/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached.client;

import java.nio.ByteBuffer;
import org.couchbase.mock.memcached.protocol.BinaryHelloCommand;
import org.couchbase.mock.memcached.protocol.CommandCode;

public class CommandBuilder {
    static int opaqueCounter = 0;
    private byte[] key = new byte[0];
    private byte[] value = new byte[0];
    private byte[] extras = new byte[0];
    private long cas = 0L;
    private int opaque = opaqueCounter++;
    private short vbucket = 0;
    private final CommandCode command;

    public CommandBuilder(CommandCode command) {
        this.command = command;
    }

    public CommandBuilder key(String key, short vbucket) {
        this.key = key.getBytes();
        this.vbucket = vbucket;
        return this;
    }

    public CommandBuilder vBucket(short vbucket) {
        this.vbucket = vbucket;
        return this;
    }

    public CommandBuilder value(String value) {
        this.value = value.getBytes();
        return this;
    }

    public CommandBuilder value(byte[] value) {
        this.value = value;
        return this;
    }

    public CommandBuilder cas(long cas) {
        this.cas = cas;
        return this;
    }

    public CommandBuilder extras(byte[] extras) {
        this.extras = extras;
        return this;
    }

    public CommandBuilder value(byte[] value, int flags) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(flags);
        bb.rewind();
        this.extras(bb.array());
        this.value(value);
        return this;
    }

    public static byte[] buildHello(String name, BinaryHelloCommand.Feature ... features) {
        CommandBuilder cBuilder = new CommandBuilder(CommandCode.HELLO);
        cBuilder.key(name, (short)0);
        ByteBuffer bb = ByteBuffer.allocate(features.length * 2);
        for (BinaryHelloCommand.Feature f : features) {
            bb.putShort((short)f.getValue());
        }
        bb.rewind();
        cBuilder.value(bb.array());
        return cBuilder.build();
    }

    public static byte[] buildStore(String key, short vbucket, String value) {
        CommandBuilder cBuilder = new CommandBuilder(CommandCode.SET);
        cBuilder.key(key, vbucket);
        cBuilder.value(value.getBytes(), 0);
        return cBuilder.build();
    }

    public byte[] build() {
        int totalLen = 24 + this.key.length + this.value.length + this.extras.length;
        byte[] ret = new byte[totalLen];
        ByteBuffer buffer = ByteBuffer.wrap(ret);
        buffer.put((byte)-128);
        buffer.put((byte)this.command.cc());
        buffer.putShort((short)this.key.length);
        buffer.put((byte)this.extras.length);
        buffer.put((byte)0);
        buffer.putShort(this.vbucket);
        buffer.putInt(totalLen - 24);
        buffer.putInt(this.opaque);
        buffer.putLong(this.cas);
        buffer.put(this.extras);
        buffer.put(this.key);
        buffer.put(this.value);
        return ret;
    }
}

