
package Paws::RedshiftData::GetStatementResult;
  use Moose;
  has Id => (is => 'ro', isa => 'Str', required => 1);
  has NextToken => (is => 'ro', isa => 'Str');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'GetStatementResult');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::RedshiftData::GetStatementResultResponse');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::RedshiftData::GetStatementResult - Arguments for method GetStatementResult on L<Paws::RedshiftData>

=head1 DESCRIPTION

This class represents the parameters used for calling the method GetStatementResult on the
L<Redshift Data API Service|Paws::RedshiftData> service. Use the attributes of this class
as arguments to method GetStatementResult.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to GetStatementResult.

=head1 SYNOPSIS

    my $redshift-data = Paws->service('RedshiftData');
    my $GetStatementResultResponse = $redshift -data->GetStatementResult(
      Id        => 'MyUUID',
      NextToken => 'MyString',    # OPTIONAL
    );

    # Results:
    my $ColumnMetadata = $GetStatementResultResponse->ColumnMetadata;
    my $NextToken      = $GetStatementResultResponse->NextToken;
    my $Records        = $GetStatementResultResponse->Records;
    my $TotalNumRows   = $GetStatementResultResponse->TotalNumRows;

    # Returns a L<Paws::RedshiftData::GetStatementResultResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/redshift-data/GetStatementResult>

=head1 ATTRIBUTES


=head2 B<REQUIRED> Id => Str

The identifier of the SQL statement whose results are to be fetched.
This value is a universally unique identifier (UUID) generated by
Amazon Redshift Data API. This identifier is returned by
C<ExecuteStatment> and C<ListStatements>.



=head2 NextToken => Str

A value that indicates the starting point for the next set of response
records in a subsequent request. If a value is returned in a response,
you can retrieve the next set of records by providing this returned
NextToken value in the next NextToken parameter and retrying the
command. If the NextToken field is empty, all response records have
been retrieved for the request.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method GetStatementResult in L<Paws::RedshiftData>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

