=head1 NAME

Pangloss::Segment::RemoveLanguage - remove language.

=head1 SYNOPSIS

  $pipe->add_segment( Pangloss::Segment::RemoveLanguage->new )

=cut

package Pangloss::Segment::RemoveLanguage;

use Pangloss::Language;

use base qw( Pipeline::Segment );

our $VERSION  = ((require Pangloss::Version), $Pangloss::VERSION)[1];
our $REVISION = (split(/ /, ' $Revision: 1.7 $ '))[2];

sub dispatch {
    my $self    = shift;
    my $request = $self->store->get('OpenFrame::Request') || return;
    my $app     = $self->store->get('Pangloss::Application') || return;
    my $view    = $self->store->get('Pangloss::Application::View');
    my $args    = $request->arguments;
    my %details = ();

    if ($args->{remove_language}) {
	my $iso_code = $args->{selected_language};

	$self->emit( "removing language $iso_code" );

	return $app->language_editor->remove( $iso_code, $view );
    }
}

1;

__END__

#------------------------------------------------------------------------------

=head1 DESCRIPTION

This class inherits its interface from C<Pipeline::Segment>.

On dispatch(), if the request has an 'remove_language' argument, attempts to
remove the language specified by 'selected_language' and return the
resulting view or error.

=head1 AUTHOR

Steve Purkis <spurkis@quiup.com>

=head1 SEE ALSO

L<Pangloss::Application::LanguageEditor>

=cut
