package Bio::MUST::Tools::Mcl;
# ABSTRACT: Scripts for processing MCL clusters
# CONTRIBUTOR: Mick VAN VLIERBERGHE <mvanvlierberghe@doct.uliege.be>
$Bio::MUST::Tools::Mcl::VERSION = '0.210170';
use strict;
use warnings;

1;

__END__

=pod

=head1 NAME

Bio::MUST::Tools::Mcl - Scripts for processing MCL clusters

=head1 VERSION

version 0.210170

=head1 DESCRIPTION

Scripts for post-processing MCL clusters produced by orthology inference
programs such as OrthoMCL L<https://github.com/stajichlab/OrthoMCL> or
OrthoFinder L<https://github.com/davidemms/OrthoFinder>.

More details can be found in Van Vlierberghe et al. (2021) Broadly sampled
orthologous groups of eukaryotic proteins for the phylogenetic study of
plastid-bearing lineages (submitted to BMC Research Notes).

=head1 AUTHOR

Denis BAURAIN <denis.baurain@uliege.be>

=head1 CONTRIBUTOR

=for stopwords Mick VAN VLIERBERGHE

Mick VAN VLIERBERGHE <mvanvlierberghe@doct.uliege.be>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by University of Liege / Unit of Eukaryotic Phylogenomics / Denis BAURAIN.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
