# Generated by default/object.tt
package Paws::SageMaker::PipelineExecution;
  use Moose;
  has CreatedBy => (is => 'ro', isa => 'Paws::SageMaker::UserContext');
  has CreationTime => (is => 'ro', isa => 'Str');
  has FailureReason => (is => 'ro', isa => 'Str');
  has LastModifiedBy => (is => 'ro', isa => 'Paws::SageMaker::UserContext');
  has LastModifiedTime => (is => 'ro', isa => 'Str');
  has PipelineArn => (is => 'ro', isa => 'Str');
  has PipelineExecutionArn => (is => 'ro', isa => 'Str');
  has PipelineExecutionDescription => (is => 'ro', isa => 'Str');
  has PipelineExecutionDisplayName => (is => 'ro', isa => 'Str');
  has PipelineExecutionStatus => (is => 'ro', isa => 'Str');
  has PipelineExperimentConfig => (is => 'ro', isa => 'Paws::SageMaker::PipelineExperimentConfig');
  has PipelineParameters => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::Parameter]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::PipelineExecution

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::PipelineExecution object:

  $service_obj->Method(Att1 => { CreatedBy => $value, ..., PipelineParameters => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::PipelineExecution object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedBy

=head1 DESCRIPTION

An execution of a pipeline.

=head1 ATTRIBUTES


=head2 CreatedBy => L<Paws::SageMaker::UserContext>




=head2 CreationTime => Str

The creation time of the pipeline execution.


=head2 FailureReason => Str

If the execution failed, a message describing why.


=head2 LastModifiedBy => L<Paws::SageMaker::UserContext>




=head2 LastModifiedTime => Str

The time that the pipeline execution was last modified.


=head2 PipelineArn => Str

The Amazon Resource Name (ARN) of the pipeline that was executed.


=head2 PipelineExecutionArn => Str

The Amazon Resource Name (ARN) of the pipeline execution.


=head2 PipelineExecutionDescription => Str

The description of the pipeline execution.


=head2 PipelineExecutionDisplayName => Str

The display name of the pipeline execution.


=head2 PipelineExecutionStatus => Str

The status of the pipeline status.


=head2 PipelineExperimentConfig => L<Paws::SageMaker::PipelineExperimentConfig>




=head2 PipelineParameters => ArrayRef[L<Paws::SageMaker::Parameter>]

Contains a list of pipeline parameters. This list can be empty.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

