#!/usr/bin/env perl

use strict;
use warnings;

use FindBin '$Bin';
use lib "$Bin/lib";

use Catalyst::Test 'App';
use File::Spec;
use Test::More tests => 4;


is ( get('/'), '<table class="pages"><tr><td class="p_prefix">Pages:</td><td class="p_main"><span class="p_current">1</span></td><td class="p_main"><a href="http://localhost/?p=2">2</a></td><td class="p_main"><a href="http://localhost/?p=3">3</a></td><td class="p_main"><a href="http://localhost/?p=4">4</a></td><td class="p_main"><a href="http://localhost/?p=5">5</a></td><td class="p_main"><a href="http://localhost/?p=6">6</a></td><td class="p_main"><a href="http://localhost/?p=7">7</a></td><td class="p_main"><a href="http://localhost/?p=8">8</a></td><td class="p_main"><a href="http://localhost/?p=9">9</a></td><td class="p_main"><a href="http://localhost/?p=10">10</a></td><td class="p_delim">...</td><td class="p_side"><a href="http://localhost/?p=99">99</a></td><td class="p_side"><a href="http://localhost/?p=100">100</a></td><td class="p_edge"><a href="http://localhost/?p=2">>></a></td><td class="p_suffix">Total: 1000</td></tr></table>', 'defaults' );

is ( get('/?rows=15&p=8'), '<table class="pages"><tr><td class="p_prefix">Pages:</td><td class="p_edge"><a href="http://localhost/?p=7&rows=15"><<</a></td><td class="p_side"><a href="http://localhost/?p=1&rows=15">1</a></td><td class="p_side"><a href="http://localhost/?p=2&rows=15">2</a></td><td class="p_delim">...</td><td class="p_main"><a href="http://localhost/?p=4&rows=15">4</a></td><td class="p_main"><a href="http://localhost/?p=5&rows=15">5</a></td><td class="p_main"><a href="http://localhost/?p=6&rows=15">6</a></td><td class="p_main"><a href="http://localhost/?p=7&rows=15">7</a></td><td class="p_main"><span class="p_current">8</span></td><td class="p_main"><a href="http://localhost/?p=9&rows=15">9</a></td><td class="p_main"><a href="http://localhost/?p=10&rows=15">10</a></td><td class="p_main"><a href="http://localhost/?p=11&rows=15">11</a></td><td class="p_main"><a href="http://localhost/?p=12&rows=15">12</a></td><td class="p_main"><a href="http://localhost/?p=13&rows=15">13</a></td><td class="p_delim">...</td><td class="p_side"><a href="http://localhost/?p=66&rows=15">66</a></td><td class="p_side"><a href="http://localhost/?p=67&rows=15">67</a></td><td class="p_edge"><a href="http://localhost/?p=9&rows=15">>></a></td><td class="p_suffix">Total: 1000</td></tr></table>', 'page,size' );

is ( get('/?delim=z&p=17'), '<table class="pages"><tr><td class="p_prefix">Pages:</td><td class="p_edge"><a href="http://localhost/?p=16&delim=z"><<</a></td><td class="p_side"><a href="http://localhost/?p=1&delim=z">1</a></td><td class="p_side"><a href="http://localhost/?p=2&delim=z">2</a></td><td class="p_delim">z</td><td class="p_main"><a href="http://localhost/?p=13&delim=z">13</a></td><td class="p_main"><a href="http://localhost/?p=14&delim=z">14</a></td><td class="p_main"><a href="http://localhost/?p=15&delim=z">15</a></td><td class="p_main"><a href="http://localhost/?p=16&delim=z">16</a></td><td class="p_main"><span class="p_current">17</span></td><td class="p_main"><a href="http://localhost/?p=18&delim=z">18</a></td><td class="p_main"><a href="http://localhost/?p=19&delim=z">19</a></td><td class="p_main"><a href="http://localhost/?p=20&delim=z">20</a></td><td class="p_main"><a href="http://localhost/?p=21&delim=z">21</a></td><td class="p_main"><a href="http://localhost/?p=22&delim=z">22</a></td><td class="p_delim">z</td><td class="p_side"><a href="http://localhost/?p=99&delim=z">99</a></td><td class="p_side"><a href="http://localhost/?p=100&delim=z">100</a></td><td class="p_edge"><a href="http://localhost/?p=18&delim=z">>></a></td><td class="p_suffix">Total: 1000</td></tr></table>', 'main,side' );

is ( get('/?delim=z&p=17&prefix=Pref&suffix=Suff'), '<table class="pages"><tr><td class="p_prefix">Pref</td><td class="p_edge"><a href="http://localhost/?p=16&suffix=Suff&delim=z&prefix=Pref"><<</a></td><td class="p_side"><a href="http://localhost/?p=1&suffix=Suff&delim=z&prefix=Pref">1</a></td><td class="p_side"><a href="http://localhost/?p=2&suffix=Suff&delim=z&prefix=Pref">2</a></td><td class="p_delim">z</td><td class="p_main"><a href="http://localhost/?p=13&suffix=Suff&delim=z&prefix=Pref">13</a></td><td class="p_main"><a href="http://localhost/?p=14&suffix=Suff&delim=z&prefix=Pref">14</a></td><td class="p_main"><a href="http://localhost/?p=15&suffix=Suff&delim=z&prefix=Pref">15</a></td><td class="p_main"><a href="http://localhost/?p=16&suffix=Suff&delim=z&prefix=Pref">16</a></td><td class="p_main"><span class="p_current">17</span></td><td class="p_main"><a href="http://localhost/?p=18&suffix=Suff&delim=z&prefix=Pref">18</a></td><td class="p_main"><a href="http://localhost/?p=19&suffix=Suff&delim=z&prefix=Pref">19</a></td><td class="p_main"><a href="http://localhost/?p=20&suffix=Suff&delim=z&prefix=Pref">20</a></td><td class="p_main"><a href="http://localhost/?p=21&suffix=Suff&delim=z&prefix=Pref">21</a></td><td class="p_main"><a href="http://localhost/?p=22&suffix=Suff&delim=z&prefix=Pref">22</a></td><td class="p_delim">z</td><td class="p_side"><a href="http://localhost/?p=99&suffix=Suff&delim=z&prefix=Pref">99</a></td><td class="p_side"><a href="http://localhost/?p=100&suffix=Suff&delim=z&prefix=Pref">100</a></td><td class="p_edge"><a href="http://localhost/?p=18&suffix=Suff&delim=z&prefix=Pref">>></a></td><td class="p_suffix">Suff</td></tr></table>', 'delim,prefix,suffix');

