use DPKG::Make;

my @filelist=('tmproot/file1.txt',
              'tmproot/file2.txt',
              'tmproot/file3.txt',
              'tmproot/file4.txt');

my %doc; my %conf; my %metadata;
$doc{'tmproot/file1.txt'}=1;
$conf{'tmproot/file2.txt'}=1;

my $pathprefix='tmproot';
my $tag='test';
my $version='0.1';
my $release='1';
my $arch='any';
print(<<END);
This script will try to build an Debian package (*.deb).
END

%metadata=(
           'vendor'=>'Laboratory for GeeksLikeMeNeedExercise Medicine',
           'summary'=>'software package for testing--not too fancy',
           'name'=>$tag,
           'copyrightname'=>'',
           'group'=>'base',
           'AutoReqProv'=>'no',
           'requires'=>[()],
	   'email'=>'harris41@msu.edu',
           'description'=>'Generated by DPKG::Make. '.
                  'This implements the '.$tag.' software package',
           'pre'=>'echo "You are installing a package built by DPKG::Make; '.
                  'DPKG::Make is available at http://www.cpan.org/."',
           );

my $buildloc='TempBuildLoc';
DPKG::Make::execute($tag,$version,$release,$arch,$buildloc,$pathprefix,
                    \@filelist,\%doc,\%conf,\%metadata);

# execution can also be done with multiple smaller steps
# (equivalent functionality)
$release=2;

DPKG::Make::dpkgsrc($tag,$version,$release,$arch,$buildloc,$pathprefix,
                    \@filelist,\%doc,\%conf,\%metadata);

my $currentdir=`pwd`; chomp($currentdir); my $invokingdir=$currentdir;
$currentdir.='/'.$buildloc;

DPKG::Make::compiledpkg($buildloc,$tag,$version,$release,$arch,
 	 	        $currentdir,$invokingdir);

DPKG::Make::cleanbuildloc($buildloc);

