# Note: this file was auto-generated by Module::Build::Compat version 0.03
use ExtUtils::MakeMaker;
use FindBin;
use File::Spec::Functions qw(catfile);

# VOS and VMS can't handle dodgy plugin names
# and VOS can't even unpack them so we create them on the
# fly and only run the tests if they're present
my %dodgy_files = (
    catfile(qw(OddTest Plugin -Dodgy.pm))   => 'OddTest::Plugin::-Dodgy',
    catfile(qw(EditorJunk Plugin #Bar.pm#)) => 'EditorJunk::Bar',
    catfile(qw(EditorJunk Plugin .#Bar.pm)) => 'EditorJunk::Bar',
);

my $core = grep { $_ eq 'PERL_CORE=1' } @ARGV;
my @path = $core ? (File::Spec->updir, File::Spec->updir, File::Spec->updir,
                   "t", "Module_Pluggable") : ($FindBin::Bin,"t");

my @files;
unless (grep { lc($^O) eq $_ } qw(vms vos)) {
    foreach my $test (keys %dodgy_files) {
        my ($file) = (catfile(@path, "lib", $test)=~/^(.*)$/);
        if (open(FH, ">$file")) {
            my $name = $dodgy_files{$test};
            print FH "package $name;\nsub new {}\n1;";
            close(FH);
            push @files, $file;
        }
    }
}


WriteMakefile
(
          'NAME'         => 'Module::Pluggable',
          'VERSION_FROM' => 'lib/Module/Pluggable.pm',
          'PREREQ_PM'    => {
                           'File::Basename' => '0',
                           'File::Spec' => '3.00',
                           'Test::More' => '0.62'
                         },
          'EXE_FILES'    => [],
		  'INSTALLDIRS'  => ((($] >= 5.008009) || ($] < 5.011)) ? 'perl' : 'site'),                                                                 
          'PL_FILES'     => {},
          'realclean'    => {FILES=> join ' ', @files},
          # In the core pods will be built by installman.
          $core ? (MAN3PODS => {}) : (),
        )
;
