######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT 11
package Geo::Location::TimeZone::L;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude 157.5 to 172.5
	"11" => {
		# Grid 11:-6 ; 2 records
		"-6" => {
			"def_z" => "Antartica/South_Pole",
			"192" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,3",
				"p" => [[157.517593383789,-82.5],[157.517593383789,-90],[157.5,-90],[157.5,-82.5],[157.517593383789,-82.5],],
			},
		},
		# Grid 11:-5 ; 2 records
		"-5" => {
			"def_z" => "Antarctica/McMurdo",
			"193" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,3",
				"p" => [[157.517593383789,-67.5],[157.517593383789,-82.5],[157.5,-82.5],[157.5,-67.5],[157.517593383789,-67.5],],
			},
		},
		# Grid 11:-4 ; 2 records
		"-4" => {
			"def_z" => "Etc/GMT+12",
			"194" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,3",
				"p" => [[157.517593383789,-52.5],[157.517593383789,-67.5],[157.5,-67.5],[157.5,-52.5],[157.517593383789,-52.5],],
			},
		},
		# Grid 11:-3 ; 2 records
		"-3" => {
			"def_z" => "Etc/GMT+12",
			"195" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,3",
				"p" => [[157.5,-37.5],[157.517593383789,-37.5],[157.517593383789,-52.5],[157.5,-52.5],[157.5,-38.4430541992188],[157.5,-37.5],],
			},
		},
		# Grid 11:-2 ; 6 records
		"-2" => {
			"def_z" => "Australia/Lord_Howe",
			"196" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,3",
				"p" => [[157.5,-22.5],[157.517593383789,-22.5],[157.517593383789,-37.5],[157.5,-37.5],[157.5,-22.5],],
			},
			"287" => {
				"z" => "Australia/Lord_Howe",
				"c" => "ESRI",
				"s" => "17,3",
				"p" => [[157.834716796875,-33.6231880187988],[164.824813842773,-33.6231880187988],[164.824813842773,-30.3648529052734],[157.832977294922,-30.3658924102783],[157.834716796875,-33.6231880187988],],
			},
			"418" => {
				"z" => "Etc/GMT+12",
				"c" => "ESRI",
				"s" => "28,1",
				"p" => [[163.358795166016,-22.5],[172.5,-22.5],[172.5,-37.5],[169.153898347667,-37.5],[172.5,-32.2509106248444],[172.5,-22.5],[160.124389648438,-22.5],[163.358795166016,-22.5],],
			},
			"436" => {
				"z" => "Pacific/Norfolk",
				"c" => "ESRI",
				"s" => "29,1",
				"p" => [[172.5,-30.7825889587402],[166.356506347656,-30.7825889587402],[166.356506347656,-27.9698371887207],[172.5,-27.9698371887207],[172.5,-30.7825889587402],],
			},
			"438" => {
				"z" => "Australia/Lord_Howe",
				"c" => "ESRI",
				"s" => "30,1",
				"p" => [[164.824813842773,-30.3648529052734],[164.824813842773,-33.6231880187988],[157.834716796875,-33.6231880187988],[157.832977294922,-30.3658924102783],[164.824813842773,-30.3648529052734],],
			},
		},
		# Grid 11:-1 ; 2 records
		"-1" => {
			"def_z1" => "166.45,-22.2666667,Pacific/Noumea",
			"def_z0" => "160.208817,-9.580777,Pacific/Guadalcanal",
			"def_z2" => "168.36,-16.69,Pacific/Efate",
			"197" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,3",
				"p" => [[157.5,-7.5],[157.5,-9.19105295509456],[157.517593383789,-9.20436096191406],[157.517593383789,-22.5],[157.5,-22.5],[157.5,-12.911111831665],[157.5,-7.5],],
			},
		},
		# Grid 11:0 ; 3 records
		"0" => {
			"def_z1" => "169.5333333,-0.8833333,Pacific/Tarawa",
			"def_z0" => "171.3833333,7.1,Pacific/Majuro",
			"def_z2" => "163.0,5.33,Pacific/Kosrae",
			"def_z3" => "171.26,7.06,Pacific/Majuro",
			"def_z4" => "166.91666,-0.533333,Pacific/Nauru",
			"198" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,3",
				"p" => [[157.5,0],[157.5,-0.0227278313049381],[157.517593383789,-0.0227520652115345],[157.517593383789,-5.72842502593994],[157.5,-5.73940746861938],[157.5,-7.5],[157.5,-7.5],[157.5,0],],
			},
			"277" => {
				"z" => "Pacific/Ponape",
				"c" => "ESRI",
				"s" => "17,2",
				"p" => [[172.5,7.5],[160.556689806945,7.5],[160.544403076172,-2.35326170921326],[172.5,-2.35571115687198],[172.5,-7.5],[157.5,-7.5],[157.5,-5.73940746861938],[157.517593383789,-5.72842502593994],[157.517593383789,-0.0227520652115345],[157.5,-0.0227278313049381],[157.5,7.5],[172.5,7.5],],
			},
		},
		# Grid 11:1 ; 2 records
		"1" => {
			"def_z1" => "166.633,19.3,Pacific/Wake",
			"def_z0" => "167.73,8.716667,Pacific/Kwajalein",
			"181" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,2",
				"p" => [[157.508239746094,12],[157.5,12],[157.5,22.5],[157.508239746094,22.5],[157.508239746094,12],],
			},
		},
		# Grid 11:2 ; 1 records
		"2" => {
			"182" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,2",
				"p" => [[157.5,37.5],[157.508239746094,37.5],[157.508239746094,22.5],[157.5,22.5],[157.5,37.5],],
			},
		},
		# Grid 11:3 ; 3 records
		"3" => {
			"def_z" => "Etc/GMT+12",
			"183" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,2",
				"p" => [[157.5,51.3887500693749],[157.508605957031,51.3920059204102],[157.508239746094,50.6927604675293],[157.508239746094,37.5],[157.5,37.5],[157.5,51.3887500693749],],
			},
			"234" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,2",
				"p" => [[172.5,51.75],[171,52.5],[172.5,52.5],[172.5,49.9972305297852],[172.5,51.75],],
			},
		},
		# Grid 11:4 ; 2 records
		"4" => {
			"def_z" => "Etc/GMT+12",
			"235" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,2",
				"p" => [[171,52.5],[170,53],[172.5,54.4880989615914],[172.5,52.5],[171,52.5],],
			},
		},
		# Grid 11:5 ; 2 records
		"5" => {
			"def_z" => "Etc/GMT+12",
			"176" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,1",
				"p" => [[157.5,67.5],[157.5,82.5],[157.507064819336,82.5],[157.507064819336,77.64599609375],[158.181930541992,76.9711227416992],[158.434997558594,76.6055755615234],[158.51936340332,76.1556625366211],[158.463119506836,75.9588241577148],[158.125686645508,75.7901077270508],[157.5,75.6040947624532],[157.5,74.6653366088867],[157.5,67.5],],
			},
		},
		# Grid 11:6 ; 1 records
		"6" => {
			"177" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,1",
				"p" => [[157.5,82.5],[157.5,90],[157.507064819336,90],[157.507064819336,82.5],[158.51936340332,82.5],[157.5,82.5],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
