# Generated by default/object.tt
package Paws::Macie2::Severity;
  use Moose;
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Score => (is => 'ro', isa => 'Int', request_name => 'score', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::Severity

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::Severity object:

  $service_obj->Method(Att1 => { Description => $value, ..., Score => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::Severity object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Provides the numerical and qualitative representations of a finding's
severity.

=head1 ATTRIBUTES


=head2 Description => Str

The qualitative representation of the finding's severity, ranging from
Low (least severe) to High (most severe).


=head2 Score => Int

The numerical representation of the finding's severity, ranging from 1
(least severe) to 3 (most severe).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

