# Generated by default/object.tt
package Paws::DynamoDB::BatchStatementResponse;
  use Moose;
  has Error => (is => 'ro', isa => 'Paws::DynamoDB::BatchStatementError');
  has Item => (is => 'ro', isa => 'Paws::DynamoDB::AttributeMap');
  has TableName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DynamoDB::BatchStatementResponse

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DynamoDB::BatchStatementResponse object:

  $service_obj->Method(Att1 => { Error => $value, ..., TableName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DynamoDB::BatchStatementResponse object:

  $result = $service_obj->Method(...);
  $result->Att1->Error

=head1 DESCRIPTION

A PartiQL batch statement response..

=head1 ATTRIBUTES


=head2 Error => L<Paws::DynamoDB::BatchStatementError>

The error associated with a failed PartiQL batch statement.


=head2 Item => L<Paws::DynamoDB::AttributeMap>

A DynamoDB item associated with a BatchStatementResponse


=head2 TableName => Str

The table name associated with a failed PartiQL batch statement.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DynamoDB>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

