######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT 5
package Geo::Location::TimeZone::E;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude 67.5 to 82.5
	"5" => {
		# Grid 5:-6 ; 2 records
		"-6" => {
			"def_z" => "Antartica/South_Pole",
			"525" => {
				"z" => "Etc/GMT+4",
				"c" => "ESRI",
				"s" => "35,5",
				"p" => [[67.5380401611328,-82.5],[67.5116958618164,-82.5],[67.5116958618164,-90],[67.5,-90],[67.5,-82.5],[67.5380401611328,-82.5],],
			},
		},
		# Grid 5:-5 ; 2 records
		"-5" => {
			"def_z" => "Antartica/Davis",
			"526" => {
				"z" => "Etc/GMT+4",
				"c" => "ESRI",
				"s" => "35,5",
				"p" => [[67.5380401611328,-67.5],[67.5116934073199,-67.5],[67.5116958618164,-79.6482238769531],[67.5116958618164,-82.5],[67.5,-82.5],[67.5,-67.5],[67.5380401611328,-67.5],],
			},
		},
		# Grid 5:-4 ; 1 records
		"-4" => {
			"527" => {
				"z" => "Etc/GMT+4",
				"c" => "ESRI",
				"s" => "35,5",
				"p" => [[67.5380401611328,-52.5],[67.5116903766342,-52.5],[67.5116934073199,-67.5],[67.5,-67.5],[67.5,-52.5],[67.5380401611328,-52.5],],
			},
		},
		# Grid 5:-3 ; 1 records
		"-3" => {
			"528" => {
				"z" => "Etc/GMT+4",
				"c" => "ESRI",
				"s" => "35,5",
				"p" => [[67.5380401611328,-37.5],[67.5116882324219,-37.5],[67.5116882324219,-41.8874893188477],[67.5116903766342,-52.5],[67.5,-52.5],[67.5,-37.5],[67.5380401611328,-37.5],],
			},
		},
		# Grid 5:-2 ; 1 records
		"-2" => {
			"529" => {
				"z" => "Etc/GMT+4",
				"c" => "ESRI",
				"s" => "35,5",
				"p" => [[67.5380401611328,-22.5],[67.5116882324219,-22.5],[67.5116882324219,-37.5],[67.5,-37.5],[67.5,-22.5],[67.5380401611328,-22.5],],
			},
		},
		# Grid 5:-1 ; 2 records
		"-1" => {
			"def_z" => "Etc/GMT+6",
			"530" => {
				"z" => "Etc/GMT+4",
				"c" => "ESRI",
				"s" => "35,5",
				"p" => [[67.5380401611328,-7.5],[67.5116882324219,-7.5],[67.5116882324219,-22.5],[67.5,-22.5],[67.5,-7.5],[67.5380401611328,-7.5],],
			},
		},
		# Grid 5:0 ; 3 records
		"0" => {
			"def_z" => "Asia/Calcutta",
			"373" => {
				"z" => "Etc/GMT+6",
				"c" => "ESRI",
				"s" => "21,5",
				"p" => [[70.2521514892578,-6.97027254104614],[73.3476943969727,-6.97027254104614],[73.3483874623468,-7.5],[70.2521514892578,-7.5],[70.2521514892578,-6.97027254104614],],
			},
			"531" => {
				"z" => "Etc/GMT+4",
				"c" => "ESRI",
				"s" => "35,5",
				"p" => [[67.5380401611328,7.5],[67.5116882324219,7.5],[67.5116882324219,-7.5],[67.5,-7.5],[67.5,7.5],[67.5380401611328,7.5],],
			},
		},
		# Grid 5:1 ; 3 records
		"1" => {
			"def_z" => "Asia/Calcutta",
			"532" => {
				"z" => "Etc/GMT+4",
				"c" => "ESRI",
				"s" => "35,5",
				"p" => [[67.5380401611328,22.5],[67.5116882324219,22.5],[67.5116882324219,7.5],[67.5,7.5],[67.5,22.5],[67.5380401611328,22.5],],
			},
			"596" => {
				"z" => "Asia/Calcutta",
				"c" => "ESRI",
				"s" => "38,3",
				"p" => [[74.1465454101562,12.1522245407104],[74.1465454101562,7.82511425018311],[67.5116882324219,7.82490730285645],[67.5116882324219,12.1522245407104],[74.1465454101562,12.1522245407104],],
			},
		},
		# Grid 5:2 ; 7 records
		"2" => {
			"def_z" => "Asia/Dili",
			"11" => {
				"z" => "Asia/Katmandu",
				"c" => "ESRI",
				"s" => "3,1",
				"p" => [[82.5,26.8674964904785],[82.5,27.6842664932109],[82.4347076416016,27.6755523681641],[82.0663986206055,27.9141540527344],[81.9777679443359,27.9172172546387],[81.8802642822266,27.8572196960449],[81.4802703857422,28.0799980163574],[81.4219207763672,28.1663856506348],[81.3199920654297,28.129997253418],[81.3121948242188,28.1933288574219],[81.1935882568359,28.3666648864746],[81.0188751220703,28.4041633605957],[81.0069427490234,28.4430503845215],[80.9385833740234,28.441104888916],[80.8924865722656,28.5063858032227],[80.7983245849609,28.5238876342773],[80.6624908447266,28.6327743530273],[80.5849914550781,28.6536064147949],[80.5772094726562,28.6855506896973],[80.5055541992188,28.6583290100098],[80.5086059570312,28.5669403076172],[80.4402618408203,28.6288833618164],[80.3577575683594,28.6294403076172],[80.24609375,28.7508316040039],[80.0558166503906,28.836109161377],[80.0599822998047,28.9316635131836],[80.1296997070312,28.993049621582],[80.1466522216797,29.1083297729492],[80.2569427490234,29.144718170166],[80.2399749755859,29.2147178649902],[80.2877655029297,29.2055511474609],[80.3069305419922,29.3105545043945],[80.2758178710938,29.3224983215332],[80.2363739013672,29.4252738952637],[80.4069366455078,29.5963859558105],[80.3769226074219,29.7486038208008],[80.5397033691406,29.8461074829102],[80.598876953125,29.9552726745605],[80.74609375,30.0213851928711],[80.8727569580078,30.1388854980469],[80.8585968017578,30.1747169494629],[80.8933258056641,30.2111053466797],[80.9363708496094,30.1813850402832],[81.0253601074219,30.2043533325195],[81.1097106933594,30.0247192382812],[81.2236022949219,30.0102767944336],[81.3019256591797,30.0836067199707],[81.2908172607422,30.1305503845215],[81.3777618408203,30.1666641235352],[81.4210968017578,30.3852729797363],[81.5419311523438,30.3305511474609],[81.5577545166016,30.3819389343262],[81.63720703125,30.4244384765625],[81.8030395507812,30.3636093139648],[82.1005401611328,30.3422203063965],[82.1072082519531,30.230827331543],[82.1785888671875,30.1905517578125],[82.1502685546875,30.1255531311035],[82.1777648925781,30.0636100769043],[82.2310943603516,30.0752754211426],[82.5,29.9661989381317],[82.5,26.3477745056152],[82.5,26.8674964904785],],
			},
			"123" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[82.5,29.9661989381317],[82.2310943603516,30.0752754211426],[82.1777648925781,30.0636100769043],[82.1502685546875,30.1255531311035],[82.1785888671875,30.1905517578125],[82.1072082519531,30.230827331543],[82.1005401611328,30.3422203063965],[81.8030395507812,30.3636093139648],[81.63720703125,30.4244384765625],[81.5577545166016,30.3819389343262],[81.5419311523438,30.3305511474609],[81.4210968017578,30.3852729797363],[81.3777618408203,30.1666641235352],[81.2908172607422,30.1305503845215],[81.3019256591797,30.0836067199707],[81.2236022949219,30.0102767944336],[81.1097106933594,30.0247192382812],[81.0253601074219,30.2043533325195],[80.9988708496094,30.2619438171387],[80.8038635253906,30.3266639709473],[80.7519378662109,30.3949966430664],[80.60693359375,30.4747161865234],[80.5388793945312,30.4644393920898],[80.3219299316406,30.5647201538086],[80.2070007324219,30.5755157470703],[80.2277679443359,30.621940612793],[80.1874847412109,30.6758270263672],[80.2502746582031,30.7399940490723],[80.1783142089844,30.7994422912598],[80.0941467285156,30.7866630554199],[80.0419311523438,30.8469429016113],[79.9498138427734,30.884895324707],[79.879150390625,30.9591598510742],[79.7488708496094,30.9897155761719],[79.5994262695312,30.9355506896973],[79.494140625,31.0241661071777],[79.4224853515625,31.0274963378906],[79.3932495117188,31.1010665893555],[79.3149871826172,31.1330528259277],[79.2866516113281,31.2233276367188],[79.2402648925781,31.2441596984863],[79.2174835205078,31.3408317565918],[79.0924835205078,31.4374961853027],[79.0186004638672,31.4113845825195],[79.0055541992188,31.325553894043],[78.9419250488281,31.3599967956543],[78.8776550292969,31.2916259765625],[78.7705383300781,31.3049964904785],[78.7927551269531,31.4433288574219],[78.7127685546875,31.4983291625977],[78.8438720703125,31.6041641235352],[78.7905426025391,31.6747169494629],[78.7424774169922,31.6849937438965],[78.6924743652344,31.7741661071777],[78.7450714111328,31.9103622436523],[78.7711029052734,31.9811058044434],[78.6805419921875,32.035270690918],[78.5447082519531,32.2094345092773],[78.4759368896484,32.2430419921875],[78.4783172607422,32.3499984741211],[78.44970703125,32.3869400024414],[78.4772033691406,32.4247131347656],[78.397216796875,32.5311050415039],[78.4205322265625,32.5661010742188],[78.6385955810547,32.5777740478516],[78.7044372558594,32.631103515625],[78.7605438232422,32.6355514526367],[78.7802734375,32.478874206543],[78.9710998535156,32.350830078125],[79.0991516113281,32.3763809204102],[79.1316528320312,32.4749908447266],[79.253173828125,32.515998840332],[79.3138732910156,32.4966583251953],[79.4572143554688,32.6024932861328],[79.5144348144531,32.6722183227539],[79.5302734375,32.7541656494141],[79.4708251953125,32.7938842773438],[79.4502716064453,32.882209777832],[79.3560943603516,32.9649963378906],[79.4063720703125,33.1616592407227],[79.1838684082031,33.2258224487305],[79.1035919189453,33.2197113037109],[79.0913696289062,33.2749938964844],[78.9963684082031,33.3149948120117],[78.9365081787109,33.4079971313477],[78.9158172607422,33.6294326782227],[79.0408172607422,33.6394348144531],[79.0194396972656,33.7544403076172],[78.9494171142578,33.8322143554688],[78.9088745117188,33.9702682495117],[78.9752655029297,34.0172119140625],[79.4291534423828,34.0216598510742],[79.5247039794922,34.118049621582],[79.5116577148438,34.1902694702148],[79.5780487060547,34.2086029052734],[79.5391540527344,34.4299926757812],[79.7227630615234,34.4205474853516],[79.7636108398438,34.4549942016602],[79.7247009277344,34.5299911499023],[79.8438720703125,34.5744400024414],[79.8874969482422,34.6627655029297],[80.0713806152344,34.6694412231445],[80.1024780273438,34.7747116088867],[80.20166015625,34.8938827514648],[80.1902618408203,35.087646484375],[80.2980346679688,35.2074966430664],[80.2894287109375,35.3399887084961],[80.3866577148438,35.4252700805664],[80.3838806152344,35.5111083984375],[80.2977600097656,35.5033264160156],[80.2741088867188,35.5275268554688],[80.2066497802734,35.5619354248047],[80.1477661132812,35.4572143554688],[80.0574798583984,35.4077682495117],[79.9641571044922,35.5958251953125],[79.9191436767578,35.6174926757812],[79.8588714599609,35.5661010742188],[79.8130340576172,35.6294326782227],[79.6935882568359,35.6508255004883],[79.6344299316406,35.759162902832],[79.6588745117188,35.8191604614258],[79.5811004638672,35.8697128295898],[79.4619293212891,35.8580474853516],[79.4380340576172,35.9605484008789],[79.3283233642578,35.9863815307617],[78.9344177246094,35.8924942016602],[78.7419281005859,35.9202728271484],[78.6255340576172,35.8166656494141],[78.2991485595703,35.7019348144531],[78.1722106933594,35.6194381713867],[78.1369323730469,35.543327331543],[77.9724884033203,35.5741653442383],[77.9246978759766,35.4897155761719],[77.8239288330078,35.5013275146484],[77.7010955810547,35.4611053466797],[77.4313659667969,35.4716567993164],[77.3080291748047,35.5347213745117],[77.1874847412109,35.5280456542969],[77.0755462646484,35.5877685546875],[76.9144287109375,35.597770690918],[76.8641510009766,35.6488800048828],[76.7780456542969,35.6552658081055],[76.7122039794922,35.7149963378906],[76.5897064208984,35.7569427490234],[76.5641479492188,35.9127655029297],[76.4216461181641,35.8336029052734],[76.1769256591797,35.8144378662109],[76.1238708496094,35.9777679443359],[75.9727630615234,36.0116577148438],[75.9260864257812,36.0772094726562],[75.9230346679688,36.1235961914062],[75.9938659667969,36.1597213745117],[75.9935913085938,36.2083358764648],[76.0416564941406,36.2375106811523],[75.9908142089844,36.3144454956055],[76.0049896240234,36.4586029052734],[75.8552551269531,36.6671752929688],[75.63916015625,36.763542175293],[75.5463714599609,36.7696304321289],[75.5230407714844,36.7290649414062],[75.4544372558594,36.7304382324219],[75.397216796875,36.9140548706055],[75.1444396972656,36.999870300293],[74.959716796875,36.9801177978516],[74.9016571044922,36.9109268188477],[74.8174896240234,37.0217666625977],[74.7394256591797,37.0203704833984],[74.6908111572266,37.0625915527344],[74.5654296875,37.0278167724609],[74.4005432128906,37.1389617919922],[74.397216796875,37.1784133911133],[74.4794311523438,37.1792526245117],[74.5297088623047,37.2417755126953],[74.6510925292969,37.2345733642578],[74.7510986328125,37.3037567138672],[74.8110961914062,37.2204132080078],[74.9157409667969,37.2373275756836],[74.9580383300781,37.2818374633789],[75.0966491699219,37.3218536376953],[75.1110992431641,37.3835296630859],[75.1874847412109,37.4065856933594],[75.0452875596697,37.5],[82.5,37.5],[82.5,27.8827743530273],[82.5,29.9661989381317],],
			},
			"360" => {
				"z" => "Etc/GMT+6",
				"c" => "ESRI",
				"s" => "21,2",
				"p" => [[82.5,37.5],[75.0452875596697,37.5],[75.1874847412109,37.4065856933594],[75.1110992431641,37.3835296630859],[75.0966491699219,37.3218536376953],[74.9580383300781,37.2818374633789],[74.9157409667969,37.2373275756836],[74.832763671875,37.3254470825195],[74.6842651367188,37.3997421264648],[74.5422058105469,37.3817977905273],[74.3638763427734,37.4284591674805],[74.2399749755859,37.4070434570312],[74.2374877929688,37.361198425293],[74.1972045898438,37.3389663696289],[73.7385864257812,37.2216491699219],[73.6199798583984,37.2624816894531],[73.6494293212891,37.3041534423828],[73.7688751220703,37.3411254882812],[73.7759857177734,37.4342956542969],[73.4563751220703,37.4761047363281],[73.3724822998047,37.4469223022461],[73.3072052001953,37.4627532958984],[73.1505432128906,37.4004898071289],[73.0691528320312,37.3140716552734],[72.7935943603516,37.2262344360352],[72.6585083007812,37.0212020874023],[72.3063507080078,36.9781036376953],[71.8427581787109,36.6921005249023],[71.6952514648438,36.6718444824219],[71.6100616455078,36.7003784179688],[71.5546875,36.7606811523438],[71.4569396972656,36.9447326660156],[71.4294281005859,37.0758285522461],[71.4469299316406,37.2072296142578],[71.4902648925781,37.2836303710938],[71.4794311523438,37.410026550293],[71.5140991210938,37.4677276611328],[71.5075368247159,37.5],[69.4313610390776,37.5],[69.3802642822266,37.4511032104492],[69.4111022949219,37.2408294677734],[69.4505462646484,37.2252655029297],[69.3885955810547,37.1585998535156],[69.2466430664062,37.0941543579102],[69.1252593994141,37.1630477905273],[68.9997100830078,37.3077697753906],[68.8877716064453,37.3386001586914],[68.91943359375,37.2755508422852],[68.8380432128906,37.3269424438477],[68.806640625,37.3180541992188],[68.8216552734375,37.2449951171875],[68.6641540527344,37.2749938964844],[68.6238708496094,37.2005462646484],[68.4122009277344,37.1480484008789],[68.3974914550781,37.0991592407227],[68.2947082519531,37.1083297729492],[68.2749938964844,37.0122146606445],[68.1871948242188,37.0205459594727],[68.0283203125,36.9238815307617],[67.8855438232422,37.0613784790039],[67.7822113037109,37.0960998535156],[67.7798767089844,37.1858215332031],[67.8380432128906,37.2619400024414],[67.8174896240234,37.4460983276367],[67.8362853278875,37.5],[76.3933258056641,37.5],[82.5,37.5],],
			},
			"533" => {
				"z" => "Etc/GMT+4",
				"c" => "ESRI",
				"s" => "35,5",
				"p" => [[67.5,25.2594413757324],[67.5,23.9751287866651],[67.5005493164062,23.9749946594238],[67.5058288574219,23.9213829040527],[67.5380401611328,23.9381294250488],[67.5,23.9091657236755],[67.5,23.8845002544088],[67.5116882324219,23.8769416809082],[67.5116882324219,22.5],[67.5,22.5],[67.5,25.0344429016113],[67.5,25.2594413757324],],
			},
			"580" => {
				"z" => "Asia/Bahrain",
				"c" => "ESRI",
				"s" => "37,3",
				"p" => [[76.66748046875,22.5],[67.5116882324219,22.5],[67.5116882324219,23.8769416809082],[67.5,23.8845002544088],[67.5,23.9091657236755],[67.5380401611328,23.9381294250488],[67.5058288574219,23.9213829040527],[67.5005493164062,23.9749946594238],[67.5,23.9751287866651],[67.5,31.2508945801717],[67.7919311523438,31.3411064147949],[67.7730407714844,31.4086074829102],[67.6677551269531,31.3999977111816],[67.6152648925781,31.4277725219727],[67.5755462646484,31.5319404602051],[67.73193359375,31.5291633605957],[67.8819274902344,31.6380500793457],[67.9805450439453,31.6358299255371],[68.0716552734375,31.6952743530273],[68.1660919189453,31.8330535888672],[68.272216796875,31.7716636657715],[68.5313720703125,31.7269401550293],[68.5716552734375,31.7652740478516],[68.4371948242188,31.7866630554199],[68.5194396972656,31.8249969482422],[68.7072143554688,31.7811088562012],[68.7280426025391,31.7041625976562],[68.8330535888672,31.6038856506348],[69.0194396972656,31.6505508422852],[69.0997161865234,31.7066612243652],[69.2243957519531,31.8712921142578],[69.3282470703125,31.9403648376465],[69.2719268798828,32.1452713012695],[69.2913665771484,32.317497253418],[69.2480316162109,32.4438781738281],[69.2874908447266,32.5263824462891],[69.3777618408203,32.5683288574219],[69.4583282470703,32.6705474853516],[69.3949890136719,32.7738800048828],[69.5127716064453,32.8694381713867],[69.4908142089844,33.0038833618164],[69.5808258056641,33.0869369506836],[69.7008209228516,33.0777740478516],[69.7913665771484,33.1269378662109],[69.8810882568359,33.0899887084961],[70.0288696289062,33.1358261108398],[70.0677642822266,33.2049942016602],[70.1449890136719,33.2024917602539],[70.3269348144531,33.3319396972656],[70.2861022949219,33.4227676391602],[70.1680450439453,33.5208282470703],[70.1966400146484,33.6408309936523],[70.1513824462891,33.6655426025391],[70.1374969482422,33.7324905395508],[69.9855346679688,33.7530517578125],[69.869140625,33.9299926757812],[69.9063720703125,34.035270690918],[70.0027770996094,34.0527725219727],[70.4913635253906,33.9430465698242],[70.8910980224609,33.9663848876953],[70.9055480957031,34.0133285522461],[70.9810943603516,34.0088882446289],[71.0772094726562,34.0522155761719],[71.0772094726562,34.1127700805664],[71.1355438232422,34.1660995483398],[71.1183166503906,34.2602767944336],[71.1588745117188,34.3483276367188],[71.0005493164062,34.4630508422852],[70.9874877929688,34.5511016845703],[71.0885925292969,34.5594329833984],[71.0958251953125,34.6766586303711],[71.2255401611328,34.7444381713867],[71.3091430664062,34.8836059570312],[71.4989013671875,34.9663467407227],[71.5380401611328,35.0197143554688],[71.5355377197266,35.0866546630859],[71.6638793945312,35.1955413818359],[71.5485992431641,35.3011016845703],[71.6494293212891,35.4249954223633],[71.6019287109375,35.5005493164062],[71.6166534423828,35.5552673339844],[71.5088806152344,35.6208267211914],[71.5452575683594,35.7111053466797],[71.4908142089844,35.7566604614258],[71.4399719238281,35.8708267211914],[71.38720703125,35.8969421386719],[71.3849945068359,35.9419326782227],[71.1870574951172,36.0421905517578],[71.3388977050781,36.2049179077148],[71.4125213623047,36.2204284667969],[71.5072479248047,36.3153610229492],[71.5789031982422,36.3317260742188],[71.5630645751953,36.3722686767578],[71.6330718994141,36.4655532836914],[71.808349609375,36.4036331176758],[71.7958374023438,36.4916458129883],[71.9044342041016,36.5072174072266],[72.07470703125,36.5891418457031],[72.0791625976562,36.6316223144531],[72.181640625,36.6496887207031],[72.175537109375,36.711311340332],[72.4741516113281,36.7623977661133],[72.556640625,36.8212661743164],[73.6683044433594,36.9096374511719],[73.8522033691406,36.8927230834961],[74.0383148193359,36.8146820068359],[74.12109375,36.8385848999023],[74.1516571044922,36.9038772583008],[74.2519378662109,36.899169921875],[74.4199829101562,37.0014343261719],[74.4888763427734,37.0103378295898],[74.5530395507812,36.9617233276367],[74.5654296875,37.0278167724609],[74.6908111572266,37.0625915527344],[74.7394256591797,37.0203704833984],[74.8174896240234,37.0217666625977],[74.9016571044922,36.9109268188477],[74.959716796875,36.9801177978516],[75.1444396972656,36.999870300293],[75.397216796875,36.9140548706055],[75.4544372558594,36.7304382324219],[75.5230407714844,36.7290649414062],[75.5463714599609,36.7696304321289],[75.63916015625,36.763542175293],[75.8552551269531,36.6671752929688],[76.0049896240234,36.4586029052734],[75.9908142089844,36.3144454956055],[76.0416564941406,36.2375106811523],[75.9935913085938,36.2083358764648],[75.9938659667969,36.1597213745117],[75.9230346679688,36.1235961914062],[75.9260864257812,36.0772094726562],[75.9727630615234,36.0116577148438],[76.1238708496094,35.9777679443359],[76.1769256591797,35.8144378662109],[76.4216461181641,35.8336029052734],[76.5641479492188,35.9127655029297],[76.5897064208984,35.7569427490234],[76.7122039794922,35.7149963378906],[76.7780456542969,35.6552658081055],[76.8641510009766,35.6488800048828],[76.9144287109375,35.597770690918],[77.0755462646484,35.5877685546875],[77.1874847412109,35.5280456542969],[77.3080291748047,35.5347213745117],[77.4313659667969,35.4716567993164],[77.7010955810547,35.4611053466797],[77.8239288330078,35.5013275146484],[77.04248046875,35.0991592407227],[77.0608062744141,35.0147171020508],[76.9641571044922,34.940544128418],[76.9169311523438,34.6813812255859],[76.8699798583984,34.6588821411133],[76.8013763427734,34.6722183227539],[76.7272033691406,34.7438812255859],[76.5630340576172,34.7316589355469],[76.4702606201172,34.7699890136719],[76.2935943603516,34.7002716064453],[76.2291564941406,34.6094360351562],[76.16748046875,34.5863800048828],[75.988037109375,34.6269378662109],[75.8055419921875,34.5072174072266],[75.661376953125,34.5008316040039],[75.3924865722656,34.5547103881836],[75.2430419921875,34.6260986328125],[74.6927490234375,34.693603515625],[74.38916015625,34.7819366455078],[73.9491424560547,34.6544342041016],[73.9463653564453,34.565544128418],[73.8819274902344,34.5219345092773],[73.8705291748047,34.4583282470703],[73.7963714599609,34.3855514526367],[73.8480377197266,34.318603515625],[73.9733123779297,34.3027725219727],[74.0177612304688,34.2180480957031],[74.01416015625,34.1755523681641],[73.9122009277344,34.1152725219727],[73.9133148193359,34.068603515625],[73.9788665771484,34.0113830566406],[74.2444305419922,34.019157409668],[74.2958221435547,33.9774856567383],[74.2358093261719,33.884162902832],[74.0502624511719,33.8316650390625],[73.9947052001953,33.7555541992188],[74,33.6541595458984],[74.1544342041016,33.5613784790039],[74.1824798583984,33.5105514526367],[74.1258087158203,33.3433227539062],[74.0241546630859,33.2763824462891],[74.0133209228516,33.1988754272461],[74.1733093261719,33.047492980957],[74.3341522216797,33.0005493164062],[74.3638763427734,32.8694381713867],[74.3296661376953,32.8154296875],[74.3716430664062,32.7711029052734],[74.4544372558594,32.7930526733398],[74.5316619873047,32.7502746582031],[74.6324768066406,32.7705459594727],[74.70166015625,32.8469390869141],[74.6535949707031,32.5933227539062],[74.7038726806641,32.4855499267578],[74.7444305419922,32.4649963378906],[74.8616485595703,32.4847183227539],[74.9385833740234,32.4488754272461],[75.0488739013672,32.4783248901367],[75.3193054199219,32.3446502685547],[75.3285827636719,32.2927589416504],[75.3912963867188,32.2415809631348],[75.3288269042969,32.2090682983398],[75.3068618774414,32.1339111328125],[75.2565307617188,32.0928688049316],[75.2241668701172,32.1167602539062],[75.1940231323242,32.074031829834],[75.0407409667969,32.0414505004883],[74.9034729003906,32.0532913208008],[74.8331069946289,31.9627094268799],[74.6053237915039,31.8771190643311],[74.5492095947266,31.7438507080078],[74.4887313842773,31.7215900421143],[74.6103286743164,31.5543193817139],[74.5984191894531,31.4894104003906],[74.6551132202148,31.4279708862305],[74.5483703613281,31.3544406890869],[74.5389862060547,31.1187305450439],[74.5572814941406,31.0760498046875],[74.6237411499023,31.123929977417],[74.6843185424805,31.1120204925537],[74.6945877075195,31.0539608001709],[74.5611190795898,31.0455894470215],[74.5549926757812,30.9950523376465],[74.4322052001953,30.9427719116211],[74.400634765625,30.8841438293457],[74.3169403076172,30.8894386291504],[74.1611022949219,30.6616630554199],[74.0488739013672,30.5991630554199],[74.0502624511719,30.5149993896484],[73.99609375,30.504997253418],[73.9338073730469,30.4162445068359],[73.8724975585938,30.3900985717773],[73.8585968017578,30.3602752685547],[73.9344177246094,30.3141632080078],[73.9644317626953,30.2347183227539],[73.9334030151367,30.1360015869141],[73.3974914550781,29.9427719116211],[73.2652740478516,29.553050994873],[73.0863800048828,29.2458267211914],[72.9888763427734,29.1419410705566],[72.9483184814453,29.035831451416],[72.3897094726562,28.7849960327148],[72.2922058105469,28.6799964904785],[72.2066497802734,28.4024963378906],[71.9199829101562,28.1208305358887],[71.8969421386719,27.9619407653809],[71.6269226074219,27.876106262207],[71.2258148193359,27.8458290100098],[70.8666534423828,27.7069396972656],[70.7377624511719,27.7313842773438],[70.6622009277344,27.8633308410645],[70.6636047363281,27.9283294677734],[70.5144348144531,28.0391654968262],[70.3683166503906,28.0208320617676],[70.2035369873047,27.8855819702148],[70.1197052001953,27.8161087036133],[70.0310974121094,27.5905532836914],[69.8674774169922,27.4086074829102],[69.5833282470703,27.1783294677734],[69.5097198486328,26.9922180175781],[69.4860992431641,26.8063850402832],[69.5127716064453,26.7466621398926],[69.7227630615234,26.6652717590332],[69.8008117675781,26.5941619873047],[70.0713806152344,26.5961074829102],[70.1719207763672,26.5527763366699],[70.1738739013672,26.2444381713867],[70.0927581787109,26.0799980163574],[70.1172027587891,25.9188842773438],[70.2927551269531,25.7013854980469],[70.3861083984375,25.6747169494629],[70.6063690185547,25.7141609191895],[70.6663818359375,25.6983299255371],[70.6774749755859,25.4016609191895],[70.7533264160156,25.2738876342773],[70.8796997070312,25.1561050415039],[70.9421997070312,24.9355506896973],[71.0774230957031,24.6804618835449],[70.9927520751953,24.6361083984375],[70.9797058105469,24.5605545043945],[71.0055541992188,24.5408325195312],[71.006103515625,24.4580497741699],[71.0819396972656,24.4486045837402],[71.1058197021484,24.4163856506348],[71.0291595458984,24.3636093139648],[70.9280395507812,24.3616638183594],[70.8644256591797,24.3169403076172],[70.8858184814453,24.2744407653809],[70.7908172607422,24.2394371032715],[70.6505432128906,24.241382598877],[70.5844268798828,24.2783317565918],[70.5677642822266,24.3713836669922],[70.6008148193359,24.4149971008301],[70.5674896240234,24.4363822937012],[70.1200866699219,24.3090324401855],[70.0707092285156,24.1979179382324],[70.0147094726562,24.1697158813477],[69.7236022949219,24.1711082458496],[69.5986022949219,24.2813873291016],[69.3108062744141,24.2966651916504],[69.1894226074219,24.2580528259277],[69.0802764892578,24.2972183227539],[68.988037109375,24.2569427490234],[68.9269256591797,24.325553894043],[68.8580322265625,24.2416610717773],[68.82470703125,24.3327751159668],[68.7830505371094,24.3327751159668],[68.7452545166016,24.3163871765137],[68.7472076416016,23.9699935913086],[68.3905487060547,23.9674949645996],[68.3763732910156,23.9441604614258],[68.3619232177734,23.9738845825195],[68.3305511474609,23.9147186279297],[68.2905426025391,23.9444389343262],[68.2819366455078,23.8977737426758],[68.2144317626953,23.8683280944824],[68.1977996826172,23.7666854858398],[68.2138824462891,23.680549621582],[68.2802734375,23.6666641235352],[68.2305450439453,23.6436080932617],[68.2010955810547,23.6641616821289],[68.1402740478516,23.6047172546387],[68.3213806152344,23.5808296203613],[68.4474792480469,23.7269401550293],[68.5880432128906,23.7669410705566],[68.6283111572266,23.8261070251465],[68.8183288574219,23.8763847351074],[68.6688690185547,23.8097190856934],[68.6363830566406,23.7572212219238],[68.4669342041016,23.6530494689941],[68.4855346679688,23.6099967956543],[68.4233093261719,23.6272201538086],[68.4029312133789,23.5184211730957],[68.3915939331055,23.4550971984863],[68.4369201660156,23.426383972168],[68.4627685546875,23.4394378662109],[68.4763793945312,23.4002723693848],[68.5380401611328,23.4180526733398],[68.5110473632812,23.3698825836182],[68.5391540527344,23.2783317565918],[68.5688781738281,23.25],[68.6205291748047,23.2677764892578],[68.5935974121094,23.2288818359375],[68.6666564941406,23.142219543457],[69.1434707641602,22.8713989257812],[69.2093734741211,22.7301654815674],[69.1351852416992,22.5503959655762],[69.0870789913654,22.5],[73.3016510009766,22.5],[76.66748046875,22.5],],
			},
			"9" => {
				"z" => "Asia/Kabul",
				"c" => "ESRI",
				"s" => "2,1",
				"p" => [[67.5,35.6352691650391],[67.5,37.2732683853364],[67.5574798583984,37.2155456542969],[67.6433258056641,37.2472152709961],[67.7552642822266,37.2205429077148],[67.7798767089844,37.1858215332031],[67.7822113037109,37.0960998535156],[67.8855438232422,37.0613784790039],[68.0283203125,36.9238815307617],[68.1871948242188,37.0205459594727],[68.2749938964844,37.0122146606445],[68.2947082519531,37.1083297729492],[68.3974914550781,37.0991592407227],[68.4122009277344,37.1480484008789],[68.6238708496094,37.2005462646484],[68.6641540527344,37.2749938964844],[68.8216552734375,37.2449951171875],[68.806640625,37.3180541992188],[68.8380432128906,37.3269424438477],[68.91943359375,37.2755508422852],[68.8877716064453,37.3386001586914],[68.9997100830078,37.3077697753906],[69.1252593994141,37.1630477905273],[69.2466430664062,37.0941543579102],[69.3885955810547,37.1585998535156],[69.4505462646484,37.2252655029297],[69.4111022949219,37.2408294677734],[69.3802642822266,37.4511032104492],[69.4313610390776,37.5],[71.5075368247159,37.5],[71.5140991210938,37.4677276611328],[71.4794311523438,37.410026550293],[71.4902648925781,37.2836303710938],[71.4469299316406,37.2072296142578],[71.4294281005859,37.0758285522461],[71.4569396972656,36.9447326660156],[71.5546875,36.7606811523438],[71.6100616455078,36.7003784179688],[71.6952514648438,36.6718444824219],[71.8427581787109,36.6921005249023],[72.3063507080078,36.9781036376953],[72.6585083007812,37.0212020874023],[72.7935943603516,37.2262344360352],[73.0691528320312,37.3140716552734],[73.1505432128906,37.4004898071289],[73.3072052001953,37.4627532958984],[73.3724822998047,37.4469223022461],[73.4563751220703,37.4761047363281],[73.7759857177734,37.4342956542969],[73.7688751220703,37.3411254882812],[73.6494293212891,37.3041534423828],[73.6199798583984,37.2624816894531],[73.7385864257812,37.2216491699219],[74.1972045898438,37.3389663696289],[74.2374877929688,37.361198425293],[74.2399749755859,37.4070434570312],[74.3638763427734,37.4284591674805],[74.5422058105469,37.3817977905273],[74.6842651367188,37.3997421264648],[74.832763671875,37.3254470825195],[74.9157409667969,37.2373275756836],[74.8110961914062,37.2204132080078],[74.7510986328125,37.3037567138672],[74.6510925292969,37.2345733642578],[74.5297088623047,37.2417755126953],[74.4794311523438,37.1792526245117],[74.397216796875,37.1784133911133],[74.4005432128906,37.1389617919922],[74.5654296875,37.0278167724609],[74.5530395507812,36.9617233276367],[74.4888763427734,37.0103378295898],[74.4199829101562,37.0014343261719],[74.2519378662109,36.899169921875],[74.1516571044922,36.9038772583008],[74.12109375,36.8385848999023],[74.0383148193359,36.8146820068359],[73.8522033691406,36.8927230834961],[73.6683044433594,36.9096374511719],[72.556640625,36.8212661743164],[72.4741516113281,36.7623977661133],[72.175537109375,36.711311340332],[72.181640625,36.6496887207031],[72.0791625976562,36.6316223144531],[72.07470703125,36.5891418457031],[71.9044342041016,36.5072174072266],[71.7958374023438,36.4916458129883],[71.808349609375,36.4036331176758],[71.6330718994141,36.4655532836914],[71.5630645751953,36.3722686767578],[71.5789031982422,36.3317260742188],[71.5072479248047,36.3153610229492],[71.4125213623047,36.2204284667969],[71.3388977050781,36.2049179077148],[71.1870574951172,36.0421905517578],[71.3849945068359,35.9419326782227],[71.38720703125,35.8969421386719],[71.4399719238281,35.8708267211914],[71.4908142089844,35.7566604614258],[71.5452575683594,35.7111053466797],[71.5088806152344,35.6208267211914],[71.6166534423828,35.5552673339844],[71.6019287109375,35.5005493164062],[71.6494293212891,35.4249954223633],[71.5485992431641,35.3011016845703],[71.6638793945312,35.1955413818359],[71.5355377197266,35.0866546630859],[71.5380401611328,35.0197143554688],[71.4989013671875,34.9663467407227],[71.3091430664062,34.8836059570312],[71.2255401611328,34.7444381713867],[71.0958251953125,34.6766586303711],[71.0885925292969,34.5594329833984],[70.9874877929688,34.5511016845703],[71.0005493164062,34.4630508422852],[71.1588745117188,34.3483276367188],[71.1183166503906,34.2602767944336],[71.1355438232422,34.1660995483398],[71.0772094726562,34.1127700805664],[71.0772094726562,34.0522155761719],[70.9810943603516,34.0088882446289],[70.9055480957031,34.0133285522461],[70.8910980224609,33.9663848876953],[70.4913635253906,33.9430465698242],[70.0027770996094,34.0527725219727],[69.9063720703125,34.035270690918],[69.869140625,33.9299926757812],[69.9855346679688,33.7530517578125],[70.1374969482422,33.7324905395508],[70.1513824462891,33.6655426025391],[70.1966400146484,33.6408309936523],[70.1680450439453,33.5208282470703],[70.2861022949219,33.4227676391602],[70.3269348144531,33.3319396972656],[70.1449890136719,33.2024917602539],[70.0677642822266,33.2049942016602],[70.0288696289062,33.1358261108398],[69.8810882568359,33.0899887084961],[69.7913665771484,33.1269378662109],[69.7008209228516,33.0777740478516],[69.5808258056641,33.0869369506836],[69.4908142089844,33.0038833618164],[69.5127716064453,32.8694381713867],[69.3949890136719,32.7738800048828],[69.4583282470703,32.6705474853516],[69.3777618408203,32.5683288574219],[69.2874908447266,32.5263824462891],[69.2480316162109,32.4438781738281],[69.2913665771484,32.317497253418],[69.2719268798828,32.1452713012695],[69.3282470703125,31.9403648376465],[69.2243957519531,31.8712921142578],[69.0997161865234,31.7066612243652],[69.0194396972656,31.6505508422852],[68.8330535888672,31.6038856506348],[68.7280426025391,31.7041625976562],[68.7072143554688,31.7811088562012],[68.5194396972656,31.8249969482422],[68.4371948242188,31.7866630554199],[68.5716552734375,31.7652740478516],[68.5313720703125,31.7269401550293],[68.272216796875,31.7716636657715],[68.1660919189453,31.8330535888672],[68.0716552734375,31.6952743530273],[67.9805450439453,31.6358299255371],[67.8819274902344,31.6380500793457],[67.73193359375,31.5291633605957],[67.5755462646484,31.5319404602051],[67.6152648925781,31.4277725219727],[67.6677551269531,31.3999977111816],[67.7730407714844,31.4086074829102],[67.7919311523438,31.3411064147949],[67.5,31.2508945801717],[67.5,29.3886070251465],[67.5,35.6352691650391],],
			},
		},
		# Grid 5:3 ; 4 records
		"3" => {
			"def_z1" => "74.3666667,41.8666667,Asia/Oral",
			"def_z0" => "68.3666667,40.1333333,Asia/Tashkent",
			"def_z7" => "71.4405556,47.7397222,Asia/Aqtau",
			"def_z2" => "74.6002778,42.8730556,Asia/Bishkek",
			"def_z3" => "76.95,43.25,Asia/Almaty",
			"def_z6" => "72.4230556,49.8994444,Asia/Aqtobe",
			"def_z4" => "69.25,41.3166667,Asia/Tashkent",
			"def_z5" => "68.7738889,38.56,Asia/Dushanbe",
			"10" => {
				"z" => "Asia/Kabul",
				"c" => "ESRI",
				"s" => "2,1",
				"p" => [[69.869140625,37.5],[67.5,37.5],[69.4313610390776,37.5],[69.5158233642578,37.5808258056641],[69.8069305419922,37.5830535888672],[69.8991546630859,37.6149978637695],[69.9586029052734,37.5649948120117],[70.0624542236328,37.5413360595703],[70.1619262695312,37.53955078125],[70.2155456542969,37.6163787841797],[70.2536010742188,37.6157455444336],[70.2858123779297,37.6970596313477],[70.2469329833984,37.8125457763672],[70.1655426025391,37.8717193603516],[70.161376953125,37.9333724975586],[70.2474517822266,37.9316940307617],[70.2472076416016,37.9639434814453],[70.4641571044922,38.1111907958984],[70.5844268798828,38.2781677246094],[70.5977630615234,38.3415069580078],[70.6855316162109,38.3748550415039],[70.6722106933594,38.4140319824219],[70.8738708496094,38.4529418945312],[70.9299774169922,38.4304428100586],[70.9672088623047,38.4721145629883],[71.0497131347656,38.4029388427734],[71.1455383300781,38.3857345581055],[71.3663787841797,38.2362747192383],[71.2527770996094,37.9220352172852],[71.334716796875,37.8878707885742],[71.5153656005859,37.9484558105469],[71.5919342041016,37.9026184082031],[71.5885925292969,37.8156509399414],[71.5287780761719,37.7639007568359],[71.4957122802734,37.5581512451172],[71.5075368247159,37.5],[71.1355438232422,37.5],[69.869140625,37.5],],
			},
			"124" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[82.5,45.8713760375977],[82.5,37.5],[75.0452875596697,37.5],[74.9494171142578,37.5629806518555],[74.9027709960938,37.6471557617188],[74.9910888671875,37.7838287353516],[74.9027709960938,37.8471603393555],[74.9366455078125,37.8888320922852],[74.9083251953125,37.9104919433594],[74.9136047363281,38.0177154541016],[74.814697265625,38.0788269042969],[74.79443359375,38.306037902832],[74.8647003173828,38.3888244628906],[74.8566436767578,38.4704818725586],[74.7885894775391,38.5274276733398],[74.7183227539062,38.5290985107422],[74.3547058105469,38.6743774414062],[74.1341552734375,38.6732635498047],[74.1108093261719,38.6215972900391],[74.0605316162109,38.6046524047852],[74.0688781738281,38.5365982055664],[73.9366455078125,38.5410461425781],[73.8177642822266,38.6077117919922],[73.8021850585938,38.6498336791992],[73.7577667236328,38.7302093505859],[73.7624969482422,38.8007659912109],[73.7049865722656,38.8807601928711],[73.8533172607422,38.9690933227539],[73.7216491699219,39.0824356079102],[73.6172027587891,39.2321472167969],[73.6699829101562,39.3440933227539],[73.6556854248047,39.4548263549805],[73.8480377197266,39.4749298095703],[73.9024810791016,39.5696563720703],[73.9561004638672,39.5977096557617],[73.9108123779297,39.7252044677734],[73.8444366455078,39.7557678222656],[73.8449859619141,39.8054885864258],[73.9944305419922,40.0460433959961],[74.1980285644531,40.1138229370117],[74.3621978759766,40.0996551513672],[74.7305450439453,40.3396530151367],[74.8844299316406,40.3277130126953],[74.8102569580078,40.4197998046875],[74.8602600097656,40.5193862915039],[75.0588684082031,40.4477157592773],[75.161376953125,40.47021484375],[75.2255401611328,40.4468841552734],[75.5780487060547,40.6479949951172],[75.6227569580078,40.5979919433594],[75.6455383300781,40.4866027832031],[75.6966400146484,40.444938659668],[75.661376953125,40.3982772827148],[75.6972045898438,40.2991104125977],[75.9288635253906,40.3054962158203],[75.9780426025391,40.3632736206055],[76.0680541992188,40.3957748413086],[76.1941375732422,40.3779907226562],[76.2774810791016,40.4543838500977],[76.3385925292969,40.3485488891602],[76.4869232177734,40.4310531616211],[76.5530395507812,40.5441055297852],[76.6394348144531,40.6085510253906],[76.6497192382812,40.7449417114258],[76.7935943603516,40.8624420166016],[76.7819366455078,40.9407730102539],[76.8738708496094,41.0141067504883],[77.0583190917969,41.0491104125977],[77.1380462646484,41.0160522460938],[77.3774719238281,41.0279998779297],[77.5435943603516,40.9866104125977],[77.6847076416016,41.0018920898438],[77.8547058105469,41.0693969726562],[78.0808258056641,41.0407867431641],[78.2462310791016,41.1651306152344],[78.3799743652344,41.2838363647461],[78.3755340576172,41.3788299560547],[78.5310974121094,41.4638366699219],[78.6399841308594,41.4830017089844],[78.6955261230469,41.5430068969727],[79.2074890136719,41.7282791137695],[79.3094177246094,41.7913360595703],[79.4319305419922,41.7821655273438],[79.6549835205078,41.8821716308594],[79.7785949707031,41.8871765136719],[79.8794250488281,42.0163497924805],[80.2513885498047,42.0424575805664],[80.2833251953125,42.0796813964844],[80.2340240478516,42.1962203979492],[80.2810974121094,42.2121734619141],[80.2938690185547,42.2521820068359],[80.2383117675781,42.3632888793945],[80.2172088623047,42.4505081176758],[80.2424774169922,42.4905090332031],[80.1822052001953,42.5680160522461],[80.1719207763672,42.6605072021484],[80.2606506347656,42.8194046020508],[80.5785980224609,42.8910751342773],[80.5613708496094,42.9263534545898],[80.4444274902344,42.9546813964844],[80.3766479492188,43.0252380371094],[80.6463775634766,43.1413497924805],[80.7435913085938,43.1077423095703],[80.814697265625,43.1399612426758],[80.7691497802734,43.2888565063477],[80.6605377197266,43.3288497924805],[80.7385864257812,43.4719009399414],[80.5537109375,43.8132247924805],[80.4388732910156,43.9921951293945],[80.4313659667969,44.0530242919922],[80.3627624511719,44.125244140625],[80.3999938964844,44.2641372680664],[80.348876953125,44.4502487182617],[80.4072113037109,44.6021957397461],[80.3749847412109,44.6560745239258],[80.5166625976562,44.7071990966797],[80.5208282470703,44.7324752807617],[80.26220703125,44.8244247436523],[80.0016632080078,44.7977600097656],[79.8758087158203,44.8655319213867],[79.87109375,44.9049758911133],[80.1213684082031,45.039421081543],[80.3916625976562,45.0491485595703],[80.4691467285156,45.1110916137695],[81.0544281005859,45.1660842895508],[81.6883087158203,45.3508148193359],[81.7977600097656,45.3058090209961],[81.8158111572266,45.2005310058594],[81.9480285644531,45.1574783325195],[82.2969360351562,45.2377548217773],[82.4816589355469,45.1274719238281],[82.5,45.126344450152],[82.5,45.4642155015413],[82.3621978759766,45.4955291748047],[82.3149261474609,45.544792175293],[82.5,45.8822009242162],[82.5,48.3644638061523],[82.5,45.8713760375977],],
			},
			"374" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,1",
				"p" => [[82.5,51.0024948120117],[82.5,50.7215574594359],[82.4988708496094,50.7210998535156],[82.4427490234375,50.7580490112305],[82.3563690185547,50.7597198486328],[82.1502685546875,50.7105484008789],[82.0111083984375,50.7713775634766],[81.8288726806641,50.7683258056641],[81.7827606201172,50.793327331543],[81.7258148193359,50.7474899291992],[81.5953979492188,50.735725402832],[81.4374847412109,50.7644424438477],[81.4899749755859,50.8411026000977],[81.4219207763672,50.9277725219727],[81.4246978759766,50.9663848876953],[81.0763854980469,50.9478073120117],[81.18359375,51.1960983276367],[81.0408325195312,51.1814346313477],[80.9402923583984,51.2212142944336],[80.9322357177734,51.2839889526367],[80.8722534179688,51.259033203125],[80.6878356933594,51.3147201538086],[80.6334381103516,51.2147598266602],[80.438720703125,51.1979675292969],[80.4306793212891,51.1190872192383],[80.4867858886719,51.0587768554688],[80.4623565673828,50.9640808105469],[80.1990509033203,50.8883590698242],[80.1721038818359,50.8291931152344],[80.0654449462891,50.860595703125],[80.0351715087891,50.8333740234375],[80.1096038818359,50.7594757080078],[79.9938659667969,50.8130493164062],[79.536376953125,51.4499969482422],[78.9230346679688,52.176383972168],[78.6235861790828,52.5],[82.5,52.5],[82.5,49.079719543457],[82.5,51.0024948120117],],
			},
		},
		# Grid 5:4 ; 2 records
		"4" => {
			"def_z" => "Etc/GMT+7",
			"362" => {
				"z1" => "73.4,55.0,Asia/Omsk",
				"z0" => "71.2833333,56.3666667,Asia/Kamchatka",
				"c" => "ESRI",
				"s" => "21,2",
				"p" => [[78.3755340576172,52.5],[67.5,52.5],[67.5,54.8585464296573],[67.5813751220703,54.8544387817383],[67.7663879394531,54.8919372558594],[67.8322143554688,54.9633255004883],[67.9297027587891,54.9833297729492],[68.034423828125,54.9502716064453],[68.2052612304688,54.9661026000977],[68.2594299316406,55.0488815307617],[68.3308258056641,55.0805511474609],[68.2444305419922,55.1047134399414],[68.19970703125,55.1783294677734],[68.3044281005859,55.2052688598633],[68.6258087158203,55.2019348144531],[68.6388854980469,55.2555541992188],[68.7049865722656,55.2866592407227],[68.7313690185547,55.3705444335938],[68.8799743652344,55.3427658081055],[68.9333190917969,55.2861099243164],[69.0024871826172,55.2874984741211],[69.0010986328125,55.3536071777344],[68.9394226074219,55.3702697753906],[68.9233093261719,55.4241638183594],[68.9524841308594,55.444709777832],[69.1683197021484,55.4005432128906],[69.1855316162109,55.343879699707],[69.2327575683594,55.3324966430664],[69.3513793945312,55.3944396972656],[69.6727600097656,55.3544387817383],[69.8460998535156,55.2949981689453],[69.9491424560547,55.2041625976562],[70.0558166503906,55.2077713012695],[70.2388763427734,55.1388854980469],[70.2880401611328,55.1872100830078],[70.3983306884766,55.2091598510742],[70.4699859619141,55.2966613769531],[70.5066528320312,55.3377685546875],[70.4660949707031,55.4049911499023],[70.4877624511719,55.4385986328125],[70.5491485595703,55.4913787841797],[70.6966400146484,55.5063858032227],[70.7636108398438,55.597770690918],[70.5469360351562,55.6749954223633],[70.5836029052734,55.7961044311523],[70.7855377197266,55.8330535888672],[70.7591552734375,55.8633270263672],[70.5913696289062,55.8361053466797],[70.4752655029297,55.8522186279297],[70.4741516113281,55.8916625976562],[70.8041534423828,55.9202728271484],[70.9163818359375,56.1105499267578],[70.8174896240234,56.1733245849609],[70.8402709960938,56.2569427490234],[70.772216796875,56.2547149658203],[70.7627716064453,56.2866592407227],[70.93359375,56.3469390869141],[70.9413604736328,56.4116592407227],[70.8624877929688,56.4638824462891],[70.7847137451172,56.436653137207],[70.7597198486328,56.4611053466797],[70.8577575683594,56.5030517578125],[70.9541625976562,56.4911041259766],[71.0908203125,56.555549621582],[71.119140625,56.6455459594727],[71.0330505371094,56.6922149658203],[71.0558166503906,56.7102737426758],[71.1666564941406,56.6713790893555],[71.348876953125,56.6691589355469],[71.3938751220703,56.6847152709961],[71.3969421386719,56.7330474853516],[71.5408172607422,56.7191543579102],[71.5855407714844,56.7944412231445],[71.675537109375,56.8263854980469],[71.6585998535156,56.9147109985352],[71.613037109375,56.9569396972656],[71.3708190917969,57.063606262207],[71.2338714599609,57.2002716064453],[71.0902709960938,57.2205429077148],[71.1477661132812,57.2513885498047],[71.0924835205078,57.2899932861328],[71.1024780273438,57.3408279418945],[70.8116455078125,57.3280487060547],[70.7541656494141,57.2774887084961],[70.7819366455078,57.1991577148438],[70.6944274902344,57.1930465698242],[70.6097106933594,57.1991577148438],[70.6560974121094,57.26416015625],[70.5172119140625,57.2869415283203],[70.4249877929688,57.38916015625],[70.6874847412109,57.5144424438477],[70.6910858154297,57.5666656494141],[70.6672058105469,57.5927658081055],[70.5772094726562,57.5786056518555],[70.5744323730469,57.7091598510742],[70.4988708496094,57.7074966430664],[70.4838714599609,57.7677688598633],[70.425537109375,57.7663879394531],[70.4417114257812,57.8384246826172],[70.3786468505859,57.9171295166016],[70.4369201660156,57.9336013793945],[70.8730316162109,58.5424957275391],[71.0788726806641,58.5286026000977],[71.1199798583984,58.4488754272461],[71.3038635253906,58.3974914550781],[71.2472076416016,58.3561019897461],[71.2191467285156,58.1469421386719],[71.2488708496094,58.1219329833984],[71.2385864257812,58.0711059570312],[71.9888763427734,58.1247100830078],[72.0705413818359,58.0941543579102],[72.1216430664062,58.0230484008789],[72.8722076416016,58.006103515625],[72.9691467285156,58.060546875],[72.9385833740234,58.0874938964844],[73.0844268798828,58.1491622924805],[74.2063751220703,58.1336059570312],[74.4549865722656,58.2586059570312],[74.6205291748047,58.2936096191406],[74.6266479492188,58.3391571044922],[74.7999877929688,58.4269409179688],[74.8760833740234,58.4272155761719],[74.8916625976562,58.4777679443359],[75.1052551269531,58.5811080932617],[75.3555450439453,58.4727630615234],[75.0541534423828,58.3447113037109],[75.2397003173828,58.2199859619141],[75.0663757324219,58.1183242797852],[75.5644226074219,57.9338760375977],[75.582763671875,57.6463851928711],[75.7124938964844,57.63916015625],[75.8585968017578,57.3991622924805],[75.9663848876953,57.4141540527344],[76.1088714599609,57.2502746582031],[76.1919250488281,56.9727630615234],[76.2519378662109,56.918327331543],[76.2894287109375,56.726936340332],[76.1491546630859,56.6308212280273],[76.0460968017578,56.6216583251953],[76.0152740478516,56.5516586303711],[75.8652648925781,56.4997177124023],[75.8441467285156,56.4499969482422],[75.8949890136719,56.4427642822266],[75.9358062744141,56.4797134399414],[76.006103515625,56.4538803100586],[76.0574798583984,56.4827651977539],[76.1419372558594,56.4511032104492],[76.0780487060547,56.4147109985352],[76.1166534423828,56.3141555786133],[76.2997131347656,56.2363815307617],[76.3188781738281,56.185546875],[76.1630401611328,56.1494369506836],[76.1508178710938,56.180549621582],[75.9944305419922,56.1783294677734],[75.9563751220703,56.1274871826172],[75.7488708496094,56.1411056518555],[75.7005462646484,56.067497253418],[75.5430450439453,56.0472183227539],[75.5058288574219,55.9961013793945],[75.3121948242188,55.8916625976562],[75.2974853515625,55.8447113037109],[75.3733062744141,55.8133239746094],[75.3702545166016,55.7666625976562],[75.0819396972656,55.7502746582031],[75.1369323730469,55.7233200073242],[75.1288604736328,55.6994323730469],[75.2377624511719,55.6599884033203],[75.1313629150391,55.598876953125],[75.1972045898438,55.5597152709961],[75.3058166503906,55.5691604614258],[75.3222198486328,55.5402755737305],[75.3249969482422,55.5072174072266],[75.1713714599609,55.4527740478516],[75.1685943603516,55.4211044311523],[75.0913696289062,55.382209777832],[75.2694396972656,55.2541656494141],[75.2480316162109,55.1374969482422],[75.4002685546875,55.0280456542969],[75.3402709960938,54.9141540527344],[75.5408172607422,54.9019317626953],[75.4916534423828,54.8613815307617],[75.5133209228516,54.8233261108398],[75.6572113037109,54.8099899291992],[75.709716796875,54.6863784790039],[75.8088684082031,54.6930465698242],[75.7897033691406,54.6694412231445],[75.8349914550781,54.6047134399414],[75.8060913085938,54.565544128418],[75.6777648925781,54.5341644287109],[75.6913604736328,54.1102752685547],[76.2072143554688,54.259162902832],[76.1855316162109,54.2955474853516],[76.2388763427734,54.35888671875],[76.4877624511719,54.325553894043],[76.6569366455078,54.3677673339844],[76.7066497802734,54.4472122192383],[76.9235992431641,54.4755477905273],[76.9249877929688,54.4374923706055],[76.7788696289062,54.394157409668],[76.8558197021484,54.35888671875],[76.864990234375,54.3180541992188],[76.7213745117188,54.1533203125],[76.3933258056641,54.1636047363281],[76.5216522216797,53.9938812255859],[77.5238800048828,53.5063858032227],[77.9213714599609,53.2588882446289],[78.6235861790828,52.5],[80.2833251953125,52.5],[78.3755340576172,52.5],],
			},
		},
		# Grid 5:5 ; 3 records
		"5" => {
			"335" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,1",
				"p" => [[67.5,69.3593521118164],[67.5,69.6050261878686],[67.613037109375,69.5916595458984],[67.7861022949219,69.5166625976562],[67.9674835205078,69.4841461181641],[68.0380401611328,69.4888763427734],[68.0072174072266,69.5186004638672],[68.1016540527344,69.5466461181641],[68.1094207763672,69.3888854980469],[68.0213775634766,69.3435974121094],[68.0474853515625,69.2813720703125],[68.4733123779297,68.9724884033203],[68.7849884033203,68.9108123779297],[69.0216522216797,68.9641571044922],[69.0324859619141,68.9419250488281],[69.2202606201172,68.9572143554688],[68.9438629150391,68.8980407714844],[69.1083221435547,68.8724822998047],[69.0952606201172,68.8333282470703],[69.0088806152344,68.7999877929688],[68.8977661132812,68.6074829101562],[68.5630340576172,68.3694305419922],[68.5716552734375,68.3377685546875],[68.6499938964844,68.3121948242188],[68.5641479492188,68.3105316162109],[68.4363708496094,68.2249908447266],[68.2833251953125,68.1849822998047],[68.270263671875,68.2391510009766],[68.1852569580078,68.2360992431641],[68.2008209228516,68.2947082519531],[68.2605438232422,68.334716796875],[68.159423828125,68.411376953125],[67.7830505371094,68.4774780273438],[67.7061004638672,68.5105438232422],[67.8058166503906,68.5008239746094],[67.772216796875,68.5177612304688],[67.5,68.6239179150499],[67.5,82.5],[67.536750793457,82.5],[67.536750793457,77.0095367431641],[68.5008239746094,76.9563751220703],[68.4727630615234,76.925537109375],[68.8094177246094,76.8663787841797],[68.7544403076172,76.8222198486328],[68.9313659667969,76.7827606201172],[68.8936004638672,76.7574920654297],[68.9005432128906,76.7277679443359],[69.0302734375,76.7080383300781],[68.8563690185547,76.6566467285156],[68.7847137451172,76.5877685546875],[68.925537109375,76.5588684082031],[68.5797119140625,76.4330444335938],[68.4010925292969,76.4060974121094],[68.4394226074219,76.3897094726562],[68.3333282470703,76.3358154296875],[68.16943359375,76.3180541992188],[68.3133087158203,76.2833251953125],[67.536750793457,76.1917572021484],[67.536750793457,71.4098739624023],[67.5,71.4012342149176],[67.5,70.8352661132812],[67.5,69.3593521118164],],
			},
			"355" => {
				"z" => "Etc/GMT+6",
				"c" => "ESRI",
				"s" => "21,1",
				"p" => [[82.5,74.9676941451173],[82.2766876220703,74.9565277099609],[82.2766876220703,73.9233474731445],[67.536750793457,73.9547729492188],[67.536750793457,76.1917572021484],[68.3133087158203,76.2833251953125],[68.16943359375,76.3180541992188],[68.3333282470703,76.3358154296875],[68.4394226074219,76.3897094726562],[68.4010925292969,76.4060974121094],[68.5797119140625,76.4330444335938],[68.925537109375,76.5588684082031],[68.7847137451172,76.5877685546875],[68.8563690185547,76.6566467285156],[69.0302734375,76.7080383300781],[68.9005432128906,76.7277679443359],[68.8936004638672,76.7574920654297],[68.9313659667969,76.7827606201172],[68.7544403076172,76.8222198486328],[68.8094177246094,76.8663787841797],[68.4727630615234,76.925537109375],[68.5008239746094,76.9563751220703],[67.536750793457,77.0095367431641],[67.536750793457,81.6645278930664],[69.5494788182558,82.5],[82.3080062866211,82.5],[82.3080062866211,76.459342956543],[82.5,76.4254615511158],[82.5,74.9676941451173],],
			},
			"376" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,1",
				"p" => [[82.5,72.3169403076172],[82.5,67.5],[82.3528768890424,67.5],[82.3513793945312,67.5010986328125],[82.3966522216797,67.5349884033203],[82.1141510009766,67.5994262695312],[82.0410919189453,67.6566467285156],[82.119140625,67.6874847412109],[82.0805511474609,67.6885833740234],[82.1055450439453,67.7288665771484],[81.9030456542969,67.7777709960938],[81.7244262695312,67.9241485595703],[81.7619323730469,67.9524841308594],[81.877197265625,67.9316558837891],[81.9888763427734,67.9633178710938],[82.3744201660156,67.9491424560547],[82.3961029052734,68.0591430664062],[82.35693359375,68.0958251953125],[82.3927612304688,68.1774749755859],[82.5,68.1741227469784],[82.5,68.5613144951015],[82.4561004638672,68.5783233642578],[82.5,68.5953562115012],[82.5,68.9791591360619],[82.4972076416016,68.9877624511719],[82.3163757324219,69.0538635253906],[82.5,69.1069588029557],[82.5,69.110073653745],[82.4613800048828,69.1244201660156],[82.4638824462891,69.1605377197266],[81.8133087158203,69.2005462646484],[81.7597198486328,69.2524871826172],[81.9360961914062,69.3466491699219],[81.7810974121094,69.4313659667969],[81.6724853515625,69.4483184814453],[81.6230316162109,69.4152679443359],[81.6138763427734,69.3283233642578],[81.6402740478516,69.3113708496094],[81.5824890136719,69.2758178710938],[81.4441375732422,69.2544403076172],[81.3358154296875,69.2880401611328],[80.9559631347656,69.2066650390625],[80.7931060791016,69.2639465332031],[80.7666931152344,69.3050384521484],[80.1459808349609,69.3632507324219],[79.8591461181641,69.3460998535156],[79.877197265625,69.3727569580078],[79.8227691650391,69.3944396972656],[79.8280487060547,69.4224853515625],[79.7138824462891,69.4324798583984],[79.7408142089844,69.4483184814453],[79.63916015625,69.4858093261719],[79.5958251953125,69.5883178710938],[79.5008239746094,69.6047058105469],[79.5372009277344,69.6308135986328],[79.4916534423828,69.6363830566406],[79.5058288574219,69.6535949707031],[79.0041656494141,69.6969299316406],[79.1397094726562,69.7430419921875],[79.0663757324219,69.7472076416016],[79.0633087158203,69.7866516113281],[78.9758148193359,69.8116455078125],[79.0188751220703,69.8349914550781],[78.8752593994141,69.8816528320312],[78.9658203125,69.8802642822266],[79.1874847412109,69.9641571044922],[79.1197052001953,70.0066528320312],[79.2185974121094,70.0116577148438],[79.1785888671875,70.0349884033203],[79.1944274902344,70.0516510009766],[79.3494262695312,70.0449829101562],[79.3280487060547,70.1488800048828],[79.4988708496094,70.1105346679688],[79.6294250488281,70.2210998535156],[79.7088775634766,70.2385864257812],[79.7383117675781,70.2488708496094],[79.7035980224609,70.2699890136719],[79.7247009277344,70.2841491699219],[79.8574829101562,70.272216796875],[80.1140441894531,70.3609619140625],[80.0820922851562,70.3937377929688],[80.1860046386719,70.3918151855469],[80.1768341064453,70.4365539550781],[80.5717620849609,70.4618835449219],[80.6256713867188,70.4216766357422],[80.6915588378906,70.4232025146484],[80.7073974609375,70.3910064697266],[80.7621765136719,70.3944396972656],[80.7276916503906,70.4107666015625],[80.7910766601562,70.4150543212891],[80.798583984375,70.4411926269531],[80.6701354980469,70.4462280273438],[80.6064910888672,70.5009460449219],[80.6656951904297,70.5138702392578],[80.6601104736328,70.5740661621094],[80.7207183837891,70.5944976806641],[80.7562866210938,70.6658630371094],[80.59228515625,70.7167510986328],[80.6901702880859,70.8018646240234],[80.5664672851562,70.8547668457031],[80.550048828125,71.0575714111328],[79.9663848876953,71.1310882568359],[79.5083312988281,71.2933197021484],[79.2291564941406,71.3174896240234],[79.1746978759766,71.3460998535156],[79.1402740478516,71.4216461181641],[79.3585968017578,71.494140625],[79.3908233642578,71.5438690185547],[79.3313751220703,71.5977630615234],[79.3802642822266,71.6163787841797],[79.8697052001953,71.6002655029297],[80.1354064941406,71.6745300292969],[80.0663146972656,71.7694244384766],[80.1273956298828,71.77490234375],[80.0350494384766,71.8314666748047],[80.1732940673828,71.8693084716797],[80.2746429443359,71.8514862060547],[80.2718963623047,71.8784790039062],[80.3487854003906,71.8860015869141],[80.2483825683594,71.9100646972656],[80.2309265136719,71.9419250488281],[79.9100189208984,71.9844818115234],[79.8672027587891,72.0224914550781],[79.6969299316406,72.0591430664062],[79.4227600097656,72.0355377197266],[79.3827514648438,72.0621948242188],[79.0944366455078,72.0705413818359],[79.0919342041016,72.1016540527344],[79.0186004638672,72.1199798583984],[78.9108123779297,72.1147003173828],[78.9116516113281,72.1444396972656],[78.7711029052734,72.1702575683594],[78.8080291748047,72.1833190917969],[78.6769256591797,72.1794281005859],[78.5972137451172,72.209716796875],[78.6780395507812,72.2216491699219],[78.6591491699219,72.2611083984375],[78.4463653564453,72.3597106933594],[78.4547119140625,72.3644256591797],[78.5001525878906,72.3773345947266],[78.4727020263672,72.6475219726562],[78.1752700805664,72.8979949951172],[78.2065811157227,73.0232315063477],[78.5353240966797,73.3050079345703],[79.490234375,73.6650543212891],[81.0869674682617,73.7589797973633],[82.2766876220703,73.9233474731445],[82.2766876220703,74.9565277099609],[82.5,74.9676941451173],[82.5,76.4254615511158],[82.3080062866211,76.459342956543],[82.3080062866211,82.5],[82.5,82.5],[82.5,72.3169403076172],],
			},
		},
		# Grid 5:6 ; 4 records
		"6" => {
			"def_z" => "Etc/GMT+6",
			"336" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,1",
				"p" => [[68.1852569580078,82.5],[67.5,82.5],[67.5,82.8900979370742],[67.536750793457,82.8902816772461],[67.536750793457,82.5],[68.6499938964844,82.5],[68.1852569580078,82.5],],
			},
			"377" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,1",
				"p" => [[75.0663757324219,82.5],[82.3080062866211,82.5],[82.3080062866211,83.378532409668],[82.5,83.3787299497128],[82.5,82.5],[76.2894287109375,82.5],[75.0663757324219,82.5],],
			},
			"515" => {
				"z" => "Etc/GMT+4",
				"c" => "ESRI",
				"s" => "35,1",
				"p" => [[67.536750793457,90],[67.536750793457,82.8902816772461],[67.5,82.8900979370742],[67.5,90],[67.536750793457,90],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
