# Generated by default/object.tt
package Paws::MediaTailor::SlateSource;
  use Moose;
  has SourceLocationName => (is => 'ro', isa => 'Str');
  has VodSourceName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaTailor::SlateSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaTailor::SlateSource object:

  $service_obj->Method(Att1 => { SourceLocationName => $value, ..., VodSourceName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaTailor::SlateSource object:

  $result = $service_obj->Method(...);
  $result->Att1->SourceLocationName

=head1 DESCRIPTION

Slate VOD source configuration.

=head1 ATTRIBUTES


=head2 SourceLocationName => Str

The name of the source location where the slate VOD source is stored.


=head2 VodSourceName => Str

The slate VOD source name. The VOD source must already exist in a
source location before it can be used for slate.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaTailor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

