# Generated by default/object.tt
package Paws::CloudFront::RealtimeLogConfig;
  use Moose;
  has ARN => (is => 'ro', isa => 'Str', required => 1);
  has EndPoints => (is => 'ro', isa => 'ArrayRef[Paws::CloudFront::EndPoint]', required => 1);
  has Fields => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'Field', traits => ['NameInRequest'], required => 1);
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has SamplingRate => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::RealtimeLogConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::RealtimeLogConfig object:

  $service_obj->Method(Att1 => { ARN => $value, ..., SamplingRate => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::RealtimeLogConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->ARN

=head1 DESCRIPTION

A real-time log configuration.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ARN => Str

The Amazon Resource Name (ARN) of this real-time log configuration.


=head2 B<REQUIRED> EndPoints => ArrayRef[L<Paws::CloudFront::EndPoint>]

Contains information about the Amazon Kinesis data stream where you are
sending real-time log data for this real-time log configuration.


=head2 B<REQUIRED> Fields => ArrayRef[Str|Undef]

A list of fields that are included in each real-time log record. In an
API response, the fields are provided in the same order in which they
are sent to the Amazon Kinesis data stream.

For more information about fields, see Real-time log configuration
fields
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields)
in the I<Amazon CloudFront Developer Guide>.


=head2 B<REQUIRED> Name => Str

The unique name of this real-time log configuration.


=head2 B<REQUIRED> SamplingRate => Int

The sampling rate for this real-time log configuration. The sampling
rate determines the percentage of viewer requests that are represented
in the real-time log data. The sampling rate is an integer between 1
and 100, inclusive.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

