/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.skin.ArrowBody;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowDressing;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;

public class ArrowConfiguration {
    private final ArrowBody body;
    private final ArrowDressing dressing1;
    private final ArrowDressing dressing2;
    private final ArrowDecoration decoration1;
    private final ArrowDecoration decoration2;
    private final HtmlColor color;

    private ArrowConfiguration(ArrowBody arrowBody, ArrowDressing arrowDressing, ArrowDressing arrowDressing2, ArrowDecoration arrowDecoration, ArrowDecoration arrowDecoration2, HtmlColor htmlColor) {
        if (arrowBody == null || arrowDressing == null) {
            throw new IllegalArgumentException();
        }
        this.body = arrowBody;
        this.dressing1 = arrowDressing;
        this.dressing2 = arrowDressing2;
        this.decoration1 = arrowDecoration;
        this.decoration2 = arrowDecoration2;
        this.color = htmlColor;
    }

    public String toString() {
        return this.name();
    }

    public String name() {
        if (this.dressing2 == null) {
            return this.body.name() + "(" + this.dressing1.name() + ")" + this.color + " " + (Object)((Object)this.decoration1);
        }
        return this.body.name() + "(" + this.dressing1.name() + " " + (Object)((Object)this.decoration1) + ")(" + this.dressing2.name() + " " + (Object)((Object)this.decoration2) + ")" + this.color;
    }

    public static ArrowConfiguration withDirectionNormal() {
        return new ArrowConfiguration(ArrowBody.NORMAL, ArrowDressing.create(), ArrowDressing.create().withHead(ArrowHead.NORMAL), ArrowDecoration.NONE, ArrowDecoration.NONE, null);
    }

    public static ArrowConfiguration withDirectionBoth() {
        return new ArrowConfiguration(ArrowBody.NORMAL, ArrowDressing.create().withHead(ArrowHead.NORMAL), ArrowDressing.create().withHead(ArrowHead.NORMAL), ArrowDecoration.NONE, ArrowDecoration.NONE, null);
    }

    public static ArrowConfiguration withDirectionSelf() {
        return new ArrowConfiguration(ArrowBody.NORMAL, ArrowDressing.create().withHead(ArrowHead.NORMAL), null, ArrowDecoration.NONE, ArrowDecoration.NONE, null);
    }

    public static ArrowConfiguration withDirectionReverse() {
        return ArrowConfiguration.withDirectionNormal().reverse();
    }

    public ArrowConfiguration reverse() {
        return new ArrowConfiguration(this.body, this.dressing2, this.dressing1, this.decoration2, this.decoration1, this.color);
    }

    public ArrowConfiguration self() {
        return new ArrowConfiguration(this.body, this.dressing1, null, this.decoration1, this.decoration2, this.color);
    }

    public ArrowConfiguration withDotted() {
        return new ArrowConfiguration(ArrowBody.DOTTED, this.dressing1, this.dressing2, this.decoration1, this.decoration2, this.color);
    }

    public ArrowConfiguration withHead(ArrowHead arrowHead) {
        ArrowDressing arrowDressing = ArrowConfiguration.addHead(this.dressing1, arrowHead);
        ArrowDressing arrowDressing2 = ArrowConfiguration.addHead(this.dressing2, arrowHead);
        return new ArrowConfiguration(this.body, arrowDressing, arrowDressing2, this.decoration1, this.decoration2, this.color);
    }

    private static ArrowDressing addHead(ArrowDressing arrowDressing, ArrowHead arrowHead) {
        if (arrowDressing == null || arrowDressing.getHead() == ArrowHead.NONE) {
            return arrowDressing;
        }
        return arrowDressing.withHead(arrowHead);
    }

    public ArrowConfiguration withHead1(ArrowHead arrowHead) {
        return new ArrowConfiguration(this.body, this.dressing1.withHead(arrowHead), this.dressing2, this.decoration1, this.decoration2, this.color);
    }

    public ArrowConfiguration withHead2(ArrowHead arrowHead) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2.withHead(arrowHead), this.decoration1, this.decoration2, this.color);
    }

    public ArrowConfiguration withPart(ArrowPart arrowPart) {
        if (this.dressing2 != null && this.dressing2.getHead() != ArrowHead.NONE) {
            return new ArrowConfiguration(this.body, this.dressing1, this.dressing2.withPart(arrowPart), this.decoration1, this.decoration2, this.color);
        }
        return new ArrowConfiguration(this.body, this.dressing1.withPart(arrowPart), this.dressing2, this.decoration1, this.decoration2, this.color);
    }

    public ArrowConfiguration withDecoration1(ArrowDecoration arrowDecoration) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, arrowDecoration, this.decoration2, this.color);
    }

    public ArrowConfiguration withDecoration2(ArrowDecoration arrowDecoration) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, this.decoration1, arrowDecoration, this.color);
    }

    public ArrowConfiguration withColor(HtmlColor htmlColor) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, this.decoration1, this.decoration2, htmlColor);
    }

    public final ArrowDecoration getDecoration1() {
        return this.decoration1;
    }

    public final ArrowDecoration getDecoration2() {
        return this.decoration2;
    }

    public final ArrowDirection getArrowDirection() {
        if (this.dressing2 == null) {
            return ArrowDirection.SELF;
        }
        if (this.dressing1.getHead() == ArrowHead.NONE && this.dressing2.getHead() != ArrowHead.NONE) {
            return ArrowDirection.LEFT_TO_RIGHT_NORMAL;
        }
        if (this.dressing1.getHead() != ArrowHead.NONE && this.dressing2.getHead() == ArrowHead.NONE) {
            return ArrowDirection.RIGHT_TO_LEFT_REVERSE;
        }
        return ArrowDirection.BOTH_DIRECTION;
    }

    public boolean isSelfArrow() {
        return this.getArrowDirection() == ArrowDirection.SELF;
    }

    public boolean isDotted() {
        return this.body == ArrowBody.DOTTED;
    }

    public ArrowHead getHead() {
        if (this.dressing2 != null && this.dressing2.getHead() != ArrowHead.NONE) {
            return this.dressing2.getHead();
        }
        return this.dressing1.getHead();
    }

    public boolean isAsync() {
        return this.dressing1.getHead() == ArrowHead.ASYNC || this.dressing2 != null && this.dressing2.getHead() == ArrowHead.ASYNC;
    }

    public final ArrowPart getPart() {
        if (this.dressing2 != null && this.dressing2.getHead() != ArrowHead.NONE) {
            return this.dressing2.getPart();
        }
        return this.dressing1.getPart();
    }

    public HtmlColor getColor() {
        return this.color;
    }

    public ArrowDressing getDressing1() {
        return this.dressing1;
    }

    public ArrowDressing getDressing2() {
        return this.dressing2;
    }
}

