#!/usr/bin/env perl
use utf8;
#Lemmatizations listed in this file are ERRORS of the old Morpha implementation!

my $VARIOUS = <<'END_VARIOUS';
'll	MD	'll
'd	MD	'd
'd	VBD	'd
n't	RB	n't
pp.	NNS	p.
lay	VBD	lay	#lie: VBD is not VB
rebound	VB	rebind	#rebound: VB is not VBD
audits	NN	audit	#should be NNS - not our problem
receivables	NN	receivable	#should be NNS - not our problem
pence	NN	penny	#should be NNS - not our problem
bore	VBP	bear	#bore: VBP is not VBD
bore	VB	bear
found	VB	find	#found: VB is not VBD
formula	NN	formulum
data	NN	datum
latest	JJS	lat
later	RBR	lat
merest	JJS	mer
paler	JJR	pal
better-off	JJR	good
irregularities	NNS	regular
irregularly	RB	regular
irreversible	JJ	reversib
irregularity	NN	regular
irresponsibility	NN	responsib
irreducible	JJ	reduci
commons	NNS	common	#polemic
refreshments	NNS	refreshment	#polemic
spoils	NNS	spoil	#polemic
rations	NNS	ration
cafés	NNS	cafés
END_VARIOUS

#These are negations, prefix should be cut off, but wasn't in PEDT::MorphologyAnalysis.
my $NEGATION = <<'END_NEGATION';
irresponsible	JJ	irresponsible
unprecedented	JJ	unprecedented
undoubtedly	RB	undoubtedly
unexpectedly	RB	unexpectedly
inorganic	JJ	inorganic
undue	JJ	undue
unruly	JJ	unruly
unmoved	JJ	unmoved
undeniably	RB	undeniably
unmistakably	RB	unmistakably
disillusioned	JJ	disillusioned
disinfectant	NN	disinfectant
irrevocably	RB	irrevocably
non-european	JJ	non-european
non-christian	JJ	non-christian
inexplicably	RB	inexplicably
END_NEGATION

#These are NOT negations, prefix should NOT be cut off, but was in PEDT::MorphologyAnalysis.
my $NO_NEGATION = <<'END_NO_NEGATION';
immigration	NN	migration
impassioned	JJ	passioned
impassive	JJ	passive
indifference	NN	difference
indifferent	JJ	different
incoming	JJ	coming
insanity	NN	sanity  #polemic
irradiation	NN	radiation
unix-based	JJ	ix-based
uneasy	JJ	easy
unease	NN	ease
uneasily	RB	easily
invertebrates	NNS	vertebrate
inextricably	RB	inextricably
disillusionment	NN	disillusionment
intuition	NN	tuition
intuitions	NNS	tuition
irate	JJ	ate
dismissal	NN	missal
dismissive	JJ	missive
dismissals	NNS	missal
inshore	RB	shore
inbred	JJ	bred
END_NO_NEGATION

my $I_US = <<'END_I_US';
ai	NN	aus
xi	NN	xus
alexei	NNS	alexeus
graffiti	NN	graffitus
mini	NN	minus
chilli	NN	chillus
scsi	NN	scsus
ascii	NN	ascius
psi	NN	psus
rdbi	NNS	rdbus
semi	NN	semus
sunni	NN	sunnus
roi	NN	rous
dei	NNS	deus
di	NN	dus
rpi	NN	rpus
ahi	NNS	ahus
loci	NNS	locus
boutros-ghali	NN	boutros-ghalus
kadi	NN	kadus
certiorari	NNS	certiorarus
malai	NNS	malaus
myeloski	NNS	myeloskus
swahili	NN	swahilus
volenti	NNS	volentus
moduli	NNS	modulus
thai	NN	thaus
lazuli	NNS	lazulus
pakistani	NN	pakistanus
sdi	NN	sdus
chianti	NN	chiantus
ci	NN	cus
mahdi	NN	mahdus
wi	NNS	wus
lili	NNS	lilus
ch'i	NNS	ch'us
END_I_US

#Proper nouns should not be changed by lemmatization.
my $NNP = <<'END_NNP';
CBS	NNP	cb
IRS	NNP	ir
Mae	NNP	ma
Mass.	NNP	mas.
Intel	NNP	tel
Mitsubishi	NNP	mitsubishus
SCI	NNP	scus
Saatchi	NNP	saatchus
Nikkei	NNP	nikkeus
AIDS	NNP	aid
MCI	NNP	mcus
II	NNP	ius
WCRS	NNP	wcr
Li	NNP	lus
CIA	NNP	cium
Cincinnati	NNP	cincinnatus
Miami	NNP	miamus
Gandhi	NNP	gandhus
FBI	NNP	fbus
III	NNP	iius
Cos.	NNP	co.
Giuliani	NNP	giulianus
Missouri	NNP	missourus
Sansui	NNP	sansuus
Savings	NNPS	savings
Messrs.	NNP	messr.
Fuji	NNP	fujus
Olivetti	NNP	olivettus
PS	NNP	p
SDI	NNP	sdus
Hitachi	NNP	hitachus
Waertsilae	NNP	waertsila
Eli	NNP	elus
Mississippi	NNP	mississippus
Yamaichi	NNP	yamaichus
Infiniti	NNP	infinitus
Hawaii	NNP	hawaius
Agnelli	NNP	agnellus
Taipei	NNP	taipeus
TVS	NNP	tv
EMS	NNP	em
O'Kicki	NNP	o'kickus
CMS	NNP	cm
Hyundai	NNP	hyundaus
Independent	NNP	dependent
Saudi	NNP	saudus
Statistics	NNPS	statistics
CS	NNP	c
Chugai	NNP	chugaus
Dynamics	NNPS	dynamics
Messrs.	NNPS	messr.
Wis.	NNP	wi.
Giovanni	NNP	giovannus
Valhi	NNP	valhus
ICI	NNP	icus
ISI	NNP	isus
DeConcini	NNP	deconcinus
Rights	NNPS	rights
Di	NNP	dus
DES	NNP	de
Murata	NNP	mura
PBS	NNP	pb
TCI	NNP	tcus
Mitsui	NNP	mitsuus
Olympics	NNPS	olympics
MMI	NNP	mmus
Belli	NNP	bellus
NBI	NNP	nbus
Shanghai	NNP	shanghaus
Wanniski	NNP	wanniskus
Bros.	NNP	bro.
OAS	NNP	oa
Aichi	NNP	aichus
ici	NNP	icus
ali	NNP	alus
sri	NNP	srus
indies	NNP	dies
li	NNP	lus
di	NNP	dus
saudi	NNP	saudus
gandhi	NNP	gandhus
modigliani	NNP	modiglianus
delhi	NNP	delhus
ronni	NNP	ronnus
ni	NNP	nus
dti	NNP	dtus
alexei	NNP	alexeus
vi	NNP	vus
hari	NNP	harus
ferrari	NNP	ferrarus
masai	NNP	masaus
cbi	NNP	cbus
independent	NNP	dependent
irvine	NNP	vine
miami	NNP	miamus
olivetti	NNP	olivettus
emi	NNP	emus
saatchi	NNP	saatchus
lili	NNP	lilus
hawaii	NNP	hawaius
levi	NNP	levus
fiji	NNP	fijus
fbi	NNP	fbus
henri	NNP	henrus
malawi	NNP	malawus
yemen	NNP	yeman
irwin	NNP	win
fri	NNP	frus
mussolini	NNP	mussolinus
hitachi	NNP	hitachus
ari	NNP	arus
niki	NNP	nikus
hmi	NNP	hmus
willi	NNP	willus
koi	NNP	kous
helsinki	NNP	helsinkus
bcci	NNP	bccus
nairobi	NNP	nairobus
ferranti	NNP	ferrantus
vicki	NNP	vickus
tivoli	NNP	tivolus
giovanni	NNP	giovannus
shanghai	NNP	shanghaus
carmen	NNP	carman
haiti	NNP	haitus
naomi	NNP	naomus
llanelli	NNP	llanellus
indo-china	NNP	do-china
tiananmen	NNP	tiananman
janata	NNP	jana
ingrid	NNP	grid
fenari	NNP	fenarus
midi	NNP	midus
dai	NNP	daus
mitsubishi	NNP	mitsubishus
nikolai	NNP	nikolaus
andrei	NNP	andreus
chi	NNP	chus
jacqui	NNP	jacquus
rae	NNP	ra
tripoli	NNP	tripolus
khomeini	NNP	khomeinus
gemini	NNP	geminus
sergei	NNP	sergeus
rafsanjani	NNP	rafsanjanus
bae	NNP	ba
mississippi	NNP	mississippus
meh'lindi	NNP	meh'lindus
mini	NNP	minus
hanoi	NNP	hanous
ui	NNP	uus
shai	NNP	shaus
wabi	NNP	wabus
disraeli	NNP	disraelus
mali	NNP	malus
omi	NNP	omus
djibouti	NNP	djiboutus
bremen	NNP	breman
ingram	NNP	gram
dubai	NNP	dubaus
audi	NNP	audus
mancini	NNP	mancinus
tbilisi	NNP	tbilisus
fujimori	NNP	fujimorus
nicolae	NNP	nicola
edi	NNP	edus
myeloski	NNP	myeloskus
toni	NNP	tonus
brunei	NNP	bruneus
capri	NNP	caprus
uae	NNP	ua
agassi	NNP	agassus
lori	NNP	lorus
macari	NNP	macarus
marconi	NNP	marconus
artai	NNP	artaus
stasi	NNP	stasus
dhabi	NNP	dhabus
missouri	NNP	missourus
modi	NNP	modus
mori	NNP	morus
sinai	NNP	sinaus
abi	NNP	abus
verdi	NNP	verdus
dalai	NNP	dalaus
bali	NNP	balus
pri	NNP	prus
rnli	NNP	rnlus
ilford	NNP	ford
unwin	NNP	win
delphi	NNP	delphus
fi	NNP	fus
jimi	NNP	jimus
suzuki	NNP	suzukus
ri	NNP	rus
yuri	NNP	yurus
sabatini	NNP	sabatinus
mai	NNP	maus
posi	NNP	posus
buthelezi	NNP	buthelezus
karachi	NNP	karachus
nikkei	NNP	nikkeus
judi	NNP	judus
lsi	NNP	lsus
mazowiecki	NNP	mazowieckus
armani	NNP	armanus
fuji	NNP	fujus
heidi	NNP	heidus
taipei	NNP	taipeus
acemi	NNP	acemus
rmi	NNP	rmus
cincinnati	NNP	cincinnatus
tvei	NNP	tveus
shanti	NNP	shantus
hrawi	NNP	hrawus
pompeii	NNP	pompeius
gassendi	NNP	gassendus
shae	NNP	sha
atari	NNP	atarus
mae	NNP	ma
hyundai	NNP	hyundaus
gramsci	NNP	gramscus
steffi	NNP	steffus
fei	NNP	feus
messrs.	NNP	messr.
chatichai	NNP	chatichaus
nikki	NNP	nikkus
rossini	NNP	rossinus
ciskei	NNP	ciskeus
doi	NNP	dous
rossi	NNP	rossus
mcrae	NNP	mcra
christi	NNP	christus
yeremi	NNP	yeremus
miletti	NNP	milettus
luigi	NNP	luigus
andreotti	NNP	andreottus
gianni	NNP	giannus
parti	NNP	partus
wolski	NNP	wolskus
qaddafi	NNP	qaddafus
pavarotti	NNP	pavarottus
ansi	NNP	ansus
bari	NNP	barus
kawasaki	NNP	kawasakus
mundi	NNP	mundus
monteverdi	NNP	monteverdus
pease	NNP	pea
suragai	NNP	suragaus
rudi	NNP	rudus
kyi	NNP	kyus
assisi	NNP	assisus
burundi	NNP	burundus
nogai	NNP	nogaus
bsdi	NNP	bsdus
joni	NNP	jonus
toshiki	NNP	toshikus
didi	NNP	didus
cristiani	NNP	cristianus
miti	NNP	mitus
rutskoi	NNP	rutskous
marti	NNP	martus
benedetti	NNP	benedettus
transkei	NNP	transkeus
nagasaki	NNP	nagasakus
thai	NNP	thaus
kadhafi	NNP	kadhafus
kai	NNP	kaus
brae	NNP	bra
ixi	NNP	ixus
gaddafi	NNP	gaddafus
vellayati	NNP	vellayatus
hosni	NNP	hosnus
joshi	NNP	joshus
bambi	NNP	bambus
craxi	NNP	craxus
georgi	NNP	georgus
dali	NNP	dalus
sendei	NNP	sendeus
imran	NNP	ran
capriati	NNP	capriatus
macrae	NNP	macra
dei	NNP	deus
beni	NNP	benus
lai	NNP	laus
pwllheli	NNP	pwllhelus
vinci	NNP	vincus
cagliari	NNP	cagliarus
bernini	NNP	berninus
petri	NNP	petrus
malinowski	NNP	malinowskus
dili	NNP	dilus
fddi	NNP	fddus
suzi	NNP	suzus
benghazi	NNP	benghazus
newcomen	NNP	newcoman
aurae	NNP	aura
wilfridi	NNP	wilfridus
jodami	NNP	jodamus
eli	NNP	elus
dewi	NNP	dewus
vivaldi	NNP	vivaldus
bolshoi	NNP	bolshous
vecchi	NNP	vecchus
sidi	NNP	sidus
scarabae	NNP	scaraba
moscovici	NNP	moscovicus
fittipaldi	NNP	fittipaldus
hashemi	NNP	hashemus
zborowski	NNP	zborowskus
jaruzelski	NNP	jaruzelskus
dimitri	NNP	dimitrus
END_NNP

#Non-plural nouns should not be changed by lemmatization (except of  cutting off negation prefix)
my $NN = <<'END_OF_NN';
sales	NN	sale
works	NN	work
graphics	NN	graphic
aids	NN	aid
mps	NN	mp
maths	NN	math
mains	NN	main
dos	NN	do
ethics	NN	ethic
innings	NN	inning
ms-dos	NN	ms-do
0s.	NN	0.
ps	NN	p
ms	NN	m
stamina	NN	stamen
0-	NN	0-_nn
sae	NN	sa
lms	NN	lm
fella	NN	fellum
atlas	NN	atla
frs	NN	fr
vms	NN	vm
butchers	NN	butcher
pragmatics	NN	pragmatic
insanity	NN	sanity
pp.	NN	p.
deixis	NN	deixi
lumen	NN	luman
metaplasia	NN	metaplasium
lire	NN	lira
propria	NN	proprium
aerobics	NN	aerobic
irrelevance	NN	relevance
stylistics	NN	stylistic
dysplasia	NN	dysplasium
telecoms	NN	telecom
bulimia	NN	bulimium
dia	NN	dium
guberniia	NN	gubernium
della	NN	dellum
sis	NN	si
tcr-	NN	tcr-_nn
hyperplasia	NN	hyperplasium
minorities	NN	minority
citalia	NN	citalium
diagnostics	NN	diagnostic
sos	NN	so
hypothermia	NN	hypothermium
plc-	NN	plc-_nn
f--	NN	f--_nn
pres	NN	pre
papilla	NN	papillum
majlis	NN	majli
mitochondria	NN	mitochondrium
viewdata	NN	viewda
achilles	NN	achille
clematis	NN	clemati
clitoris	NN	clitori
0pts	NN	0pt
neoplasia	NN	neoplasium
pamela	NN	pamelum
genitalia	NN	genitalium
lapis	NN	lapi
acropolis	NN	acropoli
chrysalis	NN	chrysali
cepacia	NN	cepacium
avionics	NN	avionic
celia	NN	celium
charolais	NN	charolai
microalbuminuria	NN	microalbuminurium
malais	NN	malai
gurus	NN	guru
bella	NN	bellum
mflops	NN	mflop
intarsia	NN	intarsium
rics	NN	ric
nucella	NN	nucellum
phyla	NN	phylum
atlantis	NN	atlanti
candelabra	NN	candelabrum
cardia	NN	cardium
is.	NN	i.
0kms	NN	0km
caddis	NN	caddi
0gns	NN	0gn
irs	NN	ir
phenylketonuria	NN	phenylketonurium
nvala	NN	nvalum
two-	NN	two-_nn
rdbi	NN	rdbus
shia	NN	shium
subspecies	NN	subspecy
chi	NN	chus
sci-fi	NN	sci-fus
muderris	NN	muderri
amis	NN	ami
fenella	NN	fenellum
0yds	NN	0yd
fmi	NN	fmus
wis	NN	wi
sla	NN	slum
unionization	NN	ionization
soon-yi	NN	soon-yus
polis	NN	poli
eis	NN	ei
chamois	NN	chamoix
spastics	NN	spastic
luciferi	NN	luciferus
vulgaris	NN	vulgari
charades	NN	charade
morris	NN	morri
imi	NN	imus
eighteenth-	NN	eighteenth-_nn
i-	NN	i-_nn
xmas	NN	xma
gourami	NN	gouramus
gravis	NN	gravi
epithelia	NN	epithelium
narcissi	NN	narcissus
gouramis	NN	gourami
hypoxia	NN	hypoxium
0hrs	NN	0hr
punjabi	NN	punjabus
sylvia	NN	sylvium
muscularis	NN	musculari
listeria	NN	listerium
gti	NN	gtus
ola	NN	olum
tectonics	NN	tectonic
kroner	NN	krone
cilia	NN	cilium
thais	NN	thai
maria	NN	marium
mycobacteria	NN	mycobacterium
uzi	NN	uzus
automata	NN	automaton
niki	NN	nikus
delors	NN	delor
alchemilla	NN	alchemillum
protozoa	NN	protozoan
symposia	NN	symposium
kts	NN	kt
three-	NN	three-_nn
flavia	NN	flavium
quanta	NN	quantum
sangria	NN	sangrium
woodlice	NN	woodlouse
mid-	NN	mid-_nn
fabia	NN	fabium
mia	NN	mium
bugis	NN	bugi
subss.	NN	subs.
gui	NN	guus
wgms	NN	wgm
0s	NN	0
bali	NN	balus
us.	NN	u.
apologia	NN	apologium
magi	NN	magus
pula	NN	pulum
identifies	NN	identify
cis	NN	ci
hypermedia	NN	hypermedium
savimbi	NN	savimbus
maxilla	NN	maxillum
materia	NN	materium
nazi	NN	nazus
macroeconomics	NN	macroeconomic
lili	NN	lilus
leila	NN	leilum
minimis	NN	minimi
adonis	NN	adoni
eps	NN	ep
rachaela	NN	rachaelum
chlamydia	NN	chlamydium
jacqui	NN	jacquus
0ls	NN	0l
spermatozoa	NN	spermatozoon
dhia	NN	dhium
mozzarella	NN	mozzarellum
kata	NN	ka
stepchildren	NN	stepchild
amaryllis	NN	amarylli
paella	NN	paellum
rms	NN	rm
corosini	NN	corosinus
decidendi	NN	decidendus
injuria	NN	injurium
res	NN	re
psychedelia	NN	psychedelium
lobelia	NN	lobelium
buddleia	NN	buddleium
chai	NN	chaus
arrhythmia	NN	arrhythmium
poetics	NN	poetic
sociolinguistics	NN	sociolinguistic
triaxis	NN	triaxi
pot-pourri	NN	pot-pourrus
pompeii	NN	pompeius
divi	NN	divus
teargas	NN	tearga
trattoria	NN	trattorium
novella	NN	novellum
canis	NN	cani
irreverence	NN	reverence
cella	NN	cellum
urticaria	NN	urticarium
pos.	NN	po.
taramasalata	NN	taramasala
api	NN	apus
anglais	NN	anglai
daphnia	NN	daphnium
nla	NN	nlum
medici	NN	medicus
landsbergis	NN	landsbergi
sti	NN	stus
--	NN	--_nn
bacardi	NN	bacardus
intractability	NN	tractability
askaris	NN	askari
mtfs	NN	mtf
zuwayi	NN	zuwayus
regis	NN	regi
one-	NN	one-_nn
low-	NN	low-_nn
coupla	NN	couplum
gymnasia	NN	gymnasium
eia	NN	eium
tfiia	NN	tfium
agenais	NN	agenai
cpi	NN	cpus
sharia	NN	sharium
irradiance	NN	radiance
neroli	NN	nerolus
irreversibility	NN	reversib
yonks	NN	yonk
csys	NN	csy
cosi	NN	cosus
rumen	NN	ruman
irreducibility	NN	reduci
masala	NN	masalum
sylvestris	NN	sylvestri
ifs	NN	if
officinalis	NN	officinali
hellebores	NN	hellebore
giovanni	NN	giovannus
ssi	NN	ssus
hysterics	NN	hysteric
robotics	NN	robotic
kanji	NN	kanjus
hsds	NN	hsd
pois	NN	poi
pseudomonas	NN	pseudomona
paris	NN	pari
cla	NN	clum
0-0-	NN	0-0-_nn
xla	NN	xlum
cynthia	NN	cynthium
nts	NN	nt
standi	NN	standus
links	NN	link
dormice	NN	dormouse
hindi	NN	hindus
infusoria	NN	infusorium
latifundia	NN	latifundium
guis	NN	gui
allis	NN	alli
stomata	NN	stoma
mpla	NN	mplum
cross-roads	NN	cross-road
facia	NN	facium
digitalis	NN	digitali
gujerati	NN	gujeratus
bovis	NN	bovi
leavis	NN	leavi
ella	NN	ellum
inside-forward	NN	side-forward
milieux	NN	milieu
lori	NN	lorus
insula	NN	insulum
artai	NN	artaus
myeloski	NN	myeloskus
haematuria	NN	haematurium
synodontis	NN	synodonti
yanomami	NN	yanomamus
calidris	NN	calidri
sarella	NN	sarellum
emilia	NN	emilium
chemotaxis	NN	chemotaxi
milettis	NN	miletti
asi	NN	asus
marmi	NN	marmus
0mls	NN	0ml
ami	NN	amus
wwii	NN	wwius
achlorhydria	NN	achlorhydrium
steffi	NN	steffus
intis	NN	inti
bordelais	NN	bordelai
telematics	NN	telematic
centauri	NN	centaurus
four-	NN	four-_nn
enopla	NN	enoplum
premaxilla	NN	premaxillum
sixteenth-	NN	sixteenth-_nn
lamborghini	NN	lamborghinus
uni	NN	unus
wi	NN	wus
dysgraphia	NN	dysgraphium
faecalis	NN	faecali
refugia	NN	refugium
addenda	NN	addendum
middle-	NN	middle-_nn
semai	NN	semaus
xerophthalmia	NN	xerophthalmium
mis	NN	mi
dysuria	NN	dysurium
mala	NN	malum
betula	NN	betulum
apraxia	NN	apraxium
teclis	NN	tecli
tertiis	NN	tertii
inheritor	NN	heritor
semiotics	NN	semiotic
bradycardia	NN	bradycardium
scientia	NN	scientium
inla	NN	inlum
sssi	NN	sssus
passacaglia	NN	passacaglium
nauplii	NN	nauplius
fabula	NN	fabulum
pers.	NN	per.
htfiia	NN	htfium
so-	NN	so-_nn
illus.	NN	illu.
anti-	NN	anti-_nn
energetics	NN	energetic
butis	NN	buti
tsunamis	NN	tsunami
non-co-operation	NN	non-co-operation
pmis	NN	pmi
younis	NN	youni
telecomms	NN	telecomm
affinis	NN	affini
medulla	NN	medullum
unix-based	NN	ix-based
unlikelihood	NN	likelihood
anoxia	NN	anoxium
sub-sales	NN	sub-sale
proteinuria	NN	proteinurium
tata	NN	ta
al-megrahi	NN	al-megrahus
femora	NN	femur
al-kaysi	NN	al-kaysus
corgis	NN	corgi
mavis	NN	mavi
abyssicola	NN	abyssicolum
intra-	NN	tra-_nn
camilla	NN	camillum
pre-eclampsia	NN	pre-eclampsium
sci	NN	scus
ultrasonics	NN	ultrasonic
nfis	NN	nfi
scoria	NN	scorium
anomala	NN	anomalum
inter-	NN	inter-_nn
pro-	NN	pro-_nn
luigi	NN	luigus
tafari	NN	tafarus
twenty-	NN	twenty-_nn
sabatini	NN	sabatinus
g'bai	NN	g'baus
coriolis	NN	corioli
honoraria	NN	honorarium
laevis	NN	laevi
giardia	NN	giardium
mla	NN	mlum
chola	NN	cholum
brichardi	NN	brichardus
eight-	NN	eight-_nn
irrelevancy	NN	relevancy
bla	NN	blum
rotundifolia	NN	rotundifolium
jamila	NN	jamilum
suzi	NN	suzus
cdai	NN	cdaus
0--	NN	0--_nn
irresolution	NN	resolution
tachygastria	NN	tachygastrium
adelphi	NN	adelphus
0th-	NN	0th-_nn
napoli	NN	napolus
indiction	NN	diction
mkii	NN	mkius
kinematics	NN	kinematic
mais	NN	mai
hamamelis	NN	hamameli
bacci	NN	baccus
ropati	NN	ropatus
technics	NN	technic
long-	NN	long-_nn
borealis	NN	boreali
ismailis	NN	ismaili
haveli	NN	havelus
coulis	NN	couli
semi-	NN	semi-_nn
zambezi	NN	zambezus
res.	NN	re.
self-	NN	self-_nn
meticais	NN	meticai
sala	NN	salum
al-masri	NN	al-masrus
econometrics	NN	econometric
achalasia	NN	achalasium
rais	NN	rai
el-gharbi	NN	el-gharbus
alexia	NN	alexium
diata	NN	dia
ampulla	NN	ampullum
x-	NN	x-_nn
n'pani	NN	n'panus
puris	NN	puri
ria	NN	rium
eubacteria	NN	eubacterium
drosophila	NN	drosophilum
breccia	NN	breccium
pmt0-plc-	NN	pmt0-plc-_nn
haustoria	NN	haustorium
bonis	NN	boni
lola	NN	lolum
cordelia	NN	cordelium
planaria	NN	planarium
cgli	NN	cglus
cyanobacteria	NN	cyanobacterium
mahonia	NN	mahonium
dis-ease	NN	-ease
paramedics	NN	paramedic
beccaria	NN	beccarium
perennis	NN	perenni
snowdonia	NN	snowdonium
iron-ore	NN	on-ore
continua	NN	continuum
microlepis	NN	microlepi
pulsatilla	NN	pulsatillum
polanski	NN	polanskus
kinsai	NN	kinsaus
al-thani	NN	al-thanus
estella	NN	estellum
maori	NN	maorus
mani	NN	manus
pai	NN	paus
serenata	NN	serena
omanis	NN	omani
impala	NN	impalum
yi	NN	yus
over-	NN	over-_nn
zaki	NN	zakus
juvenilia	NN	juvenilium
omnia	NN	omnium
trois	NN	troi
sardinia	NN	sardinium
rimini	NN	riminus
bidentata	NN	bidenta
lamellipodia	NN	lamellipodium
blastula	NN	blastulum
boccia	NN	boccium
ytfiia	NN	ytfium
cipriani	NN	ciprianus
gnostics	NN	gnostic
him-	NN	him-_nn
campari	NN	camparus
scilla	NN	scillum
second-innings	NN	second-inning
commis	NN	commi
bilharzia	NN	bilharzium
calvados	NN	calvado
desiderata	NN	desideratum
brevis	NN	brevi
gracilis	NN	gracili
six-	NN	six-_nn
posi	NN	posus
ninety-	NN	ninety-_nn
pacis	NN	paci
non-english	NN	non-english
bsia	NN	bsium
al-	NN	al-_nn
colnaghi	NN	colnaghus
cpni	NN	cpnus
syndics	NN	syndic
strandli	NN	strandlus
granulomata	NN	granuloma
australis	NN	australi
radula	NN	radulum
centifolia	NN	centifolium
interspecies	NN	interspecy
philharmonia	NN	philharmonium
asthmatics	NN	asthmatic
zombis	NN	zombi
propionibacteria	NN	propionibacterium
hemiplegia	NN	hemiplegium
paki	NN	pakus
diglossia	NN	diglossium
sukhumi	NN	sukhumus
menorrhagia	NN	menorrhagium
kibbutzim	NN	kibbutz
frottola	NN	frottolum
age-	NN	age-_nn
non-	NN	non-_nn
dermis	NN	dermi
al-anbari	NN	al-anbarus
mikila	NN	mikilum
dr-dos	NN	dr-do
tala-tala	NN	tala-talum
mri	NN	mrus
under-	NN	der-_nn
hela	NN	helum
hermeneutics	NN	hermeneutic
vecchi	NN	vecchus
tandoori	NN	tandoorus
pegasi	NN	pegasus
five-	NN	five-_nn
'this	NN	'thi
bani	NN	banus
olszewski	NN	olszewskus
apla	NN	aplum
vaginalis	NN	vaginali
charleroi	NN	charlerous
deni	NN	denus
sfi	NN	sfus
flagella	NN	flagellum
familia	NN	familium
oliguria	NN	oligurium
benghazi	NN	benghazus
l-	NN	l-_nn
hypotonia	NN	hypotonium
acquis	NN	acqui
berberis	NN	berberi
pomerania	NN	pomeranium
glynis	NN	glyni
lis	NN	li
victoria	NN	victorium
pubis	NN	pubi
franglais	NN	franglai
ducati	NN	ducatus
lacinia	NN	lacinium
fujimori	NN	fujimorus
gla	NN	glum
eli	NN	elus
mela	NN	melum
rudbeckia	NN	rudbeckium
pamella	NN	pamellum
gris	NN	gri
cols.	NN	col.
optima	NN	optimum
tetraplegia	NN	tetraplegium
iron-working	NN	on-working
hamula	NN	hamulum
cassia	NN	cassium
abdel-shafi	NN	abdel-shafus
small-	NN	small-_nn
talabani	NN	talabanus
gabonais	NN	gabonai
indie-dance	NN	die-dance
nyala	NN	nyalum
dvla	NN	dvlum
crania	NN	cranium
impassivity	NN	passivity
bangladeshis	NN	bangladeshi
tsps	NN	tsp
colombi	NN	colombus
delia	NN	delium
cosla	NN	coslum
ink-jet	NN	k-jet
dntps	NN	dntp
micro-	NN	micro-_nn
potentilla	NN	potentillum
eei	NN	eeus
polynesia	NN	polynesium
herpetiformis	NN	herpetiformi
third-	NN	third-_nn
namoi	NN	namous
chemoprophylaxis	NN	chemoprophylaxi
militaria	NN	militarium
neotropics	NN	neotropic
orientalis	NN	orientali
toscanini	NN	toscaninus
bourani	NN	bouranus
gila	NN	gilum
pakis	NN	paki
serapis	NN	serapi
fps	NN	fp
bazadais	NN	bazadai
orbis	NN	orbi
mortaria	NN	mortarium
filopodia	NN	filopodium
panspermia	NN	panspermium
arenaria	NN	arenarium
cathexis	NN	cathexi
manics	NN	manic
myalgia	NN	myalgium
satis	NN	sati
maharishi	NN	maharishus
balearics	NN	balearic
lavinia	NN	lavinium
inn-keeper	NN	n-keeper
-0-	NN	-0-_nn
public-	NN	public-_nn
tatti	NN	tattus
ula	NN	ulum
gloxinia	NN	gloxinium
bartocci	NN	bartoccus
bellini	NN	bellinus
gwili	NN	gwilus
filiformis	NN	filiformi
f-	NN	f-_nn
tethlis	NN	tethli
ifi	NN	ifus
francais	NN	francai
lamblia	NN	lamblium
oceanis	NN	oceani
abyssalis	NN	abyssali
myelodysplasia	NN	myelodysplasium
duplicata	NN	duplica
ei	NN	eus
catatonia	NN	catatonium
atria	NN	atrium
fundi	NN	fundus
up-	NN	up-_nn
non-european	NN	non-european
crucis	NN	cruci
indicia	NN	indicium
alia	NN	alium
legionella	NN	legionellum
sufis	NN	sufi
valenzuela	NN	valenzuelum
non-turbo	NN	non-turbo
non-christian	NN	non-christian
fascisti	NN	fascistus
galicia	NN	galicium
marci	NN	marcus
bryonia	NN	bryonium
ommatidia	NN	ommatidium
conservative-	NN	conservative-_nn
gateaux	NN	gateau
lanceolata	NN	lanceola
anatolia	NN	anatolium
bavarois	NN	bavaroi
santis	NN	santi
longifolia	NN	longifolium
hyemalis	NN	hyemali
proarrhythmia	NN	proarrhythmium
giacometti	NN	giacomettus
asics	NN	asic
pki	NN	pkus
bfi	NN	bfus
forensics	NN	forensic
togolais	NN	togolai
cappella	NN	cappellum
nogai	NN	nogaus
lanisticola	NN	lanisticolum
pdci	NN	pdcus
finnis	NN	finni
fidelis	NN	fideli
lamella	NN	lamellum
r-	NN	r-_nn
daphnis	NN	daphni
ephemeris	NN	ephemeri
jacuzzis	NN	jacuzzi
janis	NN	jani
gardai	NN	gardaus
katia	NN	katium
zborowski	NN	zborowskus
demographics	NN	demographic
quia	NN	quium
haplochromis	NN	haplochromi
exempla	NN	exemplum
gironella	NN	gironellum
nobis	NN	nobi
votadini	NN	votadinus
gerardi	NN	gerardus
enterobacteria	NN	enterobacterium
well-	NN	well-_nn
miracoli	NN	miracolus
din-dins	NN	din-din
odonata	NN	odona
bairdi	NN	bairdus
phylis	NN	phyli
ceti	NN	cetus
vita-finzi	NN	vita-finzus
hyperthermia	NN	hyperthermium
grassi	NN	grassus
hola	NN	holum
etruria	NN	etrurium
burbulis	NN	burbuli
pris	NN	pri
paganini	NN	paganinus
vicini	NN	vicinus
generis	NN	generi
errata	NN	erratum
somateria	NN	somaterium
pectoralis	NN	pectorali
foulis	NN	fouli
bps	NN	bp
jenni	NN	jennus
salvinia	NN	salvinium
same-lamborghini	NN	same-lamborghinus
colloquia	NN	colloquium
kempis	NN	kempi
astrantia	NN	astrantium
chapattis	NN	chapatti
stephanotis	NN	stephanoti
scuti	NN	scutus
sulawesi	NN	sulawesus
tenuis	NN	tenui
spheris	NN	spheri
paniculata	NN	panicula
pease	NN	pea
aquilegia	NN	aquilegium
suragai	NN	suragaus
pleura	NN	pleuron
praevia	NN	praevium
syconia	NN	syconium
persepolis	NN	persepoli
carabinieri	NN	carabinierus
imbricata	NN	imbrica
alfieri	NN	alfierus
scholastics	NN	scholastic
astoria	NN	astorium
dayis	NN	dayi
post-	NN	post-_nn
bia	NN	bium
khafji	NN	khafjus
t-	NN	t-_nn
trachomatis	NN	trachomati
arazi	NN	arazus
antis	NN	anti
agrostis	NN	agrosti
potentia	NN	potentium
irreligion	NN	religion
auriculata	NN	auricula
m-	NN	m-_nn
mrs	NN	mr
bacteriuria	NN	bacteriurium
taki	NN	takus
distastefulness	NN	tastefulness
carmella	NN	carmellum
tritonis	NN	tritoni
aberdulais	NN	aberdulai
unit/module	NN	it/module
capitula	NN	capitulum
right-	NN	right-_nn
cineraria	NN	cinerarium
patria	NN	patrium
capillaris	NN	capillari
aporia	NN	aporium
girgis	NN	girgi
disc-jockey	NN	c-jockey
dannii	NN	dannius
al-makrizi	NN	al-makrizus
capella	NN	capellum
on-	NN	on-_nn
sakata	NN	saka
scagliola	NN	scagliolum
atresia	NN	atresium
jimi	NN	jimus
hautbois	NN	hautboi
inside-right	NN	side-right
single-	NN	single-_nn
in-	NN	in-_nn
commedia	NN	commedium
ghia	NN	ghium
wingti	NN	wingtus
angiodysplasia	NN	angiodysplasium
favela	NN	favelum
nobilis	NN	nobili
holla	NN	hollum
diodati	NN	diodatus
madras	NN	madra
stubbs	NN	stubb
ophiopristis	NN	ophiopristi
felis	NN	feli
genitalis	NN	genitali
bulla	NN	bullum
tacis	NN	taci
alicia	NN	alicium
pudenda	NN	pudendum
bufi	NN	bufus
pc-dos	NN	pc-do
lenis	NN	leni
sonia	NN	sonium
chest-of-drawers	NN	chest-of-drawer
chamomilla	NN	chamomillum
ashi	NN	ashus
aculeata	NN	aculea
glia	NN	glium
off-sales	NN	off-sale
yeremi	NN	yeremus
spahis	NN	spahi
judicata	NN	judica
incunabula	NN	incunabulum
gis	NN	gi
cellini	NN	cellinus
aethis	NN	aethi
animatronics	NN	animatronic
tibesti	NN	tibestus
attis	NN	atti
lymphocystis	NN	lymphocysti
congolais	NN	congolai
epididymis	NN	epididymi
shoshoni	NN	shoshonus
to-	NN	to-_nn
simulacra	NN	simulacrum
anis	NN	ani
maculata	NN	macula
trevi	NN	trevus
metadata	NN	metada
pirelli	NN	pirellus
rla	NN	rlum
svengali	NN	svengalus
fifty-	NN	fifty-_nn
paralympics	NN	paralympic
fibromyalgia	NN	fibromyalgium
ga-	NN	ga-_nn
decision-	NN	decision-_nn
normoalbuminuria	NN	normoalbuminurium
dis-equilibrium	NN	-equilibrium
amphibia	NN	amphibium
tricia	NN	tricium
mandala	NN	mandalum
hui	NN	huus
bmi	NN	bmus
pieris	NN	pieri
problematics	NN	problematic
gentilis	NN	gentili
botanics	NN	botanic
osteomata	NN	osteoma
chyluria	NN	chylurium
cryptosporidia	NN	cryptosporidium
quadrimaculata	NN	quadrimacula
glycosuria	NN	glycosurium
nidri	NN	nidrus
reprographics	NN	reprographic
bpi	NN	bpus
ruritania	NN	ruritanium
albuminuria	NN	albuminurium
reticulata	NN	reticula
hominis	NN	homini
al-hariri	NN	al-harirus
occidentalis	NN	occidentali
cs-	NN	cs-_nn
heterophylla	NN	heterophyllum
concordia	NN	concordium
alesi	NN	alesus
flexi	NN	flexus
regia	NN	regium
ecori	NN	ecorus
thirty-	NN	thirty-_nn
macro-	NN	macro-_nn
momenta	NN	momentum
aplysia	NN	aplysium
catuvellauni	NN	catuvellaunus
catalonia	NN	catalonium
you-	NN	you-_nn
akroteria	NN	akroterium
predella	NN	predellum
parousia	NN	parousium
scylla	NN	scyllum
boltanski	NN	boltanskus
halfpence	NN	halfpenny
saffi	NN	saffus
punctata	NN	puncta
anaphylaxis	NN	anaphylaxi
abruzzi	NN	abruzzus
computer-	NN	computer-_nn
tgf-	NN	tgf-_nn
sufi	NN	sufus
perugia	NN	perugium
amazonia	NN	amazonium
discoth?que	NN	coth?que
chromis	NN	chromi
y-	NN	y-_nn
dmitri	NN	dmitrus
marcia	NN	marcium
damianis	NN	damiani
euphorbia	NN	euphorbium
salieri	NN	salierus
multi-	NN	multi-_nn
zaria	NN	zarium
hypochlorhydria	NN	hypochlorhydrium
octantis	NN	octanti
rata	NN	ra
technopolis	NN	technopoli
microeconomics	NN	microeconomic
barberini	NN	barberinus
viscontis	NN	visconti
archaebacteria	NN	archaebacterium
gioella	NN	gioellum
bsi	NN	bsus
yemeni	NN	yemenus
scaevola	NN	scaevolum
gerais	NN	gerai
annulii	NN	annulius
suki	NN	sukus
dyspraxia	NN	dyspraxium
manuela	NN	manuelum
mercanti	NN	mercantus
hemianopia	NN	hemianopium
al-hithi	NN	al-hithus
bangladeshi	NN	bangladeshus
shastri	NN	shastrus
iniki	NN	inikus
communis	NN	communi
unlikeliness	NN	likeliness
stola	NN	stolum
metuji	NN	metujus
iata	NN	ia
head-quarters	NN	head-quarter
mosambiki	NN	mosambikus
possidendi	NN	possidendus
mundi	NN	mundus
arussi	NN	arussus
felici	NN	felicus
hi-	NN	hi-_nn
csi	NN	csus
cygni	NN	cygnus
acuminata	NN	acumina
ampullaria	NN	ampullarium
fai	NN	faus
lazaris	NN	lazari
dani	NN	danus
humilis	NN	humili
ghi	NN	ghus
tabla	NN	tablum
mkhedrioni	NN	mkhedrionus
synthetics	NN	synthetic
cfi	NN	cfus
relais	NN	relai
powis	NN	powi
irgun	NN	gun
chalais	NN	chalai
caligula	NN	caligulum
mammalia	NN	mammalium
kuwaiti	NN	kuwaitus
pulmonaria	NN	pulmonarium
bagi	NN	bagus
joni	NN	jonus
time-	NN	time-_nn
pdp-	NN	pdp-_nn
filaria	NN	filarium
metrics	NN	metric
collembola	NN	collembolum
piscis	NN	pisci
derbi	NN	derbus
black-	NN	black-_nn
al-sanusi	NN	al-sanusus
melia	NN	melium
portuguese-	NN	portuguese-_nn
subulata	NN	subula
vibroseis	NN	vibrosei
guarani	NN	guaranus
clovis	NN	clovi
0(0)--	NN	0(0)--_nn
gomis	NN	gomi
spiralis	NN	spirali
orionis	NN	orioni
macrophylla	NN	macrophyllum
gamsakhurdia	NN	gamsakhurdium
gaia	NN	gaium
annunciata	NN	annuncia
rizla	NN	rizlum
unkiar-skelessi	NN	kiar-skelessus
intime	NN	time
hypomania	NN	hypomanium
intron/exon	NN	tron/exon
louis	NN	loui
ecclesia	NN	ecclesium
gabrieli	NN	gabrielus
tortellini	NN	tortellinus
virginia	NN	virginium
shanti	NN	shantus
solanki	NN	solankus
signore	NN	signora
iron-founder	NN	on-founder
it-	NN	it-_nn
sella	NN	sellum
systematics	NN	systematic
vila	NN	vilum
kocinski	NN	kocinskus
vihuela	NN	vihuelum
homunculi	NN	homunculus
calendula	NN	calendulum
boulonnais	NN	boulonnai
md-dos	NN	md-do
bula	NN	bulum
megalopolis	NN	megalopoli
zis	NN	zi
themis	NN	themi
oppositifolia	NN	oppositifolium
language-	NN	language-_nn
siii	NN	siius
vadinamia	NN	vadinamium
dysphasia	NN	dysphasium
but-	NN	but-_nn
krishnamurti	NN	krishnamurtus
al-islami	NN	al-islamus
seventy-	NN	seventy-_nn
angeli	NN	angelus
frcs	NN	frc
oki	NN	okus
phragmata	NN	phragma
regazzoni	NN	regazzonus
horatia	NN	horatium
canaria	NN	canarium
twelfth-	NN	twelfth-_nn
mortadella	NN	mortadellum
n-joi	NN	n-jous
patti	NN	pattus
unidata	NN	unida
non-japanese	NN	non-japanese
pusilla	NN	pusillum
agatis	NN	agati
moais	NN	moai
fenestralis	NN	fenestrali
cerruti	NN	cerrutus
tigris	NN	tigri
ri-	NN	ri-_nn
p-	NN	p-_nn
schiaparelli	NN	schiaparellus
autumnalis	NN	autumnali
inst.	NN	st.
cinzia	NN	cinzium
s0(0)--	NN	s0(0)--_nn
that-	NN	that-_nn
omni	NN	omnus
lineata	NN	linea
notata	NN	nota
charollais	NN	charollai
portia	NN	portium
salmi	NN	salmus
ten-	NN	ten-_nn
mimi	NN	mimus
moratoria	NN	moratorium
skimmia	NN	skimmium
chatichai	NN	chatichaus
latifolia	NN	latifolium
bsri	NN	bsrus
eds-gfi	NN	eds-gfus
tilapia	NN	tilapium
meso-	NN	meso-_nn
india	NN	indium
gramsci	NN	gramscus
florakis	NN	floraki
herbaria	NN	herbarium
amarilis	NN	amarili
hopi	NN	hopus
citronella	NN	citronellum
marianella	NN	marianellum
dla	NN	dlum
intrinsics	NN	intrinsic
albini	NN	albinus
burzoi	NN	burzous
al-fenari	NN	al-fenarus
decis	NN	deci
nambudiri	NN	nambudirus
brunelleschi	NN	brunelleschus
midi	NN	midus
acris	NN	acri
kis	NN	ki
tuttis	NN	tutti
chata	NN	cha
amalfi	NN	amalfus
fms	NN	fm
jatis	NN	jati
civics	NN	civic
madani	NN	madanus
auditoria	NN	auditorium
veris	NN	veri
syncordia	NN	syncordium
adai	NN	adaus
theoria	NN	theorium
rekhi	NN	rekhus
iron-containing	NN	on-containing
marilla	NN	marillum
sabraxis	NN	sabraxi
euro-mps	NN	euro-mp
escherichia	NN	escherichium
tutsi	NN	tutsus
quadrata	NN	quadra
garonnais	NN	garonnai
republicii	NN	republicius
raji	NN	rajus
rostrata	NN	rostra
fontanellatesi	NN	fontanellatesus
flics	NN	flic
co-	NN	co-_nn
ophiactis	NN	ophiacti
moderati	NN	moderatus
orris	NN	orri
ophiomitrella	NN	ophiomitrellum
covia	NN	covium
under-utilisation	NN	der-utilisation
rildia	NN	rildium
opercularis	NN	operculari
al-hussaini	NN	al-hussainus
make-	NN	make-_nn
klebsiella	NN	klebsiellum
kauai	NN	kauaus
thetis	NN	theti
pneumophila	NN	pneumophilum
tenth-	NN	tenth-_nn
impro	NN	pro
e-data	NN	e-datum
lewis	NN	lewi
socata	NN	soca
hydri	NN	hydrus
brancusi	NN	brancusus
demontis	NN	demonti
gsi	NN	gsus
encylopedia	NN	encylopedium
omnis	NN	omni
baglioni	NN	baglionus
squadriglia	NN	squadriglium
re-	NN	re-_nn
basmati	NN	basmatus
echinata	NN	echina
tfiiia	NN	tfiium
word-	NN	word-_nn
botrytis	NN	botryti
calabria	NN	calabrium
eridani	NN	eridanus
otalgia	NN	otalgium
al-umari	NN	al-umarus
pedunculata	NN	peduncula
carinthia	NN	carinthium
sakti	NN	saktus
diptheria	NN	diptherium
similis	NN	simili
miki	NN	mikus
ths	NN	th
hci	NN	hcus
dieffenbachia	NN	dieffenbachium
vestigia	NN	vestigium
schematics	NN	schematic
irish-american	NN	ish-american
nula	NN	nulum
rvi	NN	rvus
ultimata	NN	ultimatum
gia	NN	gium
britomartis	NN	britomarti
normski	NN	normskus
al-mahdi	NN	al-mahdus
moschata	NN	moscha
mahala	NN	mahalum
parmigiani	NN	parmigianus
indwelling	NN	dwelling
valhalla	NN	valhallum
osi	NN	osus
home-	NN	home-_nn
sixth-	NN	sixth-_nn
erotics	NN	erotic
hypokinesia	NN	hypokinesium
sagittarii	NN	sagittarius
nivalis	NN	nivali
sessilis	NN	sessili
hermia	NN	hermium
al-aksarayi	NN	al-aksarayus
draconis	NN	draconi
anaesthaesia	NN	anaesthaesium
levis	NN	levi
elli	NN	ellus
sterna	NN	sternum
intermagnetics	NN	intermagnetic
al-zawi	NN	al-zawus
cni	NN	cnus
kx-p0i	NN	kx-p0us
consularis	NN	consulari
squamata	NN	squama
rossi	NN	rossus
loti	NN	lotus
biraderi	NN	biraderus
boiotia	NN	boiotium
ashrawi	NN	ashrawus
war-	NN	war-_nn
agnelli	NN	agnellus
stennis	NN	stenni
condylomata	NN	condyloma
godetia	NN	godetium
non-excludability	NN	non-excludability
akai	NN	akaus
microdata	NN	microda
camelia	NN	camelium
xapuri	NN	xapurus
mesembria	NN	mesembrium
lucchesi	NN	lucchesus
dettori	NN	dettorus
prosignia	NN	prosignium
anpetuwi	NN	anpetuwus
coatis	NN	coati
museveni	NN	musevenus
callanetics	NN	callanetic
venturini	NN	venturinus
cellinis	NN	cellini
disequilibria	NN	equilibrium
angustifolia	NN	angustifolium
berenyi	NN	berenyus
tympana	NN	tympanum
hospitia	NN	hospitium
bronze-	NN	bronze-_nn
sidacai	NN	sidacaus
dhobis	NN	dhobi
bi	NN	bus
fungi	NN	fungus
fii	NN	fius
vallisneria	NN	vallisnerium
montini	NN	montinus
sessions.	NN	session.
set-	NN	set-_nn
nai	NN	naus
destefani	NN	destefanus
and-	NN	and-_nn
bresaola	NN	bresaolum
galleria	NN	gallerium
kosi	NN	kosus
kalfelis	NN	kalfeli
agraphia	NN	agraphium
tertulia	NN	tertulium
bois	NN	boi
malachi	NN	malachus
karoui	NN	karouus
teradata	NN	terada
chemics	NN	chemic
semi-deserts.	NN	semi-desert.
afropithecini	NN	afropithecinus
tinctoria	NN	tinctorium
aleuadai	NN	aleuadaus
c-	NN	c-_nn
0cals	NN	0cal
ternata	NN	terna
monis	NN	moni
neurosyphilis	NN	neurosyphili
pavonis	NN	pavoni
zanussi	NN	zanussus
tala	NN	talum
labidochromis	NN	labidochromi
ecotopia	NN	ecotopium
you--	NN	you--_nn
elis	NN	eli
hyperalgesia	NN	hyperalgesium
sixty-	NN	sixty-_nn
alkmaionidai	NN	alkmaionidaus
kaposi	NN	kaposus
gaddafi	NN	gaddafus
minifundia	NN	minifundium
non-justiciability	NN	non-justiciability
gc-ms	NN	gc-m
horribilis	NN	horribili
clelia	NN	clelium
tula	NN	tulum
difformis	NN	difformi
market-	NN	market-_nn
her-	NN	her-_nn
microviewdata	NN	microviewda
sola	NN	solum
mattli	NN	mattlus
horchata	NN	horcha
capriati	NN	capriatus
ratafia	NN	ratafium
whoopi	NN	whoopus
yousefi	NN	yousefus
nia	NN	nium
dyspareunia	NN	dyspareunium
hagi	NN	hagus
glacialis	NN	glaciali
peripatetics	NN	peripatetic
rossetti	NN	rossettus
double-	NN	double-_nn
me--	NN	me--_nn
saskia	NN	saskium
agoutis	NN	agouti
dulais	NN	dulai
water-	NN	water-_nn
kenyapithecini	NN	kenyapithecinus
ulmaria	NN	ulmarium
michaela	NN	michaelum
margi	NN	margus
chatchai	NN	chatchaus
gandini	NN	gandinus
geometrics	NN	geometric
via	NN	vium
to--	NN	to--_nn
pro-rata	NN	pro-ra
zola	NN	zolum
dilatata	NN	dilata
damiani	NN	damianus
vlci	NN	vlcus
geodesics	NN	geodesic
polyfilla	NN	polyfillum
santorini	NN	santorinus
aubretia	NN	aubretium
paraesthesia	NN	paraesthesium
aromatics	NN	aromatic
dziekanowski	NN	dziekanowskus
ammophila	NN	ammophilum
julidochromis	NN	julidochromi
miletti	NN	milettus
pectinata	NN	pectina
campestris	NN	campestri
tyminski	NN	tyminskus
anastasia	NN	anastasium
lunia	NN	lunium
gaviria	NN	gavirium
francia	NN	francium
skandia	NN	skandium
dyskinesia	NN	dyskinesium
calcia	NN	calcium
leoni	NN	leonus
socioeconomics	NN	socioeconomic
lrcs	NN	lrc
gcds	NN	gcd
arcadia	NN	arcadium
al-zahrani	NN	al-zahranus
domatia	NN	domatium
pestis	NN	pesti
substantia	NN	substantium
rella	NN	rellum
adela	NN	adelum
blinis	NN	blini
optoelectronics	NN	optoelectronic
fasciculata	NN	fascicula
echolalia	NN	echolalium
vacantia	NN	vacantium
biodata	NN	bioda
combinatorics	NN	combinatoric
sunpics	NN	sunpic
mirabilis	NN	mirabili
herculis	NN	herculi
simla	NN	simlum
seticornis	NN	seticorni
tessellata	NN	tessella
civitatis	NN	civitati
stationeri	NN	stationerus
high-	NN	high-_nn
pluvialis	NN	pluviali
fluidics	NN	fluidic
clemenciae	NN	clemencia
incurring	NN	curring
g-orgi	NN	g-orgus
amethi	NN	amethus
mollicomata	NN	mollicoma
afewerki	NN	afewerkus
kuoni	NN	kuonus
talionis	NN	talioni
frascati	NN	frascatus
focaccia	NN	focaccium
piranesi	NN	piranesus
tageia	NN	tageium
nadia	NN	nadium
hayashi	NN	hayashus
air-	NN	air-_nn
aldaniti	NN	aldanitus
heterotopia	NN	heterotopium
poldi-pezzoli	NN	poldi-pezzolus
islandia	NN	islandium
dalmatia	NN	dalmatium
non-penetrance	NN	non-penetrance
puppis	NN	puppi
amiri	NN	amirus
marsalis	NN	marsali
half-	NN	half-_nn
bli	NN	blus
subtropics	NN	subtropic
macrotrichia	NN	macrotrichium
alkmeonidai	NN	alkmeonidaus
accomplis	NN	accompli
tms	NN	tm
frejji	NN	frejjus
rni	NN	rnus
benji	NN	benjus
rtpi	NN	rtpus
avia	NN	avium
khmelnitski	NN	khmelnitskus
bevis	NN	bevi
clapotis	NN	clapoti
?0-	NN	?0-_nn
guzzi	NN	guzzus
eranthis	NN	eranthi
grenadilla	NN	grenadillum
dogmatics	NN	dogmatic
yoi	NN	yous
wt-	NN	wt-_nn
mesopotamia	NN	mesopotamium
glochidia	NN	glochidium
meltemi	NN	meltemus
cenci	NN	cencus
damyata	NN	damya
psychics	NN	psychic
gortari	NN	gortarus
inside-left	NN	side-left
trangia	NN	trangium
be-	NN	be-_nn
sorabi	NN	sorabus
geis	NN	gei
visconti	NN	viscontus
cali	NN	calus
ossmodula	NN	ossmodulum
cervicornis	NN	cervicorni
chapatis	NN	chapati
u-	NN	u-_nn
sensilla	NN	sensillum
sea-	NN	sea-_nn
cps	NN	cp
hypermnesia	NN	hypermnesium
forty-	NN	forty-_nn
kanchelskis	NN	kanchelski
wyvis	NN	wyvi
optronics	NN	optronic
cremonini	NN	cremoninus
superminis	NN	supermini
butteris	NN	butteri
ventralis	NN	ventrali
avai-bamhi	NN	avai-bamhus
morula	NN	morulum
assegais	NN	assegai
dolcis	NN	dolci
ennis	NN	enni
sanusi	NN	sanusus
efi	NN	efus
gastrula	NN	gastrulum
gabrielli	NN	gabriellus
afghani	NN	afghanus
fabalis	NN	fabali
v-	NN	v-_nn
moussavi	NN	moussavus
previa	NN	previum
dobunni	NN	dobunnus
aluaudi	NN	aluaudus
zenobia	NN	zenobium
laski	NN	laskus
kigoi	NN	kigous
terminalis	NN	terminali
uri	NN	urus
b-	NN	b-_nn
fapla	NN	faplum
updata	NN	upda
videopics	NN	videopic
eleventh-	NN	eleventh-_nn
ascetics	NN	ascetic
camerata	NN	camera
fab-ms	NN	fab-m
allata	NN	alla
sense-data	NN	sense-datum
karamanlis	NN	karamanli
curoi	NN	curous
aquileia	NN	aquileium
heuristics	NN	heuristic
cpki	NN	cpkus
principalis	NN	principali
anthelmintics	NN	anthelmintic
leptospicularis	NN	leptospiculari
andalusia	NN	andalusium
harakiri	NN	harakirus
vimla	NN	vimlum
confidence-	NN	confidence-_nn
liberata	NN	libera
macrocephala	NN	macrocephalum
dryopithecini	NN	dryopithecinus
hindustani	NN	hindustanus
beri-beri	NN	beri-berus
wistaria	NN	wistarium
ascaridia	NN	ascaridium
0mms	NN	0mm
clangula	NN	clangulum
nigriventris	NN	nigriventri
shadrokh-cigari	NN	shadrokh-cigarus
riia	NN	rium
eighty-	NN	eighty-_nn
skoupidia	NN	skoupidium
corydalis	NN	corydali
scarlatti	NN	scarlattus
eye-	NN	eye-_nn
axilla	NN	axillum
colonia	NN	colonium
killmoulis	NN	killmouli
matris	NN	matri
laudi	NN	laudus
lanoptics	NN	lanoptic
degree_angle	NN	degree
cadenabbia	NN	cadenabbium
kurunagala	NN	kurunagalum
misrati	NN	misratus
meleagris	NN	meleagri
chest--	NN	chest--_nn
pinnata	NN	pinna
calceolaria	NN	calceolarium
salmagundi	NN	salmagundus
akagi	NN	akagus
rutli	NN	rutlus
birth-	NN	birth-_nn
ajayi	NN	ajayus
psychedelics	NN	psychedelic
horla	NN	horlum
chauthala	NN	chauthalum
synergia	NN	synergium
godzilla	NN	godzillum
bedelia	NN	bedelium
iti	NN	itus
dhani	NN	dhanus
turania	NN	turanium
owsla	NN	owslum
tiki	NN	tikus
phyllisia	NN	phyllisium
heterakis	NN	heteraki
flokati	NN	flokatus
al-ajami	NN	al-ajamus
ambulia	NN	ambulium
nabi	NN	nabus
kapuscinski	NN	kapuscinskus
jci	NN	jcus
this.	NN	thi.
under-capitalisation	NN	der-capitalisation
memoria	NN	memorium
iron-founding	NN	on-founding
snow-	NN	snow-_nn
-n-	NN	-n-_nn
naris	NN	nari
olympia	NN	olympium
varicella	NN	varicellum
pollinia	NN	pollinium
ansorgei	NN	ansorgeus
cambrai	NN	cambraus
savini	NN	savinus
ridi	NN	ridus
aniridia	NN	aniridium
lampi	NN	lampus
mbuji-mayi	NN	mbuji-mayus
eltis	NN	elti
amphipolis	NN	amphipoli
brescia	NN	brescium
part-	NN	part-_nn
kola	NN	kolum
ostia	NN	ostium
vsi	NN	vsus
milla	NN	millum
massi	NN	massus
bonomi	NN	bonomus
prunella	NN	prunellum
philippi	NN	philippus
pellegrini	NN	pellegrinus
gerousia	NN	gerousium
magnetics	NN	magnetic
non-sequitur	NN	non-sequitur
tuzla	NN	tuzlum
house-	NN	house-_nn
gesophola	NN	gesopholum
grazia	NN	grazium
stapelia	NN	stapelium
varela	NN	varelum
sancta	NN	sanctum
cordia	NN	cordium
limnophila	NN	limnophilum
alpha-	NN	alpha-_nn
mannaia	NN	mannaium
grain-	NN	grain-_nn
bheki	NN	bhekus
windows-	NN	windows-_nn
parapraxis	NN	parapraxi
nabis	NN	nabi
choi	NN	chous
mechatronics	NN	mechatronic
of--	NN	of--_nn
islami	NN	islamus
attila	NN	attilum
tremula	NN	tremulum
sartori	NN	sartorus
neftis	NN	nefti
politricks	NN	politrick
meis	NN	mei
cwis	NN	cwi
policy-	NN	policy-_nn
harris	NN	harri
alpini	NN	alpinus
terentia	NN	terentium
solaas	NN	solaa
aquila	NN	aquilum
vulpis	NN	vulpi
christmas-	NN	christmas-_nn
pianola	NN	pianolum
teri	NN	terus
picti	NN	pictus
tauri	NN	taurus
sarfati	NN	sarfatus
this-	NN	this-_nn
heteractis	NN	heteracti
tazmania	NN	tazmanium
regini	NN	reginus
0sts	NN	0st
nonni	NN	nonnus
tandri	NN	tandrus
mancarelli	NN	mancarellus
opt-	NN	opt-_nn
pni	NN	pnus
galla	NN	gallum
grolla	NN	grollum
basenji	NN	basenjus
geodemographics	NN	geodemographic
nefertiti	NN	nefertitus
orinthia	NN	orinthium
anubis	NN	anubi
premmia	NN	premmium
montbretia	NN	montbretium
kinsella	NN	kinsellum
parataxis	NN	parataxi
acetosella	NN	acetosellum
monti	NN	montus
fruitella	NN	fruitellum
nigella	NN	nigellum
waikiki	NN	waikikus
walpurgis	NN	walpurgi
microsporidia	NN	microsporidium
smds	NN	smd
maui	NN	mauus
yella	NN	yellum
camerounais	NN	camerounai
fermata	NN	ferma
al-sayrafi	NN	al-sayrafus
sulphuris	NN	sulphuri
dvs	NN	dv
ink-blot	NN	k-blot
annorexia	NN	annorexium
precaria	NN	precarium
potnia	NN	potnium
me-	NN	me-_nn
fibroplasia	NN	fibroplasium
electrostatics	NN	electrostatic
0-0-0-	NN	0-0-0-_nn
mehri	NN	mehrus
takahashi	NN	takahashus
wide-	NN	wide-_nn
beventini	NN	beventinus
frari	NN	frarus
suristani	NN	suristanus
parvifolia	NN	parvifolium
life-	NN	life-_nn
acaulis	NN	acauli
bronchopneumonia	NN	bronchopneumonium
dimitri	NN	dimitrus
velupillai	NN	velupillaus
dubois	NN	duboi
semiramis	NN	semirami
syrimis	NN	syrimi
russia	NN	russium
olbia	NN	olbium
tpi	NN	tpus
qataris	NN	qatari
al-sharifi	NN	al-sharifus
meta-ethics	NN	meta-ethic
gratia	NN	gratium
arbitrators.	NN	arbitrator.
karunanidhi	NN	karunanidhus
hypermetropia	NN	hypermetropium
radiophysics	NN	radiophysic
xmp-api	NN	xmp-apus
trifurcata	NN	trifurca
tedris	NN	tedri
0ws	NN	0w
fourteenth-	NN	fourteenth-_nn
bcl-0-	NN	bcl-0-_nn
gimli	NN	gimlus
parorchis	NN	parorchi
con-	NN	con-_nn
paralinguistics	NN	paralinguistic
miri	NN	mirus
quais	NN	quai
leucocephala	NN	leucocephalum
environment-	NN	environment-_nn
sarai	NN	saraus
macula	NN	maculum
iiisi	NN	iiisus
nefertari	NN	nefertarus
layla	NN	laylum
d-	NN	d-_nn
meli	NN	melus
cai	NN	caus
cytogenetics	NN	cytogenetic
calcium-	NN	calcium-_nn
carracci	NN	carraccus
transavanguardia	NN	transavanguardium
telekia	NN	telekium
brandeis	NN	brandei
tahiti	NN	tahitus
claris	NN	clari
por-gilli	NN	por-gillus
legata	NN	lega
mandovi	NN	mandovus
analogia	NN	analogium
measure--	NN	measure--_nn
galaxis	NN	galaxi
seven-	NN	seven-_nn
uk-	NN	uk-_nn
synaesthesia	NN	synaesthesium
dubunni	NN	dubunnus
thermai	NN	thermaus
similia	NN	similium
dish-washer	NN	h-washer
shusui	NN	shusuus
ki	NN	kus
marcella	NN	marcellum
mizumaki	NN	mizumakus
ravi	NN	ravus
child-	NN	child-_nn
acemi	NN	acemus
retrospiralis	NN	retrospirali
danieli	NN	danielus
jamarella	NN	jamarellum
cardinalis	NN	cardinali
perithecia	NN	perithecium
glennis	NN	glenni
harmonia	NN	harmonium
heteroglossia	NN	heteroglossium
rubis	NN	rubi
gadaffi	NN	gadaffus
paheri	NN	paherus
charismatics	NN	charismatic
cedi	NN	cedus
cuspidata	NN	cuspida
traumata	NN	trauma
cecropia	NN	cecropium
bamhi	NN	bamhus
habilis	NN	habili
nicolli	NN	nicollus
indie/dance	NN	die/dance
rdbms	NN	rdbm
manzanilla	NN	manzanillum
ze'evi	NN	ze'evus
chia	NN	chium
radian_angle	NN	radian
graft-	NN	graft-_nn
integrifolia	NN	integrifolium
cti	NN	ctus
ajami	NN	ajamus
fontana-silvestri	NN	fontana-silvestrus
al-iryani	NN	al-iryanus
wrestlemania	NN	wrestlemanium
dastmalchi	NN	dastmalchus
telangiectasia	NN	telangiectasium
acis	NN	aci
ashanti	NN	ashantus
ohmachi	NN	ohmachus
melancia	NN	melancium
prosopopoeia	NN	prosopopoeium
thingi	NN	thingus
ironer	NN	oner
income-related	NN	come-related
dover-calais	NN	dover-calai
scorpii	NN	scorpius
kirghizia	NN	kirghizium
agrestis	NN	agresti
faris	NN	fari
mursi	NN	mursus
gula	NN	gulum
tournai	NN	tournaus
passata	NN	passa
off-	NN	off-_nn
militaris	NN	militari
icai	NN	icaus
bernicla	NN	berniclum
euphrasia	NN	euphrasium
travois	NN	travoi
hypersomnia	NN	hypersomnium
corelli	NN	corellus
ela	NN	elum
boscareccia	NN	boscareccium
vasari	NN	vasarus
abdominis	NN	abdomini
annunziata	NN	annunzia
hand-	NN	hand-_nn
fls.	NN	fl.
charivari	NN	charivarus
lcci	NN	lccus
vocalis	NN	vocali
pendennis	NN	pendenni
iid-affi	NN	iid-affus
rosaefolia	NN	rosaefolium
dowlais	NN	dowlai
plasmodia	NN	plasmodium
bulli	NN	bullus
martia	NN	martium
plena	NN	plenum
godchildren	NN	godchild
dali	NN	dalus
ulomi	NN	ulomus
heis	NN	hei
pitti	NN	pittus
glabella	NN	glabellum
arthralgia	NN	arthralgium
timi	NN	timus
arghuri	NN	arghurus
meta-data	NN	meta-datum
sacambambaspis	NN	sacambambaspi
dysautonomia	NN	dysautonomium
rai	NN	raus
spongia	NN	spongium
genii	NN	genie
inkey	NN	key
homo-	NN	homo-_nn
leishmania	NN	leishmanium
majella	NN	majellum
ambasciatori	NN	ambasciatorus
hayama-machi	NN	hayama-machus
staphisagria	NN	staphisagrium
cercaria	NN	cercarium
chattri	NN	chattrus
gujarati	NN	gujaratus
vibrola	NN	vibrolum
scarponis	NN	scarponi
for-	NN	for-_nn
crescendi	NN	crescendo
golgi	NN	golgus
al-uzaizi	NN	al-uzaizus
maggi	NN	maggus
chela	NN	chelum
non-interventionism	NN	non-interventionism
inn-door	NN	n-door
senoi	NN	senous
volumnia	NN	volumnium
julii	NN	julius
mascis	NN	masci
malfi	NN	malfus
hygienics	NN	hygienic
monocerotis	NN	monoceroti
not-	NN	not-_nn
'tis	NN	'ti
pick-	NN	pick-_nn
domitila	NN	domitilum
dioscuri	NN	dioscurus
barzani	NN	barzanus
webi	NN	webus
cumbria	NN	cumbrium
.0-	NN	.0-_nn
caravanserais	NN	caravanserai
gloria	NN	glorium
gilleis	NN	gillei
al-jaburi	NN	al-jaburus
botticelli	NN	botticellus
all-	NN	all-_nn
eucomis	NN	eucomi
orchis	NN	orchi
anophthalmia	NN	anophthalmium
gaillardia	NN	gaillardium
amicitia	NN	amicitium
insider/ethnographer	NN	sider/ethnographer
bach-busoni	NN	bach-busonus
ex-	NN	ex-_nn
marinetti	NN	marinettus
mokai	NN	mokaus
qi	NN	qus
disaster'	NN	aster'
mandorla	NN	mandorlum
lni	NN	lnus
cyclothymia	NN	cyclothymium
kon-tiki	NN	kon-tikus
tris	NN	tri
rbis	NN	rbi
juris	NN	juri
s-	NN	s-_nn
charentais	NN	charentai
ex-formula	NN	ex-formulum
top-	NN	top-_nn
hypoplasia	NN	hypoplasium
quarters	NN	quarter
beneficia	NN	beneficium
ch-	NN	ch-_nn
poleis	NN	polei
realia	NN	realium
pozzuoli	NN	pozzuolus
ascaris	NN	ascari
bravais	NN	bravai
iroquois	NN	iroquoi
walvis	NN	walvi
of-	NN	of-_nn
giureconsulti	NN	giureconsultus
exotics	NN	exotic
morais	NN	morai
yamaichi	NN	yamaichus
gelli	NN	gellus
ciliata	NN	cilia
mapinduzi	NN	mapinduzus
tania	NN	tanium
bhagwati	NN	bhagwatus
chapati	NN	chapatus
glissandi	NN	glissando
coprophagia	NN	coprophagium
eglanteria	NN	eglanterium
omi	NN	omus
fifteenth-	NN	fifteenth-_nn
valais	NN	valai
smla	NN	smlum
discordia	NN	discordium
aristata	NN	arista
non-jew	NN	non-jew
------	NN	------_nn
is0-	NN	is0-_nn
bartolinis	NN	bartolini
sztuki	NN	sztukus
yamaguchi	NN	yamaguchus
sedilia	NN	sedilium
di-	NN	di-_nn
male-	NN	male-_nn
rhizobia	NN	rhizobium
lamentabili	NN	lamentabilus
epistaxis	NN	epistaxi
lacustris	NN	lacustri
colibri	NN	colibrus
ystradgynlais	NN	ystradgynlai
yoshi	NN	yoshus
favola	NN	favolum
ink-pad	NN	k-pad
apricaria	NN	apricarium
gongylidia	NN	gongylidium
itis	NN	iti
interferon-	NN	interferon-_nn
sipotai	NN	sipotaus
dlrs	NN	dlr
mausolea	NN	mausoleum
unit-linked	NN	it-linked
death-	NN	death-_nn
erythrai	NN	erythraus
shebeli	NN	shebelus
melzi	NN	melzus
osteomalacia	NN	osteomalacium
artemesia	NN	artemesium
melanochromis	NN	melanochromi
pla	NN	plum
blue-	NN	blue-_nn
zsofia	NN	zsofium
impaler	NN	paler
areata	NN	area
nella	NN	nellum
naggarothi	NN	naggarothus
oculis	NN	oculi
fifth-	NN	fifth-_nn
accutronics	NN	accutronic
fazisi	NN	fazisus
pileri	NN	pilerus
amentia	NN	amentium
tuxis	NN	tuxi
miramalfi	NN	miramalfus
cd0-	NN	cd0-_nn
promis	NN	promi
lexia	NN	lexium
mrpii	NN	mrpius
differentia	NN	differentium
duty-	NN	duty-_nn
kdpi	NN	kdpus
student-	NN	student-_nn
hypochlorrhydria	NN	hypochlorrhydrium
polygala	NN	polygalum
al-baghli	NN	al-baghlus
tricyclics	NN	tricyclic
delphini	NN	delphinus
sanatoria	NN	sanatorium
reni	NN	renus
dmowski	NN	dmowskus
type-	NN	type-_nn
never-	NN	never-_nn
dezotti	NN	dezottus
kalmia	NN	kalmium
spanish-	NN	spanish-_nn
renascia	NN	renascium
sybaris	NN	sybari
white-	NN	white-_nn
flavirostris	NN	flavirostri
villanella	NN	villanellum
settis	NN	setti
akpata	NN	akpa
unlikeness	NN	likeness
kirkella	NN	kirkellum
mini-	NN	mini-_nn
fata	NN	fa
incarnata	NN	incarna
ego-	NN	ego-_nn
more-	NN	more-_nn
old-	NN	old-_nn
rivoli	NN	rivolus
END_OF_NN

if ( $ARGV[0] =~ /^-[ad]$/ ) {
    print $VARIOUS . $NEGATION . $NO_NEGATION . $I_US . $NNP . $NN;
}
else {
    die "Invalid usage: use option -a or -d\n";
}
