######################################################################
#
# 2227_cp00930_by_utf8.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x00"],
        ["\x01",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x01"],
        ["\x02",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x02"],
        ["\x03",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x03"],
        ["\x04",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x37"],
        ["\x05",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x2D"],
        ["\x06",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x2E"],
        ["\x07",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x2F"],
        ["\x08",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x16"],
        ["\x09",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x05"],
        ["\x0A",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x15"],
        ["\x0B",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x0B"],
        ["\x0C",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x0C"],
        ["\x0D",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x0D"],
        ["\x0E",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x0E"],
        ["\x0F",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x0F"],
        ["\x10",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x10"],
        ["\x11",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x11"],
        ["\x12",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x12"],
        ["\x13",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x13"],
        ["\x14",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x3C"],
        ["\x15",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x3D"],
        ["\x16",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x32"],
        ["\x17",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x26"],
        ["\x18",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x18"],
        ["\x19",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x19"],
        ["\x1A",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x3F"],
        ["\x1B",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x27"],
        ["\x1C",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x1C"],
        ["\x1D",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x1D"],
        ["\x1E",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x1E"],
        ["\x1F",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x1F"],
        ["\x20",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x40"],
        ["\x21",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x5A"],
        ["\x22",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x7F"],
        ["\x23",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x7B"],
        ["\x24",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xE0"],
        ["\x25",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x6C"],
        ["\x26",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x50"],
        ["\x27",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x7D"],
        ["\x28",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x4D"],
        ["\x29",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x5D"],
        ["\x2A",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x5C"],
        ["\x2B",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x4E"],
        ["\x2C",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x6B"],
        ["\x2D",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x60"],
        ["\x2E",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x4B"],
        ["\x2F",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x61"],
        ["\x30",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xF0"],
        ["\x31",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xF1"],
        ["\x32",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xF2"],
        ["\x33",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xF3"],
        ["\x34",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xF4"],
        ["\x35",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xF5"],
        ["\x36",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xF6"],
        ["\x37",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xF7"],
        ["\x38",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xF8"],
        ["\x39",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xF9"],
        ["\x3A",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x7A"],
        ["\x3B",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x5E"],
        ["\x3C",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x4C"],
        ["\x3D",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x7E"],
        ["\x3E",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x6E"],
        ["\x3F",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x6F"],
        ["\x40",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x7C"],
        ["\x41",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xC1"],
        ["\x42",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xC2"],
        ["\x43",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xC3"],
        ["\x44",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xC4"],
        ["\x45",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xC5"],
        ["\x46",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xC6"],
        ["\x47",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xC7"],
        ["\x48",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xC8"],
        ["\x49",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xC9"],
        ["\x4A",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xD1"],
        ["\x4B",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xD2"],
        ["\x4C",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xD3"],
        ["\x4D",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xD4"],
        ["\x4E",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xD5"],
        ["\x4F",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xD6"],
        ["\x50",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xD7"],
        ["\x51",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xD8"],
        ["\x52",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xD9"],
        ["\x53",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xE2"],
        ["\x54",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xE3"],
        ["\x55",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xE4"],
        ["\x56",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xE5"],
        ["\x57",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xE6"],
        ["\x58",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xE7"],
        ["\x59",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xE8"],
        ["\x5A",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xE9"],
        ["\x5B",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x70"],
        ["\x5C",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x5B"],
        ["\x5D",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x80"],
        ["\x5E",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xB0"],
        ["\x5F",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x6D"],
        ["\x60",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x79"],
        ["\x61",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x62"],
        ["\x62",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x63"],
        ["\x63",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x64"],
        ["\x64",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x65"],
        ["\x65",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x66"],
        ["\x66",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x67"],
        ["\x67",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x68"],
        ["\x68",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x69"],
        ["\x69",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x71"],
        ["\x6A",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x72"],
        ["\x6B",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x73"],
        ["\x6C",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x74"],
        ["\x6D",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x75"],
        ["\x6E",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x76"],
        ["\x6F",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x77"],
        ["\x70",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x78"],
        ["\x71",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x8B"],
        ["\x72",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x9B"],
        ["\x73",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xAB"],
        ["\x74",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xB3"],
        ["\x75",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xB4"],
        ["\x76",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xB5"],
        ["\x77",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xB6"],
        ["\x78",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xB7"],
        ["\x79",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xB8"],
        ["\x7A",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xB9"],
        ["\x7B",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xC0"],
        ["\x7C",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x4F"],
        ["\x7D",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xD0"],
        ["\x7E",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\xA0"],
        ["\x7F",'cp00930','utf8',{'INPUT_LAYOUT'=>'S'},"\x07"],
        ["\xEF\xBD\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41"],
        ["\xEF\xBD\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42"],
        ["\xEF\xBD\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43"],
        ["\xEF\xBD\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44"],
        ["\xEF\xBD\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45"],
        ["\xEF\xBD\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46"],
        ["\xEF\xBD\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47"],
        ["\xEF\xBD\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48"],
        ["\xEF\xBD\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49"],
        ["\xEF\xBD\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51"],
        ["\xEF\xBD\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52"],
        ["\xEF\xBD\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53"],
        ["\xEF\xBD\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54"],
        ["\xEF\xBD\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55"],
        ["\xEF\xBD\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56"],
        ["\xEF\xBD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58"],
        ["\xEF\xBD\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x81"],
        ["\xEF\xBD\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x82"],
        ["\xEF\xBD\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x83"],
        ["\xEF\xBD\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x84"],
        ["\xEF\xBD\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x85"],
        ["\xEF\xBD\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x86"],
        ["\xEF\xBD\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x87"],
        ["\xEF\xBD\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x88"],
        ["\xEF\xBD\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x89"],
        ["\xEF\xBD\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A"],
        ["\xEF\xBD\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C"],
        ["\xEF\xBD\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D"],
        ["\xEF\xBD\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E"],
        ["\xEF\xBD\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F"],
        ["\xEF\xBD\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x90"],
        ["\xEF\xBE\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x91"],
        ["\xEF\xBE\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x92"],
        ["\xEF\xBE\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x93"],
        ["\xEF\xBE\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x94"],
        ["\xEF\xBE\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x95"],
        ["\xEF\xBE\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x96"],
        ["\xEF\xBE\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x97"],
        ["\xEF\xBE\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x98"],
        ["\xEF\xBE\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x99"],
        ["\xEF\xBE\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A"],
        ["\xEF\xBE\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D"],
        ["\xEF\xBE\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E"],
        ["\xEF\xBE\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F"],
        ["\xEF\xBE\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2"],
        ["\xEF\xBE\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3"],
        ["\xEF\xBE\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4"],
        ["\xEF\xBE\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5"],
        ["\xEF\xBE\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6"],
        ["\xEF\xBE\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7"],
        ["\xEF\xBE\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xA8"],
        ["\xEF\xBE\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xA9"],
        ["\xEF\xBE\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xAA"],
        ["\xEF\xBE\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xAC"],
        ["\xEF\xBE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xAD"],
        ["\xEF\xBE\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xAE"],
        ["\xEF\xBE\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF"],
        ["\xEF\xBE\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA"],
        ["\xEF\xBE\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB"],
        ["\xEF\xBE\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC"],
        ["\xEF\xBE\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD"],
        ["\xEF\xBE\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE"],
        ["\xEF\xBE\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF"],
        ["\xE3\x80\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x40\x40"],
        ["\xE3\x80\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x44"],
        ["\xE3\x80\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x41"],
        ["\xEF\xBC\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x6B"],
        ["\xEF\xBC\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x4B"],
        ["\xE3\x83\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x45"],
        ["\xEF\xBC\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x7A"],
        ["\xEF\xBC\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x5E"],
        ["\xEF\xBC\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x6F"],
        ["\xEF\xBC\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x5A"],
        ["\xE3\x82\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xBE"],
        ["\xE3\x82\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xBF"],
        ["\xC2\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x50"],
        ["\xEF\xBD\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x79"],
        ["\xC2\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x60"],
        ["\xEF\xBC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x70"],
        ["\xEF\xBF\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA1"],
        ["\xEF\xBC\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x6D"],
        ["\xE3\x83\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xDC"],
        ["\xE3\x83\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xDD"],
        ["\xE3\x82\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xDC"],
        ["\xE3\x82\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xDD"],
        ["\xE3\x80\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x5B"],
        ["\xE4\xBB\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x5C"],
        ["\xE3\x80\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x5D"],
        ["\xE3\x80\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x5E"],
        ["\xE3\x80\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x5F"],
        ["\xE3\x83\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x58"],
        ["\xE2\x80\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],
        ["\xE2\x80\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x5A"],
        ["\xEF\xBC\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x61"],
        ["\xEF\xBC\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE0"],
        ["\xE3\x80\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA1"],
        ["\xE2\x88\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],
        ["\xEF\xBD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x4F"],
        ["\xE2\x80\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x7F"],
        ["\xE2\x80\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x7E"],
        ["\xE2\x80\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x61"],
        ["\xE2\x80\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x71"],
        ["\xE2\x80\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x62"],
        ["\xE2\x80\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x72"],
        ["\xEF\xBC\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x4D"],
        ["\xEF\xBC\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x5D"],
        ["\xE3\x80\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x63"],
        ["\xE3\x80\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x73"],
        ["\xEF\xBC\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x44"],
        ["\xEF\xBC\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x45"],
        ["\xEF\xBD\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC0"],
        ["\xEF\xBD\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD0"],
        ["\xE3\x80\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x64"],
        ["\xE3\x80\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x74"],
        ["\xE3\x80\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x65"],
        ["\xE3\x80\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x75"],
        ["\xE3\x80\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x42"],
        ["\xE3\x80\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x43"],
        ["\xE3\x80\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x42"],
        ["\xE3\x80\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x43"],
        ["\xE3\x80\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x66"],
        ["\xE3\x80\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x76"],
        ["\xEF\xBC\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x4E"],
        ["\xEF\xBC\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xC2\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x4B"],
        ["\xC3\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x7A"],
        ["\xC3\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x7B"],
        ["\xEF\xBC\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x7E"],
        ["\xE2\x89\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x4C"],
        ["\xEF\xBC\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x4C"],
        ["\xEF\xBC\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x6E"],
        ["\xE2\x89\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x67"],
        ["\xE2\x89\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x77"],
        ["\xE2\x88\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x4D"],
        ["\xE2\x88\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x68"],
        ["\xE2\x99\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x69"],
        ["\xE2\x99\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x79"],
        ["\xC2\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xED"],
        ["\xE2\x80\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xEE"],
        ["\xE2\x80\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xEF"],
        ["\xE2\x84\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x4E"],
        ["\xEF\xBF\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x5B"],
        ["\xEF\xBC\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE0"],
        ["\xEF\xBF\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x4A"],
        ["\xEF\xBF\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x4A"],
        ["\xEF\xBC\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x6C"],
        ["\xEF\xBC\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x7B"],
        ["\xEF\xBC\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x50"],
        ["\xEF\xBC\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x5C"],
        ["\xEF\xBC\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x7C"],
        ["\xC2\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x6A"],
        ["\xE2\x98\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE5"],
        ["\xE2\x98\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE6"],
        ["\xE2\x97\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE0"],
        ["\xE2\x97\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE1"],
        ["\xE2\x97\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE4"],
        ["\xE2\x97\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE7"],
        ["\xE2\x97\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE8"],
        ["\xE2\x96\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE9"],
        ["\xE2\x96\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xEA"],
        ["\xE2\x96\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE2"],
        ["\xE2\x96\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE3"],
        ["\xE2\x96\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xEB"],
        ["\xE2\x96\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xEC"],
        ["\xE2\x80\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x6B"],
        ["\xE3\x80\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x6C"],
        ["\xE2\x86\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xF0"],
        ["\xE2\x86\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xF1"],
        ["\xE2\x86\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xF2"],
        ["\xE2\x86\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xF3"],
        ["\xE3\x80\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\xE2\x88\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x64"],
        ["\xE2\x88\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x65"],
        ["\xE2\x8A\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x66"],
        ["\xE2\x8A\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x67"],
        ["\xE2\x8A\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x68"],
        ["\xE2\x8A\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x69"],
        ["\xE2\x88\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x6A"],
        ["\xE2\x88\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x6B"],
        ["\xE2\x88\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x6C"],
        ["\xE2\x88\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x6D"],
        ["\xEF\xBF\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x5F"],
        ["\xE2\x87\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x6E"],
        ["\xE2\x87\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x6F"],
        ["\xE2\x88\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x70"],
        ["\xE2\x88\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x71"],
        ["\xE2\x88\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x4B"],
        ["\xE2\x8A\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x4C"],
        ["\xE2\x8C\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x4D"],
        ["\xE2\x88\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x4E"],
        ["\xE2\x88\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x4F"],
        ["\xE2\x89\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x5B"],
        ["\xE2\x89\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x5C"],
        ["\xE2\x89\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x5D"],
        ["\xE2\x89\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x5E"],
        ["\xE2\x88\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x5F"],
        ["\xE2\x88\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x60"],
        ["\xE2\x88\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x61"],
        ["\xE2\x88\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x78"],
        ["\xE2\x88\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x62"],
        ["\xE2\x88\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x63"],
        ["\xE2\x84\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x72"],
        ["\xE2\x80\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x73"],
        ["\xE2\x99\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x74"],
        ["\xE2\x99\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x75"],
        ["\xE2\x99\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x76"],
        ["\xE2\x80\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x77"],
        ["\xE2\x80\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x78"],
        ["\xC2\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x79"],
        ["\xE2\x97\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x7A"],
        ["\xEF\xBC\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF0"],
        ["\xEF\xBC\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF1"],
        ["\xEF\xBC\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF2"],
        ["\xEF\xBC\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF3"],
        ["\xEF\xBC\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF4"],
        ["\xEF\xBC\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF5"],
        ["\xEF\xBC\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF6"],
        ["\xEF\xBC\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF7"],
        ["\xEF\xBC\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF8"],
        ["\xEF\xBC\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF9"],
        ["\xEF\xBC\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC1"],
        ["\xEF\xBC\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC2"],
        ["\xEF\xBC\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC3"],
        ["\xEF\xBC\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC4"],
        ["\xEF\xBC\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC5"],
        ["\xEF\xBC\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC6"],
        ["\xEF\xBC\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC7"],
        ["\xEF\xBC\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC8"],
        ["\xEF\xBC\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC9"],
        ["\xEF\xBC\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD1"],
        ["\xEF\xBC\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD2"],
        ["\xEF\xBC\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD3"],
        ["\xEF\xBC\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD4"],
        ["\xEF\xBC\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD5"],
        ["\xEF\xBC\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD6"],
        ["\xEF\xBC\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD7"],
        ["\xEF\xBC\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD8"],
        ["\xEF\xBC\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD9"],
        ["\xEF\xBC\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE2"],
        ["\xEF\xBC\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE3"],
        ["\xEF\xBC\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE4"],
        ["\xEF\xBC\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE5"],
        ["\xEF\xBC\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE6"],
        ["\xEF\xBC\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE7"],
        ["\xEF\xBC\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE8"],
        ["\xEF\xBC\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE9"],
        ["\xEF\xBD\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x81"],
        ["\xEF\xBD\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x82"],
        ["\xEF\xBD\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x83"],
        ["\xEF\xBD\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x84"],
        ["\xEF\xBD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x85"],
        ["\xEF\xBD\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x86"],
        ["\xEF\xBD\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x87"],
        ["\xEF\xBD\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x88"],
        ["\xEF\xBD\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x89"],
        ["\xEF\xBD\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x91"],
        ["\xEF\xBD\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x92"],
        ["\xEF\xBD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x93"],
        ["\xEF\xBD\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x94"],
        ["\xEF\xBD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x95"],
        ["\xEF\xBD\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x96"],
        ["\xEF\xBD\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x97"],
        ["\xEF\xBD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x98"],
        ["\xEF\xBD\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x99"],
        ["\xEF\xBD\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA2"],
        ["\xEF\xBD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA3"],
        ["\xEF\xBD\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA4"],
        ["\xEF\xBD\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA5"],
        ["\xEF\xBD\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA6"],
        ["\xEF\xBD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA7"],
        ["\xEF\xBD\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA8"],
        ["\xEF\xBD\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA9"],
        ["\xE3\x81\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x47"],
        ["\xE3\x81\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x81"],
        ["\xE3\x81\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x48"],
        ["\xE3\x81\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x82"],
        ["\xE3\x81\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x49"],
        ["\xE3\x81\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x83"],
        ["\xE3\x81\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x51"],
        ["\xE3\x81\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x84"],
        ["\xE3\x81\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x52"],
        ["\xE3\x81\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x85"],
        ["\xE3\x81\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x86"],
        ["\xE3\x81\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC0"],
        ["\xE3\x81\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x87"],
        ["\xE3\x81\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC1"],
        ["\xE3\x81\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x88"],
        ["\xE3\x81\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC2"],
        ["\xE3\x81\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x89"],
        ["\xE3\x81\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC3"],
        ["\xE3\x81\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x8A"],
        ["\xE3\x81\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC4"],
        ["\xE3\x81\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x8C"],
        ["\xE3\x81\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC5"],
        ["\xE3\x81\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x8D"],
        ["\xE3\x81\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC6"],
        ["\xE3\x81\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x8E"],
        ["\xE3\x81\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC7"],
        ["\xE3\x81\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x8F"],
        ["\xE3\x81\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC8"],
        ["\xE3\x81\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x90"],
        ["\xE3\x81\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC9"],
        ["\xE3\x81\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x91"],
        ["\xE3\x81\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xCA"],
        ["\xE3\x81\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x92"],
        ["\xE3\x81\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xCB"],
        ["\xE3\x81\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x56"],
        ["\xE3\x81\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x93"],
        ["\xE3\x81\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xCC"],
        ["\xE3\x81\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x94"],
        ["\xE3\x81\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xCD"],
        ["\xE3\x81\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x95"],
        ["\xE3\x81\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xCE"],
        ["\xE3\x81\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x96"],
        ["\xE3\x81\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x97"],
        ["\xE3\x81\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x98"],
        ["\xE3\x81\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x99"],
        ["\xE3\x81\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x9A"],
        ["\xE3\x81\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x9D"],
        ["\xE3\x81\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xCF"],
        ["\xE3\x81\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD5"],
        ["\xE3\x81\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x9E"],
        ["\xE3\x81\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD0"],
        ["\xE3\x81\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD6"],
        ["\xE3\x81\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x9F"],
        ["\xE3\x81\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD1"],
        ["\xE3\x81\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD7"],
        ["\xE3\x81\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA2"],
        ["\xE3\x81\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD2"],
        ["\xE3\x81\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD8"],
        ["\xE3\x81\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA3"],
        ["\xE3\x81\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD3"],
        ["\xE3\x81\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD9"],
        ["\xE3\x81\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA4"],
        ["\xE3\x81\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA5"],
        ["\xE3\x82\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA6"],
        ["\xE3\x82\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA7"],
        ["\xE3\x82\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA8"],
        ["\xE3\x82\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x53"],
        ["\xE3\x82\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA9"],
        ["\xE3\x82\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x54"],
        ["\xE3\x82\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xAA"],
        ["\xE3\x82\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x55"],
        ["\xE3\x82\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xAC"],
        ["\xE3\x82\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xAD"],
        ["\xE3\x82\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xAE"],
        ["\xE3\x82\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xAF"],
        ["\xE3\x82\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xBA"],
        ["\xE3\x82\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xBB"],
        ["\xE3\x82\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x57"],
        ["\xE3\x82\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xBC"],
        ["\xE3\x82\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xDA"],
        ["\xE3\x82\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xDB"],
        ["\xE3\x82\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x46"],
        ["\xE3\x82\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xBD"],
        ["\xE3\x82\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x47"],
        ["\xE3\x82\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x81"],
        ["\xE3\x82\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x48"],
        ["\xE3\x82\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x82"],
        ["\xE3\x82\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x49"],
        ["\xE3\x82\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x83"],
        ["\xE3\x82\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x51"],
        ["\xE3\x82\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x84"],
        ["\xE3\x82\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x52"],
        ["\xE3\x82\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x85"],
        ["\xE3\x82\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x86"],
        ["\xE3\x82\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC0"],
        ["\xE3\x82\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x87"],
        ["\xE3\x82\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC1"],
        ["\xE3\x82\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x88"],
        ["\xE3\x82\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC2"],
        ["\xE3\x82\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x89"],
        ["\xE3\x82\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC3"],
        ["\xE3\x82\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x8A"],
        ["\xE3\x82\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC4"],
        ["\xE3\x82\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x8C"],
        ["\xE3\x82\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC5"],
        ["\xE3\x82\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x8D"],
        ["\xE3\x82\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC6"],
        ["\xE3\x82\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x8E"],
        ["\xE3\x82\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC7"],
        ["\xE3\x82\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x8F"],
        ["\xE3\x82\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC8"],
        ["\xE3\x82\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x90"],
        ["\xE3\x82\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC9"],
        ["\xE3\x82\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x91"],
        ["\xE3\x83\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xCA"],
        ["\xE3\x83\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x92"],
        ["\xE3\x83\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xCB"],
        ["\xE3\x83\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x56"],
        ["\xE3\x83\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x93"],
        ["\xE3\x83\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xCC"],
        ["\xE3\x83\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x94"],
        ["\xE3\x83\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xCD"],
        ["\xE3\x83\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x95"],
        ["\xE3\x83\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xCE"],
        ["\xE3\x83\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x96"],
        ["\xE3\x83\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x97"],
        ["\xE3\x83\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x98"],
        ["\xE3\x83\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x99"],
        ["\xE3\x83\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x9A"],
        ["\xE3\x83\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x9D"],
        ["\xE3\x83\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xCF"],
        ["\xE3\x83\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD5"],
        ["\xE3\x83\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x9E"],
        ["\xE3\x83\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD0"],
        ["\xE3\x83\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD6"],
        ["\xE3\x83\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x9F"],
        ["\xE3\x83\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD1"],
        ["\xE3\x83\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD7"],
        ["\xE3\x83\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA2"],
        ["\xE3\x83\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD2"],
        ["\xE3\x83\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD8"],
        ["\xE3\x83\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA3"],
        ["\xE3\x83\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD3"],
        ["\xE3\x83\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD9"],
        ["\xE3\x83\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA4"],
        ["\xE3\x83\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA5"],
        ["\xE3\x83\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA6"],
        ["\xE3\x83\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA7"],
        ["\xE3\x83\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA8"],
        ["\xE3\x83\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x53"],
        ["\xE3\x83\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA9"],
        ["\xE3\x83\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x54"],
        ["\xE3\x83\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xAA"],
        ["\xE3\x83\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x55"],
        ["\xE3\x83\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xAC"],
        ["\xE3\x83\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xAD"],
        ["\xE3\x83\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xAE"],
        ["\xE3\x83\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xAF"],
        ["\xE3\x83\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xBA"],
        ["\xE3\x83\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xBB"],
        ["\xE3\x83\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x57"],
        ["\xE3\x83\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xBC"],
        ["\xE3\x83\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xDA"],
        ["\xE3\x83\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xDB"],
        ["\xE3\x83\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x46"],
        ["\xE3\x83\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xBD"],
        ["\xE3\x83\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD4"],
        ["\xE3\x83\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x59"],
        ["\xE3\x83\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x5A"],
        ["\xCE\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x61"],
        ["\xCE\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x62"],
        ["\xCE\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x63"],
        ["\xCE\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x64"],
        ["\xCE\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x65"],
        ["\xCE\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x66"],
        ["\xCE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x67"],
        ["\xCE\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x68"],
        ["\xCE\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x69"],
        ["\xCE\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x6A"],
        ["\xCE\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x6B"],
        ["\xCE\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x6C"],
        ["\xCE\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x6D"],
        ["\xCE\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x6E"],
        ["\xCE\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x6F"],
        ["\xCE\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x70"],
        ["\xCE\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x71"],
        ["\xCE\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x72"],
        ["\xCE\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x73"],
        ["\xCE\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x74"],
        ["\xCE\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x75"],
        ["\xCE\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x76"],
        ["\xCE\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x77"],
        ["\xCE\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x78"],
        ["\xCE\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x41"],
        ["\xCE\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x42"],
        ["\xCE\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x43"],
        ["\xCE\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x44"],
        ["\xCE\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x45"],
        ["\xCE\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x46"],
        ["\xCE\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x47"],
        ["\xCE\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x48"],
        ["\xCE\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x49"],
        ["\xCE\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x4A"],
        ["\xCE\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x4B"],
        ["\xCE\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x4C"],
        ["\xCE\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x4D"],
        ["\xCE\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x4E"],
        ["\xCE\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x4F"],
        ["\xCF\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x50"],
        ["\xCF\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x51"],
        ["\xCF\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x52"],
        ["\xCF\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x53"],
        ["\xCF\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x54"],
        ["\xCF\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x55"],
        ["\xCF\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x56"],
        ["\xCF\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x57"],
        ["\xCF\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x58"],
        ["\xD0\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC0"],
        ["\xD0\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC1"],
        ["\xD0\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC2"],
        ["\xD0\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC3"],
        ["\xD0\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC4"],
        ["\xD0\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC5"],
        ["\xD0\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC6"],
        ["\xD0\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC7"],
        ["\xD0\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC8"],
        ["\xD0\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC9"],
        ["\xD0\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xCA"],
        ["\xD0\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xCB"],
        ["\xD0\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xCC"],
        ["\xD0\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xCD"],
        ["\xD0\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xCE"],
        ["\xD0\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xCF"],
        ["\xD0\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD0"],
        ["\xD0\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD1"],
        ["\xD0\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD2"],
        ["\xD0\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD3"],
        ["\xD0\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD4"],
        ["\xD0\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD5"],
        ["\xD0\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD6"],
        ["\xD0\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD7"],
        ["\xD0\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD8"],
        ["\xD0\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD9"],
        ["\xD0\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xDA"],
        ["\xD0\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xDB"],
        ["\xD0\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xDC"],
        ["\xD0\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xDD"],
        ["\xD0\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xDE"],
        ["\xD0\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xDF"],
        ["\xD0\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xE0"],
        ["\xD0\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x80"],
        ["\xD0\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x81"],
        ["\xD0\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x82"],
        ["\xD0\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x83"],
        ["\xD0\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x84"],
        ["\xD0\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x85"],
        ["\xD1\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x86"],
        ["\xD0\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x87"],
        ["\xD0\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x88"],
        ["\xD0\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x89"],
        ["\xD0\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x8A"],
        ["\xD0\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x8B"],
        ["\xD0\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x8C"],
        ["\xD0\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x8D"],
        ["\xD0\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x8E"],
        ["\xD0\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x8F"],
        ["\xD0\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x90"],
        ["\xD1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x91"],
        ["\xD1\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x92"],
        ["\xD1\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x93"],
        ["\xD1\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x94"],
        ["\xD1\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x95"],
        ["\xD1\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x96"],
        ["\xD1\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x97"],
        ["\xD1\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x98"],
        ["\xD1\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x99"],
        ["\xD1\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x9A"],
        ["\xD1\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x9B"],
        ["\xD1\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x9C"],
        ["\xD1\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x9D"],
        ["\xD1\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x9E"],
        ["\xD1\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x9F"],
        ["\xD1\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xA0"],
        ["\xE2\x94\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x7C"],
        ["\xE2\x94\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x7D"],
        ["\xE2\x94\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x7E"],
        ["\xE2\x94\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x7F"],
        ["\xE2\x94\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB0"],
        ["\xE2\x94\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB1"],
        ["\xE2\x94\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB2"],
        ["\xE2\x94\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB3"],
        ["\xE2\x94\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB4"],
        ["\xE2\x94\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB5"],
        ["\xE2\x94\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB6"],
        ["\xE2\x94\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB7"],
        ["\xE2\x94\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB8"],
        ["\xE2\x94\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB9"],
        ["\xE2\x94\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE1"],
        ["\xE2\x94\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE2"],
        ["\xE2\x94\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE3"],
        ["\xE2\x94\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE4"],
        ["\xE2\x94\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE5"],
        ["\xE2\x94\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE6"],
        ["\xE2\x94\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE7"],
        ["\xE2\x95\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE8"],
        ["\xE2\x94\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE9"],
        ["\xE2\x94\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xEA"],
        ["\xE2\x94\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xEB"],
        ["\xE2\x94\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xEC"],
        ["\xE2\x94\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xED"],
        ["\xE2\x94\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xEE"],
        ["\xE2\x94\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xEF"],
        ["\xE2\x94\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xF0"],
        ["\xE2\x94\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xF1"],
        ["\xE2\x95\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xF2"],
        ["\xE2\x91\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],
        ["\xE2\x91\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],
        ["\xE2\x91\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],
        ["\xE2\x91\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],
        ["\xE2\x91\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],
        ["\xE2\x91\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],
        ["\xE2\x91\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],
        ["\xE2\x91\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],
        ["\xE2\x91\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],
        ["\xE2\x91\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],
        ["\xE2\x91\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],
        ["\xE2\x91\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],
        ["\xE2\x91\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\xE2\x91\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],
        ["\xE2\x91\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],
        ["\xE2\x91\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7F"],
        ["\xE2\x91\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],
        ["\xE2\x91\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x81"],
        ["\xE2\x91\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x82"],
        ["\xE2\x91\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x83"],
        ["\xE2\x85\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF1"],
        ["\xE2\x85\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF2"],
        ["\xE2\x85\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF3"],
        ["\xE2\x85\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF4"],
        ["\xE2\x85\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF5"],
        ["\xE2\x85\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF6"],
        ["\xE2\x85\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF7"],
        ["\xE2\x85\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF8"],
        ["\xE2\x85\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF9"],
        ["\xE2\x85\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xFA"],
        ["\xE3\x8D\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\xE3\x8C\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x75"],
        ["\xE3\x8C\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x83"],
        ["\xE3\x8D\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\xE3\x8C\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x79"],
        ["\xE3\x8C\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x88"],
        ["\xE3\x8C\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x64"],
        ["\xE3\x8C\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x97"],
        ["\xE3\x8D\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\xE3\x8D\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\xE3\x8C\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x6E"],
        ["\xE3\x8C\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x87"],
        ["\xE3\x8C\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x84"],
        ["\xE3\x8C\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C"],
        ["\xE3\x8D\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xE3\x8C\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C"],
        ["\xE3\x8E\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xE3\x8E\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\xE3\x8E\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\xE3\x8E\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\xE3\x8E\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\xE3\x8F\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x63"],
        ["\xE3\x8E\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],
        ["\xE3\x8D\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xE3\x80\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\xE3\x80\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\xE2\x84\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x6E"],
        ["\xE3\x8F\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6C"],
        ["\xE2\x84\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x6F"],
        ["\xE3\x8A\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x67"],
        ["\xE3\x8A\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],
        ["\xE3\x8A\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x69"],
        ["\xE3\x8A\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6A"],
        ["\xE3\x8A\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6B"],
        ["\xE3\x88\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x6D"],
        ["\xE3\x88\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\xE3\x88\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xE3\x8D\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\xE3\x8D\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\xE3\x8D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xE2\x88\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],
        ["\xE2\x88\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],
        ["\xE2\x88\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],
        ["\xE2\x8A\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xE4\xBA\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x67"],
        ["\xE5\x94\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD4"],
        ["\xE5\xA8\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x7A"],
        ["\xE9\x98\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xAE"],
        ["\xE5\x93\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF9"],
        ["\xE6\x84\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC6"],
        ["\xE6\x8C\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x81"],
        ["\xE5\xA7\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x79"],
        ["\xE9\x80\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xCE"],
        ["\xE8\x91\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD9"],
        ["\xE8\x8C\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE2"],
        ["\xE7\xA9\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x9B"],
        ["\xE6\x82\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x65"],
        ["\xE6\x8F\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x60"],
        ["\xE6\xB8\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x43"],
        ["\xE6\x97\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xEC"],
        ["\xE8\x91\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x72"],
        ["\xE8\x8A\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xDD"],
        ["\xE9\xAF\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xAA"],
        ["\xE6\xA2\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xDA"],
        ["\xE5\x9C\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x82"],
        ["\xE6\x96\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x81"],
        ["\xE6\x89\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x69"],
        ["\xE5\xAE\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xAB"],
        ["\xE5\xA7\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x9C"],
        ["\xE8\x99\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x44"],
        ["\xE9\xA3\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x45"],
        ["\xE7\xB5\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF7"],
        ["\xE7\xB6\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xDC"],
        ["\xE9\xAE\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x8E"],
        ["\xE6\x88\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x7F"],
        ["\xE7\xB2\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xFB"],
        ["\xE8\xA2\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x48"],
        ["\xE5\xAE\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA8"],
        ["\xE5\xBA\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xEB"],
        ["\xE6\x8C\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x89"],
        ["\xE6\x9A\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE2"],
        ["\xE6\xA1\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF1"],
        ["\xE9\x97\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x64"],
        ["\xE9\x9E\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x4C"],
        ["\xE6\x9D\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD0"],
        ["\xE4\xBB\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF6"],
        ["\xE4\xBC\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB2"],
        ["\xE4\xBD\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC8"],
        ["\xE4\xBE\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x9E"],
        ["\xE5\x81\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xFB"],
        ["\xE5\x9B\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xFA"],
        ["\xE5\xA4\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x47"],
        ["\xE5\xA7\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x4F"],
        ["\xE5\xA8\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x65"],
        ["\xE5\xB0\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x89"],
        ["\xE6\x83\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE0"],
        ["\xE6\x84\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x63"],
        ["\xE6\x85\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xAD"],
        ["\xE6\x98\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE9"],
        ["\xE6\xA4\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF7"],
        ["\xE7\x82\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD7"],
        ["\xE7\x95\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x8F"],
        ["\xE7\x95\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA9"],
        ["\xE7\xA7\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x75"],
        ["\xE7\xB6\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x80"],
        ["\xE7\xB7\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x9A"],
        ["\xE8\x83\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF6"],
        ["\xE8\x90\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x82"],
        ["\xE8\xA1\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xEA"],
        ["\xE8\xAC\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x73"],
        ["\xE9\x81\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xBC"],
        ["\xE9\x81\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xDA"],
        ["\xE5\x8C\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x87"],
        ["\xE4\xBA\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x6D"],
        ["\xE4\xBA\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x7F"],
        ["\xE5\x9F\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE9"],
        ["\xE8\x82\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xAC"],
        ["\xE9\x83\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB3"],
        ["\xE7\xA3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xAA"],
        ["\xE4\xB8\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x41"],
        ["\xE5\xA3\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB0"],
        ["\xE6\xBA\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x71"],
        ["\xE9\x80\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD6"],
        ["\xE7\xA8\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x6A"],
        ["\xE8\x8C\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x4C"],
        ["\xE8\x8A\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x9A"],
        ["\xE9\xB0\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC8"],
        ["\xE5\x85\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x91"],
        ["\xE5\x8D\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x99"],
        ["\xE5\x92\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB1"],
        ["\xE5\x93\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xCB"],
        ["\xE5\x9B\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x49"],
        ["\xE5\xA7\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB9"],
        ["\xE5\xBC\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xDA"],
        ["\xE9\xA3\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA3"],
        ["\xE6\xB7\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x4E"],
        ["\xE8\x83\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE9"],
        ["\xE8\x94\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x8B"],
        ["\xE9\x99\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD8"],
        ["\xE9\x99\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD2"],
        ["\xE9\x9A\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xAE"],
        ["\xE9\x9F\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x77"],
        ["\xE5\x90\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xBC"],
        ["\xE5\x8F\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x5A"],
        ["\xE5\xAE\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD5"],
        ["\xE7\x83\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x99"],
        ["\xE7\xBE\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x8F"],
        ["\xE8\xBF\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xDF"],
        ["\xE9\x9B\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xDD"],
        ["\xE5\x8D\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x82"],
        ["\xE9\xB5\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE7"],
        ["\xE7\xAA\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x9E"],
        ["\xE4\xB8\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xEC"],
        ["\xE7\xA2\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB1"],
        ["\xE8\x87\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x89"],
        ["\xE6\xB8\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA0"],
        ["\xE5\x98\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF3"],
        ["\xE5\x94\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xDB"],
        ["\xE6\xAC\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF7"],
        ["\xE8\x94\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x9A"],
        ["\xE9\xB0\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xAB"],
        ["\xE5\xA7\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x55"],
        ["\xE5\x8E\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x67"],
        ["\xE6\xB5\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x6B"],
        ["\xE7\x93\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x64"],
        ["\xE9\x96\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x5F"],
        ["\xE5\x99\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x9B"],
        ["\xE4\xBA\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x9D"],
        ["\xE9\x81\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xAB"],
        ["\xE9\x9B\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xBC"],
        ["\xE8\x8D\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x5F"],
        ["\xE9\xA4\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA7"],
        ["\xE5\x8F\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x94"],
        ["\xE5\x96\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD3"],
        ["\xE5\xAC\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE8"],
        ["\xE5\xBD\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x5E"],
        ["\xE6\x98\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xAC"],
        ["\xE6\x9B\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xBC"],
        ["\xE6\xA0\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xFA"],
        ["\xE6\xB0\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xFB"],
        ["\xE6\xB3\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x57"],
        ["\xE6\xB4\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB7"],
        ["\xE7\x91\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x52"],
        ["\xE7\x9B\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB5"],
        ["\xE7\xA9\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x54"],
        ["\xE9\xA0\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x76"],
        ["\xE8\x8B\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xEE"],
        ["\xE8\xA1\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x80"],
        ["\xE8\xA9\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC1"],
        ["\xE9\x8B\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x6F"],
        ["\xE6\xB6\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x45"],
        ["\xE7\x96\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xCE"],
        ["\xE7\x9B\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x74"],
        ["\xE9\xA7\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xAC"],
        ["\xE6\x82\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x73"],
        ["\xE8\xAC\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE5"],
        ["\xE8\xB6\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xDF"],
        ["\xE9\x96\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x77"],
        ["\xE6\xA6\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xEB"],
        ["\xE5\x8E\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB7"],
        ["\xE5\x86\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x45"],
        ["\xE5\x9C\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE1"],
        ["\xE5\xA0\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA4"],
        ["\xE5\xA5\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF2"],
        ["\xE5\xAE\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x78"],
        ["\xE5\xBB\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD0"],
        ["\xE6\x80\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xDE"],
        ["\xE6\x8E\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD0"],
        ["\xE6\x8F\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD5"],
        ["\xE6\xB2\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x6F"],
        ["\xE6\xBC\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xED"],
        ["\xE7\x82\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xAD"],
        ["\xE7\x84\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xEE"],
        ["\xE7\x85\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xDD"],
        ["\xE7\x87\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x47"],
        ["\xE7\x8C\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x5A"],
        ["\xE7\xB8\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xAA"],
        ["\xE8\x89\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x54"],
        ["\xE8\x8B\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x4B"],
        ["\xE8\x96\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xEC"],
        ["\xE9\x81\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE3"],
        ["\xE9\x89\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD4"],
        ["\xE9\xB4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC3"],
        ["\xE5\xA1\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x43"],
        ["\xE6\x96\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA4"],
        ["\xE6\xB1\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x82"],
        ["\xE7\x94\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD7"],
        ["\xE5\x87\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE6"],
        ["\xE5\xA4\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x92"],
        ["\xE5\xA5\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE5"],
        ["\xE5\xBE\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xEA"],
        ["\xE5\xBF\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x95"],
        ["\xE6\x8A\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE1"],
        ["\xE6\x97\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA3"],
        ["\xE6\xA8\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF2"],
        ["\xE6\xAC\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA0"],
        ["\xE6\xAE\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x59"],
        ["\xE7\x8E\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB1"],
        ["\xE7\xBF\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xFB"],
        ["\xE8\xA5\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x6C"],
        ["\xE9\xB4\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD0"],
        ["\xE9\xB4\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x64"],
        ["\xE9\xBB\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC6"],
        ["\xE5\xB2\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x72"],
        ["\xE6\xB2\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xFD"],
        ["\xE8\x8D\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE0"],
        ["\xE5\x84\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x4E"],
        ["\xE5\xB1\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE9"],
        ["\xE6\x86\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x6C"],
        ["\xE8\x87\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x74"],
        ["\xE6\xA1\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x77"],
        ["\xE7\x89\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x9A"],
        ["\xE4\xB9\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xBD"],
        ["\xE4\xBF\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x67"],
        ["\xE5\x8D\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x79"],
        ["\xE6\x81\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x81"],
        ["\xE6\xB8\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x50"],
        ["\xE7\xA9\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB8"],
        ["\xE9\x9F\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x4D"],
        ["\xE4\xB8\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x5F"],
        ["\xE5\x8C\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x90"],
        ["\xE4\xBB\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x71"],
        ["\xE4\xBD\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x70"],
        ["\xE4\xBC\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x61"],
        ["\xE4\xBE\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x5A"],
        ["\xE4\xBD\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x76"],
        ["\xE5\x8A\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x9F"],
        ["\xE5\x8F\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC6"],
        ["\xE5\x98\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x7E"],
        ["\xE5\xA4\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x7E"],
        ["\xE5\xAB\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x89"],
        ["\xE5\xAE\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x86"],
        ["\xE5\xAF\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB8"],
        ["\xE7\xA7\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xED"],
        ["\xE6\x9A\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x46"],
        ["\xE6\x9E\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB9"],
        ["\xE6\x9E\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE8"],
        ["\xE6\xAD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF7"],
        ["\xE6\xB2\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x5A"],
        ["\xE7\x81\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x85"],
        ["\xE7\x8F\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x9A"],
        ["\xE7\xA6\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x86"],
        ["\xE7\xA6\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x63"],
        ["\xE7\xA8\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xBE"],
        ["\xE7\xAE\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x51"],
        ["\xE8\x8A\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD9"],
        ["\xE8\x8B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x77"],
        ["\xE8\x8C\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x7A"],
        ["\xE8\x8D\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA1"],
        ["\xE8\x8F\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x6C"],
        ["\xE8\x8F\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x51"],
        ["\xE8\x9D\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC3"],
        ["\xE8\xAA\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD6"],
        ["\xE5\x98\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xCA"],
        ["\xE8\xB2\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xEB"],
        ["\xE8\xBF\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x5D"],
        ["\xE9\x81\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x8D"],
        ["\xE9\x9C\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE4"],
        ["\xE8\x9A\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xAA"],
        ["\xE4\xBF\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC7"],
        ["\xE5\xB3\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x9D"],
        ["\xE6\x88\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xDE"],
        ["\xE7\x89\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xFC"],
        ["\xE7\x94\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x77"],
        ["\xE8\x87\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x8A"],
        ["\xE8\x8A\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xBA"],
        ["\xE8\x9B\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x99"],
        ["\xE8\xB3\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x41"],
        ["\xE9\x9B\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x45"],
        ["\xE9\xA4\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x4B"],
        ["\xE9\xA7\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xBE"],
        ["\xE4\xBB\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x4B"],
        ["\xE4\xBC\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xBD"],
        ["\xE8\xA7\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB7"],
        ["\xE5\x9B\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA9"],
        ["\xE5\xA1\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x53"],
        ["\xE5\xA3\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC8"],
        ["\xE5\xBB\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xAF"],
        ["\xE5\xBF\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x60"],
        ["\xE6\x80\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x71"],
        ["\xE6\x82\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x91"],
        ["\xE6\x81\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x94"],
        ["\xE6\x87\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF2"],
        ["\xE6\x88\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA0"],
        ["\xE6\x8B\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA2"],
        ["\xE6\x94\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x8F"],
        ["\xE9\xAD\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xCB"],
        ["\xE6\x99\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x6D"],
        ["\xE6\xA2\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x82"],
        ["\xE6\xB5\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA7"],
        ["\xE7\x81\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF5"],
        ["\xE7\x95\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xAE"],
        ["\xE7\x9A\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB0"],
        ["\xE7\xB5\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE4"],
        ["\xE8\x8A\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x7B"],
        ["\xE8\x9F\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x90"],
        ["\xE9\x96\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xCD"],
        ["\xE9\x9A\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA9"],
        ["\xE8\xB2\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xEA"],
        ["\xE5\x87\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xAC"],
        ["\xE5\x8A\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x6A"],
        ["\xE5\xA4\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x94"],
        ["\xE5\x92\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE9"],
        ["\xE5\xAE\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x68"],
        ["\xE5\xB4\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x74"],
        ["\xE6\x85\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x8A"],
        ["\xE6\xA6\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x42"],
        ["\xE6\xB6\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x91"],
        ["\xE7\xA2\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x56"],
        ["\xE8\x93\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x6D"],
        ["\xE8\xA1\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA5"],
        ["\xE8\xA9\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x8D"],
        ["\xE9\x8E\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x6D"],
        ["\xE9\xAA\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x9C"],
        ["\xE6\xB5\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xCC"],
        ["\xE9\xA6\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x85"],
        ["\xE8\x9B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xBB"],
        ["\xE5\x9E\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xCE"],
        ["\xE6\x9F\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC1"],
        ["\xE8\x9B\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE1"],
        ["\xE9\x88\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x8F"],
        ["\xE5\x8A\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD6"],
        ["\xE5\x9A\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD8"],
        ["\xE5\x90\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xBA"],
        ["\xE5\xBB\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xAD"],
        ["\xE6\x8B\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE5"],
        ["\xE6\x92\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x52"],
        ["\xE6\xA0\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xDE"],
        ["\xE6\xA0\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x9E"],
        ["\xE6\xAE\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC0"],
        ["\xE7\x8D\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x61"],
        ["\xE7\xA2\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x7A"],
        ["\xE7\xA9\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x5C"],
        ["\xE8\xA6\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x4C"],
        ["\xE8\xA7\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x7D"],
        ["\xE8\xB5\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xCC"],
        ["\xE8\xBC\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x5A"],
        ["\xE9\x83\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x62"],
        ["\xE9\x96\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE9"],
        ["\xE9\x9A\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x5A"],
        ["\xE9\x9D\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA3"],
        ["\xE5\xAD\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xBE"],
        ["\xE5\xB2\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x46"],
        ["\xE6\xA5\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x61"],
        ["\xE9\xA1\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF1"],
        ["\xE9\xA1\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x8E"],
        ["\xE6\x8E\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE3"],
        ["\xE7\xAC\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE0"],
        ["\xE6\xA8\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x6F"],
        ["\xE6\xA9\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB2"],
        ["\xE6\xA2\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xAD"],
        ["\xE9\xB0\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x71"],
        ["\xE6\xBD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC2"],
        ["\xE5\x89\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD6"],
        ["\xE5\x96\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x75"],
        ["\xE6\x81\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x84"],
        ["\xE6\x8B\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC5"],
        ["\xE6\xB4\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB4"],
        ["\xE6\xB8\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x41"],
        ["\xE6\xBB\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA2"],
        ["\xE8\x91\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xDF"],
        ["\xE8\xA4\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x5E"],
        ["\xE8\xBD\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xFE"],
        ["\xE4\xB8\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x97"],
        ["\xE9\xB0\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD5"],
        ["\xE5\x8F\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x59"],
        ["\xE6\xA4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x63"],
        ["\xE6\xA8\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x69"],
        ["\xE9\x9E\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x45"],
        ["\xE6\xA0\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x56"],
        ["\xE5\x85\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xBE"],
        ["\xE7\xAB\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x46"],
        ["\xE8\x92\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB2"],
        ["\xE9\x87\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xCC"],
        ["\xE9\x8E\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x62"],
        ["\xE5\x99\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x7D"],
        ["\xE9\xB4\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x54"],
        ["\xE6\xA0\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x42"],
        ["\xE8\x8C\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD3"],
        ["\xE8\x90\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x7C"],
        ["\xE7\xB2\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xAB"],
        ["\xE5\x88\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x9B"],
        ["\xE8\x8B\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x5D"],
        ["\xE7\x93\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC2"],
        ["\xE4\xB9\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x70"],
        ["\xE4\xBE\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x98"],
        ["\xE5\x86\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x7B"],
        ["\xE5\xAF\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x81"],
        ["\xE5\x88\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD7"],
        ["\xE5\x8B\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x9A"],
        ["\xE5\x8B\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x7E"],
        ["\xE5\xB7\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x93"],
        ["\xE5\x96\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB5"],
        ["\xE5\xA0\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xAC"],
        ["\xE5\xA7\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xDE"],
        ["\xE5\xAE\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC5"],
        ["\xE5\xAE\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA2"],
        ["\xE5\xAF\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF8"],
        ["\xE5\xB9\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x6F"],
        ["\xE5\xB9\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xDA"],
        ["\xE6\x82\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xEB"],
        ["\xE6\x84\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF7"],
        ["\xE6\x85\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD3"],
        ["\xE6\x86\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA5"],
        ["\xE6\x8F\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xAA"],
        ["\xE6\x95\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xCF"],
        ["\xE6\x9F\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC1"],
        ["\xE6\xA1\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x6D"],
        ["\xE6\xA3\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB6"],
        ["\xE6\xAC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xFB"],
        ["\xE6\xAD\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x4E"],
        ["\xE6\xB1\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC4"],
        ["\xE6\xBC\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x58"],
        ["\xE6\xBE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xBA"],
        ["\xE6\xBD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xAA"],
        ["\xE7\x92\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB9"],
        ["\xE7\x94\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x55"],
        ["\xE7\x9B\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE3"],
        ["\xE7\x9C\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA2"],
        ["\xE7\xAB\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x87"],
        ["\xE7\xAE\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF2"],
        ["\xE7\xB0\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xEC"],
        ["\xE7\xB7\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xFC"],
        ["\xE7\xBC\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x84"],
        ["\xE7\xBF\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB6"],
        ["\xE8\x82\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x8C"],
        ["\xE8\x89\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x4A"],
        ["\xE8\x8E\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xEE"],
        ["\xE8\xA6\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x7E"],
        ["\xE8\xAB\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE0"],
        ["\xE8\xB2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA1"],
        ["\xE9\x82\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA9"],
        ["\xE9\x91\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x4E"],
        ["\xE9\x96\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC1"],
        ["\xE9\x96\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD9"],
        ["\xE9\x96\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC5"],
        ["\xE9\x99\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xFE"],
        ["\xE9\x9F\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x75"],
        ["\xE9\xA4\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x62"],
        ["\xE8\x88\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xAA"],
        ["\xE4\xB8\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x7A"],
        ["\xE5\x90\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xCB"],
        ["\xE5\xB2\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x48"],
        ["\xE5\xB7\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xCF"],
        ["\xE7\x8E\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x4C"],
        ["\xE7\x99\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x47"],
        ["\xE7\x9C\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA5"],
        ["\xE5\xB2\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xBF"],
        ["\xE7\xBF\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x8B"],
        ["\xE8\xB4\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x84"],
        ["\xE9\x9B\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA4"],
        ["\xE9\xA0\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x9D"],
        ["\xE9\xA1\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB8"],
        ["\xE9\xA1\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x57"],
        ["\xE4\xBC\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD2"],
        ["\xE4\xBC\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x9F"],
        ["\xE5\x8D\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x91"],
        ["\xE5\x96\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD1"],
        ["\xE5\x99\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xFC"],
        ["\xE5\x9F\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF1"],
        ["\xE5\xA5\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x69"],
        ["\xE5\xAC\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x8B"],
        ["\xE5\xAF\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xDF"],
        ["\xE5\xB2\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x4A"],
        ["\xE5\xB8\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB5"],
        ["\xE5\xB9\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x57"],
        ["\xE5\xBF\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x97"],
        ["\xE6\x8F\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF2"],
        ["\xE6\x9C\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x96"],
        ["\xE6\x97\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xAB"],
        ["\xE6\x97\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x77"],
        ["\xE6\x9C\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x8B"],
        ["\xE6\xA3\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF1"],
        ["\xE6\xA3\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB1"],
        ["\xE6\xA9\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x79"],
        ["\xE5\xB8\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x82"],
        ["\xE6\xAF\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x5B"],
        ["\xE6\xB0\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB9"],
        ["\xE6\xB1\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x4C"],
        ["\xE7\x95\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD4"],
        ["\xE7\xA5\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD8"],
        ["\xE5\xAD\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xEC"],
        ["\xE7\xA8\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x64"],
        ["\xE7\xB4\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xDB"],
        ["\xE5\xBE\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE0"],
        ["\xE8\xA6\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xFB"],
        ["\xE8\xA8\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x94"],
        ["\xE8\xB2\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x7F"],
        ["\xE8\xB5\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD0"],
        ["\xE8\xBB\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xAA"],
        ["\xE8\xBC\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x87"],
        ["\xE9\xA3\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xCE"],
        ["\xE9\xA8\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x58"],
        ["\xE9\xAC\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC8"],
        ["\xE4\xBA\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC0"],
        ["\xE5\x81\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x59"],
        ["\xE5\x84\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xCA"],
        ["\xE5\xA6\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x95"],
        ["\xE5\xAE\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x8B"],
        ["\xE6\x88\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x92"],
        ["\xE6\x8A\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF7"],
        ["\xE6\x93\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xCD"],
        ["\xE6\xAC\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x7D"],
        ["\xE7\x8A\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xDC"],
        ["\xE7\x96\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB4"],
        ["\xE7\xA5\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x92"],
        ["\xE7\xBE\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x98"],
        ["\xE8\x9F\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC6"],
        ["\xE8\xAA\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x65"],
        ["\xE8\xAD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x81"],
        ["\xE6\x8E\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x41"],
        ["\xE8\x8F\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD7"],
        ["\xE9\x9E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xED"],
        ["\xE5\x90\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x7E"],
        ["\xE5\x90\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xEA"],
        ["\xE5\x96\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x6D"],
        ["\xE6\xA1\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x4B"],
        ["\xE6\xA9\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC2"],
        ["\xE8\xA9\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x5F"],
        ["\xE7\xA0\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x48"],
        ["\xE6\x9D\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA6"],
        ["\xE9\xBB\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xAE"],
        ["\xE5\x8D\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA4"],
        ["\xE5\xAE\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xDE"],
        ["\xE8\x84\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x5C"],
        ["\xE8\x99\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x60"],
        ["\xE9\x80\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xFC"],
        ["\xE4\xB8\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x56"],
        ["\xE4\xB9\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x8A"],
        ["\xE4\xBB\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x85"],
        ["\xE4\xBC\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x81"],
        ["\xE5\x8F\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x5C"],
        ["\xE5\x90\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x98"],
        ["\xE5\xAE\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x92"],
        ["\xE5\xBC\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x63"],
        ["\xE6\x80\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xCC"],
        ["\xE6\x95\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x5C"],
        ["\xE6\x9C\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF0"],
        ["\xE6\xB1\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA0"],
        ["\xE6\xB1\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC8"],
        ["\xE6\xB3\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x4B"],
        ["\xE7\x81\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x73"],
        ["\xE7\x90\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xDB"],
        ["\xE7\xA9\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x86"],
        ["\xE7\xAA\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xAA"],
        ["\xE7\xAC\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xCF"],
        ["\xE7\xB4\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF3"],
        ["\xE7\xB3\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xFE"],
        ["\xE7\xB5\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x57"],
        ["\xE6\x97\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x7B"],
        ["\xE7\x89\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x73"],
        ["\xE5\x8E\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xCA"],
        ["\xE5\xB1\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x5E"],
        ["\xE5\xB7\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x52"],
        ["\xE6\x8B\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x61"],
        ["\xE6\x8B\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x77"],
        ["\xE6\x8C\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x82"],
        ["\xE6\xB8\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x7A"],
        ["\xE8\x99\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x72"],
        ["\xE8\xA8\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x9A"],
        ["\xE8\xB7\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC2"],
        ["\xE9\x8B\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE7"],
        ["\xE6\xBC\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x78"],
        ["\xE7\xA6\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xAA"],
        ["\xE9\xAD\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xEE"],
        ["\xE4\xBA\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xAC"],
        ["\xE4\xBA\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x73"],
        ["\xE4\xBA\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x75"],
        ["\xE4\xBE\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xBC"],
        ["\xE4\xBE\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xEC"],
        ["\xE5\x83\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xAD"],
        ["\xE5\x85\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x5A"],
        ["\xE7\xAB\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x71"],
        ["\xE5\x85\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB3"],
        ["\xE5\x87\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xEC"],
        ["\xE5\x8D\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD7"],
        ["\xE5\x8C\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x4D"],
        ["\xE5\x8D\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE2"],
        ["\xE5\x8F\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD5"],
        ["\xE5\x96\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x5F"],
        ["\xE5\xA2\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x95"],
        ["\xE5\xB3\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB3"],
        ["\xE5\xBC\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD2"],
        ["\xE5\xBD\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x85"],
        ["\xE6\x80\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x42"],
        ["\xE6\x81\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD5"],
        ["\xE6\x81\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x4E"],
        ["\xE6\x8C\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB1"],
        ["\xE6\x95\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA5"],
        ["\xE6\xA9\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x89"],
        ["\xE6\xB3\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x58"],
        ["\xE7\x8B\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x5A"],
        ["\xE7\x8B\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x9E"],
        ["\xE7\x9F\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xBB"],
        ["\xE8\x83\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE3"],
        ["\xE8\x84\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x51"],
        ["\xE8\x88\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x6A"],
        ["\xE8\x95\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x65"],
        ["\xE9\x83\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x95"],
        ["\xE9\x8F\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x8D"],
        ["\xE9\x9F\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x5C"],
        ["\xE9\xA5\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD5"],
        ["\xE9\xA9\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD5"],
        ["\xE4\xBB\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xED"],
        ["\xE5\x87\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD9"],
        ["\xE5\xB0\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x80"],
        ["\xE6\x9A\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x83"],
        ["\xE6\xA5\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x6B"],
        ["\xE5\xB1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x8B"],
        ["\xE6\x9B\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB6"],
        ["\xE6\xA5\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB7"],
        ["\xE7\x8E\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xFD"],
        ["\xE6\xA1\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC0"],
        ["\xE7\xB2\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE7"],
        ["\xE5\x83\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC9"],
        ["\xE5\x8B\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x9F"],
        ["\xE5\x9D\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xAE"],
        ["\xE5\xB7\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x7D"],
        ["\xE9\x8C\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x8E"],
        ["\xE6\x96\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xCF"],
        ["\xE6\xAC\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x9D"],
        ["\xE6\xAC\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF8"],
        ["\xE7\x90\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD8"],
        ["\xE7\xA6\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x75"],
        ["\xE7\xA6\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x5D"],
        ["\xE7\xAD\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x8F"],
        ["\xE7\xB7\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x97"],
        ["\xE8\x8A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD0"],
        ["\xE8\x8F\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x73"],
        ["\xE8\xA1\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA7"],
        ["\xE8\xA5\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xAF"],
        ["\xE8\xAC\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x87"],
        ["\xE8\xBF\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x73"],
        ["\xE9\x87\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x86"],
        ["\xE5\x90\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x7A"],
        ["\xE9\x8A\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x8C"],
        ["\xE4\xB9\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x49"],
        ["\xE5\x80\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x63"],
        ["\xE5\x8F\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x8B"],
        ["\xE5\x8C\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x54"],
        ["\xE7\x8B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x74"],
        ["\xE7\x8E\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE9"],
        ["\xE7\x9F\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x4D"],
        ["\xE8\x8B\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x5F"],
        ["\xE8\xBA\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x53"],
        ["\xE9\xA7\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xFE"],
        ["\xE9\xA7\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x85"],
        ["\xE9\xA7\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xFC"],
        ["\xE5\x85\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xAF"],
        ["\xE6\x84\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB2"],
        ["\xE8\x99\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x88"],
        ["\xE5\x96\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB9"],
        ["\xE7\xA9\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x8D"],
        ["\xE5\x81\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC3"],
        ["\xE5\xAF\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF4"],
        ["\xE9\x81\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xEC"],
        ["\xE9\x9A\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB9"],
        ["\xE4\xB8\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB8"],
        ["\xE6\xAB\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA6"],
        ["\xE9\x87\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF0"],
        ["\xE5\xB1\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB2"],
        ["\xE5\xB1\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x94"],
        ["\xE6\x8E\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x44"],
        ["\xE7\xAA\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA6"],
        ["\xE6\xB2\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF8"],
        ["\xE9\x9D\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF1"],
        ["\xE8\xBD\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE1"],
        ["\xE7\xAA\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x65"],
        ["\xE7\x86\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x7F"],
        ["\xE9\x9A\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE5"],
        ["\xE7\xB2\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x85"],
        ["\xE6\xA0\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x9B"],
        ["\xE7\xB9\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x69"],
        ["\xE6\xA1\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x79"],
        ["\xE9\x8D\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x70"],
        ["\xE5\x8B\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x7A"],
        ["\xE5\x90\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xCF"],
        ["\xE8\x96\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x98"],
        ["\xE8\xA8\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC8"],
        ["\xE7\xBE\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB1"],
        ["\xE8\xBB\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x97"],
        ["\xE9\x83\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x9E"],
        ["\xE5\x8D\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xDB"],
        ["\xE8\xA2\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x6A"],
        ["\xE7\xA5\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD2"],
        ["\xE4\xBF\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x51"],
        ["\xE5\x82\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x43"],
        ["\xE5\x88\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x52"],
        ["\xE5\x85\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE8"],
        ["\xE5\x95\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE4"],
        ["\xE5\x9C\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE6"],
        ["\xE7\x8F\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB9"],
        ["\xE5\x9E\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE6"],
        ["\xE5\xA5\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x64"],
        ["\xE5\xBD\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x90"],
        ["\xE5\xBE\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x60"],
        ["\xE6\x81\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x43"],
        ["\xE6\x85\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA8"],
        ["\xE6\x85\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB6"],
        ["\xE6\x86\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x75"],
        ["\xE6\x8E\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC1"],
        ["\xE6\x90\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x49"],
        ["\xE6\x95\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB0"],
        ["\xE6\x99\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x93"],
        ["\xE6\xA1\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xAB"],
        ["\xE6\xB8\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x98"],
        ["\xE7\x95\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB4"],
        ["\xE7\xA8\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC7"],
        ["\xE7\xB3\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xFA"],
        ["\xE7\xB5\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x88"],
        ["\xE7\xB6\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x4A"],
        ["\xE7\xB9\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x73"],
        ["\xE7\xBD\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xEF"],
        ["\xE8\x8C\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC9"],
        ["\xE8\x8D\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB3"],
        ["\xE8\x9B\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF9"],
        ["\xE8\xA8\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC9"],
        ["\xE8\xA9\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xFB"],
        ["\xE8\xAD\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD7"],
        ["\xE8\xBB\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA6"],
        ["\xE9\xA0\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC4"],
        ["\xE9\xB6\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x8E"],
        ["\xE8\x8A\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x53"],
        ["\xE8\xBF\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA9"],
        ["\xE9\xAF\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x78"],
        ["\xE5\x8A\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF0"],
        ["\xE6\x88\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD9"],
        ["\xE6\x92\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x74"],
        ["\xE6\xBF\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD0"],
        ["\xE9\x9A\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC3"],
        ["\xE6\xA1\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD6"],
        ["\xE5\x82\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC3"],
        ["\xE6\xAC\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB5"],
        ["\xE6\xB1\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA4"],
        ["\xE6\xBD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC2"],
        ["\xE7\xA9\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x86"],
        ["\xE7\xB5\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xBF"],
        ["\xE8\xA1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x43"],
        ["\xE8\xA8\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xCC"],
        ["\xE6\x9C\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x61"],
        ["\xE4\xBB\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB2"],
        ["\xE5\x80\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xFA"],
        ["\xE5\x80\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF1"],
        ["\xE5\x81\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x81"],
        ["\xE5\x85\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF4"],
        ["\xE5\x88\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x6B"],
        ["\xE5\x89\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD3"],
        ["\xE5\x96\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD3"],
        ["\xE5\x9C\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x49"],
        ["\xE5\xA0\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE7"],
        ["\xE5\xAB\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC3"],
        ["\xE5\xBB\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x66"],
        ["\xE6\x86\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xBE"],
        ["\xE6\x87\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC6"],
        ["\xE6\x8B\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x8D"],
        ["\xE6\x8D\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x93"],
        ["\xE6\xA4\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x6D"],
        ["\xE6\xA8\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xDC"],
        ["\xE7\x89\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x8A"],
        ["\xE7\x8A\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC5"],
        ["\xE7\x8C\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x45"],
        ["\xE7\xA0\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD3"],
        ["\xE7\xA1\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x69"],
        ["\xE7\xB5\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF6"],
        ["\xE7\x9C\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x52"],
        ["\xE8\x82\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x79"],
        ["\xE8\xA6\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xBB"],
        ["\xE8\xAC\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x7C"],
        ["\xE8\xB3\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE5"],
        ["\xE8\xBB\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x55"],
        ["\xE9\x81\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC2"],
        ["\xE9\x8D\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x45"],
        ["\xE9\x99\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x6C"],
        ["\xE9\xA1\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE5"],
        ["\xE9\xA8\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB4"],
        ["\xE9\xB9\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x7D"],
        ["\xE5\x85\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x95"],
        ["\xE5\x8E\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x74"],
        ["\xE5\x8E\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x8E"],
        ["\xE5\xB9\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA2"],
        ["\xE5\xBC\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x42"],
        ["\xE6\xB8\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x8A"],
        ["\xE6\xBA\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xFC"],
        ["\xE7\x8E\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x6E"],
        ["\xE7\x8F\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB7"],
        ["\xE7\xB5\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x63"],
        ["\xE8\x88\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xAC"],
        ["\xE8\xA8\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x9A"],
        ["\xE8\xAB\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xAB"],
        ["\xE9\x99\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xAD"],
        ["\xE4\xB9\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA5"],
        ["\xE5\x80\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xFA"],
        ["\xE5\x8F\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD4"],
        ["\xE5\x91\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF6"],
        ["\xE5\x9B\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x94"],
        ["\xE5\xA7\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF2"],
        ["\xE5\xAD\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xAF"],
        ["\xE5\xB7\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xAD"],
        ["\xE5\xBA\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF8"],
        ["\xE5\xBC\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x6B"],
        ["\xE6\x88\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xCF"],
        ["\xE6\x95\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF7"],
        ["\xE6\x9E\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x61"],
        ["\xE6\xB9\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x52"],
        ["\xE7\x8B\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xDB"],
        ["\xE7\xB3\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x71"],
        ["\xE8\xA2\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x5A"],
        ["\xE8\x82\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC5"],
        ["\xE8\x83\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x63"],
        ["\xE8\x8F\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x6D"],
        ["\xE8\x99\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xAB"],
        ["\xE8\xAA\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB4"],
        ["\xE8\xB7\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xCB"],
        ["\xE9\x88\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xBF"],
        ["\xE9\x9B\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x4D"],
        ["\xE9\xA1\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xEE"],
        ["\xE9\xBC\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xAF"],
        ["\xE4\xBA\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x45"],
        ["\xE4\xBA\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x74"],
        ["\xE4\xBC\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x99"],
        ["\xE5\x8D\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xDF"],
        ["\xE5\x91\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xEE"],
        ["\xE5\x90\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF6"],
        ["\xE5\xA8\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB5"],
        ["\xE5\xBE\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE5"],
        ["\xE5\xBE\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x98"],
        ["\xE6\x82\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB1"],
        ["\xE6\xA2\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD3"],
        ["\xE6\xAA\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xEE"],
        ["\xE7\x91\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF1"],
        ["\xE7\xA2\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x4E"],
        ["\xE8\xAA\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE7"],
        ["\xE8\xAA\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x91"],
        ["\xE8\xAD\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xDB"],
        ["\xE9\x86\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x70"],
        ["\xE4\xB9\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB5"],
        ["\xE9\xAF\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC6"],
        ["\xE4\xBA\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x8E"],
        ["\xE4\xBD\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x62"],
        ["\xE4\xBE\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE3"],
        ["\xE5\x80\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xAE"],
        ["\xE5\x80\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x43"],
        ["\xE5\x85\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x9E"],
        ["\xE5\x85\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xBB"],
        ["\xE5\x8A\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x70"],
        ["\xE5\x8A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x78"],
        ["\xE5\x8B\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE9"],
        ["\xE5\x8E\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x42"],
        ["\xE5\x8F\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x88"],
        ["\xE5\x90\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA5"],
        ["\xE5\x90\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xAF"],
        ["\xE5\x96\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x53"],
        ["\xE5\x9D\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF3"],
        ["\xE5\x9E\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x66"],
        ["\xE5\xA5\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x9E"],
        ["\xE5\xAD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD9"],
        ["\xE5\xAD\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF4"],
        ["\xE5\xAE\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC8"],
        ["\xE5\xB7\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x6A"],
        ["\xE5\xB7\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA3"],
        ["\xE5\xB7\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xCB"],
        ["\xE5\xB9\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA9"],
        ["\xE5\xBA\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB7"],
        ["\xE5\xBA\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x5A"],
        ["\xE5\xBA\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x9A"],
        ["\xE5\xBC\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD3"],
        ["\xE6\x81\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC7"],
        ["\xE6\x85\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x8E"],
        ["\xE6\x8A\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x67"],
        ["\xE6\x8B\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x45"],
        ["\xE6\x8E\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xAC"],
        ["\xE6\x94\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC5"],
        ["\xE6\x98\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x99"],
        ["\xE6\x99\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB0"],
        ["\xE6\x9B\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x6D"],
        ["\xE6\x9D\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x8B"],
        ["\xE6\xA0\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xBF"],
        ["\xE6\xA2\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xCC"],
        ["\xE6\xA7\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x96"],
        ["\xE6\xB1\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xAD"],
        ["\xE6\xB4\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD4"],
        ["\xE6\xB5\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xEB"],
        ["\xE6\xB8\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC6"],
        ["\xE6\xBA\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x4D"],
        ["\xE7\x94\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA0"],
        ["\xE7\x9A\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xBB"],
        ["\xE7\xA1\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xEF"],
        ["\xE7\xA8\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD5"],
        ["\xE7\xB3\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x4B"],
        ["\xE7\xB4\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x67"],
        ["\xE7\xB4\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x78"],
        ["\xE7\xB5\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x6D"],
        ["\xE7\xB6\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xCB"],
        ["\xE8\x80\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x9A"],
        ["\xE8\x80\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x60"],
        ["\xE8\x82\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xEB"],
        ["\xE8\x82\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD5"],
        ["\xE8\x85\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x47"],
        ["\xE8\x86\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD8"],
        ["\xE8\x88\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x9F"],
        ["\xE8\x8D\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xDC"],
        ["\xE8\xA1\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA4"],
        ["\xE8\xA1\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xED"],
        ["\xE8\xAC\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x6E"],
        ["\xE8\xB2\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF1"],
        ["\xE8\xB3\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x8F"],
        ["\xE9\x83\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x52"],
        ["\xE9\x85\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x86"],
        ["\xE9\x89\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x63"],
        ["\xE7\xA0\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xAF"],
        ["\xE9\x8B\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA1"],
        ["\xE9\x96\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x9B"],
        ["\xE9\x99\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE5"],
        ["\xE9\xA0\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x97"],
        ["\xE9\xA6\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xBD"],
        ["\xE9\xAB\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x71"],
        ["\xE9\xB4\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD6"],
        ["\xE5\x89\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC7"],
        ["\xE5\x8A\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC6"],
        ["\xE5\x8F\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE2"],
        ["\xE5\x90\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA0"],
        ["\xE5\xA3\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB9"],
        ["\xE6\x8B\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB5"],
        ["\xE6\xBF\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x80"],
        ["\xE8\xB1\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x68"],
        ["\xE8\xBD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA9"],
        ["\xE9\xBA\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x61"],
        ["\xE5\x85\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x9E"],
        ["\xE5\x88\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF5"],
        ["\xE5\x91\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x54"],
        ["\xE5\x9B\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x8F"],
        ["\xE7\xA9\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x94"],
        ["\xE9\x85\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xEB"],
        ["\xE9\xB5\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xFD"],
        ["\xE9\xBB\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x79"],
        ["\xE7\x8D\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x95"],
        ["\xE6\xBC\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD0"],
        ["\xE8\x85\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA4"],
        ["\xE7\x94\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x95"],
        ["\xE5\xBF\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x56"],
        ["\xE6\x83\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x9D"],
        ["\xE9\xAA\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA5"],
        ["\xE7\x8B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xDC"],
        ["\xE8\xBE\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x41"],
        ["\xE6\xAD\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x4C"],
        ["\xE9\xA0\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x46"],
        ["\xE4\xBB\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE0"],
        ["\xE5\x9B\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x44"],
        ["\xE5\x9D\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA6"],
        ["\xE5\xA2\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x88"],
        ["\xE5\xA9\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x77"],
        ["\xE6\x81\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB8"],
        ["\xE6\x87\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA4"],
        ["\xE6\x98\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE8"],
        ["\xE6\x98\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE7"],
        ["\xE6\xA0\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x67"],
        ["\xE6\xA2\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x59"],
        ["\xE6\xB7\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x46"],
        ["\xE7\x97\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xFD"],
        ["\xE7\xB4\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xBD"],
        ["\xE8\x89\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB4"],
        ["\xE9\xAD\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA8"],
        ["\xE4\xBA\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xDC"],
        ["\xE4\xBD\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x76"],
        ["\xE5\x8F\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA5"],
        ["\xE5\x94\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB8"],
        ["\xE5\xB5\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD3"],
        ["\xE5\xB7\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x5B"],
        ["\xE5\xB7\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x8B"],
        ["\xE6\x9F\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x73"],
        ["\xE6\xB2\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xAD"],
        ["\xE7\x91\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x88"],
        ["\xE7\xA0\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x5B"],
        ["\xE8\xA9\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x76"],
        ["\xE9\x8E\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x70"],
        ["\xE8\xA3\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x8A"],
        ["\xE5\x9D\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x8D"],
        ["\xE5\xBA\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB1"],
        ["\xE6\x8C\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x8F"],
        ["\xE5\x82\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x58"],
        ["\xE5\x82\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x43"],
        ["\xE5\x86\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xEB"],
        ["\xE6\x9C\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF5"],
        ["\xE5\x93\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x6B"],
        ["\xE5\xA1\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC1"],
        ["\xE5\xA6\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA3"],
        ["\xE5\xAE\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD4"],
        ["\xE5\xBD\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xCD"],
        ["\xE6\x89\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF1"],
        ["\xE6\x8E\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x4F"],
        ["\xE6\xA0\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE0"],
        ["\xE6\xAD\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE4"],
        ["\xE6\xB8\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x69"],
        ["\xE7\x81\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xBC"],
        ["\xE9\x87\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xBF"],
        ["\xE7\x8A\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x54"],
        ["\xE7\xA0\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC3"],
        ["\xE7\xA0\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB4"],
        ["\xE7\xA5\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x71"],
        ["\xE6\x96\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xDB"],
        ["\xE7\xB4\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x68"],
        ["\xE8\x8F\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA8"],
        ["\xE8\xA3\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xBD"],
        ["\xE8\xBC\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x6E"],
        ["\xE9\x9A\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x97"],
        ["\xE5\x89\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x66"],
        ["\xE5\x9C\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xCD"],
        ["\xE6\x9D\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xBC"],
        ["\xE7\xBD\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x4E"],
        ["\xE8\xB2\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xAF"],
        ["\xE5\x86\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC9"],
        ["\xE5\x9D\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xEC"],
        ["\xE9\x98\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x91"],
        ["\xE5\xA0\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x7C"],
        ["\xE6\xA6\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x52"],
        ["\xE8\x82\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x51"],
        ["\xE5\x92\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xDE"],
        ["\xE5\xB4\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x7F"],
        ["\xE5\x9F\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA3"],
        ["\xE7\xA2\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD2"],
        ["\xE9\xB7\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xAF"],
        ["\xE4\xBD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x94"],
        ["\xE5\x89\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x90"],
        ["\xE5\x92\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x50"],
        ["\xE6\x90\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA3"],
        ["\xE6\x98\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE8"],
        ["\xE6\x9C\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA4"],
        ["\xE6\x9F\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF1"],
        ["\xE7\xAA\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x99"],
        ["\xE7\xAD\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC9"],
        ["\xE7\xB4\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF4"],
        ["\xE9\x8C\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB1"],
        ["\xE6\xA1\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x71"],
        ["\xE9\xAE\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x91"],
        ["\xE7\xAC\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x6E"],
        ["\xE5\x8C\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x57"],
        ["\xE5\x86\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA1"],
        ["\xE5\x88\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xCF"],
        ["\xE5\xAF\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x93"],
        ["\xE6\x8B\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x9E"],
        ["\xE6\x92\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x77"],
        ["\xE6\x93\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD6"],
        ["\xE6\x9C\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF9"],
        ["\xE6\xAE\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE9"],
        ["\xE8\x96\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF1"],
        ["\xE9\x9B\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x8A"],
        ["\xE7\x9A\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA4"],
        ["\xE9\xAF\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE4"],
        ["\xE6\x8D\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x7D"],
        ["\xE9\x8C\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD2"],
        ["\xE9\xAE\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB7"],
        ["\xE7\x9A\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC7"],
        ["\xE6\x99\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC3"],
        ["\xE4\xB8\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x43"],
        ["\xE5\x82\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x9C"],
        ["\xE5\x8F\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD2"],
        ["\xE5\xB1\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x65"],
        ["\xE6\x83\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x6E"],
        ["\xE6\x92\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xDE"],
        ["\xE6\x95\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC9"],
        ["\xE6\xA1\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF3"],
        ["\xE7\x87\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xCE"],
        ["\xE7\x8F\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x99"],
        ["\xE7\x94\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC0"],
        ["\xE7\xAE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x43"],
        ["\xE7\xBA\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xEB"],
        ["\xE8\x9A\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x5D"],
        ["\xE8\xAE\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x6B"],
        ["\xE8\xB3\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xEE"],
        ["\xE9\x85\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x99"],
        ["\xE9\xA4\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB3"],
        ["\xE6\x96\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xFC"],
        ["\xE6\x9A\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x93"],
        ["\xE6\xAE\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x92"],
        ["\xE4\xBB\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB5"],
        ["\xE4\xBB\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x65"],
        ["\xE4\xBC\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x8A"],
        ["\xE4\xBD\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB6"],
        ["\xE5\x88\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC0"],
        ["\xE5\x8F\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF0"],
        ["\xE5\x8F\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD9"],
        ["\xE5\x97\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x5E"],
        ["\xE5\x9B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x44"],
        ["\xE5\xA3\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x7D"],
        ["\xE5\xA7\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x90"],
        ["\xE5\xA7\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC1"],
        ["\xE5\xA7\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x42"],
        ["\xE5\xAD\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x64"],
        ["\xE5\xB1\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xBA"],
        ["\xE5\xB8\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x53"],
        ["\xE5\xB8\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x44"],
        ["\xE5\xBF\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x61"],
        ["\xE6\x80\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xAD"],
        ["\xE6\x8C\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB6"],
        ["\xE6\x94\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x7B"],
        ["\xE5\xAD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF2"],
        ["\xE6\x96\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA5"],
        ["\xE6\x96\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x88"],
        ["\xE6\x97\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x6A"],
        ["\xE6\x9E\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x72"],
        ["\xE6\xAD\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD8"],
        ["\xE6\xAD\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x99"],
        ["\xE6\xB0\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x8E"],
        ["\xE7\x8D\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x9F"],
        ["\xE7\xA5\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xEB"],
        ["\xE7\xA7\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC3"],
        ["\xE7\xB3\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC7"],
        ["\xE7\xB4\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x80"],
        ["\xE7\xB4\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF0"],
        ["\xE8\x82\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x82"],
        ["\xE8\x84\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x74"],
        ["\xE8\x87\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x48"],
        ["\xE8\xA6\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x50"],
        ["\xE8\xA9\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x90"],
        ["\xE8\xA9\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB0"],
        ["\xE8\xA9\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x48"],
        ["\xE8\xAA\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x76"],
        ["\xE8\xAB\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x9C"],
        ["\xE8\xB3\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x50"],
        ["\xE8\xB3\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x94"],
        ["\xE9\x9B\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB7"],
        ["\xE9\xA3\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x8F"],
        ["\xE6\xAD\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x9F"],
        ["\xE4\xBA\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xCE"],
        ["\xE4\xBC\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xBC"],
        ["\xE4\xBE\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC2"],
        ["\xE5\x85\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x9F"],
        ["\xE5\xAD\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF2"],
        ["\xE5\xAF\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA0"],
        ["\xE6\x85\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xBE"],
        ["\xE6\x8C\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD8"],
        ["\xE6\x99\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x51"],
        ["\xE6\xAC\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x97"],
        ["\xE6\xBB\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x57"],
        ["\xE6\xB2\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x84"],
        ["\xE7\x88\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x79"],
        ["\xE7\x92\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x49"],
        ["\xE7\x97\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x82"],
        ["\xE7\xA3\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x62"],
        ["\xE7\xA4\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x53"],
        ["\xE8\x80\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE6"],
        ["\xE8\x80\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xAB"],
        ["\xE8\x87\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC3"],
        ["\xE8\x92\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE3"],
        ["\xE8\xBE\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x74"],
        ["\xE6\xB1\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x6A"],
        ["\xE9\xB9\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x97"],
        ["\xE5\xBC\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x8F"],
        ["\xE8\xAD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x75"],
        ["\xE9\xB4\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xBA"],
        ["\xE7\xAB\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x5C"],
        ["\xE8\xBB\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA6"],
        ["\xE5\xAE\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x75"],
        ["\xE9\x9B\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA5"],
        ["\xE4\xB8\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x47"],
        ["\xE5\x8F\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x42"],
        ["\xE5\x9F\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x57"],
        ["\xE5\xA4\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x41"],
        ["\xE5\xAB\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE0"],
        ["\xE5\xAE\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB8"],
        ["\xE6\x82\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x69"],
        ["\xE6\xB9\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x90"],
        ["\xE6\xBC\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xAE"],
        ["\xE7\x96\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x42"],
        ["\xE8\xB3\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xEC"],
        ["\xE5\xAE\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xED"],
        ["\xE8\x94\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xBD"],
        ["\xE7\xAF\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x75"],
        ["\xE5\x81\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD2"],
        ["\xE6\x9F\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA7"],
        ["\xE8\x8A\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x72"],
        ["\xE5\xB1\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC0"],
        ["\xE8\x95\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA6"],
        ["\xE7\xB8\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x6B"],
        ["\xE8\x88\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x58"],
        ["\xE5\x86\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC4"],
        ["\xE5\xB0\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x8A"],
        ["\xE6\x8D\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB3"],
        ["\xE8\xB5\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x51"],
        ["\xE6\x96\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD1"],
        ["\xE7\x85\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x4C"],
        ["\xE7\xA4\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x63"],
        ["\xE7\xB4\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x47"],
        ["\xE8\x80\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x70"],
        ["\xE8\xAC\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xBB"],
        ["\xE8\xBB\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x53"],
        ["\xE9\x81\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x58"],
        ["\xE8\x9B\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xEA"],
        ["\xE9\x82\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB8"],
        ["\xE5\x80\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD0"],
        ["\xE5\x8B\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x70"],
        ["\xE5\xB0\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x6B"],
        ["\xE6\x9D\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC1"],
        ["\xE7\x81\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x6A"],
        ["\xE7\x88\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA9"],
        ["\xE9\x85\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xBB"],
        ["\xE9\x87\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x79"],
        ["\xE9\x8C\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x57"],
        ["\xE8\x8B\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD6"],
        ["\xE5\xAF\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE9"],
        ["\xE5\xBC\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x6E"],
        ["\xE6\x83\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x72"],
        ["\xE4\xB8\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x62"],
        ["\xE5\x8F\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA6"],
        ["\xE5\xAE\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF0"],
        ["\xE6\x89\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xCB"],
        ["\xE6\x9C\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x42"],
        ["\xE6\xAE\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x65"],
        ["\xE7\x8B\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x7B"],
        ["\xE7\x8F\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x99"],
        ["\xE7\xA8\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x92"],
        ["\xE8\x85\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xCE"],
        ["\xE8\xB6\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xED"],
        ["\xE9\x85\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x58"],
        ["\xE9\xA6\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xBE"],
        ["\xE5\x84\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x6F"],
        ["\xE5\x8F\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x4C"],
        ["\xE5\x91\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x8D"],
        ["\xE5\xAF\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB2"],
        ["\xE6\x8E\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x61"],
        ["\xE6\xA8\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xCF"],
        ["\xE7\xB6\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA3"],
        ["\xE9\x9C\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xFB"],
        ["\xE5\x9B\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x65"],
        ["\xE5\x8F\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x91"],
        ["\xE5\x91\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA1"],
        ["\xE5\xAE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xDD"],
        ["\xE5\xB0\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xEE"],
        ["\xE5\xB7\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x41"],
        ["\xE4\xBF\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xDE"],
        ["\xE6\x84\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x82"],
        ["\xE6\x8B\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD7"],
        ["\xE6\xB4\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x72"],
        ["\xE7\xA7\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF1"],
        ["\xE7\xA7\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x58"],
        ["\xE7\xB5\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF4"],
        ["\xE7\xB9\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xDA"],
        ["\xE7\xBF\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x69"],
        ["\xE8\x87\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB3"],
        ["\xE8\x88\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB8"],
        ["\xE8\x92\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x93"],
        ["\xE8\xA1\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x88"],
        ["\xE8\xA5\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xDF"],
        ["\xE8\xAE\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xFE"],
        ["\xE8\xB9\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF6"],
        ["\xE8\xBC\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA6"],
        ["\xE9\x80\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD3"],
        ["\xE9\x85\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x48"],
        ["\xE9\x85\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x49"],
        ["\xE9\x9B\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA0"],
        ["\xE9\x86\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x6F"],
        ["\xE4\xBB\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD9"],
        ["\xE4\xBD\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE0"],
        ["\xE5\x85\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC9"],
        ["\xE5\x8D\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x4A"],
        ["\xE5\xBE\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xFB"],
        ["\xE6\x88\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x7F"],
        ["\xE6\x9F\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xEA"],
        ["\xE6\xB1\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x84"],
        ["\xE6\xB8\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x92"],
        ["\xE7\x8D\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x65"],
        ["\xE7\xB8\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x93"],
        ["\xE9\x87\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA3"],
        ["\xE9\x8A\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE2"],
        ["\xE5\x8F\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA5"],
        ["\xE5\xA4\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xDD"],
        ["\xE5\xAE\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x82"],
        ["\xE6\xB7\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xBF"],
        ["\xE7\xA5\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xEB"],
        ["\xE7\xB8\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF7"],
        ["\xE7\xB2\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC8"],
        ["\xE5\xA1\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x79"],
        ["\xE7\x86\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xBF"],
        ["\xE5\x87\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x9B"],
        ["\xE8\xA1\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x6C"],
        ["\xE8\xBF\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x9C"],
        ["\xE4\xBF\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x60"],
        ["\xE5\xB3\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x72"],
        ["\xE6\x98\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x62"],
        ["\xE7\x9E\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB0"],
        ["\xE7\xAB\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x6B"],
        ["\xE8\x88\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB8"],
        ["\xE9\xA7\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC0"],
        ["\xE5\x87\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x80"],
        ["\xE5\xBE\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF5"],
        ["\xE6\x97\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x67"],
        ["\xE6\xA5\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xAE"],
        ["\xE6\xAE\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA4"],
        ["\xE6\xB7\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x94"],
        ["\xE6\xBA\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xCE"],
        ["\xE6\xBD\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD2"],
        ["\xE7\x9B\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x82"],
        ["\xE7\xB4\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA6"],
        ["\xE5\xB7\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x47"],
        ["\xE9\x81\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x6E"],
        ["\xE9\x86\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA9"],
        ["\xE9\xA0\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB2"],
        ["\xE5\x87\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE6"],
        ["\xE5\x88\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x4B"],
        ["\xE6\x89\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x8C"],
        ["\xE6\x9A\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xBE"],
        ["\xE6\x9B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x52"],
        ["\xE6\xB8\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE4"],
        ["\xE5\xBA\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC1"],
        ["\xE7\xB7\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x9B"],
        ["\xE7\xBD\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x99"],
        ["\xE6\x9B\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x9D"],
        ["\xE8\x96\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF9"],
        ["\xE8\x97\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE2"],
        ["\xE8\xAB\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE2"],
        ["\xE5\x8A\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x71"],
        ["\xE5\x8F\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF5"],
        ["\xE5\xA5\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x99"],
        ["\xE5\xBA\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x4F"],
        ["\xE5\xBE\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB3"],
        ["\xE6\x81\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x98"],
        ["\xE9\x8B\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC0"],
        ["\xE9\x99\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x6D"],
        ["\xE5\x82\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x5B"],
        ["\xE5\x84\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA2"],
        ["\xE5\x8B\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB5"],
        ["\xE5\x8C\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x6B"],
        ["\xE5\x8D\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x47"],
        ["\xE5\x8F\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x86"],
        ["\xE5\x93\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x68"],
        ["\xE5\x95\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xBE"],
        ["\xE5\x94\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x43"],
        ["\xE5\x98\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xEC"],
        ["\xE5\xA5\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xCA"],
        ["\xE5\xA6\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xAF"],
        ["\xE5\xA8\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x98"],
        ["\xE5\xAE\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xEF"],
        ["\xE5\xB0\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x59"],
        ["\xE5\xB0\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x5D"],
        ["\xE5\xB0\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x4A"],
        ["\xE5\xB0\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x71"],
        ["\xE5\xBA\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x50"],
        ["\xE5\xBA\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xED"],
        ["\xE5\xBB\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x62"],
        ["\xE5\xBD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x64"],
        ["\xE6\x89\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x48"],
        ["\xE6\x8A\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC0"],
        ["\xE6\x8B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xFD"],
        ["\xE6\x8E\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xEC"],
        ["\xE6\x8D\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x8F"],
        ["\xE6\x98\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xFE"],
        ["\xE6\x98\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD1"],
        ["\xE6\x98\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB3"],
        ["\xE6\x99\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF8"],
        ["\xE6\x9D\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x78"],
        ["\xE6\xA2\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xAC"],
        ["\xE6\xA8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x9B"],
        ["\xE6\xA8\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x85"],
        ["\xE6\xB2\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC6"],
        ["\xE6\xB6\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x6B"],
        ["\xE6\xB8\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC0"],
        ["\xE6\xB9\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x55"],
        ["\xE7\x84\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x83"],
        ["\xE7\x84\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE6"],
        ["\xE7\x85\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x42"],
        ["\xE7\x97\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x4A"],
        ["\xE7\x9C\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x47"],
        ["\xE7\xA1\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x76"],
        ["\xE7\xA4\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB0"],
        ["\xE7\xA5\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF9"],
        ["\xE7\xA7\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xDF"],
        ["\xE7\xAB\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x6E"],
        ["\xE7\xAC\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB5"],
        ["\xE7\xB2\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD4"],
        ["\xE7\xB4\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE4"],
        ["\xE8\x82\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x67"],
        ["\xE8\x8F\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x80"],
        ["\xE8\x92\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF8"],
        ["\xE8\x95\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA8"],
        ["\xE8\xA1\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA5"],
        ["\xE8\xA3\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA8"],
        ["\xE8\xA8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xEF"],
        ["\xE8\xA8\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xBA"],
        ["\xE8\xA9\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x88"],
        ["\xE8\xA9\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE7"],
        ["\xE8\xB1\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x94"],
        ["\xE8\xB3\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xAD"],
        ["\xE9\x86\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x7F"],
        ["\xE9\x89\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB4"],
        ["\xE9\x8D\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xBD"],
        ["\xE9\x90\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC8"],
        ["\xE9\x9A\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF9"],
        ["\xE9\x9E\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE7"],
        ["\xE4\xB8\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x5E"],
        ["\xE4\xB8\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD3"],
        ["\xE4\xB8\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x62"],
        ["\xE4\xB9\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x47"],
        ["\xE5\x86\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x7E"],
        ["\xE5\x89\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x85"],
        ["\xE5\x9F\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xDB"],
        ["\xE5\xA0\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD9"],
        ["\xE5\xA3\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x96"],
        ["\xE5\xAC\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE4"],
        ["\xE5\xB8\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xEF"],
        ["\xE6\x83\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x5F"],
        ["\xE6\x93\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF6"],
        ["\xE6\x9D\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x5E"],
        ["\xE6\x9D\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF4"],
        ["\xE6\xB5\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC9"],
        ["\xE7\x8A\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x52"],
        ["\xE7\x95\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x54"],
        ["\xE7\xA9\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x98"],
        ["\xE8\x92\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xBA"],
        ["\xE8\xAD\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x7B"],
        ["\xE9\x86\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC2"],
        ["\xE9\x8C\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x57"],
        ["\xE5\x98\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xCA"],
        ["\xE5\x9F\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x48"],
        ["\xE9\xA3\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x57"],
        ["\xE6\x8B\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE5"],
        ["\xE6\xA4\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC5"],
        ["\xE6\xAE\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x73"],
        ["\xE7\x87\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE6"],
        ["\xE7\xB9\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x9A"],
        ["\xE8\x81\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD7"],
        ["\xE8\x89\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC3"],
        ["\xE8\xA7\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD1"],
        ["\xE9\xA3\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB8"],
        ["\xE8\x9D\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x47"],
        ["\xE8\xBE\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE5"],
        ["\xE5\xB0\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xCE"],
        ["\xE4\xBC\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF4"],
        ["\xE4\xBF\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA5"],
        ["\xE4\xBE\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x8C"],
        ["\xE5\x94\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x76"],
        ["\xE5\xA8\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x4C"],
        ["\xE5\xAF\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x59"],
        ["\xE5\xAF\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x87"],
        ["\xE5\xBF\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE7"],
        ["\xE6\x85\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x76"],
        ["\xE6\x8C\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF6"],
        ["\xE6\x96\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x87"],
        ["\xE6\x99\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB2"],
        ["\xE6\xA3\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x9D"],
        ["\xE6\xA6\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x7E"],
        ["\xE6\xB5\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x41"],
        ["\xE6\xB7\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x77"],
        ["\xE7\x94\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x67"],
        ["\xE7\x96\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE1"],
        ["\xE7\x9C\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x42"],
        ["\xE7\xA5\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA1"],
        ["\xE7\xA7\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x8A"],
        ["\xE7\xB4\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x59"],
        ["\xE8\x87\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x47"],
        ["\xE8\x8A\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE5"],
        ["\xE8\x96\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x5A"],
        ["\xE8\xA6\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x85"],
        ["\xE8\xA8\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x68"],
        ["\xE8\xBA\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x9C"],
        ["\xE8\xBE\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x5E"],
        ["\xE9\x80\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x69"],
        ["\xE9\x87\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x88"],
        ["\xE9\x9C\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xDE"],
        ["\xE4\xBA\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x93"],
        ["\xE4\xBB\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x76"],
        ["\xE5\x88\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x44"],
        ["\xE5\xA1\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x89"],
        ["\xE5\xA3\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x4F"],
        ["\xE5\xB0\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x5F"],
        ["\xE7\x94\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x66"],
        ["\xE5\xB0\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB9"],
        ["\xE8\x85\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC4"],
        ["\xE8\xA8\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF2"],
        ["\xE8\xBF\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x68"],
        ["\xE9\x99\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x84"],
        ["\xE9\x9D\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xAB"],
        ["\xE7\xAC\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF4"],
        ["\xE8\xAB\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC1"],
        ["\xE9\xA0\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB0"],
        ["\xE9\x85\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xAE"],
        ["\xE5\x9B\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC1"],
        ["\xE5\x8E\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x78"],
        ["\xE9\x80\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB3"],
        ["\xE5\x90\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC4"],
        ["\xE5\x9E\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC9"],
        ["\xE5\xB8\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xAF"],
        ["\xE6\x8E\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD5"],
        ["\xE6\xB0\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x9C"],
        ["\xE7\x82\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xCB"],
        ["\xE7\x9D\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x6C"],
        ["\xE7\xB2\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xCC"],
        ["\xE7\xBF\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x69"],
        ["\xE8\xA1\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x54"],
        ["\xE9\x81\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF7"],
        ["\xE9\x85\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x7C"],
        ["\xE9\x8C\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x90"],
        ["\xE9\x8C\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xEF"],
        ["\xE9\x9A\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x76"],
        ["\xE7\x91\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x5B"],
        ["\xE9\xAB\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC5"],
        ["\xE5\xB4\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x7F"],
        ["\xE5\xB5\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x9E"],
        ["\xE6\x95\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xCC"],
        ["\xE6\x9E\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD0"],
        ["\xE8\xB6\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x61"],
        ["\xE9\x9B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xFB"],
        ["\xE6\x8D\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD6"],
        ["\xE6\x9D\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x68"],
        ["\xE6\xA4\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xED"],
        ["\xE8\x8F\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x53"],
        ["\xE9\xA0\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE4"],
        ["\xE9\x9B\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x64"],
        ["\xE8\xA3\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x8D"],
        ["\xE6\xBE\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x87"],
        ["\xE6\x91\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xEF"],
        ["\xE5\xAF\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x60"],
        ["\xE4\xB8\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x9B"],
        ["\xE7\x80\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x5B"],
        ["\xE7\x95\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x86"],
        ["\xE6\x98\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xBB"],
        ["\xE5\x87\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xDC"],
        ["\xE5\x88\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC4"],
        ["\xE5\x8B\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xEE"],
        ["\xE5\xA7\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF1"],
        ["\xE5\xBE\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x61"],
        ["\xE6\x80\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x6E"],
        ["\xE6\x88\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xBA"],
        ["\xE6\x94\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC7"],
        ["\xE6\x95\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x7C"],
        ["\xE6\x98\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA9"],
        ["\xE6\x99\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x95"],
        ["\xE6\xA3\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x75"],
        ["\xE6\xA0\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xCC"],
        ["\xE6\xAD\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x77"],
        ["\xE6\xB8\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x96"],
        ["\xE7\x89\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x58"],
        ["\xE7\x94\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x99"],
        ["\xE7\x9B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x44"],
        ["\xE7\xB2\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x6C"],
        ["\xE8\x81\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB5"],
        ["\xE5\xA3\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x6C"],
        ["\xE8\xA3\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x7B"],
        ["\xE8\xA5\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x58"],
        ["\xE8\xAA\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xFD"],
        ["\xE8\xAA\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA0"],
        ["\xE8\xAB\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE8"],
        ["\xE9\x80\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB1"],
        ["\xE9\x86\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x78"],
        ["\xE9\x9D\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x4C"],
        ["\xE9\x9D\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x44"],
        ["\xE6\x96\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x8E"],
        ["\xE7\xA8\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC4"],
        ["\xE8\x84\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xEC"],
        ["\xE9\x9A\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xDA"],
        ["\xE5\xB8\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x53"],
        ["\xE6\x83\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD7"],
        ["\xE6\x88\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x95"],
        ["\xE6\x96\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x41"],
        ["\xE6\x98\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x59"],
        ["\xE6\x9E\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE2"],
        ["\xE7\x9F\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x80"],
        ["\xE7\xA9\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x91"],
        ["\xE7\xB1\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xFE"],
        ["\xE7\xB8\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x66"],
        ["\xE8\x84\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x5E"],
        ["\xE8\xB2\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD2"],
        ["\xE8\xB5\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF9"],
        ["\xE8\xB7\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xCD"],
        ["\xE8\xB9\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x68"],
        ["\xE7\xA2\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x7D"],
        ["\xE5\x88\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x65"],
        ["\xE6\x8B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x5C"],
        ["\xE6\x8E\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA8"],
        ["\xE6\x91\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x8C"],
        ["\xE6\x8A\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x8D"],
        ["\xE8\xA8\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE2"],
        ["\xE7\xAA\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x69"],
        ["\xE7\xAF\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA1"],
        ["\xE8\xAA\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x52"],
        ["\xE9\x9B\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xBB"],
        ["\xE7\xB5\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF3"],
        ["\xE8\x88\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x94"],
        ["\xE8\x9D\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE8"],
        ["\xE4\xBB\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA2"],
        ["\xE5\x85\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA2"],
        ["\xE5\x8D\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x4C"],
        ["\xE5\x8D\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xEE"],
        ["\xE5\xAE\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x8F"],
        ["\xE5\xB0\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xFB"],
        ["\xE5\xB0\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC0"],
        ["\xE5\xB7\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x67"],
        ["\xE6\x88\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x64"],
        ["\xE6\x89\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xCA"],
        ["\xE6\x92\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x72"],
        ["\xE6\xA0\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE3"],
        ["\xE6\xA0\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xDA"],
        ["\xE6\xB3\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xEE"],
        ["\xE6\xB5\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x8D"],
        ["\xE6\xB4\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x4E"],
        ["\xE6\x9F\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x9B"],
        ["\xE6\xBD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC0"],
        ["\xE7\x85\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x90"],
        ["\xE7\x85\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x90"],
        ["\xE6\x97\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x7B"],
        ["\xE7\xA9\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x91"],
        ["\xE7\xAE\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x8D"],
        ["\xE7\xB7\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x87"],
        ["\xE7\xB9\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x68"],
        ["\xE7\xBE\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x96"],
        ["\xE8\x85\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x6F"],
        ["\xE8\x88\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC1"],
        ["\xE8\x88\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x7B"],
        ["\xE8\x96\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xBF"],
        ["\xE8\xA9\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x8E"],
        ["\xE8\xB3\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x78"],
        ["\xE8\xB7\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD1"],
        ["\xE9\x81\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x5D"],
        ["\xE9\x81\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x5B"],
        ["\xE9\x8A\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x48"],
        ["\xE9\x8A\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xAD"],
        ["\xE9\x96\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x9C"],
        ["\xE9\xAE\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE9"],
        ["\xE5\x89\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xAF"],
        ["\xE5\x96\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB3"],
        ["\xE6\xBC\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x73"],
        ["\xE7\x84\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xEF"],
        ["\xE5\x85\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB1"],
        ["\xE7\xA6\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x87"],
        ["\xE7\xB9\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD4"],
        ["\xE8\x86\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x76"],
        ["\xE7\xB3\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x60"],
        ["\xE5\x99\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x62"],
        ["\xE5\xA1\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC6"],
        ["\xE5\xB2\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB9"],
        ["\xE6\x8E\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x60"],
        ["\xE6\x9B\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x66"],
        ["\xE6\x9B\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x5F"],
        ["\xE6\xA5\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x4C"],
        ["\xE7\x8B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xCF"],
        ["\xE7\x96\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB0"],
        ["\xE7\x96\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x71"],
        ["\xE7\xA4\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x9C"],
        ["\xE7\xA5\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xDC"],
        ["\xE7\xA7\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x83"],
        ["\xE7\xB2\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x59"],
        ["\xE7\xB4\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x9F"],
        ["\xE7\xB5\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB9"],
        ["\xE8\x98\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xBF"],
        ["\xE8\xA8\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xDF"],
        ["\xE9\x98\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xEF"],
        ["\xE9\x81\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x4C"],
        ["\xE9\xBC\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xCB"],
        ["\xE5\x83\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x84"],
        ["\xE5\x89\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE1"],
        ["\xE5\x8F\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x71"],
        ["\xE5\x8F\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF5"],
        ["\xE5\x80\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD6"],
        ["\xE5\x96\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x68"],
        ["\xE5\xA3\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x9F"],
        ["\xE5\xA5\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x53"],
        ["\xE7\x88\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xDD"],
        ["\xE5\xAE\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x4D"],
        ["\xE5\xB1\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x8E"],
        ["\xE5\x8C\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB7"],
        ["\xE6\x83\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x68"],
        ["\xE6\x83\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB3"],
        ["\xE6\x8D\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xDD"],
        ["\xE6\x8E\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC3"],
        ["\xE6\x8C\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x55"],
        ["\xE6\x8E\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA3"],
        ["\xE6\x93\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x9B"],
        ["\xE6\x97\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE9"],
        ["\xE6\x9B\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD2"],
        ["\xE5\xB7\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x67"],
        ["\xE6\xA7\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xDB"],
        ["\xE6\xA7\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB7"],
        ["\xE6\xBC\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA1"],
        ["\xE7\x87\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x66"],
        ["\xE4\xBA\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x96"],
        ["\xE7\x97\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA4"],
        ["\xE7\x9B\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x78"],
        ["\xE7\xAA\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE9"],
        ["\xE7\xB3\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x8C"],
        ["\xE7\xB7\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x93"],
        ["\xE7\xB6\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x70"],
        ["\xE8\x81\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x89"],
        ["\xE8\x8D\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x42"],
        ["\xE8\x8D\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x62"],
        ["\xE8\x91\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x79"],
        ["\xE8\x92\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB9"],
        ["\xE8\x97\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x5F"],
        ["\xE8\xA3\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x98"],
        ["\xE8\xB5\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xAA"],
        ["\xE9\x80\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x44"],
        ["\xE9\x81\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x43"],
        ["\xE9\x8E\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x97"],
        ["\xE9\x9C\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE8"],
        ["\xE9\xA8\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD2"],
        ["\xE5\x83\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xBA"],
        ["\xE5\xA2\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x4D"],
        ["\xE6\x86\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x4A"],
        ["\xE8\x87\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xBD"],
        ["\xE8\x94\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x5E"],
        ["\xE8\xB4\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x7C"],
        ["\xE9\x80\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB8"],
        ["\xE4\xBF\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x6A"],
        ["\xE5\x81\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x43"],
        ["\xE5\x89\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x4D"],
        ["\xE5\x8D\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x6D"],
        ["\xE6\x81\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB0"],
        ["\xE6\x8D\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA0"],
        ["\xE6\x9D\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x4B"],
        ["\xE6\xB8\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x45"],
        ["\xE8\xB6\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xFA"],
        ["\xE9\x80\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xCD"],
        ["\xE4\xBF\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x97"],
        ["\xE5\xB1\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x6D"],
        ["\xE8\xB3\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xFD"],
        ["\xE6\x97\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xDC"],
        ["\xE7\xB6\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xCB"],
        ["\xE5\x8D\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF2"],
        ["\xE8\xA2\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x57"],
        ["\xE5\x85\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x67"],
        ["\xE6\x8F\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xFD"],
        ["\xE5\xAD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x41"],
        ["\xE5\xAD\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x5E"],
        ["\xE5\xB0\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xEF"],
        ["\xE6\x90\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD8"],
        ["\xE6\x9D\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x56"],
        ["\xE9\x81\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x55"],
        ["\xE4\xBB\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x55"],
        ["\xE5\xA4\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xFE"],
        ["\xE5\xA4\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xAB"],
        ["\xE6\xB1\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD2"],
        ["\xE8\xA9\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE3"],
        ["\xE5\x94\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x78"],
        ["\xE5\xA0\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB0"],
        ["\xE5\xA6\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x9E"],
        ["\xE6\x83\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB8"],
        ["\xE6\x89\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xEA"],
        ["\xE6\x9F\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xCD"],
        ["\xE8\x88\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xDB"],
        ["\xE6\xA5\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC5"],
        ["\xE9\x99\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE8"],
        ["\xE9\xA7\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE5"],
        ["\xE9\xA8\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xDA"],
        ["\xE4\xBD\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x96"],
        ["\xE5\xA0\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x71"],
        ["\xE5\xAF\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x56"],
        ["\xE8\x80\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x8E"],
        ["\xE5\xB2\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x62"],
        ["\xE5\xB8\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x60"],
        ["\xE5\xBE\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA3"],
        ["\xE6\x80\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x81"],
        ["\xE6\x85\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xFD"],
        ["\xE6\x88\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x92"],
        ["\xE6\x9B\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC3"],
        ["\xE6\xB3\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF3"],
        ["\xE6\xBB\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA1"],
        ["\xE8\x83\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x63"],
        ["\xE8\x85\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x9A"],
        ["\xE8\x8B\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD7"],
        ["\xE8\xA2\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x54"],
        ["\xE8\xB2\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF4"],
        ["\xE9\x80\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x49"],
        ["\xE9\x80\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x77"],
        ["\xE9\x9A\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x93"],
        ["\xE9\xBB\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xDD"],
        ["\xE9\xAF\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD8"],
        ["\xE4\xBB\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x9A"],
        ["\xE5\x8F\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x78"],
        ["\xE5\xA4\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x5B"],
        ["\xE7\xAC\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x7E"],
        ["\xE9\x86\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x6F"],
        ["\xE9\xA1\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xFE"],
        ["\xE9\xB7\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x7A"],
        ["\xE6\xBB\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA3"],
        ["\xE7\x80\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xAE"],
        ["\xE5\x8D\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x96"],
        ["\xE5\x95\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x83"],
        ["\xE5\xAE\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x6F"],
        ["\xE6\x89\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD5"],
        ["\xE6\x8A\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x7E"],
        ["\xE6\x8B\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xDB"],
        ["\xE6\xB2\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x85"],
        ["\xE6\xBF\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD4"],
        ["\xE7\x90\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x5C"],
        ["\xE8\xA8\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB6"],
        ["\xE9\x90\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x88"],
        ["\xE6\xBF\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xBE"],
        ["\xE8\xAB\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE1"],
        ["\xE8\x8C\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF7"],
        ["\xE5\x87\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x8A"],
        ["\xE8\x9B\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x4E"],
        ["\xE5\x8F\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x41"],
        ["\xE5\x8F\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x71"],
        ["\xE4\xBD\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xFE"],
        ["\xE9\x81\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA4"],
        ["\xE8\xBE\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xDF"],
        ["\xE5\xA5\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xBB"],
        ["\xE8\x84\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB4"],
        ["\xE5\xB7\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x46"],
        ["\xE7\xAB\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC8"],
        ["\xE8\xBE\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x7E"],
        ["\xE6\xA3\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xEF"],
        ["\xE8\xB0\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x81"],
        ["\xE7\x8B\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xFE"],
        ["\xE9\xB1\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x60"],
        ["\xE6\xA8\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xBE"],
        ["\xE8\xAA\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x83"],
        ["\xE4\xB8\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xAB"],
        ["\xE5\x8D\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE3"],
        ["\xE5\x98\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x63"],
        ["\xE5\x9D\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC4"],
        ["\xE6\x8B\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA1"],
        ["\xE6\x8E\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x7F"],
        ["\xE6\x97\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x9D"],
        ["\xE6\xAD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x87"],
        ["\xE6\xB7\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA5"],
        ["\xE6\xB9\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF3"],
        ["\xE7\x82\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x61"],
        ["\xE7\x9F\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x82"],
        ["\xE7\xAB\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xEF"],
        ["\xE7\xAE\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xCA"],
        ["\xE7\xB6\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA6"],
        ["\xE8\x80\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB8"],
        ["\xE8\x83\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x9B"],
        ["\xE8\x9B\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD8"],
        ["\xE8\xAA\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA2"],
        ["\xE9\x8D\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC7"],
        ["\xE5\x9B\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF0"],
        ["\xE5\xA3\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x8E"],
        ["\xE5\xBC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD4"],
        ["\xE6\x96\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x89"],
        ["\xE6\x9A\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x6C"],
        ["\xE6\xAA\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF5"],
        ["\xE6\xAE\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xED"],
        ["\xE7\x94\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x7C"],
        ["\xE8\xAB\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x63"],
        ["\xE5\x80\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x7D"],
        ["\xE7\x9F\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB0"],
        ["\xE5\x9C\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC2"],
        ["\xE5\xBC\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x97"],
        ["\xE6\x81\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xCE"],
        ["\xE6\x99\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA8"],
        ["\xE6\xB1\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE8"],
        ["\xE7\x97\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x89"],
        ["\xE7\xA8\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xCF"],
        ["\xE7\xBD\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x8C"],
        ["\xE8\x87\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x6A"],
        ["\xE8\x9C\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xDC"],
        ["\xE9\x81\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x6D"],
        ["\xE9\xA6\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xDF"],
        ["\xE7\xAF\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA8"],
        ["\xE7\x95\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x72"],
        ["\xE7\xAB\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF5"],
        ["\xE7\xAD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x45"],
        ["\xE8\x93\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x94"],
        ["\xE9\x80\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xBB"],
        ["\xE7\xA7\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x9F"],
        ["\xE7\xAA\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB0"],
        ["\xE8\x8C\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x77"],
        ["\xE5\xAB\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x67"],
        ["\xE7\x9D\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xAA"],
        ["\xE4\xB8\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x5C"],
        ["\xE4\xBB\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x69"],
        ["\xE5\xAE\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x64"],
        ["\xE5\xBF\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x4F"],
        ["\xE6\x8A\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x53"],
        ["\xE6\x98\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x98"],
        ["\xE6\x9F\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xEA"],
        ["\xE6\xB3\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x44"],
        ["\xE8\x99\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xCB"],
        ["\xE8\xA1\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE9"],
        ["\xE8\xA8\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x66"],
        ["\xE9\x85\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x91"],
        ["\xE9\x8B\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC1"],
        ["\xE9\xA7\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF5"],
        ["\xE6\xA8\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x8B"],
        ["\xE7\x80\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xDE"],
        ["\xE7\x8C\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC5"],
        ["\xE8\x8B\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB0"],
        ["\xE8\x91\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x59"],
        ["\xE8\xB2\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x62"],
        ["\xE4\xB8\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xCE"],
        ["\xE5\x85\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF3"],
        ["\xE5\x87\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF9"],
        ["\xE5\x96\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x58"],
        ["\xE5\xAF\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x56"],
        ["\xE5\xB8\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC7"],
        ["\xE5\xB8\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC5"],
        ["\xE5\xBA\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x92"],
        ["\xE5\xBC\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE5"],
        ["\xE5\xBC\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xBA"],
        ["\xE5\xBD\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x86"],
        ["\xE5\xBE\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x74"],
        ["\xE6\x87\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x53"],
        ["\xE6\x8C\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xDB"],
        ["\xE6\x9A\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC7"],
        ["\xE6\x9C\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x5C"],
        ["\xE6\xBD\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x93"],
        ["\xE7\x89\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xDD"],
        ["\xE7\x94\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x55"],
        ["\xE7\x9C\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x5F"],
        ["\xE8\x81\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA8"],
        ["\xE8\x84\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE9"],
        ["\xE8\x85\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB6"],
        ["\xE8\x9D\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x6E"],
        ["\xE8\xAA\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x89"],
        ["\xE8\xAB\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x70"],
        ["\xE8\xB6\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x78"],
        ["\xE8\xB7\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB4"],
        ["\xE9\x8A\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x80"],
        ["\xE9\x95\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x83"],
        ["\xE9\xA0\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x5B"],
        ["\xE9\xB3\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x79"],
        ["\xE5\x8B\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xEF"],
        ["\xE6\x8D\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x46"],
        ["\xE7\x9B\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x74"],
        ["\xE6\x9C\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF3"],
        ["\xE6\xB2\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x8F"],
        ["\xE7\x8F\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x5D"],
        ["\xE8\xB3\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x4D"],
        ["\xE9\x8E\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x89"],
        ["\xE9\x99\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x61"],
        ["\xE6\xB4\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xDC"],
        ["\xE5\xA2\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x50"],
        ["\xE6\xA4\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA0"],
        ["\xE6\xA7\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xFA"],
        ["\xE8\xBF\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD1"],
        ["\xE9\x8E\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xFE"],
        ["\xE7\x97\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x47"],
        ["\xE9\x80\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE3"],
        ["\xE5\xA1\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x57"],
        ["\xE6\xA0\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD1"],
        ["\xE6\x8E\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xCD"],
        ["\xE6\xA7\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x5C"],
        ["\xE4\xBD\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xDF"],
        ["\xE6\xBC\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x8A"],
        ["\xE6\x9F\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD8"],
        ["\xE8\xBE\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF5"],
        ["\xE8\x94\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA1"],
        ["\xE7\xB6\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC9"],
        ["\xE9\x8D\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xAA"],
        ["\xE6\xA4\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xBA"],
        ["\xE6\xBD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x46"],
        ["\xE5\x9D\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x49"],
        ["\xE5\xA3\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x9B"],
        ["\xE5\xAC\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xEA"],
        ["\xE7\xB4\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x92"],
        ["\xE7\x88\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x87"],
        ["\xE5\x90\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD3"],
        ["\xE9\x87\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE3"],
        ["\xE9\xB6\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x7A"],
        ["\xE4\xBA\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x52"],
        ["\xE4\xBD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA4"],
        ["\xE5\x81\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x70"],
        ["\xE5\x81\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x95"],
        ["\xE5\x89\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x79"],
        ["\xE8\xB2\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB6"],
        ["\xE5\x91\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x56"],
        ["\xE5\xA0\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x61"],
        ["\xE5\xAE\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE7"],
        ["\xE5\xB8\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x9C"],
        ["\xE5\xBA\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x64"],
        ["\xE5\xBA\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE0"],
        ["\xE5\xBB\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x5B"],
        ["\xE5\xBC\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x9B"],
        ["\xE6\x82\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE3"],
        ["\xE6\x8A\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x90"],
        ["\xE6\x8C\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x87"],
        ["\xE6\x8F\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB9"],
        ["\xE6\xA2\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE4"],
        ["\xE6\xB1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x4D"],
        ["\xE7\xA2\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x95"],
        ["\xE7\xA6\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA7"],
        ["\xE7\xA8\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF4"],
        ["\xE7\xB7\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x80"],
        ["\xE8\x89\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xFC"],
        ["\xE8\xA8\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC4"],
        ["\xE8\xAB\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x46"],
        ["\xE8\xB9\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA7"],
        ["\xE9\x80\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x5E"],
        ["\xE9\x82\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x81"],
        ["\xE9\x84\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x54"],
        ["\xE9\x87\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF4"],
        ["\xE9\xBC\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xAA"],
        ["\xE6\xB3\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x56"],
        ["\xE6\x91\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xCB"],
        ["\xE6\x93\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x43"],
        ["\xE6\x95\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF3"],
        ["\xE6\xBB\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB7"],
        ["\xE7\x9A\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xEF"],
        ["\xE7\xAC\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x41"],
        ["\xE9\x81\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xCC"],
        ["\xE9\x8F\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x41"],
        ["\xE6\xBA\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x97"],
        ["\xE5\x93\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x47"],
        ["\xE5\xBE\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF8"],
        ["\xE6\x92\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x7A"],
        ["\xE8\xBD\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xEE"],
        ["\xE8\xBF\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xDF"],
        ["\xE9\x89\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD7"],
        ["\xE5\x85\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC9"],
        ["\xE5\xA1\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x5E"],
        ["\xE5\xA4\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x8A"],
        ["\xE5\xB1\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xDD"],
        ["\xE5\xBA\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x54"],
        ["\xE6\xB7\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x91"],
        ["\xE7\xBA\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xFA"],
        ["\xE7\x94\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA7"],
        ["\xE8\xB2\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x7B"],
        ["\xE8\xBB\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x52"],
        ["\xE9\xA1\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC1"],
        ["\xE7\x82\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x88"],
        ["\xE4\xBC\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD9"],
        ["\xE6\xAE\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x49"],
        ["\xE6\xBE\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x89"],
        ["\xE7\x94\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x63"],
        ["\xE9\x9B\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x82"],
        ["\xE5\x85\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x50"],
        ["\xE5\x90\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB2"],
        ["\xE5\xA0\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF6"],
        ["\xE5\xA1\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x6A"],
        ["\xE5\xA6\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x7F"],
        ["\xE5\xB1\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xFB"],
        ["\xE5\xBE\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x6C"],
        ["\xE6\x96\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x83"],
        ["\xE6\x9D\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x5D"],
        ["\xE6\xB8\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD2"],
        ["\xE7\x99\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE8"],
        ["\xE8\x8F\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD4"],
        ["\xE8\xB3\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC1"],
        ["\xE9\x80\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF0"],
        ["\xE9\x83\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x4F"],
        ["\xE9\x8D\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD3"],
        ["\xE7\xA0\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x45"],
        ["\xE7\xA0\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xDF"],
        ["\xE5\x8A\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x64"],
        ["\xE5\xBA\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xDE"],
        ["\xE5\x9C\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x84"],
        ["\xE5\xA5\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x90"],
        ["\xE6\x80\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD6"],
        ["\xE5\x80\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x6A"],
        ["\xE5\x85\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x4B"],
        ["\xE5\x86\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xDE"],
        ["\xE5\x87\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE6"],
        ["\xE5\x88\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x50"],
        ["\xE5\x94\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xAB"],
        ["\xE5\xA1\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xCB"],
        ["\xE5\xA1\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF8"],
        ["\xE5\xA5\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x83"],
        ["\xE5\xAE\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x5C"],
        ["\xE5\xB3\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x6F"],
        ["\xE5\xB6\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD1"],
        ["\xE6\x82\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x45"],
        ["\xE6\x8A\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x51"],
        ["\xE6\x90\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x8F"],
        ["\xE6\x9D\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x57"],
        ["\xE6\xA1\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xDA"],
        ["\xE6\xA2\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x49"],
        ["\xE6\xA3\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA9"],
        ["\xE7\x9B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x65"],
        ["\xE6\xB7\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE1"],
        ["\xE6\xB9\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xBD"],
        ["\xE6\xB6\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x69"],
        ["\xE7\x81\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x65"],
        ["\xE7\x87\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF8"],
        ["\xE5\xBD\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x5F"],
        ["\xE7\x97\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x49"],
        ["\xE7\xA5\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x53"],
        ["\xE7\xAD\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA7"],
        ["\xE7\xAD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD0"],
        ["\xE7\xAD\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x7C"],
        ["\xE7\xB3\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x84"],
        ["\xE7\xB5\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x81"],
        ["\xE5\x88\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xDD"],
        ["\xE8\x91\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x71"],
        ["\xE8\x95\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF0"],
        ["\xE8\x97\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x68"],
        ["\xE8\xA8\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD2"],
        ["\xE8\xAC\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE2"],
        ["\xE8\xB1\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x99"],
        ["\xE8\xB8\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x7C"],
        ["\xE9\x80\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x72"],
        ["\xE9\x80\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xDA"],
        ["\xE9\x90\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xCF"],
        ["\xE9\x99\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB7"],
        ["\xE9\xA0\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xEB"],
        ["\xE9\xA8\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x5E"],
        ["\xE9\x97\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xCC"],
        ["\xE5\x83\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xEC"],
        ["\xE5\x8B\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE4"],
        ["\xE5\x90\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x6D"],
        ["\xE5\xA0\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x7F"],
        ["\xE5\xB0\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xAE"],
        ["\xE6\x86\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC2"],
        ["\xE6\x92\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xDB"],
        ["\xE6\xB4\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x98"],
        ["\xE7\x9E\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x9B"],
        ["\xE7\xAB\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x50"],
        ["\xE8\x83\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xAB"],
        ["\xE8\x90\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF7"],
        ["\xE9\x81\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x50"],
        ["\xE9\x8A\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC0"],
        ["\xE5\xB3\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x96"],
        ["\xE9\xB4\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA1"],
        ["\xE5\x8C\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF1"],
        ["\xE5\xBE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE8"],
        ["\xE5\xBE\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x54"],
        ["\xE6\xB6\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x50"],
        ["\xE7\x89\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA2"],
        ["\xE7\x9D\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x73"],
        ["\xE7\xA6\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD0"],
        ["\xE7\xAF\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD8"],
        ["\xE6\xAF\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x97"],
        ["\xE7\x8B\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xDB"],
        ["\xE8\xAA\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x4F"],
        ["\xE6\xA0\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD3"],
        ["\xE6\xA9\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD4"],
        ["\xE5\x87\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xCF"],
        ["\xE7\xAA\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xFD"],
        ["\xE6\xA4\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA7"],
        ["\xE5\xB1\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA7"],
        ["\xE9\xB3\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC4"],
        ["\xE8\x8B\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x5A"],
        ["\xE5\xAF\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x84"],
        ["\xE9\x85\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x73"],
        ["\xE7\x80\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x5C"],
        ["\xE5\x99\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF1"],
        ["\xE5\xB1\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xDD"],
        ["\xE6\x83\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x65"],
        ["\xE6\x95\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF2"],
        ["\xE6\xB2\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x98"],
        ["\xE8\xB1\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xCF"],
        ["\xE9\x81\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF8"],
        ["\xE9\xA0\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x7A"],
        ["\xE5\x91\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB0"],
        ["\xE6\x9B\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x56"],
        ["\xE9\x88\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x63"],
        ["\xE5\xA5\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE6"],
        ["\xE9\x82\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x46"],
        ["\xE5\x86\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x8E"],
        ["\xE4\xB9\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA9"],
        ["\xE5\x87\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x9E"],
        ["\xE8\x96\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xAD"],
        ["\xE8\xAC\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF9"],
        ["\xE7\x81\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x96"],
        ["\xE6\x8D\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC0"],
        ["\xE9\x8D\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x48"],
        ["\xE6\xA5\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x93"],
        ["\xE9\xA6\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA1"],
        ["\xE7\xB8\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x59"],
        ["\xE7\x95\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xDD"],
        ["\xE5\x8D\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x59"],
        ["\xE6\xA5\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xDF"],
        ["\xE8\xBB\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB1"],
        ["\xE9\x9B\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x5A"],
        ["\xE6\xB1\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x5E"],
        ["\xE4\xBA\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x42"],
        ["\xE5\xB0\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x86"],
        ["\xE5\xBC\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE1"],
        ["\xE8\xBF\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF6"],
        ["\xE5\x8C\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xCB"],
        ["\xE8\xB3\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x9E"],
        ["\xE8\x82\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x42"],
        ["\xE8\x99\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB6"],
        ["\xE5\xBB\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD9"],
        ["\xE6\x97\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x62"],
        ["\xE4\xB9\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x98"],
        ["\xE5\x85\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x65"],
        ["\xE5\xA6\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF8"],
        ["\xE5\xB0\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC6"],
        ["\xE9\x9F\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xDF"],
        ["\xE4\xBB\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x55"],
        ["\xE5\xA6\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x43"],
        ["\xE5\xBF\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD7"],
        ["\xE8\xAA\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x7E"],
        ["\xE6\xBF\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x7E"],
        ["\xE7\xA6\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xFA"],
        ["\xE7\xA5\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x89"],
        ["\xE5\xAF\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA9"],
        ["\xE8\x91\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x4E"],
        ["\xE7\x8C\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD0"],
        ["\xE7\x86\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD5"],
        ["\xE5\xB9\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x60"],
        ["\xE5\xBF\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xAE"],
        ["\xE6\x8D\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC0"],
        ["\xE6\x92\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x48"],
        ["\xE7\x87\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD5"],
        ["\xE7\xB2\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF7"],
        ["\xE4\xB9\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x9F"],
        ["\xE5\xBB\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x64"],
        ["\xE4\xB9\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD8"],
        ["\xE5\x9F\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF4"],
        ["\xE5\x9A\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x90"],
        ["\xE6\x82\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xCD"],
        ["\xE6\xBF\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xCE"],
        ["\xE7\xB4\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE2"],
        ["\xE8\x83\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x4F"],
        ["\xE8\x84\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB3"],
        ["\xE8\x86\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x5F"],
        ["\xE8\xBE\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x45"],
        ["\xE8\xA6\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xEB"],
        ["\xE8\x9A\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA2"],
        ["\xE5\xB7\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x7D"],
        ["\xE6\x8A\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE3"],
        ["\xE6\x92\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x62"],
        ["\xE8\xA6\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xFA"],
        ["\xE6\x9D\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x80"],
        ["\xE6\xB3\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xCA"],
        ["\xE6\xB4\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x72"],
        ["\xE7\x90\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x9F"],
        ["\xE7\xA0\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xBE"],
        ["\xE5\xA9\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xCC"],
        ["\xE7\xBD\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x79"],
        ["\xE8\x8A\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x42"],
        ["\xE9\xA6\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x64"],
        ["\xE4\xBF\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE1"],
        ["\xE5\xBB\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC7"],
        ["\xE6\x8B\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE2"],
        ["\xE6\x8E\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xFA"],
        ["\xE6\x95\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x8A"],
        ["\xE6\x9D\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x63"],
        ["\xE7\x9B\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xBA"],
        ["\xE7\x89\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x6F"],
        ["\xE8\x83\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB2"],
        ["\xE8\x82\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x4E"],
        ["\xE8\xBC\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF4"],
        ["\xE9\x85\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF3"],
        ["\xE5\x80\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC4"],
        ["\xE5\x9F\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xAC"],
        ["\xE5\xAA\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x80"],
        ["\xE6\xA2\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x98"],
        ["\xE6\xA5\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB3"],
        ["\xE7\x85\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xEA"],
        ["\xE7\x8B\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD6"],
        ["\xE8\xB2\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x74"],
        ["\xE5\xA3\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x75"],
        ["\xE8\xB3\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x4F"],
        ["\xE9\x99\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC3"],
        ["\xE9\x80\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xCA"],
        ["\xE8\x9D\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x4B"],
        ["\xE7\xA7\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x8F"],
        ["\xE7\x9F\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC9"],
        ["\xE8\x90\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x4A"],
        ["\xE4\xBC\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA6"],
        ["\xE5\x89\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x81"],
        ["\xE5\x8D\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF6"],
        ["\xE6\x8B\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xBA"],
        ["\xE6\x9F\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x80"],
        ["\xE6\xB3\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB8"],
        ["\xE7\x99\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x59"],
        ["\xE7\xAE\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE0"],
        ["\xE7\xB2\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x4B"],
        ["\xE8\x88\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x87"],
        ["\xE8\x96\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x92"],
        ["\xE8\xBF\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xEF"],
        ["\xE6\x9B\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA6"],
        ["\xE6\xBC\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x8E"],
        ["\xE7\x88\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD9"],
        ["\xE7\xB8\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE6"],
        ["\xE8\x8E\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB3"],
        ["\xE9\xA7\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE5"],
        ["\xE9\xBA\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE0"],
        ["\xE5\x87\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB6"],
        ["\xE7\xAE\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xFB"],
        ["\xE7\xA1\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xBF"],
        ["\xE7\xAE\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x5C"],
        ["\xE8\x82\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x41"],
        ["\xE7\xAD\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x9B"],
        ["\xE6\xAB\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC5"],
        ["\xE5\xB9\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xDE"],
        ["\xE8\x82\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x50"],
        ["\xE7\x95\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x8B"],
        ["\xE7\x95\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xFE"],
        ["\xE5\x85\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x48"],
        ["\xE9\x89\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA8"],
        ["\xE6\xBA\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xFA"],
        ["\xE7\x99\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x4B"],
        ["\xE9\x86\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xFA"],
        ["\xE9\xAB\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF6"],
        ["\xE4\xBC\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF6"],
        ["\xE7\xBD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x82"],
        ["\xE6\x8A\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x85"],
        ["\xE7\xAD\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF5"],
        ["\xE9\x96\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x72"],
        ["\xE9\xB3\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x95"],
        ["\xE5\x99\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x82"],
        ["\xE5\xA1\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x6F"],
        ["\xE8\x9B\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC2"],
        ["\xE9\x9A\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD5"],
        ["\xE4\xBC\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC9"],
        ["\xE5\x88\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x5C"],
        ["\xE5\x8D\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x90"],
        ["\xE5\x8F\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF9"],
        ["\xE5\x8F\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB2"],
        ["\xE5\xB8\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x75"],
        ["\xE6\x90\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC8"],
        ["\xE6\x96\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE4"],
        ["\xE6\x9D\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB4"],
        ["\xE6\xB0\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x6E"],
        ["\xE6\xB1\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x5E"],
        ["\xE7\x89\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xBD"],
        ["\xE7\x8A\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA7"],
        ["\xE7\x8F\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x66"],
        ["\xE7\x95\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xDC"],
        ["\xE7\xB9\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x59"],
        ["\xE8\x88\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x56"],
        ["\xE8\x97\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF6"],
        ["\xE8\xB2\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x5D"],
        ["\xE7\xAF\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE8"],
        ["\xE9\x87\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x46"],
        ["\xE7\x85\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA0"],
        ["\xE9\xA0\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x57"],
        ["\xE9\xA3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB5"],
        ["\xE6\x8C\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA8"],
        ["\xE6\x99\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB6"],
        ["\xE7\x95\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB9"],
        ["\xE7\x9B\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x90"],
        ["\xE7\xA3\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x9C"],
        ["\xE8\x95\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF7"],
        ["\xE8\x9B\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA5"],
        ["\xE5\x8C\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xED"],
        ["\xE5\x8D\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xAD"],
        ["\xE5\x90\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x4F"],
        ["\xE5\xA6\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA2"],
        ["\xE5\xBA\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x8D"],
        ["\xE5\xBD\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x72"],
        ["\xE6\x82\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x9D"],
        ["\xE6\x89\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xAD"],
        ["\xE6\x89\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x76"],
        ["\xE6\x8A\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA6"],
        ["\xE6\x96\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x80"],
        ["\xE6\xAF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x4E"],
        ["\xE6\xB3\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xFD"],
        ["\xE7\x96\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x97"],
        ["\xE7\x9A\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xDA"],
        ["\xE7\xA2\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x7B"],
        ["\xE7\xA7\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x70"],
        ["\xE7\xB7\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x7D"],
        ["\xE7\xBD\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA5"],
        ["\xE8\x82\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x7B"],
        ["\xE8\xA2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x8D"],
        ["\xE8\xAA\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF2"],
        ["\xE8\xB2\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD0"],
        ["\xE9\x81\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC4"],
        ["\xE9\x9D\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE1"],
        ["\xE9\xA3\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x8A"],
        ["\xE6\xA8\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x4F"],
        ["\xE7\xB0\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xAB"],
        ["\xE5\x82\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xAC"],
        ["\xE5\xB0\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC8"],
        ["\xE5\xBE\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x5D"],
        ["\xE6\x9E\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x5E"],
        ["\xE6\xAF\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD7"],
        ["\xE7\x90\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA3"],
        ["\xE7\x9C\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xBC"],
        ["\xE7\xBE\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x7D"],
        ["\xE9\xBC\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xFD"],
        ["\xE6\x9F\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD9"],
        ["\xE7\xA8\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x87"],
        ["\xE5\x8C\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD1"],
        ["\xE7\x96\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA0"],
        ["\xE9\xAB\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x9D"],
        ["\xE5\xBD\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE1"],
        ["\xE8\x86\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x60"],
        ["\xE8\x8F\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xCC"],
        ["\xE8\x82\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x6A"],
        ["\xE5\xBC\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE0"],
        ["\xE5\xBF\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xCA"],
        ["\xE7\x95\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x9A"],
        ["\xE7\xAD\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC7"],
        ["\xE9\x80\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xAC"],
        ["\xE6\xA1\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x46"],
        ["\xE5\xA7\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB3"],
        ["\xE5\xAA\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x55"],
        ["\xE7\xB4\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB5"],
        ["\xE7\x99\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x4B"],
        ["\xE8\xAC\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA1"],
        ["\xE4\xBF\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB1"],
        ["\xE5\xBD\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x59"],
        ["\xE6\xA8\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x66"],
        ["\xE6\xB0\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA4"],
        ["\xE6\xBC\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xBC"],
        ["\xE7\x93\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x52"],
        ["\xE7\xA5\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xBF"],
        ["\xE8\xA1\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC0"],
        ["\xE8\xA9\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xFD"],
        ["\xE8\xB1\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x93"],
        ["\xE5\xBB\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xAF"],
        ["\xE6\x8F\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xCF"],
        ["\xE7\x97\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xBF"],
        ["\xE7\xA7\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xBA"],
        ["\xE8\x8B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB8"],
        ["\xE9\x8C\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF0"],
        ["\xE9\x8B\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xBE"],
        ["\xE8\x92\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x59"],
        ["\xE8\x9B\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x66"],
        ["\xE9\xB0\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x6E"],
        ["\xE5\x93\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD0"],
        ["\xE5\xBD\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x88"],
        ["\xE6\x96\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x9D"],
        ["\xE6\xB5\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xEA"],
        ["\xE7\x80\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD1"],
        ["\xE8\xB2\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA3"],
        ["\xE8\xB3\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD7"],
        ["\xE9\xA0\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xAB"],
        ["\xE6\x95\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x47"],
        ["\xE7\x93\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD4"],
        ["\xE4\xB8\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xAF"],
        ["\xE4\xBB\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x5D"],
        ["\xE5\x9F\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x7E"],
        ["\xE5\xA4\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x73"],
        ["\xE5\xA9\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x6F"],
        ["\xE5\xAF\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xAC"],
        ["\xE5\x86\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x78"],
        ["\xE5\xB8\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x6B"],
        ["\xE5\xBA\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x51"],
        ["\xE6\x80\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF0"],
        ["\xE6\x89\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x7A"],
        ["\xE6\x95\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x51"],
        ["\xE6\x96\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC2"],
        ["\xE6\x99\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF8"],
        ["\xE6\xB5\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x8C"],
        ["\xE7\x88\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xCC"],
        ["\xE7\xAC\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD9"],
        ["\xE8\x85\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x62"],
        ["\xE8\x86\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x91"],
        ["\xE8\x8A\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xBD"],
        ["\xE8\xAD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x4F"],
        ["\xE8\xB2\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC8"],
        ["\xE8\xB3\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA7"],
        ["\xE8\xB5\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xEE"],
        ["\xE9\x98\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x86"],
        ["\xE9\x99\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x8C"],
        ["\xE4\xBE\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB9"],
        ["\xE6\x92\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE1"],
        ["\xE6\xAD\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB1"],
        ["\xE8\x88\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x63"],
        ["\xE8\x91\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x47"],
        ["\xE8\x95\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD3"],
        ["\xE9\x83\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x95"],
        ["\xE5\xB0\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x76"],
        ["\xE6\xA5\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x95"],
        ["\xE9\xA2\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE7"],
        ["\xE8\x91\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE0"],
        ["\xE8\x95\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x91"],
        ["\xE4\xBC\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x83"],
        ["\xE5\x89\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x4E"],
        ["\xE5\xBE\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x70"],
        ["\xE5\xB9\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x5E"],
        ["\xE6\x9C\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD4"],
        ["\xE7\xA6\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x8B"],
        ["\xE8\x85\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA0"],
        ["\xE8\xA4\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x51"],
        ["\xE8\xA6\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF2"],
        ["\xE6\xB7\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xEA"],
        ["\xE5\xBC\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xAC"],
        ["\xE6\x89\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x81"],
        ["\xE6\xB2\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xAA"],
        ["\xE4\xBB\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE5"],
        ["\xE7\x89\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x52"],
        ["\xE9\xAE\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x8D"],
        ["\xE5\x88\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB4"],
        ["\xE5\x90\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE5"],
        ["\xE5\x99\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x6D"],
        ["\xE5\xA2\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x89"],
        ["\xE6\x86\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xFC"],
        ["\xE6\x89\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB7"],
        ["\xE7\x84\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x4F"],
        ["\xE5\xA5\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xDD"],
        ["\xE7\xB2\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x9E"],
        ["\xE7\xB3\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x92"],
        ["\xE7\xB4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF3"],
        ["\xE9\x9B\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x90"],
        ["\xE6\x96\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xCA"],
        ["\xE8\x81\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xBB"],
        ["\xE4\xB8\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC5"],
        ["\xE4\xBD\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x94"],
        ["\xE5\x85\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x49"],
        ["\xE5\xA1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x9F"],
        ["\xE5\xB9\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x7F"],
        ["\xE5\xB9\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x8D"],
        ["\xE5\xBC\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xCD"],
        ["\xE6\x9F\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x7F"],
        ["\xE4\xB8\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x7C"],
        ["\xE8\x94\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD1"],
        ["\xE9\x96\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x7D"],
        ["\xE9\x99\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x57"],
        ["\xE7\xB1\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x6F"],
        ["\xE9\xA0\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD9"],
        ["\xE5\x83\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x78"],
        ["\xE5\xA3\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x95"],
        ["\xE7\x99\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x7E"],
        ["\xE7\xA2\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF8"],
        ["\xE5\x88\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xDD"],
        ["\xE7\x9E\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x72"],
        ["\xE8\x94\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x6C"],
        ["\xE7\xAE\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x9B"],
        ["\xE5\x81\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x49"],
        ["\xE5\xA4\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x6F"],
        ["\xE7\x89\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x67"],
        ["\xE7\xAF\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB6"],
        ["\xE7\xB7\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x4E"],
        ["\xE8\xBE\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD5"],
        ["\xE8\xBF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD6"],
        ["\xE9\x81\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x5D"],
        ["\xE4\xBE\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x4C"],
        ["\xE5\x8B\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xCE"],
        ["\xE5\xA8\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x9F"],
        ["\xE5\xBC\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x47"],
        ["\xE9\x9E\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x8B"],
        ["\xE4\xBF\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xAA"],
        ["\xE8\x88\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x5B"],
        ["\xE9\x8B\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x63"],
        ["\xE5\x9C\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xCF"],
        ["\xE6\x8D\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x41"],
        ["\xE6\xAD\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD8"],
        ["\xE7\x94\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x58"],
        ["\xE8\xA3\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x6A"],
        ["\xE8\xBC\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x68"],
        ["\xE7\xA9\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD4"],
        ["\xE5\x8B\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE1"],
        ["\xE5\xA2\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xBE"],
        ["\xE6\x85\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE3"],
        ["\xE6\x88\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x61"],
        ["\xE6\x9A\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xFE"],
        ["\xE6\xAF\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x69"],
        ["\xE7\xB0\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x4C"],
        ["\xE8\x8F\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x6A"],
        ["\xE5\x80\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x69"],
        ["\xE4\xBF\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF9"],
        ["\xE5\x8C\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA8"],
        ["\xE5\x91\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x73"],
        ["\xE5\xA0\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB8"],
        ["\xE5\xA5\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB2"],
        ["\xE5\xAE\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x4D"],
        ["\xE5\xB3\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xFE"],
        ["\xE5\xB3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xAC"],
        ["\xE5\xB4\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x5F"],
        ["\xE5\xBA\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x4F"],
        ["\xE6\x8A\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x86"],
        ["\xE6\x8D\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x85"],
        ["\xE6\x94\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xAF"],
        ["\xE6\x96\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xCD"],
        ["\xE6\x9C\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC4"],
        ["\xE6\xB3\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x4A"],
        ["\xE6\xB3\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x87"],
        ["\xE7\x83\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x87"],
        ["\xE7\xA0\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC2"],
        ["\xE7\xB8\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE4"],
        ["\xE8\x83\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB6"],
        ["\xE8\x8A\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x83"],
        ["\xE8\x90\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xDB"],
        ["\xE8\x93\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x88"],
        ["\xE8\x9C\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xCD"],
        ["\xE8\xA4\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xBA"],
        ["\xE8\xA8\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x71"],
        ["\xE8\xB1\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x48"],
        ["\xE9\x82\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC5"],
        ["\xE9\x8B\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x49"],
        ["\xE9\xA3\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x49"],
        ["\xE9\xB3\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA6"],
        ["\xE9\xB5\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x8A"],
        ["\xE4\xB9\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x6C"],
        ["\xE4\xBA\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xCE"],
        ["\xE5\x82\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE7"],
        ["\xE5\x89\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x99"],
        ["\xE5\x9D\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x55"],
        ["\xE5\xA6\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xEC"],
        ["\xE5\xB8\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x85"],
        ["\xE5\xBF\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x45"],
        ["\xE5\xBF\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA3"],
        ["\xE6\x88\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xDC"],
        ["\xE6\x9A\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB2"],
        ["\xE6\x9C\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xBB"],
        ["\xE6\x9F\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x4A"],
        ["\xE6\xA3\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x5A"],
        ["\xE5\x86\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x8F"],
        ["\xE7\xB4\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x77"],
        ["\xE8\x82\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xFB"],
        ["\xE8\x86\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF6"],
        ["\xE8\xAC\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x4D"],
        ["\xE8\xB2\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x64"],
        ["\xE8\xB2\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x72"],
        ["\xE9\x89\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x83"],
        ["\xE9\x98\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xBC"],
        ["\xE5\x90\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE1"],
        ["\xE9\xA0\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB3"],
        ["\xE5\x8C\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x5A"],
        ["\xE5\x83\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xBB"],
        ["\xE5\x8D\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC0"],
        ["\xE5\xA2\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xFC"],
        ["\xE6\x92\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC7"],
        ["\xE6\x9C\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA2"],
        ["\xE7\x89\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x7B"],
        ["\xE7\x9D\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x96"],
        ["\xE7\xA9\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xBE"],
        ["\xE9\x87\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x4A"],
        ["\xE5\x8B\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB1"],
        ["\xE6\xB2\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x75"],
        ["\xE6\xAE\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x42"],
        ["\xE5\xA0\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x9D"],
        ["\xE5\xB9\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x6B"],
        ["\xE5\xA5\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x84"],
        ["\xE6\x9C\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x66"],
        ["\xE7\xBF\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF6"],
        ["\xE5\x87\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE1"],
        ["\xE7\x9B\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x57"],
        ["\xE6\x91\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD1"],
        ["\xE7\xA3\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB4"],
        ["\xE9\xAD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE2"],
        ["\xE9\xBA\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA7"],
        ["\xE5\x9F\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xAC"],
        ["\xE5\xA6\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xDC"],
        ["\xE6\x98\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x9D"],
        ["\xE6\x9E\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD9"],
        ["\xE6\xAF\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF5"],
        ["\xE5\x93\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF0"],
        ["\xE6\xA7\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x81"],
        ["\xE5\xB9\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xCA"],
        ["\xE8\x86\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x8A"],
        ["\xE6\x9E\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x78"],
        ["\xE9\xAE\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xCE"],
        ["\xE6\x9F\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x54"],
        ["\xE9\xB1\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC6"],
        ["\xE6\xA1\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x88"],
        ["\xE4\xBA\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xFA"],
        ["\xE4\xBF\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x4A"],
        ["\xE5\x8F\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF5"],
        ["\xE6\x8A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE0"],
        ["\xE6\x9C\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x46"],
        ["\xE6\xB2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xEC"],
        ["\xE8\xBF\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xCD"],
        ["\xE4\xBE\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x75"],
        ["\xE7\xB9\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x9A"],
        ["\xE9\xBA\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xEA"],
        ["\xE4\xB8\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x4D"],
        ["\xE6\x85\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xDB"],
        ["\xE6\xBA\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x5B"],
        ["\xE6\xBC\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x6E"],
        ["\xE8\x94\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x7B"],
        ["\xE5\x91\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x7F"],
        ["\xE6\x9C\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC6"],
        ["\xE9\xAD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB4"],
        ["\xE5\xB7\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE6"],
        ["\xE7\xAE\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xCC"],
        ["\xE5\xB2\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD5"],
        ["\xE5\xAF\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x56"],
        ["\xE8\x9C\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA1"],
        ["\xE6\xB9\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x88"],
        ["\xE8\x93\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x9A"],
        ["\xE7\xA8\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xFA"],
        ["\xE8\x84\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x79"],
        ["\xE5\xA6\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x66"],
        ["\xE7\xB2\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC9"],
        ["\xE6\xB0\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x56"],
        ["\xE7\x9C\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x6A"],
        ["\xE5\x8B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xED"],
        ["\xE5\xA4\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x8B"],
        ["\xE7\x84\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x5F"],
        ["\xE7\x89\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xAF"],
        ["\xE7\x9F\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xED"],
        ["\xE9\x9C\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x48"],
        ["\xE9\xB5\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x7E"],
        ["\xE6\xA4\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xFD"],
        ["\xE5\xA9\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x54"],
        ["\xE5\xA8\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x54"],
        ["\xE5\x86\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x67"],
        ["\xE5\x90\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF3"],
        ["\xE5\x91\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB0"],
        ["\xE6\x98\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA6"],
        ["\xE7\x9B\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x84"],
        ["\xE8\xBF\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x58"],
        ["\xE9\x8A\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xDC"],
        ["\xE9\xB3\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x70"],
        ["\xE5\xA7\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x8C"],
        ["\xE7\x89\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB7"],
        ["\xE6\xBB\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE6"],
        ["\xE5\x85\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x56"],
        ["\xE6\xA3\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xCA"],
        ["\xE7\xB6\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x9D"],
        ["\xE7\xB7\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x6B"],
        ["\xE9\x9D\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x91"],
        ["\xE9\xBA\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x5F"],
        ["\xE6\x91\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF5"],
        ["\xE6\xA8\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x64"],
        ["\xE8\x8C\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x46"],
        ["\xE5\xA6\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x4D"],
        ["\xE5\xAD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x83"],
        ["\xE6\xAF\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE2"],
        ["\xE7\x8C\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x51"],
        ["\xE7\x9B\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x80"],
        ["\xE7\xB6\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x53"],
        ["\xE8\x80\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xEC"],
        ["\xE8\x92\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x95"],
        ["\xE5\x84\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xBD"],
        ["\xE6\x9C\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x6C"],
        ["\xE9\xBB\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xBC"],
        ["\xE7\x9B\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x75"],
        ["\xE6\x9D\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA6"],
        ["\xE5\x8B\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x97"],
        ["\xE9\xA4\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xBF"],
        ["\xE5\xB0\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xAE"],
        ["\xE6\x88\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x44"],
        ["\xE7\xB1\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF0"],
        ["\xE8\xB2\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xEF"],
        ["\xE5\x95\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE4"],
        ["\xE6\x82\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x54"],
        ["\xE7\xB4\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF9"],
        ["\xE9\x96\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xAA"],
        ["\xE5\x8C\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x5B"],
        ["\xE4\xB9\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x49"],
        ["\xE5\x86\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x46"],
        ["\xE5\xA4\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC8"],
        ["\xE7\x88\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x96"],
        ["\xE8\x80\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x99"],
        ["\xE9\x87\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x69"],
        ["\xE5\xBC\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE6"],
        ["\xE7\x9F\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC1"],
        ["\xE5\x8E\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x52"],
        ["\xE5\xBD\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x5D"],
        ["\xE7\xB4\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xBD"],
        ["\xE8\x96\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE1"],
        ["\xE8\xA8\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xAD"],
        ["\xE8\xBA\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA1"],
        ["\xE9\x9D\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC3"],
        ["\xE6\x9F\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xEA"],
        ["\xE8\x96\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB3"],
        ["\xE9\x91\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x41"],
        ["\xE6\x84\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x98"],
        ["\xE6\x84\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC8"],
        ["\xE6\xB2\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x5C"],
        ["\xE7\x99\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xAA"],
        ["\xE8\xAB\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x9C"],
        ["\xE8\xBC\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x93"],
        ["\xE5\x94\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE0"],
        ["\xE4\xBD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE6"],
        ["\xE5\x84\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xDA"],
        ["\xE5\x8B\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x9C"],
        ["\xE5\x8F\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD4"],
        ["\xE5\xAE\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x7A"],
        ["\xE5\xB9\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x5F"],
        ["\xE6\x82\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD8"],
        ["\xE6\x86\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x7C"],
        ["\xE6\x8F\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF2"],
        ["\xE6\x9C\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x85"],
        ["\xE6\x9F\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE1"],
        ["\xE6\xB9\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xBD"],
        ["\xE6\xB6\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x7D"],
        ["\xE7\x8C\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x4F"],
        ["\xE7\x8C\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xDD"],
        ["\xE7\x94\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x7C"],
        ["\xE7\xA5\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x8C"],
        ["\xE8\xA3\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF8"],
        ["\xE8\xAA\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xCB"],
        ["\xE9\x81\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x8B"],
        ["\xE9\x82\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x92"],
        ["\xE9\x83\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB7"],
        ["\xE9\x9B\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x70"],
        ["\xE8\x9E\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC2"],
        ["\xE5\xA4\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC3"],
        ["\xE4\xBA\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC2"],
        ["\xE4\xBD\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC1"],
        ["\xE4\xB8\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x89"],
        ["\xE8\xAA\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x8C"],
        ["\xE8\xBC\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x6C"],
        ["\xE9\xA0\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x4A"],
        ["\xE5\x82\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xDA"],
        ["\xE5\xB9\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xAF"],
        ["\xE5\xA6\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD1"],
        ["\xE5\xAE\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x89"],
        ["\xE5\xBA\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x5D"],
        ["\xE6\x8F\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x46"],
        ["\xE6\x8F\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x7E"],
        ["\xE6\x93\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x4E"],
        ["\xE6\x9B\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xFE"],
        ["\xE6\xA5\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD7"],
        ["\xE6\xA7\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x48"],
        ["\xE6\xB4\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xDA"],
        ["\xE6\xBA\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xBE"],
        ["\xE7\x86\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x9D"],
        ["\xE7\x94\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB6"],
        ["\xE7\xAA\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA7"],
        ["\xE7\xBE\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD1"],
        ["\xE8\x80\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA0"],
        ["\xE8\x91\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF9"],
        ["\xE8\x93\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x83"],
        ["\xE8\xA6\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x55"],
        ["\xE8\xAC\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x7D"],
        ["\xE8\xB8\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA8"],
        ["\xE9\x81\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x82"],
        ["\xE9\x99\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xBF"],
        ["\xE9\xA4\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x79"],
        ["\xE6\x85\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF4"],
        ["\xE6\x8A\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x66"],
        ["\xE6\xAC\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF6"],
        ["\xE6\xB2\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD9"],
        ["\xE6\xB5\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x7E"],
        ["\xE7\xBF\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x9C"],
        ["\xE7\xBF\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB5"],
        ["\xE6\xB7\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x88"],
        ["\xE7\xBE\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xFA"],
        ["\xE8\x9E\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD6"],
        ["\xE8\xA3\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x43"],
        ["\xE6\x9D\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x76"],
        ["\xE8\x8E\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC9"],
        ["\xE9\xA0\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x7A"],
        ["\xE9\x9B\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD6"],
        ["\xE6\xB4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x50"],
        ["\xE7\xB5\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE7"],
        ["\xE8\x90\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF2"],
        ["\xE9\x85\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xBD"],
        ["\xE4\xB9\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xBF"],
        ["\xE5\x8D\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF5"],
        ["\xE5\xB5\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x8C"],
        ["\xE6\xAC\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xDE"],
        ["\xE6\xBF\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA3"],
        ["\xE8\x97\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xED"],
        ["\xE8\x98\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA6"],
        ["\xE8\xA6\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD0"],
        ["\xE5\x88\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xBC"],
        ["\xE5\x90\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC6"],
        ["\xE5\xB1\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA2"],
        ["\xE6\x9D\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x51"],
        ["\xE6\xA2\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x58"],
        ["\xE7\x90\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xEB"],
        ["\xE7\x92\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x8C"],
        ["\xE7\x97\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x74"],
        ["\xE8\xA3\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA4"],
        ["\xE8\xA3\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x4D"],
        ["\xE9\x87\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x6C"],
        ["\xE9\x9B\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x97"],
        ["\xE9\x99\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x61"],
        ["\xE5\xBE\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x91"],
        ["\xE7\x8E\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x83"],
        ["\xE7\xAB\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xDD"],
        ["\xE8\x91\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x9F"],
        ["\xE6\x8E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE6"],
        ["\xE7\x95\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF0"],
        ["\xE5\x8A\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x85"],
        ["\xE6\xB5\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xFC"],
        ["\xE6\xBA\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC4"],
        ["\xE7\x90\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF7"],
        ["\xE7\x95\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xAB"],
        ["\xE7\xA1\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x84"],
        ["\xE7\xB2\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA9"],
        ["\xE9\x9A\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x5D"],
        ["\xE7\xAB\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE7"],
        ["\xE9\xBE\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xCA"],
        ["\xE4\xBE\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x7C"],
        ["\xE6\x85\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x49"],
        ["\xE6\x97\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xCF"],
        ["\xE8\x99\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x50"],
        ["\xE4\xBA\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB1"],
        ["\xE4\xBA\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x9C"],
        ["\xE5\x83\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x82"],
        ["\xE4\xB8\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x83"],
        ["\xE5\x87\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x44"],
        ["\xE5\xAF\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x7A"],
        ["\xE6\x96\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x4E"],
        ["\xE6\xA2\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x44"],
        ["\xE6\xB6\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x74"],
        ["\xE7\x8C\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x9D"],
        ["\xE7\x99\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB7"],
        ["\xE7\x9E\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x7D"],
        ["\xE7\xA8\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x96"],
        ["\xE7\xB3\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC5"],
        ["\xE8\x89\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC4"],
        ["\xE8\xAB\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x81"],
        ["\xE9\x81\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x6B"],
        ["\xE9\x87\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB5"],
        ["\xE9\x99\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC7"],
        ["\xE9\xA0\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xCD"],
        ["\xE5\x8A\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF7"],
        ["\xE7\xB7\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA5"],
        ["\xE5\x80\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x51"],
        ["\xE5\x8E\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x55"],
        ["\xE6\x9E\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA2"],
        ["\xE6\xB7\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC7"],
        ["\xE7\x87\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x79"],
        ["\xE7\x90\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x53"],
        ["\xE8\x87\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD0"],
        ["\xE8\xBC\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB7"],
        ["\xE9\x9A\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE0"],
        ["\xE9\xB1\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x4C"],
        ["\xE9\xBA\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x9B"],
        ["\xE7\x91\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x8C"],
        ["\xE5\xA1\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xEB"],
        ["\xE6\xB6\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xDA"],
        ["\xE7\xB4\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x48"],
        ["\xE9\xA1\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xBA"],
        ["\xE4\xBB\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC3"],
        ["\xE4\xBC\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x4A"],
        ["\xE4\xBE\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x46"],
        ["\xE5\x86\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xFC"],
        ["\xE5\x8A\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x92"],
        ["\xE5\xB6\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE8"],
        ["\xE6\x80\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x9F"],
        ["\xE7\x8E\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF9"],
        ["\xE7\xA4\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x58"],
        ["\xE8\x8B\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x59"],
        ["\xE9\x88\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xAE"],
        ["\xE9\x9A\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x45"],
        ["\xE9\x9B\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x69"],
        ["\xE9\x9C\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x4B"],
        ["\xE9\xBA\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF3"],
        ["\xE9\xBD\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x80"],
        ["\xE6\x9A\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xCC"],
        ["\xE6\xAD\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x55"],
        ["\xE5\x88\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB4"],
        ["\xE5\x8A\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x68"],
        ["\xE7\x83\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD1"],
        ["\xE8\xA3\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x60"],
        ["\xE5\xBB\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xDB"],
        ["\xE6\x81\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xCA"],
        ["\xE6\x86\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x5B"],
        ["\xE6\xBC\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE0"],
        ["\xE7\x85\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x6F"],
        ["\xE7\xB0\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x70"],
        ["\xE7\xB7\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x60"],
        ["\xE8\x81\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xCA"],
        ["\xE8\x93\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF4"],
        ["\xE9\x80\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x54"],
        ["\xE9\x8C\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE6"],
        ["\xE5\x91\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x50"],
        ["\xE9\xAD\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF4"],
        ["\xE6\xAB\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x86"],
        ["\xE7\x82\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x7D"],
        ["\xE8\xB3\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF8"],
        ["\xE8\xB7\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x84"],
        ["\xE9\x9C\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC6"],
        ["\xE5\x8A\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA9"],
        ["\xE5\xA9\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF8"],
        ["\xE5\xBB\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA7"],
        ["\xE5\xBC\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xBF"],
        ["\xE6\x9C\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x6E"],
        ["\xE6\xA5\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xBA"],
        ["\xE6\xA6\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC7"],
        ["\xE6\xB5\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x9D"],
        ["\xE6\xBC\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC4"],
        ["\xE7\x89\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC4"],
        ["\xE7\x8B\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x6F"],
        ["\xE7\xAF\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x44"],
        ["\xE8\x80\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x85"],
        ["\xE8\x81\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE4"],
        ["\xE8\x9D\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA1"],
        ["\xE9\x83\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x6E"],
        ["\xE5\x85\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x46"],
        ["\xE9\xBA\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x9E"],
        ["\xE7\xA6\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xAE"],
        ["\xE8\x82\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x7F"],
        ["\xE9\x8C\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x86"],
        ["\xE8\xAB\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF3"],
        ["\xE5\x80\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF9"],
        ["\xE5\x92\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x7A"],
        ["\xE8\xA9\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x50"],
        ["\xE6\xAD\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x8E"],
        ["\xE8\xB3\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x67"],
        ["\xE8\x84\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE3"],
        ["\xE6\x83\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x78"],
        ["\xE6\x9E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD2"],
        ["\xE9\xB7\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF1"],
        ["\xE4\xBA\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE8"],
        ["\xE4\xBA\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE4"],
        ["\xE9\xB0\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x93"],
        ["\xE8\xA9\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD3"],
        ["\xE8\x97\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xBB"],
        ["\xE8\x95\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xDE"],
        ["\xE6\xA4\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x68"],
        ["\xE6\xB9\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x6B"],
        ["\xE7\xA2\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x5B"],
        ["\xE8\x85\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xAF"],
        ["\xE5\xBC\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x41"],
        ["\xE4\xB8\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x42"],
        ["\xE4\xB8\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x43"],
        ["\xE4\xB8\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x45"],
        ["\xE4\xB8\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x46"],
        ["\xE4\xB8\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x47"],
        ["\xE4\xB8\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC8"],
        ["\xE4\xB8\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x48"],
        ["\xE4\xB9\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x49"],
        ["\xE4\xB9\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x4A"],
        ["\xE4\xB9\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x4B"],
        ["\xE4\xBA\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x4D"],
        ["\xE4\xBA\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x4E"],
        ["\xE8\xB1\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x55"],
        ["\xE4\xBA\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x4F"],
        ["\xE8\x88\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDB"],
        ["\xE5\xBC\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x51"],
        ["\xE4\xBA\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x50"],
        ["\xE4\xBA\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x52"],
        ["\xE4\xBA\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x67"],
        ["\xE4\xBA\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x53"],
        ["\xE4\xBA\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x54"],
        ["\xE4\xBA\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x55"],
        ["\xE4\xBA\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x56"],
        ["\xE4\xBA\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x57"],
        ["\xE4\xBB\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x58"],
        ["\xE4\xBB\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x59"],
        ["\xE4\xBB\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x5A"],
        ["\xE4\xBB\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x5B"],
        ["\xE4\xBB\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x5C"],
        ["\xE4\xBB\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x5E"],
        ["\xE4\xBB\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x5F"],
        ["\xE4\xBB\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x60"],
        ["\xE4\xBB\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x61"],
        ["\xE4\xBB\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x41"],
        ["\xE4\xBC\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x63"],
        ["\xE4\xBD\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x67"],
        ["\xE4\xBC\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x68"],
        ["\xE4\xBD\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x6F"],
        ["\xE4\xBD\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x69"],
        ["\xE4\xBD\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x6B"],
        ["\xE4\xBD\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x6C"],
        ["\xE4\xBD\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE2"],
        ["\xE4\xBE\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x72"],
        ["\xE4\xBE\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x73"],
        ["\xE4\xBE\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x76"],
        ["\xE4\xBD\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x77"],
        ["\xE4\xBD\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x79"],
        ["\xE4\xBD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x7A"],
        ["\xE4\xBE\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x8D"],
        ["\xE4\xBD\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x7C"],
        ["\xE4\xBE\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x7D"],
        ["\xE4\xBE\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x7E"],
        ["\xE5\x84\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x90"],
        ["\xE4\xBF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x7F"],
        ["\xE4\xBF\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC4"],
        ["\xE4\xBF\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x80"],
        ["\xE4\xBF\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x81"],
        ["\xE4\xBF\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x82"],
        ["\xE4\xBF\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x83"],
        ["\xE4\xBF\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x84"],
        ["\xE4\xBF\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x85"],
        ["\xE4\xBF\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x87"],
        ["\xE4\xBF\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x88"],
        ["\xE5\x80\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x89"],
        ["\xE5\x80\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x8B"],
        ["\xE5\x80\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x8C"],
        ["\xE5\x80\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x8D"],
        ["\xE5\x80\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x8E"],
        ["\xE5\x80\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x8F"],
        ["\xE4\xBC\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x64"],
        ["\xE4\xBF\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF8"],
        ["\xE5\x80\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x90"],
        ["\xE5\x80\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x92"],
        ["\xE5\x80\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x93"],
        ["\xE4\xBF\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x95"],
        ["\xE4\xBF\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x96"],
        ["\xE5\x80\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x97"],
        ["\xE5\x80\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x99"],
        ["\xE5\x81\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x9A"],
        ["\xE5\x81\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x9B"],
        ["\xE6\x9C\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xAC"],
        ["\xE5\x81\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x9C"],
        ["\xE5\x81\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x9D"],
        ["\xE5\x81\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x9E"],
        ["\xE5\x81\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x9F"],
        ["\xE5\x81\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA0"],
        ["\xE5\x81\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA5"],
        ["\xE5\x81\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA6"],
        ["\xE5\x82\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA7"],
        ["\xE5\x82\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA9"],
        ["\xE5\x82\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xAA"],
        ["\xE5\x82\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xAB"],
        ["\xE5\x82\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xAD"],
        ["\xE5\x83\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xAE"],
        ["\xE5\x83\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xAF"],
        ["\xE5\x82\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB0"],
        ["\xE5\x83\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB1"],
        ["\xE5\x83\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD4"],
        ["\xE5\x83\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB3"],
        ["\xE5\x83\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB4"],
        ["\xE5\x83\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB6"],
        ["\xE5\x83\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB7"],
        ["\xE5\x83\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB8"],
        ["\xE5\x83\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB9"],
        ["\xE5\x83\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xBA"],
        ["\xE5\x84\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xBB"],
        ["\xE5\x84\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xBC"],
        ["\xE5\x84\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xBD"],
        ["\xE5\x84\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC1"],
        ["\xE5\x84\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xBF"],
        ["\xE5\x84\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC0"],
        ["\xE5\x84\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xBE"],
        ["\xE5\x84\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC2"],
        ["\xE5\x84\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC3"],
        ["\xE5\x84\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC4"],
        ["\xE5\x84\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC5"],
        ["\xE5\x84\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC6"],
        ["\xE5\x84\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC7"],
        ["\xE5\x85\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC8"],
        ["\xE5\x85\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xCB"],
        ["\xE5\x85\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xCA"],
        ["\xE5\x85\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xCC"],
        ["\xE5\x85\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xCD"],
        ["\xE7\xAB\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x5D"],
        ["\xE5\x85\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xCF"],
        ["\xE5\x85\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD0"],
        ["\xE5\x85\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD1"],
        ["\xE5\x86\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD2"],
        ["\xE5\x86\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD3"],
        ["\xE5\x9B\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD4"],
        ["\xE5\x86\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD5"],
        ["\xE5\x86\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD6"],
        ["\xE5\x86\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD7"],
        ["\xE5\x86\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD8"],
        ["\xE5\x86\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD9"],
        ["\xE5\x86\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xDA"],
        ["\xE5\x86\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xDB"],
        ["\xE5\x86\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xDD"],
        ["\xE5\x86\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xDE"],
        ["\xE5\x86\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xDF"],
        ["\xE5\x86\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE0"],
        ["\xE5\x86\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE1"],
        ["\xE5\x86\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE2"],
        ["\xE5\x86\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE3"],
        ["\xE5\x86\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE4"],
        ["\xE5\x86\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE5"],
        ["\xE5\x86\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE6"],
        ["\xE5\x86\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE7"],
        ["\xE5\x86\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE9"],
        ["\xE5\x87\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xEA"],
        ["\xE5\x87\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xEB"],
        ["\xE5\x87\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xEC"],
        ["\xE5\x87\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xED"],
        ["\xE8\x99\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD1"],
        ["\xE5\x87\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xEE"],
        ["\xE5\x87\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF0"],
        ["\xE5\x87\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF1"],
        ["\xE5\x87\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF2"],
        ["\xE5\x87\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF3"],
        ["\xE5\x88\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF4"],
        ["\xE5\x88\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF5"],
        ["\xE5\x88\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF6"],
        ["\xE5\x88\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE3"],
        ["\xE5\x88\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF8"],
        ["\xE5\x88\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF9"],
        ["\xE5\x88\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xFA"],
        ["\xE5\x88\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xFB"],
        ["\xE5\x88\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xFC"],
        ["\xE5\x89\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x41"],
        ["\xE5\x89\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xFD"],
        ["\xE5\x89\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xFE"],
        ["\xE5\x89\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xAE"],
        ["\xE5\x89\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x42"],
        ["\xE5\x89\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x43"],
        ["\xE5\x89\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x45"],
        ["\xE5\x89\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x47"],
        ["\xE5\x89\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x48"],
        ["\xE5\x89\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x46"],
        ["\xE5\x89\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x49"],
        ["\xE5\x89\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x4A"],
        ["\xE5\x8A\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x4B"],
        ["\xE5\x8A\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x80"],
        ["\xE5\x8A\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x4D"],
        ["\xE5\x89\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x44"],
        ["\xE5\x8A\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x4C"],
        ["\xE5\x8A\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x4E"],
        ["\xE8\xBE\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xEC"],
        ["\xE8\xBE\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xED"],
        ["\xE5\x8A\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x51"],
        ["\xE5\x8A\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x52"],
        ["\xE5\x8A\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x53"],
        ["\xE5\x8A\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x54"],
        ["\xE5\x8B\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x55"],
        ["\xE5\x8B\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x57"],
        ["\xE5\x8B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x92"],
        ["\xE5\x8B\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x59"],
        ["\xE5\x8B\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x5A"],
        ["\xE5\x8B\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x5B"],
        ["\xE9\xA3\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xDB"],
        ["\xE5\x8B\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x5C"],
        ["\xE5\x8B\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x5D"],
        ["\xE5\x8B\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x5E"],
        ["\xE5\x8B\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x5F"],
        ["\xE5\x8B\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x60"],
        ["\xE5\x8C\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x62"],
        ["\xE5\x8C\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x64"],
        ["\xE7\x94\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x65"],
        ["\xE5\x8C\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x66"],
        ["\xE5\x8C\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x67"],
        ["\xE5\x8C\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x68"],
        ["\xE5\x8C\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x69"],
        ["\xE5\x8C\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x6A"],
        ["\xE5\x8C\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x6C"],
        ["\xE5\x8C\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x6D"],
        ["\xE5\x8C\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x6E"],
        ["\xE5\x8C\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x6F"],
        ["\xE5\x8C\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x70"],
        ["\xE5\x8D\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x71"],
        ["\xE5\x8D\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x73"],
        ["\xE5\x8D\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x72"],
        ["\xE4\xB8\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x75"],
        ["\xE5\x8D\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x74"],
        ["\xE5\x8D\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x76"],
        ["\xE5\x87\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x77"],
        ["\xE5\x8D\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x79"],
        ["\xE5\x8D\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x7A"],
        ["\xE5\x8D\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x7B"],
        ["\xE5\xA4\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC8"],
        ["\xE5\x8D\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x7E"],
        ["\xE5\x8D\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x7D"],
        ["\xE5\x8E\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x7F"],
        ["\xE5\x8E\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x81"],
        ["\xE5\x8E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x82"],
        ["\xE5\x8E\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x83"],
        ["\xE5\x8E\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x84"],
        ["\xE5\x8E\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x85"],
        ["\xE5\x8E\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x86"],
        ["\xE5\x8E\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x88"],
        ["\xE5\x8F\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x89"],
        ["\xE7\xB0\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x8A"],
        ["\xE9\x9B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x88"],
        ["\xE5\x8F\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x8C"],
        ["\xE6\x9B\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x8D"],
        ["\xE7\x87\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x8F"],
        ["\xE5\x8F\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x90"],
        ["\xE5\x8F\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x91"],
        ["\xE5\x8F\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x92"],
        ["\xE5\x8F\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x93"],
        ["\xE5\x90\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x94"],
        ["\xE5\x90\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x95"],
        ["\xE5\x91\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x96"],
        ["\xE5\x90\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x97"],
        ["\xE5\x90\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x98"],
        ["\xE5\x90\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x99"],
        ["\xE5\x90\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x9A"],
        ["\xE5\x90\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x9B"],
        ["\xE5\x90\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x9C"],
        ["\xE5\x90\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x9D"],
        ["\xE5\x91\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x9E"],
        ["\xE5\x92\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x9F"],
        ["\xE5\x91\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA0"],
        ["\xE5\x92\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA1"],
        ["\xE5\x91\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA2"],
        ["\xE5\x91\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA3"],
        ["\xE5\x91\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA4"],
        ["\xE5\x91\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA5"],
        ["\xE5\x92\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA6"],
        ["\xE5\x91\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA7"],
        ["\xE5\x92\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA8"],
        ["\xE5\x91\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xAA"],
        ["\xE5\x92\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xAB"],
        ["\xE5\x92\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xAC"],
        ["\xE5\x92\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xAD"],
        ["\xE5\x93\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xAF"],
        ["\xE5\x92\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB2"],
        ["\xE5\x92\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB3"],
        ["\xE5\x92\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB4"],
        ["\xE5\x92\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB5"],
        ["\xE5\x93\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB6"],
        ["\xE5\x93\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB8"],
        ["\xE5\x92\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB9"],
        ["\xE5\x92\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xBA"],
        ["\xE5\x93\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xBB"],
        ["\xE5\x92\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xBC"],
        ["\xE5\x92\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xBE"],
        ["\xE5\x92\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB0"],
        ["\xE5\x93\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB7"],
        ["\xE5\x93\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xBF"],
        ["\xE5\x93\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC1"],
        ["\xE5\x94\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC2"],
        ["\xE5\x94\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC3"],
        ["\xE5\x93\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC4"],
        ["\xE5\x93\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC5"],
        ["\xE5\x93\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC6"],
        ["\xE5\x93\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x7C"],
        ["\xE5\x93\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC7"],
        ["\xE5\x94\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC8"],
        ["\xE5\x95\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC9"],
        ["\xE5\x95\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xCA"],
        ["\xE5\x95\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xCB"],
        ["\xE5\x94\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xCC"],
        ["\xE5\x95\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xCD"],
        ["\xE5\x95\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xCE"],
        ["\xE5\x95\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xCF"],
        ["\xE5\x95\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD0"],
        ["\xE5\x94\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD1"],
        ["\xE5\x94\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD2"],
        ["\xE5\x95\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD3"],
        ["\xE5\x96\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD4"],
        ["\xE5\x96\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD5"],
        ["\xE5\x92\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB1"],
        ["\xE5\x96\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD6"],
        ["\xE5\x96\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD7"],
        ["\xE5\x95\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD8"],
        ["\xE5\x95\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD9"],
        ["\xE5\x96\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xDA"],
        ["\xE5\x96\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xDB"],
        ["\xE5\x96\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xDC"],
        ["\xE5\x95\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xDD"],
        ["\xE5\x96\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xDF"],
        ["\xE5\x96\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE0"],
        ["\xE5\x96\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE1"],
        ["\xE5\x96\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE2"],
        ["\xE5\x97\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA2"],
        ["\xE5\x97\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE3"],
        ["\xE5\x97\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE4"],
        ["\xE5\x97\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE5"],
        ["\xE5\x97\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE6"],
        ["\xE5\x97\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE7"],
        ["\xE5\x97\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE8"],
        ["\xE5\x98\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xEA"],
        ["\xE5\x97\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xEB"],
        ["\xE5\x98\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xEC"],
        ["\xE5\x97\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xED"],
        ["\xE5\x97\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xEE"],
        ["\xE5\x98\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xEF"],
        ["\xE5\x97\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE9"],
        ["\xE5\x99\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF0"],
        ["\xE5\x99\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF1"],
        ["\xE7\x87\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xFB"],
        ["\xE5\x98\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x7F"],
        ["\xE5\x98\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF2"],
        ["\xE5\x98\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF3"],
        ["\xE5\x98\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF4"],
        ["\xE5\x99\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF5"],
        ["\xE5\x99\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF6"],
        ["\xE5\x98\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF8"],
        ["\xE5\x99\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF9"],
        ["\xE5\x99\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xFA"],
        ["\xE5\x9A\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF7"],
        ["\xE5\x9A\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xFE"],
        ["\xE5\x9A\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x41"],
        ["\xE5\x9A\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x42"],
        ["\xE5\x9A\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xFC"],
        ["\xE5\x9A\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xFD"],
        ["\xE5\x9A\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x43"],
        ["\xE5\x9A\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x44"],
        ["\xE5\x9A\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x45"],
        ["\xE5\x9A\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x46"],
        ["\xE5\x9B\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x48"],
        ["\xE5\x9A\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x49"],
        ["\xE5\x9B\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x4A"],
        ["\xE5\x9B\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x4B"],
        ["\xE5\x9B\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x4C"],
        ["\xE5\x9B\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x47"],
        ["\xE5\x9B\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x4D"],
        ["\xE5\x9B\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x4F"],
        ["\xE5\x9B\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x4E"],
        ["\xE5\x9B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x50"],
        ["\xE5\x9B\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x51"],
        ["\xE5\x9B\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x52"],
        ["\xE5\x9C\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x66"],
        ["\xE5\x9B\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x53"],
        ["\xE5\x9C\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x54"],
        ["\xE5\x9C\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x55"],
        ["\xE5\x9C\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x56"],
        ["\xE5\x9C\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xBD"],
        ["\xE5\x9C\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x57"],
        ["\xE5\x9C\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE7"],
        ["\xE5\x9C\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x59"],
        ["\xE5\x9C\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x5A"],
        ["\xE5\x97\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x58"],
        ["\xE5\x9C\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x5B"],
        ["\xE5\x9C\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x5C"],
        ["\xE5\x9C\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD1"],
        ["\xE5\x9C\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x5D"],
        ["\xE5\x9D\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x5E"],
        ["\xE5\x9C\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x5F"],
        ["\xE5\x9D\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x61"],
        ["\xE5\x9D\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x62"],
        ["\xE5\x9D\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x98"],
        ["\xE5\x9F\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x71"],
        ["\xE5\x9E\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x64"],
        ["\xE5\x9D\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x65"],
        ["\xE5\x9D\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x66"],
        ["\xE5\x9E\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x67"],
        ["\xE5\x9E\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x68"],
        ["\xE5\x9E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x69"],
        ["\xE5\x9E\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x6B"],
        ["\xE5\x9E\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x6A"],
        ["\xE5\x9E\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x6D"],
        ["\xE5\x9E\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xCD"],
        ["\xE5\x9F\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x6E"],
        ["\xE5\x9F\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x6F"],
        ["\xE5\x9F\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x72"],
        ["\xE5\x9F\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x74"],
        ["\xE5\x9F\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x75"],
        ["\xE5\xA0\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x78"],
        ["\xE5\x9F\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x76"],
        ["\xE5\x9F\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x79"],
        ["\xE5\xA0\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x7A"],
        ["\xE5\xA0\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x7B"],
        ["\xE5\xA0\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA7"],
        ["\xE5\xA1\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x86"],
        ["\xE5\xA0\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x7C"],
        ["\xE5\xA1\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x7E"],
        ["\xE5\xA1\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x7D"],
        ["\xE5\xA1\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x83"],
        ["\xE6\xAF\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x7F"],
        ["\xE5\xA1\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x81"],
        ["\xE5\xA0\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x80"],
        ["\xE5\xA1\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x84"],
        ["\xE5\xA2\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x85"],
        ["\xE5\xA2\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x8D"],
        ["\xE5\xA2\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x87"],
        ["\xE5\xA2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x88"],
        ["\xE5\xA2\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x8E"],
        ["\xE5\xA3\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x95"],
        ["\xE5\xA2\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x52"],
        ["\xE5\xA2\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x89"],
        ["\xE5\xA2\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x8B"],
        ["\xE5\xA3\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x8F"],
        ["\xE5\xA3\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x90"],
        ["\xE5\xA3\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x91"],
        ["\xE5\xA3\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x92"],
        ["\xE5\xA3\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x93"],
        ["\xE5\xA3\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x94"],
        ["\xE5\xA3\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x99"],
        ["\xE5\xA3\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x96"],
        ["\xE5\xA3\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x98"],
        ["\xE5\xA3\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x97"],
        ["\xE5\xA3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x9A"],
        ["\xE5\xA3\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x77"],
        ["\xE5\xA3\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x9C"],
        ["\xE5\xA3\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x9D"],
        ["\xE5\xA3\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x9E"],
        ["\xE5\xA3\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x75"],
        ["\xE5\xA4\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x9F"],
        ["\xE5\xA4\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA0"],
        ["\xE5\xA4\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA2"],
        ["\xE5\xA4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA3"],
        ["\xE6\xA2\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA4"],
        ["\xE5\xA4\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA5"],
        ["\xE5\xA4\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA6"],
        ["\xE5\xA4\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA7"],
        ["\xE5\xA4\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA8"],
        ["\xE5\xA4\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA9"],
        ["\xE5\xA4\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xAA"],
        ["\xE7\xAB\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x4E"],
        ["\xE5\xA5\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xAB"],
        ["\xE5\xA5\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xAC"],
        ["\xE5\xA5\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x8F"],
        ["\xE5\xA5\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xAE"],
        ["\xE5\xA5\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xAF"],
        ["\xE5\xA5\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB3"],
        ["\xE5\xA5\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB4"],
        ["\xE5\xA5\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB5"],
        ["\xE5\xA5\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB6"],
        ["\xE5\xA5\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB7"],
        ["\xE5\xA5\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB8"],
        ["\xE5\xA6\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB9"],
        ["\xE5\xA6\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xBC"],
        ["\xE4\xBD\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x6D"],
        ["\xE4\xBE\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x78"],
        ["\xE5\xA6\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xBD"],
        ["\xE5\xA6\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xBF"],
        ["\xE5\xA7\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC1"],
        ["\xE5\xA7\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC2"],
        ["\xE5\xA7\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x84"],
        ["\xE5\xA6\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xBA"],
        ["\xE5\xA7\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC3"],
        ["\xE5\xA7\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC4"],
        ["\xE5\xA8\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC5"],
        ["\xE5\xA8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC6"],
        ["\xE5\xA8\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC7"],
        ["\xE5\xA8\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC8"],
        ["\xE5\xA8\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xCA"],
        ["\xE5\xA8\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC9"],
        ["\xE5\xA9\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xCB"],
        ["\xE5\xA9\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xCC"],
        ["\xE5\xA9\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xCD"],
        ["\xE5\xA8\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xCE"],
        ["\xE5\xA8\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xCF"],
        ["\xE5\xA9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD0"],
        ["\xE5\xA9\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD1"],
        ["\xE5\xAA\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD2"],
        ["\xE5\xAA\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD3"],
        ["\xE5\xAA\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD4"],
        ["\xE5\xAB\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD6"],
        ["\xE5\xAB\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD7"],
        ["\xE5\xAA\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD8"],
        ["\xE5\xAB\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD9"],
        ["\xE5\xAB\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xDA"],
        ["\xE5\xAB\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xDB"],
        ["\xE5\xAB\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xDC"],
        ["\xE5\xAB\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xDD"],
        ["\xE5\xAB\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xDE"],
        ["\xE5\xAB\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xDF"],
        ["\xE5\xAC\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE0"],
        ["\xE5\xAC\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE1"],
        ["\xE5\xAC\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE2"],
        ["\xE5\xAC\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE3"],
        ["\xE5\xAB\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD5"],
        ["\xE5\xAC\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE4"],
        ["\xE5\xAC\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE5"],
        ["\xE5\xAC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE6"],
        ["\xE5\xAD\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE7"],
        ["\xE5\xAD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE8"],
        ["\xE5\xAD\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE9"],
        ["\xE5\xAD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xEA"],
        ["\xE5\xAD\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xEB"],
        ["\xE5\xAD\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x58"],
        ["\xE5\xAD\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xEE"],
        ["\xE5\xAD\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xEF"],
        ["\xE5\xAD\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF0"],
        ["\xE5\xAD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF1"],
        ["\xE5\xAD\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF2"],
        ["\xE5\xAD\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF3"],
        ["\xE5\xAD\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF4"],
        ["\xE6\x96\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xED"],
        ["\xE5\xAD\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF5"],
        ["\xE5\xAE\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF6"],
        ["\xE5\xAE\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF7"],
        ["\xE5\xAE\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF8"],
        ["\xE5\xAE\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF9"],
        ["\xE5\xAF\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xFA"],
        ["\xE5\xAF\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xFB"],
        ["\xE5\xAF\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xFD"],
        ["\xE5\xAF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x44"],
        ["\xE5\xAF\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x41"],
        ["\xE5\xAF\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x45"],
        ["\xE5\xAF\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xFC"],
        ["\xE5\xAF\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x46"],
        ["\xE5\xAF\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x43"],
        ["\xE5\xAF\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x47"],
        ["\xE5\xAF\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x48"],
        ["\xE5\xAF\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x49"],
        ["\xE5\xAF\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x4B"],
        ["\xE5\xAF\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x4A"],
        ["\xE5\xB0\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x4C"],
        ["\xE5\xB0\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x4D"],
        ["\xE5\xB0\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x4E"],
        ["\xE5\xB0\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x4F"],
        ["\xE5\xB0\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x50"],
        ["\xE5\xB0\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x52"],
        ["\xE5\xB0\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x53"],
        ["\xE5\xB0\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x54"],
        ["\xE5\xB0\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x55"],
        ["\xE5\xB0\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x5D"],
        ["\xE5\xB1\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x56"],
        ["\xE5\xB1\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x57"],
        ["\xE5\xB1\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x58"],
        ["\xE5\xB1\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x59"],
        ["\xE5\xB1\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x5A"],
        ["\xE5\xB1\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x43"],
        ["\xE5\xAD\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x5B"],
        ["\xE5\xB1\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x5C"],
        ["\xE5\xB1\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x5D"],
        ["\xE4\xB9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x4C"],
        ["\xE5\xB1\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x5E"],
        ["\xE5\xB1\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x5F"],
        ["\xE5\xB2\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x60"],
        ["\xE5\xB2\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x5A"],
        ["\xE5\xB2\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x61"],
        ["\xE5\xA6\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xBB"],
        ["\xE5\xB2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x63"],
        ["\xE5\xB2\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x64"],
        ["\xE5\xB2\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x65"],
        ["\xE5\xB2\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x6A"],
        ["\xE5\xB2\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x66"],
        ["\xE5\xB3\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x69"],
        ["\xE5\xB2\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x62"],
        ["\xE5\xB3\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x6B"],
        ["\xE5\xB3\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x6C"],
        ["\xE5\xB3\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x6D"],
        ["\xE5\xB3\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x6E"],
        ["\xE5\xB3\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x6F"],
        ["\xE5\xB3\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x71"],
        ["\xE5\xB6\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x8C"],
        ["\xE5\xB3\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x72"],
        ["\xE5\xB4\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x73"],
        ["\xE5\xB4\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x74"],
        ["\xE5\xB4\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF1"],
        ["\xE5\xB5\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x81"],
        ["\xE5\xB4\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x75"],
        ["\xE5\xB4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x76"],
        ["\xE5\xB4\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x77"],
        ["\xE5\xB4\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x4D"],
        ["\xE5\xB4\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x79"],
        ["\xE5\xB4\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x7A"],
        ["\xE5\xB4\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x7B"],
        ["\xE5\xB4\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x7C"],
        ["\xE5\xB5\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x7D"],
        ["\xE5\xB5\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x7E"],
        ["\xE5\xB5\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x82"],
        ["\xE5\xB5\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x83"],
        ["\xE5\xB5\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x85"],
        ["\xE5\xB5\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x86"],
        ["\xE5\xB5\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x88"],
        ["\xE5\xB6\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x89"],
        ["\xE5\xB6\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x8A"],
        ["\xE5\xB6\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x8B"],
        ["\xE5\xB6\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x8D"],
        ["\xE5\xB6\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x8E"],
        ["\xE5\xB6\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x90"],
        ["\xE5\xB6\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x91"],
        ["\xE5\xB6\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x84"],
        ["\xE5\xB6\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x8F"],
        ["\xE5\xB6\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x92"],
        ["\xE5\xB6\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x94"],
        ["\xE5\xB7\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x96"],
        ["\xE5\xB7\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x81"],
        ["\xE5\xB7\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x98"],
        ["\xE5\xB7\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x99"],
        ["\xE5\xB7\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xDF"],
        ["\xE5\xB7\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x9A"],
        ["\xE5\xB7\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x9B"],
        ["\xE5\xB7\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x4B"],
        ["\xE5\xB7\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x9C"],
        ["\xE5\xB8\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x9D"],
        ["\xE5\xB8\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x9E"],
        ["\xE5\xB8\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x9F"],
        ["\xE5\xB8\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA0"],
        ["\xE5\xB8\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA1"],
        ["\xE5\xB8\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA2"],
        ["\xE5\xB8\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xBE"],
        ["\xE5\xB9\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA3"],
        ["\xE5\xB9\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA4"],
        ["\xE5\xB9\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA5"],
        ["\xE5\xB9\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA7"],
        ["\xE5\xB9\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA8"],
        ["\xE5\xB9\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA9"],
        ["\xE5\xB9\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x83"],
        ["\xE5\xB9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xAA"],
        ["\xE5\xB9\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xAB"],
        ["\xE5\xB9\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA6"],
        ["\xE5\xB9\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xAC"],
        ["\xE5\xB9\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xAD"],
        ["\xE5\xB9\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xAE"],
        ["\xE9\xBA\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x50"],
        ["\xE5\xB9\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xAF"],
        ["\xE5\xBA\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB0"],
        ["\xE5\xBB\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB1"],
        ["\xE5\xBB\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB2"],
        ["\xE5\xBB\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB3"],
        ["\xE5\xBB\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB4"],
        ["\xE5\xBB\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB5"],
        ["\xE5\xBB\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x6C"],
        ["\xE5\xBB\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE9"],
        ["\xE5\xBB\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB6"],
        ["\xE5\xBB\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB7"],
        ["\xE5\xBB\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB8"],
        ["\xE5\xBB\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB9"],
        ["\xE5\xBB\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xBA"],
        ["\xE5\xBB\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xBB"],
        ["\xE5\xBB\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xBC"],
        ["\xE5\xBB\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xBD"],
        ["\xE5\xBB\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xBF"],
        ["\xE5\xBB\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC0"],
        ["\xE5\xBB\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xBE"],
        ["\xE5\xBB\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC1"],
        ["\xE5\xBB\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD6"],
        ["\xE5\xBB\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x4B"],
        ["\xE5\xBC\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC2"],
        ["\xE5\xBC\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC3"],
        ["\xE5\xBD\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD6"],
        ["\xE5\xBD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD5"],
        ["\xE5\xBC\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC4"],
        ["\xE5\xBC\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC5"],
        ["\xE5\xBC\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC6"],
        ["\xE5\xBC\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC8"],
        ["\xE5\xBC\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC9"],
        ["\xE5\xBC\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xCC"],
        ["\xE5\xBD\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xCE"],
        ["\xE5\xBD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xCF"],
        ["\xE5\xBD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD0"],
        ["\xE5\xBC\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xCA"],
        ["\xE5\xBD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD1"],
        ["\xE5\xBD\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD2"],
        ["\xE5\xBD\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD3"],
        ["\xE5\xBD\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD4"],
        ["\xE5\xBD\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD7"],
        ["\xE5\xBD\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x9C"],
        ["\xE5\xBD\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD9"],
        ["\xE5\xBD\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xDA"],
        ["\xE5\xBE\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xDB"],
        ["\xE5\xBE\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xDC"],
        ["\xE5\xBD\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xDD"],
        ["\xE5\xBE\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xDE"],
        ["\xE5\xBE\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xDF"],
        ["\xE5\xBE\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE1"],
        ["\xE5\xBE\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE0"],
        ["\xE5\xBE\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE3"],
        ["\xE5\xBE\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE2"],
        ["\xE5\xBE\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE4"],
        ["\xE5\xBE\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE5"],
        ["\xE5\xBE\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE6"],
        ["\xE5\xBE\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE7"],
        ["\xE5\xBE\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE9"],
        ["\xE5\xBF\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xEA"],
        ["\xE5\xBF\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xEB"],
        ["\xE5\xBF\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xEC"],
        ["\xE5\xBF\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xED"],
        ["\xE5\xBF\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xEE"],
        ["\xE5\xBF\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF0"],
        ["\xE6\x82\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x76"],
        ["\xE5\xBF\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF2"],
        ["\xE6\x80\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF3"],
        ["\xE6\x81\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x43"],
        ["\xE6\x80\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF4"],
        ["\xE6\x80\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF5"],
        ["\xE6\x80\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF6"],
        ["\xE6\x80\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF7"],
        ["\xE6\x80\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF8"],
        ["\xE6\x80\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF9"],
        ["\xE6\x80\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xFA"],
        ["\xE6\x80\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xFB"],
        ["\xE6\x80\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xFC"],
        ["\xE6\x80\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xFD"],
        ["\xE6\x80\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xFE"],
        ["\xE6\x81\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x41"],
        ["\xE6\x81\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x42"],
        ["\xE6\x81\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x45"],
        ["\xE6\x81\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x46"],
        ["\xE6\x81\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x47"],
        ["\xE6\x81\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x48"],
        ["\xE6\x81\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x49"],
        ["\xE6\x81\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x4A"],
        ["\xE6\x81\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x4B"],
        ["\xE6\x81\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x4C"],
        ["\xE6\x81\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x4D"],
        ["\xE6\x81\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x56"],
        ["\xE6\x81\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x4E"],
        ["\xE6\x81\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x4F"],
        ["\xE6\x81\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x50"],
        ["\xE6\x82\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x52"],
        ["\xE6\x82\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x44"],
        ["\xE6\x83\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x4A"],
        ["\xE6\x82\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x53"],
        ["\xE6\x82\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x54"],
        ["\xE6\x82\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x55"],
        ["\xE6\x82\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x56"],
        ["\xE6\x82\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x58"],
        ["\xE6\x82\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x59"],
        ["\xE6\x82\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x5A"],
        ["\xE6\x82\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x5B"],
        ["\xE6\x82\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x5C"],
        ["\xE6\x83\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x5D"],
        ["\xE6\x82\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x5E"],
        ["\xE6\x83\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x60"],
        ["\xE6\x83\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x61"],
        ["\xE6\x82\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA3"],
        ["\xE5\xBF\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xEF"],
        ["\xE6\x82\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x62"],
        ["\xE6\x83\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x63"],
        ["\xE6\x82\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x64"],
        ["\xE6\x83\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x66"],
        ["\xE6\x85\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x78"],
        ["\xE6\x84\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x69"],
        ["\xE6\x84\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x6A"],
        ["\xE6\x83\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x6B"],
        ["\xE6\x83\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x6C"],
        ["\xE6\x84\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x6D"],
        ["\xE6\x83\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x6E"],
        ["\xE6\x83\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x6F"],
        ["\xE6\x84\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x70"],
        ["\xE6\x84\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x71"],
        ["\xE6\x83\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x72"],
        ["\xE6\x83\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x73"],
        ["\xE6\x84\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x74"],
        ["\xE6\x84\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x75"],
        ["\xE6\x85\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x77"],
        ["\xE6\x84\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x7C"],
        ["\xE6\x84\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x7A"],
        ["\xE6\x84\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x7B"],
        ["\xE6\x85\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x7D"],
        ["\xE6\x84\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE3"],
        ["\xE6\x84\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x7F"],
        ["\xE6\x84\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x80"],
        ["\xE6\x84\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x81"],
        ["\xE6\x84\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x84"],
        ["\xE6\x85\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x85"],
        ["\xE6\x85\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x86"],
        ["\xE6\x85\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x87"],
        ["\xE6\x85\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x89"],
        ["\xE6\x85\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x8A"],
        ["\xE6\x85\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x8B"],
        ["\xE6\x85\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x8C"],
        ["\xE6\x85\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x8D"],
        ["\xE6\x85\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x8E"],
        ["\xE6\x85\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x8F"],
        ["\xE6\x85\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x82"],
        ["\xE6\x85\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x90"],
        ["\xE6\x85\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x91"],
        ["\xE6\x85\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x83"],
        ["\xE6\x85\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x92"],
        ["\xE6\x85\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x93"],
        ["\xE6\x86\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x95"],
        ["\xE6\x86\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x96"],
        ["\xE6\x86\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x88"],
        ["\xE6\x86\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x97"],
        ["\xE6\x86\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x98"],
        ["\xE6\x86\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xCF"],
        ["\xE6\x86\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x99"],
        ["\xE6\x86\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x9A"],
        ["\xE6\x86\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x9B"],
        ["\xE6\x86\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x9C"],
        ["\xE6\x87\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x9D"],
        ["\xE6\x87\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x9E"],
        ["\xE6\x87\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x9F"],
        ["\xE6\x87\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xAA"],
        ["\xE6\x87\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA0"],
        ["\xE6\x87\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA1"],
        ["\xE6\x87\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA2"],
        ["\xE6\x86\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA3"],
        ["\xE6\x87\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA4"],
        ["\xE7\xBD\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA5"],
        ["\xE6\x87\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA6"],
        ["\xE6\x87\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA7"],
        ["\xE6\x87\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA8"],
        ["\xE6\x87\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xAB"],
        ["\xE6\x87\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xAD"],
        ["\xE6\x87\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA9"],
        ["\xE6\x87\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xAE"],
        ["\xE6\x87\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xAC"],
        ["\xE6\x87\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xAF"],
        ["\xE6\x87\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB0"],
        ["\xE6\x88\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB1"],
        ["\xE6\x88\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB2"],
        ["\xE6\x88\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB3"],
        ["\xE6\x88\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB4"],
        ["\xE6\x88\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x60"],
        ["\xE6\x88\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB6"],
        ["\xE6\x88\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB7"],
        ["\xE6\x88\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB8"],
        ["\xE6\x88\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB9"],
        ["\xE6\x88\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBA"],
        ["\xE6\x88\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBB"],
        ["\xE6\x88\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBC"],
        ["\xE6\x88\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBD"],
        ["\xE6\x88\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBE"],
        ["\xE6\x89\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBF"],
        ["\xE6\x89\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC0"],
        ["\xE6\x89\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC1"],
        ["\xE6\x89\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC2"],
        ["\xE6\x89\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC3"],
        ["\xE6\x89\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC4"],
        ["\xE6\x89\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC5"],
        ["\xE6\x89\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC6"],
        ["\xE6\x8A\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC7"],
        ["\xE6\x8A\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC8"],
        ["\xE6\x89\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xCA"],
        ["\xE6\x8A\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC9"],
        ["\xE6\x8A\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xCB"],
        ["\xE6\x8A\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xCC"],
        ["\xE6\x8B\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD7"],
        ["\xE6\x8A\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xCD"],
        ["\xE6\x8A\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xCE"],
        ["\xE6\x8B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xCF"],
        ["\xE6\x8B\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD0"],
        ["\xE6\x8A\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD1"],
        ["\xE6\x8B\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD2"],
        ["\xE6\x8B\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE6"],
        ["\xE6\x8B\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD4"],
        ["\xE6\x93\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x60"],
        ["\xE6\x8B\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD5"],
        ["\xE6\x8B\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD6"],
        ["\xE6\x8B\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x45"],
        ["\xE6\x8B\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD8"],
        ["\xE6\x8B\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD9"],
        ["\xE6\x8B\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xDB"],
        ["\xE6\x8A\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xDC"],
        ["\xE6\x8B\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xDD"],
        ["\xE6\x8C\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xDE"],
        ["\xE6\x8B\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xDF"],
        ["\xE6\x8B\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE0"],
        ["\xE6\x8C\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE1"],
        ["\xE6\x8C\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE2"],
        ["\xE6\x8C\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE3"],
        ["\xE6\x8B\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE4"],
        ["\xE6\x8B\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE5"],
        ["\xE6\x8D\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE7"],
        ["\xE6\x8C\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE9"],
        ["\xE6\x8D\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE8"],
        ["\xE6\x90\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x48"],
        ["\xE6\x8D\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xEA"],
        ["\xE6\x8E\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xEB"],
        ["\xE6\x8E\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xEC"],
        ["\xE6\x8E\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xED"],
        ["\xE6\x8E\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xEE"],
        ["\xE6\x8D\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xEF"],
        ["\xE6\x8E\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF0"],
        ["\xE6\x8E\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF1"],
        ["\xE6\x8E\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF2"],
        ["\xE6\x8E\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF3"],
        ["\xE6\x8E\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF6"],
        ["\xE6\x8D\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF4"],
        ["\xE6\x8D\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF5"],
        ["\xE6\x8E\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF7"],
        ["\xE6\x8F\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF8"],
        ["\xE6\x8F\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF9"],
        ["\xE6\x8F\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xFA"],
        ["\xE6\x8F\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xFC"],
        ["\xE6\x8F\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xFD"],
        ["\xE6\x8F\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xFE"],
        ["\xE6\x8F\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x41"],
        ["\xE6\x8F\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x42"],
        ["\xE6\x90\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x4C"],
        ["\xE6\x90\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x43"],
        ["\xE6\x90\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x44"],
        ["\xE6\x90\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x45"],
        ["\xE6\x90\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x46"],
        ["\xE6\x90\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x47"],
        ["\xE6\x94\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x71"],
        ["\xE6\x90\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x49"],
        ["\xE6\x90\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x4A"],
        ["\xE6\x90\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x4B"],
        ["\xE6\x91\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x4E"],
        ["\xE6\x91\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x4F"],
        ["\xE6\x91\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x51"],
        ["\xE6\x91\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x4D"],
        ["\xE6\x94\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x7F"],
        ["\xE6\x92\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x55"],
        ["\xE6\x92\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x57"],
        ["\xE6\x92\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x58"],
        ["\xE6\x92\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x59"],
        ["\xE6\x92\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x5A"],
        ["\xE6\x92\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x5B"],
        ["\xE6\x93\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x5C"],
        ["\xE6\x93\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x5D"],
        ["\xE6\x93\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x5E"],
        ["\xE6\x93\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x5F"],
        ["\xE6\x92\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x56"],
        ["\xE6\x93\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x61"],
        ["\xE6\x93\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x62"],
        ["\xE6\x93\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x63"],
        ["\xE6\x93\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x64"],
        ["\xE8\x88\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x78"],
        ["\xE6\x93\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x65"],
        ["\xE6\x93\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x66"],
        ["\xE6\x8A\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD3"],
        ["\xE6\x93\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x67"],
        ["\xE6\x93\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x68"],
        ["\xE6\x94\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x76"],
        ["\xE6\x93\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x6A"],
        ["\xE6\x93\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x69"],
        ["\xE6\x93\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x6B"],
        ["\xE6\x93\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x6C"],
        ["\xE6\x94\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x6D"],
        ["\xE6\x93\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x6E"],
        ["\xE6\x94\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x6F"],
        ["\xE6\x94\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x70"],
        ["\xE6\x94\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x72"],
        ["\xE6\x94\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x73"],
        ["\xE6\x94\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x74"],
        ["\xE6\x94\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x75"],
        ["\xE6\x94\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x77"],
        ["\xE6\x94\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x78"],
        ["\xE6\x94\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x79"],
        ["\xE6\x94\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x7A"],
        ["\xE6\x94\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x7B"],
        ["\xE7\x95\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x7C"],
        ["\xE6\x95\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x7D"],
        ["\xE6\x95\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x7F"],
        ["\xE6\x95\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x82"],
        ["\xE6\x95\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x80"],
        ["\xE6\x95\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x81"],
        ["\xE6\x95\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB1"],
        ["\xE6\x95\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x83"],
        ["\xE6\x95\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x84"],
        ["\xE6\x95\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x85"],
        ["\xE6\x96\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x86"],
        ["\xE6\x96\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x87"],
        ["\xE8\xAE\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x88"],
        ["\xE6\x96\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x89"],
        ["\xE6\x96\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x8A"],
        ["\xE6\x96\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x8B"],
        ["\xE6\x96\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x8C"],
        ["\xE6\x97\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x8D"],
        ["\xE6\x97\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x8E"],
        ["\xE6\x97\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x8F"],
        ["\xE6\x97\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x90"],
        ["\xE6\x97\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x91"],
        ["\xE6\x97\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x92"],
        ["\xE6\x97\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x65"],
        ["\xE6\x97\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x93"],
        ["\xE6\x97\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x95"],
        ["\xE6\x97\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x94"],
        ["\xE6\x97\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x96"],
        ["\xE6\x9D\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x9A"],
        ["\xE6\x98\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x8E"],
        ["\xE6\x98\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x9B"],
        ["\xE6\x97\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x9C"],
        ["\xE6\x9D\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE0"],
        ["\xE6\x98\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x9F"],
        ["\xE6\x98\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x93"],
        ["\xE6\x98\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA2"],
        ["\xE6\x98\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA3"],
        ["\xE6\x99\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xEA"],
        ["\xE6\x99\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA5"],
        ["\xE6\x99\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA6"],
        ["\xE6\x99\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x51"],
        ["\xE6\x99\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA9"],
        ["\xE6\x99\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xAD"],
        ["\xE6\x99\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xAA"],
        ["\xE6\x99\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA0"],
        ["\xE6\x99\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB2"],
        ["\xE6\x99\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xCE"],
        ["\xE6\x99\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xAC"],
        ["\xE6\x99\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB0"],
        ["\xE6\x9A\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB1"],
        ["\xE6\x9A\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB2"],
        ["\xE6\x9A\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xAB"],
        ["\xE6\x9A\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD1"],
        ["\xE6\x9A\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB3"],
        ["\xE6\x9A\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB5"],
        ["\xE6\x9A\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB7"],
        ["\xE6\x9B\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xBA"],
        ["\xE6\x9A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x43"],
        ["\xE6\x9B\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xBC"],
        ["\xE6\x9A\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xBD"],
        ["\xE6\x9A\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xBE"],
        ["\xE6\x9B\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB9"],
        ["\xE6\x9A\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xBF"],
        ["\xE6\x9B\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC0"],
        ["\xE6\x9B\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC1"],
        ["\xE6\x9B\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xCC"],
        ["\xE6\x98\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x9E"],
        ["\xE6\x9B\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC2"],
        ["\xE6\x9B\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC3"],
        ["\xE6\x9B\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC4"],
        ["\xE6\x9B\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC5"],
        ["\xE6\x9B\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC6"],
        ["\xE6\x9C\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xFD"],
        ["\xE6\x9C\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xCA"],
        ["\xE6\x9C\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xCB"],
        ["\xE6\x9C\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xCD"],
        ["\xE6\x9C\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xCE"],
        ["\xE9\x9C\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xCF"],
        ["\xE6\x9C\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD0"],
        ["\xE6\x9C\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD1"],
        ["\xE6\x9C\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD2"],
        ["\xE6\x9D\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x4F"],
        ["\xE6\x9C\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD4"],
        ["\xE6\x9C\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD3"],
        ["\xE6\x9D\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD5"],
        ["\xE6\x9D\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD6"],
        ["\xE6\x9D\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x80"],
        ["\xE6\x9D\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD7"],
        ["\xE6\x9D\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x91"],
        ["\xE6\x9D\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD9"],
        ["\xE6\x9E\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDA"],
        ["\xE6\x9D\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDC"],
        ["\xE6\x9E\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDD"],
        ["\xE6\x9D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xDF"],
        ["\xE6\x9D\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDE"],
        ["\xE6\x9E\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF2"],
        ["\xE6\x9E\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDF"],
        ["\xE6\x9E\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE1"],
        ["\xE6\x9E\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE2"],
        ["\xE6\x9E\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDB"],
        ["\xE6\x9E\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE4"],
        ["\xE6\x9F\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE5"],
        ["\xE6\x9E\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE6"],
        ["\xE6\x9F\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE7"],
        ["\xE6\x9E\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC9"],
        ["\xE6\x9F\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE8"],
        ["\xE6\x9E\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE9"],
        ["\xE6\x9F\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xEB"],
        ["\xE6\x9F\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF3"],
        ["\xE6\x9F\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xED"],
        ["\xE6\x9F\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xEE"],
        ["\xE6\x9F\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xEF"],
        ["\xE6\x9E\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF2"],
        ["\xE6\x9F\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF1"],
        ["\xE6\x9F\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF4"],
        ["\xE6\x9F\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xEA"],
        ["\xE6\xAA\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x55"],
        ["\xE6\xA0\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF5"],
        ["\xE6\xA1\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF6"],
        ["\xE6\xA0\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xDE"],
        ["\xE6\xA1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF8"],
        ["\xE6\xA1\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF7"],
        ["\xE6\xA0\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xFA"],
        ["\xE6\xA1\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xFB"],
        ["\xE6\xA2\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x61"],
        ["\xE6\xA0\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE2"],
        ["\xE6\xA1\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xFD"],
        ["\xE6\xA1\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xFC"],
        ["\xE6\xA1\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x41"],
        ["\xE6\xA1\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x42"],
        ["\xE6\xA2\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x43"],
        ["\xE6\xA2\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x45"],
        ["\xE6\xA2\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x46"],
        ["\xE6\xA2\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x47"],
        ["\xE6\xA2\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x92"],
        ["\xE6\xA2\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xBC"],
        ["\xE6\xA2\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x48"],
        ["\xE6\xAA\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x5D"],
        ["\xE6\xA2\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x4A"],
        ["\xE6\xA1\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x4B"],
        ["\xE6\xA2\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x4C"],
        ["\xE6\xA2\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC6"],
        ["\xE6\xA2\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x4D"],
        ["\xE6\xA4\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x4E"],
        ["\xE6\xA2\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xFE"],
        ["\xE6\xA1\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x44"],
        ["\xE6\xA4\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x4F"],
        ["\xE6\xA3\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x50"],
        ["\xE6\xA4\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x51"],
        ["\xE6\xA3\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x52"],
        ["\xE6\xA4\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x61"],
        ["\xE6\xA4\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x53"],
        ["\xE6\xA3\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x54"],
        ["\xE6\xA4\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x55"],
        ["\xE6\xA3\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x56"],
        ["\xE6\xA3\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x57"],
        ["\xE6\xA3\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x58"],
        ["\xE6\xA3\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x59"],
        ["\xE6\xA4\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x69"],
        ["\xE6\xA4\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x5A"],
        ["\xE6\xA4\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x5C"],
        ["\xE6\xA3\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC2"],
        ["\xE6\xA3\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x5D"],
        ["\xE6\xA4\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xFA"],
        ["\xE6\xA3\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x94"],
        ["\xE6\xA3\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x5E"],
        ["\xE6\xA3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x5B"],
        ["\xE6\xA4\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x65"],
        ["\xE6\xA4\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x62"],
        ["\xE6\xA4\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x70"],
        ["\xE6\xA4\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x64"],
        ["\xE6\xA4\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x63"],
        ["\xE6\xA3\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x60"],
        ["\xE6\xA5\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x67"],
        ["\xE6\xA5\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x68"],
        ["\xE6\xA5\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE2"],
        ["\xE6\xA5\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x6A"],
        ["\xE6\xA5\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA2"],
        ["\xE6\xA5\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x6B"],
        ["\xE6\xA5\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x74"],
        ["\xE6\xA5\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xEF"],
        ["\xE6\xA4\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xED"],
        ["\xE6\xA5\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x6D"],
        ["\xE6\xA4\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x6F"],
        ["\xE6\xA5\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x70"],
        ["\xE6\xA4\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x71"],
        ["\xE6\xA5\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x7C"],
        ["\xE6\xA5\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x72"],
        ["\xE6\xA5\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x73"],
        ["\xE6\xA6\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x75"],
        ["\xE6\xA5\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x6C"],
        ["\xE6\xA6\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x76"],
        ["\xE6\xA6\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x4A"],
        ["\xE6\xA7\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x8C"],
        ["\xE6\xA6\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x77"],
        ["\xE6\xA7\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x7A"],
        ["\xE6\xA7\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x7B"],
        ["\xE6\xA6\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x7C"],
        ["\xE6\xA7\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x7D"],
        ["\xE5\xAF\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x7E"],
        ["\xE6\xA7\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x7F"],
        ["\xE6\xA7\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x81"],
        ["\xE6\xA6\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x82"],
        ["\xE6\xA7\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x83"],
        ["\xE6\xA6\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x8D"],
        ["\xE6\xA8\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x88"],
        ["\xE6\xA6\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x76"],
        ["\xE6\xA6\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x84"],
        ["\xE6\xA6\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x85"],
        ["\xE6\xA6\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x86"],
        ["\xE6\xA6\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB2"],
        ["\xE6\xA7\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x87"],
        ["\xE6\xA7\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x89"],
        ["\xE6\xA8\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x8A"],
        ["\xE6\xA8\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x8B"],
        ["\xE6\xA7\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x8C"],
        ["\xE6\xAC\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC1"],
        ["\xE6\xA7\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x8D"],
        ["\xE6\xA7\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x8E"],
        ["\xE6\xA7\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x8F"],
        ["\xE6\xA8\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xBB"],
        ["\xE6\xA6\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x80"],
        ["\xE6\xA8\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x91"],
        ["\xE6\xA7\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x92"],
        ["\xE6\xA8\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x93"],
        ["\xE6\xA7\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x94"],
        ["\xE6\xA8\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x95"],
        ["\xE6\xA8\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x97"],
        ["\xE6\xAB\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB7"],
        ["\xE6\xA8\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x98"],
        ["\xE6\xA8\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x99"],
        ["\xE6\xA9\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x9C"],
        ["\xE6\xA8\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x9D"],
        ["\xE6\xA9\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA8"],
        ["\xE6\xA8\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x9F"],
        ["\xE6\xA9\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA0"],
        ["\xE6\xA9\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA1"],
        ["\xE6\xA9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA2"],
        ["\xE6\xA9\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA3"],
        ["\xE6\xA9\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA4"],
        ["\xE6\xA9\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA5"],
        ["\xE6\xA8\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA7"],
        ["\xE6\xA8\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x96"],
        ["\xE6\xAA\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xAA"],
        ["\xE6\xAA\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xAB"],
        ["\xE6\xAA\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x9E"],
        ["\xE6\xAA\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xAC"],
        ["\xE6\xAA\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xAD"],
        ["\xE6\xAA\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xAE"],
        ["\xE6\xAA\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB0"],
        ["\xE8\x98\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBE"],
        ["\xE6\xAA\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB3"],
        ["\xE6\xAB\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x8B"],
        ["\xE6\xAB\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB4"],
        ["\xE6\xAA\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB5"],
        ["\xE6\xAA\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB6"],
        ["\xE6\xAA\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB1"],
        ["\xE6\xAB\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB8"],
        ["\xE6\xAB\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBA"],
        ["\xE6\xAB\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x62"],
        ["\xE6\xAA\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB2"],
        ["\xE6\xAB\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBB"],
        ["\xE6\xAB\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBF"],
        ["\xE6\xAB\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xEE"],
        ["\xE6\xAC\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC0"],
        ["\xE8\x98\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBD"],
        ["\xE6\xAB\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC2"],
        ["\xE6\xAC\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC3"],
        ["\xE6\xAC\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC4"],
        ["\xE9\xAC\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x86"],
        ["\xE6\xAC\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC5"],
        ["\xE6\xAC\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC6"],
        ["\xE6\xAC\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC7"],
        ["\xE7\x9B\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC9"],
        ["\xE6\xAC\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC8"],
        ["\xE9\xA3\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xCA"],
        ["\xE6\xAD\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xCB"],
        ["\xE6\xAD\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xCC"],
        ["\xE6\xAD\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xCD"],
        ["\xE6\xAD\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xCE"],
        ["\xE6\xAD\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xCF"],
        ["\xE6\xAD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD0"],
        ["\xE6\xAD\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD1"],
        ["\xE6\xAD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD2"],
        ["\xE6\xAD\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD3"],
        ["\xE6\xAD\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD4"],
        ["\xE6\xAD\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD5"],
        ["\xE6\xAD\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD6"],
        ["\xE6\xAE\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD7"],
        ["\xE6\xAE\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD8"],
        ["\xE6\xAE\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD9"],
        ["\xE6\xAE\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xDA"],
        ["\xE6\xAE\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xDB"],
        ["\xE6\xAE\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xDC"],
        ["\xE6\xAE\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xDD"],
        ["\xE6\xAE\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xDE"],
        ["\xE6\xAE\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xDF"],
        ["\xE6\xAE\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE0"],
        ["\xE6\xAE\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE1"],
        ["\xE6\xAE\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE3"],
        ["\xE6\xAE\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE2"],
        ["\xE6\xAE\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE4"],
        ["\xE6\xAE\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE5"],
        ["\xE6\xAE\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE6"],
        ["\xE6\xAF\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE7"],
        ["\xE6\xAF\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE8"],
        ["\xE6\xAF\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE9"],
        ["\xE6\xAF\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xEB"],
        ["\xE6\xAF\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xEC"],
        ["\xE6\xAF\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xED"],
        ["\xE6\xAF\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xEE"],
        ["\xE6\xAF\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xEF"],
        ["\xE9\xBA\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x51"],
        ["\xE6\xB0\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF0"],
        ["\xE6\xB0\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF1"],
        ["\xE6\xB0\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF2"],
        ["\xE6\xB0\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF3"],
        ["\xE6\xB0\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF4"],
        ["\xE6\xB0\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF5"],
        ["\xE6\xB1\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF7"],
        ["\xE6\xB1\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF8"],
        ["\xE6\xB1\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xFA"],
        ["\xE6\xB1\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB4"],
        ["\xE6\xB2\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xFB"],
        ["\xE6\xB2\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xFC"],
        ["\xE6\xB2\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x41"],
        ["\xE6\xB2\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x42"],
        ["\xE6\xB2\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x43"],
        ["\xE6\xB1\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x44"],
        ["\xE6\xB1\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x45"],
        ["\xE6\xB1\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x46"],
        ["\xE6\xB2\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x47"],
        ["\xE6\xB2\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x48"],
        ["\xE6\xB3\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x49"],
        ["\xE6\xB3\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x4A"],
        ["\xE6\xB3\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD7"],
        ["\xE6\xB2\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x4B"],
        ["\xE6\xB3\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC6"],
        ["\xE6\xB3\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x4C"],
        ["\xE6\xB3\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x4F"],
        ["\xE6\xB2\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x4D"],
        ["\xE6\xB2\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x50"],
        ["\xE6\xB2\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x51"],
        ["\xE6\xB2\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x52"],
        ["\xE6\xB3\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x53"],
        ["\xE6\xB3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x54"],
        ["\xE6\xB3\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x55"],
        ["\xE6\xB3\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x56"],
        ["\xE6\xB4\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x57"],
        ["\xE8\xA1\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x70"],
        ["\xE6\xB4\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x59"],
        ["\xE6\xB4\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x5A"],
        ["\xE6\xB4\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x5B"],
        ["\xE6\xB4\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xBC"],
        ["\xE6\xB4\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB6"],
        ["\xE6\xB4\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xAC"],
        ["\xE6\xB4\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x5C"],
        ["\xE6\xB4\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x5D"],
        ["\xE6\xB4\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x5E"],
        ["\xE6\xB5\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x5F"],
        ["\xE6\xB6\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x61"],
        ["\xE6\xB5\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x63"],
        ["\xE6\xB5\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x64"],
        ["\xE6\xB5\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x65"],
        ["\xE6\xB5\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x66"],
        ["\xE6\xB6\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x67"],
        ["\xE6\xB6\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x68"],
        ["\xE6\xBF\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD2"],
        ["\xE6\xB6\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x6A"],
        ["\xE6\xB7\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x6C"],
        ["\xE6\xB8\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x64"],
        ["\xE6\xB8\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x6D"],
        ["\xE6\xB6\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x6F"],
        ["\xE6\xB7\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x71"],
        ["\xE6\xB7\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x70"],
        ["\xE6\xB6\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x73"],
        ["\xE6\xB7\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x75"],
        ["\xE6\xB7\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x76"],
        ["\xE6\xB7\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x77"],
        ["\xE6\xB7\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x78"],
        ["\xE6\xB7\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x79"],
        ["\xE6\xB7\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x7B"],
        ["\xE6\xB7\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x7C"],
        ["\xE6\xB7\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x7D"],
        ["\xE6\xB7\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x7E"],
        ["\xE6\xB7\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x81"],
        ["\xE6\xB7\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x82"],
        ["\xE6\xB7\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x83"],
        ["\xE6\xB7\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x84"],
        ["\xE6\xB8\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x85"],
        ["\xE6\xB9\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x86"],
        ["\xE6\xB8\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x6E"],
        ["\xE6\xB8\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x87"],
        ["\xE6\xB9\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x88"],
        ["\xE6\xB9\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x89"],
        ["\xE6\xB8\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x8B"],
        ["\xE6\xB8\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x8C"],
        ["\xE6\xB9\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x8D"],
        ["\xE6\xB8\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x8F"],
        ["\xE6\xB9\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x90"],
        ["\xE6\xB9\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x91"],
        ["\xE6\xB8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x92"],
        ["\xE6\xB9\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x94"],
        ["\xE6\xB8\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x96"],
        ["\xE6\xB9\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x97"],
        ["\xE6\xB8\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x98"],
        ["\xE6\xBB\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB4"],
        ["\xE6\xB8\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x99"],
        ["\xE6\xB8\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x9A"],
        ["\xE6\xBA\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x9B"],
        ["\xE6\xBA\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x9C"],
        ["\xE6\xBA\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x9D"],
        ["\xE6\xBB\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA9"],
        ["\xE6\xBA\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x9E"],
        ["\xE6\xBB\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x4A"],
        ["\xE6\xBA\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x9F"],
        ["\xE6\xBA\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA0"],
        ["\xE6\xBB\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA1"],
        ["\xE6\xBA\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA2"],
        ["\xE6\xBB\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA3"],
        ["\xE6\xBB\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA4"],
        ["\xE6\xBA\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA5"],
        ["\xE6\xBA\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x76"],
        ["\xE6\xBB\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA7"],
        ["\xE6\xBA\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA8"],
        ["\xE6\xBD\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA9"],
        ["\xE6\xBC\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x75"],
        ["\xE7\x81\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xEA"],
        ["\xE6\xBB\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xAB"],
        ["\xE6\xBB\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xAC"],
        ["\xE6\xBB\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xAD"],
        ["\xE6\xBC\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xAE"],
        ["\xE6\xBB\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xAF"],
        ["\xE6\xBC\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB0"],
        ["\xE6\xBB\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB1"],
        ["\xE6\xBC\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB2"],
        ["\xE6\xBB\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB3"],
        ["\xE6\xBC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB5"],
        ["\xE6\xBC\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB6"],
        ["\xE6\xBB\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB7"],
        ["\xE6\xBE\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB8"],
        ["\xE6\xBD\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB9"],
        ["\xE6\xBD\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xBA"],
        ["\xE6\xBE\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA0"],
        ["\xE6\xBE\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xBB"],
        ["\xE6\xBD\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xBC"],
        ["\xE6\xBD\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xBD"],
        ["\xE6\xBF\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE2"],
        ["\xE6\xBD\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xBE"],
        ["\xE6\xBE\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC0"],
        ["\xE6\xBD\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC2"],
        ["\xE6\xBD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC3"],
        ["\xE6\xBE\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC5"],
        ["\xE6\xBE\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC6"],
        ["\xE6\xBF\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xCF"],
        ["\xE6\xBD\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC7"],
        ["\xE6\xBE\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC8"],
        ["\xE6\xBE\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC9"],
        ["\xE6\xBE\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xCB"],
        ["\xE6\xBE\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x4B"],
        ["\xE6\xBE\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xCC"],
        ["\xE6\xBF\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC4"],
        ["\xE6\xBE\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xCE"],
        ["\xE6\xBF\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD0"],
        ["\xE6\xBF\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD1"],
        ["\xE6\xBF\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD2"],
        ["\xE6\xBF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD4"],
        ["\xE6\xBF\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD3"],
        ["\xE6\xBF\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x55"],
        ["\xE6\xBF\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD6"],
        ["\xE6\xBF\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xCD"],
        ["\xE7\x80\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD9"],
        ["\xE7\x80\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDA"],
        ["\xE6\xBF\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDB"],
        ["\xE7\x80\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDC"],
        ["\xE7\x80\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDD"],
        ["\xE7\x80\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDE"],
        ["\xE6\xBF\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x87"],
        ["\xE7\x80\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDF"],
        ["\xE7\x80\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE0"],
        ["\xE6\xBD\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xBF"],
        ["\xE7\x80\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB0"],
        ["\xE7\x80\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE4"],
        ["\xE7\x80\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE1"],
        ["\xE7\x80\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE5"],
        ["\xE7\x80\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE6"],
        ["\xE7\x80\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE7"],
        ["\xE7\x81\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE8"],
        ["\xE7\x81\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE9"],
        ["\xE7\x82\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xEB"],
        ["\xE7\x82\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xEE"],
        ["\xE7\x82\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xEC"],
        ["\xE7\x83\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF7"],
        ["\xE7\x82\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xEE"],
        ["\xE7\x82\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xEF"],
        ["\xE7\x82\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xCD"],
        ["\xE7\x82\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF0"],
        ["\xE7\x83\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF1"],
        ["\xE7\x83\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF2"],
        ["\xE7\x83\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x8C"],
        ["\xE7\x83\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF3"],
        ["\xE7\x84\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF4"],
        ["\xE7\x83\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF8"],
        ["\xE7\x84\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF9"],
        ["\xE7\x84\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xFA"],
        ["\xE7\x85\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x57"],
        ["\xE7\x85\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x85"],
        ["\xE7\x86\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x45"],
        ["\xE7\x85\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xFE"],
        ["\xE7\x85\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x41"],
        ["\xE7\x85\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x42"],
        ["\xE7\x85\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x43"],
        ["\xE7\x85\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x44"],
        ["\xE7\x86\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x46"],
        ["\xE7\x87\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x57"],
        ["\xE7\x86\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x47"],
        ["\xE7\x86\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x48"],
        ["\xE7\x86\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xBB"],
        ["\xE7\x86\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x4A"],
        ["\xE7\x87\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x52"],
        ["\xE7\x86\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x4C"],
        ["\xE7\x86\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x4D"],
        ["\xE7\x87\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x4E"],
        ["\xE7\x87\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x50"],
        ["\xE7\x87\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x51"],
        ["\xE7\x87\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x53"],
        ["\xE7\x87\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x55"],
        ["\xE7\x87\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x56"],
        ["\xE7\x87\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x4F"],
        ["\xE7\x87\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x54"],
        ["\xE7\x87\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x58"],
        ["\xE7\x87\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x59"],
        ["\xE7\x87\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x5B"],
        ["\xE7\x88\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x5C"],
        ["\xE7\x88\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x5D"],
        ["\xE7\x88\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x7C"],
        ["\xE7\x88\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x5E"],
        ["\xE7\x88\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x5F"],
        ["\xE7\x88\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x60"],
        ["\xE7\x88\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x61"],
        ["\xE7\x88\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x62"],
        ["\xE7\x88\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x63"],
        ["\xE7\x88\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x64"],
        ["\xE7\x88\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x65"],
        ["\xE7\x89\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x66"],
        ["\xE7\x89\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x67"],
        ["\xE7\x89\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x68"],
        ["\xE7\x89\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x69"],
        ["\xE7\x89\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x6A"],
        ["\xE7\x89\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x6B"],
        ["\xE7\x8A\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x6E"],
        ["\xE7\x8A\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x6C"],
        ["\xE7\x8A\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x6D"],
        ["\xE7\x8A\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x6F"],
        ["\xE7\x8A\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x70"],
        ["\xE7\x8A\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x71"],
        ["\xE7\x8A\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x72"],
        ["\xE7\x8A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x79"],
        ["\xE7\x8A\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x74"],
        ["\xE7\x8B\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x76"],
        ["\xE7\x8B\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x77"],
        ["\xE7\x8B\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x78"],
        ["\xE7\x8B\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x7A"],
        ["\xE7\x8B\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x7B"],
        ["\xE7\x8B\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x7C"],
        ["\xE7\x8B\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x7D"],
        ["\xE7\x8B\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x7E"],
        ["\xE7\x8B\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x7F"],
        ["\xE7\x8B\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x80"],
        ["\xE5\x80\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA1"],
        ["\xE7\x8C\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x81"],
        ["\xE7\x8C\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x82"],
        ["\xE7\x8C\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x83"],
        ["\xE7\x8C\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x84"],
        ["\xE7\x8C\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x85"],
        ["\xE7\x8C\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x87"],
        ["\xE7\x8C\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x89"],
        ["\xE7\x8C\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x88"],
        ["\xE7\x8C\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x8B"],
        ["\xE7\x8C\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x8C"],
        ["\xE7\x8D\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x8E"],
        ["\xE7\x8D\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x8D"],
        ["\xE9\xBB\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x90"],
        ["\xE7\x8D\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x8F"],
        ["\xE7\x8D\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x91"],
        ["\xE7\x8D\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x92"],
        ["\xE7\x8D\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x93"],
        ["\xE7\x8D\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x95"],
        ["\xE7\x8D\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x96"],
        ["\xE7\x8D\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x97"],
        ["\xE7\x8D\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xCB"],
        ["\xE7\x8F\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x98"],
        ["\xE7\x8E\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x9A"],
        ["\xE7\x8F\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x9B"],
        ["\xE7\x8E\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x9C"],
        ["\xE7\x8F\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x9D"],
        ["\xE7\x8F\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA0"],
        ["\xE7\x8F\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA3"],
        ["\xE7\x8F\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA5"],
        ["\xE7\x92\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC2"],
        ["\xE7\x90\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA9"],
        ["\xE7\x91\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xBE"],
        ["\xE7\x90\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xAC"],
        ["\xE7\x8F\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA6"],
        ["\xE7\x90\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xAF"],
        ["\xE7\x90\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB0"],
        ["\xE7\x91\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB1"],
        ["\xE7\x90\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB2"],
        ["\xE7\x91\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB3"],
        ["\xE7\x91\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB4"],
        ["\xE7\x91\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB5"],
        ["\xE7\x91\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB6"],
        ["\xE7\x91\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB7"],
        ["\xE7\x91\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB8"],
        ["\xE7\x91\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB9"],
        ["\xE7\x91\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xBA"],
        ["\xE7\x91\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x83"],
        ["\xE7\x91\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xBF"],
        ["\xE7\x92\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x4D"],
        ["\xE7\x92\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC1"],
        ["\xE7\x92\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC3"],
        ["\xE7\x93\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC4"],
        ["\xE7\x93\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC5"],
        ["\xE7\x93\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC6"],
        ["\xE7\x8F\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA4"],
        ["\xE7\x93\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC7"],
        ["\xE7\x93\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC8"],
        ["\xE7\x93\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC9"],
        ["\xE7\x93\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCA"],
        ["\xE7\x93\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCB"],
        ["\xE7\x93\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCD"],
        ["\xE7\x93\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCC"],
        ["\xE7\x93\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCE"],
        ["\xE7\x93\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD0"],
        ["\xE7\x93\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCF"],
        ["\xE7\x94\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD2"],
        ["\xE7\x94\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD3"],
        ["\xE7\x94\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD4"],
        ["\xE7\x94\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD6"],
        ["\xE7\x94\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD7"],
        ["\xE7\x94\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD5"],
        ["\xE7\x94\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE6"],
        ["\xE7\x94\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD8"],
        ["\xE7\x94\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD9"],
        ["\xE7\x94\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xDA"],
        ["\xE7\x94\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xDB"],
        ["\xE7\x94\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xDC"],
        ["\xE7\x95\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xDD"],
        ["\xE7\x95\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xDE"],
        ["\xE7\x95\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xDF"],
        ["\xE7\x95\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE0"],
        ["\xE7\x95\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE2"],
        ["\xE7\x95\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE1"],
        ["\xE7\x95\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE3"],
        ["\xE7\x95\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xFD"],
        ["\xE7\x95\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE4"],
        ["\xE7\x95\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE5"],
        ["\xE7\x95\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE6"],
        ["\xE7\x95\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE9"],
        ["\xE7\x95\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xEA"],
        ["\xE7\x95\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xEB"],
        ["\xE7\x96\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xED"],
        ["\xE7\x96\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xEE"],
        ["\xE7\x95\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE8"],
        ["\xE7\x96\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xEF"],
        ["\xE7\x96\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF0"],
        ["\xE7\x96\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xEC"],
        ["\xE7\x96\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF1"],
        ["\xE7\x96\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF2"],
        ["\xE7\x96\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF3"],
        ["\xE7\x96\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF4"],
        ["\xE7\x96\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF5"],
        ["\xE7\x97\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF6"],
        ["\xE7\x96\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF7"],
        ["\xE7\x97\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF8"],
        ["\xE7\x96\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF9"],
        ["\xE7\x96\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xFA"],
        ["\xE7\x96\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xFB"],
        ["\xE7\x96\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xFC"],
        ["\xE7\x96\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xFD"],
        ["\xE7\x97\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xFE"],
        ["\xE7\x97\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x41"],
        ["\xE7\x97\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x42"],
        ["\xE7\x97\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x43"],
        ["\xE7\x97\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x44"],
        ["\xE7\x97\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x45"],
        ["\xE7\x97\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x46"],
        ["\xE7\x97\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x47"],
        ["\xE7\x97\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x48"],
        ["\xE7\x98\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x49"],
        ["\xE7\x97\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x4A"],
        ["\xE7\x97\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x4B"],
        ["\xE7\x97\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x4C"],
        ["\xE7\x97\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x4D"],
        ["\xE7\x98\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x4E"],
        ["\xE7\x98\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x4F"],
        ["\xE7\x98\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x4F"],
        ["\xE7\x98\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x50"],
        ["\xE7\x98\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x51"],
        ["\xE7\x98\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x52"],
        ["\xE7\x98\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x53"],
        ["\xE7\x98\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x54"],
        ["\xE7\x98\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x55"],
        ["\xE7\x98\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x56"],
        ["\xE7\x98\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x57"],
        ["\xE7\x98\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x58"],
        ["\xE7\x99\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x59"],
        ["\xE7\x99\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x5A"],
        ["\xE7\x99\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x5C"],
        ["\xE7\x99\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x5D"],
        ["\xE7\x99\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x5B"],
        ["\xE7\x99\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x5E"],
        ["\xE7\x99\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x5F"],
        ["\xE7\x99\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x60"],
        ["\xE7\x99\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x61"],
        ["\xE7\x99\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x63"],
        ["\xE7\x99\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x62"],
        ["\xE7\x99\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x64"],
        ["\xE7\x99\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x65"],
        ["\xE7\x99\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x66"],
        ["\xE7\x99\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x67"],
        ["\xE7\x99\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x9A"],
        ["\xE7\x99\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x68"],
        ["\xE7\x9A\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x6A"],
        ["\xE7\x9A\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x6B"],
        ["\xE7\x9A\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x6C"],
        ["\xE7\x9A\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x6D"],
        ["\xE7\x9A\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x99"],
        ["\xE7\x9A\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x96"],
        ["\xE7\x9A\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x81"],
        ["\xE7\x9A\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x6E"],
        ["\xE7\x9A\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x6F"],
        ["\xE7\x9A\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x74"],
        ["\xE7\x9A\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x75"],
        ["\xE7\x9A\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x76"],
        ["\xE7\x9A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x77"],
        ["\xE7\x9A\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x78"],
        ["\xE7\x9B\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x79"],
        ["\xE7\x9B\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x7B"],
        ["\xE7\x9B\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x7C"],
        ["\xE7\x9B\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x7D"],
        ["\xE7\x9B\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x7E"],
        ["\xE7\x9B\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x7F"],
        ["\xE7\x9B\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x80"],
        ["\xE7\x9B\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF7"],
        ["\xE7\x9B\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x81"],
        ["\xE8\x98\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x82"],
        ["\xE7\x9B\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x83"],
        ["\xE7\x9C\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x84"],
        ["\xE7\x9C\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x85"],
        ["\xE7\x9C\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x86"],
        ["\xE7\x9C\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x88"],
        ["\xE7\x9C\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x87"],
        ["\xE7\x9C\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xCA"],
        ["\xE7\x9C\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x89"],
        ["\xE7\x9C\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x8A"],
        ["\xE7\x9C\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x8B"],
        ["\xE7\x9C\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x8C"],
        ["\xE7\x9C\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x8D"],
        ["\xE7\x9D\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x8F"],
        ["\xE7\x9D\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x90"],
        ["\xE7\x9D\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x91"],
        ["\xE7\x9D\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x92"],
        ["\xE7\x9D\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x93"],
        ["\xE7\x9D\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x94"],
        ["\xE7\x9D\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x95"],
        ["\xE7\x9D\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x96"],
        ["\xE7\x9D\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x97"],
        ["\xE7\x9E\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x98"],
        ["\xE7\x9E\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x99"],
        ["\xE7\x9E\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x9A"],
        ["\xE7\x9E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x9B"],
        ["\xE7\x9E\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x9C"],
        ["\xE7\x9E\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x9D"],
        ["\xE7\x9E\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x9E"],
        ["\xE7\x9E\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x9F"],
        ["\xE7\x9E\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA0"],
        ["\xE7\x9E\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA1"],
        ["\xE7\x9E\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA2"],
        ["\xE7\x9E\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA3"],
        ["\xE7\x9F\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA4"],
        ["\xE7\x9F\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA5"],
        ["\xE7\x9F\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x50"],
        ["\xE7\x9F\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA6"],
        ["\xE7\x9F\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA7"],
        ["\xE7\x9F\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA8"],
        ["\xE7\x9F\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA9"],
        ["\xE7\x9F\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xAB"],
        ["\xE7\xA0\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xAC"],
        ["\xE7\xA0\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xAD"],
        ["\xE7\xA4\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB9"],
        ["\xE7\xA0\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB0"],
        ["\xE7\xA4\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x4C"],
        ["\xE7\xA1\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB1"],
        ["\xE7\xA2\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB5"],
        ["\xE7\xA1\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB4"],
        ["\xE7\xA2\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB7"],
        ["\xE7\xA1\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB9"],
        ["\xE7\xA2\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB8"],
        ["\xE7\xA2\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xBA"],
        ["\xE7\xA2\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xBB"],
        ["\xE7\xA2\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xBC"],
        ["\xE7\xA2\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xBD"],
        ["\xE7\xA2\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xBE"],
        ["\xE7\xA3\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xBF"],
        ["\xE7\xA3\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC0"],
        ["\xE7\xA3\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC1"],
        ["\xE7\xA3\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC2"],
        ["\xE7\xA2\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC3"],
        ["\xE7\xA2\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC4"],
        ["\xE7\xA3\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC5"],
        ["\xE7\xA3\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC6"],
        ["\xE7\xA3\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC7"],
        ["\xE7\xA3\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC8"],
        ["\xE7\xA3\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC9"],
        ["\xE7\xA3\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCA"],
        ["\xE7\xA3\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCB"],
        ["\xE7\xA4\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCC"],
        ["\xE7\xA4\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF0"],
        ["\xE7\xA4\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCD"],
        ["\xE7\xA4\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCE"],
        ["\xE7\xA4\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCF"],
        ["\xE7\xA4\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD0"],
        ["\xE7\xA5\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD3"],
        ["\xE7\xA5\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD4"],
        ["\xE7\xA5\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x65"],
        ["\xE7\xA5\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD6"],
        ["\xE7\xA5\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD7"],
        ["\xE7\xA5\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD8"],
        ["\xE7\xA5\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x5C"],
        ["\xE7\xA5\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD8"],
        ["\xE7\xA5\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xDA"],
        ["\xE7\xA6\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xDB"],
        ["\xE7\xA6\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xDE"],
        ["\xE7\xA6\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD7"],
        ["\xE9\xBD\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF5"],
        ["\xE7\xA6\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE0"],
        ["\xE7\xA6\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF5"],
        ["\xE7\xA6\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE1"],
        ["\xE7\xA6\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x6A"],
        ["\xE7\xA6\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE2"],
        ["\xE7\xA7\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE3"],
        ["\xE7\xA7\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE4"],
        ["\xE7\xA7\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE5"],
        ["\xE7\xA7\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE6"],
        ["\xE7\xA7\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB5"],
        ["\xE7\xA7\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE7"],
        ["\xE7\xA8\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE8"],
        ["\xE7\xA8\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE9"],
        ["\xE7\xA8\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xEA"],
        ["\xE7\xA8\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xEB"],
        ["\xE7\xA8\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x66"],
        ["\xE7\xA8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xEC"],
        ["\xE7\xA6\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE7"],
        ["\xE7\xA8\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xED"],
        ["\xE7\xA8\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF0"],
        ["\xE7\xA8\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xEE"],
        ["\xE7\xA8\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xEF"],
        ["\xE7\xA9\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF1"],
        ["\xE7\xA9\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF2"],
        ["\xE7\xA9\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF3"],
        ["\xE7\xA9\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF5"],
        ["\xE7\xA9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF4"],
        ["\xE7\xA9\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF6"],
        ["\xE9\xBE\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF7"],
        ["\xE7\xA9\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF8"],
        ["\xE7\xA9\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF9"],
        ["\xE7\xA9\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xFA"],
        ["\xE7\xAA\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xFB"],
        ["\xE7\xAA\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x41"],
        ["\xE7\xAA\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xFC"],
        ["\xE7\xAA\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xFD"],
        ["\xE7\xAA\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xFE"],
        ["\xE7\xAA\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x42"],
        ["\xE7\xAB\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF0"],
        ["\xE7\xAA\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x43"],
        ["\xE7\xAA\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x44"],
        ["\xE7\xAB\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x48"],
        ["\xE7\xAB\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x49"],
        ["\xE7\xAA\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x47"],
        ["\xE9\x82\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x45"],
        ["\xE7\xAB\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x4A"],
        ["\xE7\xAB\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x4B"],
        ["\xE7\xAB\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x4C"],
        ["\xE7\xAB\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x4D"],
        ["\xE7\xAB\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x50"],
        ["\xE7\xAB\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x51"],
        ["\xE7\xAB\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x52"],
        ["\xE7\xAB\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x53"],
        ["\xE7\xAB\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x54"],
        ["\xE7\xAB\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x55"],
        ["\xE7\xAB\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x56"],
        ["\xE7\xAB\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x57"],
        ["\xE7\xAB\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x5B"],
        ["\xE7\xAB\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x5C"],
        ["\xE7\xAC\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x5E"],
        ["\xE7\xAC\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x5F"],
        ["\xE7\xAC\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x61"],
        ["\xE7\xAC\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x62"],
        ["\xE7\xAC\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x63"],
        ["\xE7\xAC\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE7"],
        ["\xE7\xAC\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x65"],
        ["\xE7\xAC\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x66"],
        ["\xE7\xAC\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x67"],
        ["\xE7\xAC\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x68"],
        ["\xE7\xAC\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x64"],
        ["\xE7\xAD\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x69"],
        ["\xE7\xAD\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x6F"],
        ["\xE7\xAC\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD5"],
        ["\xE7\xAD\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x6A"],
        ["\xE7\xAC\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x60"],
        ["\xE7\xAD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x6B"],
        ["\xE7\xAD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x6C"],
        ["\xE7\xAD\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x6E"],
        ["\xE7\xAD\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x84"],
        ["\xE7\xAD\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x70"],
        ["\xE7\xAD\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x48"],
        ["\xE7\xAD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x71"],
        ["\xE7\xAD\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x72"],
        ["\xE7\xAD\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x4E"],
        ["\xE7\xAD\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x73"],
        ["\xE7\xAE\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x74"],
        ["\xE7\xAE\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x75"],
        ["\xE7\xAE\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x76"],
        ["\xE7\xAE\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x77"],
        ["\xE7\xAE\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x78"],
        ["\xE7\xAE\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x79"],
        ["\xE7\xAE\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA4"],
        ["\xE7\xAE\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x7A"],
        ["\xE7\xAE\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x7B"],
        ["\xE7\xAD\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x6D"],
        ["\xE7\xAE\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x7C"],
        ["\xE7\xAF\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x7E"],
        ["\xE7\xAF\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE8"],
        ["\xE7\xAF\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x7F"],
        ["\xE7\xAF\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x7D"],
        ["\xE7\xAE\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x80"],
        ["\xE7\xAF\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x81"],
        ["\xE7\xAF\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x83"],
        ["\xE7\xAF\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x84"],
        ["\xE7\xB0\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x53"],
        ["\xE7\xB0\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x88"],
        ["\xE7\xAF\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x85"],
        ["\xE7\xAF\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x87"],
        ["\xE7\xB1\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xEE"],
        ["\xE7\xB0\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x89"],
        ["\xE7\xB0\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x8B"],
        ["\xE7\xB0\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x8A"],
        ["\xE7\xAF\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x8C"],
        ["\xE7\xAF\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x86"],
        ["\xE7\xB0\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x7C"],
        ["\xE7\xB0\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x8D"],
        ["\xE7\xAF\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x8E"],
        ["\xE7\xB0\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x8F"],
        ["\xE7\xB0\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x90"],
        ["\xE7\xB0\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x91"],
        ["\xE7\xB0\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x92"],
        ["\xE7\xB0\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x93"],
        ["\xE7\xB0\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x94"],
        ["\xE7\xB0\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x95"],
        ["\xE7\xB1\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x97"],
        ["\xE7\xB1\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x98"],
        ["\xE7\xB1\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x99"],
        ["\xE7\xB1\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF2"],
        ["\xE7\xB1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x96"],
        ["\xE7\xB1\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x9A"],
        ["\xE7\xB1\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x9B"],
        ["\xE7\xB1\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x9C"],
        ["\xE7\xB1\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xAA"],
        ["\xE7\xB1\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x99"],
        ["\xE7\xB1\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x9D"],
        ["\xE7\xB1\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x9E"],
        ["\xE7\xB1\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x9F"],
        ["\xE7\xB2\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA0"],
        ["\xE7\xB2\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA1"],
        ["\xE7\xB2\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA2"],
        ["\xE7\xB2\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA6"],
        ["\xE7\xB2\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA3"],
        ["\xE7\xB2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA4"],
        ["\xE7\xB2\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA5"],
        ["\xE7\xB2\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA7"],
        ["\xE7\xB2\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA8"],
        ["\xE7\xB2\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA9"],
        ["\xE7\xB2\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xAA"],
        ["\xE7\xB2\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xAB"],
        ["\xE7\xB2\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xAC"],
        ["\xE7\xB2\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xAE"],
        ["\xE7\xB3\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xBC"],
        ["\xE7\xB3\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xAF"],
        ["\xE7\xB3\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB0"],
        ["\xE7\xB3\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB3"],
        ["\xE7\xB3\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB1"],
        ["\xE7\xB3\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB4"],
        ["\xE7\xB3\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB2"],
        ["\xE9\xAC\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x88"],
        ["\xE7\xB3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB5"],
        ["\xE7\xB3\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB6"],
        ["\xE7\xB3\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB7"],
        ["\xE7\xB3\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB8"],
        ["\xE7\xB3\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC2"],
        ["\xE7\xB4\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB9"],
        ["\xE7\xB4\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xBA"],
        ["\xE7\xB4\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xBB"],
        ["\xE7\xB4\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xBC"],
        ["\xE7\xB4\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xBD"],
        ["\xE7\xB5\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xBE"],
        ["\xE7\xB5\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xBF"],
        ["\xE7\xB4\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC0"],
        ["\xE7\xB4\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC1"],
        ["\xE7\xB4\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC2"],
        ["\xE7\xB4\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC3"],
        ["\xE7\xB5\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC5"],
        ["\xE7\xB5\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC7"],
        ["\xE7\xB5\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC8"],
        ["\xE7\xB5\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC9"],
        ["\xE7\xB5\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x68"],
        ["\xE7\xB5\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xCA"],
        ["\xE7\xB5\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xCB"],
        ["\xE7\xB5\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xCC"],
        ["\xE7\xB5\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xCD"],
        ["\xE7\xB6\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xCE"],
        ["\xE7\xB6\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xCF"],
        ["\xE7\xB5\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD0"],
        ["\xE7\xB6\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x74"],
        ["\xE7\xB5\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xED"],
        ["\xE7\xB6\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xEB"],
        ["\xE7\xB6\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD3"],
        ["\xE7\xB6\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD1"],
        ["\xE7\xB6\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD2"],
        ["\xE7\xB6\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD3"],
        ["\xE7\xB7\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD5"],
        ["\xE7\xB6\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD6"],
        ["\xE7\xB6\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD7"],
        ["\xE7\xB8\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF3"],
        ["\xE7\xB6\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD8"],
        ["\xE7\xB6\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD9"],
        ["\xE7\xB7\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE8"],
        ["\xE7\xB6\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xDB"],
        ["\xE7\xB6\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xDC"],
        ["\xE7\xB6\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xDD"],
        ["\xE7\xB7\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xDF"],
        ["\xE7\xB7\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE0"],
        ["\xE7\xB7\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE2"],
        ["\xE7\xB7\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE3"],
        ["\xE7\xB7\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE4"],
        ["\xE7\xB7\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE6"],
        ["\xE7\xB7\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE7"],
        ["\xE7\xB8\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE9"],
        ["\xE7\xB8\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xEA"],
        ["\xE7\xB8\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA8"],
        ["\xE7\xB8\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xEB"],
        ["\xE7\xB8\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xEC"],
        ["\xE7\xB8\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF2"],
        ["\xE7\xB8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xED"],
        ["\xE7\xB8\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xEE"],
        ["\xE7\xB8\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE5"],
        ["\xE7\xB8\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xCC"],
        ["\xE7\xB9\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF0"],
        ["\xE7\xB9\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF1"],
        ["\xE7\xB8\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF5"],
        ["\xE7\xB8\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF4"],
        ["\xE7\xB8\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF6"],
        ["\xE7\xB9\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF7"],
        ["\xE7\xB8\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF8"],
        ["\xE7\xB8\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF9"],
        ["\xE7\xB8\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xEF"],
        ["\xE7\xB9\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x42"],
        ["\xE7\xB9\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xFA"],
        ["\xE7\xB9\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xFB"],
        ["\xE7\xB9\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xFC"],
        ["\xE7\xB9\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xFE"],
        ["\xE7\xB9\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x41"],
        ["\xE7\xB9\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x43"],
        ["\xE7\xB9\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x44"],
        ["\xE7\xB9\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x45"],
        ["\xE7\xB9\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x46"],
        ["\xE7\xB9\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x47"],
        ["\xE7\xBA\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x4B"],
        ["\xE7\xB7\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xDE"],
        ["\xE7\xB9\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x48"],
        ["\xE8\xBE\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x49"],
        ["\xE7\xB9\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x4A"],
        ["\xE7\xBA\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x78"],
        ["\xE7\xBA\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x4C"],
        ["\xE7\xBA\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x4E"],
        ["\xE7\xBA\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x4F"],
        ["\xE7\xBA\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x73"],
        ["\xE7\xBA\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x50"],
        ["\xE7\xBA\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x51"],
        ["\xE7\xBA\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x52"],
        ["\xE7\xBA\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x4D"],
        ["\xE7\xBA\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x53"],
        ["\xE7\xBA\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x9C"],
        ["\xE7\xBC\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x54"],
        ["\xE7\xBC\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x55"],
        ["\xE7\xBD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x56"],
        ["\xE7\xBD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x58"],
        ["\xE7\xBD\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xCB"],
        ["\xE7\xBD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x59"],
        ["\xE7\xBD\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x6E"],
        ["\xE7\xBD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x5A"],
        ["\xE7\xBD\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x5B"],
        ["\xE7\xBD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x5C"],
        ["\xE7\xBD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x5D"],
        ["\xE7\xBD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x5E"],
        ["\xE7\xBD\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x5F"],
        ["\xE7\xBD\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x60"],
        ["\xE7\xBD\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x62"],
        ["\xE7\xBD\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x61"],
        ["\xE7\xBD\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x63"],
        ["\xE7\xBE\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x64"],
        ["\xE7\xBE\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x65"],
        ["\xE7\xBE\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x66"],
        ["\xE7\xBE\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x68"],
        ["\xE7\xBE\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x67"],
        ["\xE7\xBE\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x69"],
        ["\xE7\xBE\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x6A"],
        ["\xE7\xBE\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x6B"],
        ["\xE7\xBE\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x6C"],
        ["\xE7\xBE\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x6D"],
        ["\xE7\xBE\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x6F"],
        ["\xE7\xBE\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x70"],
        ["\xE7\xBE\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x72"],
        ["\xE7\xBE\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x73"],
        ["\xE7\xBE\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x71"],
        ["\xE7\xBE\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x74"],
        ["\xE7\xBE\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x75"],
        ["\xE8\xAD\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x76"],
        ["\xE7\xBF\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x78"],
        ["\xE7\xBF\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x79"],
        ["\xE7\xBF\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x7A"],
        ["\xE7\xBF\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x7B"],
        ["\xE7\xBF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF9"],
        ["\xE7\xBF\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x7C"],
        ["\xE7\xBF\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x7D"],
        ["\xE7\xBF\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x7E"],
        ["\xE7\xBF\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x7F"],
        ["\xE7\xBF\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x80"],
        ["\xE9\xA3\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xDA"],
        ["\xE8\x80\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xDC"],
        ["\xE8\x80\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x81"],
        ["\xE8\x80\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x82"],
        ["\xE8\x80\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x83"],
        ["\xE8\x80\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE4"],
        ["\xE8\x80\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x84"],
        ["\xE8\x80\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x85"],
        ["\xE8\x80\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x86"],
        ["\xE8\x80\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x87"],
        ["\xE8\x80\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x88"],
        ["\xE8\x80\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x89"],
        ["\xE8\x81\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x8A"],
        ["\xE8\x81\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x8B"],
        ["\xE8\x81\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x8C"],
        ["\xE8\x81\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x8D"],
        ["\xE8\x81\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x79"],
        ["\xE8\x81\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x8E"],
        ["\xE8\x81\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x8F"],
        ["\xE8\x81\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x90"],
        ["\xE8\x81\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x91"],
        ["\xE8\x81\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x92"],
        ["\xE8\x81\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x93"],
        ["\xE8\x81\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x94"],
        ["\xE8\x81\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x95"],
        ["\xE8\x81\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x96"],
        ["\xE8\x81\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x97"],
        ["\xE8\x82\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x98"],
        ["\xE8\x82\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB6"],
        ["\xE8\x82\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x99"],
        ["\xE8\x82\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x92"],
        ["\xE8\x82\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x9A"],
        ["\xE8\x82\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x9B"],
        ["\xE8\x82\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x9C"],
        ["\xE5\x86\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x9D"],
        ["\xE8\x82\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x9E"],
        ["\xE8\x83\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x9F"],
        ["\xE8\x83\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA0"],
        ["\xE8\x83\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA1"],
        ["\xE8\x83\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA2"],
        ["\xE8\x83\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA3"],
        ["\xE8\x83\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA4"],
        ["\xE8\x83\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x88"],
        ["\xE8\x84\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA5"],
        ["\xE8\x83\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA6"],
        ["\xE8\x83\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA7"],
        ["\xE8\x84\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA8"],
        ["\xE8\x84\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x96"],
        ["\xE8\x84\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA9"],
        ["\xE8\x84\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xAA"],
        ["\xE8\x85\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xAB"],
        ["\xE9\x9A\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x73"],
        ["\xE8\x85\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xAC"],
        ["\xE8\x84\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xAD"],
        ["\xE8\x85\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xAE"],
        ["\xE8\x85\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xAF"],
        ["\xE8\x83\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB0"],
        ["\xE8\x85\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB1"],
        ["\xE8\x85\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB2"],
        ["\xE8\x85\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB3"],
        ["\xE8\x85\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB5"],
        ["\xE8\x85\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB6"],
        ["\xE8\x86\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB7"],
        ["\xE8\x86\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB8"],
        ["\xE8\x86\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB9"],
        ["\xE8\x86\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBA"],
        ["\xE8\x86\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBB"],
        ["\xE8\x86\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBC"],
        ["\xE8\x86\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBD"],
        ["\xE8\x86\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC1"],
        ["\xE8\x86\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBE"],
        ["\xE8\x85\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB4"],
        ["\xE8\x86\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBF"],
        ["\xE8\x86\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC2"],
        ["\xE8\x86\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC4"],
        ["\xE8\x86\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC0"],
        ["\xE8\x86\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC6"],
        ["\xE8\x86\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC3"],
        ["\xE8\x86\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC7"],
        ["\xE8\x87\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC8"],
        ["\xE8\x87\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC9"],
        ["\xE8\x86\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCA"],
        ["\xE8\x87\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCB"],
        ["\xE8\x87\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCC"],
        ["\xE8\x87\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCD"],
        ["\xE8\x87\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCF"],
        ["\xE8\x87\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCE"],
        ["\xE8\x87\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC5"],
        ["\xE8\x87\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD0"],
        ["\xE8\x87\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD1"],
        ["\xE8\x87\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD2"],
        ["\xE8\x87\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x73"],
        ["\xE8\x87\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD3"],
        ["\xE8\x87\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD4"],
        ["\xE8\x87\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD5"],
        ["\xE8\x88\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD6"],
        ["\xE8\x88\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD7"],
        ["\xE8\x88\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD8"],
        ["\xE8\x88\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x58"],
        ["\xE8\x88\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xBA"],
        ["\xE8\x88\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD9"],
        ["\xE8\x88\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDA"],
        ["\xE8\x88\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDC"],
        ["\xE8\x88\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDD"],
        ["\xE8\x88\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDE"],
        ["\xE8\x88\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE0"],
        ["\xE8\x88\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE1"],
        ["\xE8\x89\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE2"],
        ["\xE8\x89\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE3"],
        ["\xE8\x89\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xAE"],
        ["\xE8\x89\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE5"],
        ["\xE8\x89\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE4"],
        ["\xE8\x89\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE6"],
        ["\xE8\x89\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE7"],
        ["\xE8\x89\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE8"],
        ["\xE8\x89\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE9"],
        ["\xE8\x89\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xEA"],
        ["\xE8\x89\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xEB"],
        ["\xE8\x88\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDF"],
        ["\xE8\x89\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xEC"],
        ["\xE8\x89\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xED"],
        ["\xE8\x89\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC5"],
        ["\xE8\x89\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xEE"],
        ["\xE8\x8A\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xEF"],
        ["\xE8\x8A\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF0"],
        ["\xE8\x8A\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF1"],
        ["\xE8\x8A\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF2"],
        ["\xE8\x8A\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF3"],
        ["\xE8\x8A\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF4"],
        ["\xE8\x8B\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF5"],
        ["\xE8\x8B\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF6"],
        ["\xE8\x8B\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF7"],
        ["\xE8\x8B\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF9"],
        ["\xE8\x8B\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xFA"],
        ["\xE8\x8B\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xFB"],
        ["\xE8\x8B\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x44"],
        ["\xE8\x8E\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x60"],
        ["\xE8\x8C\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xFC"],
        ["\xE8\x8B\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xFD"],
        ["\xE8\x8B\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xFE"],
        ["\xE8\x8B\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x41"],
        ["\xE8\x8C\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x42"],
        ["\xE8\x8B\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x43"],
        ["\xE8\x8C\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x45"],
        ["\xE8\x8B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x46"],
        ["\xE8\x8C\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x47"],
        ["\xE8\x8C\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x49"],
        ["\xE8\x8C\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x4A"],
        ["\xE8\x8C\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x7B"],
        ["\xE8\x8C\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x4B"],
        ["\xE8\x8D\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x4C"],
        ["\xE8\x8C\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x4D"],
        ["\xE8\x8D\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x4E"],
        ["\xE8\x8D\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x4F"],
        ["\xE8\x8C\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x50"],
        ["\xE8\x8C\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x51"],
        ["\xE8\x8C\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF6"],
        ["\xE8\x8C\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x52"],
        ["\xE8\x8E\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x62"],
        ["\xE8\x8E\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x53"],
        ["\xE8\x8E\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x54"],
        ["\xE8\x8E\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x55"],
        ["\xE8\x8E\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x56"],
        ["\xE8\x8E\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x57"],
        ["\xE8\x8C\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x58"],
        ["\xE8\x8E\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x59"],
        ["\xE8\x8E\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x86"],
        ["\xE8\x8E\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x5C"],
        ["\xE8\x8D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x5D"],
        ["\xE8\x8E\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x5E"],
        ["\xE8\x8D\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x5F"],
        ["\xE8\x8D\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x5A"],
        ["\xE8\x8E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x61"],
        ["\xE8\x8E\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x63"],
        ["\xE8\x8E\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x64"],
        ["\xE8\x8F\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x65"],
        ["\xE8\x90\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x66"],
        ["\xE8\x8F\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE9"],
        ["\xE8\x8F\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x68"],
        ["\xE8\x8F\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x6A"],
        ["\xE8\x90\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x6B"],
        ["\xE8\x8F\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x6C"],
        ["\xE8\x90\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x6D"],
        ["\xE8\x8F\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x6E"],
        ["\xE8\x8F\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x69"],
        ["\xE8\x90\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x6F"],
        ["\xE8\x8F\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x70"],
        ["\xE8\x8F\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x71"],
        ["\xE8\x90\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x72"],
        ["\xE8\x90\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD8"],
        ["\xE8\x90\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x73"],
        ["\xE8\x8E\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x75"],
        ["\xE8\x90\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x84"],
        ["\xE8\x94\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x9D"],
        ["\xE8\x8F\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x76"],
        ["\xE8\x91\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x6C"],
        ["\xE8\x90\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x77"],
        ["\xE8\x90\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x79"],
        ["\xE8\x95\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x9F"],
        ["\xE8\x92\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x7A"],
        ["\xE8\x91\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x7B"],
        ["\xE8\x91\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x7C"],
        ["\xE8\x92\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x90"],
        ["\xE8\x91\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x7F"],
        ["\xE8\x92\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x80"],
        ["\xE8\x91\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x81"],
        ["\xE8\x91\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x82"],
        ["\xE8\x90\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x75"],
        ["\xE8\x91\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x83"],
        ["\xE8\x91\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x7D"],
        ["\xE8\x90\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x85"],
        ["\xE8\x93\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x86"],
        ["\xE8\x91\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x78"],
        ["\xE8\x92\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x87"],
        ["\xE8\x92\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x88"],
        ["\xE8\x92\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x89"],
        ["\xE8\x93\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x94"],
        ["\xE8\x93\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x8B"],
        ["\xE8\x92\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x8C"],
        ["\xE8\x93\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x8D"],
        ["\xE8\x93\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x8E"],
        ["\xE8\x93\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x8F"],
        ["\xE8\x93\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x91"],
        ["\xE8\x93\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x92"],
        ["\xE8\x92\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x93"],
        ["\xE8\x94\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA8"],
        ["\xE8\x93\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x95"],
        ["\xE8\x93\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x96"],
        ["\xE8\x94\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x97"],
        ["\xE8\x94\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x98"],
        ["\xE8\x94\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x99"],
        ["\xE8\x94\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x9A"],
        ["\xE8\x94\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x9B"],
        ["\xE8\x94\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x9C"],
        ["\xE8\x93\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x8B"],
        ["\xE8\x95\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA0"],
        ["\xE8\x95\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA2"],
        ["\xE8\x95\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA3"],
        ["\xE8\x95\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA4"],
        ["\xE8\x95\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA5"],
        ["\xE8\x98\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x96"],
        ["\xE8\x95\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA7"],
        ["\xE8\x95\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA9"],
        ["\xE8\x96\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAA"],
        ["\xE8\x96\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAB"],
        ["\xE8\x96\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAC"],
        ["\xE8\x96\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAD"],
        ["\xE8\x96\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAE"],
        ["\xE8\x96\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAF"],
        ["\xE8\x95\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB0"],
        ["\xE8\x96\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB1"],
        ["\xE8\x96\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB2"],
        ["\xE8\x97\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x95"],
        ["\xE8\x96\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB4"],
        ["\xE8\x96\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB5"],
        ["\xE8\x95\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB6"],
        ["\xE8\x95\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB7"],
        ["\xE8\x96\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB8"],
        ["\xE8\x97\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xBC"],
        ["\xE8\x96\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xBD"],
        ["\xE8\x97\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xBE"],
        ["\xE8\x96\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xBF"],
        ["\xE8\x97\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC0"],
        ["\xE8\x97\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC1"],
        ["\xE8\x97\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC2"],
        ["\xE8\x97\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC3"],
        ["\xE8\x97\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC4"],
        ["\xE8\x97\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC5"],
        ["\xE8\x98\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC6"],
        ["\xE8\x98\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC7"],
        ["\xE8\x98\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC8"],
        ["\xE8\x97\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC9"],
        ["\xE8\x97\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xED"],
        ["\xE8\x98\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xDA"],
        ["\xE8\x98\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xCA"],
        ["\xE8\x98\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xCB"],
        ["\xE8\x98\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xCC"],
        ["\xE8\x98\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xCD"],
        ["\xE8\x99\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xCF"],
        ["\xE4\xB9\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD0"],
        ["\xE8\x99\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xFB"],
        ["\xE8\x99\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD2"],
        ["\xE8\x99\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD3"],
        ["\xE8\x99\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD4"],
        ["\xE8\x9A\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD5"],
        ["\xE8\x9A\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD6"],
        ["\xE8\x9A\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD7"],
        ["\xE8\x9A\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD9"],
        ["\xE8\x9A\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD8"],
        ["\xE8\x9A\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDA"],
        ["\xE8\x9A\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDB"],
        ["\xE8\x9A\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDC"],
        ["\xE8\x9B\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDD"],
        ["\xE8\x9B\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDE"],
        ["\xE8\x9A\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDF"],
        ["\xE8\x9B\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE0"],
        ["\xE8\xA0\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x51"],
        ["\xE8\x9A\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE3"],
        ["\xE8\x9B\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE4"],
        ["\xE8\x9B\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE5"],
        ["\xE8\x9B\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE6"],
        ["\xE8\x9B\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE7"],
        ["\xE8\x9B\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE8"],
        ["\xE8\x9B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE9"],
        ["\xE8\x9B\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x74"],
        ["\xE8\x9C\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEA"],
        ["\xE8\x9C\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEB"],
        ["\xE8\x9C\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEC"],
        ["\xE8\x9C\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xED"],
        ["\xE8\x9C\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEE"],
        ["\xE8\x9B\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEF"],
        ["\xE8\x9C\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF0"],
        ["\xE8\x9C\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF1"],
        ["\xE8\x9C\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF2"],
        ["\xE8\x9B\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF3"],
        ["\xE8\x9C\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF4"],
        ["\xE8\x9C\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF5"],
        ["\xE8\x9C\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF6"],
        ["\xE8\x9C\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x6D"],
        ["\xE8\x9C\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF7"],
        ["\xE8\x9C\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF8"],
        ["\xE8\x9C\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF9"],
        ["\xE8\x9C\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xFA"],
        ["\xE8\x9D\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x46"],
        ["\xE8\x9D\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xFB"],
        ["\xE8\x9D\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xFC"],
        ["\xE8\x9D\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xFD"],
        ["\xE8\x9D\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xFE"],
        ["\xE8\x9D\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x41"],
        ["\xE8\x9D\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x42"],
        ["\xE8\x9D\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x43"],
        ["\xE8\x9D\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x47"],
        ["\xE8\x9D\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x48"],
        ["\xE8\x9D\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x49"],
        ["\xE8\x9D\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x4A"],
        ["\xE8\x9D\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x45"],
        ["\xE8\xA0\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xBD"],
        ["\xE8\x9E\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x4C"],
        ["\xE8\x9E\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x4E"],
        ["\xE8\x9E\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x44"],
        ["\xE8\x9E\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x4F"],
        ["\xE8\x9F\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x50"],
        ["\xE8\x9E\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x51"],
        ["\xE8\x9F\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x52"],
        ["\xE8\x9F\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x53"],
        ["\xE9\x9B\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x54"],
        ["\xE8\x9E\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x55"],
        ["\xE8\x9F\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x56"],
        ["\xE8\x9E\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x57"],
        ["\xE8\x9F\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF4"],
        ["\xE8\x9F\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x4D"],
        ["\xE8\x9E\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x59"],
        ["\xE8\x9F\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x5A"],
        ["\xE8\x9F\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x5B"],
        ["\xE8\x9F\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x5C"],
        ["\xE8\xA0\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x5F"],
        ["\xE8\xA0\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x61"],
        ["\xE8\x9F\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x62"],
        ["\xE8\x9F\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x63"],
        ["\xE8\x9F\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x64"],
        ["\xE8\xA0\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x5D"],
        ["\xE8\x9F\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x58"],
        ["\xE8\xA0\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x65"],
        ["\xE8\xA0\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x60"],
        ["\xE8\xA0\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x66"],
        ["\xE8\xA0\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x67"],
        ["\xE8\xA0\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x68"],
        ["\xE8\xA0\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x6A"],
        ["\xE8\xA0\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x6B"],
        ["\xE8\xA0\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x6C"],
        ["\xE8\xA0\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x69"],
        ["\xE8\xA0\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x6D"],
        ["\xE8\xA1\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x6F"],
        ["\xE8\xA1\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x6E"],
        ["\xE8\xA1\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x71"],
        ["\xE8\xA1\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x72"],
        ["\xE8\xA1\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x73"],
        ["\xE8\xA1\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x74"],
        ["\xE8\xA1\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x75"],
        ["\xE8\xA2\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x76"],
        ["\xE8\xA1\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x77"],
        ["\xE8\xA2\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x7C"],
        ["\xE8\xA1\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x78"],
        ["\xE8\xA1\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x79"],
        ["\xE8\xA2\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x85"],
        ["\xE8\xA1\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x7A"],
        ["\xE8\xA2\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x7B"],
        ["\xE8\xA2\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x7D"],
        ["\xE8\xA2\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x7E"],
        ["\xE8\xA2\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x7F"],
        ["\xE8\xA2\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x80"],
        ["\xE8\xA2\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x81"],
        ["\xE8\xA2\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x82"],
        ["\xE8\xA2\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x83"],
        ["\xE8\xA2\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC5"],
        ["\xE8\xA2\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x84"],
        ["\xE8\xA2\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x86"],
        ["\xE8\xA3\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x87"],
        ["\xE8\xA3\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x88"],
        ["\xE8\xA3\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x89"],
        ["\xE8\xA3\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x8A"],
        ["\xE8\xA3\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x8B"],
        ["\xE8\xA3\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x8C"],
        ["\xE8\xA3\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x8D"],
        ["\xE8\xA4\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x8E"],
        ["\xE8\xA3\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x8F"],
        ["\xE8\xA3\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x49"],
        ["\xE8\xA3\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x91"],
        ["\xE8\xA3\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x92"],
        ["\xE8\xA4\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x93"],
        ["\xE8\xA4\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x94"],
        ["\xE8\xA4\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x97"],
        ["\xE8\xA4\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x98"],
        ["\xE8\xA5\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x9F"],
        ["\xE8\xA4\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x99"],
        ["\xE8\xA4\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x9A"],
        ["\xE8\xA4\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x95"],
        ["\xE8\xA4\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x9B"],
        ["\xE8\xA5\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x9C"],
        ["\xE8\xA5\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x6B"],
        ["\xE8\xA4\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x9D"],
        ["\xE8\xA4\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x9E"],
        ["\xE8\xA4\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA0"],
        ["\xE8\xA5\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA2"],
        ["\xE8\xA4\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x96"],
        ["\xE8\xA5\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA3"],
        ["\xE8\xA5\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA4"],
        ["\xE8\xA5\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA5"],
        ["\xE8\xA5\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA7"],
        ["\xE8\xA5\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA8"],
        ["\xE8\xA5\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA6"],
        ["\xE8\xA5\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA9"],
        ["\xE8\xA5\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAA"],
        ["\xE8\xA5\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAB"],
        ["\xE8\xA5\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAC"],
        ["\xE8\xA6\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAD"],
        ["\xE8\xA6\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAE"],
        ["\xE8\xA6\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAF"],
        ["\xE8\xA6\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB0"],
        ["\xE8\xA6\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB1"],
        ["\xE8\xA6\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB2"],
        ["\xE8\xA6\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB3"],
        ["\xE8\xA6\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB4"],
        ["\xE8\xA6\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB5"],
        ["\xE8\xA6\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB6"],
        ["\xE8\xA6\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB7"],
        ["\xE8\xA6\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB8"],
        ["\xE8\xA6\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xBA"],
        ["\xE8\xA6\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB9"],
        ["\xE8\xA7\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xBB"],
        ["\xE8\xA7\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xBC"],
        ["\xE8\xA7\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x60"],
        ["\xE8\xA7\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xBD"],
        ["\xE8\xA7\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xBE"],
        ["\xE8\xA7\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xBF"],
        ["\xE8\xA7\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC0"],
        ["\xE8\xA8\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC1"],
        ["\xE8\xA8\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC2"],
        ["\xE8\xA8\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC3"],
        ["\xE8\xA8\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC4"],
        ["\xE8\xA8\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC6"],
        ["\xE8\xA8\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC7"],
        ["\xE8\xA8\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC8"],
        ["\xE8\xA8\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC9"],
        ["\xE8\xA9\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xCA"],
        ["\xE8\xA9\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xCC"],
        ["\xE8\xA9\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xCD"],
        ["\xE8\xA9\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xCE"],
        ["\xE8\xA9\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xCF"],
        ["\xE8\xA9\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD0"],
        ["\xE8\xA9\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD1"],
        ["\xE8\xA9\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD2"],
        ["\xE8\xA9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD3"],
        ["\xE8\xAA\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD5"],
        ["\xE8\xAA\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD6"],
        ["\xE8\xAA\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD7"],
        ["\xE8\xAA\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD8"],
        ["\xE8\xAA\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD9"],
        ["\xE8\xAA\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xDA"],
        ["\xE8\xAA\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xDB"],
        ["\xE8\xAA\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xDC"],
        ["\xE8\xAA\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xDD"],
        ["\xE8\xAA\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xDE"],
        ["\xE8\xAB\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB2"],
        ["\xE8\xAB\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE2"],
        ["\xE8\xAB\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE3"],
        ["\xE8\xAB\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE4"],
        ["\xE8\xAB\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x96"],
        ["\xE8\xAB\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE5"],
        ["\xE8\xAB\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE6"],
        ["\xE8\xAB\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE7"],
        ["\xE8\xAB\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE8"],
        ["\xE8\xAC\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE9"],
        ["\xE8\xAB\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xEA"],
        ["\xE8\xAB\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xEB"],
        ["\xE8\xAB\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF0"],
        ["\xE8\xAB\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF1"],
        ["\xE8\xAB\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF2"],
        ["\xE8\xAC\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF3"],
        ["\xE8\xAC\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF4"],
        ["\xE8\xAC\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF5"],
        ["\xE8\xAB\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xEC"],
        ["\xE8\xAC\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF6"],
        ["\xE8\xAC\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF7"],
        ["\xE8\xAC\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF8"],
        ["\xE8\xAC\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF9"],
        ["\xE8\xAC\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xFA"],
        ["\xE9\x9E\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xFC"],
        ["\xE8\xAC\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xFD"],
        ["\xE8\xAC\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xFE"],
        ["\xE8\xAC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x41"],
        ["\xE8\xAC\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x81"],
        ["\xE8\xAD\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xFB"],
        ["\xE8\xAD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x42"],
        ["\xE8\xAD\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x43"],
        ["\xE8\xAD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x44"],
        ["\xE8\xAD\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x46"],
        ["\xE8\xAD\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x47"],
        ["\xE8\xAD\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x48"],
        ["\xE8\xAD\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x49"],
        ["\xE8\xAD\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x4B"],
        ["\xE8\xAD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x4C"],
        ["\xE8\xAD\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x4D"],
        ["\xE8\xAD\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x4E"],
        ["\xE8\xAD\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x4A"],
        ["\xE8\xAD\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x4F"],
        ["\xE8\xAE\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x51"],
        ["\xE8\xAE\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x52"],
        ["\xE8\xAE\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x53"],
        ["\xE8\xAE\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x55"],
        ["\xE8\xAE\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x56"],
        ["\xE8\xAE\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x57"],
        ["\xE8\xAE\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x54"],
        ["\xE8\xAE\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x58"],
        ["\xE8\xB0\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x59"],
        ["\xE8\xB1\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x5A"],
        ["\xE8\xB0\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x5B"],
        ["\xE8\xB1\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x5C"],
        ["\xE8\xB1\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x5D"],
        ["\xE8\xB1\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x5E"],
        ["\xE8\xB1\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x5F"],
        ["\xE8\xB1\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x60"],
        ["\xE8\xB1\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x61"],
        ["\xE8\xB1\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x62"],
        ["\xE8\xB1\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x63"],
        ["\xE8\xB1\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x64"],
        ["\xE8\xB2\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x66"],
        ["\xE8\xB2\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x67"],
        ["\xE8\xB2\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x68"],
        ["\xE8\xB2\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x69"],
        ["\xE8\xB2\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x6A"],
        ["\xE8\xB2\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x6B"],
        ["\xE8\xB2\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x6D"],
        ["\xE8\xB1\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x65"],
        ["\xE8\xB2\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x6C"],
        ["\xE6\x88\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x6E"],
        ["\xE8\xB2\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x6F"],
        ["\xE8\xB2\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x70"],
        ["\xE8\xB2\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x72"],
        ["\xE8\xB2\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x73"],
        ["\xE8\xB2\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x74"],
        ["\xE8\xB2\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x71"],
        ["\xE8\xB2\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x76"],
        ["\xE8\xB3\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x77"],
        ["\xE8\xB3\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x75"],
        ["\xE8\xB3\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x66"],
        ["\xE8\xB3\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x7A"],
        ["\xE8\xB3\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x7B"],
        ["\xE8\xB3\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x7E"],
        ["\xE8\xB3\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x7F"],
        ["\xE8\xB3\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x80"],
        ["\xE8\xB4\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x5A"],
        ["\xE8\xB4\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x74"],
        ["\xE8\xB4\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x82"],
        ["\xE8\xB4\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x81"],
        ["\xE8\xB4\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x83"],
        ["\xE8\xB4\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x84"],
        ["\xE8\xB4\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x86"],
        ["\xE9\xBD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x6E"],
        ["\xE8\xB4\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x87"],
        ["\xE8\xB3\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x79"],
        ["\xE8\xB4\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x88"],
        ["\xE8\xB4\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x89"],
        ["\xE8\xB5\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x8A"],
        ["\xE8\xB5\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x8B"],
        ["\xE8\xB5\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x8C"],
        ["\xE8\xB5\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC9"],
        ["\xE8\xB6\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x8F"],
        ["\xE8\xB6\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xDE"],
        ["\xE8\xB7\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x90"],
        ["\xE8\xB6\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x91"],
        ["\xE8\xB6\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x92"],
        ["\xE8\xB7\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x93"],
        ["\xE8\xB7\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x94"],
        ["\xE8\xB7\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x95"],
        ["\xE8\xB7\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x96"],
        ["\xE8\xB7\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x97"],
        ["\xE8\xB7\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x98"],
        ["\xE8\xB7\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x99"],
        ["\xE8\xB7\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x9A"],
        ["\xE8\xB7\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x9B"],
        ["\xE8\xB7\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x9C"],
        ["\xE8\xB7\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x9D"],
        ["\xE8\xB8\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x9E"],
        ["\xE8\xB8\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA0"],
        ["\xE8\xB7\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x9F"],
        ["\xE8\xB8\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA1"],
        ["\xE8\xB8\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA2"],
        ["\xE8\xB8\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA3"],
        ["\xE8\xB8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA4"],
        ["\xE8\xB9\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA5"],
        ["\xE8\xB8\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA6"],
        ["\xE8\xB8\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA7"],
        ["\xE8\xB8\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA8"],
        ["\xE8\xB9\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA9"],
        ["\xE8\xB9\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAA"],
        ["\xE8\xB9\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAB"],
        ["\xE8\xB9\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAC"],
        ["\xE8\xB9\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAD"],
        ["\xE8\xB9\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAE"],
        ["\xE8\xB9\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAF"],
        ["\xE8\xB9\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB0"],
        ["\xE8\xB9\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB1"],
        ["\xE8\xB8\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xFC"],
        ["\xE8\xB9\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB3"],
        ["\xE8\xB9\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB2"],
        ["\xE8\xB9\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB4"],
        ["\xE8\xB9\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB5"],
        ["\xE8\xB9\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB7"],
        ["\xE8\xBA\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB8"],
        ["\xE8\xBA\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB6"],
        ["\xE8\xBA\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB9"],
        ["\xE8\xBA\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xBA"],
        ["\xE8\xBA\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xBB"],
        ["\xE8\xBA\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xBC"],
        ["\xE8\xBA\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xBD"],
        ["\xE8\xBA\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xBE"],
        ["\xE8\xBA\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xBF"],
        ["\xE8\xBA\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC0"],
        ["\xE8\xBA\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC2"],
        ["\xE8\xBA\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC1"],
        ["\xE8\xBA\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x44"],
        ["\xE8\xBA\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x7A"],
        ["\xE8\xBB\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC5"],
        ["\xE8\xBA\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC3"],
        ["\xE8\xBA\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC4"],
        ["\xE8\xBB\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC6"],
        ["\xE8\xBB\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC7"],
        ["\xE8\xBB\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC8"],
        ["\xE8\xBB\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xCA"],
        ["\xE8\xBB\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xCB"],
        ["\xE8\xBB\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xCC"],
        ["\xE8\xBB\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xCD"],
        ["\xE8\xBB\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xCE"],
        ["\xE8\xBB\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xCF"],
        ["\xE8\xBC\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD0"],
        ["\xE8\xBC\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD2"],
        ["\xE8\xBC\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD3"],
        ["\xE8\xBC\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD4"],
        ["\xE8\xBC\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD7"],
        ["\xE8\xBC\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD5"],
        ["\xE8\xBC\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD6"],
        ["\xE8\xBC\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD8"],
        ["\xE8\xBC\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x5B"],
        ["\xE8\xBC\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD1"],
        ["\xE8\xBC\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD9"],
        ["\xE8\xBC\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDA"],
        ["\xE8\xBC\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDB"],
        ["\xE8\xBC\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDC"],
        ["\xE8\xBD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDD"],
        ["\xE8\xBD\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDE"],
        ["\xE8\xBC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDF"],
        ["\xE8\xBD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE2"],
        ["\xE8\xBD\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE0"],
        ["\xE8\xBD\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE1"],
        ["\xE8\xBD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE3"],
        ["\xE8\xBD\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE4"],
        ["\xE8\xBD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE5"],
        ["\xE8\xBD\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE6"],
        ["\xE8\xBD\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE7"],
        ["\xE8\xBD\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE8"],
        ["\xE8\xBE\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE9"],
        ["\xE8\xBE\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xEA"],
        ["\xE8\xBE\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xEB"],
        ["\xE8\xBE\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xEE"],
        ["\xE8\xBE\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xEF"],
        ["\xE8\xBE\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF0"],
        ["\xE8\xBF\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF2"],
        ["\xE8\xBF\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF3"],
        ["\xE8\xBF\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF4"],
        ["\xE8\xBF\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x9E"],
        ["\xE8\xBF\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF5"],
        ["\xE9\x82\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x86"],
        ["\xE8\xBF\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF7"],
        ["\xE9\x80\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF8"],
        ["\xE8\xBF\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF9"],
        ["\xE8\xBF\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA9"],
        ["\xE9\x80\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xFB"],
        ["\xE9\x80\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xFC"],
        ["\xE9\x80\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xFE"],
        ["\xE9\x80\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x41"],
        ["\xE9\x80\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x42"],
        ["\xE9\x80\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x43"],
        ["\xE9\x80\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x44"],
        ["\xE9\x80\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x45"],
        ["\xE9\x80\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x46"],
        ["\xE9\x80\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x85"],
        ["\xE9\x80\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x47"],
        ["\xE8\xBF\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xFA"],
        ["\xE9\x81\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x48"],
        ["\xE9\x81\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x4A"],
        ["\xE9\x81\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x4B"],
        ["\xE9\x81\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x4C"],
        ["\xE9\x80\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xFD"],
        ["\xE9\x81\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x4D"],
        ["\xE9\x80\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x4E"],
        ["\xE9\x81\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x4F"],
        ["\xE9\x81\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x50"],
        ["\xE9\x81\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x51"],
        ["\xE9\x81\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x52"],
        ["\xE9\x81\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x54"],
        ["\xE9\x81\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x55"],
        ["\xE9\x9A\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x56"],
        ["\xE9\x81\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x57"],
        ["\xE9\x82\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x58"],
        ["\xE9\x81\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x59"],
        ["\xE9\x82\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x7B"],
        ["\xE9\x82\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x5B"],
        ["\xE9\x82\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xEA"],
        ["\xE9\x82\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x5A"],
        ["\xE9\x82\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x5C"],
        ["\xE9\x82\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA8"],
        ["\xE9\x82\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x5E"],
        ["\xE9\x82\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x5F"],
        ["\xE9\x82\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x60"],
        ["\xE9\x83\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x61"],
        ["\xE9\x83\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x62"],
        ["\xE6\x89\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x5D"],
        ["\xE9\x83\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x63"],
        ["\xE9\x84\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x65"],
        ["\xE9\x84\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x68"],
        ["\xE9\x84\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x69"],
        ["\xE9\x84\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x6A"],
        ["\xE9\x84\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x6C"],
        ["\xE9\x85\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x6D"],
        ["\xE9\x85\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x6E"],
        ["\xE9\x85\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x6F"],
        ["\xE9\x85\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x70"],
        ["\xE9\x85\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x71"],
        ["\xE9\x85\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x72"],
        ["\xE9\x85\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x73"],
        ["\xE9\x85\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x74"],
        ["\xE9\x86\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x75"],
        ["\xE9\x86\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x76"],
        ["\xE9\x86\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x77"],
        ["\xE9\x86\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x78"],
        ["\xE9\x86\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x79"],
        ["\xE9\x86\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x7A"],
        ["\xE9\x86\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x7B"],
        ["\xE9\x86\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x7C"],
        ["\xE9\x86\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x7D"],
        ["\xE9\x86\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x7E"],
        ["\xE9\x87\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x7F"],
        ["\xE9\x87\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x80"],
        ["\xE9\x87\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x52"],
        ["\xE9\x87\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x81"],
        ["\xE9\x87\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x82"],
        ["\xE9\x87\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x87"],
        ["\xE9\x87\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x88"],
        ["\xE9\x87\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x89"],
        ["\xE9\x87\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x84"],
        ["\xE9\x87\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD0"],
        ["\xE9\x87\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x8B"],
        ["\xE9\x87\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x8E"],
        ["\xE9\x88\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x91"],
        ["\xE9\x87\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x92"],
        ["\xE9\x88\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x94"],
        ["\xE9\x88\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x96"],
        ["\xE9\x88\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x97"],
        ["\xE9\x88\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x69"],
        ["\xE9\x89\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x93"],
        ["\xE9\x89\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x99"],
        ["\xE9\x89\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x9A"],
        ["\xE9\x89\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x9C"],
        ["\xE9\x89\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x9D"],
        ["\xE9\x89\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA0"],
        ["\xE9\x8A\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB1"],
        ["\xE9\x88\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA4"],
        ["\xE9\x89\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA7"],
        ["\xE9\x89\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA2"],
        ["\xE9\x8A\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xAA"],
        ["\xE9\x8A\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xAE"],
        ["\xE9\x8A\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xAF"],
        ["\xE9\x8A\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB0"],
        ["\xE9\x89\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA9"],
        ["\xE9\x8B\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB3"],
        ["\xE9\x8A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xBA"],
        ["\xE9\x8A\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xBB"],
        ["\xE9\x8B\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB2"],
        ["\xE9\x8C\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC0"],
        ["\xE9\x8B\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC2"],
        ["\xE9\x8D\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC4"],
        ["\xE9\x8C\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x83"],
        ["\xE9\x8C\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC7"],
        ["\xE9\x8C\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xCA"],
        ["\xE9\x8C\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xCB"],
        ["\xE9\x8C\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xCD"],
        ["\xE9\x8C\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xBE"],
        ["\xE9\x8C\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xBF"],
        ["\xE9\x8C\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xCF"],
        ["\xE9\x8D\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xAD"],
        ["\xE9\x8D\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD1"],
        ["\xE9\x8D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD2"],
        ["\xE9\x8D\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD3"],
        ["\xE9\x8D\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD4"],
        ["\xE9\x8E\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD7"],
        ["\xE9\x8E\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x6E"],
        ["\xE9\x8E\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD9"],
        ["\xE9\x8E\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xDA"],
        ["\xE9\x8E\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD6"],
        ["\xE9\x8F\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xDC"],
        ["\xE9\x8F\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xDE"],
        ["\xE9\x8F\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xDF"],
        ["\xE9\x8F\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE0"],
        ["\xE9\x8F\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE1"],
        ["\xE9\x8F\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE2"],
        ["\xE9\x8F\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE3"],
        ["\xE9\x8F\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE5"],
        ["\xE9\x8F\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xDB"],
        ["\xE9\x8F\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE6"],
        ["\xE9\x90\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE7"],
        ["\xE9\x90\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE9"],
        ["\xE9\x90\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xEA"],
        ["\xE9\x90\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xEC"],
        ["\xE9\x90\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xED"],
        ["\xE9\x90\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xCD"],
        ["\xE9\x90\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xEE"],
        ["\xE9\x90\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xEF"],
        ["\xE9\x90\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x56"],
        ["\xE9\x90\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xEB"],
        ["\xE9\x90\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF1"],
        ["\xE9\x91\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF2"],
        ["\xE9\x91\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF3"],
        ["\xE9\x91\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF5"],
        ["\xE9\x91\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF7"],
        ["\xE9\x91\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF9"],
        ["\xE9\x91\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xFA"],
        ["\xE9\x91\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xFB"],
        ["\xE9\x91\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xFC"],
        ["\xE9\x88\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x98"],
        ["\xE9\x91\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xFE"],
        ["\xE9\x91\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xFD"],
        ["\xE9\x91\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x41"],
        ["\xE9\x91\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x43"],
        ["\xE9\x91\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF8"],
        ["\xE9\x91\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x44"],
        ["\xE9\x91\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x45"],
        ["\xE9\x92\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x46"],
        ["\xE9\x91\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x42"],
        ["\xE9\x96\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x47"],
        ["\xE9\x96\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x48"],
        ["\xE9\x96\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x49"],
        ["\xE9\x96\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x4B"],
        ["\xE9\x96\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x4C"],
        ["\xE9\x96\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x4D"],
        ["\xE9\x96\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x4E"],
        ["\xE9\x96\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x4F"],
        ["\xE9\x96\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x50"],
        ["\xE9\x96\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x51"],
        ["\xE9\x96\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x52"],
        ["\xE9\x96\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x53"],
        ["\xE9\x96\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x54"],
        ["\xE9\x96\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x55"],
        ["\xE9\x96\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x56"],
        ["\xE9\x97\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x57"],
        ["\xE6\xBF\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x58"],
        ["\xE9\x97\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x59"],
        ["\xE9\x97\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x5A"],
        ["\xE9\x97\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x5B"],
        ["\xE9\x97\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x5C"],
        ["\xE9\x97\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x5D"],
        ["\xE9\x97\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x5E"],
        ["\xE9\x97\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x5F"],
        ["\xE9\x97\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x60"],
        ["\xE9\x97\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x61"],
        ["\xE9\x97\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x62"],
        ["\xE9\x98\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x63"],
        ["\xE9\x98\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x64"],
        ["\xE9\x98\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x65"],
        ["\xE9\x98\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x66"],
        ["\xE9\x99\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x67"],
        ["\xE9\x99\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x69"],
        ["\xE9\x99\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x68"],
        ["\xE9\x99\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x6A"],
        ["\xE9\x99\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x6F"],
        ["\xE9\x99\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x6B"],
        ["\xE9\x99\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x72"],
        ["\xE9\x99\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x6C"],
        ["\xE9\x99\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x6D"],
        ["\xE9\x99\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x6E"],
        ["\xE9\x99\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x70"],
        ["\xE9\x99\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x71"],
        ["\xE9\x9A\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x72"],
        ["\xE9\x9A\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x75"],
        ["\xE9\x9A\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x76"],
        ["\xE9\x9A\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x77"],
        ["\xE9\x9A\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x7B"],
        ["\xE9\x9A\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x7A"],
        ["\xE9\x9A\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x7C"],
        ["\xE9\x9A\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x7D"],
        ["\xE9\x9A\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x7E"],
        ["\xE9\x9A\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x80"],
        ["\xE9\x9A\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x81"],
        ["\xE9\x9A\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x82"],
        ["\xE9\x9A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x83"],
        ["\xE9\x9B\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x84"],
        ["\xE9\x9B\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x85"],
        ["\xE9\x9B\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x77"],
        ["\xE9\x9B\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x5B"],
        ["\xE8\xA5\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA1"],
        ["\xE9\x9B\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x87"],
        ["\xE9\x9C\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x8E"],
        ["\xE9\x9B\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x86"],
        ["\xE9\x9B\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x89"],
        ["\xE9\x9C\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x8A"],
        ["\xE9\x9C\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x8B"],
        ["\xE9\x9C\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x8C"],
        ["\xE9\x9C\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x8F"],
        ["\xE9\x9C\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x90"],
        ["\xE9\x9C\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x91"],
        ["\xE9\x9C\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x92"],
        ["\xE9\x9C\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x93"],
        ["\xE9\x9C\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x8D"],
        ["\xE9\x9C\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x94"],
        ["\xE9\x9C\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x95"],
        ["\xE9\x9C\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x96"],
        ["\xE9\x9C\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x98"],
        ["\xE9\x9C\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x9A"],
        ["\xE9\x9C\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x9B"],
        ["\xE9\x9D\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x9D"],
        ["\xE9\x9D\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x9C"],
        ["\xE9\x9D\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x9F"],
        ["\xE9\x9D\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xA0"],
        ["\xE9\x9D\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xA1"],
        ["\xE9\x9D\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xA6"],
        ["\xE9\x9D\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xA7"],
        ["\xE9\x9D\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xA8"],
        ["\xE9\x9D\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xA9"],
        ["\xE9\x9D\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xAA"],
        ["\xE5\x8B\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD6"],
        ["\xE9\x9D\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB5"],
        ["\xE9\x9D\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xCE"],
        ["\xE9\x9D\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xAC"],
        ["\xE9\x9E\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xAD"],
        ["\xE9\x9D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xAE"],
        ["\xE9\x9E\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xAF"],
        ["\xE9\x9D\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB0"],
        ["\xE9\x9E\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x77"],
        ["\xE9\x9E\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB1"],
        ["\xE9\x9E\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB2"],
        ["\xE9\x9E\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB3"],
        ["\xE9\x9E\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB4"],
        ["\xE9\x9E\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB5"],
        ["\xE9\x9E\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB6"],
        ["\xE9\x9E\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB7"],
        ["\xE9\x9E\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB8"],
        ["\xE9\x9E\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xB9"],
        ["\xE9\x9F\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xBA"],
        ["\xE9\x9F\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xBB"],
        ["\xE9\x9F\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xBC"],
        ["\xE9\x9F\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xBD"],
        ["\xE9\x9F\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xBE"],
        ["\xE9\x9F\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xBF"],
        ["\xE9\xBD\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x6F"],
        ["\xE9\x9F\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC0"],
        ["\xE7\xAB\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC1"],
        ["\xE9\x9F\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xFC"],
        ["\xE9\x9F\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC2"],
        ["\xE9\xA0\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC3"],
        ["\xE9\xA0\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x56"],
        ["\xE9\xA0\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xFB"],
        ["\xE9\xA0\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC5"],
        ["\xE9\xA0\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC6"],
        ["\xE9\xA0\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC7"],
        ["\xE9\xA0\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC8"],
        ["\xE9\xA1\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xDC"],
        ["\xE9\xA1\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC9"],
        ["\xE9\xA1\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xCA"],
        ["\xE9\xA1\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xCD"],
        ["\xE9\xA1\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xCE"],
        ["\xE9\xA1\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xCF"],
        ["\xE9\xA1\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xD0"],
        ["\xE9\xA1\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xD1"],
        ["\xE9\xA1\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xD2"],
        ["\xE9\xA2\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xD3"],
        ["\xE9\xA2\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xD4"],
        ["\xE9\xA2\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xD5"],
        ["\xE9\xA2\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xD6"],
        ["\xE9\xA3\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xD7"],
        ["\xE9\xA3\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xD8"],
        ["\xE9\xA3\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xD9"],
        ["\xE9\xA3\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xDC"],
        ["\xE9\xA3\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xDE"],
        ["\xE9\xA4\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xE0"],
        ["\xE9\xA4\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xBC"],
        ["\xE9\xA4\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xE2"],
        ["\xE9\xA4\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xE3"],
        ["\xE9\xA4\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xE4"],
        ["\xE9\xA4\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xE7"],
        ["\xE9\xA4\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xE1"],
        ["\xE9\xA4\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xE8"],
        ["\xE9\xA4\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xE9"],
        ["\xE9\xA4\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xEA"],
        ["\xE9\xA4\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xEB"],
        ["\xE9\xA4\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xEC"],
        ["\xE9\xA4\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xED"],
        ["\xE9\xA4\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xEE"],
        ["\xE9\xA5\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xEF"],
        ["\xE9\xA5\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF0"],
        ["\xE9\xA5\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF1"],
        ["\xE9\xA5\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF2"],
        ["\xE9\xA5\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF3"],
        ["\xE9\xA5\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF4"],
        ["\xE9\xA5\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE8"],
        ["\xE9\xA5\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF5"],
        ["\xE9\xA5\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF6"],
        ["\xE9\xA6\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF7"],
        ["\xE9\xA6\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF8"],
        ["\xE9\xA6\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xFA"],
        ["\xE9\xA6\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xFB"],
        ["\xE9\xA6\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xFC"],
        ["\xE9\xA6\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xFD"],
        ["\xE9\xA7\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xFE"],
        ["\xE9\xA7\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x41"],
        ["\xE9\xA7\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x42"],
        ["\xE9\xA7\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x43"],
        ["\xE9\xA7\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x44"],
        ["\xE9\xA7\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x45"],
        ["\xE9\xA7\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x46"],
        ["\xE9\xA7\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x48"],
        ["\xE9\xA7\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x49"],
        ["\xE9\xA7\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x4A"],
        ["\xE9\xA7\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x4B"],
        ["\xE9\xA8\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x4C"],
        ["\xE9\xA8\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x4D"],
        ["\xE9\xA8\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x4E"],
        ["\xE9\xA7\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x47"],
        ["\xE9\xA8\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x4F"],
        ["\xE9\xA8\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x50"],
        ["\xE9\xA8\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x51"],
        ["\xE9\xA9\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x53"],
        ["\xE9\xA9\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x54"],
        ["\xE9\xA9\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x52"],
        ["\xE9\xA9\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x55"],
        ["\xE9\xA8\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x56"],
        ["\xE9\xA9\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x57"],
        ["\xE9\xA9\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x58"],
        ["\xE9\xA9\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x5A"],
        ["\xE9\xA9\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x5B"],
        ["\xE9\xA9\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x5C"],
        ["\xE9\xA9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x5D"],
        ["\xE9\xA9\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x5F"],
        ["\xE9\xA9\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x60"],
        ["\xE9\xA9\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x5E"],
        ["\xE9\xA9\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x62"],
        ["\xE9\xA9\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x61"],
        ["\xE9\xAA\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x63"],
        ["\xE9\xAA\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x64"],
        ["\xE9\xAA\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x65"],
        ["\xE9\xAB\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x66"],
        ["\xE9\xAB\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x67"],
        ["\xE9\xAB\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x6A"],
        ["\xE9\xAB\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x68"],
        ["\xE9\xAB\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x69"],
        ["\xE9\xAB\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x6D"],
        ["\xE9\xAB\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x6E"],
        ["\xE9\xAB\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x6F"],
        ["\xE9\xAB\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x70"],
        ["\xE9\xAB\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x71"],
        ["\xE9\xAB\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x72"],
        ["\xE9\xAB\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x73"],
        ["\xE9\xAB\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x74"],
        ["\xE9\xAB\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x75"],
        ["\xE9\xAB\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x76"],
        ["\xE9\xAB\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x77"],
        ["\xE9\xAB\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x78"],
        ["\xE9\xAC\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x79"],
        ["\xE9\xAC\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x7A"],
        ["\xE9\xAC\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x7B"],
        ["\xE9\xAC\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x7C"],
        ["\xE9\xAC\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x7D"],
        ["\xE9\xAC\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x7E"],
        ["\xE9\xAC\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x7F"],
        ["\xE9\xAC\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x80"],
        ["\xE9\xAC\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x81"],
        ["\xE9\xAC\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x82"],
        ["\xE9\xAC\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x83"],
        ["\xE9\xAC\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x84"],
        ["\xE9\xAC\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x85"],
        ["\xE9\xAC\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x87"],
        ["\xE9\xAD\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x89"],
        ["\xE9\xAD\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x8A"],
        ["\xE9\xAD\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x89"],
        ["\xE9\xAD\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x8B"],
        ["\xE9\xAD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x8C"],
        ["\xE9\xAD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x8D"],
        ["\xE9\xAD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x8E"],
        ["\xE9\xAD\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x90"],
        ["\xE9\xAE\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x92"],
        ["\xE9\xAE\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x94"],
        ["\xE9\xAE\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x95"],
        ["\xE9\xAE\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x96"],
        ["\xE9\xAE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x97"],
        ["\xE9\xAE\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x98"],
        ["\xE9\xAE\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x99"],
        ["\xE9\xAE\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x9A"],
        ["\xE9\xAE\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x9C"],
        ["\xE9\xAF\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x9D"],
        ["\xE9\xAF\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x9E"],
        ["\xE9\xAE\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xA0"],
        ["\xE9\xAF\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xA1"],
        ["\xE9\xAF\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xA2"],
        ["\xE9\xAF\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xA3"],
        ["\xE9\xAF\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xA4"],
        ["\xE9\xAF\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xA5"],
        ["\xE9\xAF\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xA6"],
        ["\xE9\xAF\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xA7"],
        ["\xE9\xAF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xA8"],
        ["\xE9\xAF\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xA9"],
        ["\xE9\xB0\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF0"],
        ["\xE9\xAF\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xAC"],
        ["\xE9\xAF\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xAB"],
        ["\xE9\xAF\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x51"],
        ["\xE9\xB0\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xAF"],
        ["\xE9\xB0\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xB0"],
        ["\xE9\xB0\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xB2"],
        ["\xE9\xB0\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xB3"],
        ["\xE9\xB0\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xB4"],
        ["\xE9\xB0\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xB5"],
        ["\xE9\xB0\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xB6"],
        ["\xE9\xB0\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xB7"],
        ["\xE9\xB0\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xB8"],
        ["\xE9\xB0\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xAD"],
        ["\xE9\xB0\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xB9"],
        ["\xE9\xB0\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xAE"],
        ["\xE9\xB0\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xBA"],
        ["\xE9\xB0\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xBB"],
        ["\xE9\xB0\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xBC"],
        ["\xE9\xB0\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xBD"],
        ["\xE9\xB1\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xBE"],
        ["\xE9\xB0\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xBF"],
        ["\xE9\xB1\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xC0"],
        ["\xE9\xB0\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xC1"],
        ["\xE9\xB1\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xC2"],
        ["\xE9\xB1\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xC3"],
        ["\xE9\xB1\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xC4"],
        ["\xE9\xB1\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xC5"],
        ["\xE9\xB1\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xC6"],
        ["\xE9\xB3\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xC8"],
        ["\xE9\xB3\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xC9"],
        ["\xE9\xB3\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xCA"],
        ["\xE9\xB4\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xCB"],
        ["\xE9\xB4\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xFC"],
        ["\xE9\xB3\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xC7"],
        ["\xE9\xB4\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xCC"],
        ["\xE9\xB4\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xCD"],
        ["\xE9\xB4\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xCE"],
        ["\xE9\xB4\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xCF"],
        ["\xE9\xB6\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE5"],
        ["\xE9\xB4\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD1"],
        ["\xE9\xB4\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD2"],
        ["\xE9\xB5\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD7"],
        ["\xE9\xB4\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD3"],
        ["\xE9\xB4\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD4"],
        ["\xE9\xB5\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD5"],
        ["\xE9\xB4\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD6"],
        ["\xE9\xB4\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD8"],
        ["\xE9\xB5\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD9"],
        ["\xE9\xB5\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xDA"],
        ["\xE9\xB5\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xDB"],
        ["\xE9\xB5\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xDC"],
        ["\xE9\xB5\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xE0"],
        ["\xE9\xB5\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xDE"],
        ["\xE9\xB5\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xDF"],
        ["\xE9\xB5\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xDD"],
        ["\xE9\xB5\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xE1"],
        ["\xE9\xB6\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x42"],
        ["\xE9\xB6\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xE3"],
        ["\xE9\xB6\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xEA"],
        ["\xE9\xB5\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xE5"],
        ["\xE9\xB5\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xE6"],
        ["\xE9\xB6\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xE7"],
        ["\xE9\xB6\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xE8"],
        ["\xE9\xB6\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xE9"],
        ["\xE9\xB6\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xEB"],
        ["\xE9\xB7\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xEC"],
        ["\xE9\xB7\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xED"],
        ["\xE9\xB6\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xEE"],
        ["\xE9\xB6\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xEF"],
        ["\xE9\xB6\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF0"],
        ["\xE9\xB7\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF1"],
        ["\xE9\xB7\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF2"],
        ["\xE9\xB7\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF3"],
        ["\xE9\xB7\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF5"],
        ["\xE9\xB7\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF6"],
        ["\xE9\xB7\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF7"],
        ["\xE9\xB7\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF8"],
        ["\xE9\xB7\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF9"],
        ["\xE9\xB7\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xFA"],
        ["\xE9\xB7\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xFB"],
        ["\xE9\xB8\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xFC"],
        ["\xE9\xB8\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xFD"],
        ["\xE9\xB8\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x41"],
        ["\xE9\xB9\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x42"],
        ["\xE9\xB9\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x43"],
        ["\xE9\xB9\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x44"],
        ["\xE9\xBA\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x45"],
        ["\xE9\xBA\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x46"],
        ["\xE9\xBA\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x47"],
        ["\xE9\xBA\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x48"],
        ["\xE9\xBA\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF9"],
        ["\xE9\xBA\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x49"],
        ["\xE9\xBA\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x4A"],
        ["\xE9\xBA\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x4B"],
        ["\xE9\xBA\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x4C"],
        ["\xE9\xBA\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB4"],
        ["\xE9\xBA\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x4D"],
        ["\xE9\xBA\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x4E"],
        ["\xE9\xBA\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x4F"],
        ["\xE9\x9D\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x52"],
        ["\xE9\xBB\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x53"],
        ["\xE9\xBB\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA7"],
        ["\xE9\xBB\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x54"],
        ["\xE9\xBB\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x55"],
        ["\xE9\xBB\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x57"],
        ["\xE9\xBB\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x58"],
        ["\xE9\xBB\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x59"],
        ["\xE9\xBB\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x5A"],
        ["\xE9\xBB\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x5B"],
        ["\xE9\xBB\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x5C"],
        ["\xE9\xBB\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x5D"],
        ["\xE9\xBB\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x5E"],
        ["\xE9\xBB\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x5F"],
        ["\xE9\xBB\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x60"],
        ["\xE9\xBB\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x61"],
        ["\xE9\xBB\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x62"],
        ["\xE9\xBB\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x63"],
        ["\xE9\xBB\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x64"],
        ["\xE9\xBB\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x65"],
        ["\xE9\xBC\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x66"],
        ["\xE9\xBC\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x67"],
        ["\xE7\x9A\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x68"],
        ["\xE9\xBC\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x69"],
        ["\xE9\xBC\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x6A"],
        ["\xE9\xBC\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x6B"],
        ["\xE9\xBC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x6C"],
        ["\xE9\xBD\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x6D"],
        ["\xE9\xBD\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x70"],
        ["\xE9\xBD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x71"],
        ["\xE9\xBD\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x72"],
        ["\xE9\xBD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x73"],
        ["\xE9\xBD\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x74"],
        ["\xE9\xBD\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x75"],
        ["\xE9\xBD\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x76"],
        ["\xE9\xBD\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x77"],
        ["\xE9\xBD\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x78"],
        ["\xE9\xBD\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x79"],
        ["\xE9\xBD\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x7A"],
        ["\xE9\xBD\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x7B"],
        ["\xE9\xBD\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x7C"],
        ["\xE9\xBE\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x7D"],
        ["\xE9\xBE\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x7E"],
        ["\xE9\xBE\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x7F"],
        ["\xE5\xA0\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x53"],
        ["\xE6\xA7\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB9"],
        ["\xE9\x81\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF3"],
        ["\xE7\x91\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xBB"],
        ["\xE5\x87\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x84"],
        ["\xE7\x86\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x68"],
        ["\xE2\x85\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xB1"],
        ["\xE2\x85\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xB2"],
        ["\xE2\x85\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xB3"],
        ["\xE2\x85\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xB4"],
        ["\xE2\x85\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xB5"],
        ["\xE2\x85\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xB6"],
        ["\xE2\x85\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xB7"],
        ["\xE2\x85\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xB8"],
        ["\xE2\x85\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xB9"],
        ["\xE2\x85\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xBA"],
        ["\xEF\xBF\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\xEF\xBC\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x7D"],
        ["\xEF\xBC\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x7F"],
        ["\xE7\xBA\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xBF"],
        ["\xE8\xA4\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xDA"],
        ["\xE9\x8D\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF7"],
        ["\xE9\x8A\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x4B"],
        ["\xE8\x93\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x7B"],
        ["\xE4\xBF\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x94"],
        ["\xE7\x82\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x9E"],
        ["\xE6\x98\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xEB"],
        ["\xE6\xA3\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x86"],
        ["\xE9\x8B\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x94"],
        ["\xE6\x9B\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x97"],
        ["\xE5\xBD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC7"],
        ["\xE4\xB8\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x44"],
        ["\xE4\xBB\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x5D"],
        ["\xE4\xBB\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x62"],
        ["\xE4\xBC\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x65"],
        ["\xE4\xBC\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x66"],
        ["\xE4\xBC\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x6A"],
        ["\xE4\xBD\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x6E"],
        ["\xE4\xBE\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x70"],
        ["\xE4\xBE\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x71"],
        ["\xE4\xBE\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x74"],
        ["\xE4\xBE\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x7B"],
        ["\xE4\xBF\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x86"],
        ["\xE5\x81\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x8A"],
        ["\xE5\x80\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x91"],
        ["\xE4\xBF\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x94"],
        ["\xE5\x80\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x98"],
        ["\xE5\x81\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA2"],
        ["\xE5\x81\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA3"],
        ["\xE5\x81\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA4"],
        ["\xE5\x82\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA8"],
        ["\xE5\x83\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB2"],
        ["\xE5\x83\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB5"],
        ["\xE5\x85\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC9"],
        ["\xE5\x85\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xCE"],
        ["\xE5\x86\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xDC"],
        ["\xE5\x86\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE8"],
        ["\xE5\x87\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xEF"],
        ["\xE5\x88\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF7"],
        ["\xE5\x8A\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x4F"],
        ["\xE5\x8A\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x50"],
        ["\xE5\x8B\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x56"],
        ["\xE5\x8B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x58"],
        ["\xE5\x8C\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x61"],
        ["\xE5\x8C\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x63"],
        ["\xE5\x8C\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x6B"],
        ["\xE5\x8D\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x7C"],
        ["\xE5\x8E\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x80"],
        ["\xE5\x8E\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x87"],
        ["\xE5\x8F\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x8B"],
        ["\xEF\xA8\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x8E"],
        ["\xE5\x92\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA9"],
        ["\xE5\x92\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xAE"],
        ["\xE5\x92\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xBD"],
        ["\xE5\x93\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC0"],
        ["\xE5\x96\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xDE"],
        ["\xE5\x9D\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x60"],
        ["\xE5\x9D\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x63"],
        ["\xE5\x9E\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x6C"],
        ["\xE5\x9F\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x70"],
        ["\xE5\x9F\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x73"],
        ["\xEF\xA8\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x77"],
        ["\xEF\xA8\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x82"],
        ["\xE5\xA2\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x8A"],
        ["\xE5\xA2\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x8C"],
        ["\xE5\xA4\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA1"],
        ["\xE5\xA5\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xAD"],
        ["\xE5\xA5\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB0"],
        ["\xE5\xA5\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB1"],
        ["\xE5\xA5\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB2"],
        ["\xE5\xA6\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xBE"],
        ["\xE5\xA6\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC0"],
        ["\xE5\xAD\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xEC"],
        ["\xE5\xAF\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xFC"],
        ["\xE7\x94\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xFE"],
        ["\xE5\xAF\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x42"],
        ["\xE5\xAF\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x44"],
        ["\xE5\xB0\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x51"],
        ["\xE5\xB2\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x67"],
        ["\xE5\xB2\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x68"],
        ["\xE5\xB3\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x70"],
        ["\xE5\xB4\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x78"],
        ["\xE5\xB5\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x7F"],
        ["\xEF\xA8\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x80"],
        ["\xE5\xB5\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x84"],
        ["\xE5\xB5\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x87"],
        ["\xE5\xB6\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x93"],
        ["\xE5\xB6\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x95"],
        ["\xE5\xB7\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x97"],
        ["\xE5\xBC\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC7"],
        ["\xE5\xBC\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xCB"],
        ["\xE5\xBD\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD8"],
        ["\xE5\xBE\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE8"],
        ["\xE5\xBF\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF1"],
        ["\xE6\x81\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x44"],
        ["\xE6\x82\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x51"],
        ["\xE6\x82\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x57"],
        ["\xE6\x83\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x5F"],
        ["\xE6\x83\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x65"],
        ["\xE6\x84\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x67"],
        ["\xE6\x83\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x68"],
        ["\xE6\x84\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x76"],
        ["\xE6\x84\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x79"],
        ["\xE6\x84\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x7E"],
        ["\xE6\x86\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x94"],
        ["\xE6\x88\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB5"],
        ["\xE6\x8A\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xDA"],
        ["\xE6\x8F\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xFB"],
        ["\xE6\x91\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x50"],
        ["\xE6\x92\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x53"],
        ["\xE6\x93\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x54"],
        ["\xE6\x95\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x7E"],
        ["\xE6\x98\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x97"],
        ["\xE6\x98\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x98"],
        ["\xE6\x98\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x9F"],
        ["\xE6\x98\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x9D"],
        ["\xE6\x98\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA0"],
        ["\xE6\x98\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA1"],
        ["\xE6\x98\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA4"],
        ["\xE6\x99\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA7"],
        ["\xE6\x99\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA8"],
        ["\xE6\x99\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xAB"],
        ["\xEF\xA8\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xAE"],
        ["\xE6\x99\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xAF"],
        ["\xE6\x9A\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB4"],
        ["\xE6\x9A\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB6"],
        ["\xE6\x9A\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB8"],
        ["\xE6\x9A\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xBB"],
        ["\xE6\x9B\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC7"],
        ["\xE6\x9C\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC8"],
        ["\xEF\xA4\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC9"],
        ["\xE6\x9D\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD8"],
        ["\xE6\x9E\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE3"],
        ["\xE6\xA1\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xEC"],
        ["\xE6\x9F\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF0"],
        ["\xE6\xA0\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF3"],
        ["\xE6\xA1\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF9"],
        ["\xE6\xA3\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x5F"],
        ["\xEF\xA8\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x66"],
        ["\xE6\xA5\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x6E"],
        ["\xEF\xA8\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x78"],
        ["\xE6\xA6\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x79"],
        ["\xE6\xA7\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x90"],
        ["\xE6\xA8\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x9A"],
        ["\xE6\xA9\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x9B"],
        ["\xE6\xA9\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA6"],
        ["\xE6\xA9\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA9"],
        ["\xE6\xA9\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xAF"],
        ["\xE6\xAB\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB9"],
        ["\xE6\xAB\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBC"],
        ["\xE6\xAF\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xEA"],
        ["\xE6\xB0\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF6"],
        ["\xE6\xB1\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF9"],
        ["\xE6\xB2\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xFD"],
        ["\xE6\xB1\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xFE"],
        ["\xE6\xB3\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x4E"],
        ["\xE6\xB4\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x58"],
        ["\xE6\xB6\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x60"],
        ["\xE6\xB5\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x62"],
        ["\xE6\xB6\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x6B"],
        ["\xE6\xB6\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x72"],
        ["\xE6\xB7\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x74"],
        ["\xE6\xB7\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x7A"],
        ["\xE6\xB7\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x7F"],
        ["\xE6\xB7\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x80"],
        ["\xE6\xB8\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x8A"],
        ["\xE6\xB9\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x8E"],
        ["\xE6\xB8\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x93"],
        ["\xE6\xB8\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x95"],
        ["\xE6\xBA\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA6"],
        ["\xE6\xBE\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC1"],
        ["\xE6\xBE\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xCA"],
        ["\xE6\xBF\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD5"],
        ["\xE7\x80\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD7"],
        ["\xE7\x80\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD8"],
        ["\xE7\x80\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE3"],
        ["\xE7\x82\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xEA"],
        ["\xE7\x82\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xED"],
        ["\xE7\x84\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF5"],
        ["\xE7\x84\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF6"],
        ["\xE7\x85\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xFB"],
        ["\xE7\x85\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xFC"],
        ["\xE7\x85\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xFD"],
        ["\xEF\xA8\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x49"],
        ["\xE7\x87\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x4B"],
        ["\xE7\x87\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x5A"],
        ["\xE7\x8A\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x73"],
        ["\xE7\x8A\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x75"],
        ["\xE7\x8C\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x86"],
        ["\xEF\xA8\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x8A"],
        ["\xE7\x8D\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x94"],
        ["\xE7\x8E\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x99"],
        ["\xE7\x8F\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x9E"],
        ["\xE7\x8F\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x9F"],
        ["\xE7\x8F\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA1"],
        ["\xE7\x8F\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA2"],
        ["\xE7\x90\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA7"],
        ["\xE7\x8F\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA8"],
        ["\xE7\x90\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xAA"],
        ["\xE7\x90\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xAB"],
        ["\xE7\x90\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xAD"],
        ["\xE7\x90\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xAE"],
        ["\xE7\x91\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xBC"],
        ["\xE7\x92\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xBD"],
        ["\xE7\x92\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC0"],
        ["\xE7\x94\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD1"],
        ["\xE7\x95\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE7"],
        ["\xE7\x9A\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x69"],
        ["\xE7\x9A\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x70"],
        ["\xE7\x9A\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x71"],
        ["\xE7\x9A\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x72"],
        ["\xE7\x9A\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x73"],
        ["\xEF\xA8\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x7A"],
        ["\xE7\x9D\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x8E"],
        ["\xE5\x8A\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xAA"],
        ["\xE7\xA0\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xAE"],
        ["\xE7\xA1\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB2"],
        ["\xE7\xA1\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB3"],
        ["\xE7\xA1\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB6"],
        ["\xE7\xA4\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD1"],
        ["\xEF\xA8\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD2"],
        ["\xEF\xA8\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD5"],
        ["\xEF\xA8\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD9"],
        ["\xE7\xA6\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xDC"],
        ["\xEF\xA8\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xDD"],
        ["\xE7\xA6\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xDF"],
        ["\xE7\xAB\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x4F"],
        ["\xE7\xAB\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x58"],
        ["\xEF\xA8\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x59"],
        ["\xE7\xAB\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x5A"],
        ["\xE7\xAE\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x82"],
        ["\xEF\xA8\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xAD"],
        ["\xE7\xB5\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC4"],
        ["\xE7\xB5\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC6"],
        ["\xE7\xB6\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD4"],
        ["\xE7\xB6\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xDA"],
        ["\xE7\xB7\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE1"],
        ["\xE7\xB9\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xFD"],
        ["\xE7\xBD\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x57"],
        ["\xE7\xBE\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x6E"],
        ["\xEF\xA8\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x77"],
        ["\xE8\x8C\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF8"],
        ["\xE8\x8D\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x48"],
        ["\xE8\x8D\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x5B"],
        ["\xE8\x8F\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x67"],
        ["\xE8\x8F\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x74"],
        ["\xE8\x91\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x7E"],
        ["\xE8\x92\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x8A"],
        ["\xE8\x95\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x9E"],
        ["\xE8\x95\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA1"],
        ["\xE8\x95\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA8"],
        ["\xEF\xA8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB9"],
        ["\xE8\x96\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xBB"],
        ["\xEF\xA8\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xCE"],
        ["\xEF\xA8\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE2"],
        ["\xE8\xA0\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x5E"],
        ["\xE8\xA3\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x90"],
        ["\xE8\xA8\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC5"],
        ["\xE8\xA8\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xCB"],
        ["\xE8\xA9\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD4"],
        ["\xE8\xAA\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xDF"],
        ["\xE8\xAA\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE1"],
        ["\xE8\xAB\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xED"],
        ["\xEF\xA8\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xEE"],
        ["\xE8\xAB\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xEF"],
        ["\xE8\xAD\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x45"],
        ["\xE8\xAD\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x50"],
        ["\xE8\xB3\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x7C"],
        ["\xE8\xB3\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x7D"],
        ["\xE8\xB4\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x85"],
        ["\xE8\xB5\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x8D"],
        ["\xEF\xA8\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x8E"],
        ["\xE8\xBB\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC9"],
        ["\xEF\xA8\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF1"],
        ["\xEF\xA8\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x49"],
        ["\xE9\x81\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x53"],
        ["\xE9\x83\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x64"],
        ["\xEF\xA8\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x66"],
        ["\xE9\x84\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x67"],
        ["\xE9\x84\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x6B"],
        ["\xE9\x87\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x83"],
        ["\xE9\x87\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x85"],
        ["\xE9\x87\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x86"],
        ["\xE9\x87\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x8A"],
        ["\xE9\x87\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x8C"],
        ["\xE9\x87\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x8D"],
        ["\xE9\x87\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x8F"],
        ["\xE9\x88\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x90"],
        ["\xE9\x88\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x93"],
        ["\xE9\x88\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x95"],
        ["\xE9\x88\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x9B"],
        ["\xE9\x89\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x9E"],
        ["\xE9\x88\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x9F"],
        ["\xE9\x89\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA1"],
        ["\xE9\x89\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA3"],
        ["\xE9\x89\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA5"],
        ["\xE9\x88\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA6"],
        ["\xE9\x89\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA8"],
        ["\xE9\x8A\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xAB"],
        ["\xE9\x89\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xAC"],
        ["\xE9\x89\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xAD"],
        ["\xE9\x8B\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB4"],
        ["\xE9\x8B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB5"],
        ["\xE9\x8B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB6"],
        ["\xE9\x8B\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB7"],
        ["\xEF\xA8\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB8"],
        ["\xE9\x8B\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB9"],
        ["\xE9\x8B\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xBC"],
        ["\xE9\x8B\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xBD"],
        ["\xE9\x8C\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC1"],
        ["\xE9\x8C\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC3"],
        ["\xE9\x8B\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC5"],
        ["\xEF\xA8\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC6"],
        ["\xE9\x8C\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC8"],
        ["\xE9\x8B\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC9"],
        ["\xE9\x8C\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xCC"],
        ["\xE9\x8C\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xCE"],
        ["\xE9\x8D\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD0"],
        ["\xE9\x8D\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD5"],
        ["\xE9\x8E\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD8"],
        ["\xE9\x8F\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xDD"],
        ["\xE9\x8F\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE4"],
        ["\xE9\x8F\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE8"],
        ["\xE9\x90\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF0"],
        ["\xE9\x91\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF4"],
        ["\xE9\x91\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF6"],
        ["\xE9\x96\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x4A"],
        ["\xEF\xA7\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x74"],
        ["\xEF\xA8\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x78"],
        ["\xE9\x9A\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x79"],
        ["\xE9\x9A\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x7F"],
        ["\xE9\x9C\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x97"],
        ["\xE9\x9C\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x99"],
        ["\xE9\x9D\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x9E"],
        ["\xE9\x9D\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xA2"],
        ["\xE9\x9D\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xA3"],
        ["\xE9\x9D\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xA4"],
        ["\xE9\x9D\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xA5"],
        ["\xE9\xA1\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xCB"],
        ["\xE9\xA1\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xCC"],
        ["\xEF\xA8\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xDD"],
        ["\xEF\xA8\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xDF"],
        ["\xE9\xA4\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xE5"],
        ["\xEF\xA8\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xE6"],
        ["\xE9\xA6\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xF9"],
        ["\xE9\xA9\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x59"],
        ["\xE9\xAB\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x6B"],
        ["\xE9\xAB\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x6C"],
        ["\xE9\xAD\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x8F"],
        ["\xE9\xAD\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x91"],
        ["\xE9\xAE\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x93"],
        ["\xE9\xAE\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x9B"],
        ["\xE9\xAE\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x9F"],
        ["\xE9\xB0\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xB1"],
        ["\xE9\xB5\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xE2"],
        ["\xE9\xB5\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xE4"],
        ["\xEF\xA8\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xF4"],
        ["\xE9\xB8\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xFE"],
        ["\xE9\xBB\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x56"],
        ["\xE2\x80\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x4A"],
        ["\xE2\x80\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x7C"],
        ["\xE2\x88\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x60"],
        ["\xE3\x80\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\xE3\x80\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\xE3\x80\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\xE3\x80\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\xE3\x80\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\xE3\x83\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\xE3\x82\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\xE2\x8A\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x74"],
        ["\xE2\x8A\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x75"],
        ["\xE2\x8A\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x78"],
        ["\xE2\x8A\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x79"],
        ["\xE2\x88\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xCF"],
        ["\xE2\x88\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xCD"],
        ["\xE2\x8C\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\xE2\x8C\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\xE2\x8A\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x83"],
        ["\xE2\x8A\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x84"],
        ["\xE2\x8A\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x85"],
        ["\xE2\x88\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE6"],
        ["\xEF\xBD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\xEF\xBD\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\xE3\x80\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\xE3\x80\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\xE3\x80\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\xE3\x80\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\xE2\x89\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x58"],
        ["\xE2\x89\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xFA"],
        ["\xE2\x89\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xFC"],
        ["\xE2\x89\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x41"],
        ["\xE2\x89\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x68"],
        ["\xE2\x89\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x69"],
        ["\xE2\x86\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\x61"],
        ["\xE2\x99\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\xE2\x99\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xE2\x99\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xE2\x99\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xE2\x96\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xE2\x96\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xE2\x97\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\xE2\x97\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\xE2\x86\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\x64"],
        ["\xE2\x86\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\x65"],
        ["\xE2\x86\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\x63"],
        ["\xE2\x86\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\x66"],
        ["\xE2\x87\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\x91"],
        ["\xE2\x87\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB3"],
        ["\xE2\x87\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB1"],
        ["\xE2\x87\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB2"],
        ["\xE2\x87\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB4"],
        ["\xE2\xA4\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x77"],
        ["\xE2\xA4\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x78"],
        ["\xE2\xA6\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x44"],
        ["\xE2\x97\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xE3\x80\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\xEF\xB9\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],
        ["\xEF\xB9\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],
        ["\xE2\x97\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x4F"],
        ["\xE2\x80\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xBD"],
        ["\xE2\x88\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD7"],
        ["\xE2\x84\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD8"],
        ["\xE2\x84\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB5"],
        ["\xE3\x8F\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6A"],
        ["\xE2\x84\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB9"],
        ["\xE2\x84\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xCB"],
        ["\xE3\x82\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\xE2\x80\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB6"],
        ["\xE2\xA7\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x7F"],
        ["\xE2\xA7\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x80"],
        ["\xE3\x82\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\xE3\x82\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\xE3\x82\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\xE2\x99\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xE2\x99\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\xE2\x99\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xE2\x99\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xE2\x99\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\xE2\x99\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xE2\x99\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xE2\x99\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xCF\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\x94"],
        ["\xE2\x93\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x47"],
        ["\xE2\x93\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x48"],
        ["\xE2\x93\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x49"],
        ["\xE2\x93\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4A"],
        ["\xE2\x93\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4B"],
        ["\xE2\x93\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4C"],
        ["\xE2\x93\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4D"],
        ["\xE2\x93\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4E"],
        ["\xE2\x93\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4F"],
        ["\xE2\x93\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x50"],
        ["\xE2\x98\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\xE2\x98\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\xE3\x80\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\xE2\x98\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x74"],
        ["\xE2\x98\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x68"],
        ["\xE2\x98\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],
        ["\xE2\x98\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x6A"],
        ["\xE2\x98\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x6B"],
        ["\xE2\x99\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xE2\x96\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\xE3\x87\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x85"],
        ["\xE3\x87\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x86"],
        ["\xE3\x87\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x87"],
        ["\xE3\x87\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x88"],
        ["\xE3\x87\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x89"],
        ["\xE3\x87\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x8A"],
        ["\xE3\x87\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x8B"],
        ["\xE3\x87\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x8C"],
        ["\xE3\x87\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x8D"],
        ["\xE3\x87\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x8E"],
        ["\xE3\x87\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x8F"],
        ["\xE3\x87\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x90"],
        ["\xE3\x87\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x91"],
        ["\xE3\x87\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x92"],
        ["\xE3\x87\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x93"],
        ["\xE3\x87\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x94"],
        ["\xE2\x8E\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xE2\x8E\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\xE2\x8F\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xE2\x8F\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xE2\x8F\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xE2\x8F\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\xE2\x8F\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\xE2\x8F\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\xE2\x8F\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFD"],
        ["\xE2\x8F\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFE"],
        ["\xE2\x8F\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x41"],
        ["\xE2\x8F\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x42"],
        ["\xE2\x8F\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x43"],
        ["\xE2\x8F\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x44"],
        ["\xE2\x8F\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x45"],
        ["\xE3\x83\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\xE3\x83\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\xE3\x83\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\xE3\x83\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\xE2\x8B\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xE2\x8B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xE2\x85\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF3"],
        ["\xE2\x85\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF4"],
        ["\xE2\x85\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF5"],
        ["\xE2\x9C\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\xE2\x8C\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xE2\x90\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],
        ["\xE2\x8F\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x46"],
        ["\xE3\x89\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\xE3\x89\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\xE3\x89\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\xE3\x89\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\xE3\x89\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\xE3\x89\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\xE3\x89\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\xE3\x89\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\xE3\x89\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\xE3\x89\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\xE3\x89\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\xE3\x89\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\xE3\x89\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\xE3\x89\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\xE3\x89\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\xE3\x8A\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\xE3\x8A\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\xE3\x8A\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\xE3\x8A\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\xE3\x8A\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\xE3\x8A\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\xE3\x8A\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\xE3\x8A\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\xE3\x8A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\xE3\x8A\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\xE3\x8A\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\xE3\x8A\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\xE3\x8A\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\xE3\x8A\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\xE3\x8A\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\xE2\x97\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xE2\x97\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xE2\x97\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xE2\x97\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\xE2\x80\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD0"],
        ["\xE2\x81\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDA"],
        ["\xE2\x81\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDB"],
        ["\xE2\x81\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDC"],
        ["\xC7\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x7C"],
        ["\xC7\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x7D"],
        ["\xC7\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x7F"],
        ["\xE1\xB8\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xDE"],
        ["\xE1\xB8\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xDF"],
        ["\xC7\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x94"],
        ["\xC7\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x95"],
        ["\xC7\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x80"],
        ["\xC7\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x81"],
        ["\xC7\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x83"],
        ["\xC7\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x85"],
        ["\xC7\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x87"],
        ["\xC7\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x89"],
        ["\xC7\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x8B"],
        ["\xE2\x82\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE1"],
        ["\xC2\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x41"],
        ["\xC2\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x42"],
        ["\xC2\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x43"],
        ["\xC2\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x6A"],
        ["\xC2\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x44"],
        ["\xC2\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x45"],
        ["\xC2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x46"],
        ["\xC2\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x47"],
        ["\xC2\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x48"],
        ["\xC2\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x49"],
        ["\xC2\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x4A"],
        ["\xC2\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x4B"],
        ["\xC2\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x4D"],
        ["\xC2\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x4E"],
        ["\xC2\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x4F"],
        ["\xC2\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x50"],
        ["\xC2\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x51"],
        ["\xC2\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x52"],
        ["\xC2\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x53"],
        ["\xC2\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x54"],
        ["\xC2\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x55"],
        ["\xC3\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x56"],
        ["\xC3\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x57"],
        ["\xC3\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x58"],
        ["\xC3\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x59"],
        ["\xC3\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x5A"],
        ["\xC3\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x5B"],
        ["\xC3\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x5C"],
        ["\xC3\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x5D"],
        ["\xC3\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x5E"],
        ["\xC3\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x5F"],
        ["\xC3\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x60"],
        ["\xC3\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x61"],
        ["\xC3\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x62"],
        ["\xC3\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x63"],
        ["\xC3\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x64"],
        ["\xC3\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x65"],
        ["\xC3\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x66"],
        ["\xC3\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x67"],
        ["\xC3\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x68"],
        ["\xC3\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x69"],
        ["\xC3\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x6A"],
        ["\xC3\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x6B"],
        ["\xC3\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x6C"],
        ["\xC3\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x6D"],
        ["\xC3\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x6E"],
        ["\xC3\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x6F"],
        ["\xC3\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x70"],
        ["\xC3\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x71"],
        ["\xC3\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x72"],
        ["\xC3\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x73"],
        ["\xC3\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x74"],
        ["\xC3\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x75"],
        ["\xC3\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x76"],
        ["\xC3\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x77"],
        ["\xC3\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x78"],
        ["\xC3\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x79"],
        ["\xC3\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x7A"],
        ["\xC3\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x7B"],
        ["\xC3\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x7C"],
        ["\xC3\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x7D"],
        ["\xC3\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x7E"],
        ["\xC3\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x7F"],
        ["\xC3\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x80"],
        ["\xC3\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x81"],
        ["\xC3\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x82"],
        ["\xC3\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x83"],
        ["\xC3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x84"],
        ["\xC3\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x85"],
        ["\xC3\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x86"],
        ["\xC3\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x87"],
        ["\xC3\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x88"],
        ["\xC3\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x89"],
        ["\xC3\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x8A"],
        ["\xC3\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x8B"],
        ["\xC3\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x8C"],
        ["\xC3\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x8D"],
        ["\xC3\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x8E"],
        ["\xC3\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x8F"],
        ["\xC3\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x90"],
        ["\xC3\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x91"],
        ["\xC3\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x92"],
        ["\xC3\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\x93"],
        ["\xC4\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB8"],
        ["\xC4\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],
        ["\xC5\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x64"],
        ["\xC4\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xCA"],
        ["\xC5\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x46"],
        ["\xC4\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB9"],
        ["\xC4\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE3"],
        ["\xC5\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x65"],
        ["\xC4\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xCB"],
        ["\xC5\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x47"],
        ["\xC4\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBC"],
        ["\xCB\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],
        ["\xC5\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],
        ["\xC4\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],
        ["\xC5\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x54"],
        ["\xC5\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x5A"],
        ["\xC5\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x58"],
        ["\xC5\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x5E"],
        ["\xC5\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x73"],
        ["\xC5\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x77"],
        ["\xC5\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x75"],
        ["\xC4\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBD"],
        ["\xCB\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xFC"],
        ["\xC5\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xFA"],
        ["\xC4\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],
        ["\xC5\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x55"],
        ["\xCB\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xED"],
        ["\xC5\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x5B"],
        ["\xC5\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x59"],
        ["\xC5\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x5F"],
        ["\xC5\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x74"],
        ["\xCB\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xFE"],
        ["\xC5\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x78"],
        ["\xC5\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x76"],
        ["\xC5\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x4E"],
        ["\xC4\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBA"],
        ["\xC4\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],
        ["\xC4\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBE"],
        ["\xC4\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],
        ["\xC4\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD0"],
        ["\xC4\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],
        ["\xC4\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],
        ["\xC5\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xFB"],
        ["\xC5\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x41"],
        ["\xC5\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x4A"],
        ["\xC5\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x52"],
        ["\xC5\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x68"],
        ["\xC5\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x6A"],
        ["\xC5\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x5C"],
        ["\xC5\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x4F"],
        ["\xC4\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],
        ["\xC4\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],
        ["\xC4\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBF"],
        ["\xC4\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],
        ["\xC4\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],
        ["\xC4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],
        ["\xC4\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],
        ["\xC4\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],
        ["\xC5\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xFC"],
        ["\xC5\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x42"],
        ["\xC5\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x4B"],
        ["\xC5\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x53"],
        ["\xC5\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x69"],
        ["\xC5\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x6B"],
        ["\xC5\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x5D"],
        ["\xCB\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xFA"],
        ["\xC4\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC0"],
        ["\xC4\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],
        ["\xC4\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDC"],
        ["\xC4\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xEC"],
        ["\xC5\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x56"],
        ["\xC5\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x66"],
        ["\xC4\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],
        ["\xC4\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],
        ["\xC4\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDD"],
        ["\xC4\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xED"],
        ["\xC5\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x57"],
        ["\xC5\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x67"],
        ["\xC9\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAD"],
        ["\xCA\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],
        ["\xC9\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBA"],
        ["\xCA\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBF"],
        ["\xCA\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCE"],
        ["\xC9\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA8"],
        ["\xC9\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAA"],
        ["\xC9\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB5"],
        ["\xCA\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],
        ["\xC9\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x92"],
        ["\xC9\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAF"],
        ["\xC9\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB9"],
        ["\xCA\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBE"],
        ["\xCA\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCC"],
        ["\xC9\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB7"],
        ["\xC9\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA9"],
        ["\xC9\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x9B"],
        ["\xC9\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAE"],
        ["\xCA\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],
        ["\xCA\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCA"],
        ["\xC9\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x9D"],
        ["\xC5\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x45"],
        ["\xC9\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAC"],
        ["\xCA\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBD"],
        ["\xC4\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDF"],
        ["\xCA\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],
        ["\xCA\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],
        ["\xC9\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA2"],
        ["\xCA\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],
        ["\xC7\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x7B"],
        ["\xC9\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x8F"],
        ["\xC9\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x93"],
        ["\xCA\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],
        ["\xC9\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x9C"],
        ["\xC6\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x93"],
        ["\xC5\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x4D"],
        ["\xC5\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x4C"],
        ["\xC9\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA4"],
        ["\xCA\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],
        ["\xC9\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x94"],
        ["\xC9\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB1"],
        ["\xC9\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x95"],
        ["\xC9\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x98"],
        ["\xC9\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x9A"],
        ["\xC9\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x8C"],
        ["\xC9\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],
        ["\xCA\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],
        ["\xC9\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA0"],
        ["\xCA\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],
        ["\xC9\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x90"],
        ["\xC9\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x8D"],
        ["\xC9\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x8E"],
        ["\xCA\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],
        ["\xC9\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],
        ["\xCA\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xDE"],
        ["\xCA\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xDD"],
        ["\xC9\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x91"],
        ["\xCA\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCD"],
        ["\xC9\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB6"],
        ["\xC9\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA3"],
        ["\xC9\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\x96"],
        ["\xC7\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\x90"],
        ["\xE1\xBD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\x63"],
        ["\xE1\xBD\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\x64"],
        ["\xE1\xBD\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\x62"],
        ["\xE1\xBD\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\x65"],
        ["\xCD\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],
        ["\xCB\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xEE"],
        ["\xCB\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],
        ["\xCB\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],
        ["\xCB\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],
        ["\xCC\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x57"],
        ["\xE2\x80\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD2"],
        ["\xCC\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x5C"],
        ["\xCC\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x52"],
        ["\xCC\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x55"],
        ["\xCC\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x51"],
        ["\xCC\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x60"],
        ["\xCC\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x5D"],
        ["\xCC\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x53"],
        ["\xCB\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\x42"],
        ["\xCB\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\x43"],
        ["\xCB\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\x44"],
        ["\xCB\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\x45"],
        ["\xCB\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\x46"],
        ["\xCC\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x76"],
        ["\xCC\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x7D"],
        ["\xCC\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8A"],
        ["\xCC\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6D"],
        ["\xCC\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x70"],
        ["\xCC\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x71"],
        ["\xCC\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x59"],
        ["\xCC\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8E"],
        ["\xCC\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x7A"],
        ["\xCC\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x80"],
        ["\xCB\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\x41"],
        ["\xCC\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x75"],
        ["\xCC\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x81"],
        ["\xCC\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8D"],
        ["\xCC\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x85"],
        ["\xCC\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6E"],
        ["\xCC\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6F"],
        ["\xCC\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x69"],
        ["\xCC\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6A"],
        ["\xCC\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x7B"],
        ["\xCC\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8B"],
        ["\xCC\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8C"],
        ["\xCC\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x54"],
        ["\xCC\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6B"],
        ["\xE2\x9D\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFE"],
        ["\xE2\x9D\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x41"],
        ["\xE2\x9D\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x42"],
        ["\xE2\x9D\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x43"],
        ["\xE2\x9D\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x44"],
        ["\xE2\x9D\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x45"],
        ["\xE2\x9D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x46"],
        ["\xE2\x9D\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x47"],
        ["\xE2\x9D\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x48"],
        ["\xE2\x9D\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x49"],
        ["\xE2\x93\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\xE2\x93\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\xE2\x93\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFD"],
        ["\xE2\x93\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFE"],
        ["\xE2\x93\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x41"],
        ["\xE2\x93\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x42"],
        ["\xE2\x93\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x43"],
        ["\xE2\x93\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x44"],
        ["\xE2\x93\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x45"],
        ["\xE2\x93\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x46"],
        ["\xE2\x85\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\x48"],
        ["\xE2\x85\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\x49"],
        ["\xE2\x93\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xE2\x93\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\xE2\x93\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xE2\x93\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xE2\x93\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xE2\x93\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xE2\x93\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xE2\x93\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xE2\x93\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xE2\x93\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xE2\x93\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\xE2\x93\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\xE2\x93\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\xE2\x93\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\xE2\x93\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\xE2\x93\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\xE2\x93\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xE2\x93\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xE2\x93\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xE2\x93\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xE2\x93\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xE2\x93\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xE2\x93\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xE2\x93\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xE2\x93\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xE2\x93\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xE3\x8B\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x80"],
        ["\xE3\x8B\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x81"],
        ["\xE3\x8B\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x82"],
        ["\xE3\x8B\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x83"],
        ["\xE3\x8B\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x84"],
        ["\xE3\x8B\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x85"],
        ["\xE3\x8B\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x86"],
        ["\xE3\x8B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x87"],
        ["\xE3\x8B\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x88"],
        ["\xE3\x8B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x89"],
        ["\xE3\x8B\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A"],
        ["\xE3\x8B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B"],
        ["\xE3\x8B\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C"],
        ["\xE3\x8B\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D"],
        ["\xE3\x8B\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E"],
        ["\xE3\x8B\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F"],
        ["\xE3\x8B\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x90"],
        ["\xE3\x8B\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x91"],
        ["\xE3\x8B\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x92"],
        ["\xE3\x8B\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x93"],
        ["\xE3\x8B\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\xE3\x8B\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x99"],
        ["\xE3\x8B\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x95"],
        ["\xE3\x8B\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D"],
        ["\xE3\x8B\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C"],
        ["\xE2\x81\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDD"],
        ["\xE2\x81\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD5"],
        ["\xE2\x85\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\x42"],
        ["\xE2\x85\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\x43"],
        ["\xE2\x9D\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\xE2\x98\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x7E"],
        ["\xE4\xBF\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x56"],
        ["\xF0\xA0\x80\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x42"],
        ["\xE3\x90\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x43"],
        ["\xE4\xB8\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x4B"],
        ["\xE4\xB8\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x4C"],
        ["\xE4\xBA\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x5C"],
        ["\xE4\xBB\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x6D"],
        ["\xE4\xBB\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x6F"],
        ["\xE4\xBC\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x72"],
        ["\xE4\xBD\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x8A"],
        ["\xE4\xBD\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x82"],
        ["\xE4\xBD\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x83"],
        ["\xE4\xBD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x89"],
        ["\xE4\xBD\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x8C"],
        ["\xE4\xBD\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x8D"],
        ["\xE4\xBD\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x95"],
        ["\xE4\xBE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x9F"],
        ["\xEF\xA8\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x54"],
        ["\xE4\xBF\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],
        ["\xE5\x80\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xBB"],
        ["\xE5\x80\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x57"],
        ["\xE5\x80\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],
        ["\xE5\x80\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC4"],
        ["\xE5\x80\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC8"],
        ["\xE5\x80\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC9"],
        ["\xE5\x80\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xCE"],
        ["\xE5\x81\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xCF"],
        ["\xE5\x83\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],
        ["\xE5\x83\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x4F"],
        ["\xE5\x83\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x42"],
        ["\xE5\x83\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x4A"],
        ["\xEF\xA8\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x63"],
        ["\xE5\x84\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x54"],
        ["\xE5\x84\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x53"],
        ["\xE5\x84\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x57"],
        ["\xE5\x84\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x61"],
        ["\xE5\x84\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x6B"],
        ["\xEF\xA8\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x69"],
        ["\xE5\x85\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x71"],
        ["\xE5\x85\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x72"],
        ["\xE3\x92\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x6C"],
        ["\xE5\x87\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x71"],
        ["\xE5\x87\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x72"],
        ["\xE5\x87\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x8B"],
        ["\xE5\x87\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x8C"],
        ["\xE5\x87\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x8E"],
        ["\xE5\x88\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x93"],
        ["\xE3\x93\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x74"],
        ["\xE5\x88\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x97"],
        ["\xE5\x89\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA1"],
        ["\xE5\x89\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA3"],
        ["\xE5\x89\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],
        ["\xE5\x8A\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],
        ["\xE5\x8B\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],
        ["\xEF\xA8\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x7B"],
        ["\xE5\x8B\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC7"],
        ["\xE5\x8B\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x7E"],
        ["\xE5\x8B\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xCB"],
        ["\xEF\xA8\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x7F"],
        ["\xE5\x8B\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],
        ["\xE5\x8B\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x81"],
        ["\xE5\x8C\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE0"],
        ["\xEF\xA8\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x83"],
        ["\xE5\x8D\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF5"],
        ["\xE5\x8D\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF6"],
        ["\xE5\x8D\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x87"],
        ["\xE5\x8E\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x44"],
        ["\xE5\x90\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x8F"],
        ["\xE5\x90\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x60"],
        ["\xE5\x91\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x6A"],
        ["\xE5\x91\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x72"],
        ["\xE5\x91\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x75"],
        ["\xE5\x91\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x76"],
        ["\xE5\x92\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x7A"],
        ["\xE5\x92\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x7F"],
        ["\xE5\x92\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x81"],
        ["\xE5\x93\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x8D"],
        ["\xE5\x94\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x9F"],
        ["\xE5\x94\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA2"],
        ["\xE5\x94\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA4"],
        ["\xE5\x95\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAE"],
        ["\xE5\x95\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB3"],
        ["\xE5\x96\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],
        ["\xE5\x96\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],
        ["\xEF\xA8\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x9E"],
        ["\xE5\x96\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],
        ["\xE5\x97\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCE"],
        ["\xEF\xA8\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],
        ["\xE5\x98\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xDB"],
        ["\xE5\x98\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],
        ["\xE5\x98\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xEA"],
        ["\xE5\x99\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],
        ["\xE5\x99\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAD"],
        ["\xE5\x99\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xFD"],
        ["\xEF\xA8\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAC"],
        ["\xE5\x99\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x42"],
        ["\xE5\x99\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x43"],
        ["\xE5\x99\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x44"],
        ["\xE5\x9A\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x4C"],
        ["\xE5\x9A\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x4F"],
        ["\xE5\x9A\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x54"],
        ["\xE5\x9A\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x56"],
        ["\xE5\x9A\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x59"],
        ["\xE5\x9B\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x5D"],
        ["\xE5\x9B\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x5E"],
        ["\xE5\x9C\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x76"],
        ["\xF0\xA1\x88\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB1"],
        ["\xE5\x9C\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],
        ["\xE5\x9C\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x86"],
        ["\xE5\x9C\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x87"],
        ["\xE5\x9C\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x88"],
        ["\xE5\x9D\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x98"],
        ["\xE5\x9D\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x9D"],
        ["\xE5\x9D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],
        ["\xE5\x9E\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAB"],
        ["\xF0\xA1\x8C\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],
        ["\xE5\x9E\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],
        ["\xE5\x9F\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB6"],
        ["\xE5\x9F\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBB"],
        ["\xE5\x9F\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBF"],
        ["\xE5\x9F\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC1"],
        ["\xE5\x9F\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],
        ["\xE5\x9F\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC6"],
        ["\xE5\xA0\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],
        ["\xE5\xA1\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xDE"],
        ["\xE5\xA1\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],
        ["\xEF\xA8\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],
        ["\xE5\xA1\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE3"],
        ["\xE5\xA2\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],
        ["\xEF\xA8\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC2"],
        ["\xE5\xA2\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF6"],
        ["\xF0\xA1\x91\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],
        ["\xE5\xA3\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x41"],
        ["\xE5\xA3\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],
        ["\xE5\xA3\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x42"],
        ["\xE5\xA3\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x44"],
        ["\xE5\xA3\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC7"],
        ["\xE5\xA3\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x48"],
        ["\xE5\xA4\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x4C"],
        ["\xE8\x99\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE3"],
        ["\xE5\xA5\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x63"],
        ["\xE5\xA6\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x6B"],
        ["\xE5\xA6\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x6E"],
        ["\xE5\xA7\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x7B"],
        ["\xE5\xA7\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x80"],
        ["\xE5\xA7\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x81"],
        ["\xE5\xA8\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x93"],
        ["\xE5\xA8\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x95"],
        ["\xE5\xA9\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],
        ["\xE5\xA9\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA7"],
        ["\xE5\xA9\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],
        ["\xE5\xA9\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xAB"],
        ["\xE5\xAA\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],
        ["\xE5\xAA\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB2"],
        ["\xE5\xAA\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB6"],
        ["\xE5\xAB\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC0"],
        ["\xF0\xA1\xA2\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD9"],
        ["\xE5\xAC\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD1"],
        ["\xE5\xAC\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],
        ["\xE5\x89\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x75"],
        ["\xF0\xA0\xAE\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x8D"],
        ["\xE5\xAD\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],
        ["\xE5\xAD\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],
        ["\xE5\xAE\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xEC"],
        ["\xE5\xB0\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE2"],
        ["\xE5\xB0\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x4A"],
        ["\xE5\xB0\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x4D"],
        ["\xE3\x9E\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],
        ["\xE5\xB1\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x57"],
        ["\xEF\xA8\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE7"],
        ["\xEF\xA8\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],
        ["\xF0\xA1\x9A\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],
        ["\xE5\xB1\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x60"],
        ["\xE5\xB2\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x67"],
        ["\xE5\xB2\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x6A"],
        ["\xE5\xB2\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x6D"],
        ["\xE5\xB2\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x6E"],
        ["\xE5\xB3\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x73"],
        ["\xE5\xB3\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF3"],
        ["\xE5\xB3\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x74"],
        ["\xE5\xB3\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x7A"],
        ["\xF0\xA1\xB8\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFA"],
        ["\xE3\x9F\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFB"],
        ["\xE5\xB4\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x7D"],
        ["\xE5\xB5\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x89"],
        ["\xE5\xB5\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFC"],
        ["\xE5\xB5\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x8B"],
        ["\xE5\xB6\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x9A"],
        ["\xE5\xB6\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA5"],
        ["\xE5\xB6\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x45"],
        ["\xE5\xB6\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA6"],
        ["\xE5\xB7\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAD"],
        ["\xE5\x90\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x90"],
        ["\xE5\xBD\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xCD"],
        ["\xE5\x99\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],
        ["\xE5\xB7\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x4A"],
        ["\xE5\xB8\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBA"],
        ["\xE5\xB8\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBC"],
        ["\xE5\xB9\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],
        ["\xE5\xB9\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xCC"],
        ["\xE5\xBA\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],
        ["\xEF\xA4\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x54"],
        ["\xE5\xBB\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],
        ["\xE5\xBB\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x57"],
        ["\xE5\xBC\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x59"],
        ["\xE5\xBC\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xEE"],
        ["\xE5\xBC\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF0"],
        ["\xE5\xBC\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF5"],
        ["\xE5\xBC\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],
        ["\xE5\xBC\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],
        ["\xE5\xBC\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x42"],
        ["\xE5\xBD\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x44"],
        ["\xE5\xBD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x49"],
        ["\xE5\xBD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x4A"],
        ["\xE5\xBD\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x4E"],
        ["\xE5\xBD\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x55"],
        ["\xE5\xBE\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x57"],
        ["\xE5\xBE\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x5B"],
        ["\xE5\xBE\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x5F"],
        ["\xE5\xBE\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x62"],
        ["\xE5\xBE\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x5C"],
        ["\xE5\xBF\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x69"],
        ["\xE5\xBF\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x70"],
        ["\xE5\xBF\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x73"],
        ["\xE6\x80\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x80"],
        ["\xE6\x80\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x82"],
        ["\xE6\x80\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x84"],
        ["\xE6\x80\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x89"],
        ["\xE6\x80\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x8A"],
        ["\xE6\x81\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x8C"],
        ["\xEF\xA8\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x61"],
        ["\xE6\x82\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA1"],
        ["\xE6\x82\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA2"],
        ["\xE6\x83\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB1"],
        ["\xE6\x83\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB4"],
        ["\xE6\x83\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],
        ["\xE6\x83\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xBB"],
        ["\xE6\x84\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC9"],
        ["\xE6\x84\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],
        ["\xEF\xA8\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x66"],
        ["\xE6\x86\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE3"],
        ["\xEF\xA8\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x67"],
        ["\xE6\x86\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],
        ["\xE6\x86\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],
        ["\xEF\xA9\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x6A"],
        ["\xE6\x88\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x4D"],
        ["\xE6\x88\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x6D"],
        ["\xE6\x89\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x55"],
        ["\xE6\x89\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x5D"],
        ["\xE6\x89\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x5E"],
        ["\xE6\x89\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x62"],
        ["\xE6\x8A\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x70"],
        ["\xE6\x8B\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x71"],
        ["\xE6\x8B\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x74"],
        ["\xE6\x8B\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x79"],
        ["\xE6\x8C\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x7D"],
        ["\xE6\x8C\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x83"],
        ["\xE6\x8C\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x89"],
        ["\xE6\x8D\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x8D"],
        ["\xE6\x8D\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x98"],
        ["\xE6\x8D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA0"],
        ["\xE6\x8F\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBD"],
        ["\xE6\x8F\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x7B"],
        ["\xE6\x90\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC6"],
        ["\xE6\x90\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC8"],
        ["\xE6\x90\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],
        ["\xE6\x91\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x7F"],
        ["\xE6\x91\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD8"],
        ["\xE6\x91\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE3"],
        ["\xE6\x92\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],
        ["\xE6\x92\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF9"],
        ["\xE6\x93\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],
        ["\xE6\x93\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xFC"],
        ["\xE6\x93\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x41"],
        ["\xE6\x93\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x4C"],
        ["\xE6\x93\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x4D"],
        ["\xE6\x94\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x5C"],
        ["\xE6\x94\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x5E"],
        ["\xEF\xA9\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x85"],
        ["\xE6\x95\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x6C"],
        ["\xE6\x96\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x76"],
        ["\xEF\xA9\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x89"],
        ["\xE6\x98\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x8D"],
        ["\xE6\x98\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x97"],
        ["\xE6\x98\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x9C"],
        ["\xE6\x98\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x9E"],
        ["\xE6\x98\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x9F"],
        ["\xE6\x99\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x8E"],
        ["\xE6\x99\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA6"],
        ["\xF0\xA3\x87\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x94"],
        ["\xE6\x99\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x90"],
        ["\xE6\x99\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAD"],
        ["\xE6\x99\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],
        ["\xE6\x99\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],
        ["\xE6\x9A\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBC"],
        ["\xEF\xA9\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x97"],
        ["\xE6\x9A\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC7"],
        ["\xE6\x9B\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x9B"],
        ["\xE6\x9B\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xCB"],
        ["\xE3\xAC\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x9C"],
        ["\xE6\x9B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD0"],
        ["\xE6\x9B\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],
        ["\xE6\x9C\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD8"],
        ["\xE6\x9C\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],
        ["\xE6\x9D\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE0"],
        ["\xE6\x9D\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE1"],
        ["\xE6\x9D\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],
        ["\xE6\x9E\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],
        ["\xE6\x9E\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],
        ["\xE6\x9E\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],
        ["\xE6\x9E\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],
        ["\xE6\x9F\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x4C"],
        ["\xE6\x9F\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x43"],
        ["\xE6\x9F\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],
        ["\xE6\xA0\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x4F"],
        ["\xE6\xA0\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x53"],
        ["\xE6\xA0\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x57"],
        ["\xE6\xA1\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x61"],
        ["\xE6\xA1\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x67"],
        ["\xE6\xA1\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x68"],
        ["\xEF\xA9\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],
        ["\xE6\xA2\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x76"],
        ["\xE6\xA2\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x77"],
        ["\xE6\xA2\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x7B"],
        ["\xE6\xA3\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x7F"],
        ["\xE6\xA3\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x87"],
        ["\xE6\xA3\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x8B"],
        ["\xE6\xA3\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x8C"],
        ["\xE6\xA3\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x8D"],
        ["\xE6\xA3\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x91"],
        ["\xE6\xA4\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x95"],
        ["\xE6\xA5\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],
        ["\xF0\xA3\x97\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCB"],
        ["\xE6\xA4\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x9D"],
        ["\xE6\xA5\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA0"],
        ["\xE6\xA5\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA4"],
        ["\xE6\xA5\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA6"],
        ["\xE6\xA5\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],
        ["\xE6\xA6\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],
        ["\xE6\xA6\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],
        ["\xE6\xA6\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBB"],
        ["\xE6\xA7\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC9"],
        ["\xE3\xAE\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCA"],
        ["\xE3\xAF\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],
        ["\xE6\xA7\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCD"],
        ["\xE6\xA7\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCE"],
        ["\xE6\xA7\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],
        ["\xE6\xA7\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],
        ["\xE6\xA8\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],
        ["\xE6\xA8\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],
        ["\xF0\xA3\x9C\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDE"],
        ["\xE6\xA8\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],
        ["\xE6\xA8\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDC"],
        ["\xE6\xA9\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDE"],
        ["\xE6\xA9\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],
        ["\xE6\xA9\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],
        ["\xE6\xA9\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],
        ["\xF0\xA3\x9D\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDF"],
        ["\xE6\xAA\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],
        ["\xE6\xAA\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDA"],
        ["\xE6\xAA\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],
        ["\xE6\xAA\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],
        ["\xE6\xAA\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],
        ["\xE6\xAB\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x4C"],
        ["\xE3\xB0\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],
        ["\xEF\xA4\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE4"],
        ["\xE6\xAC\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x5C"],
        ["\xE6\xAC\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x5D"],
        ["\xE6\xAC\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x61"],
        ["\xE6\xAC\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x63"],
        ["\xE6\xAD\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x67"],
        ["\xE6\xAD\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x6B"],
        ["\xE6\xAD\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x6E"],
        ["\xE6\xAD\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEA"],
        ["\xE6\xAD\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x6F"],
        ["\xE6\xAD\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],
        ["\xE6\xAE\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x76"],
        ["\xE6\xAE\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x7F"],
        ["\xE6\xAE\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x81"],
        ["\xEF\xA5\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],
        ["\xE6\xAF\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],
        ["\xE6\xAF\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF4"],
        ["\xE6\xAF\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x95"],
        ["\xE6\xB0\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x98"],
        ["\xE6\xB0\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x9C"],
        ["\xE6\xB0\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA5"],
        ["\xE6\xB1\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\xE6\xB2\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],
        ["\xE6\xB1\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB5"],
        ["\xE6\xB1\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\xE6\xB2\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],
        ["\xE6\xB2\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],
        ["\xE6\xB2\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],
        ["\xE6\xB3\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFD"],
        ["\xE6\xB3\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],
        ["\xE6\xB3\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCD"],
        ["\xE6\xB3\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],
        ["\xE6\xB3\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],
        ["\xE6\xB3\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],
        ["\xF0\xA3\xB3\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x43"],
        ["\xE6\xB4\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xDA"],
        ["\xE6\xB4\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],
        ["\xE6\xB4\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],
        ["\xE6\xB4\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],
        ["\xE6\xB4\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],
        ["\xE6\xB5\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x46"],
        ["\xE6\xB5\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xEC"],
        ["\xEF\xA9\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x49"],
        ["\xE6\xB6\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],
        ["\xE6\xB6\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x4C"],
        ["\xE6\xB6\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],
        ["\xE6\xB6\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],
        ["\xE6\xB6\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],
        ["\xE6\xB7\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],
        ["\xE6\xB7\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x42"],
        ["\xE6\xB7\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x54"],
        ["\xE6\xB7\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x43"],
        ["\xE6\xB7\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x44"],
        ["\xEF\xA9\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x59"],
        ["\xE6\xB8\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x5B"],
        ["\xE6\xB9\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x55"],
        ["\xE6\xB9\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x61"],
        ["\xE6\xBA\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x5E"],
        ["\xE6\xBA\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x6F"],
        ["\xE6\xBB\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x73"],
        ["\xE6\xBB\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x75"],
        ["\xE6\xBB\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x79"],
        ["\xE6\xBC\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x61"],
        ["\xE6\xBC\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x88"],
        ["\xEF\xA9\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x62"],
        ["\xE6\xBC\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x8C"],
        ["\xE6\xBC\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x8E"],
        ["\xE6\xBC\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x90"],
        ["\xE6\xBD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x95"],
        ["\xE6\xBD\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x99"],
        ["\xE6\xBD\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x9C"],
        ["\xE6\xBD\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x9D"],
        ["\xE6\xBD\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x9E"],
        ["\xE6\xBD\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],
        ["\xE6\xBE\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],
        ["\xE6\xBE\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],
        ["\xE6\xBE\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],
        ["\xE6\xBE\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],
        ["\xE6\xBE\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],
        ["\xE6\xBE\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\xE6\xBE\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],
        ["\xE6\xBF\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\xE6\xBF\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],
        ["\xE6\xBF\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],
        ["\xE6\xBF\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],
        ["\xE7\x80\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],
        ["\xE7\x81\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],
        ["\xE7\x81\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],
        ["\xE7\x81\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDA"],
        ["\xE7\x81\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],
        ["\xE7\x81\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDB"],
        ["\xE7\x81\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDF"],
        ["\xE7\x82\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xEA"],
        ["\xE7\x82\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],
        ["\xE7\x83\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],
        ["\xE7\x83\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],
        ["\xE7\x83\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],
        ["\xE7\x84\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x43"],
        ["\xE7\x84\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x41"],
        ["\xE7\x84\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x42"],
        ["\xE7\x84\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x78"],
        ["\xE7\x84\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x46"],
        ["\xE7\x85\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x79"],
        ["\xEF\xA9\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x7C"],
        ["\xE7\x85\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x4E"],
        ["\xE7\x85\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x52"],
        ["\xE7\x85\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x53"],
        ["\xE7\x86\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x56"],
        ["\xE7\x86\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x57"],
        ["\xE7\x86\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x59"],
        ["\xE7\x86\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x62"],
        ["\xE7\x87\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x65"],
        ["\xE7\x88\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x6E"],
        ["\xE7\x88\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x81"],
        ["\xE7\x89\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x85"],
        ["\xE7\x89\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x86"],
        ["\xE3\xB8\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x85"],
        ["\xE7\x8A\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x98"],
        ["\xE7\x8A\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x9B"],
        ["\xE7\x8B\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x88"],
        ["\xE7\x8B\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xAC"],
        ["\xF0\xA4\x9F\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x8E"],
        ["\xE7\x8C\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],
        ["\xE7\x8C\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],
        ["\xE7\x8D\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],
        ["\xE7\x8D\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"],
        ["\xE7\x8D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],
        ["\xE7\x8E\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xDF"],
        ["\xE7\x8E\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],
        ["\xE7\x8E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],
        ["\xE7\x8E\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],
        ["\xE7\x8E\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],
        ["\xE7\x8E\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xEA"],
        ["\xE7\x8F\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],
        ["\xE7\x8F\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],
        ["\xE7\x8F\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],
        ["\xE7\x90\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x49"],
        ["\xE7\x90\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x4B"],
        ["\xE7\x90\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x4C"],
        ["\xEF\xA9\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x96"],
        ["\xE7\x90\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x4E"],
        ["\xE7\x90\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x4F"],
        ["\xE7\x90\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x50"],
        ["\xE7\x90\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x52"],
        ["\xE7\x90\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x53"],
        ["\xE7\x91\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x58"],
        ["\xE7\x91\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x59"],
        ["\xE7\x91\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x5A"],
        ["\xE7\x91\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x5B"],
        ["\xE7\x91\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x5F"],
        ["\xE7\x91\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x64"],
        ["\xE7\x91\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x65"],
        ["\xE7\x92\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x6C"],
        ["\xE7\x92\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x6D"],
        ["\xE7\x92\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x72"],
        ["\xE7\x92\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x75"],
        ["\xE7\x92\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x78"],
        ["\xE7\x92\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x6F"],
        ["\xE7\x92\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x79"],
        ["\xE7\x92\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x7A"],
        ["\xE7\x92\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x7B"],
        ["\xE7\x92\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x82"],
        ["\xE7\x92\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x85"],
        ["\xE7\x93\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x86"],
        ["\xE7\x93\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x87"],
        ["\xE7\x93\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x8C"],
        ["\xE7\x93\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x99"],
        ["\xE7\x94\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x9D"],
        ["\xE7\x95\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB5"],
        ["\xE7\x96\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],
        ["\xE3\xBD\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],
        ["\xE7\x97\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCD"],
        ["\xE7\x97\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],
        ["\xE7\x98\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],
        ["\xE7\x98\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDC"],
        ["\xE7\x98\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],
        ["\xE7\x98\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],
        ["\xE7\x98\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],
        ["\xE7\x98\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],
        ["\xE7\x98\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xEC"],
        ["\xE7\x98\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],
        ["\xE7\x98\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],
        ["\xE7\x99\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],
        ["\xE7\x99\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x42"],
        ["\xE7\x99\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x46"],
        ["\xE7\x99\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x47"],
        ["\xE7\x99\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x48"],
        ["\xE7\x99\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x4A"],
        ["\xE7\x99\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x4B"],
        ["\xE7\x9A\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x4D"],
        ["\xE7\x9A\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x52"],
        ["\xE7\x9A\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x5B"],
        ["\xE7\x9A\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB8"],
        ["\xE7\x9B\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x5F"],
        ["\xE7\x9B\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x62"],
        ["\xE7\x9B\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x63"],
        ["\xE7\x9B\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x64"],
        ["\xE7\x9B\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x67"],
        ["\xE7\x9B\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x6B"],
        ["\xE7\x9B\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x6E"],
        ["\xE7\x9C\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x71"],
        ["\xE7\x9C\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x77"],
        ["\xE7\x9C\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x7F"],
        ["\xE7\x9C\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x81"],
        ["\xE7\x9D\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x88"],
        ["\xE7\x9D\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x89"],
        ["\xE7\x9D\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x8E"],
        ["\xE7\x9D\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x90"],
        ["\xE7\x9D\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x92"],
        ["\xE7\x9D\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x9B"],
        ["\xE7\x9E\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x9D"],
        ["\xE7\x9E\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],
        ["\xE7\x9E\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA8"],
        ["\xE7\x9F\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB6"],
        ["\xE7\xA0\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],
        ["\xF0\xA5\x92\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCD"],
        ["\xE7\xA1\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xCE"],
        ["\xE7\xA1\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCB"],
        ["\xE7\xA1\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],
        ["\xE7\xA1\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],
        ["\xE7\xA1\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],
        ["\xEF\xA9\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],
        ["\xE7\xA2\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],
        ["\xF0\xA5\x94\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD0"],
        ["\xE7\xA2\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],
        ["\xE7\xA3\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xFD"],
        ["\xE7\xA3\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x42"],
        ["\xE7\xA4\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x49"],
        ["\xE7\xA3\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x45"],
        ["\xE7\xA4\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x4E"],
        ["\xE7\xA4\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD5"],
        ["\xE7\xA4\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x56"],
        ["\xE7\xA4\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x57"],
        ["\xEF\xA9\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD6"],
        ["\xEF\xA9\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],
        ["\xE7\xA5\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x5D"],
        ["\xE7\xA5\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x5E"],
        ["\xEF\xA9\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD7"],
        ["\xEF\xA9\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],
        ["\xEF\xA9\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],
        ["\xE7\xA5\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x66"],
        ["\xEF\xA9\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDB"],
        ["\xE7\xA5\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x6B"],
        ["\xEF\xA9\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDD"],
        ["\xEF\xA9\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDE"],
        ["\xE7\xA6\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x75"],
        ["\xE7\xA6\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x7C"],
        ["\xE7\xA6\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x7E"],
        ["\xE7\xA7\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x83"],
        ["\xE7\xA7\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x84"],
        ["\xF0\xA5\x9D\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],
        ["\xE7\xA7\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x86"],
        ["\xE7\xA7\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x8A"],
        ["\xE7\xA7\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x8F"],
        ["\xE7\xA7\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x90"],
        ["\xE7\xA8\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x95"],
        ["\xEF\xA9\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE7"],
        ["\xE7\xA8\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA7"],
        ["\xE7\xA9\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],
        ["\xE7\xA9\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],
        ["\xEF\xA9\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],
        ["\xE7\xAA\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBE"],
        ["\xE7\xAA\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],
        ["\xF0\xA5\xA7\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],
        ["\xE7\xAA\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],
        ["\xE7\xAA\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCC"],
        ["\xE7\xAB\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],
        ["\xE7\xAB\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],
        ["\xE7\xAC\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF1"],
        ["\xE7\xAC\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],
        ["\xE7\xAC\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF3"],
        ["\xE7\xAD\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xED"],
        ["\xE7\xAD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],
        ["\xE7\xAD\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],
        ["\xE7\xAD\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],
        ["\xE7\xAD\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],
        ["\xE7\xAD\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],
        ["\xEF\xA9\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],
        ["\xE7\xAF\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x55"],
        ["\xE7\xAF\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x56"],
        ["\xE7\xB0\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x63"],
        ["\xE7\xB0\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x74"],
        ["\xE7\xB0\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x41"],
        ["\xE7\xB0\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x6F"],
        ["\xE7\xB0\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x75"],
        ["\xE7\xB0\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x77"],
        ["\xE4\x89\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x42"],
        ["\xF0\xA5\xB6\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x44"],
        ["\xE7\xB1\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x80"],
        ["\xE7\xB1\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x8A"],
        ["\xE7\xB1\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x8E"],
        ["\xE7\xB2\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x93"],
        ["\xE7\xB2\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x94"],
        ["\xE7\xB2\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x96"],
        ["\xE7\xB2\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x9D"],
        ["\xE7\xB3\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA7"],
        ["\xE7\xB3\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],
        ["\xE7\xB3\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],
        ["\xE7\xB4\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB1"],
        ["\xE7\xB4\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB2"],
        ["\xE7\xB4\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],
        ["\xE7\xB4\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],
        ["\xE7\xB4\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],
        ["\xE7\xB4\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBF"],
        ["\xE7\xB5\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],
        ["\xE7\xB5\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],
        ["\xE7\xB5\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],
        ["\xE7\xB6\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],
        ["\xE7\xB6\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDB"],
        ["\xE7\xB6\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],
        ["\xE7\xB7\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],
        ["\xE7\xB7\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xEE"],
        ["\xE7\xB7\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x5A"],
        ["\xEF\xA9\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x5B"],
        ["\xE7\xB8\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x4A"],
        ["\xE7\xB8\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x41"],
        ["\xE7\xB8\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x43"],
        ["\xE7\xB8\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x44"],
        ["\xEF\xA9\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x5F"],
        ["\xE7\xB9\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x53"],
        ["\xE7\xB9\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x58"],
        ["\xE7\xBA\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x64"],
        ["\xEF\xA9\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x65"],
        ["\xE7\xBE\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x87"],
        ["\xE7\xBE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x89"],
        ["\xE7\xBE\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x91"],
        ["\xE7\xBF\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x95"],
        ["\xE7\xBF\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x97"],
        ["\xE7\xBF\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x98"],
        ["\xE7\xBF\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x9C"],
        ["\xE7\xBF\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x9D"],
        ["\xE7\xBF\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA0"],
        ["\xEF\xA9\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x6A"],
        ["\xE8\x80\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],
        ["\xE8\x80\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],
        ["\xE8\x80\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB8"],
        ["\xE8\x80\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],
        ["\xE8\x80\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xBC"],
        ["\xE8\x83\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x70"],
        ["\xE8\x83\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],
        ["\xE8\x83\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],
        ["\xE8\x83\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xDD"],
        ["\xE8\x84\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],
        ["\xE8\x85\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],
        ["\xE8\x85\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],
        ["\xE8\x85\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],
        ["\xE8\x85\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xFA"],
        ["\xE8\x85\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xFC"],
        ["\xE8\x86\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x50"],
        ["\xE8\x87\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x53"],
        ["\xE8\x87\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x56"],
        ["\xE8\x87\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x58"],
        ["\xEF\xA9\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x83"],
        ["\xE4\x91\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x84"],
        ["\xE4\x91\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x88"],
        ["\xE8\x89\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x81"],
        ["\xE8\x89\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x85"],
        ["\xF0\xA6\xAB\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x97"],
        ["\xE8\x8A\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x90"],
        ["\xE8\x8A\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x98"],
        ["\xE8\x8A\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x99"],
        ["\xE8\x8A\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x9A"],
        ["\xE8\x8A\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x9D"],
        ["\xE8\x8A\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x9F"],
        ["\xE8\x8A\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA3"],
        ["\xE8\x8A\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],
        ["\xE8\x8A\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA7"],
        ["\xE8\x8B\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],
        ["\xE8\x8B\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],
        ["\xE8\x8B\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],
        ["\xE8\x8B\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB6"],
        ["\xE8\x8C\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],
        ["\xE8\x8C\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC1"],
        ["\xE8\x8C\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],
        ["\xE8\x8C\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC8"],
        ["\xE8\x8D\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCC"],
        ["\xE8\x8D\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],
        ["\xE8\x8D\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD1"],
        ["\xE8\x8D\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD4"],
        ["\xE8\x8D\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD9"],
        ["\xE8\x8E\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],
        ["\xE8\x8E\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],
        ["\xE8\x8E\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE2"],
        ["\xE8\x8E\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE8"],
        ["\xE8\x8E\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE9"],
        ["\xE8\x8E\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xED"],
        ["\xE8\x8F\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],
        ["\xE8\x8F\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF0"],
        ["\xE8\x8F\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF2"],
        ["\xE8\x8F\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x9F"],
        ["\xE8\x8F\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF6"],
        ["\xE8\x90\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFA"],
        ["\xE8\x90\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFB"],
        ["\xE8\x90\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFC"],
        ["\xEF\xA9\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA3"],
        ["\xE8\x91\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],
        ["\xE8\x91\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x56"],
        ["\xE8\x91\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x57"],
        ["\xE8\x92\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x5E"],
        ["\xE8\x92\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x62"],
        ["\xE8\x92\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x67"],
        ["\xE8\x92\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x69"],
        ["\xE8\x93\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x6C"],
        ["\xE8\x93\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x6D"],
        ["\xF0\xA6\xB9\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAB"],
        ["\xE8\x94\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x8D"],
        ["\xE8\x94\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x84"],
        ["\xE8\x94\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x86"],
        ["\xE8\x94\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x8C"],
        ["\xE8\x95\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x9F"],
        ["\xE8\x96\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],
        ["\xE8\x95\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA2"],
        ["\xE8\x96\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAB"],
        ["\xE8\x96\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAC"],
        ["\xE8\x96\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB2"],
        ["\xE8\x97\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC1"],
        ["\xE8\x97\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC2"],
        ["\xE8\x97\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC9"],
        ["\xE8\x98\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD5"],
        ["\xE8\x97\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCD"],
        ["\xE8\x98\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCF"],
        ["\xE8\x98\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD0"],
        ["\xE8\x98\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],
        ["\xF0\xA7\x83\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB7"],
        ["\xE8\x98\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD6"],
        ["\xE8\x98\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDC"],
        ["\xE8\x98\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDE"],
        ["\xE8\x99\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE9"],
        ["\xE8\x99\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],
        ["\xEF\xA4\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],
        ["\xE8\x99\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xEF"],
        ["\xE4\x96\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],
        ["\xE8\x99\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF3"],
        ["\xE8\x99\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF5"],
        ["\xE8\x9A\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xFD"],
        ["\xE8\x9A\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x4C"],
        ["\xE8\x9B\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x5D"],
        ["\xE8\x9B\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x5E"],
        ["\xE8\x9B\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x5F"],
        ["\xE8\x9C\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x63"],
        ["\xE8\x9D\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x82"],
        ["\xE8\x9E\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x89"],
        ["\xE8\x9E\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x8A"],
        ["\xE8\x9E\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x98"],
        ["\xE8\x9E\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x99"],
        ["\xE8\x9E\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x9C"],
        ["\xE4\x97\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCA"],
        ["\xE8\x9F\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],
        ["\xE8\x9F\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCE"],
        ["\xE8\xA0\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],
        ["\xE8\xA0\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],
        ["\xE8\xA0\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],
        ["\xE8\xA0\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBE"],
        ["\xE8\xA0\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC5"],
        ["\xE8\xA2\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE4"],
        ["\xE8\xA2\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xEB"],
        ["\xE8\xA3\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF0"],
        ["\xE8\xA3\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF4"],
        ["\xF0\xA7\x9A\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],
        ["\xEF\xA9\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],
        ["\xE8\xA4\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x48"],
        ["\xE8\xA4\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x49"],
        ["\xE8\xA4\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x4A"],
        ["\xE8\xA4\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x4D"],
        ["\xE8\xA4\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x4F"],
        ["\xE8\xA4\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x51"],
        ["\xE8\xA4\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x53"],
        ["\xE8\xA5\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x56"],
        ["\xE8\xA6\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x70"],
        ["\xEF\xA9\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],
        ["\xE8\xA7\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x7D"],
        ["\xE8\xA7\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x82"],
        ["\xE8\xA7\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x88"],
        ["\xE8\xA8\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x92"],
        ["\xE8\xA8\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x95"],
        ["\xE8\xA9\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],
        ["\xE8\xA9\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA4"],
        ["\xE8\xA9\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],
        ["\xE8\xA9\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAB"],
        ["\xE8\xA9\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAE"],
        ["\xE8\xAB\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],
        ["\xE8\xAB\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],
        ["\xEF\xA9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],
        ["\xEF\xA9\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],
        ["\xE8\xAD\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE8"],
        ["\xE8\xAD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],
        ["\xE8\xAD\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xED"],
        ["\xE8\xAD\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],
        ["\xE8\xAE\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],
        ["\xE8\xB1\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x49"],
        ["\xE8\xB1\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x57"],
        ["\xEF\xA9\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],
        ["\xE8\xB3\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x74"],
        ["\xE8\xB3\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x7B"],
        ["\xE8\xB3\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x7C"],
        ["\xEF\xA9\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF6"],
        ["\xE8\xB4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x82"],
        ["\xE8\xB6\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x95"],
        ["\xE8\xB7\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA2"],
        ["\xE8\xB7\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\xE8\xB7\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\xE8\xB8\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],
        ["\xE8\xB8\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\xE8\xB8\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC5"],
        ["\xE8\xB9\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],
        ["\xE8\xB9\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],
        ["\xF0\xA8\x89\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x43"],
        ["\xE8\xBB\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xEF"],
        ["\xE4\xA1\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x45"],
        ["\xE8\xBB\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],
        ["\xE8\xBC\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\x4A"],
        ["\xE8\xBC\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\x52"],
        ["\xE8\xBC\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\x56"],
        ["\xE8\xBD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\x61"],
        ["\xF0\xA8\x8F\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x4A"],
        ["\xE8\xBE\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\x6C"],
        ["\xE8\xBE\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\x6D"],
        ["\xE8\xBF\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\x7D"],
        ["\xE8\xBF\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\x7E"],
        ["\xE8\xBF\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\x7F"],
        ["\xE9\x80\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\x87"],
        ["\xE9\x80\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\x8F"],
        ["\xEF\xA9\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x4F"],
        ["\xE9\x82\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],
        ["\xE9\x82\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],
        ["\xE9\x82\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],
        ["\xE9\x82\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA9"],
        ["\xE9\x82\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xAA"],
        ["\xE9\x82\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xAD"],
        ["\xE9\x82\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB1"],
        ["\xE9\x82\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],
        ["\xE9\x83\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB7"],
        ["\xE9\x83\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],
        ["\xE9\x83\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],
        ["\xE9\x83\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],
        ["\xE9\x83\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],
        ["\xE9\x83\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC6"],
        ["\xE9\x83\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],
        ["\xE9\x84\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xD3"],
        ["\xE9\x84\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xD4"],
        ["\xE9\x84\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xDB"],
        ["\xE9\x84\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xDC"],
        ["\xE9\x84\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xE0"],
        ["\xE9\x84\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xE1"],
        ["\xE9\x84\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xE2"],
        ["\xE9\x84\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xE8"],
        ["\xE9\x85\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xEB"],
        ["\xE9\x85\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xF1"],
        ["\xE9\x86\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xFB"],
        ["\xE9\x86\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\x47"],
        ["\xE9\x86\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\x4B"],
        ["\xE9\x86\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\x4F"],
        ["\xE9\x86\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\x54"],
        ["\xE9\x87\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\x65"],
        ["\xE9\x87\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\x62"],
        ["\xE9\x88\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\x6B"],
        ["\xE9\x88\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\x7F"],
        ["\xE9\x89\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\x82"],
        ["\xE9\x89\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\x87"],
        ["\xE9\x8B\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],
        ["\xE9\x8B\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],
        ["\xE9\x8B\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],
        ["\xE9\x8C\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x63"],
        ["\xE9\x8C\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xCE"],
        ["\xE9\x8D\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],
        ["\xE9\x8D\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x66"],
        ["\xE9\x8D\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE0"],
        ["\xE9\x8D\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE1"],
        ["\xE9\x8D\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE4"],
        ["\xE9\x8E\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],
        ["\xE9\x8E\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xFC"],
        ["\xE9\x8E\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x46"],
        ["\xE9\x8F\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x53"],
        ["\xE9\x90\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x5E"],
        ["\xE9\x8F\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x5B"],
        ["\xE9\x90\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x6B"],
        ["\xE9\x91\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x71"],
        ["\xE9\x91\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x78"],
        ["\xE9\x91\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x7A"],
        ["\xE9\x91\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x7E"],
        ["\xE9\x91\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x7F"],
        ["\xE9\x96\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x89"],
        ["\xE9\x96\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x8C"],
        ["\xE9\x96\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x8E"],
        ["\xE9\x96\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x8F"],
        ["\xE9\x96\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x91"],
        ["\xE9\x96\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x93"],
        ["\xE9\x96\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x95"],
        ["\xE9\x97\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x9A"],
        ["\xE9\x97\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x9B"],
        ["\xE9\x97\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x9E"],
        ["\xE4\xA6\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x75"],
        ["\xE9\x97\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA0"],
        ["\xE9\x97\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA2"],
        ["\xE9\x99\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],
        ["\xE9\x9A\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],
        ["\xE9\x9A\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xCC"],
        ["\xE9\x9A\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xCD"],
        ["\xE9\x9B\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],
        ["\xE9\x9B\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],
        ["\xEF\xA9\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x82"],
        ["\xE9\x9B\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xDA"],
        ["\xE9\x9B\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],
        ["\xE9\x9D\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xEC"],
        ["\xE9\x9D\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],
        ["\xE9\x9D\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],
        ["\xE9\x9D\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],
        ["\xE9\x9E\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],
        ["\xE9\x9E\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x49"],
        ["\xE9\x9E\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x50"],
        ["\xE9\x9F\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x54"],
        ["\xE9\x9F\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x58"],
        ["\xE9\x9F\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x65"],
        ["\xE9\x9F\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x63"],
        ["\xE9\x9F\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x6B"],
        ["\xEF\xA9\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x89"],
        ["\xE9\xA0\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x70"],
        ["\xE9\xA0\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x77"],
        ["\xE9\xA0\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x7C"],
        ["\xE9\xA0\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x7F"],
        ["\xEF\xA9\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x8D"],
        ["\xE9\xA1\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x88"],
        ["\xE9\xA1\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x89"],
        ["\xE9\xA1\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x8A"],
        ["\xE9\xA1\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x8B"],
        ["\xE9\xA1\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x8C"],
        ["\xEF\xA7\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x8E"],
        ["\xE9\xA1\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x91"],
        ["\xE9\xA2\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x99"],
        ["\xE9\xA3\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x9E"],
        ["\xE9\xA3\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],
        ["\xE9\xA5\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],
        ["\xE9\xA8\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xEC"],
        ["\xE9\xA8\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],
        ["\xE9\xA8\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],
        ["\xE9\xA8\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xFA"],
        ["\xE9\xA8\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xFB"],
        ["\xE9\xA8\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x41"],
        ["\xE9\xA9\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x45"],
        ["\xE9\xA9\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA1"],
        ["\xE9\xAA\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x53"],
        ["\xE9\xAB\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x58"],
        ["\xE9\xAB\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x59"],
        ["\xE9\xAB\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x5C"],
        ["\xE9\xAB\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x60"],
        ["\xE9\xAB\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x6C"],
        ["\xE9\xAC\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x72"],
        ["\xE9\xAC\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x76"],
        ["\xE9\xAC\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x82"],
        ["\xE4\xB0\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA9"],
        ["\xE9\xAC\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x85"],
        ["\xE9\xAD\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x94"],
        ["\xE9\xAD\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA2"],
        ["\xE9\xAD\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x98"],
        ["\xE9\xAE\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA5"],
        ["\xE9\xAE\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],
        ["\xE9\xAE\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB1"],
        ["\xE9\xAE\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB3"],
        ["\xE9\xAF\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBD"],
        ["\xE9\xAF\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],
        ["\xE9\xAF\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],
        ["\xE9\xAF\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],
        ["\xE9\xAF\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],
        ["\xE9\xB0\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDD"],
        ["\xE9\xB1\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],
        ["\xE9\xB1\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xEF"],
        ["\xE9\xB1\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],
        ["\xE9\xB1\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],
        ["\xE9\xB1\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xFA"],
        ["\xE9\xB1\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],
        ["\xE9\xB1\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x45"],
        ["\xE9\xB4\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x51"],
        ["\xE9\xB4\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x52"],
        ["\xE9\xB5\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x5C"],
        ["\xE9\xB5\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x5E"],
        ["\xE9\xB5\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBE"],
        ["\xE9\xB5\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x64"],
        ["\xE9\xB5\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x6B"],
        ["\xE9\xB6\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x70"],
        ["\xE9\xB6\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x76"],
        ["\xE9\xB7\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],
        ["\xE9\xB6\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x7B"],
        ["\xE9\xB6\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x80"],
        ["\xE9\xB7\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x89"],
        ["\xF0\xAA\x86\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC6"],
        ["\xE9\xB7\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x8F"],
        ["\xE9\xB8\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x98"],
        ["\xE9\xB8\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x9E"],
        ["\xE9\xB9\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],
        ["\xE9\xBA\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],
        ["\xE9\xBA\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB1"],
        ["\xE9\xBA\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],
        ["\xE9\xBA\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB5"],
        ["\xE9\xBA\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],
        ["\xE9\xBA\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB9"],
        ["\xE9\xBB\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],
        ["\xE9\xBC\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCE"],
        ["\xE9\xBC\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],
        ["\xE9\xBD\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],
        ["\xE9\xBE\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\x42"],
        ["\xE9\xBE\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\x45"],
        ["\xE9\xBE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\x47"],
        ["\xE9\xBE\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\x4A"],
        ["\xE5\xA7\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],
        ["\xE5\xB1\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE5"],
        ["\xE5\xB9\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x51"],
        ["\xE7\x98\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xEF"],
        ["\xE7\xB9\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x5B"],
        ["\xF0\xA0\x82\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x46"],
        ["\xE4\xB8\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x41"],
        ["\xE4\xB8\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x41"],
        ["\xE4\xB8\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x45"],
        ["\xE4\xB8\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x44"],
        ["\xE4\xB8\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x49"],
        ["\xE4\xB8\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x4A"],
        ["\xE4\xB9\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x4E"],
        ["\xE4\xB9\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x51"],
        ["\xE4\xB9\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x47"],
        ["\xF0\xA0\x82\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x48"],
        ["\xE4\xB9\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x52"],
        ["\xE3\x90\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x4A"],
        ["\xF0\xA0\x82\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x49"],
        ["\xE4\xB9\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x53"],
        ["\xE4\xB9\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x57"],
        ["\xE4\xBA\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x5F"],
        ["\xE3\x90\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x4B"],
        ["\xE3\x90\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x4C"],
        ["\xE4\xBA\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x61"],
        ["\xE4\xBA\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x4D"],
        ["\xF0\xA0\x86\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x4E"],
        ["\xE4\xBA\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x4F"],
        ["\xE4\xBB\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x62"],
        ["\xE4\xBB\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x50"],
        ["\xE4\xBB\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x63"],
        ["\xE4\xBB\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x51"],
        ["\xE4\xBB\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x64"],
        ["\xE4\xBB\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x6A"],
        ["\xE4\xBB\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x6C"],
        ["\xE4\xBC\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x76"],
        ["\xE4\xBD\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x52"],
        ["\xE4\xBC\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x7D"],
        ["\xE4\xBC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x7F"],
        ["\xE4\xBD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x87"],
        ["\xE4\xBD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x88"],
        ["\xF0\xA0\x88\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x53"],
        ["\xE4\xBD\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x90"],
        ["\xE4\xBD\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x91"],
        ["\xE4\xBD\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x93"],
        ["\xE4\xBD\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x94"],
        ["\xE4\xBE\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x97"],
        ["\xE4\xBE\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\x99"],
        ["\xE4\xBF\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x55"],
        ["\xE4\xBE\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA3"],
        ["\xE4\xBE\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA9"],
        ["\xE4\xBF\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],
        ["\xE4\xBF\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xAF"],
        ["\xE4\xBF\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB1"],
        ["\xE4\xBF\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB2"],
        ["\xE3\x91\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x59"],
        ["\xE4\xBF\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB7"],
        ["\xE5\x80\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xBA"],
        ["\xE5\x80\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC1"],
        ["\xE5\x80\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC2"],
        ["\xE5\x80\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC6"],
        ["\xE3\x91\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x58"],
        ["\xE5\x81\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD3"],
        ["\xE5\x81\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD6"],
        ["\xE5\x81\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD7"],
        ["\xE5\x81\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDC"],
        ["\xE5\x81\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDD"],
        ["\xE5\x81\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDF"],
        ["\xE5\x82\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x5C"],
        ["\xE5\x82\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x5A"],
        ["\xE5\x82\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xEA"],
        ["\xE5\x82\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],
        ["\xE5\x82\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x5B"],
        ["\xE5\x82\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],
        ["\xE5\x82\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xEE"],
        ["\xE5\x82\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF4"],
        ["\xF0\xA0\x8C\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x5D"],
        ["\xE5\x82\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x5E"],
        ["\xE5\x82\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF8"],
        ["\xE5\x82\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x5F"],
        ["\xE5\x83\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xFC"],
        ["\xE5\x83\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xFD"],
        ["\xE5\x83\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x65"],
        ["\xF0\xA0\x8E\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x64"],
        ["\xE5\x83\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x41"],
        ["\xF0\xA0\x8D\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x60"],
        ["\xE5\x83\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x44"],
        ["\xE5\x83\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x61"],
        ["\xE5\x83\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x62"],
        ["\xE5\x83\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x4C"],
        ["\xE3\x92\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x66"],
        ["\xE5\xAE\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xEE"],
        ["\xE5\xAE\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF1"],
        ["\xE3\x9D\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDB"],
        ["\xE3\x9D\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDD"],
        ["\xE5\xAF\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDC"],
        ["\xE5\xAF\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xFC"],
        ["\xE3\x9D\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDF"],
        ["\xE3\x9D\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDE"],
        ["\xE5\xAF\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x44"],
        ["\xE5\xAF\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x46"],
        ["\xE3\x9D\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE0"],
        ["\xE5\xB0\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],
        ["\xE5\xB0\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x4C"],
        ["\xE5\xB0\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x50"],
        ["\xF0\xA1\xB1\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE4"],
        ["\xE5\xB1\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE6"],
        ["\xE5\xB1\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x58"],
        ["\xE5\xB1\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x59"],
        ["\xE5\xB1\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x5A"],
        ["\xE5\xB1\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x5B"],
        ["\xE5\xB1\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x5D"],
        ["\xF0\xA1\xB4\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE9"],
        ["\xF0\xA1\xB5\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEA"],
        ["\xE5\xB1\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x62"],
        ["\xF0\xA1\xB5\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],
        ["\xF0\xA1\xB5\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],
        ["\xE5\xB2\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x65"],
        ["\xE5\xB2\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x66"],
        ["\xE3\x9F\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF1"],
        ["\xF0\xA1\xB6\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF2"],
        ["\xF0\xA1\xB6\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],
        ["\xE5\xB2\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x6B"],
        ["\xE5\xB2\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x6C"],
        ["\xE5\xB2\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xED"],
        ["\xF0\xA1\xB6\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEF"],
        ["\xE5\xB2\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEE"],
        ["\xE5\xB2\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x71"],
        ["\xF0\xA1\xB6\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF4"],
        ["\xE5\xB3\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x72"],
        ["\xF0\xA1\xB7\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF5"],
        ["\xF0\xA1\xB8\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF9"],
        ["\xE5\xB4\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x7C"],
        ["\xE5\xB4\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF6"],
        ["\xE5\xB4\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x82"],
        ["\xE5\xB4\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],
        ["\xE5\xB4\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF8"],
        ["\xE5\xB4\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x80"],
        ["\xE5\xB4\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x81"],
        ["\xE5\xB4\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x83"],
        ["\xE5\xB4\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x85"],
        ["\xE3\x9F\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFD"],
        ["\xE5\xB5\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x91"],
        ["\xE5\xB5\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x94"],
        ["\xE3\x9F\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFE"],
        ["\xE5\xB5\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x95"],
        ["\xF0\xA1\xBC\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x44"],
        ["\xE3\x9F\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x41"],
        ["\xE5\xB6\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x9C"],
        ["\xE3\xA0\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x42"],
        ["\xE5\xB6\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\x9E"],
        ["\xE5\xB6\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA0"],
        ["\xE5\xB6\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x43"],
        ["\xE5\xB6\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA2"],
        ["\xE5\xB6\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA8"],
        ["\xE5\xB6\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA9"],
        ["\xE5\xB6\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],
        ["\xF0\xA1\xBD\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x46"],
        ["\xE5\xB7\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x47"],
        ["\xE5\xB7\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x48"],
        ["\xE5\xB7\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAF"],
        ["\xE5\xB7\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB1"],
        ["\xF0\xA1\xBF\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x49"],
        ["\xE5\xB7\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB2"],
        ["\xE5\xB7\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],
        ["\xE3\xA0\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x4B"],
        ["\xE5\xB8\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],
        ["\xE3\xA0\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x4C"],
        ["\xE5\xB8\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],
        ["\xE5\xB8\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],
        ["\xE3\xA1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x4D"],
        ["\xE5\xB8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],
        ["\xE5\xB8\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],
        ["\xE5\xB8\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],
        ["\xE5\xB9\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],
        ["\xE3\xA1\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x4E"],
        ["\xE5\xB9\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],
        ["\xE3\xA1\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x4F"],
        ["\xE5\xB9\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xCF"],
        ["\xE5\xB9\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD0"],
        ["\xE5\xB9\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],
        ["\xE5\x84\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x56"],
        ["\xF0\xA0\x8F\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x67"],
        ["\xE5\x84\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x5C"],
        ["\xE5\x84\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x5E"],
        ["\xF0\xA0\x91\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x68"],
        ["\xE5\x85\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x6A"],
        ["\xF0\xA0\x94\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x6B"],
        ["\xE5\x85\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCC"],
        ["\xE5\x86\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x77"],
        ["\xE5\x86\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x79"],
        ["\xE3\x92\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x6D"],
        ["\xE5\x86\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x7B"],
        ["\xE5\x86\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x7D"],
        ["\xE5\x86\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x7E"],
        ["\xE3\x93\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x6F"],
        ["\xE5\x86\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x81"],
        ["\xF0\xA0\x97\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x70"],
        ["\xF0\xA0\x98\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x73"],
        ["\xE5\x87\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x90"],
        ["\xE5\x87\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x91"],
        ["\xE5\x88\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x94"],
        ["\xE5\x88\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x96"],
        ["\xE5\x88\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\x98"],
        ["\xF0\xA0\x9D\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x76"],
        ["\xE5\x89\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA2"],
        ["\xE5\x89\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA6"],
        ["\xE5\x89\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x77"],
        ["\xE5\x89\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xAC"],
        ["\xE5\x8A\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x78"],
        ["\xE5\x8A\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB0"],
        ["\xF0\xA0\xA0\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x79"],
        ["\xE5\x8A\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB8"],
        ["\xF0\xA0\xA0\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x7A"],
        ["\xE5\x8A\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],
        ["\xE5\x8A\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],
        ["\xE5\x8A\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC2"],
        ["\xE5\x8B\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x7C"],
        ["\xE3\x94\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x7D"],
        ["\xE5\x8B\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC9"],
        ["\xF0\xA0\xA2\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x80"],
        ["\xE5\x8B\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD7"],
        ["\xE5\x8C\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD9"],
        ["\xE5\x8C\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],
        ["\xE5\x8C\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xEC"],
        ["\xE5\x8C\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xEF"],
        ["\xE5\x8D\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],
        ["\xF0\xA0\xA5\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x82"],
        ["\xF0\xA0\xA6\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x84"],
        ["\xE5\x8D\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x85"],
        ["\xE5\x8D\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],
        ["\xE5\x8D\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x86"],
        ["\xE5\x8E\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x46"],
        ["\xE5\x8E\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x4A"],
        ["\xF0\xA0\xAB\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x88"],
        ["\xE5\x8E\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x4C"],
        ["\xE5\x8F\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x50"],
        ["\xF0\xA0\xAC\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x89"],
        ["\xE3\x95\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x8A"],
        ["\xE3\x95\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x8B"],
        ["\xE5\x8F\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x55"],
        ["\xE5\x8F\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x56"],
        ["\xE3\x95\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x8C"],
        ["\xE5\x8F\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x8E"],
        ["\xE5\x8F\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x5B"],
        ["\xE5\x91\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x93"],
        ["\xE5\x90\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x91"],
        ["\xE5\x90\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x61"],
        ["\xE3\x95\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x92"],
        ["\xE5\x91\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x67"],
        ["\xE5\x91\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x6D"],
        ["\xE5\x91\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x6F"],
        ["\xE5\x91\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x94"],
        ["\xE5\x92\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x7C"],
        ["\xE5\x92\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x7E"],
        ["\xE5\x92\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x95"],
        ["\xE5\x92\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x82"],
        ["\xE5\x92\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x85"],
        ["\xE5\x92\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x86"],
        ["\xE5\x92\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x88"],
        ["\xE5\x92\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x8A"],
        ["\xE5\x92\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x8C"],
        ["\xE5\x93\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x96"],
        ["\xF0\xA0\xB5\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x9B"],
        ["\xE5\x93\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x93"],
        ["\xE5\x93\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x94"],
        ["\xE5\x93\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x97"],
        ["\xE5\x93\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x98"],
        ["\xE5\x94\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x98"],
        ["\xE5\x94\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x99"],
        ["\xE5\x94\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\x9C"],
        ["\xE5\x94\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],
        ["\xE5\x95\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA9"],
        ["\xE3\x96\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x99"],
        ["\xE5\x95\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],
        ["\xE5\x95\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAC"],
        ["\xE3\x96\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x9A"],
        ["\xE5\x95\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB4"],
        ["\xE5\x95\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB5"],
        ["\xE5\x95\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB6"],
        ["\xF0\xA0\xB7\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x9F"],
        ["\xE5\x95\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x9C"],
        ["\xE5\x96\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],
        ["\xE5\x96\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],
        ["\xE5\x96\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],
        ["\xE3\x97\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x9D"],
        ["\xE5\x97\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD0"],
        ["\xF0\xA0\xBA\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],
        ["\xF0\xA0\xB9\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],
        ["\xE5\x96\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],
        ["\xE5\x97\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCB"],
        ["\xE5\x97\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],
        ["\xE5\x97\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCF"],
        ["\xE5\x97\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA0"],
        ["\xE3\x97\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],
        ["\xE5\x97\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD6"],
        ["\xF0\xA0\xB9\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],
        ["\xE5\x97\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD7"],
        ["\xE5\x98\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],
        ["\xF0\xA0\xBD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA8"],
        ["\xE5\x98\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],
        ["\xE5\x98\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE0"],
        ["\xE5\x98\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE5"],
        ["\xE5\x98\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],
        ["\xE3\x97\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA9"],
        ["\xE5\x98\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],
        ["\xE5\x98\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xED"],
        ["\xE5\x99\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],
        ["\xE5\x99\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAA"],
        ["\xE5\x99\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],
        ["\xE5\x99\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF9"],
        ["\xE5\x99\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x41"],
        ["\xE3\x98\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAE"],
        ["\xE5\x9A\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x48"],
        ["\xE5\x9A\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x4A"],
        ["\xE5\x9A\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x4B"],
        ["\xE5\x9A\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x4D"],
        ["\xE5\x9A\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x4E"],
        ["\xE5\x9A\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x53"],
        ["\xE5\x9A\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x57"],
        ["\xE5\x9A\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],
        ["\xE5\x9B\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x5C"],
        ["\xE5\x9B\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x61"],
        ["\xE5\x9B\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x67"],
        ["\xE5\x9B\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x6D"],
        ["\xE5\x9B\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x71"],
        ["\xE5\x9B\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x72"],
        ["\xF0\xA1\x88\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB0"],
        ["\xE5\x9C\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x79"],
        ["\xE5\x9C\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x7F"],
        ["\xF0\xA1\x89\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],
        ["\xE5\x9C\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x82"],
        ["\xF0\xA1\x89\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],
        ["\xE5\x9D\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x8C"],
        ["\xE5\x9D\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x8D"],
        ["\xE5\x9D\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x8E"],
        ["\xE5\x9D\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x8F"],
        ["\xF0\xA1\x89\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB4"],
        ["\xE5\x9D\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x93"],
        ["\xE5\x9D\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x97"],
        ["\xE5\x9D\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x9A"],
        ["\xE5\x9D\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x9B"],
        ["\xE5\x9D\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\x9C"],
        ["\xE5\x9D\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA0"],
        ["\xF0\xA1\x8B\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB7"],
        ["\xF0\xA1\x8B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB6"],
        ["\xE5\x9E\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],
        ["\xE5\x9E\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAC"],
        ["\xE5\x9E\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAD"],
        ["\xE5\x9E\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],
        ["\xE5\x9F\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB9"],
        ["\xF0\xA1\x8B\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB8"],
        ["\xE5\x9F\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB5"],
        ["\xF0\xA1\x8C\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBD"],
        ["\xF0\xA1\x8D\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBE"],
        ["\xE5\x9F\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB9"],
        ["\xE5\x9F\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBC"],
        ["\xE5\x9F\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC0"],
        ["\xE3\x99\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBB"],
        ["\xE5\x9F\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC3"],
        ["\xE5\x9F\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],
        ["\xE5\x9F\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],
        ["\xE5\xA0\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC8"],
        ["\xE5\xA0\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],
        ["\xE5\xA0\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD0"],
        ["\xE5\xA0\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD2"],
        ["\xE5\xA0\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],
        ["\xE5\xA0\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD5"],
        ["\xF0\xA1\x8F\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],
        ["\xE5\xA1\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD7"],
        ["\xE5\xA1\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],
        ["\xE5\xA1\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE0"],
        ["\xE5\xA2\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],
        ["\xE5\xA2\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC1"],
        ["\xE5\xA2\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xEC"],
        ["\xE5\xA2\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xED"],
        ["\xE5\xA2\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],
        ["\xE5\xA2\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xEF"],
        ["\xE5\xA2\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],
        ["\xE5\xA2\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],
        ["\xE5\xA2\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF7"],
        ["\xF0\xA1\x91\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC5"],
        ["\xE5\xA3\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],
        ["\xE5\xA3\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xFC"],
        ["\xE5\xA3\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x47"],
        ["\xE5\xA3\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x49"],
        ["\xE5\xA3\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC8"],
        ["\xE5\xA4\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x4A"],
        ["\xE5\xA4\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x4B"],
        ["\xE5\xA4\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC9"],
        ["\xE5\xA4\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x4F"],
        ["\xE5\xA4\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x53"],
        ["\xF0\xA1\x97\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCA"],
        ["\xE3\x9A\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCB"],
        ["\xE5\xA4\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],
        ["\xE3\x9A\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],
        ["\xE5\xA5\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x5C"],
        ["\xE3\x9A\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCE"],
        ["\xF0\xA6\xB0\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x9E"],
        ["\xE5\xA5\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x60"],
        ["\xF0\xA1\x99\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD0"],
        ["\xE5\xA5\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x66"],
        ["\xE5\xA5\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x67"],
        ["\xE5\xA5\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x6A"],
        ["\xE5\xA6\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x71"],
        ["\xE5\xA6\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x74"],
        ["\xE5\xA6\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x79"],
        ["\xE5\xA7\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x7D"],
        ["\xE5\xA7\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x7F"],
        ["\xE5\xA7\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x82"],
        ["\xE5\xA7\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x84"],
        ["\xE5\xA7\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x85"],
        ["\xE5\xA7\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x86"],
        ["\xE5\xA7\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x87"],
        ["\xF0\xA1\x9C\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],
        ["\xF0\xA1\x9D\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD6"],
        ["\xE3\x9B\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD4"],
        ["\xE5\xA8\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x8F"],
        ["\xE5\xA8\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x90"],
        ["\xE5\xA8\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],
        ["\xE5\xA8\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x97"],
        ["\xE5\xA8\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\x9A"],
        ["\xE5\xA9\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA2"],
        ["\xE5\xA9\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],
        ["\xE5\xA9\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA9"],
        ["\xE5\xAA\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],
        ["\xE5\xAA\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],
        ["\xE5\xAA\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB3"],
        ["\xE5\xAA\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],
        ["\xE5\xAA\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB5"],
        ["\xE5\xAA\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],
        ["\xE5\xAA\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],
        ["\xE5\xAA\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBB"],
        ["\xE5\xAA\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],
        ["\xE5\xAA\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBF"],
        ["\xE5\xAB\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],
        ["\xE5\xAB\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC5"],
        ["\xE5\xAB\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC6"],
        ["\xE5\xAB\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC7"],
        ["\xE5\xAB\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],
        ["\xE5\xAB\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],
        ["\xE5\xAB\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCA"],
        ["\xE5\xAC\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCD"],
        ["\xE5\xAC\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCF"],
        ["\xE5\xAC\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD0"],
        ["\xE5\xAC\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD7"],
        ["\xE5\xAC\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD6"],
        ["\xE5\xAD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],
        ["\xE5\xAD\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],
        ["\xE5\xAD\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],
        ["\xE5\xAD\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],
        ["\xE5\xAD\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],
        ["\xE5\xAD\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE4"],
        ["\xE5\xAE\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE5"],
        ["\xE5\xAE\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE6"],
        ["\xF0\xA1\xA7\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],
        ["\xE5\xB9\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD2"],
        ["\xF0\xA2\x85\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x50"],
        ["\xE5\xBA\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],
        ["\xE5\xBA\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xDB"],
        ["\xE5\xBA\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xDC"],
        ["\xE5\xBA\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x53"],
        ["\xE5\xBA\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE1"],
        ["\xE5\xBB\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE2"],
        ["\xE5\xBB\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE7"],
        ["\xE5\xBB\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x55"],
        ["\xF0\xA2\x8C\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x56"],
        ["\xE5\xBB\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x58"],
        ["\xE5\xBC\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],
        ["\xE5\xBC\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],
        ["\xE5\xBC\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF4"],
        ["\xF0\xA2\x8E\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x5A"],
        ["\xE5\xBC\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x5B"],
        ["\xE5\xBD\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x46"],
        ["\xE5\xBD\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x4D"],
        ["\xE5\xBD\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x50"],
        ["\xE5\xBD\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x56"],
        ["\xE5\xBE\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x59"],
        ["\xE5\xBE\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x5D"],
        ["\xE5\xBE\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x5E"],
        ["\xE5\xBE\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x65"],
        ["\xE5\xBF\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x66"],
        ["\xE3\xA3\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x5D"],
        ["\xE5\xBF\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x67"],
        ["\xE5\xBF\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x6A"],
        ["\xE5\xBF\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x6D"],
        ["\xE5\xBF\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x6E"],
        ["\xE5\xBF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x6F"],
        ["\xE5\xBF\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x71"],
        ["\xE5\xBF\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x77"],
        ["\xE5\xBF\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x78"],
        ["\xE5\xBF\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x7A"],
        ["\xE5\xBF\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x7D"],
        ["\xE3\xA4\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x5F"],
        ["\xE6\x80\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x83"],
        ["\xE6\x80\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x5E"],
        ["\xE6\x80\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x87"],
        ["\xE3\xA4\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x60"],
        ["\xE6\x81\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x8F"],
        ["\xE6\x81\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x98"],
        ["\xE6\x82\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\x9F"],
        ["\xE6\x82\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA6"],
        ["\xF0\xA2\x9B\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x62"],
        ["\xE6\x82\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA7"],
        ["\xE6\x82\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA8"],
        ["\xE6\x82\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],
        ["\xE6\x83\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xAE"],
        ["\xE6\x83\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB5"],
        ["\xE6\x83\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB6"],
        ["\xE6\x83\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x63"],
        ["\xE6\x83\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xBA"],
        ["\xE6\x84\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],
        ["\xE6\x84\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],
        ["\xE6\x84\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC4"],
        ["\xE6\x84\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],
        ["\xE6\x84\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xCA"],
        ["\xE6\x84\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x65"],
        ["\xE3\xA5\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x64"],
        ["\xE6\x85\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD2"],
        ["\xE6\x85\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],
        ["\xE6\x85\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],
        ["\xE6\x85\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xDC"],
        ["\xF0\xA2\xA1\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x68"],
        ["\xE6\x86\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE4"],
        ["\xE6\x86\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],
        ["\xE6\x86\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE6"],
        ["\xE6\x86\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],
        ["\xE6\x86\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xEC"],
        ["\xE6\x86\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xEE"],
        ["\xF0\xA2\xA2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x69"],
        ["\xE6\x87\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF7"],
        ["\xE6\x87\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],
        ["\xE6\x87\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],
        ["\xE6\x87\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x6B"],
        ["\xF0\xA2\xA6\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x6C"],
        ["\xE6\x88\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x4A"],
        ["\xE6\x88\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x4E"],
        ["\xE6\x88\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x50"],
        ["\xE6\x89\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x57"],
        ["\xE6\x89\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x58"],
        ["\xE6\x89\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x5A"],
        ["\xE6\x89\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x5B"],
        ["\xE6\x89\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x6E"],
        ["\xE6\x89\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x60"],
        ["\xE6\x89\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x6F"],
        ["\xE6\x89\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x61"],
        ["\xE6\x89\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x63"],
        ["\xE6\x8A\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x71"],
        ["\xE6\x8B\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x73"],
        ["\xF0\xA2\xAA\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x72"],
        ["\xE6\x8B\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x7A"],
        ["\xE6\x8C\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x7B"],
        ["\xE6\x8C\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x7F"],
        ["\xE6\x8C\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x80"],
        ["\xF0\xA2\xAD\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x77"],
        ["\xF0\xA2\xAD\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x78"],
        ["\xE6\x8C\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x73"],
        ["\xE6\x8C\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x87"],
        ["\xE6\x8C\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x74"],
        ["\xE6\x8C\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x8A"],
        ["\xE6\x8D\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x8B"],
        ["\xE6\x8D\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x8E"],
        ["\xE6\x8D\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x92"],
        ["\xF0\xA2\xAD\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x75"],
        ["\xE6\x8D\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x76"],
        ["\xF0\xA2\xB0\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x7C"],
        ["\xF0\xA2\xAE\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x79"],
        ["\xE6\x8D\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\x9A"],
        ["\xE6\x8E\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA4"],
        ["\xE6\x8E\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],
        ["\xF0\xA2\xB0\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x7D"],
        ["\xE6\x8E\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA8"],
        ["\xE6\x8E\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB2"],
        ["\xE6\x8F\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x7E"],
        ["\xE6\x8F\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB9"],
        ["\xE6\x8F\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],
        ["\xE6\x8F\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],
        ["\xE6\x8F\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],
        ["\xE6\x8F\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x7A"],
        ["\xE6\x8F\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],
        ["\xE6\x8F\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],
        ["\xE6\x90\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],
        ["\xE6\x90\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],
        ["\xE6\x90\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],
        ["\xE6\x90\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCF"],
        ["\xE6\x90\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD1"],
        ["\xE6\x91\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDC"],
        ["\xE6\x91\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDD"],
        ["\xE6\x91\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],
        ["\xE6\x91\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],
        ["\xE6\x91\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],
        ["\xE6\x92\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],
        ["\xE6\x92\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],
        ["\xE6\x92\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],
        ["\xE6\x93\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xFD"],
        ["\xE6\x93\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xFE"],
        ["\xE6\x93\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x43"],
        ["\xE6\x93\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x44"],
        ["\xF0\xA2\xB7\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x80"],
        ["\xE6\x93\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x45"],
        ["\xE6\x93\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x46"],
        ["\xE6\x93\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x4E"],
        ["\xE6\x94\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x50"],
        ["\xE3\xA9\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x81"],
        ["\xE6\x94\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x54"],
        ["\xE6\x94\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x56"],
        ["\xE6\x94\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x57"],
        ["\xE3\xA9\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x82"],
        ["\xE6\x94\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x5A"],
        ["\xE6\x94\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x83"],
        ["\xE6\x95\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x84"],
        ["\xE6\x95\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x69"],
        ["\xE6\x95\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x6D"],
        ["\xE6\x95\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x6E"],
        ["\xE6\x96\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x70"],
        ["\xE6\x96\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x86"],
        ["\xE6\x96\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x71"],
        ["\xE6\x96\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x72"],
        ["\xE6\x96\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x7B"],
        ["\xE6\x96\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x87"],
        ["\xE6\x96\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x88"],
        ["\xE6\x96\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x7E"],
        ["\xE6\x97\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x7F"],
        ["\xE6\x97\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x81"],
        ["\xE6\x97\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x84"],
        ["\xE3\xAB\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x8A"],
        ["\xE6\x97\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x89"],
        ["\xE6\x97\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x8C"],
        ["\xE6\x97\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x8C"],
        ["\xE6\x98\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x8F"],
        ["\xE6\x98\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x90"],
        ["\xE6\x98\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x96"],
        ["\xE6\x98\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\x9B"],
        ["\xE6\x99\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA3"],
        ["\xE6\x99\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],
        ["\xE6\x99\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],
        ["\xE3\xAB\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x8F"],
        ["\xF0\xA3\x87\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x93"],
        ["\xE6\x99\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],
        ["\xE6\x99\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x92"],
        ["\xF0\xA3\x87\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x96"],
        ["\xF0\xA3\x86\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x91"],
        ["\xE6\x99\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAE"],
        ["\xE6\x99\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAF"],
        ["\xE6\x99\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB0"],
        ["\xE6\x99\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x95"],
        ["\xE6\x99\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],
        ["\xE6\x9A\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB9"],
        ["\xE6\x9A\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBD"],
        ["\xE6\x9A\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],
        ["\xE3\xAC\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x98"],
        ["\xE6\x9A\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC4"],
        ["\xE6\x9A\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC5"],
        ["\xE6\x9A\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],
        ["\xE3\xAC\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x99"],
        ["\xE3\xAC\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x9A"],
        ["\xE6\x9B\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],
        ["\xE3\xAB\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x8B"],
        ["\xE6\x9C\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x9D"],
        ["\xE6\x9C\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],
        ["\xE6\x9C\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x9E"],
        ["\xF0\xA3\x8D\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x9F"],
        ["\xE6\x9C\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],
        ["\xF0\xA3\x8F\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA3"],
        ["\xF0\xA3\x8F\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],
        ["\xE6\x9D\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE2"],
        ["\xE6\x9D\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA0"],
        ["\xE6\x9D\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE3"],
        ["\xE6\x9D\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],
        ["\xF0\xA3\x8F\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],
        ["\xF0\xA3\x8F\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],
        ["\xF0\xA3\x8F\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA4"],
        ["\xE6\x9D\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE8"],
        ["\xE6\x9D\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE9"],
        ["\xF0\xA3\x8F\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA5"],
        ["\xE6\x9E\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA6"],
        ["\xF0\xA3\x8F\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA7"],
        ["\xE8\x8D\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x9C"],
        ["\xE6\xA0\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],
        ["\xE6\x9E\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF5"],
        ["\xE6\x9E\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],
        ["\xE6\x9F\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xFC"],
        ["\xE6\x9F\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xFE"],
        ["\xE6\x9F\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x42"],
        ["\xE6\x9F\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x44"],
        ["\xE6\x9F\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA9"],
        ["\xE6\x9F\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x48"],
        ["\xE6\x9F\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x4B"],
        ["\xF0\xA3\x91\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAF"],
        ["\xF0\xA3\x91\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB1"],
        ["\xF0\xA3\x91\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB0"],
        ["\xE6\xA0\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],
        ["\xE6\xA0\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x50"],
        ["\xE6\xA0\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x54"],
        ["\xF0\xA3\x91\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB2"],
        ["\xE6\xA0\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x58"],
        ["\xE6\xA0\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x59"],
        ["\xE6\xA0\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],
        ["\xE6\xA1\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x5B"],
        ["\xE6\xA1\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],
        ["\xE6\xA1\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x5D"],
        ["\xE6\xA1\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x5E"],
        ["\xE6\xA1\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x5F"],
        ["\xE3\xAD\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],
        ["\xE6\xA1\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x62"],
        ["\xE6\xA1\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x63"],
        ["\xE6\xA1\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x6A"],
        ["\xE6\xA1\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x6C"],
        ["\xE6\xA2\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x6D"],
        ["\xE6\xA2\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],
        ["\xE6\xA2\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x71"],
        ["\xE3\xAD\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB5"],
        ["\xE6\xA2\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x72"],
        ["\xE6\xA2\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB6"],
        ["\xE6\xA2\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x73"],
        ["\xE6\xA2\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x74"],
        ["\xE6\xA2\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x79"],
        ["\xE6\xA2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB7"],
        ["\xE6\xA2\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB8"],
        ["\xE6\xA2\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x7C"],
        ["\xE6\xA3\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x90"],
        ["\xF0\xA3\x93\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBF"],
        ["\xF0\xA3\x95\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC4"],
        ["\xE6\xA3\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],
        ["\xE6\xA3\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x7D"],
        ["\xE6\xA3\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x7E"],
        ["\xE6\xA3\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x82"],
        ["\xE6\xA3\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x83"],
        ["\xE6\xA3\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBB"],
        ["\xE6\xA3\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x86"],
        ["\xE6\xA3\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x8A"],
        ["\xE6\xA3\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBC"],
        ["\xE6\xA4\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBD"],
        ["\xE6\xA4\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBE"],
        ["\xE3\xAE\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],
        ["\xE3\xAE\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC0"],
        ["\xF0\xA3\x96\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC5"],
        ["\xE6\xA4\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\x9F"],
        ["\xE3\xAE\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC2"],
        ["\xE6\xA5\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],
        ["\xE6\xA5\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],
        ["\xE6\xA5\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],
        ["\xE6\xA5\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],
        ["\xE6\xA5\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAF"],
        ["\xE6\xA5\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB1"],
        ["\xE6\xA6\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB4"],
        ["\xE3\xAE\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC6"],
        ["\xE6\xA6\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB5"],
        ["\xE6\xA6\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB8"],
        ["\xE6\xA6\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],
        ["\xE6\xA6\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],
        ["\xE6\xA6\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],
        ["\xE6\xA6\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],
        ["\xE6\xA7\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC8"],
        ["\xE6\xA7\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],
        ["\xE6\xA7\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],
        ["\xF0\xA3\x98\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD3"],
        ["\xF0\xA3\x99\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],
        ["\xF0\xA3\x98\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD2"],
        ["\xF0\xA3\x98\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD4"],
        ["\xE6\xA7\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],
        ["\xE6\xA7\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],
        ["\xE6\xA7\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],
        ["\xE6\xA7\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],
        ["\xE3\xAF\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD6"],
        ["\xE6\xA7\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCF"],
        ["\xE6\xA7\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],
        ["\xE6\xA8\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],
        ["\xE6\xA8\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],
        ["\xE6\xA8\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],
        ["\xF0\xA3\x9C\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDD"],
        ["\xE6\xA8\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],
        ["\xE6\xA8\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD7"],
        ["\xE6\xA8\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],
        ["\xE6\xA8\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDD"],
        ["\xE6\xA9\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],
        ["\xE6\xA9\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],
        ["\xE6\xA9\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],
        ["\xE6\xA9\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],
        ["\xE6\xA9\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],
        ["\xF0\xA3\x9C\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDC"],
        ["\xE6\xAA\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xED"],
        ["\xE6\xAA\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],
        ["\xE3\xAF\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD9"],
        ["\xE6\xAA\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],
        ["\xE6\xAA\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],
        ["\xE6\xAA\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDB"],
        ["\xF0\xA3\x9D\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE0"],
        ["\xE6\xAA\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],
        ["\xE6\xAA\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xFD"],
        ["\xE6\xAB\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x42"],
        ["\xE6\xAB\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x47"],
        ["\xE6\xAB\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x46"],
        ["\xE6\xAB\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x4A"],
        ["\xE6\xAB\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x4B"],
        ["\xF0\xA3\x9F\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE5"],
        ["\xF0\xA3\x9F\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE3"],
        ["\xE6\xAB\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x4D"],
        ["\xE6\xAB\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x4F"],
        ["\xE6\xAB\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x50"],
        ["\xE6\xAB\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE1"],
        ["\xE6\xAB\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x52"],
        ["\xF0\xA3\xA0\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE7"],
        ["\xE6\xAC\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE6"],
        ["\xE6\xAC\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x58"],
        ["\xE6\xAC\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x59"],
        ["\xE6\xAC\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x5A"],
        ["\xF0\xA3\xA0\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],
        ["\xE6\xAC\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x5B"],
        ["\xE3\xB0\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE9"],
        ["\xE6\xAC\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x62"],
        ["\xE6\xAD\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x68"],
        ["\xE6\xAD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x6C"],
        ["\xE6\xAD\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEB"],
        ["\xE6\xAD\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x73"],
        ["\xE6\xAD\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],
        ["\xE6\xAE\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEE"],
        ["\xE6\xAE\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x79"],
        ["\xE6\xAE\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x82"],
        ["\xF0\xA3\xAA\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF0"],
        ["\xE6\xAE\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x86"],
        ["\xE6\xAE\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x87"],
        ["\xE6\xAF\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF1"],
        ["\xE6\xAF\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF2"],
        ["\xE6\xAF\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x8A"],
        ["\xE6\xAF\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x8C"],
        ["\xE6\xAF\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x8F"],
        ["\xE6\xAF\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x90"],
        ["\xE6\xAF\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x91"],
        ["\xE6\xAF\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x92"],
        ["\xE6\xB0\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x96"],
        ["\xE6\xB0\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF5"],
        ["\xE6\xB0\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\x9B"],
        ["\xE6\xB0\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],
        ["\xE6\xB0\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],
        ["\xE6\xB0\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\xF0\xA3\xB1\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF6"],
        ["\xE6\xB1\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],
        ["\xE6\xB1\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],
        ["\xE6\xB1\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\xE6\xB2\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF7"],
        ["\xE6\xB2\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],
        ["\xE3\xB3\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF8"],
        ["\xE6\xB2\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],
        ["\xE6\xB2\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],
        ["\xE6\xB2\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],
        ["\xE6\xB2\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFA"],
        ["\xE6\xB3\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],
        ["\xE6\xB3\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCA"],
        ["\xE3\xB3\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFC"],
        ["\xE6\xB3\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],
        ["\xE6\xB3\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],
        ["\xE6\xB3\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],
        ["\xE6\xB3\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],
        ["\xE6\xB3\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFB"],
        ["\xF0\xA3\xB4\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x44"],
        ["\xE6\xB4\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFE"],
        ["\xE6\xB4\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],
        ["\xE6\xB4\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x41"],
        ["\xE6\xB4\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],
        ["\xE6\xB4\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],
        ["\xE6\xB1\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],
        ["\xE6\xB4\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],
        ["\xE6\xB4\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],
        ["\xE6\xB5\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x47"],
        ["\xE6\xB5\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],
        ["\xE6\xB5\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x48"],
        ["\xE6\xB5\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],
        ["\xE6\xB6\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x4A"],
        ["\xE6\xB6\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x4B"],
        ["\xE6\xB6\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x4D"],
        ["\xE6\xB6\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x4E"],
        ["\xE6\xB6\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],
        ["\xE6\xB6\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],
        ["\xF0\xA3\xB5\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x4F"],
        ["\xE6\xB8\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x56"],
        ["\xF0\xA3\xB7\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x58"],
        ["\xF0\xA3\xB7\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x57"],
        ["\xF0\xA3\xB7\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x55"],
        ["\xE6\xB6\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x50"],
        ["\xE6\xB6\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x51"],
        ["\xE6\xB6\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],
        ["\xE6\xB7\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x52"],
        ["\xE6\xB4\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x42"],
        ["\xE6\xB7\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],
        ["\xE6\xB7\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x41"],
        ["\xE6\xB7\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x53"],
        ["\xE6\xB7\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x45"],
        ["\xE6\xB7\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x49"],
        ["\xE6\xB7\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x4D"],
        ["\xE6\xB8\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x53"],
        ["\xE6\xB8\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x50"],
        ["\xE6\xB8\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x51"],
        ["\xE3\xB4\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x5A"],
        ["\xE6\xB8\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x52"],
        ["\xE6\xB9\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x57"],
        ["\xE6\xB9\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x58"],
        ["\xE6\xB9\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x59"],
        ["\xE6\xB9\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x5C"],
        ["\xE6\xB9\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x5A"],
        ["\xE6\xB9\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x5B"],
        ["\xE6\xB9\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x5D"],
        ["\xE6\xB9\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x5E"],
        ["\xE6\xB9\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x5F"],
        ["\xE6\xB9\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x63"],
        ["\xE3\xB4\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x5D"],
        ["\xE6\xBA\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x69"],
        ["\xE6\xBA\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x6C"],
        ["\xE6\xBA\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x5F"],
        ["\xE6\xBB\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x74"],
        ["\xE6\xBB\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x77"],
        ["\xE6\xBB\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x60"],
        ["\xE6\xBC\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x64"],
        ["\xE6\xBB\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x7B"],
        ["\xE6\xBB\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x7E"],
        ["\xE6\xBB\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x7F"],
        ["\xE6\xBC\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x83"],
        ["\xE6\xBC\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x84"],
        ["\xE6\xBC\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x87"],
        ["\xE6\xBC\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x63"],
        ["\xE6\xBC\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x91"],
        ["\xE6\xBC\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x93"],
        ["\xF0\xA3\xBD\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x66"],
        ["\xE6\xBD\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x96"],
        ["\xE6\xBD\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x98"],
        ["\xE6\xBD\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x9A"],
        ["\xE6\xBD\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x65"],
        ["\xE6\xBD\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\x9F"],
        ["\xE6\xBE\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x67"],
        ["\xE6\xBD\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\xE6\xBE\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],
        ["\xE6\xBE\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],
        ["\xE6\xBE\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x69"],
        ["\xE6\xBE\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],
        ["\xE6\xBE\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],
        ["\xE6\xBE\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],
        ["\xE3\xB5\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x68"],
        ["\xE6\xBF\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],
        ["\xE6\xBF\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x6A"],
        ["\xE6\xBF\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],
        ["\xE6\xBF\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],
        ["\xE6\xBF\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],
        ["\xF0\xA4\x82\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x6C"],
        ["\xE6\xBF\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],
        ["\xE7\x80\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],
        ["\xE7\x80\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x6B"],
        ["\xE7\x80\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],
        ["\xF0\xA4\x84\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x6E"],
        ["\xE7\x80\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],
        ["\xE7\x80\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x6D"],
        ["\xE7\x80\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCF"],
        ["\xE7\x81\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],
        ["\xE7\x81\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x6F"],
        ["\xE7\x81\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],
        ["\xE3\xB6\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x70"],
        ["\xE7\x81\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],
        ["\xE7\x81\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDC"],
        ["\xE7\x81\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x71"],
        ["\xE7\x81\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDD"],
        ["\xE7\x81\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDE"],
        ["\xE7\x81\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],
        ["\xE7\x81\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE1"],
        ["\xE7\x82\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],
        ["\xE7\x82\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],
        ["\xE7\x82\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],
        ["\xE7\x82\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],
        ["\xF0\xA4\x87\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x73"],
        ["\xE7\x82\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x72"],
        ["\xE7\x82\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xEC"],
        ["\xF0\xA4\x87\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x74"],
        ["\xE7\x83\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x75"],
        ["\xE7\x83\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],
        ["\xE7\x83\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],
        ["\xE7\x83\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],
        ["\xE7\x83\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],
        ["\xE7\x84\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],
        ["\xE7\x84\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],
        ["\xE7\x84\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],
        ["\xE7\x84\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x76"],
        ["\xE7\x84\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xFE"],
        ["\xE3\xB7\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x77"],
        ["\xE7\x84\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x45"],
        ["\xE7\x84\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x47"],
        ["\xE7\x85\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x4D"],
        ["\xE7\x85\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x4B"],
        ["\xE7\x85\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x7A"],
        ["\xE7\x85\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x51"],
        ["\xE3\xB7\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x7B"],
        ["\xE7\x86\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x7D"],
        ["\xE7\x86\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x55"],
        ["\xE7\x86\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x5B"],
        ["\xE7\x86\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x5C"],
        ["\xE7\x86\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x5D"],
        ["\xE7\x86\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x7E"],
        ["\xE7\x86\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x5E"],
        ["\xE7\x86\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x61"],
        ["\xF0\xA4\x8E\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x7F"],
        ["\xE7\x87\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x66"],
        ["\xE7\x87\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x68"],
        ["\xE7\x87\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x6A"],
        ["\xE7\x87\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x6C"],
        ["\xE7\x88\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x6F"],
        ["\xE3\xB8\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x80"],
        ["\xEF\xA9\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x82"],
        ["\xE7\x88\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x78"],
        ["\xE7\x88\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x7A"],
        ["\xE7\x88\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x7B"],
        ["\xE7\x88\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x7C"],
        ["\xE4\xB8\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x45"],
        ["\xE7\x89\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x7E"],
        ["\xE7\x89\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x84"],
        ["\xE7\x89\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x83"],
        ["\xE7\x89\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x8B"],
        ["\xF0\xA4\x98\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x84"],
        ["\xE7\x89\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x8E"],
        ["\xE7\x89\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x8F"],
        ["\xE7\x89\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x92"],
        ["\xE7\x89\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x95"],
        ["\xE7\x8A\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x99"],
        ["\xF0\xA4\x9A\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x86"],
        ["\xE7\x8A\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x9D"],
        ["\xE7\x8A\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\x9E"],
        ["\xE7\x8A\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x87"],
        ["\xE7\x8B\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA0"],
        ["\xE3\xB9\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x89"],
        ["\xE7\x8B\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA3"],
        ["\xE3\xB9\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x8A"],
        ["\xE3\xB9\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x8B"],
        ["\xE7\x8B\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA9"],
        ["\xE7\x8B\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],
        ["\xE7\x8C\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB1"],
        ["\xE7\x8C\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],
        ["\xE7\x8C\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB6"],
        ["\xE7\x8C\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB7"],
        ["\xE3\xBA\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x8C"],
        ["\xE7\x8C\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x8F"],
        ["\xE7\x8C\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],
        ["\xE7\x8C\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],
        ["\xE7\x8C\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x8D"],
        ["\xE7\x8C\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],
        ["\xE7\x8D\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],
        ["\xE3\xBA\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x90"],
        ["\xE7\x8D\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],
        ["\xE7\x8D\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],
        ["\xF0\xA4\xA2\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x91"],
        ["\xE7\x8D\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],
        ["\xE7\x8D\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],
        ["\xE7\x8D\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],
        ["\xE7\x8E\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],
        ["\xE7\x8E\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xDA"],
        ["\xE7\x8E\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x92"],
        ["\xE7\x8E\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x93"],
        ["\xE7\x8E\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE1"],
        ["\xE7\x8E\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],
        ["\xE7\x8E\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],
        ["\xE7\x8E\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],
        ["\xE7\x8E\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x94"],
        ["\xE7\x8E\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xEC"],
        ["\xE7\x8E\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],
        ["\xE7\x8E\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xEE"],
        ["\xE7\x8E\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xEF"],
        ["\xE7\x8E\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],
        ["\xE7\x8F\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],
        ["\xE7\x8F\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],
        ["\xE7\x8F\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],
        ["\xE7\x8F\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],
        ["\xE7\x8F\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x41"],
        ["\xE7\x90\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x95"],
        ["\xE7\x8F\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x42"],
        ["\xE7\x90\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x47"],
        ["\xE7\x90\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x4D"],
        ["\xE7\x90\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x54"],
        ["\xE7\x90\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x55"],
        ["\xE7\x91\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x97"],
        ["\xE7\x91\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x56"],
        ["\xE7\x91\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x57"],
        ["\xE7\x91\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x5C"],
        ["\xE7\x91\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x5E"],
        ["\xE7\x91\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x60"],
        ["\xE7\x91\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x67"],
        ["\xE7\x92\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x6A"],
        ["\xE7\x92\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x6B"],
        ["\xE7\x92\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x98"],
        ["\xF0\xA4\xA9\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x9A"],
        ["\xE7\x92\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x71"],
        ["\xE7\x92\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x99"],
        ["\xE7\x92\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x73"],
        ["\xE7\x92\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x76"],
        ["\xE7\x92\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x77"],
        ["\xE7\x92\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x9B"],
        ["\xE7\x92\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x7C"],
        ["\xE7\x92\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x7D"],
        ["\xE7\x92\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x83"],
        ["\xE7\x92\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x84"],
        ["\xE7\x92\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x9C"],
        ["\xE7\x93\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x9D"],
        ["\xE7\x93\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x8B"],
        ["\xE7\x93\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x8E"],
        ["\xE7\x93\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x94"],
        ["\xE7\x93\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x93"],
        ["\xF0\xA4\xAD\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x9E"],
        ["\xE7\x93\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x96"],
        ["\xF0\xA4\xAD\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x9F"],
        ["\xE7\x94\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\x9E"],
        ["\xE7\x94\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA0"],
        ["\xE7\x94\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],
        ["\xE3\xBD\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA1"],
        ["\xF0\xA4\xB0\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA0"],
        ["\xE7\x94\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],
        ["\xE7\x94\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA7"],
        ["\xE7\x95\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],
        ["\xE7\x95\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],
        ["\xE7\x95\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],
        ["\xE7\x95\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],
        ["\xE7\x95\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],
        ["\xE7\x95\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA2"],
        ["\xE7\x95\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],
        ["\xE7\x95\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],
        ["\xE7\x95\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB6"],
        ["\xE7\x95\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],
        ["\xE7\x95\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],
        ["\xE7\x96\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],
        ["\xF0\xA4\xB4\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],
        ["\xE7\x96\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA5"],
        ["\xE3\xBD\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],
        ["\xE7\x96\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],
        ["\xE3\xBD\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA8"],
        ["\xE7\x96\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA9"],
        ["\xE7\x96\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAA"],
        ["\xE7\x96\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],
        ["\xE7\x97\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],
        ["\xE7\x97\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],
        ["\xE7\x97\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCE"],
        ["\xE7\x97\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAB"],
        ["\xE7\x97\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAC"],
        ["\xE7\x97\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],
        ["\xE7\x97\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],
        ["\xE7\x97\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],
        ["\xE7\x97\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],
        ["\xE7\x97\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],
        ["\xE7\x97\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],
        ["\xE7\x97\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],
        ["\xE7\x98\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDD"],
        ["\xE7\x98\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAF"],
        ["\xE7\x98\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],
        ["\xE7\x98\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],
        ["\xE3\xBE\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],
        ["\xF0\xA4\xB8\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAE"],
        ["\xE7\x98\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],
        ["\xE7\x98\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],
        ["\xE7\x98\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],
        ["\xF0\xA4\xB8\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],
        ["\xE7\x98\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],
        ["\xE7\x98\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],
        ["\xE7\x98\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],
        ["\xE7\x98\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],
        ["\xF0\xA4\xB9\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB2"],
        ["\xE3\xBF\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB3"],
        ["\xE7\x99\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xFA"],
        ["\xF0\xA4\xBA\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB4"],
        ["\xE7\x99\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],
        ["\xE7\x99\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x43"],
        ["\xE3\xBF\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB5"],
        ["\xE7\x99\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x49"],
        ["\xE7\x9A\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x51"],
        ["\xE7\x9A\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB6"],
        ["\xE7\x9A\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x54"],
        ["\xE7\x9A\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x59"],
        ["\xE7\x9A\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x5A"],
        ["\xE7\x9A\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB7"],
        ["\xF0\xA5\x81\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB9"],
        ["\xE7\x9B\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x60"],
        ["\xF0\xA5\x81\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],
        ["\xE7\x9B\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x68"],
        ["\xE7\x9B\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x69"],
        ["\xF0\xA5\x84\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],
        ["\xE7\x9C\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x76"],
        ["\xE7\x9C\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x78"],
        ["\xE7\x9C\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x7C"],
        ["\xE7\x9C\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x80"],
        ["\xF0\xA5\x86\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],
        ["\xE4\x80\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],
        ["\xF0\xA5\x87\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC0"],
        ["\xF0\xA5\x87\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],
        ["\xE7\x9D\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBF"],
        ["\xE7\x9D\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x91"],
        ["\xE7\x9D\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x95"],
        ["\xF0\xA5\x88\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC2"],
        ["\xE7\x9D\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x98"],
        ["\xE7\x9D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC1"],
        ["\xE7\x9D\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\x9C"],
        ["\xF0\xA5\x89\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC4"],
        ["\xE4\x81\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC3"],
        ["\xE7\x9E\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA4"],
        ["\xE7\x9E\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],
        ["\xE7\x9E\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA6"],
        ["\xE7\x9E\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC5"],
        ["\xE7\x9E\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC6"],
        ["\xE7\x9F\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],
        ["\xE7\x9F\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],
        ["\xE7\x9F\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],
        ["\xE7\x9F\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],
        ["\xE7\x9F\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB9"],
        ["\xE7\x9F\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],
        ["\xE4\x82\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC7"],
        ["\xE7\x9F\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBB"],
        ["\xE7\x9F\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],
        ["\xE7\x9F\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBF"],
        ["\xF0\xA5\x90\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC8"],
        ["\xE7\xA0\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],
        ["\xE7\xA0\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],
        ["\xE7\xA0\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],
        ["\xE7\xA0\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],
        ["\xE7\xA0\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],
        ["\xE7\xA0\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC9"],
        ["\xE7\xA1\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],
        ["\xE7\xA1\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],
        ["\xF0\xA5\x93\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],
        ["\xE7\xA2\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],
        ["\xE7\xA2\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDF"],
        ["\xE7\xA2\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],
        ["\xE7\xA2\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE1"],
        ["\xE7\xA2\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],
        ["\xE7\xA2\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],
        ["\xE7\xA2\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xED"],
        ["\xE7\xA3\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],
        ["\xE7\xA3\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],
        ["\xE7\xA3\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],
        ["\xE7\xA3\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],
        ["\xE7\xA3\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xFB"],
        ["\xE7\xA3\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xFC"],
        ["\xE7\xA3\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xFE"],
        ["\xE7\xA3\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD1"],
        ["\xE7\xA3\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x46"],
        ["\xE7\xA3\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x47"],
        ["\xE7\xA3\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],
        ["\xF0\xA5\x96\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],
        ["\xE7\xA4\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x4C"],
        ["\xE7\xA4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD4"],
        ["\xE7\xA4\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x52"],
        ["\xE7\xA4\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x59"],
        ["\xE7\xA5\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x5F"],
        ["\xE7\xA5\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x64"],
        ["\xE7\xA5\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x65"],
        ["\xE4\x84\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],
        ["\xE7\xA5\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x67"],
        ["\xE7\xA5\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x6A"],
        ["\xE7\xA6\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x73"],
        ["\xE7\xA6\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x74"],
        ["\xE7\xA6\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x77"],
        ["\xE7\xA6\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x79"],
        ["\xE7\xA6\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x7D"],
        ["\xE7\xA6\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x7F"],
        ["\xE7\xA7\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x80"],
        ["\xE7\xA7\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x82"],
        ["\xE7\xA7\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],
        ["\xE7\xA7\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],
        ["\xE7\xA7\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x87"],
        ["\xE4\x85\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE2"],
        ["\xF0\xA5\x9E\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],
        ["\xF0\xA5\x9E\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE4"],
        ["\xE4\x85\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],
        ["\xE7\xA8\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x98"],
        ["\xE7\xA8\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x9A"],
        ["\xE7\xA8\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x9B"],
        ["\xE7\xA8\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x9C"],
        ["\xE7\xA8\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\x9D"],
        ["\xE4\x85\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE6"],
        ["\xE7\xA8\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],
        ["\xE7\xA8\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],
        ["\xE7\xA9\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],
        ["\xE7\xA9\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAD"],
        ["\xE7\xA9\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAF"],
        ["\xE7\xA9\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],
        ["\xE7\xA9\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB1"],
        ["\xE7\xA9\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],
        ["\xE7\xA9\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB4"],
        ["\xE7\xA9\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],
        ["\xE7\xA9\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB7"],
        ["\xE7\xA9\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],
        ["\xE7\xA9\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],
        ["\xE7\xAA\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],
        ["\xE7\xAA\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],
        ["\xE7\xAA\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],
        ["\xE7\xAA\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],
        ["\xE7\xAA\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],
        ["\xF0\xA5\xA7\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],
        ["\xE4\x86\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],
        ["\xE7\xAA\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],
        ["\xE7\xAA\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCD"],
        ["\xE7\xAA\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],
        ["\xE4\x86\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xED"],
        ["\xE7\xAB\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],
        ["\xE7\xAB\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],
        ["\xE7\xAB\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],
        ["\xF0\xA5\xAB\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEF"],
        ["\xF0\xA5\xAB\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],
        ["\xE7\xAC\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],
        ["\xF0\xA5\xAB\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],
        ["\xE7\xAC\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],
        ["\xE7\xAC\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xDF"],
        ["\xE7\xAC\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE1"],
        ["\xE7\xAC\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],
        ["\xE7\xAC\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],
        ["\xE7\xAC\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],
        ["\xE4\x87\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],
        ["\xE4\x87\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF5"],
        ["\xE7\xAD\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF7"],
        ["\xE7\xAD\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xEC"],
        ["\xE4\x87\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF4"],
        ["\xE7\xAD\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xEF"],
        ["\xE7\xAD\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF6"],
        ["\xE7\xAD\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],
        ["\xE7\xAD\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],
        ["\xE7\xAD\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],
        ["\xE7\xAD\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],
        ["\xF0\xA5\xAE\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF9"],
        ["\xE4\x88\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF8"],
        ["\xE7\xAE\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xFD"],
        ["\xE7\xAE\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],
        ["\xE7\xAE\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x42"],
        ["\xE4\x88\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],
        ["\xE7\xAE\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x46"],
        ["\xE7\xAE\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x49"],
        ["\xE7\xAE\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x4D"],
        ["\xE7\xAF\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x50"],
        ["\xE7\xAF\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x52"],
        ["\xF0\xA5\xB1\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFC"],
        ["\xF0\xA5\xB1\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFD"],
        ["\xE7\xAF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x53"],
        ["\xE7\xAF\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x54"],
        ["\xE7\xAF\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x57"],
        ["\xE7\xAF\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x5A"],
        ["\xE7\xAF\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFE"],
        ["\xE7\xB0\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x65"],
        ["\xE7\xB0\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x69"],
        ["\xE7\xB0\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x6B"],
        ["\xE7\xB0\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x6C"],
        ["\xE7\xB0\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x71"],
        ["\xE7\xB1\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x43"],
        ["\xE7\xB1\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x7B"],
        ["\xE7\xB1\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x7C"],
        ["\xE7\xB1\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x45"],
        ["\xE7\xB1\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x85"],
        ["\xE7\xB1\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x86"],
        ["\xE7\xB1\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x89"],
        ["\xE7\xB1\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x8B"],
        ["\xE7\xB1\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x46"],
        ["\xE7\xB1\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x8C"],
        ["\xF0\xA5\xB8\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x47"],
        ["\xF0\xA5\xB9\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x48"],
        ["\xF0\xA5\xB9\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x4A"],
        ["\xE7\xB2\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x97"],
        ["\xF0\xA5\xB9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x49"],
        ["\xE7\xB2\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x99"],
        ["\xE7\xB2\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x9A"],
        ["\xE7\xB2\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x9E"],
        ["\xF0\xA5\xBB\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x4C"],
        ["\xE7\xB3\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\x9F"],
        ["\xF0\xA5\xBB\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x4B"],
        ["\xE7\xB3\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],
        ["\xE7\xB3\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA3"],
        ["\xF0\xA5\xBB\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x4D"],
        ["\xE7\xB3\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA8"],
        ["\xF0\xA5\xBC\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x4E"],
        ["\xE7\xB3\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAC"],
        ["\xE7\xB3\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],
        ["\xF0\xA5\xBD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x4F"],
        ["\xE7\xB3\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],
        ["\xE7\xB4\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],
        ["\xE7\xB4\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB3"],
        ["\xE4\x8B\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x50"],
        ["\xE7\xB4\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB6"],
        ["\xE7\xB4\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBA"],
        ["\xF0\xA5\xBF\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x52"],
        ["\xF0\xA5\xBF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x51"],
        ["\xE7\xB4\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],
        ["\xE7\xB4\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],
        ["\xE7\xB5\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],
        ["\xE7\xB5\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],
        ["\xF0\xA6\x80\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x56"],
        ["\xF0\xA5\xBF\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x54"],
        ["\xE4\x8B\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x53"],
        ["\xE7\xB5\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCA"],
        ["\xE7\xB5\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],
        ["\xE7\xB5\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],
        ["\xE7\xB5\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],
        ["\xE4\x8B\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x55"],
        ["\xE7\xB5\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],
        ["\xF0\xA6\x80\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x57"],
        ["\xE7\xB6\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],
        ["\xE7\xB6\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDA"],
        ["\xE7\xB6\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],
        ["\xE7\xB6\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],
        ["\xF0\xA6\x81\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x59"],
        ["\xE7\xB6\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE1"],
        ["\xE7\xB6\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],
        ["\xE7\xB6\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],
        ["\xE7\xB6\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],
        ["\xE7\xB7\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x58"],
        ["\xE7\xB7\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],
        ["\xE7\xB7\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],
        ["\xE7\xB7\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],
        ["\xE7\xB7\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],
        ["\xE7\xB7\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],
        ["\xE4\x8C\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x5C"],
        ["\xF0\xA6\x83\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x5E"],
        ["\xEF\xA9\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x5D"],
        ["\xE7\xB8\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x42"],
        ["\xE7\xB8\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x45"],
        ["\xE7\xB8\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x47"],
        ["\xE7\xB8\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x48"],
        ["\xE7\xB8\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x49"],
        ["\xE7\xB8\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x4B"],
        ["\xE7\xB9\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x52"],
        ["\xE7\xB9\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x5E"],
        ["\xE7\xB9\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x60"],
        ["\xE7\xB9\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x60"],
        ["\xE7\xBA\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x62"],
        ["\xE7\xBA\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x63"],
        ["\xE4\x8C\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x61"],
        ["\xE7\xBA\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x65"],
        ["\xE7\xBA\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x67"],
        ["\xE7\xBA\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x68"],
        ["\xE4\x8D\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x62"],
        ["\xE7\xBC\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x6C"],
        ["\xE7\xBC\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x6B"],
        ["\xE7\xBC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x6E"],
        ["\xE7\xBD\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x70"],
        ["\xE7\xBD\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x71"],
        ["\xE7\xBD\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x72"],
        ["\xE3\x93\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\x6E"],
        ["\xF0\xA6\x89\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x63"],
        ["\xE7\xBD\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x73"],
        ["\xF0\xA6\x8A\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x64"],
        ["\xE7\xBD\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x78"],
        ["\xE7\xBD\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x79"],
        ["\xE7\xBD\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x7A"],
        ["\xE7\xBD\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x7D"],
        ["\xE7\xBD\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x7F"],
        ["\xE7\xBD\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x80"],
        ["\xF0\xA6\x8D\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x66"],
        ["\xE7\xBE\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x86"],
        ["\xE5\x85\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x67"],
        ["\xF0\xA3\xB4\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\x45"],
        ["\xE7\xBE\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x88"],
        ["\xE7\xBE\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x8A"],
        ["\xE7\xBE\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x8E"],
        ["\xF0\xA6\x90\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x68"],
        ["\xE7\xBF\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x93"],
        ["\xE7\xBF\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x96"],
        ["\xE7\xBF\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x99"],
        ["\xE7\xBF\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x9A"],
        ["\xE7\xBF\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x9E"],
        ["\xE7\xBF\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\x9F"],
        ["\xE8\x80\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x69"],
        ["\xE8\x80\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],
        ["\xE8\x80\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],
        ["\xE8\x80\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],
        ["\xE8\x80\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],
        ["\xE8\x80\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],
        ["\xE8\x80\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],
        ["\xE8\x80\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB4"],
        ["\xE8\x80\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],
        ["\xE8\x81\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x6B"],
        ["\xE8\x81\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],
        ["\xE8\x81\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],
        ["\xE8\x81\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],
        ["\xE8\x81\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x6C"],
        ["\xE8\x82\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x6D"],
        ["\xE8\x82\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],
        ["\xE8\x82\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x6E"],
        ["\xE8\x82\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xCC"],
        ["\xE8\x82\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xCE"],
        ["\xF0\xA6\x99\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x72"],
        ["\xE8\x83\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x6F"],
        ["\xE8\x83\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],
        ["\xE8\x83\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],
        ["\xE8\x83\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x71"],
        ["\xF0\xA6\x9A\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x75"],
        ["\xE8\x84\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x77"],
        ["\xE8\x83\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x73"],
        ["\xE8\x83\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x74"],
        ["\xE4\x8F\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x76"],
        ["\xE8\x84\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xEE"],
        ["\xE8\x84\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],
        ["\xE8\x84\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],
        ["\xE4\x8F\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x78"],
        ["\xE8\x84\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xEA"],
        ["\xE8\x84\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],
        ["\xE8\x84\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xEC"],
        ["\xF0\xA6\x9C\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x7B"],
        ["\xE8\x84\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x79"],
        ["\xE4\x90\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x7A"],
        ["\xE8\x85\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],
        ["\xE4\x90\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x7C"],
        ["\xE8\x86\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x41"],
        ["\xE4\x90\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x7D"],
        ["\xE8\x86\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x42"],
        ["\xE8\x86\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x43"],
        ["\xE4\x90\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x7E"],
        ["\xE8\x86\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x49"],
        ["\xE8\x86\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x4E"],
        ["\xE8\x87\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x7F"],
        ["\xE8\x87\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x51"],
        ["\xE8\x87\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x80"],
        ["\xE8\x87\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x59"],
        ["\xF0\xA6\xA3\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x81"],
        ["\xE8\x87\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x5D"],
        ["\xF0\xA6\xA3\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x82"],
        ["\xE8\x87\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x5F"],
        ["\xF0\xA6\xA5\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x85"],
        ["\xE8\x87\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x67"],
        ["\xE8\x87\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x68"],
        ["\xF0\xA6\xA5\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x86"],
        ["\xE8\x88\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x87"],
        ["\xF0\xA6\xA7\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x89"],
        ["\xE8\x88\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x6E"],
        ["\xE8\x88\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x71"],
        ["\xE8\x88\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x72"],
        ["\xF0\xA6\xA8\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x8A"],
        ["\xE8\x88\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x74"],
        ["\xE8\x88\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x75"],
        ["\xE8\x88\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x8B"],
        ["\xE8\x89\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x7A"],
        ["\xE8\x89\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x8C"],
        ["\xE8\x89\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x79"],
        ["\xF0\xA6\xA9\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x8E"],
        ["\xE8\x89\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x7B"],
        ["\xE4\x91\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x8D"],
        ["\xE8\x89\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x7D"],
        ["\xE4\x91\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x8F"],
        ["\xE8\x89\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x90"],
        ["\xF0\xA6\xAA\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x91"],
        ["\xE8\x89\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x80"],
        ["\xE8\x89\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x82"],
        ["\xF0\xA6\xAA\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x92"],
        ["\xEF\xA9\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x94"],
        ["\xEF\xA9\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x95"],
        ["\xE8\x89\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x96"],
        ["\xE4\x92\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x93"],
        ["\xE8\x89\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x87"],
        ["\xE8\x89\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x88"],
        ["\xE8\x8A\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x8B"],
        ["\xE8\x8A\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x8F"],
        ["\xE8\x8A\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x98"],
        ["\xE8\x8A\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x9B"],
        ["\xE8\x8A\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\x9C"],
        ["\xE8\x8A\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],
        ["\xE8\x8A\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],
        ["\xE8\x8A\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA4"],
        ["\xE8\x8A\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],
        ["\xE8\x8B\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAD"],
        ["\xE8\x8B\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAF"],
        ["\xE8\x8B\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB4"],
        ["\xE8\x8C\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB8"],
        ["\xE8\x8C\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB9"],
        ["\xE8\x8C\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x99"],
        ["\xE8\x8D\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD3"],
        ["\xE8\x8C\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xBC"],
        ["\xE8\x8C\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xBD"],
        ["\xE8\x8C\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC5"],
        ["\xE8\x8C\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC9"],
        ["\xE8\x8D\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCD"],
        ["\xE8\x8D\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD6"],
        ["\xE4\x92\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x9B"],
        ["\xE4\x93\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x9D"],
        ["\xE4\x92\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\x9A"],
        ["\xE8\x8E\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDE"],
        ["\xE8\x8E\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE0"],
        ["\xE8\x8E\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE1"],
        ["\xE8\x8E\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],
        ["\xE8\x8E\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],
        ["\xE8\x8F\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xEF"],
        ["\xE8\x8F\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF1"],
        ["\xE8\x8F\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF3"],
        ["\xE8\x8F\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF4"],
        ["\xE8\x8F\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA0"],
        ["\xE8\x8F\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF8"],
        ["\xE8\x90\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFD"],
        ["\xE8\x90\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFE"],
        ["\xE8\x90\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x41"],
        ["\xF0\xA6\xB1\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA1"],
        ["\xE8\x90\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],
        ["\xE8\x90\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x44"],
        ["\xE8\x91\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x47"],
        ["\xE8\x91\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x49"],
        ["\xE8\x91\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x4A"],
        ["\xE8\x91\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x4B"],
        ["\xE8\x91\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x4E"],
        ["\xE8\x91\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x4F"],
        ["\xE8\x91\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x50"],
        ["\xF0\xA6\xB3\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],
        ["\xE8\x91\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x53"],
        ["\xE8\x91\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x59"],
        ["\xE8\x91\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x5A"],
        ["\xE8\x91\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x5B"],
        ["\xE8\x92\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x5D"],
        ["\xE4\x94\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],
        ["\xE8\x92\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA6"],
        ["\xE8\x92\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x63"],
        ["\xE8\x92\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x6B"],
        ["\xE4\x94\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA7"],
        ["\xE8\x93\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],
        ["\xE8\x93\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x71"],
        ["\xE8\x93\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x72"],
        ["\xF0\xA6\xB9\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],
        ["\xE8\x93\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x73"],
        ["\xE8\x93\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x74"],
        ["\xE8\x93\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x75"],
        ["\xE8\x93\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x76"],
        ["\xE8\x93\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x77"],
        ["\xE8\x93\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x7A"],
        ["\xE8\x93\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x7C"],
        ["\xE8\x94\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x80"],
        ["\xE8\x94\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAA"],
        ["\xE8\x94\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x87"],
        ["\xE8\x94\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x88"],
        ["\xE8\x94\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x8B"],
        ["\xE8\x94\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x8F"],
        ["\xE8\x95\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x93"],
        ["\xE8\x95\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA0"],
        ["\xE4\x94\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],
        ["\xE4\x95\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAF"],
        ["\xE8\x94\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],
        ["\xE8\x95\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x95"],
        ["\xE8\x95\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x9A"],
        ["\xE8\x95\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x9D"],
        ["\xE8\x95\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\x9E"],
        ["\xF0\xA6\xBE\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB0"],
        ["\xE8\x95\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA3"],
        ["\xE8\x95\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA4"],
        ["\xE8\x95\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],
        ["\xE8\x96\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],
        ["\xE8\x96\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],
        ["\xE8\x96\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAD"],
        ["\xE8\x96\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAF"],
        ["\xE8\x96\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB0"],
        ["\xF0\xA6\xBF\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],
        ["\xF0\xA6\xBF\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB1"],
        ["\xF0\xA6\xBF\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],
        ["\xE8\x96\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB8"],
        ["\xE8\x96\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xBA"],
        ["\xE8\x97\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xBF"],
        ["\xE8\x97\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC0"],
        ["\xE8\x97\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC3"],
        ["\xE8\x97\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],
        ["\xE8\x97\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC5"],
        ["\xE8\x97\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB5"],
        ["\xE8\x97\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC7"],
        ["\xE8\x97\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCB"],
        ["\xE8\x98\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],
        ["\xE8\x98\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],
        ["\xE8\x98\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD9"],
        ["\xE8\x98\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDA"],
        ["\xE8\x98\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB6"],
        ["\xE8\x98\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDB"],
        ["\xF0\xA7\x84\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB8"],
        ["\xE8\x98\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB9"],
        ["\xE8\x98\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE0"],
        ["\xF0\xA7\x84\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBA"],
        ["\xE8\x99\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE2"],
        ["\xE8\x99\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE7"],
        ["\xE8\x99\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE8"],
        ["\xE8\x99\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF4"],
        ["\xE8\x99\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],
        ["\xE8\x99\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],
        ["\xE8\x9A\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],
        ["\xE8\x9A\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBF"],
        ["\xE8\x9A\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xFA"],
        ["\xE8\x9A\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],
        ["\xE8\x9A\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x41"],
        ["\xE8\x9A\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],
        ["\xE8\x9A\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x45"],
        ["\xE8\x9A\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x47"],
        ["\xE8\x9A\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x48"],
        ["\xE8\x9B\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x50"],
        ["\xE8\x9B\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x51"],
        ["\xE8\x9B\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x53"],
        ["\xE8\x9B\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x55"],
        ["\xE8\x9B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x56"],
        ["\xE8\x9B\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x5A"],
        ["\xE8\x9B\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],
        ["\xE4\x96\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC2"],
        ["\xE8\x9C\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x61"],
        ["\xE8\x9C\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x62"],
        ["\xE8\x9C\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x64"],
        ["\xE8\x9C\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x66"],
        ["\xE8\x9C\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x67"],
        ["\xE8\x9C\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x69"],
        ["\xE8\x9C\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x6B"],
        ["\xE8\x9C\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x6C"],
        ["\xE8\x9C\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x6D"],
        ["\xE8\x9C\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x71"],
        ["\xE8\x9C\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x74"],
        ["\xE8\x9C\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x77"],
        ["\xE8\x9D\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x78"],
        ["\xE8\x9D\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x79"],
        ["\xE8\x9D\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC3"],
        ["\xE8\x9D\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x7C"],
        ["\xE8\x9D\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x7F"],
        ["\xE8\x9D\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x80"],
        ["\xE8\x9D\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x83"],
        ["\xE8\x9D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC4"],
        ["\xF0\xA7\x8F\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"],
        ["\xF0\xA7\x8F\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC5"],
        ["\xE8\x9E\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x97"],
        ["\xE8\x9E\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x8B"],
        ["\xE8\x9E\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x8C"],
        ["\xE8\x9E\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x8F"],
        ["\xE8\x9E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x95"],
        ["\xF0\xA7\x8F\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC7"],
        ["\xE4\x97\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC8"],
        ["\xE8\x9E\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x9D"],
        ["\xF0\xA7\x90\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC9"],
        ["\xE8\x9F\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\x9F"],
        ["\xE8\x9F\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA3"],
        ["\xE8\x9F\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],
        ["\xE8\x9F\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],
        ["\xF0\xA7\x91\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCB"],
        ["\xE8\x9F\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAB"],
        ["\xE8\x9F\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],
        ["\xE8\x9F\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCD"],
        ["\xE8\x9F\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAD"],
        ["\xE8\x9F\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAE"],
        ["\xE8\x9F\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],
        ["\xE8\xA0\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB5"],
        ["\xE8\xA0\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],
        ["\xE8\xA0\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],
        ["\xE8\xA0\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],
        ["\xE8\xA0\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC6"],
        ["\xE8\xA0\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC8"],
        ["\xE8\xA0\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],
        ["\xE8\xA0\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xCD"],
        ["\xE4\x98\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],
        ["\xE8\xA1\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD3"],
        ["\xE8\xA1\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],
        ["\xE8\xA1\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDC"],
        ["\xE8\xA1\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDE"],
        ["\xF0\xA7\x98\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],
        ["\xF0\xA7\x98\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD1"],
        ["\xE8\xA1\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDF"],
        ["\xF0\xA7\x98\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD4"],
        ["\xE8\xA1\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],
        ["\xE8\xA2\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],
        ["\xE8\xA2\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD5"],
        ["\xE8\xA2\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],
        ["\xE8\xA2\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],
        ["\xE8\xA3\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xEF"],
        ["\xE8\xA3\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF6"],
        ["\xF0\xA7\x9A\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD7"],
        ["\xE8\xA3\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF5"],
        ["\xE8\xA3\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF7"],
        ["\xE8\xA3\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF8"],
        ["\xE8\xA3\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xFC"],
        ["\xE8\xA3\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],
        ["\xE4\x99\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD8"],
        ["\xE8\xA4\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x41"],
        ["\xF0\xA7\x9C\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],
        ["\xE8\xA4\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDB"],
        ["\xF0\xA7\x9C\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDC"],
        ["\xE8\xA5\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x57"],
        ["\xE8\xA5\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x58"],
        ["\xE8\xA5\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x5A"],
        ["\xF0\xA7\x9D\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDD"],
        ["\xE4\x99\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],
        ["\xE8\xA5\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x62"],
        ["\xE8\xA6\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDF"],
        ["\xE8\xA6\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x6D"],
        ["\xE8\xA6\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x6F"],
        ["\xE8\xA6\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x74"],
        ["\xE8\xA6\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x77"],
        ["\xE8\xA6\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x7B"],
        ["\xE8\xA7\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x7F"],
        ["\xE8\xA7\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x81"],
        ["\xE8\xA7\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x84"],
        ["\xE4\x9A\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE1"],
        ["\xE8\xA7\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x86"],
        ["\xE8\xA7\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x87"],
        ["\xE8\xA7\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x8A"],
        ["\xE8\xA7\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x8B"],
        ["\xE4\x9A\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE2"],
        ["\xE8\xA8\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x90"],
        ["\xE8\xA8\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x91"],
        ["\xF0\xA7\xA6\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE4"],
        ["\xE8\xA8\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],
        ["\xE8\xA8\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x9B"],
        ["\xE8\xA8\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\x9D"],
        ["\xE8\xA9\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA0"],
        ["\xE8\xA9\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA3"],
        ["\xE8\xA9\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA8"],
        ["\xE8\xAA\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC1"],
        ["\xE8\xAA\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],
        ["\xE8\xAA\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC5"],
        ["\xE8\xAB\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD0"],
        ["\xE8\xAB\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],
        ["\xF0\xA7\xAA\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],
        ["\xE8\xAC\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"],
        ["\xE8\xAC\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],
        ["\xE8\xAC\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE8"],
        ["\xE8\xAC\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],
        ["\xE8\xAC\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xDF"],
        ["\xE8\xAC\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],
        ["\xE8\xAD\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],
        ["\xE4\x9C\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEA"],
        ["\xE8\xAD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],
        ["\xE8\xAD\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xEE"],
        ["\xE8\xAD\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF1"],
        ["\xE8\xAE\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF6"],
        ["\xE8\xAE\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF9"],
        ["\xE8\xAE\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],
        ["\xE8\xAE\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xFD"],
        ["\xE8\xAE\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],
        ["\xE8\xAE\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x41"],
        ["\xE8\xB0\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x44"],
        ["\xF0\xA7\xAE\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],
        ["\xE8\xB0\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x45"],
        ["\xF0\xA7\xAE\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEF"],
        ["\xF0\xA7\xAF\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF0"],
        ["\xE8\xB1\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x47"],
        ["\xE8\xB1\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x48"],
        ["\xE8\xB1\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x4B"],
        ["\xE8\xB1\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x4E"],
        ["\xE8\xB2\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x68"],
        ["\xE8\xB3\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x71"],
        ["\xE8\xB3\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x70"],
        ["\xE8\xB3\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x72"],
        ["\xF0\xA7\xB6\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],
        ["\xE8\xB3\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],
        ["\xF0\xA7\xB8\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF7"],
        ["\xE8\xB4\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x80"],
        ["\xE8\xB4\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],
        ["\xE8\xB5\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x85"],
        ["\xE8\xB6\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x89"],
        ["\xE8\xB6\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x8E"],
        ["\xE8\xB6\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x92"],
        ["\xF0\xA7\xBE\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF9"],
        ["\xE8\xB7\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\x9E"],
        ["\xE8\xB7\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA0"],
        ["\xE8\xB7\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],
        ["\xE4\x9F\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xFB"],
        ["\xE8\xB7\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB0"],
        ["\xE8\xB8\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],
        ["\xE4\xA0\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],
        ["\xE4\xA1\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x46"],
        ["\xE8\xBF\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\x76"],
        ["\xE9\x81\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\x95"],
        ["\xE9\x81\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\x96"],
        ["\xE4\xA2\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x53"],
        ["\xE9\x83\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],
        ["\xE9\x89\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\x84"],
        ["\xE9\x89\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\x8D"],
        ["\xE9\x8A\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\x9A"],
        ["\xE9\x8A\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\x9F"],
        ["\xE9\x8E\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],
        ["\xE9\x8F\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x6E"],
        ["\xE9\x96\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\x88"],
        ["\xE9\x98\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],
        ["\xE9\x98\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xAF"],
        ["\xE9\x98\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x77"],
        ["\xE9\x98\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB4"],
        ["\xE9\x9A\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],
        ["\xE4\xA7\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x7C"],
        ["\xE4\xA7\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x7F"],
        ["\xE9\x9B\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],
        ["\xE4\xA8\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x81"],
        ["\xE4\xA8\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x84"],
        ["\xE9\x9D\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],
        ["\xE9\x9D\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],
        ["\xE9\x9F\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x5A"],
        ["\xE9\xA0\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x71"],
        ["\xE9\xA0\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x73"],
        ["\xE9\xA0\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x74"],
        ["\xE4\xAA\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x8B"],
        ["\xE9\xA0\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\x79"],
        ["\xE4\xAC\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x97"],
        ["\xE9\xA4\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB1"],
        ["\xE9\xA5\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xCD"],
        ["\xE9\xA6\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x9B"],
        ["\xE9\xA7\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],
        ["\xE9\xA7\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x9D"],
        ["\xE9\xA8\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],
        ["\xE9\xA8\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\x9F"],
        ["\xE9\xA8\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],
        ["\xE9\xA8\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA0"],
        ["\xE9\xA8\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xFE"],
        ["\xE9\xA9\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x43"],
        ["\xE9\xA9\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x47"],
        ["\xE9\xA9\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA2"],
        ["\xE4\xAF\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],
        ["\xE9\xAA\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x4F"],
        ["\xE4\xAF\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA4"],
        ["\xE9\xAA\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA5"],
        ["\xE4\xAF\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],
        ["\xE9\xAA\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x54"],
        ["\xE9\xAB\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x5A"],
        ["\xE9\xAB\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x5D"],
        ["\xE9\xAB\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x5E"],
        ["\xE9\xAB\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x5F"],
        ["\xE4\xAF\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],
        ["\xE9\xAB\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x63"],
        ["\xE9\xAB\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x65"],
        ["\xE9\xAB\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x67"],
        ["\xE9\xAC\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x73"],
        ["\xE9\xAC\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x79"],
        ["\xE9\xAC\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x7C"],
        ["\xE9\xAC\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x7D"],
        ["\xE9\xAC\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x7E"],
        ["\xE9\xAC\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x81"],
        ["\xE9\xAC\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x84"],
        ["\xE9\xAC\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x86"],
        ["\xE9\xAC\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x8C"],
        ["\xE4\xB0\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAA"],
        ["\xE9\xAD\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x8E"],
        ["\xE9\xAD\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x96"],
        ["\xE9\xAD\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x97"],
        ["\xE9\xAD\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x9B"],
        ["\xE9\xAD\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x9C"],
        ["\xE9\xAD\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\x9F"],
        ["\xE9\xAD\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],
        ["\xE9\xAD\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA0"],
        ["\xE9\xAE\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB2"],
        ["\xE9\xAE\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB5"],
        ["\xF0\xA9\xB7\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAC"],
        ["\xF0\xA9\xB8\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],
        ["\xE9\xAE\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB7"],
        ["\xE9\xAE\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],
        ["\xE9\xAE\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBB"],
        ["\xE9\xAF\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBE"],
        ["\xE9\xAF\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],
        ["\xE9\xAF\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],
        ["\xE9\xAF\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],
        ["\xE9\xAF\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],
        ["\xE9\xAF\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],
        ["\xE9\xAF\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],
        ["\xE9\xAF\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCA"],
        ["\xE9\xAF\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAD"],
        ["\xF0\xA9\xB8\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],
        ["\xE9\xAF\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCF"],
        ["\xF0\xA9\xBA\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],
        ["\xE9\xAF\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCC"],
        ["\xF0\xA9\xB9\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB0"],
        ["\xE9\xB0\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],
        ["\xE9\xB0\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],
        ["\xE9\xB0\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],
        ["\xE9\xB0\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],
        ["\xE9\xB0\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB1"],
        ["\xE9\xB0\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],
        ["\xE9\xB0\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDF"],
        ["\xE9\xB0\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],
        ["\xE9\xB0\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],
        ["\xF0\xA9\xBB\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],
        ["\xE9\xB0\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],
        ["\xE9\xB0\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],
        ["\xE9\xB0\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],
        ["\xE9\xB1\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],
        ["\xE9\xB1\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],
        ["\xF0\xA9\xBB\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB5"],
        ["\xE9\xB1\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xEC"],
        ["\xE9\xB1\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xED"],
        ["\xF0\xA9\xBB\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],
        ["\xE9\xB1\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],
        ["\xE9\xB1\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],
        ["\xE9\xB1\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],
        ["\xE9\xB1\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],
        ["\xE9\xB1\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],
        ["\xE9\xB1\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],
        ["\xE9\xB1\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],
        ["\xE9\xB1\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xFE"],
        ["\xE9\xB1\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],
        ["\xE9\xB1\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x41"],
        ["\xE9\xB1\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x42"],
        ["\xE9\xB1\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x43"],
        ["\xE9\xB1\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x44"],
        ["\xE9\xB1\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],
        ["\xE9\xB3\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x47"],
        ["\xE9\xB3\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x48"],
        ["\xE9\xB4\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x4C"],
        ["\xE9\xB4\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x4B"],
        ["\xF0\xA9\xBF\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB9"],
        ["\xE9\xB4\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x4D"],
        ["\xE9\xB4\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x4E"],
        ["\xE9\xB4\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x4F"],
        ["\xF0\xAA\x80\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBD"],
        ["\xE4\xB3\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],
        ["\xF0\xAA\x80\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBB"],
        ["\xE9\xB4\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x55"],
        ["\xE4\xB3\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBC"],
        ["\xE9\xB5\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x5B"],
        ["\xE9\xB5\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x5F"],
        ["\xE9\xB5\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x62"],
        ["\xE9\xB5\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x63"],
        ["\xF0\xAA\x83\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC2"],
        ["\xE9\xB5\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x66"],
        ["\xF0\xAA\x82\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBF"],
        ["\xE9\xB5\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC0"],
        ["\xE9\xB5\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x68"],
        ["\xE9\xB5\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x69"],
        ["\xE9\xB5\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x6C"],
        ["\xE9\xB6\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x6E"],
        ["\xE9\xB6\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x71"],
        ["\xE9\xB6\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC1"],
        ["\xE9\xB6\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x79"],
        ["\xE9\xB6\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x81"],
        ["\xE9\xB6\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x7E"],
        ["\xE9\xB6\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x7F"],
        ["\xE9\xB6\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC3"],
        ["\xE9\xB7\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x82"],
        ["\xE9\xB7\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x83"],
        ["\xE9\xB7\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x84"],
        ["\xE9\xB7\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x88"],
        ["\xE9\xB7\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x8A"],
        ["\xE9\xB7\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x8C"],
        ["\xE9\xB7\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x8D"],
        ["\xE9\xB7\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC5"],
        ["\xE9\xB7\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x95"],
        ["\xE4\xB4\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC7"],
        ["\xE9\xB8\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x99"],
        ["\xE9\xB8\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\x97"],
        ["\xE9\xB8\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC8"],
        ["\xE9\xB8\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA0"],
        ["\xE9\xB8\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],
        ["\xE9\xB9\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],
        ["\xF0\xA2\x88\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\x52"],
        ["\xE9\xBA\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA5"],
        ["\xE9\xBA\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA9"],
        ["\xE9\xBA\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xAF"],
        ["\xE9\xBA\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB2"],
        ["\xF0\xAA\x8E\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC9"],
        ["\xE9\xBA\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCA"],
        ["\xF0\xAA\x90\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCC"],
        ["\xE9\xBB\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xBE"],
        ["\xE9\xBB\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],
        ["\xE9\xBB\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],
        ["\xE9\xBB\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],
        ["\xE9\xBC\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCA"],
        ["\xE4\xB5\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCD"],
        ["\xE9\xBC\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCB"],
        ["\xE9\xBC\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],
        ["\xE9\xBC\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],
        ["\xE9\xBC\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],
        ["\xE9\xBC\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],
        ["\xE9\xBC\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],
        ["\xE9\xBC\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],
        ["\xE9\xBD\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],
        ["\xE9\xBD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],
        ["\xE9\xBD\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xEA"],
        ["\xE9\xBD\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xEC"],
        ["\xE9\xBD\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xED"],
        ["\xE9\xBD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],
        ["\xF0\xAA\x97\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],
        ["\xE9\xBD\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],
        ["\xF0\xAA\x98\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],
        ["\xE9\xBD\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],
        ["\xF0\xAA\x98\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD0"],
        ["\xE9\xBD\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],
        ["\xE9\xBD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],
        ["\xE9\xBD\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],
        ["\xF0\xAA\x9A\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD1"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e::RoundTrip;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::RoundTrip::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
