# Generated by default/object.tt
package Paws::CodeArtifact::UpstreamRepository;
  use Moose;
  has RepositoryName => (is => 'ro', isa => 'Str', request_name => 'repositoryName', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeArtifact::UpstreamRepository

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeArtifact::UpstreamRepository object:

  $service_obj->Method(Att1 => { RepositoryName => $value, ..., RepositoryName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeArtifact::UpstreamRepository object:

  $result = $service_obj->Method(...);
  $result->Att1->RepositoryName

=head1 DESCRIPTION

Information about an upstream repository. A list of
C<UpstreamRepository> objects is an input parameter to CreateRepository
(https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_CreateRepository.html)
and UpdateRepository
(https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdateRepository.html).

=head1 ATTRIBUTES


=head2 B<REQUIRED> RepositoryName => Str

The name of an upstream repository.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeArtifact>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

