#ABSTRACT: Patrons Account Information API command line client
package App::PAIA;
use strict;
use v5.10;
use parent 'App::Cmd';
our $VERSION = '0.27'; #VERSION

sub global_opt_spec {
    ['base|b=s'     => "base URL of PAIA server"],
    ['auth=s'       => "base URL of PAIA auth server"],
    ['core=s'       => "base URL of PAIA core server"],
    ['insecure|k'   => "disable verification of SSL certificates"],
    ['config|c=s'   => "configuration file (default: ./paia.json)"],
    ['session|s=s'  => "session file (default: ./paia-session.json)"],
    ['verbose|v'    => "show what's going on internally"],
    ['debug|D|V'    => "show full HTTP requests and responses"],
    ['quiet|q'      => "don't print PAIA response"],
    ["username|u=s" => "username for login"],
    ["password|p=s" => "password for login"],
    ['access_token|token|t=s' => "explicit access_token"],
    ["patron|o=s"   => "explicit patron identifier"],
    ["scope|e=s"    => "comma-separated list of scopes for login"],
    ["help|h|?"     => "show help", { shortcircuit => 1 } ],
    ["version"      => "show client version", { shortcircuit => 1 } ];
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::PAIA - Patrons Account Information API command line client

=head1 VERSION

version 0.27

=head1 SYNOPSIS

    paia patron --base http://example.org/ --username alice --password 12345

Run C<paia help> or C<perldoc paia> for more commands and options.

=head1 DESCRIPTION

The L<Patrons Account Information API (PAIA)|http://gbv.github.io/paia/> is a
HTTP based API to access library patron information, such as loans,
reservations, and fees. This client can be used to access PAIA servers via
command line.

=head1 USAGE

See the documentation of of L<paia> command.

To avoid SSL errors install L<Mozilla::CA> or use option C<--insecure>.

=head1 IMPLEMENTATION

The client is implemented using L<App::Cmd>. There is a module for each command
in the App::PAIA::Command:: namespace and common functionality implemented in
L<App::PAIA::Command>.

=head1 RESOURCES

=over

=item L<http://gbv.github.io/paia/>

PAIA specification

=item L<https://github.com/gbv/App-PAIA>

Code repository and issue tracker

=back

=head1 AUTHOR

Jakob Voß

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Jakob Voß.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
