/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sis.internal.util.StreamWriterDelegate;
import org.apache.sis.xml.FilterVersion;
import org.apache.sis.xml.FilteredNamespaces;

final class FilteredStreamWriter
extends StreamWriterDelegate {
    private final FilterVersion version;

    FilteredStreamWriter(XMLStreamWriter xMLStreamWriter, FilterVersion filterVersion) {
        super(xMLStreamWriter);
        this.version = filterVersion;
    }

    private String toView(String string) {
        String string2 = this.version.toView.get(string);
        return string2 != null ? string2 : string;
    }

    @Override
    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.out.writeStartElement(this.toView(string), string2);
    }

    @Override
    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.out.writeStartElement(string, string2, this.toView(string3));
    }

    @Override
    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.out.writeEmptyElement(this.toView(string), string2);
    }

    @Override
    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.out.writeEmptyElement(string, string2, this.toView(string3));
    }

    @Override
    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        this.out.writeAttribute(string, this.toView(string2), string3, string4);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        this.out.writeAttribute(this.toView(string), string2, string3);
    }

    @Override
    public void writeNamespace(String string, String string2) throws XMLStreamException {
        this.out.writeNamespace(string, this.toView(string2));
    }

    @Override
    public void writeDefaultNamespace(String string) throws XMLStreamException {
        this.out.writeDefaultNamespace(this.toView(string));
    }

    @Override
    public String getPrefix(String string) throws XMLStreamException {
        return this.out.getPrefix(this.toView(string));
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        this.out.setPrefix(string, this.toView(string2));
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.out.setDefaultNamespace(this.toView(string));
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        namespaceContext = namespaceContext instanceof FilteredNamespaces ? ((FilteredNamespaces)namespaceContext).inverse(this.version) : new FilteredNamespaces(namespaceContext, this.version, true);
        this.out.setNamespaceContext(namespaceContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return new FilteredNamespaces(this.out.getNamespaceContext(), this.version, false);
    }
}

