/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.util;

public class ClassLoaderUtil {
    public static <T> T buildClass(Class<T> iface, String className) {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        try {
            Class<?> clazz = loader.loadClass(className);
            if (iface.isAssignableFrom(clazz)) {
                return (T)clazz.newInstance();
            }
            throw new IllegalArgumentException(iface.toString() + " is not assignable from " + className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

