/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;
import org.apache.pdfbox.util.operator.SetNonStrokingCMYKColor;
import org.apache.pdfbox.util.operator.SetNonStrokingCalRGBColor;
import org.apache.pdfbox.util.operator.SetNonStrokingGrayColor;
import org.apache.pdfbox.util.operator.SetNonStrokingICCBasedColor;
import org.apache.pdfbox.util.operator.SetNonStrokingRGBColor;
import org.apache.pdfbox.util.operator.SetNonStrokingSeparation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetNonStrokingColor
extends OperatorProcessor {
    private static final Log log = LogFactory.getLog(SetNonStrokingColor.class);

    @Override
    public void process(PDFOperator operator, List<COSBase> arguments) throws IOException {
        PDColorSpace colorSpace = this.context.getGraphicsState().getNonStrokingColor().getColorSpace();
        if (colorSpace != null) {
            OperatorProcessor newOperator = null;
            if (colorSpace instanceof PDDeviceGray) {
                newOperator = new SetNonStrokingGrayColor();
            } else if (colorSpace instanceof PDDeviceRGB) {
                newOperator = new SetNonStrokingRGBColor();
            } else if (colorSpace instanceof PDDeviceCMYK) {
                newOperator = new SetNonStrokingCMYKColor();
            } else if (colorSpace instanceof PDICCBased) {
                newOperator = new SetNonStrokingICCBasedColor();
            } else if (colorSpace instanceof PDCalRGB) {
                newOperator = new SetNonStrokingCalRGBColor();
            } else if (colorSpace instanceof PDSeparation) {
                newOperator = new SetNonStrokingSeparation();
            }
            if (newOperator != null) {
                newOperator.setContext(this.getContext());
                ((OperatorProcessor)newOperator).process(operator, arguments);
            } else {
                log.warn((Object)("Not supported colorspace " + colorSpace.getName() + " within operator " + operator.getOperation()));
            }
        } else {
            log.warn((Object)("Colorspace not found in " + this.getClass().getName() + ".process!!"));
        }
    }
}

