/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.sis.util.resources.Errors;

public class Cloner {
    private Class<?> type;
    private Method method;

    protected boolean isCloneRequired(Object object) {
        return true;
    }

    public Object clone(Object object) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        SecurityException securityException = null;
        Class<?> clazz = object.getClass();
        try {
            if (clazz != this.type) {
                this.method = clazz.getMethod("clone", null);
                this.type = clazz;
                if (!Modifier.isPublic(this.method.getDeclaringClass().getModifiers())) {
                    try {
                        this.method.setAccessible(true);
                    }
                    catch (SecurityException securityException2) {
                        securityException = securityException2;
                    }
                }
            }
            if (this.method != null) {
                return this.method.invoke(object, (Object[])null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (this.isCloneRequired(object)) {
                throw Cloner.fail(noSuchMethodException, clazz);
            }
            this.method = null;
            this.type = clazz;
        }
        catch (IllegalAccessException illegalAccessException) {
            if (securityException != null) {
                illegalAccessException.addSuppressed(securityException);
            }
            throw Cloner.fail(illegalAccessException, clazz);
        }
        catch (InvocationTargetException invocationTargetException) {
            Cloner.rethrow(invocationTargetException.getCause());
            throw Cloner.fail(invocationTargetException, clazz);
        }
        catch (SecurityException securityException3) {
            throw Cloner.fail(securityException3, clazz);
        }
        return object;
    }

    private static void rethrow(Throwable throwable) throws CloneNotSupportedException {
        if (throwable instanceof CloneNotSupportedException) {
            throw (CloneNotSupportedException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    private static CloneNotSupportedException fail(Throwable throwable, Class<?> clazz) {
        return (CloneNotSupportedException)new CloneNotSupportedException(Errors.format((short)20, clazz)).initCause(throwable);
    }

    public static Object cloneIfPublic(Object object) throws CloneNotSupportedException {
        if (object != null) {
            Class<?> clazz = object.getClass();
            try {
                Method method = clazz.getMethod("clone", null);
                if (Modifier.isPublic(method.getModifiers())) {
                    return method.invoke(object, (Object[])null);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new AssertionError((Object)reflectiveOperationException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Cloner.rethrow(invocationTargetException.getCause());
                throw Cloner.fail(invocationTargetException, clazz);
            }
            catch (SecurityException securityException) {
                throw Cloner.fail(securityException, clazz);
            }
        }
        return object;
    }
}

