package Net::StackExchange::Comments;
BEGIN {
  $Net::StackExchange::Comments::VERSION = '0.102601';
}

# ABSTRACT: Provides accessors for a comment

use Moose;

has 'comment_id' => (
    is       => 'ro',
    isa      => 'Int',
    required => 1,
);

has 'creation_date' => (
    is       => 'ro',
    isa      => 'Int',
    required => 1,
);

has 'owner' => (
    is       => 'rw'
    isa      => 'Net::StackExchange::Owner',
    required => 1,
);

has 'last_edit_date' => (
    is  => 'ro',
    isa => 'Int',
);

has 'last_activity_date' => (
    is  => 'ro',
    isa => 'Int',
);

has 'up_vote_count' => (
    is       => 'ro',
    isa      => 'Int',
    required => 1,
);

has 'down_vote_count' => (
    is       => 'ro',
    isa      => 'Int',
    required => 1,
);

has 'view_count' => (
    is       => 'ro',
    isa      => 'Int',
    required => 1,
);

has 'score' => (
    is       => 'ro',
    isa      => 'Int',
    required => 1,
);

has 'community_owned' => (
    is       => 'ro',
    isa      => 'Boolean',
    required => 1,
    coerce   => 1,
);

has 'title' => (
    is       => 'ro',
    isa      => 'Str',
    required => 1,
);

has 'body' => (
    is  => 'ro',
    isa => 'Str',
);

has 'comments' => (
    is  => 'ro',
    isa => 'ArrayRef[Net::StackExchange::Comments]',
);

has '_NSE' => (
    is       => 'ro',
    isa      => 'Net::StackExchange',
    required => 1,
);

__PACKAGE__->meta()->make_immutable();

no Moose;

1;



=pod

=head1 NAME

Net::StackExchange::Comments - Provides accessors for a comment

=head1 VERSION

version 0.102601

=head1 SYNOPSIS

    use Net::StackExchange;

    my $se = Net::StackExchange->new( {
        'network' => 'stackoverflow.com',
        'version' => '1.0',
    } );

    my $answers_route   = $se->route('answers');
    my $answers_request = $answers_route->prepare_request( { 'id' => '1036353' } );

    $answers_request->body(1);

    my $answers_response = $answers_request ->execute( );
    my $answer           = $answers_response->answers(0);

    print "__Answer__\n";
    print "Title: ", $answer->title(), "\n";
    print "Body: ",  $answer->body (), "\n";

=head1 ATTRIBUTES

=head2 C<answer_id>

Returns id of the answer.

=head2 C<accepted>

Returns whether this answer is the accepted answer on its question.

=head2 C<answer_comments_url>

Returns a link to the method that returns comments on this answer.

=head2 C<question_id>

Returns id of the question this post is or is on.

=head2 C<locked_date>

Returns date this question was locked.

=head2 C<owner>

Returns a L<Net::StackExchange::Owner> object.

=head2 C<creation_date>

Returns date this post was created.

=head2 C<last_edit_date>

Returns last time this post was edited.

=head2 C<last_activity_date>

Returns last time this post had any activity.

=head2 C<up_vote_count>

Returns number of up votes on this post.

=head2 C<down_vote_count>

Returns number of down votes on this post.

=head2 C<view_count>

Returns number of times this post has been viewed.

=head2 C<score>

Returns score of this post.

=head2 C<community_owned>

Returns whether this post is community owned.

=head2 C<title>

Returns title of this post, in plaintext.

=head2 C<body>

Returns body of this post, rendered as HTML.

=head2 C<comments>

Returns a L<Net::StackExchange::Comments> object.

=head1 AUTHOR

Alan Haggai Alavi <alanhaggai@alanhaggai.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2010 by Alan Haggai Alavi.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut


__END__

