// This file is generated by kconfig_compiler_kf6 from easyeffects_db_gate.kcfg.
// All changes you do to this file will be lost.
#ifndef DB_GATE_H
#define DB_GATE_H

#include "kconfig_base_ee.hpp"

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

namespace db {

class Gate : public KConfigBaseEE
{
  Q_OBJECT
  public:

    Gate( const QString & masterGroup, const QString & instanceIndex );
    ~Gate() override;

    /**
      Set bypass
    */
    void setBypass( bool v )
    {
      if (v != mBypass && !isBypassImmutable()) {
        mBypass = v;
        Q_EMIT bypassChanged();
      }
    }

    Q_PROPERTY(bool bypass READ bypass WRITE setBypass NOTIFY bypassChanged)
    Q_PROPERTY(bool isBypassImmutable READ isBypassImmutable CONSTANT)
    Q_PROPERTY(bool defaultBypassValue READ defaultBypassValue CONSTANT)
    /**
      Get bypass
    */
    bool bypass() const
    {
      return mBypass;
    }

    /**
      Is bypass Immutable
    */
    bool isBypassImmutable() const
    {
      return isImmutable( QStringLiteral( "bypass" ) );
    }

    /**
      Get bypass default value
    */
    bool defaultBypassValue() const
    {
        return defaultBypassValue_helper();
    }

    /**
      Set inputGain
    */
    void setInputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setInputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setInputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mInputGain && !isInputGainImmutable()) {
        mInputGain = v;
        Q_EMIT inputGainChanged();
      }
    }

    Q_PROPERTY(double inputGain READ inputGain WRITE setInputGain NOTIFY inputGainChanged)
    Q_PROPERTY(bool isInputGainImmutable READ isInputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultInputGainValue READ defaultInputGainValue CONSTANT)
    /**
      Get inputGain
    */
    double inputGain() const
    {
      return mInputGain;
    }

    /**
      Is inputGain Immutable
    */
    bool isInputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "inputGain" ) );
    }

    /**
      Get inputGain default value
    */
    double defaultInputGainValue() const
    {
        return defaultInputGainValue_helper();
    }

    /**
      Set outputGain
    */
    void setOutputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setOutputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setOutputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mOutputGain && !isOutputGainImmutable()) {
        mOutputGain = v;
        Q_EMIT outputGainChanged();
      }
    }

    Q_PROPERTY(double outputGain READ outputGain WRITE setOutputGain NOTIFY outputGainChanged)
    Q_PROPERTY(bool isOutputGainImmutable READ isOutputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultOutputGainValue READ defaultOutputGainValue CONSTANT)
    /**
      Get outputGain
    */
    double outputGain() const
    {
      return mOutputGain;
    }

    /**
      Is outputGain Immutable
    */
    bool isOutputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "outputGain" ) );
    }

    /**
      Get outputGain default value
    */
    double defaultOutputGainValue() const
    {
        return defaultOutputGainValue_helper();
    }

    /**
      Set dry
    */
    void setDry( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setDry: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 20)
      {
        qDebug() << "setDry: value " << v << " is greater than the maximum value of 20";
        v = 20;
      }

      if (v != mDry && !isDryImmutable()) {
        mDry = v;
        Q_EMIT dryChanged();
      }
    }

    Q_PROPERTY(double dry READ dry WRITE setDry NOTIFY dryChanged)
    Q_PROPERTY(bool isDryImmutable READ isDryImmutable CONSTANT)
    Q_PROPERTY(double defaultDryValue READ defaultDryValue CONSTANT)
    /**
      Get dry
    */
    double dry() const
    {
      return mDry;
    }

    /**
      Is dry Immutable
    */
    bool isDryImmutable() const
    {
      return isImmutable( QStringLiteral( "dry" ) );
    }

    /**
      Get dry default value
    */
    double defaultDryValue() const
    {
        return defaultDryValue_helper();
    }

    /**
      Set wet
    */
    void setWet( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setWet: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 20)
      {
        qDebug() << "setWet: value " << v << " is greater than the maximum value of 20";
        v = 20;
      }

      if (v != mWet && !isWetImmutable()) {
        mWet = v;
        Q_EMIT wetChanged();
      }
    }

    Q_PROPERTY(double wet READ wet WRITE setWet NOTIFY wetChanged)
    Q_PROPERTY(bool isWetImmutable READ isWetImmutable CONSTANT)
    Q_PROPERTY(double defaultWetValue READ defaultWetValue CONSTANT)
    /**
      Get wet
    */
    double wet() const
    {
      return mWet;
    }

    /**
      Is wet Immutable
    */
    bool isWetImmutable() const
    {
      return isImmutable( QStringLiteral( "wet" ) );
    }

    /**
      Get wet default value
    */
    double defaultWetValue() const
    {
        return defaultWetValue_helper();
    }

    /**
      Set modeLabels
    */
    void setModeLabels( const QStringList & v )
    {
      if (v != mModeLabels && !isModeLabelsImmutable()) {
        mModeLabels = v;
        Q_EMIT modeLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList modeLabels READ modeLabels WRITE setModeLabels NOTIFY modeLabelsChanged)
    Q_PROPERTY(bool isModeLabelsImmutable READ isModeLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultModeLabelsValue READ defaultModeLabelsValue CONSTANT)
    /**
      Get modeLabels
    */
    QStringList modeLabels() const
    {
      return mModeLabels;
    }

    /**
      Is modeLabels Immutable
    */
    bool isModeLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "modeLabels" ) );
    }

    /**
      Get modeLabels default value
    */
    QStringList defaultModeLabelsValue() const
    {
        return defaultModeLabelsValue_helper();
    }

    /**
      Set Mode
    */
    void setMode( int v )
    {
      if (v != mMode && !isModeImmutable()) {
        mMode = v;
        Q_EMIT modeChanged();
      }
    }

    Q_PROPERTY(int mode READ mode WRITE setMode NOTIFY modeChanged)
    Q_PROPERTY(bool isModeImmutable READ isModeImmutable CONSTANT)
    Q_PROPERTY(int defaultModeValue READ defaultModeValue CONSTANT)
    /**
      Get Mode
    */
    int mode() const
    {
      return mMode;
    }

    /**
      Is Mode Immutable
    */
    bool isModeImmutable() const
    {
      return isImmutable( QStringLiteral( "mode" ) );
    }

    /**
      Get Mode default value
    */
    int defaultModeValue() const
    {
        return defaultModeValue_helper();
    }

    /**
      Set attack
    */
    void setAttack( double v )
    {
      if (v < 0)
      {
        qDebug() << "setAttack: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 2000)
      {
        qDebug() << "setAttack: value " << v << " is greater than the maximum value of 2000";
        v = 2000;
      }

      if (v != mAttack && !isAttackImmutable()) {
        mAttack = v;
        Q_EMIT attackChanged();
      }
    }

    Q_PROPERTY(double attack READ attack WRITE setAttack NOTIFY attackChanged)
    Q_PROPERTY(bool isAttackImmutable READ isAttackImmutable CONSTANT)
    Q_PROPERTY(double defaultAttackValue READ defaultAttackValue CONSTANT)
    /**
      Get attack
    */
    double attack() const
    {
      return mAttack;
    }

    /**
      Is attack Immutable
    */
    bool isAttackImmutable() const
    {
      return isImmutable( QStringLiteral( "attack" ) );
    }

    /**
      Get attack default value
    */
    double defaultAttackValue() const
    {
        return defaultAttackValue_helper();
    }

    /**
      Set release
    */
    void setRelease( double v )
    {
      if (v < 0)
      {
        qDebug() << "setRelease: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 5000)
      {
        qDebug() << "setRelease: value " << v << " is greater than the maximum value of 5000";
        v = 5000;
      }

      if (v != mRelease && !isReleaseImmutable()) {
        mRelease = v;
        Q_EMIT releaseChanged();
      }
    }

    Q_PROPERTY(double release READ release WRITE setRelease NOTIFY releaseChanged)
    Q_PROPERTY(bool isReleaseImmutable READ isReleaseImmutable CONSTANT)
    Q_PROPERTY(double defaultReleaseValue READ defaultReleaseValue CONSTANT)
    /**
      Get release
    */
    double release() const
    {
      return mRelease;
    }

    /**
      Is release Immutable
    */
    bool isReleaseImmutable() const
    {
      return isImmutable( QStringLiteral( "release" ) );
    }

    /**
      Get release default value
    */
    double defaultReleaseValue() const
    {
        return defaultReleaseValue_helper();
    }

    /**
      Set curveThreshold
    */
    void setCurveThreshold( double v )
    {
      if (v < -60)
      {
        qDebug() << "setCurveThreshold: value " << v << " is less than the minimum value of -60";
        v = -60;
      }

      if (v > 0)
      {
        qDebug() << "setCurveThreshold: value " << v << " is greater than the maximum value of 0";
        v = 0;
      }

      if (v != mCurveThreshold && !isCurveThresholdImmutable()) {
        mCurveThreshold = v;
        Q_EMIT curveThresholdChanged();
      }
    }

    Q_PROPERTY(double curveThreshold READ curveThreshold WRITE setCurveThreshold NOTIFY curveThresholdChanged)
    Q_PROPERTY(bool isCurveThresholdImmutable READ isCurveThresholdImmutable CONSTANT)
    Q_PROPERTY(double defaultCurveThresholdValue READ defaultCurveThresholdValue CONSTANT)
    /**
      Get curveThreshold
    */
    double curveThreshold() const
    {
      return mCurveThreshold;
    }

    /**
      Is curveThreshold Immutable
    */
    bool isCurveThresholdImmutable() const
    {
      return isImmutable( QStringLiteral( "curveThreshold" ) );
    }

    /**
      Get curveThreshold default value
    */
    double defaultCurveThresholdValue() const
    {
        return defaultCurveThresholdValue_helper();
    }

    /**
      Set curveZone
    */
    void setCurveZone( double v )
    {
      if (v < -60)
      {
        qDebug() << "setCurveZone: value " << v << " is less than the minimum value of -60";
        v = -60;
      }

      if (v > 0)
      {
        qDebug() << "setCurveZone: value " << v << " is greater than the maximum value of 0";
        v = 0;
      }

      if (v != mCurveZone && !isCurveZoneImmutable()) {
        mCurveZone = v;
        Q_EMIT curveZoneChanged();
      }
    }

    Q_PROPERTY(double curveZone READ curveZone WRITE setCurveZone NOTIFY curveZoneChanged)
    Q_PROPERTY(bool isCurveZoneImmutable READ isCurveZoneImmutable CONSTANT)
    Q_PROPERTY(double defaultCurveZoneValue READ defaultCurveZoneValue CONSTANT)
    /**
      Get curveZone
    */
    double curveZone() const
    {
      return mCurveZone;
    }

    /**
      Is curveZone Immutable
    */
    bool isCurveZoneImmutable() const
    {
      return isImmutable( QStringLiteral( "curveZone" ) );
    }

    /**
      Get curveZone default value
    */
    double defaultCurveZoneValue() const
    {
        return defaultCurveZoneValue_helper();
    }

    /**
      Set hysteresis
    */
    void setHysteresis( bool v )
    {
      if (v != mHysteresis && !isHysteresisImmutable()) {
        mHysteresis = v;
        Q_EMIT hysteresisChanged();
      }
    }

    Q_PROPERTY(bool hysteresis READ hysteresis WRITE setHysteresis NOTIFY hysteresisChanged)
    Q_PROPERTY(bool isHysteresisImmutable READ isHysteresisImmutable CONSTANT)
    Q_PROPERTY(bool defaultHysteresisValue READ defaultHysteresisValue CONSTANT)
    /**
      Get hysteresis
    */
    bool hysteresis() const
    {
      return mHysteresis;
    }

    /**
      Is hysteresis Immutable
    */
    bool isHysteresisImmutable() const
    {
      return isImmutable( QStringLiteral( "hysteresis" ) );
    }

    /**
      Get hysteresis default value
    */
    bool defaultHysteresisValue() const
    {
        return defaultHysteresisValue_helper();
    }

    /**
      Set hysteresisThreshold
    */
    void setHysteresisThreshold( double v )
    {
      if (v < -60)
      {
        qDebug() << "setHysteresisThreshold: value " << v << " is less than the minimum value of -60";
        v = -60;
      }

      if (v > 0)
      {
        qDebug() << "setHysteresisThreshold: value " << v << " is greater than the maximum value of 0";
        v = 0;
      }

      if (v != mHysteresisThreshold && !isHysteresisThresholdImmutable()) {
        mHysteresisThreshold = v;
        Q_EMIT hysteresisThresholdChanged();
      }
    }

    Q_PROPERTY(double hysteresisThreshold READ hysteresisThreshold WRITE setHysteresisThreshold NOTIFY hysteresisThresholdChanged)
    Q_PROPERTY(bool isHysteresisThresholdImmutable READ isHysteresisThresholdImmutable CONSTANT)
    Q_PROPERTY(double defaultHysteresisThresholdValue READ defaultHysteresisThresholdValue CONSTANT)
    /**
      Get hysteresisThreshold
    */
    double hysteresisThreshold() const
    {
      return mHysteresisThreshold;
    }

    /**
      Is hysteresisThreshold Immutable
    */
    bool isHysteresisThresholdImmutable() const
    {
      return isImmutable( QStringLiteral( "hysteresisThreshold" ) );
    }

    /**
      Get hysteresisThreshold default value
    */
    double defaultHysteresisThresholdValue() const
    {
        return defaultHysteresisThresholdValue_helper();
    }

    /**
      Set hysteresisZone
    */
    void setHysteresisZone( double v )
    {
      if (v < -60)
      {
        qDebug() << "setHysteresisZone: value " << v << " is less than the minimum value of -60";
        v = -60;
      }

      if (v > 0)
      {
        qDebug() << "setHysteresisZone: value " << v << " is greater than the maximum value of 0";
        v = 0;
      }

      if (v != mHysteresisZone && !isHysteresisZoneImmutable()) {
        mHysteresisZone = v;
        Q_EMIT hysteresisZoneChanged();
      }
    }

    Q_PROPERTY(double hysteresisZone READ hysteresisZone WRITE setHysteresisZone NOTIFY hysteresisZoneChanged)
    Q_PROPERTY(bool isHysteresisZoneImmutable READ isHysteresisZoneImmutable CONSTANT)
    Q_PROPERTY(double defaultHysteresisZoneValue READ defaultHysteresisZoneValue CONSTANT)
    /**
      Get hysteresisZone
    */
    double hysteresisZone() const
    {
      return mHysteresisZone;
    }

    /**
      Is hysteresisZone Immutable
    */
    bool isHysteresisZoneImmutable() const
    {
      return isImmutable( QStringLiteral( "hysteresisZone" ) );
    }

    /**
      Get hysteresisZone default value
    */
    double defaultHysteresisZoneValue() const
    {
        return defaultHysteresisZoneValue_helper();
    }

    /**
      Set reduction
    */
    void setReduction( double v )
    {
      if (v < -72)
      {
        qDebug() << "setReduction: value " << v << " is less than the minimum value of -72";
        v = -72;
      }

      if (v > 72)
      {
        qDebug() << "setReduction: value " << v << " is greater than the maximum value of 72";
        v = 72;
      }

      if (v != mReduction && !isReductionImmutable()) {
        mReduction = v;
        Q_EMIT reductionChanged();
      }
    }

    Q_PROPERTY(double reduction READ reduction WRITE setReduction NOTIFY reductionChanged)
    Q_PROPERTY(bool isReductionImmutable READ isReductionImmutable CONSTANT)
    Q_PROPERTY(double defaultReductionValue READ defaultReductionValue CONSTANT)
    /**
      Get reduction
    */
    double reduction() const
    {
      return mReduction;
    }

    /**
      Is reduction Immutable
    */
    bool isReductionImmutable() const
    {
      return isImmutable( QStringLiteral( "reduction" ) );
    }

    /**
      Get reduction default value
    */
    double defaultReductionValue() const
    {
        return defaultReductionValue_helper();
    }

    /**
      Set makeup
    */
    void setMakeup( double v )
    {
      if (v < -60)
      {
        qDebug() << "setMakeup: value " << v << " is less than the minimum value of -60";
        v = -60;
      }

      if (v > 60)
      {
        qDebug() << "setMakeup: value " << v << " is greater than the maximum value of 60";
        v = 60;
      }

      if (v != mMakeup && !isMakeupImmutable()) {
        mMakeup = v;
        Q_EMIT makeupChanged();
      }
    }

    Q_PROPERTY(double makeup READ makeup WRITE setMakeup NOTIFY makeupChanged)
    Q_PROPERTY(bool isMakeupImmutable READ isMakeupImmutable CONSTANT)
    Q_PROPERTY(double defaultMakeupValue READ defaultMakeupValue CONSTANT)
    /**
      Get makeup
    */
    double makeup() const
    {
      return mMakeup;
    }

    /**
      Is makeup Immutable
    */
    bool isMakeupImmutable() const
    {
      return isImmutable( QStringLiteral( "makeup" ) );
    }

    /**
      Get makeup default value
    */
    double defaultMakeupValue() const
    {
        return defaultMakeupValue_helper();
    }

    /**
      Set sidechainListen
    */
    void setSidechainListen( bool v )
    {
      if (v != mSidechainListen && !isSidechainListenImmutable()) {
        mSidechainListen = v;
        Q_EMIT sidechainListenChanged();
      }
    }

    Q_PROPERTY(bool sidechainListen READ sidechainListen WRITE setSidechainListen NOTIFY sidechainListenChanged)
    Q_PROPERTY(bool isSidechainListenImmutable READ isSidechainListenImmutable CONSTANT)
    Q_PROPERTY(bool defaultSidechainListenValue READ defaultSidechainListenValue CONSTANT)
    /**
      Get sidechainListen
    */
    bool sidechainListen() const
    {
      return mSidechainListen;
    }

    /**
      Is sidechainListen Immutable
    */
    bool isSidechainListenImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainListen" ) );
    }

    /**
      Get sidechainListen default value
    */
    bool defaultSidechainListenValue() const
    {
        return defaultSidechainListenValue_helper();
    }

    /**
      Set sidechainTypeLabels
    */
    void setSidechainTypeLabels( const QStringList & v )
    {
      if (v != mSidechainTypeLabels && !isSidechainTypeLabelsImmutable()) {
        mSidechainTypeLabels = v;
        Q_EMIT sidechainTypeLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList sidechainTypeLabels READ sidechainTypeLabels WRITE setSidechainTypeLabels NOTIFY sidechainTypeLabelsChanged)
    Q_PROPERTY(bool isSidechainTypeLabelsImmutable READ isSidechainTypeLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultSidechainTypeLabelsValue READ defaultSidechainTypeLabelsValue CONSTANT)
    /**
      Get sidechainTypeLabels
    */
    QStringList sidechainTypeLabels() const
    {
      return mSidechainTypeLabels;
    }

    /**
      Is sidechainTypeLabels Immutable
    */
    bool isSidechainTypeLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainTypeLabels" ) );
    }

    /**
      Get sidechainTypeLabels default value
    */
    QStringList defaultSidechainTypeLabelsValue() const
    {
        return defaultSidechainTypeLabelsValue_helper();
    }

    /**
      Set Sidechain Type
    */
    void setSidechainType( int v )
    {
      if (v != mSidechainType && !isSidechainTypeImmutable()) {
        mSidechainType = v;
        Q_EMIT sidechainTypeChanged();
      }
    }

    Q_PROPERTY(int sidechainType READ sidechainType WRITE setSidechainType NOTIFY sidechainTypeChanged)
    Q_PROPERTY(bool isSidechainTypeImmutable READ isSidechainTypeImmutable CONSTANT)
    Q_PROPERTY(int defaultSidechainTypeValue READ defaultSidechainTypeValue CONSTANT)
    /**
      Get Sidechain Type
    */
    int sidechainType() const
    {
      return mSidechainType;
    }

    /**
      Is Sidechain Type Immutable
    */
    bool isSidechainTypeImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainType" ) );
    }

    /**
      Get Sidechain Type default value
    */
    int defaultSidechainTypeValue() const
    {
        return defaultSidechainTypeValue_helper();
    }

    /**
      Set sidechainModeLabels
    */
    void setSidechainModeLabels( const QStringList & v )
    {
      if (v != mSidechainModeLabels && !isSidechainModeLabelsImmutable()) {
        mSidechainModeLabels = v;
        Q_EMIT sidechainModeLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList sidechainModeLabels READ sidechainModeLabels WRITE setSidechainModeLabels NOTIFY sidechainModeLabelsChanged)
    Q_PROPERTY(bool isSidechainModeLabelsImmutable READ isSidechainModeLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultSidechainModeLabelsValue READ defaultSidechainModeLabelsValue CONSTANT)
    /**
      Get sidechainModeLabels
    */
    QStringList sidechainModeLabels() const
    {
      return mSidechainModeLabels;
    }

    /**
      Is sidechainModeLabels Immutable
    */
    bool isSidechainModeLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainModeLabels" ) );
    }

    /**
      Get sidechainModeLabels default value
    */
    QStringList defaultSidechainModeLabelsValue() const
    {
        return defaultSidechainModeLabelsValue_helper();
    }

    /**
      Set Sidechain Mode
    */
    void setSidechainMode( int v )
    {
      if (v != mSidechainMode && !isSidechainModeImmutable()) {
        mSidechainMode = v;
        Q_EMIT sidechainModeChanged();
      }
    }

    Q_PROPERTY(int sidechainMode READ sidechainMode WRITE setSidechainMode NOTIFY sidechainModeChanged)
    Q_PROPERTY(bool isSidechainModeImmutable READ isSidechainModeImmutable CONSTANT)
    Q_PROPERTY(int defaultSidechainModeValue READ defaultSidechainModeValue CONSTANT)
    /**
      Get Sidechain Mode
    */
    int sidechainMode() const
    {
      return mSidechainMode;
    }

    /**
      Is Sidechain Mode Immutable
    */
    bool isSidechainModeImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainMode" ) );
    }

    /**
      Get Sidechain Mode default value
    */
    int defaultSidechainModeValue() const
    {
        return defaultSidechainModeValue_helper();
    }

    /**
      Set stereoSplit
    */
    void setStereoSplit( bool v )
    {
      if (v != mStereoSplit && !isStereoSplitImmutable()) {
        mStereoSplit = v;
        Q_EMIT stereoSplitChanged();
      }
    }

    Q_PROPERTY(bool stereoSplit READ stereoSplit WRITE setStereoSplit NOTIFY stereoSplitChanged)
    Q_PROPERTY(bool isStereoSplitImmutable READ isStereoSplitImmutable CONSTANT)
    Q_PROPERTY(bool defaultStereoSplitValue READ defaultStereoSplitValue CONSTANT)
    /**
      Get stereoSplit
    */
    bool stereoSplit() const
    {
      return mStereoSplit;
    }

    /**
      Is stereoSplit Immutable
    */
    bool isStereoSplitImmutable() const
    {
      return isImmutable( QStringLiteral( "stereoSplit" ) );
    }

    /**
      Get stereoSplit default value
    */
    bool defaultStereoSplitValue() const
    {
        return defaultStereoSplitValue_helper();
    }

    /**
      Set sidechainSourceLabels
    */
    void setSidechainSourceLabels( const QStringList & v )
    {
      if (v != mSidechainSourceLabels && !isSidechainSourceLabelsImmutable()) {
        mSidechainSourceLabels = v;
        Q_EMIT sidechainSourceLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList sidechainSourceLabels READ sidechainSourceLabels WRITE setSidechainSourceLabels NOTIFY sidechainSourceLabelsChanged)
    Q_PROPERTY(bool isSidechainSourceLabelsImmutable READ isSidechainSourceLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultSidechainSourceLabelsValue READ defaultSidechainSourceLabelsValue CONSTANT)
    /**
      Get sidechainSourceLabels
    */
    QStringList sidechainSourceLabels() const
    {
      return mSidechainSourceLabels;
    }

    /**
      Is sidechainSourceLabels Immutable
    */
    bool isSidechainSourceLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainSourceLabels" ) );
    }

    /**
      Get sidechainSourceLabels default value
    */
    QStringList defaultSidechainSourceLabelsValue() const
    {
        return defaultSidechainSourceLabelsValue_helper();
    }

    /**
      Set Sidechain Source
    */
    void setSidechainSource( int v )
    {
      if (v != mSidechainSource && !isSidechainSourceImmutable()) {
        mSidechainSource = v;
        Q_EMIT sidechainSourceChanged();
      }
    }

    Q_PROPERTY(int sidechainSource READ sidechainSource WRITE setSidechainSource NOTIFY sidechainSourceChanged)
    Q_PROPERTY(bool isSidechainSourceImmutable READ isSidechainSourceImmutable CONSTANT)
    Q_PROPERTY(int defaultSidechainSourceValue READ defaultSidechainSourceValue CONSTANT)
    /**
      Get Sidechain Source
    */
    int sidechainSource() const
    {
      return mSidechainSource;
    }

    /**
      Is Sidechain Source Immutable
    */
    bool isSidechainSourceImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainSource" ) );
    }

    /**
      Get Sidechain Source default value
    */
    int defaultSidechainSourceValue() const
    {
        return defaultSidechainSourceValue_helper();
    }

    /**
      Set stereoSplitSourceLabels
    */
    void setStereoSplitSourceLabels( const QStringList & v )
    {
      if (v != mStereoSplitSourceLabels && !isStereoSplitSourceLabelsImmutable()) {
        mStereoSplitSourceLabels = v;
        Q_EMIT stereoSplitSourceLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList stereoSplitSourceLabels READ stereoSplitSourceLabels WRITE setStereoSplitSourceLabels NOTIFY stereoSplitSourceLabelsChanged)
    Q_PROPERTY(bool isStereoSplitSourceLabelsImmutable READ isStereoSplitSourceLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultStereoSplitSourceLabelsValue READ defaultStereoSplitSourceLabelsValue CONSTANT)
    /**
      Get stereoSplitSourceLabels
    */
    QStringList stereoSplitSourceLabels() const
    {
      return mStereoSplitSourceLabels;
    }

    /**
      Is stereoSplitSourceLabels Immutable
    */
    bool isStereoSplitSourceLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "stereoSplitSourceLabels" ) );
    }

    /**
      Get stereoSplitSourceLabels default value
    */
    QStringList defaultStereoSplitSourceLabelsValue() const
    {
        return defaultStereoSplitSourceLabelsValue_helper();
    }

    /**
      Set Stereo Split Mode
    */
    void setStereoSplitSource( int v )
    {
      if (v != mStereoSplitSource && !isStereoSplitSourceImmutable()) {
        mStereoSplitSource = v;
        Q_EMIT stereoSplitSourceChanged();
      }
    }

    Q_PROPERTY(int stereoSplitSource READ stereoSplitSource WRITE setStereoSplitSource NOTIFY stereoSplitSourceChanged)
    Q_PROPERTY(bool isStereoSplitSourceImmutable READ isStereoSplitSourceImmutable CONSTANT)
    Q_PROPERTY(int defaultStereoSplitSourceValue READ defaultStereoSplitSourceValue CONSTANT)
    /**
      Get Stereo Split Mode
    */
    int stereoSplitSource() const
    {
      return mStereoSplitSource;
    }

    /**
      Is Stereo Split Mode Immutable
    */
    bool isStereoSplitSourceImmutable() const
    {
      return isImmutable( QStringLiteral( "stereoSplitSource" ) );
    }

    /**
      Get Stereo Split Mode default value
    */
    int defaultStereoSplitSourceValue() const
    {
        return defaultStereoSplitSourceValue_helper();
    }

    /**
      Set sidechainPreamp
    */
    void setSidechainPreamp( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setSidechainPreamp: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 40)
      {
        qDebug() << "setSidechainPreamp: value " << v << " is greater than the maximum value of 40";
        v = 40;
      }

      if (v != mSidechainPreamp && !isSidechainPreampImmutable()) {
        mSidechainPreamp = v;
        Q_EMIT sidechainPreampChanged();
      }
    }

    Q_PROPERTY(double sidechainPreamp READ sidechainPreamp WRITE setSidechainPreamp NOTIFY sidechainPreampChanged)
    Q_PROPERTY(bool isSidechainPreampImmutable READ isSidechainPreampImmutable CONSTANT)
    Q_PROPERTY(double defaultSidechainPreampValue READ defaultSidechainPreampValue CONSTANT)
    /**
      Get sidechainPreamp
    */
    double sidechainPreamp() const
    {
      return mSidechainPreamp;
    }

    /**
      Is sidechainPreamp Immutable
    */
    bool isSidechainPreampImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainPreamp" ) );
    }

    /**
      Get sidechainPreamp default value
    */
    double defaultSidechainPreampValue() const
    {
        return defaultSidechainPreampValue_helper();
    }

    /**
      Set sidechainReactivity
    */
    void setSidechainReactivity( double v )
    {
      if (v < 0)
      {
        qDebug() << "setSidechainReactivity: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 250)
      {
        qDebug() << "setSidechainReactivity: value " << v << " is greater than the maximum value of 250";
        v = 250;
      }

      if (v != mSidechainReactivity && !isSidechainReactivityImmutable()) {
        mSidechainReactivity = v;
        Q_EMIT sidechainReactivityChanged();
      }
    }

    Q_PROPERTY(double sidechainReactivity READ sidechainReactivity WRITE setSidechainReactivity NOTIFY sidechainReactivityChanged)
    Q_PROPERTY(bool isSidechainReactivityImmutable READ isSidechainReactivityImmutable CONSTANT)
    Q_PROPERTY(double defaultSidechainReactivityValue READ defaultSidechainReactivityValue CONSTANT)
    /**
      Get sidechainReactivity
    */
    double sidechainReactivity() const
    {
      return mSidechainReactivity;
    }

    /**
      Is sidechainReactivity Immutable
    */
    bool isSidechainReactivityImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainReactivity" ) );
    }

    /**
      Get sidechainReactivity default value
    */
    double defaultSidechainReactivityValue() const
    {
        return defaultSidechainReactivityValue_helper();
    }

    /**
      Set sidechainLookahead
    */
    void setSidechainLookahead( double v )
    {
      if (v < 0)
      {
        qDebug() << "setSidechainLookahead: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 20)
      {
        qDebug() << "setSidechainLookahead: value " << v << " is greater than the maximum value of 20";
        v = 20;
      }

      if (v != mSidechainLookahead && !isSidechainLookaheadImmutable()) {
        mSidechainLookahead = v;
        Q_EMIT sidechainLookaheadChanged();
      }
    }

    Q_PROPERTY(double sidechainLookahead READ sidechainLookahead WRITE setSidechainLookahead NOTIFY sidechainLookaheadChanged)
    Q_PROPERTY(bool isSidechainLookaheadImmutable READ isSidechainLookaheadImmutable CONSTANT)
    Q_PROPERTY(double defaultSidechainLookaheadValue READ defaultSidechainLookaheadValue CONSTANT)
    /**
      Get sidechainLookahead
    */
    double sidechainLookahead() const
    {
      return mSidechainLookahead;
    }

    /**
      Is sidechainLookahead Immutable
    */
    bool isSidechainLookaheadImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainLookahead" ) );
    }

    /**
      Get sidechainLookahead default value
    */
    double defaultSidechainLookaheadValue() const
    {
        return defaultSidechainLookaheadValue_helper();
    }

    /**
      Set hpfModeLabels
    */
    void setHpfModeLabels( const QStringList & v )
    {
      if (v != mHpfModeLabels && !isHpfModeLabelsImmutable()) {
        mHpfModeLabels = v;
        Q_EMIT hpfModeLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList hpfModeLabels READ hpfModeLabels WRITE setHpfModeLabels NOTIFY hpfModeLabelsChanged)
    Q_PROPERTY(bool isHpfModeLabelsImmutable READ isHpfModeLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultHpfModeLabelsValue READ defaultHpfModeLabelsValue CONSTANT)
    /**
      Get hpfModeLabels
    */
    QStringList hpfModeLabels() const
    {
      return mHpfModeLabels;
    }

    /**
      Is hpfModeLabels Immutable
    */
    bool isHpfModeLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "hpfModeLabels" ) );
    }

    /**
      Get hpfModeLabels default value
    */
    QStringList defaultHpfModeLabelsValue() const
    {
        return defaultHpfModeLabelsValue_helper();
    }

    /**
      Set High-pass Filter Mode
    */
    void setHpfMode( int v )
    {
      if (v != mHpfMode && !isHpfModeImmutable()) {
        mHpfMode = v;
        Q_EMIT hpfModeChanged();
      }
    }

    Q_PROPERTY(int hpfMode READ hpfMode WRITE setHpfMode NOTIFY hpfModeChanged)
    Q_PROPERTY(bool isHpfModeImmutable READ isHpfModeImmutable CONSTANT)
    Q_PROPERTY(int defaultHpfModeValue READ defaultHpfModeValue CONSTANT)
    /**
      Get High-pass Filter Mode
    */
    int hpfMode() const
    {
      return mHpfMode;
    }

    /**
      Is High-pass Filter Mode Immutable
    */
    bool isHpfModeImmutable() const
    {
      return isImmutable( QStringLiteral( "hpfMode" ) );
    }

    /**
      Get High-pass Filter Mode default value
    */
    int defaultHpfModeValue() const
    {
        return defaultHpfModeValue_helper();
    }

    /**
      Set hpfFrequency
    */
    void setHpfFrequency( double v )
    {
      if (v < 10)
      {
        qDebug() << "setHpfFrequency: value " << v << " is less than the minimum value of 10";
        v = 10;
      }

      if (v > 20000)
      {
        qDebug() << "setHpfFrequency: value " << v << " is greater than the maximum value of 20000";
        v = 20000;
      }

      if (v != mHpfFrequency && !isHpfFrequencyImmutable()) {
        mHpfFrequency = v;
        Q_EMIT hpfFrequencyChanged();
      }
    }

    Q_PROPERTY(double hpfFrequency READ hpfFrequency WRITE setHpfFrequency NOTIFY hpfFrequencyChanged)
    Q_PROPERTY(bool isHpfFrequencyImmutable READ isHpfFrequencyImmutable CONSTANT)
    Q_PROPERTY(double defaultHpfFrequencyValue READ defaultHpfFrequencyValue CONSTANT)
    /**
      Get hpfFrequency
    */
    double hpfFrequency() const
    {
      return mHpfFrequency;
    }

    /**
      Is hpfFrequency Immutable
    */
    bool isHpfFrequencyImmutable() const
    {
      return isImmutable( QStringLiteral( "hpfFrequency" ) );
    }

    /**
      Get hpfFrequency default value
    */
    double defaultHpfFrequencyValue() const
    {
        return defaultHpfFrequencyValue_helper();
    }

    /**
      Set lpfModeLabels
    */
    void setLpfModeLabels( const QStringList & v )
    {
      if (v != mLpfModeLabels && !isLpfModeLabelsImmutable()) {
        mLpfModeLabels = v;
        Q_EMIT lpfModeLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList lpfModeLabels READ lpfModeLabels WRITE setLpfModeLabels NOTIFY lpfModeLabelsChanged)
    Q_PROPERTY(bool isLpfModeLabelsImmutable READ isLpfModeLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultLpfModeLabelsValue READ defaultLpfModeLabelsValue CONSTANT)
    /**
      Get lpfModeLabels
    */
    QStringList lpfModeLabels() const
    {
      return mLpfModeLabels;
    }

    /**
      Is lpfModeLabels Immutable
    */
    bool isLpfModeLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "lpfModeLabels" ) );
    }

    /**
      Get lpfModeLabels default value
    */
    QStringList defaultLpfModeLabelsValue() const
    {
        return defaultLpfModeLabelsValue_helper();
    }

    /**
      Set Low-pass Filter Mode
    */
    void setLpfMode( int v )
    {
      if (v != mLpfMode && !isLpfModeImmutable()) {
        mLpfMode = v;
        Q_EMIT lpfModeChanged();
      }
    }

    Q_PROPERTY(int lpfMode READ lpfMode WRITE setLpfMode NOTIFY lpfModeChanged)
    Q_PROPERTY(bool isLpfModeImmutable READ isLpfModeImmutable CONSTANT)
    Q_PROPERTY(int defaultLpfModeValue READ defaultLpfModeValue CONSTANT)
    /**
      Get Low-pass Filter Mode
    */
    int lpfMode() const
    {
      return mLpfMode;
    }

    /**
      Is Low-pass Filter Mode Immutable
    */
    bool isLpfModeImmutable() const
    {
      return isImmutable( QStringLiteral( "lpfMode" ) );
    }

    /**
      Get Low-pass Filter Mode default value
    */
    int defaultLpfModeValue() const
    {
        return defaultLpfModeValue_helper();
    }

    /**
      Set lpfFrequency
    */
    void setLpfFrequency( double v )
    {
      if (v < 10)
      {
        qDebug() << "setLpfFrequency: value " << v << " is less than the minimum value of 10";
        v = 10;
      }

      if (v > 20000)
      {
        qDebug() << "setLpfFrequency: value " << v << " is greater than the maximum value of 20000";
        v = 20000;
      }

      if (v != mLpfFrequency && !isLpfFrequencyImmutable()) {
        mLpfFrequency = v;
        Q_EMIT lpfFrequencyChanged();
      }
    }

    Q_PROPERTY(double lpfFrequency READ lpfFrequency WRITE setLpfFrequency NOTIFY lpfFrequencyChanged)
    Q_PROPERTY(bool isLpfFrequencyImmutable READ isLpfFrequencyImmutable CONSTANT)
    Q_PROPERTY(double defaultLpfFrequencyValue READ defaultLpfFrequencyValue CONSTANT)
    /**
      Get lpfFrequency
    */
    double lpfFrequency() const
    {
      return mLpfFrequency;
    }

    /**
      Is lpfFrequency Immutable
    */
    bool isLpfFrequencyImmutable() const
    {
      return isImmutable( QStringLiteral( "lpfFrequency" ) );
    }

    /**
      Get lpfFrequency default value
    */
    double defaultLpfFrequencyValue() const
    {
        return defaultLpfFrequencyValue_helper();
    }

    /**
      Set sidechainInputDevice
    */
    void setSidechainInputDevice( const QString & v )
    {
      if (v != mSidechainInputDevice && !isSidechainInputDeviceImmutable()) {
        mSidechainInputDevice = v;
        Q_EMIT sidechainInputDeviceChanged();
      }
    }

    Q_PROPERTY(QString sidechainInputDevice READ sidechainInputDevice WRITE setSidechainInputDevice NOTIFY sidechainInputDeviceChanged)
    Q_PROPERTY(bool isSidechainInputDeviceImmutable READ isSidechainInputDeviceImmutable CONSTANT)
    Q_PROPERTY(QString defaultSidechainInputDeviceValue READ defaultSidechainInputDeviceValue CONSTANT)
    /**
      Get sidechainInputDevice
    */
    QString sidechainInputDevice() const
    {
      return mSidechainInputDevice;
    }

    /**
      Is sidechainInputDevice Immutable
    */
    bool isSidechainInputDeviceImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainInputDevice" ) );
    }

    /**
      Get sidechainInputDevice default value
    */
    QString defaultSidechainInputDeviceValue() const
    {
        return defaultSidechainInputDeviceValue_helper();
    }

    /**
      Set inputToSidechain
    */
    void setInputToSidechain( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setInputToSidechain: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 40)
      {
        qDebug() << "setInputToSidechain: value " << v << " is greater than the maximum value of 40";
        v = 40;
      }

      if (v != mInputToSidechain && !isInputToSidechainImmutable()) {
        mInputToSidechain = v;
        Q_EMIT inputToSidechainChanged();
      }
    }

    Q_PROPERTY(double inputToSidechain READ inputToSidechain WRITE setInputToSidechain NOTIFY inputToSidechainChanged)
    Q_PROPERTY(bool isInputToSidechainImmutable READ isInputToSidechainImmutable CONSTANT)
    Q_PROPERTY(double defaultInputToSidechainValue READ defaultInputToSidechainValue CONSTANT)
    /**
      Get inputToSidechain
    */
    double inputToSidechain() const
    {
      return mInputToSidechain;
    }

    /**
      Is inputToSidechain Immutable
    */
    bool isInputToSidechainImmutable() const
    {
      return isImmutable( QStringLiteral( "inputToSidechain" ) );
    }

    /**
      Get inputToSidechain default value
    */
    double defaultInputToSidechainValue() const
    {
        return defaultInputToSidechainValue_helper();
    }

    /**
      Set inputToLink
    */
    void setInputToLink( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setInputToLink: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 40)
      {
        qDebug() << "setInputToLink: value " << v << " is greater than the maximum value of 40";
        v = 40;
      }

      if (v != mInputToLink && !isInputToLinkImmutable()) {
        mInputToLink = v;
        Q_EMIT inputToLinkChanged();
      }
    }

    Q_PROPERTY(double inputToLink READ inputToLink WRITE setInputToLink NOTIFY inputToLinkChanged)
    Q_PROPERTY(bool isInputToLinkImmutable READ isInputToLinkImmutable CONSTANT)
    Q_PROPERTY(double defaultInputToLinkValue READ defaultInputToLinkValue CONSTANT)
    /**
      Get inputToLink
    */
    double inputToLink() const
    {
      return mInputToLink;
    }

    /**
      Is inputToLink Immutable
    */
    bool isInputToLinkImmutable() const
    {
      return isImmutable( QStringLiteral( "inputToLink" ) );
    }

    /**
      Get inputToLink default value
    */
    double defaultInputToLinkValue() const
    {
        return defaultInputToLinkValue_helper();
    }

    /**
      Set sidechainToInput
    */
    void setSidechainToInput( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setSidechainToInput: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 40)
      {
        qDebug() << "setSidechainToInput: value " << v << " is greater than the maximum value of 40";
        v = 40;
      }

      if (v != mSidechainToInput && !isSidechainToInputImmutable()) {
        mSidechainToInput = v;
        Q_EMIT sidechainToInputChanged();
      }
    }

    Q_PROPERTY(double sidechainToInput READ sidechainToInput WRITE setSidechainToInput NOTIFY sidechainToInputChanged)
    Q_PROPERTY(bool isSidechainToInputImmutable READ isSidechainToInputImmutable CONSTANT)
    Q_PROPERTY(double defaultSidechainToInputValue READ defaultSidechainToInputValue CONSTANT)
    /**
      Get sidechainToInput
    */
    double sidechainToInput() const
    {
      return mSidechainToInput;
    }

    /**
      Is sidechainToInput Immutable
    */
    bool isSidechainToInputImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainToInput" ) );
    }

    /**
      Get sidechainToInput default value
    */
    double defaultSidechainToInputValue() const
    {
        return defaultSidechainToInputValue_helper();
    }

    /**
      Set sidechainToLink
    */
    void setSidechainToLink( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setSidechainToLink: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 40)
      {
        qDebug() << "setSidechainToLink: value " << v << " is greater than the maximum value of 40";
        v = 40;
      }

      if (v != mSidechainToLink && !isSidechainToLinkImmutable()) {
        mSidechainToLink = v;
        Q_EMIT sidechainToLinkChanged();
      }
    }

    Q_PROPERTY(double sidechainToLink READ sidechainToLink WRITE setSidechainToLink NOTIFY sidechainToLinkChanged)
    Q_PROPERTY(bool isSidechainToLinkImmutable READ isSidechainToLinkImmutable CONSTANT)
    Q_PROPERTY(double defaultSidechainToLinkValue READ defaultSidechainToLinkValue CONSTANT)
    /**
      Get sidechainToLink
    */
    double sidechainToLink() const
    {
      return mSidechainToLink;
    }

    /**
      Is sidechainToLink Immutable
    */
    bool isSidechainToLinkImmutable() const
    {
      return isImmutable( QStringLiteral( "sidechainToLink" ) );
    }

    /**
      Get sidechainToLink default value
    */
    double defaultSidechainToLinkValue() const
    {
        return defaultSidechainToLinkValue_helper();
    }

    /**
      Set linkToSidechain
    */
    void setLinkToSidechain( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setLinkToSidechain: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 40)
      {
        qDebug() << "setLinkToSidechain: value " << v << " is greater than the maximum value of 40";
        v = 40;
      }

      if (v != mLinkToSidechain && !isLinkToSidechainImmutable()) {
        mLinkToSidechain = v;
        Q_EMIT linkToSidechainChanged();
      }
    }

    Q_PROPERTY(double linkToSidechain READ linkToSidechain WRITE setLinkToSidechain NOTIFY linkToSidechainChanged)
    Q_PROPERTY(bool isLinkToSidechainImmutable READ isLinkToSidechainImmutable CONSTANT)
    Q_PROPERTY(double defaultLinkToSidechainValue READ defaultLinkToSidechainValue CONSTANT)
    /**
      Get linkToSidechain
    */
    double linkToSidechain() const
    {
      return mLinkToSidechain;
    }

    /**
      Is linkToSidechain Immutable
    */
    bool isLinkToSidechainImmutable() const
    {
      return isImmutable( QStringLiteral( "linkToSidechain" ) );
    }

    /**
      Get linkToSidechain default value
    */
    double defaultLinkToSidechainValue() const
    {
        return defaultLinkToSidechainValue_helper();
    }

    /**
      Set linkToInput
    */
    void setLinkToInput( double v )
    {
      if (v < -80.01)
      {
        qDebug() << "setLinkToInput: value " << v << " is less than the minimum value of -80.01";
        v = -80.01;
      }

      if (v > 40)
      {
        qDebug() << "setLinkToInput: value " << v << " is greater than the maximum value of 40";
        v = 40;
      }

      if (v != mLinkToInput && !isLinkToInputImmutable()) {
        mLinkToInput = v;
        Q_EMIT linkToInputChanged();
      }
    }

    Q_PROPERTY(double linkToInput READ linkToInput WRITE setLinkToInput NOTIFY linkToInputChanged)
    Q_PROPERTY(bool isLinkToInputImmutable READ isLinkToInputImmutable CONSTANT)
    Q_PROPERTY(double defaultLinkToInputValue READ defaultLinkToInputValue CONSTANT)
    /**
      Get linkToInput
    */
    double linkToInput() const
    {
      return mLinkToInput;
    }

    /**
      Is linkToInput Immutable
    */
    bool isLinkToInputImmutable() const
    {
      return isImmutable( QStringLiteral( "linkToInput" ) );
    }

    /**
      Get linkToInput default value
    */
    double defaultLinkToInputValue() const
    {
        return defaultLinkToInputValue_helper();
    }


    enum {
      signalBypassChanged = 1,
      signalInputGainChanged = 2,
      signalOutputGainChanged = 3,
      signalDryChanged = 4,
      signalWetChanged = 5,
      signalModeLabelsChanged = 6,
      signalModeChanged = 7,
      signalAttackChanged = 8,
      signalReleaseChanged = 9,
      signalCurveThresholdChanged = 10,
      signalCurveZoneChanged = 11,
      signalHysteresisChanged = 12,
      signalHysteresisThresholdChanged = 13,
      signalHysteresisZoneChanged = 14,
      signalReductionChanged = 15,
      signalMakeupChanged = 16,
      signalSidechainListenChanged = 17,
      signalSidechainTypeLabelsChanged = 18,
      signalSidechainTypeChanged = 19,
      signalSidechainModeLabelsChanged = 20,
      signalSidechainModeChanged = 21,
      signalStereoSplitChanged = 22,
      signalSidechainSourceLabelsChanged = 23,
      signalSidechainSourceChanged = 24,
      signalStereoSplitSourceLabelsChanged = 25,
      signalStereoSplitSourceChanged = 26,
      signalSidechainPreampChanged = 27,
      signalSidechainReactivityChanged = 28,
      signalSidechainLookaheadChanged = 29,
      signalHpfModeLabelsChanged = 30,
      signalHpfModeChanged = 31,
      signalHpfFrequencyChanged = 32,
      signalLpfModeLabelsChanged = 33,
      signalLpfModeChanged = 34,
      signalLpfFrequencyChanged = 35,
      signalSidechainInputDeviceChanged = 36,
      signalInputToSidechainChanged = 37,
      signalInputToLinkChanged = 38,
      signalSidechainToInputChanged = 39,
      signalSidechainToLinkChanged = 40,
      signalLinkToSidechainChanged = 41,
      signalLinkToInputChanged = 42
    };

  Q_SIGNALS:
    void bypassChanged();

    void inputGainChanged();

    void outputGainChanged();

    void dryChanged();

    void wetChanged();

    void modeLabelsChanged();

    void modeChanged();

    void attackChanged();

    void releaseChanged();

    void curveThresholdChanged();

    void curveZoneChanged();

    void hysteresisChanged();

    void hysteresisThresholdChanged();

    void hysteresisZoneChanged();

    void reductionChanged();

    void makeupChanged();

    void sidechainListenChanged();

    void sidechainTypeLabelsChanged();

    void sidechainTypeChanged();

    void sidechainModeLabelsChanged();

    void sidechainModeChanged();

    void stereoSplitChanged();

    void sidechainSourceLabelsChanged();

    void sidechainSourceChanged();

    void stereoSplitSourceLabelsChanged();

    void stereoSplitSourceChanged();

    void sidechainPreampChanged();

    void sidechainReactivityChanged();

    void sidechainLookaheadChanged();

    void hpfModeLabelsChanged();

    void hpfModeChanged();

    void hpfFrequencyChanged();

    void lpfModeLabelsChanged();

    void lpfModeChanged();

    void lpfFrequencyChanged();

    void sidechainInputDeviceChanged();

    void inputToSidechainChanged();

    void inputToLinkChanged();

    void sidechainToInputChanged();

    void sidechainToLinkChanged();

    void linkToSidechainChanged();

    void linkToInputChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    QString mParammasterGroup;
    QString mParaminstanceIndex;

    // Gate#$(instanceIndex)
    bool mBypass;
    bool defaultBypassValue_helper() const;
    double mInputGain;
    double defaultInputGainValue_helper() const;
    double mOutputGain;
    double defaultOutputGainValue_helper() const;
    double mDry;
    double defaultDryValue_helper() const;
    double mWet;
    double defaultWetValue_helper() const;
    QStringList mModeLabels;
    QStringList defaultModeLabelsValue_helper() const;
    int mMode;
    int defaultModeValue_helper() const;
    double mAttack;
    double defaultAttackValue_helper() const;
    double mRelease;
    double defaultReleaseValue_helper() const;
    double mCurveThreshold;
    double defaultCurveThresholdValue_helper() const;
    double mCurveZone;
    double defaultCurveZoneValue_helper() const;
    bool mHysteresis;
    bool defaultHysteresisValue_helper() const;
    double mHysteresisThreshold;
    double defaultHysteresisThresholdValue_helper() const;
    double mHysteresisZone;
    double defaultHysteresisZoneValue_helper() const;
    double mReduction;
    double defaultReductionValue_helper() const;
    double mMakeup;
    double defaultMakeupValue_helper() const;
    bool mSidechainListen;
    bool defaultSidechainListenValue_helper() const;
    QStringList mSidechainTypeLabels;
    QStringList defaultSidechainTypeLabelsValue_helper() const;
    int mSidechainType;
    int defaultSidechainTypeValue_helper() const;
    QStringList mSidechainModeLabels;
    QStringList defaultSidechainModeLabelsValue_helper() const;
    int mSidechainMode;
    int defaultSidechainModeValue_helper() const;
    bool mStereoSplit;
    bool defaultStereoSplitValue_helper() const;
    QStringList mSidechainSourceLabels;
    QStringList defaultSidechainSourceLabelsValue_helper() const;
    int mSidechainSource;
    int defaultSidechainSourceValue_helper() const;
    QStringList mStereoSplitSourceLabels;
    QStringList defaultStereoSplitSourceLabelsValue_helper() const;
    int mStereoSplitSource;
    int defaultStereoSplitSourceValue_helper() const;
    double mSidechainPreamp;
    double defaultSidechainPreampValue_helper() const;
    double mSidechainReactivity;
    double defaultSidechainReactivityValue_helper() const;
    double mSidechainLookahead;
    double defaultSidechainLookaheadValue_helper() const;
    QStringList mHpfModeLabels;
    QStringList defaultHpfModeLabelsValue_helper() const;
    int mHpfMode;
    int defaultHpfModeValue_helper() const;
    double mHpfFrequency;
    double defaultHpfFrequencyValue_helper() const;
    QStringList mLpfModeLabels;
    QStringList defaultLpfModeLabelsValue_helper() const;
    int mLpfMode;
    int defaultLpfModeValue_helper() const;
    double mLpfFrequency;
    double defaultLpfFrequencyValue_helper() const;
    QString mSidechainInputDevice;
    QString defaultSidechainInputDeviceValue_helper() const;
    double mInputToSidechain;
    double defaultInputToSidechainValue_helper() const;
    double mInputToLink;
    double defaultInputToLinkValue_helper() const;
    double mSidechainToInput;
    double defaultSidechainToInputValue_helper() const;
    double mSidechainToLink;
    double defaultSidechainToLinkValue_helper() const;
    double mLinkToSidechain;
    double defaultLinkToSidechainValue_helper() const;
    double mLinkToInput;
    double defaultLinkToInputValue_helper() const;
};

}

#endif

