
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "desktopnotificationsfactory_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_DesktopNotificationsFactory_Type = nullptr;
static PyTypeObject *Sbk_DesktopNotificationsFactory_TypeF(void)
{
    return _Sbk_DesktopNotificationsFactory_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void DesktopNotificationsFactoryWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::DesktopNotificationsFactory::Type >("DesktopNotificationsFactory::Type");
}

void DesktopNotificationsFactoryWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

DesktopNotificationsFactoryWrapper::DesktopNotificationsFactoryWrapper(::QObject * parent) : DesktopNotificationsFactory(parent)
{
}

void DesktopNotificationsFactoryWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DesktopNotificationsFactory_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("DesktopNotificationsFactory", funcName, gil, pyOverride, event);
}

void DesktopNotificationsFactoryWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DesktopNotificationsFactory_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("DesktopNotificationsFactory", funcName, gil, pyOverride, signal);
}

void DesktopNotificationsFactoryWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DesktopNotificationsFactory_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("DesktopNotificationsFactory", funcName, gil, pyOverride, event);
}

void DesktopNotificationsFactoryWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DesktopNotificationsFactory_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("DesktopNotificationsFactory", funcName, gil, pyOverride, signal);
}

bool DesktopNotificationsFactoryWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DesktopNotificationsFactory_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("DesktopNotificationsFactory", funcName, gil, pyOverride, event);
}

bool DesktopNotificationsFactoryWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DesktopNotificationsFactory_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("DesktopNotificationsFactory", funcName, gil, pyOverride, watched, event);
}

void DesktopNotificationsFactoryWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DesktopNotificationsFactory_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("DesktopNotificationsFactory", funcName, gil, pyOverride, event);
}

const QMetaObject *DesktopNotificationsFactoryWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return DesktopNotificationsFactory::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int DesktopNotificationsFactoryWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = DesktopNotificationsFactory::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *DesktopNotificationsFactoryWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< DesktopNotificationsFactoryWrapper *>(this));
    }
    return DesktopNotificationsFactory::qt_metacast(_clname);
}

DesktopNotificationsFactoryWrapper::~DesktopNotificationsFactoryWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_DesktopNotificationsFactory_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_DesktopNotificationsFactory_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::DesktopNotificationsFactory >()))
        return -1;

    DesktopNotificationsFactoryWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:DesktopNotificationsFactory", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: DesktopNotificationsFactory::DesktopNotificationsFactory(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // DesktopNotificationsFactory(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // DesktopNotificationsFactory(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // DesktopNotificationsFactory(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) DesktopNotificationsFactoryWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new DesktopNotificationsFactoryWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< DesktopNotificationsFactory >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX]);
    };


    return 1;
}

static PyObject *Sbk_DesktopNotificationsFactoryFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DesktopNotificationsFactoryWrapper *>(reinterpret_cast< ::DesktopNotificationsFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadSettings()
        cppSelf->loadSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DesktopNotificationsFactoryFunc_nativeNotificationPreview(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DesktopNotificationsFactoryWrapper *>(reinterpret_cast< ::DesktopNotificationsFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // nativeNotificationPreview()
        cppSelf->nativeNotificationPreview();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DesktopNotificationsFactoryFunc_showNotification(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DesktopNotificationsFactoryWrapper *>(reinterpret_cast< ::DesktopNotificationsFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "showNotification", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: DesktopNotificationsFactory::showNotification(QPixmap,QString,QString)
    // 1: DesktopNotificationsFactory::showNotification(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 1; // showNotification(QString,QString)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        overloadId = 0; // showNotification(QPixmap,QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "showNotification", errInfo, SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // showNotification(const QPixmap &icon, const QString &heading, const QString &text)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPixmap cppArg0_local;
            ::QPixmap *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // showNotification(QPixmap,QString,QString)
                cppSelf->showNotification(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // showNotification(const QString &heading, const QString &text)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // showNotification(QString,QString)
                cppSelf->showNotification(cppArg0, cppArg1);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DesktopNotificationsFactoryFunc_supportsNativeNotifications(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DesktopNotificationsFactoryWrapper *>(reinterpret_cast< ::DesktopNotificationsFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // supportsNativeNotifications()const
        bool cppResult = const_cast<const DesktopNotificationsFactoryWrapper *>(cppSelf)->supportsNativeNotifications();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_DesktopNotificationsFactory_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_DesktopNotificationsFactory_EnumFlagInfo[] = {
    "Type:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_DesktopNotificationsFactory_methods[] = {
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_DesktopNotificationsFactoryFunc_loadSettings), METH_NOARGS, nullptr},
    {"nativeNotificationPreview", reinterpret_cast<PyCFunction>(Sbk_DesktopNotificationsFactoryFunc_nativeNotificationPreview), METH_NOARGS, nullptr},
    {"showNotification", reinterpret_cast<PyCFunction>(Sbk_DesktopNotificationsFactoryFunc_showNotification), METH_VARARGS, nullptr},
    {"supportsNativeNotifications", reinterpret_cast<PyCFunction>(Sbk_DesktopNotificationsFactoryFunc_supportsNativeNotifications), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_DesktopNotificationsFactory_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::DesktopNotificationsFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<DesktopNotificationsFactoryWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_DesktopNotificationsFactory_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_DesktopNotificationsFactory_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_DesktopNotificationsFactory_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_DesktopNotificationsFactory_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_DesktopNotificationsFactory_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_DesktopNotificationsFactory_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_DesktopNotificationsFactory_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_DesktopNotificationsFactory_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_DesktopNotificationsFactory_spec = {
    "1:PyFalkon.DesktopNotificationsFactory",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_DesktopNotificationsFactory_slots
};

} //extern "C"

static void *Sbk_DesktopNotificationsFactory_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::DesktopNotificationsFactory *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_DesktopNotificationsFactory_Type(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::DesktopNotificationsFactory::Type>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::DesktopNotificationsFactory::Type *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_DesktopNotificationsFactory_Type_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_Type_IDX])))
        return Enum_PythonToCpp_DesktopNotificationsFactory_Type;
    return {};
}

static PyObject *DesktopNotificationsFactory_Type_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::DesktopNotificationsFactory::Type>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::DesktopNotificationsFactory::Type *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void DesktopNotificationsFactory_PythonToCpp_DesktopNotificationsFactory_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_DesktopNotificationsFactory_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_DesktopNotificationsFactory_PythonToCpp_DesktopNotificationsFactory_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_DesktopNotificationsFactory_TypeF()))
        return DesktopNotificationsFactory_PythonToCpp_DesktopNotificationsFactory_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *DesktopNotificationsFactory_PTR_CppToPython_DesktopNotificationsFactory(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::DesktopNotificationsFactory *>(const_cast<void *>(cppIn)), Sbk_DesktopNotificationsFactory_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *DesktopNotificationsFactory_SignatureStrings[] = {
    "PyFalkon.DesktopNotificationsFactory(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.DesktopNotificationsFactory.loadSettings(self)",
    "PyFalkon.DesktopNotificationsFactory.nativeNotificationPreview(self)",
    "1:PyFalkon.DesktopNotificationsFactory.showNotification(self,icon:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage],heading:QString,text:QString)",
    "0:PyFalkon.DesktopNotificationsFactory.showNotification(self,heading:QString,text:QString)",
    "PyFalkon.DesktopNotificationsFactory.supportsNativeNotifications(self)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t DesktopNotificationsFactory_SignatureByteSize = 213;
static constexpr uint8_t DesktopNotificationsFactory_SignatureBytes[213] = {
    0x78, 0xda, 0xa5, 0x91, 0x3f, 0x0b, 0xc2, 0x40, 0x0c, 0xc5, 0xf7, 0x7e, 0x0a, 0x47, 0x85, 0x7a,
    0xe8, 0xe2, 0x50, 0xd0, 0x45, 0x51, 0x5c, 0xf4, 0x4a, 0x71, 0x12, 0x87, 0xb3, 0x8d, 0x1a, 0x3d,
    0x2f, 0xc7, 0x5d, 0xaa, 0xf6, 0xdb, 0x7b, 0xf8, 0x07, 0x45, 0x41, 0x0a, 0x4e, 0x21, 0x2f, 0xbc,
    0x1f, 0x79, 0x89, 0xac, 0xc6, 0x4a, 0x1f, 0xc8, 0x88, 0x11, 0xf8, 0x03, 0x93, 0x9d, 0x11, 0xe3,
    0x06, 0x73, 0xc5, 0x48, 0xc6, 0x8f, 0x55, 0xce, 0xe4, 0xaa, 0xa6, 0x07, 0xbd, 0x89, 0xad, 0x72,
    0x60, 0x38, 0x91, 0x55, 0x86, 0x05, 0xf4, 0x44, 0xca, 0x43, 0x72, 0x20, 0xd2, 0xf9, 0x7a, 0x0f,
    0x39, 0xf7, 0x4d, 0xa9, 0xb5, 0x65, 0xd7, 0x8a, 0x64, 0x0d, 0xa0, 0xd0, 0xa4, 0x8a, 0x0c, 0x98,
    0xd1, 0x6c, 0xfd, 0x8d, 0x5e, 0xd3, 0x67, 0x42, 0x7b, 0x82, 0xf7, 0x91, 0x74, 0x70, 0x42, 0x38,
    0x3f, 0x20, 0xdd, 0xa4, 0x16, 0xc6, 0xef, 0xe8, 0xfc, 0x3e, 0xb8, 0x07, 0xc4, 0x9c, 0x4c, 0xc2,
    0x95, 0x0d, 0x4b, 0x89, 0x85, 0x09, 0xf2, 0xf2, 0x95, 0x75, 0x52, 0xa2, 0x48, 0x25, 0x5e, 0x8e,
    0xca, 0xc6, 0x8d, 0x0f, 0x79, 0x7a, 0x54, 0x5b, 0x58, 0xc5, 0x3b, 0x50, 0x45, 0xb0, 0x26, 0x69,
    0xc6, 0x2e, 0xd4, 0x98, 0xe1, 0xc2, 0xcf, 0xa6, 0x15, 0x75, 0xfe, 0xd9, 0xec, 0x37, 0xba, 0x1e,
    0xb8, 0xb4, 0x96, 0x1c, 0xfb, 0xd9, 0xd7, 0x05, 0x1f, 0x0f, 0x68, 0x0f, 0xd6, 0x44, 0x3a, 0xba,
    0x02, 0x6f, 0xb7, 0xc8, 0x6a
};
#endif

PyTypeObject *init_DesktopNotificationsFactory(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX].type;

    Shiboken::AutoDecRef Sbk_DesktopNotificationsFactory_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_DesktopNotificationsFactory_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "DesktopNotificationsFactory",
        "DesktopNotificationsFactory*",
        &Sbk_DesktopNotificationsFactory_spec,
        &Shiboken::callCppDestructor< DesktopNotificationsFactory >,
        Sbk_DesktopNotificationsFactory_Type_bases.object(),
        0);
    auto *pyType = Sbk_DesktopNotificationsFactory_TypeF(); // references _Sbk_DesktopNotificationsFactory_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, DesktopNotificationsFactory_SignatureStrings);
#else
    InitSignatureBytes(pyType, DesktopNotificationsFactory_SignatureBytes, DesktopNotificationsFactory_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_DesktopNotificationsFactory_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        DesktopNotificationsFactory_PythonToCpp_DesktopNotificationsFactory_PTR,
        is_DesktopNotificationsFactory_PythonToCpp_DesktopNotificationsFactory_PTR_Convertible,
        DesktopNotificationsFactory_PTR_CppToPython_DesktopNotificationsFactory);

    Shiboken::Conversions::registerConverterName(converter, "DesktopNotificationsFactory");
    Shiboken::Conversions::registerConverterName(converter, "DesktopNotificationsFactory*");
    Shiboken::Conversions::registerConverterName(converter, "DesktopNotificationsFactory&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::DesktopNotificationsFactory).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(DesktopNotificationsFactoryWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_DesktopNotificationsFactory_TypeF(), &Sbk_DesktopNotificationsFactory_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_DesktopNotificationsFactory_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Type'.
    const char *Type_Initializer[] = {
        "DesktopNative",
        "PopupWidget",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Type_InitializerValues[] = {
        uint8_t(DesktopNotificationsFactory::Type::DesktopNative), //  0x00  0
        uint8_t(DesktopNotificationsFactory::Type::PopupWidget)    //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_DesktopNotificationsFactory_TypeF(),
        "1:PyFalkon.DesktopNotificationsFactory.Type",
        Type_Initializer, Type_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_DesktopNotificationsFactory_Type_IDX].type = EType;
    // Register converter for enum 'DesktopNotificationsFactory::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            DesktopNotificationsFactory_Type_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_DesktopNotificationsFactory_Type,
            is_Enum_PythonToCpp_DesktopNotificationsFactory_Type_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "DesktopNotificationsFactory::Type");
        Shiboken::Conversions::registerConverterAlias(converter, "Type");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Type' enum.

    DesktopNotificationsFactoryWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::DesktopNotificationsFactory::staticMetaObject, sizeof(DesktopNotificationsFactoryWrapper));

    return pyType;
}
