/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_wavfile_source = R"doc(Read stream from a Microsoft PCM (.wav) file, output floats.

Unless otherwise called, values are within [-1;1]. Check gr_make_wavfile_source() for extra info.

Constructor Specific Documentation:



Args:
    filename : 
    repeat : )doc";


static const char* __doc_gr_blocks_wavfile_source_wavfile_source_0 = R"doc()doc";


static const char* __doc_gr_blocks_wavfile_source_wavfile_source_1 = R"doc()doc";


static const char* __doc_gr_blocks_wavfile_source_make = R"doc(Read stream from a Microsoft PCM (.wav) file, output floats.

Unless otherwise called, values are within [-1;1]. Check gr_make_wavfile_source() for extra info.

Constructor Specific Documentation:



Args:
    filename : 
    repeat : )doc";


static const char* __doc_gr_blocks_wavfile_source_sample_rate = R"doc(Read the sample rate as specified in the wav file header.)doc";


static const char* __doc_gr_blocks_wavfile_source_bits_per_sample = R"doc(Return the number of bits per sample as specified in the wav file header. Only 8 or 16 bit are supported here.)doc";


static const char* __doc_gr_blocks_wavfile_source_channels = R"doc(Return the number of channels in the wav file as specified in the wav file header. This is also the max number of outputs you can have.)doc";
