{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.Dbusmenu.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "set-attr Dbusmenu/MenuitemClass/buildvariant/@type name zzz"
 , "set-attr Dbusmenu/Menuitem/child_find/@return-value nullable 1"
 , "set-attr Dbusmenu/Menuitem/find_id/@return-value nullable 1"
 , "set-attr Dbusmenu/Menuitem/property_get/@return-value nullable 1"
 , "set-attr Dbusmenu/Menuitem/property_get_byte_array/@return-value nullable 1"
 , "set-attr Dbusmenu/Menuitem/property_get_variant/@return-value nullable 1"]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.Dbusmenu.Config"
 , "GI.Dbusmenu"
 , "GI.Dbusmenu.Callbacks"
 , "GI.Dbusmenu.Constants"
 , "GI.Dbusmenu.Enums"
 , "GI.Dbusmenu.Objects"
 , "GI.Dbusmenu.Objects.Client"
 , "GI.Dbusmenu.Objects.Menuitem"
 , "GI.Dbusmenu.Objects.MenuitemProxy"
 , "GI.Dbusmenu.Objects.Server"]
