{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Data type for holding integer-to-integer hash maps.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.MapT
    ( 

-- * Exported types
    MapT(..)                                ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveMapTMethod                       ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype MapT = MapT (SP.ManagedPtr MapT)
    deriving (Eq)

instance SP.ManagedPtrNewtype MapT where
    toManagedPtr (MapT p) = p

foreign import ccall "hb_gobject_map_get_type" c_hb_gobject_map_get_type :: 
    IO GType

type instance O.ParentTypes MapT = '[]
instance O.HasParentTypes MapT

instance B.Types.TypedObject MapT where
    glibType = c_hb_gobject_map_get_type

instance B.Types.GBoxed MapT

-- | Convert t'MapT' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MapT) where
    gvalueGType_ = c_hb_gobject_map_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr MapT)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr MapT)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed MapT ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MapT
type instance O.AttributeList MapT = MapTAttributeList
type MapTAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveMapTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMapTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMapTMethod t MapT, O.OverloadedMethod info MapT p) => OL.IsLabel t (MapT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMapTMethod t MapT, O.OverloadedMethod info MapT p, R.HasField t MapT p) => R.HasField t MapT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMapTMethod t MapT, O.OverloadedMethodInfo info MapT) => OL.IsLabel t (O.MethodProxy info MapT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


