{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Data type for holding variation-axis values.
-- 
-- The minimum, default, and maximum values are in un-normalized, user scales.
-- 
-- \<note>Note: at present, the only flag defined for /@flags@/ is
-- @/HB_OT_VAR_AXIS_FLAG_HIDDEN/@.\<\/note>
-- 
-- /Since: 2.2.0/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.OtVarAxisInfoT
    ( 

-- * Exported types
    OtVarAxisInfoT(..)                      ,
    newZeroOtVarAxisInfoT                   ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveOtVarAxisInfoTMethod             ,
#endif



 -- * Properties


-- ** axisIndex #attr:axisIndex#
-- | Index of the axis in the variation-axis array

    getOtVarAxisInfoTAxisIndex              ,
#if defined(ENABLE_OVERLOADING)
    otVarAxisInfoT_axisIndex                ,
#endif
    setOtVarAxisInfoTAxisIndex              ,


-- ** defaultValue #attr:defaultValue#
-- | The position on the variation axis corresponding to the font\'s defaults

    getOtVarAxisInfoTDefaultValue           ,
#if defined(ENABLE_OVERLOADING)
    otVarAxisInfoT_defaultValue             ,
#endif
    setOtVarAxisInfoTDefaultValue           ,


-- ** flags #attr:flags#
-- | The t'GI.HarfBuzz.Flags.OtVarAxisFlagsT' flags for the axis

    getOtVarAxisInfoTFlags                  ,
#if defined(ENABLE_OVERLOADING)
    otVarAxisInfoT_flags                    ,
#endif
    setOtVarAxisInfoTFlags                  ,


-- ** maxValue #attr:maxValue#
-- | The maximum value on the variation axis that the font covers

    getOtVarAxisInfoTMaxValue               ,
#if defined(ENABLE_OVERLOADING)
    otVarAxisInfoT_maxValue                 ,
#endif
    setOtVarAxisInfoTMaxValue               ,


-- ** minValue #attr:minValue#
-- | The minimum value on the variation axis that the font covers

    getOtVarAxisInfoTMinValue               ,
#if defined(ENABLE_OVERLOADING)
    otVarAxisInfoT_minValue                 ,
#endif
    setOtVarAxisInfoTMinValue               ,


-- ** nameId #attr:nameId#
-- | The @name@ table Name ID that provides display names for the axis

    getOtVarAxisInfoTNameId                 ,
#if defined(ENABLE_OVERLOADING)
    otVarAxisInfoT_nameId                   ,
#endif
    setOtVarAxisInfoTNameId                 ,


-- ** tag #attr:tag#
-- | The @/hb_tag_t/@ tag identifying the design variation of the axis

    getOtVarAxisInfoTTag                    ,
#if defined(ENABLE_OVERLOADING)
    otVarAxisInfoT_tag                      ,
#endif
    setOtVarAxisInfoTTag                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.HarfBuzz.Flags as HarfBuzz.Flags

#else
import {-# SOURCE #-} qualified GI.HarfBuzz.Flags as HarfBuzz.Flags

#endif

-- | Memory-managed wrapper type.
newtype OtVarAxisInfoT = OtVarAxisInfoT (SP.ManagedPtr OtVarAxisInfoT)
    deriving (Eq)

instance SP.ManagedPtrNewtype OtVarAxisInfoT where
    toManagedPtr (OtVarAxisInfoT p) = p

foreign import ccall "hb_gobject_ot_var_axis_info_get_type" c_hb_gobject_ot_var_axis_info_get_type :: 
    IO GType

type instance O.ParentTypes OtVarAxisInfoT = '[]
instance O.HasParentTypes OtVarAxisInfoT

instance B.Types.TypedObject OtVarAxisInfoT where
    glibType = c_hb_gobject_ot_var_axis_info_get_type

instance B.Types.GBoxed OtVarAxisInfoT

-- | Convert t'OtVarAxisInfoT' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe OtVarAxisInfoT) where
    gvalueGType_ = c_hb_gobject_ot_var_axis_info_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr OtVarAxisInfoT)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr OtVarAxisInfoT)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed OtVarAxisInfoT ptr
        else return P.Nothing
        
    

-- | Construct a t'OtVarAxisInfoT' struct initialized to zero.
newZeroOtVarAxisInfoT :: MonadIO m => m OtVarAxisInfoT
newZeroOtVarAxisInfoT = liftIO $ callocBoxedBytes 32 >>= wrapBoxed OtVarAxisInfoT

instance tag ~ 'AttrSet => Constructible OtVarAxisInfoT tag where
    new _ attrs = do
        o <- newZeroOtVarAxisInfoT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@axis_index@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otVarAxisInfoT #axisIndex
-- @
getOtVarAxisInfoTAxisIndex :: MonadIO m => OtVarAxisInfoT -> m Word32
getOtVarAxisInfoTAxisIndex s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@axis_index@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otVarAxisInfoT [ #axisIndex 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtVarAxisInfoTAxisIndex :: MonadIO m => OtVarAxisInfoT -> Word32 -> m ()
setOtVarAxisInfoTAxisIndex s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data OtVarAxisInfoTAxisIndexFieldInfo
instance AttrInfo OtVarAxisInfoTAxisIndexFieldInfo where
    type AttrBaseTypeConstraint OtVarAxisInfoTAxisIndexFieldInfo = (~) OtVarAxisInfoT
    type AttrAllowedOps OtVarAxisInfoTAxisIndexFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtVarAxisInfoTAxisIndexFieldInfo = (~) Word32
    type AttrTransferTypeConstraint OtVarAxisInfoTAxisIndexFieldInfo = (~)Word32
    type AttrTransferType OtVarAxisInfoTAxisIndexFieldInfo = Word32
    type AttrGetType OtVarAxisInfoTAxisIndexFieldInfo = Word32
    type AttrLabel OtVarAxisInfoTAxisIndexFieldInfo = "axis_index"
    type AttrOrigin OtVarAxisInfoTAxisIndexFieldInfo = OtVarAxisInfoT
    attrGet = getOtVarAxisInfoTAxisIndex
    attrSet = setOtVarAxisInfoTAxisIndex
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtVarAxisInfoT.axisIndex"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtVarAxisInfoT.html#g:attr:axisIndex"
        })

otVarAxisInfoT_axisIndex :: AttrLabelProxy "axisIndex"
otVarAxisInfoT_axisIndex = AttrLabelProxy

#endif


-- | Get the value of the “@tag@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otVarAxisInfoT #tag
-- @
getOtVarAxisInfoTTag :: MonadIO m => OtVarAxisInfoT -> m Word32
getOtVarAxisInfoTTag s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Word32
    return val

-- | Set the value of the “@tag@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otVarAxisInfoT [ #tag 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtVarAxisInfoTTag :: MonadIO m => OtVarAxisInfoT -> Word32 -> m ()
setOtVarAxisInfoTTag s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data OtVarAxisInfoTTagFieldInfo
instance AttrInfo OtVarAxisInfoTTagFieldInfo where
    type AttrBaseTypeConstraint OtVarAxisInfoTTagFieldInfo = (~) OtVarAxisInfoT
    type AttrAllowedOps OtVarAxisInfoTTagFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtVarAxisInfoTTagFieldInfo = (~) Word32
    type AttrTransferTypeConstraint OtVarAxisInfoTTagFieldInfo = (~)Word32
    type AttrTransferType OtVarAxisInfoTTagFieldInfo = Word32
    type AttrGetType OtVarAxisInfoTTagFieldInfo = Word32
    type AttrLabel OtVarAxisInfoTTagFieldInfo = "tag"
    type AttrOrigin OtVarAxisInfoTTagFieldInfo = OtVarAxisInfoT
    attrGet = getOtVarAxisInfoTTag
    attrSet = setOtVarAxisInfoTTag
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtVarAxisInfoT.tag"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtVarAxisInfoT.html#g:attr:tag"
        })

otVarAxisInfoT_tag :: AttrLabelProxy "tag"
otVarAxisInfoT_tag = AttrLabelProxy

#endif


-- | Get the value of the “@name_id@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otVarAxisInfoT #nameId
-- @
getOtVarAxisInfoTNameId :: MonadIO m => OtVarAxisInfoT -> m Word32
getOtVarAxisInfoTNameId s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Word32
    return val

-- | Set the value of the “@name_id@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otVarAxisInfoT [ #nameId 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtVarAxisInfoTNameId :: MonadIO m => OtVarAxisInfoT -> Word32 -> m ()
setOtVarAxisInfoTNameId s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data OtVarAxisInfoTNameIdFieldInfo
instance AttrInfo OtVarAxisInfoTNameIdFieldInfo where
    type AttrBaseTypeConstraint OtVarAxisInfoTNameIdFieldInfo = (~) OtVarAxisInfoT
    type AttrAllowedOps OtVarAxisInfoTNameIdFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtVarAxisInfoTNameIdFieldInfo = (~) Word32
    type AttrTransferTypeConstraint OtVarAxisInfoTNameIdFieldInfo = (~)Word32
    type AttrTransferType OtVarAxisInfoTNameIdFieldInfo = Word32
    type AttrGetType OtVarAxisInfoTNameIdFieldInfo = Word32
    type AttrLabel OtVarAxisInfoTNameIdFieldInfo = "name_id"
    type AttrOrigin OtVarAxisInfoTNameIdFieldInfo = OtVarAxisInfoT
    attrGet = getOtVarAxisInfoTNameId
    attrSet = setOtVarAxisInfoTNameId
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtVarAxisInfoT.nameId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtVarAxisInfoT.html#g:attr:nameId"
        })

otVarAxisInfoT_nameId :: AttrLabelProxy "nameId"
otVarAxisInfoT_nameId = AttrLabelProxy

#endif


-- | Get the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otVarAxisInfoT #flags
-- @
getOtVarAxisInfoTFlags :: MonadIO m => OtVarAxisInfoT -> m [HarfBuzz.Flags.OtVarAxisFlagsT]
getOtVarAxisInfoTFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otVarAxisInfoT [ #flags 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtVarAxisInfoTFlags :: MonadIO m => OtVarAxisInfoT -> [HarfBuzz.Flags.OtVarAxisFlagsT] -> m ()
setOtVarAxisInfoTFlags s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 12) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data OtVarAxisInfoTFlagsFieldInfo
instance AttrInfo OtVarAxisInfoTFlagsFieldInfo where
    type AttrBaseTypeConstraint OtVarAxisInfoTFlagsFieldInfo = (~) OtVarAxisInfoT
    type AttrAllowedOps OtVarAxisInfoTFlagsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtVarAxisInfoTFlagsFieldInfo = (~) [HarfBuzz.Flags.OtVarAxisFlagsT]
    type AttrTransferTypeConstraint OtVarAxisInfoTFlagsFieldInfo = (~)[HarfBuzz.Flags.OtVarAxisFlagsT]
    type AttrTransferType OtVarAxisInfoTFlagsFieldInfo = [HarfBuzz.Flags.OtVarAxisFlagsT]
    type AttrGetType OtVarAxisInfoTFlagsFieldInfo = [HarfBuzz.Flags.OtVarAxisFlagsT]
    type AttrLabel OtVarAxisInfoTFlagsFieldInfo = "flags"
    type AttrOrigin OtVarAxisInfoTFlagsFieldInfo = OtVarAxisInfoT
    attrGet = getOtVarAxisInfoTFlags
    attrSet = setOtVarAxisInfoTFlags
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtVarAxisInfoT.flags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtVarAxisInfoT.html#g:attr:flags"
        })

otVarAxisInfoT_flags :: AttrLabelProxy "flags"
otVarAxisInfoT_flags = AttrLabelProxy

#endif


-- | Get the value of the “@min_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otVarAxisInfoT #minValue
-- @
getOtVarAxisInfoTMinValue :: MonadIO m => OtVarAxisInfoT -> m Float
getOtVarAxisInfoTMinValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@min_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otVarAxisInfoT [ #minValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtVarAxisInfoTMinValue :: MonadIO m => OtVarAxisInfoT -> Float -> m ()
setOtVarAxisInfoTMinValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 16) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data OtVarAxisInfoTMinValueFieldInfo
instance AttrInfo OtVarAxisInfoTMinValueFieldInfo where
    type AttrBaseTypeConstraint OtVarAxisInfoTMinValueFieldInfo = (~) OtVarAxisInfoT
    type AttrAllowedOps OtVarAxisInfoTMinValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtVarAxisInfoTMinValueFieldInfo = (~) Float
    type AttrTransferTypeConstraint OtVarAxisInfoTMinValueFieldInfo = (~)Float
    type AttrTransferType OtVarAxisInfoTMinValueFieldInfo = Float
    type AttrGetType OtVarAxisInfoTMinValueFieldInfo = Float
    type AttrLabel OtVarAxisInfoTMinValueFieldInfo = "min_value"
    type AttrOrigin OtVarAxisInfoTMinValueFieldInfo = OtVarAxisInfoT
    attrGet = getOtVarAxisInfoTMinValue
    attrSet = setOtVarAxisInfoTMinValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtVarAxisInfoT.minValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtVarAxisInfoT.html#g:attr:minValue"
        })

otVarAxisInfoT_minValue :: AttrLabelProxy "minValue"
otVarAxisInfoT_minValue = AttrLabelProxy

#endif


-- | Get the value of the “@default_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otVarAxisInfoT #defaultValue
-- @
getOtVarAxisInfoTDefaultValue :: MonadIO m => OtVarAxisInfoT -> m Float
getOtVarAxisInfoTDefaultValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@default_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otVarAxisInfoT [ #defaultValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtVarAxisInfoTDefaultValue :: MonadIO m => OtVarAxisInfoT -> Float -> m ()
setOtVarAxisInfoTDefaultValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 20) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data OtVarAxisInfoTDefaultValueFieldInfo
instance AttrInfo OtVarAxisInfoTDefaultValueFieldInfo where
    type AttrBaseTypeConstraint OtVarAxisInfoTDefaultValueFieldInfo = (~) OtVarAxisInfoT
    type AttrAllowedOps OtVarAxisInfoTDefaultValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtVarAxisInfoTDefaultValueFieldInfo = (~) Float
    type AttrTransferTypeConstraint OtVarAxisInfoTDefaultValueFieldInfo = (~)Float
    type AttrTransferType OtVarAxisInfoTDefaultValueFieldInfo = Float
    type AttrGetType OtVarAxisInfoTDefaultValueFieldInfo = Float
    type AttrLabel OtVarAxisInfoTDefaultValueFieldInfo = "default_value"
    type AttrOrigin OtVarAxisInfoTDefaultValueFieldInfo = OtVarAxisInfoT
    attrGet = getOtVarAxisInfoTDefaultValue
    attrSet = setOtVarAxisInfoTDefaultValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtVarAxisInfoT.defaultValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtVarAxisInfoT.html#g:attr:defaultValue"
        })

otVarAxisInfoT_defaultValue :: AttrLabelProxy "defaultValue"
otVarAxisInfoT_defaultValue = AttrLabelProxy

#endif


-- | Get the value of the “@max_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otVarAxisInfoT #maxValue
-- @
getOtVarAxisInfoTMaxValue :: MonadIO m => OtVarAxisInfoT -> m Float
getOtVarAxisInfoTMaxValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@max_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otVarAxisInfoT [ #maxValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtVarAxisInfoTMaxValue :: MonadIO m => OtVarAxisInfoT -> Float -> m ()
setOtVarAxisInfoTMaxValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 24) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data OtVarAxisInfoTMaxValueFieldInfo
instance AttrInfo OtVarAxisInfoTMaxValueFieldInfo where
    type AttrBaseTypeConstraint OtVarAxisInfoTMaxValueFieldInfo = (~) OtVarAxisInfoT
    type AttrAllowedOps OtVarAxisInfoTMaxValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtVarAxisInfoTMaxValueFieldInfo = (~) Float
    type AttrTransferTypeConstraint OtVarAxisInfoTMaxValueFieldInfo = (~)Float
    type AttrTransferType OtVarAxisInfoTMaxValueFieldInfo = Float
    type AttrGetType OtVarAxisInfoTMaxValueFieldInfo = Float
    type AttrLabel OtVarAxisInfoTMaxValueFieldInfo = "max_value"
    type AttrOrigin OtVarAxisInfoTMaxValueFieldInfo = OtVarAxisInfoT
    attrGet = getOtVarAxisInfoTMaxValue
    attrSet = setOtVarAxisInfoTMaxValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtVarAxisInfoT.maxValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtVarAxisInfoT.html#g:attr:maxValue"
        })

otVarAxisInfoT_maxValue :: AttrLabelProxy "maxValue"
otVarAxisInfoT_maxValue = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList OtVarAxisInfoT
type instance O.AttributeList OtVarAxisInfoT = OtVarAxisInfoTAttributeList
type OtVarAxisInfoTAttributeList = ('[ '("axisIndex", OtVarAxisInfoTAxisIndexFieldInfo), '("tag", OtVarAxisInfoTTagFieldInfo), '("nameId", OtVarAxisInfoTNameIdFieldInfo), '("flags", OtVarAxisInfoTFlagsFieldInfo), '("minValue", OtVarAxisInfoTMinValueFieldInfo), '("defaultValue", OtVarAxisInfoTDefaultValueFieldInfo), '("maxValue", OtVarAxisInfoTMaxValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveOtVarAxisInfoTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOtVarAxisInfoTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOtVarAxisInfoTMethod t OtVarAxisInfoT, O.OverloadedMethod info OtVarAxisInfoT p) => OL.IsLabel t (OtVarAxisInfoT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOtVarAxisInfoTMethod t OtVarAxisInfoT, O.OverloadedMethod info OtVarAxisInfoT p, R.HasField t OtVarAxisInfoT p) => R.HasField t OtVarAxisInfoT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOtVarAxisInfoTMethod t OtVarAxisInfoT, O.OverloadedMethodInfo info OtVarAxisInfoT) => OL.IsLabel t (O.MethodProxy info OtVarAxisInfoT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


