
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kpixmapsequence_wrapper.h"

// Argument includes
#include <QString>
#include <kpixmapsequence.h>
#include <qpixmap.h>
#include <qsize.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KPixmapSequence_Type = nullptr;
static PyTypeObject *Sbk_KPixmapSequence_TypeF(void)
{
    return _Sbk_KPixmapSequence_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KPixmapSequence_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KPixmapSequence >()))
        return -1;

    ::KPixmapSequence *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]);

    if (PyArg_ParseTuple(args, "|OO:KPixmapSequence", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KPixmapSequence::KPixmapSequence()
    // 1: KPixmapSequence::KPixmapSequence(KPixmapSequence)
    // 2: KPixmapSequence::KPixmapSequence(QPixmap,const QSize&=)
    // 3: KPixmapSequence::KPixmapSequence(QString,int)
    if (numArgs == 0) {
        overloadId = 0; // KPixmapSequence()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 3; // KPixmapSequence(QString,int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // KPixmapSequence(QPixmap,QSize)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), (pyArgs[1])))) {
            overloadId = 2; // KPixmapSequence(QPixmap,QSize)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KPixmapSequence(KPixmapSequence)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KPixmapSequence()
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]);
            }

            // KPixmapSequence()
            cptr = new ::KPixmapSequence();
            break;
        }
        case 1: // KPixmapSequence(const KPixmapSequence &other)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KPixmapSequence *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KPixmapSequence(KPixmapSequence)
                cptr = new ::KPixmapSequence(*cppArg0);
            }
            break;
        }
        case 2: // KPixmapSequence(const QPixmap &pixmap, const QSize &frameSize)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"frameSize", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPixmap cppArg0_local;
            ::QPixmap *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QSize cppArg1_local = QSize();
            ::QSize *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
                if (pythonToCpp[1].isValue())
                    pythonToCpp[1](pyArgs[1], &cppArg1_local);
                else
                    pythonToCpp[1](pyArgs[1], &cppArg1);
                }

            if (Shiboken::Errors::occurred() == nullptr) {
                // KPixmapSequence(QPixmap,QSize)
                cptr = new ::KPixmapSequence(*cppArg0, *cppArg1);
            }
            break;
        }
        case 3: // KPixmapSequence(const QString &fullPath, int size)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KPixmapSequence(QString,int)
                cptr = new ::KPixmapSequence(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KPixmapSequence >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KPixmapSequenceFunc_frameAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequence *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPixmapSequence::frameAt(int)const->QPixmap
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // frameAt(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "frameAt", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // frameAt(int)const
            QPixmap cppResult = const_cast<const ::KPixmapSequence *>(cppSelf)->frameAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapSequenceFunc_frameCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequence *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // frameCount()const
        int cppResult = const_cast<const ::KPixmapSequence *>(cppSelf)->frameCount();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapSequenceFunc_frameSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequence *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // frameSize()const
        QSize cppResult = const_cast<const ::KPixmapSequence *>(cppSelf)->frameSize();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapSequenceFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequence *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isEmpty()const
        bool cppResult = const_cast<const ::KPixmapSequence *>(cppSelf)->isEmpty();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPixmapSequenceFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPixmapSequence *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::KPixmapSequence *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KPixmapSequence_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KPixmapSequence_methods[] = {
    {"frameAt", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceFunc_frameAt), METH_O, nullptr},
    {"frameCount", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceFunc_frameCount), METH_NOARGS, nullptr},
    {"frameSize", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceFunc_frameSize), METH_NOARGS, nullptr},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceFunc_isEmpty), METH_NOARGS, nullptr},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_KPixmapSequenceFunc_isValid), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KPixmapSequence_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KPixmapSequence_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KPixmapSequence_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KPixmapSequence_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KPixmapSequence_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KPixmapSequence_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KPixmapSequence_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KPixmapSequence_spec = {
    "1:KWidgetsAddons.KPixmapSequence",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KPixmapSequence_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KPixmapSequence_PythonToCpp_KPixmapSequence_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KPixmapSequence_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KPixmapSequence_PythonToCpp_KPixmapSequence_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KPixmapSequence_TypeF()))
        return KPixmapSequence_PythonToCpp_KPixmapSequence_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KPixmapSequence_PTR_CppToPython_KPixmapSequence(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KPixmapSequence_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KPixmapSequence_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KPixmapSequence_SignatureStrings[] = {
    "3:KWidgetsAddons.KPixmapSequence(self)",
    "2:KWidgetsAddons.KPixmapSequence(self,other:KWidgetsAddons.KPixmapSequence)",
    "1:KWidgetsAddons.KPixmapSequence(self,pixmap:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage],frameSize:PySide6.QtCore.QSize=QSize())",
    "0:KWidgetsAddons.KPixmapSequence(self,fullPath:QString,size:int)",
    "KWidgetsAddons.KPixmapSequence.frameAt(self,index:int)->PySide6.QtGui.QPixmap",
    "KWidgetsAddons.KPixmapSequence.frameCount(self)->int",
    "KWidgetsAddons.KPixmapSequence.frameSize(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KPixmapSequence.isEmpty(self)->bool",
    "KWidgetsAddons.KPixmapSequence.isValid(self)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t KPixmapSequence_SignatureByteSize = 222;
static constexpr uint8_t KPixmapSequence_SignatureBytes[222] = {
    0x78, 0xda, 0x8d, 0x90, 0xc1, 0x8a, 0xc2, 0x30, 0x10, 0x86, 0xef, 0x7d, 0x8a, 0x3d, 0x1a, 0xa8,
    0x41, 0x5d, 0xf0, 0x50, 0x50, 0x10, 0x59, 0x16, 0xf1, 0xd2, 0x52, 0xd4, 0x83, 0xec, 0x21, 0x9a,
    0x69, 0x1d, 0x48, 0x93, 0xda, 0x4c, 0xc1, 0xfa, 0xf4, 0xd6, 0x54, 0x59, 0x5c, 0x64, 0x9b, 0x4b,
    0x0e, 0x7f, 0xe6, 0xfb, 0xf8, 0x67, 0x3e, 0xa3, 0xf5, 0x0e, 0x65, 0x0e, 0x64, 0x17, 0x52, 0x1a,
    0x6d, 0xf9, 0x3a, 0xc6, 0x4b, 0x21, 0xca, 0x14, 0xce, 0x35, 0xe8, 0x23, 0x0c, 0x2c, 0xa8, 0x8c,
    0x05, 0x13, 0x9f, 0xb1, 0xd0, 0xd0, 0x09, 0xaa, 0x9e, 0x49, 0x16, 0x8c, 0xbd, 0x5c, 0xa5, 0xcb,
    0x22, 0x6a, 0x4a, 0xd4, 0x39, 0xdf, 0x68, 0x34, 0x7a, 0x1f, 0x37, 0x29, 0x4a, 0x98, 0xf2, 0x84,
    0xbe, 0x6b, 0xe4, 0x49, 0x87, 0x85, 0x1f, 0x7f, 0xe2, 0x55, 0x21, 0x72, 0xf8, 0x09, 0xb3, 0x4a,
    0x14, 0x90, 0xe2, 0x15, 0xa2, 0xdf, 0xff, 0xa5, 0xa9, 0x80, 0x27, 0xf7, 0x70, 0xe6, 0xde, 0x01,
    0x63, 0xc1, 0xc8, 0xab, 0x4e, 0x56, 0x2b, 0x15, 0x0b, 0x3a, 0x45, 0x49, 0x4a, 0x55, 0xdb, 0x28,
    0xb4, 0x77, 0x33, 0x6a, 0x62, 0xc1, 0xff, 0x38, 0x77, 0x3d, 0x16, 0xd4, 0x69, 0x50, 0x4b, 0xb8,
    0x38, 0x6c, 0x38, 0x7f, 0xbb, 0x8d, 0x97, 0x6d, 0x69, 0x6a, 0xdd, 0x09, 0x5b, 0x4d, 0x2b, 0xf3,
    0x82, 0xdc, 0xbe, 0x0f, 0xe6, 0xdd, 0x45, 0xfa, 0x24, 0x68, 0xbf, 0x8a, 0x92, 0x9a, 0xa7, 0xe2,
    0x60, 0x8c, 0xea, 0x47, 0xb6, 0x42, 0xa1, 0x7c, 0x41, 0x6e, 0x83, 0xf3, 0xe3, 0x87
};
#endif

PyTypeObject *init_KPixmapSequence(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX].type;

    Shiboken::AutoDecRef Sbk_KPixmapSequence_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KPixmapSequence_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KPixmapSequence",
        "KPixmapSequence*",
        &Sbk_KPixmapSequence_spec,
        &Shiboken::callCppDestructor< ::KPixmapSequence >,
        Sbk_KPixmapSequence_Type_bases.object(),
        0);
    auto *pyType = Sbk_KPixmapSequence_TypeF(); // references _Sbk_KPixmapSequence_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KPixmapSequence_SignatureStrings);
#else
    InitSignatureBytes(pyType, KPixmapSequence_SignatureBytes, KPixmapSequence_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KPixmapSequence_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequence_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KPixmapSequence_PythonToCpp_KPixmapSequence_PTR,
        is_KPixmapSequence_PythonToCpp_KPixmapSequence_PTR_Convertible,
        KPixmapSequence_PTR_CppToPython_KPixmapSequence);

    Shiboken::Conversions::registerConverterName(converter, "KPixmapSequence");
    Shiboken::Conversions::registerConverterName(converter, "KPixmapSequence*");
    Shiboken::Conversions::registerConverterName(converter, "KPixmapSequence&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KPixmapSequence).name());

    qRegisterMetaType< ::KPixmapSequence *>();

    return pyType;
}
