/* toggle-box.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from toggle-box.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Michael Terry <michael.terry@canonical.com>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#define grid_size 40
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TOGGLE_BOX (toggle_box_get_type ())
#define TOGGLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOGGLE_BOX, ToggleBox))
#define TOGGLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOGGLE_BOX, ToggleBoxClass))
#define IS_TOGGLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOGGLE_BOX))
#define IS_TOGGLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOGGLE_BOX))
#define TOGGLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOGGLE_BOX, ToggleBoxClass))

typedef struct _ToggleBox ToggleBox;
typedef struct _ToggleBoxClass ToggleBoxClass;
typedef struct _ToggleBoxPrivate ToggleBoxPrivate;
enum  {
	TOGGLE_BOX_0_PROPERTY,
	TOGGLE_BOX_DEFAULT_KEY_PROPERTY,
	TOGGLE_BOX_STARTING_KEY_PROPERTY,
	TOGGLE_BOX_SELECTED_KEY_PROPERTY,
	TOGGLE_BOX_NUM_PROPERTIES
};
static GParamSpec* toggle_box_properties[TOGGLE_BOX_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_FLAT_BUTTON (flat_button_get_type ())
#define FLAT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAT_BUTTON, FlatButton))
#define FLAT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FLAT_BUTTON, FlatButtonClass))
#define IS_FLAT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAT_BUTTON))
#define IS_FLAT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FLAT_BUTTON))
#define FLAT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FLAT_BUTTON, FlatButtonClass))

typedef struct _FlatButton FlatButton;
typedef struct _FlatButtonClass FlatButtonClass;

#define TYPE_CACHED_IMAGE (cached_image_get_type ())
#define CACHED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CACHED_IMAGE, CachedImage))
#define CACHED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CACHED_IMAGE, CachedImageClass))
#define IS_CACHED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CACHED_IMAGE))
#define IS_CACHED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CACHED_IMAGE))
#define CACHED_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CACHED_IMAGE, CachedImageClass))

typedef struct _CachedImage CachedImage;
typedef struct _CachedImageClass CachedImageClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ToggleBox {
	GtkBox parent_instance;
	ToggleBoxPrivate * priv;
	GtkBox* scrolled_box;
};

struct _ToggleBoxClass {
	GtkBoxClass parent_class;
};

struct _ToggleBoxPrivate {
	gchar* _default_key;
	gchar* _starting_key;
	gchar* _selected_key;
	GtkButton* selected_button;
};

static gint ToggleBox_private_offset;
static gpointer toggle_box_parent_class = NULL;

VALA_EXTERN GType toggle_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ToggleBox, g_object_unref)
VALA_EXTERN ToggleBox* toggle_box_new (const gchar* default_key,
                           const gchar* starting_key);
VALA_EXTERN ToggleBox* toggle_box_construct (GType object_type,
                                 const gchar* default_key,
                                 const gchar* starting_key);
VALA_EXTERN void toggle_box_add_item (ToggleBox* self,
                          const gchar* key,
                          const gchar* label,
                          GdkPixbuf* icon);
static GtkButton* toggle_box_make_button (ToggleBox* self,
                                   const gchar* key,
                                   const gchar* name_in,
                                   GdkPixbuf* icon);
VALA_EXTERN const gchar* toggle_box_get_starting_key (ToggleBox* self);
VALA_EXTERN const gchar* toggle_box_get_default_key (ToggleBox* self);
static void toggle_box_select (ToggleBox* self,
                        GtkButton* button);
static gboolean toggle_box_real_draw (GtkWidget* base,
                               cairo_t* c);
VALA_EXTERN void cairo_utils_rounded_rectangle (cairo_t* c,
                                    gdouble x,
                                    gdouble y,
                                    gdouble width,
                                    gdouble height,
                                    gdouble radius);
VALA_EXTERN void toggle_box_set_selected_key (ToggleBox* self,
                                  const gchar* value);
VALA_EXTERN GType flat_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FlatButton, g_object_unref)
VALA_EXTERN FlatButton* flat_button_new (void);
VALA_EXTERN FlatButton* flat_button_construct (GType object_type);
static void toggle_box_button_clicked_cb (ToggleBox* self,
                                   GtkButton* button);
static void _toggle_box_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
VALA_EXTERN GType cached_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CachedImage, g_object_unref)
VALA_EXTERN CachedImage* cached_image_new (GdkPixbuf* pixbuf);
VALA_EXTERN CachedImage* cached_image_construct (GType object_type,
                                     GdkPixbuf* pixbuf);
static void toggle_box_real_grab_focus (GtkWidget* base);
static void toggle_box_set_default_key (ToggleBox* self,
                                 const gchar* value);
static void toggle_box_set_starting_key (ToggleBox* self,
                                  const gchar* value);
VALA_EXTERN const gchar* toggle_box_get_selected_key (ToggleBox* self);
static GObject * toggle_box_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
static void toggle_box_finalize (GObject * obj);
static GType toggle_box_get_type_once (void);
static void _vala_toggle_box_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_toggle_box_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
toggle_box_get_instance_private (ToggleBox* self)
{
	return G_STRUCT_MEMBER_P (self, ToggleBox_private_offset);
}

ToggleBox*
toggle_box_construct (GType object_type,
                      const gchar* default_key,
                      const gchar* starting_key)
{
	ToggleBox * self = NULL;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
#line 29 "../src/toggle-box.vala"
	self = (ToggleBox*) g_object_new (object_type, "default-key", default_key, "starting-key", starting_key, "selected-key", starting_key, NULL);
#line 31 "../src/toggle-box.vala"
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 31 "../src/toggle-box.vala"
	g_object_ref_sink (_tmp0_);
#line 31 "../src/toggle-box.vala"
	scrolled_window = _tmp0_;
#line 32 "../src/toggle-box.vala"
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
#line 32 "../src/toggle-box.vala"
	g_object_ref_sink (_tmp1_);
#line 32 "../src/toggle-box.vala"
	_g_object_unref0 (self->scrolled_box);
#line 32 "../src/toggle-box.vala"
	self->scrolled_box = _tmp1_;
#line 33 "../src/toggle-box.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) scrolled_window);
#line 34 "../src/toggle-box.vala"
	_tmp2_ = self->scrolled_box;
#line 34 "../src/toggle-box.vala"
	gtk_container_add ((GtkContainer*) scrolled_window, (GtkWidget*) _tmp2_);
#line 35 "../src/toggle-box.vala"
	gtk_widget_show ((GtkWidget*) scrolled_window);
#line 36 "../src/toggle-box.vala"
	_tmp3_ = self->scrolled_box;
#line 36 "../src/toggle-box.vala"
	gtk_widget_show ((GtkWidget*) _tmp3_);
#line 37 "../src/toggle-box.vala"
	gtk_scrolled_window_set_max_content_height (scrolled_window, 210);
#line 38 "../src/toggle-box.vala"
	gtk_scrolled_window_set_propagate_natural_height (scrolled_window, TRUE);
#line 39 "../src/toggle-box.vala"
	gtk_scrolled_window_set_policy (scrolled_window, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
#line 40 "../src/toggle-box.vala"
	gtk_scrolled_window_set_shadow_type (scrolled_window, GTK_SHADOW_NONE);
#line 27 "../src/toggle-box.vala"
	_g_object_unref0 (scrolled_window);
#line 27 "../src/toggle-box.vala"
	return self;
#line 237 "toggle-box.c"
}

ToggleBox*
toggle_box_new (const gchar* default_key,
                const gchar* starting_key)
{
#line 27 "../src/toggle-box.vala"
	return toggle_box_construct (TYPE_TOGGLE_BOX, default_key, starting_key);
#line 246 "toggle-box.c"
}

void
toggle_box_add_item (ToggleBox* self,
                     const gchar* key,
                     const gchar* label,
                     GdkPixbuf* icon)
{
	GtkButton* item = NULL;
	GtkButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GList* _tmp3_;
	GList* _tmp4_;
	gboolean _tmp5_;
	GtkButton* _tmp11_;
	GtkBox* _tmp12_;
	GtkButton* _tmp13_;
#line 43 "../src/toggle-box.vala"
	g_return_if_fail (self != NULL);
#line 43 "../src/toggle-box.vala"
	g_return_if_fail (key != NULL);
#line 43 "../src/toggle-box.vala"
	g_return_if_fail (label != NULL);
#line 45 "../src/toggle-box.vala"
	_tmp0_ = toggle_box_make_button (self, key, label, icon);
#line 45 "../src/toggle-box.vala"
	item = _tmp0_;
#line 47 "../src/toggle-box.vala"
	_tmp3_ = gtk_container_get_children ((GtkContainer*) self);
#line 47 "../src/toggle-box.vala"
	_tmp4_ = _tmp3_;
#line 47 "../src/toggle-box.vala"
	_tmp5_ = _tmp4_ == NULL;
#line 47 "../src/toggle-box.vala"
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (g_list_free (_tmp4_), NULL));
#line 47 "../src/toggle-box.vala"
	if (_tmp5_) {
#line 47 "../src/toggle-box.vala"
		_tmp2_ = TRUE;
#line 287 "toggle-box.c"
	} else {
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
#line 48 "../src/toggle-box.vala"
		_tmp7_ = self->priv->_starting_key;
#line 48 "../src/toggle-box.vala"
		if (_tmp7_ == NULL) {
#line 295 "toggle-box.c"
			const gchar* _tmp8_;
#line 48 "../src/toggle-box.vala"
			_tmp8_ = self->priv->_default_key;
#line 48 "../src/toggle-box.vala"
			_tmp6_ = g_strcmp0 (_tmp8_, key) == 0;
#line 301 "toggle-box.c"
		} else {
#line 48 "../src/toggle-box.vala"
			_tmp6_ = FALSE;
#line 305 "toggle-box.c"
		}
#line 48 "../src/toggle-box.vala"
		_tmp2_ = _tmp6_;
#line 309 "toggle-box.c"
	}
#line 47 "../src/toggle-box.vala"
	if (_tmp2_) {
#line 47 "../src/toggle-box.vala"
		_tmp1_ = TRUE;
#line 315 "toggle-box.c"
	} else {
		const gchar* _tmp9_;
#line 49 "../src/toggle-box.vala"
		_tmp9_ = self->priv->_starting_key;
#line 49 "../src/toggle-box.vala"
		_tmp1_ = g_strcmp0 (_tmp9_, key) == 0;
#line 322 "toggle-box.c"
	}
#line 47 "../src/toggle-box.vala"
	if (_tmp1_) {
#line 326 "toggle-box.c"
		GtkButton* _tmp10_;
#line 50 "../src/toggle-box.vala"
		_tmp10_ = item;
#line 50 "../src/toggle-box.vala"
		toggle_box_select (self, _tmp10_);
#line 332 "toggle-box.c"
	}
#line 52 "../src/toggle-box.vala"
	_tmp11_ = item;
#line 52 "../src/toggle-box.vala"
	gtk_widget_show ((GtkWidget*) _tmp11_);
#line 53 "../src/toggle-box.vala"
	_tmp12_ = self->scrolled_box;
#line 53 "../src/toggle-box.vala"
	_tmp13_ = item;
#line 53 "../src/toggle-box.vala"
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
#line 43 "../src/toggle-box.vala"
	_g_object_unref0 (item);
#line 346 "toggle-box.c"
}

static gboolean
toggle_box_real_draw (GtkWidget* base,
                      cairo_t* c)
{
	ToggleBox * self;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_;
	GtkAllocation _tmp2_;
	gboolean result;
#line 63 "../src/toggle-box.vala"
	self = (ToggleBox*) base;
#line 63 "../src/toggle-box.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 66 "../src/toggle-box.vala"
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
#line 66 "../src/toggle-box.vala"
	allocation = _tmp0_;
#line 68 "../src/toggle-box.vala"
	_tmp1_ = allocation;
#line 68 "../src/toggle-box.vala"
	_tmp2_ = allocation;
#line 68 "../src/toggle-box.vala"
	cairo_utils_rounded_rectangle (c, (gdouble) 0, (gdouble) 0, (gdouble) _tmp1_.width, (gdouble) _tmp2_.height, 0.1 * grid_size);
#line 70 "../src/toggle-box.vala"
	cairo_set_source_rgba (c, 0.5, 0.5, 0.5, 0.5);
#line 71 "../src/toggle-box.vala"
	cairo_set_line_width (c, (gdouble) 1);
#line 72 "../src/toggle-box.vala"
	cairo_stroke (c);
#line 74 "../src/toggle-box.vala"
	result = GTK_WIDGET_CLASS (toggle_box_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox), c);
#line 74 "../src/toggle-box.vala"
	return result;
#line 383 "toggle-box.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 84 "../src/toggle-box.vala"
	return self ? g_object_ref (self) : NULL;
#line 391 "toggle-box.c"
}

static void
toggle_box_select (ToggleBox* self,
                   GtkButton* button)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkButton* _tmp8_;
	gconstpointer _tmp9_;
#line 77 "../src/toggle-box.vala"
	g_return_if_fail (self != NULL);
#line 77 "../src/toggle-box.vala"
	g_return_if_fail (button != NULL);
#line 79 "../src/toggle-box.vala"
	_tmp0_ = self->priv->selected_button;
#line 79 "../src/toggle-box.vala"
	if (_tmp0_ != NULL) {
#line 413 "toggle-box.c"
		GtkButton* _tmp1_;
		GtkButton* _tmp2_;
		GtkStyleContext* _tmp3_;
#line 81 "../src/toggle-box.vala"
		_tmp1_ = self->priv->selected_button;
#line 81 "../src/toggle-box.vala"
		gtk_button_set_relief (_tmp1_, GTK_RELIEF_NONE);
#line 82 "../src/toggle-box.vala"
		_tmp2_ = self->priv->selected_button;
#line 82 "../src/toggle-box.vala"
		_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
#line 82 "../src/toggle-box.vala"
		gtk_style_context_remove_class (_tmp3_, "selected");
#line 427 "toggle-box.c"
	}
#line 84 "../src/toggle-box.vala"
	_tmp4_ = _g_object_ref0 (button);
#line 84 "../src/toggle-box.vala"
	_g_object_unref0 (self->priv->selected_button);
#line 84 "../src/toggle-box.vala"
	self->priv->selected_button = _tmp4_;
#line 85 "../src/toggle-box.vala"
	_tmp5_ = self->priv->selected_button;
#line 85 "../src/toggle-box.vala"
	gtk_button_set_relief (_tmp5_, GTK_RELIEF_NORMAL);
#line 86 "../src/toggle-box.vala"
	_tmp6_ = self->priv->selected_button;
#line 86 "../src/toggle-box.vala"
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
#line 86 "../src/toggle-box.vala"
	gtk_style_context_add_class (_tmp7_, "selected");
#line 87 "../src/toggle-box.vala"
	_tmp8_ = self->priv->selected_button;
#line 87 "../src/toggle-box.vala"
	_tmp9_ = g_object_get_data ((GObject*) _tmp8_, "toggle-list-key");
#line 87 "../src/toggle-box.vala"
	toggle_box_set_selected_key (self, (const gchar*) _tmp9_);
#line 451 "toggle-box.c"
}

static void
_toggle_box_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
#line 95 "../src/toggle-box.vala"
	toggle_box_button_clicked_cb ((ToggleBox*) self, _sender);
#line 460 "toggle-box.c"
}

static GtkButton*
toggle_box_make_button (ToggleBox* self,
                        const gchar* key,
                        const gchar* name_in,
                        GdkPixbuf* icon)
{
	FlatButton* item = NULL;
	FlatButton* _tmp0_;
	FlatButton* _tmp1_;
	GtkStyleContext* _tmp2_;
	FlatButton* _tmp3_;
	FlatButton* _tmp4_;
	GtkBox* hbox = NULL;
	GtkBox* _tmp5_;
	gchar* name = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GtkBox* _tmp17_;
	FlatButton* _tmp18_;
	FlatButton* _tmp19_;
	GtkBox* _tmp20_;
	GtkBox* _tmp21_;
	FlatButton* _tmp27_;
	gchar* _tmp28_;
	GError* _inner_error0_ = NULL;
	GtkButton* result;
#line 90 "../src/toggle-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 90 "../src/toggle-box.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 90 "../src/toggle-box.vala"
	g_return_val_if_fail (name_in != NULL, NULL);
#line 92 "../src/toggle-box.vala"
	_tmp0_ = flat_button_new ();
#line 92 "../src/toggle-box.vala"
	g_object_ref_sink (_tmp0_);
#line 92 "../src/toggle-box.vala"
	item = _tmp0_;
#line 93 "../src/toggle-box.vala"
	_tmp1_ = item;
#line 93 "../src/toggle-box.vala"
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
#line 93 "../src/toggle-box.vala"
	gtk_style_context_add_class (_tmp2_, "toggle-button");
#line 94 "../src/toggle-box.vala"
	_tmp3_ = item;
#line 94 "../src/toggle-box.vala"
	gtk_button_set_relief ((GtkButton*) _tmp3_, GTK_RELIEF_NONE);
#line 95 "../src/toggle-box.vala"
	_tmp4_ = item;
#line 95 "../src/toggle-box.vala"
	g_signal_connect_object ((GtkButton*) _tmp4_, "clicked", (GCallback) _toggle_box_button_clicked_cb_gtk_button_clicked, self, 0);
#line 97 "../src/toggle-box.vala"
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
#line 97 "../src/toggle-box.vala"
	g_object_ref_sink (_tmp5_);
#line 97 "../src/toggle-box.vala"
	hbox = _tmp5_;
#line 99 "../src/toggle-box.vala"
	if (icon != NULL) {
#line 528 "toggle-box.c"
		CachedImage* image = NULL;
		CachedImage* _tmp6_;
		GtkBox* _tmp7_;
		CachedImage* _tmp8_;
#line 101 "../src/toggle-box.vala"
		_tmp6_ = cached_image_new (icon);
#line 101 "../src/toggle-box.vala"
		g_object_ref_sink (_tmp6_);
#line 101 "../src/toggle-box.vala"
		image = _tmp6_;
#line 102 "../src/toggle-box.vala"
		_tmp7_ = hbox;
#line 102 "../src/toggle-box.vala"
		_tmp8_ = image;
#line 102 "../src/toggle-box.vala"
		gtk_box_pack_start (_tmp7_, (GtkWidget*) _tmp8_, FALSE, FALSE, (guint) 0);
#line 99 "../src/toggle-box.vala"
		_g_object_unref0 (image);
#line 547 "toggle-box.c"
	}
#line 105 "../src/toggle-box.vala"
	_tmp9_ = g_strdup (name_in);
#line 105 "../src/toggle-box.vala"
	name = _tmp9_;
#line 106 "../src/toggle-box.vala"
	_tmp10_ = self->priv->_default_key;
#line 106 "../src/toggle-box.vala"
	if (g_strcmp0 (key, _tmp10_) == 0) {
#line 557 "toggle-box.c"
		const gchar* _tmp11_;
		gchar* _tmp12_;
#line 109 "../src/toggle-box.vala"
		_tmp11_ = name;
#line 109 "../src/toggle-box.vala"
		_tmp12_ = g_strdup_printf (_ ("%s (Default)"), _tmp11_);
#line 109 "../src/toggle-box.vala"
		_g_free0 (name);
#line 109 "../src/toggle-box.vala"
		name = _tmp12_;
#line 568 "toggle-box.c"
	}
#line 112 "../src/toggle-box.vala"
	_tmp13_ = (GtkLabel*) gtk_label_new (NULL);
#line 112 "../src/toggle-box.vala"
	g_object_ref_sink (_tmp13_);
#line 112 "../src/toggle-box.vala"
	label = _tmp13_;
#line 113 "../src/toggle-box.vala"
	_tmp14_ = name;
#line 113 "../src/toggle-box.vala"
	_tmp15_ = g_strdup_printf ("<span font=\"Ubuntu 12.5\">%s</span>", _tmp14_);
#line 113 "../src/toggle-box.vala"
	_tmp16_ = _tmp15_;
#line 113 "../src/toggle-box.vala"
	gtk_label_set_markup (label, _tmp16_);
#line 113 "../src/toggle-box.vala"
	_g_free0 (_tmp16_);
#line 114 "../src/toggle-box.vala"
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
#line 115 "../src/toggle-box.vala"
	_tmp17_ = hbox;
#line 115 "../src/toggle-box.vala"
	gtk_box_pack_start (_tmp17_, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
#line 117 "../src/toggle-box.vala"
	_tmp18_ = item;
#line 117 "../src/toggle-box.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp18_, TRUE);
#line 118 "../src/toggle-box.vala"
	_tmp19_ = item;
#line 118 "../src/toggle-box.vala"
	_tmp20_ = hbox;
#line 118 "../src/toggle-box.vala"
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
#line 119 "../src/toggle-box.vala"
	_tmp21_ = hbox;
#line 119 "../src/toggle-box.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp21_);
#line 606 "toggle-box.c"
	{
		GtkCssProvider* style = NULL;
		GtkCssProvider* _tmp22_;
		FlatButton* _tmp23_;
		GtkStyleContext* _tmp24_;
#line 124 "../src/toggle-box.vala"
		_tmp22_ = gtk_css_provider_new ();
#line 124 "../src/toggle-box.vala"
		style = _tmp22_;
#line 125 "../src/toggle-box.vala"
		gtk_css_provider_load_from_data (style, "* {padding: 8px 3px;}", (gssize) -1, &_inner_error0_);
#line 125 "../src/toggle-box.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 125 "../src/toggle-box.vala"
			_g_object_unref0 (style);
#line 622 "toggle-box.c"
			goto __catch0_g_error;
		}
#line 126 "../src/toggle-box.vala"
		_tmp23_ = item;
#line 126 "../src/toggle-box.vala"
		_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
#line 126 "../src/toggle-box.vala"
		gtk_style_context_add_provider (_tmp24_, (GtkStyleProvider*) style, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 121 "../src/toggle-box.vala"
		_g_object_unref0 (style);
#line 633 "toggle-box.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
#line 121 "../src/toggle-box.vala"
		e = _inner_error0_;
#line 121 "../src/toggle-box.vala"
		_inner_error0_ = NULL;
#line 130 "../src/toggle-box.vala"
		_tmp25_ = e;
#line 130 "../src/toggle-box.vala"
		_tmp26_ = _tmp25_->message;
#line 130 "../src/toggle-box.vala"
		g_debug ("toggle-box.vala:130: Internal error loading session chooser style: %s", _tmp26_);
#line 121 "../src/toggle-box.vala"
		_g_error_free0 (e);
#line 653 "toggle-box.c"
	}
	__finally0:
#line 121 "../src/toggle-box.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 121 "../src/toggle-box.vala"
		_g_object_unref0 (label);
#line 121 "../src/toggle-box.vala"
		_g_free0 (name);
#line 121 "../src/toggle-box.vala"
		_g_object_unref0 (hbox);
#line 121 "../src/toggle-box.vala"
		_g_object_unref0 (item);
#line 121 "../src/toggle-box.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 121 "../src/toggle-box.vala"
		g_clear_error (&_inner_error0_);
#line 121 "../src/toggle-box.vala"
		return NULL;
#line 672 "toggle-box.c"
	}
#line 133 "../src/toggle-box.vala"
	_tmp27_ = item;
#line 133 "../src/toggle-box.vala"
	_tmp28_ = g_strdup (key);
#line 133 "../src/toggle-box.vala"
	g_object_set_data_full ((GObject*) _tmp27_, "toggle-list-key", _tmp28_, g_free);
#line 134 "../src/toggle-box.vala"
	result = (GtkButton*) item;
#line 134 "../src/toggle-box.vala"
	_g_object_unref0 (label);
#line 134 "../src/toggle-box.vala"
	_g_free0 (name);
#line 134 "../src/toggle-box.vala"
	_g_object_unref0 (hbox);
#line 134 "../src/toggle-box.vala"
	return result;
#line 690 "toggle-box.c"
}

static void
toggle_box_button_clicked_cb (ToggleBox* self,
                              GtkButton* button)
{
	gconstpointer _tmp0_;
#line 137 "../src/toggle-box.vala"
	g_return_if_fail (self != NULL);
#line 137 "../src/toggle-box.vala"
	g_return_if_fail (button != NULL);
#line 139 "../src/toggle-box.vala"
	_tmp0_ = g_object_get_data ((GObject*) button, "toggle-list-key");
#line 139 "../src/toggle-box.vala"
	toggle_box_set_selected_key (self, (const gchar*) _tmp0_);
#line 706 "toggle-box.c"
}

static void
toggle_box_real_grab_focus (GtkWidget* base)
{
	ToggleBox * self;
	GtkButton* _tmp0_;
#line 142 "../src/toggle-box.vala"
	self = (ToggleBox*) base;
#line 144 "../src/toggle-box.vala"
	_tmp0_ = self->priv->selected_button;
#line 144 "../src/toggle-box.vala"
	if (_tmp0_ != NULL) {
#line 720 "toggle-box.c"
		GtkButton* _tmp1_;
#line 145 "../src/toggle-box.vala"
		_tmp1_ = self->priv->selected_button;
#line 145 "../src/toggle-box.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
#line 726 "toggle-box.c"
	}
}

const gchar*
toggle_box_get_default_key (ToggleBox* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 22 "../src/toggle-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 22 "../src/toggle-box.vala"
	_tmp0_ = self->priv->_default_key;
#line 22 "../src/toggle-box.vala"
	result = _tmp0_;
#line 22 "../src/toggle-box.vala"
	return result;
#line 743 "toggle-box.c"
}

static void
toggle_box_set_default_key (ToggleBox* self,
                            const gchar* value)
{
	gchar* old_value;
#line 22 "../src/toggle-box.vala"
	g_return_if_fail (self != NULL);
#line 22 "../src/toggle-box.vala"
	old_value = toggle_box_get_default_key (self);
#line 22 "../src/toggle-box.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 757 "toggle-box.c"
		gchar* _tmp0_;
#line 22 "../src/toggle-box.vala"
		_tmp0_ = g_strdup (value);
#line 22 "../src/toggle-box.vala"
		_g_free0 (self->priv->_default_key);
#line 22 "../src/toggle-box.vala"
		self->priv->_default_key = _tmp0_;
#line 22 "../src/toggle-box.vala"
		g_object_notify_by_pspec ((GObject *) self, toggle_box_properties[TOGGLE_BOX_DEFAULT_KEY_PROPERTY]);
#line 767 "toggle-box.c"
	}
}

const gchar*
toggle_box_get_starting_key (ToggleBox* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 23 "../src/toggle-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 23 "../src/toggle-box.vala"
	_tmp0_ = self->priv->_starting_key;
#line 23 "../src/toggle-box.vala"
	result = _tmp0_;
#line 23 "../src/toggle-box.vala"
	return result;
#line 784 "toggle-box.c"
}

static void
toggle_box_set_starting_key (ToggleBox* self,
                             const gchar* value)
{
	gchar* old_value;
#line 23 "../src/toggle-box.vala"
	g_return_if_fail (self != NULL);
#line 23 "../src/toggle-box.vala"
	old_value = toggle_box_get_starting_key (self);
#line 23 "../src/toggle-box.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 798 "toggle-box.c"
		gchar* _tmp0_;
#line 23 "../src/toggle-box.vala"
		_tmp0_ = g_strdup (value);
#line 23 "../src/toggle-box.vala"
		_g_free0 (self->priv->_starting_key);
#line 23 "../src/toggle-box.vala"
		self->priv->_starting_key = _tmp0_;
#line 23 "../src/toggle-box.vala"
		g_object_notify_by_pspec ((GObject *) self, toggle_box_properties[TOGGLE_BOX_STARTING_KEY_PROPERTY]);
#line 808 "toggle-box.c"
	}
}

const gchar*
toggle_box_get_selected_key (ToggleBox* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 24 "../src/toggle-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 24 "../src/toggle-box.vala"
	_tmp0_ = self->priv->_selected_key;
#line 24 "../src/toggle-box.vala"
	result = _tmp0_;
#line 24 "../src/toggle-box.vala"
	return result;
#line 825 "toggle-box.c"
}

void
toggle_box_set_selected_key (ToggleBox* self,
                             const gchar* value)
{
	gchar* old_value;
#line 24 "../src/toggle-box.vala"
	g_return_if_fail (self != NULL);
#line 24 "../src/toggle-box.vala"
	old_value = toggle_box_get_selected_key (self);
#line 24 "../src/toggle-box.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 839 "toggle-box.c"
		gchar* _tmp0_;
#line 24 "../src/toggle-box.vala"
		_tmp0_ = g_strdup (value);
#line 24 "../src/toggle-box.vala"
		_g_free0 (self->priv->_selected_key);
#line 24 "../src/toggle-box.vala"
		self->priv->_selected_key = _tmp0_;
#line 24 "../src/toggle-box.vala"
		g_object_notify_by_pspec ((GObject *) self, toggle_box_properties[TOGGLE_BOX_SELECTED_KEY_PROPERTY]);
#line 849 "toggle-box.c"
	}
}

static GObject *
toggle_box_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ToggleBox * self;
#line 58 "../src/toggle-box.vala"
	parent_class = G_OBJECT_CLASS (toggle_box_parent_class);
#line 58 "../src/toggle-box.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 58 "../src/toggle-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOGGLE_BOX, ToggleBox);
#line 60 "../src/toggle-box.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
#line 58 "../src/toggle-box.vala"
	return obj;
#line 871 "toggle-box.c"
}

static void
toggle_box_class_init (ToggleBoxClass * klass,
                       gpointer klass_data)
{
#line 20 "../src/toggle-box.vala"
	toggle_box_parent_class = g_type_class_peek_parent (klass);
#line 20 "../src/toggle-box.vala"
	g_type_class_adjust_private_offset (klass, &ToggleBox_private_offset);
#line 20 "../src/toggle-box.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) toggle_box_real_draw;
#line 20 "../src/toggle-box.vala"
	((GtkWidgetClass *) klass)->grab_focus = (void (*) (GtkWidget*)) toggle_box_real_grab_focus;
#line 20 "../src/toggle-box.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_toggle_box_get_property;
#line 20 "../src/toggle-box.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_toggle_box_set_property;
#line 20 "../src/toggle-box.vala"
	G_OBJECT_CLASS (klass)->constructor = toggle_box_constructor;
#line 20 "../src/toggle-box.vala"
	G_OBJECT_CLASS (klass)->finalize = toggle_box_finalize;
#line 20 "../src/toggle-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TOGGLE_BOX_DEFAULT_KEY_PROPERTY, toggle_box_properties[TOGGLE_BOX_DEFAULT_KEY_PROPERTY] = g_param_spec_string ("default-key", "default-key", "default-key", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 20 "../src/toggle-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TOGGLE_BOX_STARTING_KEY_PROPERTY, toggle_box_properties[TOGGLE_BOX_STARTING_KEY_PROPERTY] = g_param_spec_string ("starting-key", "starting-key", "starting-key", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 20 "../src/toggle-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TOGGLE_BOX_SELECTED_KEY_PROPERTY, toggle_box_properties[TOGGLE_BOX_SELECTED_KEY_PROPERTY] = g_param_spec_string ("selected-key", "selected-key", "selected-key", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 900 "toggle-box.c"
}

static void
toggle_box_instance_init (ToggleBox * self,
                          gpointer klass)
{
#line 20 "../src/toggle-box.vala"
	self->priv = toggle_box_get_instance_private (self);
#line 909 "toggle-box.c"
}

static void
toggle_box_finalize (GObject * obj)
{
	ToggleBox * self;
#line 20 "../src/toggle-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOGGLE_BOX, ToggleBox);
#line 22 "../src/toggle-box.vala"
	_g_free0 (self->priv->_default_key);
#line 23 "../src/toggle-box.vala"
	_g_free0 (self->priv->_starting_key);
#line 24 "../src/toggle-box.vala"
	_g_free0 (self->priv->_selected_key);
#line 25 "../src/toggle-box.vala"
	_g_object_unref0 (self->scrolled_box);
#line 56 "../src/toggle-box.vala"
	_g_object_unref0 (self->priv->selected_button);
#line 20 "../src/toggle-box.vala"
	G_OBJECT_CLASS (toggle_box_parent_class)->finalize (obj);
#line 930 "toggle-box.c"
}

static GType
toggle_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ToggleBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) toggle_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ToggleBox), 0, (GInstanceInitFunc) toggle_box_instance_init, NULL };
	GType toggle_box_type_id;
	toggle_box_type_id = g_type_register_static (gtk_box_get_type (), "ToggleBox", &g_define_type_info, 0);
	ToggleBox_private_offset = g_type_add_instance_private (toggle_box_type_id, sizeof (ToggleBoxPrivate));
	return toggle_box_type_id;
}

GType
toggle_box_get_type (void)
{
	static volatile gsize toggle_box_type_id__once = 0;
	if (g_once_init_enter (&toggle_box_type_id__once)) {
		GType toggle_box_type_id;
		toggle_box_type_id = toggle_box_get_type_once ();
		g_once_init_leave (&toggle_box_type_id__once, toggle_box_type_id);
	}
	return toggle_box_type_id__once;
}

static void
_vala_toggle_box_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	ToggleBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TOGGLE_BOX, ToggleBox);
#line 20 "../src/toggle-box.vala"
	switch (property_id) {
#line 20 "../src/toggle-box.vala"
		case TOGGLE_BOX_DEFAULT_KEY_PROPERTY:
#line 20 "../src/toggle-box.vala"
		g_value_set_string (value, toggle_box_get_default_key (self));
#line 20 "../src/toggle-box.vala"
		break;
#line 20 "../src/toggle-box.vala"
		case TOGGLE_BOX_STARTING_KEY_PROPERTY:
#line 20 "../src/toggle-box.vala"
		g_value_set_string (value, toggle_box_get_starting_key (self));
#line 20 "../src/toggle-box.vala"
		break;
#line 20 "../src/toggle-box.vala"
		case TOGGLE_BOX_SELECTED_KEY_PROPERTY:
#line 20 "../src/toggle-box.vala"
		g_value_set_string (value, toggle_box_get_selected_key (self));
#line 20 "../src/toggle-box.vala"
		break;
#line 983 "toggle-box.c"
		default:
#line 20 "../src/toggle-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "../src/toggle-box.vala"
		break;
#line 989 "toggle-box.c"
	}
}

static void
_vala_toggle_box_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	ToggleBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TOGGLE_BOX, ToggleBox);
#line 20 "../src/toggle-box.vala"
	switch (property_id) {
#line 20 "../src/toggle-box.vala"
		case TOGGLE_BOX_DEFAULT_KEY_PROPERTY:
#line 20 "../src/toggle-box.vala"
		toggle_box_set_default_key (self, g_value_get_string (value));
#line 20 "../src/toggle-box.vala"
		break;
#line 20 "../src/toggle-box.vala"
		case TOGGLE_BOX_STARTING_KEY_PROPERTY:
#line 20 "../src/toggle-box.vala"
		toggle_box_set_starting_key (self, g_value_get_string (value));
#line 20 "../src/toggle-box.vala"
		break;
#line 20 "../src/toggle-box.vala"
		case TOGGLE_BOX_SELECTED_KEY_PROPERTY:
#line 20 "../src/toggle-box.vala"
		toggle_box_set_selected_key (self, g_value_get_string (value));
#line 20 "../src/toggle-box.vala"
		break;
#line 1021 "toggle-box.c"
		default:
#line 20 "../src/toggle-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "../src/toggle-box.vala"
		break;
#line 1027 "toggle-box.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

