// python wrapper for vtkRemoteInteractionAdapter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkRemoteInteractionAdapter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkRemoteInteractionAdapter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkRemoteInteractionAdapter_ClassNew(); }


static PyObject *
PyvtkRemoteInteractionAdapter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkRemoteInteractionAdapter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteInteractionAdapter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteInteractionAdapter *op = static_cast<vtkRemoteInteractionAdapter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkRemoteInteractionAdapter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteInteractionAdapter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkRemoteInteractionAdapter *tempr = vtkRemoteInteractionAdapter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteInteractionAdapter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteInteractionAdapter *op = static_cast<vtkRemoteInteractionAdapter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRemoteInteractionAdapter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkRemoteInteractionAdapter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteInteractionAdapter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkRemoteInteractionAdapter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteInteractionAdapter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteInteractionAdapter *op = static_cast<vtkRemoteInteractionAdapter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkRemoteInteractionAdapter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteInteractionAdapter_ProcessEvent_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteInteractionAdapter *op = static_cast<vtkRemoteInteractionAdapter *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->ProcessEvent(temp0) :
      op->vtkRemoteInteractionAdapter::ProcessEvent(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkRemoteInteractionAdapter_ProcessEvent_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ProcessEvent");

  vtkRenderWindowInteractor *temp0 = nullptr;
  std::string temp1;
  double temp2 = 1.0;
  double temp3 = 1e-5;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 4) &&
      ap.GetVTKObject(temp0, "vtkRenderWindowInteractor") &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    bool tempr = vtkRemoteInteractionAdapter::ProcessEvent(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkRemoteInteractionAdapter_ProcessEvent(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkRemoteInteractionAdapter_ProcessEvent_s1(self, args);
    case 2:
    case 3:
    case 4:
      return PyvtkRemoteInteractionAdapter_ProcessEvent_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "ProcessEvent");
  return nullptr;
}


static PyObject *
PyvtkRemoteInteractionAdapter_SetDevicePixelRatio(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDevicePixelRatio");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteInteractionAdapter *op = static_cast<vtkRemoteInteractionAdapter *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDevicePixelRatio(temp0);
    }
    else
    {
      op->vtkRemoteInteractionAdapter::SetDevicePixelRatio(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteInteractionAdapter_GetDevicePixelRatio(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDevicePixelRatio");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteInteractionAdapter *op = static_cast<vtkRemoteInteractionAdapter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetDevicePixelRatio() :
      op->vtkRemoteInteractionAdapter::GetDevicePixelRatio());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteInteractionAdapter_SetDevicePixelRatioTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDevicePixelRatioTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteInteractionAdapter *op = static_cast<vtkRemoteInteractionAdapter *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDevicePixelRatioTolerance(temp0);
    }
    else
    {
      op->vtkRemoteInteractionAdapter::SetDevicePixelRatioTolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteInteractionAdapter_GetDevicePixelRatioTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDevicePixelRatioTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteInteractionAdapter *op = static_cast<vtkRemoteInteractionAdapter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetDevicePixelRatioTolerance() :
      op->vtkRemoteInteractionAdapter::GetDevicePixelRatioTolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteInteractionAdapter_SetInteractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInteractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteInteractionAdapter *op = static_cast<vtkRemoteInteractionAdapter *>(vp);

  vtkRenderWindowInteractor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderWindowInteractor"))
  {
    if (ap.IsBound())
    {
      op->SetInteractor(temp0);
    }
    else
    {
      op->vtkRemoteInteractionAdapter::SetInteractor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteInteractionAdapter_GetInteractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInteractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteInteractionAdapter *op = static_cast<vtkRemoteInteractionAdapter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderWindowInteractor *tempr = (ap.IsBound() ?
      op->GetInteractor() :
      op->vtkRemoteInteractionAdapter::GetInteractor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkRemoteInteractionAdapter_Methods[] = {
  {"IsTypeOf", PyvtkRemoteInteractionAdapter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkRemoteInteractionAdapter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkRemoteInteractionAdapter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkRemoteInteractionAdapter\nC++: static vtkRemoteInteractionAdapter *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkRemoteInteractionAdapter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkRemoteInteractionAdapter\nC++: vtkRemoteInteractionAdapter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkRemoteInteractionAdapter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkRemoteInteractionAdapter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"ProcessEvent", PyvtkRemoteInteractionAdapter_ProcessEvent, METH_VARARGS,
   "ProcessEvent(self, event:str) -> bool\nC++: bool ProcessEvent(const std::string &event)\nProcessEvent(iren:vtkRenderWindowInteractor, event:str,\n    devicePixelRatio:float=1.0,\n    devicePixelRatioTolerance:float=1e-5) -> bool\nC++: static bool ProcessEvent(vtkRenderWindowInteractor *iren,\n    const std::string &event, double devicePixelRatio=1.0,\n    double devicePixelRatioTolerance=1e-5)\n\nApply the vtk-js event to the internal RenderWindowInteractor\n@param event stringified json representation of a vtk-js\n    interaction event.\n@return true if the event is processed , false otherwise\n"},
  {"SetDevicePixelRatio", PyvtkRemoteInteractionAdapter_SetDevicePixelRatio, METH_VARARGS,
   "SetDevicePixelRatio(self, _arg:float) -> None\nC++: virtual void SetDevicePixelRatio(double _arg)\n\n"},
  {"GetDevicePixelRatio", PyvtkRemoteInteractionAdapter_GetDevicePixelRatio, METH_VARARGS,
   "GetDevicePixelRatio(self) -> float\nC++: virtual double GetDevicePixelRatio()\n\n"},
  {"SetDevicePixelRatioTolerance", PyvtkRemoteInteractionAdapter_SetDevicePixelRatioTolerance, METH_VARARGS,
   "SetDevicePixelRatioTolerance(self, _arg:float) -> None\nC++: virtual void SetDevicePixelRatioTolerance(double _arg)\n\nTolerance used when truncating the event position from physical\nto logical. i.e.  int event_position_x = int(event.at(\"x\") *\ndevicePixelRatio + devicePixelRatioTolerance)\n"},
  {"GetDevicePixelRatioTolerance", PyvtkRemoteInteractionAdapter_GetDevicePixelRatioTolerance, METH_VARARGS,
   "GetDevicePixelRatioTolerance(self) -> float\nC++: virtual double GetDevicePixelRatioTolerance()\n\n"},
  {"SetInteractor", PyvtkRemoteInteractionAdapter_SetInteractor, METH_VARARGS,
   "SetInteractor(self, iren:vtkRenderWindowInteractor) -> None\nC++: void SetInteractor(vtkRenderWindowInteractor *iren)\n\n"},
  {"GetInteractor", PyvtkRemoteInteractionAdapter_GetInteractor, METH_VARARGS,
   "GetInteractor(self) -> vtkRenderWindowInteractor\nC++: virtual vtkRenderWindowInteractor *GetInteractor()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkRemoteInteractionAdapter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("device_pixel_ratio"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemoteInteractionAdapter_GetDevicePixelRatio(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemoteInteractionAdapter_SetDevicePixelRatio(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemoteInteractionAdapter_SetDevicePixelRatio(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDevicePixelRatio/SetDevicePixelRatio\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("device_pixel_ratio_tolerance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemoteInteractionAdapter_GetDevicePixelRatioTolerance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemoteInteractionAdapter_SetDevicePixelRatioTolerance(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemoteInteractionAdapter_SetDevicePixelRatioTolerance(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDevicePixelRatioTolerance/SetDevicePixelRatioTolerance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interactor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemoteInteractionAdapter_GetInteractor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemoteInteractionAdapter_SetInteractor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemoteInteractionAdapter_SetInteractor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInteractor/SetInteractor\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkRemoteInteractionAdapter_Doc =
  "vtkRemoteInteractionAdapter - Map vtk-js interaction events to native\nVTK events\n\n"
  "Superclass: vtkObject\n\n"
  "Apply an vtk-js events to a vtkRenderWindowInteractor. For the\n"
  "expected format see\n"
  "https://github.com/Kitware/vtk-js/blob/master/Sources/Interaction/Styl\n"
  "e/InteractorStyleRemoteMouse/index.js\n\n"
  "Events are processed in the `ProcessEvent` method which can be called\n"
  "either as a static method providing all the relevant parameters as\n"
  "arguments or  a class method with the parameters provided via member\n"
  "variables.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkRemoteInteractionAdapter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkWebCore.vtkRemoteInteractionAdapter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkRemoteInteractionAdapter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkRemoteInteractionAdapter_StaticNew()
{
  return vtkRemoteInteractionAdapter::New();
}

PyObject *PyvtkRemoteInteractionAdapter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkRemoteInteractionAdapter_Type, PyvtkRemoteInteractionAdapter_Methods,
    "vtkRemoteInteractionAdapter",
 &PyvtkRemoteInteractionAdapter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkRemoteInteractionAdapter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkRemoteInteractionAdapter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkRemoteInteractionAdapter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkRemoteInteractionAdapter", o) != 0)
  {
    Py_DECREF(o);
  }

}

