// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkCellGridShaderUtil.h"

const char *vtkCellGridShaderUtil =
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"void shapeGradientAt(in vec3 param, in float coord[{ShapeCoeffPerCell}], out vec3 dxdr, out vec3 dxds, out vec3 dxdt)\n"
"{{\n"
"  dxdr = vec3(0.);\n"
"  dxds = vec3(0.);\n"
"  dxdt = vec3(0.);\n"
"  float basisGradient[3 * {ShapeCellBasisSize}];\n"
"  shapeBasisGradientAt(param, basisGradient);\n"
"  for (int ii = 0; ii < {ShapeNumBasisFun}; ++ii)\n"
"  {{\n"
"    int start = ii * {ShapeMultiplicity};\n"
"    vec3 point = vec3(coord[start], coord[start + 1], coord[start + 2]);\n"
"    dxdr += point * basisGradient[ii * {ShapeMultiplicity} + 0];\n"
"    dxds += point * basisGradient[ii * {ShapeMultiplicity} + 1];\n"
"    dxdt += point * basisGradient[ii * {ShapeMultiplicity} + 2];\n"
"  }}\n"
"}}\n"
"\n"
"void colorEvaluateAt(\n"
"  in vec3 rr,\n"
"  in float shapeData[{ShapeCoeffPerCell}],\n"
"  in float cellData[{ColorCoeffPerCell}],\n"
"  out float value[{ColorNumValPP}])\n"
"{{\n"
"  float basis[{ColorCellBasisSize}];\n"
"  colorBasisAt(rr, basis);\n"
"  for (int cc = 0; cc < {ColorNumValPP}; ++cc)\n"
"  {{\n"
"    value[cc] = 0.0;\n"
"  }}\n"
"  for (int pp = 0; pp < {ColorNumBasisFun}; ++pp)\n"
"  {{\n"
"    for (int cc = 0; cc < {ColorMultiplicity}; ++cc)\n"
"    {{\n"
"      for (int bb = 0; bb < {ColorBasisSize}; ++bb)\n"
"      {{\n"
"        value[cc * {ColorBasisSize} + bb] += cellData[pp * {ColorMultiplicity} + cc] * basis[pp * {ColorBasisSize} + bb];\n"
"      }}\n"
"    }}\n"
"  }}\n"
"#if {ColorScaleInverseJacobian}\n"
"  {{\n"
"    // Scale the value by the inverse Jacobian of the shape attribute.\n"
"    vec3 dxdr;\n"
"    vec3 dxds;\n"
"    vec3 dxdt;\n"
"    mat3 jac;\n"
"    shapeGradientAt(rr, shapeData, dxdr, dxds, dxdt);\n"
"    jac = transpose(mat3(dxdr, dxds, dxdt));\n"
"    // jac = mat3(dxdr, dxds, dxdt);\n"
"    mat3 ijac = inverse(jac);\n"
"    for (int cc = 0; cc < {ColorNumValPP} / 3; ++cc)\n"
"    {{\n"
"      vec3 unscaled = vec3(value[cc * 3], value[cc * 3 + 1], value[cc * 3 + 2]);\n"
"      vec3 scaled = ijac * unscaled;\n"
"      value[cc * 3    ] = scaled.x;\n"
"      value[cc * 3 + 1] = scaled.y;\n"
"      value[cc * 3 + 2] = scaled.z;\n"
"    }}\n"
"  }}\n"
"#elif {ColorScaleScaledJacobian}\n"
"  {{\n"
"    // Scale the value by the determinant of the Jacobian *and*\n"
"    // transform the value by the Jacobian.\n"
"    vec3 dxdr;\n"
"    vec3 dxds;\n"
"    vec3 dxdt;\n"
"    mat3 jac;\n"
"    shapeGradientAt(rr, shapeData, dxdr, dxds, dxdt);\n"
"    // jac = transpose(mat3(dxdr, dxds, dxdt));\n"
"    jac = mat3(dxdr, dxds, dxdt);\n"
"    float jdet = determinant(jac);\n"
"    for (int cc = 0; cc < {ColorNumValPP} / 3; ++cc)\n"
"    {{\n"
"      vec3 unscaled = vec3(value[cc * 3], value[cc * 3 + 1], value[cc * 3 + 2]);\n"
"      vec3 scaled = jac * unscaled / jdet;\n"
"      value[cc * 3    ] = scaled.x;\n"
"      value[cc * 3 + 1] = scaled.y;\n"
"      value[cc * 3 + 2] = scaled.z;\n"
"    }}\n"
"  }}\n"
"#endif\n"
"}}\n"
"\n"
"void shapeEvaluateAt(in vec3 rr, in float shapeVals[{ShapeCoeffPerCell}], out float value[{ShapeNumValPP}])\n"
"{{\n"
"  float basis[{ShapeCellBasisSize}];\n"
"  shapeBasisAt(rr, basis);\n"
"  for (int cc = 0; cc < {ShapeNumValPP}; ++cc)\n"
"  {{\n"
"    value[cc] = 0.0;\n"
"  }}\n"
"  for (int pp = 0; pp < {ShapeNumBasisFun}; ++pp)\n"
"  {{\n"
"    for (int cc = 0; cc < {ShapeNumValPP}; ++cc)\n"
"    {{\n"
"      value[cc] += shapeVals[pp * {ShapeNumValPP} + cc] * basis[pp];\n"
"    }}\n"
"  }}\n"
"}}\n"
"\n"
"// Fetch point coordinates and per-integration-point field values for\n"
"// the entire cell.\n"
"//\n"
"// NB: Currently, a cell-grid's shape attribute *must* be continuous\n"
"// (i.e., share degrees of freedom at cell boundaries). This makes\n"
"// fetching shapeValues much simpler than fetching colorValues.\n"
"//\n"
"// NB: This method expects `shape_conn` and `shape_vals` declared as samplerBuffer uniforms.\n"
"void shapeValuesForCell(in int cellId, out float shapeValues[{ShapeCoeffPerCell}])\n"
"{{\n"
"  for (int ii = 0; ii < {ShapeNumBasisFun}; ++ii)\n"
"  {{\n"
"    int vertexId = texelFetchBuffer(shape_conn, cellId * {ShapeNumBasisFun} + ii).s;\n"
"    for (int jj = 0; jj < {ShapeMultiplicity}; ++jj)\n"
"    {{\n"
"      shapeValues[ii * {ShapeMultiplicity} + jj] = texelFetchBuffer(shape_vals, vertexId * {ShapeMultiplicity} + jj).x;\n"
"    }}\n"
"  }}\n"
"}}\n"
"";
