// java wrapper for vtkFieldData object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkFieldData.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkFieldData_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkFieldData",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFieldData_ExtendedNew_10(JNIEnv* env, jobject obj)
{
  vtkFieldData * temp20;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFieldData_IsTypeOf_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFieldData_IsA_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFieldData_GetNumberOfGenerationsFromBaseType_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFieldData_GetNumberOfGenerationsFromBase_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_Initialize_15(JNIEnv* env, jobject obj)
{

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFieldData_Allocate_16(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Allocate(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_CopyStructure_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkFieldData * temp0;
  temp0 = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_AllocateArrays_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllocateArrays(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFieldData_GetNumberOfArrays_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfArrays();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFieldData_AddArray_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_NullData_111(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->NullData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_RemoveArray_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveArray(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_RemoveArray_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveArray(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFieldData_GetArray_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataArray * temp20;
  temp0 = id0;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArray(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFieldData_GetArray_115(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkDataArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArray(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFieldData_GetAbstractArray_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkAbstractArray * temp20;
  temp0 = id0;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAbstractArray(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFieldData_GetAbstractArray_117(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkAbstractArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAbstractArray(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFieldData_HasArray_118(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasArray(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkFieldData_GetArrayName_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_PassData_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkFieldData * temp0;
  temp0 = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->PassData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_CopyFieldOn_121(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyFieldOn(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_CopyFieldOff_122(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyFieldOff(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_CopyAllOn_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyAllOn(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_CopyAllOff_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyAllOff(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_DeepCopy_125(JNIEnv* env, jobject obj,jobject id0)
{
  vtkFieldData * temp0;
  temp0 = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_ShallowCopy_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkFieldData * temp0;
  temp0 = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_Squeeze_127(JNIEnv* env, jobject obj)
{

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->Squeeze();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_Reset_128(JNIEnv* env, jobject obj)
{

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->Reset();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFieldData_GetActualMemorySize_129(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFieldData_GetMTime_130(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_GetField_131(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkIdList * temp0;
  vtkFieldData * temp1;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetField(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFieldData_GetNumberOfComponents_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponents();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFieldData_GetNumberOfTuples_133(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTuples();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_SetNumberOfTuples_134(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfTuples(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_SetTuple_135(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2)
{
  long long   temp0;
  long long   temp1;
  vtkFieldData * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, id2));

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTuple(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_InsertTuple_136(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2)
{
  long long   temp0;
  long long   temp1;
  vtkFieldData * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, id2));

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertTuple(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFieldData_InsertNextTuple_137(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkFieldData * temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextTuple(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkFieldData_GetRange_138(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdoubleArray id1,jint id2)
{
  char * temp0;
  double temp1[2];
  int   temp2;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  temp2 = id2;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRange(temp0,temp1,temp2);
  delete[] temp0;
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkFieldData_GetRange_139(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jint id2)
{
  int   temp0;
  double temp1[2];
  int   temp2;
  bool   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  temp2 = id2;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRange(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkFieldData_GetFiniteRange_140(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdoubleArray id1,jint id2)
{
  char * temp0;
  double temp1[2];
  int   temp2;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  temp2 = id2;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFiniteRange(temp0,temp1,temp2);
  delete[] temp0;
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkFieldData_GetFiniteRange_141(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jint id2)
{
  int   temp0;
  double temp1[2];
  int   temp2;
  bool   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  temp2 = id2;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFiniteRange(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkFieldData_GetGhostsToSkip_142(JNIEnv* env, jobject obj)
{
   unsigned char   temp20;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGhostsToSkip();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFieldData_SetGhostsToSkip_143(JNIEnv* env, jobject obj,jbyte id0)
{
   unsigned char   temp0;
  temp0 = id0;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGhostsToSkip(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkFieldData_HasAnyGhostBitSet_144(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAnyGhostBitSet(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFieldData_GetGhostArray_145(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkFieldData* op = static_cast<vtkFieldData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGhostArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkFieldData_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkFieldData::New());
}
