// java wrapper for vtkHigherOrderWedge object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkHigherOrderWedge.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkNonLinearCell_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkHigherOrderWedge_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkHigherOrderWedge",dType)) { return me; }
  if ((res= vtkNonLinearCell_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderWedge_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderWedge_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderWedge_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderWedge_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderWedge_GetCellType_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderWedge_GetCellDimension_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderWedge_RequiresInitialization_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RequiresInitialization();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderWedge_GetNumberOfEdges_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdges();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderWedge_GetNumberOfFaces_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaces();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderWedge_GetEdge_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdge(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderWedge_GetFace_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFace(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHigherOrderWedge_Initialize_111(JNIEnv* env, jobject obj)
{

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderWedge_CellBoundary_112(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CellBoundary(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHigherOrderWedge_Contour_113(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jobject id7,jobject id8,jlong id9,jobject id10)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkCellArray * temp4;
  vtkCellArray * temp5;
  vtkPointData * temp6;
  vtkPointData * temp7;
  vtkCellData * temp8;
  long long   temp9;
  vtkCellData * temp10;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id7));
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;
  temp10 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id10));

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  op->Contour(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9,temp10);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHigherOrderWedge_Clip_114(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jlong id7,jobject id8,jint id9)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkPointData * temp4;
  vtkPointData * temp5;
  vtkCellData * temp6;
  long long   temp7;
  vtkCellData * temp8;
  int   temp9;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = id7;
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clip(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderWedge_TriangulateLocalIds_115(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateLocalIds(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHigherOrderWedge_SetParametricCoords_116(JNIEnv* env, jobject obj)
{

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParametricCoords();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderWedge_GetParametricCenter_117(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParametricCenter(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHigherOrderWedge_GetParametricDistance_118(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParametricDistance(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHigherOrderWedge_SetOrderFromCellData_119(JNIEnv* env, jobject obj,jobject id0,jlong id1,jlong id2)
{
  vtkCellData * temp0;
  long long   temp1;
  long long   temp2;
  temp0 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrderFromCellData(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHigherOrderWedge_SetUniformOrderFromNumPoints_120(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUniformOrderFromNumPoints(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHigherOrderWedge_SetOrder_121(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jlong id3)
{
  int   temp0;
  int   temp1;
  int   temp2;
  long long   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrder(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderWedge_GetOrder_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrder(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHigherOrderWedge_PointCountSupportsUniformOrder_123(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PointCountSupportsUniformOrder(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderWedge_PointIndexFromIJK_124(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PointIndexFromIJK(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderWedge_GetNumberOfApproximatingWedges_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfApproximatingWedges();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderWedge_GetBoundaryQuad_126(JNIEnv* env, jobject obj)
{
  vtkHigherOrderQuadrilateral * temp20;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoundaryQuad();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderWedge_GetBoundaryTri_127(JNIEnv* env, jobject obj)
{
  vtkHigherOrderTriangle * temp20;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoundaryTri();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderWedge_GetEdgeCell_128(JNIEnv* env, jobject obj)
{
  vtkHigherOrderCurve * temp20;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeCell();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderWedge_GetInterpolation_129(JNIEnv* env, jobject obj)
{
  vtkHigherOrderInterpolation * temp20;

  vtkHigherOrderWedge* op = static_cast<vtkHigherOrderWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolation();
  return reinterpret_cast<jlong>(temp20);
}
