// java wrapper for vtkMutableDirectedGraph object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMutableDirectedGraph.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDirectedGraph_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMutableDirectedGraph_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMutableDirectedGraph",dType)) { return me; }
  if ((res= vtkDirectedGraph_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMutableDirectedGraph_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMutableDirectedGraph_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMutableDirectedGraph_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMutableDirectedGraph_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMutableDirectedGraph_SetNumberOfVertices_14(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNumberOfVertices(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMutableDirectedGraph_AddVertex_15(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddVertex();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMutableDirectedGraph_AddVertex_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkVariantArray * temp0;
  long long   temp20;
  temp0 = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddVertex(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMutableDirectedGraph_LazyAddVertex_17(JNIEnv* env, jobject obj)
{

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->LazyAddVertex();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMutableDirectedGraph_LazyAddVertex_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkVariantArray * temp0;
  temp0 = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->LazyAddVertex(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMutableDirectedGraph_LazyAddEdge_19(JNIEnv* env, jobject obj,jlong id0,jlong id1,jobject id2)
{
  long long   temp0;
  long long   temp1;
  vtkVariantArray * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->LazyAddEdge(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMutableDirectedGraph_AddGraphEdge_110(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  vtkGraphEdge * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddGraphEdge(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMutableDirectedGraph_AddChild_111(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkVariantArray * temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkVariantArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddChild(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMutableDirectedGraph_AddChild_112(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddChild(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMutableDirectedGraph_RemoveVertex_113(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveVertex(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMutableDirectedGraph_RemoveEdge_114(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveEdge(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMutableDirectedGraph_RemoveVertices_115(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIdTypeArray * temp0;
  temp0 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveVertices(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMutableDirectedGraph_RemoveEdges_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIdTypeArray * temp0;
  temp0 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMutableDirectedGraph* op = static_cast<vtkMutableDirectedGraph*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveEdges(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMutableDirectedGraph_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMutableDirectedGraph::New());
}
