// java wrapper for vtkTextRenderer object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTextRenderer.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTextRenderer_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTextRenderer",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextRenderer_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextRenderer_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextRenderer_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextRenderer_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextRenderer_GetInstance_14(JNIEnv* env, jobject obj)
{
  vtkTextRenderer * temp20;

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInstance();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextRenderer_SetDefaultBackend_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDefaultBackend(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextRenderer_GetDefaultBackend_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDefaultBackend();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextRenderer_DetectBackend_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DetectBackend(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextRenderer_FreeTypeIsSupported_18(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FreeTypeIsSupported();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextRenderer_MathTextIsSupported_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MathTextIsSupported();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextRenderer_GetBoundingBox_110(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1,jintArray id2,jint id3,jint id4)
{
  vtkTextProperty * temp0;
  vtkStdString temp1;
  int temp2[4];
  int   temp3;
  int   temp4;
  bool   temp20;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);
  env->GetIntArrayRegion(id2, 0, 4, reinterpret_cast<jint*>(&temp2[0]));
  temp3 = id3;
  temp4 = id4;

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoundingBox(temp0,temp1,temp2,temp3,temp4);
  env->SetIntArrayRegion(id2, 0, 4, reinterpret_cast<jint*>(&temp2[0]));
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextRenderer_RenderString_111(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1,jobject id2,jintArray id3,jint id4,jint id5)
{
  vtkTextProperty * temp0;
  vtkStdString temp1;
  vtkImageData * temp2;
  int temp3[2];
  int   temp4;
  int   temp5;
  bool   temp20;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);
  temp2 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id2));
  env->GetIntArrayRegion(id3, 0, 2, reinterpret_cast<jint*>(&temp3[0]));
  temp4 = id4;
  temp5 = id5;

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderString(temp0,temp1,temp2,temp3,temp4,temp5);
  env->SetIntArrayRegion(id3, 0, 2, reinterpret_cast<jint*>(&temp3[0]));
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextRenderer_GetConstrainedFontSize_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1,jint id2,jint id3,jint id4,jint id5)
{
  vtkStdString temp0;
  vtkTextProperty * temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConstrainedFontSize(temp0,temp1,temp2,temp3,temp4,temp5);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextRenderer_StringToPath_113(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1,jobject id2,jint id3,jint id4)
{
  vtkTextProperty * temp0;
  vtkStdString temp1;
  vtkPath * temp2;
  int   temp3;
  int   temp4;
  bool   temp20;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);
  temp2 = static_cast<vtkPath*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = id3;
  temp4 = id4;

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->StringToPath(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextRenderer_SetScaleToPowerOfTwo_114(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTextRenderer* op = static_cast<vtkTextRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleToPowerOfTwo(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTextRenderer_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTextRenderer::New());
}
