// LFOUI.h
// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef LFOUI_h
#define LFOUI_h
#include <FL/Fl.H>
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009, Alan Calvert
// Copyright 2017-2023, Will Godfrey & others

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is a derivative of the ZynAddSubFX original


#include <iostream>
#include "UI/WidgetPDial.h"
#include "UI/WidgetCheckButton.h"
#include <FL/Fl_Group.H>
#include <FL/Fl_Box.H>
#include <FL/fl_draw.H>
#include <FL/fl_ask.H>
#include "PresetsUI.h"
#include "Params/LFOParams.h"
#include "Misc/SynthEngine.h"
#include <FL/Fl_Group.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Button.H>

class LFOUI : public Fl_Group, PresetsUI_ {
public:
  LFOUI(int x,int y, int w, int h, const char *label=0);
  ~LFOUI();
  Fl_Group* make_window();
  Fl_Group *lfoui;
  Fl_Group *lfoparamswindow;
  Fl_Check_Button2 *bpm;
private:
  inline void cb_bpm_i(Fl_Check_Button2*, void*);
  static void cb_bpm(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *continous;
private:
  inline void cb_continous_i(Fl_Check_Button2*, void*);
  static void cb_continous(Fl_Check_Button2*, void*);
public:
  WidgetPDial *freq;
private:
  inline void cb_freq_i(WidgetPDial*, void*);
  static void cb_freq(WidgetPDial*, void*);
public:
  WidgetPDial *intensity;
private:
  inline void cb_intensity_i(WidgetPDial*, void*);
  static void cb_intensity(WidgetPDial*, void*);
public:
  WidgetPDial *delay;
private:
  inline void cb_delay_i(WidgetPDial*, void*);
  static void cb_delay(WidgetPDial*, void*);
public:
  WidgetPDial *startphase;
private:
  inline void cb_startphase_i(WidgetPDial*, void*);
  static void cb_startphase(WidgetPDial*, void*);
public:
  Fl_Choice *LFOtype;
private:
  inline void cb_LFOtype_i(Fl_Choice*, void*);
  static void cb_LFOtype(Fl_Choice*, void*);
public:
  WidgetPDial *randomness;
private:
  inline void cb_randomness_i(WidgetPDial*, void*);
  static void cb_randomness(WidgetPDial*, void*);
public:
  WidgetPDial *freqrand;
private:
  inline void cb_freqrand_i(WidgetPDial*, void*);
  static void cb_freqrand(WidgetPDial*, void*);
public:
  WidgetPDial *stretch;
private:
  inline void cb_stretch_i(WidgetPDial*, void*);
  static void cb_stretch(WidgetPDial*, void*);
public:
  Fl_Button *lfoC;
private:
  inline void cb_lfoC_i(Fl_Button*, void*);
  static void cb_lfoC(Fl_Button*, void*);
public:
  Fl_Button *lfoP;
private:
  inline void cb_lfoP_i(Fl_Button*, void*);
  static void cb_lfoP(Fl_Button*, void*);
public:
  Fl_Group *randgroup;
  void refresh();
  void lfoRtext(float dScale);
  void send_data(int action, int group, int control, float value, int type);
  void returns_update(CommandBlock *getData);
  void init(SynthEngine *synth_, int npart_, int kititem_, int engine_, int group_);
  void updateLFOFreqType();
  void updateBpmControls();
private:
  LFOParams *pars;
  SynthEngine *synth;
  int npart;
  int kititem;
  int group;
  int engine;
};
#endif
