/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import java.util.Objects;

public final class JavaStackTraceElement {
    private final String className;
    private final String fileName;
    private final String methodName;

    public JavaStackTraceElement(String className, String fileName, String methodName) {
        this.className = Objects.requireNonNull(className, "JavaStackTraceElement.className cannot be null");
        this.fileName = Objects.requireNonNull(fileName, "JavaStackTraceElement.fileName cannot be null");
        this.methodName = Objects.requireNonNull(methodName, "JavaStackTraceElement.methodName cannot be null");
    }

    public String getClassName() {
        return this.className;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaStackTraceElement that = (JavaStackTraceElement)o;
        return this.className.equals(that.className) && this.fileName.equals(that.fileName) && this.methodName.equals(that.methodName);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.fileName, this.methodName);
    }

    public String toString() {
        return "JavaStackTraceElement{className=" + this.className + ", fileName=" + this.fileName + ", methodName=" + this.methodName + '}';
    }
}

