/*
 * Decompiled with CFR 0.152.
 */
package org.dpolivaev.mnemonicsetter;

import java.awt.event.KeyEvent;
import javax.swing.Action;
import org.dpolivaev.mnemonicsetter.INameMnemonicHolder;

public class ActionNameMnemonicHolder
implements INameMnemonicHolder {
    private final Action action;

    public ActionNameMnemonicHolder(Action action) {
        this.action = action;
    }

    @Override
    public String getText() {
        return (String)this.action.getValue("Name");
    }

    @Override
    public void setDisplayedMnemonicIndex(int mnemoSignIndex) {
        this.action.putValue("SwingDisplayedMnemonicIndexKey", mnemoSignIndex);
    }

    @Override
    public void setMnemonic(char charAfterMnemoSign) {
        int keyCode = KeyEvent.getExtendedKeyCodeForChar(charAfterMnemoSign);
        this.setMnemonic(keyCode);
    }

    @Override
    public void setMnemonic(int keyCode) {
        this.action.putValue("MnemonicKey", keyCode);
    }

    @Override
    public void setText(String text) {
        this.action.putValue("Name", text);
    }

    @Override
    public int getMnemonic() {
        Object mnemonic = this.action.getValue("MnemonicKey");
        if (mnemonic instanceof Integer) {
            return (Integer)mnemonic;
        }
        return 0;
    }

    @Override
    public boolean hasAccelerator() {
        return this.action.getValue("AcceleratorKey") != null;
    }
}

