/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.extension;

import java.util.function.Function;
import java.util.function.Supplier;
import org.freeplane.core.extension.IExtension;

public interface Configurable {
    public void putClientProperty(Object var1, Object var2);

    public Object getClientProperty(Object var1);

    public void refresh();

    default public void addExtension(Class<? extends IExtension> clazz, IExtension extension) {
        IExtension oldExtension = (IExtension)this.getClientProperty(extension.getClass());
        if (oldExtension == null) {
            this.putClientProperty(clazz, extension);
        } else if (!oldExtension.equals(extension)) {
            throw new RuntimeException("extension of class " + clazz.getName() + " already registered");
        }
    }

    default public void addExtension(IExtension extension) {
        this.addExtension(extension.getClass(), extension);
    }

    default public <T extends IExtension> T putExtension(Class<? extends IExtension> clazz, T extension) {
        IExtension oldExtension = (IExtension)this.getClientProperty(clazz);
        this.putClientProperty(clazz, extension);
        return (T)oldExtension;
    }

    default public <T extends IExtension> T putExtension(T extension) {
        return this.putExtension(extension.getClass(), extension);
    }

    default public boolean containsExtension(Class<? extends IExtension> clazz) {
        return this.getClientProperty(clazz) != null;
    }

    default public <T extends IExtension> T getExtension(Class<T> clazz) {
        return (T)((IExtension)this.getClientProperty(clazz));
    }

    default public <T extends IExtension> T computeIfAbsent(Class<T> clazz, Function<Configurable, T> factory) {
        IExtension extension = (IExtension)this.getClientProperty(clazz);
        if (extension == null) {
            extension = (IExtension)factory.apply(this);
            this.putClientProperty(clazz, extension);
        }
        return (T)extension;
    }

    default public <T extends IExtension> T computeIfAbsent(Class<T> clazz, Supplier<T> factory) {
        IExtension extension = (IExtension)this.getClientProperty(clazz);
        if (extension == null) {
            extension = (IExtension)factory.get();
            this.putClientProperty(clazz, extension);
        }
        return (T)extension;
    }

    default public <T extends IExtension> T removeExtension(Class<T> clazz) {
        return this.putExtension(clazz, null);
    }

    default public boolean removeExtension(IExtension extension) {
        return this.putExtension(extension.getClass(), null) != null;
    }
}

