/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.VersionedBytesStore;
import org.apache.kafka.streams.state.VersionedBytesStoreSupplier;
import org.apache.kafka.streams.state.VersionedKeyValueStore;
import org.apache.kafka.streams.state.internals.AbstractStoreBuilder;
import org.apache.kafka.streams.state.internals.ChangeLoggingVersionedKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.MeteredVersionedKeyValueStore;

public class VersionedKeyValueStoreBuilder<K, V>
extends AbstractStoreBuilder<K, V, VersionedKeyValueStore<K, V>> {
    private final VersionedBytesStoreSupplier storeSupplier;

    public VersionedKeyValueStoreBuilder(VersionedBytesStoreSupplier storeSupplier, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        super(storeSupplier.name(), keySerde, valueSerde, time);
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        Objects.requireNonNull(storeSupplier.metricsScope(), "storeSupplier's metricsScope can't be null");
        this.storeSupplier = storeSupplier;
    }

    @Override
    public VersionedKeyValueStore<K, V> build() {
        KeyValueStore store = (KeyValueStore)this.storeSupplier.get();
        if (!(store instanceof VersionedBytesStore)) {
            throw new IllegalStateException("VersionedBytesStoreSupplier.get() must return an instance of VersionedBytesStore");
        }
        return new MeteredVersionedKeyValueStore(this.maybeWrapLogging((VersionedBytesStore)store), this.storeSupplier.metricsScope(), this.time, this.keySerde, this.valueSerde);
    }

    @Override
    public StoreBuilder<VersionedKeyValueStore<K, V>> withCachingEnabled() {
        throw new IllegalStateException("Versioned stores do not support caching");
    }

    public long historyRetention() {
        return this.storeSupplier.historyRetentionMs();
    }

    private VersionedBytesStore maybeWrapLogging(VersionedBytesStore inner) {
        if (!this.enableLogging) {
            return inner;
        }
        return new ChangeLoggingVersionedKeyValueBytesStore(inner);
    }
}

