/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.HeapAnotB;
import com.yahoo.sketches.theta.HeapCompactOrderedSketch;
import com.yahoo.sketches.theta.Intersection;
import com.yahoo.sketches.theta.IntersectionImpl;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.Sketch;
import java.util.Arrays;

public class PairwiseSetOperations {
    public static CompactSketch intersect(Sketch skA, Sketch skB) {
        if (skA == null && skB == null) {
            return null;
        }
        short seedHash = skA == null ? skB.getSeedHash() : skA.getSeedHash();
        IntersectionImpl inter = new IntersectionImpl(seedHash);
        return ((Intersection)inter).intersect(skA, skB, true, null);
    }

    public static CompactSketch aNotB(Sketch skA, Sketch skB) {
        if (skA == null && skB == null) {
            return null;
        }
        short seedHash = skA == null ? skB.getSeedHash() : skA.getSeedHash();
        HeapAnotB anotb = new HeapAnotB(seedHash);
        return anotb.aNotB(skA, skB, true, null);
    }

    public static CompactSketch union(CompactSketch skA, CompactSketch skB) {
        return PairwiseSetOperations.union(skA, skB, 4096);
    }

    public static CompactSketch union(CompactSketch skA, CompactSketch skB, int k) {
        long[] outArr;
        long hashB;
        int swB;
        int swA;
        if (skA == null) {
            swA = 1;
        } else {
            PairwiseSetOperations.checkOrdered(skA);
            int n = swA = skA.isEmpty() ? 2 : 3;
        }
        if (skB == null) {
            swB = 1;
        } else {
            PairwiseSetOperations.checkOrdered(skB);
            swB = skB.isEmpty() ? 2 : 3;
        }
        int sw = swA << 2 | swB;
        switch (sw) {
            case 5: {
                return null;
            }
            case 6: {
                long thetaLong = skB.getThetaLong();
                return thetaLong == Long.MAX_VALUE ? skB : HeapCompactOrderedSketch.compact(new long[0], true, skB.getSeedHash(), 0, Long.MAX_VALUE);
            }
            case 7: {
                return PairwiseSetOperations.maybeCutback(skB, k);
            }
            case 9: {
                long thetaLong = skA.getThetaLong();
                return thetaLong == Long.MAX_VALUE ? skA : HeapCompactOrderedSketch.compact(new long[0], true, skA.getSeedHash(), 0, Long.MAX_VALUE);
            }
            case 10: {
                short seedHash = PairwiseSetOperations.seedHashesCheck(skA, skB);
                long thetaLong = skA.getThetaLong();
                if (thetaLong == Long.MAX_VALUE) {
                    return skA;
                }
                thetaLong = skB.getThetaLong();
                if (thetaLong == Long.MAX_VALUE) {
                    return skB;
                }
                return HeapCompactOrderedSketch.compact(new long[0], true, seedHash, 0, Long.MAX_VALUE);
            }
            case 11: {
                PairwiseSetOperations.seedHashesCheck(skA, skB);
                return PairwiseSetOperations.maybeCutback(skB, k);
            }
            case 13: {
                return PairwiseSetOperations.maybeCutback(skA, k);
            }
            case 14: {
                PairwiseSetOperations.seedHashesCheck(skA, skB);
                return PairwiseSetOperations.maybeCutback(skA, k);
            }
            case 15: {
                PairwiseSetOperations.seedHashesCheck(skA, skB);
            }
        }
        long thetaLongA = skA.getThetaLong();
        long thetaLongB = skB.getThetaLong();
        long thetaLong = Math.min(thetaLongA, thetaLongB);
        long[] cacheA = skA.hasMemory() ? skA.getCache() : (long[])skA.getCache().clone();
        long[] cacheB = skB.hasMemory() ? skB.getCache() : (long[])skB.getCache().clone();
        int aLen = cacheA.length;
        int bLen = cacheB.length;
        long[] outCache = new long[aLen + bLen];
        int indexA = 0;
        int indexB = 0;
        int indexOut = 0;
        long hashA = aLen == 0 ? thetaLong : cacheA[indexA];
        long l = hashB = bLen == 0 ? thetaLong : cacheB[indexB];
        while (indexA < aLen || indexB < bLen) {
            if (hashA == hashB) {
                if (hashA >= thetaLong) break;
                if (indexOut >= k) {
                    thetaLong = hashA;
                    break;
                }
                outCache[indexOut++] = hashA;
                hashA = ++indexA < aLen ? cacheA[indexA] : thetaLong;
                hashB = ++indexB < bLen ? cacheB[indexB] : thetaLong;
                continue;
            }
            if (hashA < hashB) {
                if (hashA >= thetaLong) break;
                if (indexOut >= k) {
                    thetaLong = hashA;
                    break;
                }
                outCache[indexOut++] = hashA;
                hashA = ++indexA < aLen ? cacheA[indexA] : thetaLong;
                continue;
            }
            if (hashB >= thetaLong) break;
            if (indexOut >= k) {
                thetaLong = hashB;
                break;
            }
            outCache[indexOut++] = hashB;
            hashB = ++indexB < bLen ? cacheB[indexB] : thetaLong;
        }
        int curCount = indexOut;
        if (indexOut > k) {
            outArr = Arrays.copyOf(outCache, k);
            curCount = k;
        } else {
            outArr = Arrays.copyOf(outCache, curCount);
        }
        return SetOperation.createCompactSketch(outArr, false, skA.getSeedHash(), curCount, thetaLong, true, null);
    }

    private static CompactSketch maybeCutback(CompactSketch csk, int k) {
        boolean empty = csk.isEmpty();
        int curCount = csk.getRetainedEntries(true);
        long thetaLong = csk.getThetaLong();
        if (curCount > k) {
            long[] cache = csk.hasMemory() ? csk.getCache() : (long[])csk.getCache().clone();
            thetaLong = cache[k];
            long[] arr = Arrays.copyOf(cache, k);
            curCount = k;
            return SetOperation.createCompactSketch(arr, empty, csk.getSeedHash(), curCount, thetaLong, true, null);
        }
        return csk;
    }

    private static void checkOrdered(CompactSketch csk) {
        if (!csk.isOrdered()) {
            throw new SketchesArgumentException("Given sketch must be ordered.");
        }
    }

    private static short seedHashesCheck(Sketch skA, Sketch skB) {
        short seedHashA = skA.getSeedHash();
        short seedHashB = skB.getSeedHash();
        return Util.checkSeedHashes(seedHashA, seedHashB);
    }
}

