/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport.connection;

import com.sun.corba.ee.impl.transport.connection.ConnectionCacheNonBlockingBase;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.concurrent.ConcurrentQueue;
import com.sun.corba.ee.spi.transport.connection.Connection;
import com.sun.corba.ee.spi.transport.connection.InboundConnectionCache;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@Transport
public final class InboundConnectionCacheImpl<C extends Connection>
extends ConnectionCacheNonBlockingBase<C>
implements InboundConnectionCache<C> {
    private final ConcurrentMap<C, ConnectionState<C>> connectionMap = new ConcurrentHashMap<C, ConnectionState<C>>();

    @Override
    protected String thisClassName() {
        return "InboundConnectionCacheImpl";
    }

    public InboundConnectionCacheImpl(String cacheType, int highWaterMark, int numberToReclaim, long ttl) {
        super(cacheType, highWaterMark, numberToReclaim, ttl);
    }

    @Override
    public void requestReceived(C conn) {
        int count;
        ConcurrentQueue.Handle reclaimHandle;
        ConnectionState<C> cs = this.getConnectionState(conn);
        int totalConnections = this.totalBusy.get() + this.totalIdle.get();
        if (totalConnections > this.highWaterMark()) {
            this.reclaim();
        }
        if ((reclaimHandle = cs.reclaimableHandle) != null) {
            reclaimHandle.remove();
        }
        if ((count = cs.busyCount.getAndIncrement()) == 0) {
            this.totalIdle.decrementAndGet();
            this.totalBusy.incrementAndGet();
        }
    }

    @InfoMethod
    private void msg(String m) {
    }

    @InfoMethod
    private void display(String m, Object value) {
    }

    @Override
    @Transport
    public void requestProcessed(C conn, int numResponsesExpected) {
        ConnectionState cs = (ConnectionState)this.connectionMap.get(conn);
        if (cs == null) {
            this.msg("connection was closed");
            return;
        }
        int numResp = cs.expectedResponseCount.addAndGet(numResponsesExpected);
        int numBusy = cs.busyCount.decrementAndGet();
        this.display("numResp", numResp);
        this.display("numBusy", numBusy);
        if (numBusy == 0) {
            this.totalBusy.decrementAndGet();
            this.totalIdle.incrementAndGet();
            if (numResp == 0) {
                this.display("queing reclaimalbe connection", conn);
                cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
            }
        }
    }

    @Override
    @Transport
    public void responseSent(C conn) {
        ConnectionState cs = (ConnectionState)this.connectionMap.get(conn);
        int waitCount = cs.expectedResponseCount.decrementAndGet();
        if (waitCount == 0) {
            cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
        }
    }

    @Override
    public void close(C conn) {
        ConnectionState cs = (ConnectionState)this.connectionMap.remove(conn);
        int count = cs.busyCount.get();
        if (count == 0) {
            this.totalIdle.decrementAndGet();
        } else {
            this.totalBusy.decrementAndGet();
        }
        ConcurrentQueue.Handle rh = cs.reclaimableHandle;
        if (rh != null) {
            rh.remove();
        }
        try {
            conn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ConnectionState<C> getConnectionState(C conn) {
        ConnectionState<C> cs = new ConnectionState<C>(conn);
        ConnectionState<C> result = this.connectionMap.putIfAbsent(conn, cs);
        if (result != null) {
            this.totalIdle.incrementAndGet();
            return result;
        }
        return cs;
    }

    private static final class ConnectionState<C extends Connection> {
        final C connection;
        final AtomicInteger busyCount;
        final AtomicInteger expectedResponseCount;
        ConcurrentQueue.Handle reclaimableHandle;

        ConnectionState(C conn) {
            this.connection = conn;
            this.busyCount = new AtomicInteger();
            this.expectedResponseCount = new AtomicInteger();
            this.reclaimableHandle = null;
        }
    }
}

