/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.host;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.graalvm.visualvm.core.datasource.StatefulDataSource;
import org.graalvm.visualvm.host.HostsSupport;

public abstract class Host
extends StatefulDataSource {
    public static final Host LOCALHOST = HostsSupport.getInstance().createLocalHost();
    public static final Host UNKNOWN_HOST = HostsSupport.getInstance().createUnknownHost();
    private final String hostName;
    private InetAddress inetAddress;

    public Host(String hostName) throws UnknownHostException {
        this(hostName, InetAddress.getByName(hostName));
    }

    public Host(String hostName, InetAddress inetAddress) {
        if (hostName == null) {
            throw new IllegalArgumentException("Host name cannot be null");
        }
        if (inetAddress == null) {
            throw new IllegalArgumentException("InetAddress cannot be null");
        }
        this.hostName = hostName;
        this.inetAddress = inetAddress;
    }

    public String getHostName() {
        return this.hostName;
    }

    public final InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public int hashCode() {
        if (UNKNOWN_HOST == this) {
            return super.hashCode();
        }
        InetAddress address = this.getInetAddress();
        if (this == LOCALHOST) {
            return address.hashCode();
        }
        if (address.isLoopbackAddress()) {
            return LOCALHOST.hashCode();
        }
        return address.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Host)) {
            return false;
        }
        if (UNKNOWN_HOST == this) {
            return obj == this;
        }
        Host host = (Host)((Object)obj);
        InetAddress thisAddress = this.getInetAddress();
        InetAddress otherAddress = host.getInetAddress();
        if (thisAddress.isLoopbackAddress() && otherAddress.isLoopbackAddress()) {
            return true;
        }
        return thisAddress.equals(otherAddress);
    }

    public String toString() {
        return this.getHostName() + " [IP: " + this.getInetAddress().getHostAddress() + "]";
    }
}

