/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         cf_parse
#define yylex           cf_lex
#define yyerror         cf_error
#define yydebug         cf_debug
#define yynerrs         cf_nerrs
#define yylval          cf_lval
#define yychar          cf_char

/* First part of user prologue.  */
#line 57 "conf/gen_parser.m4"

#line 9 "conf/confbase.Y"
/* Headers from conf/confbase.Y */

#define PARSER 1

#include "nest/bird.h"
#include "conf/conf.h"
#include "lib/resource.h"
#include "lib/socket.h"
#include "lib/settle.h"
#include "lib/timer.h"
#include "lib/string.h"
#include "nest/protocol.h"
#include "nest/iface.h"
#include "nest/route.h"
#include "nest/bfd.h"
#include "nest/cli.h"
#include "filter/filter.h"

/* FIXME: Turn on YYERROR_VERBOSE and work around lots of bison bugs? */

/* Defines from conf/confbase.Y */

static bool this_sadr_from_hack_active;

static void
check_u16(uint val)
{
  if (val > 0xFFFF)
    cf_error("Value %u out of range (0-65535)", val);
}

#define cf_assert(cond, ...) do { if (!(cond)) cf_error(__VA_ARGS__); } while (0)
static inline void cf_assert_symbol(const struct symbol *sym, uint class) {
  switch (class) {
    case SYM_PROTO: cf_assert(sym->class == SYM_PROTO, "Protocol name required"); break;
    case SYM_TEMPLATE: cf_assert(sym->class == SYM_TEMPLATE, "Protocol template name required"); break;
    case SYM_FUNCTION: cf_assert(sym->class == SYM_FUNCTION, "Function name required"); break;
    case SYM_FILTER: cf_assert(sym->class == SYM_FILTER, "Filter name required"); break;
    case SYM_TABLE: cf_assert(sym->class == SYM_TABLE, "Table name required"); break;
    case SYM_ATTRIBUTE: cf_assert(sym->class == SYM_ATTRIBUTE, "Custom attribute name required"); break;
    case SYM_MPLS_DOMAIN: cf_assert(sym->class == SYM_MPLS_DOMAIN, "MPLS domain name required"); break;
    case SYM_MPLS_RANGE: cf_assert(sym->class == SYM_MPLS_RANGE, "MPLS range name required"); break;
    case SYM_VARIABLE: cf_assert((sym->class & ~0xff) == SYM_VARIABLE, "Variable name required"); break;
    case SYM_CONSTANT: cf_assert((sym->class & ~0xff) == SYM_CONSTANT, "Constant name required"); break;
    default: bug("This shall not happen");
  }
}

#line 9 "conf/flowspec.Y"
/* Headers from conf/flowspec.Y */

#define PARSER 1

#include "nest/bird.h"
#include "lib/flowspec.h"


/* Defines from conf/flowspec.Y */

struct flow_builder *this_flow;


#line 11 "filter/config.Y"
/* Headers from filter/config.Y */

#include "filter/f-inst.h"
#include "filter/data.h"

/* Defines from filter/config.Y */

static inline u32 pair(u32 a, u32 b) { return (a << 16) | b; }
static inline u32 pair_a(u32 p) { return p >> 16; }
static inline u32 pair_b(u32 p) { return p & 0xFFFF; }

static struct symbol *this_function;
static struct sym_scope *this_for_scope;

static struct f_method_scope {
  struct f_inst *object;
  struct sym_scope *main;
  struct sym_scope scope;
} f_method_scope_stack[32];
static int f_method_scope_pos = -1;

#define FM  (f_method_scope_stack[f_method_scope_pos])

static inline void f_method_call_start(struct f_inst *object)
{
  if (object->type == T_VOID)
    cf_error("Can't infer type to properly call a method, please assign the value to a variable");
  if (++f_method_scope_pos >= (int) ARRAY_SIZE(f_method_scope_stack))
    cf_error("Too many nested method calls");

  struct sym_scope *scope = f_type_method_scope(object->type);
  if (!scope->hash.count && !scope->next)
    cf_error("No methods defined for type %s", f_type_name(object->type));

  /* Replacing the current symbol scope with the appropriate method scope
     for the given type. */
  FM = (struct f_method_scope) {
    .object = object,
    .main = new_config->current_scope,
    .scope = {
      .next = scope->next,
      .hash = scope->hash,
      .block = 1,
      .readonly = 1,
    },
  };
  new_config->current_scope = &FM.scope;
}

static inline void f_method_call_args(void)
{
  /* For argument parsing, we need to revert back to the standard symbol scope. */
  new_config->current_scope = FM.main;
}

static inline void f_method_call_end(void)
{
  ASSERT_DIE(f_method_scope_pos >= 0);
  if (&FM.scope == new_config->current_scope)
    new_config->current_scope = FM.main;

  f_method_scope_pos--;
}

static int
f_new_var(struct sym_scope *s)
{
  /*
   * - A variable is an offset on vstack from vbase.
   * - Vbase is set on filter start / function call.
   * - Scopes contain (non-frame) block scopes inside filter/function scope
   * - Each scope knows number of vars in that scope
   * - Offset is therefore a sum of 'slots' up to filter/function scope
   * - New variables are added on top of vstk, so intermediate values cannot
   *   be there during FI_VAR_INIT. I.e. no 'var' inside 'term'.
   * - Also, each f_line must always have its scope, otherwise a variable may
   *   be defined but not initialized if relevant f_line is not executed.
   */

  int offset = s->slots++;

  while (s->block)
  {
    s = s->next;
    ASSERT(s);
    offset += s->slots;
  }

  if (offset >= 0xff)
    cf_error("Too many variables, at most 255 allowed");

  return offset;
}

/* Macro for top-level pre-defined variables. */
#define f_predefined_variable(conf_, name_, type_) \
    cf_define_symbol(conf_, cf_get_symbol(conf_, name_), SYM_VARIABLE | type_, offset, f_new_var(conf_->current_scope))

/*
 * Sets and their items are during parsing handled as lists, linked
 * through left ptr. The first item in a list also contains a pointer
 * to the last item in a list (right ptr). For convenience, even items
 * are handled as one-item lists. Lists are merged by f_merge_items().
 */
static int
f_valid_set_type(int type)
{
  switch (type)
  {
  case T_INT:
  case T_PAIR:
  case T_QUAD:
  case T_ENUM:
  case T_IP:
  case T_EC:
  case T_LC:
  case T_RD:
    return 1;

  default:
    return 0;
  }
}

static inline struct f_tree *
f_new_item(struct f_val from, struct f_val to)
{
  struct f_tree *t = f_new_tree();
  t->right = t;
  t->from = from;
  t->to = to;
  return t;
}

static inline struct f_tree *
f_merge_items(struct f_tree *a, struct f_tree *b)
{
  if (!a) return b;
  a->right->left = b;
  a->right = b->right;
  b->right = NULL;
  return a;
}

static inline struct f_tree *
f_new_pair_item(int fa, int ta, int fb, int tb)
{
  check_u16(fa);
  check_u16(ta);
  check_u16(fb);
  check_u16(tb);

  if ((ta < fa) || (tb < fb))
    cf_error( "From value cannot be higher that To value in pair sets");

  struct f_tree *t = f_new_tree();
  t->right = t;
  t->from.type = t->to.type = T_PAIR;
  t->from.val.i = pair(fa, fb);
  t->to.val.i = pair(ta, tb);
  return t;
}

static inline struct f_tree *
f_new_pair_set(int fa, int ta, int fb, int tb)
{
  check_u16(fa);
  check_u16(ta);
  check_u16(fb);
  check_u16(tb);

  if ((ta < fa) || (tb < fb))
    cf_error( "From value cannot be higher that To value in pair sets");

  struct f_tree *lst = NULL;
  int i;

  for (i = fa; i <= ta; i++)
    lst = f_merge_items(lst, f_new_pair_item(i, i, fb, tb));

  return lst;
}

#define CC_ALL 0xFFFF
#define EC_ALL 0xFFFFFFFF
#define LC_ALL 0xFFFFFFFF

static struct f_tree *
f_new_ec_item(u32 kind, u32 ipv4_used, u32 key, u32 vf, u32 vt)
{
  u64 fm, to;

  if ((kind != EC_GENERIC) && (ipv4_used || (key >= 0x10000))) {
    check_u16(vf);
    if (vt == EC_ALL)
      vt = 0xFFFF;
    else
      check_u16(vt);
  }

  if (kind == EC_GENERIC) {
    fm = ec_generic(key, vf);
    to = ec_generic(key, vt);
  }
  else if (ipv4_used) {
    fm = ec_ip4(kind, key, vf);
    to = ec_ip4(kind, key, vt);
  }
  else if (key < 0x10000) {
    fm = ec_as2(kind, key, vf);
    to = ec_as2(kind, key, vt);
  }
  else {
    fm = ec_as4(kind, key, vf);
    to = ec_as4(kind, key, vt);
  }

  struct f_tree *t = f_new_tree();
  t->right = t;
  t->from.type = t->to.type = T_EC;
  t->from.val.ec = fm;
  t->to.val.ec = to;
  return t;
}

static struct f_tree *
f_new_lc_item(u32 f1, u32 t1, u32 f2, u32 t2, u32 f3, u32 t3)
{
  struct f_tree *t = f_new_tree();
  t->right = t;
  t->from.type = t->to.type = T_LC;
  t->from.val.lc = (lcomm) {f1, f2, f3};
  t->to.val.lc = (lcomm) {t1, t2, t3};
  return t;
}


/*
 * Remove all new lines and doubled whitespaces
 * and convert all tabulators to spaces
 * and return a copy of string
 */
char *
assert_copy_expr(const char *start, size_t len)
{
  /* XXX: Allocates maybe a little more memory than we really finally need */
  char *str = cfg_alloc(len + 1);

  char *dst = str;
  const char *src = start - 1;
  const char *end = start + len;
  while (++src < end)
  {
    if (*src == '\n')
      continue;

    /* Skip doubled whitespaces */
    if (src != start)
    {
      const char *prev = src - 1;
      if ((*src == ' ' || *src == '\t') && (*prev == ' ' || *prev == '\t'))
	continue;
    }

    if (*src == '\t')
      *dst = ' ';
    else
      *dst = *src;

    dst++;
  }
  *dst = '\0';

  return str;
}

/*
 * assert_done - create f_instruction of bt_assert
 * @expr: expression in bt_assert()
 * @start: pointer to first char of test expression
 * @end: pointer to the last char of test expression
 */
static struct f_inst *
assert_done(struct f_inst *expr, const char *start, const char *end)
{
  return f_new_inst(FI_ASSERT, expr,
    (end >= start) ?
      assert_copy_expr(start, end - start + 1)
    : "???");
}

static struct f_inst *
f_lval_getter(struct f_lval *lval)
{
  switch (lval->type) {
    case F_LVAL_CONSTANT:	return f_new_inst(FI_CONSTANT, *(lval->sym->val));
    case F_LVAL_VARIABLE:	return f_new_inst(FI_VAR_GET, lval->sym);
    case F_LVAL_SA:		return f_new_inst(FI_RTA_GET, lval->rte, lval->sa);
    case F_LVAL_EA:		return f_new_inst(FI_EA_GET, lval->rte, lval->da);
    case F_LVAL_ATTR_BIT:
      {
	struct f_inst *c = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_INT, .val.i = (1U << lval->fab.bit)});
	return f_new_inst(FI_EQ, c, f_new_inst(FI_BITAND, f_new_inst(FI_EA_GET, lval->rte, lval->fab.class), c));
      }
    default:			bug("Unknown lval type");
  }
}

static struct f_inst *
f_lval_setter(struct f_lval *lval, struct f_inst *expr)
{
  switch (lval->type) {
    case F_LVAL_CONSTANT:	cf_error("Constant %s is read-only", lval->sym->name);
    case F_LVAL_VARIABLE:	return f_new_inst(FI_VAR_SET, expr, lval->sym);
    case F_LVAL_SA:
      if (lval->sa.readonly)
	cf_error( "This static attribute is read-only.");
      return f_new_inst(FI_RTA_SET, expr, lval->sa);

    case F_LVAL_EA:		return f_new_inst(FI_EA_SET, expr, lval->da);
    case F_LVAL_ATTR_BIT:	return f_new_inst(FI_CONDITION, expr,
	f_new_inst(FI_EA_SET,
	  f_new_inst(FI_BITOR,
	    f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_INT, .val.i = (1U << lval->fab.bit)}),
	    f_new_inst(FI_EA_GET, lval->rte, lval->fab.class)
	  ),
	  lval->fab.class),
	f_new_inst(FI_EA_SET,
	  f_new_inst(FI_BITAND,
	    f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_INT, .val.i = ~(1U << lval->fab.bit)}),
	    f_new_inst(FI_EA_GET, lval->rte, lval->fab.class)
	  ),
	  lval->fab.class)
	);
    default:			bug("Unknown lval type");
  }
}

static struct f_inst *
assert_assign(struct f_lval *lval, struct f_inst *expr, const char *start, const char *end)
{
  struct f_inst *setter = f_lval_setter(lval, expr),
		*getter = f_lval_getter(lval);

  struct f_inst *checker = f_new_inst(FI_EQ, expr, getter);
  setter->next = checker;

  return assert_done(setter, start, end);
}

#line 10 "nest/config.Y"
/* Headers from nest/config.Y */

#include "nest/rt-dev.h"
#include "nest/password.h"
#include "nest/cmds.h"
#include "nest/mpls.h"
#include "lib/lists.h"
#include "lib/mac.h"

/* Defines from nest/config.Y */

static struct rtable_config *this_table;
static struct proto_config *this_proto;
static struct channel_config *this_channel;
static struct iface_patt *this_ipatt;
static struct iface_patt_node *this_ipn;
/* static struct roa_table_config *this_roa_table; */
static list *this_p_list;
static struct password_item *this_p_item;
static int password_id;
static struct bfd_options *this_bfd_opts;

static void
iface_patt_check(void)
{
  struct iface_patt_node *pn;

  WALK_LIST(pn, this_ipatt->ipn_list)
    if (!pn->pattern || pn->prefix.type)
      cf_error("Interface name/mask expected, not IP prefix");
}

static inline void
init_password_list(void)
{
   if (!this_p_list) {
      this_p_list = cfg_allocz(sizeof(list));
      init_list(this_p_list);
      password_id = 1;
   }
}

static inline void
init_password(const void *key, uint length, uint id)
{
   this_p_item = cfg_allocz(sizeof (struct password_item));
   this_p_item->password = key;
   this_p_item->length = length;
   this_p_item->genfrom = 0;
   this_p_item->gento = TIME_INFINITY;
   this_p_item->accfrom = 0;
   this_p_item->accto = TIME_INFINITY;
   this_p_item->id = id;
   this_p_item->alg = ALG_UNDEFINED;
   add_tail(this_p_list, &this_p_item->n);
}

static inline void
reset_passwords(void)
{
  this_p_list = NULL;
}

static inline list *
get_passwords(void)
{
  list *rv = this_p_list;
  this_p_list = NULL;
  return rv;
}

static inline void
init_bfd_opts(struct bfd_options **opts)
{
  cf_check_bfd(1);

  if (! *opts)
    *opts = bfd_new_options();
}

static inline void
open_bfd_opts(struct bfd_options **opts)
{
  init_bfd_opts(opts);
  this_bfd_opts = *opts;
}

static inline void
close_bfd_opts(void)
{
  this_bfd_opts = NULL;
}

static void
proto_postconfig(void)
{
  CALL(this_proto->protocol->postconfig, this_proto);
  this_channel = NULL;
  this_proto = NULL;
}

static void
channel_reload_out_done_main(void *_prr)
{
  struct proto_reload_request *prr = _prr;
  ASSERT_THE_BIRD_LOCKED;

  rfree(prr->trie->lp);
}

static inline void
proto_call_cmd_reload(struct proto_spec ps, int dir, const struct f_trie *trie)
{
  struct proto_reload_request *prr = cfg_alloc(sizeof *prr);
  *prr = (struct proto_reload_request) {
    .trie = trie,
    .dir = dir,
    .counter = 1,
  };
  if (trie)
  {
    /* CLI linpool is moved to trie, because trie is need for longer time
     * than the linpool would exist in CLI. The linpool is freed in channel_reload_out_done_main.
     */
    ASSERT_DIE(this_cli->parser_pool == prr->trie->lp);
    rmove(this_cli->parser_pool, &root_pool);
    this_cli->parser_pool = lp_new(this_cli->pool);
    prr->ev = (event) {
      .data = prr,
      .hook = channel_reload_out_done_main,
    };
  }

  proto_apply_cmd(ps, proto_cmd_reload, 1, (uintptr_t) prr);
  /* This function used reference to this trie, so it is freed here as well as in protocols*/
  if (trie)
    if (atomic_fetch_sub_explicit(&prr->counter, 1, memory_order_acq_rel) == 1)
      ev_send_loop(&main_birdloop, &prr->ev);
}

#define DIRECT_CFG ((struct rt_dev_config *) this_proto)

#line 10 "nest/mpls.Y"
/* Headers from nest/mpls.Y */

#include "nest/mpls.h"

/* Defines from nest/mpls.Y */

static struct mpls_domain_config *this_mpls_domain;
static struct mpls_range_config *this_mpls_range;

#define MPLS_CC ((struct mpls_channel_config *) this_channel)

#line 11 "proto/aggregator/config.Y"
/* Headers from proto/aggregator/config.Y */

#include "proto/aggregator/aggregator.h"

/* Defines from proto/aggregator/config.Y */

#define AGGREGATOR_CFG ((struct aggregator_config *) this_proto)
#define AGGR_ITEM_ALLOC ((struct aggr_item_node *) cfg_allocz(sizeof(struct aggr_item_node)))

#line 8 "proto/bfd/config.Y"
/* Headers from proto/bfd/config.Y */

#include "proto/bfd/bfd.h"

/* Defines from proto/bfd/config.Y */

#define BFD_CFG ((struct bfd_config *) this_proto)
#define BFD_IFACE ((struct bfd_iface_config *) this_ipatt)
#define BFD_NEIGHBOR this_bfd_neighbor

static struct bfd_neighbor *this_bfd_neighbor;

extern struct bfd_config *bfd_cf;

#line 13 "proto/babel/config.Y"
/* Headers from proto/babel/config.Y */

#include "proto/babel/babel.h"
#include "nest/iface.h"

/* Defines from proto/babel/config.Y */

#define BABEL_CFG ((struct babel_config *) this_proto)
#define BABEL_IFACE ((struct babel_iface_config *) this_ipatt)

#line 9 "proto/bgp/config.Y"
/* Headers from proto/bgp/config.Y */

#include "proto/bgp/bgp.h"

/* Defines from proto/bgp/config.Y */

#define BGP_CFG ((struct bgp_config *) this_proto)
#define BGP_CC ((struct bgp_channel_config *) this_channel)

static struct ao_config *this_ao_key;
static struct ao_config **next_ao_key;

#line 10 "proto/l3vpn/config.Y"
/* Headers from proto/l3vpn/config.Y */

#include "proto/l3vpn/l3vpn.h"


/* Defines from proto/l3vpn/config.Y */

#define L3VPN_CFG ((struct l3vpn_config *) this_proto)

static void
f_tree_only_rt(struct f_tree *t)
{
  /* Parsed degenerate trees have link to the last node in t->right */
  t->right = NULL;

  while (t)
  {
    uint type1 = t->from.val.ec >> 48;
    uint type2 = t->to.val.ec >> 48;
    ASSERT(type1 == type2);

    if (!ec_type_is_rt(type1))
      cf_error("Extended community is not route target");

    ASSERT(!t->right);
    t = t->left;
  }
}


#line 9 "proto/ospf/config.Y"
/* Headers from proto/ospf/config.Y */

#include "proto/ospf/ospf.h"

/* Defines from proto/ospf/config.Y */

#define OSPF_CFG ((struct ospf_config *) this_proto)
#define OSPF_PATT ((struct ospf_iface_patt *) this_ipatt)

static struct ospf_area_config *this_area;
static struct nbma_node *this_nbma;
static list *this_nets;
static struct area_net_config *this_pref;
static struct ospf_stubnet_config *this_stubnet;

static inline int ospf_cfg_is_v2(void) { return OSPF_CFG->ospf2; }
static inline int ospf_cfg_is_v3(void) { return ! OSPF_CFG->ospf2; }

static void
ospf_iface_finish(void)
{
  struct ospf_iface_patt *ip = OSPF_PATT;

  if (ip->deadint == 0)
    ip->deadint = ip->deadc * ip->helloint;

  if (ip->waitint == 0)
    ip->waitint = ip->deadc * ip->helloint;

  ip->passwords = get_passwords();

  if (ospf_cfg_is_v2() && (ip->autype == OSPF_AUTH_CRYPT) && (ip->helloint < 5))
    cf_warn("Hello or poll interval less that 5 makes cryptographic authentication prone to replay attacks");

  if ((ip->autype == OSPF_AUTH_NONE) && (ip->passwords != NULL))
    cf_warn("Password option without authentication option does not make sense");

  if (ip->passwords)
  {
    struct password_item *pass;
    WALK_LIST(pass, *ip->passwords)
    {
      if (pass->alg && (ip->autype != OSPF_AUTH_CRYPT))
	cf_error("Password algorithm option requires cryptographic authentication");

      /* Set default OSPF crypto algorithms */
      if (!pass->alg && (ip->autype == OSPF_AUTH_CRYPT))
	pass->alg = ospf_cfg_is_v2() ? ALG_MD5 : ALG_HMAC_SHA256;

      if (ospf_cfg_is_v3() && ip->autype && (pass->alg < ALG_HMAC))
	cf_error("Keyed hash algorithms are not allowed, use HMAC algorithms");
    }
  }
}

static void
ospf_area_finish(void)
{
  if ((this_area->areaid == 0) && (this_area->type != OPT_E))
    cf_error("Backbone area cannot be stub/NSSA");

  if (this_area->summary && (this_area->type == OPT_E))
    cf_error("Only stub/NSSA areas can use summary propagation");

  if (this_area->default_nssa && ((this_area->type != OPT_N) || ! this_area->summary))
    cf_error("Only NSSA areas with summary propagation can use NSSA default route");

  if ((this_area->default_cost & LSA_EXT3_EBIT) && ! this_area->default_nssa)
    cf_error("Only NSSA default route can use type 2 metric");
}

static void
ospf_proto_finish(void)
{
  struct ospf_config *cf = OSPF_CFG;
  struct ospf_area_config *ac;
  struct ospf_iface_patt *ic;

  /* Define default channel */
  if (! proto_cf_main_channel(this_proto))
  {
    uint net_type = this_proto->net_type = ospf_cfg_is_v2() ? NET_IP4 : NET_IP6;
    channel_config_new(NULL, net_label[net_type], net_type, this_proto);
  }

  /* Propagate global instance ID to interfaces */
  if (cf->instance_id_set)
  {
    WALK_LIST(ac, cf->area_list)
      WALK_LIST(ic, ac->patt_list)
	if (!ic->instance_id_set)
	{ ic->instance_id = cf->instance_id; ic->instance_id_set = 1; }

    WALK_LIST(ic, cf->vlink_list)
      if (!ic->instance_id_set)
      { ic->instance_id = cf->instance_id; ic->instance_id_set = 1; }
  }

  if (ospf_cfg_is_v3())
  {
    uint ipv4 = (this_proto->net_type == NET_IP4);
    uint base = (ipv4 ? 64 : 0) + (cf->af_mc ? 32 : 0);

    /* RFC 5838 - OSPFv3-AF */
    if (cf->af_ext)
    {
      /* RFC 5838 2.1 - instance IDs based on AFs */
      WALK_LIST(ac, cf->area_list)
	WALK_LIST(ic, ac->patt_list)
	{
	  if (!ic->instance_id_set)
	    ic->instance_id = base;
	  else if (ic->instance_id >= 128)
	    cf_warn("Instance ID %d from unassigned/private range", ic->instance_id);
	  else if ((ic->instance_id < base) || (ic->instance_id >= (base + 32)))
	    cf_error("Instance ID %d invalid for given channel type", ic->instance_id);
	}

      /* RFC 5838 2.8 - vlinks limited to IPv6 unicast */
      if ((ipv4 || cf->af_mc) && !EMPTY_LIST(cf->vlink_list))
	cf_error("Vlinks not supported in AFs other than IPv6 unicast");
    }
    else
    {
      if (ipv4 || cf->af_mc)
	cf_error("Different channel type");
    }
  }

  if (EMPTY_LIST(cf->area_list))
    cf_error("No configured areas in OSPF");

  int areano = 0;
  int backbone = 0;
  int nssa = 0;
  WALK_LIST(ac, cf->area_list)
  {
    areano++;
    if (ac->areaid == 0)
      backbone = 1;
    if (ac->type == OPT_N)
      nssa = 1;
  }

  cf->abr = areano > 1;

  /* Route export or NSSA translation (RFC 3101 3.1) */
  cf->asbr = (proto_cf_main_channel(this_proto)->out_filter != FILTER_REJECT) || (nssa && cf->abr);

  if (cf->abr && !backbone)
  {
    struct ospf_area_config *ac = cfg_allocz(sizeof(struct ospf_area_config));
    ac->type = OPT_E; /* Backbone is non-stub */
    add_head(&cf->area_list, NODE ac);
    init_list(&ac->patt_list);
    init_list(&ac->net_list);
    init_list(&ac->enet_list);
    init_list(&ac->stubnet_list);
  }

  if (!cf->abr && !EMPTY_LIST(cf->vlink_list))
    cf_error("Vlinks cannot be used on single area router");

  if (cf->asbr && (areano == 1) && (this_area->type == 0))
    cf_error("ASBR must be in non-stub area");
}

static inline void
ospf_check_defcost(int cost)
{
  if ((cost <= 0) || (cost >= LSINFINITY))
   cf_error("Default cost must be in range 1-%u", LSINFINITY-1);
}

static inline void
ospf_check_auth(void)
{
  if (ospf_cfg_is_v3())
    cf_error("Plaintext authentication not supported in OSPFv3");
}


#line 9 "proto/pipe/config.Y"
/* Headers from proto/pipe/config.Y */

#include "proto/pipe/pipe.h"

/* Defines from proto/pipe/config.Y */

#define PIPE_CFG ((struct pipe_config *) this_proto)

#line 10 "proto/radv/config.Y"
/* Headers from proto/radv/config.Y */

#include "proto/radv/radv.h"

/* Defines from proto/radv/config.Y */

#define RADV_CFG ((struct radv_config *) this_proto)
#define RADV_IFACE ((struct radv_iface_config *) this_ipatt)
#define RADV_PREFIX this_radv_prefix
#define RADV_RDNSS (&this_radv_rdnss)
#define RADV_DNSSL (&this_radv_dnssl)

static struct radv_prefix_config *this_radv_prefix;
static struct radv_rdnss_config this_radv_rdnss;
static struct radv_dnssl_config this_radv_dnssl;
static list radv_dns_list;	/* Used by radv_rdnss and radv_dnssl */
static u8 radv_mult_val;	/* Used by radv_mult for second return value */

static inline void
radv_add_to_custom_list(list *l, int type, const struct adata *payload)
{
  if (type < 0 || type > 255) cf_error("RA cusom type must be in range 0-255");
  struct radv_custom_config *cf = cfg_allocz(sizeof(struct radv_custom_config));
  add_tail(l, NODE cf);
  cf->type = type;
  cf->payload = payload;
}

#line 12 "proto/rip/config.Y"
/* Headers from proto/rip/config.Y */

#include "proto/rip/rip.h"
#include "nest/iface.h"

/* Defines from proto/rip/config.Y */

#define RIP_CFG ((struct rip_config *) this_proto)
#define RIP_IFACE ((struct rip_iface_config *) this_ipatt)

static inline int rip_cfg_is_v2(void) { return RIP_CFG->rip2; }
static inline int rip_cfg_is_ng(void) { return ! RIP_CFG->rip2; }

static inline void
rip_check_auth(void)
{
  if (rip_cfg_is_ng())
    cf_error("Authentication not supported in RIPng");
}


#line 9 "proto/rpki/config.Y"
/* Headers from proto/rpki/config.Y */

#include "proto/rpki/rpki.h"

/* Defines from proto/rpki/config.Y */

#define RPKI_CFG ((struct rpki_config *) this_proto)
#define RPKI_TR_TCP_CFG ((struct rpki_tr_tcp_config *) RPKI_CFG->tr_config.spec)
#define RPKI_TR_SSH_CFG ((struct rpki_tr_ssh_config *) RPKI_CFG->tr_config.spec)

static void
rpki_check_unused_hostname(void)
{
  if (RPKI_CFG->hostname != NULL)
    cf_error("Only one cache server per protocol allowed");
}

static void
rpki_check_unused_transport(void)
{
  if (RPKI_CFG->tr_config.spec != NULL)
    cf_error("At the most one transport per protocol allowed");
}

#line 9 "proto/static/config.Y"
/* Headers from proto/static/config.Y */

#include "proto/static/static.h"

/* Defines from proto/static/config.Y */

#define STATIC_CFG ((struct static_config *) this_proto)
static struct static_route *this_srt, *this_snh;
static struct f_inst *this_srt_cmds, *this_srt_last_cmd;
static uint this_srt_aspa_max;

static struct static_route *
static_nexthop_new(void)
{
  struct static_route *nh = this_srt;

  if (this_snh)
  {
    /* Additional next hop */
    nh = cfg_allocz(sizeof(struct static_route));
    nh->net = this_srt->net;
    this_snh->mp_next = nh;
  }

  nh->dest = RTD_UNICAST;
  nh->mp_head = this_srt;
  return nh;
};

static void
static_route_finish(void)
{
  if (net_type_match(this_srt->net, NB_DEST) == !this_srt->dest)
    cf_error("Unexpected or missing nexthop/type");

  this_srt->cmds = f_linearize(this_srt_cmds, 0);
}

#line 10 "proto/mrt/config.Y"
/* Headers from proto/mrt/config.Y */

#include "proto/mrt/mrt.h"

/* Defines from proto/mrt/config.Y */

#define MRT_CFG ((struct mrt_config *) this_proto)

#line 9 "proto/bmp/config.Y"
/* Headers from proto/bmp/config.Y */

#include "proto/bmp/bmp.h"

/* Defines from proto/bmp/config.Y */

#define BMP_CFG ((struct bmp_config *) this_proto)

#line 9 "sysdep/linux/netlink.Y"
/* Headers from sysdep/linux/netlink.Y */

#line 9 "sysdep/unix/config.Y"
/* Headers from sysdep/unix/config.Y */

#include "sysdep/unix/unix.h"
#include <stdio.h>

/* Defines from sysdep/unix/config.Y */

static struct log_config *this_log;
static struct cli_config *this_cli_config;
static struct thread_group_config *this_thread_group;

#line 9 "sysdep/unix/krt.Y"
/* Headers from sysdep/unix/krt.Y */

#include "sysdep/unix/krt.h"

/* Defines from sysdep/unix/krt.Y */

#define THIS_KRT ((struct krt_config *) this_proto)
#define THIS_KIF ((struct kif_config *) this_proto)
#define KIF_IFACE ((struct kif_iface_config *) this_ipatt)

static void
kif_set_preferred(ip_addr ip)
{
  if (ipa_is_ip4(ip))
    KIF_IFACE->pref_v4 = ip;
  else if (!ipa_is_link_local(ip))
    KIF_IFACE->pref_v6 = ip;
  else
    KIF_IFACE->pref_ll = ip;
}

#line 57 "conf/gen_parser.m4"

#line 1093 "obj/conf/cf-parse.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "cf-parse.tab.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_QUIT = 3,                       /* QUIT  */
  YYSYMBOL_EXIT = 4,                       /* EXIT  */
  YYSYMBOL_HELP = 5,                       /* HELP  */
  YYSYMBOL_END = 6,                        /* END  */
  YYSYMBOL_CLI_MARKER = 7,                 /* CLI_MARKER  */
  YYSYMBOL_INVALID_TOKEN = 8,              /* INVALID_TOKEN  */
  YYSYMBOL_ELSECOL = 9,                    /* ELSECOL  */
  YYSYMBOL_DDOT = 10,                      /* DDOT  */
  YYSYMBOL_GEQ = 11,                       /* GEQ  */
  YYSYMBOL_LEQ = 12,                       /* LEQ  */
  YYSYMBOL_NEQ = 13,                       /* NEQ  */
  YYSYMBOL_AND = 14,                       /* AND  */
  YYSYMBOL_OR = 15,                        /* OR  */
  YYSYMBOL_IMP = 16,                       /* IMP  */
  YYSYMBOL_PO = 17,                        /* PO  */
  YYSYMBOL_PC = 18,                        /* PC  */
  YYSYMBOL_NUM = 19,                       /* NUM  */
  YYSYMBOL_ENUM_TOKEN = 20,                /* ENUM_TOKEN  */
  YYSYMBOL_IP4 = 21,                       /* IP4  */
  YYSYMBOL_IP6 = 22,                       /* IP6  */
  YYSYMBOL_VPN_RD = 23,                    /* VPN_RD  */
  YYSYMBOL_CF_SYM_KNOWN = 24,              /* CF_SYM_KNOWN  */
  YYSYMBOL_CF_SYM_UNDEFINED = 25,          /* CF_SYM_UNDEFINED  */
  YYSYMBOL_CF_SYM_METHOD_BARE = 26,        /* CF_SYM_METHOD_BARE  */
  YYSYMBOL_CF_SYM_METHOD_ARGS = 27,        /* CF_SYM_METHOD_ARGS  */
  YYSYMBOL_TEXT = 28,                      /* TEXT  */
  YYSYMBOL_BYTETEXT = 29,                  /* BYTETEXT  */
  YYSYMBOL_PREFIX_DUMMY = 30,              /* PREFIX_DUMMY  */
  YYSYMBOL_31_ = 31,                       /* '='  */
  YYSYMBOL_32_ = 32,                       /* '<'  */
  YYSYMBOL_33_ = 33,                       /* '>'  */
  YYSYMBOL_34_ = 34,                       /* '~'  */
  YYSYMBOL_NMA = 35,                       /* NMA  */
  YYSYMBOL_36_ = 36,                       /* '|'  */
  YYSYMBOL_37_ = 37,                       /* '&'  */
  YYSYMBOL_38_ = 38,                       /* '+'  */
  YYSYMBOL_39_ = 39,                       /* '-'  */
  YYSYMBOL_40_ = 40,                       /* '*'  */
  YYSYMBOL_41_ = 41,                       /* '/'  */
  YYSYMBOL_42_ = 42,                       /* '%'  */
  YYSYMBOL_43_ = 43,                       /* '!'  */
  YYSYMBOL_44_ = 44,                       /* '.'  */
  YYSYMBOL_DEFINE = 45,                    /* DEFINE  */
  YYSYMBOL_ON = 46,                        /* ON  */
  YYSYMBOL_OFF = 47,                       /* OFF  */
  YYSYMBOL_YES = 48,                       /* YES  */
  YYSYMBOL_NO = 49,                        /* NO  */
  YYSYMBOL_S = 50,                         /* S  */
  YYSYMBOL_MS = 51,                        /* MS  */
  YYSYMBOL_US = 52,                        /* US  */
  YYSYMBOL_PORT = 53,                      /* PORT  */
  YYSYMBOL_VPN = 54,                       /* VPN  */
  YYSYMBOL_MPLS = 55,                      /* MPLS  */
  YYSYMBOL_FROM = 56,                      /* FROM  */
  YYSYMBOL_MAX = 57,                       /* MAX  */
  YYSYMBOL_AS = 58,                        /* AS  */
  YYSYMBOL_59_ = 59,                       /* ';'  */
  YYSYMBOL_60_ = 60,                       /* '('  */
  YYSYMBOL_61_ = 61,                       /* ')'  */
  YYSYMBOL_FLOW4 = 62,                     /* FLOW4  */
  YYSYMBOL_FLOW6 = 63,                     /* FLOW6  */
  YYSYMBOL_DST = 64,                       /* DST  */
  YYSYMBOL_SRC = 65,                       /* SRC  */
  YYSYMBOL_PROTO = 66,                     /* PROTO  */
  YYSYMBOL_NEXT = 67,                      /* NEXT  */
  YYSYMBOL_HEADER = 68,                    /* HEADER  */
  YYSYMBOL_DPORT = 69,                     /* DPORT  */
  YYSYMBOL_SPORT = 70,                     /* SPORT  */
  YYSYMBOL_ICMP = 71,                      /* ICMP  */
  YYSYMBOL_TYPE = 72,                      /* TYPE  */
  YYSYMBOL_CODE = 73,                      /* CODE  */
  YYSYMBOL_TCP = 74,                       /* TCP  */
  YYSYMBOL_FLAGS = 75,                     /* FLAGS  */
  YYSYMBOL_LENGTH = 76,                    /* LENGTH  */
  YYSYMBOL_DSCP = 77,                      /* DSCP  */
  YYSYMBOL_DONT_FRAGMENT = 78,             /* DONT_FRAGMENT  */
  YYSYMBOL_IS_FRAGMENT = 79,               /* IS_FRAGMENT  */
  YYSYMBOL_FIRST_FRAGMENT = 80,            /* FIRST_FRAGMENT  */
  YYSYMBOL_LAST_FRAGMENT = 81,             /* LAST_FRAGMENT  */
  YYSYMBOL_FRAGMENT = 82,                  /* FRAGMENT  */
  YYSYMBOL_LABEL = 83,                     /* LABEL  */
  YYSYMBOL_OFFSET = 84,                    /* OFFSET  */
  YYSYMBOL_85_ = 85,                       /* ','  */
  YYSYMBOL_86_ = 86,                       /* '{'  */
  YYSYMBOL_87_ = 87,                       /* '}'  */
  YYSYMBOL_FUNCTION = 88,                  /* FUNCTION  */
  YYSYMBOL_PRINT = 89,                     /* PRINT  */
  YYSYMBOL_PRINTN = 90,                    /* PRINTN  */
  YYSYMBOL_UNSET = 91,                     /* UNSET  */
  YYSYMBOL_RETURN = 92,                    /* RETURN  */
  YYSYMBOL_ACCEPT = 93,                    /* ACCEPT  */
  YYSYMBOL_REJECT = 94,                    /* REJECT  */
  YYSYMBOL_ERROR = 95,                     /* ERROR  */
  YYSYMBOL_INT = 96,                       /* INT  */
  YYSYMBOL_BOOL = 97,                      /* BOOL  */
  YYSYMBOL_IP = 98,                        /* IP  */
  YYSYMBOL_PREFIX = 99,                    /* PREFIX  */
  YYSYMBOL_RD = 100,                       /* RD  */
  YYSYMBOL_PAIR = 101,                     /* PAIR  */
  YYSYMBOL_QUAD = 102,                     /* QUAD  */
  YYSYMBOL_EC = 103,                       /* EC  */
  YYSYMBOL_LC = 104,                       /* LC  */
  YYSYMBOL_ENUM = 105,                     /* ENUM  */
  YYSYMBOL_SET = 106,                      /* SET  */
  YYSYMBOL_STRING = 107,                   /* STRING  */
  YYSYMBOL_BYTESTRING = 108,               /* BYTESTRING  */
  YYSYMBOL_BGPMASK = 109,                  /* BGPMASK  */
  YYSYMBOL_BGPPATH = 110,                  /* BGPPATH  */
  YYSYMBOL_CLIST = 111,                    /* CLIST  */
  YYSYMBOL_ECLIST = 112,                   /* ECLIST  */
  YYSYMBOL_LCLIST = 113,                   /* LCLIST  */
  YYSYMBOL_IF = 114,                       /* IF  */
  YYSYMBOL_THEN = 115,                     /* THEN  */
  YYSYMBOL_ELSE = 116,                     /* ELSE  */
  YYSYMBOL_CASE = 117,                     /* CASE  */
  YYSYMBOL_FOR = 118,                      /* FOR  */
  YYSYMBOL_IN = 119,                       /* IN  */
  YYSYMBOL_DO = 120,                       /* DO  */
  YYSYMBOL_TRUE = 121,                     /* TRUE  */
  YYSYMBOL_FALSE = 122,                    /* FALSE  */
  YYSYMBOL_RT = 123,                       /* RT  */
  YYSYMBOL_RO = 124,                       /* RO  */
  YYSYMBOL_UNKNOWN = 125,                  /* UNKNOWN  */
  YYSYMBOL_GENERIC = 126,                  /* GENERIC  */
  YYSYMBOL_GW = 127,                       /* GW  */
  YYSYMBOL_NET = 128,                      /* NET  */
  YYSYMBOL_SCOPE = 129,                    /* SCOPE  */
  YYSYMBOL_DEST = 130,                     /* DEST  */
  YYSYMBOL_IFNAME = 131,                   /* IFNAME  */
  YYSYMBOL_IFINDEX = 132,                  /* IFINDEX  */
  YYSYMBOL_WEIGHT = 133,                   /* WEIGHT  */
  YYSYMBOL_GW_MPLS = 134,                  /* GW_MPLS  */
  YYSYMBOL_ROA_CHECK = 135,                /* ROA_CHECK  */
  YYSYMBOL_ASPA_CHECK = 136,               /* ASPA_CHECK  */
  YYSYMBOL_DEFINED = 137,                  /* DEFINED  */
  YYSYMBOL_ADD = 138,                      /* ADD  */
  YYSYMBOL_DELETE = 139,                   /* DELETE  */
  YYSYMBOL_RESET = 140,                    /* RESET  */
  YYSYMBOL_PREPEND = 141,                  /* PREPEND  */
  YYSYMBOL_EMPTY = 142,                    /* EMPTY  */
  YYSYMBOL_FILTER = 143,                   /* FILTER  */
  YYSYMBOL_WHERE = 144,                    /* WHERE  */
  YYSYMBOL_EVAL = 145,                     /* EVAL  */
  YYSYMBOL_ATTRIBUTE = 146,                /* ATTRIBUTE  */
  YYSYMBOL_FROM_HEX = 147,                 /* FROM_HEX  */
  YYSYMBOL_BT_ASSERT = 148,                /* BT_ASSERT  */
  YYSYMBOL_BT_TEST_SUITE = 149,            /* BT_TEST_SUITE  */
  YYSYMBOL_BT_CHECK_ASSIGN = 150,          /* BT_CHECK_ASSIGN  */
  YYSYMBOL_BT_TEST_SAME = 151,             /* BT_TEST_SAME  */
  YYSYMBOL_FORMAT = 152,                   /* FORMAT  */
  YYSYMBOL_STACKS = 153,                   /* STACKS  */
  YYSYMBOL_154_ = 154,                     /* ':'  */
  YYSYMBOL_155_ = 155,                     /* '['  */
  YYSYMBOL_156_ = 156,                     /* ']'  */
  YYSYMBOL_157_ = 157,                     /* '?'  */
  YYSYMBOL_ROUTER = 158,                   /* ROUTER  */
  YYSYMBOL_ID = 159,                       /* ID  */
  YYSYMBOL_HOSTNAME = 160,                 /* HOSTNAME  */
  YYSYMBOL_PROTOCOL = 161,                 /* PROTOCOL  */
  YYSYMBOL_TEMPLATE = 162,                 /* TEMPLATE  */
  YYSYMBOL_PREFERENCE = 163,               /* PREFERENCE  */
  YYSYMBOL_DISABLED = 164,                 /* DISABLED  */
  YYSYMBOL_DEBUG = 165,                    /* DEBUG  */
  YYSYMBOL_ALL = 166,                      /* ALL  */
  YYSYMBOL_DIRECT = 167,                   /* DIRECT  */
  YYSYMBOL_PIPE = 168,                     /* PIPE  */
  YYSYMBOL_INTERFACE = 169,                /* INTERFACE  */
  YYSYMBOL_IMPORT = 170,                   /* IMPORT  */
  YYSYMBOL_EXPORT = 171,                   /* EXPORT  */
  YYSYMBOL_NONE = 172,                     /* NONE  */
  YYSYMBOL_VRF = 173,                      /* VRF  */
  YYSYMBOL_DEFAULT = 174,                  /* DEFAULT  */
  YYSYMBOL_TABLE = 175,                    /* TABLE  */
  YYSYMBOL_TABLES = 176,                   /* TABLES  */
  YYSYMBOL_STATES = 177,                   /* STATES  */
  YYSYMBOL_ROUTES = 178,                   /* ROUTES  */
  YYSYMBOL_FILTERS = 179,                  /* FILTERS  */
  YYSYMBOL_IPV4 = 180,                     /* IPV4  */
  YYSYMBOL_IPV6 = 181,                     /* IPV6  */
  YYSYMBOL_VPN4 = 182,                     /* VPN4  */
  YYSYMBOL_VPN6 = 183,                     /* VPN6  */
  YYSYMBOL_ROA4 = 184,                     /* ROA4  */
  YYSYMBOL_ROA6 = 185,                     /* ROA6  */
  YYSYMBOL_SADR = 186,                     /* SADR  */
  YYSYMBOL_ASPA = 187,                     /* ASPA  */
  YYSYMBOL_RECEIVE = 188,                  /* RECEIVE  */
  YYSYMBOL_LIMIT = 189,                    /* LIMIT  */
  YYSYMBOL_ACTION = 190,                   /* ACTION  */
  YYSYMBOL_WARN = 191,                     /* WARN  */
  YYSYMBOL_BLOCK = 192,                    /* BLOCK  */
  YYSYMBOL_RESTART = 193,                  /* RESTART  */
  YYSYMBOL_DISABLE = 194,                  /* DISABLE  */
  YYSYMBOL_KEEP = 195,                     /* KEEP  */
  YYSYMBOL_FILTERED = 196,                 /* FILTERED  */
  YYSYMBOL_RPKI = 197,                     /* RPKI  */
  YYSYMBOL_PASSWORD = 198,                 /* PASSWORD  */
  YYSYMBOL_KEY = 199,                      /* KEY  */
  YYSYMBOL_PASSIVE = 200,                  /* PASSIVE  */
  YYSYMBOL_TO = 201,                       /* TO  */
  YYSYMBOL_EVENTS = 202,                   /* EVENTS  */
  YYSYMBOL_PACKETS = 203,                  /* PACKETS  */
  YYSYMBOL_PROTOCOLS = 204,                /* PROTOCOLS  */
  YYSYMBOL_CHANNELS = 205,                 /* CHANNELS  */
  YYSYMBOL_INTERFACES = 206,               /* INTERFACES  */
  YYSYMBOL_ALGORITHM = 207,                /* ALGORITHM  */
  YYSYMBOL_KEYED = 208,                    /* KEYED  */
  YYSYMBOL_HMAC = 209,                     /* HMAC  */
  YYSYMBOL_MD5 = 210,                      /* MD5  */
  YYSYMBOL_SHA1 = 211,                     /* SHA1  */
  YYSYMBOL_SHA256 = 212,                   /* SHA256  */
  YYSYMBOL_SHA384 = 213,                   /* SHA384  */
  YYSYMBOL_SHA512 = 214,                   /* SHA512  */
  YYSYMBOL_BLAKE2S128 = 215,               /* BLAKE2S128  */
  YYSYMBOL_BLAKE2S256 = 216,               /* BLAKE2S256  */
  YYSYMBOL_BLAKE2B256 = 217,               /* BLAKE2B256  */
  YYSYMBOL_BLAKE2B512 = 218,               /* BLAKE2B512  */
  YYSYMBOL_PRIMARY = 219,                  /* PRIMARY  */
  YYSYMBOL_STATS = 220,                    /* STATS  */
  YYSYMBOL_COUNT = 221,                    /* COUNT  */
  YYSYMBOL_COMMANDS = 222,                 /* COMMANDS  */
  YYSYMBOL_PREEXPORT = 223,                /* PREEXPORT  */
  YYSYMBOL_NOEXPORT = 224,                 /* NOEXPORT  */
  YYSYMBOL_EXPORTED = 225,                 /* EXPORTED  */
  YYSYMBOL_GENERATE = 226,                 /* GENERATE  */
  YYSYMBOL_BGP = 227,                      /* BGP  */
  YYSYMBOL_PASSWORDS = 228,                /* PASSWORDS  */
  YYSYMBOL_DESCRIPTION = 229,              /* DESCRIPTION  */
  YYSYMBOL_RELOAD = 230,                   /* RELOAD  */
  YYSYMBOL_OUT = 231,                      /* OUT  */
  YYSYMBOL_MRTDUMP = 232,                  /* MRTDUMP  */
  YYSYMBOL_MESSAGES = 233,                 /* MESSAGES  */
  YYSYMBOL_RESTRICT = 234,                 /* RESTRICT  */
  YYSYMBOL_MEMORY = 235,                   /* MEMORY  */
  YYSYMBOL_CLASS = 236,                    /* CLASS  */
  YYSYMBOL_PARTIAL = 237,                  /* PARTIAL  */
  YYSYMBOL_TIMEFORMAT = 238,               /* TIMEFORMAT  */
  YYSYMBOL_ISO = 239,                      /* ISO  */
  YYSYMBOL_SHORT = 240,                    /* SHORT  */
  YYSYMBOL_LONG = 241,                     /* LONG  */
  YYSYMBOL_ROUTE = 242,                    /* ROUTE  */
  YYSYMBOL_BASE = 243,                     /* BASE  */
  YYSYMBOL_LOG = 244,                      /* LOG  */
  YYSYMBOL_GRACEFUL = 245,                 /* GRACEFUL  */
  YYSYMBOL_WAIT = 246,                     /* WAIT  */
  YYSYMBOL_CHECK = 247,                    /* CHECK  */
  YYSYMBOL_LINK = 248,                     /* LINK  */
  YYSYMBOL_CORK = 249,                     /* CORK  */
  YYSYMBOL_SORTED = 250,                   /* SORTED  */
  YYSYMBOL_TRIE = 251,                     /* TRIE  */
  YYSYMBOL_MIN = 252,                      /* MIN  */
  YYSYMBOL_ROA = 253,                      /* ROA  */
  YYSYMBOL_DIGEST = 254,                   /* DIGEST  */
  YYSYMBOL_REFRESH = 255,                  /* REFRESH  */
  YYSYMBOL_SETTLE = 256,                   /* SETTLE  */
  YYSYMBOL_TIME = 257,                     /* TIME  */
  YYSYMBOL_GC = 258,                       /* GC  */
  YYSYMBOL_THRESHOLD = 259,                /* THRESHOLD  */
  YYSYMBOL_PERIOD = 260,                   /* PERIOD  */
  YYSYMBOL_MPLS_LABEL = 261,               /* MPLS_LABEL  */
  YYSYMBOL_MPLS_POLICY = 262,              /* MPLS_POLICY  */
  YYSYMBOL_MPLS_CLASS = 263,               /* MPLS_CLASS  */
  YYSYMBOL_ASPA_PROVIDERS = 264,           /* ASPA_PROVIDERS  */
  YYSYMBOL_IPV4_MC = 265,                  /* IPV4_MC  */
  YYSYMBOL_IPV4_MPLS = 266,                /* IPV4_MPLS  */
  YYSYMBOL_IPV6_MC = 267,                  /* IPV6_MC  */
  YYSYMBOL_IPV6_MPLS = 268,                /* IPV6_MPLS  */
  YYSYMBOL_IPV6_SADR = 269,                /* IPV6_SADR  */
  YYSYMBOL_VPN4_MC = 270,                  /* VPN4_MC  */
  YYSYMBOL_VPN4_MPLS = 271,                /* VPN4_MPLS  */
  YYSYMBOL_VPN6_MC = 272,                  /* VPN6_MC  */
  YYSYMBOL_VPN6_MPLS = 273,                /* VPN6_MPLS  */
  YYSYMBOL_PRI = 274,                      /* PRI  */
  YYSYMBOL_SEC = 275,                      /* SEC  */
  YYSYMBOL_NET_TYPE = 276,                 /* NET_TYPE  */
  YYSYMBOL_RTS = 277,                      /* RTS  */
  YYSYMBOL_RTD = 278,                      /* RTD  */
  YYSYMBOL_AF = 279,                       /* AF  */
  YYSYMBOL_SHOW = 280,                     /* SHOW  */
  YYSYMBOL_STATUS = 281,                   /* STATUS  */
  YYSYMBOL_SUMMARY = 282,                  /* SUMMARY  */
  YYSYMBOL_SYMBOLS = 283,                  /* SYMBOLS  */
  YYSYMBOL_DUMP = 284,                     /* DUMP  */
  YYSYMBOL_RESOURCES = 285,                /* RESOURCES  */
  YYSYMBOL_SOCKETS = 286,                  /* SOCKETS  */
  YYSYMBOL_AO = 287,                       /* AO  */
  YYSYMBOL_KEYS = 288,                     /* KEYS  */
  YYSYMBOL_NEIGHBORS = 289,                /* NEIGHBORS  */
  YYSYMBOL_ATTRIBUTES = 290,               /* ATTRIBUTES  */
  YYSYMBOL_ENABLE = 291,                   /* ENABLE  */
  YYSYMBOL_DOMAIN = 292,                   /* DOMAIN  */
  YYSYMBOL_RANGE = 293,                    /* RANGE  */
  YYSYMBOL_STATIC = 294,                   /* STATIC  */
  YYSYMBOL_DYNAMIC = 295,                  /* DYNAMIC  */
  YYSYMBOL_START = 296,                    /* START  */
  YYSYMBOL_POLICY = 297,                   /* POLICY  */
  YYSYMBOL_AGGREGATE = 298,                /* AGGREGATE  */
  YYSYMBOL_RANGES = 299,                   /* RANGES  */
  YYSYMBOL_AGGREGATOR = 300,               /* AGGREGATOR  */
  YYSYMBOL_PEER = 301,                     /* PEER  */
  YYSYMBOL_MERGE = 302,                    /* MERGE  */
  YYSYMBOL_BY = 303,                       /* BY  */
  YYSYMBOL_BABEL = 304,                    /* BABEL  */
  YYSYMBOL_METRIC = 305,                   /* METRIC  */
  YYSYMBOL_RXCOST = 306,                   /* RXCOST  */
  YYSYMBOL_HELLO = 307,                    /* HELLO  */
  YYSYMBOL_UPDATE = 308,                   /* UPDATE  */
  YYSYMBOL_WIRED = 309,                    /* WIRED  */
  YYSYMBOL_WIRELESS = 310,                 /* WIRELESS  */
  YYSYMBOL_BUFFER = 311,                   /* BUFFER  */
  YYSYMBOL_PRIORITY = 312,                 /* PRIORITY  */
  YYSYMBOL_HOP = 313,                      /* HOP  */
  YYSYMBOL_ENTRIES = 314,                  /* ENTRIES  */
  YYSYMBOL_RANDOMIZE = 315,                /* RANDOMIZE  */
  YYSYMBOL_MAC = 316,                      /* MAC  */
  YYSYMBOL_PERMISSIVE = 317,               /* PERMISSIVE  */
  YYSYMBOL_EXTENDED = 318,                 /* EXTENDED  */
  YYSYMBOL_TUNNEL = 319,                   /* TUNNEL  */
  YYSYMBOL_RTT = 320,                      /* RTT  */
  YYSYMBOL_DECAY = 321,                    /* DECAY  */
  YYSYMBOL_SEND = 322,                     /* SEND  */
  YYSYMBOL_TIMESTAMPS = 323,               /* TIMESTAMPS  */
  YYSYMBOL_COST = 324,                     /* COST  */
  YYSYMBOL_DELAY = 325,                    /* DELAY  */
  YYSYMBOL_PREFER = 326,                   /* PREFER  */
  YYSYMBOL_NATIVE = 327,                   /* NATIVE  */
  YYSYMBOL_BFD = 328,                      /* BFD  */
  YYSYMBOL_IDLE = 329,                     /* IDLE  */
  YYSYMBOL_RX = 330,                       /* RX  */
  YYSYMBOL_TX = 331,                       /* TX  */
  YYSYMBOL_INTERVAL = 332,                 /* INTERVAL  */
  YYSYMBOL_MULTIPLIER = 333,               /* MULTIPLIER  */
  YYSYMBOL_ADDRESS = 334,                  /* ADDRESS  */
  YYSYMBOL_EXPRESS = 335,                  /* EXPRESS  */
  YYSYMBOL_MULTIHOP = 336,                 /* MULTIHOP  */
  YYSYMBOL_NEIGHBOR = 337,                 /* NEIGHBOR  */
  YYSYMBOL_DEV = 338,                      /* DEV  */
  YYSYMBOL_LOCAL = 339,                    /* LOCAL  */
  YYSYMBOL_AUTHENTICATION = 340,           /* AUTHENTICATION  */
  YYSYMBOL_SIMPLE = 341,                   /* SIMPLE  */
  YYSYMBOL_METICULOUS = 342,               /* METICULOUS  */
  YYSYMBOL_STRICT = 343,                   /* STRICT  */
  YYSYMBOL_BIND = 344,                     /* BIND  */
  YYSYMBOL_ZERO = 345,                     /* ZERO  */
  YYSYMBOL_UDP6 = 346,                     /* UDP6  */
  YYSYMBOL_CHECKSUM = 347,                 /* CHECKSUM  */
  YYSYMBOL_SESSIONS = 348,                 /* SESSIONS  */
  YYSYMBOL_HOLD = 349,                     /* HOLD  */
  YYSYMBOL_CONNECT = 350,                  /* CONNECT  */
  YYSYMBOL_RETRY = 351,                    /* RETRY  */
  YYSYMBOL_KEEPALIVE = 352,                /* KEEPALIVE  */
  YYSYMBOL_STARTUP = 353,                  /* STARTUP  */
  YYSYMBOL_VIA = 354,                      /* VIA  */
  YYSYMBOL_SELF = 355,                     /* SELF  */
  YYSYMBOL_PATH = 356,                     /* PATH  */
  YYSYMBOL_FORGET = 357,                   /* FORGET  */
  YYSYMBOL_AFTER = 358,                    /* AFTER  */
  YYSYMBOL_BGP_LOCAL_PREF = 359,           /* BGP_LOCAL_PREF  */
  YYSYMBOL_BGP_MED = 360,                  /* BGP_MED  */
  YYSYMBOL_SOURCE = 361,                   /* SOURCE  */
  YYSYMBOL_RR = 362,                       /* RR  */
  YYSYMBOL_RS = 363,                       /* RS  */
  YYSYMBOL_CLIENT = 364,                   /* CLIENT  */
  YYSYMBOL_CLUSTER = 365,                  /* CLUSTER  */
  YYSYMBOL_AS4 = 366,                      /* AS4  */
  YYSYMBOL_ADVERTISE = 367,                /* ADVERTISE  */
  YYSYMBOL_CAPABILITIES = 368,             /* CAPABILITIES  */
  YYSYMBOL_OLDER = 369,                    /* OLDER  */
  YYSYMBOL_MISSING = 370,                  /* MISSING  */
  YYSYMBOL_LLADDR = 371,                   /* LLADDR  */
  YYSYMBOL_DROP = 372,                     /* DROP  */
  YYSYMBOL_IGNORE = 373,                   /* IGNORE  */
  YYSYMBOL_ENHANCED = 374,                 /* ENHANCED  */
  YYSYMBOL_INTERPRET = 375,                /* INTERPRET  */
  YYSYMBOL_COMMUNITIES = 376,              /* COMMUNITIES  */
  YYSYMBOL_IGP = 377,                      /* IGP  */
  YYSYMBOL_GATEWAY = 378,                  /* GATEWAY  */
  YYSYMBOL_RECURSIVE = 379,                /* RECURSIVE  */
  YYSYMBOL_MED = 380,                      /* MED  */
  YYSYMBOL_TTL = 381,                      /* TTL  */
  YYSYMBOL_SECURITY = 382,                 /* SECURITY  */
  YYSYMBOL_DETERMINISTIC = 383,            /* DETERMINISTIC  */
  YYSYMBOL_SECONDARY = 384,                /* SECONDARY  */
  YYSYMBOL_ALLOW = 385,                    /* ALLOW  */
  YYSYMBOL_PATHS = 386,                    /* PATHS  */
  YYSYMBOL_AWARE = 387,                    /* AWARE  */
  YYSYMBOL_SETKEY = 388,                   /* SETKEY  */
  YYSYMBOL_CONFEDERATION = 389,            /* CONFEDERATION  */
  YYSYMBOL_MEMBER = 390,                   /* MEMBER  */
  YYSYMBOL_MULTICAST = 391,                /* MULTICAST  */
  YYSYMBOL_LIVED = 392,                    /* LIVED  */
  YYSYMBOL_STALE = 393,                    /* STALE  */
  YYSYMBOL_IBGP = 394,                     /* IBGP  */
  YYSYMBOL_EBGP = 395,                     /* EBGP  */
  YYSYMBOL_MANDATORY = 396,                /* MANDATORY  */
  YYSYMBOL_INTERNAL = 397,                 /* INTERNAL  */
  YYSYMBOL_EXTERNAL = 398,                 /* EXTERNAL  */
  YYSYMBOL_SETS = 399,                     /* SETS  */
  YYSYMBOL_NAME = 400,                     /* NAME  */
  YYSYMBOL_DIGITS = 401,                   /* DIGITS  */
  YYSYMBOL_AIGP = 402,                     /* AIGP  */
  YYSYMBOL_ORIGINATE = 403,                /* ORIGINATE  */
  YYSYMBOL_ENFORCE = 404,                  /* ENFORCE  */
  YYSYMBOL_FIRST = 405,                    /* FIRST  */
  YYSYMBOL_FREE = 406,                     /* FREE  */
  YYSYMBOL_VALIDATE = 407,                 /* VALIDATE  */
  YYSYMBOL_ROLE = 408,                     /* ROLE  */
  YYSYMBOL_ROLES = 409,                    /* ROLES  */
  YYSYMBOL_PROVIDER = 410,                 /* PROVIDER  */
  YYSYMBOL_CUSTOMER = 411,                 /* CUSTOMER  */
  YYSYMBOL_RS_SERVER = 412,                /* RS_SERVER  */
  YYSYMBOL_RS_CLIENT = 413,                /* RS_CLIENT  */
  YYSYMBOL_REQUIRE = 414,                  /* REQUIRE  */
  YYSYMBOL_BGP_OTC = 415,                  /* BGP_OTC  */
  YYSYMBOL_GLOBAL = 416,                   /* GLOBAL  */
  YYSYMBOL_RECV = 417,                     /* RECV  */
  YYSYMBOL_SIZE = 418,                     /* SIZE  */
  YYSYMBOL_WARNING = 419,                  /* WARNING  */
  YYSYMBOL_SINGLE = 420,                   /* SINGLE  */
  YYSYMBOL_DOUBLE = 421,                   /* DOUBLE  */
  YYSYMBOL_SECRET = 422,                   /* SECRET  */
  YYSYMBOL_DEPRECATED = 423,               /* DEPRECATED  */
  YYSYMBOL_PREFERRED = 424,                /* PREFERRED  */
  YYSYMBOL_CMAC = 425,                     /* CMAC  */
  YYSYMBOL_AES128 = 426,                   /* AES128  */
  YYSYMBOL_BGP_ORIGIN = 427,               /* BGP_ORIGIN  */
  YYSYMBOL_CEASE = 428,                    /* CEASE  */
  YYSYMBOL_HIT = 429,                      /* HIT  */
  YYSYMBOL_ADMINISTRATIVE = 430,           /* ADMINISTRATIVE  */
  YYSYMBOL_SHUTDOWN = 431,                 /* SHUTDOWN  */
  YYSYMBOL_CONFIGURATION = 432,            /* CONFIGURATION  */
  YYSYMBOL_CHANGE = 433,                   /* CHANGE  */
  YYSYMBOL_DECONFIGURED = 434,             /* DECONFIGURED  */
  YYSYMBOL_CONNECTION = 435,               /* CONNECTION  */
  YYSYMBOL_REJECTED = 436,                 /* REJECTED  */
  YYSYMBOL_COLLISION = 437,                /* COLLISION  */
  YYSYMBOL_OF = 438,                       /* OF  */
  YYSYMBOL_ASPA_CHECK_UPSTREAM = 439,      /* ASPA_CHECK_UPSTREAM  */
  YYSYMBOL_ASPA_CHECK_DOWNSTREAM = 440,    /* ASPA_CHECK_DOWNSTREAM  */
  YYSYMBOL_BMP = 441,                      /* BMP  */
  YYSYMBOL_STATION = 442,                  /* STATION  */
  YYSYMBOL_SYSTEM = 443,                   /* SYSTEM  */
  YYSYMBOL_MONITORING = 444,               /* MONITORING  */
  YYSYMBOL_RIB = 445,                      /* RIB  */
  YYSYMBOL_PRE_POLICY = 446,               /* PRE_POLICY  */
  YYSYMBOL_POST_POLICY = 447,              /* POST_POLICY  */
  YYSYMBOL_L3VPN = 448,                    /* L3VPN  */
  YYSYMBOL_TARGET = 449,                   /* TARGET  */
  YYSYMBOL_DISTINGUISHER = 450,            /* DISTINGUISHER  */
  YYSYMBOL_MRT = 451,                      /* MRT  */
  YYSYMBOL_FILENAME = 452,                 /* FILENAME  */
  YYSYMBOL_ALWAYS = 453,                   /* ALWAYS  */
  YYSYMBOL_OSPF = 454,                     /* OSPF  */
  YYSYMBOL_V2 = 455,                       /* V2  */
  YYSYMBOL_V3 = 456,                       /* V3  */
  YYSYMBOL_AREA = 457,                     /* AREA  */
  YYSYMBOL_RFC1583COMPAT = 458,            /* RFC1583COMPAT  */
  YYSYMBOL_STUB = 459,                     /* STUB  */
  YYSYMBOL_TICK = 460,                     /* TICK  */
  YYSYMBOL_COST2 = 461,                    /* COST2  */
  YYSYMBOL_RETRANSMIT = 462,               /* RETRANSMIT  */
  YYSYMBOL_TRANSMIT = 463,                 /* TRANSMIT  */
  YYSYMBOL_DEAD = 464,                     /* DEAD  */
  YYSYMBOL_BROADCAST = 465,                /* BROADCAST  */
  YYSYMBOL_BCAST = 466,                    /* BCAST  */
  YYSYMBOL_NONBROADCAST = 467,             /* NONBROADCAST  */
  YYSYMBOL_NBMA = 468,                     /* NBMA  */
  YYSYMBOL_POINTOPOINT = 469,              /* POINTOPOINT  */
  YYSYMBOL_PTP = 470,                      /* PTP  */
  YYSYMBOL_POINTOMULTIPOINT = 471,         /* POINTOMULTIPOINT  */
  YYSYMBOL_PTMP = 472,                     /* PTMP  */
  YYSYMBOL_CRYPTOGRAPHIC = 473,            /* CRYPTOGRAPHIC  */
  YYSYMBOL_ELIGIBLE = 474,                 /* ELIGIBLE  */
  YYSYMBOL_POLL = 475,                     /* POLL  */
  YYSYMBOL_NETWORKS = 476,                 /* NETWORKS  */
  YYSYMBOL_HIDDEN = 477,                   /* HIDDEN  */
  YYSYMBOL_VIRTUAL = 478,                  /* VIRTUAL  */
  YYSYMBOL_ONLY = 479,                     /* ONLY  */
  YYSYMBOL_LARGE = 480,                    /* LARGE  */
  YYSYMBOL_NORMAL = 481,                   /* NORMAL  */
  YYSYMBOL_STUBNET = 482,                  /* STUBNET  */
  YYSYMBOL_TAG = 483,                      /* TAG  */
  YYSYMBOL_LSADB = 484,                    /* LSADB  */
  YYSYMBOL_ECMP = 485,                     /* ECMP  */
  YYSYMBOL_NSSA = 486,                     /* NSSA  */
  YYSYMBOL_TRANSLATOR = 487,               /* TRANSLATOR  */
  YYSYMBOL_STABILITY = 488,                /* STABILITY  */
  YYSYMBOL_LSID = 489,                     /* LSID  */
  YYSYMBOL_INSTANCE = 490,                 /* INSTANCE  */
  YYSYMBOL_REAL = 491,                     /* REAL  */
  YYSYMBOL_NETMASK = 492,                  /* NETMASK  */
  YYSYMBOL_LSA = 493,                      /* LSA  */
  YYSYMBOL_SUPPRESSION = 494,              /* SUPPRESSION  */
  YYSYMBOL_RFC5838 = 495,                  /* RFC5838  */
  YYSYMBOL_PE = 496,                       /* PE  */
  YYSYMBOL_TOPOLOGY = 497,                 /* TOPOLOGY  */
  YYSYMBOL_STATE = 498,                    /* STATE  */
  YYSYMBOL_GENERATION = 499,               /* GENERATION  */
  YYSYMBOL_RADV = 500,                     /* RADV  */
  YYSYMBOL_RA = 501,                       /* RA  */
  YYSYMBOL_SOLICITED = 502,                /* SOLICITED  */
  YYSYMBOL_UNICAST = 503,                  /* UNICAST  */
  YYSYMBOL_MANAGED = 504,                  /* MANAGED  */
  YYSYMBOL_OTHER = 505,                    /* OTHER  */
  YYSYMBOL_CONFIG = 506,                   /* CONFIG  */
  YYSYMBOL_LINGER = 507,                   /* LINGER  */
  YYSYMBOL_MTU = 508,                      /* MTU  */
  YYSYMBOL_REACHABLE = 509,                /* REACHABLE  */
  YYSYMBOL_RETRANS = 510,                  /* RETRANS  */
  YYSYMBOL_TIMER = 511,                    /* TIMER  */
  YYSYMBOL_CURRENT = 512,                  /* CURRENT  */
  YYSYMBOL_VALID = 513,                    /* VALID  */
  YYSYMBOL_MULT = 514,                     /* MULT  */
  YYSYMBOL_LIFETIME = 515,                 /* LIFETIME  */
  YYSYMBOL_SKIP = 516,                     /* SKIP  */
  YYSYMBOL_ONLINK = 517,                   /* ONLINK  */
  YYSYMBOL_AUTONOMOUS = 518,               /* AUTONOMOUS  */
  YYSYMBOL_RDNSS = 519,                    /* RDNSS  */
  YYSYMBOL_DNSSL = 520,                    /* DNSSL  */
  YYSYMBOL_NS = 521,                       /* NS  */
  YYSYMBOL_TRIGGER = 522,                  /* TRIGGER  */
  YYSYMBOL_SENSITIVE = 523,                /* SENSITIVE  */
  YYSYMBOL_LOW = 524,                      /* LOW  */
  YYSYMBOL_MEDIUM = 525,                   /* MEDIUM  */
  YYSYMBOL_HIGH = 526,                     /* HIGH  */
  YYSYMBOL_PROPAGATE = 527,                /* PROPAGATE  */
  YYSYMBOL_CUSTOM = 528,                   /* CUSTOM  */
  YYSYMBOL_OPTION = 529,                   /* OPTION  */
  YYSYMBOL_VALUE = 530,                    /* VALUE  */
  YYSYMBOL_RA_PREFERENCE = 531,            /* RA_PREFERENCE  */
  YYSYMBOL_RIP = 532,                      /* RIP  */
  YYSYMBOL_NG = 533,                       /* NG  */
  YYSYMBOL_INFINITY = 534,                 /* INFINITY  */
  YYSYMBOL_TIMEOUT = 535,                  /* TIMEOUT  */
  YYSYMBOL_GARBAGE = 536,                  /* GARBAGE  */
  YYSYMBOL_MODE = 537,                     /* MODE  */
  YYSYMBOL_VERSION = 538,                  /* VERSION  */
  YYSYMBOL_SPLIT = 539,                    /* SPLIT  */
  YYSYMBOL_HORIZON = 540,                  /* HORIZON  */
  YYSYMBOL_POISON = 541,                   /* POISON  */
  YYSYMBOL_REVERSE = 542,                  /* REVERSE  */
  YYSYMBOL_PLAINTEXT = 543,                /* PLAINTEXT  */
  YYSYMBOL_DEMAND = 544,                   /* DEMAND  */
  YYSYMBOL_CIRCUIT = 545,                  /* CIRCUIT  */
  YYSYMBOL_REMOTE = 546,                   /* REMOTE  */
  YYSYMBOL_BIRD = 547,                     /* BIRD  */
  YYSYMBOL_PRIVATE = 548,                  /* PRIVATE  */
  YYSYMBOL_PUBLIC = 549,                   /* PUBLIC  */
  YYSYMBOL_SSH = 550,                      /* SSH  */
  YYSYMBOL_TRANSPORT = 551,                /* TRANSPORT  */
  YYSYMBOL_USER = 552,                     /* USER  */
  YYSYMBOL_EXPIRE = 553,                   /* EXPIRE  */
  YYSYMBOL_PROHIBIT = 554,                 /* PROHIBIT  */
  YYSYMBOL_BLACKHOLE = 555,                /* BLACKHOLE  */
  YYSYMBOL_UNREACHABLE = 556,              /* UNREACHABLE  */
  YYSYMBOL_TRANSIT = 557,                  /* TRANSIT  */
  YYSYMBOL_PROVIDERS = 558,                /* PROVIDERS  */
  YYSYMBOL_KERNEL = 559,                   /* KERNEL  */
  YYSYMBOL_NETLINK = 560,                  /* NETLINK  */
  YYSYMBOL_KRT_LOCK_MTU = 561,             /* KRT_LOCK_MTU  */
  YYSYMBOL_KRT_LOCK_WINDOW = 562,          /* KRT_LOCK_WINDOW  */
  YYSYMBOL_KRT_LOCK_RTT = 563,             /* KRT_LOCK_RTT  */
  YYSYMBOL_KRT_LOCK_RTTVAR = 564,          /* KRT_LOCK_RTTVAR  */
  YYSYMBOL_KRT_LOCK_SSTHRESH = 565,        /* KRT_LOCK_SSTHRESH  */
  YYSYMBOL_KRT_LOCK_CWND = 566,            /* KRT_LOCK_CWND  */
  YYSYMBOL_KRT_LOCK_ADVMSS = 567,          /* KRT_LOCK_ADVMSS  */
  YYSYMBOL_KRT_LOCK_REORDERING = 568,      /* KRT_LOCK_REORDERING  */
  YYSYMBOL_KRT_LOCK_HOPLIMIT = 569,        /* KRT_LOCK_HOPLIMIT  */
  YYSYMBOL_KRT_LOCK_INITCWND = 570,        /* KRT_LOCK_INITCWND  */
  YYSYMBOL_KRT_LOCK_RTO_MIN = 571,         /* KRT_LOCK_RTO_MIN  */
  YYSYMBOL_KRT_LOCK_INITRWND = 572,        /* KRT_LOCK_INITRWND  */
  YYSYMBOL_KRT_LOCK_QUICKACK = 573,        /* KRT_LOCK_QUICKACK  */
  YYSYMBOL_KRT_LOCK_CONGCTL = 574,         /* KRT_LOCK_CONGCTL  */
  YYSYMBOL_KRT_LOCK_FASTOPEN_NO_COOKIE = 575, /* KRT_LOCK_FASTOPEN_NO_COOKIE  */
  YYSYMBOL_KRT_FEATURE_ECN = 576,          /* KRT_FEATURE_ECN  */
  YYSYMBOL_KRT_FEATURE_ALLFRAG = 577,      /* KRT_FEATURE_ALLFRAG  */
  YYSYMBOL_SYSLOG = 578,                   /* SYSLOG  */
  YYSYMBOL_TRACE = 579,                    /* TRACE  */
  YYSYMBOL_INFO = 580,                     /* INFO  */
  YYSYMBOL_AUTH = 581,                     /* AUTH  */
  YYSYMBOL_FATAL = 582,                    /* FATAL  */
  YYSYMBOL_BUG = 583,                      /* BUG  */
  YYSYMBOL_STDERR = 584,                   /* STDERR  */
  YYSYMBOL_SOFT = 585,                     /* SOFT  */
  YYSYMBOL_UDP = 586,                      /* UDP  */
  YYSYMBOL_CLI = 587,                      /* CLI  */
  YYSYMBOL_CONFIRM = 588,                  /* CONFIRM  */
  YYSYMBOL_UNDO = 589,                     /* UNDO  */
  YYSYMBOL_LATENCY = 590,                  /* LATENCY  */
  YYSYMBOL_WATCHDOG = 591,                 /* WATCHDOG  */
  YYSYMBOL_PING = 592,                     /* PING  */
  YYSYMBOL_WAKEUP = 593,                   /* WAKEUP  */
  YYSYMBOL_SCHEDULING = 594,               /* SCHEDULING  */
  YYSYMBOL_TIMERS = 595,                   /* TIMERS  */
  YYSYMBOL_ALLOCATOR = 596,                /* ALLOCATOR  */
  YYSYMBOL_FIXED = 597,                    /* FIXED  */
  YYSYMBOL_THREAD = 598,                   /* THREAD  */
  YYSYMBOL_THREADS = 599,                  /* THREADS  */
  YYSYMBOL_GROUP = 600,                    /* GROUP  */
  YYSYMBOL_CONFIGURE = 601,                /* CONFIGURE  */
  YYSYMBOL_DOWN = 602,                     /* DOWN  */
  YYSYMBOL_PERSIST = 603,                  /* PERSIST  */
  YYSYMBOL_SCAN = 604,                     /* SCAN  */
  YYSYMBOL_LEARN = 605,                    /* LEARN  */
  YYSYMBOL_DEVICE = 606,                   /* DEVICE  */
  YYSYMBOL_YYACCEPT = 607,                 /* $accept  */
  YYSYMBOL_cli_cmd = 608,                  /* cli_cmd  */
  YYSYMBOL_cmd_QUIT = 609,                 /* cmd_QUIT  */
  YYSYMBOL_cmd_EXIT = 610,                 /* cmd_EXIT  */
  YYSYMBOL_cmd_HELP = 611,                 /* cmd_HELP  */
  YYSYMBOL_config = 612,                   /* config  */
  YYSYMBOL_conf_entries = 613,             /* conf_entries  */
  YYSYMBOL_conf = 614,                     /* conf  */
  YYSYMBOL_definition = 615,               /* definition  */
  YYSYMBOL_expr = 616,                     /* expr  */
  YYSYMBOL_expr_us = 617,                  /* expr_us  */
  YYSYMBOL_symbol = 618,                   /* symbol  */
  YYSYMBOL_bool = 619,                     /* bool  */
  YYSYMBOL_ipa = 620,                      /* ipa  */
  YYSYMBOL_ipa_scope = 621,                /* ipa_scope  */
  YYSYMBOL_pxlen4 = 622,                   /* pxlen4  */
  YYSYMBOL_net_ip4_ = 623,                 /* net_ip4_  */
  YYSYMBOL_net_ip6_slash = 624,            /* net_ip6_slash  */
  YYSYMBOL_net_ip6_ = 625,                 /* net_ip6_  */
  YYSYMBOL_net_ip6_sadr_ = 626,            /* net_ip6_sadr_  */
  YYSYMBOL_net_vpn4_ = 627,                /* net_vpn4_  */
  YYSYMBOL_net_vpn6_ = 628,                /* net_vpn6_  */
  YYSYMBOL_net_roa4_ = 629,                /* net_roa4_  */
  YYSYMBOL_net_roa6_ = 630,                /* net_roa6_  */
  YYSYMBOL_net_mpls_ = 631,                /* net_mpls_  */
  YYSYMBOL_net_aspa_ = 632,                /* net_aspa_  */
  YYSYMBOL_net_ip_ = 633,                  /* net_ip_  */
  YYSYMBOL_net_vpn_ = 634,                 /* net_vpn_  */
  YYSYMBOL_net_roa_ = 635,                 /* net_roa_  */
  YYSYMBOL_net_ = 636,                     /* net_  */
  YYSYMBOL_net_ip4 = 637,                  /* net_ip4  */
  YYSYMBOL_net_ip6 = 638,                  /* net_ip6  */
  YYSYMBOL_net_ip = 639,                   /* net_ip  */
  YYSYMBOL_net_any = 640,                  /* net_any  */
  YYSYMBOL_net_or_ipa = 641,               /* net_or_ipa  */
  YYSYMBOL_label_stack_start = 642,        /* label_stack_start  */
  YYSYMBOL_label_stack = 643,              /* label_stack  */
  YYSYMBOL_time = 644,                     /* time  */
  YYSYMBOL_settle = 645,                   /* settle  */
  YYSYMBOL_text = 646,                     /* text  */
  YYSYMBOL_opttext = 647,                  /* opttext  */
  YYSYMBOL_text_or_ipa = 648,              /* text_or_ipa  */
  YYSYMBOL_bytestring = 649,               /* bytestring  */
  YYSYMBOL_bytestring_text = 650,          /* bytestring_text  */
  YYSYMBOL_bytestring_expr = 651,          /* bytestring_expr  */
  YYSYMBOL_flow_num_op = 652,              /* flow_num_op  */
  YYSYMBOL_flow_logic_op = 653,            /* flow_logic_op  */
  YYSYMBOL_flow_num_type_ = 654,           /* flow_num_type_  */
  YYSYMBOL_flow_num_type = 655,            /* flow_num_type  */
  YYSYMBOL_flow_flag_type = 656,           /* flow_flag_type  */
  YYSYMBOL_flow_frag_type = 657,           /* flow_frag_type  */
  YYSYMBOL_flow_srcdst = 658,              /* flow_srcdst  */
  YYSYMBOL_flow_num_opts = 659,            /* flow_num_opts  */
  YYSYMBOL_flow_num_opt_ext_expr = 660,    /* flow_num_opt_ext_expr  */
  YYSYMBOL_flow_num_opt_ext = 661,         /* flow_num_opt_ext  */
  YYSYMBOL_flow_bmk_opts = 662,            /* flow_bmk_opts  */
  YYSYMBOL_flow_neg = 663,                 /* flow_neg  */
  YYSYMBOL_flow_frag_val = 664,            /* flow_frag_val  */
  YYSYMBOL_flow_frag_opts = 665,           /* flow_frag_opts  */
  YYSYMBOL_flow4_item = 666,               /* flow4_item  */
  YYSYMBOL_flow6_item = 667,               /* flow6_item  */
  YYSYMBOL_flow4_opts = 668,               /* flow4_opts  */
  YYSYMBOL_flow6_opts = 669,               /* flow6_opts  */
  YYSYMBOL_flow_builder_init = 670,        /* flow_builder_init  */
  YYSYMBOL_flow_builder_set_ipv4 = 671,    /* flow_builder_set_ipv4  */
  YYSYMBOL_flow_builder_set_ipv6 = 672,    /* flow_builder_set_ipv6  */
  YYSYMBOL_net_flow4_ = 673,               /* net_flow4_  */
  YYSYMBOL_net_flow6_ = 674,               /* net_flow6_  */
  YYSYMBOL_net_flow_ = 675,                /* net_flow_  */
  YYSYMBOL_enum_type = 676,                /* enum_type  */
  YYSYMBOL_filter_def = 677,               /* filter_def  */
  YYSYMBOL_678_1 = 678,                    /* $@1  */
  YYSYMBOL_filter_eval = 679,              /* filter_eval  */
  YYSYMBOL_custom_attr = 680,              /* custom_attr  */
  YYSYMBOL_bt_test_suite = 681,            /* bt_test_suite  */
  YYSYMBOL_bt_test_same = 682,             /* bt_test_same  */
  YYSYMBOL_type = 683,                     /* type  */
  YYSYMBOL_684_2 = 684,                    /* @2  */
  YYSYMBOL_function_argsn = 685,           /* function_argsn  */
  YYSYMBOL_function_args = 686,            /* function_args  */
  YYSYMBOL_function_vars = 687,            /* function_vars  */
  YYSYMBOL_function_type = 688,            /* function_type  */
  YYSYMBOL_filter_body = 689,              /* filter_body  */
  YYSYMBOL_filter = 690,                   /* filter  */
  YYSYMBOL_691_3 = 691,                    /* $@3  */
  YYSYMBOL_where_filter = 692,             /* where_filter  */
  YYSYMBOL_693_4 = 693,                    /* $@4  */
  YYSYMBOL_function_body = 694,            /* function_body  */
  YYSYMBOL_function_def = 695,             /* function_def  */
  YYSYMBOL_696_5 = 696,                    /* $@5  */
  YYSYMBOL_697_6 = 697,                    /* $@6  */
  YYSYMBOL_cmds = 698,                     /* cmds  */
  YYSYMBOL_cmd_var = 699,                  /* cmd_var  */
  YYSYMBOL_cmd_prep = 700,                 /* cmd_prep  */
  YYSYMBOL_cmds_int = 701,                 /* cmds_int  */
  YYSYMBOL_fipa = 702,                     /* fipa  */
  YYSYMBOL_set_atom0 = 703,                /* set_atom0  */
  YYSYMBOL_set_atom = 704,                 /* set_atom  */
  YYSYMBOL_switch_atom = 705,              /* switch_atom  */
  YYSYMBOL_cnum = 706,                     /* cnum  */
  YYSYMBOL_pair_item = 707,                /* pair_item  */
  YYSYMBOL_ec_kind = 708,                  /* ec_kind  */
  YYSYMBOL_ec_item = 709,                  /* ec_item  */
  YYSYMBOL_lc_item = 710,                  /* lc_item  */
  YYSYMBOL_set_item = 711,                 /* set_item  */
  YYSYMBOL_switch_item = 712,              /* switch_item  */
  YYSYMBOL_ec_items = 713,                 /* ec_items  */
  YYSYMBOL_set_items = 714,                /* set_items  */
  YYSYMBOL_switch_items = 715,             /* switch_items  */
  YYSYMBOL_fprefix = 716,                  /* fprefix  */
  YYSYMBOL_fprefix_set = 717,              /* fprefix_set  */
  YYSYMBOL_switch_body = 718,              /* switch_body  */
  YYSYMBOL_bgp_path_expr = 719,            /* bgp_path_expr  */
  YYSYMBOL_bgp_path = 720,                 /* bgp_path  */
  YYSYMBOL_bgp_path_tail = 721,            /* bgp_path_tail  */
  YYSYMBOL_constant = 722,                 /* constant  */
  YYSYMBOL_constructor = 723,              /* constructor  */
  YYSYMBOL_var_list_r = 724,               /* var_list_r  */
  YYSYMBOL_var_list = 725,                 /* var_list  */
  YYSYMBOL_function_call = 726,            /* function_call  */
  YYSYMBOL_static_attr = 727,              /* static_attr  */
  YYSYMBOL_term_dot_method = 728,          /* term_dot_method  */
  YYSYMBOL_729_7 = 729,                    /* $@7  */
  YYSYMBOL_method_name_cont = 730,         /* method_name_cont  */
  YYSYMBOL_731_8 = 731,                    /* $@8  */
  YYSYMBOL_term = 732,                     /* term  */
  YYSYMBOL_term_bs = 733,                  /* term_bs  */
  YYSYMBOL_break_command = 734,            /* break_command  */
  YYSYMBOL_var = 735,                      /* var  */
  YYSYMBOL_for_var = 736,                  /* for_var  */
  YYSYMBOL_cmd = 737,                      /* cmd  */
  YYSYMBOL_738_9 = 738,                    /* $@9  */
  YYSYMBOL_739_10 = 739,                   /* $@10  */
  YYSYMBOL_740_11 = 740,                   /* $@11  */
  YYSYMBOL_741_12 = 741,                   /* $@12  */
  YYSYMBOL_742_13 = 742,                   /* $@13  */
  YYSYMBOL_743_14 = 743,                   /* $@14  */
  YYSYMBOL_get_cf_position = 744,          /* get_cf_position  */
  YYSYMBOL_lvalue = 745,                   /* lvalue  */
  YYSYMBOL_rtrid = 746,                    /* rtrid  */
  YYSYMBOL_idval = 747,                    /* idval  */
  YYSYMBOL_hostname_override = 748,        /* hostname_override  */
  YYSYMBOL_gr_opts = 749,                  /* gr_opts  */
  YYSYMBOL_net_type_base = 750,            /* net_type_base  */
  YYSYMBOL_net_type = 751,                 /* net_type  */
  YYSYMBOL_table = 752,                    /* table  */
  YYSYMBOL_table_start = 753,              /* table_start  */
  YYSYMBOL_table_sorted = 754,             /* table_sorted  */
  YYSYMBOL_table_opt = 755,                /* table_opt  */
  YYSYMBOL_table_opts = 756,               /* table_opts  */
  YYSYMBOL_table_opt_list = 757,           /* table_opt_list  */
  YYSYMBOL_proto_start = 758,              /* proto_start  */
  YYSYMBOL_proto_name = 759,               /* proto_name  */
  YYSYMBOL_proto_item = 760,               /* proto_item  */
  YYSYMBOL_channel_start = 761,            /* channel_start  */
  YYSYMBOL_channel_item_ = 762,            /* channel_item_  */
  YYSYMBOL_channel_item = 763,             /* channel_item  */
  YYSYMBOL_channel_opts = 764,             /* channel_opts  */
  YYSYMBOL_channel_opt_list = 765,         /* channel_opt_list  */
  YYSYMBOL_channel_end = 766,              /* channel_end  */
  YYSYMBOL_proto_channel = 767,            /* proto_channel  */
  YYSYMBOL_rtable = 768,                   /* rtable  */
  YYSYMBOL_imexport = 769,                 /* imexport  */
  YYSYMBOL_limit_action = 770,             /* limit_action  */
  YYSYMBOL_limit_spec = 771,               /* limit_spec  */
  YYSYMBOL_debug_default = 772,            /* debug_default  */
  YYSYMBOL_timeformat_base = 773,          /* timeformat_base  */
  YYSYMBOL_timeformat_which = 774,         /* timeformat_which  */
  YYSYMBOL_timeformat_spec = 775,          /* timeformat_spec  */
  YYSYMBOL_iface_patt_node_init = 776,     /* iface_patt_node_init  */
  YYSYMBOL_iface_patt_node_body = 777,     /* iface_patt_node_body  */
  YYSYMBOL_iface_negate = 778,             /* iface_negate  */
  YYSYMBOL_iface_patt_node = 779,          /* iface_patt_node  */
  YYSYMBOL_iface_patt_list = 780,          /* iface_patt_list  */
  YYSYMBOL_iface_patt_list_nopx = 781,     /* iface_patt_list_nopx  */
  YYSYMBOL_iface_patt_init = 782,          /* iface_patt_init  */
  YYSYMBOL_iface_patt = 783,               /* iface_patt  */
  YYSYMBOL_tos = 784,                      /* tos  */
  YYSYMBOL_proto = 785,                    /* proto  */
  YYSYMBOL_dev_proto_start = 786,          /* dev_proto_start  */
  YYSYMBOL_dev_proto = 787,                /* dev_proto  */
  YYSYMBOL_dev_iface_init = 788,           /* dev_iface_init  */
  YYSYMBOL_dev_iface_patt = 789,           /* dev_iface_patt  */
  YYSYMBOL_debug_mask = 790,               /* debug_mask  */
  YYSYMBOL_debug_list = 791,               /* debug_list  */
  YYSYMBOL_debug_flag = 792,               /* debug_flag  */
  YYSYMBOL_mrtdump_mask = 793,             /* mrtdump_mask  */
  YYSYMBOL_mrtdump_list = 794,             /* mrtdump_list  */
  YYSYMBOL_mrtdump_flag = 795,             /* mrtdump_flag  */
  YYSYMBOL_password_list = 796,            /* password_list  */
  YYSYMBOL_password_list_body = 797,       /* password_list_body  */
  YYSYMBOL_password_items = 798,           /* password_items  */
  YYSYMBOL_password_item = 799,            /* password_item  */
  YYSYMBOL_pass_key = 800,                 /* pass_key  */
  YYSYMBOL_password_item_begin = 801,      /* password_item_begin  */
  YYSYMBOL_password_item_params = 802,     /* password_item_params  */
  YYSYMBOL_password_algorithm = 803,       /* password_algorithm  */
  YYSYMBOL_password_item_end = 804,        /* password_item_end  */
  YYSYMBOL_bfd_opts = 805,                 /* bfd_opts  */
  YYSYMBOL_cmd_SHOW_STATUS = 806,          /* cmd_SHOW_STATUS  */
  YYSYMBOL_cmd_SHOW_MEMORY = 807,          /* cmd_SHOW_MEMORY  */
  YYSYMBOL_cmd_SHOW_PROTOCOLS = 808,       /* cmd_SHOW_PROTOCOLS  */
  YYSYMBOL_cmd_SHOW_PROTOCOLS_ALL = 809,   /* cmd_SHOW_PROTOCOLS_ALL  */
  YYSYMBOL_optproto = 810,                 /* optproto  */
  YYSYMBOL_cmd_SHOW_INTERFACES = 811,      /* cmd_SHOW_INTERFACES  */
  YYSYMBOL_cmd_SHOW_INTERFACES_SUMMARY = 812, /* cmd_SHOW_INTERFACES_SUMMARY  */
  YYSYMBOL_cmd_SHOW_ROUTE = 813,           /* cmd_SHOW_ROUTE  */
  YYSYMBOL_r_args = 814,                   /* r_args  */
  YYSYMBOL_r_args_for = 815,               /* r_args_for  */
  YYSYMBOL_r_args_for_val = 816,           /* r_args_for_val  */
  YYSYMBOL_export_mode = 817,              /* export_mode  */
  YYSYMBOL_channel_sym = 818,              /* channel_sym  */
  YYSYMBOL_channel_arg = 819,              /* channel_arg  */
  YYSYMBOL_cmd_SHOW_SYMBOLS = 820,         /* cmd_SHOW_SYMBOLS  */
  YYSYMBOL_sym_args = 821,                 /* sym_args  */
  YYSYMBOL_cmd_DUMP_RESOURCES = 822,       /* cmd_DUMP_RESOURCES  */
  YYSYMBOL_cmd_DUMP_SOCKETS = 823,         /* cmd_DUMP_SOCKETS  */
  YYSYMBOL_cmd_DUMP_AO_KEYS = 824,         /* cmd_DUMP_AO_KEYS  */
  YYSYMBOL_cmd_DUMP_EVENTS = 825,          /* cmd_DUMP_EVENTS  */
  YYSYMBOL_cmd_DUMP_INTERFACES = 826,      /* cmd_DUMP_INTERFACES  */
  YYSYMBOL_cmd_DUMP_NEIGHBORS = 827,       /* cmd_DUMP_NEIGHBORS  */
  YYSYMBOL_cmd_DUMP_ATTRIBUTES = 828,      /* cmd_DUMP_ATTRIBUTES  */
  YYSYMBOL_cmd_DUMP_ROUTES = 829,          /* cmd_DUMP_ROUTES  */
  YYSYMBOL_cmd_DUMP_TABLES = 830,          /* cmd_DUMP_TABLES  */
  YYSYMBOL_cmd_DUMP_PROTOCOLS = 831,       /* cmd_DUMP_PROTOCOLS  */
  YYSYMBOL_cmd_DUMP_FILTER_ALL = 832,      /* cmd_DUMP_FILTER_ALL  */
  YYSYMBOL_cmd_EVAL = 833,                 /* cmd_EVAL  */
  YYSYMBOL_partial_opt = 834,              /* partial_opt  */
  YYSYMBOL_cmd_DISABLE = 835,              /* cmd_DISABLE  */
  YYSYMBOL_cmd_ENABLE = 836,               /* cmd_ENABLE  */
  YYSYMBOL_cmd_RESTART = 837,              /* cmd_RESTART  */
  YYSYMBOL_cmd_RELOAD_FILTERS = 838,       /* cmd_RELOAD_FILTERS  */
  YYSYMBOL_cmd_RELOAD_FILTERS_IN = 839,    /* cmd_RELOAD_FILTERS_IN  */
  YYSYMBOL_cmd_RELOAD_FILTERS_OUT = 840,   /* cmd_RELOAD_FILTERS_OUT  */
  YYSYMBOL_cmd_DEBUG = 841,                /* cmd_DEBUG  */
  YYSYMBOL_debug_args = 842,               /* debug_args  */
  YYSYMBOL_cmd_MRTDUMP = 843,              /* cmd_MRTDUMP  */
  YYSYMBOL_cmd_RESTRICT = 844,             /* cmd_RESTRICT  */
  YYSYMBOL_cmd_TIMEFORMAT = 845,           /* cmd_TIMEFORMAT  */
  YYSYMBOL_proto_patt = 846,               /* proto_patt  */
  YYSYMBOL_proto_patt2 = 847,              /* proto_patt2  */
  YYSYMBOL_mpls_domain = 848,              /* mpls_domain  */
  YYSYMBOL_mpls_domain_start = 849,        /* mpls_domain_start  */
  YYSYMBOL_mpls_domain_opt = 850,          /* mpls_domain_opt  */
  YYSYMBOL_mpls_domain_opts = 851,         /* mpls_domain_opts  */
  YYSYMBOL_mpls_domain_opt_list = 852,     /* mpls_domain_opt_list  */
  YYSYMBOL_mpls_domain_end = 853,          /* mpls_domain_end  */
  YYSYMBOL_mpls_range = 854,               /* mpls_range  */
  YYSYMBOL_mpls_range_start = 855,         /* mpls_range_start  */
  YYSYMBOL_mpls_range_opt = 856,           /* mpls_range_opt  */
  YYSYMBOL_mpls_range_opts = 857,          /* mpls_range_opts  */
  YYSYMBOL_mpls_range_opt_list = 858,      /* mpls_range_opt_list  */
  YYSYMBOL_mpls_range_end = 859,           /* mpls_range_end  */
  YYSYMBOL_mpls_channel = 860,             /* mpls_channel  */
  YYSYMBOL_mpls_channel_start = 861,       /* mpls_channel_start  */
  YYSYMBOL_mpls_label_policy = 862,        /* mpls_label_policy  */
  YYSYMBOL_mpls_channel_opt = 863,         /* mpls_channel_opt  */
  YYSYMBOL_mpls_channel_opts = 864,        /* mpls_channel_opts  */
  YYSYMBOL_mpls_channel_opt_list = 865,    /* mpls_channel_opt_list  */
  YYSYMBOL_mpls_channel_end = 866,         /* mpls_channel_end  */
  YYSYMBOL_867_15 = 867,                   /* $@15  */
  YYSYMBOL_show_mpls_ranges_args = 868,    /* show_mpls_ranges_args  */
  YYSYMBOL_cmd_SHOW_MPLS_RANGES = 869,     /* cmd_SHOW_MPLS_RANGES  */
  YYSYMBOL_aggregator_proto_start = 870,   /* aggregator_proto_start  */
  YYSYMBOL_aggregator_proto_item = 871,    /* aggregator_proto_item  */
  YYSYMBOL_872_16 = 872,                   /* $@16  */
  YYSYMBOL_873_17 = 873,                   /* $@17  */
  YYSYMBOL_aggregator_proto_opts = 874,    /* aggregator_proto_opts  */
  YYSYMBOL_aggregator_proto = 875,         /* aggregator_proto  */
  YYSYMBOL_aggr_list = 876,                /* aggr_list  */
  YYSYMBOL_aggr_item = 877,                /* aggr_item  */
  YYSYMBOL_babel_proto_start = 878,        /* babel_proto_start  */
  YYSYMBOL_babel_proto_item = 879,         /* babel_proto_item  */
  YYSYMBOL_babel_proto_opts = 880,         /* babel_proto_opts  */
  YYSYMBOL_babel_proto = 881,              /* babel_proto  */
  YYSYMBOL_babel_iface_start = 882,        /* babel_iface_start  */
  YYSYMBOL_babel_iface_finish = 883,       /* babel_iface_finish  */
  YYSYMBOL_babel_iface_item = 884,         /* babel_iface_item  */
  YYSYMBOL_babel_iface_opts = 885,         /* babel_iface_opts  */
  YYSYMBOL_babel_iface_opt_list = 886,     /* babel_iface_opt_list  */
  YYSYMBOL_babel_iface = 887,              /* babel_iface  */
  YYSYMBOL_cmd_SHOW_BABEL_INTERFACES = 888, /* cmd_SHOW_BABEL_INTERFACES  */
  YYSYMBOL_cmd_SHOW_BABEL_NEIGHBORS = 889, /* cmd_SHOW_BABEL_NEIGHBORS  */
  YYSYMBOL_cmd_SHOW_BABEL_ENTRIES = 890,   /* cmd_SHOW_BABEL_ENTRIES  */
  YYSYMBOL_cmd_SHOW_BABEL_ROUTES = 891,    /* cmd_SHOW_BABEL_ROUTES  */
  YYSYMBOL_bfd_proto_start = 892,          /* bfd_proto_start  */
  YYSYMBOL_bfd_proto_item = 893,           /* bfd_proto_item  */
  YYSYMBOL_bfd_proto_opts = 894,           /* bfd_proto_opts  */
  YYSYMBOL_bfd_proto = 895,                /* bfd_proto  */
  YYSYMBOL_bfd_accept_item = 896,          /* bfd_accept_item  */
  YYSYMBOL_bfd_accept = 897,               /* bfd_accept  */
  YYSYMBOL_bfd_iface_start = 898,          /* bfd_iface_start  */
  YYSYMBOL_bfd_iface_finish = 899,         /* bfd_iface_finish  */
  YYSYMBOL_bfd_auth_type = 900,            /* bfd_auth_type  */
  YYSYMBOL_bfd_iface_opt_list = 901,       /* bfd_iface_opt_list  */
  YYSYMBOL_bfd_iface = 902,                /* bfd_iface  */
  YYSYMBOL_bfd_multihop = 903,             /* bfd_multihop  */
  YYSYMBOL_bfd_neigh_iface = 904,          /* bfd_neigh_iface  */
  YYSYMBOL_bfd_neigh_local = 905,          /* bfd_neigh_local  */
  YYSYMBOL_bfd_neigh_multihop = 906,       /* bfd_neigh_multihop  */
  YYSYMBOL_bfd_neighbor = 907,             /* bfd_neighbor  */
  YYSYMBOL_bfd_item = 908,                 /* bfd_item  */
  YYSYMBOL_bfd_items = 909,                /* bfd_items  */
  YYSYMBOL_bfd_opts_start = 910,           /* bfd_opts_start  */
  YYSYMBOL_bfd_opts_end = 911,             /* bfd_opts_end  */
  YYSYMBOL_cmd_SHOW_BFD_SESSIONS = 912,    /* cmd_SHOW_BFD_SESSIONS  */
  YYSYMBOL_bfd_show_sessions_args = 913,   /* bfd_show_sessions_args  */
  YYSYMBOL_bgp_proto_start = 914,          /* bgp_proto_start  */
  YYSYMBOL_bgp_loc_opts = 915,             /* bgp_loc_opts  */
  YYSYMBOL_bgp_nbr_opts = 916,             /* bgp_nbr_opts  */
  YYSYMBOL_bgp_cease_mask = 917,           /* bgp_cease_mask  */
  YYSYMBOL_bgp_cease_list = 918,           /* bgp_cease_list  */
  YYSYMBOL_bgp_cease_flag = 919,           /* bgp_cease_flag  */
  YYSYMBOL_bgp_auth_type = 920,            /* bgp_auth_type  */
  YYSYMBOL_bgp_role_name = 921,            /* bgp_role_name  */
  YYSYMBOL_bgp_proto = 922,                /* bgp_proto  */
  YYSYMBOL_923_18 = 923,                   /* $@18  */
  YYSYMBOL_924_19 = 924,                   /* $@19  */
  YYSYMBOL_bgp_afi = 925,                  /* bgp_afi  */
  YYSYMBOL_tcp_ao_key_start = 926,         /* tcp_ao_key_start  */
  YYSYMBOL_tcp_ao_key_opt = 927,           /* tcp_ao_key_opt  */
  YYSYMBOL_tcp_ao_algorithm = 928,         /* tcp_ao_algorithm  */
  YYSYMBOL_tcp_ao_key_opts = 929,          /* tcp_ao_key_opts  */
  YYSYMBOL_tcp_ao_key_end = 930,           /* tcp_ao_key_end  */
  YYSYMBOL_tcp_ao_key = 931,               /* tcp_ao_key  */
  YYSYMBOL_tcp_ao_keys = 932,              /* tcp_ao_keys  */
  YYSYMBOL_tcp_ao_key_list = 933,          /* tcp_ao_key_list  */
  YYSYMBOL_934_20 = 934,                   /* $@20  */
  YYSYMBOL_tcp_ao_end = 935,               /* tcp_ao_end  */
  YYSYMBOL_bgp_channel_start = 936,        /* bgp_channel_start  */
  YYSYMBOL_bgp_nh = 937,                   /* bgp_nh  */
  YYSYMBOL_bgp_llnh = 938,                 /* bgp_llnh  */
  YYSYMBOL_bgp_lladdr = 939,               /* bgp_lladdr  */
  YYSYMBOL_bgp_channel_item = 940,         /* bgp_channel_item  */
  YYSYMBOL_bgp_channel_opts = 941,         /* bgp_channel_opts  */
  YYSYMBOL_bgp_channel_opt_list = 942,     /* bgp_channel_opt_list  */
  YYSYMBOL_bgp_channel_end = 943,          /* bgp_channel_end  */
  YYSYMBOL_bgp_proto_channel = 944,        /* bgp_proto_channel  */
  YYSYMBOL_cmd_RELOAD_BGP = 945,           /* cmd_RELOAD_BGP  */
  YYSYMBOL_cmd_RELOAD_BGP_IN = 946,        /* cmd_RELOAD_BGP_IN  */
  YYSYMBOL_cmd_RELOAD_BGP_OUT = 947,       /* cmd_RELOAD_BGP_OUT  */
  YYSYMBOL_bmp_proto_start = 948,          /* bmp_proto_start  */
  YYSYMBOL_bmp_station_address = 949,      /* bmp_station_address  */
  YYSYMBOL_bmp_proto = 950,                /* bmp_proto  */
  YYSYMBOL_l3vpn_channel_start = 951,      /* l3vpn_channel_start  */
  YYSYMBOL_l3vpn_channel = 952,            /* l3vpn_channel  */
  YYSYMBOL_l3vpn_proto_start = 953,        /* l3vpn_proto_start  */
  YYSYMBOL_l3vpn_proto_item = 954,         /* l3vpn_proto_item  */
  YYSYMBOL_l3vpn_proto_opts = 955,         /* l3vpn_proto_opts  */
  YYSYMBOL_l3vpn_proto = 956,              /* l3vpn_proto  */
  YYSYMBOL_l3vpn_targets = 957,            /* l3vpn_targets  */
  YYSYMBOL_mrt_proto_start = 958,          /* mrt_proto_start  */
  YYSYMBOL_mrt_proto_item = 959,           /* mrt_proto_item  */
  YYSYMBOL_mrt_proto_opts = 960,           /* mrt_proto_opts  */
  YYSYMBOL_mrt_proto = 961,                /* mrt_proto  */
  YYSYMBOL_cmd_MRT_DUMP = 962,             /* cmd_MRT_DUMP  */
  YYSYMBOL_mrt_dump_args = 963,            /* mrt_dump_args  */
  YYSYMBOL_ospf_variant = 964,             /* ospf_variant  */
  YYSYMBOL_ospf_proto_start = 965,         /* ospf_proto_start  */
  YYSYMBOL_ospf_proto = 966,               /* ospf_proto  */
  YYSYMBOL_ospf_af_mc = 967,               /* ospf_af_mc  */
  YYSYMBOL_ospf_channel_start = 968,       /* ospf_channel_start  */
  YYSYMBOL_ospf_channel = 969,             /* ospf_channel  */
  YYSYMBOL_ospf_proto_item = 970,          /* ospf_proto_item  */
  YYSYMBOL_ospf_area_start = 971,          /* ospf_area_start  */
  YYSYMBOL_ospf_area = 972,                /* ospf_area  */
  YYSYMBOL_ospf_area_opts = 973,           /* ospf_area_opts  */
  YYSYMBOL_ospf_area_item = 974,           /* ospf_area_item  */
  YYSYMBOL_975_21 = 975,                   /* $@21  */
  YYSYMBOL_976_22 = 976,                   /* $@22  */
  YYSYMBOL_ospf_stubnet = 977,             /* ospf_stubnet  */
  YYSYMBOL_ospf_stubnet_start = 978,       /* ospf_stubnet_start  */
  YYSYMBOL_ospf_stubnet_opts = 979,        /* ospf_stubnet_opts  */
  YYSYMBOL_ospf_stubnet_item = 980,        /* ospf_stubnet_item  */
  YYSYMBOL_ospf_vlink = 981,               /* ospf_vlink  */
  YYSYMBOL_ospf_vlink_opts = 982,          /* ospf_vlink_opts  */
  YYSYMBOL_ospf_vlink_item = 983,          /* ospf_vlink_item  */
  YYSYMBOL_ospf_vlink_start = 984,         /* ospf_vlink_start  */
  YYSYMBOL_ospf_iface_item = 985,          /* ospf_iface_item  */
  YYSYMBOL_pref_list = 986,                /* pref_list  */
  YYSYMBOL_pref_item = 987,                /* pref_item  */
  YYSYMBOL_pref_base = 988,                /* pref_base  */
  YYSYMBOL_pref_opt = 989,                 /* pref_opt  */
  YYSYMBOL_nbma_list = 990,                /* nbma_list  */
  YYSYMBOL_nbma_eligible = 991,            /* nbma_eligible  */
  YYSYMBOL_nbma_item = 992,                /* nbma_item  */
  YYSYMBOL_ospf_iface_start = 993,         /* ospf_iface_start  */
  YYSYMBOL_ospf_instance_id = 994,         /* ospf_instance_id  */
  YYSYMBOL_ospf_iface_patt_list = 995,     /* ospf_iface_patt_list  */
  YYSYMBOL_996_23 = 996,                   /* $@23  */
  YYSYMBOL_ospf_iface_opts = 997,          /* ospf_iface_opts  */
  YYSYMBOL_ospf_iface_opt_list = 998,      /* ospf_iface_opt_list  */
  YYSYMBOL_ospf_iface = 999,               /* ospf_iface  */
  YYSYMBOL_cmd_SHOW_OSPF = 1000,           /* cmd_SHOW_OSPF  */
  YYSYMBOL_cmd_SHOW_OSPF_NEIGHBORS = 1001, /* cmd_SHOW_OSPF_NEIGHBORS  */
  YYSYMBOL_cmd_SHOW_OSPF_INTERFACE = 1002, /* cmd_SHOW_OSPF_INTERFACE  */
  YYSYMBOL_cmd_SHOW_OSPF_TOPOLOGY = 1003,  /* cmd_SHOW_OSPF_TOPOLOGY  */
  YYSYMBOL_cmd_SHOW_OSPF_TOPOLOGY_ALL = 1004, /* cmd_SHOW_OSPF_TOPOLOGY_ALL  */
  YYSYMBOL_cmd_SHOW_OSPF_STATE = 1005,     /* cmd_SHOW_OSPF_STATE  */
  YYSYMBOL_cmd_SHOW_OSPF_STATE_ALL = 1006, /* cmd_SHOW_OSPF_STATE_ALL  */
  YYSYMBOL_cmd_SHOW_OSPF_LSADB = 1007,     /* cmd_SHOW_OSPF_LSADB  */
  YYSYMBOL_lsadb_args = 1008,              /* lsadb_args  */
  YYSYMBOL_pipe_proto_start = 1009,        /* pipe_proto_start  */
  YYSYMBOL_1010_24 = 1010,                 /* $@24  */
  YYSYMBOL_pipe_proto = 1011,              /* pipe_proto  */
  YYSYMBOL_radv_proto_start = 1012,        /* radv_proto_start  */
  YYSYMBOL_radv_proto_item = 1013,         /* radv_proto_item  */
  YYSYMBOL_1014_25 = 1014,                 /* $@25  */
  YYSYMBOL_1015_26 = 1015,                 /* $@26  */
  YYSYMBOL_radv_proto_opts = 1016,         /* radv_proto_opts  */
  YYSYMBOL_radv_proto = 1017,              /* radv_proto  */
  YYSYMBOL_radv_iface_start = 1018,        /* radv_iface_start  */
  YYSYMBOL_radv_iface_item = 1019,         /* radv_iface_item  */
  YYSYMBOL_1020_27 = 1020,                 /* $@27  */
  YYSYMBOL_1021_28 = 1021,                 /* $@28  */
  YYSYMBOL_radv_preference = 1022,         /* radv_preference  */
  YYSYMBOL_radv_iface_finish = 1023,       /* radv_iface_finish  */
  YYSYMBOL_radv_iface_opts = 1024,         /* radv_iface_opts  */
  YYSYMBOL_radv_iface_opt_list = 1025,     /* radv_iface_opt_list  */
  YYSYMBOL_radv_iface = 1026,              /* radv_iface  */
  YYSYMBOL_radv_prefix_start = 1027,       /* radv_prefix_start  */
  YYSYMBOL_radv_prefix_item = 1028,        /* radv_prefix_item  */
  YYSYMBOL_radv_prefix_finish = 1029,      /* radv_prefix_finish  */
  YYSYMBOL_radv_prefix_opts = 1030,        /* radv_prefix_opts  */
  YYSYMBOL_radv_prefix_opt_list = 1031,    /* radv_prefix_opt_list  */
  YYSYMBOL_radv_prefix = 1032,             /* radv_prefix  */
  YYSYMBOL_radv_rdnss_node = 1033,         /* radv_rdnss_node  */
  YYSYMBOL_radv_rdnss_start = 1034,        /* radv_rdnss_start  */
  YYSYMBOL_radv_rdnss_item = 1035,         /* radv_rdnss_item  */
  YYSYMBOL_radv_rdnss_finish = 1036,       /* radv_rdnss_finish  */
  YYSYMBOL_radv_rdnss_opts = 1037,         /* radv_rdnss_opts  */
  YYSYMBOL_radv_rdnss = 1038,              /* radv_rdnss  */
  YYSYMBOL_radv_dnssl_node = 1039,         /* radv_dnssl_node  */
  YYSYMBOL_radv_dnssl_start = 1040,        /* radv_dnssl_start  */
  YYSYMBOL_radv_dnssl_item = 1041,         /* radv_dnssl_item  */
  YYSYMBOL_radv_dnssl_finish = 1042,       /* radv_dnssl_finish  */
  YYSYMBOL_radv_dnssl_opts = 1043,         /* radv_dnssl_opts  */
  YYSYMBOL_radv_dnssl = 1044,              /* radv_dnssl  */
  YYSYMBOL_radv_mult = 1045,               /* radv_mult  */
  YYSYMBOL_radv_sensitive = 1046,          /* radv_sensitive  */
  YYSYMBOL_rip_variant = 1047,             /* rip_variant  */
  YYSYMBOL_rip_proto_start = 1048,         /* rip_proto_start  */
  YYSYMBOL_rip_proto_item = 1049,          /* rip_proto_item  */
  YYSYMBOL_rip_proto_opts = 1050,          /* rip_proto_opts  */
  YYSYMBOL_rip_proto = 1051,               /* rip_proto  */
  YYSYMBOL_rip_iface_start = 1052,         /* rip_iface_start  */
  YYSYMBOL_rip_iface_finish = 1053,        /* rip_iface_finish  */
  YYSYMBOL_rip_iface_item = 1054,          /* rip_iface_item  */
  YYSYMBOL_rip_auth = 1055,                /* rip_auth  */
  YYSYMBOL_rip_iface_opts = 1056,          /* rip_iface_opts  */
  YYSYMBOL_rip_iface_opt_list = 1057,      /* rip_iface_opt_list  */
  YYSYMBOL_rip_iface = 1058,               /* rip_iface  */
  YYSYMBOL_cmd_SHOW_RIP_INTERFACES = 1059, /* cmd_SHOW_RIP_INTERFACES  */
  YYSYMBOL_cmd_SHOW_RIP_NEIGHBORS = 1060,  /* cmd_SHOW_RIP_NEIGHBORS  */
  YYSYMBOL_rpki_proto_start = 1061,        /* rpki_proto_start  */
  YYSYMBOL_rpki_proto = 1062,              /* rpki_proto  */
  YYSYMBOL_rpki_proto_opts = 1063,         /* rpki_proto_opts  */
  YYSYMBOL_rpki_proto_item = 1064,         /* rpki_proto_item  */
  YYSYMBOL_rpki_keep_interval = 1065,      /* rpki_keep_interval  */
  YYSYMBOL_rpki_proto_item_port = 1066,    /* rpki_proto_item_port  */
  YYSYMBOL_rpki_cache_addr = 1067,         /* rpki_cache_addr  */
  YYSYMBOL_rpki_transport = 1068,          /* rpki_transport  */
  YYSYMBOL_rpki_transport_tcp_init = 1069, /* rpki_transport_tcp_init  */
  YYSYMBOL_rpki_transport_tcp_opts_list = 1070, /* rpki_transport_tcp_opts_list  */
  YYSYMBOL_rpki_transport_tcp_opts = 1071, /* rpki_transport_tcp_opts  */
  YYSYMBOL_rpki_transport_tcp_item = 1072, /* rpki_transport_tcp_item  */
  YYSYMBOL_rpki_transport_tcp_check = 1073, /* rpki_transport_tcp_check  */
  YYSYMBOL_rpki_transport_ssh_init = 1074, /* rpki_transport_ssh_init  */
  YYSYMBOL_rpki_transport_ssh_opts = 1075, /* rpki_transport_ssh_opts  */
  YYSYMBOL_rpki_transport_ssh_item = 1076, /* rpki_transport_ssh_item  */
  YYSYMBOL_rpki_transport_ssh_check = 1077, /* rpki_transport_ssh_check  */
  YYSYMBOL_static_proto_start = 1078,      /* static_proto_start  */
  YYSYMBOL_static_proto = 1079,            /* static_proto  */
  YYSYMBOL_stat_nexthop = 1080,            /* stat_nexthop  */
  YYSYMBOL_stat_nexthops = 1081,           /* stat_nexthops  */
  YYSYMBOL_stat_mpls = 1082,               /* stat_mpls  */
  YYSYMBOL_stat_route0 = 1083,             /* stat_route0  */
  YYSYMBOL_1084_29 = 1084,                 /* $@29  */
  YYSYMBOL_stat_route = 1085,              /* stat_route  */
  YYSYMBOL_1086_30 = 1086,                 /* $@30  */
  YYSYMBOL_stat_aspa_provider = 1087,      /* stat_aspa_provider  */
  YYSYMBOL_stat_aspa_providers = 1088,     /* stat_aspa_providers  */
  YYSYMBOL_stat_route_item = 1089,         /* stat_route_item  */
  YYSYMBOL_stat_route_opts = 1090,         /* stat_route_opts  */
  YYSYMBOL_stat_route_opt_list = 1091,     /* stat_route_opt_list  */
  YYSYMBOL_1092_31 = 1092,                 /* $@31  */
  YYSYMBOL_cmd_SHOW_STATIC = 1093,         /* cmd_SHOW_STATIC  */
  YYSYMBOL_kern_proto = 1094,              /* kern_proto  */
  YYSYMBOL_kern_sys_item = 1095,           /* kern_sys_item  */
  YYSYMBOL_attr_bit = 1096,                /* attr_bit  */
  YYSYMBOL_log_begin = 1097,               /* log_begin  */
  YYSYMBOL_log_config = 1098,              /* log_config  */
  YYSYMBOL_syslog_name = 1099,             /* syslog_name  */
  YYSYMBOL_log_limit = 1100,               /* log_limit  */
  YYSYMBOL_log_file = 1101,                /* log_file  */
  YYSYMBOL_log_udp_host = 1102,            /* log_udp_host  */
  YYSYMBOL_log_udp_port = 1103,            /* log_udp_port  */
  YYSYMBOL_log_mask = 1104,                /* log_mask  */
  YYSYMBOL_log_mask_list = 1105,           /* log_mask_list  */
  YYSYMBOL_log_cat = 1106,                 /* log_cat  */
  YYSYMBOL_mrtdump_base = 1107,            /* mrtdump_base  */
  YYSYMBOL_cli = 1108,                     /* cli  */
  YYSYMBOL_cli_opts = 1109,                /* cli_opts  */
  YYSYMBOL_cli_opts_begin = 1110,          /* cli_opts_begin  */
  YYSYMBOL_cli_opts_block = 1111,          /* cli_opts_block  */
  YYSYMBOL_1112_32 = 1112,                 /* $@32  */
  YYSYMBOL_thread_group_opts = 1113,       /* thread_group_opts  */
  YYSYMBOL_debug_unix = 1114,              /* debug_unix  */
  YYSYMBOL_latency_debug_mask = 1115,      /* latency_debug_mask  */
  YYSYMBOL_latency_debug_list = 1116,      /* latency_debug_list  */
  YYSYMBOL_latency_debug_flag = 1117,      /* latency_debug_flag  */
  YYSYMBOL_cmd_CONFIGURE = 1118,           /* cmd_CONFIGURE  */
  YYSYMBOL_cmd_CONFIGURE_SOFT = 1119,      /* cmd_CONFIGURE_SOFT  */
  YYSYMBOL_cmd_CONFIGURE_CONFIRM = 1120,   /* cmd_CONFIGURE_CONFIRM  */
  YYSYMBOL_cmd_CONFIGURE_UNDO = 1121,      /* cmd_CONFIGURE_UNDO  */
  YYSYMBOL_cmd_CONFIGURE_STATUS = 1122,    /* cmd_CONFIGURE_STATUS  */
  YYSYMBOL_cmd_CONFIGURE_CHECK = 1123,     /* cmd_CONFIGURE_CHECK  */
  YYSYMBOL_cmd_DOWN = 1124,                /* cmd_DOWN  */
  YYSYMBOL_cmd_GRACEFUL_RESTART = 1125,    /* cmd_GRACEFUL_RESTART  */
  YYSYMBOL_cmd_SHOW_THREADS = 1126,        /* cmd_SHOW_THREADS  */
  YYSYMBOL_cmd_SHOW_THREADS_ALL = 1127,    /* cmd_SHOW_THREADS_ALL  */
  YYSYMBOL_cfg_name = 1128,                /* cfg_name  */
  YYSYMBOL_cfg_timeout = 1129,             /* cfg_timeout  */
  YYSYMBOL_kern_proto_start = 1130,        /* kern_proto_start  */
  YYSYMBOL_kern_learn = 1131,              /* kern_learn  */
  YYSYMBOL_kern_mp_limit = 1132,           /* kern_mp_limit  */
  YYSYMBOL_kern_channel = 1133,            /* kern_channel  */
  YYSYMBOL_kern_item = 1134,               /* kern_item  */
  YYSYMBOL_kif_proto_start = 1135,         /* kif_proto_start  */
  YYSYMBOL_kif_proto = 1136,               /* kif_proto  */
  YYSYMBOL_kif_item = 1137,                /* kif_item  */
  YYSYMBOL_kif_iface_start = 1138,         /* kif_iface_start  */
  YYSYMBOL_kif_iface_item = 1139,          /* kif_iface_item  */
  YYSYMBOL_kif_iface_opts = 1140,          /* kif_iface_opts  */
  YYSYMBOL_kif_iface_opt_list = 1141,      /* kif_iface_opt_list  */
  YYSYMBOL_kif_iface = 1142                /* kif_iface  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
# define YYCOPY_NEEDED 1
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  87
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   6246

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  607
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  536
/* YYNRULES -- Number of rules.  */
#define YYNRULES  1695
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  3230

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   838


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    43,     2,     2,     2,    42,    37,     2,
      60,    61,    40,    38,    85,    39,    44,    41,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   154,    59,
      32,    31,    33,   157,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   155,     2,   156,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    86,    36,    87,    34,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    35,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    88,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,   181,   182,   183,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
     428,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,   446,   447,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   493,   494,   495,   496,   497,
     498,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   522,   523,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   533,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   572,   573,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,   597,
     598,   599,   600,   601,   602,   603,   604,   605,   606
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,    57,    57,    57,    57,    57,    57,    57,    57,    57,
      57,    57,   156,   157,   160,   162,   165,   170,   173,   180,
     181,   182,   188,   189,   190,   193,   193,   198,   199,   200,
     201,   202,   203,   210,   211,   212,   219,   220,   227,   233,
     243,   249,   268,   296,   302,   308,   316,   324,   330,   336,
     336,   337,   337,   338,   338,   341,   342,   343,   344,   345,
     346,   347,   354,   355,   363,   364,   372,   373,   381,   382,
     390,   391,   392,   393,   394,   404,   412,   413,   424,   432,
     439,   440,   447,   448,   452,   453,   454,   455,   462,   470,
     471,   475,   476,   477,   485,   486,   487,    37,    38,    39,
      40,    41,    42,    43,    44,    48,    49,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    65,    66,    67,
      70,    71,    75,    79,    83,    84,    88,    92,   101,   102,
     106,   110,   114,   121,   122,   126,   127,   128,   129,   133,
     136,   139,   145,   149,   150,   151,   155,   159,   165,   166,
     167,   170,   172,   175,   177,   181,   188,   189,   191,   197,
     203,   203,     9,     9,    10,    10,    11,    11,   403,   412,
     414,   414,   429,   431,   434,   435,   450,   452,   463,   465,
     479,   480,   481,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   493,   494,   495,   496,   518,   517,
     527,   528,   537,   538,   546,   547,   554,   555,   558,   561,
     565,   565,   580,   580,   590,   596,   599,   604,   599,   632,
     633,   636,   636,   638,   646,   647,   664,   665,   678,   679,
     680,   681,   682,   690,   691,   700,   704,   707,   708,   709,
     710,   711,   712,   713,   714,   715,   716,   721,   722,   723,
     724,   728,   729,   730,   734,   735,   736,   737,   738,   739,
     740,   741,   746,   747,   748,   749,   750,   754,   755,   756,
     757,   758,   762,   763,   767,   768,   772,   773,   777,   778,
     779,   780,   788,   789,   792,   793,   800,   810,   811,   815,
     819,   820,   821,   822,   826,   827,   828,   829,   830,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   848,
     849,   853,   854,   855,   856,   862,   863,   864,   867,   883,
     894,   895,   896,   897,   898,   899,   900,   901,   904,   904,
     906,   909,   909,   914,   919,   929,   930,   931,   932,   933,
     934,   935,   936,   937,   938,   939,   940,   941,   942,   943,
     944,   945,   946,   947,   949,   950,   952,   954,   956,   957,
     958,   959,   961,   962,   963,   964,   966,   967,   968,   970,
     972,   973,   977,   981,   982,   983,   987,   991,   998,   999,
    1003,  1003,  1003,  1004,  1007,  1010,  1016,  1018,  1010,  1023,
    1026,  1042,  1049,  1052,  1055,  1058,  1059,  1062,  1062,  1068,
    1069,  1073,  1078,  1094,   206,   209,   210,   214,   215,   216,
     217,   227,   229,   231,   233,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   252,   253,   259,   261,   263,
     268,   270,   274,   275,   276,   281,   282,   283,   287,   288,
     289,   290,   297,   299,   302,   304,   310,   313,   314,   318,
     324,   328,   338,   348,   350,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   367,   373,   378,   379,   385,   386,
     387,   388,   389,   390,   398,   403,   404,   407,   409,   412,
     414,   418,   425,   428,   435,   436,   437,   438,   442,   443,
     444,   445,   446,   450,   451,   455,   458,   459,   460,   461,
     462,   467,   470,   474,   475,   476,   477,   481,   482,   483,
     484,   485,   486,   487,   488,   494,   502,   503,   507,   508,
     512,   517,   518,   522,   524,   532,   536,   537,   542,   544,
     552,   553,   554,   555,   556,   560,   568,   574,   575,   576,
     580,   581,   585,   586,   587,   588,   589,   590,   596,   597,
     598,   602,   603,   607,   608,   614,   618,   619,   622,   624,
     628,   629,   632,   632,   634,   645,   646,   647,   648,   649,
     650,   651,   652,   653,   657,   658,   659,   660,   661,   662,
     663,   664,   665,   666,   667,   668,   669,   670,   674,   680,
     686,   686,   689,   689,   692,   692,   695,   695,   699,   700,
     703,   703,   706,   706,   710,   710,   731,   738,   744,   750,
     757,   764,   771,   778,   784,   789,   794,   798,   802,   806,
     816,   823,   832,   836,   843,   847,   848,   849,   850,   854,
     858,   862,   876,   877,   878,   879,   882,   883,   884,   885,
     890,   891,   892,   893,   894,   895,   896,   897,   898,   899,
     900,   901,   902,   903,   904,   905,   906,   907,   908,   909,
     910,   914,   924,   924,   934,   938,   939,   940,   941,   942,
     943,   947,   947,   949,   949,   951,   951,   953,   953,   955,
     955,   957,   957,   959,   959,   961,   961,   963,   963,   965,
     965,   967,   967,   970,   970,   974,   980,   983,   983,   985,
     985,   987,   987,   989,   989,   991,   991,   993,   993,   997,
     997,  1010,  1011,  1015,  1015,  1018,  1018,  1022,  1022,  1032,
    1033,  1034,  1038,  1039,  1040,    31,    33,    35,    38,    41,
      43,    46,    48,    51,    54,    56,    60,    64,    69,    70,
      73,    75,    78,    80,    84,    97,    99,   119,   120,   121,
     122,   126,   127,   128,   129,   130,   131,   134,   136,   139,
     141,   144,   144,   149,   155,   178,   186,   196,   196,    28,
      30,    40,    41,    42,    43,    43,    73,    73,    85,    85,
      86,    90,    91,   105,   127,    36,    38,    59,    60,    65,
      66,    67,    68,    69,    70,    73,    75,    79,    86,    87,
      88,    89,    93,    97,   101,   117,   139,   140,   141,   142,
     143,   144,   147,   149,   153,   156,   161,   162,   163,   167,
     168,   172,   173,   176,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   210,   212,   216,   219,   239,   245,   245,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
      34,    36,    44,    45,    46,    47,    50,    52,    56,    60,
      81,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   176,
     178,   181,   183,   188,   192,   192,   195,   195,   198,   198,
     201,   201,    56,    58,    98,   100,   101,   104,   106,   107,
     108,   109,   114,   115,   119,   120,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   136,   137,   138,   142,   143,
     144,   145,   146,   150,   151,   152,   153,   154,   155,   159,
     160,   166,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,   183,   184,   185,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   249,   249,   250,   251,   252,
     253,   254,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   272,   283,   289,   294,   299,   304,
     320,   325,   333,   334,   337,   339,   342,   354,   356,   358,
     362,   362,   366,   384,   413,   414,   415,   419,   420,   421,
     424,   424,   424,   427,   428,   429,   430,   431,   432,   433,
     434,   435,   436,   437,   438,   443,   444,   445,   446,   447,
     448,   449,   450,   451,   452,   453,   454,   455,   456,   457,
     458,   459,   460,   471,   483,   485,   488,   490,   494,   504,
     506,   519,   519,   525,   525,   530,   530,   536,   547,    49,
      52,    65,    67,    74,    75,    76,    77,    78,    79,    80,
      81,    84,    86,    90,    94,    95,   211,   214,   215,   216,
     219,   235,   236,   240,   241,   245,   254,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   274,   289,   292,   294,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   307,   308,   308,   309,
     310,   311,   315,   316,   320,   328,   330,   334,   335,   336,
     340,   341,   344,   346,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   362,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   422,   424,   427,   429,   437,
     439,   440,   443,   445,   449,   450,   453,   463,   485,   487,
     491,   491,   494,   496,   499,   501,   505,   509,   509,   512,
     512,   515,   515,   520,   520,   523,   523,   528,   528,   531,
     531,   535,   535,   552,   555,   556,   557,   558,   559,   560,
     561,   562,    23,    26,    25,    42,    43,    44,    45,    51,
      52,    53,    55,    68,    69,    70,    71,    72,    72,    73,
      73,    74,    75,    76,    79,    81,    85,    89,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   128,
     132,   133,   134,   135,   136,   137,   137,   138,   138,   139,
     140,   141,   142,   146,   147,   148,   151,   189,   191,   194,
     196,   200,   203,   215,   216,   217,   218,   222,   229,   237,
     239,   242,   244,   248,   252,   262,   267,   268,   269,   273,
     285,   287,   291,   292,   296,   309,   314,   315,   316,   320,
     332,   334,   338,   339,   344,   345,   349,   350,    46,    49,
      50,    53,    67,    68,    69,    70,    71,    72,    75,    77,
      81,    85,   110,   140,   141,   142,   143,   144,   145,   146,
     150,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
     173,   174,   175,   176,   179,   181,   184,   186,   190,   195,
     195,   198,   198,    43,    45,    55,    57,    59,    63,    64,
      65,    66,    67,    68,    69,    70,    76,    82,    88,    89,
      93,   100,   101,   104,   106,   124,   125,   129,   135,   137,
     140,   142,   146,   147,   148,   152,   158,   168,   170,   174,
     175,   176,   180,    56,    58,    65,    66,    67,    68,    69,
      70,    78,    82,    87,    92,    95,    98,   103,   107,   115,
     116,   119,   121,   124,   124,   137,   138,   142,   147,   148,
     149,   150,   151,   152,   153,   153,   158,   167,   180,   180,
     183,   192,   194,   197,   199,   199,   203,   203,    26,    28,
      35,    36,    37,    38,    39,    40,    41,    42,    45,    47,
      51,    54,    54,    63,    64,    65,    66,    67,    68,    24,
      26,    35,    37,    42,    50,    51,    52,    55,    56,    63,
      70,    73,    76,    26,    29,    30,    31,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    46,    47,    48,
      49,    50,    53,    54,    57,    34,    36,    38,    45,    46,
      49,    51,    55,    63,    71,    72,    73,    76,    86,    87,
      91,    92,    96,    97,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   113,   116,   117,   127,   129,   135,   135,
     137,   145,   147,   148,   151,   163,   163,   189,   190,   191,
     192,   193,   194,   205,   208,   209,   210,   211,   215,   216,
     217,   220,   220,   223,   224,   225,   226,   227,   228,   229,
     237,   237,   240,   240,   247,   247,   250,   250,   253,   253,
     256,   256,   259,   259,   264,   264,   267,   267,   270,   270,
     274,   275,   279,   280,   281,    43,    45,    50,    51,    54,
      55,    59,    60,    65,    66,    70,    71,    72,    73,    77,
      84,    85,    96,    98,   101,   102,   105,   106,   107,   114,
     121,   124,   126,   129,   131,   135
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "QUIT", "EXIT", "HELP",
  "END", "CLI_MARKER", "INVALID_TOKEN", "ELSECOL", "DDOT", "GEQ", "LEQ",
  "NEQ", "AND", "OR", "IMP", "PO", "PC", "NUM", "ENUM_TOKEN", "IP4", "IP6",
  "VPN_RD", "CF_SYM_KNOWN", "CF_SYM_UNDEFINED", "CF_SYM_METHOD_BARE",
  "CF_SYM_METHOD_ARGS", "TEXT", "BYTETEXT", "PREFIX_DUMMY", "'='", "'<'",
  "'>'", "'~'", "NMA", "'|'", "'&'", "'+'", "'-'", "'*'", "'/'", "'%'",
  "'!'", "'.'", "DEFINE", "ON", "OFF", "YES", "NO", "S", "MS", "US",
  "PORT", "VPN", "MPLS", "FROM", "MAX", "AS", "';'", "'('", "')'", "FLOW4",
  "FLOW6", "DST", "SRC", "PROTO", "NEXT", "HEADER", "DPORT", "SPORT",
  "ICMP", "TYPE", "CODE", "TCP", "FLAGS", "LENGTH", "DSCP",
  "DONT_FRAGMENT", "IS_FRAGMENT", "FIRST_FRAGMENT", "LAST_FRAGMENT",
  "FRAGMENT", "LABEL", "OFFSET", "','", "'{'", "'}'", "FUNCTION", "PRINT",
  "PRINTN", "UNSET", "RETURN", "ACCEPT", "REJECT", "ERROR", "INT", "BOOL",
  "IP", "PREFIX", "RD", "PAIR", "QUAD", "EC", "LC", "ENUM", "SET",
  "STRING", "BYTESTRING", "BGPMASK", "BGPPATH", "CLIST", "ECLIST",
  "LCLIST", "IF", "THEN", "ELSE", "CASE", "FOR", "IN", "DO", "TRUE",
  "FALSE", "RT", "RO", "UNKNOWN", "GENERIC", "GW", "NET", "SCOPE", "DEST",
  "IFNAME", "IFINDEX", "WEIGHT", "GW_MPLS", "ROA_CHECK", "ASPA_CHECK",
  "DEFINED", "ADD", "DELETE", "RESET", "PREPEND", "EMPTY", "FILTER",
  "WHERE", "EVAL", "ATTRIBUTE", "FROM_HEX", "BT_ASSERT", "BT_TEST_SUITE",
  "BT_CHECK_ASSIGN", "BT_TEST_SAME", "FORMAT", "STACKS", "':'", "'['",
  "']'", "'?'", "ROUTER", "ID", "HOSTNAME", "PROTOCOL", "TEMPLATE",
  "PREFERENCE", "DISABLED", "DEBUG", "ALL", "DIRECT", "PIPE", "INTERFACE",
  "IMPORT", "EXPORT", "NONE", "VRF", "DEFAULT", "TABLE", "TABLES",
  "STATES", "ROUTES", "FILTERS", "IPV4", "IPV6", "VPN4", "VPN6", "ROA4",
  "ROA6", "SADR", "ASPA", "RECEIVE", "LIMIT", "ACTION", "WARN", "BLOCK",
  "RESTART", "DISABLE", "KEEP", "FILTERED", "RPKI", "PASSWORD", "KEY",
  "PASSIVE", "TO", "EVENTS", "PACKETS", "PROTOCOLS", "CHANNELS",
  "INTERFACES", "ALGORITHM", "KEYED", "HMAC", "MD5", "SHA1", "SHA256",
  "SHA384", "SHA512", "BLAKE2S128", "BLAKE2S256", "BLAKE2B256",
  "BLAKE2B512", "PRIMARY", "STATS", "COUNT", "COMMANDS", "PREEXPORT",
  "NOEXPORT", "EXPORTED", "GENERATE", "BGP", "PASSWORDS", "DESCRIPTION",
  "RELOAD", "OUT", "MRTDUMP", "MESSAGES", "RESTRICT", "MEMORY", "CLASS",
  "PARTIAL", "TIMEFORMAT", "ISO", "SHORT", "LONG", "ROUTE", "BASE", "LOG",
  "GRACEFUL", "WAIT", "CHECK", "LINK", "CORK", "SORTED", "TRIE", "MIN",
  "ROA", "DIGEST", "REFRESH", "SETTLE", "TIME", "GC", "THRESHOLD",
  "PERIOD", "MPLS_LABEL", "MPLS_POLICY", "MPLS_CLASS", "ASPA_PROVIDERS",
  "IPV4_MC", "IPV4_MPLS", "IPV6_MC", "IPV6_MPLS", "IPV6_SADR", "VPN4_MC",
  "VPN4_MPLS", "VPN6_MC", "VPN6_MPLS", "PRI", "SEC", "NET_TYPE", "RTS",
  "RTD", "AF", "SHOW", "STATUS", "SUMMARY", "SYMBOLS", "DUMP", "RESOURCES",
  "SOCKETS", "AO", "KEYS", "NEIGHBORS", "ATTRIBUTES", "ENABLE", "DOMAIN",
  "RANGE", "STATIC", "DYNAMIC", "START", "POLICY", "AGGREGATE", "RANGES",
  "AGGREGATOR", "PEER", "MERGE", "BY", "BABEL", "METRIC", "RXCOST",
  "HELLO", "UPDATE", "WIRED", "WIRELESS", "BUFFER", "PRIORITY", "HOP",
  "ENTRIES", "RANDOMIZE", "MAC", "PERMISSIVE", "EXTENDED", "TUNNEL", "RTT",
  "DECAY", "SEND", "TIMESTAMPS", "COST", "DELAY", "PREFER", "NATIVE",
  "BFD", "IDLE", "RX", "TX", "INTERVAL", "MULTIPLIER", "ADDRESS",
  "EXPRESS", "MULTIHOP", "NEIGHBOR", "DEV", "LOCAL", "AUTHENTICATION",
  "SIMPLE", "METICULOUS", "STRICT", "BIND", "ZERO", "UDP6", "CHECKSUM",
  "SESSIONS", "HOLD", "CONNECT", "RETRY", "KEEPALIVE", "STARTUP", "VIA",
  "SELF", "PATH", "FORGET", "AFTER", "BGP_LOCAL_PREF", "BGP_MED", "SOURCE",
  "RR", "RS", "CLIENT", "CLUSTER", "AS4", "ADVERTISE", "CAPABILITIES",
  "OLDER", "MISSING", "LLADDR", "DROP", "IGNORE", "ENHANCED", "INTERPRET",
  "COMMUNITIES", "IGP", "GATEWAY", "RECURSIVE", "MED", "TTL", "SECURITY",
  "DETERMINISTIC", "SECONDARY", "ALLOW", "PATHS", "AWARE", "SETKEY",
  "CONFEDERATION", "MEMBER", "MULTICAST", "LIVED", "STALE", "IBGP", "EBGP",
  "MANDATORY", "INTERNAL", "EXTERNAL", "SETS", "NAME", "DIGITS", "AIGP",
  "ORIGINATE", "ENFORCE", "FIRST", "FREE", "VALIDATE", "ROLE", "ROLES",
  "PROVIDER", "CUSTOMER", "RS_SERVER", "RS_CLIENT", "REQUIRE", "BGP_OTC",
  "GLOBAL", "RECV", "SIZE", "WARNING", "SINGLE", "DOUBLE", "SECRET",
  "DEPRECATED", "PREFERRED", "CMAC", "AES128", "BGP_ORIGIN", "CEASE",
  "HIT", "ADMINISTRATIVE", "SHUTDOWN", "CONFIGURATION", "CHANGE",
  "DECONFIGURED", "CONNECTION", "REJECTED", "COLLISION", "OF",
  "ASPA_CHECK_UPSTREAM", "ASPA_CHECK_DOWNSTREAM", "BMP", "STATION",
  "SYSTEM", "MONITORING", "RIB", "PRE_POLICY", "POST_POLICY", "L3VPN",
  "TARGET", "DISTINGUISHER", "MRT", "FILENAME", "ALWAYS", "OSPF", "V2",
  "V3", "AREA", "RFC1583COMPAT", "STUB", "TICK", "COST2", "RETRANSMIT",
  "TRANSMIT", "DEAD", "BROADCAST", "BCAST", "NONBROADCAST", "NBMA",
  "POINTOPOINT", "PTP", "POINTOMULTIPOINT", "PTMP", "CRYPTOGRAPHIC",
  "ELIGIBLE", "POLL", "NETWORKS", "HIDDEN", "VIRTUAL", "ONLY", "LARGE",
  "NORMAL", "STUBNET", "TAG", "LSADB", "ECMP", "NSSA", "TRANSLATOR",
  "STABILITY", "LSID", "INSTANCE", "REAL", "NETMASK", "LSA", "SUPPRESSION",
  "RFC5838", "PE", "TOPOLOGY", "STATE", "GENERATION", "RADV", "RA",
  "SOLICITED", "UNICAST", "MANAGED", "OTHER", "CONFIG", "LINGER", "MTU",
  "REACHABLE", "RETRANS", "TIMER", "CURRENT", "VALID", "MULT", "LIFETIME",
  "SKIP", "ONLINK", "AUTONOMOUS", "RDNSS", "DNSSL", "NS", "TRIGGER",
  "SENSITIVE", "LOW", "MEDIUM", "HIGH", "PROPAGATE", "CUSTOM", "OPTION",
  "VALUE", "RA_PREFERENCE", "RIP", "NG", "INFINITY", "TIMEOUT", "GARBAGE",
  "MODE", "VERSION", "SPLIT", "HORIZON", "POISON", "REVERSE", "PLAINTEXT",
  "DEMAND", "CIRCUIT", "REMOTE", "BIRD", "PRIVATE", "PUBLIC", "SSH",
  "TRANSPORT", "USER", "EXPIRE", "PROHIBIT", "BLACKHOLE", "UNREACHABLE",
  "TRANSIT", "PROVIDERS", "KERNEL", "NETLINK", "KRT_LOCK_MTU",
  "KRT_LOCK_WINDOW", "KRT_LOCK_RTT", "KRT_LOCK_RTTVAR",
  "KRT_LOCK_SSTHRESH", "KRT_LOCK_CWND", "KRT_LOCK_ADVMSS",
  "KRT_LOCK_REORDERING", "KRT_LOCK_HOPLIMIT", "KRT_LOCK_INITCWND",
  "KRT_LOCK_RTO_MIN", "KRT_LOCK_INITRWND", "KRT_LOCK_QUICKACK",
  "KRT_LOCK_CONGCTL", "KRT_LOCK_FASTOPEN_NO_COOKIE", "KRT_FEATURE_ECN",
  "KRT_FEATURE_ALLFRAG", "SYSLOG", "TRACE", "INFO", "AUTH", "FATAL", "BUG",
  "STDERR", "SOFT", "UDP", "CLI", "CONFIRM", "UNDO", "LATENCY", "WATCHDOG",
  "PING", "WAKEUP", "SCHEDULING", "TIMERS", "ALLOCATOR", "FIXED", "THREAD",
  "THREADS", "GROUP", "CONFIGURE", "DOWN", "PERSIST", "SCAN", "LEARN",
  "DEVICE", "$accept", "cli_cmd", "cmd_QUIT", "cmd_EXIT", "cmd_HELP",
  "config", "conf_entries", "conf", "definition", "expr", "expr_us",
  "symbol", "bool", "ipa", "ipa_scope", "pxlen4", "net_ip4_",
  "net_ip6_slash", "net_ip6_", "net_ip6_sadr_", "net_vpn4_", "net_vpn6_",
  "net_roa4_", "net_roa6_", "net_mpls_", "net_aspa_", "net_ip_",
  "net_vpn_", "net_roa_", "net_", "net_ip4", "net_ip6", "net_ip",
  "net_any", "net_or_ipa", "label_stack_start", "label_stack", "time",
  "settle", "text", "opttext", "text_or_ipa", "bytestring",
  "bytestring_text", "bytestring_expr", "flow_num_op", "flow_logic_op",
  "flow_num_type_", "flow_num_type", "flow_flag_type", "flow_frag_type",
  "flow_srcdst", "flow_num_opts", "flow_num_opt_ext_expr",
  "flow_num_opt_ext", "flow_bmk_opts", "flow_neg", "flow_frag_val",
  "flow_frag_opts", "flow4_item", "flow6_item", "flow4_opts", "flow6_opts",
  "flow_builder_init", "flow_builder_set_ipv4", "flow_builder_set_ipv6",
  "net_flow4_", "net_flow6_", "net_flow_", "enum_type", "filter_def",
  "$@1", "filter_eval", "custom_attr", "bt_test_suite", "bt_test_same",
  "type", "@2", "function_argsn", "function_args", "function_vars",
  "function_type", "filter_body", "filter", "$@3", "where_filter", "$@4",
  "function_body", "function_def", "$@5", "$@6", "cmds", "cmd_var",
  "cmd_prep", "cmds_int", "fipa", "set_atom0", "set_atom", "switch_atom",
  "cnum", "pair_item", "ec_kind", "ec_item", "lc_item", "set_item",
  "switch_item", "ec_items", "set_items", "switch_items", "fprefix",
  "fprefix_set", "switch_body", "bgp_path_expr", "bgp_path",
  "bgp_path_tail", "constant", "constructor", "var_list_r", "var_list",
  "function_call", "static_attr", "term_dot_method", "$@7",
  "method_name_cont", "$@8", "term", "term_bs", "break_command", "var",
  "for_var", "cmd", "$@9", "$@10", "$@11", "$@12", "$@13", "$@14",
  "get_cf_position", "lvalue", "rtrid", "idval", "hostname_override",
  "gr_opts", "net_type_base", "net_type", "table", "table_start",
  "table_sorted", "table_opt", "table_opts", "table_opt_list",
  "proto_start", "proto_name", "proto_item", "channel_start",
  "channel_item_", "channel_item", "channel_opts", "channel_opt_list",
  "channel_end", "proto_channel", "rtable", "imexport", "limit_action",
  "limit_spec", "debug_default", "timeformat_base", "timeformat_which",
  "timeformat_spec", "iface_patt_node_init", "iface_patt_node_body",
  "iface_negate", "iface_patt_node", "iface_patt_list",
  "iface_patt_list_nopx", "iface_patt_init", "iface_patt", "tos", "proto",
  "dev_proto_start", "dev_proto", "dev_iface_init", "dev_iface_patt",
  "debug_mask", "debug_list", "debug_flag", "mrtdump_mask", "mrtdump_list",
  "mrtdump_flag", "password_list", "password_list_body", "password_items",
  "password_item", "pass_key", "password_item_begin",
  "password_item_params", "password_algorithm", "password_item_end",
  "bfd_opts", "cmd_SHOW_STATUS", "cmd_SHOW_MEMORY", "cmd_SHOW_PROTOCOLS",
  "cmd_SHOW_PROTOCOLS_ALL", "optproto", "cmd_SHOW_INTERFACES",
  "cmd_SHOW_INTERFACES_SUMMARY", "cmd_SHOW_ROUTE", "r_args", "r_args_for",
  "r_args_for_val", "export_mode", "channel_sym", "channel_arg",
  "cmd_SHOW_SYMBOLS", "sym_args", "cmd_DUMP_RESOURCES", "cmd_DUMP_SOCKETS",
  "cmd_DUMP_AO_KEYS", "cmd_DUMP_EVENTS", "cmd_DUMP_INTERFACES",
  "cmd_DUMP_NEIGHBORS", "cmd_DUMP_ATTRIBUTES", "cmd_DUMP_ROUTES",
  "cmd_DUMP_TABLES", "cmd_DUMP_PROTOCOLS", "cmd_DUMP_FILTER_ALL",
  "cmd_EVAL", "partial_opt", "cmd_DISABLE", "cmd_ENABLE", "cmd_RESTART",
  "cmd_RELOAD_FILTERS", "cmd_RELOAD_FILTERS_IN", "cmd_RELOAD_FILTERS_OUT",
  "cmd_DEBUG", "debug_args", "cmd_MRTDUMP", "cmd_RESTRICT",
  "cmd_TIMEFORMAT", "proto_patt", "proto_patt2", "mpls_domain",
  "mpls_domain_start", "mpls_domain_opt", "mpls_domain_opts",
  "mpls_domain_opt_list", "mpls_domain_end", "mpls_range",
  "mpls_range_start", "mpls_range_opt", "mpls_range_opts",
  "mpls_range_opt_list", "mpls_range_end", "mpls_channel",
  "mpls_channel_start", "mpls_label_policy", "mpls_channel_opt",
  "mpls_channel_opts", "mpls_channel_opt_list", "mpls_channel_end", "$@15",
  "show_mpls_ranges_args", "cmd_SHOW_MPLS_RANGES",
  "aggregator_proto_start", "aggregator_proto_item", "$@16", "$@17",
  "aggregator_proto_opts", "aggregator_proto", "aggr_list", "aggr_item",
  "babel_proto_start", "babel_proto_item", "babel_proto_opts",
  "babel_proto", "babel_iface_start", "babel_iface_finish",
  "babel_iface_item", "babel_iface_opts", "babel_iface_opt_list",
  "babel_iface", "cmd_SHOW_BABEL_INTERFACES", "cmd_SHOW_BABEL_NEIGHBORS",
  "cmd_SHOW_BABEL_ENTRIES", "cmd_SHOW_BABEL_ROUTES", "bfd_proto_start",
  "bfd_proto_item", "bfd_proto_opts", "bfd_proto", "bfd_accept_item",
  "bfd_accept", "bfd_iface_start", "bfd_iface_finish", "bfd_auth_type",
  "bfd_iface_opt_list", "bfd_iface", "bfd_multihop", "bfd_neigh_iface",
  "bfd_neigh_local", "bfd_neigh_multihop", "bfd_neighbor", "bfd_item",
  "bfd_items", "bfd_opts_start", "bfd_opts_end", "cmd_SHOW_BFD_SESSIONS",
  "bfd_show_sessions_args", "bgp_proto_start", "bgp_loc_opts",
  "bgp_nbr_opts", "bgp_cease_mask", "bgp_cease_list", "bgp_cease_flag",
  "bgp_auth_type", "bgp_role_name", "bgp_proto", "$@18", "$@19", "bgp_afi",
  "tcp_ao_key_start", "tcp_ao_key_opt", "tcp_ao_algorithm",
  "tcp_ao_key_opts", "tcp_ao_key_end", "tcp_ao_key", "tcp_ao_keys",
  "tcp_ao_key_list", "$@20", "tcp_ao_end", "bgp_channel_start", "bgp_nh",
  "bgp_llnh", "bgp_lladdr", "bgp_channel_item", "bgp_channel_opts",
  "bgp_channel_opt_list", "bgp_channel_end", "bgp_proto_channel",
  "cmd_RELOAD_BGP", "cmd_RELOAD_BGP_IN", "cmd_RELOAD_BGP_OUT",
  "bmp_proto_start", "bmp_station_address", "bmp_proto",
  "l3vpn_channel_start", "l3vpn_channel", "l3vpn_proto_start",
  "l3vpn_proto_item", "l3vpn_proto_opts", "l3vpn_proto", "l3vpn_targets",
  "mrt_proto_start", "mrt_proto_item", "mrt_proto_opts", "mrt_proto",
  "cmd_MRT_DUMP", "mrt_dump_args", "ospf_variant", "ospf_proto_start",
  "ospf_proto", "ospf_af_mc", "ospf_channel_start", "ospf_channel",
  "ospf_proto_item", "ospf_area_start", "ospf_area", "ospf_area_opts",
  "ospf_area_item", "$@21", "$@22", "ospf_stubnet", "ospf_stubnet_start",
  "ospf_stubnet_opts", "ospf_stubnet_item", "ospf_vlink",
  "ospf_vlink_opts", "ospf_vlink_item", "ospf_vlink_start",
  "ospf_iface_item", "pref_list", "pref_item", "pref_base", "pref_opt",
  "nbma_list", "nbma_eligible", "nbma_item", "ospf_iface_start",
  "ospf_instance_id", "ospf_iface_patt_list", "$@23", "ospf_iface_opts",
  "ospf_iface_opt_list", "ospf_iface", "cmd_SHOW_OSPF",
  "cmd_SHOW_OSPF_NEIGHBORS", "cmd_SHOW_OSPF_INTERFACE",
  "cmd_SHOW_OSPF_TOPOLOGY", "cmd_SHOW_OSPF_TOPOLOGY_ALL",
  "cmd_SHOW_OSPF_STATE", "cmd_SHOW_OSPF_STATE_ALL", "cmd_SHOW_OSPF_LSADB",
  "lsadb_args", "pipe_proto_start", "$@24", "pipe_proto",
  "radv_proto_start", "radv_proto_item", "$@25", "$@26", "radv_proto_opts",
  "radv_proto", "radv_iface_start", "radv_iface_item", "$@27", "$@28",
  "radv_preference", "radv_iface_finish", "radv_iface_opts",
  "radv_iface_opt_list", "radv_iface", "radv_prefix_start",
  "radv_prefix_item", "radv_prefix_finish", "radv_prefix_opts",
  "radv_prefix_opt_list", "radv_prefix", "radv_rdnss_node",
  "radv_rdnss_start", "radv_rdnss_item", "radv_rdnss_finish",
  "radv_rdnss_opts", "radv_rdnss", "radv_dnssl_node", "radv_dnssl_start",
  "radv_dnssl_item", "radv_dnssl_finish", "radv_dnssl_opts", "radv_dnssl",
  "radv_mult", "radv_sensitive", "rip_variant", "rip_proto_start",
  "rip_proto_item", "rip_proto_opts", "rip_proto", "rip_iface_start",
  "rip_iface_finish", "rip_iface_item", "rip_auth", "rip_iface_opts",
  "rip_iface_opt_list", "rip_iface", "cmd_SHOW_RIP_INTERFACES",
  "cmd_SHOW_RIP_NEIGHBORS", "rpki_proto_start", "rpki_proto",
  "rpki_proto_opts", "rpki_proto_item", "rpki_keep_interval",
  "rpki_proto_item_port", "rpki_cache_addr", "rpki_transport",
  "rpki_transport_tcp_init", "rpki_transport_tcp_opts_list",
  "rpki_transport_tcp_opts", "rpki_transport_tcp_item",
  "rpki_transport_tcp_check", "rpki_transport_ssh_init",
  "rpki_transport_ssh_opts", "rpki_transport_ssh_item",
  "rpki_transport_ssh_check", "static_proto_start", "static_proto",
  "stat_nexthop", "stat_nexthops", "stat_mpls", "stat_route0", "$@29",
  "stat_route", "$@30", "stat_aspa_provider", "stat_aspa_providers",
  "stat_route_item", "stat_route_opts", "stat_route_opt_list", "$@31",
  "cmd_SHOW_STATIC", "kern_proto", "kern_sys_item", "attr_bit",
  "log_begin", "log_config", "syslog_name", "log_limit", "log_file",
  "log_udp_host", "log_udp_port", "log_mask", "log_mask_list", "log_cat",
  "mrtdump_base", "cli", "cli_opts", "cli_opts_begin", "cli_opts_block",
  "$@32", "thread_group_opts", "debug_unix", "latency_debug_mask",
  "latency_debug_list", "latency_debug_flag", "cmd_CONFIGURE",
  "cmd_CONFIGURE_SOFT", "cmd_CONFIGURE_CONFIRM", "cmd_CONFIGURE_UNDO",
  "cmd_CONFIGURE_STATUS", "cmd_CONFIGURE_CHECK", "cmd_DOWN",
  "cmd_GRACEFUL_RESTART", "cmd_SHOW_THREADS", "cmd_SHOW_THREADS_ALL",
  "cfg_name", "cfg_timeout", "kern_proto_start", "kern_learn",
  "kern_mp_limit", "kern_channel", "kern_item", "kif_proto_start",
  "kif_proto", "kif_item", "kif_iface_start", "kif_iface_item",
  "kif_iface_opts", "kif_iface_opt_list", "kif_iface", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-2647)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1015)

#define yytable_value_is_error(Yyn) \
  ((Yyn) == YYTABLE_NINF)

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     164,   235,   258,   716,   272,   318,   353,  4282,   388,   506,
     506,   573,   506,   510,   146,   344,    90,  1610,   506,   421,
      32,   631, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,  1146,
     449, -2647, -2647, -2647,  1146,   670,  4282,  3305,   747,   795,
     743,   928, -2647, -2647,   -55, -2647,   689, -2647, -2647, -2647,
   -2647, -2647,   166,   918, -2647,   732,   928,  -171,   337,   936,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647,   835, -2647,   779,  2394, -2647, -2647, -2647,  1160,
    1045, -2647,   976,  1160, -2647,  1160, -2647,  1160, -2647,  1160,
    4809,  1160,  1893,  1160, -2647,  1160, -2647,  1160,  4631,   983,
      89,  1160, -2647,  1160, -2647,  1160, -2647,  1160,  4710,   169,
   -2647, -2647, -2647, -2647,  1160,  1160,   147, -2647, -2647, -2647,
    1437, -2647, -2647,  1061,  1075,  1500,  1126, -2647, -2647,   979,
     263,  4282,  1173,  3298,  1120,  1154, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647,  1200,  1227,  1249,  1277,
    1283,  1289,  1317,  1333,  1346,  1222,  1276,  1378,  1382, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647,  1307,  1411,  1398, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
    4358, -2647, -2647, -2647,  1423, -2647, -2647,   546,  1466,   546,
   -2647,  1451,  1451,   822,   956,   663, -2647,  1140,  1301,  1476,
    1481,  1192,   793,    79,  1488, -2647,  1495, -2647,  1480,   899,
    1163,    54,   -45,   189,  1380,   928,   928,   928,   928,   928,
     928,   928,  1264,   928,   928,  1451, -2647, -2647,  1526,  1551,
    1526,  1560,  1580,  1068, -2647, -2647, -2647,  1578,  1146, -2647,
    1140, -2647,  6202, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
    1576, -2647,   752,  1603,  1617,  1212, -2647, -2647,  1594,   546,
     546,   546,  1140,  1413,   796, -2647,   663,  1600, -2647, -2647,
   -2647, -2647,   146,    77,  1418, -2647,  1140,  1140,  1146, -2647,
    1146, -2647,  1596, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647,  1119, -2647,  1151, -2647, -2647, -2647,
   -2647,  1664,  1637,  1620, -2647,  1544,   928,  1459,   546, -2647,
     371,  1460,   928,   663,  1471,  1108, -2647,  1662,  1644,  1683,
    1687, -2647, -2647,  1663,  1665,  1681,  1686, -2647,   963, -2647,
   -2647, -2647,   -74,  1710,  1755,  1221,    40,    87,    93,   138,
     211,   928,  1459,  1399,  1625,  1541,   646,  1707,   514,  1420,
    1504,  1483,  1456,  1404,  1421,  1275,   293,   135,   552,  1492,
    1590,   505,  1592,  1503,  1549,  1528,  1235,  1501,  1711,  1459,
    1506,  1575,  1579,  1505,  1511,   214,  1459,   104,  1489,  1557,
     970,  1834,  1843,  1799, -2647,  1817,  1847,  1832, -2647,  1601,
    1588,  1589,   -31,  1482,  1860,  1842,  1851,  1852,  1433, -2647,
   -2647,  1748,  1545,  1379,  1459,  1784,  1140,  1459,  1789,  1459,
    1556, -2647,  1644, -2647,  1892,  1866, -2647, -2647,  1462, -2647,
    1140,  1651,  2015,  1931,  1774,  1737,  1794,  1911,  1913,  1889,
    1895,  1896,  1897, -2647,  1447,  1738,  1812,  1930,  1935,  1936,
     125,  1904, -2647,  1803,  1629,  1140,  1822,  1689,  1459,  1735,
    1582, -2647, -2647, -2647,  1958, -2647,  1961,  1938,  1940, -2647,
   -2647,  1765, -2647,  1970,   962, -2647,  1437,  1437,  4282,  1397,
    1437,  1437,  2013, -2647,  2014, -2647, -2647,  1061,  1075, -2647,
    2018, -2647,  4282,  2000,   561,  2001,  1995, -2647, -2647, -2647,
    2022, -2647,  1957,  3791, -2647, -2647,  1931,  1931,  4282,  4282,
    4282,  4282,  4282,  4282,  4282, -2647, -2647, -2647, -2647,  3143,
   -2647, -2647, -2647,   944, -2647, -2647,  2042, -2647, -2647, -2647,
   -2647,   603, -2647,   636, -2647,  1931,  1931,  2040,  2005,  2043,
   -2647,  4282,  4282,  4282,  4282,  4282,  4282,  4282,  4282,  4282,
    4282,  4282,  4282,  4282,  4282,  4282,  4282, -2647,  3509, -2647,
    1370, -2647, -2647, -2647, -2647, -2647,  2057,  2058,   506,   506,
    1828,   506,   506,  2061, -2647,   362, -2647,  2063, -2647, -2647,
    4282,  2044,  1585,  1606, -2647, -2647, -2647, -2647, -2647,  1226,
    2068, -2647,  2069, -2647,  5369, -2647,  1032, -2647,  2070,  1480,
    1480,  1480,  1480, -2647,  1480,  1480, -2647,   197,   249,  2073,
    1480,  1480, -2647,  2079,   928,  2082,  2084,  2085,  2087,  2090,
    2091,  2093,   928,  2095,  2097,  2107,   846,  2112, -2647,  1068,
   -2647, -2647,  1140,  2113,  4282, -2647,  2029,  1140, -2647,   437,
    3441, -2647,  2062,  2038,  2039, -2647, -2647, -2647, -2647,  4282,
    2067, -2647, -2647, -2647, -2647, -2647,   546, -2647,   -87, -2647,
    1140, -2647,  2074, -2647,  2076,  1727, -2647,  1452,   928,  1140,
     179,  1140, -2647,   723,  1095, -2647, -2647, -2647, -2647, -2647,
   -2647,  1160, -2647, -2647, -2647, -2647,  2104, -2647,  1379, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
    1140, -2647, -2647,  1459,  1146, -2647, -2647, -2647, -2647, -2647,
    1169, -2647, -2647, -2647, -2647, -2647,  1744,  1944,  1884,  1887,
   -2647,  2088,  1140,  1140, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647,  1459,    36,  2105,  2106,   -83,   866,  1459,  1781,
    1959,  1922,  1926, -2647,  2125,  1937,  1953,  1459,  1946,    69,
    1934,  1939,  1459,  2138,  2140,  2114,  1782, -2647,  2143, -2647,
   -2647, -2647,  1474,  2161,   120,   604,  2161,  1304, -2647, -2647,
   -2647,  2146,  1459,  1140,  1949,  1952,  1140,  1956,  1459,  1539,
    1459,  2048,  1459,  1459,  2151,  1459,  1459,  1459,  1459,  1459,
    1816,  2159,  1459,  1459,  2167,  1459,  2168,  2170,  1459,  1459,
    1838,  1976,  2041,  2002,  1459,  1991,  1459, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647,  2047,  1539, -2647,   928,   928,
    2130, -2647, -2647, -2647, -2647,  1459,   945,  1459, -2647, -2647,
    1459, -2647,  2064,  1140, -2647, -2647, -2647, -2647, -2647, -2647,
    1140, -2647,  1447,  2226, -2647, -2647, -2647,  1314,  2065, -2647,
   -2647,  1447,  1314, -2647, -2647, -2647,  1314,  1459,  1931, -2647,
   -2647, -2647, -2647, -2647, -2647,  1500, -2647, -2647, -2647,  1459,
    1931, -2647, -2647, -2647, -2647,  1405, -2647,  1539, -2647, -2647,
   -2647, -2647, -2647,   113,  1900, -2647,  2198,  1459,  1459, -2647,
    1140,  1948, -2647,  1140, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647,  1140, -2647,  2241, -2647, -2647, -2647,  4427,
   -2647, -2647,  1437,   638, -2647, -2647, -2647, -2647, -2647,  2178,
    2203,  6202, -2647,  2123,  2228, -2647, -2647,  4282, -2647,  4282,
   -2647, -2647,   641,  2184,  5645,  4713,  4794,  4874,  5302,  5659,
    5696,  2185,   223,  2186,  5710, -2647, -2647,  2253,  2263,  2395,
   -2647,  1500, -2647,  2212,  2213,  2217,  2258,  2230,  2603,  2603,
    2603,  3981,  3981,  2603,  2603,  2603,  2603,  2603,  1740,  1740,
    1355,  1355,  1995,  1995,  1950, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647,   727, -2647, -2647, -2647,  1828,  1828,  4282,
    2275,  2283,  2285, -2647, -2647, -2647,   760, -2647, -2647,  5747,
   -2647, -2647, -2647, -2647, -2647,   424,  2286, -2647, -2647, -2647,
    1198,  1447,  2226,  2269, -2647,  2119,  2121,   504, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647,  2273, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647,  1451,  1451,  1451,  1451,
     703,  1451,  1451,   145,  1480,  1451,  1480,  1451, -2647,  1451,
    1451, -2647,  2292, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
    2293, -2647, -2647, -2647, -2647,  2226,  1255,   928, -2647, -2647,
    2294, -2647, -2647,  6104,  2240,  2287,  2245,  2954, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647,   752, -2647,   928,  2281, -2647,  2247,  5761, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647,  1182, -2647, -2647,
   -2647, -2647,   928, -2647, -2647, -2647, -2647, -2647,  4282, -2647,
    2254,  1140,   928, -2647,   -33, -2647,  2250,  2257, -2647, -2647,
   -2647, -2647, -2647,  2227,   -36, -2647, -2647, -2647,  2278, -2647,
    2234, -2647,  2266, -2647,  1627, -2647,  2034, -2647,  2270, -2647,
    2246,  1475,  1863,   399,  1941,  2098,  1140,  1140, -2647,  2274,
    2297,  2302,  1459,  2083, -2647, -2647,  2171,  2108,  1140,  2308,
    2309,  2318,  1987,  2124,  1140,  1140, -2647, -2647,  1459,  1459,
    2323,  2128,  1140,  2325,  1140,  1140,  2326, -2647, -2647,  2396,
   -2647,  1140, -2647, -2647, -2647, -2647,  1146, -2647,  1140,  1140,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,  2346, -2647,
    1140,  1140, -2647, -2647,  2347,  2349,  1140,  1140,  2350,  1140,
    2351,  2352,  2354,  1379,  2361,  2364, -2647,  2365,  2366,  2367,
    2370,  2377,  1459,  1294,  2378,  2379, -2647,  2380, -2647,  1459,
    2381,  2383,  2199,  1459,  1459,  1459,  2384,  2190,  2387,  1564,
   -2647, -2647,  5124, -2647,  1140,  2388,  1001,  2389,  2391,  1228,
    1496,   367, -2647,  1140, -2647, -2647, -2647, -2647,  1140, -2647,
   -2647,   581,  2393,  1412, -2647, -2647, -2647,  4282, -2647,  2264,
   -2647,  1459,  1412, -2647, -2647, -2647,  2397,  3756,  5052,  2419,
    2398,  2400,  2403, -2647,  2161,  2402,  2445,  2447,  1140,  1459,
    2439,  1459,   113, -2647, -2647, -2647,  2279, -2647,  1140, -2647,
    2234,  2385, -2647,  1437, -2647, -2647,  1437,  4282, -2647,  2430,
    2434,  5535,  4676, -2647, -2647, -2647,  4282,  4282, -2647,  4282,
    4282,  4282,  4282, -2647, -2647,  3327,  4282,  3467,  4282, -2647,
    2390,  4282, -2647, -2647, -2647, -2647, -2647,  2455,  2436,  2459,
   -2647, -2647, -2647, -2647, -2647,  1370, -2647,  2473,  2474,  6202,
   -2647, -2647, -2647,   362, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647,  1061,   562,  1670, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647,  2460,  2460, -2647, -2647,  1423,
   -2647,  2477,  2479,  2481,  2483, -2647, -2647, -2647, -2647,   928,
   -2647, -2647,  1583, -2647,   928,  2484,  2493, -2647, -2647,  2469,
    1379, -2647, -2647, -2647,  1379,  1379,  1451,  2494,  1451,  2495,
    2496,  2497, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647,  3441,  3441, -2647, -2647,  4459,   752,  2446,  2443,  2422,
    2234, -2647, -2647,   -87, -2647, -2647,  5798,  2489, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
    1217, -2647, -2647, -2647,   -23,   -16, -2647,   546,  2255,  2272,
    2251,  1459,  1459,  2256,  1442,  1924,  2478, -2647,  2500, -2647,
   -2647, -2647,   546,  1973, -2647,  2480,   683, -2647, -2647, -2647,
   -2647,  2486,  2358,  2233, -2647, -2647,  2485, -2647, -2647,  2382,
   -2647, -2647,  2487, -2647, -2647, -2647,  1951, -2647,  1539,  2194,
    2196, -2647,  2488,  2291,  1140,  2470,  2498, -2647, -2647, -2647,
    2499,   648, -2647,  2501,   373,  1140,  2505, -2647, -2647, -2647,
    2299,  1140,  2506,  2510,   148, -2647,  2513,  2516, -2647,  1459,
    2517, -2647,  2519,  2521, -2647,  2472, -2647,  2522,  2523,   217,
   -2647,   278, -2647, -2647, -2647,  1356, -2647, -2647, -2647, -2647,
    2526,  2527, -2647,  2528, -2647, -2647, -2647,  2529, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647,  2530, -2647,  2531, -2647, -2647,
   -2647,  2534, -2647, -2647,  2401,  2536,  2537,  2538, -2647,  1459,
   -2647,  1004, -2647,  2574, -2647,  2546, -2647,  2368,  2295, -2647,
    2221,  1796,  1543,  2218,  2438,  2418,  2280,  2376,  2555,  1140,
    2252,  2449,     8,  1459,  1459,   181,  1459,    88, -2647,  2566,
    2567, -2647,  1140, -2647,  1539, -2647, -2647,  1459,  1459, -2647,
    2605,  2180,  2181,  1274, -2647, -2647, -2647,  1644, -2647,  2586,
   -2647,  2226,  1293,  1140,   928,  2508, -2647, -2647,  2590, -2647,
   -2647, -2647, -2647,     2,  1459, -2647,   927, -2647,  2404,  1474,
   -2647,   106,  2595, -2647,  2166, -2647,  2598, -2647,  6202,  1519,
   -2647, -2647, -2647, -2647, -2647,  1389, -2647, -2647, -2647,  1389,
    2490,  2133, -2647, -2647,  2600, -2647, -2647,  1459,  1140, -2647,
   -2647,  2606,  1140,  2126, -2647,  2129,  2471,  2336,  2471,  2615,
    1452,   -26,  2471, -2647, -2647,  2614, -2647,  1140, -2647, -2647,
   -2647, -2647,  2447, -2647, -2647,  2599, -2647, -2647,  2642, -2647,
   -2647, -2647, -2647,  1049,  1140, -2647, -2647, -2647, -2647, -2647,
   -2647,  6202,  2646, -2647,  4282, -2647,  4282,  2767,  2872,  5569,
    5603,  5812,  5849,  5863,  5900,   881,   744,  6202,  2601,   987,
     206,  2607,  2672,  5710, -2647,  2674, -2647,  2635, -2647, -2647,
   -2647, -2647,  2675,  1061,  1075,  1423, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647,  1061,  1075, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647,  2690, -2647,  2693, -2647,
   -2647, -2647,   752,  2596, -2647, -2647,  4282,  4282,  2644,  4282,
   -2647, -2647, -2647,  4282,  4282, -2647,  2645,  2647,   752,  2621,
   -2647, -2647,  4459,  2650,  4282, -2647, -2647,  1060,  2651, -2647,
   -2647,  2692, -2647, -2647, -2647,   -33, -2647,  2653,  2654,  2424,
    -118,  1459,  2461,  2462,  1140,  2629, -2647,  2463,  2550,  1140,
   -2647, -2647,  2466,  1140,  1140,  1146, -2647,  1649,  1583, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647,   187, -2647, -2647,  1931,
   -2647, -2647, -2647, -2647,  2558, -2647,   790, -2647, -2647,  2131,
    2638, -2647,   155, -2647,  1459,  2386, -2647,  1140,  2669,  1140,
   -2647, -2647,  2540,  2303,  2296, -2647,   102,  2304,  1300,  1375,
   -2647, -2647,  2673,  2676,  2679, -2647,  1140,  2683, -2647, -2647,
   -2647, -2647,  2658,  2686, -2647, -2647,  2687, -2647, -2647, -2647,
   -2647,  1152, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647,  1459, -2647, -2647, -2647,  2688,   372,
     559, -2647, -2647,  2356,   370,  1105,  1459,  1459,  2492,   -65,
    1931,  1459,  2684,  2360,  2437, -2647,    -7,  1931, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647,  2369,  2695, -2647, -2647, -2647,
   -2647,  2694,  2698, -2647,   149,   149,   149,  2731, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647,  2408, -2647, -2647, -2647,  1140,
    1140,  1459, -2647,  2680,  1140, -2647,  2681,  1379, -2647, -2647,
    2682,  1140, -2647, -2647,  1140,  2685, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647,  2689, -2647, -2647, -2647,  1302,   494,
   -2647,  1459,  2697, -2647, -2647, -2647,  2570, -2647, -2647, -2647,
    1140,  1140, -2647,  1140,  1539,  1140,  2696, -2647,  2720, -2647,
   -2647, -2647,  1140, -2647, -2647,  2642,  2445,  2755, -2647, -2647,
   -2647, -2647,    16,  2737,  5914,  5951, -2647, -2647, -2647, -2647,
    2709, -2647, -2647,  1668,  2704, -2647, -2647, -2647, -2647, -2647,
   -2647,  1857,  2738,  2738,  1110,  2721, -2647,  1857,  2738,  2738,
    1389,  2723,  4282,  4282, -2647, -2647, -2647, -2647, -2647,  2743,
    4282, -2647,  3613, -2647,  2745,  4282,  2776,  3936,  4107,  2701,
   -2647,  4282, -2647, -2647, -2647,  1427, -2647,  4459,   807,   940,
    2769,  6118,  2207,  2482,  2882, -2647, -2647,   726, -2647, -2647,
   -2647,  1042,  4282, -2647, -2647,  2733, -2647, -2647, -2647,  2736,
    1140,  1140,  2739,  1140,  1140,  2740, -2647,  1140,  2541,  1140,
    1140, -2647, -2647, -2647, -2647,  1140, -2647,  1140,  2741,  2242,
   -2647, -2647,  2710,  1459, -2647, -2647, -2647, -2647, -2647,  2638,
    1146, -2647, -2647,  1146,   928,  2491, -2647,  2509,  2742, -2647,
    2762,  2373,  2539, -2647, -2647, -2647, -2647, -2647, -2647,   648,
   -2647, -2647, -2647, -2647,  2764, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647,  1459,  2754, -2647,  1414,  2515,  1140,  1140,   598,
   -2647, -2647, -2647,  1777,  2761,  2766,  2768, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647,  2464,   778,  2413,  1539,
     778, -2647, -2647, -2647, -2647, -2647,  1140,  2660,  2622, -2647,
   -2647,  2542,  2465,  1459, -2647, -2647, -2647, -2647, -2647,  1459,
    2543, -2647, -2647,  1465,  2818, -2647, -2647, -2647, -2647, -2647,
   -2647,  1459,  2234,  2794, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647,  2795, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647,  1140,  2796,  1140,
   -2647, -2647, -2647, -2647, -2647,  1459, -2647,  2798,  2799, -2647,
   -2647, -2647, -2647,  1539,  2827, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
    2880,  1140,  1760, -2647,  2806, -2647,  1018,  1140,  1679,  1083,
   -2647, -2647, -2647, -2647,  1760,  1018,  1083,  2808, -2647,  5965,
    6002,  2832,  2834,   997,   825,  2835,  1052,  2838,  2839,   906,
    2841,   935, -2647,  2842, -2647, -2647, -2647, -2647, -2647,  2843,
   -2647,  4508, -2647, -2647,   752,  2786,  4282,  2300,  4282, -2647,
   -2647,  6153,  1950, -2647, -2647,  2849,  2850, -2647,  2851,  2852,
   -2647,  1140, -2647,  2656, -2647, -2647, -2647, -2647, -2647,  4282,
   -2647,  2829, -2647, -2647, -2647, -2647, -2647, -2647, -2647,  1498,
   -2647, -2647, -2647,  1539,  2579,  1459, -2647, -2647, -2647, -2647,
   -2647, -2647,   584, -2647, -2647,  1605,  2584,  2585,  2589, -2647,
   -2647, -2647,  1611, -2647,  2714, -2647, -2647, -2647,  4282, -2647,
   -2647, -2647, -2647,   532, -2647, -2647, -2647,  2661, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647,  1459,  1140,  2777,  2671,
   -2647, -2647,  1459, -2647,   645, -2647,  2166, -2647, -2647,  1240,
    1254,    78,   582,   -15, -2647, -2647, -2647, -2647, -2647,  2410,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,  1140,
   -2647, -2647,  1140,  1933,  1140, -2647,  2738,  2738,  2889, -2647,
   -2647, -2647, -2647, -2647,  2738,  2738,  2912, -2647, -2647, -2647,
   -2647, -2647,  2892,  4282, -2647, -2647, -2647,  2893,  4282, -2647,
    4282,  2924, -2647,  4282, -2647, -2647,  2857,  2886,  2840,  2089,
   -2647, -2647,  6202, -2647,  6167, -2647,  2891, -2647, -2647, -2647,
   -2647, -2647,  1140,  6016,  2242,  2223, -2647, -2647, -2647, -2647,
    1459, -2647, -2647, -2647,  1140,   834,  2792,  2801,  1777,  2899,
    2903, -2647,  2876,  2905,  1140,  1140,  1140, -2647, -2647,  1631,
    6053,  2938,    84,  1140,  2938,  1547,   156,  2881,  1140, -2647,
   -2647,   413,  1140, -2647,  2818, -2647, -2647,  5020, -2647, -2647,
   -2647,    37, -2647, -2647,  1459,  1140,  1459,  2908, -2647,  1140,
    1140,    83,  1140,  2648,   183, -2647,  2910, -2647,  2456,  2518,
    1459,  1459,  1459,  2916,   761, -2647,   -34,   -24,  1826,  4919,
   -2647,    73, -2647,    24, -2647,  2806,  1140, -2647,  1140,  1140,
    1140,  1679,  1679, -2647,  2915,  2927,  2935,  2913,  2936,  2939,
    2944, -2647, -2647,  4508,  4508, -2647, -2647,  2996, -2647, -2647,
   -2647, -2647,   756,  4282,  2946,  2923, -2647, -2647, -2647, -2647,
   -2647,  1140,  2699,  1020, -2647,  1140,  2763,  1140,  2677,  2700,
    2947,    86,  2702,  2724,   105,   288, -2647,  2961, -2647, -2647,
    2972,  1647,  1722, -2647, -2647, -2647, -2647,  2587, -2647,  2975,
    1140,  1140,  2977, -2647, -2647, -2647,  1605, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647,  2978,  2938,  2938,  2979,  2980,  2982,
    2938,  2938, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
    2210, -2647,  1140,  2800,  2553,  2957,  1140,  1140,  1140,  1459,
    2749,   707,    94,  2580,  2691,  1459,  1140,  2744,   729,   -84,
    1140,  2937,  2609, -2647,  3009, -2647,  1140,  3017, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,  1140,  1140,
   -2647, -2647,  1140,  1140, -2647, -2647, -2647, -2647,  2581, -2647,
      72,   -79,   -25,  2572,  -162,  2582,  1459,  2575,  2828,  2573,
    2773,  2748,  2751,  2562,  3033, -2647,    67,  1539,  3034, -2647,
    3067,    67,  3037, -2647, -2647, -2647,  1140, -2647,  1459,   -44,
    1140,  2844,  1459,  2787,   722,  1539,  -101,  2715,  2845,  2966,
    2846,  2847,  -130,   177,  2560,  2563,  2561, -2647,  3049, -2647,
     928,   134,  3050, -2647,  2564,  2568,   928,  3055, -2647,  3074,
    3078, -2647, -2647, -2647, -2647, -2647, -2647,  4282, -2647,  4282,
   -2647, -2647, -2647,  1065,  1788,  4508,  6202,  3061,  4282, -2647,
     112, -2647, -2647, -2647, -2647,  1459, -2647,  1140,  1140,  2809,
    1140,  1140,  1140,  1140,  1459,  1140,  1140,  1140,  1140,  1140,
   -2647, -2647,  2804, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647,  3064,  3066, -2647,
   -2647,   532,  3069,  3070,   532,   532,   532,  3071,  3072, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,  1459,
    2632, -2647, -2647, -2647, -2647, -2647,   117,  1140,  1140, -2647,
   -2647, -2647, -2647,  1459,  1109, -2647, -2647,  1140,  1140, -2647,
    1459,  1459, -2647,  1140,  1459, -2647, -2647, -2647, -2647, -2647,
    2610,  2610,  2802,  2875, -2647,   860,  1140,   860,  2878,  1140,
    1140,  1140,  2805,  2633, -2647,  1459,  1140,  1140,  2949,  1459,
    1302,  1459,   494,    35, -2647, -2647,  1140, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647,  1459,  1459, -2647,
    1140, -2647,  1140,  1140,  1140, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647,  1321,  1140,  1140,  1140,  1140, -2647, -2647,  1459,
   -2647,  1459,  1459,  1459, -2647, -2647, -2647, -2647, -2647, -2647,
    2940,  2941, -2647, -2647,  1140,  1140,  3081,  3062, -2647, -2647,
   -2647,  3026, -2647,  6067,  1539,  1539,    99, -2647, -2647, -2647,
    1459, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647,   532,   532, -2647, -2647, -2647,
     532,   532, -2647,  1459,  1284, -2647, -2647, -2647, -2647, -2647,
   -2647,  2670, -2647, -2647, -2647, -2647, -2647, -2647, -2647,  1459,
   -2647, -2647,  1140,  1140, -2647, -2647, -2647, -2647,  2610, -2647,
    1140,  2610, -2647, -2647,  1140,  1459, -2647, -2647, -2647,  1140,
   -2647, -2647, -2647, -2647,  1140,  1459, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647,  2705, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647,   928,   928, -2647, -2647, -2647,  4282,  4508,
    3089, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647,  2678, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647,  2620, -2647, -2647, -2647, -2647,  3068,
   -2647, -2647, -2647,  3092,  1826,  4282, -2647, -2647,  3097, -2647
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
      14,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1660,     0,    13,   162,   164,   166,   590,   592,   594,   596,
     600,   602,   604,   662,   671,   673,   675,   677,   679,   681,
     683,   685,   687,   689,   691,   693,   697,   699,   701,   703,
     705,   707,   709,   713,   715,   717,   767,   894,   896,   898,
     900,   838,  1101,  1103,  1105,  1531,  1257,  1259,  1261,  1263,
    1265,  1267,  1269,  1271,  1429,  1431,  1516,  1640,  1642,  1644,
    1646,  1648,  1650,  1652,  1654,  1656,  1658,     1,    12,     0,
     426,    16,   422,   423,     0,     0,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   415,   416,   418,   419,   420,
     421,   424,     0,     0,  1576,     0,     0,     0,     0,     0,
      15,    17,   169,   172,   174,   176,   178,   215,   404,   411,
     413,   425,     0,   427,   430,     0,   495,   501,   446,   449,
     453,   725,   731,   449,   769,   449,   850,   449,   785,   449,
     453,   449,   453,   449,  1109,   449,  1518,   449,   453,     0,
     453,   449,  1291,   449,  1378,   449,  1433,   449,   453,   453,
    1575,  1603,  1606,  1623,   449,   449,   453,   163,   165,   167,
     298,   299,   310,   226,   227,   305,   402,   302,   303,     0,
       0,     0,     0,     0,     0,     0,   322,   300,   301,   320,
     321,   323,   324,   325,   326,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1557,
    1558,  1559,  1560,  1561,  1562,  1563,  1564,  1565,  1566,  1567,
    1568,  1569,  1570,  1571,  1572,  1573,    49,     0,    50,    59,
      51,    52,    53,    54,    60,    61,    55,    56,    57,   306,
     160,   161,    58,   304,   314,   354,   355,   371,   403,   357,
       0,   370,   356,  1574,   719,   721,   720,     0,     0,     0,
     719,    83,    83,     0,     0,     0,   716,   507,     0,     0,
       0,     0,   723,     0,     0,   606,     0,   664,   599,     0,
       0,   599,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    83,  1533,  1661,  1660,     0,
    1660,     0,     0,  1662,  1653,    26,    25,     0,     0,   216,
       0,   170,   173,   180,   181,   182,   184,   183,   185,   186,
     187,   188,   198,   189,   190,   191,   192,   193,   194,   195,
       0,   196,     0,     0,     0,     0,    81,    80,     0,     0,
       0,     0,     0,     0,     0,   417,     0,     0,   504,   503,
     505,   506,     0,     0,     0,  1610,     0,     0,     0,  1614,
       0,   431,   444,   529,  1283,  1434,   903,  1474,   770,   851,
     786,  1540,  1112,  1519,  1127,  1292,  1379,  1666,  1683,  1130,
    1381,     0,   450,     0,   528,     0,     0,    32,     0,   535,
       0,     0,     0,     0,     0,     0,   464,     0,   479,     0,
       0,   729,   733,     0,     0,     0,     0,   746,     0,  1032,
    1033,   902,     0,     0,     0,     0,  1022,  1023,     0,     0,
       0,     0,    32,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    32,     0,     0,   907,   904,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    32,
       0,     0,     0,     0,     0,     0,    32,     0,     0,     0,
       0,     0,     0,   759,  1053,  1096,     0,     0,  1539,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   426,
    1126,     0,     0,     0,    32,     0,     0,    32,     0,    32,
    1133,  1137,   479,  1138,     0,     0,  1151,  1285,     0,  1282,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1473,     0,     0,     0,     0,     0,     0,
    1498,  1513,  1665,     0,     0,     0,     0,     0,    32,     0,
      32,  1675,  1673,  1674,     0,  1676,     0,     0,     0,  1682,
    1689,     0,  1686,     0,   298,   402,   298,   298,     0,     0,
     298,   298,     0,   287,     0,    39,    40,     0,     0,    43,
       0,    44,   315,     0,     0,     0,   352,    47,   247,   248,
       0,   250,     0,     0,   155,   155,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   228,   231,   230,   234,     0,
     307,    49,    50,   278,   229,   233,   265,   262,   263,   264,
     274,     0,   282,     0,    48,     0,     0,     0,    41,     0,
     694,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   328,     0,   538,
       0,   537,   712,   710,   711,    82,     0,     0,     0,     0,
     696,     0,     0,     0,   549,     0,   548,     0,    19,    21,
       0,     0,   509,   512,   718,  1655,   763,   722,   724,   723,
       0,   601,     0,   593,     0,   591,     0,   598,     0,   599,
     599,   599,   599,   840,   599,   599,  1273,   599,   599,     0,
     599,   599,  1657,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1649,  1662,
    1645,  1647,  1663,     0,     0,   727,     0,     0,   204,     0,
       0,   197,     0,     0,     0,   407,   409,   410,   524,     0,
       0,   412,   498,   496,   497,   499,     0,  1629,     0,  1628,
       0,  1624,     0,  1605,     0,  1579,  1585,     0,     0,  1580,
       0,     0,  1607,     0,     0,  1626,  1627,  1615,   429,   442,
     428,   449,  1128,  1129,  1380,   451,     0,   530,     0,   459,
      28,    30,    29,    31,    27,   454,   456,   515,   462,   461,
       0,   460,   457,    32,     0,   531,   477,   481,   532,   533,
       0,   726,   778,   856,   795,   933,     0,     0,     0,     0,
     951,     0,     0,     0,  1026,  1024,  1027,  1025,  1028,  1030,
    1029,  1031,    32,     0,     0,     0,     0,    32,    32,     0,
       0,     0,     0,  1050,     0,     0,     0,    32,     0,     0,
       0,     0,    32,     0,     0,     0,     0,   952,     0,    33,
      34,    35,     0,    36,     0,     0,    36,     0,   925,   926,
     927,     0,    32,     0,     0,     0,     0,     0,    32,     0,
      32,     0,    32,    32,     0,    32,    32,    32,    32,    32,
       0,     0,    32,    32,     0,    32,     0,     0,    32,    32,
       0,     0,     0,     0,    32,     0,    32,   934,   936,   757,
     761,  1094,  1098,   935,  1544,     0,     0,  1541,     0,     0,
       0,  1545,  1121,  1528,  1131,    32,    32,    32,  1152,  1139,
      32,  1149,  1146,     0,  1140,  1134,  1135,   481,  1132,  1154,
       0,   472,     0,   210,   212,   486,   487,     0,     0,   485,
     466,     0,     0,   468,   483,   465,     0,    32,     0,  1286,
    1287,  1304,  1388,  1436,  1475,     0,    69,    68,  1493,    32,
       0,  1476,  1477,  1478,  1500,     0,  1499,     0,  1503,  1501,
    1502,  1506,  1504,  1489,  1495,  1514,     0,    32,    32,  1555,
       0,     0,  1677,     0,  1670,  1669,  1679,  1553,  1668,  1667,
    1684,   515,  1687,     0,  1685,     0,   290,   296,   294,     0,
     226,   227,   298,     0,   295,   297,   289,    38,    41,   318,
       0,   316,   358,     0,     0,   359,   249,     0,   335,     0,
     156,   157,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   236,   279,   280,     0,     0,     0,
     308,     0,   309,     0,     0,     0,     0,     0,   349,   347,
     345,   342,   343,   344,   346,   348,   350,   351,   341,   340,
     336,   337,   338,   339,     0,   657,   655,   656,   640,   643,
     647,   650,   653,   654,   658,   641,   642,   644,   645,   646,
     648,   649,   651,   652,   659,   660,   661,   542,   543,   544,
     546,   547,   545,     0,   540,   702,   698,   696,   696,     0,
       0,     0,     0,  1102,   553,   554,     0,   551,   714,     0,
     508,   510,   511,   513,   514,     0,     0,   595,   603,   605,
       0,     0,   210,     0,   616,     0,   637,     0,   618,   617,
     622,   623,   636,   638,   639,   607,   615,     0,   663,   670,
     667,   666,   668,   669,   665,  1517,    83,    83,    83,    83,
       0,    83,    83,     0,   599,    83,   599,    83,  1258,    83,
      83,  1659,     0,   688,   686,   678,   690,   680,   672,   674,
       0,   682,   684,   700,  1532,   210,     0,     0,  1537,  1651,
       0,  1664,  1641,     0,   200,   206,     0,     0,   171,   208,
       4,     7,     6,     9,     2,     3,     5,     8,    10,    11,
     199,     0,   175,     0,     0,   515,     0,     0,   405,   500,
    1638,  1635,  1633,  1634,  1636,  1639,  1637,     0,  1631,  1625,
    1604,   502,     0,  1584,    85,    86,    87,    84,     0,  1587,
    1588,     0,     0,  1582,     0,  1590,     0,     0,  1609,  1611,
      22,    23,    24,     0,     0,  1284,   452,   458,   518,   521,
     536,   455,     0,   463,     0,   482,     0,   732,     0,   728,
     742,   453,   453,   453,     0,     0,     0,     0,   942,     0,
       0,     0,    32,    32,   991,   993,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1048,  1052,    32,    32,
       0,     0,     0,     0,     0,     0,     0,  1013,  1012,   835,
    1015,     0,   953,    67,    66,   907,     0,   907,     0,     0,
     939,   910,   911,   928,   929,   930,   931,   932,     0,   904,
       0,     0,   937,   989,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   988,     0,     0,     0,
       0,     0,    32,     0,     0,     0,   992,     0,   946,    32,
       0,     0,     0,    32,    32,    32,     0,     0,     0,     0,
     745,   481,     0,  1099,     0,     0,     0,     0,     0,     0,
     453,   453,  1141,     0,  1144,  1143,  1148,  1142,     0,  1150,
    1136,     0,     0,     0,   209,   484,   204,     0,   494,   488,
     470,    32,     0,   471,   469,   474,     0,   453,   453,   453,
    1491,     0,     0,  1483,    36,  1496,     0,     0,     0,    32,
       0,    32,  1490,  1511,  1481,  1680,  1671,  1554,     0,  1678,
     523,  1693,  1688,   298,   288,   292,   298,     0,   319,     0,
       0,     0,     0,   151,   153,   366,     0,     0,   353,     0,
       0,     0,     0,   372,   369,     0,     0,     0,     0,   232,
       0,     0,   266,   275,   283,  1108,  1107,     0,     0,     0,
     334,   330,   331,   333,   329,     0,   539,     0,     0,   695,
     704,  1104,  1106,     0,   550,    20,   768,   764,   765,   766,
     597,   634,   635,     0,   631,   632,   633,   627,   625,   626,
     608,   624,   609,   614,   621,     0,     0,   610,   611,   619,
     620,     0,     0,     0,     0,   839,   841,   845,   848,     0,
     846,   847,     0,   849,     0,     0,     0,  1272,  1281,     0,
       0,  1276,  1279,  1274,     0,     0,    83,     0,    83,     0,
       0,     0,   692,   676,  1536,  1535,  1534,  1538,  1643,    18,
     202,     0,     0,   217,   168,   219,     0,     0,     0,     0,
     525,   406,   408,     0,  1630,  1578,     0,     0,  1586,  1583,
    1581,  1599,  1594,  1598,  1597,  1595,  1596,  1600,  1601,  1602,
       0,  1592,  1577,   414,     0,     0,   445,     0,     0,     0,
       0,    32,    32,     0,     0,     0,     0,   519,    83,   515,
     534,   480,     0,     0,   475,     0,     0,   730,   740,   744,
     780,     0,     0,     0,   771,   772,     0,   858,   859,     0,
     852,   853,     0,   797,   802,   804,     0,   804,     0,     0,
       0,   787,     0,     0,     0,     0,     0,   964,   963,  1020,
       0,     0,   912,     0,    32,     0,     0,  1001,  1000,  1011,
       0,     0,     0,     0,     0,   990,     0,     0,   978,    32,
       0,   954,     0,     0,   961,     0,   833,     0,     0,     0,
      37,     0,   908,   909,  1018,     0,   905,   906,   956,   948,
       0,     0,   969,     0,   958,   965,   944,     0,   945,   980,
     994,   960,   959,  1010,   962,     0,   995,     0,   997,   998,
     947,     0,   957,   985,     0,     0,     0,     0,   983,    32,
    1019,     0,   760,     0,   751,     0,   762,     0,     0,  1097,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    32,    32,    32,    32,     0,  1063,     0,
       0,  1546,     0,  1547,     0,  1548,  1549,    32,    32,  1123,
       0,     0,     0,     0,  1110,  1113,  1115,   479,  1114,     0,
    1530,   210,     0,     0,     0,     0,  1524,  1520,     0,  1145,
    1147,  1153,  1247,     0,    32,  1167,    32,  1165,     0,     0,
    1157,    32,     0,  1171,  1248,  1290,     0,   211,   213,     0,
     493,   473,   467,  1289,  1306,     0,  1307,  1297,  1299,     0,
       0,     0,  1293,  1294,     0,  1390,  1391,    32,     0,  1382,
    1383,     0,     0,     0,  1435,     0,  1451,     0,  1451,     0,
       0,     0,  1451,  1438,  1439,     0,  1442,     0,  1494,  1479,
    1480,  1482,     0,  1507,  1508,  1505,    75,    76,  1485,  1487,
    1488,  1484,  1486,     0,     0,  1681,  1556,  1691,  1695,   291,
     293,   317,     0,   360,     0,   311,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   236,     0,     0,
       0,     0,     0,     0,    45,     0,    46,     0,   541,   706,
     708,   552,     0,   628,   629,     0,   612,   613,   901,   895,
     897,   899,   843,    72,    73,    74,    70,    71,   842,   844,
    1262,  1260,  1277,  1280,  1275,  1278,     0,  1264,     0,  1268,
    1430,  1432,     0,   207,   204,   380,   315,   315,     0,     0,
     373,   374,   375,     0,     0,   385,     0,     0,     0,     0,
     223,   224,   220,     0,   315,   221,   222,     0,     0,  1100,
     177,     0,  1632,    88,  1589,     0,  1591,     0,     0,     0,
       0,    32,     0,     0,     0,     0,   433,     0,     0,     0,
     432,   434,     0,     0,     0,     0,   443,   516,     0,   520,
     522,   476,   478,   735,   736,   737,     0,   734,   774,     0,
     776,   779,   515,   854,     0,   857,   789,   515,   790,     0,
     812,   791,   816,   792,    32,     0,   796,     0,     0,     0,
     972,   974,     0,     0,     0,   916,     0,     0,     0,     0,
     914,   975,     0,     0,     0,  1002,     0,     0,   949,   970,
    1051,  1034,     0,     0,   976,   979,     0,   955,   966,   971,
     589,     0,  1016,  1021,   941,   940,   938,   967,   968,   950,
     943,   999,   996,  1017,    32,   981,   986,   984,     0,     0,
       0,   752,   758,     0,     0,    32,    32,    32,     0,     0,
       0,    32,     0,     0,     0,  1091,     0,     0,  1071,  1072,
    1073,  1069,  1090,  1089,  1074,     0,     0,  1095,  1552,  1543,
    1542,     0,     0,  1116,     0,     0,     0,     0,   481,  1122,
    1523,  1522,  1521,  1526,  1525,     0,  1529,   515,  1170,     0,
       0,    32,  1158,     0,     0,  1156,     0,     0,  1174,  1169,
    1173,     0,  1163,  1155,     0,  1181,  1288,   489,   490,   491,
     492,    65,    64,  1342,  1351,  1296,   515,  1295,     0,     0,
    1302,    32,     0,  1305,   515,  1387,  1384,  1386,  1389,  1453,
       0,     0,  1452,     0,     0,     0,     0,  1454,  1440,  1457,
    1466,  1444,     0,  1437,  1492,  1497,     0,     0,  1515,  1510,
    1512,  1672,     0,     0,     0,     0,   109,   120,   121,   107,
       0,   110,   111,     0,     0,   114,   115,   119,   116,   158,
     117,     0,   133,   133,     0,     0,   159,     0,   133,   133,
       0,     0,     0,     0,   363,   364,   362,   365,   245,     0,
       0,   243,     0,   239,     0,     0,   237,     0,     0,     0,
      42,   315,   630,  1266,  1270,     0,   218,   219,     0,     0,
       0,     0,     0,     0,     0,   401,   401,     0,   214,   225,
     395,     0,     0,   397,   205,     0,  1593,  1608,  1612,     0,
       0,     0,     0,     0,     0,     0,  1616,     0,     0,     0,
       0,   435,   436,   441,   517,     0,   743,     0,     0,     0,
     773,   204,   891,    32,   800,   798,   799,   801,   803,   812,
       0,   833,   805,     0,     0,   819,   793,     0,     0,  1004,
       0,     0,     0,   919,   920,   918,   922,   921,   923,     0,
     913,  1006,  1005,  1007,     0,  1003,  1044,  1049,   977,   836,
     562,   563,    32,     0,   830,     0,     0,     0,     0,     0,
     832,   555,   557,     0,   588,     0,     0,   982,   753,   754,
     755,   748,   750,   747,   749,   756,     0,    32,     0,     0,
      32,  1082,  1083,  1084,  1086,  1087,     0,     0,     0,  1093,
    1075,     0,     0,    32,  1060,  1061,  1062,  1070,  1092,    32,
       0,  1550,  1551,     0,     0,  1124,  1118,  1119,  1120,  1117,
    1111,    32,  1250,  1254,  1160,  1161,  1159,  1235,  1162,  1235,
    1195,  1175,  1164,  1249,  1182,  1349,  1348,  1339,  1355,  1354,
    1362,  1298,  1364,  1365,  1372,  1300,  1303,     0,  1426,     0,
    1450,  1449,  1445,  1443,  1446,    32,  1441,  1458,     0,  1447,
    1509,    77,  1694,     0,     0,   361,   312,   313,   108,   112,
     113,   118,   103,   101,    99,    98,   100,   102,    97,   104,
     126,     0,   143,   128,   124,   134,   144,     0,     0,   145,
      63,    62,   142,   152,   148,   149,   150,   146,   154,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   281,     0,   201,   203,   381,   393,   394,     0,
     390,     0,   284,   379,     0,     0,     0,     0,     0,   377,
     392,     0,     0,   179,  1613,     0,     0,  1622,     0,     0,
    1620,     0,   438,     0,   437,   440,   739,   738,   741,     0,
     784,   775,   781,   777,   889,   860,   855,   805,   788,     0,
     815,   817,   818,     0,   821,    32,  1009,   973,   917,   924,
     915,  1008,     0,   837,   829,   558,     0,     0,     0,   824,
     828,   806,     0,   807,     0,   831,    92,    91,     0,   564,
      93,    95,    94,   565,   561,   834,   987,     0,  1055,  1056,
    1054,  1066,  1067,  1064,  1065,  1088,    32,     0,     0,     0,
    1080,  1085,    32,   272,     0,  1527,  1248,  1252,  1256,     0,
       0,     0,  1184,     0,  1353,  1337,  1336,  1360,  1370,     0,
    1424,  1392,  1385,  1448,  1460,  1465,  1467,  1690,  1692,     0,
     122,   106,   105,     0,     0,   105,   133,   133,     0,   135,
     136,   137,   138,   139,   133,   133,     0,   367,   368,   260,
     244,   242,     0,     0,   240,   258,   238,     0,     0,   256,
       0,   254,   253,     0,   251,   332,     0,     0,   383,     0,
     378,   386,   401,   401,     0,   389,     0,  1617,  1619,  1618,
    1621,    79,     0,     0,     0,   861,   893,   814,   813,   820,
      32,   823,   794,  1046,     0,     0,     0,     0,     0,     0,
       0,  1045,     0,     0,     0,     0,     0,   808,   809,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1076,
    1077,     0,     0,  1081,     0,  1125,  1251,     0,  1168,  1238,
    1236,  1239,  1166,  1172,    32,     0,    32,     0,  1180,     0,
       0,     0,     0,     0,     0,  1194,     0,  1352,     0,     0,
      32,    32,    32,     0,     0,  1341,  1356,  1366,     0,     0,
    1428,     0,  1455,     0,   127,   125,     0,   129,     0,     0,
       0,     0,     0,   147,     0,     0,     0,     0,     0,     0,
       0,   382,   391,     0,     0,   396,   235,   270,   267,   268,
     269,   276,     0,     0,     0,     0,   376,   398,   439,   783,
     782,     0,     0,     0,   892,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   888,     0,   822,  1047,
       0,     0,     0,   584,   585,   586,   587,     0,  1042,     0,
       0,     0,     0,  1040,  1041,   556,   558,   825,   826,   827,
     810,   811,    96,    78,     0,     0,     0,     0,     0,     0,
       0,     0,   588,  1079,  1057,  1058,  1059,  1068,  1078,   273,
       0,  1255,     0,     0,     0,     0,     0,     0,     0,    32,
       0,     0,     0,     0,     0,    32,     0,     0,     0,     0,
       0,     0,     0,  1234,     0,  1240,     0,     0,  1178,  1179,
    1177,  1176,  1188,  1185,  1191,  1192,  1193,  1186,     0,     0,
    1189,  1183,     0,     0,  1343,  1344,  1345,  1350,     0,  1340,
       0,     0,     0,     0,     0,     0,    32,     0,     0,     0,
       0,  1325,  1327,     0,     0,  1359,     0,     0,     0,  1369,
       0,     0,     0,    89,  1301,    90,     0,  1427,    32,     0,
       0,     0,    32,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1419,     0,  1459,
       0,     0,     0,  1472,     0,     0,     0,     0,   123,     0,
       0,   130,   141,   140,   259,   241,   257,     0,   255,     0,
     252,   384,   286,     0,     0,     0,   387,     0,     0,   862,
       0,   865,   866,   867,   864,    32,   863,     0,     0,     0,
       0,     0,     0,     0,    32,     0,     0,     0,     0,     0,
     872,   880,   881,   890,  1035,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,  1043,  1038,     0,     0,  1039,
     559,   565,     0,     0,   565,   565,   565,     0,     0,   560,
    1203,  1204,  1205,  1206,  1207,  1208,  1209,  1210,  1200,    32,
       0,  1242,  1197,  1215,  1196,  1233,     0,     0,     0,  1228,
    1222,  1223,  1224,    32,    32,  1217,  1199,     0,     0,  1201,
      32,    32,  1198,     0,    32,  1253,  1241,  1237,  1187,  1190,
    1376,  1376,     0,     0,  1324,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1312,    32,     0,     0,     0,    32,
       0,    32,     0,     0,  1338,  1363,     0,  1374,  1358,  1357,
    1361,  1373,  1367,  1368,  1371,  1398,  1396,    32,    32,  1393,
       0,  1417,     0,     0,     0,  1412,  1397,  1420,  1423,  1422,
    1421,  1418,    32,     0,     0,     0,     0,  1394,  1395,    32,
    1399,    32,    32,    32,  1425,  1464,  1462,  1463,  1461,  1456,
       0,     0,  1471,  1468,     0,     0,     0,     0,   271,   277,
     285,     0,   399,     0,     0,     0,     0,   874,   868,   869,
      32,   884,   883,   886,   885,   887,   870,   871,   527,   526,
     873,   882,  1036,  1037,   570,   565,   565,   572,   571,   573,
     565,   565,  1218,    32,     0,  1226,  1225,  1227,  1230,  1229,
    1216,     0,  1231,  1214,  1202,  1213,  1212,  1219,  1211,    32,
    1347,  1346,     0,     0,  1333,  1334,  1335,  1320,  1376,  1321,
       0,  1376,  1314,  1310,     0,    32,  1313,  1315,  1316,     0,
    1330,  1326,  1331,  1328,     0,    32,  1375,  1416,  1403,  1405,
    1410,  1411,  1413,     0,  1414,  1408,  1409,  1406,  1407,  1400,
    1401,  1402,  1404,     0,     0,   132,   131,   246,     0,     0,
       0,   875,   876,   878,   877,   879,   568,   569,   566,   567,
    1220,  1221,  1244,  1243,  1232,  1377,  1309,  1322,  1318,  1323,
    1319,  1308,  1311,  1317,     0,  1332,  1415,  1470,  1469,     0,
     388,   400,  1245,     0,     0,     0,  1246,  1329,     0,   261
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,    91,
    -357,   -73,  1288,  -434,  -809, -2647,  -180,  -177,  -182,  2049,
    2051,  2059, -2647, -2647, -2647, -2647,  -209, -2647, -2647,  -454,
   -2647, -1704,  -806,  -622,  1220, -2647,  1358, -1710, -2113,  -112,
    -218,  1373,   -50,   549, -2646,   615,  -984, -2647,  1341,  1342,
    1347,  1349,  1021,   625,   628,  1023, -1882,  -857,  1024, -2647,
   -2647, -2647, -2647,  2612, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647,   -66, -2647, -2647, -2647,
   -2647, -2647,  1818, -1082, -2647,  -624, -2647, -1802, -2647, -2647,
   -2647,   995, -2647,  1287, -2647,  -213, -2301,  2172,   282, -1392,
   -2480,  3008, -1976, -2455,  2173,   290, -2647,  2649, -2647,  2176,
   -2647, -2647, -2647, -2647,  -480, -2647, -2647,  -586,  1019, -1524,
   -1047, -2647, -2647,   759, -2647,    17, -2261, -2647, -2647, -2647,
   -1806, -2647, -2647, -2647, -2647, -2647, -2647, -2127,  -179, -2647,
    -479, -2647, -2647,    12,  3054, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647,   -41,  -103, -2647,  -137,     6, -2647,  -482,  -890,
    -140,  -547,  -478, -2647,   410, -2647, -2647, -2647,  2853, -2647,
   -2647, -2647,  1634,  -758, -1094, -2647, -2647, -2544, -2647, -2647,
   -2647, -2647, -2647,  -251, -2647,  1759,   408, -2647,  1753, -1951,
   -2647,   451, -2377, -2647, -2647, -1421,   575,   436, -2647, -2647,
   -2647, -2647, -2647,  -235, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647,  -990, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647,   786, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,    49,
    2552, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647,  -143, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
     608, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647,  1616,   748, -2647,   975, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647,   977, -2647, -2647, -2647, -2647, -2647,  1917,   219,
   -2647, -2647,   958, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
     919, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
    -188, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,   882,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647,   694, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647,   215, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647,   395,   379, -2647, -2647, -2647,
   -2647,   207,   378, -2647, -2647, -2647, -2647,   208,   381, -2382,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,  -361,  1111,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647,  2282, -2647, -2647, -2647, -2647, -2647, -2647,
    1107, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,  1319,
   -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
    1704, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647,  1210,  2544, -2647, -2647, -2647, -2647, -2647, -2647, -2647,
   -2647, -2647, -2647, -2647, -2647, -2647
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,    22,    23,    24,    25,     2,     3,   120,   121,   774,
    2461,   392,  2520,  2359,  1297,   565,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
    2412,  2103,  2659,   948,  1878,  1817,  1818,  2774,  2462,   348,
     646,  1219,  2864,  2509,  2510,  2401,  2563,  2160,  2161,  2162,
    2163,  2164,  2402,  2403,  2404,  2406,  2407,  2573,  2409,  2165,
    2171,  1837,  1838,  1010,  1423,  1424,   250,   251,   252,  1190,
     122,   718,   123,   124,   125,   126,  1908,   719,  1531,  1175,
    1177,  1533,  1178,  1375,  1376,   929,  1377,  1179,   127,   716,
    1894,  1909,  1910,  1911,  1912,   253,   605,   606,  2717,  1022,
     607,  1023,   608,   609,   610,  2721,  2534,   611,  2722,   612,
     613,  2599,   561,   254,   562,   255,   256,   999,  1000,   257,
     258,   259,  1054,  1454,  1857,  1847,   261,  1914,  1915,  2445,
    1916,  2197,  2596,  2204,  2723,  3091,  2452,  2446,   262,   128,
     730,   129,   130,   406,   132,   133,   134,   372,  1576,  1234,
     760,   135,   393,   407,   408,  1584,  1585,  1244,   787,  1245,
     409,   935,   930,  1770,  1380,   136,   137,   362,   279,  1238,
    1949,  1578,  1239,  1410,  1411,  1195,  1196,  2940,   138,   139,
     140,   777,   410,   642,  1083,  1084,   657,  1096,  1097,  2290,
    2291,  2632,  2292,  2293,  2294,  2647,  2758,  2514,  1290,    26,
      27,    28,    29,   678,    30,    31,    32,   674,  1480,  1481,
    1127,  1076,   267,    33,   676,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,  1090,    46,    47,
      48,    49,    50,    51,    52,   268,    53,    54,    55,   269,
     670,   141,   142,  1248,   790,   412,   791,  1249,  1250,  2238,
    1956,  1589,  1957,   472,   473,  2305,  1695,  1349,   890,  1350,
    1351,  1105,    56,   143,  1596,  2239,  2241,  1251,   144,  2471,
    2472,   145,  1602,  1252,   146,  1962,  2616,  2747,  2615,  2475,
    1963,    57,    58,    59,    60,   147,  1612,  1253,   148,  2248,
    1966,  1967,  2480,  2505,  2252,  1968,  1971,  2255,  2484,  2621,
    1973,  2295,  2011,  1646,  2493,    61,  1140,   149,   847,   844,
    1623,  1989,  1990,   851,  1308,   150,   835,  1647,   474,  2002,
    2631,  2759,  2492,  2749,  2003,  1634,   824,  1276,  1635,   475,
    2521,  2787,  2327,  1719,  1352,   892,  1353,   476,    62,    63,
      64,   151,  1356,   152,  1737,  1738,   153,  1739,  1360,   154,
    2336,   155,  1748,  1361,   156,    65,   706,   389,   157,   158,
     916,   502,   503,   504,   505,   506,  1371,  1762,  2086,  2083,
    2089,  2090,  2541,  2667,  1763,  2542,  2676,  1764,  2814,  2539,
    2660,  2661,  2817,  3124,  3223,  3203,  2077,  2095,  2343,  2536,
    2657,  2538,  2078,    66,    67,    68,    69,    70,    71,    72,
      73,  1143,   159,   761,   160,   161,  1784,  2108,  2109,  1387,
     162,  2106,  2854,  3030,  3032,  3147,  2685,  2684,  2546,  2107,
    2104,  2683,  2544,  2543,  2356,  2105,  2360,  2547,  2858,  3035,
    2686,  2361,  2364,  2548,  2862,  3041,  2687,  2365,  3038,  3140,
     390,   163,  1791,  1388,   164,  2114,  2690,  2888,  3061,  2689,
    2551,  2115,    74,    75,   165,   166,  1389,  1805,  2123,  1806,
    2128,  2131,  2377,  2555,  2691,  2892,  2692,  2378,  2693,  2897,
    3079,   167,   168,   963,   964,  1808,   530,  1390,   531,  1396,
    1814,  1815,  2140,  1823,   966,  1403,    76,   169,   544,   263,
     363,   170,  1213,  1223,   750,  1220,  1548,  1226,  1560,  1561,
     171,   172,   752,   753,  1564,  1233,  1935,   173,   741,  1207,
    1208,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,   313,   713,   174,   976,  1825,   545,   546,   175,   176,
     553,   981,  2384,  2142,  1828,   982
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     357,   563,   604,   571,   365,   569,   603,  1453,   570,   755,
     756,  1913,   843,   846,   908,   131,   317,  2139,   644,  1240,
     917,   319,   321,   518,   260,   529,   543,  1370,   528,   542,
    1483,   342,  2511,   602,   933,   601,  1295,  1309,   570,  1012,
    1013,  1930,  2865,  1846,  1848,  1850,  1851,   471,  2129,   484,
    1126,  1566,  1125,  2855,   647,   501,   689,   517,   271,   272,
     307,   275,  1551,  2859,  1927,   527,   541,   305,  1033,  1034,
     947,  3057,  2677,   552,   986,  2110,   987,   988,   677,  2447,
     994,   995,  1168,  1524,  3015,   671,   658,   705,  2335,  2335,
    2335,   659,  2196,   346,   568,   804,  2101,   347,   732,   733,
     734,   346,   413,  2382,   414,   347,   415,  3164,   416,  3058,
     477,  2893,   485,   322,   486,  1200,   487,  2465,  2633,  2718,
     519,   349,   520,   658,   521,   658,   522,   660,   659,  1567,
     659,  1262,  1552,   547,   548,  1568,   658,  1490,  3017,  2220,
    2775,   659,   806,  2930,  2720,   281,   508,   776,   808,   350,
     351,  1507,   770,   771,   772,   773,   839,   840,  1931,   841,
    2889,   690,  1266,  3021,   660,  2663,   660,   352,  1397,  1508,
     131,     1,   798,  1298,   277,  2048,   509,   660,  1299,  1300,
    2317,  2936,  2937,   695,   696,   697,   698,   699,   700,   701,
     346,   703,   704,   810,   347,   692,   658,  2253,   898,  1201,
     658,   659,   658,  2525,  3047,   659,  1569,   659,   576,  2333,
     583,  1928,  2780,  1570,  1571,  1572,  2185,  1509,  1573,   954,
     947,   677,  1574,   684,   417,   353,  2055,   770,   771,   772,
     773,    92,    93,  1436,   549,  2000,  1932,   660,     4,     5,
       6,   660,  2264,   660,   691,   715,  1398,   395,   366,   396,
    3000,   749,   510,   397,   398,  2824,   532,  2989,    87,   511,
     512,  3067,   400,  2235,   513,  1224,  2990,  2186,  2860,   722,
    1298,  2890,   870,   677,  2236,  1299,  2014,   514,   177,   308,
    3193,  2408,   401,   799,   769,  2776,   515,  2408,   779,  1237,
     781,  2187,  3094,  3095,   282,   757,   283,   758,  2716,  1913,
    1373,  3048,   574,  1510,  2334,   395,  3076,   396,  1437,  1382,
    1267,   397,   398,   309,   839,   840,   550,   841,   402,   814,
     400,   403,   650,   653,   178,   284,  2079,   395,  2318,   396,
    3055,  1298,   285,   397,   398,  3068,  1299,  2015,  2931,  3022,
     401,  2938,   400,   685,  3077,  1225,   604,  2001,  2324,   105,
     106,   107,   108,   109,   110,   693,   111,  2781,  2533,   179,
    2664,   672,   401,  1144,   367,  2325,  2326,  2511,   661,   899,
     356,   286,  3059,   287,  3165,   563,   402,   563,   563,   403,
       7,   563,   563,  1209,   288,   278,  1553,  2049,  1913,  2633,
     516,  1386,   658,  1511,   289,   346,  2298,   659,   402,   347,
       8,   403,  2665,  1392,  2829,   575,  2056,  2932,  3001,  2678,
    2933,   717,   264,  2891,   533,  1146,   265,  2939,   290,   770,
     771,   772,   773,  1241,  2825,  1321,  3194,  2511,     9,    10,
    1466,   805,  1929,   660,  2718,  2991,  3016,  1540,  3096,  2473,
    2383,  1399,  3060,   735,  1136,  1137,  1138,  1139,  1467,  1141,
    1142,  1400,  1145,  1147,  1740,  1149,  1150,   754,   754,  2720,
    2941,  1696,  1355,  2080,  1263,    11,  2417,    12,   947,    13,
    1282,   534,  2221,    14,   535,  2724,  2725,   947,   807,   955,
      15,  2856,  3018,  2237,   809,  1199,  1603,  2857,  2081,  1482,
    3019,  2861,  1604,  2254,   875,  1866,  1867,   956,  2679,  2728,
    1512,  2680,  2681,  2682,   957,  1202,  1203,  1204,  1205,  1206,
    1741,   924,  1415,  1554,  2815,    16,   276,  1301,  1302,    17,
    2816,  1394,  2362,  1395,  2130,   395,    18,   396,  1487,   811,
     270,   397,   398,  2265,   265,   354,   838,   280,   686,  1094,
     400,   812,  1742,   845,   291,   778,  1555,  1556,  1557,  1558,
    1559,   687,   688,   871,   266,  2666,  2826,   395,   876,   396,
     401,  1513,  1575,   397,   398,  2307,  1180,  2992,  1605,   813,
    2894,  2895,   400,   872,   873,   989,  2896,  1933,  2865,  3013,
    2363,  3036,  1152,  1934,  2052,  1811,   842,   911,  2641,  1001,
    1160,  2675,   401,   639,  2091,  1095,   402,  3125,  3126,   403,
    1003,   921,  1514,   566,  2942,  1014,  1015,  1016,  1017,  1018,
    1019,  1020,  2716,  2716,  1301,  1302,  1024,   310,  1862,  1526,
     311,   312,   292,  2719,  1181,  2642,   969,  1743,   402,  3141,
    1401,   403,   640,  1294,  1515,  2598,  1221,   314,  1038,  1039,
    1040,  1041,  1042,  1043,  1044,  1045,  1046,  1047,  1048,  1049,
    1050,  1051,  1052,  1053,  1191,   745,  3069,   947,  2301,  2070,
     602,   746,   601,   747,  2746,   570,  2299,  2300,  1751,  2668,
    1488,  2623,   266,  1913,   748,  1301,  1302,  1099,  2789,   958,
     959,   960,   961,   962,  2698,  2699,    19,   405,  1029,   293,
    1182,  2643,  2701,  2702,   315,   316,  2308,  1087,  1088,  1183,
    1091,  1092,  1425,  1004,  2309,   306,  2813,   315,   316,  1495,
     654,  1243,   641,  1184,  1185,  1186,  1187,  1283,  1468,  1469,
    1235,  1031,    88,  1029,   848,  2310,  1426,  1496,   536,   537,
    2654,  1173,  2302,  2644,  1606,  1607,  1608,  1746,  2887,  2645,
    2784,   318,  1609,  2624,  1610,   405,  1197,  1982,   658,   655,
    1752,   551,   273,   659,  2180,  1753,   825,  2448,  2646,  1030,
    1992,    89,   849,   571,   742,   569,  3208,   405,   570,  3210,
    2501,    90,   538,   539,   540,    91,   315,   316,    92,    93,
    2280,  2281,  1228,  2987,  2937,  2449,  1357,  1358,  2422,   660,
    2424,  2625,  1032,  2426,  1416,  2429,  2431,   658,  3053,  2937,
     274,  2655,   659,  1171,    94,  2181,  2502,   343,  1176,  1229,
    2283,   782,  1455,   563,  1456,   604,   604,   667,  2838,  1744,
    1745,   668,   603,   320,   770,   771,   772,   773,  2669,   656,
     854,   754,   826,  2785,  2786,  2583,    20,    21,   660,   850,
    1222,  2914,  1227,   737,  1667,  1463,   270,  1464,  2839,   602,
     265,   601,  1164,  2303,   570,   344,   855,  2304,   721,    95,
    2840,    96,    97,  1754,  1188,    98,  2437,    99,  2242,  1497,
    1498,   754,  1499,  2249,   100,   355,   101,   102,   103,  1983,
     827,   104,   738,  1500,  1501,   658,  2584,   819,   828,  2670,
     659,   820,  1417,  1259,  1260,  1766,   105,   106,   107,   108,
     109,   110,   345,   111,  1772,  1303,  2626,  2911,  2912,  1516,
    2915,  1518,   770,   771,   772,   773,  2590,  1913,  1491,  1492,
    1493,  1494,  2671,  1505,  1506,   364,   660,  1517,  1476,  1519,
    1475,  1520,  1521,  1829,  2778,  2841,  1830,   368,  2719,  2503,
    2504,   648,  2178,  2938,  1315,  2593,   658,  1318,   112,  1984,
    2998,   659,   346,  2088,   113,   369,   347,  2244,  2938,   669,
     114,   115,   739,  2511,   658,   405,  2179,  2591,  1189,   659,
    2245,  2246,   985,   770,   771,   772,   773,  1953,  1954,  1755,
     270,   554,  1025,  1026,   265,   740,   555,   660,   266,  1165,
     924,   770,   771,   772,   773,   821,  2594,   405,   822,  2438,
     556,  2627,   557,  2842,  1369,   660,  2628,  2629,  2630,  2843,
     370,  1372,  2357,  2844,  1304,  1305,  1306,  1307,  1379,  2988,
    2368,  1166,   558,  1379,  1421,  1417,  1422,  1379,   196,   371,
    1027,  1883,  2561,  2565,  3054,  1884,  1885,  1502,  1128,  1503,
    1756,  1504,  2751,  2752,  2672,  2673,  2674,  1167,  2183,  2753,
    2754,  2755,  2756,   649,  1722,  1527,  1129,  1757,  2581,  1758,
    1723,  1407,   411,  1759,  1409,  2962,  2963,  1760,  1761,   507,
    2967,  2968,  2184,   186,  1412,   651,  1985,   679,  1986,   358,
    1987,  1538,  2582,  1988,   595,   596,   990,   991,   597,   199,
     200,  2212,   201,   202,   203,   204,   205,  2561,  2565,  1724,
    1545,  2450,   564,  2566,  2213,   680,  1459,    92,    93,  3090,
    1550,  1536,  1601,  2586,  1595,   196,   566,   559,  1537,   560,
    1130,   573,   266,  1268,   658,  1441,  2247,  1417,   658,   659,
     879,   567,   394,   659,  2410,  1895,  2138,  2587,  1896,  1897,
    1898,  1899,  1900,  1901,  1902,  1230,  1231,  1232,  1594,  1600,
    1611,   770,   771,   772,   773,   770,   771,   772,   773,   658,
     359,   360,   361,  1903,   659,   660,  1904,  1905,  2574,   660,
     315,   316,  2518,  2519,  1972,  1131,   199,   200,  2340,   201,
     202,   203,   204,   205,   315,   316,   572,   652,   681,  1913,
    1913,  2705,   577,  1132,  1133,  2072,  2707,  1906,  2708,  1907,
     660,  2710,  1363,   395,   796,   396,   584,  1134,   797,   397,
     398,   880,   881,   682,   399,   882,   391,  1736,   400,  1471,
    1472,  1473,  1474,  1650,   933,   105,   106,   107,   108,   109,
     110,   725,   111,   726,   563,  1546,   727,   563,   401,  2279,
     585,   595,   596,   183,   184,   597,   598,  1783,  1790,  1804,
     667,  2084,  1246,  1269,   668,  2068,  1247,  1735,  1747,  2757,
     586,   567,   568,  2845,  1293,  2846,  2847,  1543,   728,  1544,
    2848,  2849,   729,  2850,   402,   567,   568,   403,  1293,   934,
    2851,  2852,   599,  1525,  1782,  1789,  1803,   587,   883,  2853,
    2060,   571,   404,   569,   658,   614,   570,  2029,  1886,   659,
    1888,  2030,  1925,   116,  1926,   839,   840,   117,   841,   588,
    2198,  2199,  1549,   658,   118,   119,  1936,   934,   659,  2342,
    1877,  2071,  1876,   839,   840,   570,   841,  2658,  2211,  2921,
    2922,  1951,  1364,   658,   837,   660,   884,   589,   659,  2923,
     658,  2662,  1383,   590,   885,   659,  1384,  1615,  1616,   591,
    2280,  2281,  2282,  1676,   660,  1694,  1917,  1310,  1718,  1626,
    1948,  1378,  1311,  1312,   617,  1632,  1633,   770,   771,   772,
     773,  3201,  1734,  1640,   660,  1642,  1643,   592,   600,   886,
    2283,   660,  1648,  3220,  3144,  3145,  3146,  1872,  2358,  1652,
    1653,  1913,  1879,   593,  1768,   635,   636,  2284,   725,   637,
     726,  1656,  1657,   727,  2285,  1453,   594,  1660,  1661,  1310,
    1663,   568,  2240,  2101,  1311,  2016,   595,   596,   990,   991,
     597,   598,  2567,   658,  1677,  2575,   839,   840,   659,   841,
     618,  2567,  2575,  1393,  1831,  2311,  2312,  2125,   615,   729,
    3131,  2132,   616,  1839,  1840,  1720,  1841,  1842,  1843,  1844,
     770,   771,   772,   773,  1749,   619,   554,   599,  1853,  1750,
    2269,   555,  2270,  1918,   660,  1892,  1893,   638,   567,   568,
     945,   946,   643,  1214,  1215,   556,  1216,   557,   658,   645,
    1217,  2286,   664,   659,  2287,  2288,  2434,   665,  2435,  1819,
   -1014,   666,  2289,  2319,   673,   567,   568,   558,  1293,  1826,
    2328,   675,   192,   196,   677,   770,   771,   772,   773,   194,
     195,   683,  1218,  1955,  1649,  3086,  1651,  3087,   707,   660,
     709,   567,   568,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
    3114,   662,   663,  3117,  3118,  3119,   694,  1077,  1078,  1079,
    1294,   417,   702,   992,   307,   923,   924,   708,    92,    93,
     839,   840,  1590,   841,   199,   200,   710,   201,   202,   203,
     204,   205,  1080,  1081,   762,   763,  1082,   602,   925,   601,
     802,   803,   570,  1729,   926,  2618,   711,  2232,   578,   579,
     580,   581,   559,  2102,   560,   720,  1730,  2102,   570,   860,
     861,   658,   570,   712,  1873,  1874,   659,  1875,  2350,   714,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   723,   770,   771,
     772,   773,  2074,   395,   216,   396,  1101,  1102,   510,   397,
     398,   724,   660,   405,  1917,  1583,   512,  1691,   400,   833,
     513,  1692,  3173,   731,   395,   736,   396,  1103,  1104,   743,
     397,   398,   931,   514,   751,  1913,  1731,  1732,   401,   400,
     -82,   -82,   515,   -82,  1727,  1728,   105,   106,   107,   108,
     109,   110,   759,   111,   764,   775,   923,   924,   765,   401,
    2373,  1863,  1864,   766,  3196,  3197,  2280,  2281,  2282,  3198,
    3199,  1943,  1944,   768,   402,  1978,   767,   403,   784,   925,
    2097,  2098,  2099,  2100,  1581,   926,  1994,   780,  2037,   783,
     815,   785,  1997,  2066,  2067,   402,  2283,   510,   403,  1582,
     786,   834,   932,  1917,  1583,   512,  2267,  2268,  1733,   513,
    2389,  2390,   788,  2284,  2496,  2497,   789,   864,   974,   792,
    2285,   793,   514,   294,   874,  2751,  2752,  2569,  2570,  2571,
    2572,   515,  2753,  2754,  2755,  2756,  1877,   794,  1876,   800,
     922,   570,   795,  1591,  2561,  2562,  1592,  1593,   633,   634,
     635,   636,   909,   801,   637,   912,   295,   914,   296,   818,
     510,   816,  1582,   823,   923,   924,  3219,  1583,   512,  2038,
    2045,   555,   513,  2280,  2281,  2506,  2507,   595,   596,   990,
     991,   597,   297,  2059,   298,   514,   299,   925,   817,  2195,
     829,  2637,  2638,   926,   515,   832,   972,  2286,   975,   830,
    2287,  2288,   831,  3228,  2073,  2207,   852,  2508,  2289,   836,
     927,  2770,  2771,   196,  2902,  2903,   928,   853,   599,   856,
     555,  2144,   857,  2145,   858,  2863,  1693,  2945,  2946,  2947,
    2948,  2949,   859,  2455,  2456,   862,  2458,  2459,  2392,  2393,
    2394,   863,  2233,  1457,  1458,  2523,   658,  2337,  2338,  2117,
     866,   659,   865,  2119,   867,   889,  2508,   868,  2395,  2396,
    2397,   869,   196,   887,   877,   300,   301,   302,  2134,   303,
     304,   878,   888,   891,   199,   200,   893,   201,   202,   203,
     204,   205,   895,  1001,  1001,  2141,  2201,   660,   894,   901,
    2202,  2203,   896,   897,   213,    92,    93,   900,   902,   905,
    2499,  1001,  2950,  2951,  2952,  2953,  2954,   903,   904,   923,
     924,   906,   910,   907,  2392,  2393,  2394,   915,   913,  2557,
    1597,   918,   919,   199,   200,   934,   201,   202,   203,   204,
     205,   920,   925,   936,  2395,  2396,  2397,   937,   926,   938,
     939,  2036,   940,   213,  1450,   941,  1451,  1452,  2398,  2399,
     478,   942,   943,   944,  2411,   927,   949,   950,  2102,   951,
     965,   928,   973,   570,   952,   953,   967,   970,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   968,   196,   977,  1917,   971,
     978,   395,   983,   396,   979,  2225,   980,   397,   398,   984,
    2229,   996,  1598,   997,  2231,   754,   400,   998,  1002,   637,
    1005,  1006,  1007,   105,   106,   107,   108,   109,   110,  2619,
     111,   395,  1028,   396,  2398,  2399,   401,   397,   398,  1035,
    2470,  1036,  1037,  1085,  1086,  1089,   400,  1093,  2258,  1098,
    2260,  1242,  1100,   405,  1107,  1108,  1135,   199,   200,  1148,
     201,   202,   203,   204,   205,  1151,   401,  2274,  1153,  1174,
    1154,  1155,   402,  1156,   405,   403,  1157,  1158,  2714,  1159,
    1261,  1161,   658,  1162,  2611,  1270,  1271,   659,   595,   596,
     990,   991,   597,  1163,  2512,  1280,   923,   924,  1169,  1172,
    1286,  1192,   402,  1193,  1194,   403,  1198,  1212,  1236,   770,
     771,   772,   773,  1210,   931,  1211,  1254,  1255,  2444,   925,
    1314,  1256,  2482,   660,  1257,   926,  1320,  1258,  1322,   599,
    1324,  1325,  1273,  1327,  1328,  1329,  1330,  1331,   923,   924,
    1334,  1335,   927,  1337,  1264,  1265,  1340,  1341,   928,  1621,
    2344,  2345,  1346,  1272,  1348,  2348,  2715,  2478,  1599,  1274,
    2481,   925,  2352,  1275,  1277,  2353,  1279,   926,  1281,  2419,
    2420,  1284,  1278,  1362,  1365,  1366,  1285,  1287,  1367,  1288,
    1289,  1291,  1292,  1296,   932,  1313,  1316,  1323,  1001,  1317,
    1326,  2370,  2371,  1319,  2372,  1332,  2374,  1333,   621,   622,
     623,   624,   625,  2379,   479,  1385,  1336,  1338,  1339,  2451,
    1342,  1343,   480,  1347,  1344,  1345,  1354,  1391,   626,   627,
     628,   629,   630,   631,   632,   633,   634,   635,   636,  1359,
    1374,   637,  2400,  1368,   955,  1405,  1406,  1404,  2400,  1408,
    1413,  1381,  1917,  1417,  1418,  1419,   555,  1420,  2603,  1427,
    1435,  1438,  1440,  1445,  1446,  1447,  2731,  2767,  2768,  2769,
    1448,  1460,   595,   596,   990,   991,   597,   598,  1449,  1461,
    2732,  1462,  1470,  1484,  1485,  2733,  1486,  1489,  1522,  1523,
    1528,  1530,  2469,  1532,  1534,  1539,  1541,  1547,   196,  1562,
    2734,   754,   754,  1565,   754,   754,  1563,  1577,   754,  1579,
    2464,   754,  2441,  1441,   555,  1580,  2466,  1586,  2467,  1587,
    1294,  1294,  1588,  1617,  1613,   481,   482,   483,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,  1614,  1618,   602,   602,   601,
     601,  1619,   570,   570,  1624,  1625,   196,  1627,  1628,   199,
     200,  2600,   201,   202,   203,   204,   205,  1629,   754,  2500,
    1630,  1631,  1638,  1639,  1641,  1644,   604,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,  1645,  1654,  1658,   754,  1659,  1662,
    1664,  1665,  2735,  1666,   595,   596,   990,   991,   597,   598,
    1668,  2280,  2281,  1669,  1670,  1671,  1672,   199,   200,  1673,
     201,   202,   203,   204,   205,  2470,  1674,  1678,  1679,  1680,
    1682,  3056,  1683,  1688,  1684,  1689,  1690,  1721,  1725,  2512,
    1726,  2283,  1765,  1807,  1769,   599,  1773,  1812,  2549,  1809,
    2552,   405,  1810,  2602,  1813,  2604,  1816,  1821,  1824,  1832,
    2736,  1827,  1792,  1833,  1854,  1852,  1793,  1855,  1856,  1859,
    1860,    92,    93,  1868,  1865,  1869,  2613,  1870,  1882,  1871,
    1880,   405,  2560,   621,   622,   623,   624,   625,  2568,  1881,
    1887,  1889,  1890,  1891,  1920,  1919,  1794,  1921,  1924,  2512,
    1939,  1937,  1942,   626,   627,   628,   629,   630,   631,   632,
     633,   634,   635,   636,  1945,  2640,   637,  1938,  1947,  2737,
    2738,  2739,  1958,  1959,  1917,  1917,  1960,  1946,  1974,  1952,
    1964,  2740,  1975,  2741,  1961,  2742,  1965,  1976,  1977,  1969,
    1620,  1622,   754,  2743,  2744,  1979,  1996,  1980,  1981,  2010,
    1991,   373,   374,  2745,  1995,  1998,  1636,  1637,  2442,  1999,
    3098,  3099,  2004,  3101,  3102,  2005,  2007,   395,  2008,   396,
    2009,  2012,  2013,   397,   398,  2017,  2018,  2019,  2020,  2021,
    2022,   375,   400,  2023,  2024,  2025,  2026,  2027,  2031,   105,
     106,   107,   108,   109,   110,  2032,   111,  2035,  2034,  2033,
    2039,  2041,   401,  2040, -1015, -1015, -1015,  2043,  2650,  2042,
    1675,   376,  2044,  2046,  2047,  2057,  2058,  1681,  2063,  2064,
    2065,  1685,  1686,  1687, -1015, -1015, -1015, -1015, -1015,   631,
     632,   633,   634,   635,   636,  2069,  2075,   637,   402,  2076,
    2694,   403,  2087,  2400,  2093,  2400,  2094,  2096,  2102,  2113,
    3191,  3192,  2112,   570,  2120,  2118,  2122,  2121,  2111,  1771,
    2124,  1795,  2126,  2133,  1796,  2970,  2971,  2972,  2973,  2974,
    2975,  2976,  2977,  2137,  2136,  2143,  2182,  1820,   377,  1822,
    3202,  2189,  2188,  2190,   378,  2191,  2193,  2192,   379,  2194,
     604,   604,   721,   754,  2200,  2205,  3175,  2206,  2208,  2210,
    2214,  2215,  2217,  2218,  2219,  2750,  2226,  2243,  2223,  2224,
    2227,  2228,   380,  2230,  2251,   754,   754,   754,  2259,  2261,
    2263,  2250,  2271,  2257,  2777,  2272,  1917,  2266,  2273,  2783,
    2916,  2262,  2275,  2788,  2276,  2277,  2278,  2297,  2306,  2316,
    2323,  2321,  2322,  2331,  2339,  2329,  2819,  2332,  1797,  2369,
    2822,  2823,  2330,  2827,  2341,  2830,  2347,  2349,  2351,  2367,
    1798,  2354,  2375,  1792,  2381,  2355,  2385,  2388,  3075,  2391,
    2413,  2405,  2418,  2421,  3082,  2425,  2427,  2898,  2432,  2899,
    2900,  2901,  1799,  2439,  2453,  2454,  2474,  2463,  2457,  2460,
    2468,  2486,  2488,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
    2146,  2487,  2919,  2491,  2489,  2515,  2924,  2516,  2926,  2522,
    2483,  2147,  2148,  2149,  2150,   381,  2151,  2152,  2153,  2485,
    2495,  2154,   382,  2155,  2156,   383,  2498,  2513,   384,  2157,
    2158,  2957,  2958,  2526,  2159,  2528,  2532,  2517,  2529,  1940,
    1941,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,  2333,  2527,
    2537,  2545,  2550,  2978,  2554,  2556,  2558,  2982,  2983,  2984,
    2559,  2564,  2576,  2579,   385,  2580,  2585,  2996,  2588,  2999,
    2589,  3002,  2592,  2595,  2597,  2601,  2443,  3006,  2607,  2608,
    2609,  2610,  1993,  2612,  2614,  2620,  2634,  2635,  2648,  3008,
    3009,  2636,  2639,  3010,  3011,  2146,   386,  2006,  2652,  2651,
    2700,  2703,  2704,  2706,  2709,  3093,  2147,  2148,  2149,  2150,
    2688,  2151,  2152,  2153,  2711,  2712,  2154,  3037,  2155,  2156,
    2727,  2760,  3037,   387,  2157,  2158,  2713,  3045,  2763,  2166,
    2761,  3049,  2764,  2765,  2766,  1800,  2773,  2821,  2782,  2831,
    1801,  2832,  1802,  2828,  3070,  2837,  2904,  2028,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,  2905,   333,
     334,   335,   336,   337,   338,   339,  2906,  2908,  2907,  2909,
     388,  2050,  2051,  2053,  2054,  2910,  2913,  2917,  2918,  2927,
    1917,  2925,  2920,  2955,  2929,  2061,  2062,   405,   754,   754,
    2943,   754,   754,  3103,  3104,  2934,  3106,  3107,  3108,  3109,
    3110,  2944,  2928,  2833,  2956,  2935,  2959,  2961,  2964,  2965,
    1535,  2966,  2082,  2981,  2085,  2512,  2980,  2993,  2979,  2092,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
    2986,   333,   334,   335,   336,   337,   338,   339,  3005,  2997,
    3003,  3217,  3218,  2994,  3004,  2116,  3007,  3127,  3128,  3129,
    3020,  3025,  3012,  3023,  3027,  3026,  3028,  3029,  3133,  3134,
    3031,  3033,  3034,  3040,  3137,  2362,  3044,  3062,  3052,  3064,
    3071,  3050,  3063,  3065,  3066,  3072,  3073,  3148,  3074,  3078,
    3151,  3152,  3153,  3080,  3083,  3084,  3081,  3157,  3158,  3085,
    3092,  3111,  3100,  3112,   341,  3113,  3123,  3166,  3115,  3116,
    3120,  3121,  3143,  3139,  3142,  3150,  3155,  3154,  3159,  3183,
    3184,  3169,  3187,  3170,  3171,  3172,  3189,  3188,  3221,  3204,
    3224,  3226,  3222,  3225,   754,  3176,  3177,  3178,  3229,  1477,
     180,  1478,   181,   182,   183,   184,   185,   186,  2234,  1479,
    2135,   187,   188,  2127,  3227,  3185,  3186,  2762,  2696,  2167,
    2168,   189,   190,  1021,  3216,  2169,   191,  2170,  2414,  2697,
    2695,  2415,  2436,  2416,  1767,  3088,   341,  1011,   192,  2209,
    1442,   582,  1443,   193,  3089,   194,   195,  1444,   993,   196,
    2433,  2606,   500,  1950,  1858,   744,  1861,  2960,  2969,  2222,
    2779,  1106,  2730,  1970,  2477,  2617,  1655,  2490,  2479,  2524,
    2656,  2540,  3149,  3206,  3207,  3014,  3039,  3161,  3042,  2376,
    3163,  3209,  3043,  2380,  2216,  3211,  1402,  1922,     0,     0,
    3213,     0,     0,  1170,     0,  3214,     0,     0,     0,     0,
       0,     0,  2256,     0,   197,   198,   578,   579,   580,   581,
     199,   200,     0,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,     0,   211,     0,   212,     0,     0,     0,
     213,     0,     0,     0,     0,   214,     0,     0,   215,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2296,     0,     0,   180,     0,   181,   182,   183,
     184,   185,   186,  2313,  2314,  2315,   187,   188,     0,  2320,
     216,     0,     0,     0,     0,     0,   189,   190,     0,     0,
       0,   191,     0,     0,   180,     0,   181,   182,   183,   184,
     185,   186,     0,   192,     0,   187,   188,     0,   193,     0,
     194,   195,     0,     0,   196,   189,   190,  1845,     0,  2346,
     191,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   192,     0,     0,     0,     0,   193,     0,   194,
     195,     0,     0,   196,     0,     0,     0,     0,     0,  2366,
       0,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,     0,   333,   334,   335,   336,   337,   338,   339,   197,
     198,   578,   579,   580,   581,   199,   200,     0,   201,   202,
     203,   204,   205,   206,   207,   208,   209,   210,     0,   211,
       0,   212,     0,     0,     0,   213,     0,     0,   197,   198,
     214,     0,     0,   215,   199,   200,     0,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,     0,   211,     0,
     212,     0,     0,     0,   213,     0,     0,     0,     0,   214,
       0,     0,   215,     0,   180,   216,   181,   182,   183,   184,
     185,   186,     0,     0,     0,   187,   188,     0,     0,     0,
       0,     0,     0,     0,     0,   189,   190,  1849,     0,     0,
     191,     0,     0,     0,   216,     0,     0,     0,     0,     0,
       0,     0,   192,     0,     0,     0,     0,   193,     0,   194,
     195,  2476,   340,   196,     0,     0,     0,   323,   324,   325,
     326,   327,   328,   329,   330,   331,   332,   341,   333,   334,
     335,   336,   337,   338,   339,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1055,     0,     0,     0,     0,     0,
    2494,  1056,  1057,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   217,   218,     0,     0,     0,     0,   197,   198,
       0,     0,     0,     0,   199,   200,     0,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,     0,   211,     0,
     212,  2530,     0,     0,   213,     0,     0,  2531,     0,   214,
       0,     0,   215,     0,     0,     0,     0,     0,     0,  2535,
     180,     0,   181,   182,   183,   184,   185,   186,     0,     0,
       0,   187,   188,     0,     0,     0,     0,     0,     0,     0,
       0,   189,   190,  2423,   216,     0,   191,     0,     0,     0,
       0,     0,     0,  2553,     0,     0,     0,     0,   192,     0,
       0,     0,     0,   193,     0,   194,   195,     0,     0,   196,
       0,     0,     0,   341,     0,     0,     0,     0,     0,  1058,
    1059,  1060,  1061,  1062,  1063,     0,  1064,     0,     0,     0,
       0,     0,     0,     0,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   197,   198,     0,   217,   218,     0,
     199,   200,     0,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,     0,   211,     0,   212,     0,     0,     0,
     213,     0,     0,     0,     0,   214,   217,   218,   215,     0,
       0,     0,     0,  2622,  1065,  1066,  1067,  1068,  1069,  1070,
    1071,  1072,  1073,  1074,  1075,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     216,     0,   621,   622,   623,   624,   625,     0,     0,     0,
       0,     0,     0,     0,  2649,     0,     0,     0,    92,    93,
    2653,     0,   626,   627,   628,   629,   630,   631,   632,   633,
     634,   635,   636,     0,     0,   637,     0,     0,     0,     0,
       0,     0,     0,  1774,     0,     0,     0,     0,     0,     0,
       0,     0,  1008,     0,     0,  1775,     0,     0,     0,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,  1009,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,     0,   217,   218,  2748,     0,
       0,     0,     0,     0,   395,     0,   396,     0,     0,     0,
     397,   398,     0,     0,     0,  1776,     0,     0,     0,   400,
       0,     0,     0,     0,     0,     0,   105,   106,   107,   108,
     109,   110,     0,   111,     0,     0,     0,     0,     0,   401,
       0,     0,  2818,   180,  2820,   181,   182,   183,   184,   185,
     186,     0,     0,     0,   187,   188,     0,     0,  2834,  2835,
    2836,     0,     0,     0,   189,   190,  2428,     0,     0,   191,
       0,     0,     0,     0,     0,   402,     0,     0,   403,     0,
       0,   192,   621,   622,   623,     0,   193,     0,   194,   195,
       0,     0,   196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   626,   627,   628,   629,   630,   631,   632,   633,
     634,   635,   636,     0,     0,   637,     0,     0,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,     0,     0,     0,     0,     0,
       0,     0,   217,   218,     0,     0,     0,   197,   198,     0,
       0,     0,     0,   199,   200,     0,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,     0,   211,     0,   212,
       0,     0,     0,   213,     0,     0,     0,  2985,   214,     0,
       0,   215,     0,  2995,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   216,   180,     0,   181,   182,   183,   184,
     185,   186,     0,     0,  3024,   187,   188,     0,     0,     0,
       0,     0,     0,     0,     0,   189,   190,  2430,     0,     0,
     191,     0,     0,     0,     0,     0,  3046,     0,     0,     0,
    3051,     0,   192,     0,     0,     0,     0,   193,     0,   194,
     195,     0,     0,   196,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3097,     0,     0,     0,     0,     0,     0,
       0,     0,  3105,     0,     0,     0,     0,     0,   197,   198,
       0,     0,     0,     0,   199,   200,     0,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,     0,   211,     0,
     212,     0,     0,     0,   213,     0,     0,     0,     0,   214,
       0,     0,   215,     0,     0,     0,     0,  3122,     0,     0,
       0,     0,     0,     0,     0,  1777,  1778,     0,  1779,     0,
       0,  3130,  3132,  1780,  1781,     0,     0,     0,  3135,  3136,
       0,     0,  3138,     0,   216,     0,     0,     0,     0,   180,
       0,   181,   182,   183,   184,   185,   186,     0,     0,     0,
     187,   188,     0,  3156,     0,     0,     0,  3160,     0,  3162,
     189,   190,     0,     0,     0,   191,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3167,  3168,   192,     0,     0,
       0,     0,   193,     0,   194,   195,     0,     0,   196,     0,
    3174,     0,     0,     0,   405,     0,     0,  3179,     0,  3180,
    3181,  3182,     0,     0,   620,     0,     0,     0,     0,   621,
     622,   623,   624,   625,     0,   217,   218,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3195,   626,
     627,   628,   629,   630,   631,   632,   633,   634,   635,   636,
       0,     0,   637,   197,   198,     0,     0,     0,     0,   199,
     200,  3200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,     0,   211,     0,   212,     0,  3205,     0,   213,
       0,     0,     0,     0,   214,     0,     0,   215,   621,   622,
     623,   624,   625,  3212,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3215,     0,     0,     0,     0,   626,   627,
     628,   629,   630,   631,   632,   633,   634,   635,   636,   216,
       0,   637,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   186,     0,     0,     0,     0,  1414,     0,
       0,     0,     0,     0,     0,     0,     0,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   196,     0,     0,     0,     0,
       0,     0,   186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1895,   217,   218,  1896,  1897,
    1898,  1899,  1900,  1901,  1902,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,     0,   333,   334,   335,   336,
     337,   338,   339,  1903,   196,     0,  1904,  1905,     0,     0,
       0,     0,     0,     0,     0,     0,   199,   200,     0,   201,
     202,   203,   204,   205,  1895,     0,     0,  1896,  1897,  1898,
    1899,  1900,  1901,  1902,     0,     0,     0,  1906,     0,  1907,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1903,     0,     0,  1904,  1905,     0,     0,     0,
       0,     0,     0,     0,     0,   199,   200,     0,   201,   202,
     203,   204,   205,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1906,     0,  1907,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   488,   489,   621,   622,   623,
     624,   625,     0,    92,    93,     0,     0,     0,     0,     0,
       0,   341,     0,     0,     0,     0,     0,   626,   627,   628,
     629,   630,   631,   632,   633,   634,   635,   636,   490,     0,
     637,   217,   218,     0,   621,   622,   623,   624,   625,     0,
       0,     0,     0,     0,     0,     0,     0,  1835,     0,     0,
       0,     0,     0,     0,   626,   627,   628,   629,   630,   631,
     632,   633,   634,   635,   636,     0,     0,   637,     0,     0,
       0,  1836,     0,     0,     0,   417,     0,     0,     0,     0,
       0,     0,    92,    93,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,   396,     0,     0,     0,   397,   398,   523,  1429,     0,
       0,     0,     0,     0,   400,   621,   622,   623,   624,   625,
       0,   105,   106,   107,   108,   109,   110,     0,   111,     0,
       0,     0,     0,     0,   401,   626,   627,   628,   629,   630,
     631,   632,   633,   634,   635,   636,     0,     0,   637,     0,
       0,     0,     0,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     402,     0,     0,   403,   417,     0,   418,     0,   395,     0,
     396,   419,   420,     0,   397,   398,   491,     0,     0,  1430,
       0,     0,     0,   400,     0,   621,   622,   623,   624,   625,
     105,   106,   107,   108,   109,   110,   421,   111,     0,     0,
       0,     0,     0,   401,   422,   626,   627,   628,   629,   630,
     631,   632,   633,   634,   635,   636,     0,     0,   637,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   492,     0,     0,     0,     0,     0,   402,
       0,     0,   403,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   524,     0,     0,     0,     0,   525,     0,  1431,
       0,     0,     0,     0,     0,     0,     0,   395,     0,   396,
       0,     0,  2866,   397,   398,     0,   423,     0,   424,     0,
       0,     0,   400,   425,     0,     0,     0,     0,     0,   426,
     427,   428,   429,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   401,   430,     0,     0,  2867,   431,     0,   432,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,     0,   402,     0,
       0,   403,     0,     0,     0,     0,     0,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,     0,     0,     0,
       0,   436,     0,     0,     0,     0,     0,     0,     0,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,     0,   526,   493,   494,
     495,   496,  2790,     0,     0,     0,     0,   437,     0,     0,
     438,     0,     0,     0,   439,   440,     0,  2791,     0,     0,
       0,     0,     0,     0,    92,    93,   497,  2280,  2281,  2868,
       0,   498,     0,     0,     0,     0,   499,     0,     0,     0,
       0,   441,     0,     0,     0,   442,     0,   443,     0,  1785,
     444,     0,     0,     0,     0,   445,   446,  2283,   447,   448,
       0,     0,   449,     0,     0,     0,     0,     0,   450,   451,
       0,   452,   453,     0,     0,   454,  2869,     0,     0,     0,
     455,   456,   457,     0,     0,     0,   458,   459,     0,     0,
       0,  1697,     0,     0,   460,     0,   461,     0,     0,   462,
     463,  1698,   464,     0,   465,     0,     0,   466,   467,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     395,  1699,   396,   468,     0,   469,   397,   398,  2280,  2281,
       0,  1786,     0,   470,  2870,   400,     0,  2871,     0,   405,
       0,     0,   105,   106,   107,   108,   109,   110,     0,   111,
       0,     0,     0,     0,     0,   401,     0,  2872,  2283,  2873,
    2874,     0,     0,  2875,     0,     0,     0,     0,     0,  2876,
       0,     0,  1700,     0,     0,     0,  2792,  2793,  2794,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   402,     0,     0,   403,     0,     0,   510,     0,  1582,
       0,     0,     0,     0,  1701,  1702,     0,     0,     0,   513,
    2877,     0,     0,     0,     0,     0,     0,     0,   405,  2795,
       0,     0,   514,   621,   622,   623,   624,   625,     0,     0,
       0,   515,     0,     0,     0,     0,     0,  2796,     0,     0,
       0,     0,  2797,   626,   627,   628,   629,   630,   631,   632,
     633,   634,   635,   636,  2798,     0,   637,     0,  2799,     0,
    2800,  2801,     0,     0,     0,     0,     0,     0,     0,     0,
    2802,     0,     0,  2803,     0,  1703,     0,  1704,     0,  1705,
       0,     0,  1706,     0,     0,  1109,  1707,     0,     0,     0,
       0,  2878,     0,     0,     0,     0,     0,  1432,     0,     0,
     567,   568,   945,   946,     0,     0,     0,     0,     0,     0,
       0,  2804,     0,     0,  2879,     0,     0,   405,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   192,     0,     0,     0,     0,     0,
       0,   194,   195,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1708,     0,     0,     0,     0,     0,  1709,     0,
       0,     0,     0,     0,  2880,  2881,  2882,  2883,  2884,     0,
    2885,     0,     0,  2886,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2805,
       0,     0,  2806,  2807,  2808,     0,     0,  1110,  1111,     0,
    2809,     0,     0,     0,  1710,  2810,     0,     0,     0,     0,
       0,  1711,  1712,     0,     0,  2811,     0,     0,  1713,     0,
       0,  2812,  1112,   924,     0,     0,     0,     0,     0,     0,
    1714,     0,     0,     0,     0,     0,  1715,     0,     0,     0,
    1113,  1716,     0,     0,     0,  1114,     0,  1787,  1717,  1115,
    1116,     0,     0,     0,  1117,     0,   621,   622,   623,   624,
     625,     0,     0,     0,     0,     0,   216,     0,     0,     0,
       0,     0,     0,     0,     0,  1118,   626,   627,   628,   629,
     630,   631,   632,   633,   634,   635,   636,     0,     0,   637,
     621,   622,   623,   624,   625,     0,  1788,     0,  1119,  1120,
    1121,     0,  1122,  1123,  1124,     0,     0,     0,     0,     0,
     626,   627,   628,   629,   630,   631,   632,   633,   634,   635,
     636,     0,     0,   637,   621,   622,   623,   624,   625,     0,
    1834,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   626,   627,   628,   629,   630,   631,
     632,   633,   634,   635,   636,     0,     0,   637,     0,     0,
     405,     0,     0,     0,  2172,     0,   621,   622,   623,   624,
     625,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     621,   622,   623,   624,   625,     0,   626,   627,   628,   629,
     630,   631,   632,   633,   634,   635,   636,     0,  2173,   637,
     626,   627,   628,   629,   630,   631,   632,   633,   634,   635,
     636,     0,     0,   637,     0,     0,  1428,   621,   622,   623,
     624,   625,     0,     0,     0,     0,     0,     0,     0,     0,
    1433,   621,   622,   623,   624,   625,     0,   626,   627,   628,
     629,   630,   631,   632,   633,   634,   635,   636,     0,     0,
     637,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,     0,     0,   637,     0,     0,  1434,   621,   622,
     623,   624,   625,     0,     0,     0,     0,     0,     0,     0,
       0,  1439,   621,   622,   623,   624,   625,     0,   626,   627,
     628,   629,   630,   631,   632,   633,   634,   635,   636,     0,
       0,   637,   626,   627,   628,   629,   630,   631,   632,   633,
     634,   635,   636,     0,     0,   637,     0,     0,  1465,   621,
     622,   623,   624,   625,     0,     0,     0,     0,     0,     0,
       0,     0,  1542,   621,   622,   623,   624,   625,     0,   626,
     627,   628,   629,   630,   631,   632,   633,   634,   635,   636,
       0,     0,   637,   626,   627,   628,   629,   630,   631,   632,
     633,   634,   635,   636,     0,     0,   637,     0,     0,  1923,
     621,   622,   623,   624,   625,     0,     0,     0,     0,     0,
       0,     0,     0,  2174,   621,   622,   623,   624,   625,     0,
     626,   627,   628,   629,   630,   631,   632,   633,   634,   635,
     636,     0,     0,   637,   626,   627,   628,   629,   630,   631,
     632,   633,   634,   635,   636,     0,     0,   637,     0,     0,
    2175,   621,   622,   623,   624,   625,     0,     0,     0,     0,
       0,     0,     0,     0,  2176,   621,   622,   623,   624,   625,
       0,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,     0,     0,   637,   626,   627,   628,   629,   630,
     631,   632,   633,   634,   635,   636,     0,     0,   637,     0,
       0,  2177,   621,   622,   623,   624,   625,     0,     0,     0,
       0,     0,     0,     0,     0,  2386,   621,   622,   623,   624,
     625,     0,   626,   627,   628,   629,   630,   631,   632,   633,
     634,   635,   636,     0,     0,   637,   626,   627,   628,   629,
     630,   631,   632,   633,   634,   635,   636,     0,     0,   637,
       0,     0,  2387,   621,   622,   623,   624,   625,     0,     0,
       0,     0,     0,     0,     0,     0,  2577,   621,   622,   623,
     624,   625,     0,   626,   627,   628,   629,   630,   631,   632,
     633,   634,   635,   636,     0,     0,   637,   626,   627,   628,
     629,   630,   631,   632,   633,   634,   635,   636,     0,     0,
     637,     0,     0,  2578,   621,   622,   623,   624,   625,     0,
       0,     0,     0,     0,     0,     0,     0,  2729,   621,   622,
     623,   624,   625,     0,   626,   627,   628,   629,   630,   631,
     632,   633,   634,   635,   636,     0,     0,   637,   626,   627,
     628,   629,   630,   631,   632,   633,   634,   635,   636,     0,
       0,   637,     0,     0,  2772,   621,   622,   623,   624,   625,
       0,     0,     0,     0,     0,     0,     0,     0,  3190,   621,
     622,   623,   624,   625,     0,   626,   627,   628,   629,   630,
     631,   632,   633,   634,   635,   636,     0,     0,   637,   626,
     627,   628,   629,   630,   631,   632,   633,   634,   635,   636,
       0,     0,   637,  1529,   621,   622,   623,   624,   625,     0,
       0,     0,     0,     0,     0,     0,     0,  2440,   621,   622,
     623,   624,   625,     0,   626,   627,   628,   629,   630,   631,
     632,   633,   634,   635,   636,     0,     0,   637,   626,   627,
     628,   629,   630,   631,   632,   633,   634,   635,   636,     0,
       0,   637,  2605,   621,   622,   623,   624,   625,     0,     0,
       0,     0,     0,     0,     0,     0,  2726,     0,     0,     0,
       0,     0,     0,   626,   627,   628,   629,   630,   631,   632,
     633,   634,   635,   636,     0,     0,   637
};

static const yytype_int16 yycheck[] =
{
     112,   180,   215,   185,   116,   185,   215,  1054,   185,   366,
     367,  1535,   446,   447,   493,     3,    89,  1823,   269,   777,
     502,    94,    95,   160,     7,   168,   169,   917,   168,   169,
    1112,    97,  2293,   215,   512,   215,   842,   846,   215,   586,
     587,    57,  2688,  1435,  1436,  1437,  1438,   150,    74,   152,
     674,    87,   674,    87,   272,   158,   291,   160,     9,    10,
      28,    12,    95,    87,    87,   168,   169,    18,   615,   616,
     524,   172,    87,   176,   554,  1779,   556,   557,    24,  2206,
     560,   561,   706,  1165,   163,     6,    19,   305,  2064,  2065,
    2066,    24,  1894,    24,    22,    55,    24,    28,   349,   350,
     351,    24,   143,    87,   145,    28,   147,    72,   149,   210,
     151,    87,   153,    96,   155,   202,   157,  2230,  2495,  2599,
     161,   176,   163,    19,   165,    19,   167,    60,    24,   165,
      24,    95,   165,   174,   175,   171,    19,  1127,   163,   257,
      56,    24,    55,    57,  2599,    55,    57,   398,    55,   204,
     205,     6,    46,    47,    48,    49,    21,    22,   174,    24,
      87,   206,   245,   325,    60,    87,    60,   222,    55,    24,
     158,     7,   246,    53,    28,   167,    87,    60,    58,    59,
     245,    76,    77,   295,   296,   297,   298,   299,   300,   301,
      24,   303,   304,    55,    28,     6,    19,    42,   229,   286,
      19,    24,    19,  2316,   248,    24,   242,    24,   191,    60,
     193,   234,    56,   249,   250,   251,    10,    72,   254,    94,
     674,    24,   258,   169,    55,   280,   138,    46,    47,    48,
      49,    62,    63,    10,    87,    87,   252,    60,     3,     4,
       5,    60,   140,    60,   289,   318,   133,   158,   419,   160,
     334,   363,   163,   164,   165,   172,    87,  2801,     0,   170,
     171,   391,   173,    76,   175,    86,   172,    61,   292,   342,
      53,   198,    58,    24,    87,    58,    59,   188,     6,   247,
     181,  2163,   193,   357,   396,   201,   197,  2169,   400,   768,
     402,    85,   180,   181,   204,   368,   206,   370,  2599,  1823,
     922,   345,    39,   158,   155,   158,   172,   160,    85,   931,
     393,   164,   165,   281,    21,    22,   169,    24,   229,   431,
     173,   232,   273,   274,     6,   235,   324,   158,   393,   160,
    2874,    53,   242,   164,   165,   465,    58,    59,   252,   501,
     193,   236,   173,   289,   210,   166,   559,   199,   355,   180,
     181,   182,   183,   184,   185,   166,   187,   201,  2334,     6,
     282,   282,   193,   166,   535,   372,   373,  2628,   277,   400,
     204,   281,   473,   283,   339,   554,   229,   556,   557,   232,
     145,   560,   561,   740,   294,   239,   419,   379,  1912,  2766,
     301,   938,    19,   248,   304,    24,    24,    24,   229,    28,
     165,   232,   324,   950,   221,   142,   318,   321,   492,   424,
     324,   320,    24,   340,   245,   166,    28,   312,   328,    46,
      47,    48,    49,   780,   341,   859,   327,  2688,   193,   194,
       6,   391,   455,    60,  2914,   341,   515,  1195,   326,  2241,
     424,   328,   543,   352,   679,   680,   681,   682,    24,   684,
     685,   338,   687,   688,    87,   690,   691,   366,   367,  2914,
     172,  1351,   896,   461,   428,   230,  2170,   232,   922,   234,
     401,   302,   590,   238,   305,  2602,  2603,   931,   391,   354,
     245,   515,   507,   296,   391,   736,    87,   521,   486,  1111,
     515,   515,    93,   338,   390,  1485,  1486,   372,   513,  2612,
     355,   516,   517,   518,   379,   592,   593,   594,   595,   596,
     143,   144,   992,   546,   477,   280,     6,   397,   398,   284,
     483,   955,    28,   957,   550,   158,   291,   160,    24,   391,
      24,   164,   165,   431,    28,   590,   445,   193,   484,   177,
     173,   330,   175,   408,   454,   174,   579,   580,   581,   582,
     583,   497,   498,   339,   166,   477,   473,   158,   467,   160,
     193,   416,   598,   164,   165,   195,   129,   473,   169,   358,
     546,   547,   173,   359,   360,   558,   552,   593,  3224,   507,
      86,   514,   694,   599,   403,  1394,   293,   496,    56,   572,
     702,  2542,   193,    47,   488,   233,   229,   480,   481,   232,
      39,   510,   457,    41,   316,   588,   589,   590,   591,   592,
     593,   594,  2913,  2914,   397,   398,   599,   585,    56,  1166,
     588,   589,   532,  2599,   187,    93,   535,   260,   229,  3011,
     517,   232,    86,   842,   489,  2441,   748,     6,   621,   622,
     623,   624,   625,   626,   627,   628,   629,   630,   631,   632,
     633,   634,   635,   636,   720,   578,   479,  1111,    99,  1741,
     842,   584,   842,   586,  2615,   842,   294,   295,    87,    87,
     166,    87,   166,  2197,   597,   397,   398,   660,  2654,   554,
     555,   556,   557,   558,  2566,  2567,   451,   598,    85,   599,
     253,   159,  2574,  2575,    24,    25,   326,   648,   649,   262,
     651,   652,    61,   142,   334,   284,  2657,    24,    25,     6,
      47,   784,   166,   276,   277,   278,   279,   829,   294,   295,
     761,    85,     6,    85,   172,   355,    85,    24,   559,   560,
      85,   714,   173,   201,   335,   336,   337,  1361,  2689,   207,
     327,   292,   343,   159,   345,   598,   729,    99,    19,    86,
     169,   604,   179,    24,    10,   174,   242,    31,   226,   156,
     387,    45,   210,   945,   356,   945,  3148,   598,   945,  3151,
     172,    55,   603,   604,   605,    59,    24,    25,    62,    63,
     198,   199,    59,    76,    77,    59,   898,   899,  2180,    60,
    2182,   207,   156,  2185,   156,  2187,  2188,    19,    76,    77,
     227,   156,    24,   712,    88,    61,   208,    60,   717,    86,
     228,   403,    85,   992,    87,  1028,  1029,    24,    57,   452,
     453,    28,  1031,   153,    46,    47,    48,    49,   246,   166,
     325,   740,   318,   420,   421,    10,   601,   602,    60,   287,
     749,    85,   751,    47,  1323,    85,    24,    87,    87,  1031,
      28,  1031,     6,   294,  1031,    60,   351,   298,   106,   143,
      99,   145,   146,   282,   427,   149,    59,   151,  1962,   166,
     167,   780,   169,  1967,   158,   186,   160,   161,   162,   231,
     366,   165,    86,   180,   181,    19,    61,   241,   374,   307,
      24,   245,    85,   802,   803,  1373,   180,   181,   182,   183,
     184,   185,   159,   187,  1382,   301,   322,  2713,  2714,  1144,
     154,  1146,    46,    47,    48,    49,    10,  2441,  1136,  1137,
    1138,  1139,   340,  1141,  1142,   193,    60,  1145,  1110,  1147,
    1110,  1149,  1150,  1413,  2644,   174,  1416,   600,  2914,   341,
     342,   119,    61,   236,   853,    10,    19,   856,   232,   301,
     221,    24,    24,  1759,   238,    19,    28,   167,   236,   166,
     244,   245,   166,  3224,    19,   598,    85,    61,   531,    24,
     180,   181,    10,    46,    47,    48,    49,   294,   295,   398,
      24,    19,    38,    39,    28,   189,    24,    60,   166,   143,
     144,    46,    47,    48,    49,   349,    61,   598,   352,    59,
      38,   417,    40,   242,   913,    60,   422,   423,   424,   248,
     175,   920,  2106,   252,   410,   411,   412,   413,   927,   312,
    2114,   175,    60,   932,  1007,    85,  1009,   936,    66,   250,
      86,  1510,    14,    15,   312,  1514,  1515,   334,     6,   336,
     459,   338,   208,   209,   462,   463,   464,   201,    61,   215,
     216,   217,   218,   231,    53,  1167,    24,   476,    61,   478,
      59,   970,    86,   482,   973,  2775,  2776,   486,   487,    86,
    2780,  2781,    85,    24,   983,   119,   428,   178,   430,   161,
     432,  1193,    85,   435,    19,    20,    21,    22,    23,   127,
     128,    31,   130,   131,   132,   133,   134,    14,    15,    98,
    1212,    59,    41,    85,    44,   206,  1089,    62,    63,  2915,
    1222,  1177,  1252,    61,  1251,    66,    41,   155,  1191,   157,
      88,   142,   166,   257,    19,    60,   336,    85,    19,    24,
     160,    21,    87,    24,    24,    86,    87,    85,    89,    90,
      91,    92,    93,    94,    95,    50,    51,    52,  1251,  1252,
    1253,    46,    47,    48,    49,    46,    47,    48,    49,    19,
     242,   243,   244,   114,    24,    60,   117,   118,    85,    60,
      24,    25,   394,   395,  1608,   143,   127,   128,  2068,   130,
     131,   132,   133,   134,    24,    25,    60,   231,   289,  2713,
    2714,  2583,    19,   161,   162,  1742,  2588,   148,  2590,   150,
      60,  2593,   257,   158,   241,   160,    86,   175,   245,   164,
     165,   241,   242,   314,   169,   245,    56,  1360,   173,    21,
      22,    23,    24,  1296,  1702,   180,   181,   182,   183,   184,
     185,    19,   187,    21,  1413,  1218,    24,  1416,   193,    87,
      86,    19,    20,    21,    22,    23,    24,  1387,  1388,  1389,
      24,   324,    83,   387,    28,  1737,    87,  1360,  1361,   425,
      60,    21,    22,   502,    24,   504,   505,    85,    56,    87,
     509,   510,    60,   512,   229,    21,    22,   232,    24,    24,
     519,   520,    60,    28,  1387,  1388,  1389,    60,   318,   528,
    1724,  1473,   247,  1473,    19,    19,  1473,   293,  1516,    24,
    1518,   297,    85,   587,    87,    21,    22,   591,    24,    60,
    1896,  1897,  1221,    19,   598,   599,  1567,    24,    24,  2077,
    1502,    28,  1502,    21,    22,  1502,    24,    87,  1914,   309,
     310,  1582,   387,    19,    59,    60,   366,    60,    24,   319,
      19,    87,   932,    60,   374,    24,   936,  1256,  1257,    60,
     198,   199,   200,    59,    60,  1349,  1535,    53,  1352,  1268,
    1578,    47,    58,    59,    57,  1274,  1275,    46,    47,    48,
      49,    87,  1360,  1282,    60,  1284,  1285,    60,   156,   409,
     228,    60,  1291,  3189,   524,   525,   526,  1499,    86,  1298,
    1299,  2915,  1504,    60,  1377,    40,    41,   245,    19,    44,
      21,  1310,  1311,    24,   252,  2452,    60,  1316,  1317,    53,
    1319,    22,  1959,    24,    58,    59,    19,    20,    21,    22,
      23,    24,  2406,    19,  1333,  2409,    21,    22,    24,    24,
      19,  2415,  2416,    28,  1417,   330,   331,  1798,    60,    60,
     331,  1802,    60,  1426,  1427,  1354,  1429,  1430,  1431,  1432,
      46,    47,    48,    49,  1363,    57,    19,    60,  1441,  1368,
      85,    24,    87,  1536,    60,  1531,  1532,    44,    21,    22,
      23,    24,     6,    21,    22,    38,    24,    40,    19,    28,
      28,   329,     6,    24,   332,   333,    59,     6,    61,  1398,
      86,   299,   340,  2040,     6,    21,    22,    60,    24,  1408,
    2047,     6,    55,    66,    24,    46,    47,    48,    49,    62,
      63,   348,    60,  1586,  1295,  2907,  1297,  2909,   308,    60,
     310,    21,    22,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   572,   573,   574,   575,   576,   577,
    2961,   240,   241,  2964,  2965,  2966,   166,   177,   178,   179,
    1759,    55,   288,   156,    28,   143,   144,     6,    62,    63,
      21,    22,    87,    24,   127,   128,     6,   130,   131,   132,
     133,   134,   202,   203,   455,   456,   206,  1759,   166,  1759,
     359,   360,  1759,    87,   172,    87,     6,  1944,   123,   124,
     125,   126,   155,  1775,   157,    19,   100,  1779,  1775,   364,
     365,    19,  1779,   535,    21,    22,    24,    24,  2087,    31,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   572,   573,   574,   575,   576,   577,    24,    46,    47,
      48,    49,  1744,   158,   187,   160,    51,    52,   163,   164,
     165,    24,    60,   598,  1823,   170,   171,    83,   173,   245,
     175,    87,   331,    59,   158,   242,   160,    51,    52,    59,
     164,   165,   119,   188,   246,  3189,   170,   171,   193,   173,
      21,    22,   197,    24,   446,   447,   180,   181,   182,   183,
     184,   185,    86,   187,   533,   397,   143,   144,    24,   193,
    2124,    21,    22,    56,  3115,  3116,   198,   199,   200,  3120,
    3121,   259,   260,   159,   229,  1614,    86,   232,   600,   166,
     191,   192,   193,   194,    87,   172,  1625,   257,   175,   248,
     432,    59,  1631,   449,   450,   229,   228,   163,   232,   165,
      86,   443,   189,  1912,   170,   171,   436,   437,   242,   175,
      72,    73,    59,   245,   330,   331,    59,   459,   166,    86,
     252,    86,   188,   143,   466,   208,   209,    78,    79,    80,
      81,   197,   215,   216,   217,   218,  1948,    86,  1948,    59,
     119,  1948,    86,   298,    14,    15,   301,   302,    38,    39,
      40,    41,   494,    28,    44,   497,   176,   499,   178,   248,
     163,   392,   165,    86,   143,   144,  3188,   170,   171,   256,
    1709,    24,   175,   198,   199,    28,    29,    19,    20,    21,
      22,    23,   202,  1722,   204,   188,   206,   166,   193,  1892,
     400,   210,   211,   172,   197,   369,   538,   329,   540,   325,
     332,   333,   349,  3225,  1743,  1908,   344,    60,   340,   418,
     189,   210,   211,    66,  2701,  2702,   195,   257,    60,   257,
      24,  1834,   349,  1836,   305,    29,   292,   210,   211,   212,
     213,   214,   334,  2220,  2221,   364,  2223,  2224,    11,    12,
      13,   160,  1945,  1087,  1088,  2309,    19,  2065,  2066,  1788,
     305,    24,   376,  1792,   305,    86,    60,   382,    31,    32,
      33,   380,    66,    59,   405,   285,   286,   287,  1807,   289,
     290,   344,    59,    86,   127,   128,    59,   130,   131,   132,
     133,   134,   311,  1896,  1897,  1824,  1899,    60,    86,    59,
    1903,  1904,   334,   334,   147,    62,    63,   445,    86,   496,
    2287,  1914,   210,   211,   212,   213,   214,    86,    86,   143,
     144,   193,   158,   398,    11,    12,    13,   391,   159,  2383,
      87,    59,    86,   127,   128,    24,   130,   131,   132,   133,
     134,   499,   166,   189,    31,    32,    33,   230,   172,   175,
      59,   175,    59,   147,    24,    86,    26,    27,   121,   122,
      87,    86,    86,    86,  2164,   189,   248,   175,  2170,    59,
      86,   195,   257,  2170,    59,    59,   193,   175,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   572,
     573,   574,   575,   576,   577,   386,    66,    59,  2197,   330,
      59,   158,   257,   160,    86,  1934,    86,   164,   165,    59,
    1939,    18,   169,    19,  1943,  1944,   173,    19,    38,    44,
      39,    19,    85,   180,   181,   182,   183,   184,   185,  2483,
     187,   158,    10,   160,   121,   122,   193,   164,   165,    19,
    2239,    56,    19,     6,     6,   237,   173,     6,  1977,     6,
    1979,   783,    28,   598,     6,     6,     6,   127,   128,     6,
     130,   131,   132,   133,   134,     6,   193,  1996,     6,    60,
       6,     6,   229,     6,   598,   232,     6,     6,     9,     6,
     812,     6,    19,     6,  2461,   817,   818,    24,    19,    20,
      21,    22,    23,     6,  2293,   827,   143,   144,     6,     6,
     832,    59,   229,    85,    85,   232,    59,   400,    24,    46,
      47,    48,    49,    59,   119,    59,   392,   193,  2204,   166,
     852,   257,  2254,    60,   257,   172,   858,    59,   860,    60,
     862,   863,   193,   865,   866,   867,   868,   869,   143,   144,
     872,   873,   189,   875,    59,    59,   878,   879,   195,    86,
    2079,  2080,   884,   392,   886,  2084,    87,  2250,   315,   257,
    2253,   166,  2091,   257,    59,  2094,   233,   172,   242,  2172,
    2173,   257,   255,   905,   906,   907,   257,    59,   910,    59,
      86,   419,    59,    42,   189,    59,   257,   159,  2191,   257,
      59,  2120,  2121,   257,  2123,   399,  2125,    58,    11,    12,
      13,    14,    15,  2132,   331,   937,    59,    59,    58,  2212,
     392,   255,   339,   242,   193,   233,   189,   949,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,   119,
      24,    44,  2161,   189,   354,   967,   968,    59,  2167,   311,
      19,   196,  2441,    85,    61,   142,    24,    39,  2447,    85,
      85,    85,    19,    61,    61,    58,    53,  2634,  2635,  2636,
      22,     6,    19,    20,    21,    22,    23,    24,    58,     6,
      67,     6,     6,    24,   175,    72,   175,    24,     6,     6,
       6,    61,    60,    16,    59,    24,    59,    53,    66,    59,
      87,  2220,  2221,    86,  2223,  2224,    59,    39,  2227,    85,
    2229,  2230,   115,    60,    24,    59,  2235,   293,  2237,    59,
    2539,  2540,    86,    59,   393,   442,   443,   444,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   572,
     573,   574,   575,   576,   577,   257,    59,  2539,  2540,  2539,
    2540,    59,  2539,  2540,   193,   257,    66,    59,    59,   127,
     128,  2444,   130,   131,   132,   133,   134,    59,  2287,  2288,
     393,   257,    59,   255,    59,    59,  2599,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,   572,   573,
     574,   575,   576,   577,     8,    59,    59,  2316,    59,    59,
      59,    59,   189,    59,    19,    20,    21,    22,    23,    24,
      59,   198,   199,    59,    59,    59,    59,   127,   128,    59,
     130,   131,   132,   133,   134,  2614,    59,    59,    59,    59,
      59,  2875,    59,    59,   245,   255,    59,    59,    59,  2628,
      59,   228,    59,    55,   190,    60,    59,    55,  2367,    59,
    2369,   598,    59,  2446,    19,  2448,    19,    28,   189,    39,
     247,    86,    53,    39,    19,    85,    57,    41,    19,     6,
       6,    62,    63,     6,    24,     6,  2469,     6,    19,     6,
       6,   598,  2401,    11,    12,    13,    14,    15,  2407,     6,
       6,     6,     6,     6,    61,    59,    87,    85,    19,  2688,
     259,   256,   256,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,   600,  2508,    44,   255,    28,   306,
     307,   308,    46,   175,  2713,  2714,   303,    59,   344,    59,
     158,   318,   346,   320,    59,   322,    59,    59,   257,   598,
    1262,  1263,  2461,   330,   331,    85,   257,    59,    59,    87,
      59,   167,   168,   340,    59,    59,  1278,  1279,    86,    59,
    2927,  2928,    59,  2930,  2931,    59,    59,   158,    59,   160,
      59,    59,    59,   164,   165,    59,    59,    59,    59,    59,
      59,   197,   173,    59,   193,    59,    59,    59,    24,   180,
     181,   182,   183,   184,   185,    59,   187,   386,   313,   241,
     392,   193,   193,   175,    11,    12,    13,   241,  2527,   339,
    1332,   227,    67,   371,   175,    59,    59,  1339,    23,   449,
     449,  1343,  1344,  1345,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    59,   138,    44,   229,    59,
    2559,   232,   248,  2562,    59,  2564,   490,    59,  2840,    59,
    3094,  3095,   529,  2840,   538,    59,   195,   538,   178,  1381,
     334,   252,    57,    59,   255,   465,   466,   467,   468,   469,
     470,   471,   472,    41,    85,    39,    85,  1399,   294,  1401,
    3124,    19,    85,    19,   300,    60,     6,    22,   304,     6,
    2913,  2914,   106,  2612,    60,    60,  3063,    60,    87,    59,
      59,    19,    59,    59,   290,  2624,    87,   159,   257,   257,
     257,   171,   328,   257,    86,  2634,  2635,  2636,    59,   189,
     434,   600,    59,   347,  2643,    59,  2915,   433,    59,  2648,
    2723,   438,    59,  2652,    86,    59,    59,    59,   392,   257,
     313,    67,   392,    59,    23,   386,  2665,    59,   339,   189,
    2669,  2670,    67,  2672,   356,  2674,    86,    86,    86,    72,
     351,    86,    76,    53,    19,    86,    39,    68,  2890,    75,
      59,    43,    59,    40,  2896,    40,    10,  2696,    87,  2698,
    2699,  2700,   373,    24,    61,    59,    86,   256,    59,    59,
      59,    59,   429,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   572,   573,   574,   575,   576,   577,
      53,    59,  2731,    59,   285,    59,  2735,    59,  2737,   416,
     339,    64,    65,    66,    67,   441,    69,    70,    71,   330,
      86,    74,   448,    76,    77,   451,   331,    86,   454,    82,
      83,  2760,  2761,   193,    87,   313,   313,   393,   393,  1571,
    1572,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,   572,   573,   574,   575,   576,   577,    60,   257,
      86,    86,    86,  2792,    86,    86,    59,  2796,  2797,  2798,
      10,    85,    84,    61,   500,    61,    61,  2806,    60,  2808,
      61,  2810,    61,    61,    61,   119,    24,  2816,    59,    59,
      59,    59,  1624,   257,    85,   336,   332,   332,   257,  2828,
    2829,   332,   208,  2832,  2833,    53,   532,  1639,   257,   152,
      41,    19,    40,    40,    10,  2918,    64,    65,    66,    67,
     530,    69,    70,    71,    87,    59,    74,  2856,    76,    77,
      59,   159,  2861,   559,    82,    83,   116,  2866,    59,    87,
     159,  2870,    59,    87,    59,   546,    28,    59,    87,    59,
     551,   515,   553,   325,  2883,    59,    61,  1689,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,    61,   107,
     108,   109,   110,   111,   112,   113,    61,    61,    85,    60,
     606,  1713,  1714,  1715,  1716,    61,    10,    61,    85,   332,
    3189,   248,   313,   426,    67,  1727,  1728,   598,  2927,  2928,
      59,  2930,  2931,  2932,  2933,   323,  2935,  2936,  2937,  2938,
    2939,    59,   332,   515,    59,   311,    59,    59,    59,    59,
      86,    59,  1754,    86,  1756,  3224,   493,   467,   248,  1761,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     311,   107,   108,   109,   110,   111,   112,   113,    59,   325,
     133,  3183,  3184,   382,   465,  1787,    59,  2986,  2987,  2988,
     508,   506,   501,   501,   511,   257,   313,   339,  2997,  2998,
     339,   529,    59,    59,  3003,    28,    59,   382,   311,   133,
     540,   257,   257,   257,   257,   542,   545,  3016,    59,    59,
    3019,  3020,  3021,   549,    59,    41,   548,  3026,  3027,    41,
      59,   317,   313,    59,   242,    59,   494,  3036,    59,    59,
      59,    59,   257,   523,   332,   257,   503,   332,   189,   199,
     199,  3050,    61,  3052,  3053,  3054,   120,    85,    59,   479,
     530,    59,   474,    85,  3063,  3064,  3065,  3066,    61,  1110,
      17,  1110,    19,    20,    21,    22,    23,    24,  1948,  1110,
    1812,    28,    29,  1800,  3224,  3084,  3085,  2628,  2563,  1838,
    1838,    38,    39,    40,   479,  1838,    43,  1838,  2167,  2564,
    2562,  2168,  2197,  2169,  1376,  2913,   242,   585,    55,  1912,
    1028,   193,  1029,    60,  2914,    62,    63,  1031,   559,    66,
    2191,  2452,   158,  1579,  1455,   362,  1463,  2766,  2782,  1931,
    2645,   669,  2614,  1607,  2249,  2477,  1309,  2269,  2251,  2310,
    2536,  2349,  3017,  3142,  3143,  2840,  2857,  3030,  2860,  2128,
    3032,  3150,  2861,  2136,  1925,  3154,   964,  1543,    -1,    -1,
    3159,    -1,    -1,   709,    -1,  3164,    -1,    -1,    -1,    -1,
      -1,    -1,  1974,    -1,   121,   122,   123,   124,   125,   126,
     127,   128,    -1,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,    -1,   141,    -1,   143,    -1,    -1,    -1,
     147,    -1,    -1,    -1,    -1,   152,    -1,    -1,   155,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2024,    -1,    -1,    17,    -1,    19,    20,    21,
      22,    23,    24,  2035,  2036,  2037,    28,    29,    -1,  2041,
     187,    -1,    -1,    -1,    -1,    -1,    38,    39,    -1,    -1,
      -1,    43,    -1,    -1,    17,    -1,    19,    20,    21,    22,
      23,    24,    -1,    55,    -1,    28,    29,    -1,    60,    -1,
      62,    63,    -1,    -1,    66,    38,    39,    40,    -1,  2081,
      43,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    55,    -1,    -1,    -1,    -1,    60,    -1,    62,
      63,    -1,    -1,    66,    -1,    -1,    -1,    -1,    -1,  2111,
      -1,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,    -1,   107,   108,   109,   110,   111,   112,   113,   121,
     122,   123,   124,   125,   126,   127,   128,    -1,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,    -1,   141,
      -1,   143,    -1,    -1,    -1,   147,    -1,    -1,   121,   122,
     152,    -1,    -1,   155,   127,   128,    -1,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,    -1,   141,    -1,
     143,    -1,    -1,    -1,   147,    -1,    -1,    -1,    -1,   152,
      -1,    -1,   155,    -1,    17,   187,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    28,    29,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    38,    39,    40,    -1,    -1,
      43,    -1,    -1,    -1,   187,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    55,    -1,    -1,    -1,    -1,    60,    -1,    62,
      63,  2243,   227,    66,    -1,    -1,    -1,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   242,   107,   108,
     109,   110,   111,   112,   113,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    55,    -1,    -1,    -1,    -1,    -1,
    2282,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   439,   440,    -1,    -1,    -1,    -1,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,    -1,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,    -1,   141,    -1,
     143,  2323,    -1,    -1,   147,    -1,    -1,  2329,    -1,   152,
      -1,    -1,   155,    -1,    -1,    -1,    -1,    -1,    -1,  2341,
      17,    -1,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    28,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    38,    39,    40,   187,    -1,    43,    -1,    -1,    -1,
      -1,    -1,    -1,  2375,    -1,    -1,    -1,    -1,    55,    -1,
      -1,    -1,    -1,    60,    -1,    62,    63,    -1,    -1,    66,
      -1,    -1,    -1,   242,    -1,    -1,    -1,    -1,    -1,   180,
     181,   182,   183,   184,   185,    -1,   187,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   572,   573,   574,   575,   576,
     577,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   121,   122,    -1,   439,   440,    -1,
     127,   128,    -1,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,    -1,   141,    -1,   143,    -1,    -1,    -1,
     147,    -1,    -1,    -1,    -1,   152,   439,   440,   155,    -1,
      -1,    -1,    -1,  2485,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     187,    -1,    11,    12,    13,    14,    15,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2526,    -1,    -1,    -1,    62,    63,
    2532,    -1,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    -1,    -1,    44,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    99,    -1,    -1,    -1,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
     572,   573,   574,   575,   576,   577,    85,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   572,
     573,   574,   575,   576,   577,    -1,   439,   440,  2620,    -1,
      -1,    -1,    -1,    -1,   158,    -1,   160,    -1,    -1,    -1,
     164,   165,    -1,    -1,    -1,   169,    -1,    -1,    -1,   173,
      -1,    -1,    -1,    -1,    -1,    -1,   180,   181,   182,   183,
     184,   185,    -1,   187,    -1,    -1,    -1,    -1,    -1,   193,
      -1,    -1,  2664,    17,  2666,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    28,    29,    -1,    -1,  2680,  2681,
    2682,    -1,    -1,    -1,    38,    39,    40,    -1,    -1,    43,
      -1,    -1,    -1,    -1,    -1,   229,    -1,    -1,   232,    -1,
      -1,    55,    11,    12,    13,    -1,    60,    -1,    62,    63,
      -1,    -1,    66,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    -1,    -1,    44,    -1,    -1,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   572,
     573,   574,   575,   576,   577,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   439,   440,    -1,    -1,    -1,   121,   122,    -1,
      -1,    -1,    -1,   127,   128,    -1,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,    -1,   141,    -1,   143,
      -1,    -1,    -1,   147,    -1,    -1,    -1,  2799,   152,    -1,
      -1,   155,    -1,  2805,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   187,    17,    -1,    19,    20,    21,    22,
      23,    24,    -1,    -1,  2846,    28,    29,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    38,    39,    40,    -1,    -1,
      43,    -1,    -1,    -1,    -1,    -1,  2868,    -1,    -1,    -1,
    2872,    -1,    55,    -1,    -1,    -1,    -1,    60,    -1,    62,
      63,    -1,    -1,    66,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   572,   573,   574,   575,   576,
     577,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2925,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2934,    -1,    -1,    -1,    -1,    -1,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,    -1,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,    -1,   141,    -1,
     143,    -1,    -1,    -1,   147,    -1,    -1,    -1,    -1,   152,
      -1,    -1,   155,    -1,    -1,    -1,    -1,  2979,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   519,   520,    -1,   522,    -1,
      -1,  2993,  2994,   527,   528,    -1,    -1,    -1,  3000,  3001,
      -1,    -1,  3004,    -1,   187,    -1,    -1,    -1,    -1,    17,
      -1,    19,    20,    21,    22,    23,    24,    -1,    -1,    -1,
      28,    29,    -1,  3025,    -1,    -1,    -1,  3029,    -1,  3031,
      38,    39,    -1,    -1,    -1,    43,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3047,  3048,    55,    -1,    -1,
      -1,    -1,    60,    -1,    62,    63,    -1,    -1,    66,    -1,
    3062,    -1,    -1,    -1,   598,    -1,    -1,  3069,    -1,  3071,
    3072,  3073,    -1,    -1,     6,    -1,    -1,    -1,    -1,    11,
      12,    13,    14,    15,    -1,   439,   440,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3100,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      -1,    -1,    44,   121,   122,    -1,    -1,    -1,    -1,   127,
     128,  3123,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,    -1,   141,    -1,   143,    -1,  3139,    -1,   147,
      -1,    -1,    -1,    -1,   152,    -1,    -1,   155,    11,    12,
      13,    14,    15,  3155,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3165,    -1,    -1,    -1,    -1,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,   187,
      -1,    44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    24,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,   572,   573,
     574,   575,   576,   577,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    -1,    -1,    -1,
      -1,    -1,    24,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,   439,   440,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,    -1,   107,   108,   109,   110,
     111,   112,   113,   114,    66,    -1,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   127,   128,    -1,   130,
     131,   132,   133,   134,    86,    -1,    -1,    89,    90,    91,
      92,    93,    94,    95,    -1,    -1,    -1,   148,    -1,   150,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   114,    -1,    -1,   117,   118,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   127,   128,    -1,   130,   131,
     132,   133,   134,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   148,    -1,   150,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   572,
     573,   574,   575,   576,   577,    54,    55,    11,    12,    13,
      14,    15,    -1,    62,    63,    -1,    -1,    -1,    -1,    -1,
      -1,   242,    -1,    -1,    -1,    -1,    -1,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    87,    -1,
      44,   439,   440,    -1,    11,    12,    13,    14,    15,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,
      -1,    85,    -1,    -1,    -1,    55,    -1,    -1,    -1,    -1,
      -1,    -1,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   158,
      -1,   160,    -1,    -1,    -1,   164,   165,    87,    85,    -1,
      -1,    -1,    -1,    -1,   173,    11,    12,    13,    14,    15,
      -1,   180,   181,   182,   183,   184,   185,    -1,   187,    -1,
      -1,    -1,    -1,    -1,   193,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    -1,    -1,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   572,   573,   574,   575,   576,   577,
     229,    -1,    -1,   232,    55,    -1,    57,    -1,   158,    -1,
     160,    62,    63,    -1,   164,   165,   245,    -1,    -1,    85,
      -1,    -1,    -1,   173,    -1,    11,    12,    13,    14,    15,
     180,   181,   182,   183,   184,   185,    87,   187,    -1,    -1,
      -1,    -1,    -1,   193,    95,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   302,    -1,    -1,    -1,    -1,    -1,   229,
      -1,    -1,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   242,    -1,    -1,    -1,    -1,   247,    -1,    85,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   158,    -1,   160,
      -1,    -1,    53,   164,   165,    -1,   167,    -1,   169,    -1,
      -1,    -1,   173,   174,    -1,    -1,    -1,    -1,    -1,   180,
     181,   182,   183,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   193,   194,    -1,    -1,    87,   198,    -1,   200,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   572,   573,   574,   575,   576,   577,    -1,   229,    -1,
      -1,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,    -1,    -1,   245,    -1,   247,    -1,    -1,    -1,
      -1,   252,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
     572,   573,   574,   575,   576,   577,    -1,   377,   457,   458,
     459,   460,    72,    -1,    -1,    -1,    -1,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    62,    63,   485,   198,   199,   200,
      -1,   490,    -1,    -1,    -1,    -1,   495,    -1,    -1,    -1,
      -1,   322,    -1,    -1,    -1,   326,    -1,   328,    -1,    87,
     331,    -1,    -1,    -1,    -1,   336,   337,   228,   339,   340,
      -1,    -1,   343,    -1,    -1,    -1,    -1,    -1,   349,   350,
      -1,   352,   353,    -1,    -1,   356,   247,    -1,    -1,    -1,
     361,   362,   363,    -1,    -1,    -1,   367,   368,    -1,    -1,
      -1,    57,    -1,    -1,   375,    -1,   377,    -1,    -1,   380,
     381,    67,   383,    -1,   385,    -1,    -1,   388,   389,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     158,    87,   160,   404,    -1,   406,   164,   165,   198,   199,
      -1,   169,    -1,   414,   305,   173,    -1,   308,    -1,   598,
      -1,    -1,   180,   181,   182,   183,   184,   185,    -1,   187,
      -1,    -1,    -1,    -1,    -1,   193,    -1,   328,   228,   330,
     331,    -1,    -1,   334,    -1,    -1,    -1,    -1,    -1,   340,
      -1,    -1,   138,    -1,    -1,    -1,   246,   247,   248,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   229,    -1,    -1,   232,    -1,    -1,   163,    -1,   165,
      -1,    -1,    -1,    -1,   170,   171,    -1,    -1,    -1,   175,
     381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   598,   289,
      -1,    -1,   188,    11,    12,    13,    14,    15,    -1,    -1,
      -1,   197,    -1,    -1,    -1,    -1,    -1,   307,    -1,    -1,
      -1,    -1,   312,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,   324,    -1,    44,    -1,   328,    -1,
     330,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     340,    -1,    -1,   343,    -1,   241,    -1,   243,    -1,   245,
      -1,    -1,   248,    -1,    -1,     6,   252,    -1,    -1,    -1,
      -1,   462,    -1,    -1,    -1,    -1,    -1,    85,    -1,    -1,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   381,    -1,    -1,   485,    -1,    -1,   598,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    55,    -1,    -1,    -1,    -1,    -1,
      -1,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   318,    -1,    -1,    -1,    -1,    -1,   324,    -1,
      -1,    -1,    -1,    -1,   535,   536,   537,   538,   539,    -1,
     541,    -1,    -1,   544,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   459,
      -1,    -1,   462,   463,   464,    -1,    -1,   118,   119,    -1,
     470,    -1,    -1,    -1,   370,   475,    -1,    -1,    -1,    -1,
      -1,   377,   378,    -1,    -1,   485,    -1,    -1,   384,    -1,
      -1,   491,   143,   144,    -1,    -1,    -1,    -1,    -1,    -1,
     396,    -1,    -1,    -1,    -1,    -1,   402,    -1,    -1,    -1,
     161,   407,    -1,    -1,    -1,   166,    -1,   485,   414,   170,
     171,    -1,    -1,    -1,   175,    -1,    11,    12,    13,    14,
      15,    -1,    -1,    -1,    -1,    -1,   187,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   196,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    -1,    -1,    44,
      11,    12,    13,    14,    15,    -1,   534,    -1,   219,   220,
     221,    -1,   223,   224,   225,    -1,    -1,    -1,    -1,    -1,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    -1,    44,    11,    12,    13,    14,    15,    -1,
      85,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,
     598,    -1,    -1,    -1,    85,    -1,    11,    12,    13,    14,
      15,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      11,    12,    13,    14,    15,    -1,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    -1,    85,    44,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    -1,    44,    -1,    -1,    61,    11,    12,    13,
      14,    15,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      61,    11,    12,    13,    14,    15,    -1,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    -1,    -1,
      44,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    -1,    -1,    44,    -1,    -1,    61,    11,    12,
      13,    14,    15,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    61,    11,    12,    13,    14,    15,    -1,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    -1,
      -1,    44,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    -1,    -1,    44,    -1,    -1,    61,    11,
      12,    13,    14,    15,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    61,    11,    12,    13,    14,    15,    -1,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      -1,    -1,    44,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,    61,
      11,    12,    13,    14,    15,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    61,    11,    12,    13,    14,    15,    -1,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    -1,    -1,    44,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    -1,    -1,    44,    -1,    -1,
      61,    11,    12,    13,    14,    15,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    61,    11,    12,    13,    14,    15,
      -1,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    -1,    -1,    44,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    -1,    44,    -1,
      -1,    61,    11,    12,    13,    14,    15,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    61,    11,    12,    13,    14,
      15,    -1,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    -1,    -1,    44,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    -1,    -1,    44,
      -1,    -1,    61,    11,    12,    13,    14,    15,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    61,    11,    12,    13,
      14,    15,    -1,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    -1,    -1,    44,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    -1,    -1,
      44,    -1,    -1,    61,    11,    12,    13,    14,    15,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,    11,    12,
      13,    14,    15,    -1,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    -1,    -1,    44,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    -1,
      -1,    44,    -1,    -1,    61,    11,    12,    13,    14,    15,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,    11,
      12,    13,    14,    15,    -1,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    -1,    -1,    44,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      -1,    -1,    44,    59,    11,    12,    13,    14,    15,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    59,    11,    12,
      13,    14,    15,    -1,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    -1,    -1,    44,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    -1,
      -1,    44,    59,    11,    12,    13,    14,    15,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    59,    -1,    -1,    -1,
      -1,    -1,    -1,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    -1,    -1,    44
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,     7,   612,   613,     3,     4,     5,   145,   165,   193,
     194,   230,   232,   234,   238,   245,   280,   284,   291,   451,
     601,   602,   608,   609,   610,   611,   806,   807,   808,   809,
     811,   812,   813,   820,   822,   823,   824,   825,   826,   827,
     828,   829,   830,   831,   832,   833,   835,   836,   837,   838,
     839,   840,   841,   843,   844,   845,   869,   888,   889,   890,
     891,   912,   945,   946,   947,   962,  1000,  1001,  1002,  1003,
    1004,  1005,  1006,  1007,  1059,  1060,  1093,  1118,  1119,  1120,
    1121,  1122,  1123,  1124,  1125,  1126,  1127,     0,     6,    45,
      55,    59,    62,    63,    88,   143,   145,   146,   149,   151,
     158,   160,   161,   162,   165,   180,   181,   182,   183,   184,
     185,   187,   232,   238,   244,   245,   587,   591,   598,   599,
     614,   615,   677,   679,   680,   681,   682,   695,   746,   748,
     749,   750,   751,   752,   753,   758,   772,   773,   785,   786,
     787,   848,   849,   870,   875,   878,   881,   892,   895,   914,
     922,   948,   950,   953,   956,   958,   961,   965,   966,  1009,
    1011,  1012,  1017,  1048,  1051,  1061,  1062,  1078,  1079,  1094,
    1098,  1107,  1108,  1114,  1130,  1135,  1136,     6,     6,     6,
      17,    19,    20,    21,    22,    23,    24,    28,    29,    38,
      39,    43,    55,    60,    62,    63,    66,   121,   122,   127,
     128,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   141,   143,   147,   152,   155,   187,   439,   440,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
     572,   573,   574,   575,   576,   577,   623,   624,   625,   626,
     627,   628,   629,   630,   631,   632,   633,   634,   635,   636,
     673,   674,   675,   702,   720,   722,   723,   726,   727,   728,
     732,   733,   745,  1096,    24,    28,   166,   819,   842,   846,
      24,   846,   846,   179,   227,   846,     6,    28,   239,   775,
     193,    55,   204,   206,   235,   242,   281,   283,   294,   304,
     328,   454,   532,   599,   143,   176,   178,   202,   204,   206,
     285,   286,   287,   289,   290,   846,   284,    28,   247,   281,
     585,   588,   589,  1128,     6,    24,    25,   618,   292,   618,
     153,   618,   732,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   107,   108,   109,   110,   111,   112,   113,
     227,   242,   683,    60,    60,   159,    24,    28,   646,   176,
     204,   205,   222,   280,   590,   186,   204,   646,   161,   242,
     243,   244,   774,  1097,   193,   646,   419,   535,   600,    19,
     175,   250,   754,   167,   168,   197,   227,   294,   300,   304,
     328,   441,   448,   451,   454,   500,   532,   559,   606,   964,
    1047,    56,   618,   759,    87,   158,   160,   164,   165,   169,
     173,   193,   229,   232,   247,   598,   750,   760,   761,   767,
     789,    86,   852,   759,   759,   759,   759,    55,    57,    62,
      63,    87,    95,   167,   169,   174,   180,   181,   182,   183,
     194,   198,   200,   241,   245,   247,   252,   288,   291,   295,
     296,   322,   326,   328,   331,   336,   337,   339,   340,   343,
     349,   350,   352,   353,   356,   361,   362,   363,   367,   368,
     375,   377,   380,   381,   383,   385,   388,   389,   404,   406,
     414,   760,   860,   861,   925,   936,   944,   759,    87,   331,
     339,   442,   443,   444,   760,   759,   759,   759,    54,    55,
      87,   245,   302,   457,   458,   459,   460,   485,   490,   495,
     751,   760,   968,   969,   970,   971,   972,    86,    57,    87,
     163,   170,   171,   175,   188,   197,   301,   760,   762,   759,
     759,   759,   759,    87,   242,   247,   377,   760,   767,   860,
    1083,  1085,    87,   245,   302,   305,   559,   560,   603,   604,
     605,   760,   767,   860,  1095,  1133,  1134,   759,   759,    87,
     169,   604,   760,  1137,    19,    24,    38,    40,    60,   155,
     157,   719,   721,   745,    41,   622,    41,    21,    22,   623,
     624,   625,    60,   142,    39,   142,   732,    19,   123,   124,
     125,   126,   708,   732,    86,    86,    60,    60,    60,    60,
      60,    60,    60,    60,    60,    19,    20,    23,    24,    60,
     156,   623,   625,   633,   702,   703,   704,   707,   709,   710,
     711,   714,   716,   717,    19,    60,    60,    57,    19,    57,
       6,    11,    12,    13,    14,    15,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    44,    44,    47,
      86,   166,   790,     6,   790,    28,   647,   647,   119,   231,
     846,   119,   231,   846,    47,    86,   166,   793,    19,    24,
      60,   616,   240,   241,     6,     6,   299,    24,    28,   166,
     847,     6,   282,     6,   814,     6,   821,    24,   810,   178,
     206,   289,   314,   348,   169,   289,   484,   497,   498,   810,
     206,   289,     6,   166,   166,   646,   646,   646,   646,   646,
     646,   646,   288,   646,   646,   647,   963,  1128,     6,  1128,
       6,     6,   535,  1129,    31,   618,   696,   616,   678,   684,
      19,   106,   618,    24,    24,    19,    21,    24,    56,    60,
     747,    59,   790,   790,   790,   616,   242,    47,    86,   166,
     189,  1115,   793,    59,   775,   578,   584,   586,   597,   646,
    1101,   246,  1109,  1110,   616,   617,   617,   618,   618,    86,
     757,  1010,   455,   456,   533,    24,    56,    86,   159,   646,
      46,    47,    48,    49,   616,   619,   790,   788,   174,   646,
     257,   646,   793,   248,   600,    59,    86,   765,    59,    59,
     851,   853,    86,    86,    86,    86,   241,   245,   246,   357,
      59,    28,   359,   360,    55,   391,    55,   391,    55,   391,
      55,   391,   330,   358,   646,   619,   392,   193,   248,   241,
     245,   349,   352,    86,   933,   242,   318,   366,   374,   400,
     325,   349,   369,   245,   619,   923,   418,    59,   616,    21,
      22,    24,   293,   620,   916,   408,   620,   915,   172,   210,
     287,   920,   344,   257,   325,   351,   257,   349,   305,   334,
     364,   365,   364,   160,   619,   376,   305,   305,   382,   380,
      58,   339,   359,   360,   619,   390,   616,   405,   344,   160,
     241,   242,   245,   318,   366,   374,   409,    59,    59,    86,
     865,    86,   942,    59,    86,   311,   334,   334,   229,   400,
     445,    59,    86,    86,    86,   496,   193,   398,   747,   619,
     158,   616,   619,   159,   619,   391,   967,   765,    59,    86,
     499,   616,   119,   143,   144,   166,   172,   189,   195,   692,
     769,   119,   189,   769,    24,   768,   189,   230,   175,    59,
      59,    86,    86,    86,    86,    23,    24,   636,   640,   248,
     175,    59,    59,    59,    94,   354,   372,   379,   554,   555,
     556,   557,   558,  1080,  1081,    86,  1091,   193,   386,   616,
     175,   330,   619,   257,   166,   619,  1131,    59,    59,    86,
      86,  1138,  1142,   257,    59,    10,   721,   721,   721,   732,
      21,    22,   156,   714,   721,   721,    18,    19,    19,   724,
     725,   732,    38,    39,   142,    39,    19,    85,    61,    85,
     670,   670,   768,   768,   732,   732,   732,   732,   732,   732,
     732,    40,   706,   708,   732,    38,    39,    86,    10,    85,
     156,    85,   156,   768,   768,    19,    56,    19,   732,   732,
     732,   732,   732,   732,   732,   732,   732,   732,   732,   732,
     732,   732,   732,   732,   729,    55,    62,    63,   180,   181,
     182,   183,   184,   185,   187,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   818,   177,   178,   179,
     202,   203,   206,   791,   792,     6,     6,   846,   846,   237,
     834,   846,   846,     6,   177,   233,   794,   795,     6,   732,
      28,    51,    52,    51,    52,   868,   847,     6,     6,     6,
     118,   119,   143,   161,   166,   170,   171,   175,   196,   219,
     220,   221,   223,   224,   225,   640,   692,   817,     6,    24,
      88,   143,   161,   162,   175,     6,   810,   810,   810,   810,
     913,   810,   810,  1008,   166,   810,   166,   810,     6,   810,
     810,     6,   646,     6,     6,     6,     6,     6,     6,     6,
     646,     6,     6,     6,     6,   143,   175,   201,   692,     6,
    1129,   616,     6,   732,    60,   686,   616,   687,   689,   694,
     129,   187,   253,   262,   276,   277,   278,   279,   427,   531,
     676,   683,    59,    85,    85,   782,   783,   732,    59,   790,
     202,   286,   592,   593,   594,   595,   596,  1116,  1117,   617,
      59,    59,   400,  1099,    21,    22,    24,    28,    60,   648,
    1102,   646,   616,  1100,    86,   166,  1104,   616,    59,    86,
      50,    51,    52,  1112,   756,   759,    24,   747,   776,   779,
     780,   617,   619,   618,   764,   766,    83,    87,   850,   854,
     855,   874,   880,   894,   392,   193,   257,   257,    59,   616,
     616,   619,    95,   428,    59,    59,   245,   393,   257,   387,
     619,   619,   392,   193,   257,   257,   934,    59,   255,   233,
     619,   242,   401,   646,   257,   257,   619,    59,    59,    86,
     805,   419,    59,    24,   633,   639,    42,   621,    53,    58,
      59,   397,   398,   301,   410,   411,   412,   413,   921,   621,
      53,    58,    59,    59,   619,   616,   257,   257,   616,   257,
     619,   620,   619,   159,   619,   619,    59,   619,   619,   619,
     619,   619,   399,    58,   619,   619,    59,   619,    59,    58,
     619,   619,   392,   255,   193,   233,   619,   242,   619,   864,
     866,   867,   941,   943,   189,   620,   949,   646,   646,   119,
     955,   960,   619,   257,   387,   619,   619,   619,   189,   616,
     766,   973,   616,   640,    24,   690,   691,   693,    47,   616,
     771,   196,   640,   771,   771,   619,   768,  1016,  1050,  1063,
    1084,   619,   768,    28,   620,   620,  1086,    55,   133,   328,
     338,   517,  1080,  1092,    59,   619,   619,   616,   311,   616,
     780,   781,   616,    19,    61,   721,   156,    85,    61,   142,
      39,   732,   732,   671,   672,    61,    85,    85,    61,    85,
      85,    85,    85,    61,    61,    85,    10,    85,    85,    61,
      19,    60,   704,   711,   716,    61,    61,    58,    22,    58,
      24,    26,    27,   727,   730,    85,    87,   834,   834,   732,
       6,     6,     6,    85,    87,    61,     6,    24,   294,   295,
       6,    21,    22,    23,    24,   623,   625,   626,   627,   628,
     815,   816,   640,   690,    24,   175,   175,    24,   166,    24,
     819,   647,   647,   647,   647,     6,    24,   166,   167,   169,
     180,   181,   334,   336,   338,   647,   647,     6,    24,    72,
     158,   248,   355,   416,   457,   489,   810,   647,   810,   647,
     647,   647,     6,     6,   690,    28,   768,   646,     6,    59,
      61,   685,    16,   688,    59,    86,   683,   618,   646,    24,
     780,    59,    61,    85,    87,   646,   732,    53,  1103,   616,
     646,    95,   165,   419,   546,   579,   580,   581,   582,   583,
    1105,  1106,    59,    59,  1111,    86,    87,   165,   171,   242,
     249,   250,   251,   254,   258,   598,   755,    39,   778,    85,
      59,    87,   165,   170,   762,   763,   293,    59,    86,   858,
      87,   298,   301,   302,   760,   762,   871,    87,   169,   315,
     760,   767,   879,    87,    93,   169,   335,   336,   337,   343,
     345,   760,   893,   393,   257,   616,   616,    59,    59,    59,
     619,    86,   619,   917,   193,   257,   616,    59,    59,    59,
     393,   257,   616,   616,   932,   935,   619,   619,    59,   255,
     616,    59,   616,   616,    59,     8,   910,   924,   616,   916,
     618,   916,   616,   616,    59,   915,   616,   616,    59,    59,
     616,   616,    59,   616,    59,    59,    59,   747,    59,    59,
      59,    59,    59,    59,    59,   619,    59,   616,    59,    59,
      59,   619,    59,    59,   245,   619,   619,   619,    59,   255,
      59,    83,    87,   292,   763,   863,   766,    57,    67,    87,
     138,   170,   171,   241,   243,   245,   248,   252,   318,   324,
     370,   377,   378,   384,   396,   402,   407,   414,   763,   940,
     616,    59,    53,    59,    98,    59,    59,   446,   447,    87,
     100,   170,   171,   242,   750,   760,   860,   951,   952,   954,
      87,   143,   175,   260,   452,   453,   692,   760,   959,   616,
     616,    87,   169,   174,   282,   398,   459,   476,   478,   482,
     486,   487,   974,   981,   984,    59,   769,   689,   732,   190,
     770,   619,   769,    59,    87,    99,   169,   519,   520,   522,
     527,   528,   760,   767,  1013,    87,   169,   485,   534,   760,
     767,  1049,    53,    57,    87,   252,   255,   339,   351,   373,
     546,   551,   553,   760,   767,  1064,  1066,    55,  1082,    59,
      59,   621,    55,    19,  1087,  1088,    19,   642,   643,   616,
     619,    28,   619,  1090,   189,  1132,   616,    86,  1141,   721,
     721,   732,    39,    39,    85,    61,    85,   668,   669,   732,
     732,   732,   732,   732,   732,    40,   706,   732,   706,    40,
     706,   706,    85,   732,    19,    41,    19,   731,   792,     6,
       6,   795,    56,    21,    22,    24,   819,   819,     6,     6,
       6,     6,   646,    21,    22,    24,   623,   625,   641,   646,
       6,     6,    19,   747,   747,   747,   647,     6,   647,     6,
       6,     6,   683,   683,   697,    86,    89,    90,    91,    92,
      93,    94,    95,   114,   117,   118,   148,   150,   683,   698,
     699,   700,   701,   726,   734,   735,   737,   745,   618,    59,
      61,    85,  1117,    61,    19,    85,    87,    87,   234,   455,
      57,   174,   252,   593,   599,  1113,   790,   256,   255,   259,
     619,   619,   256,   259,   260,   600,    59,    28,   647,   777,
     779,   790,    59,   294,   295,   618,   857,   859,    46,   175,
     303,    59,   882,   887,   158,    59,   897,   898,   902,   598,
     898,   903,   620,   907,   344,   346,    59,   257,   616,    85,
      59,    59,    99,   231,   301,   428,   430,   432,   435,   918,
     919,    59,   387,   619,   616,    59,   257,   616,    59,    59,
      87,   199,   926,   931,    59,    59,   619,    59,    59,    59,
      87,   909,    59,    59,    59,    59,    59,    59,    59,    59,
      59,    59,    59,    59,   193,    59,    59,    59,   619,   293,
     297,    24,    59,   241,   313,   386,   175,   175,   256,   392,
     175,   193,   339,   241,    67,   616,   371,   175,   167,   379,
     619,   619,   403,   619,   619,   138,   318,    59,    59,   616,
     620,   619,   619,    23,   449,   449,   449,   450,   765,    59,
     690,    28,   768,   616,   646,   138,    59,   993,   999,   324,
     461,   486,   619,   976,   324,   619,   975,   248,   639,   977,
     978,   488,   619,    59,   490,   994,    59,   191,   192,   193,
     194,    24,   625,   638,  1027,  1032,  1018,  1026,  1014,  1015,
     638,   178,   529,    59,  1052,  1058,   619,   616,    59,   616,
     538,   538,   195,  1065,   334,  1065,    57,   648,  1067,    74,
     550,  1068,  1065,    59,   616,   643,    85,    41,    87,   737,
    1089,   616,  1140,    39,   732,   732,    53,    64,    65,    66,
      67,    69,    70,    71,    74,    76,    77,    82,    83,    87,
     654,   655,   656,   657,   658,   666,    87,   655,   656,   657,
     658,   667,    85,    85,    61,    61,    61,    61,    61,    85,
      10,    61,    85,    61,    85,    10,    61,    85,    85,    19,
      19,    60,    22,     6,     6,   618,   694,   738,   724,   724,
      60,   732,   732,   732,   740,    60,    60,   618,    87,   700,
      59,   724,    31,    44,    59,    19,  1106,    59,    59,   290,
     257,   590,   619,   257,   257,   616,    87,   257,   171,   616,
     257,   616,   617,   618,   641,    76,    87,   296,   856,   872,
     768,   873,   781,   159,   167,   180,   181,   336,   896,   781,
     600,    86,   901,    42,   338,   904,   619,   347,   616,    59,
     616,   189,   438,   434,   140,   431,   433,   436,   437,    85,
      87,    59,    59,    59,   616,    59,    86,    59,    59,    87,
     198,   199,   200,   228,   245,   252,   329,   332,   333,   340,
     796,   797,   799,   800,   801,   908,   619,    59,    24,   294,
     295,    99,   173,   294,   298,   862,   392,   195,   326,   334,
     355,   330,   331,   619,   619,   619,   257,   245,   393,   768,
     619,    67,   392,   313,   355,   372,   373,   939,   768,   386,
      67,    59,    59,    60,   155,   709,   957,   957,   957,    23,
     766,   356,   780,   995,   616,   616,   619,    86,   616,    86,
     747,    86,   616,   616,    86,    86,  1031,   781,    86,   620,
    1033,  1038,    28,    86,  1039,  1044,   619,    72,   781,   189,
     616,   616,   616,   620,   616,    76,  1066,  1069,  1074,   616,
    1087,    19,    87,   424,  1139,    39,    61,    61,    68,    72,
      73,    75,    11,    12,    13,    31,    32,    33,   121,   122,
     616,   652,   659,   660,   661,    43,   662,   663,   663,   665,
      24,   623,   637,    59,   659,   662,   665,   638,    59,   732,
     732,    40,   706,    40,   706,    40,   706,    10,    40,   706,
      40,   706,    87,   725,    59,    61,   698,    59,    59,    24,
      59,   115,    86,    24,   683,   736,   744,   744,    31,    59,
      59,   732,   743,    61,    59,   617,   617,    59,   617,   617,
      59,   617,   645,   256,   616,   645,   616,   616,    59,    60,
     745,   876,   877,   694,    86,   886,   619,   901,   618,   909,
     899,   618,   646,   339,   905,   330,    59,    59,   429,   285,
     919,    59,   929,   911,   619,    86,   330,   331,   331,   617,
     616,   172,   208,   341,   342,   900,    28,    29,    60,   650,
     651,   733,   745,    86,   804,    59,    59,   393,   394,   395,
     619,   937,   416,   620,   937,   645,   193,   257,   313,   393,
     619,   619,   313,   709,   713,   619,   996,    86,   998,   986,
     986,   979,   982,  1030,  1029,    86,  1025,  1034,  1040,   616,
      86,  1057,   616,   619,    86,  1070,    86,   620,    59,    10,
     616,    14,    15,   653,    85,    15,    85,   653,   616,    78,
      79,    80,    81,   664,    85,   653,    84,    61,    61,    61,
      61,    61,    85,    10,    61,    61,    61,    85,    60,    61,
      10,    61,    61,    10,    61,    61,   739,    61,   737,   718,
     618,   119,   732,   745,   732,    59,   730,    59,    59,    59,
      59,   617,   257,   732,    85,   885,   883,   899,    87,   620,
     336,   906,   619,    87,   159,   207,   322,   417,   422,   423,
     424,   927,   798,   799,   332,   332,   332,   210,   211,   208,
     732,    56,    93,   159,   201,   207,   226,   802,   257,   619,
     616,   152,   257,   619,    85,   156,   994,   997,    87,   639,
     987,   988,    87,    87,   282,   324,   477,   980,    87,   246,
     307,   340,   462,   463,   464,   796,   983,    87,   424,   513,
     516,   517,   518,  1028,  1024,  1023,  1037,  1043,   530,  1056,
    1053,  1071,  1073,  1075,   616,   661,   652,   660,   663,   663,
      41,   663,   663,    19,    40,   706,    40,   706,   706,    10,
     706,    87,    59,   116,     9,    87,   703,   705,   707,   709,
     710,   712,   715,   741,   744,   744,    59,    59,   645,    61,
     877,    53,    67,    72,    87,   189,   247,   306,   307,   308,
     318,   320,   322,   330,   331,   340,   796,   884,   619,   930,
     616,   208,   209,   215,   216,   217,   218,   425,   803,   928,
     159,   159,   650,    59,    59,    87,    59,   617,   617,   617,
     210,   211,    61,    28,   644,    56,   201,   616,   644,   803,
      56,   201,    87,   616,   327,   420,   421,   938,   616,   709,
      72,    87,   246,   247,   248,   289,   307,   312,   324,   328,
     330,   331,   340,   343,   381,   459,   462,   463,   464,   470,
     475,   485,   491,   796,   985,   477,   483,   989,   619,   616,
     619,    59,   616,   616,   172,   341,   473,   616,   325,   221,
     616,    59,   515,   515,   619,   619,   619,    59,    57,    87,
      99,   174,   242,   248,   252,   502,   504,   505,   509,   510,
     512,   519,   520,   528,  1019,    87,   515,   521,  1035,    87,
     292,   515,  1041,    29,   649,   651,    53,    87,   200,   247,
     305,   308,   328,   330,   331,   334,   340,   381,   462,   485,
     535,   536,   537,   538,   539,   541,   544,   796,  1054,    87,
     198,   340,  1072,    87,   546,   547,   552,  1076,   616,   616,
     616,   616,   664,   664,    61,    61,    61,    85,    61,    60,
      61,   737,   737,    10,    85,   154,   732,    61,    85,   616,
     313,   309,   310,   319,   616,   248,   616,   332,   332,    67,
      57,   252,   321,   324,   323,   311,    76,    77,   236,   312,
     784,   172,   316,    59,    59,   210,   211,   212,   213,   214,
     210,   211,   212,   213,   214,   426,    59,   616,   616,    59,
     798,    59,   644,   644,    59,    59,    59,   644,   644,   804,
     465,   466,   467,   468,   469,   470,   471,   472,   616,   248,
     493,    86,   616,   616,   616,   619,   311,    76,   312,   784,
     172,   341,   473,   467,   382,   619,   616,   325,   221,   616,
     334,   492,   616,   133,   465,    59,   616,    59,   616,   616,
     616,   616,   501,   507,  1032,   163,   515,   163,   507,   515,
     508,   325,   501,   501,   619,   506,   257,   511,   313,   339,
    1020,   339,  1021,   529,    59,  1036,   514,   616,  1045,  1033,
      59,  1042,  1039,  1045,    59,   616,   619,   248,   345,   616,
     257,   619,   311,    76,   312,   784,   620,   172,   210,   473,
     543,  1055,   382,   257,   133,   257,   257,   391,   465,   479,
     616,   540,   542,   545,    59,   646,   172,   210,    59,  1077,
     549,   548,   646,    59,    41,    41,   706,   706,   705,   712,
     737,   742,    59,   732,   180,   181,   326,   619,   617,   617,
     313,   617,   617,   616,   616,   619,   616,   616,   616,   616,
     616,   317,    59,    59,   802,    59,    59,   802,   802,   802,
      59,    59,   619,   494,   990,   480,   481,   616,   616,   616,
     619,   331,   619,   616,   616,   619,   619,   616,   619,   523,
    1046,  1046,   332,   257,   524,   525,   526,  1022,   616,  1022,
     257,   616,   616,   616,   332,   503,   619,   616,   616,   189,
     619,  1038,   619,  1044,    72,   339,   616,   619,   619,   616,
     616,   616,   616,   331,   619,   617,   616,   616,   616,   619,
     619,   619,   619,   199,   199,   616,   616,    61,    85,   120,
      61,   620,   620,   181,   327,   619,   802,   802,   802,   802,
     619,    87,   620,   992,   479,   619,   616,   616,  1046,   616,
    1046,   616,   619,   616,   616,   619,   479,   646,   646,   706,
     737,    59,   474,   991,   530,    85,    59,   649,   706,    61
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   607,   676,   676,   676,   676,   676,   676,   676,   676,
     676,   676,   612,   612,   613,   613,   614,   614,   615,   616,
     616,   616,   617,   617,   617,   618,   618,   619,   619,   619,
     619,   619,   619,   620,   620,   620,   621,   621,   622,   623,
     624,   625,   626,   627,   628,   629,   630,   631,   632,   633,
     633,   634,   634,   635,   635,   636,   636,   636,   636,   636,
     636,   636,   637,   637,   638,   638,   639,   639,   640,   640,
     641,   641,   641,   641,   641,   642,   643,   643,   644,   645,
     646,   646,   647,   647,   648,   648,   648,   648,   648,   649,
     649,   650,   650,   650,   651,   651,   651,   652,   652,   652,
     652,   652,   652,   652,   652,   653,   653,   654,   654,   654,
     654,   654,   654,   654,   654,   654,   654,   655,   656,   657,
     658,   658,   659,   659,   659,   659,   660,   660,   661,   661,
     662,   662,   662,   663,   663,   664,   664,   664,   664,   665,
     665,   665,   666,   666,   666,   666,   667,   667,   667,   667,
     667,   668,   668,   669,   669,   670,   671,   672,   673,   674,
     675,   675,   608,   609,   608,   610,   608,   611,   614,   614,
     678,   677,   614,   679,   614,   680,   614,   681,   614,   682,
     683,   683,   683,   683,   683,   683,   683,   683,   683,   683,
     683,   683,   683,   683,   683,   683,   683,   683,   684,   683,
     685,   685,   686,   686,   687,   687,   688,   688,   689,   690,
     691,   690,   693,   692,   694,   614,   696,   697,   695,   698,
     698,   699,   699,   700,   701,   701,   702,   702,   703,   703,
     703,   703,   703,   704,   704,   705,   706,   707,   707,   707,
     707,   707,   707,   707,   707,   707,   707,   708,   708,   708,
     708,   709,   709,   709,   710,   710,   710,   710,   710,   710,
     710,   710,   711,   711,   711,   711,   711,   712,   712,   712,
     712,   712,   713,   713,   714,   714,   715,   715,   716,   716,
     716,   716,   717,   717,   718,   718,   718,   719,   719,   720,
     721,   721,   721,   721,   721,   721,   721,   721,   721,   722,
     722,   722,   722,   722,   722,   722,   722,   722,   722,   722,
     722,   723,   723,   723,   723,   724,   724,   724,   725,   726,
     727,   727,   727,   727,   727,   727,   727,   727,   729,   728,
     730,   731,   730,   730,   730,   732,   732,   732,   732,   732,
     732,   732,   732,   732,   732,   732,   732,   732,   732,   732,
     732,   732,   732,   732,   732,   732,   732,   732,   732,   732,
     732,   732,   732,   732,   732,   732,   732,   732,   732,   732,
     732,   732,   733,   734,   734,   734,   735,   735,   736,   736,
     738,   739,   737,   737,   737,   740,   741,   742,   737,   737,
     737,   737,   737,   737,   737,   737,   737,   743,   737,   737,
     737,   744,   745,   745,   614,   746,   746,   747,   747,   747,
     747,   614,   748,   614,   749,   750,   750,   750,   750,   750,
     750,   750,   750,   750,   750,   751,   751,   614,   752,   753,
     754,   754,   755,   755,   755,   755,   755,   755,   755,   755,
     755,   755,   756,   756,   757,   757,   614,   758,   758,   759,
     759,   759,   759,   760,   760,   760,   760,   760,   760,   760,
     760,   760,   760,   760,   761,   762,   762,   762,   762,   762,
     762,   762,   762,   762,   762,   763,   763,   764,   764,   765,
     765,   766,   767,   768,   769,   769,   769,   769,   770,   770,
     770,   770,   770,   771,   771,   614,   772,   772,   772,   772,
     772,   614,   773,   774,   774,   774,   774,   775,   775,   775,
     775,   775,   775,   775,   775,   776,   777,   777,   778,   778,
     779,   780,   780,   781,   782,   783,   784,   784,   785,   786,
     787,   787,   787,   787,   787,   788,   789,   790,   790,   790,
     791,   791,   792,   792,   792,   792,   792,   792,   793,   793,
     793,   794,   794,   795,   795,   796,   797,   797,   798,   798,
     799,   799,   800,   800,   801,   802,   802,   802,   802,   802,
     802,   802,   802,   802,   803,   803,   803,   803,   803,   803,
     803,   803,   803,   803,   803,   803,   803,   803,   804,   805,
     608,   806,   608,   807,   608,   808,   608,   809,   810,   810,
     608,   811,   608,   812,   608,   813,   814,   814,   814,   814,
     814,   814,   814,   814,   814,   814,   814,   814,   814,   814,
     814,   814,   814,   814,   815,   815,   815,   815,   815,   815,
     815,   815,   816,   816,   816,   816,   817,   817,   817,   817,
     818,   818,   818,   818,   818,   818,   818,   818,   818,   818,
     818,   818,   818,   818,   818,   818,   818,   818,   818,   818,
     818,   819,   608,   820,   821,   821,   821,   821,   821,   821,
     821,   608,   822,   608,   823,   608,   824,   608,   825,   608,
     826,   608,   827,   608,   828,   608,   829,   608,   830,   608,
     831,   608,   832,   608,   833,   834,   834,   608,   835,   608,
     836,   608,   837,   608,   838,   608,   839,   608,   840,   608,
     841,   842,   842,   608,   843,   608,   844,   608,   845,   846,
     846,   846,   847,   847,   847,   614,   848,   849,   850,   851,
     851,   852,   852,   853,   854,   855,   855,   855,   856,   856,
     857,   857,   858,   858,   859,   860,   861,   862,   862,   862,
     862,   863,   863,   863,   863,   863,   863,   864,   864,   865,
     865,   867,   866,   868,   868,   868,   868,   608,   869,   785,
     870,   871,   871,   871,   872,   871,   873,   871,   874,   874,
     875,   876,   876,   877,   877,   785,   892,   893,   893,   893,
     893,   893,   893,   893,   893,   894,   894,   895,   896,   896,
     896,   896,   897,   897,   898,   899,   900,   900,   900,   900,
     900,   900,   901,   901,   902,   903,   904,   904,   904,   905,
     905,   906,   906,   907,   908,   908,   908,   908,   908,   908,
     908,   908,   908,   909,   909,   910,   911,   805,   608,   912,
     913,   913,   913,   913,   913,   913,   913,   913,   913,   913,
     785,   878,   879,   879,   879,   879,   880,   880,   881,   882,
     883,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   885,
     885,   886,   886,   887,   608,   888,   608,   889,   608,   890,
     608,   891,   785,   914,   915,   915,   915,   916,   916,   916,
     916,   916,   917,   917,   918,   918,   919,   919,   919,   919,
     919,   919,   919,   919,   919,   920,   920,   920,   921,   921,
     921,   921,   921,   922,   922,   922,   922,   922,   922,   922,
     922,   922,   922,   922,   922,   922,   922,   922,   922,   922,
     922,   922,   922,   922,   922,   922,   922,   922,   922,   922,
     922,   922,   922,   922,   922,   922,   922,   922,   922,   922,
     922,   922,   922,   922,   922,   922,   922,   922,   922,   922,
     922,   922,   922,   922,   922,   922,   922,   922,   922,   922,
     922,   922,   922,   922,   922,   922,   922,   922,   922,   922,
     922,   922,   922,   922,   922,   922,   922,   922,   922,   922,
     922,   922,   922,   922,   923,   924,   922,   922,   922,   922,
     922,   922,   925,   925,   925,   925,   925,   925,   925,   925,
     925,   925,   925,   925,   926,   927,   927,   927,   927,   927,
     927,   927,   928,   928,   929,   929,   930,   931,   932,   932,
     934,   933,   935,   936,   937,   937,   937,   938,   938,   938,
     939,   939,   939,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   941,   941,   942,   942,   943,   944,
     680,   608,   945,   608,   946,   608,   947,   732,   732,   785,
     951,   952,   953,   954,   954,   954,   954,   954,   954,   954,
     954,   955,   955,   956,   957,   957,   785,   964,   964,   964,
     965,   966,   966,   967,   967,   968,   969,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   971,   972,   973,   973,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   975,   974,   976,   974,   974,
     974,   974,   977,   977,   978,   979,   979,   980,   980,   980,
     981,   981,   982,   982,   983,   983,   983,   983,   983,   983,
     983,   983,   983,   983,   983,   984,   985,   985,   985,   985,
     985,   985,   985,   985,   985,   985,   985,   985,   985,   985,
     985,   985,   985,   985,   985,   985,   985,   985,   985,   985,
     985,   985,   985,   985,   985,   985,   985,   985,   985,   985,
     985,   985,   985,   985,   985,   986,   986,   987,   988,   989,
     989,   989,   990,   990,   991,   991,   992,   993,   994,   994,
     996,   995,   997,   997,   998,   998,   999,   608,  1000,   608,
    1001,   608,  1002,   608,  1003,   608,  1004,   608,  1005,   608,
    1006,   608,  1007,  1008,  1008,  1008,  1008,  1008,  1008,  1008,
    1008,  1008,   785,  1010,  1009,  1011,  1011,  1011,  1011,  1011,
    1011,   785,  1012,  1013,  1013,  1013,  1013,  1014,  1013,  1015,
    1013,  1013,  1013,  1013,  1016,  1016,  1017,  1018,  1019,  1019,
    1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,
    1019,  1019,  1019,  1019,  1019,  1020,  1019,  1021,  1019,  1019,
    1019,  1019,  1019,  1022,  1022,  1022,  1023,  1024,  1024,  1025,
    1025,  1026,  1027,  1028,  1028,  1028,  1028,  1028,  1029,  1030,
    1030,  1031,  1031,  1032,  1033,  1034,  1035,  1035,  1035,  1036,
    1037,  1037,  1038,  1038,  1039,  1040,  1041,  1041,  1041,  1042,
    1043,  1043,  1044,  1044,  1045,  1045,  1046,  1046,   785,  1047,
    1047,  1048,  1049,  1049,  1049,  1049,  1049,  1049,  1050,  1050,
    1051,  1052,  1053,  1054,  1054,  1054,  1054,  1054,  1054,  1054,
    1054,  1054,  1054,  1054,  1054,  1054,  1054,  1054,  1054,  1054,
    1054,  1054,  1054,  1054,  1054,  1054,  1054,  1054,  1054,  1054,
    1055,  1055,  1055,  1055,  1056,  1056,  1057,  1057,  1058,   608,
    1059,   608,  1060,   785,  1061,  1062,  1063,  1063,  1064,  1064,
    1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,
    1064,  1065,  1065,  1066,  1067,  1068,  1068,  1069,  1070,  1070,
    1071,  1071,  1072,  1072,  1072,  1073,  1074,  1075,  1075,  1076,
    1076,  1076,  1077,   785,  1078,  1079,  1079,  1079,  1079,  1079,
    1079,  1079,  1080,  1080,  1080,  1080,  1080,  1080,  1080,  1081,
    1081,  1082,  1082,  1084,  1083,  1085,  1085,  1085,  1085,  1085,
    1085,  1085,  1085,  1085,  1086,  1085,  1085,  1087,  1088,  1088,
    1089,  1090,  1090,  1091,  1092,  1091,   608,  1093,   785,   958,
     959,   959,   959,   959,   959,   959,   959,   959,   960,   960,
     961,   608,   962,   963,   963,   963,   963,   963,   963,   785,
     948,   949,   949,   949,   950,   950,   950,   950,   950,   950,
     950,   950,   950,  1094,  1095,  1095,  1095,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,   745,   614,  1097,  1098,  1099,  1099,
    1100,  1100,  1101,  1101,  1101,  1101,  1101,  1102,  1103,  1103,
    1104,  1104,  1105,  1105,  1106,  1106,  1106,  1106,  1106,  1106,
    1106,  1106,  1106,   614,  1107,  1107,   614,  1108,  1109,  1109,
    1110,  1111,  1111,  1111,   614,  1112,   614,  1113,  1113,  1113,
    1113,  1113,  1113,   614,  1114,  1114,  1114,  1114,  1115,  1115,
    1115,  1116,  1116,  1117,  1117,  1117,  1117,  1117,  1117,  1117,
     608,  1118,   608,  1119,   608,  1120,   608,  1121,   608,  1122,
     608,  1123,   608,  1124,   608,  1125,   608,  1126,   608,  1127,
    1128,  1128,  1129,  1129,  1129,   785,  1130,  1094,  1094,  1131,
    1131,  1132,  1132,  1133,  1133,  1134,  1134,  1134,  1134,  1134,
    1134,  1134,   785,  1135,  1136,  1136,  1137,  1137,  1137,  1138,
    1139,  1140,  1140,  1141,  1141,  1142
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     0,     2,     1,     1,     5,     1,
       3,     1,     2,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     1,     1,     0,     2,     2,     2,
       2,     2,     6,     2,     2,     5,     5,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     1,     2,
       1,     1,     1,     0,     1,     1,     1,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     2,     2,     1,     1,     1,     1,     2,     1,
       1,     1,     2,     4,     1,     3,     1,     3,     1,     3,
       4,     6,     6,     0,     1,     1,     1,     1,     1,     2,
       4,     4,     2,     2,     2,     2,     2,     4,     2,     2,
       2,     0,     3,     0,     3,     0,     0,     0,     6,     6,
       1,     1,     1,     2,     1,     2,     1,     2,     5,     1,
       0,     4,     1,     2,     1,     4,     1,     6,     1,     8,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     3,
       0,     4,     2,     5,     0,     4,     0,     2,     1,     1,
       0,     2,     0,     3,     4,     1,     0,     0,     7,     0,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     5,     7,     5,
       7,     9,     7,     5,     7,     5,    11,     1,     1,     2,
       1,     7,     9,     7,     7,     9,     7,     9,     7,     9,
       7,    15,     1,     1,     1,     1,     3,     1,     1,     1,
       1,     3,     1,     3,     1,     3,     1,     3,     1,     2,
       2,     6,     1,     3,     0,     4,     3,     1,     3,     3,
       2,     4,     3,     4,     2,     2,     2,     2,     0,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     3,     3,
       1,     5,     7,     7,     1,     0,     1,     3,     1,     4,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     4,
       1,     0,     5,     1,     1,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     2,     4,     1,     1,     1,     1,     3,     3,
       5,     7,     6,     6,     6,     6,     4,     8,     8,     4,
       1,     1,     4,     1,     1,     1,     5,     3,     2,     1,
       0,     0,     5,     4,     6,     0,     0,     0,     9,     4,
       3,     5,     3,     3,     3,     2,     5,     0,     5,     7,
       9,     0,     1,     1,     1,     4,     5,     1,     3,     1,
       1,     1,     3,     1,     5,     1,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     3,
       0,     1,     2,     2,     2,     3,     3,     4,     4,     6,
       4,     3,     0,     3,     0,     3,     1,     1,     1,     0,
       1,     2,     3,     0,     2,     3,     2,     2,     3,     2,
       2,     2,     2,     3,     1,     2,     2,     4,     2,     3,
       3,     3,     2,     4,     3,     1,     2,     0,     3,     0,
       3,     0,     3,     1,     2,     1,     1,     1,     0,     2,
       2,     2,     2,     2,     1,     1,     3,     3,     3,     3,
       4,     1,     4,     1,     1,     1,     1,     1,     3,     2,
       3,     3,     2,     3,     3,     0,     1,     2,     0,     1,
       3,     1,     3,     1,     0,     2,     2,     2,     2,     2,
       3,     3,     3,     3,     5,     0,     3,     1,     1,     3,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     3,     1,     1,     1,     4,     1,     0,     3,
       5,     2,     1,     1,     2,     0,     5,     5,     5,     5,
       4,     4,     4,     4,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     1,     1,     1,     1,     0,     3,
       1,     3,     1,     3,     1,     4,     1,     5,     1,     0,
       1,     3,     1,     4,     1,     4,     0,     2,     3,     3,
       3,     3,     4,     4,     3,     2,     2,     2,     2,     3,
       3,     3,     2,     2,     1,     1,     1,     1,     2,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     4,     0,     2,     2,     2,     2,     2,
       2,     1,     4,     1,     4,     1,     5,     1,     4,     1,
       4,     1,     4,     1,     4,     1,     4,     1,     4,     1,
       4,     1,     5,     1,     3,     2,     0,     1,     4,     1,
       4,     1,     4,     1,     5,     1,     6,     1,     6,     1,
       3,     2,     2,     1,     4,     1,     2,     1,     3,     1,
       1,     1,     1,     0,     1,     1,     3,     3,     1,     0,
       3,     0,     3,     0,     3,     3,     3,     3,     2,     2,
       0,     3,     0,     3,     0,     3,     1,     1,     1,     1,
       1,     1,     2,     3,     3,     3,     3,     0,     3,     0,
       3,     0,     2,     0,     2,     2,     2,     1,     5,     1,
       2,     1,     1,     3,     0,     4,     0,     4,     0,     3,
       5,     1,     3,     3,     1,     1,     2,     1,     4,     2,
       2,     2,     2,     3,     5,     0,     3,     5,     1,     1,
       1,     1,     0,     2,     0,     0,     1,     1,     2,     2,
       3,     3,     0,     3,     4,     3,     0,     2,     2,     0,
       2,     0,     2,     4,     2,     4,     4,     4,     2,     2,
       1,     2,     1,     0,     3,     0,     0,     5,     1,     5,
       0,     2,     3,     3,     3,     2,     2,     2,     2,     2,
       1,     2,     1,     1,     2,     4,     0,     3,     5,     0,
       0,     0,     2,     2,     2,     2,     2,     2,     3,     3,
       3,     3,     2,     3,     3,     4,     4,     4,     4,     4,
       2,     2,     3,     3,     3,     3,     3,     3,     1,     0,
       3,     0,     3,     4,     1,     6,     1,     6,     1,     6,
       1,     6,     2,     2,     0,     3,     3,     0,     3,     3,
       2,     2,     1,     3,     1,     3,     1,     3,     2,     2,
       2,     2,     2,     2,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     3,     3,     3,     4,     6,     4,
       6,     6,     4,     6,     5,     5,     4,     5,     5,     6,
       6,     3,     3,     4,     5,     6,     5,     5,     5,     5,
       5,     5,     5,     5,     5,     5,     6,     6,     6,     5,
       6,     6,     6,     8,     6,     6,     6,     7,     5,     6,
       5,     6,     7,     5,     6,     5,     6,     8,     4,     4,
       5,     4,     4,     4,     5,     5,     6,     5,     5,     6,
       5,     5,     6,     7,     7,     7,     7,     7,     8,     8,
       5,     5,     4,     4,     0,     0,     6,     6,     5,     5,
       5,     6,     1,     1,     2,     2,     2,     2,     2,     2,
       2,     2,     1,     1,     1,     3,     4,     4,     3,     3,
       2,     2,     1,     2,     0,     2,     0,     5,     0,     3,
       0,     4,     0,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     4,     4,     4,     6,     2,
       3,     2,     2,     2,     2,     3,     5,     5,     6,     6,
       4,     5,     3,     3,     3,     4,     3,     3,     4,     2,
       2,     2,     3,     3,     0,     3,     0,     3,     0,     3,
       6,     1,     4,     1,     5,     1,     5,     4,     4,     1,
       1,     3,     2,     1,     1,     1,     2,     3,     3,     3,
       3,     0,     3,     5,     1,     3,     2,     1,     2,     2,
       2,     3,     3,     0,     1,     2,     3,     1,     1,     2,
       2,     3,     3,     3,     3,     4,     2,     4,     3,     2,
       3,     1,     2,     4,     0,     3,     2,     1,     2,     3,
       3,     3,     3,     2,     3,     0,     5,     0,     5,     2,
       2,     1,     4,     1,     1,     0,     3,     2,     2,     2,
       5,     2,     0,     3,     0,     2,     2,     3,     2,     2,
       3,     2,     2,     2,     1,     3,     2,     2,     2,     2,
       2,     2,     3,     2,     2,     2,     2,     2,     2,     2,
       2,     3,     3,     3,     3,     2,     3,     2,     3,     3,
       4,     4,     2,     2,     2,     3,     3,     3,     2,     3,
       3,     3,     4,     2,     1,     0,     2,     3,     1,     0,
       1,     2,     0,     2,     0,     1,     3,     0,     0,     2,
       0,     3,     0,     3,     0,     3,     3,     1,     4,     1,
       6,     1,     6,     1,     6,     1,     7,     1,     6,     1,
       7,     1,     5,     0,     2,     3,     2,     3,     3,     2,
       3,     2,     2,     0,     4,     2,     3,     3,     6,     5,
       5,     1,     2,     1,     1,     2,     2,     0,     3,     0,
       3,     6,     2,     3,     0,     3,     5,     0,     4,     4,
       3,     4,     2,     3,     3,     3,     3,     4,     4,     4,
       3,     3,     4,     4,     2,     0,     3,     0,     3,     6,
       3,     3,     4,     1,     1,     1,     0,     0,     3,     0,
       3,     4,     1,     2,     2,     2,     4,     4,     0,     0,
       3,     0,     3,     3,     1,     0,     0,     2,     2,     0,
       0,     3,     1,     5,     1,     0,     0,     2,     2,     0,
       0,     3,     1,     5,     1,     2,     0,     2,     1,     1,
       2,     2,     1,     1,     2,     4,     2,     2,     0,     3,
       5,     0,     0,     2,     2,     2,     2,     2,     2,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     2,     3,     3,     4,     3,     2,     2,     1,
       1,     1,     1,     1,     0,     3,     0,     3,     4,     1,
       6,     1,     6,     1,     2,     5,     0,     3,     1,     1,
       2,     3,     1,     3,     2,     3,     3,     3,     4,     3,
       3,     0,     1,     2,     1,     4,     6,     0,     0,     3,
       0,     3,     2,     2,     2,     0,     0,     0,     3,     4,
       4,     2,     0,     2,     2,     3,     3,     3,     3,     5,
       5,     4,     3,     2,     3,     3,     3,     3,     3,     1,
       2,     0,     2,     0,     4,     2,     3,     5,     1,     2,
       2,     2,     2,     2,     0,     4,     2,     1,     1,     3,
       1,     0,     2,     0,     0,     4,     1,     4,     1,     2,
       1,     2,     2,     2,     1,     2,     2,     4,     0,     3,
       5,     1,     4,     0,     3,     3,     3,     2,     3,     2,
       2,     0,     3,     3,     3,     3,     5,     5,     5,     5,
       7,     7,     6,     3,     3,     2,     4,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     5,     2,     0,
       0,     2,     2,     3,     2,     1,     3,     1,     0,     2,
       1,     3,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     3,     1,     3,     5,     2,
       0,     0,     3,     4,     2,     0,     7,     4,     4,     4,
       3,     4,     3,     1,     3,     4,     3,     3,     1,     1,
       3,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     1,     5,     1,     3,     1,     3,     1,     3,
       1,     4,     1,     2,     1,     3,     1,     3,     1,     4,
       0,     1,     0,     1,     2,     2,     2,     3,     3,     1,
       1,     0,     2,     1,     1,     1,     1,     2,     3,     2,
       3,     4,     2,     2,     3,     3,     1,     2,     3,     0,
       2,     0,     3,     0,     3,     3
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        YY_LAC_DISCARD ("YYBACKUP");                              \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Given a state stack such that *YYBOTTOM is its bottom, such that
   *YYTOP is either its top or is YYTOP_EMPTY to indicate an empty
   stack, and such that *YYCAPACITY is the maximum number of elements it
   can hold without a reallocation, make sure there is enough room to
   store YYADD more elements.  If not, allocate a new stack using
   YYSTACK_ALLOC, copy the existing elements, and adjust *YYBOTTOM,
   *YYTOP, and *YYCAPACITY to reflect the new capacity and memory
   location.  If *YYBOTTOM != YYBOTTOM_NO_FREE, then free the old stack
   using YYSTACK_FREE.  Return 0 if successful or if no reallocation is
   required.  Return YYENOMEM if memory is exhausted.  */
static int
yy_lac_stack_realloc (YYPTRDIFF_T *yycapacity, YYPTRDIFF_T yyadd,
#if YYDEBUG
                      char const *yydebug_prefix,
                      char const *yydebug_suffix,
#endif
                      yy_state_t **yybottom,
                      yy_state_t *yybottom_no_free,
                      yy_state_t **yytop, yy_state_t *yytop_empty)
{
  YYPTRDIFF_T yysize_old =
    *yytop == yytop_empty ? 0 : *yytop - *yybottom + 1;
  YYPTRDIFF_T yysize_new = yysize_old + yyadd;
  if (*yycapacity < yysize_new)
    {
      YYPTRDIFF_T yyalloc = 2 * yysize_new;
      yy_state_t *yybottom_new;
      /* Use YYMAXDEPTH for maximum stack size given that the stack
         should never need to grow larger than the main state stack
         needs to grow without LAC.  */
      if (YYMAXDEPTH < yysize_new)
        {
          YYDPRINTF ((stderr, "%smax size exceeded%s", yydebug_prefix,
                      yydebug_suffix));
          return YYENOMEM;
        }
      if (YYMAXDEPTH < yyalloc)
        yyalloc = YYMAXDEPTH;
      yybottom_new =
        YY_CAST (yy_state_t *,
                 YYSTACK_ALLOC (YY_CAST (YYSIZE_T,
                                         yyalloc * YYSIZEOF (*yybottom_new))));
      if (!yybottom_new)
        {
          YYDPRINTF ((stderr, "%srealloc failed%s", yydebug_prefix,
                      yydebug_suffix));
          return YYENOMEM;
        }
      if (*yytop != yytop_empty)
        {
          YYCOPY (yybottom_new, *yybottom, yysize_old);
          *yytop = yybottom_new + (yysize_old - 1);
        }
      if (*yybottom != yybottom_no_free)
        YYSTACK_FREE (*yybottom);
      *yybottom = yybottom_new;
      *yycapacity = yyalloc;
    }
  return 0;
}

/* Establish the initial context for the current lookahead if no initial
   context is currently established.

   We define a context as a snapshot of the parser stacks.  We define
   the initial context for a lookahead as the context in which the
   parser initially examines that lookahead in order to select a
   syntactic action.  Thus, if the lookahead eventually proves
   syntactically unacceptable (possibly in a later context reached via a
   series of reductions), the initial context can be used to determine
   the exact set of tokens that would be syntactically acceptable in the
   lookahead's place.  Moreover, it is the context after which any
   further semantic actions would be erroneous because they would be
   determined by a syntactically unacceptable token.

   YY_LAC_ESTABLISH should be invoked when a reduction is about to be
   performed in an inconsistent state (which, for the purposes of LAC,
   includes consistent states that don't know they're consistent because
   their default reductions have been disabled).  Iff there is a
   lookahead token, it should also be invoked before reporting a syntax
   error.  This latter case is for the sake of the debugging output.

   For parse.lac=full, the implementation of YY_LAC_ESTABLISH is as
   follows.  If no initial context is currently established for the
   current lookahead, then check if that lookahead can eventually be
   shifted if syntactic actions continue from the current context.
   Report a syntax error if it cannot.  */
#define YY_LAC_ESTABLISH                                                \
do {                                                                    \
  if (!yy_lac_established)                                              \
    {                                                                   \
      YYDPRINTF ((stderr,                                               \
                  "LAC: initial context established for %s\n",          \
                  yysymbol_name (yytoken)));                            \
      yy_lac_established = 1;                                           \
      switch (yy_lac (yyesa, &yyes, &yyes_capacity, yyssp, yytoken))    \
        {                                                               \
        case YYENOMEM:                                                  \
          YYNOMEM;                                                      \
        case 1:                                                         \
          goto yyerrlab;                                                \
        }                                                               \
    }                                                                   \
} while (0)

/* Discard any previous initial lookahead context because of Event,
   which may be a lookahead change or an invalidation of the currently
   established initial context for the current lookahead.

   The most common example of a lookahead change is a shift.  An example
   of both cases is syntax error recovery.  That is, a syntax error
   occurs when the lookahead is syntactically erroneous for the
   currently established initial context, so error recovery manipulates
   the parser stacks to try to find a new initial context in which the
   current lookahead is syntactically acceptable.  If it fails to find
   such a context, it discards the lookahead.  */
#if YYDEBUG
# define YY_LAC_DISCARD(Event)                                           \
do {                                                                     \
  if (yy_lac_established)                                                \
    {                                                                    \
      YYDPRINTF ((stderr, "LAC: initial context discarded due to "       \
                  Event "\n"));                                          \
      yy_lac_established = 0;                                            \
    }                                                                    \
} while (0)
#else
# define YY_LAC_DISCARD(Event) yy_lac_established = 0
#endif

/* Given the stack whose top is *YYSSP, return 0 iff YYTOKEN can
   eventually (after perhaps some reductions) be shifted, return 1 if
   not, or return YYENOMEM if memory is exhausted.  As preconditions and
   postconditions: *YYES_CAPACITY is the allocated size of the array to
   which *YYES points, and either *YYES = YYESA or *YYES points to an
   array allocated with YYSTACK_ALLOC.  yy_lac may overwrite the
   contents of either array, alter *YYES and *YYES_CAPACITY, and free
   any old *YYES other than YYESA.  */
static int
yy_lac (yy_state_t *yyesa, yy_state_t **yyes,
        YYPTRDIFF_T *yyes_capacity, yy_state_t *yyssp, yysymbol_kind_t yytoken)
{
  yy_state_t *yyes_prev = yyssp;
  yy_state_t *yyesp = yyes_prev;
  /* Reduce until we encounter a shift and thereby accept the token.  */
  YYDPRINTF ((stderr, "LAC: checking lookahead %s:", yysymbol_name (yytoken)));
  if (yytoken == YYSYMBOL_YYUNDEF)
    {
      YYDPRINTF ((stderr, " Always Err\n"));
      return 1;
    }
  while (1)
    {
      int yyrule = yypact[+*yyesp];
      if (yypact_value_is_default (yyrule)
          || (yyrule += yytoken) < 0 || YYLAST < yyrule
          || yycheck[yyrule] != yytoken)
        {
          /* Use the default action.  */
          yyrule = yydefact[+*yyesp];
          if (yyrule == 0)
            {
              YYDPRINTF ((stderr, " Err\n"));
              return 1;
            }
        }
      else
        {
          /* Use the action from yytable.  */
          yyrule = yytable[yyrule];
          if (yytable_value_is_error (yyrule))
            {
              YYDPRINTF ((stderr, " Err\n"));
              return 1;
            }
          if (0 < yyrule)
            {
              YYDPRINTF ((stderr, " S%d\n", yyrule));
              return 0;
            }
          yyrule = -yyrule;
        }
      /* By now we know we have to simulate a reduce.  */
      YYDPRINTF ((stderr, " R%d", yyrule - 1));
      {
        /* Pop the corresponding number of values from the stack.  */
        YYPTRDIFF_T yylen = yyr2[yyrule];
        /* First pop from the LAC stack as many tokens as possible.  */
        if (yyesp != yyes_prev)
          {
            YYPTRDIFF_T yysize = yyesp - *yyes + 1;
            if (yylen < yysize)
              {
                yyesp -= yylen;
                yylen = 0;
              }
            else
              {
                yyesp = yyes_prev;
                yylen -= yysize;
              }
          }
        /* Only afterwards look at the main stack.  */
        if (yylen)
          yyesp = yyes_prev -= yylen;
      }
      /* Push the resulting state of the reduction.  */
      {
        yy_state_fast_t yystate;
        {
          const int yylhs = yyr1[yyrule] - YYNTOKENS;
          const int yyi = yypgoto[yylhs] + *yyesp;
          yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyesp
                     ? yytable[yyi]
                     : yydefgoto[yylhs]);
        }
        if (yyesp == yyes_prev)
          {
            yyesp = *yyes;
            YY_IGNORE_USELESS_CAST_BEGIN
            *yyesp = YY_CAST (yy_state_t, yystate);
            YY_IGNORE_USELESS_CAST_END
          }
        else
          {
            if (yy_lac_stack_realloc (yyes_capacity, 1,
#if YYDEBUG
                                      " (", ")",
#endif
                                      yyes, yyesa, &yyesp, yyes_prev))
              {
                YYDPRINTF ((stderr, "\n"));
                return YYENOMEM;
              }
            YY_IGNORE_USELESS_CAST_BEGIN
            *++yyesp = YY_CAST (yy_state_t, yystate);
            YY_IGNORE_USELESS_CAST_END
          }
        YYDPRINTF ((stderr, " G%d", yystate));
      }
    }
}

/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yy_state_t *yyesa;
  yy_state_t **yyes;
  YYPTRDIFF_T *yyes_capacity;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;

  int yyx;
  for (yyx = 0; yyx < YYNTOKENS; ++yyx)
    {
      yysymbol_kind_t yysym = YY_CAST (yysymbol_kind_t, yyx);
      if (yysym != YYSYMBOL_YYerror && yysym != YYSYMBOL_YYUNDEF)
        switch (yy_lac (yyctx->yyesa, yyctx->yyes, yyctx->yyes_capacity, yyctx->yyssp, yysym))
          {
          case YYENOMEM:
            return YYENOMEM;
          case 1:
            continue;
          default:
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = yysym;
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
       In the first two cases, it might appear that the current syntax
       error should have been detected in the previous state when yy_lac
       was invoked.  However, at that time, there might have been a
       different syntax error that discarded a different initial context
       during error recovery, leaving behind the current lookahead.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      YYDPRINTF ((stderr, "Constructing syntax error message\n"));
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else if (yyn == 0)
        YYDPRINTF ((stderr, "No expected tokens.\n"));
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.  In order to see if a particular token T is a
   valid looakhead, invoke yy_lac (YYESA, YYES, YYES_CAPACITY, YYSSP, T).

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store or if
   yy_lac returned YYENOMEM.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    yy_state_t yyesa[20];
    yy_state_t *yyes = yyesa;
    YYPTRDIFF_T yyes_capacity = 20 < YYMAXDEPTH ? 20 : YYMAXDEPTH;

  /* Whether LAC context is established.  A Boolean.  */
  int yy_lac_established = 0;
  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    {
      YY_LAC_ESTABLISH;
      goto yydefault;
    }
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      YY_LAC_ESTABLISH;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  YY_LAC_DISCARD ("shift");
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  {
    int yychar_backup = yychar;
    switch (yyn)
      {
  case 2: /* enum_type: NET_TYPE  */
#line 57 "conf/gen_parser.m4"
                    { (yyval.i) = T_ENUM_NET_TYPE; }
#line 6826 "obj/conf/cf-parse.tab.c"
    break;

  case 3: /* enum_type: RTS  */
#line 57 "conf/gen_parser.m4"
                                                    { (yyval.i) = T_ENUM_RTS; }
#line 6832 "obj/conf/cf-parse.tab.c"
    break;

  case 4: /* enum_type: SCOPE  */
#line 57 "conf/gen_parser.m4"
                                                                                 { (yyval.i) = T_ENUM_SCOPE; }
#line 6838 "obj/conf/cf-parse.tab.c"
    break;

  case 5: /* enum_type: RTD  */
#line 57 "conf/gen_parser.m4"
                                                                                                              { (yyval.i) = T_ENUM_RTD; }
#line 6844 "obj/conf/cf-parse.tab.c"
    break;

  case 6: /* enum_type: ROA  */
#line 57 "conf/gen_parser.m4"
                                                                                                                                         { (yyval.i) = T_ENUM_ROA; }
#line 6850 "obj/conf/cf-parse.tab.c"
    break;

  case 7: /* enum_type: ASPA  */
#line 57 "conf/gen_parser.m4"
                                                                                                                                                                     { (yyval.i) = T_ENUM_ASPA; }
#line 6856 "obj/conf/cf-parse.tab.c"
    break;

  case 8: /* enum_type: AF  */
#line 57 "conf/gen_parser.m4"
                                                                                                                                                                                                { (yyval.i) = T_ENUM_AF; }
#line 6862 "obj/conf/cf-parse.tab.c"
    break;

  case 9: /* enum_type: MPLS_POLICY  */
#line 57 "conf/gen_parser.m4"
                                                                                                                                                                                                                                  { (yyval.i) = T_ENUM_MPLS_POLICY; }
#line 6868 "obj/conf/cf-parse.tab.c"
    break;

  case 10: /* enum_type: BGP_ORIGIN  */
#line 57 "conf/gen_parser.m4"
                                                                                                                                                                                                                                                                            { (yyval.i) = T_ENUM_BGP_ORIGIN; }
#line 6874 "obj/conf/cf-parse.tab.c"
    break;

  case 11: /* enum_type: RA_PREFERENCE  */
#line 57 "conf/gen_parser.m4"
                                                                                                                                                                                                                                                                                                                        { (yyval.i) = T_ENUM_RA_PREFERENCE; }
#line 6880 "obj/conf/cf-parse.tab.c"
    break;

  case 12: /* config: conf_entries END  */
#line 156 "conf/confbase.Y"
                         { return 0; }
#line 6886 "obj/conf/cf-parse.tab.c"
    break;

  case 13: /* config: CLI_MARKER cli_cmd  */
#line 157 "conf/confbase.Y"
                      { return 0; }
#line 6892 "obj/conf/cf-parse.tab.c"
    break;

  case 18: /* definition: DEFINE symbol '=' term ';'  */
#line 173 "conf/confbase.Y"
                              {
     struct f_val *val = cf_eval((yyvsp[-1].x), T_VOID);
     cf_define_symbol(new_config, (yyvsp[-3].s), SYM_CONSTANT | val->type, val, val);
   }
#line 6901 "obj/conf/cf-parse.tab.c"
    break;

  case 20: /* expr: '(' term ')'  */
#line 181 "conf/confbase.Y"
                { (yyval.i) = cf_eval_int((yyvsp[-1].x)); }
#line 6907 "obj/conf/cf-parse.tab.c"
    break;

  case 21: /* expr: CF_SYM_KNOWN  */
#line 182 "conf/confbase.Y"
                {
     if ((yyvsp[0].s)->class != (SYM_CONSTANT | T_INT)) cf_error("Number constant expected");
     (yyval.i) = SYM_VAL((yyvsp[0].s)).i; }
#line 6915 "obj/conf/cf-parse.tab.c"
    break;

  case 22: /* expr_us: expr S  */
#line 188 "conf/confbase.Y"
           { (yyval.time) = (yyvsp[-1].i) S_; }
#line 6921 "obj/conf/cf-parse.tab.c"
    break;

  case 23: /* expr_us: expr MS  */
#line 189 "conf/confbase.Y"
           { (yyval.time) = (yyvsp[-1].i) MS_; }
#line 6927 "obj/conf/cf-parse.tab.c"
    break;

  case 24: /* expr_us: expr US  */
#line 190 "conf/confbase.Y"
           { (yyval.time) = (yyvsp[-1].i) US_; }
#line 6933 "obj/conf/cf-parse.tab.c"
    break;

  case 27: /* bool: expr  */
#line 198 "conf/confbase.Y"
        { (yyval.i) = !!(yyvsp[0].i); }
#line 6939 "obj/conf/cf-parse.tab.c"
    break;

  case 28: /* bool: ON  */
#line 199 "conf/confbase.Y"
      { (yyval.i) = 1; }
#line 6945 "obj/conf/cf-parse.tab.c"
    break;

  case 29: /* bool: YES  */
#line 200 "conf/confbase.Y"
       { (yyval.i) = 1; }
#line 6951 "obj/conf/cf-parse.tab.c"
    break;

  case 30: /* bool: OFF  */
#line 201 "conf/confbase.Y"
       { (yyval.i) = 0; }
#line 6957 "obj/conf/cf-parse.tab.c"
    break;

  case 31: /* bool: NO  */
#line 202 "conf/confbase.Y"
      { (yyval.i) = 0; }
#line 6963 "obj/conf/cf-parse.tab.c"
    break;

  case 32: /* bool: %empty  */
#line 203 "conf/confbase.Y"
                                 { (yyval.i) = 1; }
#line 6969 "obj/conf/cf-parse.tab.c"
    break;

  case 33: /* ipa: IP4  */
#line 210 "conf/confbase.Y"
       { (yyval.a) = ipa_from_ip4((yyvsp[0].ip4)); }
#line 6975 "obj/conf/cf-parse.tab.c"
    break;

  case 34: /* ipa: IP6  */
#line 211 "conf/confbase.Y"
       { (yyval.a) = ipa_from_ip6((yyvsp[0].ip6)); }
#line 6981 "obj/conf/cf-parse.tab.c"
    break;

  case 35: /* ipa: CF_SYM_KNOWN  */
#line 212 "conf/confbase.Y"
                {
     if ((yyvsp[0].s)->class != (SYM_CONSTANT | T_IP)) cf_error("IP address constant expected");
     (yyval.a) = SYM_VAL((yyvsp[0].s)).ip;
   }
#line 6990 "obj/conf/cf-parse.tab.c"
    break;

  case 36: /* ipa_scope: %empty  */
#line 219 "conf/confbase.Y"
               { (yyval.iface) = NULL; }
#line 6996 "obj/conf/cf-parse.tab.c"
    break;

  case 37: /* ipa_scope: '%' symbol  */
#line 220 "conf/confbase.Y"
              { (yyval.iface) = if_get_by_name((yyvsp[0].s)->name); }
#line 7002 "obj/conf/cf-parse.tab.c"
    break;

  case 38: /* pxlen4: '/' NUM  */
#line 227 "conf/confbase.Y"
           {
     if ((yyvsp[0].i) > IP4_MAX_PREFIX_LENGTH) cf_error("Invalid prefix length %u", (yyvsp[0].i));
     (yyval.i) = (yyvsp[0].i);
   }
#line 7011 "obj/conf/cf-parse.tab.c"
    break;

  case 39: /* net_ip4_: IP4 pxlen4  */
#line 234 "conf/confbase.Y"
{
  net_fill_ip4(&((yyval.net)), (yyvsp[-1].ip4), (yyvsp[0].i));

  net_addr_ip4 *n = (void *) &((yyval.net));
  if (!net_validate_ip4(n))
    cf_error("Invalid IPv4 prefix %I4/%d, maybe you wanted %I4/%d",
	     n->prefix, n->pxlen, ip4_and(n->prefix, ip4_mkmask(n->pxlen)), n->pxlen);
}
#line 7024 "obj/conf/cf-parse.tab.c"
    break;

  case 40: /* net_ip6_slash: IP6 '/'  */
#line 244 "conf/confbase.Y"
{
  this_sadr_from_hack_active = cf_maybe_exit_filters();
  (yyval.a) = (yyvsp[-1].ip6);
}
#line 7033 "obj/conf/cf-parse.tab.c"
    break;

  case 41: /* net_ip6_: net_ip6_slash NUM  */
#line 250 "conf/confbase.Y"
{
  if (this_sadr_from_hack_active)
  {
    cf_enter_filters();
    this_sadr_from_hack_active = 0;
  }

  if ((yyvsp[0].i) > IP6_MAX_PREFIX_LENGTH)
    cf_error("Invalid prefix length %u", (yyvsp[0].i));

  net_fill_ip6(&((yyval.net)), (yyvsp[-1].a), (yyvsp[0].i));

  net_addr_ip6 *n = (void *) &((yyval.net));
  if (!net_validate_ip6(n))
    cf_error("Invalid IPv6 prefix %I6/%d, maybe you wanted %I6/%d",
	     n->prefix, n->pxlen, ip6_and(n->prefix, ip6_mkmask(n->pxlen)), n->pxlen);
}
#line 7055 "obj/conf/cf-parse.tab.c"
    break;

  case 42: /* net_ip6_sadr_: net_ip6_slash NUM FROM IP6 '/' NUM  */
#line 269 "conf/confbase.Y"
{
  if (this_sadr_from_hack_active)
  {
    cf_enter_filters();
    this_sadr_from_hack_active = 0;
  }

  if (((yyvsp[-3].s)->class != SYM_KEYWORD) || ((yyvsp[-3].s)->keyword->value != FROM))
    cf_error("Expected FROM after %I6/%d", (yyvsp[-5].a), (yyvsp[-4].i));

  if ((yyvsp[-4].i) > IP6_MAX_PREFIX_LENGTH)
    cf_error("Invalid prefix length %u", (yyvsp[-4].i));

  if ((yyvsp[0].i) > IP6_MAX_PREFIX_LENGTH)
    cf_error("Invalid prefix length %u", (yyvsp[0].i));

  (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_ip6_sadr));
  net_fill_ip6_sadr((yyval.net_ptr), (yyvsp[-5].a), (yyvsp[-4].i), (yyvsp[-2].ip6), (yyvsp[0].i));

  net_addr_ip6_sadr *n = (void *) (yyval.net_ptr);
  if (!net_validate_ip6_sadr(n))
    cf_error("Invalid SADR IPv6 prefix %I6/%d from %I6/%d, maybe you wanted %I6/%d from %I6/%d",
	     n->dst_prefix, n->dst_pxlen, n->src_prefix, n->src_pxlen,
	     ip6_and(n->dst_prefix, ip6_mkmask(n->dst_pxlen)), n->dst_pxlen,
	     ip6_and(n->src_prefix, ip6_mkmask(n->src_pxlen)), n->src_pxlen);
}
#line 7086 "obj/conf/cf-parse.tab.c"
    break;

  case 43: /* net_vpn4_: VPN_RD net_ip4_  */
#line 297 "conf/confbase.Y"
{
  (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_vpn4));
  net_fill_vpn4((yyval.net_ptr), net4_prefix(&(yyvsp[0].net)), net4_pxlen(&(yyvsp[0].net)), (yyvsp[-1].rd));
}
#line 7095 "obj/conf/cf-parse.tab.c"
    break;

  case 44: /* net_vpn6_: VPN_RD net_ip6_  */
#line 303 "conf/confbase.Y"
{
  (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_vpn6));
  net_fill_vpn6((yyval.net_ptr), net6_prefix(&(yyvsp[0].net)), net6_pxlen(&(yyvsp[0].net)), (yyvsp[-1].rd));
}
#line 7104 "obj/conf/cf-parse.tab.c"
    break;

  case 45: /* net_roa4_: net_ip4_ MAX NUM AS NUM  */
#line 309 "conf/confbase.Y"
{
  (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_roa4));
  net_fill_roa4((yyval.net_ptr), net4_prefix(&(yyvsp[-4].net)), net4_pxlen(&(yyvsp[-4].net)), (yyvsp[-2].i), (yyvsp[0].i));
  if ((yyvsp[-2].i) < net4_pxlen(&(yyvsp[-4].net)) || (yyvsp[-2].i) > IP4_MAX_PREFIX_LENGTH)
    cf_error("Invalid max prefix length %u", (yyvsp[-2].i));
}
#line 7115 "obj/conf/cf-parse.tab.c"
    break;

  case 46: /* net_roa6_: net_ip6_ MAX NUM AS NUM  */
#line 317 "conf/confbase.Y"
{
  (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_roa6));
  net_fill_roa6((yyval.net_ptr), net6_prefix(&(yyvsp[-4].net)), net6_pxlen(&(yyvsp[-4].net)), (yyvsp[-2].i), (yyvsp[0].i));
  if ((yyvsp[-2].i) < net6_pxlen(&(yyvsp[-4].net)) || (yyvsp[-2].i) > IP6_MAX_PREFIX_LENGTH)
    cf_error("Invalid max prefix length %u", (yyvsp[-2].i));
}
#line 7126 "obj/conf/cf-parse.tab.c"
    break;

  case 47: /* net_mpls_: MPLS NUM  */
#line 325 "conf/confbase.Y"
{
  (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_mpls));
  net_fill_mpls((yyval.net_ptr), (yyvsp[0].i));
}
#line 7135 "obj/conf/cf-parse.tab.c"
    break;

  case 48: /* net_aspa_: ASPA NUM  */
#line 331 "conf/confbase.Y"
{
  (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_aspa));
  net_fill_aspa((yyval.net_ptr), (yyvsp[0].i));
}
#line 7144 "obj/conf/cf-parse.tab.c"
    break;

  case 55: /* net_: net_ip_  */
#line 341 "conf/confbase.Y"
           { (yyval.net_ptr) = cfg_alloc((yyvsp[0].net).length); net_copy((yyval.net_ptr), &((yyvsp[0].net))); }
#line 7150 "obj/conf/cf-parse.tab.c"
    break;

  case 63: /* net_ip4: CF_SYM_KNOWN  */
#line 355 "conf/confbase.Y"
                {
     if (((yyvsp[0].s)->class != (SYM_CONSTANT | T_NET)) || (SYM_VAL((yyvsp[0].s)).net->type != NET_IP4))
       cf_error("IPv4 network constant expected");
     (yyval.net) = * SYM_VAL((yyvsp[0].s)).net;
   }
#line 7160 "obj/conf/cf-parse.tab.c"
    break;

  case 65: /* net_ip6: CF_SYM_KNOWN  */
#line 364 "conf/confbase.Y"
                {
     if (((yyvsp[0].s)->class != (SYM_CONSTANT | T_NET)) || (SYM_VAL((yyvsp[0].s)).net->type != NET_IP6))
       cf_error("IPv6 network constant expected");
     (yyval.net) = * SYM_VAL((yyvsp[0].s)).net;
   }
#line 7170 "obj/conf/cf-parse.tab.c"
    break;

  case 67: /* net_ip: CF_SYM_KNOWN  */
#line 373 "conf/confbase.Y"
                {
     if (((yyvsp[0].s)->class != (SYM_CONSTANT | T_NET)) || !net_is_ip(SYM_VAL((yyvsp[0].s)).net))
       cf_error("IP network constant expected");
     (yyval.net) = * SYM_VAL((yyvsp[0].s)).net;
   }
#line 7180 "obj/conf/cf-parse.tab.c"
    break;

  case 69: /* net_any: CF_SYM_KNOWN  */
#line 382 "conf/confbase.Y"
                {
     if ((yyvsp[0].s)->class != (SYM_CONSTANT | T_NET))
       cf_error("Network constant expected");
     (yyval.net_ptr) = (net_addr *) SYM_VAL((yyvsp[0].s)).net; /* Avoid const warning */
   }
#line 7190 "obj/conf/cf-parse.tab.c"
    break;

  case 72: /* net_or_ipa: IP4  */
#line 392 "conf/confbase.Y"
       { net_fill_ip4(&((yyval.net)), (yyvsp[0].ip4), IP4_MAX_PREFIX_LENGTH); }
#line 7196 "obj/conf/cf-parse.tab.c"
    break;

  case 73: /* net_or_ipa: IP6  */
#line 393 "conf/confbase.Y"
       { net_fill_ip6(&((yyval.net)), (yyvsp[0].ip6), IP6_MAX_PREFIX_LENGTH); }
#line 7202 "obj/conf/cf-parse.tab.c"
    break;

  case 74: /* net_or_ipa: CF_SYM_KNOWN  */
#line 394 "conf/confbase.Y"
                {
     if ((yyvsp[0].s)->class == (SYM_CONSTANT | T_IP))
       net_fill_ip_host(&((yyval.net)), SYM_VAL((yyvsp[0].s)).ip);
     else if (((yyvsp[0].s)->class == (SYM_CONSTANT | T_NET)) && net_is_ip(SYM_VAL((yyvsp[0].s)).net))
       (yyval.net) = * SYM_VAL((yyvsp[0].s)).net;
     else
       cf_error("IP address or network constant expected");
   }
#line 7215 "obj/conf/cf-parse.tab.c"
    break;

  case 75: /* label_stack_start: NUM  */
#line 405 "conf/confbase.Y"
{
  (yyval.ad) = cfg_allocz(ADATA_SIZE(MPLS_MAX_LABEL_STACK * sizeof(u32)));
  (yyval.ad)->length = sizeof(u32);
  *((u32 *)(yyval.ad)->data) = (yyvsp[0].i);
}
#line 7225 "obj/conf/cf-parse.tab.c"
    break;

  case 77: /* label_stack: label_stack '/' NUM  */
#line 413 "conf/confbase.Y"
                        {
    if ((yyvsp[-2].ad)->length >= MPLS_MAX_LABEL_STACK * sizeof(u32))
      cf_error("Too many labels in stack");

    *((u32 *)((yyval.ad)->data + (yyvsp[-2].ad)->length)) = (yyvsp[0].i);
    (yyvsp[-2].ad)->length += sizeof(u32);
    (yyval.ad) = (yyvsp[-2].ad);
  }
#line 7238 "obj/conf/cf-parse.tab.c"
    break;

  case 78: /* time: TEXT  */
#line 424 "conf/confbase.Y"
        {
     (yyval.time) = tm_parse_time((yyvsp[0].t));
     if (!(yyval.time))
       cf_error("Invalid date/time");
   }
#line 7248 "obj/conf/cf-parse.tab.c"
    break;

  case 79: /* settle: expr_us expr_us  */
#line 432 "conf/confbase.Y"
                        {
  if ((yyvsp[-1].time) > (yyvsp[0].time)) cf_error("Minimum settle time %t is bigger than maximum settle time %t", (yyvsp[-1].time), (yyvsp[0].time));
  (yyval.settle).min = (yyvsp[-1].time);
  (yyval.settle).max = (yyvsp[0].time);
}
#line 7258 "obj/conf/cf-parse.tab.c"
    break;

  case 81: /* text: CF_SYM_KNOWN  */
#line 440 "conf/confbase.Y"
                {
     if ((yyvsp[0].s)->class != (SYM_CONSTANT | T_STRING)) cf_error("String constant expected");
     (yyval.t) = SYM_VAL((yyvsp[0].s)).s;
   }
#line 7267 "obj/conf/cf-parse.tab.c"
    break;

  case 83: /* opttext: %empty  */
#line 448 "conf/confbase.Y"
               { (yyval.t) = NULL; }
#line 7273 "obj/conf/cf-parse.tab.c"
    break;

  case 84: /* text_or_ipa: TEXT  */
#line 452 "conf/confbase.Y"
        { (yyval.v).type = T_STRING; (yyval.v).val.s = (yyvsp[0].t); }
#line 7279 "obj/conf/cf-parse.tab.c"
    break;

  case 85: /* text_or_ipa: IP4  */
#line 453 "conf/confbase.Y"
       { (yyval.v).type = T_IP; (yyval.v).val.ip = ipa_from_ip4((yyvsp[0].ip4)); }
#line 7285 "obj/conf/cf-parse.tab.c"
    break;

  case 86: /* text_or_ipa: IP6  */
#line 454 "conf/confbase.Y"
       { (yyval.v).type = T_IP; (yyval.v).val.ip = ipa_from_ip6((yyvsp[0].ip6)); }
#line 7291 "obj/conf/cf-parse.tab.c"
    break;

  case 87: /* text_or_ipa: CF_SYM_KNOWN  */
#line 455 "conf/confbase.Y"
                {
     if (((yyvsp[0].s)->class == (SYM_CONSTANT | T_STRING)) ||
	 ((yyvsp[0].s)->class == (SYM_CONSTANT | T_IP)))
       (yyval.v) = *((yyvsp[0].s)->val);
     else
       cf_error("String or IP constant expected");
   }
#line 7303 "obj/conf/cf-parse.tab.c"
    break;

  case 88: /* text_or_ipa: '(' term ')'  */
#line 462 "conf/confbase.Y"
                {
     (yyval.v) = *cf_eval((yyvsp[-1].x), T_VOID);
     if (((yyval.v).type != T_STRING) && ((yyval.v).type != T_IP))
       cf_error("String or IP value expected");
   }
#line 7313 "obj/conf/cf-parse.tab.c"
    break;

  case 90: /* bytestring: bytestring_expr  */
#line 471 "conf/confbase.Y"
                   { (yyval.bs) = cf_eval((yyvsp[0].x), T_BYTESTRING)->val.bs; }
#line 7319 "obj/conf/cf-parse.tab.c"
    break;

  case 91: /* bytestring_text: BYTETEXT  */
#line 475 "conf/confbase.Y"
            { (yyval.v).type = T_BYTESTRING; (yyval.v).val.bs = (yyvsp[0].bs); }
#line 7325 "obj/conf/cf-parse.tab.c"
    break;

  case 92: /* bytestring_text: TEXT  */
#line 476 "conf/confbase.Y"
        { (yyval.v).type = T_STRING; (yyval.v).val.s = (yyvsp[0].t); }
#line 7331 "obj/conf/cf-parse.tab.c"
    break;

  case 93: /* bytestring_text: bytestring_expr  */
#line 477 "conf/confbase.Y"
                   {
     (yyval.v) = *cf_eval((yyvsp[0].x), T_VOID);
     if (((yyval.v).type != T_BYTESTRING) && ((yyval.v).type != T_STRING))
       cf_error("Bytestring or string value expected");
   }
#line 7341 "obj/conf/cf-parse.tab.c"
    break;

  case 94: /* bytestring_expr: lvalue  */
#line 485 "conf/confbase.Y"
          { (yyval.x) = f_lval_getter(&(yyvsp[0].flv)); }
#line 7347 "obj/conf/cf-parse.tab.c"
    break;

  case 96: /* bytestring_expr: '(' term ')'  */
#line 487 "conf/confbase.Y"
                { (yyval.x) = (yyvsp[-1].x); }
#line 7353 "obj/conf/cf-parse.tab.c"
    break;

  case 97: /* flow_num_op: TRUE  */
#line 37 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_TRUE; }
#line 7359 "obj/conf/cf-parse.tab.c"
    break;

  case 98: /* flow_num_op: '='  */
#line 38 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_EQ;  }
#line 7365 "obj/conf/cf-parse.tab.c"
    break;

  case 99: /* flow_num_op: NEQ  */
#line 39 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_NEQ; }
#line 7371 "obj/conf/cf-parse.tab.c"
    break;

  case 100: /* flow_num_op: '<'  */
#line 40 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_LT;  }
#line 7377 "obj/conf/cf-parse.tab.c"
    break;

  case 101: /* flow_num_op: LEQ  */
#line 41 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_LEQ; }
#line 7383 "obj/conf/cf-parse.tab.c"
    break;

  case 102: /* flow_num_op: '>'  */
#line 42 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_GT;  }
#line 7389 "obj/conf/cf-parse.tab.c"
    break;

  case 103: /* flow_num_op: GEQ  */
#line 43 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_GEQ; }
#line 7395 "obj/conf/cf-parse.tab.c"
    break;

  case 104: /* flow_num_op: FALSE  */
#line 44 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_FALSE; }
#line 7401 "obj/conf/cf-parse.tab.c"
    break;

  case 105: /* flow_logic_op: OR  */
#line 48 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_OR; }
#line 7407 "obj/conf/cf-parse.tab.c"
    break;

  case 106: /* flow_logic_op: AND  */
#line 49 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_OP_AND; }
#line 7413 "obj/conf/cf-parse.tab.c"
    break;

  case 107: /* flow_num_type_: PROTO  */
#line 53 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_IP_PROTOCOL; }
#line 7419 "obj/conf/cf-parse.tab.c"
    break;

  case 108: /* flow_num_type_: NEXT HEADER  */
#line 54 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_NEXT_HEADER; }
#line 7425 "obj/conf/cf-parse.tab.c"
    break;

  case 109: /* flow_num_type_: PORT  */
#line 55 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_PORT; }
#line 7431 "obj/conf/cf-parse.tab.c"
    break;

  case 110: /* flow_num_type_: DPORT  */
#line 56 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_DST_PORT; }
#line 7437 "obj/conf/cf-parse.tab.c"
    break;

  case 111: /* flow_num_type_: SPORT  */
#line 57 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_SRC_PORT; }
#line 7443 "obj/conf/cf-parse.tab.c"
    break;

  case 112: /* flow_num_type_: ICMP TYPE  */
#line 58 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_ICMP_TYPE; }
#line 7449 "obj/conf/cf-parse.tab.c"
    break;

  case 113: /* flow_num_type_: ICMP CODE  */
#line 59 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_ICMP_CODE; }
#line 7455 "obj/conf/cf-parse.tab.c"
    break;

  case 114: /* flow_num_type_: LENGTH  */
#line 60 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_PACKET_LENGTH; }
#line 7461 "obj/conf/cf-parse.tab.c"
    break;

  case 115: /* flow_num_type_: DSCP  */
#line 61 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_DSCP; }
#line 7467 "obj/conf/cf-parse.tab.c"
    break;

  case 116: /* flow_num_type_: LABEL  */
#line 62 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_LABEL; }
#line 7473 "obj/conf/cf-parse.tab.c"
    break;

  case 117: /* flow_num_type: flow_num_type_  */
#line 65 "conf/flowspec.Y"
                             { flow_builder_set_type(this_flow, (yyvsp[0].i32)); }
#line 7479 "obj/conf/cf-parse.tab.c"
    break;

  case 118: /* flow_flag_type: TCP FLAGS  */
#line 66 "conf/flowspec.Y"
                             { flow_builder_set_type(this_flow, FLOW_TYPE_TCP_FLAGS); }
#line 7485 "obj/conf/cf-parse.tab.c"
    break;

  case 119: /* flow_frag_type: FRAGMENT  */
#line 67 "conf/flowspec.Y"
                             { flow_builder_set_type(this_flow, FLOW_TYPE_FRAGMENT); }
#line 7491 "obj/conf/cf-parse.tab.c"
    break;

  case 120: /* flow_srcdst: DST  */
#line 70 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_DST_PREFIX; }
#line 7497 "obj/conf/cf-parse.tab.c"
    break;

  case 121: /* flow_srcdst: SRC  */
#line 71 "conf/flowspec.Y"
                { (yyval.i32) = FLOW_TYPE_SRC_PREFIX; }
#line 7503 "obj/conf/cf-parse.tab.c"
    break;

  case 122: /* flow_num_opts: flow_num_op expr  */
#line 75 "conf/flowspec.Y"
                    {
     flow_check_cf_value_length(this_flow, (yyvsp[0].i));
     flow_builder_add_op_val(this_flow, (yyvsp[-1].i32), (yyvsp[0].i));
   }
#line 7512 "obj/conf/cf-parse.tab.c"
    break;

  case 123: /* flow_num_opts: flow_num_opts flow_logic_op flow_num_op expr  */
#line 79 "conf/flowspec.Y"
                                                {
     flow_check_cf_value_length(this_flow, (yyvsp[0].i));
     flow_builder_add_op_val(this_flow, (yyvsp[-2].i32) | (yyvsp[-1].i32), (yyvsp[0].i));
   }
#line 7521 "obj/conf/cf-parse.tab.c"
    break;

  case 126: /* flow_num_opt_ext_expr: expr  */
#line 88 "conf/flowspec.Y"
        {
     flow_check_cf_value_length(this_flow, (yyvsp[0].i));
     flow_builder_add_op_val(this_flow, FLOW_OP_EQ, (yyvsp[0].i));
   }
#line 7530 "obj/conf/cf-parse.tab.c"
    break;

  case 127: /* flow_num_opt_ext_expr: expr DDOT expr  */
#line 92 "conf/flowspec.Y"
                  {
     flow_check_cf_value_length(this_flow, (yyvsp[-2].i));
     flow_check_cf_value_length(this_flow, (yyvsp[0].i));
     flow_builder_add_op_val(this_flow, FLOW_OP_GEQ, (yyvsp[-2].i));
     flow_builder_add_op_val(this_flow, FLOW_OP_AND | FLOW_OP_LEQ, (yyvsp[0].i));
   }
#line 7541 "obj/conf/cf-parse.tab.c"
    break;

  case 130: /* flow_bmk_opts: flow_neg expr '/' expr  */
#line 106 "conf/flowspec.Y"
                          {
     flow_check_cf_bmk_values(this_flow, (yyvsp[-3].i32), (yyvsp[-2].i), (yyvsp[0].i));
     flow_builder_add_val_mask(this_flow, (yyvsp[-3].i32), (yyvsp[-2].i), (yyvsp[0].i));
   }
#line 7550 "obj/conf/cf-parse.tab.c"
    break;

  case 131: /* flow_bmk_opts: flow_bmk_opts flow_logic_op flow_neg expr '/' expr  */
#line 110 "conf/flowspec.Y"
                                                      {
     flow_check_cf_bmk_values(this_flow, (yyvsp[-3].i32), (yyvsp[-2].i), (yyvsp[0].i));
     flow_builder_add_val_mask(this_flow, (yyvsp[-4].i32) | (yyvsp[-3].i32), (yyvsp[-2].i), (yyvsp[0].i));
   }
#line 7559 "obj/conf/cf-parse.tab.c"
    break;

  case 132: /* flow_bmk_opts: flow_bmk_opts ',' flow_neg expr '/' expr  */
#line 114 "conf/flowspec.Y"
                                            {
     flow_check_cf_bmk_values(this_flow, (yyvsp[-3].i32), (yyvsp[-2].i), (yyvsp[0].i));
     flow_builder_add_val_mask(this_flow, 0x40 | (yyvsp[-3].i32), (yyvsp[-2].i), (yyvsp[0].i)); /* AND */
   }
#line 7568 "obj/conf/cf-parse.tab.c"
    break;

  case 133: /* flow_neg: %empty  */
#line 121 "conf/flowspec.Y"
                { (yyval.i32) = 0x00; }
#line 7574 "obj/conf/cf-parse.tab.c"
    break;

  case 134: /* flow_neg: '!'  */
#line 122 "conf/flowspec.Y"
                { (yyval.i32) = 0x02; }
#line 7580 "obj/conf/cf-parse.tab.c"
    break;

  case 135: /* flow_frag_val: DONT_FRAGMENT  */
#line 126 "conf/flowspec.Y"
                  { (yyval.i32) = 1; }
#line 7586 "obj/conf/cf-parse.tab.c"
    break;

  case 136: /* flow_frag_val: IS_FRAGMENT  */
#line 127 "conf/flowspec.Y"
                  { (yyval.i32) = 2; }
#line 7592 "obj/conf/cf-parse.tab.c"
    break;

  case 137: /* flow_frag_val: FIRST_FRAGMENT  */
#line 128 "conf/flowspec.Y"
                  { (yyval.i32) = 4; }
#line 7598 "obj/conf/cf-parse.tab.c"
    break;

  case 138: /* flow_frag_val: LAST_FRAGMENT  */
#line 129 "conf/flowspec.Y"
                  { (yyval.i32) = 8; }
#line 7604 "obj/conf/cf-parse.tab.c"
    break;

  case 139: /* flow_frag_opts: flow_neg flow_frag_val  */
#line 133 "conf/flowspec.Y"
                          {
     flow_builder_add_val_mask(this_flow, 0, ((yyvsp[-1].i32) ? 0 : (yyvsp[0].i32)), (yyvsp[0].i32));
   }
#line 7612 "obj/conf/cf-parse.tab.c"
    break;

  case 140: /* flow_frag_opts: flow_frag_opts flow_logic_op flow_neg flow_frag_val  */
#line 136 "conf/flowspec.Y"
                                                       {
     flow_builder_add_val_mask(this_flow, (yyvsp[-2].i32), ((yyvsp[-1].i32) ? 0 : (yyvsp[0].i32)), (yyvsp[0].i32));
   }
#line 7620 "obj/conf/cf-parse.tab.c"
    break;

  case 141: /* flow_frag_opts: flow_frag_opts ',' flow_neg flow_frag_val  */
#line 139 "conf/flowspec.Y"
                                             {
     flow_builder_add_val_mask(this_flow, 0x40, ((yyvsp[-1].i32) ? 0 : (yyvsp[0].i32)), (yyvsp[0].i32)); /* AND */
   }
#line 7628 "obj/conf/cf-parse.tab.c"
    break;

  case 142: /* flow4_item: flow_srcdst net_ip4  */
#line 145 "conf/flowspec.Y"
                       {
     flow_builder_set_type(this_flow, (yyvsp[-1].i32));
     flow_builder4_add_pfx(this_flow, (net_addr_ip4 *) &((yyvsp[0].net)));
   }
#line 7637 "obj/conf/cf-parse.tab.c"
    break;

  case 146: /* flow6_item: flow_srcdst net_ip6  */
#line 155 "conf/flowspec.Y"
                       {
     flow_builder_set_type(this_flow, (yyvsp[-1].i32));
     flow_builder6_add_pfx(this_flow, (net_addr_ip6 *) &((yyvsp[0].net)), 0);
   }
#line 7646 "obj/conf/cf-parse.tab.c"
    break;

  case 147: /* flow6_item: flow_srcdst net_ip6 OFFSET NUM  */
#line 159 "conf/flowspec.Y"
                                  {
     if ((yyvsp[0].i) > (yyvsp[-2].net).pxlen)
       cf_error("Prefix offset is higher than prefix length");
     flow_builder_set_type(this_flow, (yyvsp[-3].i32));
     flow_builder6_add_pfx(this_flow, (net_addr_ip6 *) &((yyvsp[-2].net)), (yyvsp[0].i));
   }
#line 7657 "obj/conf/cf-parse.tab.c"
    break;

  case 155: /* flow_builder_init: %empty  */
#line 181 "conf/flowspec.Y"
{
  if (this_flow == NULL)
    this_flow = flow_builder_init(config_pool);	  /* FIXME: This should be allocated from tmp in future */
  else
    flow_builder_clear(this_flow);
}
#line 7668 "obj/conf/cf-parse.tab.c"
    break;

  case 156: /* flow_builder_set_ipv4: %empty  */
#line 188 "conf/flowspec.Y"
                       { this_flow->ipv6 = 0; }
#line 7674 "obj/conf/cf-parse.tab.c"
    break;

  case 157: /* flow_builder_set_ipv6: %empty  */
#line 189 "conf/flowspec.Y"
                       { this_flow->ipv6 = 1; }
#line 7680 "obj/conf/cf-parse.tab.c"
    break;

  case 158: /* net_flow4_: FLOW4 '{' flow_builder_init flow_builder_set_ipv4 flow4_opts '}'  */
#line 192 "conf/flowspec.Y"
{
  (yyval.net_ptr) = (net_addr *) flow_builder4_finalize(this_flow, cfg_mem);
  flow4_validate_cf((net_addr_flow4 *) (yyval.net_ptr));
}
#line 7689 "obj/conf/cf-parse.tab.c"
    break;

  case 159: /* net_flow6_: FLOW6 '{' flow_builder_init flow_builder_set_ipv6 flow6_opts '}'  */
#line 198 "conf/flowspec.Y"
{
  (yyval.net_ptr) = (net_addr *) flow_builder6_finalize(this_flow, cfg_mem);
  flow6_validate_cf((net_addr_flow6 *) (yyval.net_ptr));
}
#line 7698 "obj/conf/cf-parse.tab.c"
    break;

  case 168: /* conf: FILTER STACKS expr expr ';'  */
#line 403 "filter/config.Y"
                                  {
  if (((yyvsp[-2].i) < 16) || ((yyvsp[-1].i) < 16))
    /* Check for self-crippling values */
    cf_error("Filter stack values lesser than 16 not supported");
  new_config->filter_vstk = (yyvsp[-2].i);
  new_config->filter_estk = (yyvsp[-1].i);
 }
#line 7710 "obj/conf/cf-parse.tab.c"
    break;

  case 170: /* $@1: %empty  */
#line 414 "filter/config.Y"
                 {
     (yyvsp[0].s) = cf_define_symbol(new_config, (yyvsp[0].s), SYM_FILTER, filter, NULL);
     cf_enter_filters();
     cf_push_scope( new_config, (yyvsp[0].s) );
     this_function = NULL;
   }
#line 7721 "obj/conf/cf-parse.tab.c"
    break;

  case 171: /* filter_def: FILTER symbol $@1 filter_body  */
#line 419 "filter/config.Y"
                 {
     struct filter *f = cfg_alloc(sizeof(struct filter));
     *f = (struct filter) { .sym = (yyvsp[-2].s), .root = (yyvsp[0].fl) };
     (yyvsp[-2].s)->filter = f;

     cf_pop_scope(new_config);
     cf_exit_filters();
   }
#line 7734 "obj/conf/cf-parse.tab.c"
    break;

  case 173: /* filter_eval: EVAL term  */
#line 431 "filter/config.Y"
             { cf_eval_int((yyvsp[0].x)); }
#line 7740 "obj/conf/cf-parse.tab.c"
    break;

  case 175: /* custom_attr: ATTRIBUTE type symbol ';'  */
#line 435 "filter/config.Y"
                                       {
  cf_enter_filters();
  struct ea_class *ac = ea_class_find_by_name((yyvsp[-1].s)->name);
  cf_exit_filters();
  if (ac && (ac->type == (yyvsp[-2].i)))
    ea_ref_class(new_config->pool, ac);
  else
    ac = ea_register_alloc(new_config->pool, (struct ea_class) {
	.name = (yyvsp[-1].s)->name,
	.type = (yyvsp[-2].i),
    })->class;

  cf_define_symbol(new_config, (yyvsp[-1].s), SYM_ATTRIBUTE, attribute, ac);
}
#line 7759 "obj/conf/cf-parse.tab.c"
    break;

  case 177: /* bt_test_suite: BT_TEST_SUITE '(' CF_SYM_KNOWN ',' text ')'  */
#line 452 "filter/config.Y"
                                             {
  cf_assert_symbol((yyvsp[-3].s), SYM_FUNCTION);
  struct f_bt_test_suite *t = cfg_allocz(sizeof(struct f_bt_test_suite));
  t->fn = (yyvsp[-3].s)->function;
  t->fn_name = (yyvsp[-3].s)->name;
  t->dsc = (yyvsp[-1].t);

  add_tail(&new_config->tests, &t->n);
 }
#line 7773 "obj/conf/cf-parse.tab.c"
    break;

  case 179: /* bt_test_same: BT_TEST_SAME '(' CF_SYM_KNOWN ',' CF_SYM_KNOWN ',' NUM ')'  */
#line 465 "filter/config.Y"
                                                            {
  cf_assert_symbol((yyvsp[-5].s), SYM_FUNCTION);
  cf_assert_symbol((yyvsp[-3].s), SYM_FUNCTION);
  struct f_bt_test_suite *t = cfg_allocz(sizeof(struct f_bt_test_suite));
  t->fn = (yyvsp[-5].s)->function;
  t->cmp = (yyvsp[-3].s)->function;
  t->result = (yyvsp[-1].i);
  t->fn_name = (yyvsp[-5].s)->name;
  t->dsc = (yyvsp[-3].s)->name;
  add_tail(&new_config->tests, &t->n);
 }
#line 7789 "obj/conf/cf-parse.tab.c"
    break;

  case 180: /* type: INT  */
#line 479 "filter/config.Y"
       { (yyval.i) = T_INT; }
#line 7795 "obj/conf/cf-parse.tab.c"
    break;

  case 181: /* type: BOOL  */
#line 480 "filter/config.Y"
        { (yyval.i) = T_BOOL; }
#line 7801 "obj/conf/cf-parse.tab.c"
    break;

  case 182: /* type: IP  */
#line 481 "filter/config.Y"
      { (yyval.i) = T_IP; }
#line 7807 "obj/conf/cf-parse.tab.c"
    break;

  case 183: /* type: RD  */
#line 482 "filter/config.Y"
      { (yyval.i) = T_RD; }
#line 7813 "obj/conf/cf-parse.tab.c"
    break;

  case 184: /* type: PREFIX  */
#line 483 "filter/config.Y"
          { (yyval.i) = T_NET; }
#line 7819 "obj/conf/cf-parse.tab.c"
    break;

  case 185: /* type: PAIR  */
#line 484 "filter/config.Y"
        { (yyval.i) = T_PAIR; }
#line 7825 "obj/conf/cf-parse.tab.c"
    break;

  case 186: /* type: QUAD  */
#line 485 "filter/config.Y"
        { (yyval.i) = T_QUAD; }
#line 7831 "obj/conf/cf-parse.tab.c"
    break;

  case 187: /* type: EC  */
#line 486 "filter/config.Y"
      { (yyval.i) = T_EC; }
#line 7837 "obj/conf/cf-parse.tab.c"
    break;

  case 188: /* type: LC  */
#line 487 "filter/config.Y"
      { (yyval.i) = T_LC; }
#line 7843 "obj/conf/cf-parse.tab.c"
    break;

  case 189: /* type: STRING  */
#line 488 "filter/config.Y"
          { (yyval.i) = T_STRING; }
#line 7849 "obj/conf/cf-parse.tab.c"
    break;

  case 190: /* type: BYTESTRING  */
#line 489 "filter/config.Y"
              { (yyval.i) = T_BYTESTRING; }
#line 7855 "obj/conf/cf-parse.tab.c"
    break;

  case 191: /* type: BGPMASK  */
#line 490 "filter/config.Y"
           { (yyval.i) = T_PATH_MASK; }
#line 7861 "obj/conf/cf-parse.tab.c"
    break;

  case 192: /* type: BGPPATH  */
#line 491 "filter/config.Y"
           { (yyval.i) = T_PATH; }
#line 7867 "obj/conf/cf-parse.tab.c"
    break;

  case 193: /* type: CLIST  */
#line 492 "filter/config.Y"
         { (yyval.i) = T_CLIST; }
#line 7873 "obj/conf/cf-parse.tab.c"
    break;

  case 194: /* type: ECLIST  */
#line 493 "filter/config.Y"
          { (yyval.i) = T_ECLIST; }
#line 7879 "obj/conf/cf-parse.tab.c"
    break;

  case 195: /* type: LCLIST  */
#line 494 "filter/config.Y"
          { (yyval.i) = T_LCLIST; }
#line 7885 "obj/conf/cf-parse.tab.c"
    break;

  case 196: /* type: ROUTE  */
#line 495 "filter/config.Y"
         { (yyval.i) = T_ROUTE; }
#line 7891 "obj/conf/cf-parse.tab.c"
    break;

  case 197: /* type: type SET  */
#line 496 "filter/config.Y"
            {
	switch ((yyvsp[-1].i)) {
	  case T_INT:
	  case T_PAIR:
	  case T_QUAD:
	  case T_ENUM:
	  case T_EC:
	  case T_LC:
	  case T_RD:
	  case T_IP:
	       (yyval.i) = T_SET;
	       break;

	  case T_NET:
	       (yyval.i) = T_PREFIX_SET;
	    break;

	  default:
		cf_error( "You can't create sets of this type." );
	}
   }
#line 7917 "obj/conf/cf-parse.tab.c"
    break;

  case 198: /* @2: %empty  */
#line 518 "filter/config.Y"
   { (yyval.i) = cf_maybe_exit_filters(); }
#line 7923 "obj/conf/cf-parse.tab.c"
    break;

  case 199: /* type: ENUM @2 enum_type  */
#line 520 "filter/config.Y"
   {
     if ((yyvsp[-1].i)) cf_enter_filters();
     (yyval.i) = (yyvsp[0].i);
   }
#line 7932 "obj/conf/cf-parse.tab.c"
    break;

  case 200: /* function_argsn: %empty  */
#line 527 "filter/config.Y"
               { (yyval.fa) = NULL; }
#line 7938 "obj/conf/cf-parse.tab.c"
    break;

  case 201: /* function_argsn: function_argsn type symbol ';'  */
#line 528 "filter/config.Y"
                                  {
     if ((yyvsp[-1].s)->scope->slots >= 0xfe) cf_error("Too many declarations, at most 255 allowed");
     (yyval.fa) = cfg_alloc(sizeof(struct f_arg));
     (yyval.fa)->arg = cf_define_symbol(new_config, (yyvsp[-1].s), SYM_VARIABLE | (yyvsp[-2].i), offset, sym_->scope->slots++);
     (yyval.fa)->next = (yyvsp[-3].fa);
   }
#line 7949 "obj/conf/cf-parse.tab.c"
    break;

  case 202: /* function_args: '(' ')'  */
#line 537 "filter/config.Y"
           { (yyval.fa) = NULL; }
#line 7955 "obj/conf/cf-parse.tab.c"
    break;

  case 203: /* function_args: '(' function_argsn type symbol ')'  */
#line 538 "filter/config.Y"
                                      {
     (yyval.fa) = cfg_alloc(sizeof(struct f_arg));
     (yyval.fa)->arg = cf_define_symbol(new_config, (yyvsp[-1].s), SYM_VARIABLE | (yyvsp[-2].i), offset, sym_->scope->slots++);
     (yyval.fa)->next = (yyvsp[-3].fa);
   }
#line 7965 "obj/conf/cf-parse.tab.c"
    break;

  case 204: /* function_vars: %empty  */
#line 546 "filter/config.Y"
               { (yyval.i) = 0; }
#line 7971 "obj/conf/cf-parse.tab.c"
    break;

  case 205: /* function_vars: function_vars type symbol ';'  */
#line 547 "filter/config.Y"
                                 {
     cf_define_symbol(new_config, (yyvsp[-1].s), SYM_VARIABLE | (yyvsp[-2].i), offset, f_new_var(sym_->scope));
     (yyval.i) = (yyvsp[-3].i) + 1;
   }
#line 7980 "obj/conf/cf-parse.tab.c"
    break;

  case 206: /* function_type: %empty  */
#line 554 "filter/config.Y"
               { (yyval.i) = T_VOID; }
#line 7986 "obj/conf/cf-parse.tab.c"
    break;

  case 207: /* function_type: IMP type  */
#line 555 "filter/config.Y"
            { (yyval.i) = (yyvsp[0].i); }
#line 7992 "obj/conf/cf-parse.tab.c"
    break;

  case 209: /* filter: CF_SYM_KNOWN  */
#line 561 "filter/config.Y"
                {
     cf_assert_symbol((yyvsp[0].s), SYM_FILTER);
     (yyval.f) = (yyvsp[0].s)->filter;
   }
#line 8001 "obj/conf/cf-parse.tab.c"
    break;

  case 210: /* $@3: %empty  */
#line 565 "filter/config.Y"
   {
     cf_enter_filters();
     cf_push_scope(new_config, NULL);
     this_function = NULL;
   }
#line 8011 "obj/conf/cf-parse.tab.c"
    break;

  case 211: /* filter: $@3 filter_body  */
#line 569 "filter/config.Y"
                 {
     struct filter *f = cfg_alloc(sizeof(struct filter));
     *f = (struct filter) { .root = (yyvsp[0].fl) };
     (yyval.f) = f;

     cf_pop_scope(new_config);
     cf_exit_filters();
   }
#line 8024 "obj/conf/cf-parse.tab.c"
    break;

  case 212: /* $@4: %empty  */
#line 580 "filter/config.Y"
         {
     cf_enter_filters();
   }
#line 8032 "obj/conf/cf-parse.tab.c"
    break;

  case 213: /* where_filter: WHERE $@4 term  */
#line 582 "filter/config.Y"
          {
     /* Construct 'IF term THEN { ACCEPT; } ELSE { REJECT; }' */
     (yyval.f) = f_new_where((yyvsp[0].x));
     cf_exit_filters();
   }
#line 8042 "obj/conf/cf-parse.tab.c"
    break;

  case 214: /* function_body: function_vars '{' cmds '}'  */
#line 590 "filter/config.Y"
                              {
     (yyval.fl) = f_linearize((yyvsp[-1].x), 0);
     (yyval.fl)->vars = (yyvsp[-3].i);
   }
#line 8051 "obj/conf/cf-parse.tab.c"
    break;

  case 216: /* $@5: %empty  */
#line 599 "filter/config.Y"
                   {
     DBG( "Beginning of function %s\n", (yyvsp[0].s)->name );
     this_function = cf_define_symbol(new_config, (yyvsp[0].s), SYM_FUNCTION, function, NULL);
     cf_enter_filters();
     cf_push_scope(new_config, this_function);
   }
#line 8062 "obj/conf/cf-parse.tab.c"
    break;

  case 217: /* $@6: %empty  */
#line 604 "filter/config.Y"
                                 {
     /* Make dummy f_line for storing function prototype */
     struct f_line *dummy = cfg_allocz(sizeof(struct f_line));
     this_function->function = dummy;

     dummy->return_type = (yyvsp[0].i);

     /* Revert the args */
     while ((yyvsp[-1].fa)) {
       struct f_arg *tmp = (yyvsp[-1].fa);
       (yyvsp[-1].fa) = (yyvsp[-1].fa)->next;

       tmp->next = dummy->arg_list;
       dummy->arg_list = tmp;
       dummy->args++;
     }
   }
#line 8084 "obj/conf/cf-parse.tab.c"
    break;

  case 218: /* function_def: FUNCTION symbol $@5 function_args function_type $@6 function_body  */
#line 620 "filter/config.Y"
                   {
     (yyvsp[0].fl)->args = this_function->function->args;
     (yyvsp[0].fl)->arg_list = this_function->function->arg_list;
     (yyvsp[0].fl)->return_type = this_function->function->return_type;
     (yyvsp[-5].s)->function = (yyvsp[0].fl);
     cf_pop_scope(new_config);
     cf_exit_filters();
   }
#line 8097 "obj/conf/cf-parse.tab.c"
    break;

  case 219: /* cmds: %empty  */
#line 632 "filter/config.Y"
                  { (yyval.x) = NULL; }
#line 8103 "obj/conf/cf-parse.tab.c"
    break;

  case 220: /* cmds: cmds_int  */
#line 633 "filter/config.Y"
            { (yyval.x) = (yyvsp[0].xp).begin; }
#line 8109 "obj/conf/cf-parse.tab.c"
    break;

  case 223: /* cmd_prep: cmd_var  */
#line 638 "filter/config.Y"
                  {
  (yyval.xp).begin = (yyval.xp).end = (yyvsp[0].x);
  if ((yyvsp[0].x))
    while ((yyval.xp).end->next)
      (yyval.xp).end = (yyval.xp).end->next;
}
#line 8120 "obj/conf/cf-parse.tab.c"
    break;

  case 225: /* cmds_int: cmds_int cmd_prep  */
#line 647 "filter/config.Y"
                     {
  if (!(yyvsp[-1].xp).begin)
    (yyval.xp) = (yyvsp[0].xp);
  else if (!(yyvsp[0].xp).begin)
    (yyval.xp) = (yyvsp[-1].xp);
  else {
    (yyval.xp).begin = (yyvsp[-1].xp).begin;
    (yyval.xp).end = (yyvsp[0].xp).end;
    (yyvsp[-1].xp).end->next = (yyvsp[0].xp).begin;
  }
 }
#line 8136 "obj/conf/cf-parse.tab.c"
    break;

  case 226: /* fipa: IP4  */
#line 664 "filter/config.Y"
                          { (yyval.v).type = T_IP; (yyval.v).val.ip = ipa_from_ip4((yyvsp[0].ip4)); }
#line 8142 "obj/conf/cf-parse.tab.c"
    break;

  case 227: /* fipa: IP6  */
#line 665 "filter/config.Y"
                          { (yyval.v).type = T_IP; (yyval.v).val.ip = ipa_from_ip6((yyvsp[0].ip6)); }
#line 8148 "obj/conf/cf-parse.tab.c"
    break;

  case 228: /* set_atom0: NUM  */
#line 678 "filter/config.Y"
          { (yyval.v).type = T_INT; (yyval.v).val.i = (yyvsp[0].i); }
#line 8154 "obj/conf/cf-parse.tab.c"
    break;

  case 229: /* set_atom0: fipa  */
#line 679 "filter/config.Y"
          { (yyval.v) = (yyvsp[0].v); }
#line 8160 "obj/conf/cf-parse.tab.c"
    break;

  case 230: /* set_atom0: VPN_RD  */
#line 680 "filter/config.Y"
          { (yyval.v).type = T_RD; (yyval.v).val.rd = (yyvsp[0].rd); }
#line 8166 "obj/conf/cf-parse.tab.c"
    break;

  case 231: /* set_atom0: ENUM_TOKEN  */
#line 681 "filter/config.Y"
              { (yyval.v).type = pair_a((yyvsp[0].i)); (yyval.v).val.i = pair_b((yyvsp[0].i)); }
#line 8172 "obj/conf/cf-parse.tab.c"
    break;

  case 232: /* set_atom0: '(' term ')'  */
#line 682 "filter/config.Y"
                {
     (yyval.v) = cf_eval_tmp((yyvsp[-1].x), T_VOID);
     if (!f_valid_set_type((yyval.v).type))
       cf_error("Set-incompatible type (%s)", f_type_name((yyval.v).type));
   }
#line 8182 "obj/conf/cf-parse.tab.c"
    break;

  case 234: /* set_atom: CF_SYM_KNOWN  */
#line 691 "filter/config.Y"
                {
     cf_assert_symbol((yyvsp[0].s), SYM_CONSTANT);
     if (!f_valid_set_type(SYM_TYPE((yyvsp[0].s))))
       cf_error("%s: Set-incompatible type (%s)", (yyvsp[0].s)->name, f_type_name(SYM_TYPE((yyvsp[0].s))));
     (yyval.v) = *(yyvsp[0].s)->val;
   }
#line 8193 "obj/conf/cf-parse.tab.c"
    break;

  case 236: /* cnum: term  */
#line 704 "filter/config.Y"
        { (yyval.i32) = cf_eval_int((yyvsp[0].x)); }
#line 8199 "obj/conf/cf-parse.tab.c"
    break;

  case 237: /* pair_item: '(' cnum ',' cnum ')'  */
#line 707 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_item((yyvsp[-3].i32), (yyvsp[-3].i32), (yyvsp[-1].i32), (yyvsp[-1].i32)); }
#line 8205 "obj/conf/cf-parse.tab.c"
    break;

  case 238: /* pair_item: '(' cnum ',' cnum DDOT cnum ')'  */
#line 708 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_item((yyvsp[-5].i32), (yyvsp[-5].i32), (yyvsp[-3].i32), (yyvsp[-1].i32)); }
#line 8211 "obj/conf/cf-parse.tab.c"
    break;

  case 239: /* pair_item: '(' cnum ',' '*' ')'  */
#line 709 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_item((yyvsp[-3].i32), (yyvsp[-3].i32), 0, CC_ALL); }
#line 8217 "obj/conf/cf-parse.tab.c"
    break;

  case 240: /* pair_item: '(' cnum DDOT cnum ',' cnum ')'  */
#line 710 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_set((yyvsp[-5].i32), (yyvsp[-3].i32), (yyvsp[-1].i32), (yyvsp[-1].i32)); }
#line 8223 "obj/conf/cf-parse.tab.c"
    break;

  case 241: /* pair_item: '(' cnum DDOT cnum ',' cnum DDOT cnum ')'  */
#line 711 "filter/config.Y"
                                             { (yyval.e) = f_new_pair_set((yyvsp[-7].i32), (yyvsp[-5].i32), (yyvsp[-3].i32), (yyvsp[-1].i32)); }
#line 8229 "obj/conf/cf-parse.tab.c"
    break;

  case 242: /* pair_item: '(' cnum DDOT cnum ',' '*' ')'  */
#line 712 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_item((yyvsp[-5].i32), (yyvsp[-3].i32), 0, CC_ALL); }
#line 8235 "obj/conf/cf-parse.tab.c"
    break;

  case 243: /* pair_item: '(' '*' ',' cnum ')'  */
#line 713 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_set(0, CC_ALL, (yyvsp[-1].i32), (yyvsp[-1].i32)); }
#line 8241 "obj/conf/cf-parse.tab.c"
    break;

  case 244: /* pair_item: '(' '*' ',' cnum DDOT cnum ')'  */
#line 714 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_set(0, CC_ALL, (yyvsp[-3].i32), (yyvsp[-1].i32)); }
#line 8247 "obj/conf/cf-parse.tab.c"
    break;

  case 245: /* pair_item: '(' '*' ',' '*' ')'  */
#line 715 "filter/config.Y"
                                        { (yyval.e) = f_new_pair_item(0, CC_ALL, 0, CC_ALL); }
#line 8253 "obj/conf/cf-parse.tab.c"
    break;

  case 246: /* pair_item: '(' cnum ',' cnum ')' DDOT '(' cnum ',' cnum ')'  */
#line 717 "filter/config.Y"
   { (yyval.e) = f_new_pair_item((yyvsp[-9].i32), (yyvsp[-3].i32), (yyvsp[-7].i32), (yyvsp[-1].i32)); }
#line 8259 "obj/conf/cf-parse.tab.c"
    break;

  case 247: /* ec_kind: RT  */
#line 721 "filter/config.Y"
      { (yyval.ecs) = EC_RT; }
#line 8265 "obj/conf/cf-parse.tab.c"
    break;

  case 248: /* ec_kind: RO  */
#line 722 "filter/config.Y"
      { (yyval.ecs) = EC_RO; }
#line 8271 "obj/conf/cf-parse.tab.c"
    break;

  case 249: /* ec_kind: UNKNOWN NUM  */
#line 723 "filter/config.Y"
               { (yyval.ecs) = (yyvsp[0].i); }
#line 8277 "obj/conf/cf-parse.tab.c"
    break;

  case 250: /* ec_kind: GENERIC  */
#line 724 "filter/config.Y"
           { (yyval.ecs) = EC_GENERIC; }
#line 8283 "obj/conf/cf-parse.tab.c"
    break;

  case 251: /* ec_item: '(' ec_kind ',' cnum ',' cnum ')'  */
#line 728 "filter/config.Y"
                                                { (yyval.e) = f_new_ec_item((yyvsp[-5].ecs), 0, (yyvsp[-3].i32), (yyvsp[-1].i32), (yyvsp[-1].i32)); }
#line 8289 "obj/conf/cf-parse.tab.c"
    break;

  case 252: /* ec_item: '(' ec_kind ',' cnum ',' cnum DDOT cnum ')'  */
#line 729 "filter/config.Y"
                                                { (yyval.e) = f_new_ec_item((yyvsp[-7].ecs), 0, (yyvsp[-5].i32), (yyvsp[-3].i32), (yyvsp[-1].i32)); }
#line 8295 "obj/conf/cf-parse.tab.c"
    break;

  case 253: /* ec_item: '(' ec_kind ',' cnum ',' '*' ')'  */
#line 730 "filter/config.Y"
                                                { (yyval.e) = f_new_ec_item((yyvsp[-5].ecs), 0, (yyvsp[-3].i32), 0, EC_ALL); }
#line 8301 "obj/conf/cf-parse.tab.c"
    break;

  case 254: /* lc_item: '(' cnum ',' cnum ',' cnum ')'  */
#line 734 "filter/config.Y"
                                            { (yyval.e) = f_new_lc_item((yyvsp[-5].i32), (yyvsp[-5].i32), (yyvsp[-3].i32), (yyvsp[-3].i32), (yyvsp[-1].i32), (yyvsp[-1].i32)); }
#line 8307 "obj/conf/cf-parse.tab.c"
    break;

  case 255: /* lc_item: '(' cnum ',' cnum ',' cnum DDOT cnum ')'  */
#line 735 "filter/config.Y"
                                            { (yyval.e) = f_new_lc_item((yyvsp[-7].i32), (yyvsp[-7].i32), (yyvsp[-5].i32), (yyvsp[-5].i32), (yyvsp[-3].i32), (yyvsp[-1].i32)); }
#line 8313 "obj/conf/cf-parse.tab.c"
    break;

  case 256: /* lc_item: '(' cnum ',' cnum ',' '*' ')'  */
#line 736 "filter/config.Y"
                                            { (yyval.e) = f_new_lc_item((yyvsp[-5].i32), (yyvsp[-5].i32), (yyvsp[-3].i32), (yyvsp[-3].i32), 0, LC_ALL); }
#line 8319 "obj/conf/cf-parse.tab.c"
    break;

  case 257: /* lc_item: '(' cnum ',' cnum DDOT cnum ',' '*' ')'  */
#line 737 "filter/config.Y"
                                            { (yyval.e) = f_new_lc_item((yyvsp[-7].i32), (yyvsp[-7].i32), (yyvsp[-5].i32), (yyvsp[-3].i32), 0, LC_ALL); }
#line 8325 "obj/conf/cf-parse.tab.c"
    break;

  case 258: /* lc_item: '(' cnum ',' '*' ',' '*' ')'  */
#line 738 "filter/config.Y"
                                            { (yyval.e) = f_new_lc_item((yyvsp[-5].i32), (yyvsp[-5].i32), 0, LC_ALL, 0, LC_ALL); }
#line 8331 "obj/conf/cf-parse.tab.c"
    break;

  case 259: /* lc_item: '(' cnum DDOT cnum ',' '*' ',' '*' ')'  */
#line 739 "filter/config.Y"
                                            { (yyval.e) = f_new_lc_item((yyvsp[-7].i32), (yyvsp[-5].i32), 0, LC_ALL, 0, LC_ALL); }
#line 8337 "obj/conf/cf-parse.tab.c"
    break;

  case 260: /* lc_item: '(' '*' ',' '*' ',' '*' ')'  */
#line 740 "filter/config.Y"
                                            { (yyval.e) = f_new_lc_item(0, LC_ALL, 0, LC_ALL, 0, LC_ALL); }
#line 8343 "obj/conf/cf-parse.tab.c"
    break;

  case 261: /* lc_item: '(' cnum ',' cnum ',' cnum ')' DDOT '(' cnum ',' cnum ',' cnum ')'  */
#line 742 "filter/config.Y"
   { (yyval.e) = f_new_lc_item((yyvsp[-13].i32), (yyvsp[-5].i32), (yyvsp[-11].i32), (yyvsp[-3].i32), (yyvsp[-9].i32), (yyvsp[-1].i32)); }
#line 8349 "obj/conf/cf-parse.tab.c"
    break;

  case 265: /* set_item: set_atom  */
#line 749 "filter/config.Y"
            { (yyval.e) = f_new_item((yyvsp[0].v), (yyvsp[0].v)); }
#line 8355 "obj/conf/cf-parse.tab.c"
    break;

  case 266: /* set_item: set_atom DDOT set_atom  */
#line 750 "filter/config.Y"
                          { (yyval.e) = f_new_item((yyvsp[-2].v), (yyvsp[0].v)); }
#line 8361 "obj/conf/cf-parse.tab.c"
    break;

  case 270: /* switch_item: switch_atom  */
#line 757 "filter/config.Y"
               { (yyval.e) = f_new_item((yyvsp[0].v), (yyvsp[0].v)); }
#line 8367 "obj/conf/cf-parse.tab.c"
    break;

  case 271: /* switch_item: switch_atom DDOT switch_atom  */
#line 758 "filter/config.Y"
                                { (yyval.e) = f_new_item((yyvsp[-2].v), (yyvsp[0].v)); }
#line 8373 "obj/conf/cf-parse.tab.c"
    break;

  case 273: /* ec_items: ec_items ',' ec_item  */
#line 763 "filter/config.Y"
                        { (yyval.e) = f_merge_items((yyvsp[-2].e), (yyvsp[0].e)); }
#line 8379 "obj/conf/cf-parse.tab.c"
    break;

  case 275: /* set_items: set_items ',' set_item  */
#line 768 "filter/config.Y"
                          { (yyval.e) = f_merge_items((yyvsp[-2].e), (yyvsp[0].e)); }
#line 8385 "obj/conf/cf-parse.tab.c"
    break;

  case 277: /* switch_items: switch_items ',' switch_item  */
#line 773 "filter/config.Y"
                                { (yyval.e) = f_merge_items((yyvsp[-2].e), (yyvsp[0].e)); }
#line 8391 "obj/conf/cf-parse.tab.c"
    break;

  case 278: /* fprefix: net_ip_  */
#line 777 "filter/config.Y"
                { (yyval.px).net = (yyvsp[0].net); (yyval.px).lo = (yyvsp[0].net).pxlen; (yyval.px).hi = (yyvsp[0].net).pxlen; }
#line 8397 "obj/conf/cf-parse.tab.c"
    break;

  case 279: /* fprefix: net_ip_ '+'  */
#line 778 "filter/config.Y"
                { (yyval.px).net = (yyvsp[-1].net); (yyval.px).lo = (yyvsp[-1].net).pxlen; (yyval.px).hi = net_max_prefix_length[(yyvsp[-1].net).type]; }
#line 8403 "obj/conf/cf-parse.tab.c"
    break;

  case 280: /* fprefix: net_ip_ '-'  */
#line 779 "filter/config.Y"
                { (yyval.px).net = (yyvsp[-1].net); (yyval.px).lo = 0; (yyval.px).hi = (yyvsp[-1].net).pxlen; }
#line 8409 "obj/conf/cf-parse.tab.c"
    break;

  case 281: /* fprefix: net_ip_ '{' NUM ',' NUM '}'  */
#line 780 "filter/config.Y"
                               {
     (yyval.px).net = (yyvsp[-5].net); (yyval.px).lo = (yyvsp[-3].i); (yyval.px).hi = (yyvsp[-1].i);
     if (((yyvsp[-3].i) > (yyvsp[-1].i)) || ((yyvsp[-1].i) > net_max_prefix_length[(yyvsp[-5].net).type]))
       cf_error("Invalid prefix pattern range: {%u, %u}", (yyvsp[-3].i), (yyvsp[-1].i));
   }
#line 8419 "obj/conf/cf-parse.tab.c"
    break;

  case 282: /* fprefix_set: fprefix  */
#line 788 "filter/config.Y"
           { (yyval.trie) = f_new_trie(cfg_mem, 0); trie_add_prefix((yyval.trie), &((yyvsp[0].px).net), (yyvsp[0].px).lo, (yyvsp[0].px).hi); }
#line 8425 "obj/conf/cf-parse.tab.c"
    break;

  case 283: /* fprefix_set: fprefix_set ',' fprefix  */
#line 789 "filter/config.Y"
                           { (yyval.trie) = (yyvsp[-2].trie); if (!trie_add_prefix((yyval.trie), &((yyvsp[0].px).net), (yyvsp[0].px).lo, (yyvsp[0].px).hi)) cf_error("Mixed IPv4/IPv6 prefixes in prefix set"); }
#line 8431 "obj/conf/cf-parse.tab.c"
    break;

  case 284: /* switch_body: %empty  */
#line 792 "filter/config.Y"
                         { (yyval.e) = NULL; }
#line 8437 "obj/conf/cf-parse.tab.c"
    break;

  case 285: /* switch_body: switch_body switch_items ':' cmd  */
#line 793 "filter/config.Y"
                                    {
     /* Fill data fields */
     struct f_tree *t;
     for (t = (yyvsp[-2].e); t; t = t->left)
       t->data = (yyvsp[0].x);
     (yyval.e) = f_merge_items((yyvsp[-3].e), (yyvsp[-2].e));
   }
#line 8449 "obj/conf/cf-parse.tab.c"
    break;

  case 286: /* switch_body: switch_body ELSECOL cmd  */
#line 800 "filter/config.Y"
                           {
     struct f_tree *t = f_new_tree();
     t->from.type = t->to.type = T_VOID;
     t->right = t;
     t->data = (yyvsp[0].x);
     (yyval.e) = f_merge_items((yyvsp[-2].e), t);
 }
#line 8461 "obj/conf/cf-parse.tab.c"
    break;

  case 287: /* bgp_path_expr: lvalue  */
#line 810 "filter/config.Y"
          { (yyval.x) = f_lval_getter(&(yyvsp[0].flv)); }
#line 8467 "obj/conf/cf-parse.tab.c"
    break;

  case 288: /* bgp_path_expr: '(' term ')'  */
#line 811 "filter/config.Y"
                { (yyval.x) = (yyvsp[-1].x); }
#line 8473 "obj/conf/cf-parse.tab.c"
    break;

  case 289: /* bgp_path: PO bgp_path_tail PC  */
#line 815 "filter/config.Y"
                         { (yyval.x) = (yyvsp[-1].x); }
#line 8479 "obj/conf/cf-parse.tab.c"
    break;

  case 290: /* bgp_path_tail: NUM bgp_path_tail  */
#line 819 "filter/config.Y"
                                { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PATH_MASK_ITEM, .val.pmi = { .asn = (yyvsp[-1].i), .kind = PM_ASN, }, }); (yyval.x)->next = (yyvsp[0].x);  }
#line 8485 "obj/conf/cf-parse.tab.c"
    break;

  case 291: /* bgp_path_tail: NUM DDOT NUM bgp_path_tail  */
#line 820 "filter/config.Y"
                                { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PATH_MASK_ITEM, .val.pmi = { .from = (yyvsp[-3].i), .to = (yyvsp[-1].i), .kind = PM_ASN_RANGE }, }); (yyval.x)->next = (yyvsp[0].x); }
#line 8491 "obj/conf/cf-parse.tab.c"
    break;

  case 292: /* bgp_path_tail: '[' ']' bgp_path_tail  */
#line 821 "filter/config.Y"
                         { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PATH_MASK_ITEM, .val.pmi = { .set = NULL, .kind = PM_ASN_SET }, }); (yyval.x)->next = (yyvsp[0].x); }
#line 8497 "obj/conf/cf-parse.tab.c"
    break;

  case 293: /* bgp_path_tail: '[' set_items ']' bgp_path_tail  */
#line 822 "filter/config.Y"
                                   {
   if ((yyvsp[-2].e)->from.type != T_INT) cf_error("Only integer sets allowed in path mask");
   (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PATH_MASK_ITEM, .val.pmi = { .set = build_tree((yyvsp[-2].e)), .kind = PM_ASN_SET }, }); (yyval.x)->next = (yyvsp[0].x);
 }
#line 8506 "obj/conf/cf-parse.tab.c"
    break;

  case 294: /* bgp_path_tail: '*' bgp_path_tail  */
#line 826 "filter/config.Y"
                                { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PATH_MASK_ITEM, .val.pmi = { .kind = PM_ASTERISK }, }); (yyval.x)->next = (yyvsp[0].x); }
#line 8512 "obj/conf/cf-parse.tab.c"
    break;

  case 295: /* bgp_path_tail: '?' bgp_path_tail  */
#line 827 "filter/config.Y"
                                { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PATH_MASK_ITEM, .val.pmi = { .kind = PM_QUESTION }, }); (yyval.x)->next = (yyvsp[0].x); }
#line 8518 "obj/conf/cf-parse.tab.c"
    break;

  case 296: /* bgp_path_tail: '+' bgp_path_tail  */
#line 828 "filter/config.Y"
                                { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PATH_MASK_ITEM, .val.pmi = { .kind = PM_LOOP }, }); (yyval.x)->next = (yyvsp[0].x); }
#line 8524 "obj/conf/cf-parse.tab.c"
    break;

  case 297: /* bgp_path_tail: bgp_path_expr bgp_path_tail  */
#line 829 "filter/config.Y"
                                { (yyval.x) = (yyvsp[-1].x); (yyval.x)->next = (yyvsp[0].x); }
#line 8530 "obj/conf/cf-parse.tab.c"
    break;

  case 298: /* bgp_path_tail: %empty  */
#line 830 "filter/config.Y"
                                { (yyval.x) = NULL; }
#line 8536 "obj/conf/cf-parse.tab.c"
    break;

  case 299: /* constant: NUM  */
#line 834 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_INT, .val.i = (yyvsp[0].i), }); }
#line 8542 "obj/conf/cf-parse.tab.c"
    break;

  case 300: /* constant: TRUE  */
#line 835 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_BOOL, .val.i = 1, }); }
#line 8548 "obj/conf/cf-parse.tab.c"
    break;

  case 301: /* constant: FALSE  */
#line 836 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_BOOL, .val.i = 0, }); }
#line 8554 "obj/conf/cf-parse.tab.c"
    break;

  case 302: /* constant: TEXT  */
#line 837 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_STRING, .val.s = (yyvsp[0].t), }); }
#line 8560 "obj/conf/cf-parse.tab.c"
    break;

  case 303: /* constant: BYTETEXT  */
#line 838 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_BYTESTRING, .val.bs = (yyvsp[0].bs), }); }
#line 8566 "obj/conf/cf-parse.tab.c"
    break;

  case 304: /* constant: fipa  */
#line 839 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (yyvsp[0].v)); }
#line 8572 "obj/conf/cf-parse.tab.c"
    break;

  case 305: /* constant: VPN_RD  */
#line 840 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_RD, .val.rd = (yyvsp[0].rd), }); }
#line 8578 "obj/conf/cf-parse.tab.c"
    break;

  case 306: /* constant: net_  */
#line 841 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_NET, .val.net = (yyvsp[0].net_ptr), }); }
#line 8584 "obj/conf/cf-parse.tab.c"
    break;

  case 307: /* constant: '[' ']'  */
#line 842 "filter/config.Y"
           { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_SET, .val.t = NULL, }); }
#line 8590 "obj/conf/cf-parse.tab.c"
    break;

  case 308: /* constant: '[' set_items ']'  */
#line 843 "filter/config.Y"
                     {
     DBG( "We've got a set here..." );
     (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_SET, .val.t = build_tree((yyvsp[-1].e)), });
     DBG( "ook\n" );
 }
#line 8600 "obj/conf/cf-parse.tab.c"
    break;

  case 309: /* constant: '[' fprefix_set ']'  */
#line 848 "filter/config.Y"
                       { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_PREFIX_SET, .val.ti = (yyvsp[-1].trie), }); }
#line 8606 "obj/conf/cf-parse.tab.c"
    break;

  case 310: /* constant: ENUM_TOKEN  */
#line 849 "filter/config.Y"
              { (yyval.x) = f_new_inst(FI_CONSTANT, (struct f_val) { .type = (yyvsp[0].i) >> 16, .val.i = (yyvsp[0].i) & 0xffff, }); }
#line 8612 "obj/conf/cf-parse.tab.c"
    break;

  case 311: /* constructor: '(' term ',' term ')'  */
#line 853 "filter/config.Y"
                         { (yyval.x) = f_new_inst(FI_PAIR_CONSTRUCT, (yyvsp[-3].x), (yyvsp[-1].x)); }
#line 8618 "obj/conf/cf-parse.tab.c"
    break;

  case 312: /* constructor: '(' ec_kind ',' term ',' term ')'  */
#line 854 "filter/config.Y"
                                     { (yyval.x) = f_new_inst(FI_EC_CONSTRUCT, (yyvsp[-3].x), (yyvsp[-1].x), (yyvsp[-5].ecs)); }
#line 8624 "obj/conf/cf-parse.tab.c"
    break;

  case 313: /* constructor: '(' term ',' term ',' term ')'  */
#line 855 "filter/config.Y"
                                  { (yyval.x) = f_new_inst(FI_LC_CONSTRUCT, (yyvsp[-5].x), (yyvsp[-3].x), (yyvsp[-1].x)); }
#line 8630 "obj/conf/cf-parse.tab.c"
    break;

  case 314: /* constructor: bgp_path  */
#line 856 "filter/config.Y"
            { (yyval.x) = f_new_inst(FI_PATHMASK_CONSTRUCT, (yyvsp[0].x)); }
#line 8636 "obj/conf/cf-parse.tab.c"
    break;

  case 315: /* var_list_r: %empty  */
#line 862 "filter/config.Y"
               { (yyval.x) = NULL; }
#line 8642 "obj/conf/cf-parse.tab.c"
    break;

  case 316: /* var_list_r: term  */
#line 863 "filter/config.Y"
        { (yyval.x) = (yyvsp[0].x); }
#line 8648 "obj/conf/cf-parse.tab.c"
    break;

  case 317: /* var_list_r: var_list_r ',' term  */
#line 864 "filter/config.Y"
                       { (yyval.x) = (yyvsp[0].x); (yyval.x)->next = (yyvsp[-2].x); }
#line 8654 "obj/conf/cf-parse.tab.c"
    break;

  case 318: /* var_list: var_list_r  */
#line 868 "filter/config.Y"
   {
     (yyval.x) = NULL;

     /* Revert the var_list_r */
     while ((yyvsp[0].x)) {
       struct f_inst *tmp = (yyvsp[0].x);
       (yyvsp[0].x) = (yyvsp[0].x)->next;

       tmp->next = (yyval.x);
       (yyval.x) = tmp;
     }
   }
#line 8671 "obj/conf/cf-parse.tab.c"
    break;

  case 319: /* function_call: CF_SYM_KNOWN '(' var_list ')'  */
#line 884 "filter/config.Y"
   {
     if ((yyvsp[-3].s)->class != SYM_FUNCTION)
       cf_error("You can't call something which is not a function. Really.");

     (yyval.x) = f_new_inst(FI_CALL, (yyvsp[-1].x), (yyvsp[-3].s));
   }
#line 8682 "obj/conf/cf-parse.tab.c"
    break;

  case 320: /* static_attr: GW  */
#line 894 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_IP,         SA_GW,	0); }
#line 8688 "obj/conf/cf-parse.tab.c"
    break;

  case 321: /* static_attr: NET  */
#line 895 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_NET,	  SA_NET,	1); }
#line 8694 "obj/conf/cf-parse.tab.c"
    break;

  case 322: /* static_attr: PROTO  */
#line 896 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_STRING,     SA_PROTO,	1); }
#line 8700 "obj/conf/cf-parse.tab.c"
    break;

  case 323: /* static_attr: DEST  */
#line 897 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_ENUM_RTD,   SA_DEST,	0); }
#line 8706 "obj/conf/cf-parse.tab.c"
    break;

  case 324: /* static_attr: IFNAME  */
#line 898 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_STRING,     SA_IFNAME,	0); }
#line 8712 "obj/conf/cf-parse.tab.c"
    break;

  case 325: /* static_attr: IFINDEX  */
#line 899 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_INT,        SA_IFINDEX,	1); }
#line 8718 "obj/conf/cf-parse.tab.c"
    break;

  case 326: /* static_attr: WEIGHT  */
#line 900 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_INT,        SA_WEIGHT,	0); }
#line 8724 "obj/conf/cf-parse.tab.c"
    break;

  case 327: /* static_attr: GW_MPLS  */
#line 901 "filter/config.Y"
           { (yyval.fsa) = f_new_static_attr(T_INT,        SA_GW_MPLS,	0); }
#line 8730 "obj/conf/cf-parse.tab.c"
    break;

  case 328: /* $@7: %empty  */
#line 904 "filter/config.Y"
                          { f_method_call_start((yyvsp[-1].x)); }
#line 8736 "obj/conf/cf-parse.tab.c"
    break;

  case 329: /* term_dot_method: term '.' $@7 method_name_cont  */
#line 904 "filter/config.Y"
                                                                        { f_method_call_end(); (yyval.x) = (yyvsp[0].x); }
#line 8742 "obj/conf/cf-parse.tab.c"
    break;

  case 330: /* method_name_cont: CF_SYM_METHOD_BARE  */
#line 906 "filter/config.Y"
                      {
     (yyval.x) = f_dispatch_method((yyvsp[0].s), FM.object, NULL, 1);
   }
#line 8750 "obj/conf/cf-parse.tab.c"
    break;

  case 331: /* $@8: %empty  */
#line 909 "filter/config.Y"
                      {
     f_method_call_args();
   }
#line 8758 "obj/conf/cf-parse.tab.c"
    break;

  case 332: /* method_name_cont: CF_SYM_METHOD_ARGS $@8 '(' var_list ')'  */
#line 911 "filter/config.Y"
                      {
     (yyval.x) = f_dispatch_method((yyvsp[-4].s), FM.object, (yyvsp[-1].x), 1);
   }
#line 8766 "obj/conf/cf-parse.tab.c"
    break;

  case 333: /* method_name_cont: static_attr  */
#line 914 "filter/config.Y"
               {
     if (FM.object->type != T_ROUTE)
       cf_error("Getting a route attribute from %s, need a route", f_type_name(FM.object->type));
     (yyval.x) = f_new_inst(FI_RTA_GET, FM.object, (yyvsp[0].fsa));
   }
#line 8776 "obj/conf/cf-parse.tab.c"
    break;

  case 334: /* method_name_cont: CF_SYM_KNOWN  */
#line 919 "filter/config.Y"
                {
     if ((yyvsp[0].s)->class != SYM_ATTRIBUTE)
       cf_error("Not a method of %s: %s", f_type_name(FM.object->type), (yyvsp[0].s)->name);
     if (FM.object->type != T_ROUTE)
       cf_error("Getting a route attribute from %s, need a route", f_type_name(FM.object->type));
     (yyval.x) = f_new_inst(FI_EA_GET, FM.object, (yyvsp[0].s)->attribute);
   }
#line 8788 "obj/conf/cf-parse.tab.c"
    break;

  case 335: /* term: '(' term ')'  */
#line 929 "filter/config.Y"
                        { (yyval.x) = (yyvsp[-1].x); }
#line 8794 "obj/conf/cf-parse.tab.c"
    break;

  case 336: /* term: term '+' term  */
#line 930 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_ADD, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 8800 "obj/conf/cf-parse.tab.c"
    break;

  case 337: /* term: term '-' term  */
#line 931 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_SUBTRACT, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 8806 "obj/conf/cf-parse.tab.c"
    break;

  case 338: /* term: term '*' term  */
#line 932 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_MULTIPLY, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 8812 "obj/conf/cf-parse.tab.c"
    break;

  case 339: /* term: term '/' term  */
#line 933 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_DIVIDE, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 8818 "obj/conf/cf-parse.tab.c"
    break;

  case 340: /* term: term '&' term  */
#line 934 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_BITAND, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 8824 "obj/conf/cf-parse.tab.c"
    break;

  case 341: /* term: term '|' term  */
#line 935 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_BITOR, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 8830 "obj/conf/cf-parse.tab.c"
    break;

  case 342: /* term: term AND term  */
#line 936 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_AND, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 8836 "obj/conf/cf-parse.tab.c"
    break;

  case 343: /* term: term OR term  */
#line 937 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_OR, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 8842 "obj/conf/cf-parse.tab.c"
    break;

  case 344: /* term: term '=' term  */
#line 938 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_EQ, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 8848 "obj/conf/cf-parse.tab.c"
    break;

  case 345: /* term: term NEQ term  */
#line 939 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_NEQ, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 8854 "obj/conf/cf-parse.tab.c"
    break;

  case 346: /* term: term '<' term  */
#line 940 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_LT, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 8860 "obj/conf/cf-parse.tab.c"
    break;

  case 347: /* term: term LEQ term  */
#line 941 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_LTE, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 8866 "obj/conf/cf-parse.tab.c"
    break;

  case 348: /* term: term '>' term  */
#line 942 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_LT, (yyvsp[0].x), (yyvsp[-2].x)); }
#line 8872 "obj/conf/cf-parse.tab.c"
    break;

  case 349: /* term: term GEQ term  */
#line 943 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_LTE, (yyvsp[0].x), (yyvsp[-2].x)); }
#line 8878 "obj/conf/cf-parse.tab.c"
    break;

  case 350: /* term: term '~' term  */
#line 944 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_MATCH, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 8884 "obj/conf/cf-parse.tab.c"
    break;

  case 351: /* term: term NMA term  */
#line 945 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_NOT_MATCH, (yyvsp[-2].x), (yyvsp[0].x)); }
#line 8890 "obj/conf/cf-parse.tab.c"
    break;

  case 352: /* term: '!' term  */
#line 946 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_NOT, (yyvsp[0].x)); }
#line 8896 "obj/conf/cf-parse.tab.c"
    break;

  case 353: /* term: DEFINED '(' term ')'  */
#line 947 "filter/config.Y"
                        { (yyval.x) = f_new_inst(FI_DEFINED, (yyvsp[-1].x)); }
#line 8902 "obj/conf/cf-parse.tab.c"
    break;

  case 354: /* term: constant  */
#line 949 "filter/config.Y"
            { (yyval.x) = (yyvsp[0].x); }
#line 8908 "obj/conf/cf-parse.tab.c"
    break;

  case 355: /* term: constructor  */
#line 950 "filter/config.Y"
               { (yyval.x) = (yyvsp[0].x); }
#line 8914 "obj/conf/cf-parse.tab.c"
    break;

  case 356: /* term: lvalue  */
#line 952 "filter/config.Y"
          { (yyval.x) = f_lval_getter(&(yyvsp[0].flv)); }
#line 8920 "obj/conf/cf-parse.tab.c"
    break;

  case 358: /* term: '+' EMPTY '+'  */
#line 956 "filter/config.Y"
                 { (yyval.x) = f_new_inst(FI_CONSTANT, f_get_empty(T_PATH)); }
#line 8926 "obj/conf/cf-parse.tab.c"
    break;

  case 359: /* term: '-' EMPTY '-'  */
#line 957 "filter/config.Y"
                 { (yyval.x) = f_new_inst(FI_CONSTANT, f_get_empty(T_CLIST)); }
#line 8932 "obj/conf/cf-parse.tab.c"
    break;

  case 360: /* term: '-' '-' EMPTY '-' '-'  */
#line 958 "filter/config.Y"
                         { (yyval.x) = f_new_inst(FI_CONSTANT, f_get_empty(T_ECLIST)); }
#line 8938 "obj/conf/cf-parse.tab.c"
    break;

  case 361: /* term: '-' '-' '-' EMPTY '-' '-' '-'  */
#line 959 "filter/config.Y"
                                 { (yyval.x) = f_new_inst(FI_CONSTANT, f_get_empty(T_LCLIST)); }
#line 8944 "obj/conf/cf-parse.tab.c"
    break;

  case 362: /* term: PREPEND '(' term ',' term ')'  */
#line 961 "filter/config.Y"
                                 { (yyval.x) = f_dispatch_method_x("prepend", (yyvsp[-3].x)->type, (yyvsp[-3].x), (yyvsp[-1].x)); }
#line 8950 "obj/conf/cf-parse.tab.c"
    break;

  case 363: /* term: ADD '(' term ',' term ')'  */
#line 962 "filter/config.Y"
                             { (yyval.x) = f_dispatch_method_x("add", (yyvsp[-3].x)->type, (yyvsp[-3].x), (yyvsp[-1].x)); }
#line 8956 "obj/conf/cf-parse.tab.c"
    break;

  case 364: /* term: DELETE '(' term ',' term ')'  */
#line 963 "filter/config.Y"
                                { (yyval.x) = f_dispatch_method_x("delete", (yyvsp[-3].x)->type, (yyvsp[-3].x), (yyvsp[-1].x)); }
#line 8962 "obj/conf/cf-parse.tab.c"
    break;

  case 365: /* term: FILTER '(' term ',' term ')'  */
#line 964 "filter/config.Y"
                                { (yyval.x) = f_dispatch_method_x("filter", (yyvsp[-3].x)->type, (yyvsp[-3].x), (yyvsp[-1].x)); }
#line 8968 "obj/conf/cf-parse.tab.c"
    break;

  case 366: /* term: ROA_CHECK '(' rtable ')'  */
#line 966 "filter/config.Y"
                            { (yyval.x) = f_implicit_roa_check((yyvsp[-1].r)); }
#line 8974 "obj/conf/cf-parse.tab.c"
    break;

  case 367: /* term: ROA_CHECK '(' rtable ',' term ',' term ')'  */
#line 967 "filter/config.Y"
                                              { (yyval.x) = f_new_inst(FI_ROA_CHECK, (yyvsp[-3].x), (yyvsp[-1].x), (yyvsp[-5].r)); }
#line 8980 "obj/conf/cf-parse.tab.c"
    break;

  case 368: /* term: ASPA_CHECK '(' rtable ',' term ',' term ')'  */
#line 968 "filter/config.Y"
                                               { (yyval.x) = f_new_inst(FI_ASPA_CHECK_EXPLICIT, (yyvsp[-3].x), (yyvsp[-1].x), (yyvsp[-5].r)); }
#line 8986 "obj/conf/cf-parse.tab.c"
    break;

  case 369: /* term: FORMAT '(' term ')'  */
#line 970 "filter/config.Y"
                       {  (yyval.x) = f_new_inst(FI_FORMAT, (yyvsp[-1].x)); }
#line 8992 "obj/conf/cf-parse.tab.c"
    break;

  case 372: /* term_bs: FROM_HEX '(' term ')'  */
#line 977 "filter/config.Y"
                         { (yyval.x) = f_new_inst(FI_FROM_HEX, (yyvsp[-1].x)); }
#line 8998 "obj/conf/cf-parse.tab.c"
    break;

  case 373: /* break_command: ACCEPT  */
#line 981 "filter/config.Y"
          { (yyval.fret) = F_ACCEPT; }
#line 9004 "obj/conf/cf-parse.tab.c"
    break;

  case 374: /* break_command: REJECT  */
#line 982 "filter/config.Y"
          { (yyval.fret) = F_REJECT; }
#line 9010 "obj/conf/cf-parse.tab.c"
    break;

  case 375: /* break_command: ERROR  */
#line 983 "filter/config.Y"
         { (yyval.fret) = F_ERROR; }
#line 9016 "obj/conf/cf-parse.tab.c"
    break;

  case 376: /* var: type symbol '=' term ';'  */
#line 987 "filter/config.Y"
                            {
     struct symbol *sym = cf_define_symbol(new_config, (yyvsp[-3].s), SYM_VARIABLE | (yyvsp[-4].i), offset, f_new_var(sym_->scope));
     (yyval.x) = f_new_inst(FI_VAR_INIT, (yyvsp[-1].x), sym);
   }
#line 9025 "obj/conf/cf-parse.tab.c"
    break;

  case 377: /* var: type symbol ';'  */
#line 991 "filter/config.Y"
                   {
     struct symbol *sym = cf_define_symbol(new_config, (yyvsp[-1].s), SYM_VARIABLE | (yyvsp[-2].i), offset, f_new_var(sym_->scope));
     (yyval.x) = f_new_inst(FI_VAR_INIT0, sym);
   }
#line 9034 "obj/conf/cf-parse.tab.c"
    break;

  case 378: /* for_var: type symbol  */
#line 998 "filter/config.Y"
               { (yyval.s) = cf_define_symbol(new_config, (yyvsp[0].s), SYM_VARIABLE | (yyvsp[-1].i), offset, f_new_var(sym_->scope)); }
#line 9040 "obj/conf/cf-parse.tab.c"
    break;

  case 379: /* for_var: CF_SYM_KNOWN  */
#line 999 "filter/config.Y"
                { cf_error("Use of a pre-defined variable in for loop is not allowed"); }
#line 9046 "obj/conf/cf-parse.tab.c"
    break;

  case 380: /* $@9: %empty  */
#line 1003 "filter/config.Y"
       { cf_push_soft_scope(new_config); }
#line 9052 "obj/conf/cf-parse.tab.c"
    break;

  case 381: /* $@10: %empty  */
#line 1003 "filter/config.Y"
                                                { cf_pop_soft_scope(new_config); }
#line 9058 "obj/conf/cf-parse.tab.c"
    break;

  case 382: /* cmd: '{' $@9 cmds $@10 '}'  */
#line 1003 "filter/config.Y"
                                                                                       { (yyval.x) = (yyvsp[-2].x); }
#line 9064 "obj/conf/cf-parse.tab.c"
    break;

  case 383: /* cmd: IF term THEN cmd  */
#line 1004 "filter/config.Y"
                    {
     (yyval.x) = f_new_inst(FI_CONDITION, (yyvsp[-2].x), (yyvsp[0].x), NULL);
   }
#line 9072 "obj/conf/cf-parse.tab.c"
    break;

  case 384: /* cmd: IF term THEN cmd ELSE cmd  */
#line 1007 "filter/config.Y"
                             {
     (yyval.x) = f_new_inst(FI_CONDITION, (yyvsp[-4].x), (yyvsp[-2].x), (yyvsp[0].x));
   }
#line 9080 "obj/conf/cf-parse.tab.c"
    break;

  case 385: /* $@11: %empty  */
#line 1010 "filter/config.Y"
       {
     /* Reserve space for walk data on stack */
     cf_push_block_scope(new_config);
     new_config->current_scope->slots += 2;
   }
#line 9090 "obj/conf/cf-parse.tab.c"
    break;

  case 386: /* $@12: %empty  */
#line 1016 "filter/config.Y"
   { this_for_scope = new_config->current_scope; new_config->current_scope = this_for_scope->next; }
#line 9096 "obj/conf/cf-parse.tab.c"
    break;

  case 387: /* $@13: %empty  */
#line 1018 "filter/config.Y"
   { new_config->current_scope = this_for_scope; this_for_scope = NULL; }
#line 9102 "obj/conf/cf-parse.tab.c"
    break;

  case 388: /* cmd: FOR $@11 for_var IN $@12 term $@13 DO cmd  */
#line 1019 "filter/config.Y"
          {
     cf_pop_block_scope(new_config);
     (yyval.x) = f_for_cycle((yyvsp[-6].s), (yyvsp[-3].x), (yyvsp[0].x));
   }
#line 9111 "obj/conf/cf-parse.tab.c"
    break;

  case 389: /* cmd: lvalue '=' term ';'  */
#line 1023 "filter/config.Y"
                       {
     (yyval.x) = f_lval_setter(&(yyvsp[-3].flv), (yyvsp[-1].x));
   }
#line 9119 "obj/conf/cf-parse.tab.c"
    break;

  case 390: /* cmd: RETURN term ';'  */
#line 1026 "filter/config.Y"
                   {
     DBG( "Ook, we'll return the value\n" );
     if (!this_function)
       cf_error("Can't return from a non-function, use accept or reject instead.");
     if (this_function->function->return_type == T_VOID)
     {
       if ((yyvsp[-1].x)->type != T_VOID)
	 cf_warn("Inferring function %s return type from its return value: %s", this_function->name, f_type_name((yyvsp[-1].x)->type));
       ((struct f_line *) this_function->function)->return_type = (yyvsp[-1].x)->type;
     }
     else if (this_function->function->return_type != (yyvsp[-1].x)->type)
       cf_error("Can't return type %s from function %s, expected %s",
		f_type_name((yyvsp[-1].x)->type), this_function->name, f_type_name(this_function->function->return_type));

     (yyval.x) = f_new_inst(FI_RETURN, (yyvsp[-1].x));
   }
#line 9140 "obj/conf/cf-parse.tab.c"
    break;

  case 391: /* cmd: UNSET '(' CF_SYM_KNOWN ')' ';'  */
#line 1042 "filter/config.Y"
                                  {
     if ((yyvsp[-2].s)->class != SYM_ATTRIBUTE)
       cf_error("Can't unset %s", (yyvsp[-2].s)->name);
     if ((yyvsp[-2].s)->attribute->readonly)
       cf_error("Attribute %s is read-only", (yyvsp[-2].s)->attribute->name);
     (yyval.x) = f_new_inst(FI_EA_UNSET, (yyvsp[-2].s)->attribute);
   }
#line 9152 "obj/conf/cf-parse.tab.c"
    break;

  case 392: /* cmd: break_command var_list_r ';'  */
#line 1049 "filter/config.Y"
                                {
    (yyval.x) = f_print((yyvsp[-1].x), !!(yyvsp[-1].x), (yyvsp[-2].fret));
   }
#line 9160 "obj/conf/cf-parse.tab.c"
    break;

  case 393: /* cmd: PRINT var_list_r ';'  */
#line 1052 "filter/config.Y"
                        {
    (yyval.x) = f_print((yyvsp[-1].x), 1, F_NOP);
   }
#line 9168 "obj/conf/cf-parse.tab.c"
    break;

  case 394: /* cmd: PRINTN var_list_r ';'  */
#line 1055 "filter/config.Y"
                         {
    (yyval.x) = f_print((yyvsp[-1].x), 0, F_NOP);
   }
#line 9176 "obj/conf/cf-parse.tab.c"
    break;

  case 395: /* cmd: function_call ';'  */
#line 1058 "filter/config.Y"
                     { (yyval.x) = f_new_inst(FI_DROP_RESULT, (yyvsp[-1].x)); }
#line 9182 "obj/conf/cf-parse.tab.c"
    break;

  case 396: /* cmd: CASE term '{' switch_body '}'  */
#line 1059 "filter/config.Y"
                                 {
      (yyval.x) = f_new_inst(FI_SWITCH, (yyvsp[-3].x), (yyvsp[-1].e));
   }
#line 9190 "obj/conf/cf-parse.tab.c"
    break;

  case 397: /* $@14: %empty  */
#line 1062 "filter/config.Y"
              {
     f_method_call_start(f_lval_getter(&(yyvsp[-1].flv)));
   }
#line 9198 "obj/conf/cf-parse.tab.c"
    break;

  case 398: /* cmd: lvalue '.' $@14 method_name_cont ';'  */
#line 1064 "filter/config.Y"
                          {
     f_method_call_end();
     (yyval.x) = f_lval_setter(&(yyvsp[-4].flv), (yyvsp[-1].x));
   }
#line 9207 "obj/conf/cf-parse.tab.c"
    break;

  case 399: /* cmd: BT_ASSERT '(' get_cf_position term get_cf_position ')' ';'  */
#line 1068 "filter/config.Y"
                                                              { (yyval.x) = assert_done((yyvsp[-3].x), (yyvsp[-4].t) + 1, (yyvsp[-2].t) - 1); }
#line 9213 "obj/conf/cf-parse.tab.c"
    break;

  case 400: /* cmd: BT_CHECK_ASSIGN '(' get_cf_position lvalue get_cf_position ',' term ')' ';'  */
#line 1069 "filter/config.Y"
                                                                               { (yyval.x) = assert_assign(&(yyvsp[-5].flv), (yyvsp[-2].x), (yyvsp[-6].t) + 1, (yyvsp[-4].t) - 1); }
#line 9219 "obj/conf/cf-parse.tab.c"
    break;

  case 401: /* get_cf_position: %empty  */
#line 1073 "filter/config.Y"
{
  (yyval.t) = cf_text;
}
#line 9227 "obj/conf/cf-parse.tab.c"
    break;

  case 402: /* lvalue: CF_SYM_KNOWN  */
#line 1078 "filter/config.Y"
                {
     switch ((yyvsp[0].s)->class)
     {
       case SYM_CONSTANT_RANGE:
	 (yyval.flv) = (struct f_lval) { .type = F_LVAL_CONSTANT, .sym = (yyvsp[0].s), };
	 break;
       case SYM_VARIABLE_RANGE:
	 (yyval.flv) = (struct f_lval) { .type = F_LVAL_VARIABLE, .sym = (yyvsp[0].s), };
         break;
       case SYM_ATTRIBUTE:
         (yyval.flv) = (struct f_lval) { .type = F_LVAL_EA, .da = (yyvsp[0].s)->attribute, .rte = f_new_inst(FI_CURRENT_ROUTE), };
	 break;
       default:
	 cf_error("Variable name or attribute name required");
     }
   }
#line 9248 "obj/conf/cf-parse.tab.c"
    break;

  case 403: /* lvalue: static_attr  */
#line 1094 "filter/config.Y"
               { (yyval.flv) = (struct f_lval) { .type = F_LVAL_SA, .sa = (yyvsp[0].fsa), .rte = f_new_inst(FI_CURRENT_ROUTE), }; }
#line 9254 "obj/conf/cf-parse.tab.c"
    break;

  case 405: /* rtrid: ROUTER ID idval ';'  */
#line 209 "nest/config.Y"
                       { new_config->router_id = (yyvsp[-1].i32); }
#line 9260 "obj/conf/cf-parse.tab.c"
    break;

  case 406: /* rtrid: ROUTER ID FROM iface_patt ';'  */
#line 210 "nest/config.Y"
                                 { new_config->router_id_from = this_ipatt; }
#line 9266 "obj/conf/cf-parse.tab.c"
    break;

  case 407: /* idval: NUM  */
#line 214 "nest/config.Y"
       { (yyval.i32) = (yyvsp[0].i); }
#line 9272 "obj/conf/cf-parse.tab.c"
    break;

  case 408: /* idval: '(' term ')'  */
#line 215 "nest/config.Y"
                { (yyval.i32) = cf_eval_int((yyvsp[-1].x)); }
#line 9278 "obj/conf/cf-parse.tab.c"
    break;

  case 409: /* idval: IP4  */
#line 216 "nest/config.Y"
       { (yyval.i32) = ip4_to_u32((yyvsp[0].ip4)); }
#line 9284 "obj/conf/cf-parse.tab.c"
    break;

  case 410: /* idval: CF_SYM_KNOWN  */
#line 217 "nest/config.Y"
                {
     if ((yyvsp[0].s)->class == (SYM_CONSTANT | T_INT) || (yyvsp[0].s)->class == (SYM_CONSTANT | T_QUAD))
       (yyval.i32) = SYM_VAL((yyvsp[0].s)).i;
     else if (((yyvsp[0].s)->class == (SYM_CONSTANT | T_IP)) && ipa_is_ip4(SYM_VAL((yyvsp[0].s)).ip))
       (yyval.i32) = ipa_to_u32(SYM_VAL((yyvsp[0].s)).ip);
     else
       cf_error("Number or IPv4 address constant expected");
   }
#line 9297 "obj/conf/cf-parse.tab.c"
    break;

  case 412: /* hostname_override: HOSTNAME text ';'  */
#line 229 "nest/config.Y"
                                     { new_config->hostname = (yyvsp[-1].t); }
#line 9303 "obj/conf/cf-parse.tab.c"
    break;

  case 414: /* gr_opts: GRACEFUL RESTART WAIT expr ';'  */
#line 233 "nest/config.Y"
                                        { new_config->gr_wait = (yyvsp[-1].i); }
#line 9309 "obj/conf/cf-parse.tab.c"
    break;

  case 415: /* net_type_base: IPV4  */
#line 239 "nest/config.Y"
        { (yyval.i) = NET_IP4; }
#line 9315 "obj/conf/cf-parse.tab.c"
    break;

  case 416: /* net_type_base: IPV6  */
#line 240 "nest/config.Y"
        { (yyval.i) = NET_IP6; }
#line 9321 "obj/conf/cf-parse.tab.c"
    break;

  case 417: /* net_type_base: IPV6 SADR  */
#line 241 "nest/config.Y"
             { (yyval.i) = NET_IP6_SADR; }
#line 9327 "obj/conf/cf-parse.tab.c"
    break;

  case 418: /* net_type_base: VPN4  */
#line 242 "nest/config.Y"
        { (yyval.i) = NET_VPN4; }
#line 9333 "obj/conf/cf-parse.tab.c"
    break;

  case 419: /* net_type_base: VPN6  */
#line 243 "nest/config.Y"
        { (yyval.i) = NET_VPN6; }
#line 9339 "obj/conf/cf-parse.tab.c"
    break;

  case 420: /* net_type_base: ROA4  */
#line 244 "nest/config.Y"
        { (yyval.i) = NET_ROA4; }
#line 9345 "obj/conf/cf-parse.tab.c"
    break;

  case 421: /* net_type_base: ROA6  */
#line 245 "nest/config.Y"
        { (yyval.i) = NET_ROA6; }
#line 9351 "obj/conf/cf-parse.tab.c"
    break;

  case 422: /* net_type_base: FLOW4  */
#line 246 "nest/config.Y"
        { (yyval.i) = NET_FLOW4; }
#line 9357 "obj/conf/cf-parse.tab.c"
    break;

  case 423: /* net_type_base: FLOW6  */
#line 247 "nest/config.Y"
        { (yyval.i) = NET_FLOW6; }
#line 9363 "obj/conf/cf-parse.tab.c"
    break;

  case 424: /* net_type_base: ASPA  */
#line 248 "nest/config.Y"
        { (yyval.i) = NET_ASPA; }
#line 9369 "obj/conf/cf-parse.tab.c"
    break;

  case 426: /* net_type: MPLS  */
#line 253 "nest/config.Y"
        { (yyval.i) = NET_MPLS; }
#line 9375 "obj/conf/cf-parse.tab.c"
    break;

  case 429: /* table_start: net_type TABLE symbol  */
#line 263 "nest/config.Y"
                                   {
   this_table = rt_new_table((yyvsp[0].s), (yyvsp[-2].i));
   }
#line 9383 "obj/conf/cf-parse.tab.c"
    break;

  case 431: /* table_sorted: SORTED  */
#line 270 "nest/config.Y"
          { this_table->sorted = 1; }
#line 9389 "obj/conf/cf-parse.tab.c"
    break;

  case 432: /* table_opt: SORTED bool  */
#line 274 "nest/config.Y"
               { this_table->sorted = (yyvsp[0].i); }
#line 9395 "obj/conf/cf-parse.tab.c"
    break;

  case 433: /* table_opt: DEBUG debug_mask  */
#line 275 "nest/config.Y"
                    { this_table->debug = (yyvsp[0].i); }
#line 9401 "obj/conf/cf-parse.tab.c"
    break;

  case 434: /* table_opt: TRIE bool  */
#line 276 "nest/config.Y"
             {
     if (!net_val_match(this_table->addr_type, NB_IP | NB_VPN | NB_ROA | NB_IP6_SADR))
       cf_error("Trie option not supported for %s table", net_label[this_table->addr_type]);
     this_table->trie_used = (yyvsp[0].i);
   }
#line 9411 "obj/conf/cf-parse.tab.c"
    break;

  case 435: /* table_opt: GC THRESHOLD expr  */
#line 281 "nest/config.Y"
                     { this_table->gc_threshold = (yyvsp[0].i); }
#line 9417 "obj/conf/cf-parse.tab.c"
    break;

  case 436: /* table_opt: GC PERIOD expr_us  */
#line 282 "nest/config.Y"
                     { this_table->gc_period = (uint) (yyvsp[0].time); if ((yyvsp[0].time) > 3600 S_) cf_error("GC period must be at most 3600 s"); }
#line 9423 "obj/conf/cf-parse.tab.c"
    break;

  case 437: /* table_opt: CORK THRESHOLD expr expr  */
#line 283 "nest/config.Y"
                            {
     if ((yyvsp[-1].i) > (yyvsp[0].i)) cf_error("Cork low threshold must be lower than the high threshold.");
     this_table->cork_threshold.low = (yyvsp[-1].i);
     this_table->cork_threshold.high = (yyvsp[0].i); }
#line 9432 "obj/conf/cf-parse.tab.c"
    break;

  case 438: /* table_opt: EXPORT SETTLE TIME settle  */
#line 287 "nest/config.Y"
                             { this_table->export_settle = (yyvsp[0].settle); }
#line 9438 "obj/conf/cf-parse.tab.c"
    break;

  case 439: /* table_opt: ROUTE REFRESH EXPORT SETTLE TIME settle  */
#line 288 "nest/config.Y"
                                           { this_table->export_rr_settle = (yyvsp[0].settle); }
#line 9444 "obj/conf/cf-parse.tab.c"
    break;

  case 440: /* table_opt: DIGEST SETTLE TIME settle  */
#line 289 "nest/config.Y"
                             { this_table->digest_settle = (yyvsp[0].settle); }
#line 9450 "obj/conf/cf-parse.tab.c"
    break;

  case 441: /* table_opt: THREAD GROUP symbol  */
#line 290 "nest/config.Y"
                       {
    if ((yyvsp[0].s)->class != SYM_THREAD_GROUP)
      cf_error("Unexpected symbol %s as a thread group name", (yyvsp[0].s)->name);
    this_table->thread_group = (yyvsp[0].s)->thread_group;
 }
#line 9460 "obj/conf/cf-parse.tab.c"
    break;

  case 446: /* conf: proto  */
#line 310 "nest/config.Y"
            { proto_postconfig(); }
#line 9466 "obj/conf/cf-parse.tab.c"
    break;

  case 447: /* proto_start: PROTOCOL  */
#line 313 "nest/config.Y"
            { (yyval.i) = SYM_PROTO; }
#line 9472 "obj/conf/cf-parse.tab.c"
    break;

  case 448: /* proto_start: TEMPLATE  */
#line 314 "nest/config.Y"
            { (yyval.i) = SYM_TEMPLATE; }
#line 9478 "obj/conf/cf-parse.tab.c"
    break;

  case 449: /* proto_name: %empty  */
#line 318 "nest/config.Y"
               {
     struct symbol *s = cf_default_name(new_config, this_proto->protocol->template, &this_proto->protocol->name_counter);
     s->class = this_proto->class;
     s->proto = this_proto;
     this_proto->name = s->name;
     }
#line 9489 "obj/conf/cf-parse.tab.c"
    break;

  case 450: /* proto_name: symbol  */
#line 324 "nest/config.Y"
          {
     cf_define_symbol(new_config, (yyvsp[0].s), this_proto->class, proto, this_proto);
     this_proto->name = (yyvsp[0].s)->name;
   }
#line 9498 "obj/conf/cf-parse.tab.c"
    break;

  case 451: /* proto_name: FROM CF_SYM_KNOWN  */
#line 328 "nest/config.Y"
                     {
     if (((yyvsp[0].s)->class != SYM_TEMPLATE) && ((yyvsp[0].s)->class != SYM_PROTO)) cf_error("Template or protocol name expected");

     struct symbol *s = cf_default_name(new_config, this_proto->protocol->template, &this_proto->protocol->name_counter);
     s->class = this_proto->class;
     s->proto = this_proto;
     this_proto->name = s->name;

     proto_copy_config(this_proto, (yyvsp[0].s)->proto);
   }
#line 9513 "obj/conf/cf-parse.tab.c"
    break;

  case 452: /* proto_name: symbol FROM CF_SYM_KNOWN  */
#line 338 "nest/config.Y"
                            {
     if (((yyvsp[0].s)->class != SYM_TEMPLATE) && ((yyvsp[0].s)->class != SYM_PROTO)) cf_error("Template or protocol name expected");

     cf_define_symbol(new_config, (yyvsp[-2].s), this_proto->class, proto, this_proto);
     this_proto->name = (yyvsp[-2].s)->name;

     proto_copy_config(this_proto, (yyvsp[0].s)->proto);
   }
#line 9526 "obj/conf/cf-parse.tab.c"
    break;

  case 454: /* proto_item: DISABLED bool  */
#line 350 "nest/config.Y"
                 { this_proto->disabled = (yyvsp[0].i); }
#line 9532 "obj/conf/cf-parse.tab.c"
    break;

  case 455: /* proto_item: RESTART TIME expr_us  */
#line 351 "nest/config.Y"
                        { this_proto->restart_limit = (yyvsp[0].time); }
#line 9538 "obj/conf/cf-parse.tab.c"
    break;

  case 456: /* proto_item: DEBUG debug_mask  */
#line 352 "nest/config.Y"
                    { this_proto->debug = (yyvsp[0].i); }
#line 9544 "obj/conf/cf-parse.tab.c"
    break;

  case 457: /* proto_item: MRTDUMP mrtdump_mask  */
#line 353 "nest/config.Y"
                        { this_proto->mrtdump = (yyvsp[0].i); }
#line 9550 "obj/conf/cf-parse.tab.c"
    break;

  case 458: /* proto_item: ROUTER ID idval  */
#line 354 "nest/config.Y"
                   { this_proto->router_id = (yyvsp[0].i32); }
#line 9556 "obj/conf/cf-parse.tab.c"
    break;

  case 459: /* proto_item: HOSTNAME text  */
#line 355 "nest/config.Y"
                 { this_proto->hostname = (yyvsp[0].t); }
#line 9562 "obj/conf/cf-parse.tab.c"
    break;

  case 460: /* proto_item: DESCRIPTION text  */
#line 356 "nest/config.Y"
                    { this_proto->dsc = (yyvsp[0].t); }
#line 9568 "obj/conf/cf-parse.tab.c"
    break;

  case 461: /* proto_item: VRF text  */
#line 357 "nest/config.Y"
            { this_proto->vrf = if_get_by_name((yyvsp[0].t)); }
#line 9574 "obj/conf/cf-parse.tab.c"
    break;

  case 462: /* proto_item: VRF DEFAULT  */
#line 358 "nest/config.Y"
               { this_proto->vrf = &default_vrf; }
#line 9580 "obj/conf/cf-parse.tab.c"
    break;

  case 463: /* proto_item: THREAD GROUP symbol  */
#line 359 "nest/config.Y"
                       {
    if ((yyvsp[0].s)->class != SYM_THREAD_GROUP)
      cf_error("Unexpected symbol %s as a thread group name", (yyvsp[0].s)->name);
    this_proto->thread_group = (yyvsp[0].s)->thread_group;
 }
#line 9590 "obj/conf/cf-parse.tab.c"
    break;

  case 464: /* channel_start: net_type_base  */
#line 368 "nest/config.Y"
{
  (yyval.cc) = this_channel = channel_config_get(NULL, net_label[(yyvsp[0].i)], (yyvsp[0].i), this_proto);
}
#line 9598 "obj/conf/cf-parse.tab.c"
    break;

  case 465: /* channel_item_: TABLE rtable  */
#line 373 "nest/config.Y"
                {
     if (this_channel->net_type && ((yyvsp[0].r)->addr_type != this_channel->net_type))
       cf_error("Incompatible table type");
     this_channel->table = (yyvsp[0].r);
   }
#line 9608 "obj/conf/cf-parse.tab.c"
    break;

  case 466: /* channel_item_: IMPORT imexport  */
#line 378 "nest/config.Y"
                   { this_channel->in_filter = (yyvsp[0].f); }
#line 9614 "obj/conf/cf-parse.tab.c"
    break;

  case 467: /* channel_item_: EXPORT IN net_any imexport  */
#line 379 "nest/config.Y"
                              {
     if (this_channel->net_type && ((yyvsp[-1].net_ptr)->type != this_channel->net_type))
       cf_error("Incompatible export prefilter type");
     this_channel->out_subprefix = (yyvsp[-1].net_ptr);
     this_channel->out_filter = (yyvsp[0].f);
   }
#line 9625 "obj/conf/cf-parse.tab.c"
    break;

  case 468: /* channel_item_: EXPORT imexport  */
#line 385 "nest/config.Y"
                   { this_channel->out_filter = (yyvsp[0].f); }
#line 9631 "obj/conf/cf-parse.tab.c"
    break;

  case 469: /* channel_item_: RECEIVE LIMIT limit_spec  */
#line 386 "nest/config.Y"
                            { this_channel->rx_limit = (yyvsp[0].cl); }
#line 9637 "obj/conf/cf-parse.tab.c"
    break;

  case 470: /* channel_item_: IMPORT LIMIT limit_spec  */
#line 387 "nest/config.Y"
                           { this_channel->in_limit = (yyvsp[0].cl); }
#line 9643 "obj/conf/cf-parse.tab.c"
    break;

  case 471: /* channel_item_: EXPORT LIMIT limit_spec  */
#line 388 "nest/config.Y"
                           { this_channel->out_limit = (yyvsp[0].cl); }
#line 9649 "obj/conf/cf-parse.tab.c"
    break;

  case 472: /* channel_item_: PREFERENCE expr  */
#line 389 "nest/config.Y"
                   { this_channel->preference = (yyvsp[0].i); check_u16((yyvsp[0].i)); }
#line 9655 "obj/conf/cf-parse.tab.c"
    break;

  case 473: /* channel_item_: IMPORT KEEP FILTERED bool  */
#line 390 "nest/config.Y"
                             {
     if ((yyvsp[0].i))
       this_channel->in_keep |= RIK_REJECTED;
     else if ((this_channel->in_keep & RIK_PREFILTER) == RIK_PREFILTER)
       cf_error("Import keep filtered is implied by the import table.");
     else
       this_channel->in_keep &= ~RIK_REJECTED;
   }
#line 9668 "obj/conf/cf-parse.tab.c"
    break;

  case 474: /* channel_item_: RPKI RELOAD bool  */
#line 398 "nest/config.Y"
                    { this_channel->rpki_reload = (yyvsp[0].i); }
#line 9674 "obj/conf/cf-parse.tab.c"
    break;

  case 476: /* channel_item: DEBUG debug_mask  */
#line 404 "nest/config.Y"
                    { this_channel->debug = (yyvsp[0].i); }
#line 9680 "obj/conf/cf-parse.tab.c"
    break;

  case 481: /* channel_end: %empty  */
#line 418 "nest/config.Y"
{
  if (!this_channel->table)
    cf_error("Routing table not specified");

  this_channel = NULL;
}
#line 9691 "obj/conf/cf-parse.tab.c"
    break;

  case 483: /* rtable: CF_SYM_KNOWN  */
#line 428 "nest/config.Y"
                     {
  cf_assert_symbol((yyvsp[0].s), SYM_TABLE);
  if (!(yyvsp[0].s)->table) rt_new_default_table((yyvsp[0].s));
  (yyval.r) = (yyvsp[0].s)->table;
}
#line 9701 "obj/conf/cf-parse.tab.c"
    break;

  case 484: /* imexport: FILTER filter  */
#line 435 "nest/config.Y"
                 { (yyval.f) = (yyvsp[0].f); }
#line 9707 "obj/conf/cf-parse.tab.c"
    break;

  case 486: /* imexport: ALL  */
#line 437 "nest/config.Y"
       { (yyval.f) = FILTER_ACCEPT; }
#line 9713 "obj/conf/cf-parse.tab.c"
    break;

  case 487: /* imexport: NONE  */
#line 438 "nest/config.Y"
        { (yyval.f) = FILTER_REJECT; }
#line 9719 "obj/conf/cf-parse.tab.c"
    break;

  case 488: /* limit_action: %empty  */
#line 442 "nest/config.Y"
                 { (yyval.i) = PLA_DISABLE; }
#line 9725 "obj/conf/cf-parse.tab.c"
    break;

  case 489: /* limit_action: ACTION WARN  */
#line 443 "nest/config.Y"
               { (yyval.i) = PLA_WARN; }
#line 9731 "obj/conf/cf-parse.tab.c"
    break;

  case 490: /* limit_action: ACTION BLOCK  */
#line 444 "nest/config.Y"
                { (yyval.i) = PLA_BLOCK; }
#line 9737 "obj/conf/cf-parse.tab.c"
    break;

  case 491: /* limit_action: ACTION RESTART  */
#line 445 "nest/config.Y"
                  { (yyval.i) = PLA_RESTART; }
#line 9743 "obj/conf/cf-parse.tab.c"
    break;

  case 492: /* limit_action: ACTION DISABLE  */
#line 446 "nest/config.Y"
                  { (yyval.i) = PLA_DISABLE; }
#line 9749 "obj/conf/cf-parse.tab.c"
    break;

  case 493: /* limit_spec: expr limit_action  */
#line 450 "nest/config.Y"
                     { (yyval.cl) = (struct channel_limit){ .limit = (yyvsp[-1].i), (yyval.cl).action = (yyvsp[0].i) }; }
#line 9755 "obj/conf/cf-parse.tab.c"
    break;

  case 494: /* limit_spec: OFF  */
#line 451 "nest/config.Y"
       { (yyval.cl) = (struct channel_limit){}; }
#line 9761 "obj/conf/cf-parse.tab.c"
    break;

  case 496: /* debug_default: DEBUG PROTOCOLS debug_mask  */
#line 458 "nest/config.Y"
                              { new_config->proto_default_debug = (yyvsp[0].i); }
#line 9767 "obj/conf/cf-parse.tab.c"
    break;

  case 497: /* debug_default: DEBUG CHANNELS debug_mask  */
#line 459 "nest/config.Y"
                             { new_config->channel_default_debug = (yyvsp[0].i); }
#line 9773 "obj/conf/cf-parse.tab.c"
    break;

  case 498: /* debug_default: DEBUG TABLES debug_mask  */
#line 460 "nest/config.Y"
                           { new_config->table_default_debug = (yyvsp[0].i); }
#line 9779 "obj/conf/cf-parse.tab.c"
    break;

  case 499: /* debug_default: DEBUG COMMANDS expr  */
#line 461 "nest/config.Y"
                       { new_config->cli_debug = (yyvsp[0].i); }
#line 9785 "obj/conf/cf-parse.tab.c"
    break;

  case 500: /* debug_default: DEBUG SHOW ROUTE debug_mask  */
#line 462 "nest/config.Y"
                               { new_config->show_route_debug = (yyvsp[0].i); }
#line 9791 "obj/conf/cf-parse.tab.c"
    break;

  case 502: /* timeformat_base: TIMEFORMAT timeformat_which timeformat_spec ';'  */
#line 470 "nest/config.Y"
                                                   { *(yyvsp[-2].tfp) = (yyvsp[-1].tf); }
#line 9797 "obj/conf/cf-parse.tab.c"
    break;

  case 503: /* timeformat_which: ROUTE  */
#line 474 "nest/config.Y"
         { (yyval.tfp) = &new_config->tf_route; }
#line 9803 "obj/conf/cf-parse.tab.c"
    break;

  case 504: /* timeformat_which: PROTOCOL  */
#line 475 "nest/config.Y"
            { (yyval.tfp) = &new_config->tf_proto; }
#line 9809 "obj/conf/cf-parse.tab.c"
    break;

  case 505: /* timeformat_which: BASE  */
#line 476 "nest/config.Y"
        { (yyval.tfp) = &new_config->tf_base; }
#line 9815 "obj/conf/cf-parse.tab.c"
    break;

  case 506: /* timeformat_which: LOG  */
#line 477 "nest/config.Y"
       { (yyval.tfp) = &new_config->tf_log; }
#line 9821 "obj/conf/cf-parse.tab.c"
    break;

  case 507: /* timeformat_spec: TEXT  */
#line 481 "nest/config.Y"
        { (yyval.tf) = (struct timeformat){(yyvsp[0].t), NULL, 0}; }
#line 9827 "obj/conf/cf-parse.tab.c"
    break;

  case 508: /* timeformat_spec: TEXT expr TEXT  */
#line 482 "nest/config.Y"
                  { (yyval.tf) = (struct timeformat){(yyvsp[-2].t), (yyvsp[0].t), (s64) (yyvsp[-1].i) S_}; }
#line 9833 "obj/conf/cf-parse.tab.c"
    break;

  case 509: /* timeformat_spec: ISO SHORT  */
#line 483 "nest/config.Y"
                { (yyval.tf) = TM_ISO_SHORT_S; }
#line 9839 "obj/conf/cf-parse.tab.c"
    break;

  case 510: /* timeformat_spec: ISO SHORT MS  */
#line 484 "nest/config.Y"
                { (yyval.tf) = TM_ISO_SHORT_MS; }
#line 9845 "obj/conf/cf-parse.tab.c"
    break;

  case 511: /* timeformat_spec: ISO SHORT US  */
#line 485 "nest/config.Y"
                { (yyval.tf) = TM_ISO_SHORT_US; }
#line 9851 "obj/conf/cf-parse.tab.c"
    break;

  case 512: /* timeformat_spec: ISO LONG  */
#line 486 "nest/config.Y"
                { (yyval.tf) = TM_ISO_LONG_S; }
#line 9857 "obj/conf/cf-parse.tab.c"
    break;

  case 513: /* timeformat_spec: ISO LONG MS  */
#line 487 "nest/config.Y"
                { (yyval.tf) = TM_ISO_LONG_MS; }
#line 9863 "obj/conf/cf-parse.tab.c"
    break;

  case 514: /* timeformat_spec: ISO LONG US  */
#line 488 "nest/config.Y"
                { (yyval.tf) = TM_ISO_LONG_US; }
#line 9869 "obj/conf/cf-parse.tab.c"
    break;

  case 515: /* iface_patt_node_init: %empty  */
#line 494 "nest/config.Y"
               {
     struct iface_patt_node *ipn = cfg_allocz(sizeof(struct iface_patt_node));
     add_tail(&this_ipatt->ipn_list, NODE ipn);
     this_ipn = ipn;
   }
#line 9879 "obj/conf/cf-parse.tab.c"
    break;

  case 516: /* iface_patt_node_body: TEXT  */
#line 502 "nest/config.Y"
        { this_ipn->pattern = (yyvsp[0].t); /* this_ipn->prefix stays zero */ }
#line 9885 "obj/conf/cf-parse.tab.c"
    break;

  case 517: /* iface_patt_node_body: opttext net_or_ipa  */
#line 503 "nest/config.Y"
                      { this_ipn->pattern = (yyvsp[-1].t); this_ipn->prefix = (yyvsp[0].net); }
#line 9891 "obj/conf/cf-parse.tab.c"
    break;

  case 518: /* iface_negate: %empty  */
#line 507 "nest/config.Y"
       { this_ipn->positive = 1; }
#line 9897 "obj/conf/cf-parse.tab.c"
    break;

  case 519: /* iface_negate: '-'  */
#line 508 "nest/config.Y"
       { this_ipn->positive = 0; }
#line 9903 "obj/conf/cf-parse.tab.c"
    break;

  case 523: /* iface_patt_list_nopx: iface_patt_list  */
#line 522 "nest/config.Y"
                                      { iface_patt_check(); }
#line 9909 "obj/conf/cf-parse.tab.c"
    break;

  case 524: /* iface_patt_init: %empty  */
#line 524 "nest/config.Y"
                 {
   /* Generic this_ipatt init */
   this_ipatt = cfg_allocz(sizeof(struct iface_patt));
   init_list(&this_ipatt->ipn_list);
 }
#line 9919 "obj/conf/cf-parse.tab.c"
    break;

  case 526: /* tos: CLASS expr  */
#line 536 "nest/config.Y"
              { (yyval.i) = (yyvsp[0].i) & 0xfc;        if ((yyvsp[0].i) > 255) cf_error("TX class must be in range 0-255"); }
#line 9925 "obj/conf/cf-parse.tab.c"
    break;

  case 527: /* tos: DSCP expr  */
#line 537 "nest/config.Y"
              { (yyval.i) = ((yyvsp[0].i) & 0x3f) << 2; if ((yyvsp[0].i) > 63)  cf_error("TX DSCP must be in range 0-63"); }
#line 9931 "obj/conf/cf-parse.tab.c"
    break;

  case 529: /* dev_proto_start: proto_start DIRECT  */
#line 544 "nest/config.Y"
                                    {
     this_proto = proto_config_new(&proto_device, (yyvsp[-1].i));
     init_list(&DIRECT_CFG->iface_list);
     this_proto->late_if_feed = 1;
   }
#line 9941 "obj/conf/cf-parse.tab.c"
    break;

  case 534: /* dev_proto: dev_proto CHECK LINK bool ';'  */
#line 556 "nest/config.Y"
                                 { DIRECT_CFG->check_link = (yyvsp[-1].i); }
#line 9947 "obj/conf/cf-parse.tab.c"
    break;

  case 535: /* dev_iface_init: %empty  */
#line 560 "nest/config.Y"
               {
     this_ipatt = cfg_allocz(sizeof(struct iface_patt));
     add_tail(&DIRECT_CFG->iface_list, NODE this_ipatt);
     init_list(&this_ipatt->ipn_list);
   }
#line 9957 "obj/conf/cf-parse.tab.c"
    break;

  case 537: /* debug_mask: ALL  */
#line 574 "nest/config.Y"
       { (yyval.i) = ~0; }
#line 9963 "obj/conf/cf-parse.tab.c"
    break;

  case 538: /* debug_mask: OFF  */
#line 575 "nest/config.Y"
       { (yyval.i) = 0; }
#line 9969 "obj/conf/cf-parse.tab.c"
    break;

  case 539: /* debug_mask: '{' debug_list '}'  */
#line 576 "nest/config.Y"
                      { (yyval.i) = (yyvsp[-1].i); }
#line 9975 "obj/conf/cf-parse.tab.c"
    break;

  case 541: /* debug_list: debug_list ',' debug_flag  */
#line 581 "nest/config.Y"
                             { (yyval.i) = (yyvsp[-2].i) | (yyvsp[0].i); }
#line 9981 "obj/conf/cf-parse.tab.c"
    break;

  case 542: /* debug_flag: STATES  */
#line 585 "nest/config.Y"
                { (yyval.i) = D_STATES; }
#line 9987 "obj/conf/cf-parse.tab.c"
    break;

  case 543: /* debug_flag: ROUTES  */
#line 586 "nest/config.Y"
                { (yyval.i) = D_ROUTES; }
#line 9993 "obj/conf/cf-parse.tab.c"
    break;

  case 544: /* debug_flag: FILTERS  */
#line 587 "nest/config.Y"
                { (yyval.i) = D_FILTERS; }
#line 9999 "obj/conf/cf-parse.tab.c"
    break;

  case 545: /* debug_flag: INTERFACES  */
#line 588 "nest/config.Y"
                { (yyval.i) = D_IFACES; }
#line 10005 "obj/conf/cf-parse.tab.c"
    break;

  case 546: /* debug_flag: EVENTS  */
#line 589 "nest/config.Y"
                { (yyval.i) = D_EVENTS; }
#line 10011 "obj/conf/cf-parse.tab.c"
    break;

  case 547: /* debug_flag: PACKETS  */
#line 590 "nest/config.Y"
                { (yyval.i) = D_PACKETS; }
#line 10017 "obj/conf/cf-parse.tab.c"
    break;

  case 548: /* mrtdump_mask: ALL  */
#line 596 "nest/config.Y"
       { (yyval.i) = ~0; }
#line 10023 "obj/conf/cf-parse.tab.c"
    break;

  case 549: /* mrtdump_mask: OFF  */
#line 597 "nest/config.Y"
       { (yyval.i) = 0; }
#line 10029 "obj/conf/cf-parse.tab.c"
    break;

  case 550: /* mrtdump_mask: '{' mrtdump_list '}'  */
#line 598 "nest/config.Y"
                        { (yyval.i) = (yyvsp[-1].i); }
#line 10035 "obj/conf/cf-parse.tab.c"
    break;

  case 552: /* mrtdump_list: mrtdump_list ',' mrtdump_flag  */
#line 603 "nest/config.Y"
                                 { (yyval.i) = (yyvsp[-2].i) | (yyvsp[0].i); }
#line 10041 "obj/conf/cf-parse.tab.c"
    break;

  case 553: /* mrtdump_flag: STATES  */
#line 607 "nest/config.Y"
                { (yyval.i) = MD_STATES; }
#line 10047 "obj/conf/cf-parse.tab.c"
    break;

  case 554: /* mrtdump_flag: MESSAGES  */
#line 608 "nest/config.Y"
                { (yyval.i) = MD_MESSAGES; }
#line 10053 "obj/conf/cf-parse.tab.c"
    break;

  case 564: /* password_item_begin: pass_key bytestring_text  */
#line 635 "nest/config.Y"
{
  init_password_list();
  if ((yyvsp[0].v).type == T_BYTESTRING)
    init_password((yyvsp[0].v).val.bs->data, (yyvsp[0].v).val.bs->length, password_id++);
  else if ((yyvsp[0].v).type == T_STRING)
    init_password((yyvsp[0].v).val.s, strlen((yyvsp[0].v).val.s), password_id++);
  else bug("Bad bytestring_text");
}
#line 10066 "obj/conf/cf-parse.tab.c"
    break;

  case 565: /* password_item_params: %empty  */
#line 645 "nest/config.Y"
               { }
#line 10072 "obj/conf/cf-parse.tab.c"
    break;

  case 566: /* password_item_params: GENERATE FROM time ';' password_item_params  */
#line 646 "nest/config.Y"
                                               { this_p_item->genfrom = (yyvsp[-2].time); }
#line 10078 "obj/conf/cf-parse.tab.c"
    break;

  case 567: /* password_item_params: GENERATE TO time ';' password_item_params  */
#line 647 "nest/config.Y"
                                             { this_p_item->gento = (yyvsp[-2].time); }
#line 10084 "obj/conf/cf-parse.tab.c"
    break;

  case 568: /* password_item_params: ACCEPT FROM time ';' password_item_params  */
#line 648 "nest/config.Y"
                                             { this_p_item->accfrom = (yyvsp[-2].time); }
#line 10090 "obj/conf/cf-parse.tab.c"
    break;

  case 569: /* password_item_params: ACCEPT TO time ';' password_item_params  */
#line 649 "nest/config.Y"
                                           { this_p_item->accto = (yyvsp[-2].time); }
#line 10096 "obj/conf/cf-parse.tab.c"
    break;

  case 570: /* password_item_params: FROM time ';' password_item_params  */
#line 650 "nest/config.Y"
                                      { this_p_item->genfrom = this_p_item->accfrom = (yyvsp[-2].time); }
#line 10102 "obj/conf/cf-parse.tab.c"
    break;

  case 571: /* password_item_params: TO time ';' password_item_params  */
#line 651 "nest/config.Y"
                                    { this_p_item->gento = this_p_item->accto = (yyvsp[-2].time); }
#line 10108 "obj/conf/cf-parse.tab.c"
    break;

  case 572: /* password_item_params: ID expr ';' password_item_params  */
#line 652 "nest/config.Y"
                                    { this_p_item->id = (yyvsp[-2].i); if ((yyvsp[-2].i) > 255) cf_error("Password ID must be in range 0-255"); }
#line 10114 "obj/conf/cf-parse.tab.c"
    break;

  case 573: /* password_item_params: ALGORITHM password_algorithm ';' password_item_params  */
#line 653 "nest/config.Y"
                                                         { this_p_item->alg = (yyvsp[-2].i); }
#line 10120 "obj/conf/cf-parse.tab.c"
    break;

  case 574: /* password_algorithm: KEYED MD5  */
#line 657 "nest/config.Y"
                { (yyval.i) = ALG_MD5; }
#line 10126 "obj/conf/cf-parse.tab.c"
    break;

  case 575: /* password_algorithm: KEYED SHA1  */
#line 658 "nest/config.Y"
                { (yyval.i) = ALG_SHA1; }
#line 10132 "obj/conf/cf-parse.tab.c"
    break;

  case 576: /* password_algorithm: KEYED SHA256  */
#line 659 "nest/config.Y"
                { (yyval.i) = ALG_SHA256; }
#line 10138 "obj/conf/cf-parse.tab.c"
    break;

  case 577: /* password_algorithm: KEYED SHA384  */
#line 660 "nest/config.Y"
                { (yyval.i) = ALG_SHA384; }
#line 10144 "obj/conf/cf-parse.tab.c"
    break;

  case 578: /* password_algorithm: KEYED SHA512  */
#line 661 "nest/config.Y"
                { (yyval.i) = ALG_SHA512; }
#line 10150 "obj/conf/cf-parse.tab.c"
    break;

  case 579: /* password_algorithm: HMAC MD5  */
#line 662 "nest/config.Y"
                { (yyval.i) = ALG_HMAC_MD5; }
#line 10156 "obj/conf/cf-parse.tab.c"
    break;

  case 580: /* password_algorithm: HMAC SHA1  */
#line 663 "nest/config.Y"
                { (yyval.i) = ALG_HMAC_SHA1; }
#line 10162 "obj/conf/cf-parse.tab.c"
    break;

  case 581: /* password_algorithm: HMAC SHA256  */
#line 664 "nest/config.Y"
                { (yyval.i) = ALG_HMAC_SHA256; }
#line 10168 "obj/conf/cf-parse.tab.c"
    break;

  case 582: /* password_algorithm: HMAC SHA384  */
#line 665 "nest/config.Y"
                { (yyval.i) = ALG_HMAC_SHA384; }
#line 10174 "obj/conf/cf-parse.tab.c"
    break;

  case 583: /* password_algorithm: HMAC SHA512  */
#line 666 "nest/config.Y"
                { (yyval.i) = ALG_HMAC_SHA512; }
#line 10180 "obj/conf/cf-parse.tab.c"
    break;

  case 584: /* password_algorithm: BLAKE2S128  */
#line 667 "nest/config.Y"
                { (yyval.i) = ALG_BLAKE2S_128; }
#line 10186 "obj/conf/cf-parse.tab.c"
    break;

  case 585: /* password_algorithm: BLAKE2S256  */
#line 668 "nest/config.Y"
                { (yyval.i) = ALG_BLAKE2S_256; }
#line 10192 "obj/conf/cf-parse.tab.c"
    break;

  case 586: /* password_algorithm: BLAKE2B256  */
#line 669 "nest/config.Y"
                { (yyval.i) = ALG_BLAKE2B_256; }
#line 10198 "obj/conf/cf-parse.tab.c"
    break;

  case 587: /* password_algorithm: BLAKE2B512  */
#line 670 "nest/config.Y"
                { (yyval.i) = ALG_BLAKE2B_512; }
#line 10204 "obj/conf/cf-parse.tab.c"
    break;

  case 588: /* password_item_end: %empty  */
#line 674 "nest/config.Y"
{
  password_validate_length(this_p_item);
}
#line 10212 "obj/conf/cf-parse.tab.c"
    break;

  case 591: /* cmd_SHOW_STATUS: SHOW STATUS END  */
#line 687 "nest/config.Y"
{ cmd_show_status(); }
#line 10218 "obj/conf/cf-parse.tab.c"
    break;

  case 593: /* cmd_SHOW_MEMORY: SHOW MEMORY END  */
#line 690 "nest/config.Y"
{ cmd_show_memory(); }
#line 10224 "obj/conf/cf-parse.tab.c"
    break;

  case 595: /* cmd_SHOW_PROTOCOLS: SHOW PROTOCOLS proto_patt2 END  */
#line 693 "nest/config.Y"
{ proto_apply_cmd((yyvsp[-1].ps), proto_cmd_show, 0, 0); }
#line 10230 "obj/conf/cf-parse.tab.c"
    break;

  case 597: /* cmd_SHOW_PROTOCOLS_ALL: SHOW PROTOCOLS ALL proto_patt2 END  */
#line 696 "nest/config.Y"
{ proto_apply_cmd((yyvsp[-1].ps), proto_cmd_show, 0, 1); }
#line 10236 "obj/conf/cf-parse.tab.c"
    break;

  case 598: /* optproto: CF_SYM_KNOWN  */
#line 699 "nest/config.Y"
                { cf_assert_symbol((yyvsp[0].s), SYM_PROTO); (yyval.s) = (yyvsp[0].s); }
#line 10242 "obj/conf/cf-parse.tab.c"
    break;

  case 599: /* optproto: %empty  */
#line 700 "nest/config.Y"
               { (yyval.s) = NULL; }
#line 10248 "obj/conf/cf-parse.tab.c"
    break;

  case 601: /* cmd_SHOW_INTERFACES: SHOW INTERFACES END  */
#line 704 "nest/config.Y"
{ if_show(); }
#line 10254 "obj/conf/cf-parse.tab.c"
    break;

  case 603: /* cmd_SHOW_INTERFACES_SUMMARY: SHOW INTERFACES SUMMARY END  */
#line 707 "nest/config.Y"
{ if_show_summary(); }
#line 10260 "obj/conf/cf-parse.tab.c"
    break;

  case 605: /* cmd_SHOW_ROUTE: SHOW ROUTE r_args END  */
#line 711 "nest/config.Y"
{ rt_show((yyvsp[-1].ra)); }
#line 10266 "obj/conf/cf-parse.tab.c"
    break;

  case 606: /* r_args: %empty  */
#line 731 "nest/config.Y"
               {
     (yyval.ra) = cfg_allocz(sizeof(struct rt_show_data));
     init_list(&((yyval.ra)->tables));
     (yyval.ra)->filter = FILTER_ACCEPT;
     (yyval.ra)->cli = this_cli;
     (yyval.ra)->tf_route = this_cli->main_config->tf_route;
   }
#line 10278 "obj/conf/cf-parse.tab.c"
    break;

  case 607: /* r_args: r_args net_any  */
#line 738 "nest/config.Y"
                  {
     (yyval.ra) = (yyvsp[-1].ra);
     if ((yyval.ra)->addr) cf_error("Only one prefix expected");
     (yyval.ra)->addr = (yyvsp[0].net_ptr);
     (yyval.ra)->addr_mode = TE_ADDR_EQUAL;
   }
#line 10289 "obj/conf/cf-parse.tab.c"
    break;

  case 608: /* r_args: r_args FOR r_args_for  */
#line 744 "nest/config.Y"
                         {
     (yyval.ra) = (yyvsp[-2].ra);
     if ((yyval.ra)->addr) cf_error("Only one prefix expected");
     (yyval.ra)->addr = (yyvsp[0].net_ptr);
     (yyval.ra)->addr_mode = TE_ADDR_FOR;
   }
#line 10300 "obj/conf/cf-parse.tab.c"
    break;

  case 609: /* r_args: r_args IN net_any  */
#line 750 "nest/config.Y"
                     {
     (yyval.ra) = (yyvsp[-2].ra);
     if ((yyval.ra)->addr) cf_error("Only one prefix expected");
     if (!net_type_match((yyvsp[0].net_ptr), NB_IP)) cf_error("Only IP networks accepted for 'in' argument");
     (yyval.ra)->addr = (yyvsp[0].net_ptr);
     (yyval.ra)->addr_mode = TE_ADDR_IN;
   }
#line 10312 "obj/conf/cf-parse.tab.c"
    break;

  case 610: /* r_args: r_args TABLE CF_SYM_KNOWN  */
#line 757 "nest/config.Y"
                            {
     cf_assert_symbol((yyvsp[0].s), SYM_TABLE);
     if (!(yyvsp[0].s)->table) cf_error("Table %s not configured", (yyvsp[0].s)->name);
     (yyval.ra) = (yyvsp[-2].ra);
     rt_show_add_table((yyval.ra), (yyvsp[0].s)->table->table);
     (yyval.ra)->tables_defined_by = RSD_TDB_DIRECT;
   }
#line 10324 "obj/conf/cf-parse.tab.c"
    break;

  case 611: /* r_args: r_args TABLE ALL  */
#line 764 "nest/config.Y"
                    {
     struct rtable_config *t;
     (yyval.ra) = (yyvsp[-2].ra);
     WALK_LIST(t, this_cli->main_config->tables)
       rt_show_add_table((yyval.ra), t->table);
     (yyval.ra)->tables_defined_by = RSD_TDB_ALL;
   }
#line 10336 "obj/conf/cf-parse.tab.c"
    break;

  case 612: /* r_args: r_args IMPORT TABLE channel_arg  */
#line 771 "nest/config.Y"
                                   {
     if (!((yyvsp[0].c)->in_keep & RIK_PREFILTER)) cf_error("No import table in channel %s.%s", (yyvsp[0].c)->proto->name, (yyvsp[0].c)->name);
     struct rt_show_data_rtable *rsdr = rt_show_add_table((yyval.ra), (yyvsp[0].c)->table);
     rsdr->name = "import";
     rsdr->prefilter = (yyvsp[0].c);
     (yyval.ra)->tables_defined_by = RSD_TDB_DIRECT;
   }
#line 10348 "obj/conf/cf-parse.tab.c"
    break;

  case 613: /* r_args: r_args EXPORT TABLE channel_arg  */
#line 778 "nest/config.Y"
                                   {
     if (!((yyvsp[0].c)->out_table)) cf_error("No export table in channel %s.%s", (yyvsp[0].c)->proto->name, (yyvsp[0].c)->name);
     struct rt_show_data_rtable *rsdr = rt_show_add_exporter((yyval.ra), (yyvsp[0].c)->out_table);
     rsdr->name = "export";
     (yyval.ra)->tables_defined_by = RSD_TDB_DIRECT;
   }
#line 10359 "obj/conf/cf-parse.tab.c"
    break;

  case 614: /* r_args: r_args FILTER filter  */
#line 784 "nest/config.Y"
                        {
     (yyval.ra) = (yyvsp[-2].ra);
     if ((yyval.ra)->filter != FILTER_ACCEPT) cf_error("Filter specified twice");
     (yyval.ra)->filter = (yyvsp[0].f);
   }
#line 10369 "obj/conf/cf-parse.tab.c"
    break;

  case 615: /* r_args: r_args where_filter  */
#line 789 "nest/config.Y"
                       {
     (yyval.ra) = (yyvsp[-1].ra);
     if ((yyval.ra)->filter != FILTER_ACCEPT) cf_error("Filter specified twice");
     (yyval.ra)->filter = (yyvsp[0].f);
   }
#line 10379 "obj/conf/cf-parse.tab.c"
    break;

  case 616: /* r_args: r_args ALL  */
#line 794 "nest/config.Y"
              {
     (yyval.ra) = (yyvsp[-1].ra);
     (yyval.ra)->verbose = 1;
   }
#line 10388 "obj/conf/cf-parse.tab.c"
    break;

  case 617: /* r_args: r_args PRIMARY  */
#line 798 "nest/config.Y"
                  {
     (yyval.ra) = (yyvsp[-1].ra);
     (yyval.ra)->primary_only = 1;
   }
#line 10397 "obj/conf/cf-parse.tab.c"
    break;

  case 618: /* r_args: r_args FILTERED  */
#line 802 "nest/config.Y"
                   {
     (yyval.ra) = (yyvsp[-1].ra);
     (yyval.ra)->filtered = 1;
   }
#line 10406 "obj/conf/cf-parse.tab.c"
    break;

  case 619: /* r_args: r_args export_mode CF_SYM_KNOWN  */
#line 806 "nest/config.Y"
                                   {
     cf_assert_symbol((yyvsp[0].s), SYM_PROTO);
     struct proto_config *c = (struct proto_config *) (yyvsp[0].s)->proto;
     (yyval.ra) = (yyvsp[-2].ra);
     if ((yyval.ra)->export_mode) cf_error("Export specified twice");
     if (!c->proto) cf_error("%s is not a protocol", (yyvsp[0].s)->name);
     (yyval.ra)->export_mode = (yyvsp[-1].i);
     (yyval.ra)->export_protocol = c->proto;
     (yyval.ra)->tables_defined_by = RSD_TDB_INDIRECT;
   }
#line 10421 "obj/conf/cf-parse.tab.c"
    break;

  case 620: /* r_args: r_args export_mode channel_arg  */
#line 816 "nest/config.Y"
                                  {
     (yyval.ra) = (yyvsp[-2].ra);
     if ((yyval.ra)->export_mode) cf_error("Export specified twice");
     (yyval.ra)->export_mode = (yyvsp[-1].i);
     (yyval.ra)->export_channel = (yyvsp[0].c);
     (yyval.ra)->tables_defined_by = RSD_TDB_INDIRECT;
   }
#line 10433 "obj/conf/cf-parse.tab.c"
    break;

  case 621: /* r_args: r_args PROTOCOL CF_SYM_KNOWN  */
#line 823 "nest/config.Y"
                                {
     cf_assert_symbol((yyvsp[0].s), SYM_PROTO);
     struct proto_config *c = (struct proto_config *) (yyvsp[0].s)->proto;
     (yyval.ra) = (yyvsp[-2].ra);
     if ((yyval.ra)->show_protocol) cf_error("Protocol specified twice");
     if (!c->proto) cf_error("%s is not a protocol", (yyvsp[0].s)->name);
     (yyval.ra)->show_protocol = c->proto;
     (yyval.ra)->tables_defined_by = RSD_TDB_INDIRECT;
   }
#line 10447 "obj/conf/cf-parse.tab.c"
    break;

  case 622: /* r_args: r_args STATS  */
#line 832 "nest/config.Y"
                {
     (yyval.ra) = (yyvsp[-1].ra);
     (yyval.ra)->stats = 1;
   }
#line 10456 "obj/conf/cf-parse.tab.c"
    break;

  case 623: /* r_args: r_args COUNT  */
#line 836 "nest/config.Y"
                {
     (yyval.ra) = (yyvsp[-1].ra);
     (yyval.ra)->stats = 2;
   }
#line 10465 "obj/conf/cf-parse.tab.c"
    break;

  case 624: /* r_args_for: r_args_for_val  */
#line 843 "nest/config.Y"
                 {
    (yyval.net_ptr) = cfg_alloc((yyvsp[0].net).length);
    net_copy((yyval.net_ptr), &(yyvsp[0].net));
  }
#line 10474 "obj/conf/cf-parse.tab.c"
    break;

  case 628: /* r_args_for: VPN_RD IP4  */
#line 850 "nest/config.Y"
              {
    (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_vpn4));
    net_fill_vpn4((yyval.net_ptr), (yyvsp[0].ip4), IP4_MAX_PREFIX_LENGTH, (yyvsp[-1].rd));
  }
#line 10483 "obj/conf/cf-parse.tab.c"
    break;

  case 629: /* r_args_for: VPN_RD IP6  */
#line 854 "nest/config.Y"
              {
    (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_vpn6));
    net_fill_vpn6((yyval.net_ptr), (yyvsp[0].ip6), IP6_MAX_PREFIX_LENGTH, (yyvsp[-1].rd));
  }
#line 10492 "obj/conf/cf-parse.tab.c"
    break;

  case 630: /* r_args_for: IP6 FROM IP6  */
#line 858 "nest/config.Y"
                {
    (yyval.net_ptr) = cfg_alloc(sizeof(net_addr_ip6_sadr));
    net_fill_ip6_sadr((yyval.net_ptr), (yyvsp[-2].ip6), IP6_MAX_PREFIX_LENGTH, (yyvsp[0].ip6), IP6_MAX_PREFIX_LENGTH);
  }
#line 10501 "obj/conf/cf-parse.tab.c"
    break;

  case 631: /* r_args_for: CF_SYM_KNOWN  */
#line 862 "nest/config.Y"
                {
     if ((yyvsp[0].s)->class == (SYM_CONSTANT | T_IP))
     {
       (yyval.net_ptr) = cfg_alloc(ipa_is_ip4(SYM_VAL((yyvsp[0].s)).ip) ? sizeof(net_addr_ip4) : sizeof(net_addr_ip6));
       net_fill_ip_host((yyval.net_ptr), SYM_VAL((yyvsp[0].s)).ip);
     }
     else if (((yyvsp[0].s)->class == (SYM_CONSTANT | T_NET)) && net_type_match(SYM_VAL((yyvsp[0].s)).net, NB_IP | NB_VPN))
       (yyval.net_ptr) = (net_addr *) SYM_VAL((yyvsp[0].s)).net; /* Avoid const warning */
     else
       cf_error("IP address or network constant expected");
   }
#line 10517 "obj/conf/cf-parse.tab.c"
    break;

  case 634: /* r_args_for_val: IP4  */
#line 878 "nest/config.Y"
       { net_fill_ip4(&((yyval.net)), (yyvsp[0].ip4), IP4_MAX_PREFIX_LENGTH); }
#line 10523 "obj/conf/cf-parse.tab.c"
    break;

  case 635: /* r_args_for_val: IP6  */
#line 879 "nest/config.Y"
       { net_fill_ip6(&((yyval.net)), (yyvsp[0].ip6), IP6_MAX_PREFIX_LENGTH); }
#line 10529 "obj/conf/cf-parse.tab.c"
    break;

  case 636: /* export_mode: PREEXPORT  */
#line 882 "nest/config.Y"
                { (yyval.i) = RSEM_PREEXPORT; }
#line 10535 "obj/conf/cf-parse.tab.c"
    break;

  case 637: /* export_mode: EXPORT  */
#line 883 "nest/config.Y"
                { (yyval.i) = RSEM_EXPORT; }
#line 10541 "obj/conf/cf-parse.tab.c"
    break;

  case 638: /* export_mode: NOEXPORT  */
#line 884 "nest/config.Y"
                { (yyval.i) = RSEM_NOEXPORT; }
#line 10547 "obj/conf/cf-parse.tab.c"
    break;

  case 639: /* export_mode: EXPORTED  */
#line 885 "nest/config.Y"
                { (yyval.i) = RSEM_EXPORTED; }
#line 10553 "obj/conf/cf-parse.tab.c"
    break;

  case 640: /* channel_sym: IPV4  */
#line 890 "nest/config.Y"
                { (yyval.t) = "ipv4"; }
#line 10559 "obj/conf/cf-parse.tab.c"
    break;

  case 641: /* channel_sym: IPV4_MC  */
#line 891 "nest/config.Y"
                { (yyval.t) = "ipv4-mc"; }
#line 10565 "obj/conf/cf-parse.tab.c"
    break;

  case 642: /* channel_sym: IPV4_MPLS  */
#line 892 "nest/config.Y"
                { (yyval.t) = "ipv4-mpls"; }
#line 10571 "obj/conf/cf-parse.tab.c"
    break;

  case 643: /* channel_sym: IPV6  */
#line 893 "nest/config.Y"
                { (yyval.t) = "ipv6"; }
#line 10577 "obj/conf/cf-parse.tab.c"
    break;

  case 644: /* channel_sym: IPV6_MC  */
#line 894 "nest/config.Y"
                { (yyval.t) = "ipv6-mc"; }
#line 10583 "obj/conf/cf-parse.tab.c"
    break;

  case 645: /* channel_sym: IPV6_MPLS  */
#line 895 "nest/config.Y"
                { (yyval.t) = "ipv6-mpls"; }
#line 10589 "obj/conf/cf-parse.tab.c"
    break;

  case 646: /* channel_sym: IPV6_SADR  */
#line 896 "nest/config.Y"
                { (yyval.t) = "ipv6-sadr"; }
#line 10595 "obj/conf/cf-parse.tab.c"
    break;

  case 647: /* channel_sym: VPN4  */
#line 897 "nest/config.Y"
                { (yyval.t) = "vpn4"; }
#line 10601 "obj/conf/cf-parse.tab.c"
    break;

  case 648: /* channel_sym: VPN4_MC  */
#line 898 "nest/config.Y"
                { (yyval.t) = "vpn4-mc"; }
#line 10607 "obj/conf/cf-parse.tab.c"
    break;

  case 649: /* channel_sym: VPN4_MPLS  */
#line 899 "nest/config.Y"
                { (yyval.t) = "vpn4-mpls"; }
#line 10613 "obj/conf/cf-parse.tab.c"
    break;

  case 650: /* channel_sym: VPN6  */
#line 900 "nest/config.Y"
                { (yyval.t) = "vpn6"; }
#line 10619 "obj/conf/cf-parse.tab.c"
    break;

  case 651: /* channel_sym: VPN6_MC  */
#line 901 "nest/config.Y"
                { (yyval.t) = "vpn6-mc"; }
#line 10625 "obj/conf/cf-parse.tab.c"
    break;

  case 652: /* channel_sym: VPN6_MPLS  */
#line 902 "nest/config.Y"
                { (yyval.t) = "vpn6-mpls"; }
#line 10631 "obj/conf/cf-parse.tab.c"
    break;

  case 653: /* channel_sym: ROA4  */
#line 903 "nest/config.Y"
                { (yyval.t) = "roa4"; }
#line 10637 "obj/conf/cf-parse.tab.c"
    break;

  case 654: /* channel_sym: ROA6  */
#line 904 "nest/config.Y"
                { (yyval.t) = "roa6"; }
#line 10643 "obj/conf/cf-parse.tab.c"
    break;

  case 655: /* channel_sym: FLOW4  */
#line 905 "nest/config.Y"
                { (yyval.t) = "flow4"; }
#line 10649 "obj/conf/cf-parse.tab.c"
    break;

  case 656: /* channel_sym: FLOW6  */
#line 906 "nest/config.Y"
                { (yyval.t) = "flow6"; }
#line 10655 "obj/conf/cf-parse.tab.c"
    break;

  case 657: /* channel_sym: MPLS  */
#line 907 "nest/config.Y"
                { (yyval.t) = "mpls"; }
#line 10661 "obj/conf/cf-parse.tab.c"
    break;

  case 658: /* channel_sym: ASPA  */
#line 908 "nest/config.Y"
                { (yyval.t) = "aspa"; }
#line 10667 "obj/conf/cf-parse.tab.c"
    break;

  case 659: /* channel_sym: PRI  */
#line 909 "nest/config.Y"
                { (yyval.t) = "pri"; }
#line 10673 "obj/conf/cf-parse.tab.c"
    break;

  case 660: /* channel_sym: SEC  */
#line 910 "nest/config.Y"
                { (yyval.t) = "sec"; }
#line 10679 "obj/conf/cf-parse.tab.c"
    break;

  case 661: /* channel_arg: CF_SYM_KNOWN '.' channel_sym  */
#line 914 "nest/config.Y"
                                {
     cf_assert_symbol((yyvsp[-2].s), SYM_PROTO);
     struct proto *p =  (yyvsp[-2].s)->proto->proto;
     if (!p) cf_error("%s is not a protocol", (yyvsp[-2].s)->name);
     (yyval.c) = proto_find_channel_by_name(p, (yyvsp[0].t));
     if (!(yyval.c)) cf_error("Channel %s.%s not found", (yyvsp[-2].s)->name, (yyvsp[0].t));
   }
#line 10691 "obj/conf/cf-parse.tab.c"
    break;

  case 663: /* cmd_SHOW_SYMBOLS: SHOW SYMBOLS sym_args END  */
#line 925 "nest/config.Y"
{ cmd_show_symbols((yyvsp[-1].sd)); }
#line 10697 "obj/conf/cf-parse.tab.c"
    break;

  case 664: /* sym_args: %empty  */
#line 934 "nest/config.Y"
               {
     (yyval.sd) = cfg_allocz(sizeof(struct sym_show_data));
     (yyval.sd)->config = this_cli->main_config;
   }
#line 10706 "obj/conf/cf-parse.tab.c"
    break;

  case 665: /* sym_args: sym_args TABLE  */
#line 938 "nest/config.Y"
                  { (yyval.sd) = (yyvsp[-1].sd); (yyval.sd)->type = SYM_TABLE; }
#line 10712 "obj/conf/cf-parse.tab.c"
    break;

  case 666: /* sym_args: sym_args FILTER  */
#line 939 "nest/config.Y"
                   { (yyval.sd) = (yyvsp[-1].sd); (yyval.sd)->type = SYM_FILTER; }
#line 10718 "obj/conf/cf-parse.tab.c"
    break;

  case 667: /* sym_args: sym_args FUNCTION  */
#line 940 "nest/config.Y"
                     { (yyval.sd) = (yyvsp[-1].sd); (yyval.sd)->type = SYM_FUNCTION; }
#line 10724 "obj/conf/cf-parse.tab.c"
    break;

  case 668: /* sym_args: sym_args PROTOCOL  */
#line 941 "nest/config.Y"
                     { (yyval.sd) = (yyvsp[-1].sd); (yyval.sd)->type = SYM_PROTO; }
#line 10730 "obj/conf/cf-parse.tab.c"
    break;

  case 669: /* sym_args: sym_args TEMPLATE  */
#line 942 "nest/config.Y"
                     { (yyval.sd) = (yyvsp[-1].sd); (yyval.sd)->type = SYM_TEMPLATE; }
#line 10736 "obj/conf/cf-parse.tab.c"
    break;

  case 670: /* sym_args: sym_args CF_SYM_KNOWN  */
#line 943 "nest/config.Y"
                         { (yyval.sd) = (yyvsp[-1].sd); (yyval.sd)->sym = (yyvsp[0].s); }
#line 10742 "obj/conf/cf-parse.tab.c"
    break;

  case 672: /* cmd_DUMP_RESOURCES: DUMP RESOURCES text END  */
#line 948 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "resources", resource_dump); }
#line 10748 "obj/conf/cf-parse.tab.c"
    break;

  case 674: /* cmd_DUMP_SOCKETS: DUMP SOCKETS text END  */
#line 950 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "sockets", sk_dump_all); }
#line 10754 "obj/conf/cf-parse.tab.c"
    break;

  case 676: /* cmd_DUMP_AO_KEYS: DUMP AO KEYS text END  */
#line 952 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "AO keys", sk_dump_ao_all); }
#line 10760 "obj/conf/cf-parse.tab.c"
    break;

  case 678: /* cmd_DUMP_EVENTS: DUMP EVENTS text END  */
#line 954 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "event log", io_log_dump); }
#line 10766 "obj/conf/cf-parse.tab.c"
    break;

  case 680: /* cmd_DUMP_INTERFACES: DUMP INTERFACES text END  */
#line 956 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "interfaces", if_dump_all); }
#line 10772 "obj/conf/cf-parse.tab.c"
    break;

  case 682: /* cmd_DUMP_NEIGHBORS: DUMP NEIGHBORS text END  */
#line 958 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "neighbor cache", neigh_dump_all); }
#line 10778 "obj/conf/cf-parse.tab.c"
    break;

  case 684: /* cmd_DUMP_ATTRIBUTES: DUMP ATTRIBUTES text END  */
#line 960 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "attribute cache", ea_dump_all); }
#line 10784 "obj/conf/cf-parse.tab.c"
    break;

  case 686: /* cmd_DUMP_ROUTES: DUMP ROUTES text END  */
#line 962 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "routing tables", rt_dump_all); }
#line 10790 "obj/conf/cf-parse.tab.c"
    break;

  case 688: /* cmd_DUMP_TABLES: DUMP TABLES text END  */
#line 964 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "table connections", rt_dump_hooks_all); }
#line 10796 "obj/conf/cf-parse.tab.c"
    break;

  case 690: /* cmd_DUMP_PROTOCOLS: DUMP PROTOCOLS text END  */
#line 966 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "protocols", protos_dump_all); }
#line 10802 "obj/conf/cf-parse.tab.c"
    break;

  case 692: /* cmd_DUMP_FILTER_ALL: DUMP FILTER ALL text END  */
#line 968 "nest/config.Y"
{ cmd_dump_file(this_cli, (yyvsp[-1].t), "filter bytecode", filters_dump_all); }
#line 10808 "obj/conf/cf-parse.tab.c"
    break;

  case 694: /* cmd_EVAL: EVAL term END  */
#line 971 "nest/config.Y"
{ cmd_eval(f_linearize((yyvsp[-1].x), 1)); }
#line 10814 "obj/conf/cf-parse.tab.c"
    break;

  case 695: /* partial_opt: PARTIAL term  */
#line 974 "nest/config.Y"
               {
    struct f_val val;
    if (f_eval(f_linearize((yyvsp[0].x), 1), &val) > F_RETURN) cf_error("Runtime error");
    if (val.type != T_PREFIX_SET) cf_error("Partial spec must be prefix set");
    (yyval.const_trie) = val.val.ti;
  }
#line 10825 "obj/conf/cf-parse.tab.c"
    break;

  case 696: /* partial_opt: %empty  */
#line 980 "nest/config.Y"
                { (yyval.const_trie) = NULL; }
#line 10831 "obj/conf/cf-parse.tab.c"
    break;

  case 698: /* cmd_DISABLE: DISABLE proto_patt opttext END  */
#line 984 "nest/config.Y"
{ proto_apply_cmd((yyvsp[-2].ps), proto_cmd_disable, 1, (uintptr_t) (yyvsp[-1].t)); }
#line 10837 "obj/conf/cf-parse.tab.c"
    break;

  case 700: /* cmd_ENABLE: ENABLE proto_patt opttext END  */
#line 986 "nest/config.Y"
{ proto_apply_cmd((yyvsp[-2].ps), proto_cmd_enable, 1, (uintptr_t) (yyvsp[-1].t)); }
#line 10843 "obj/conf/cf-parse.tab.c"
    break;

  case 702: /* cmd_RESTART: RESTART proto_patt opttext END  */
#line 988 "nest/config.Y"
{ proto_apply_cmd((yyvsp[-2].ps), proto_cmd_restart, 1, (uintptr_t) (yyvsp[-1].t)); }
#line 10849 "obj/conf/cf-parse.tab.c"
    break;

  case 704: /* cmd_RELOAD_FILTERS: RELOAD FILTERS proto_patt partial_opt END  */
#line 990 "nest/config.Y"
{ proto_call_cmd_reload((yyvsp[-2].ps), CMD_RELOAD, (yyvsp[-1].const_trie)); }
#line 10855 "obj/conf/cf-parse.tab.c"
    break;

  case 706: /* cmd_RELOAD_FILTERS_IN: RELOAD FILTERS IN proto_patt partial_opt END  */
#line 992 "nest/config.Y"
{ proto_call_cmd_reload((yyvsp[-2].ps), CMD_RELOAD_IN, (yyvsp[-1].const_trie)); }
#line 10861 "obj/conf/cf-parse.tab.c"
    break;

  case 708: /* cmd_RELOAD_FILTERS_OUT: RELOAD FILTERS OUT proto_patt partial_opt END  */
#line 994 "nest/config.Y"
{ proto_call_cmd_reload((yyvsp[-2].ps), CMD_RELOAD_OUT, (yyvsp[-1].const_trie)); }
#line 10867 "obj/conf/cf-parse.tab.c"
    break;

  case 710: /* cmd_DEBUG: DEBUG debug_args END  */
#line 998 "nest/config.Y"
{ /* Done in debug_args */  }
#line 10873 "obj/conf/cf-parse.tab.c"
    break;

  case 711: /* debug_args: proto_patt debug_mask  */
#line 1010 "nest/config.Y"
                         { proto_apply_cmd((yyvsp[-1].ps), proto_cmd_debug, 1, (yyvsp[0].i));  }
#line 10879 "obj/conf/cf-parse.tab.c"
    break;

  case 712: /* debug_args: channel_arg debug_mask  */
#line 1011 "nest/config.Y"
                          { channel_cmd_debug((yyvsp[-1].c), (yyvsp[0].i)); }
#line 10885 "obj/conf/cf-parse.tab.c"
    break;

  case 714: /* cmd_MRTDUMP: MRTDUMP proto_patt mrtdump_mask END  */
#line 1016 "nest/config.Y"
{ proto_apply_cmd((yyvsp[-2].ps), proto_cmd_mrtdump, 1, (yyvsp[-1].i)); }
#line 10891 "obj/conf/cf-parse.tab.c"
    break;

  case 716: /* cmd_RESTRICT: RESTRICT END  */
#line 1019 "nest/config.Y"
{ this_cli->restricted = 1; cli_msg(16, "Access restricted"); }
#line 10897 "obj/conf/cf-parse.tab.c"
    break;

  case 718: /* cmd_TIMEFORMAT: TIMEFORMAT timeformat_spec END  */
#line 1023 "nest/config.Y"
{ cli_set_timeformat(this_cli, (yyvsp[-1].tf)); }
#line 10903 "obj/conf/cf-parse.tab.c"
    break;

  case 719: /* proto_patt: CF_SYM_KNOWN  */
#line 1032 "nest/config.Y"
                { cf_assert_symbol((yyvsp[0].s), SYM_PROTO); (yyval.ps).ptr = (yyvsp[0].s); (yyval.ps).patt = 0; }
#line 10909 "obj/conf/cf-parse.tab.c"
    break;

  case 720: /* proto_patt: ALL  */
#line 1033 "nest/config.Y"
        { (yyval.ps).ptr = NULL; (yyval.ps).patt = 1; }
#line 10915 "obj/conf/cf-parse.tab.c"
    break;

  case 721: /* proto_patt: TEXT  */
#line 1034 "nest/config.Y"
        { (yyval.ps).ptr = (yyvsp[0].t); (yyval.ps).patt = 1; }
#line 10921 "obj/conf/cf-parse.tab.c"
    break;

  case 722: /* proto_patt2: CF_SYM_KNOWN  */
#line 1038 "nest/config.Y"
                { cf_assert_symbol((yyvsp[0].s), SYM_PROTO); (yyval.ps).ptr = (yyvsp[0].s); (yyval.ps).patt = 0; }
#line 10927 "obj/conf/cf-parse.tab.c"
    break;

  case 723: /* proto_patt2: %empty  */
#line 1039 "nest/config.Y"
        { (yyval.ps).ptr = NULL; (yyval.ps).patt = 1; }
#line 10933 "obj/conf/cf-parse.tab.c"
    break;

  case 724: /* proto_patt2: TEXT  */
#line 1040 "nest/config.Y"
        { (yyval.ps).ptr = (yyvsp[0].t); (yyval.ps).patt = 1; }
#line 10939 "obj/conf/cf-parse.tab.c"
    break;

  case 727: /* mpls_domain_start: MPLS DOMAIN symbol  */
#line 35 "nest/mpls.Y"
                                      { this_mpls_domain = mpls_domain_config_new((yyvsp[0].s)); }
#line 10945 "obj/conf/cf-parse.tab.c"
    break;

  case 733: /* mpls_domain_end: %empty  */
#line 51 "nest/mpls.Y"
                 { mpls_domain_postconfig(this_mpls_domain); this_mpls_domain = NULL; }
#line 10951 "obj/conf/cf-parse.tab.c"
    break;

  case 735: /* mpls_range_start: LABEL RANGE STATIC  */
#line 56 "nest/mpls.Y"
                                     {
    this_mpls_range = this_mpls_domain->static_range;
}
#line 10959 "obj/conf/cf-parse.tab.c"
    break;

  case 736: /* mpls_range_start: LABEL RANGE DYNAMIC  */
#line 60 "nest/mpls.Y"
                                      {
    this_mpls_range = this_mpls_domain->dynamic_range;
}
#line 10967 "obj/conf/cf-parse.tab.c"
    break;

  case 737: /* mpls_range_start: LABEL RANGE symbol  */
#line 64 "nest/mpls.Y"
                                     {
    this_mpls_range = mpls_range_config_new(this_mpls_domain, (yyvsp[0].s));
}
#line 10975 "obj/conf/cf-parse.tab.c"
    break;

  case 738: /* mpls_range_opt: START expr  */
#line 69 "nest/mpls.Y"
              { this_mpls_range->start = (yyvsp[0].i); if ((yyvsp[0].i) >= MPLS_MAX_LABEL) cf_error("MPLS label range start must be less than 2^20"); }
#line 10981 "obj/conf/cf-parse.tab.c"
    break;

  case 739: /* mpls_range_opt: LENGTH expr  */
#line 70 "nest/mpls.Y"
               { this_mpls_range->length = (yyvsp[0].i); if ((yyvsp[0].i) >= MPLS_MAX_LABEL) cf_error("MPLS label range length must be less than 2^20"); if (!(yyvsp[0].i)) cf_error("MPLS label range length must be nonzero"); }
#line 10987 "obj/conf/cf-parse.tab.c"
    break;

  case 744: /* mpls_range_end: %empty  */
#line 84 "nest/mpls.Y"
{
  struct mpls_range_config *r = this_mpls_range;

  if ((r->start == (uint) -1) || (r->length == (uint) -1))
    cf_error("MPLS label range start and length must be specified");

  if (r->start + r->length > MPLS_MAX_LABEL)
    cf_error("MPLS label range end must be less than 2^20");

  this_mpls_range = NULL;
}
#line 11003 "obj/conf/cf-parse.tab.c"
    break;

  case 746: /* mpls_channel_start: MPLS  */
#line 100 "nest/mpls.Y"
{
  (yyval.cc) = this_channel = channel_config_get(&channel_mpls, net_label[NET_MPLS], NET_MPLS, this_proto);

  if (EMPTY_LIST(new_config->mpls_domains))
  {
    int counter = 0;
    mpls_domain_config_new(cf_default_name(new_config, "mpls%d", &counter));
    cf_warn("No MPLS domain defined");
  }

  /* Default values for new channel */
  if (!MPLS_CC->domain)
  {
    MPLS_CC->domain = cf_default_mpls_domain(new_config);
    MPLS_CC->label_policy = MPLS_POLICY_PREFIX;
  }
}
#line 11025 "obj/conf/cf-parse.tab.c"
    break;

  case 747: /* mpls_label_policy: STATIC  */
#line 119 "nest/mpls.Y"
          { (yyval.i) = MPLS_POLICY_STATIC; }
#line 11031 "obj/conf/cf-parse.tab.c"
    break;

  case 748: /* mpls_label_policy: PREFIX  */
#line 120 "nest/mpls.Y"
          { (yyval.i) = MPLS_POLICY_PREFIX; }
#line 11037 "obj/conf/cf-parse.tab.c"
    break;

  case 749: /* mpls_label_policy: AGGREGATE  */
#line 121 "nest/mpls.Y"
             { (yyval.i) = MPLS_POLICY_AGGREGATE; }
#line 11043 "obj/conf/cf-parse.tab.c"
    break;

  case 750: /* mpls_label_policy: VRF  */
#line 122 "nest/mpls.Y"
       { (yyval.i) = MPLS_POLICY_VRF; }
#line 11049 "obj/conf/cf-parse.tab.c"
    break;

  case 752: /* mpls_channel_opt: DOMAIN CF_SYM_KNOWN  */
#line 127 "nest/mpls.Y"
                       { cf_assert_symbol((yyvsp[0].s), SYM_MPLS_DOMAIN); MPLS_CC->domain = (yyvsp[0].s)->mpls_domain; }
#line 11055 "obj/conf/cf-parse.tab.c"
    break;

  case 753: /* mpls_channel_opt: LABEL RANGE CF_SYM_KNOWN  */
#line 128 "nest/mpls.Y"
                            { cf_assert_symbol((yyvsp[0].s), SYM_MPLS_RANGE); MPLS_CC->range = (yyvsp[0].s)->mpls_range; }
#line 11061 "obj/conf/cf-parse.tab.c"
    break;

  case 754: /* mpls_channel_opt: LABEL RANGE STATIC  */
#line 129 "nest/mpls.Y"
                       { MPLS_CC->range = MPLS_CC->domain->static_range; }
#line 11067 "obj/conf/cf-parse.tab.c"
    break;

  case 755: /* mpls_channel_opt: LABEL RANGE DYNAMIC  */
#line 130 "nest/mpls.Y"
                       { MPLS_CC->range = MPLS_CC->domain->dynamic_range; }
#line 11073 "obj/conf/cf-parse.tab.c"
    break;

  case 756: /* mpls_channel_opt: LABEL POLICY mpls_label_policy  */
#line 131 "nest/mpls.Y"
                                  { MPLS_CC->label_policy = (yyvsp[0].i); }
#line 11079 "obj/conf/cf-parse.tab.c"
    break;

  case 761: /* $@15: %empty  */
#line 144 "nest/mpls.Y"
                  { mpls_channel_postconfig(this_channel); }
#line 11085 "obj/conf/cf-parse.tab.c"
    break;

  case 763: /* show_mpls_ranges_args: %empty  */
#line 149 "nest/mpls.Y"
   {
     if (EMPTY_LIST(this_cli->main_config->mpls_domains))
       cf_error("No MPLS domain defined");

     (yyval.msrc) = cfg_allocz(sizeof(struct mpls_show_ranges_cmd));
   }
#line 11096 "obj/conf/cf-parse.tab.c"
    break;

  case 764: /* show_mpls_ranges_args: show_mpls_ranges_args CF_SYM_KNOWN  */
#line 156 "nest/mpls.Y"
   {
     if ((yyvsp[0].s)->class == SYM_MPLS_DOMAIN)
     {
       if ((yyval.msrc)->domain)
	cf_error("Only one MPLS domain expected");

       (yyval.msrc)->domain = (yyvsp[0].s)->mpls_domain;
     }
     else if ((yyvsp[0].s)->class == SYM_MPLS_RANGE)
     {
       if ((yyval.msrc)->range)
	cf_error("Only one MPLS label range expected");

       if ((yyval.msrc)->domain != (yyvsp[0].s)->mpls_range->domain)
	cf_error("MPLS label range from different MPLS domain");

       (yyval.msrc)->domain = (yyvsp[0].s)->mpls_range->domain;
       (yyval.msrc)->range = (yyvsp[0].s)->mpls_range;
     }
     else
       cf_error("MPLS domain or label range expected");
   }
#line 11123 "obj/conf/cf-parse.tab.c"
    break;

  case 765: /* show_mpls_ranges_args: show_mpls_ranges_args STATIC  */
#line 179 "nest/mpls.Y"
   {
     if ((yyval.msrc)->range)
       cf_error("Only one MPLS label range expected");

     (yyval.msrc)->domain = (yyval.msrc)->domain ?: cf_default_mpls_domain(this_cli->main_config);
     (yyval.msrc)->range = (yyval.msrc)->domain->static_range;
   }
#line 11135 "obj/conf/cf-parse.tab.c"
    break;

  case 766: /* show_mpls_ranges_args: show_mpls_ranges_args DYNAMIC  */
#line 187 "nest/mpls.Y"
   {
     if ((yyval.msrc)->range)
       cf_error("Only one MPLS label range expected");

     (yyval.msrc)->domain = (yyval.msrc)->domain ?: cf_default_mpls_domain(this_cli->main_config);
     (yyval.msrc)->range = (yyval.msrc)->domain->dynamic_range;
   }
#line 11147 "obj/conf/cf-parse.tab.c"
    break;

  case 768: /* cmd_SHOW_MPLS_RANGES: SHOW MPLS RANGES show_mpls_ranges_args END  */
#line 197 "nest/mpls.Y"
{ mpls_show_ranges((yyvsp[-1].msrc)); }
#line 11153 "obj/conf/cf-parse.tab.c"
    break;

  case 770: /* aggregator_proto_start: proto_start AGGREGATOR  */
#line 31 "proto/aggregator/config.Y"
{
  this_proto = proto_config_new(&proto_aggregator, (yyvsp[-1].i));
  this_channel = AGGREGATOR_CFG->src = channel_config_new(NULL, "source", 0, this_proto);
  AGGREGATOR_CFG->dst = channel_config_new(NULL, "destination", 0, this_proto);

  AGGREGATOR_CFG->src->ra_mode = AGGREGATOR_CFG->dst->ra_mode = RA_ANY;
}
#line 11165 "obj/conf/cf-parse.tab.c"
    break;

  case 773: /* aggregator_proto_item: PEER TABLE rtable  */
#line 42 "proto/aggregator/config.Y"
                     { AGGREGATOR_CFG->dst->table = (yyvsp[0].r); }
#line 11171 "obj/conf/cf-parse.tab.c"
    break;

  case 774: /* $@16: %empty  */
#line 43 "proto/aggregator/config.Y"
                {
    if (AGGREGATOR_CFG->aggr_on)
      cf_error("Only one aggregate on clause allowed");

    cf_enter_filters();
    cf_push_block_scope(new_config);
 }
#line 11183 "obj/conf/cf-parse.tab.c"
    break;

  case 775: /* aggregator_proto_item: AGGREGATE ON $@16 aggr_list  */
#line 49 "proto/aggregator/config.Y"
             {
    int count = new_config->current_scope->slots;
    cf_pop_block_scope(new_config);
    cf_exit_filters();

    if (!AGGREGATOR_CFG->aggr_on_net)
      cf_error("aggregate on must be always include 'net'.");

   struct f_inst *rot = NULL;
   while ((yyvsp[0].xp).begin)
   {
     struct f_inst *tmp = (yyvsp[0].xp).begin->next;
     (yyvsp[0].xp).begin->next = rot;
     rot = (yyvsp[0].xp).begin;
     (yyvsp[0].xp).begin = tmp;
   }

   AGGREGATOR_CFG->aggr_on_count = count;
   AGGREGATOR_CFG->aggr_on = f_linearize(rot, count);

   struct f_line *premerge = f_linearize((yyvsp[0].xp).end, 0);
   premerge->args = count;
   AGGREGATOR_CFG->premerge = premerge;
 }
#line 11212 "obj/conf/cf-parse.tab.c"
    break;

  case 776: /* $@17: %empty  */
#line 73 "proto/aggregator/config.Y"
            {
   cf_enter_filters();
   cf_push_block_scope(new_config);
   f_predefined_variable(new_config, "routes", T_ROUTES_BLOCK);
 }
#line 11222 "obj/conf/cf-parse.tab.c"
    break;

  case 777: /* aggregator_proto_item: MERGE BY $@17 function_body  */
#line 77 "proto/aggregator/config.Y"
                 {
   cf_pop_block_scope(new_config);
   cf_exit_filters();
   (yyvsp[0].fl)->args++;
   AGGREGATOR_CFG->merge_by = (yyvsp[0].fl);
 }
#line 11233 "obj/conf/cf-parse.tab.c"
    break;

  case 782: /* aggr_list: aggr_list ',' aggr_item  */
#line 91 "proto/aggregator/config.Y"
                           {
    if ((yyval.xp).begin = (yyvsp[0].xp).begin)
      (yyval.xp).begin->next = (yyvsp[-2].xp).begin;
    else
      (yyval.xp).begin = (yyvsp[-2].xp).begin;

    if ((yyval.xp).end = (yyvsp[0].xp).end)
      (yyval.xp).end->next = (yyvsp[-2].xp).end;
    else
      (yyval.xp).end = (yyvsp[-2].xp).end;
 }
#line 11249 "obj/conf/cf-parse.tab.c"
    break;

  case 783: /* aggr_item: '(' term ')'  */
#line 105 "proto/aggregator/config.Y"
                {
     switch ((yyvsp[-1].x)->type) {
       case T_INT:
       case T_BOOL:
       case T_PAIR:
       case T_QUAD:
       case T_ENUM:
       case T_IP:
       case T_EC:
       case T_LC:
       case T_RD:
	 /* Fits, OK */
	 break;

       default:
	 cf_error("Expression evaluated to type %s unsupported by aggregator. Store this value as a custom attribute instead", f_type_name((yyvsp[-1].x)->type));
     }

     (yyval.xp).begin = (yyvsp[-1].x);
     (yyval.xp).end = NULL;
     f_new_var(new_config->current_scope);
   }
#line 11276 "obj/conf/cf-parse.tab.c"
    break;

  case 784: /* aggr_item: lvalue  */
#line 127 "proto/aggregator/config.Y"
           {
    (yyval.xp).begin = f_lval_getter(&(yyvsp[0].flv));
    int vari = f_new_var(new_config->current_scope);

    if ((yyvsp[0].flv).type == F_LVAL_SA && (yyvsp[0].flv).sa.sa_code == SA_NET)
      AGGREGATOR_CFG->aggr_on_net = 1;
    if (((yyvsp[0].flv).type == F_LVAL_CONSTANT) || 
	((yyvsp[0].flv).type == F_LVAL_SA && (yyvsp[0].flv).sa.readonly))
      (yyval.xp).end = NULL;
    else
    {
      char varname[12];
      bsnprintf(varname, 12, "!aggr%d", vari);
      (yyval.xp).end = f_lval_setter(&(yyvsp[0].flv),
	  f_new_inst(FI_VAR_GET, cf_define_symbol(
	      new_config, cf_get_symbol(new_config, varname),
	      SYM_VARIABLE | (yyval.xp).begin->type, offset, vari
	      )));
    }
  }
#line 11301 "obj/conf/cf-parse.tab.c"
    break;

  case 786: /* bfd_proto_start: proto_start BFD  */
#line 39 "proto/bfd/config.Y"
{
  this_proto = proto_config_new(&proto_bfd, (yyvsp[-1].i));
  this_proto->loop_order = DOMAIN_ORDER(proto);
  if (new_config->thread_group_simple)
    BFD_CFG->express_thread_group = TTAIL(thread_group, &new_config->thread_group);
  else
  {
    struct symbol *sym = cf_find_symbol(new_config, "express");
    if (sym && sym->class == SYM_THREAD_GROUP)
      BFD_CFG->express_thread_group = sym->thread_group;
    else
      BFD_CFG->express_thread_group = NULL;
  }

  init_list(&BFD_CFG->patt_list);
  BFD_CFG->accept_ipv4 = BFD_CFG->accept_ipv6 = 1;
  BFD_CFG->accept_direct = BFD_CFG->accept_multihop = 1;
}
#line 11324 "obj/conf/cf-parse.tab.c"
    break;

  case 788: /* bfd_proto_item: EXPRESS THREAD GROUP symbol  */
#line 60 "proto/bfd/config.Y"
                               {
    if ((yyvsp[0].s)->class != SYM_THREAD_GROUP)
      cf_error("Unexpected symbol %s as a thread group name", (yyvsp[0].s)->name);
    BFD_CFG->express_thread_group = (yyvsp[0].s)->thread_group;
 }
#line 11334 "obj/conf/cf-parse.tab.c"
    break;

  case 793: /* bfd_proto_item: STRICT BIND bool  */
#line 69 "proto/bfd/config.Y"
                    { BFD_CFG->strict_bind = (yyvsp[0].i); }
#line 11340 "obj/conf/cf-parse.tab.c"
    break;

  case 794: /* bfd_proto_item: ZERO UDP6 CHECKSUM RX bool  */
#line 70 "proto/bfd/config.Y"
                              { BFD_CFG->zero_udp6_checksum_rx = (yyvsp[0].i); }
#line 11346 "obj/conf/cf-parse.tab.c"
    break;

  case 797: /* bfd_proto: bfd_proto_start proto_name '{' bfd_proto_opts '}'  */
#line 79 "proto/bfd/config.Y"
                                                     {
  if (!BFD_CFG->express_thread_group)
    cf_error("Express thread group not configured and \"express\" not found.");
}
#line 11355 "obj/conf/cf-parse.tab.c"
    break;

  case 798: /* bfd_accept_item: IPV4  */
#line 86 "proto/bfd/config.Y"
                        { BFD_CFG->accept_ipv4 = 1;  BFD_CFG->accept_ipv6 = 0; }
#line 11361 "obj/conf/cf-parse.tab.c"
    break;

  case 799: /* bfd_accept_item: IPV6  */
#line 87 "proto/bfd/config.Y"
                        { BFD_CFG->accept_ipv4 = 0;  BFD_CFG->accept_ipv6 = 1; }
#line 11367 "obj/conf/cf-parse.tab.c"
    break;

  case 800: /* bfd_accept_item: DIRECT  */
#line 88 "proto/bfd/config.Y"
                        { BFD_CFG->accept_direct = 1;  BFD_CFG->accept_multihop = 0; }
#line 11373 "obj/conf/cf-parse.tab.c"
    break;

  case 801: /* bfd_accept_item: MULTIHOP  */
#line 89 "proto/bfd/config.Y"
                        { BFD_CFG->accept_direct = 0;  BFD_CFG->accept_multihop = 1; }
#line 11379 "obj/conf/cf-parse.tab.c"
    break;

  case 802: /* bfd_accept: %empty  */
#line 93 "proto/bfd/config.Y"
   {
     BFD_CFG->accept_ipv4 = BFD_CFG->accept_ipv6 = 1;
     BFD_CFG->accept_direct = BFD_CFG->accept_multihop = 1;
   }
#line 11388 "obj/conf/cf-parse.tab.c"
    break;

  case 804: /* bfd_iface_start: %empty  */
#line 101 "proto/bfd/config.Y"
{
  this_ipatt = cfg_allocz(sizeof(struct bfd_iface_config));
  add_tail(&BFD_CFG->patt_list, NODE this_ipatt);
  init_list(&this_ipatt->ipn_list);

  this_bfd_opts = &BFD_IFACE->opts;

  this_bfd_opts->min_rx_int = BFD_DEFAULT_MIN_RX_INT;
  this_bfd_opts->min_tx_int = BFD_DEFAULT_MIN_TX_INT;
  this_bfd_opts->idle_tx_int = BFD_DEFAULT_IDLE_TX_INT;
  this_bfd_opts->multiplier = BFD_DEFAULT_MULTIPLIER;

  reset_passwords();
}
#line 11407 "obj/conf/cf-parse.tab.c"
    break;

  case 805: /* bfd_iface_finish: %empty  */
#line 117 "proto/bfd/config.Y"
{
  this_bfd_opts->passwords = get_passwords();

  if (!this_bfd_opts->auth_type != !this_bfd_opts->passwords)
    cf_warn("Authentication and password options should be used together");

  if (this_bfd_opts->passwords)
  {
    struct password_item *pass;
    WALK_LIST(pass, *this_bfd_opts->passwords)
    {
      if (pass->alg)
        cf_error("Password algorithm option not available in BFD protocol");

      pass->alg = bfd_auth_type_to_hash_alg[this_bfd_opts->auth_type];
    }
  }

  this_bfd_opts = NULL;
}
#line 11432 "obj/conf/cf-parse.tab.c"
    break;

  case 806: /* bfd_auth_type: NONE  */
#line 139 "proto/bfd/config.Y"
                         { (yyval.i) = BFD_AUTH_NONE; }
#line 11438 "obj/conf/cf-parse.tab.c"
    break;

  case 807: /* bfd_auth_type: SIMPLE  */
#line 140 "proto/bfd/config.Y"
                         { (yyval.i) = BFD_AUTH_SIMPLE; }
#line 11444 "obj/conf/cf-parse.tab.c"
    break;

  case 808: /* bfd_auth_type: KEYED MD5  */
#line 141 "proto/bfd/config.Y"
                         { (yyval.i) = BFD_AUTH_KEYED_MD5; }
#line 11450 "obj/conf/cf-parse.tab.c"
    break;

  case 809: /* bfd_auth_type: KEYED SHA1  */
#line 142 "proto/bfd/config.Y"
                         { (yyval.i) = BFD_AUTH_KEYED_SHA1; }
#line 11456 "obj/conf/cf-parse.tab.c"
    break;

  case 810: /* bfd_auth_type: METICULOUS KEYED MD5  */
#line 143 "proto/bfd/config.Y"
                         { (yyval.i) = BFD_AUTH_METICULOUS_KEYED_MD5; }
#line 11462 "obj/conf/cf-parse.tab.c"
    break;

  case 811: /* bfd_auth_type: METICULOUS KEYED SHA1  */
#line 144 "proto/bfd/config.Y"
                         { (yyval.i) = BFD_AUTH_METICULOUS_KEYED_SHA1; }
#line 11468 "obj/conf/cf-parse.tab.c"
    break;

  case 815: /* bfd_multihop: bfd_iface_start bfd_iface_opt_list bfd_iface_finish  */
#line 157 "proto/bfd/config.Y"
{ BFD_CFG->multihop = BFD_IFACE; }
#line 11474 "obj/conf/cf-parse.tab.c"
    break;

  case 816: /* bfd_neigh_iface: %empty  */
#line 161 "proto/bfd/config.Y"
               { (yyval.iface) = NULL; }
#line 11480 "obj/conf/cf-parse.tab.c"
    break;

  case 817: /* bfd_neigh_iface: '%' symbol  */
#line 162 "proto/bfd/config.Y"
              { (yyval.iface) = if_get_by_name((yyvsp[0].s)->name); }
#line 11486 "obj/conf/cf-parse.tab.c"
    break;

  case 818: /* bfd_neigh_iface: DEV text  */
#line 163 "proto/bfd/config.Y"
            { (yyval.iface) = if_get_by_name((yyvsp[0].t)); }
#line 11492 "obj/conf/cf-parse.tab.c"
    break;

  case 819: /* bfd_neigh_local: %empty  */
#line 167 "proto/bfd/config.Y"
               { (yyval.a) = IPA_NONE; }
#line 11498 "obj/conf/cf-parse.tab.c"
    break;

  case 820: /* bfd_neigh_local: LOCAL ipa  */
#line 168 "proto/bfd/config.Y"
             { (yyval.a) = (yyvsp[0].a); }
#line 11504 "obj/conf/cf-parse.tab.c"
    break;

  case 821: /* bfd_neigh_multihop: %empty  */
#line 172 "proto/bfd/config.Y"
               { (yyval.i) = 0; }
#line 11510 "obj/conf/cf-parse.tab.c"
    break;

  case 822: /* bfd_neigh_multihop: MULTIHOP bool  */
#line 173 "proto/bfd/config.Y"
                 { (yyval.i) = (yyvsp[0].i); }
#line 11516 "obj/conf/cf-parse.tab.c"
    break;

  case 823: /* bfd_neighbor: ipa bfd_neigh_iface bfd_neigh_local bfd_neigh_multihop  */
#line 177 "proto/bfd/config.Y"
{
  this_bfd_neighbor = cfg_allocz(sizeof(struct bfd_neighbor));
  bfd_neighbor_add_tail(&BFD_CFG->neigh_list, this_bfd_neighbor);

  callback_init(&BFD_NEIGHBOR->notify, bfd_neighbor_notify, &main_birdloop);

  BFD_NEIGHBOR->addr = (yyvsp[-3].a);
  BFD_NEIGHBOR->local = (yyvsp[-1].a);
  BFD_NEIGHBOR->iface = (yyvsp[-2].iface);
  BFD_NEIGHBOR->multihop = (yyvsp[0].i);

  if ((yyvsp[0].i) && (yyvsp[-2].iface))
    cf_error("Neighbor cannot set both interface and multihop");

  if ((yyvsp[0].i) && ipa_zero((yyvsp[-1].a)))
    cf_error("Multihop neighbor requires specified local address");
}
#line 11538 "obj/conf/cf-parse.tab.c"
    break;

  case 824: /* bfd_item: INTERVAL expr_us  */
#line 199 "proto/bfd/config.Y"
                    { this_bfd_opts->min_rx_int = this_bfd_opts->min_tx_int = (yyvsp[0].time); }
#line 11544 "obj/conf/cf-parse.tab.c"
    break;

  case 825: /* bfd_item: MIN RX INTERVAL expr_us  */
#line 200 "proto/bfd/config.Y"
                           { this_bfd_opts->min_rx_int = (yyvsp[0].time); }
#line 11550 "obj/conf/cf-parse.tab.c"
    break;

  case 826: /* bfd_item: MIN TX INTERVAL expr_us  */
#line 201 "proto/bfd/config.Y"
                           { this_bfd_opts->min_tx_int = (yyvsp[0].time); }
#line 11556 "obj/conf/cf-parse.tab.c"
    break;

  case 827: /* bfd_item: IDLE TX INTERVAL expr_us  */
#line 202 "proto/bfd/config.Y"
                            { this_bfd_opts->idle_tx_int = (yyvsp[0].time); }
#line 11562 "obj/conf/cf-parse.tab.c"
    break;

  case 828: /* bfd_item: MULTIPLIER expr  */
#line 203 "proto/bfd/config.Y"
                   { this_bfd_opts->multiplier = (yyvsp[0].i); }
#line 11568 "obj/conf/cf-parse.tab.c"
    break;

  case 829: /* bfd_item: PASSIVE bool  */
#line 204 "proto/bfd/config.Y"
                { this_bfd_opts->passive = (yyvsp[0].i) ? BFD_OPT_PASSIVE : BFD_OPT_NOT_PASSIVE; }
#line 11574 "obj/conf/cf-parse.tab.c"
    break;

  case 830: /* bfd_item: GRACEFUL  */
#line 205 "proto/bfd/config.Y"
            { this_bfd_opts->mode = BGP_BFD_GRACEFUL; }
#line 11580 "obj/conf/cf-parse.tab.c"
    break;

  case 831: /* bfd_item: AUTHENTICATION bfd_auth_type  */
#line 206 "proto/bfd/config.Y"
                                { this_bfd_opts->auth_type = (yyvsp[0].i); }
#line 11586 "obj/conf/cf-parse.tab.c"
    break;

  case 832: /* bfd_item: password_list  */
#line 207 "proto/bfd/config.Y"
                 {}
#line 11592 "obj/conf/cf-parse.tab.c"
    break;

  case 835: /* bfd_opts_start: %empty  */
#line 216 "proto/bfd/config.Y"
{ reset_passwords(); }
#line 11598 "obj/conf/cf-parse.tab.c"
    break;

  case 836: /* bfd_opts_end: %empty  */
#line 219 "proto/bfd/config.Y"
{
  this_bfd_opts->passwords = get_passwords();

  if (!this_bfd_opts->auth_type != !this_bfd_opts->passwords)
    cf_warn("Authentication and password options should be used together");

  if (this_bfd_opts->passwords)
  {
    struct password_item *pass;
    WALK_LIST(pass, *this_bfd_opts->passwords)
    {
      if (pass->alg)
        cf_error("Password algorithm option not available in BFD protocol");

      pass->alg = bfd_auth_type_to_hash_alg[this_bfd_opts->auth_type];
    }
  }
}
#line 11621 "obj/conf/cf-parse.tab.c"
    break;

  case 839: /* cmd_SHOW_BFD_SESSIONS: SHOW BFD SESSIONS bfd_show_sessions_args END  */
#line 246 "proto/bfd/config.Y"
{ PROTO_WALK_CMD((yyvsp[-1].bssc)->name, &proto_bfd, p) bfd_show_sessions(p, (yyvsp[-1].bssc)); }
#line 11627 "obj/conf/cf-parse.tab.c"
    break;

  case 840: /* bfd_show_sessions_args: %empty  */
#line 258 "proto/bfd/config.Y"
               { (yyval.bssc) = cfg_allocz(sizeof(struct bfd_show_sessions_cmd)); }
#line 11633 "obj/conf/cf-parse.tab.c"
    break;

  case 841: /* bfd_show_sessions_args: bfd_show_sessions_args CF_SYM_KNOWN  */
#line 259 "proto/bfd/config.Y"
                                       { cf_assert_symbol((yyvsp[0].s), SYM_PROTO); (yyval.bssc)->name = (yyvsp[0].s); }
#line 11639 "obj/conf/cf-parse.tab.c"
    break;

  case 842: /* bfd_show_sessions_args: bfd_show_sessions_args ADDRESS net_or_ipa  */
#line 260 "proto/bfd/config.Y"
                                             { net_copy(&((yyval.bssc)->address), &((yyvsp[0].net))); }
#line 11645 "obj/conf/cf-parse.tab.c"
    break;

  case 843: /* bfd_show_sessions_args: bfd_show_sessions_args INTERFACE text  */
#line 261 "proto/bfd/config.Y"
                                         { (yyval.bssc)->iface = if_get_by_name((yyvsp[0].t)); }
#line 11651 "obj/conf/cf-parse.tab.c"
    break;

  case 844: /* bfd_show_sessions_args: bfd_show_sessions_args DEV text  */
#line 262 "proto/bfd/config.Y"
                                   { (yyval.bssc)->iface = if_get_by_name((yyvsp[0].t)); }
#line 11657 "obj/conf/cf-parse.tab.c"
    break;

  case 845: /* bfd_show_sessions_args: bfd_show_sessions_args ALL  */
#line 263 "proto/bfd/config.Y"
                              { (yyval.bssc)->verbose = 1; }
#line 11663 "obj/conf/cf-parse.tab.c"
    break;

  case 846: /* bfd_show_sessions_args: bfd_show_sessions_args IPV4  */
#line 264 "proto/bfd/config.Y"
                               { (yyval.bssc)->ipv4 = 1; if ((yyval.bssc)->ipv6) cf_error("Options 'ipv4' and 'ipv6' are mutually exclusive"); }
#line 11669 "obj/conf/cf-parse.tab.c"
    break;

  case 847: /* bfd_show_sessions_args: bfd_show_sessions_args IPV6  */
#line 265 "proto/bfd/config.Y"
                               { (yyval.bssc)->ipv6 = 1; if ((yyval.bssc)->ipv4) cf_error("Options 'ipv4' and 'ipv6' are mutually exclusive"); }
#line 11675 "obj/conf/cf-parse.tab.c"
    break;

  case 848: /* bfd_show_sessions_args: bfd_show_sessions_args DIRECT  */
#line 266 "proto/bfd/config.Y"
                                 { (yyval.bssc)->direct = 1; if ((yyval.bssc)->multihop) cf_error("Options 'direct' and 'multihop' are mutually exclusive"); }
#line 11681 "obj/conf/cf-parse.tab.c"
    break;

  case 849: /* bfd_show_sessions_args: bfd_show_sessions_args MULTIHOP  */
#line 267 "proto/bfd/config.Y"
                                   { (yyval.bssc)->multihop = 1; if ((yyval.bssc)->direct) cf_error("Options 'direct' and 'multihop' are mutually exclusive"); }
#line 11687 "obj/conf/cf-parse.tab.c"
    break;

  case 851: /* babel_proto_start: proto_start BABEL  */
#line 37 "proto/babel/config.Y"
{
  this_proto = proto_config_new(&proto_babel, (yyvsp[-1].i));
  init_list(&BABEL_CFG->iface_list);
  BABEL_CFG->hold_time = 1 S_;
}
#line 11697 "obj/conf/cf-parse.tab.c"
    break;

  case 855: /* babel_proto_item: RANDOMIZE ROUTER ID bool  */
#line 47 "proto/babel/config.Y"
                            { BABEL_CFG->randomize_router_id = (yyvsp[0].i); }
#line 11703 "obj/conf/cf-parse.tab.c"
    break;

  case 859: /* babel_iface_start: %empty  */
#line 60 "proto/babel/config.Y"
{
  this_ipatt = cfg_allocz(sizeof(struct babel_iface_config));
  add_tail(&BABEL_CFG->iface_list, NODE this_ipatt);
  init_list(&this_ipatt->ipn_list);
  reset_passwords();

  BABEL_IFACE->port = BABEL_PORT;
  BABEL_IFACE->type = BABEL_IFACE_TYPE_WIRED;
  BABEL_IFACE->limit = BABEL_HELLO_LIMIT;
  BABEL_IFACE->tx_tos = IP_PREC_INTERNET_CONTROL;
  BABEL_IFACE->tx_priority = sk_priority_control;
  BABEL_IFACE->rtt_min = BABEL_RTT_MIN;
  BABEL_IFACE->rtt_max = BABEL_RTT_MAX;
  BABEL_IFACE->rtt_decay = BABEL_RTT_DECAY;
  BABEL_IFACE->rtt_send = 1;
  BABEL_IFACE->check_link = 1;
  BABEL_IFACE->ext_next_hop = 1;
}
#line 11726 "obj/conf/cf-parse.tab.c"
    break;

  case 860: /* babel_iface_finish: %empty  */
#line 81 "proto/babel/config.Y"
{
  if (BABEL_IFACE->type == BABEL_IFACE_TYPE_WIRELESS)
  {
    if (!BABEL_IFACE->hello_interval)
      BABEL_IFACE->hello_interval = BABEL_HELLO_INTERVAL_WIRELESS;
    if (!BABEL_IFACE->rxcost)
      BABEL_IFACE->rxcost = BABEL_RXCOST_WIRELESS;
  }
  else
  {
    if (!BABEL_IFACE->hello_interval)
      BABEL_IFACE->hello_interval = BABEL_HELLO_INTERVAL_WIRED;
    if (!BABEL_IFACE->rxcost)
      BABEL_IFACE->rxcost = BABEL_RXCOST_WIRED;
    if (BABEL_IFACE->type == BABEL_IFACE_TYPE_TUNNEL && !BABEL_IFACE->rtt_cost)
      BABEL_IFACE->rtt_cost = BABEL_RXCOST_RTT;
  }

  if (BABEL_IFACE->rtt_cost && !BABEL_IFACE->rtt_send)
    cf_error("Can't set RTT cost when sending timestamps is disabled");

  if (BABEL_IFACE->rtt_min >= BABEL_IFACE->rtt_max)
    cf_error("Min RTT must be smaller than max RTT");

  /* Make sure we do not overflow the 16-bit centisec fields */
  if (!BABEL_IFACE->update_interval)
    BABEL_IFACE->update_interval = MIN_(BABEL_IFACE->hello_interval*BABEL_UPDATE_INTERVAL_FACTOR, BABEL_MAX_INTERVAL);
  BABEL_IFACE->ihu_interval = MIN_(BABEL_IFACE->hello_interval*BABEL_IHU_INTERVAL_FACTOR, BABEL_MAX_INTERVAL);

  BABEL_CFG->hold_time = MAX_(BABEL_CFG->hold_time, BABEL_IFACE->update_interval*BABEL_HOLD_TIME_FACTOR);

  BABEL_IFACE->passwords = get_passwords();

  if (!BABEL_IFACE->auth_type != !BABEL_IFACE->passwords)
    cf_error("Authentication and password options should be used together");

  if (BABEL_IFACE->passwords)
  {
    struct password_item *pass;
    uint len = 0, i = 0;

    WALK_LIST(pass, *BABEL_IFACE->passwords)
    {
      /* Set default crypto algorithm (HMAC-SHA256) */
      if (!pass->alg)
	pass->alg = ALG_HMAC_SHA256;

      if (!((pass->alg & ALG_HMAC) ||
	    (pass->alg == ALG_BLAKE2S_128) ||
	    (pass->alg == ALG_BLAKE2S_256) ||
	    (pass->alg == ALG_BLAKE2B_256) ||
	    (pass->alg == ALG_BLAKE2B_512)))
	cf_error("Only HMAC and Blake2 algorithms are supported");

      len += mac_type_length(pass->alg);
      i++;
    }

    BABEL_IFACE->mac_num_keys = i;
    BABEL_IFACE->mac_total_len = len;
  }

}
#line 11794 "obj/conf/cf-parse.tab.c"
    break;

  case 862: /* babel_iface_item: PORT expr  */
#line 147 "proto/babel/config.Y"
             { BABEL_IFACE->port = (yyvsp[0].i); if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>65535)) cf_error("Invalid port number"); }
#line 11800 "obj/conf/cf-parse.tab.c"
    break;

  case 863: /* babel_iface_item: RXCOST expr  */
#line 148 "proto/babel/config.Y"
               { BABEL_IFACE->rxcost = (yyvsp[0].i); if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>65535)) cf_error("Invalid rxcost"); }
#line 11806 "obj/conf/cf-parse.tab.c"
    break;

  case 864: /* babel_iface_item: LIMIT expr  */
#line 149 "proto/babel/config.Y"
              { BABEL_IFACE->limit = (yyvsp[0].i); if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>16)) cf_error("Limit must be in range 1-16"); }
#line 11812 "obj/conf/cf-parse.tab.c"
    break;

  case 865: /* babel_iface_item: TYPE WIRED  */
#line 150 "proto/babel/config.Y"
              { BABEL_IFACE->type = BABEL_IFACE_TYPE_WIRED; }
#line 11818 "obj/conf/cf-parse.tab.c"
    break;

  case 866: /* babel_iface_item: TYPE WIRELESS  */
#line 151 "proto/babel/config.Y"
                 { BABEL_IFACE->type = BABEL_IFACE_TYPE_WIRELESS; }
#line 11824 "obj/conf/cf-parse.tab.c"
    break;

  case 867: /* babel_iface_item: TYPE TUNNEL  */
#line 152 "proto/babel/config.Y"
               { BABEL_IFACE->type = BABEL_IFACE_TYPE_TUNNEL; }
#line 11830 "obj/conf/cf-parse.tab.c"
    break;

  case 868: /* babel_iface_item: HELLO INTERVAL expr_us  */
#line 153 "proto/babel/config.Y"
                          { BABEL_IFACE->hello_interval = (yyvsp[0].time); if (((yyvsp[0].time)<BABEL_MIN_INTERVAL) || ((yyvsp[0].time)>BABEL_MAX_INTERVAL)) cf_error("Hello interval must be in range 10 ms - 655 s"); }
#line 11836 "obj/conf/cf-parse.tab.c"
    break;

  case 869: /* babel_iface_item: UPDATE INTERVAL expr_us  */
#line 154 "proto/babel/config.Y"
                           { BABEL_IFACE->update_interval = (yyvsp[0].time); if (((yyvsp[0].time)<BABEL_MIN_INTERVAL) || ((yyvsp[0].time)>BABEL_MAX_INTERVAL)) cf_error("Update interval must be in range 10 ms - 655 s"); }
#line 11842 "obj/conf/cf-parse.tab.c"
    break;

  case 870: /* babel_iface_item: RX BUFFER expr  */
#line 155 "proto/babel/config.Y"
                  { BABEL_IFACE->rx_buffer = (yyvsp[0].i); if (((yyvsp[0].i)<256) || ((yyvsp[0].i)>65535)) cf_error("RX buffer must be in range 256-65535"); }
#line 11848 "obj/conf/cf-parse.tab.c"
    break;

  case 871: /* babel_iface_item: TX LENGTH expr  */
#line 156 "proto/babel/config.Y"
                  { BABEL_IFACE->tx_length = (yyvsp[0].i); if (((yyvsp[0].i)<256) || ((yyvsp[0].i)>65535)) cf_error("TX length must be in range 256-65535"); }
#line 11854 "obj/conf/cf-parse.tab.c"
    break;

  case 872: /* babel_iface_item: TX tos  */
#line 157 "proto/babel/config.Y"
          { BABEL_IFACE->tx_tos = (yyvsp[0].i); }
#line 11860 "obj/conf/cf-parse.tab.c"
    break;

  case 873: /* babel_iface_item: TX PRIORITY expr  */
#line 158 "proto/babel/config.Y"
                    { BABEL_IFACE->tx_priority = (yyvsp[0].i); }
#line 11866 "obj/conf/cf-parse.tab.c"
    break;

  case 874: /* babel_iface_item: CHECK LINK bool  */
#line 159 "proto/babel/config.Y"
                   { BABEL_IFACE->check_link = (yyvsp[0].i); }
#line 11872 "obj/conf/cf-parse.tab.c"
    break;

  case 875: /* babel_iface_item: NEXT HOP IPV4 ipa  */
#line 160 "proto/babel/config.Y"
                     { BABEL_IFACE->next_hop_ip4 = (yyvsp[0].a); if (!ipa_is_ip4((yyvsp[0].a))) cf_error("Must be an IPv4 address"); }
#line 11878 "obj/conf/cf-parse.tab.c"
    break;

  case 876: /* babel_iface_item: NEXT HOP IPV6 ipa  */
#line 161 "proto/babel/config.Y"
                     { BABEL_IFACE->next_hop_ip6 = (yyvsp[0].a); if (!ipa_is_ip6((yyvsp[0].a))) cf_error("Must be an IPv6 address"); }
#line 11884 "obj/conf/cf-parse.tab.c"
    break;

  case 877: /* babel_iface_item: NEXT HOP PREFER NATIVE  */
#line 162 "proto/babel/config.Y"
                          { BABEL_IFACE->next_hop_prefer = BABEL_NHP_NATIVE; }
#line 11890 "obj/conf/cf-parse.tab.c"
    break;

  case 878: /* babel_iface_item: NEXT HOP PREFER IPV6  */
#line 163 "proto/babel/config.Y"
                        { BABEL_IFACE->next_hop_prefer = BABEL_NHP_IP6; }
#line 11896 "obj/conf/cf-parse.tab.c"
    break;

  case 879: /* babel_iface_item: EXTENDED NEXT HOP bool  */
#line 164 "proto/babel/config.Y"
                          { BABEL_IFACE->ext_next_hop = (yyvsp[0].i); }
#line 11902 "obj/conf/cf-parse.tab.c"
    break;

  case 880: /* babel_iface_item: AUTHENTICATION NONE  */
#line 165 "proto/babel/config.Y"
                       { BABEL_IFACE->auth_type = BABEL_AUTH_NONE; }
#line 11908 "obj/conf/cf-parse.tab.c"
    break;

  case 881: /* babel_iface_item: AUTHENTICATION MAC  */
#line 166 "proto/babel/config.Y"
                      { BABEL_IFACE->auth_type = BABEL_AUTH_MAC; BABEL_IFACE->auth_permissive = 0; }
#line 11914 "obj/conf/cf-parse.tab.c"
    break;

  case 882: /* babel_iface_item: AUTHENTICATION MAC PERMISSIVE  */
#line 167 "proto/babel/config.Y"
                                 { BABEL_IFACE->auth_type = BABEL_AUTH_MAC; BABEL_IFACE->auth_permissive = 1; }
#line 11920 "obj/conf/cf-parse.tab.c"
    break;

  case 883: /* babel_iface_item: RTT MIN expr_us  */
#line 168 "proto/babel/config.Y"
                   { BABEL_IFACE->rtt_min = (yyvsp[0].time); }
#line 11926 "obj/conf/cf-parse.tab.c"
    break;

  case 884: /* babel_iface_item: RTT MAX expr_us  */
#line 169 "proto/babel/config.Y"
                   { BABEL_IFACE->rtt_max = (yyvsp[0].time); }
#line 11932 "obj/conf/cf-parse.tab.c"
    break;

  case 885: /* babel_iface_item: RTT COST expr  */
#line 170 "proto/babel/config.Y"
                 { BABEL_IFACE->rtt_cost = (yyvsp[0].i); if ((yyvsp[0].i) >= BABEL_INFINITY) cf_error("RTT cost must be < 65535"); }
#line 11938 "obj/conf/cf-parse.tab.c"
    break;

  case 886: /* babel_iface_item: RTT DECAY expr  */
#line 171 "proto/babel/config.Y"
                  { BABEL_IFACE->rtt_decay = (yyvsp[0].i); if (((yyvsp[0].i) < 1) || ((yyvsp[0].i) > 256)) cf_error("RTT decay must be between 1-256"); }
#line 11944 "obj/conf/cf-parse.tab.c"
    break;

  case 887: /* babel_iface_item: SEND TIMESTAMPS bool  */
#line 172 "proto/babel/config.Y"
                        { BABEL_IFACE->rtt_send = (yyvsp[0].i); }
#line 11950 "obj/conf/cf-parse.tab.c"
    break;

  case 895: /* cmd_SHOW_BABEL_INTERFACES: SHOW BABEL INTERFACES optproto opttext END  */
#line 193 "proto/babel/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_babel, p) babel_show_interfaces(p, (yyvsp[-1].t)); }
#line 11956 "obj/conf/cf-parse.tab.c"
    break;

  case 897: /* cmd_SHOW_BABEL_NEIGHBORS: SHOW BABEL NEIGHBORS optproto opttext END  */
#line 196 "proto/babel/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_babel, p) babel_show_neighbors(p, (yyvsp[-1].t)); }
#line 11962 "obj/conf/cf-parse.tab.c"
    break;

  case 899: /* cmd_SHOW_BABEL_ENTRIES: SHOW BABEL ENTRIES optproto opttext END  */
#line 199 "proto/babel/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_babel, p) babel_show_entries(p); }
#line 11968 "obj/conf/cf-parse.tab.c"
    break;

  case 901: /* cmd_SHOW_BABEL_ROUTES: SHOW BABEL ROUTES optproto opttext END  */
#line 202 "proto/babel/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_babel, p)  babel_show_routes(p); }
#line 11974 "obj/conf/cf-parse.tab.c"
    break;

  case 903: /* bgp_proto_start: proto_start BGP  */
#line 58 "proto/bgp/config.Y"
                                 {
     this_proto = proto_config_new(&proto_bgp, (yyvsp[-1].i));
     this_proto->loop_order = DOMAIN_ORDER(proto);
     BGP_CFG->local_port = BGP_PORT;
     BGP_CFG->remote_port = BGP_PORT;
     BGP_CFG->multihop = -1;	/* undefined */
     BGP_CFG->hold_time = 240;
     BGP_CFG->initial_hold_time = 240;
     BGP_CFG->compare_path_lengths = 1;
     BGP_CFG->igp_metric = 1;
     BGP_CFG->connect_delay_time = 5;
     BGP_CFG->connect_retry_time = 120;
     BGP_CFG->error_amnesia_time = 300;
     BGP_CFG->error_delay_time_min = 60;
     BGP_CFG->error_delay_time_max = 300;
     BGP_CFG->enable_refresh = 1;
     BGP_CFG->enable_enhanced_refresh = 1;
     BGP_CFG->enable_as4 = 1;
     BGP_CFG->enable_hostname = 0;
     BGP_CFG->capabilities = 2;
     BGP_CFG->interpret_communities = 1;
     BGP_CFG->allow_as_sets = 1;
     BGP_CFG->default_local_pref = 100;
     BGP_CFG->gr_mode = BGP_GR_AWARE;
     BGP_CFG->gr_time = 120;
     BGP_CFG->min_gr_time = 0;
     BGP_CFG->max_gr_time = ~0U;
     BGP_CFG->llgr_mode = -1;
     BGP_CFG->llgr_time = 3600;
     BGP_CFG->min_llgr_time = 0;
     BGP_CFG->max_llgr_time = ~0U;
     BGP_CFG->setkey = 1;
     BGP_CFG->local_role = BGP_ROLE_UNDEFINED;
     BGP_CFG->dynamic_name = "dynbgp";
     BGP_CFG->check_link = -1;
     BGP_CFG->send_hold_time = -1;
     BGP_CFG->tx_size_warning = 0;
   }
#line 12017 "obj/conf/cf-parse.tab.c"
    break;

  case 905: /* bgp_loc_opts: bgp_loc_opts PORT expr  */
#line 100 "proto/bgp/config.Y"
                          { BGP_CFG->local_port = (yyvsp[0].i); if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>65535)) cf_error("Invalid port number"); }
#line 12023 "obj/conf/cf-parse.tab.c"
    break;

  case 906: /* bgp_loc_opts: bgp_loc_opts AS expr  */
#line 101 "proto/bgp/config.Y"
                        { BGP_CFG->local_as = (yyvsp[0].i); }
#line 12029 "obj/conf/cf-parse.tab.c"
    break;

  case 908: /* bgp_nbr_opts: bgp_nbr_opts PORT expr  */
#line 106 "proto/bgp/config.Y"
                          { BGP_CFG->remote_port = (yyvsp[0].i); if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>65535)) cf_error("Invalid port number"); }
#line 12035 "obj/conf/cf-parse.tab.c"
    break;

  case 909: /* bgp_nbr_opts: bgp_nbr_opts AS expr  */
#line 107 "proto/bgp/config.Y"
                        { BGP_CFG->remote_as = (yyvsp[0].i); }
#line 12041 "obj/conf/cf-parse.tab.c"
    break;

  case 910: /* bgp_nbr_opts: bgp_nbr_opts INTERNAL  */
#line 108 "proto/bgp/config.Y"
                         { BGP_CFG->peer_type = BGP_PT_INTERNAL; }
#line 12047 "obj/conf/cf-parse.tab.c"
    break;

  case 911: /* bgp_nbr_opts: bgp_nbr_opts EXTERNAL  */
#line 109 "proto/bgp/config.Y"
                         { BGP_CFG->peer_type = BGP_PT_EXTERNAL; }
#line 12053 "obj/conf/cf-parse.tab.c"
    break;

  case 912: /* bgp_cease_mask: bool  */
#line 114 "proto/bgp/config.Y"
        { (yyval.i) = (yyvsp[0].i) ? ~(1 << 7) : 0; }
#line 12059 "obj/conf/cf-parse.tab.c"
    break;

  case 913: /* bgp_cease_mask: '{' bgp_cease_list '}'  */
#line 115 "proto/bgp/config.Y"
                          { (yyval.i) = (yyvsp[-1].i); }
#line 12065 "obj/conf/cf-parse.tab.c"
    break;

  case 915: /* bgp_cease_list: bgp_cease_list ',' bgp_cease_flag  */
#line 120 "proto/bgp/config.Y"
                                     { (yyval.i) = (yyvsp[-2].i) | (yyvsp[0].i); }
#line 12071 "obj/conf/cf-parse.tab.c"
    break;

  case 916: /* bgp_cease_flag: CEASE  */
#line 124 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 0; }
#line 12077 "obj/conf/cf-parse.tab.c"
    break;

  case 917: /* bgp_cease_flag: PREFIX LIMIT HIT  */
#line 125 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 1; }
#line 12083 "obj/conf/cf-parse.tab.c"
    break;

  case 918: /* bgp_cease_flag: ADMINISTRATIVE SHUTDOWN  */
#line 126 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 2; }
#line 12089 "obj/conf/cf-parse.tab.c"
    break;

  case 919: /* bgp_cease_flag: PEER DECONFIGURED  */
#line 127 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 3; }
#line 12095 "obj/conf/cf-parse.tab.c"
    break;

  case 920: /* bgp_cease_flag: ADMINISTRATIVE RESET  */
#line 128 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 4; }
#line 12101 "obj/conf/cf-parse.tab.c"
    break;

  case 921: /* bgp_cease_flag: CONNECTION REJECTED  */
#line 129 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 5; }
#line 12107 "obj/conf/cf-parse.tab.c"
    break;

  case 922: /* bgp_cease_flag: CONFIGURATION CHANGE  */
#line 130 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 6; }
#line 12113 "obj/conf/cf-parse.tab.c"
    break;

  case 923: /* bgp_cease_flag: CONNECTION COLLISION  */
#line 131 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 7; }
#line 12119 "obj/conf/cf-parse.tab.c"
    break;

  case 924: /* bgp_cease_flag: OUT OF RESOURCES  */
#line 132 "proto/bgp/config.Y"
                                { (yyval.i) = 1 << 8; }
#line 12125 "obj/conf/cf-parse.tab.c"
    break;

  case 925: /* bgp_auth_type: NONE  */
#line 136 "proto/bgp/config.Y"
                { (yyval.i) = BGP_AUTH_NONE; }
#line 12131 "obj/conf/cf-parse.tab.c"
    break;

  case 926: /* bgp_auth_type: MD5  */
#line 137 "proto/bgp/config.Y"
                { (yyval.i) = BGP_AUTH_MD5; }
#line 12137 "obj/conf/cf-parse.tab.c"
    break;

  case 927: /* bgp_auth_type: AO  */
#line 138 "proto/bgp/config.Y"
                { (yyval.i) = BGP_AUTH_AO; }
#line 12143 "obj/conf/cf-parse.tab.c"
    break;

  case 928: /* bgp_role_name: PEER  */
#line 142 "proto/bgp/config.Y"
             { (yyval.i) = BGP_ROLE_PEER; }
#line 12149 "obj/conf/cf-parse.tab.c"
    break;

  case 929: /* bgp_role_name: PROVIDER  */
#line 143 "proto/bgp/config.Y"
             { (yyval.i) = BGP_ROLE_PROVIDER; }
#line 12155 "obj/conf/cf-parse.tab.c"
    break;

  case 930: /* bgp_role_name: CUSTOMER  */
#line 144 "proto/bgp/config.Y"
             { (yyval.i) = BGP_ROLE_CUSTOMER; }
#line 12161 "obj/conf/cf-parse.tab.c"
    break;

  case 931: /* bgp_role_name: RS_SERVER  */
#line 145 "proto/bgp/config.Y"
             { (yyval.i) = BGP_ROLE_RS_SERVER; }
#line 12167 "obj/conf/cf-parse.tab.c"
    break;

  case 932: /* bgp_role_name: RS_CLIENT  */
#line 146 "proto/bgp/config.Y"
             { (yyval.i) = BGP_ROLE_RS_CLIENT; }
#line 12173 "obj/conf/cf-parse.tab.c"
    break;

  case 938: /* bgp_proto: bgp_proto LOCAL ipa ipa_scope bgp_loc_opts ';'  */
#line 155 "proto/bgp/config.Y"
                                                  {
     BGP_CFG->local_ip = (yyvsp[-3].a);
     if ((yyvsp[-2].iface)) BGP_CFG->iface = (yyvsp[-2].iface);
   }
#line 12182 "obj/conf/cf-parse.tab.c"
    break;

  case 940: /* bgp_proto: bgp_proto NEIGHBOR ipa ipa_scope bgp_nbr_opts ';'  */
#line 160 "proto/bgp/config.Y"
                                                     {
     if (ipa_nonzero(BGP_CFG->remote_ip) || BGP_CFG->remote_range)
       cf_error("Only one neighbor per BGP instance is allowed");
     BGP_CFG->remote_ip = (yyvsp[-3].a);
     if ((yyvsp[-2].iface)) BGP_CFG->iface = (yyvsp[-2].iface);
   }
#line 12193 "obj/conf/cf-parse.tab.c"
    break;

  case 941: /* bgp_proto: bgp_proto NEIGHBOR RANGE net_ip bgp_nbr_opts ';'  */
#line 166 "proto/bgp/config.Y"
                                                    {
     if (ipa_nonzero(BGP_CFG->remote_ip) || BGP_CFG->remote_range)
       cf_error("Only one neighbor per BGP instance is allowed");
     net_addr *n = cfg_alloc((yyvsp[-2].net).length);
     net_copy(n, &((yyvsp[-2].net)));
     BGP_CFG->remote_range = n;
   }
#line 12205 "obj/conf/cf-parse.tab.c"
    break;

  case 942: /* bgp_proto: bgp_proto INTERFACE TEXT ';'  */
#line 173 "proto/bgp/config.Y"
                                { BGP_CFG->iface = if_get_by_name((yyvsp[-1].t)); }
#line 12211 "obj/conf/cf-parse.tab.c"
    break;

  case 943: /* bgp_proto: bgp_proto RR CLUSTER ID idval ';'  */
#line 174 "proto/bgp/config.Y"
                                     { BGP_CFG->rr_cluster_id = (yyvsp[-1].i32); }
#line 12217 "obj/conf/cf-parse.tab.c"
    break;

  case 944: /* bgp_proto: bgp_proto RR CLIENT bool ';'  */
#line 175 "proto/bgp/config.Y"
                                { BGP_CFG->rr_client = (yyvsp[-1].i); }
#line 12223 "obj/conf/cf-parse.tab.c"
    break;

  case 945: /* bgp_proto: bgp_proto RS CLIENT bool ';'  */
#line 176 "proto/bgp/config.Y"
                                { BGP_CFG->rs_client = (yyvsp[-1].i); }
#line 12229 "obj/conf/cf-parse.tab.c"
    break;

  case 946: /* bgp_proto: bgp_proto CONFEDERATION expr ';'  */
#line 177 "proto/bgp/config.Y"
                                    { BGP_CFG->confederation = (yyvsp[-1].i); }
#line 12235 "obj/conf/cf-parse.tab.c"
    break;

  case 947: /* bgp_proto: bgp_proto CONFEDERATION MEMBER bool ';'  */
#line 178 "proto/bgp/config.Y"
                                           { BGP_CFG->confederation_member = (yyvsp[-1].i); }
#line 12241 "obj/conf/cf-parse.tab.c"
    break;

  case 948: /* bgp_proto: bgp_proto HOLD TIME expr ';'  */
#line 179 "proto/bgp/config.Y"
                                { BGP_CFG->hold_time = (yyvsp[-1].i); if (((yyvsp[-1].i) && (yyvsp[-1].i)<3) || ((yyvsp[-1].i)>65535)) cf_error("Hold time must be in range 3-65535 or zero"); }
#line 12247 "obj/conf/cf-parse.tab.c"
    break;

  case 949: /* bgp_proto: bgp_proto MIN HOLD TIME expr ';'  */
#line 180 "proto/bgp/config.Y"
                                    { BGP_CFG->min_hold_time = (yyvsp[-1].i); }
#line 12253 "obj/conf/cf-parse.tab.c"
    break;

  case 950: /* bgp_proto: bgp_proto STARTUP HOLD TIME expr ';'  */
#line 181 "proto/bgp/config.Y"
                                        { BGP_CFG->initial_hold_time = (yyvsp[-1].i); }
#line 12259 "obj/conf/cf-parse.tab.c"
    break;

  case 951: /* bgp_proto: bgp_proto DIRECT ';'  */
#line 182 "proto/bgp/config.Y"
                        { BGP_CFG->multihop = 0; }
#line 12265 "obj/conf/cf-parse.tab.c"
    break;

  case 952: /* bgp_proto: bgp_proto MULTIHOP ';'  */
#line 183 "proto/bgp/config.Y"
                          { BGP_CFG->multihop = 64; }
#line 12271 "obj/conf/cf-parse.tab.c"
    break;

  case 953: /* bgp_proto: bgp_proto MULTIHOP expr ';'  */
#line 184 "proto/bgp/config.Y"
                               { BGP_CFG->multihop = (yyvsp[-1].i); if (((yyvsp[-1].i)<1) || ((yyvsp[-1].i)>255)) cf_error("Multihop must be in range 1-255"); }
#line 12277 "obj/conf/cf-parse.tab.c"
    break;

  case 954: /* bgp_proto: bgp_proto DYNAMIC NAME text ';'  */
#line 185 "proto/bgp/config.Y"
                                   {
     if (strchr((yyvsp[-1].t), '%')) cf_error("Forbidden character '%%' in dynamic name");
     if (strlen((yyvsp[-1].t)) > (SYM_MAX_LEN - 16)) cf_error("Dynamic name too long");
     BGP_CFG->dynamic_name = (yyvsp[-1].t);
   }
#line 12287 "obj/conf/cf-parse.tab.c"
    break;

  case 955: /* bgp_proto: bgp_proto DYNAMIC NAME DIGITS expr ';'  */
#line 190 "proto/bgp/config.Y"
                                          { BGP_CFG->dynamic_name_digits = (yyvsp[-1].i); if ((yyvsp[-1].i)>10) cf_error("Dynamic name digits must be at most 10"); }
#line 12293 "obj/conf/cf-parse.tab.c"
    break;

  case 956: /* bgp_proto: bgp_proto STRICT BIND bool ';'  */
#line 191 "proto/bgp/config.Y"
                                  { BGP_CFG->strict_bind = (yyvsp[-1].i); }
#line 12299 "obj/conf/cf-parse.tab.c"
    break;

  case 957: /* bgp_proto: bgp_proto FREE BIND bool ';'  */
#line 192 "proto/bgp/config.Y"
                                { BGP_CFG->free_bind = (yyvsp[-1].i); }
#line 12305 "obj/conf/cf-parse.tab.c"
    break;

  case 958: /* bgp_proto: bgp_proto PATH METRIC bool ';'  */
#line 193 "proto/bgp/config.Y"
                                  { BGP_CFG->compare_path_lengths = (yyvsp[-1].i); }
#line 12311 "obj/conf/cf-parse.tab.c"
    break;

  case 959: /* bgp_proto: bgp_proto MED METRIC bool ';'  */
#line 194 "proto/bgp/config.Y"
                                 { BGP_CFG->med_metric = (yyvsp[-1].i); }
#line 12317 "obj/conf/cf-parse.tab.c"
    break;

  case 960: /* bgp_proto: bgp_proto IGP METRIC bool ';'  */
#line 195 "proto/bgp/config.Y"
                                 { BGP_CFG->igp_metric = (yyvsp[-1].i); }
#line 12323 "obj/conf/cf-parse.tab.c"
    break;

  case 961: /* bgp_proto: bgp_proto PREFER OLDER bool ';'  */
#line 196 "proto/bgp/config.Y"
                                   { BGP_CFG->prefer_older = (yyvsp[-1].i); }
#line 12329 "obj/conf/cf-parse.tab.c"
    break;

  case 962: /* bgp_proto: bgp_proto DETERMINISTIC MED bool ';'  */
#line 197 "proto/bgp/config.Y"
                                        { BGP_CFG->deterministic_med = (yyvsp[-1].i); }
#line 12335 "obj/conf/cf-parse.tab.c"
    break;

  case 963: /* bgp_proto: bgp_proto DEFAULT BGP_MED expr ';'  */
#line 198 "proto/bgp/config.Y"
                                      { BGP_CFG->default_med = (yyvsp[-1].i); }
#line 12341 "obj/conf/cf-parse.tab.c"
    break;

  case 964: /* bgp_proto: bgp_proto DEFAULT BGP_LOCAL_PREF expr ';'  */
#line 199 "proto/bgp/config.Y"
                                             { BGP_CFG->default_local_pref = (yyvsp[-1].i); }
#line 12347 "obj/conf/cf-parse.tab.c"
    break;

  case 965: /* bgp_proto: bgp_proto SOURCE ADDRESS ipa ';'  */
#line 200 "proto/bgp/config.Y"
                                    { BGP_CFG->local_ip = (yyvsp[-1].a); }
#line 12353 "obj/conf/cf-parse.tab.c"
    break;

  case 966: /* bgp_proto: bgp_proto START DELAY TIME expr ';'  */
#line 201 "proto/bgp/config.Y"
                                       { BGP_CFG->connect_delay_time = (yyvsp[-1].i); cf_warn("%s: Start delay time option is deprecated, use connect delay time", this_proto->name); }
#line 12359 "obj/conf/cf-parse.tab.c"
    break;

  case 967: /* bgp_proto: bgp_proto CONNECT DELAY TIME expr ';'  */
#line 202 "proto/bgp/config.Y"
                                         { BGP_CFG->connect_delay_time = (yyvsp[-1].i); }
#line 12365 "obj/conf/cf-parse.tab.c"
    break;

  case 968: /* bgp_proto: bgp_proto CONNECT RETRY TIME expr ';'  */
#line 203 "proto/bgp/config.Y"
                                         { BGP_CFG->connect_retry_time = (yyvsp[-1].i); }
#line 12371 "obj/conf/cf-parse.tab.c"
    break;

  case 969: /* bgp_proto: bgp_proto KEEPALIVE TIME expr ';'  */
#line 204 "proto/bgp/config.Y"
                                     { BGP_CFG->keepalive_time = (yyvsp[-1].i); if (((yyvsp[-1].i)<1) || ((yyvsp[-1].i)>65535)) cf_error("Keepalive time must be in range 1-65535"); }
#line 12377 "obj/conf/cf-parse.tab.c"
    break;

  case 970: /* bgp_proto: bgp_proto MIN KEEPALIVE TIME expr ';'  */
#line 205 "proto/bgp/config.Y"
                                         { BGP_CFG->min_keepalive_time = (yyvsp[-1].i); }
#line 12383 "obj/conf/cf-parse.tab.c"
    break;

  case 971: /* bgp_proto: bgp_proto SEND HOLD TIME expr ';'  */
#line 206 "proto/bgp/config.Y"
                                    { BGP_CFG->send_hold_time = (yyvsp[-1].i); }
#line 12389 "obj/conf/cf-parse.tab.c"
    break;

  case 972: /* bgp_proto: bgp_proto ERROR FORGET TIME expr ';'  */
#line 207 "proto/bgp/config.Y"
                                        { BGP_CFG->error_amnesia_time = (yyvsp[-1].i); }
#line 12395 "obj/conf/cf-parse.tab.c"
    break;

  case 973: /* bgp_proto: bgp_proto ERROR WAIT TIME expr ',' expr ';'  */
#line 208 "proto/bgp/config.Y"
                                               { BGP_CFG->error_delay_time_min = (yyvsp[-3].i); BGP_CFG->error_delay_time_max = (yyvsp[-1].i); }
#line 12401 "obj/conf/cf-parse.tab.c"
    break;

  case 974: /* bgp_proto: bgp_proto DISABLE AFTER ERROR bool ';'  */
#line 209 "proto/bgp/config.Y"
                                          { BGP_CFG->disable_after_error = (yyvsp[-1].i); }
#line 12407 "obj/conf/cf-parse.tab.c"
    break;

  case 975: /* bgp_proto: bgp_proto DISABLE AFTER CEASE bgp_cease_mask ';'  */
#line 210 "proto/bgp/config.Y"
                                                    { BGP_CFG->disable_after_cease = (yyvsp[-1].i); }
#line 12413 "obj/conf/cf-parse.tab.c"
    break;

  case 976: /* bgp_proto: bgp_proto ENABLE ROUTE REFRESH bool ';'  */
#line 211 "proto/bgp/config.Y"
                                           { BGP_CFG->enable_refresh = (yyvsp[-1].i); }
#line 12419 "obj/conf/cf-parse.tab.c"
    break;

  case 977: /* bgp_proto: bgp_proto ENABLE ENHANCED ROUTE REFRESH bool ';'  */
#line 212 "proto/bgp/config.Y"
                                                    { BGP_CFG->enable_enhanced_refresh = (yyvsp[-1].i); }
#line 12425 "obj/conf/cf-parse.tab.c"
    break;

  case 978: /* bgp_proto: bgp_proto ENABLE AS4 bool ';'  */
#line 213 "proto/bgp/config.Y"
                                 { BGP_CFG->enable_as4 = (yyvsp[-1].i); }
#line 12431 "obj/conf/cf-parse.tab.c"
    break;

  case 979: /* bgp_proto: bgp_proto ENABLE EXTENDED MESSAGES bool ';'  */
#line 214 "proto/bgp/config.Y"
                                               { BGP_CFG->enable_extended_messages = (yyvsp[-1].i); }
#line 12437 "obj/conf/cf-parse.tab.c"
    break;

  case 980: /* bgp_proto: bgp_proto ADVERTISE HOSTNAME bool ';'  */
#line 215 "proto/bgp/config.Y"
                                         { BGP_CFG->enable_hostname = (yyvsp[-1].i); }
#line 12443 "obj/conf/cf-parse.tab.c"
    break;

  case 981: /* bgp_proto: bgp_proto REQUIRE ROUTE REFRESH bool ';'  */
#line 216 "proto/bgp/config.Y"
                                            { BGP_CFG->require_refresh = (yyvsp[-1].i); }
#line 12449 "obj/conf/cf-parse.tab.c"
    break;

  case 982: /* bgp_proto: bgp_proto REQUIRE ENHANCED ROUTE REFRESH bool ';'  */
#line 217 "proto/bgp/config.Y"
                                                     { BGP_CFG->require_enhanced_refresh = (yyvsp[-1].i); }
#line 12455 "obj/conf/cf-parse.tab.c"
    break;

  case 983: /* bgp_proto: bgp_proto REQUIRE AS4 bool ';'  */
#line 218 "proto/bgp/config.Y"
                                  { BGP_CFG->require_as4 = (yyvsp[-1].i); }
#line 12461 "obj/conf/cf-parse.tab.c"
    break;

  case 984: /* bgp_proto: bgp_proto REQUIRE EXTENDED MESSAGES bool ';'  */
#line 219 "proto/bgp/config.Y"
                                                { BGP_CFG->require_extended_messages = (yyvsp[-1].i); }
#line 12467 "obj/conf/cf-parse.tab.c"
    break;

  case 985: /* bgp_proto: bgp_proto REQUIRE HOSTNAME bool ';'  */
#line 220 "proto/bgp/config.Y"
                                       { BGP_CFG->require_hostname = (yyvsp[-1].i); }
#line 12473 "obj/conf/cf-parse.tab.c"
    break;

  case 986: /* bgp_proto: bgp_proto REQUIRE GRACEFUL RESTART bool ';'  */
#line 221 "proto/bgp/config.Y"
                                               { BGP_CFG->require_gr = (yyvsp[-1].i); }
#line 12479 "obj/conf/cf-parse.tab.c"
    break;

  case 987: /* bgp_proto: bgp_proto REQUIRE LONG LIVED GRACEFUL RESTART bool ';'  */
#line 222 "proto/bgp/config.Y"
                                                          { BGP_CFG->require_llgr = (yyvsp[-1].i); }
#line 12485 "obj/conf/cf-parse.tab.c"
    break;

  case 988: /* bgp_proto: bgp_proto CAPABILITIES bool ';'  */
#line 223 "proto/bgp/config.Y"
                                   { BGP_CFG->capabilities = (yyvsp[-1].i); }
#line 12491 "obj/conf/cf-parse.tab.c"
    break;

  case 989: /* bgp_proto: bgp_proto AUTHENTICATION bgp_auth_type ';'  */
#line 224 "proto/bgp/config.Y"
                                              { BGP_CFG->auth_type = (yyvsp[-1].i); }
#line 12497 "obj/conf/cf-parse.tab.c"
    break;

  case 991: /* bgp_proto: bgp_proto PASSWORD text ';'  */
#line 226 "proto/bgp/config.Y"
                               { BGP_CFG->password = (yyvsp[-1].t); }
#line 12503 "obj/conf/cf-parse.tab.c"
    break;

  case 992: /* bgp_proto: bgp_proto SETKEY bool ';'  */
#line 227 "proto/bgp/config.Y"
                             { BGP_CFG->setkey = (yyvsp[-1].i); }
#line 12509 "obj/conf/cf-parse.tab.c"
    break;

  case 993: /* bgp_proto: bgp_proto PASSIVE bool ';'  */
#line 228 "proto/bgp/config.Y"
                              { BGP_CFG->passive = (yyvsp[-1].i); }
#line 12515 "obj/conf/cf-parse.tab.c"
    break;

  case 994: /* bgp_proto: bgp_proto INTERPRET COMMUNITIES bool ';'  */
#line 229 "proto/bgp/config.Y"
                                            { BGP_CFG->interpret_communities = (yyvsp[-1].i); }
#line 12521 "obj/conf/cf-parse.tab.c"
    break;

  case 995: /* bgp_proto: bgp_proto ALLOW LOCAL AS ';'  */
#line 230 "proto/bgp/config.Y"
                                { BGP_CFG->allow_local_as = -1; }
#line 12527 "obj/conf/cf-parse.tab.c"
    break;

  case 996: /* bgp_proto: bgp_proto ALLOW LOCAL AS expr ';'  */
#line 231 "proto/bgp/config.Y"
                                     { BGP_CFG->allow_local_as = (yyvsp[-1].i); }
#line 12533 "obj/conf/cf-parse.tab.c"
    break;

  case 997: /* bgp_proto: bgp_proto ALLOW BGP_LOCAL_PREF bool ';'  */
#line 232 "proto/bgp/config.Y"
                                           { BGP_CFG->allow_local_pref = (yyvsp[-1].i); }
#line 12539 "obj/conf/cf-parse.tab.c"
    break;

  case 998: /* bgp_proto: bgp_proto ALLOW BGP_MED bool ';'  */
#line 233 "proto/bgp/config.Y"
                                    { BGP_CFG->allow_med = (yyvsp[-1].i); }
#line 12545 "obj/conf/cf-parse.tab.c"
    break;

  case 999: /* bgp_proto: bgp_proto ALLOW AS SETS bool ';'  */
#line 234 "proto/bgp/config.Y"
                                    { BGP_CFG->allow_as_sets = (yyvsp[-1].i); }
#line 12551 "obj/conf/cf-parse.tab.c"
    break;

  case 1000: /* bgp_proto: bgp_proto GRACEFUL RESTART bool ';'  */
#line 235 "proto/bgp/config.Y"
                                       { BGP_CFG->gr_mode = (yyvsp[-1].i); }
#line 12557 "obj/conf/cf-parse.tab.c"
    break;

  case 1001: /* bgp_proto: bgp_proto GRACEFUL RESTART AWARE ';'  */
#line 236 "proto/bgp/config.Y"
                                        { BGP_CFG->gr_mode = BGP_GR_AWARE; }
#line 12563 "obj/conf/cf-parse.tab.c"
    break;

  case 1002: /* bgp_proto: bgp_proto GRACEFUL RESTART TIME expr ';'  */
#line 237 "proto/bgp/config.Y"
                                            { BGP_CFG->gr_time = (yyvsp[-1].i); if ((yyvsp[-1].i) >= (1 << 12)) cf_error("Graceful restart time must be less than 4096"); }
#line 12569 "obj/conf/cf-parse.tab.c"
    break;

  case 1003: /* bgp_proto: bgp_proto MIN GRACEFUL RESTART TIME expr ';'  */
#line 238 "proto/bgp/config.Y"
                                                { BGP_CFG->min_gr_time = (yyvsp[-1].i); if ((yyvsp[-1].i) >= (1 << 12)) cf_error("Min graceful restart time must be less than 4096"); }
#line 12575 "obj/conf/cf-parse.tab.c"
    break;

  case 1004: /* bgp_proto: bgp_proto MAX GRACEFUL RESTART TIME expr ';'  */
#line 239 "proto/bgp/config.Y"
                                                { BGP_CFG->max_gr_time = (yyvsp[-1].i); if ((yyvsp[-1].i) >= (1 << 12)) cf_error("Max graceful restart time must be less than 4096"); }
#line 12581 "obj/conf/cf-parse.tab.c"
    break;

  case 1005: /* bgp_proto: bgp_proto LONG LIVED GRACEFUL RESTART bool ';'  */
#line 240 "proto/bgp/config.Y"
                                                  { BGP_CFG->llgr_mode = (yyvsp[-1].i); }
#line 12587 "obj/conf/cf-parse.tab.c"
    break;

  case 1006: /* bgp_proto: bgp_proto LONG LIVED GRACEFUL RESTART AWARE ';'  */
#line 241 "proto/bgp/config.Y"
                                                   { BGP_CFG->llgr_mode = BGP_LLGR_AWARE; }
#line 12593 "obj/conf/cf-parse.tab.c"
    break;

  case 1007: /* bgp_proto: bgp_proto LONG LIVED STALE TIME expr ';'  */
#line 242 "proto/bgp/config.Y"
                                            { BGP_CFG->llgr_time = (yyvsp[-1].i); if ((yyvsp[-1].i) >= (1 << 24)) cf_error("Long-lived stale time must be less than 2^24"); }
#line 12599 "obj/conf/cf-parse.tab.c"
    break;

  case 1008: /* bgp_proto: bgp_proto MIN LONG LIVED STALE TIME expr ';'  */
#line 243 "proto/bgp/config.Y"
                                                { BGP_CFG->min_llgr_time = (yyvsp[-1].i); if ((yyvsp[-1].i) >= (1 << 24)) cf_error("Min long-lived stale time must be less than 2^24"); }
#line 12605 "obj/conf/cf-parse.tab.c"
    break;

  case 1009: /* bgp_proto: bgp_proto MAX LONG LIVED STALE TIME expr ';'  */
#line 244 "proto/bgp/config.Y"
                                                { BGP_CFG->max_llgr_time = (yyvsp[-1].i); if ((yyvsp[-1].i) >= (1 << 24)) cf_error("Max long-lived stale time must be less than 2^24"); }
#line 12611 "obj/conf/cf-parse.tab.c"
    break;

  case 1010: /* bgp_proto: bgp_proto TTL SECURITY bool ';'  */
#line 245 "proto/bgp/config.Y"
                                   { BGP_CFG->ttl_security = (yyvsp[-1].i); }
#line 12617 "obj/conf/cf-parse.tab.c"
    break;

  case 1011: /* bgp_proto: bgp_proto CHECK LINK bool ';'  */
#line 246 "proto/bgp/config.Y"
                                 { BGP_CFG->check_link = (yyvsp[-1].i); }
#line 12623 "obj/conf/cf-parse.tab.c"
    break;

  case 1012: /* bgp_proto: bgp_proto BFD bool ';'  */
#line 247 "proto/bgp/config.Y"
                          { if ((yyvsp[-1].i)) init_bfd_opts(&BGP_CFG->bfd); else BGP_CFG->bfd = NULL; }
#line 12629 "obj/conf/cf-parse.tab.c"
    break;

  case 1013: /* bgp_proto: bgp_proto BFD GRACEFUL ';'  */
#line 248 "proto/bgp/config.Y"
                              { init_bfd_opts(&BGP_CFG->bfd); BGP_CFG->bfd->mode = BGP_BFD_GRACEFUL; }
#line 12635 "obj/conf/cf-parse.tab.c"
    break;

  case 1014: /* $@18: %empty  */
#line 249 "proto/bgp/config.Y"
                 { open_bfd_opts(&BGP_CFG->bfd); }
#line 12641 "obj/conf/cf-parse.tab.c"
    break;

  case 1015: /* $@19: %empty  */
#line 249 "proto/bgp/config.Y"
                                                            { close_bfd_opts(); }
#line 12647 "obj/conf/cf-parse.tab.c"
    break;

  case 1017: /* bgp_proto: bgp_proto ENFORCE FIRST AS bool ';'  */
#line 250 "proto/bgp/config.Y"
                                       { BGP_CFG->enforce_first_as = (yyvsp[-1].i); }
#line 12653 "obj/conf/cf-parse.tab.c"
    break;

  case 1018: /* bgp_proto: bgp_proto LOCAL ROLE bgp_role_name ';'  */
#line 251 "proto/bgp/config.Y"
                                          { BGP_CFG->local_role = (yyvsp[-1].i); }
#line 12659 "obj/conf/cf-parse.tab.c"
    break;

  case 1019: /* bgp_proto: bgp_proto REQUIRE ROLES bool ';'  */
#line 252 "proto/bgp/config.Y"
                                    { BGP_CFG->require_roles = (yyvsp[-1].i); }
#line 12665 "obj/conf/cf-parse.tab.c"
    break;

  case 1020: /* bgp_proto: bgp_proto DISABLE RX bool ';'  */
#line 253 "proto/bgp/config.Y"
                                 { BGP_CFG->disable_rx = (yyvsp[-1].i); }
#line 12671 "obj/conf/cf-parse.tab.c"
    break;

  case 1021: /* bgp_proto: bgp_proto TX SIZE WARNING expr ';'  */
#line 254 "proto/bgp/config.Y"
                                      { BGP_CFG->tx_size_warning = (yyvsp[-1].i); }
#line 12677 "obj/conf/cf-parse.tab.c"
    break;

  case 1022: /* bgp_afi: IPV4  */
#line 258 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_IPV4; }
#line 12683 "obj/conf/cf-parse.tab.c"
    break;

  case 1023: /* bgp_afi: IPV6  */
#line 259 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_IPV6; }
#line 12689 "obj/conf/cf-parse.tab.c"
    break;

  case 1024: /* bgp_afi: IPV4 MULTICAST  */
#line 260 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_IPV4_MC; }
#line 12695 "obj/conf/cf-parse.tab.c"
    break;

  case 1025: /* bgp_afi: IPV6 MULTICAST  */
#line 261 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_IPV6_MC; }
#line 12701 "obj/conf/cf-parse.tab.c"
    break;

  case 1026: /* bgp_afi: IPV4 MPLS  */
#line 262 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_IPV4_MPLS; }
#line 12707 "obj/conf/cf-parse.tab.c"
    break;

  case 1027: /* bgp_afi: IPV6 MPLS  */
#line 263 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_IPV6_MPLS; }
#line 12713 "obj/conf/cf-parse.tab.c"
    break;

  case 1028: /* bgp_afi: VPN4 MPLS  */
#line 264 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_VPN4_MPLS; }
#line 12719 "obj/conf/cf-parse.tab.c"
    break;

  case 1029: /* bgp_afi: VPN6 MPLS  */
#line 265 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_VPN6_MPLS; }
#line 12725 "obj/conf/cf-parse.tab.c"
    break;

  case 1030: /* bgp_afi: VPN4 MULTICAST  */
#line 266 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_VPN4_MC; }
#line 12731 "obj/conf/cf-parse.tab.c"
    break;

  case 1031: /* bgp_afi: VPN6 MULTICAST  */
#line 267 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_VPN6_MC; }
#line 12737 "obj/conf/cf-parse.tab.c"
    break;

  case 1032: /* bgp_afi: FLOW4  */
#line 268 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_FLOW4; }
#line 12743 "obj/conf/cf-parse.tab.c"
    break;

  case 1033: /* bgp_afi: FLOW6  */
#line 269 "proto/bgp/config.Y"
                        { (yyval.i32) = BGP_AF_FLOW6; }
#line 12749 "obj/conf/cf-parse.tab.c"
    break;

  case 1034: /* tcp_ao_key_start: KEY  */
#line 272 "proto/bgp/config.Y"
                      {
  this_ao_key = cfg_allocz(sizeof(struct ao_config));
  *next_ao_key = this_ao_key;
  next_ao_key = &(this_ao_key->next);

  this_ao_key->key.send_id = -1;
  this_ao_key->key.recv_id = -1;
  this_ao_key->key.algorithm = ALG_HMAC_SHA1;
}
#line 12763 "obj/conf/cf-parse.tab.c"
    break;

  case 1035: /* tcp_ao_key_opt: ID expr ';'  */
#line 283 "proto/bgp/config.Y"
               {
     if ((yyvsp[-1].i) > 255)
       cf_error("Key ID must be in range 0-255");
     this_ao_key->key.send_id = (yyvsp[-1].i);
     this_ao_key->key.recv_id = (yyvsp[-1].i);
   }
#line 12774 "obj/conf/cf-parse.tab.c"
    break;

  case 1036: /* tcp_ao_key_opt: SEND ID expr ';'  */
#line 289 "proto/bgp/config.Y"
                    {
     if ((yyvsp[-1].i) > 255)
       cf_error("Send ID must be in range 0-255");
     this_ao_key->key.send_id = (yyvsp[-1].i);
   }
#line 12784 "obj/conf/cf-parse.tab.c"
    break;

  case 1037: /* tcp_ao_key_opt: RECV ID expr ';'  */
#line 294 "proto/bgp/config.Y"
                    {
     if ((yyvsp[-1].i) > 255)
       cf_error("Recv ID must be in range 0-255");
     this_ao_key->key.recv_id = (yyvsp[-1].i);
   }
#line 12794 "obj/conf/cf-parse.tab.c"
    break;

  case 1038: /* tcp_ao_key_opt: ALGORITHM tcp_ao_algorithm ';'  */
#line 299 "proto/bgp/config.Y"
                                  {
     if (!tcp_ao_alg_known((yyvsp[-1].i)))
       cf_error("Unknown algorithm for TCP-AO");
     this_ao_key->key.algorithm = (yyvsp[-1].i);
   }
#line 12804 "obj/conf/cf-parse.tab.c"
    break;

  case 1039: /* tcp_ao_key_opt: SECRET bytestring_text ';'  */
#line 304 "proto/bgp/config.Y"
                              {
     if ((yyvsp[-1].v).type == T_BYTESTRING)
     {
       this_ao_key->key.key = (yyvsp[-1].v).val.bs->data;
       this_ao_key->key.keylen = (yyvsp[-1].v).val.bs->length;
     }
     else if ((yyvsp[-1].v).type == T_STRING)
     {
       this_ao_key->key.key = (yyvsp[-1].v).val.s;
       this_ao_key->key.keylen = strlen((yyvsp[-1].v).val.s);
     }
     else bug("Bad bytestring_text");

     if (this_ao_key->key.keylen > AO_MAX_KEY_LENGTH)
       cf_error("TCP-AO secret too long");
   }
#line 12825 "obj/conf/cf-parse.tab.c"
    break;

  case 1040: /* tcp_ao_key_opt: DEPRECATED ';'  */
#line 320 "proto/bgp/config.Y"
                  {
     if (this_ao_key->key.preference > 0)
       cf_error("Key cannot be both preferred and deprecated");
     this_ao_key->key.preference = -1;
   }
#line 12835 "obj/conf/cf-parse.tab.c"
    break;

  case 1041: /* tcp_ao_key_opt: PREFERRED ';'  */
#line 325 "proto/bgp/config.Y"
                 {
     if (this_ao_key->key.preference < 0)
       cf_error("Key cannot be both preferred and deprecated");
     this_ao_key->key.preference = 1;
   }
#line 12845 "obj/conf/cf-parse.tab.c"
    break;

  case 1042: /* tcp_ao_algorithm: password_algorithm  */
#line 333 "proto/bgp/config.Y"
                      { (yyval.i) = (yyvsp[0].i); }
#line 12851 "obj/conf/cf-parse.tab.c"
    break;

  case 1043: /* tcp_ao_algorithm: CMAC AES128  */
#line 334 "proto/bgp/config.Y"
               { (yyval.i) = ALG_CMAC_AES128_AO; }
#line 12857 "obj/conf/cf-parse.tab.c"
    break;

  case 1046: /* tcp_ao_key_end: %empty  */
#line 342 "proto/bgp/config.Y"
                {
  struct ao_config *key = this_ao_key;
  this_ao_key = NULL;

  if (key->key.send_id == -1)
    cf_error("No key Send ID");
  if (key->key.recv_id == -1)
    cf_error("No key Recv ID");
  if (!key->key.key || !key->key.keylen)
    cf_error("No secret defined for key %i/%i", key->key.send_id, key->key.recv_id);
}
#line 12873 "obj/conf/cf-parse.tab.c"
    break;

  case 1049: /* tcp_ao_keys: tcp_ao_keys tcp_ao_key ';'  */
#line 358 "proto/bgp/config.Y"
                              { }
#line 12879 "obj/conf/cf-parse.tab.c"
    break;

  case 1050: /* $@20: %empty  */
#line 362 "proto/bgp/config.Y"
       { next_ao_key = &(BGP_CFG->ao_keys); }
#line 12885 "obj/conf/cf-parse.tab.c"
    break;

  case 1051: /* tcp_ao_key_list: '{' $@20 tcp_ao_keys '}'  */
#line 362 "proto/bgp/config.Y"
                                                              { next_ao_key = NULL; }
#line 12891 "obj/conf/cf-parse.tab.c"
    break;

  case 1052: /* tcp_ao_end: %empty  */
#line 366 "proto/bgp/config.Y"
{
  char used_aos_id_send[256];
  char used_aos_id_recv[256];
  memset(used_aos_id_send, 0, sizeof(char)*256);
  memset(used_aos_id_recv, 0, sizeof(char)*256);

  for (struct ao_config *key = BGP_CFG->ao_keys; key; key = key->next)
  {
    if (used_aos_id_send[key->key.send_id])
      cf_error("Multiple keys with Send ID %i", key->key.send_id);
    used_aos_id_send[key->key.send_id] = 1;

    if (used_aos_id_recv[key->key.recv_id])
      cf_error("Multiple keys with Recv ID %i", key->key.recv_id);
    used_aos_id_recv[key->key.recv_id] = 1;
  }
}
#line 12913 "obj/conf/cf-parse.tab.c"
    break;

  case 1053: /* bgp_channel_start: bgp_afi  */
#line 385 "proto/bgp/config.Y"
{
  const struct bgp_af_desc *desc = bgp_get_af_desc((yyvsp[0].i32));

  if (!desc)
    cf_error("Unknown AFI/SAFI");

  this_channel = channel_config_get(&channel_bgp, desc->name, desc->net, this_proto);

  /* New channel */
  if (!BGP_CC->desc)
  {
    BGP_CC->c.in_filter = FILTER_UNDEF;
    BGP_CC->c.out_filter = FILTER_UNDEF;
    BGP_CC->c.ra_mode = RA_UNDEF;
    BGP_CC->afi = (yyvsp[0].i32);
    BGP_CC->desc = desc;
    BGP_CC->next_hop_keep = 0xff; /* undefined */
    BGP_CC->gr_able = 0xff;	/* undefined */
    BGP_CC->llgr_able = 0xff;	/* undefined */
    BGP_CC->llgr_time = ~0U;	/* undefined */
    BGP_CC->min_llgr_time = ~0U; /* undefined */
    BGP_CC->max_llgr_time = ~0U; /* undefined */
    BGP_CC->aigp = 0xff;	/* undefined */
    BGP_CC->ptx_exporter_settle = (struct settle_config) { 10 MS_, 100 MS_ };
  }
}
#line 12944 "obj/conf/cf-parse.tab.c"
    break;

  case 1054: /* bgp_nh: bool  */
#line 413 "proto/bgp/config.Y"
        { (yyval.i) = (yyvsp[0].i); }
#line 12950 "obj/conf/cf-parse.tab.c"
    break;

  case 1055: /* bgp_nh: IBGP  */
#line 414 "proto/bgp/config.Y"
        { (yyval.i) = NH_IBGP; }
#line 12956 "obj/conf/cf-parse.tab.c"
    break;

  case 1056: /* bgp_nh: EBGP  */
#line 415 "proto/bgp/config.Y"
        { (yyval.i) = NH_EBGP; }
#line 12962 "obj/conf/cf-parse.tab.c"
    break;

  case 1057: /* bgp_llnh: NATIVE  */
#line 419 "proto/bgp/config.Y"
          { (yyval.i) = LLNH_NATIVE; }
#line 12968 "obj/conf/cf-parse.tab.c"
    break;

  case 1058: /* bgp_llnh: SINGLE  */
#line 420 "proto/bgp/config.Y"
          { (yyval.i) = LLNH_SINGLE; }
#line 12974 "obj/conf/cf-parse.tab.c"
    break;

  case 1059: /* bgp_llnh: DOUBLE  */
#line 421 "proto/bgp/config.Y"
          { (yyval.i) = LLNH_DOUBLE; }
#line 12980 "obj/conf/cf-parse.tab.c"
    break;

  case 1064: /* bgp_channel_item: NEXT HOP ADDRESS ipa  */
#line 428 "proto/bgp/config.Y"
                        { BGP_CC->next_hop_addr = (yyvsp[0].a); }
#line 12986 "obj/conf/cf-parse.tab.c"
    break;

  case 1065: /* bgp_channel_item: NEXT HOP SELF bgp_nh  */
#line 429 "proto/bgp/config.Y"
                        { BGP_CC->next_hop_self = (yyvsp[0].i); }
#line 12992 "obj/conf/cf-parse.tab.c"
    break;

  case 1066: /* bgp_channel_item: NEXT HOP KEEP bgp_nh  */
#line 430 "proto/bgp/config.Y"
                        { BGP_CC->next_hop_keep = (yyvsp[0].i); }
#line 12998 "obj/conf/cf-parse.tab.c"
    break;

  case 1067: /* bgp_channel_item: NEXT HOP PREFER GLOBAL  */
#line 431 "proto/bgp/config.Y"
                          { BGP_CC->next_hop_prefer = NHP_GLOBAL; }
#line 13004 "obj/conf/cf-parse.tab.c"
    break;

  case 1068: /* bgp_channel_item: LINK LOCAL NEXT HOP FORMAT bgp_llnh  */
#line 432 "proto/bgp/config.Y"
                                       { BGP_CC->llnh_format = (yyvsp[0].i); }
#line 13010 "obj/conf/cf-parse.tab.c"
    break;

  case 1069: /* bgp_channel_item: MANDATORY bool  */
#line 433 "proto/bgp/config.Y"
                  { BGP_CC->mandatory = (yyvsp[0].i); }
#line 13016 "obj/conf/cf-parse.tab.c"
    break;

  case 1070: /* bgp_channel_item: MISSING LLADDR bgp_lladdr  */
#line 434 "proto/bgp/config.Y"
                             { cf_warn("%s.%s: Missing lladdr option is deprecated and ignored, remove it", this_proto->name, this_channel->name); }
#line 13022 "obj/conf/cf-parse.tab.c"
    break;

  case 1071: /* bgp_channel_item: GATEWAY DIRECT  */
#line 435 "proto/bgp/config.Y"
                  { BGP_CC->gw_mode = GW_DIRECT; }
#line 13028 "obj/conf/cf-parse.tab.c"
    break;

  case 1072: /* bgp_channel_item: GATEWAY RECURSIVE  */
#line 436 "proto/bgp/config.Y"
                     { BGP_CC->gw_mode = GW_RECURSIVE; }
#line 13034 "obj/conf/cf-parse.tab.c"
    break;

  case 1073: /* bgp_channel_item: SECONDARY bool  */
#line 437 "proto/bgp/config.Y"
                  { BGP_CC->secondary = (yyvsp[0].i); }
#line 13040 "obj/conf/cf-parse.tab.c"
    break;

  case 1074: /* bgp_channel_item: VALIDATE bool  */
#line 438 "proto/bgp/config.Y"
                 {
    BGP_CC->validate = (yyvsp[0].i);
    if (BGP_SAFI(BGP_CC->afi) != BGP_SAFI_FLOW)
      cf_error("Validate option limited to flowspec channels");
   }
#line 13050 "obj/conf/cf-parse.tab.c"
    break;

  case 1075: /* bgp_channel_item: GRACEFUL RESTART bool  */
#line 443 "proto/bgp/config.Y"
                         { BGP_CC->gr_able = (yyvsp[0].i); }
#line 13056 "obj/conf/cf-parse.tab.c"
    break;

  case 1076: /* bgp_channel_item: LONG LIVED GRACEFUL RESTART bool  */
#line 444 "proto/bgp/config.Y"
                                    { BGP_CC->llgr_able = (yyvsp[0].i); }
#line 13062 "obj/conf/cf-parse.tab.c"
    break;

  case 1077: /* bgp_channel_item: LONG LIVED STALE TIME expr  */
#line 445 "proto/bgp/config.Y"
                              { BGP_CC->llgr_time = (yyvsp[0].i); if ((yyvsp[0].i) >= (1 << 24)) cf_error("Long-lived stale time must be less than 2^24"); }
#line 13068 "obj/conf/cf-parse.tab.c"
    break;

  case 1078: /* bgp_channel_item: MIN LONG LIVED STALE TIME expr  */
#line 446 "proto/bgp/config.Y"
                                  { BGP_CC->min_llgr_time = (yyvsp[0].i); if ((yyvsp[0].i) >= (1 << 24)) cf_error("Min long-lived stale time must be less than 2^24"); }
#line 13074 "obj/conf/cf-parse.tab.c"
    break;

  case 1079: /* bgp_channel_item: MAX LONG LIVED STALE TIME expr  */
#line 447 "proto/bgp/config.Y"
                                  { BGP_CC->max_llgr_time = (yyvsp[0].i); if ((yyvsp[0].i) >= (1 << 24)) cf_error("Max long-lived stale time must be less than 2^24"); }
#line 13080 "obj/conf/cf-parse.tab.c"
    break;

  case 1080: /* bgp_channel_item: EXTENDED NEXT HOP bool  */
#line 448 "proto/bgp/config.Y"
                          { BGP_CC->ext_next_hop = (yyvsp[0].i); }
#line 13086 "obj/conf/cf-parse.tab.c"
    break;

  case 1081: /* bgp_channel_item: REQUIRE EXTENDED NEXT HOP bool  */
#line 449 "proto/bgp/config.Y"
                                  { BGP_CC->require_ext_next_hop = (yyvsp[0].i);  if (BGP_AFI(BGP_CC->afi) != BGP_AFI_IPV4) cf_warn("Require extended next hop option ignored for non-IPv4 channels"); }
#line 13092 "obj/conf/cf-parse.tab.c"
    break;

  case 1082: /* bgp_channel_item: ADD PATHS RX  */
#line 450 "proto/bgp/config.Y"
                { BGP_CC->add_path = BGP_ADD_PATH_RX; }
#line 13098 "obj/conf/cf-parse.tab.c"
    break;

  case 1083: /* bgp_channel_item: ADD PATHS TX  */
#line 451 "proto/bgp/config.Y"
                { BGP_CC->add_path = BGP_ADD_PATH_TX; }
#line 13104 "obj/conf/cf-parse.tab.c"
    break;

  case 1084: /* bgp_channel_item: ADD PATHS bool  */
#line 452 "proto/bgp/config.Y"
                  { BGP_CC->add_path = (yyvsp[0].i) ? BGP_ADD_PATH_FULL : 0; }
#line 13110 "obj/conf/cf-parse.tab.c"
    break;

  case 1085: /* bgp_channel_item: REQUIRE ADD PATHS bool  */
#line 453 "proto/bgp/config.Y"
                          { BGP_CC->require_add_path = (yyvsp[0].i); }
#line 13116 "obj/conf/cf-parse.tab.c"
    break;

  case 1086: /* bgp_channel_item: IMPORT TABLE bool  */
#line 454 "proto/bgp/config.Y"
                     { BGP_CC->import_table = (yyvsp[0].i); }
#line 13122 "obj/conf/cf-parse.tab.c"
    break;

  case 1087: /* bgp_channel_item: EXPORT TABLE bool  */
#line 455 "proto/bgp/config.Y"
                     { BGP_CC->export_table = (yyvsp[0].i); }
#line 13128 "obj/conf/cf-parse.tab.c"
    break;

  case 1088: /* bgp_channel_item: EXPORT SETTLE TIME settle  */
#line 456 "proto/bgp/config.Y"
                             { BGP_CC->ptx_exporter_settle = (yyvsp[0].settle); }
#line 13134 "obj/conf/cf-parse.tab.c"
    break;

  case 1089: /* bgp_channel_item: AIGP bool  */
#line 457 "proto/bgp/config.Y"
             { BGP_CC->aigp = (yyvsp[0].i); BGP_CC->aigp_originate = 0; }
#line 13140 "obj/conf/cf-parse.tab.c"
    break;

  case 1090: /* bgp_channel_item: AIGP ORIGINATE  */
#line 458 "proto/bgp/config.Y"
                  { BGP_CC->aigp = 1; BGP_CC->aigp_originate = 1; }
#line 13146 "obj/conf/cf-parse.tab.c"
    break;

  case 1091: /* bgp_channel_item: COST expr  */
#line 459 "proto/bgp/config.Y"
             { BGP_CC->cost = (yyvsp[0].i); if ((yyvsp[0].i) < 1) cf_error("Cost must be positive"); }
#line 13152 "obj/conf/cf-parse.tab.c"
    break;

  case 1092: /* bgp_channel_item: IGP TABLE rtable  */
#line 460 "proto/bgp/config.Y"
                    {
    if (BGP_CC->desc->no_igp)
      cf_error("IGP table not allowed here");

    if ((yyvsp[0].r)->addr_type == NET_IP4)
      BGP_CC->igp_table_ip4 = (yyvsp[0].r);
    else if ((yyvsp[0].r)->addr_type == NET_IP6)
      BGP_CC->igp_table_ip6 = (yyvsp[0].r);
    else
      cf_error("Mismatched IGP table type");
   }
#line 13168 "obj/conf/cf-parse.tab.c"
    break;

  case 1093: /* bgp_channel_item: BASE TABLE rtable  */
#line 471 "proto/bgp/config.Y"
                     {
    if (BGP_SAFI(BGP_CC->afi) != BGP_SAFI_FLOW)
      cf_error("Base table option limited to flowspec channels");

    if (((BGP_CC->afi == BGP_AF_FLOW4) && ((yyvsp[0].r)->addr_type == NET_IP4)) ||
        ((BGP_CC->afi == BGP_AF_FLOW6) && ((yyvsp[0].r)->addr_type == NET_IP6)))
      BGP_CC->base_table = (yyvsp[0].r);
    else
      cf_error("Mismatched base table type");
   }
#line 13183 "obj/conf/cf-parse.tab.c"
    break;

  case 1098: /* bgp_channel_end: %empty  */
#line 494 "proto/bgp/config.Y"
{
  if (!this_channel->table)
    cf_error("Routing table not specified");

  if (BGP_CC->import_table)
    this_channel->in_keep |= RIK_PREFILTER;

  this_channel = NULL;
}
#line 13197 "obj/conf/cf-parse.tab.c"
    break;

  case 1100: /* custom_attr: ATTRIBUTE BGP NUM type symbol ';'  */
#line 506 "proto/bgp/config.Y"
                                               {
  if ((yyvsp[-3].i) > 255 || (yyvsp[-3].i) < 1)
    cf_error("Invalid attribute number. (Given %i, must be 1-255.)", (yyvsp[-3].i));

  struct ea_class *ac = bgp_find_ea_class_by_id((yyvsp[-3].i));
  ASSERT_DIE(ac);
  if ((yyvsp[-2].i) != ac->type)
    cf_error("Attribute %d type must be %s, not %s.", (yyvsp[-3].i), f_type_name(ac->type), f_type_name((yyvsp[-2].i)));

  ea_ref_class(new_config->pool, ac);
  cf_define_symbol(new_config, (yyvsp[-1].s), SYM_ATTRIBUTE, attribute, ac);
}
#line 13214 "obj/conf/cf-parse.tab.c"
    break;

  case 1102: /* cmd_RELOAD_BGP: RELOAD BGP proto_patt END  */
#line 520 "proto/bgp/config.Y"
{
  proto_apply_cmd((yyvsp[-1].ps), bgp_reload_in, 1, 0);
  proto_apply_cmd((yyvsp[-1].ps), bgp_reload_out, 1, 0);
}
#line 13223 "obj/conf/cf-parse.tab.c"
    break;

  case 1104: /* cmd_RELOAD_BGP_IN: RELOAD BGP IN proto_patt END  */
#line 526 "proto/bgp/config.Y"
{
  proto_apply_cmd((yyvsp[-1].ps), bgp_reload_in, 1, 0);
}
#line 13231 "obj/conf/cf-parse.tab.c"
    break;

  case 1106: /* cmd_RELOAD_BGP_OUT: RELOAD BGP OUT proto_patt END  */
#line 531 "proto/bgp/config.Y"
{
  proto_apply_cmd((yyvsp[-1].ps), bgp_reload_out, 1, 0);
}
#line 13239 "obj/conf/cf-parse.tab.c"
    break;

  case 1107: /* term: ASPA_CHECK_DOWNSTREAM '(' rtable ')'  */
#line 536 "proto/bgp/config.Y"
                                           { (yyval.x) =
  f_new_inst(FI_ASPA_CHECK_EXPLICIT,
      f_new_inst(FI_EA_GET,
	f_new_inst(FI_CURRENT_ROUTE),
	ea_class_find_by_name("bgp_path")
      ),
      f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_BOOL, .val.i = 0, }),
      (yyvsp[-1].r)
  );
}
#line 13254 "obj/conf/cf-parse.tab.c"
    break;

  case 1108: /* term: ASPA_CHECK_UPSTREAM '(' rtable ')'  */
#line 547 "proto/bgp/config.Y"
                                         { (yyval.x) =
  f_new_inst(FI_ASPA_CHECK_EXPLICIT,
      f_new_inst(FI_EA_GET,
	f_new_inst(FI_CURRENT_ROUTE),
	ea_class_find_by_name("bgp_path")
      ),
      f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_BOOL, .val.i = 1, }),
      (yyvsp[-1].r)
  );
}
#line 13269 "obj/conf/cf-parse.tab.c"
    break;

  case 1110: /* l3vpn_channel_start: net_type_base  */
#line 53 "proto/l3vpn/config.Y"
{
  /* Redefining proto_channel to change default values */
  (yyval.cc) = this_channel = channel_config_get(NULL, net_label[(yyvsp[0].i)], (yyvsp[0].i), this_proto);
  if (!this_channel->copy)
  {
    this_channel->out_filter = FILTER_ACCEPT;
    this_channel->preference = net_val_match((yyvsp[0].i), NB_IP) ?
      DEF_PREF_L3VPN_IMPORT :
      DEF_PREF_L3VPN_EXPORT;
  }
}
#line 13285 "obj/conf/cf-parse.tab.c"
    break;

  case 1112: /* l3vpn_proto_start: proto_start L3VPN  */
#line 68 "proto/l3vpn/config.Y"
{
  this_proto = proto_config_new(&proto_l3vpn, (yyvsp[-1].i));
}
#line 13293 "obj/conf/cf-parse.tab.c"
    break;

  case 1116: /* l3vpn_proto_item: RD VPN_RD  */
#line 77 "proto/l3vpn/config.Y"
             { L3VPN_CFG->rd = (yyvsp[0].rd); }
#line 13299 "obj/conf/cf-parse.tab.c"
    break;

  case 1117: /* l3vpn_proto_item: ROUTE DISTINGUISHER VPN_RD  */
#line 78 "proto/l3vpn/config.Y"
                              { L3VPN_CFG->rd = (yyvsp[0].rd); }
#line 13305 "obj/conf/cf-parse.tab.c"
    break;

  case 1118: /* l3vpn_proto_item: IMPORT TARGET l3vpn_targets  */
#line 79 "proto/l3vpn/config.Y"
                               { L3VPN_CFG->import_target = (yyvsp[0].e); }
#line 13311 "obj/conf/cf-parse.tab.c"
    break;

  case 1119: /* l3vpn_proto_item: EXPORT TARGET l3vpn_targets  */
#line 80 "proto/l3vpn/config.Y"
                               { L3VPN_CFG->export_target = (yyvsp[0].e); }
#line 13317 "obj/conf/cf-parse.tab.c"
    break;

  case 1120: /* l3vpn_proto_item: ROUTE TARGET l3vpn_targets  */
#line 81 "proto/l3vpn/config.Y"
                              { L3VPN_CFG->import_target = L3VPN_CFG->export_target = (yyvsp[0].e); }
#line 13323 "obj/conf/cf-parse.tab.c"
    break;

  case 1124: /* l3vpn_targets: ec_item  */
#line 94 "proto/l3vpn/config.Y"
           { f_tree_only_rt((yyvsp[0].e)); (yyval.e) = (yyvsp[0].e); }
#line 13329 "obj/conf/cf-parse.tab.c"
    break;

  case 1125: /* l3vpn_targets: '[' ec_items ']'  */
#line 95 "proto/l3vpn/config.Y"
                    { f_tree_only_rt((yyvsp[-1].e)); (yyval.e) = build_tree((yyvsp[-1].e)); }
#line 13335 "obj/conf/cf-parse.tab.c"
    break;

  case 1126: /* proto: ospf_proto '}'  */
#line 211 "proto/ospf/config.Y"
                      { ospf_proto_finish(); }
#line 13341 "obj/conf/cf-parse.tab.c"
    break;

  case 1127: /* ospf_variant: OSPF  */
#line 214 "proto/ospf/config.Y"
           { (yyval.i) = 1; }
#line 13347 "obj/conf/cf-parse.tab.c"
    break;

  case 1128: /* ospf_variant: OSPF V2  */
#line 215 "proto/ospf/config.Y"
           { (yyval.i) = 1; }
#line 13353 "obj/conf/cf-parse.tab.c"
    break;

  case 1129: /* ospf_variant: OSPF V3  */
#line 216 "proto/ospf/config.Y"
           { (yyval.i) = 0; }
#line 13359 "obj/conf/cf-parse.tab.c"
    break;

  case 1130: /* ospf_proto_start: proto_start ospf_variant  */
#line 220 "proto/ospf/config.Y"
{
  this_proto = proto_config_new(&proto_ospf, (yyvsp[-1].i));
  this_proto->net_type = (yyvsp[0].i) ? NET_IP4 : 0;

  init_list(&OSPF_CFG->area_list);
  init_list(&OSPF_CFG->vlink_list);
  OSPF_CFG->ecmp = rt_default_ecmp;
  OSPF_CFG->tick = OSPF_DEFAULT_TICK;
  OSPF_CFG->ospf2 = (yyvsp[0].i);
  OSPF_CFG->af_ext = !(yyvsp[0].i);
  OSPF_CFG->gr_mode = OSPF_GR_AWARE;
  OSPF_CFG->gr_time = OSPF_DEFAULT_GR_TIME;
}
#line 13377 "obj/conf/cf-parse.tab.c"
    break;

  case 1133: /* ospf_af_mc: %empty  */
#line 240 "proto/ospf/config.Y"
             { (yyval.i) = 0; }
#line 13383 "obj/conf/cf-parse.tab.c"
    break;

  case 1134: /* ospf_af_mc: MULTICAST  */
#line 241 "proto/ospf/config.Y"
             { (yyval.i) = 1; }
#line 13389 "obj/conf/cf-parse.tab.c"
    break;

  case 1135: /* ospf_channel_start: net_type ospf_af_mc  */
#line 246 "proto/ospf/config.Y"
{
  /* TODO: change name for multicast channels */
  (yyval.cc) = this_channel = channel_config_get(NULL, net_label[(yyvsp[-1].i)], (yyvsp[-1].i), this_proto);

  /* Save the multicast flag */
  OSPF_CFG->af_mc = (yyvsp[0].i);
}
#line 13401 "obj/conf/cf-parse.tab.c"
    break;

  case 1138: /* ospf_proto_item: ospf_channel  */
#line 258 "proto/ospf/config.Y"
                { this_proto->net_type = (yyvsp[0].cc)->net_type; }
#line 13407 "obj/conf/cf-parse.tab.c"
    break;

  case 1139: /* ospf_proto_item: RFC1583COMPAT bool  */
#line 259 "proto/ospf/config.Y"
                      { OSPF_CFG->rfc1583 = (yyvsp[0].i); }
#line 13413 "obj/conf/cf-parse.tab.c"
    break;

  case 1140: /* ospf_proto_item: RFC5838 bool  */
#line 260 "proto/ospf/config.Y"
                { OSPF_CFG->af_ext = (yyvsp[0].i); if (!ospf_cfg_is_v3()) cf_error("RFC5838 option requires OSPFv3"); }
#line 13419 "obj/conf/cf-parse.tab.c"
    break;

  case 1141: /* ospf_proto_item: VPN PE bool  */
#line 261 "proto/ospf/config.Y"
               { OSPF_CFG->vpn_pe = (yyvsp[0].i); }
#line 13425 "obj/conf/cf-parse.tab.c"
    break;

  case 1142: /* ospf_proto_item: STUB ROUTER bool  */
#line 262 "proto/ospf/config.Y"
                    { OSPF_CFG->stub_router = (yyvsp[0].i); }
#line 13431 "obj/conf/cf-parse.tab.c"
    break;

  case 1143: /* ospf_proto_item: GRACEFUL RESTART bool  */
#line 263 "proto/ospf/config.Y"
                         { OSPF_CFG->gr_mode = (yyvsp[0].i); }
#line 13437 "obj/conf/cf-parse.tab.c"
    break;

  case 1144: /* ospf_proto_item: GRACEFUL RESTART AWARE  */
#line 264 "proto/ospf/config.Y"
                          { OSPF_CFG->gr_mode = OSPF_GR_AWARE; }
#line 13443 "obj/conf/cf-parse.tab.c"
    break;

  case 1145: /* ospf_proto_item: GRACEFUL RESTART TIME expr  */
#line 265 "proto/ospf/config.Y"
                              { OSPF_CFG->gr_time = (yyvsp[0].i); if (((yyvsp[0].i) < 1) || ((yyvsp[0].i) > 1800)) cf_error("Graceful restart time must be in range 1-1800"); }
#line 13449 "obj/conf/cf-parse.tab.c"
    break;

  case 1146: /* ospf_proto_item: ECMP bool  */
#line 266 "proto/ospf/config.Y"
             { OSPF_CFG->ecmp = (yyvsp[0].i) ? OSPF_DEFAULT_ECMP_LIMIT : 0; }
#line 13455 "obj/conf/cf-parse.tab.c"
    break;

  case 1147: /* ospf_proto_item: ECMP bool LIMIT expr  */
#line 267 "proto/ospf/config.Y"
                        { OSPF_CFG->ecmp = (yyvsp[-2].i) ? (yyvsp[0].i) : 0; }
#line 13461 "obj/conf/cf-parse.tab.c"
    break;

  case 1148: /* ospf_proto_item: MERGE EXTERNAL bool  */
#line 268 "proto/ospf/config.Y"
                       { OSPF_CFG->merge_external = (yyvsp[0].i); }
#line 13467 "obj/conf/cf-parse.tab.c"
    break;

  case 1149: /* ospf_proto_item: TICK expr  */
#line 269 "proto/ospf/config.Y"
             { OSPF_CFG->tick = (yyvsp[0].i); if((yyvsp[0].i) <= 0) cf_error("Tick must be greater than zero"); }
#line 13473 "obj/conf/cf-parse.tab.c"
    break;

  case 1150: /* ospf_proto_item: INSTANCE ID expr  */
#line 270 "proto/ospf/config.Y"
                    { OSPF_CFG->instance_id = (yyvsp[0].i); OSPF_CFG->instance_id_set = 1; if ((yyvsp[0].i) > 255) cf_error("Instance ID must be in range 0-255"); }
#line 13479 "obj/conf/cf-parse.tab.c"
    break;

  case 1152: /* ospf_area_start: AREA idval  */
#line 274 "proto/ospf/config.Y"
                            {
  this_area = cfg_allocz(sizeof(struct ospf_area_config));
  add_tail(&OSPF_CFG->area_list, NODE this_area);
  this_area->areaid = (yyvsp[0].i32);
  this_area->default_cost = OSPF_DEFAULT_STUB_COST;
  this_area->type = OPT_E;
  this_area->transint = OSPF_DEFAULT_TRANSINT;

  init_list(&this_area->patt_list);
  init_list(&this_area->net_list);
  init_list(&this_area->enet_list);
  init_list(&this_area->stubnet_list);
 }
#line 13497 "obj/conf/cf-parse.tab.c"
    break;

  case 1153: /* ospf_area: ospf_area_start '{' ospf_area_opts '}'  */
#line 289 "proto/ospf/config.Y"
                                                  { ospf_area_finish(); }
#line 13503 "obj/conf/cf-parse.tab.c"
    break;

  case 1156: /* ospf_area_item: STUB bool  */
#line 298 "proto/ospf/config.Y"
             { this_area->type = (yyvsp[0].i) ? 0 : OPT_E; /* We should remove the option */ }
#line 13509 "obj/conf/cf-parse.tab.c"
    break;

  case 1157: /* ospf_area_item: NSSA  */
#line 299 "proto/ospf/config.Y"
        { this_area->type = OPT_N; }
#line 13515 "obj/conf/cf-parse.tab.c"
    break;

  case 1158: /* ospf_area_item: SUMMARY bool  */
#line 300 "proto/ospf/config.Y"
                { this_area->summary = (yyvsp[0].i); }
#line 13521 "obj/conf/cf-parse.tab.c"
    break;

  case 1159: /* ospf_area_item: DEFAULT NSSA bool  */
#line 301 "proto/ospf/config.Y"
                     { this_area->default_nssa = (yyvsp[0].i); }
#line 13527 "obj/conf/cf-parse.tab.c"
    break;

  case 1160: /* ospf_area_item: DEFAULT COST expr  */
#line 302 "proto/ospf/config.Y"
                     { this_area->default_cost = (yyvsp[0].i); ospf_check_defcost((yyvsp[0].i)); }
#line 13533 "obj/conf/cf-parse.tab.c"
    break;

  case 1161: /* ospf_area_item: DEFAULT COST2 expr  */
#line 303 "proto/ospf/config.Y"
                      { this_area->default_cost = (yyvsp[0].i) | LSA_EXT3_EBIT; ospf_check_defcost((yyvsp[0].i)); }
#line 13539 "obj/conf/cf-parse.tab.c"
    break;

  case 1162: /* ospf_area_item: STUB COST expr  */
#line 304 "proto/ospf/config.Y"
                  { this_area->default_cost = (yyvsp[0].i); ospf_check_defcost((yyvsp[0].i)); }
#line 13545 "obj/conf/cf-parse.tab.c"
    break;

  case 1163: /* ospf_area_item: TRANSLATOR bool  */
#line 305 "proto/ospf/config.Y"
                   { this_area->translator = (yyvsp[0].i); }
#line 13551 "obj/conf/cf-parse.tab.c"
    break;

  case 1164: /* ospf_area_item: TRANSLATOR STABILITY expr  */
#line 306 "proto/ospf/config.Y"
                             { this_area->transint = (yyvsp[0].i); }
#line 13557 "obj/conf/cf-parse.tab.c"
    break;

  case 1165: /* $@21: %empty  */
#line 307 "proto/ospf/config.Y"
            { this_nets = &this_area->net_list; }
#line 13563 "obj/conf/cf-parse.tab.c"
    break;

  case 1167: /* $@22: %empty  */
#line 308 "proto/ospf/config.Y"
            { this_nets = &this_area->enet_list; }
#line 13569 "obj/conf/cf-parse.tab.c"
    break;

  case 1174: /* ospf_stubnet_start: net_ip  */
#line 320 "proto/ospf/config.Y"
          {
     this_stubnet = cfg_allocz(sizeof(struct ospf_stubnet_config));
     add_tail(&this_area->stubnet_list, NODE this_stubnet);
     this_stubnet->prefix = (yyvsp[0].net);
     this_stubnet->cost = COST_D;
   }
#line 13580 "obj/conf/cf-parse.tab.c"
    break;

  case 1177: /* ospf_stubnet_item: HIDDEN bool  */
#line 334 "proto/ospf/config.Y"
               { this_stubnet->hidden = (yyvsp[0].i); }
#line 13586 "obj/conf/cf-parse.tab.c"
    break;

  case 1178: /* ospf_stubnet_item: SUMMARY bool  */
#line 335 "proto/ospf/config.Y"
                { this_stubnet->summary = (yyvsp[0].i); }
#line 13592 "obj/conf/cf-parse.tab.c"
    break;

  case 1179: /* ospf_stubnet_item: COST expr  */
#line 336 "proto/ospf/config.Y"
             { this_stubnet->cost = (yyvsp[0].i); }
#line 13598 "obj/conf/cf-parse.tab.c"
    break;

  case 1180: /* ospf_vlink: ospf_vlink_start ospf_instance_id '{' ospf_vlink_opts '}'  */
#line 340 "proto/ospf/config.Y"
                                                             { ospf_iface_finish(); }
#line 13604 "obj/conf/cf-parse.tab.c"
    break;

  case 1181: /* ospf_vlink: ospf_vlink_start ospf_instance_id  */
#line 341 "proto/ospf/config.Y"
                                     { ospf_iface_finish(); }
#line 13610 "obj/conf/cf-parse.tab.c"
    break;

  case 1185: /* ospf_vlink_item: HELLO expr  */
#line 350 "proto/ospf/config.Y"
              { OSPF_PATT->helloint = (yyvsp[0].i) ; if (((yyvsp[0].i)<=0) || ((yyvsp[0].i)>65535)) cf_error("Hello interval must be in range 1-65535"); }
#line 13616 "obj/conf/cf-parse.tab.c"
    break;

  case 1186: /* ospf_vlink_item: RETRANSMIT expr  */
#line 351 "proto/ospf/config.Y"
                   { OSPF_PATT->rxmtint = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Retransmit int must be greater than one"); }
#line 13622 "obj/conf/cf-parse.tab.c"
    break;

  case 1187: /* ospf_vlink_item: TRANSMIT DELAY expr  */
#line 352 "proto/ospf/config.Y"
                       { OSPF_PATT->inftransdelay = (yyvsp[0].i) ; if (((yyvsp[0].i)<=0) || ((yyvsp[0].i)>65535)) cf_error("Transmit delay must be in range 1-65535"); }
#line 13628 "obj/conf/cf-parse.tab.c"
    break;

  case 1188: /* ospf_vlink_item: WAIT expr  */
#line 353 "proto/ospf/config.Y"
             { OSPF_PATT->waitint = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Wait interval must be greater than one"); }
#line 13634 "obj/conf/cf-parse.tab.c"
    break;

  case 1189: /* ospf_vlink_item: DEAD expr  */
#line 354 "proto/ospf/config.Y"
             { OSPF_PATT->deadint = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Dead interval must be greater than one"); }
#line 13640 "obj/conf/cf-parse.tab.c"
    break;

  case 1190: /* ospf_vlink_item: DEAD COUNT expr  */
#line 355 "proto/ospf/config.Y"
                   { OSPF_PATT->deadc = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Dead count must be greater than one"); }
#line 13646 "obj/conf/cf-parse.tab.c"
    break;

  case 1191: /* ospf_vlink_item: AUTHENTICATION NONE  */
#line 356 "proto/ospf/config.Y"
                       { OSPF_PATT->autype = OSPF_AUTH_NONE;  }
#line 13652 "obj/conf/cf-parse.tab.c"
    break;

  case 1192: /* ospf_vlink_item: AUTHENTICATION SIMPLE  */
#line 357 "proto/ospf/config.Y"
                         { OSPF_PATT->autype = OSPF_AUTH_SIMPLE; ospf_check_auth(); }
#line 13658 "obj/conf/cf-parse.tab.c"
    break;

  case 1193: /* ospf_vlink_item: AUTHENTICATION CRYPTOGRAPHIC  */
#line 358 "proto/ospf/config.Y"
                                { OSPF_PATT->autype = OSPF_AUTH_CRYPT; }
#line 13664 "obj/conf/cf-parse.tab.c"
    break;

  case 1195: /* ospf_vlink_start: VIRTUAL LINK idval  */
#line 363 "proto/ospf/config.Y"
 {
  if (this_area->areaid == 0) cf_error("Virtual link cannot be in backbone");
  this_ipatt = cfg_allocz(sizeof(struct ospf_iface_patt));
  add_tail(&OSPF_CFG->vlink_list, NODE this_ipatt);
  init_list(&this_ipatt->ipn_list);
  OSPF_PATT->voa = this_area->areaid;
  OSPF_PATT->vid = (yyvsp[0].i32);
  OSPF_PATT->helloint = HELLOINT_D;
  OSPF_PATT->rxmtint = RXMTINT_D;
  OSPF_PATT->inftransdelay = INFTRANSDELAY_D;
  OSPF_PATT->deadc = DEADC_D;
  OSPF_PATT->type = OSPF_IT_VLINK;
  init_list(&OSPF_PATT->nbma_list);
  reset_passwords();
 }
#line 13684 "obj/conf/cf-parse.tab.c"
    break;

  case 1196: /* ospf_iface_item: COST expr  */
#line 381 "proto/ospf/config.Y"
             { OSPF_PATT->cost = (yyvsp[0].i) ; if (((yyvsp[0].i)<=0) || ((yyvsp[0].i)>65535)) cf_error("Cost must be in range 1-65535"); }
#line 13690 "obj/conf/cf-parse.tab.c"
    break;

  case 1197: /* ospf_iface_item: HELLO expr  */
#line 382 "proto/ospf/config.Y"
              { OSPF_PATT->helloint = (yyvsp[0].i) ; if (((yyvsp[0].i)<=0) || ((yyvsp[0].i)>65535)) cf_error("Hello interval must be in range 1-65535"); }
#line 13696 "obj/conf/cf-parse.tab.c"
    break;

  case 1198: /* ospf_iface_item: POLL expr  */
#line 383 "proto/ospf/config.Y"
             { OSPF_PATT->pollint = (yyvsp[0].i) ; if ((yyvsp[0].i)<=0) cf_error("Poll int must be greater than zero"); }
#line 13702 "obj/conf/cf-parse.tab.c"
    break;

  case 1199: /* ospf_iface_item: RETRANSMIT expr  */
#line 384 "proto/ospf/config.Y"
                   { OSPF_PATT->rxmtint = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Retransmit int must be greater than one"); }
#line 13708 "obj/conf/cf-parse.tab.c"
    break;

  case 1200: /* ospf_iface_item: WAIT expr  */
#line 385 "proto/ospf/config.Y"
             { OSPF_PATT->waitint = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Wait interval must be greater than one"); }
#line 13714 "obj/conf/cf-parse.tab.c"
    break;

  case 1201: /* ospf_iface_item: DEAD expr  */
#line 386 "proto/ospf/config.Y"
             { OSPF_PATT->deadint = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Dead interval must be greater than one"); }
#line 13720 "obj/conf/cf-parse.tab.c"
    break;

  case 1202: /* ospf_iface_item: DEAD COUNT expr  */
#line 387 "proto/ospf/config.Y"
                   { OSPF_PATT->deadc = (yyvsp[0].i) ; if ((yyvsp[0].i)<=1) cf_error("Dead count must be greater than one"); }
#line 13726 "obj/conf/cf-parse.tab.c"
    break;

  case 1203: /* ospf_iface_item: TYPE BROADCAST  */
#line 388 "proto/ospf/config.Y"
                  { OSPF_PATT->type = OSPF_IT_BCAST ; }
#line 13732 "obj/conf/cf-parse.tab.c"
    break;

  case 1204: /* ospf_iface_item: TYPE BCAST  */
#line 389 "proto/ospf/config.Y"
              { OSPF_PATT->type = OSPF_IT_BCAST ; }
#line 13738 "obj/conf/cf-parse.tab.c"
    break;

  case 1205: /* ospf_iface_item: TYPE NONBROADCAST  */
#line 390 "proto/ospf/config.Y"
                     { OSPF_PATT->type = OSPF_IT_NBMA ; }
#line 13744 "obj/conf/cf-parse.tab.c"
    break;

  case 1206: /* ospf_iface_item: TYPE NBMA  */
#line 391 "proto/ospf/config.Y"
             { OSPF_PATT->type = OSPF_IT_NBMA ; }
#line 13750 "obj/conf/cf-parse.tab.c"
    break;

  case 1207: /* ospf_iface_item: TYPE POINTOPOINT  */
#line 392 "proto/ospf/config.Y"
                    { OSPF_PATT->type = OSPF_IT_PTP ; }
#line 13756 "obj/conf/cf-parse.tab.c"
    break;

  case 1208: /* ospf_iface_item: TYPE PTP  */
#line 393 "proto/ospf/config.Y"
            { OSPF_PATT->type = OSPF_IT_PTP ; }
#line 13762 "obj/conf/cf-parse.tab.c"
    break;

  case 1209: /* ospf_iface_item: TYPE POINTOMULTIPOINT  */
#line 394 "proto/ospf/config.Y"
                         { OSPF_PATT->type = OSPF_IT_PTMP ; }
#line 13768 "obj/conf/cf-parse.tab.c"
    break;

  case 1210: /* ospf_iface_item: TYPE PTMP  */
#line 395 "proto/ospf/config.Y"
             { OSPF_PATT->type = OSPF_IT_PTMP ; }
#line 13774 "obj/conf/cf-parse.tab.c"
    break;

  case 1211: /* ospf_iface_item: REAL BROADCAST bool  */
#line 396 "proto/ospf/config.Y"
                       { OSPF_PATT->real_bcast = (yyvsp[0].i); if (!ospf_cfg_is_v2()) cf_error("Real broadcast option requires OSPFv2"); }
#line 13780 "obj/conf/cf-parse.tab.c"
    break;

  case 1212: /* ospf_iface_item: PTP NETMASK bool  */
#line 397 "proto/ospf/config.Y"
                    { OSPF_PATT->ptp_netmask = (yyvsp[0].i); if (!ospf_cfg_is_v2()) cf_error("PtP netmask option requires OSPFv2"); }
#line 13786 "obj/conf/cf-parse.tab.c"
    break;

  case 1213: /* ospf_iface_item: PTP ADDRESS bool  */
#line 398 "proto/ospf/config.Y"
                    { OSPF_PATT->ptp_address = (yyvsp[0].i); if (!ospf_cfg_is_v2()) cf_error("PtP address option requires OSPFv2"); }
#line 13792 "obj/conf/cf-parse.tab.c"
    break;

  case 1214: /* ospf_iface_item: TRANSMIT DELAY expr  */
#line 399 "proto/ospf/config.Y"
                       { OSPF_PATT->inftransdelay = (yyvsp[0].i) ; if (((yyvsp[0].i)<=0) || ((yyvsp[0].i)>65535)) cf_error("Transmit delay must be in range 1-65535"); }
#line 13798 "obj/conf/cf-parse.tab.c"
    break;

  case 1215: /* ospf_iface_item: PRIORITY expr  */
#line 400 "proto/ospf/config.Y"
                 { OSPF_PATT->priority = (yyvsp[0].i) ; if ((yyvsp[0].i)>255) cf_error("Priority must be in range 0-255"); }
#line 13804 "obj/conf/cf-parse.tab.c"
    break;

  case 1216: /* ospf_iface_item: STRICT NONBROADCAST bool  */
#line 401 "proto/ospf/config.Y"
                            { OSPF_PATT->strictnbma = (yyvsp[0].i) ; }
#line 13810 "obj/conf/cf-parse.tab.c"
    break;

  case 1217: /* ospf_iface_item: STUB bool  */
#line 402 "proto/ospf/config.Y"
             { OSPF_PATT->stub = (yyvsp[0].i) ; }
#line 13816 "obj/conf/cf-parse.tab.c"
    break;

  case 1218: /* ospf_iface_item: CHECK LINK bool  */
#line 403 "proto/ospf/config.Y"
                   { OSPF_PATT->check_link = (yyvsp[0].i); }
#line 13822 "obj/conf/cf-parse.tab.c"
    break;

  case 1219: /* ospf_iface_item: ECMP WEIGHT expr  */
#line 404 "proto/ospf/config.Y"
                    { OSPF_PATT->ecmp_weight = (yyvsp[0].i) - 1; if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>256)) cf_error("ECMP weight must be in range 1-256"); }
#line 13828 "obj/conf/cf-parse.tab.c"
    break;

  case 1220: /* ospf_iface_item: LINK LSA SUPPRESSION bool  */
#line 405 "proto/ospf/config.Y"
                             { OSPF_PATT->link_lsa_suppression = (yyvsp[0].i); if (!ospf_cfg_is_v3()) cf_error("Link LSA suppression option requires OSPFv3"); }
#line 13834 "obj/conf/cf-parse.tab.c"
    break;

  case 1222: /* ospf_iface_item: AUTHENTICATION NONE  */
#line 407 "proto/ospf/config.Y"
                       { OSPF_PATT->autype = OSPF_AUTH_NONE; }
#line 13840 "obj/conf/cf-parse.tab.c"
    break;

  case 1223: /* ospf_iface_item: AUTHENTICATION SIMPLE  */
#line 408 "proto/ospf/config.Y"
                         { OSPF_PATT->autype = OSPF_AUTH_SIMPLE; ospf_check_auth(); }
#line 13846 "obj/conf/cf-parse.tab.c"
    break;

  case 1224: /* ospf_iface_item: AUTHENTICATION CRYPTOGRAPHIC  */
#line 409 "proto/ospf/config.Y"
                                { OSPF_PATT->autype = OSPF_AUTH_CRYPT; }
#line 13852 "obj/conf/cf-parse.tab.c"
    break;

  case 1225: /* ospf_iface_item: RX BUFFER NORMAL  */
#line 410 "proto/ospf/config.Y"
                    { OSPF_PATT->rx_buffer = 0; }
#line 13858 "obj/conf/cf-parse.tab.c"
    break;

  case 1226: /* ospf_iface_item: RX BUFFER LARGE  */
#line 411 "proto/ospf/config.Y"
                   { OSPF_PATT->rx_buffer = OSPF_MAX_PKT_SIZE; }
#line 13864 "obj/conf/cf-parse.tab.c"
    break;

  case 1227: /* ospf_iface_item: RX BUFFER expr  */
#line 412 "proto/ospf/config.Y"
                  { OSPF_PATT->rx_buffer = (yyvsp[0].i); if (((yyvsp[0].i) < OSPF_MIN_PKT_SIZE) || ((yyvsp[0].i) > OSPF_MAX_PKT_SIZE)) cf_error("Buffer size must be in range 256-65535"); }
#line 13870 "obj/conf/cf-parse.tab.c"
    break;

  case 1228: /* ospf_iface_item: TX tos  */
#line 413 "proto/ospf/config.Y"
          { OSPF_PATT->tx_tos = (yyvsp[0].i); }
#line 13876 "obj/conf/cf-parse.tab.c"
    break;

  case 1229: /* ospf_iface_item: TX PRIORITY expr  */
#line 414 "proto/ospf/config.Y"
                    { OSPF_PATT->tx_priority = (yyvsp[0].i); }
#line 13882 "obj/conf/cf-parse.tab.c"
    break;

  case 1230: /* ospf_iface_item: TX LENGTH expr  */
#line 415 "proto/ospf/config.Y"
                  { OSPF_PATT->tx_length = (yyvsp[0].i); if (((yyvsp[0].i) < OSPF_MIN_PKT_SIZE) || ((yyvsp[0].i) > OSPF_MAX_PKT_SIZE)) cf_error("TX length must be in range 256-65535"); }
#line 13888 "obj/conf/cf-parse.tab.c"
    break;

  case 1231: /* ospf_iface_item: TTL SECURITY bool  */
#line 416 "proto/ospf/config.Y"
                     { OSPF_PATT->ttl_security = (yyvsp[0].i); }
#line 13894 "obj/conf/cf-parse.tab.c"
    break;

  case 1232: /* ospf_iface_item: TTL SECURITY TX ONLY  */
#line 417 "proto/ospf/config.Y"
                        { OSPF_PATT->ttl_security = 2; }
#line 13900 "obj/conf/cf-parse.tab.c"
    break;

  case 1233: /* ospf_iface_item: BFD bool  */
#line 418 "proto/ospf/config.Y"
            { OSPF_PATT->bfd = (yyvsp[0].i); cf_check_bfd((yyvsp[0].i)); }
#line 13906 "obj/conf/cf-parse.tab.c"
    break;

  case 1238: /* pref_base: net_ip  */
#line 430 "proto/ospf/config.Y"
 {
   this_pref = cfg_allocz(sizeof(struct area_net_config));
   add_tail(this_nets, NODE this_pref);
   this_pref->prefix = (yyvsp[0].net);
 }
#line 13916 "obj/conf/cf-parse.tab.c"
    break;

  case 1240: /* pref_opt: HIDDEN  */
#line 439 "proto/ospf/config.Y"
          { this_pref->hidden = 1; }
#line 13922 "obj/conf/cf-parse.tab.c"
    break;

  case 1241: /* pref_opt: TAG expr  */
#line 440 "proto/ospf/config.Y"
            { this_pref->tag = (yyvsp[0].i); }
#line 13928 "obj/conf/cf-parse.tab.c"
    break;

  case 1244: /* nbma_eligible: %empty  */
#line 449 "proto/ospf/config.Y"
             { (yyval.i) = 0; }
#line 13934 "obj/conf/cf-parse.tab.c"
    break;

  case 1245: /* nbma_eligible: ELIGIBLE  */
#line 450 "proto/ospf/config.Y"
            { (yyval.i) = 1; }
#line 13940 "obj/conf/cf-parse.tab.c"
    break;

  case 1246: /* nbma_item: ipa nbma_eligible ';'  */
#line 454 "proto/ospf/config.Y"
 {
   this_nbma = cfg_allocz(sizeof(struct nbma_node));
   add_tail(&OSPF_PATT->nbma_list, NODE this_nbma);
   this_nbma->ip=(yyvsp[-2].a);
   this_nbma->eligible=(yyvsp[-1].i);
 }
#line 13951 "obj/conf/cf-parse.tab.c"
    break;

  case 1247: /* ospf_iface_start: %empty  */
#line 463 "proto/ospf/config.Y"
 {
  this_ipatt = cfg_allocz(sizeof(struct ospf_iface_patt));
  add_tail(&this_area->patt_list, NODE this_ipatt);
  init_list(&this_ipatt->ipn_list);
  OSPF_PATT->cost = COST_D;
  OSPF_PATT->helloint = HELLOINT_D;
  OSPF_PATT->pollint = POLLINT_D;
  OSPF_PATT->rxmtint = RXMTINT_D;
  OSPF_PATT->inftransdelay = INFTRANSDELAY_D;
  OSPF_PATT->priority = PRIORITY_D;
  OSPF_PATT->deadc = DEADC_D;
  OSPF_PATT->type = OSPF_IT_UNDEF;
  init_list(&OSPF_PATT->nbma_list);
  OSPF_PATT->check_link = 1;
  OSPF_PATT->ptp_netmask = 2; /* not specified */
  OSPF_PATT->ptp_address = 2; /* not specified */
  OSPF_PATT->tx_tos = IP_PREC_INTERNET_CONTROL;
  OSPF_PATT->tx_priority = sk_priority_control;
  reset_passwords();
 }
#line 13976 "obj/conf/cf-parse.tab.c"
    break;

  case 1249: /* ospf_instance_id: INSTANCE expr  */
#line 487 "proto/ospf/config.Y"
                 { OSPF_PATT->instance_id = (yyvsp[0].i); OSPF_PATT->instance_id_set = 1; if ((yyvsp[0].i) > 255) cf_error("Instance ID must be in range 0-255"); }
#line 13982 "obj/conf/cf-parse.tab.c"
    break;

  case 1250: /* $@23: %empty  */
#line 491 "proto/ospf/config.Y"
                   { if (ospf_cfg_is_v3()) iface_patt_check(); }
#line 13988 "obj/conf/cf-parse.tab.c"
    break;

  case 1256: /* ospf_iface: ospf_iface_start ospf_iface_patt_list ospf_iface_opt_list  */
#line 505 "proto/ospf/config.Y"
                                                            { ospf_iface_finish(); }
#line 13994 "obj/conf/cf-parse.tab.c"
    break;

  case 1258: /* cmd_SHOW_OSPF: SHOW OSPF optproto END  */
#line 510 "proto/ospf/config.Y"
{ PROTO_WALK_CMD((yyvsp[-1].s), &proto_ospf, p) ospf_sh(p); }
#line 14000 "obj/conf/cf-parse.tab.c"
    break;

  case 1260: /* cmd_SHOW_OSPF_NEIGHBORS: SHOW OSPF NEIGHBORS optproto opttext END  */
#line 513 "proto/ospf/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_ospf, p) ospf_sh_neigh(p, (yyvsp[-1].t)); }
#line 14006 "obj/conf/cf-parse.tab.c"
    break;

  case 1262: /* cmd_SHOW_OSPF_INTERFACE: SHOW OSPF INTERFACE optproto opttext END  */
#line 516 "proto/ospf/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_ospf, p) ospf_sh_iface(p, (yyvsp[-1].t)); }
#line 14012 "obj/conf/cf-parse.tab.c"
    break;

  case 1264: /* cmd_SHOW_OSPF_TOPOLOGY: SHOW OSPF TOPOLOGY optproto opttext END  */
#line 521 "proto/ospf/config.Y"
{ ospf_sh_state(proto_get_named((yyvsp[-2].s), &proto_ospf), 0, 1); }
#line 14018 "obj/conf/cf-parse.tab.c"
    break;

  case 1266: /* cmd_SHOW_OSPF_TOPOLOGY_ALL: SHOW OSPF TOPOLOGY ALL optproto opttext END  */
#line 524 "proto/ospf/config.Y"
{ ospf_sh_state(proto_get_named((yyvsp[-2].s), &proto_ospf), 0, 0); }
#line 14024 "obj/conf/cf-parse.tab.c"
    break;

  case 1268: /* cmd_SHOW_OSPF_STATE: SHOW OSPF STATE optproto opttext END  */
#line 529 "proto/ospf/config.Y"
{ ospf_sh_state(proto_get_named((yyvsp[-2].s), &proto_ospf), 1, 1); }
#line 14030 "obj/conf/cf-parse.tab.c"
    break;

  case 1270: /* cmd_SHOW_OSPF_STATE_ALL: SHOW OSPF STATE ALL optproto opttext END  */
#line 532 "proto/ospf/config.Y"
{ ospf_sh_state(proto_get_named((yyvsp[-2].s), &proto_ospf), 1, 0); }
#line 14036 "obj/conf/cf-parse.tab.c"
    break;

  case 1272: /* cmd_SHOW_OSPF_LSADB: SHOW OSPF LSADB lsadb_args END  */
#line 536 "proto/ospf/config.Y"
{
  if (!(yyvsp[-1].ld)->proto)
    (yyvsp[-1].ld)->proto = (struct ospf_proto *) proto_get_named(NULL, &proto_ospf);

  ospf_sh_lsadb((yyvsp[-1].ld));
}
#line 14047 "obj/conf/cf-parse.tab.c"
    break;

  case 1273: /* lsadb_args: %empty  */
#line 552 "proto/ospf/config.Y"
               {
     (yyval.ld) = cfg_allocz(sizeof(struct lsadb_show_data));
   }
#line 14055 "obj/conf/cf-parse.tab.c"
    break;

  case 1274: /* lsadb_args: lsadb_args GLOBAL  */
#line 555 "proto/ospf/config.Y"
                     { (yyval.ld) = (yyvsp[-1].ld); (yyval.ld)->scope = LSA_SCOPE_AS; }
#line 14061 "obj/conf/cf-parse.tab.c"
    break;

  case 1275: /* lsadb_args: lsadb_args AREA idval  */
#line 556 "proto/ospf/config.Y"
                         { (yyval.ld) = (yyvsp[-2].ld); (yyval.ld)->scope = LSA_SCOPE_AREA; (yyval.ld)->area = (yyvsp[0].i32); }
#line 14067 "obj/conf/cf-parse.tab.c"
    break;

  case 1276: /* lsadb_args: lsadb_args LINK  */
#line 557 "proto/ospf/config.Y"
                   { (yyval.ld) = (yyvsp[-1].ld); (yyval.ld)->scope = 1; /* hack, 0 is no filter */ }
#line 14073 "obj/conf/cf-parse.tab.c"
    break;

  case 1277: /* lsadb_args: lsadb_args TYPE NUM  */
#line 558 "proto/ospf/config.Y"
                       { (yyval.ld) = (yyvsp[-2].ld); (yyval.ld)->type = (yyvsp[0].i); }
#line 14079 "obj/conf/cf-parse.tab.c"
    break;

  case 1278: /* lsadb_args: lsadb_args LSID idval  */
#line 559 "proto/ospf/config.Y"
                         { (yyval.ld) = (yyvsp[-2].ld); (yyval.ld)->lsid = (yyvsp[0].i32); }
#line 14085 "obj/conf/cf-parse.tab.c"
    break;

  case 1279: /* lsadb_args: lsadb_args SELF  */
#line 560 "proto/ospf/config.Y"
                   { (yyval.ld) = (yyvsp[-1].ld); (yyval.ld)->router = SH_ROUTER_SELF; }
#line 14091 "obj/conf/cf-parse.tab.c"
    break;

  case 1280: /* lsadb_args: lsadb_args ROUTER idval  */
#line 561 "proto/ospf/config.Y"
                           { (yyval.ld) = (yyvsp[-2].ld); (yyval.ld)->router = (yyvsp[0].i32); }
#line 14097 "obj/conf/cf-parse.tab.c"
    break;

  case 1281: /* lsadb_args: lsadb_args CF_SYM_KNOWN  */
#line 562 "proto/ospf/config.Y"
                           { cf_assert_symbol((yyvsp[0].s), SYM_PROTO); (yyval.ld) = (yyvsp[-1].ld); (yyval.ld)->proto = (struct ospf_proto *) proto_get_named((yyvsp[0].s), &proto_ospf); }
#line 14103 "obj/conf/cf-parse.tab.c"
    break;

  case 1282: /* proto: pipe_proto '}'  */
#line 23 "proto/pipe/config.Y"
                      { this_channel = NULL; }
#line 14109 "obj/conf/cf-parse.tab.c"
    break;

  case 1283: /* $@24: %empty  */
#line 26 "proto/pipe/config.Y"
{
  this_proto = proto_config_new(&proto_pipe, (yyvsp[-1].i));
  this_proto->loop_order = DOMAIN_ORDER(proto);
  PIPE_CFG->max_generation = 16;
}
#line 14119 "obj/conf/cf-parse.tab.c"
    break;

  case 1284: /* pipe_proto_start: proto_start PIPE $@24 proto_name  */
#line 32 "proto/pipe/config.Y"
{
  this_channel = proto_cf_main_channel(this_proto);
  if (!this_channel) {
    this_channel = channel_config_new(NULL, NULL, 0, this_proto);
    this_channel->in_filter = FILTER_ACCEPT;
    this_channel->out_filter = FILTER_ACCEPT;
  }
}
#line 14132 "obj/conf/cf-parse.tab.c"
    break;

  case 1288: /* pipe_proto: pipe_proto IMPORT IN net_any imexport ';'  */
#line 45 "proto/pipe/config.Y"
                                             {
    if (this_channel->net_type && ((yyvsp[-2].net_ptr)->type != this_channel->net_type))
      cf_error("Incompatible export prefilter type");
    PIPE_CFG->in_subprefix = (yyvsp[-2].net_ptr);
    this_channel->in_filter = (yyvsp[-1].f);
  }
#line 14143 "obj/conf/cf-parse.tab.c"
    break;

  case 1289: /* pipe_proto: pipe_proto PEER TABLE rtable ';'  */
#line 51 "proto/pipe/config.Y"
                                    { PIPE_CFG->peer = (yyvsp[-1].r); }
#line 14149 "obj/conf/cf-parse.tab.c"
    break;

  case 1290: /* pipe_proto: pipe_proto MAX GENERATION expr ';'  */
#line 52 "proto/pipe/config.Y"
                                      {
    if (((yyvsp[-1].i) < 1) || ((yyvsp[-1].i) > 254)) cf_error("Max generation must be in range 1..254, got %u", (yyvsp[-1].i));
    PIPE_CFG->max_generation = (yyvsp[-1].i);
  }
#line 14158 "obj/conf/cf-parse.tab.c"
    break;

  case 1292: /* radv_proto_start: proto_start RADV  */
#line 56 "proto/radv/config.Y"
{
  this_proto = proto_config_new(&proto_radv, (yyvsp[-1].i));
  this_proto->net_type = NET_IP6;

  init_list(&RADV_CFG->patt_list);
  init_list(&RADV_CFG->pref_list);
  init_list(&RADV_CFG->rdnss_list);
  init_list(&RADV_CFG->dnssl_list);
  init_list(&RADV_CFG->custom_list);
}
#line 14173 "obj/conf/cf-parse.tab.c"
    break;

  case 1296: /* radv_proto_item: PREFIX radv_prefix  */
#line 71 "proto/radv/config.Y"
                      { add_tail(&RADV_CFG->pref_list, NODE this_radv_prefix); }
#line 14179 "obj/conf/cf-parse.tab.c"
    break;

  case 1297: /* $@25: %empty  */
#line 72 "proto/radv/config.Y"
         { init_list(&radv_dns_list); }
#line 14185 "obj/conf/cf-parse.tab.c"
    break;

  case 1298: /* radv_proto_item: RDNSS $@25 radv_rdnss  */
#line 72 "proto/radv/config.Y"
                                                   { add_tail_list(&RADV_CFG->rdnss_list, &radv_dns_list); }
#line 14191 "obj/conf/cf-parse.tab.c"
    break;

  case 1299: /* $@26: %empty  */
#line 73 "proto/radv/config.Y"
         { init_list(&radv_dns_list); }
#line 14197 "obj/conf/cf-parse.tab.c"
    break;

  case 1300: /* radv_proto_item: DNSSL $@26 radv_dnssl  */
#line 73 "proto/radv/config.Y"
                                                   { add_tail_list(&RADV_CFG->dnssl_list, &radv_dns_list); }
#line 14203 "obj/conf/cf-parse.tab.c"
    break;

  case 1301: /* radv_proto_item: CUSTOM OPTION TYPE expr VALUE bytestring  */
#line 74 "proto/radv/config.Y"
                                            { radv_add_to_custom_list(&RADV_CFG->custom_list, (yyvsp[-2].i), (yyvsp[0].bs)); }
#line 14209 "obj/conf/cf-parse.tab.c"
    break;

  case 1302: /* radv_proto_item: TRIGGER net_ip6  */
#line 75 "proto/radv/config.Y"
                   { RADV_CFG->trigger = (yyvsp[0].net); }
#line 14215 "obj/conf/cf-parse.tab.c"
    break;

  case 1303: /* radv_proto_item: PROPAGATE ROUTES bool  */
#line 76 "proto/radv/config.Y"
                         { RADV_CFG->propagate_routes = (yyvsp[0].i); }
#line 14221 "obj/conf/cf-parse.tab.c"
    break;

  case 1307: /* radv_iface_start: %empty  */
#line 89 "proto/radv/config.Y"
{
  this_ipatt = cfg_allocz(sizeof(struct radv_iface_config));
  add_tail(&RADV_CFG->patt_list, NODE this_ipatt);
  init_list(&this_ipatt->ipn_list);
  init_list(&RADV_IFACE->pref_list);
  init_list(&RADV_IFACE->rdnss_list);
  init_list(&RADV_IFACE->dnssl_list);
  init_list(&RADV_IFACE->custom_list);

  RADV_IFACE->min_ra_int = (u32) -1; /* undefined */
  RADV_IFACE->max_ra_int = DEFAULT_MAX_RA_INT;
  RADV_IFACE->min_delay = DEFAULT_MIN_DELAY;
  RADV_IFACE->prefix_linger_time = (u32) -1;
  RADV_IFACE->route_linger_time = (u32) -1;
  RADV_IFACE->current_hop_limit = DEFAULT_CURRENT_HOP_LIMIT;
  RADV_IFACE->default_lifetime = (u32) -1;
  RADV_IFACE->default_lifetime_sensitive = 1;
  RADV_IFACE->default_preference = RA_PREF_MEDIUM;
  RADV_IFACE->route_lifetime = (u32) -1;
  RADV_IFACE->route_lifetime_sensitive = 0;
  RADV_IFACE->route_preference = RA_PREF_MEDIUM;
}
#line 14248 "obj/conf/cf-parse.tab.c"
    break;

  case 1308: /* radv_iface_item: MIN RA INTERVAL expr  */
#line 113 "proto/radv/config.Y"
                        { RADV_IFACE->min_ra_int = (yyvsp[0].i); if ((yyvsp[0].i) < 3) cf_error("Min RA interval must be at least 3"); }
#line 14254 "obj/conf/cf-parse.tab.c"
    break;

  case 1309: /* radv_iface_item: MAX RA INTERVAL expr  */
#line 114 "proto/radv/config.Y"
                        { RADV_IFACE->max_ra_int = (yyvsp[0].i); if (((yyvsp[0].i) < 4) || ((yyvsp[0].i) > 1800)) cf_error("Max RA interval must be in range 4-1800"); }
#line 14260 "obj/conf/cf-parse.tab.c"
    break;

  case 1310: /* radv_iface_item: MIN DELAY expr  */
#line 115 "proto/radv/config.Y"
                  { RADV_IFACE->min_delay = (yyvsp[0].i); if ((yyvsp[0].i) <= 0) cf_error("Min delay must be positive"); }
#line 14266 "obj/conf/cf-parse.tab.c"
    break;

  case 1311: /* radv_iface_item: SOLICITED RA UNICAST bool  */
#line 116 "proto/radv/config.Y"
                             { RADV_IFACE->solicited_ra_unicast = (yyvsp[0].i); }
#line 14272 "obj/conf/cf-parse.tab.c"
    break;

  case 1312: /* radv_iface_item: MANAGED bool  */
#line 117 "proto/radv/config.Y"
                { RADV_IFACE->managed = (yyvsp[0].i); }
#line 14278 "obj/conf/cf-parse.tab.c"
    break;

  case 1313: /* radv_iface_item: OTHER CONFIG bool  */
#line 118 "proto/radv/config.Y"
                     { RADV_IFACE->other_config = (yyvsp[0].i); }
#line 14284 "obj/conf/cf-parse.tab.c"
    break;

  case 1314: /* radv_iface_item: LINK MTU expr  */
#line 119 "proto/radv/config.Y"
                 { RADV_IFACE->link_mtu = (yyvsp[0].i); }
#line 14290 "obj/conf/cf-parse.tab.c"
    break;

  case 1315: /* radv_iface_item: REACHABLE TIME expr  */
#line 120 "proto/radv/config.Y"
                       { RADV_IFACE->reachable_time = (yyvsp[0].i); if ((yyvsp[0].i) > 3600000) cf_error("Reachable time must be in range 0-3600000"); }
#line 14296 "obj/conf/cf-parse.tab.c"
    break;

  case 1316: /* radv_iface_item: RETRANS TIMER expr  */
#line 121 "proto/radv/config.Y"
                      { RADV_IFACE->retrans_timer = (yyvsp[0].i); }
#line 14302 "obj/conf/cf-parse.tab.c"
    break;

  case 1317: /* radv_iface_item: CURRENT HOP LIMIT expr  */
#line 122 "proto/radv/config.Y"
                          { RADV_IFACE->current_hop_limit = (yyvsp[0].i); if ((yyvsp[0].i) > 255) cf_error("Current hop limit must be in range 0-255"); }
#line 14308 "obj/conf/cf-parse.tab.c"
    break;

  case 1318: /* radv_iface_item: DEFAULT LIFETIME expr radv_sensitive  */
#line 123 "proto/radv/config.Y"
                                        {
     RADV_IFACE->default_lifetime = (yyvsp[-1].i);
     if ((yyvsp[-1].i) > 9000)  cf_error("Default lifetime must be in range 0-9000");
     if ((yyvsp[0].i) != (uint) -1) RADV_IFACE->default_lifetime_sensitive = (yyvsp[0].i);
   }
#line 14318 "obj/conf/cf-parse.tab.c"
    break;

  case 1319: /* radv_iface_item: ROUTE LIFETIME expr radv_sensitive  */
#line 128 "proto/radv/config.Y"
                                      {
     RADV_IFACE->route_lifetime = (yyvsp[-1].i);
     if ((yyvsp[0].i) != (uint) -1) RADV_IFACE->route_lifetime_sensitive = (yyvsp[0].i);
   }
#line 14327 "obj/conf/cf-parse.tab.c"
    break;

  case 1320: /* radv_iface_item: DEFAULT PREFERENCE radv_preference  */
#line 132 "proto/radv/config.Y"
                                      { RADV_IFACE->default_preference = (yyvsp[0].i); }
#line 14333 "obj/conf/cf-parse.tab.c"
    break;

  case 1321: /* radv_iface_item: ROUTE PREFERENCE radv_preference  */
#line 133 "proto/radv/config.Y"
                                    { RADV_IFACE->route_preference = (yyvsp[0].i); }
#line 14339 "obj/conf/cf-parse.tab.c"
    break;

  case 1322: /* radv_iface_item: PREFIX LINGER TIME expr  */
#line 134 "proto/radv/config.Y"
                           { RADV_IFACE->prefix_linger_time = (yyvsp[0].i); }
#line 14345 "obj/conf/cf-parse.tab.c"
    break;

  case 1323: /* radv_iface_item: ROUTE LINGER TIME expr  */
#line 135 "proto/radv/config.Y"
                          { RADV_IFACE->route_linger_time = (yyvsp[0].i); }
#line 14351 "obj/conf/cf-parse.tab.c"
    break;

  case 1324: /* radv_iface_item: PREFIX radv_prefix  */
#line 136 "proto/radv/config.Y"
                      { add_tail(&RADV_IFACE->pref_list, NODE this_radv_prefix); }
#line 14357 "obj/conf/cf-parse.tab.c"
    break;

  case 1325: /* $@27: %empty  */
#line 137 "proto/radv/config.Y"
         { init_list(&radv_dns_list); }
#line 14363 "obj/conf/cf-parse.tab.c"
    break;

  case 1326: /* radv_iface_item: RDNSS $@27 radv_rdnss  */
#line 137 "proto/radv/config.Y"
                                                   { add_tail_list(&RADV_IFACE->rdnss_list, &radv_dns_list); }
#line 14369 "obj/conf/cf-parse.tab.c"
    break;

  case 1327: /* $@28: %empty  */
#line 138 "proto/radv/config.Y"
         { init_list(&radv_dns_list); }
#line 14375 "obj/conf/cf-parse.tab.c"
    break;

  case 1328: /* radv_iface_item: DNSSL $@28 radv_dnssl  */
#line 138 "proto/radv/config.Y"
                                                   { add_tail_list(&RADV_IFACE->dnssl_list, &radv_dns_list); }
#line 14381 "obj/conf/cf-parse.tab.c"
    break;

  case 1329: /* radv_iface_item: CUSTOM OPTION TYPE expr VALUE bytestring  */
#line 139 "proto/radv/config.Y"
                                            { radv_add_to_custom_list(&RADV_IFACE->custom_list, (yyvsp[-2].i), (yyvsp[0].bs)); }
#line 14387 "obj/conf/cf-parse.tab.c"
    break;

  case 1330: /* radv_iface_item: RDNSS LOCAL bool  */
#line 140 "proto/radv/config.Y"
                    { RADV_IFACE->rdnss_local = (yyvsp[0].i); }
#line 14393 "obj/conf/cf-parse.tab.c"
    break;

  case 1331: /* radv_iface_item: DNSSL LOCAL bool  */
#line 141 "proto/radv/config.Y"
                    { RADV_IFACE->dnssl_local = (yyvsp[0].i); }
#line 14399 "obj/conf/cf-parse.tab.c"
    break;

  case 1332: /* radv_iface_item: CUSTOM OPTION LOCAL bool  */
#line 142 "proto/radv/config.Y"
                            { RADV_IFACE->custom_local = (yyvsp[0].i); }
#line 14405 "obj/conf/cf-parse.tab.c"
    break;

  case 1333: /* radv_preference: LOW  */
#line 146 "proto/radv/config.Y"
       { (yyval.i) = RA_PREF_LOW; }
#line 14411 "obj/conf/cf-parse.tab.c"
    break;

  case 1334: /* radv_preference: MEDIUM  */
#line 147 "proto/radv/config.Y"
          { (yyval.i) = RA_PREF_MEDIUM; }
#line 14417 "obj/conf/cf-parse.tab.c"
    break;

  case 1335: /* radv_preference: HIGH  */
#line 148 "proto/radv/config.Y"
        { (yyval.i) = RA_PREF_HIGH; }
#line 14423 "obj/conf/cf-parse.tab.c"
    break;

  case 1336: /* radv_iface_finish: %empty  */
#line 151 "proto/radv/config.Y"
{
  struct radv_iface_config *ic = RADV_IFACE;

  if (ic->min_ra_int == (u32) -1)
    ic->min_ra_int = MAX_(ic->max_ra_int / 3, 3);

  if (ic->default_lifetime == (u32) -1)
    ic->default_lifetime = 3 * ic->max_ra_int;

  if (ic->route_lifetime == (u32) -1)
    ic->route_lifetime = 3 * ic->max_ra_int;

  if (ic->prefix_linger_time == (u32) -1)
    ic->prefix_linger_time = 3 * ic->max_ra_int;

  if (ic->route_linger_time == (u32) -1)
    ic->route_linger_time = 3 * ic->max_ra_int;

  if ((ic->min_ra_int > 3) &&
      (ic->min_ra_int > (ic->max_ra_int * 3 / 4)))
    cf_error("Min RA interval must be at most 3/4 * Max RA interval");

  if ((ic->default_lifetime > 0) && (ic->default_lifetime < ic->max_ra_int))
    cf_error("Default lifetime must be either 0 or at least Max RA interval");

  if ((ic->route_lifetime > 0) && (ic->route_lifetime < ic->max_ra_int))
    cf_error("Route lifetime must be either 0 or at least Max RA interval");

  if ((ic->prefix_linger_time > 0) && (ic->prefix_linger_time < ic->max_ra_int))
    cf_error("Prefix linger time must be either 0 or at least Max RA interval");

  if ((ic->route_linger_time > 0) && (ic->route_linger_time < ic->max_ra_int))
    cf_error("Route linger time must be either 0 or at least Max RA interval");

  RADV_CFG->max_linger_time = MAX_(RADV_CFG->max_linger_time, ic->route_linger_time);
}
#line 14464 "obj/conf/cf-parse.tab.c"
    break;

  case 1342: /* radv_prefix_start: net_ip6  */
#line 204 "proto/radv/config.Y"
{
  this_radv_prefix = cfg_allocz(sizeof(struct radv_prefix_config));
  RADV_PREFIX->prefix = *(net_addr_ip6 *) &((yyvsp[0].net));

  RADV_PREFIX->onlink = 1;
  RADV_PREFIX->autonomous = 1;
  RADV_PREFIX->valid_lifetime = DEFAULT_VALID_LIFETIME;
  RADV_PREFIX->preferred_lifetime = DEFAULT_PREFERRED_LIFETIME;
}
#line 14478 "obj/conf/cf-parse.tab.c"
    break;

  case 1343: /* radv_prefix_item: SKIP bool  */
#line 215 "proto/radv/config.Y"
             { RADV_PREFIX->skip = (yyvsp[0].i); }
#line 14484 "obj/conf/cf-parse.tab.c"
    break;

  case 1344: /* radv_prefix_item: ONLINK bool  */
#line 216 "proto/radv/config.Y"
               { RADV_PREFIX->onlink = (yyvsp[0].i); }
#line 14490 "obj/conf/cf-parse.tab.c"
    break;

  case 1345: /* radv_prefix_item: AUTONOMOUS bool  */
#line 217 "proto/radv/config.Y"
                   { RADV_PREFIX->autonomous = (yyvsp[0].i); }
#line 14496 "obj/conf/cf-parse.tab.c"
    break;

  case 1346: /* radv_prefix_item: VALID LIFETIME expr radv_sensitive  */
#line 218 "proto/radv/config.Y"
                                      {
     RADV_PREFIX->valid_lifetime = (yyvsp[-1].i);
     if ((yyvsp[0].i) != (uint) -1) RADV_PREFIX->valid_lifetime_sensitive = (yyvsp[0].i);
   }
#line 14505 "obj/conf/cf-parse.tab.c"
    break;

  case 1347: /* radv_prefix_item: PREFERRED LIFETIME expr radv_sensitive  */
#line 222 "proto/radv/config.Y"
                                          {
     RADV_PREFIX->preferred_lifetime = (yyvsp[-1].i);
     if ((yyvsp[0].i) != (uint) -1) RADV_PREFIX->preferred_lifetime_sensitive = (yyvsp[0].i);
   }
#line 14514 "obj/conf/cf-parse.tab.c"
    break;

  case 1348: /* radv_prefix_finish: %empty  */
#line 229 "proto/radv/config.Y"
{
  if (RADV_PREFIX->preferred_lifetime > RADV_PREFIX->valid_lifetime)
    cf_error("Preferred lifetime must be at most Valid lifetime");

  if (RADV_PREFIX->valid_lifetime_sensitive > RADV_PREFIX->preferred_lifetime_sensitive)
    cf_error("Valid lifetime sensitive requires that Preferred lifetime is sensitive too");
}
#line 14526 "obj/conf/cf-parse.tab.c"
    break;

  case 1354: /* radv_rdnss_node: ipa  */
#line 253 "proto/radv/config.Y"
{
  struct radv_rdnss_config *cf = cfg_allocz(sizeof(struct radv_rdnss_config));
  add_tail(&radv_dns_list, NODE cf);

  cf->server = (yyvsp[0].a);
  cf->lifetime_mult = DEFAULT_DNS_LIFETIME_MULT;
}
#line 14538 "obj/conf/cf-parse.tab.c"
    break;

  case 1355: /* radv_rdnss_start: %empty  */
#line 262 "proto/radv/config.Y"
{
  RADV_RDNSS->lifetime = 0;
  RADV_RDNSS->lifetime_mult = DEFAULT_DNS_LIFETIME_MULT;
}
#line 14547 "obj/conf/cf-parse.tab.c"
    break;

  case 1358: /* radv_rdnss_item: LIFETIME radv_mult  */
#line 269 "proto/radv/config.Y"
                      { RADV_RDNSS->lifetime = (yyvsp[0].i); RADV_RDNSS->lifetime_mult = radv_mult_val; }
#line 14553 "obj/conf/cf-parse.tab.c"
    break;

  case 1359: /* radv_rdnss_finish: %empty  */
#line 273 "proto/radv/config.Y"
{
  if (EMPTY_LIST(radv_dns_list))
    cf_error("No nameserver in RDNSS section");

  struct radv_rdnss_config *cf;
  WALK_LIST(cf, radv_dns_list)
  {
    cf->lifetime = RADV_RDNSS->lifetime;
    cf->lifetime_mult = RADV_RDNSS->lifetime_mult;
  }
}
#line 14569 "obj/conf/cf-parse.tab.c"
    break;

  case 1364: /* radv_dnssl_node: TEXT  */
#line 297 "proto/radv/config.Y"
{
  struct radv_dnssl_config *cf = cfg_allocz(sizeof(struct radv_dnssl_config));
  add_tail(&radv_dns_list, NODE cf);

  cf->domain = (yyvsp[0].t);
  cf->lifetime_mult = DEFAULT_DNS_LIFETIME_MULT;

  if (radv_process_domain(cf) < 0)
    cf_error("Invalid domain dame");
}
#line 14584 "obj/conf/cf-parse.tab.c"
    break;

  case 1365: /* radv_dnssl_start: %empty  */
#line 309 "proto/radv/config.Y"
{
  RADV_DNSSL->lifetime = 0;
  RADV_DNSSL->lifetime_mult = DEFAULT_DNS_LIFETIME_MULT;
}
#line 14593 "obj/conf/cf-parse.tab.c"
    break;

  case 1368: /* radv_dnssl_item: LIFETIME radv_mult  */
#line 316 "proto/radv/config.Y"
                      { RADV_DNSSL->lifetime = (yyvsp[0].i); RADV_DNSSL->lifetime_mult = radv_mult_val; }
#line 14599 "obj/conf/cf-parse.tab.c"
    break;

  case 1369: /* radv_dnssl_finish: %empty  */
#line 320 "proto/radv/config.Y"
{
  if (EMPTY_LIST(radv_dns_list))
    cf_error("No domain in DNSSL section");

  struct radv_dnssl_config *cf;
  WALK_LIST(cf, radv_dns_list)
  {
    cf->lifetime = RADV_DNSSL->lifetime;
    cf->lifetime_mult = RADV_DNSSL->lifetime_mult;
  }
}
#line 14615 "obj/conf/cf-parse.tab.c"
    break;

  case 1374: /* radv_mult: expr  */
#line 344 "proto/radv/config.Y"
        { (yyval.i) = (yyvsp[0].i); radv_mult_val = 0; }
#line 14621 "obj/conf/cf-parse.tab.c"
    break;

  case 1375: /* radv_mult: MULT expr  */
#line 345 "proto/radv/config.Y"
             { (yyval.i) = 0; radv_mult_val = (yyvsp[0].i); if (((yyvsp[0].i) < 1) || ((yyvsp[0].i) > 254)) cf_error("Multiplier must be in range 1-254"); }
#line 14627 "obj/conf/cf-parse.tab.c"
    break;

  case 1376: /* radv_sensitive: %empty  */
#line 349 "proto/radv/config.Y"
               { (yyval.i) = (uint) -1; }
#line 14633 "obj/conf/cf-parse.tab.c"
    break;

  case 1377: /* radv_sensitive: SENSITIVE bool  */
#line 350 "proto/radv/config.Y"
                  { (yyval.i) = (yyvsp[0].i); }
#line 14639 "obj/conf/cf-parse.tab.c"
    break;

  case 1379: /* rip_variant: RIP  */
#line 49 "proto/rip/config.Y"
          { (yyval.i) = 1; }
#line 14645 "obj/conf/cf-parse.tab.c"
    break;

  case 1380: /* rip_variant: RIP NG  */
#line 50 "proto/rip/config.Y"
          { (yyval.i) = 0; }
#line 14651 "obj/conf/cf-parse.tab.c"
    break;

  case 1381: /* rip_proto_start: proto_start rip_variant  */
#line 54 "proto/rip/config.Y"
{
  this_proto = proto_config_new(&proto_rip, (yyvsp[-1].i));
  this_proto->net_type = (yyvsp[0].i) ? NET_IP4 : NET_IP6;

  init_list(&RIP_CFG->patt_list);
  RIP_CFG->rip2 = (yyvsp[0].i);
  RIP_CFG->ecmp = rt_default_ecmp;
  RIP_CFG->infinity = RIP_DEFAULT_INFINITY;
  RIP_CFG->min_timeout_time = 60 S_;
  RIP_CFG->max_garbage_time = 60 S_;
}
#line 14667 "obj/conf/cf-parse.tab.c"
    break;

  case 1384: /* rip_proto_item: ECMP bool  */
#line 69 "proto/rip/config.Y"
                        { RIP_CFG->ecmp = (yyvsp[0].i) ? RIP_DEFAULT_ECMP_LIMIT : 0; }
#line 14673 "obj/conf/cf-parse.tab.c"
    break;

  case 1385: /* rip_proto_item: ECMP bool LIMIT expr  */
#line 70 "proto/rip/config.Y"
                        { RIP_CFG->ecmp = (yyvsp[-2].i) ? (yyvsp[0].i) : 0; }
#line 14679 "obj/conf/cf-parse.tab.c"
    break;

  case 1386: /* rip_proto_item: INFINITY expr  */
#line 71 "proto/rip/config.Y"
                        { RIP_CFG->infinity = (yyvsp[0].i); }
#line 14685 "obj/conf/cf-parse.tab.c"
    break;

  case 1391: /* rip_iface_start: %empty  */
#line 85 "proto/rip/config.Y"
{
  this_ipatt = cfg_allocz(sizeof(struct rip_iface_config));
  add_tail(&RIP_CFG->patt_list, NODE this_ipatt);
  init_list(&this_ipatt->ipn_list);
  reset_passwords();

  RIP_IFACE->metric = 1;
  RIP_IFACE->port = rip_cfg_is_v2() ? RIP_PORT : RIP_NG_PORT;
  RIP_IFACE->version = rip_cfg_is_v2() ? RIP_V2 : RIP_V1;
  RIP_IFACE->split_horizon = 1;
  RIP_IFACE->poison_reverse = 1;
  RIP_IFACE->check_zero = 1;
  RIP_IFACE->check_link = 1;
  RIP_IFACE->ttl_security = rip_cfg_is_v2() ? 0 : 1;
  RIP_IFACE->rx_buffer = rip_cfg_is_v2() ? RIP_MAX_PKT_LENGTH : 0;
  RIP_IFACE->tx_length = rip_cfg_is_v2() ? RIP_MAX_PKT_LENGTH : 0;
  RIP_IFACE->tx_tos = IP_PREC_INTERNET_CONTROL;
  RIP_IFACE->tx_priority = sk_priority_control;
  RIP_IFACE->update_time = RIP_DEFAULT_UPDATE_TIME;
  RIP_IFACE->timeout_time = RIP_DEFAULT_TIMEOUT_TIME;
  RIP_IFACE->garbage_time = RIP_DEFAULT_GARBAGE_TIME;
  RIP_IFACE->rxmt_time = RIP_DEFAULT_RXMT_TIME;
}
#line 14713 "obj/conf/cf-parse.tab.c"
    break;

  case 1392: /* rip_iface_finish: %empty  */
#line 110 "proto/rip/config.Y"
{
  /* Default mode is broadcast for RIPv1, multicast for RIPv2 and RIPng */
  if (!RIP_IFACE->mode)
    RIP_IFACE->mode = (rip_cfg_is_v2() && (RIP_IFACE->version == RIP_V1)) ?
      RIP_IM_BROADCAST : RIP_IM_MULTICAST;

  RIP_IFACE->passwords = get_passwords();

  if (!RIP_IFACE->auth_type != !RIP_IFACE->passwords)
    cf_warn("Authentication and password options should be used together");

  if (RIP_IFACE->passwords)
  {
    struct password_item *pass;
    WALK_LIST(pass, *RIP_IFACE->passwords)
    {
      if (pass->alg && (RIP_IFACE->auth_type != RIP_AUTH_CRYPTO))
	cf_error("Password algorithm option requires cryptographic authentication");

      /* Set default crypto algorithm (MD5) */
      if (!pass->alg && (RIP_IFACE->auth_type == RIP_AUTH_CRYPTO))
	pass->alg = ALG_MD5;
    }
  }

  RIP_CFG->min_timeout_time = MIN_(RIP_CFG->min_timeout_time, RIP_IFACE->timeout_time);
  RIP_CFG->max_garbage_time = MAX_(RIP_CFG->max_garbage_time, RIP_IFACE->garbage_time);
}
#line 14746 "obj/conf/cf-parse.tab.c"
    break;

  case 1393: /* rip_iface_item: METRIC expr  */
#line 140 "proto/rip/config.Y"
                        { RIP_IFACE->metric = (yyvsp[0].i); if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>255)) cf_error("Metric must be in range 1-255"); }
#line 14752 "obj/conf/cf-parse.tab.c"
    break;

  case 1394: /* rip_iface_item: MODE MULTICAST  */
#line 141 "proto/rip/config.Y"
                        { RIP_IFACE->mode = RIP_IM_MULTICAST; }
#line 14758 "obj/conf/cf-parse.tab.c"
    break;

  case 1395: /* rip_iface_item: MODE BROADCAST  */
#line 142 "proto/rip/config.Y"
                        { RIP_IFACE->mode = RIP_IM_BROADCAST; if (rip_cfg_is_ng()) cf_error("Broadcast not supported in RIPng"); }
#line 14764 "obj/conf/cf-parse.tab.c"
    break;

  case 1396: /* rip_iface_item: PASSIVE bool  */
#line 143 "proto/rip/config.Y"
                        { RIP_IFACE->passive = (yyvsp[0].i); }
#line 14770 "obj/conf/cf-parse.tab.c"
    break;

  case 1397: /* rip_iface_item: ADDRESS ipa  */
#line 144 "proto/rip/config.Y"
                        { RIP_IFACE->address = (yyvsp[0].a); if (ipa_is_ip4((yyvsp[0].a)) != rip_cfg_is_v2()) cf_error("IP address version mismatch"); }
#line 14776 "obj/conf/cf-parse.tab.c"
    break;

  case 1398: /* rip_iface_item: PORT expr  */
#line 145 "proto/rip/config.Y"
                        { RIP_IFACE->port = (yyvsp[0].i); if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>65535)) cf_error("Invalid port number"); }
#line 14782 "obj/conf/cf-parse.tab.c"
    break;

  case 1399: /* rip_iface_item: VERSION expr  */
#line 146 "proto/rip/config.Y"
                        { RIP_IFACE->version = (yyvsp[0].i);
			  if (rip_cfg_is_ng()) cf_error("Version not supported in RIPng");
			  if (((yyvsp[0].i) != RIP_V1) && ((yyvsp[0].i) != RIP_V2)) cf_error("Unsupported version");
			}
#line 14791 "obj/conf/cf-parse.tab.c"
    break;

  case 1400: /* rip_iface_item: VERSION ONLY bool  */
#line 150 "proto/rip/config.Y"
                        { RIP_IFACE->version_only = (yyvsp[0].i); }
#line 14797 "obj/conf/cf-parse.tab.c"
    break;

  case 1401: /* rip_iface_item: SPLIT HORIZON bool  */
#line 151 "proto/rip/config.Y"
                        { RIP_IFACE->split_horizon = (yyvsp[0].i); }
#line 14803 "obj/conf/cf-parse.tab.c"
    break;

  case 1402: /* rip_iface_item: POISON REVERSE bool  */
#line 152 "proto/rip/config.Y"
                        { RIP_IFACE->poison_reverse = (yyvsp[0].i); }
#line 14809 "obj/conf/cf-parse.tab.c"
    break;

  case 1403: /* rip_iface_item: CHECK ZERO bool  */
#line 153 "proto/rip/config.Y"
                        { RIP_IFACE->check_zero = (yyvsp[0].i); }
#line 14815 "obj/conf/cf-parse.tab.c"
    break;

  case 1404: /* rip_iface_item: DEMAND CIRCUIT bool  */
#line 154 "proto/rip/config.Y"
                        { RIP_IFACE->demand_circuit = (yyvsp[0].i); }
#line 14821 "obj/conf/cf-parse.tab.c"
    break;

  case 1405: /* rip_iface_item: UPDATE TIME expr  */
#line 155 "proto/rip/config.Y"
                        { RIP_IFACE->update_time = (yyvsp[0].i) S_; if ((yyvsp[0].i)<=0) cf_error("Update time must be positive"); }
#line 14827 "obj/conf/cf-parse.tab.c"
    break;

  case 1406: /* rip_iface_item: TIMEOUT TIME expr  */
#line 156 "proto/rip/config.Y"
                        { RIP_IFACE->timeout_time = (yyvsp[0].i) S_; if ((yyvsp[0].i)<=0) cf_error("Timeout time must be positive"); }
#line 14833 "obj/conf/cf-parse.tab.c"
    break;

  case 1407: /* rip_iface_item: GARBAGE TIME expr  */
#line 157 "proto/rip/config.Y"
                        { RIP_IFACE->garbage_time = (yyvsp[0].i) S_; if ((yyvsp[0].i)<=0) cf_error("Garbage time must be positive"); }
#line 14839 "obj/conf/cf-parse.tab.c"
    break;

  case 1408: /* rip_iface_item: RETRANSMIT TIME expr_us  */
#line 158 "proto/rip/config.Y"
                           { RIP_IFACE->rxmt_time = (yyvsp[0].time); if ((yyvsp[0].time)<=0) cf_error("Retransmit time must be positive"); }
#line 14845 "obj/conf/cf-parse.tab.c"
    break;

  case 1409: /* rip_iface_item: ECMP WEIGHT expr  */
#line 159 "proto/rip/config.Y"
                        { RIP_IFACE->ecmp_weight = (yyvsp[0].i) - 1; if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>256)) cf_error("ECMP weight must be in range 1-256"); }
#line 14851 "obj/conf/cf-parse.tab.c"
    break;

  case 1410: /* rip_iface_item: RX BUFFER expr  */
#line 160 "proto/rip/config.Y"
                        { RIP_IFACE->rx_buffer = (yyvsp[0].i); if (((yyvsp[0].i)<256) || ((yyvsp[0].i)>65535)) cf_error("RX length must be in range 256-65535"); }
#line 14857 "obj/conf/cf-parse.tab.c"
    break;

  case 1411: /* rip_iface_item: TX LENGTH expr  */
#line 161 "proto/rip/config.Y"
                        { RIP_IFACE->tx_length = (yyvsp[0].i); if (((yyvsp[0].i)<256) || ((yyvsp[0].i)>65535)) cf_error("TX length must be in range 256-65535"); }
#line 14863 "obj/conf/cf-parse.tab.c"
    break;

  case 1412: /* rip_iface_item: TX tos  */
#line 162 "proto/rip/config.Y"
                        { RIP_IFACE->tx_tos = (yyvsp[0].i); }
#line 14869 "obj/conf/cf-parse.tab.c"
    break;

  case 1413: /* rip_iface_item: TX PRIORITY expr  */
#line 163 "proto/rip/config.Y"
                        { RIP_IFACE->tx_priority = (yyvsp[0].i); }
#line 14875 "obj/conf/cf-parse.tab.c"
    break;

  case 1414: /* rip_iface_item: TTL SECURITY bool  */
#line 164 "proto/rip/config.Y"
                        { RIP_IFACE->ttl_security = (yyvsp[0].i); }
#line 14881 "obj/conf/cf-parse.tab.c"
    break;

  case 1415: /* rip_iface_item: TTL SECURITY TX ONLY  */
#line 165 "proto/rip/config.Y"
                        { RIP_IFACE->ttl_security = 2; }
#line 14887 "obj/conf/cf-parse.tab.c"
    break;

  case 1416: /* rip_iface_item: CHECK LINK bool  */
#line 166 "proto/rip/config.Y"
                        { RIP_IFACE->check_link = (yyvsp[0].i); }
#line 14893 "obj/conf/cf-parse.tab.c"
    break;

  case 1417: /* rip_iface_item: BFD bool  */
#line 167 "proto/rip/config.Y"
                        { RIP_IFACE->bfd = (yyvsp[0].i); cf_check_bfd((yyvsp[0].i)); }
#line 14899 "obj/conf/cf-parse.tab.c"
    break;

  case 1418: /* rip_iface_item: AUTHENTICATION rip_auth  */
#line 168 "proto/rip/config.Y"
                           { RIP_IFACE->auth_type = (yyvsp[0].i); if ((yyvsp[0].i)) rip_check_auth(); }
#line 14905 "obj/conf/cf-parse.tab.c"
    break;

  case 1419: /* rip_iface_item: password_list  */
#line 169 "proto/rip/config.Y"
                        { rip_check_auth(); }
#line 14911 "obj/conf/cf-parse.tab.c"
    break;

  case 1420: /* rip_auth: NONE  */
#line 173 "proto/rip/config.Y"
                        { (yyval.i) = RIP_AUTH_NONE; }
#line 14917 "obj/conf/cf-parse.tab.c"
    break;

  case 1421: /* rip_auth: PLAINTEXT  */
#line 174 "proto/rip/config.Y"
                        { (yyval.i) = RIP_AUTH_PLAIN; }
#line 14923 "obj/conf/cf-parse.tab.c"
    break;

  case 1422: /* rip_auth: CRYPTOGRAPHIC  */
#line 175 "proto/rip/config.Y"
                        { (yyval.i) = RIP_AUTH_CRYPTO; }
#line 14929 "obj/conf/cf-parse.tab.c"
    break;

  case 1423: /* rip_auth: MD5  */
#line 176 "proto/rip/config.Y"
                        { (yyval.i) = RIP_AUTH_CRYPTO; }
#line 14935 "obj/conf/cf-parse.tab.c"
    break;

  case 1430: /* cmd_SHOW_RIP_INTERFACES: SHOW RIP INTERFACES optproto opttext END  */
#line 196 "proto/rip/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_rip, p) rip_show_interfaces(p, (yyvsp[-1].t)); }
#line 14941 "obj/conf/cf-parse.tab.c"
    break;

  case 1432: /* cmd_SHOW_RIP_NEIGHBORS: SHOW RIP NEIGHBORS optproto opttext END  */
#line 199 "proto/rip/config.Y"
{ PROTO_WALK_CMD((yyvsp[-2].s), &proto_rip, p) rip_show_neighbors(p, (yyvsp[-1].t)); }
#line 14947 "obj/conf/cf-parse.tab.c"
    break;

  case 1434: /* rpki_proto_start: proto_start RPKI  */
#line 45 "proto/rpki/config.Y"
                                   {
  this_proto = proto_config_new(&proto_rpki, (yyvsp[-1].i));
  this_proto->loop_order = DOMAIN_ORDER(proto);
  RPKI_CFG->retry_interval = RPKI_RETRY_INTERVAL;
  RPKI_CFG->refresh_interval = RPKI_REFRESH_INTERVAL;
  RPKI_CFG->expire_interval = RPKI_EXPIRE_INTERVAL;
  RPKI_CFG->min_version = 0;
  RPKI_CFG->max_version = RPKI_MAX_VERSION;
}
#line 14961 "obj/conf/cf-parse.tab.c"
    break;

  case 1435: /* rpki_proto: rpki_proto_start proto_name '{' rpki_proto_opts '}'  */
#line 55 "proto/rpki/config.Y"
                                                                { rpki_check_config(RPKI_CFG); }
#line 14967 "obj/conf/cf-parse.tab.c"
    break;

  case 1443: /* rpki_proto_item: LOCAL ADDRESS ipa  */
#line 68 "proto/rpki/config.Y"
                     { RPKI_CFG->local_ip = (yyvsp[0].a); }
#line 14973 "obj/conf/cf-parse.tab.c"
    break;

  case 1445: /* rpki_proto_item: REFRESH rpki_keep_interval expr  */
#line 70 "proto/rpki/config.Y"
                                   {
     if (rpki_check_refresh_interval((yyvsp[0].i)))
       cf_error(rpki_check_refresh_interval((yyvsp[0].i)));
     RPKI_CFG->refresh_interval = (yyvsp[0].i);
     RPKI_CFG->keep_refresh_interval = (yyvsp[-1].i);
   }
#line 14984 "obj/conf/cf-parse.tab.c"
    break;

  case 1446: /* rpki_proto_item: RETRY rpki_keep_interval expr  */
#line 76 "proto/rpki/config.Y"
                                 {
     if (rpki_check_retry_interval((yyvsp[0].i)))
       cf_error(rpki_check_retry_interval((yyvsp[0].i)));
     RPKI_CFG->retry_interval = (yyvsp[0].i);
     RPKI_CFG->keep_retry_interval = (yyvsp[-1].i);
   }
#line 14995 "obj/conf/cf-parse.tab.c"
    break;

  case 1447: /* rpki_proto_item: EXPIRE rpki_keep_interval expr  */
#line 82 "proto/rpki/config.Y"
                                  {
     if (rpki_check_expire_interval((yyvsp[0].i)))
       cf_error(rpki_check_expire_interval((yyvsp[0].i)));
     RPKI_CFG->expire_interval = (yyvsp[0].i);
     RPKI_CFG->keep_expire_interval = (yyvsp[-1].i);
   }
#line 15006 "obj/conf/cf-parse.tab.c"
    break;

  case 1448: /* rpki_proto_item: IGNORE MAX LENGTH bool  */
#line 88 "proto/rpki/config.Y"
                          { RPKI_CFG->ignore_max_length = (yyvsp[0].i); }
#line 15012 "obj/conf/cf-parse.tab.c"
    break;

  case 1449: /* rpki_proto_item: MIN VERSION expr  */
#line 89 "proto/rpki/config.Y"
                    {
     if ((yyvsp[0].i) > RPKI_MAX_VERSION) cf_error("RPKI version %u unsupported, min version must be in range 0-%u", (yyvsp[0].i), RPKI_MAX_VERSION);
     RPKI_CFG->min_version = (yyvsp[0].i);
   }
#line 15021 "obj/conf/cf-parse.tab.c"
    break;

  case 1450: /* rpki_proto_item: MAX VERSION expr  */
#line 93 "proto/rpki/config.Y"
                    {
     if ((yyvsp[0].i) > RPKI_MAX_VERSION) cf_error("RPKI version %u unsupported, max version must be in range 0-%u", (yyvsp[0].i), RPKI_MAX_VERSION);
     RPKI_CFG->max_version = (yyvsp[0].i);
   }
#line 15030 "obj/conf/cf-parse.tab.c"
    break;

  case 1451: /* rpki_keep_interval: %empty  */
#line 100 "proto/rpki/config.Y"
             { (yyval.i) = 0; }
#line 15036 "obj/conf/cf-parse.tab.c"
    break;

  case 1452: /* rpki_keep_interval: KEEP  */
#line 101 "proto/rpki/config.Y"
        { (yyval.i) = 1; }
#line 15042 "obj/conf/cf-parse.tab.c"
    break;

  case 1453: /* rpki_proto_item_port: PORT expr  */
#line 104 "proto/rpki/config.Y"
                                { check_u16((yyvsp[0].i)); RPKI_CFG->port = (yyvsp[0].i); }
#line 15048 "obj/conf/cf-parse.tab.c"
    break;

  case 1454: /* rpki_cache_addr: text_or_ipa  */
#line 107 "proto/rpki/config.Y"
{
  rpki_check_unused_hostname();
  if ((yyvsp[0].v).type == T_STRING)
    RPKI_CFG->hostname = (yyvsp[0].v).val.s;
  else if ((yyvsp[0].v).type == T_IP)
  {
    RPKI_CFG->ip = (yyvsp[0].v).val.ip;

    /* Ensure hostname is filled */
    char *hostname = cfg_allocz(INET6_ADDRSTRLEN + 1);
    bsnprintf(hostname, INET6_ADDRSTRLEN+1, "%I", RPKI_CFG->ip);
    RPKI_CFG->hostname = hostname;
  }
  else bug("Bad text_or_ipa");
}
#line 15068 "obj/conf/cf-parse.tab.c"
    break;

  case 1457: /* rpki_transport_tcp_init: %empty  */
#line 129 "proto/rpki/config.Y"
{
  rpki_check_unused_transport();
  RPKI_CFG->tr_config.spec = cfg_allocz(sizeof(struct rpki_tr_tcp_config));
  RPKI_CFG->tr_config.type = RPKI_TR_TCP;
}
#line 15078 "obj/conf/cf-parse.tab.c"
    break;

  case 1462: /* rpki_transport_tcp_item: AUTHENTICATION NONE  */
#line 146 "proto/rpki/config.Y"
                        { RPKI_TR_TCP_CFG->auth_type = RPKI_TCP_AUTH_NONE; }
#line 15084 "obj/conf/cf-parse.tab.c"
    break;

  case 1463: /* rpki_transport_tcp_item: AUTHENTICATION MD5  */
#line 147 "proto/rpki/config.Y"
                        { RPKI_TR_TCP_CFG->auth_type = RPKI_TCP_AUTH_MD5; }
#line 15090 "obj/conf/cf-parse.tab.c"
    break;

  case 1464: /* rpki_transport_tcp_item: PASSWORD text  */
#line 148 "proto/rpki/config.Y"
                        { RPKI_TR_TCP_CFG->password = (yyvsp[0].t); }
#line 15096 "obj/conf/cf-parse.tab.c"
    break;

  case 1465: /* rpki_transport_tcp_check: %empty  */
#line 152 "proto/rpki/config.Y"
{
  if (!RPKI_TR_TCP_CFG->auth_type != !RPKI_TR_TCP_CFG->password)
    cf_error("Authentication and password options should be used together");
}
#line 15105 "obj/conf/cf-parse.tab.c"
    break;

  case 1466: /* rpki_transport_ssh_init: %empty  */
#line 158 "proto/rpki/config.Y"
{
#if HAVE_LIBSSH
  rpki_check_unused_transport();
  RPKI_CFG->tr_config.spec = cfg_allocz(sizeof(struct rpki_tr_ssh_config));
  RPKI_CFG->tr_config.type = RPKI_TR_SSH;
#else
  cf_error("This build doesn't support SSH");
#endif
}
#line 15119 "obj/conf/cf-parse.tab.c"
    break;

  case 1469: /* rpki_transport_ssh_item: BIRD PRIVATE KEY text  */
#line 174 "proto/rpki/config.Y"
                          { RPKI_TR_SSH_CFG->bird_private_key = (yyvsp[0].t); }
#line 15125 "obj/conf/cf-parse.tab.c"
    break;

  case 1470: /* rpki_transport_ssh_item: REMOTE PUBLIC KEY text  */
#line 175 "proto/rpki/config.Y"
                          { RPKI_TR_SSH_CFG->cache_public_key = (yyvsp[0].t); }
#line 15131 "obj/conf/cf-parse.tab.c"
    break;

  case 1471: /* rpki_transport_ssh_item: USER text  */
#line 176 "proto/rpki/config.Y"
                          { RPKI_TR_SSH_CFG->user = (yyvsp[0].t); }
#line 15137 "obj/conf/cf-parse.tab.c"
    break;

  case 1472: /* rpki_transport_ssh_check: %empty  */
#line 180 "proto/rpki/config.Y"
{
  if (RPKI_TR_SSH_CFG->user == NULL)
    cf_error("User must be set");
}
#line 15146 "obj/conf/cf-parse.tab.c"
    break;

  case 1474: /* static_proto_start: proto_start STATIC  */
#line 59 "proto/static/config.Y"
{
  this_proto = proto_config_new(&proto_static, (yyvsp[-1].i));
  init_list(&STATIC_CFG->routes);
}
#line 15155 "obj/conf/cf-parse.tab.c"
    break;

  case 1477: /* static_proto: static_proto proto_channel ';'  */
#line 67 "proto/static/config.Y"
                                  { this_proto->net_type = (yyvsp[-1].cc)->net_type; }
#line 15161 "obj/conf/cf-parse.tab.c"
    break;

  case 1479: /* static_proto: static_proto CHECK LINK bool ';'  */
#line 69 "proto/static/config.Y"
                                    { STATIC_CFG->check_link = (yyvsp[-1].i); }
#line 15167 "obj/conf/cf-parse.tab.c"
    break;

  case 1480: /* static_proto: static_proto IGP TABLE rtable ';'  */
#line 70 "proto/static/config.Y"
                                     {
    if ((yyvsp[-1].r)->addr_type == NET_IP4)
      STATIC_CFG->igp_table_ip4 = (yyvsp[-1].r);
    else if ((yyvsp[-1].r)->addr_type == NET_IP6)
      STATIC_CFG->igp_table_ip6 = (yyvsp[-1].r);
    else
      cf_error("Incompatible IGP table type");
   }
#line 15180 "obj/conf/cf-parse.tab.c"
    break;

  case 1481: /* static_proto: static_proto stat_route stat_route_opt_list ';'  */
#line 78 "proto/static/config.Y"
                                                   { static_route_finish(); }
#line 15186 "obj/conf/cf-parse.tab.c"
    break;

  case 1482: /* stat_nexthop: VIA ipa ipa_scope  */
#line 82 "proto/static/config.Y"
                      {
      this_snh = static_nexthop_new();
      this_snh->via = (yyvsp[-1].a);
      this_snh->iface = (yyvsp[0].iface);
    }
#line 15196 "obj/conf/cf-parse.tab.c"
    break;

  case 1483: /* stat_nexthop: VIA TEXT  */
#line 87 "proto/static/config.Y"
             {
      this_snh = static_nexthop_new();
      this_snh->via = IPA_NONE;
      this_snh->iface = if_get_by_name((yyvsp[0].t));
    }
#line 15206 "obj/conf/cf-parse.tab.c"
    break;

  case 1484: /* stat_nexthop: stat_nexthop DEV TEXT  */
#line 92 "proto/static/config.Y"
                          {
      this_snh->iface = if_get_by_name((yyvsp[0].t));
    }
#line 15214 "obj/conf/cf-parse.tab.c"
    break;

  case 1485: /* stat_nexthop: stat_nexthop MPLS label_stack  */
#line 95 "proto/static/config.Y"
                                  {
    this_snh->mls = (yyvsp[0].ad);
  }
#line 15222 "obj/conf/cf-parse.tab.c"
    break;

  case 1486: /* stat_nexthop: stat_nexthop ONLINK bool  */
#line 98 "proto/static/config.Y"
                             {
    this_snh->onlink = (yyvsp[0].i);
    if (this_snh->use_bfd && this_snh->onlink)
      cf_error("Options 'bfd' and 'onlink' cannot be combined");
  }
#line 15232 "obj/conf/cf-parse.tab.c"
    break;

  case 1487: /* stat_nexthop: stat_nexthop WEIGHT expr  */
#line 103 "proto/static/config.Y"
                             {
    this_snh->weight = (yyvsp[0].i) - 1;
    if (((yyvsp[0].i)<1) || ((yyvsp[0].i)>256)) cf_error("Weight must be in range 1-256");
  }
#line 15241 "obj/conf/cf-parse.tab.c"
    break;

  case 1488: /* stat_nexthop: stat_nexthop BFD bool  */
#line 107 "proto/static/config.Y"
                          {
    this_snh->use_bfd = (yyvsp[0].i); cf_check_bfd((yyvsp[0].i));
    if (this_snh->use_bfd && this_snh->onlink)
      cf_error("Options 'bfd' and 'onlink' cannot be combined");
  }
#line 15251 "obj/conf/cf-parse.tab.c"
    break;

  case 1492: /* stat_mpls: MPLS expr  */
#line 121 "proto/static/config.Y"
             { this_srt->mpls_label = (yyvsp[0].i); if ((yyvsp[0].i) >= MPLS_MAX_LABEL) cf_error("MPLS label must be less than 2^20"); }
#line 15257 "obj/conf/cf-parse.tab.c"
    break;

  case 1493: /* $@29: %empty  */
#line 124 "proto/static/config.Y"
                           {
     this_srt = cfg_allocz(sizeof(struct static_route));
     add_tail(&STATIC_CFG->routes, &this_srt->n);
     this_srt->net = (yyvsp[0].net_ptr);
     this_srt->mpls_label = (uint) -1;
     this_srt_cmds = NULL;
     this_srt_last_cmd = NULL;
     this_srt->mp_next = NULL;
     this_snh = NULL;
  }
#line 15272 "obj/conf/cf-parse.tab.c"
    break;

  case 1496: /* stat_route: stat_route0 RECURSIVE ipa  */
#line 138 "proto/static/config.Y"
                             {
      this_srt->dest = RTDX_RECURSIVE;
      this_srt->via = (yyvsp[0].a);
   }
#line 15281 "obj/conf/cf-parse.tab.c"
    break;

  case 1497: /* stat_route: stat_route0 RECURSIVE ipa MPLS label_stack  */
#line 142 "proto/static/config.Y"
                                              {
      this_srt->dest = RTDX_RECURSIVE;
      this_srt->via = (yyvsp[-2].a);
      this_srt->mls = (yyvsp[0].ad);
   }
#line 15291 "obj/conf/cf-parse.tab.c"
    break;

  case 1498: /* stat_route: stat_route0  */
#line 147 "proto/static/config.Y"
                                { this_srt->dest = RTD_NONE; }
#line 15297 "obj/conf/cf-parse.tab.c"
    break;

  case 1499: /* stat_route: stat_route0 DROP  */
#line 148 "proto/static/config.Y"
                                { this_srt->dest = RTD_BLACKHOLE; }
#line 15303 "obj/conf/cf-parse.tab.c"
    break;

  case 1500: /* stat_route: stat_route0 REJECT  */
#line 149 "proto/static/config.Y"
                                { this_srt->dest = RTD_UNREACHABLE; }
#line 15309 "obj/conf/cf-parse.tab.c"
    break;

  case 1501: /* stat_route: stat_route0 BLACKHOLE  */
#line 150 "proto/static/config.Y"
                                { this_srt->dest = RTD_BLACKHOLE; }
#line 15315 "obj/conf/cf-parse.tab.c"
    break;

  case 1502: /* stat_route: stat_route0 UNREACHABLE  */
#line 151 "proto/static/config.Y"
                                { this_srt->dest = RTD_UNREACHABLE; }
#line 15321 "obj/conf/cf-parse.tab.c"
    break;

  case 1503: /* stat_route: stat_route0 PROHIBIT  */
#line 152 "proto/static/config.Y"
                                { this_srt->dest = RTD_PROHIBIT; }
#line 15327 "obj/conf/cf-parse.tab.c"
    break;

  case 1504: /* $@30: %empty  */
#line 153 "proto/static/config.Y"
                         {
    if (this_srt->net->type != NET_ASPA) cf_error("Provider settings available only for ASPA");
    this_srt->aspa = cfg_alloc(sizeof (adata) + (this_srt_aspa_max = 8) * sizeof (u32));
    this_srt->aspa->length = 0;
   }
#line 15337 "obj/conf/cf-parse.tab.c"
    break;

  case 1506: /* stat_route: stat_route0 TRANSIT  */
#line 158 "proto/static/config.Y"
                       {
    if (this_srt->net->type != NET_ASPA) cf_error("Transit settings available only for ASPA");
    /* Allocate an explicit zero */
    this_srt->aspa = cfg_alloc(sizeof (adata) + sizeof (u32));
    this_srt->aspa->length = sizeof(u32);
    ((u32 *) this_srt->aspa->data)[0] = 0;
   }
#line 15349 "obj/conf/cf-parse.tab.c"
    break;

  case 1507: /* stat_aspa_provider: NUM  */
#line 167 "proto/static/config.Y"
                        {
  if (this_srt->aspa->length == this_srt_aspa_max * sizeof(u32))
  {
    adata *new = cfg_alloc(sizeof (adata) + (this_srt_aspa_max * 2) * sizeof (u32));
    memcpy(new, this_srt->aspa, this_srt->aspa->length + sizeof(adata));
    this_srt->aspa = new;
    this_srt_aspa_max *= 2;
  }

  ((u32 *) this_srt->aspa->data)[this_srt->aspa->length / sizeof(u32)] = (yyvsp[0].i);
  this_srt->aspa->length += sizeof(u32);
}
#line 15366 "obj/conf/cf-parse.tab.c"
    break;

  case 1510: /* stat_route_item: cmd  */
#line 183 "proto/static/config.Y"
       {
     if (this_srt_last_cmd)
       this_srt_last_cmd->next = (yyvsp[0].x);
     else
       this_srt_cmds = (yyvsp[0].x);
     this_srt_last_cmd = (yyvsp[0].x);
   }
#line 15378 "obj/conf/cf-parse.tab.c"
    break;

  case 1514: /* $@31: %empty  */
#line 199 "proto/static/config.Y"
       { cf_enter_filters(); }
#line 15384 "obj/conf/cf-parse.tab.c"
    break;

  case 1515: /* stat_route_opt_list: '{' $@31 stat_route_opts '}'  */
#line 199 "proto/static/config.Y"
                                                   { cf_exit_filters(); }
#line 15390 "obj/conf/cf-parse.tab.c"
    break;

  case 1517: /* cmd_SHOW_STATIC: SHOW STATIC optproto END  */
#line 204 "proto/static/config.Y"
{ PROTO_WALK_CMD((yyvsp[-1].s), &proto_static, p) static_show(p); }
#line 15396 "obj/conf/cf-parse.tab.c"
    break;

  case 1519: /* mrt_proto_start: proto_start MRT  */
#line 29 "proto/mrt/config.Y"
{
  this_proto = proto_config_new(&proto_mrt, (yyvsp[-1].i));
  this_proto->loop_order = DOMAIN_ORDER(proto);
}
#line 15405 "obj/conf/cf-parse.tab.c"
    break;

  case 1521: /* mrt_proto_item: TABLE rtable  */
#line 36 "proto/mrt/config.Y"
                        { MRT_CFG->table_cf = (yyvsp[0].r); }
#line 15411 "obj/conf/cf-parse.tab.c"
    break;

  case 1522: /* mrt_proto_item: TABLE TEXT  */
#line 37 "proto/mrt/config.Y"
                        { MRT_CFG->table_expr = (yyvsp[0].t); }
#line 15417 "obj/conf/cf-parse.tab.c"
    break;

  case 1523: /* mrt_proto_item: FILTER filter  */
#line 38 "proto/mrt/config.Y"
                        { MRT_CFG->filter = (yyvsp[0].f); }
#line 15423 "obj/conf/cf-parse.tab.c"
    break;

  case 1524: /* mrt_proto_item: where_filter  */
#line 39 "proto/mrt/config.Y"
                        { MRT_CFG->filter = (yyvsp[0].f); }
#line 15429 "obj/conf/cf-parse.tab.c"
    break;

  case 1525: /* mrt_proto_item: FILENAME text  */
#line 40 "proto/mrt/config.Y"
                        { MRT_CFG->filename = (yyvsp[0].t); }
#line 15435 "obj/conf/cf-parse.tab.c"
    break;

  case 1526: /* mrt_proto_item: PERIOD expr  */
#line 41 "proto/mrt/config.Y"
                        { MRT_CFG->period = (yyvsp[0].i); }
#line 15441 "obj/conf/cf-parse.tab.c"
    break;

  case 1527: /* mrt_proto_item: ALWAYS ADD PATH bool  */
#line 42 "proto/mrt/config.Y"
                        { MRT_CFG->always_add_path = (yyvsp[0].i); }
#line 15447 "obj/conf/cf-parse.tab.c"
    break;

  case 1530: /* mrt_proto: mrt_proto_start proto_name '{' mrt_proto_opts '}'  */
#line 51 "proto/mrt/config.Y"
                                                     { mrt_check_config(this_proto); }
#line 15453 "obj/conf/cf-parse.tab.c"
    break;

  case 1532: /* cmd_MRT_DUMP: MRT DUMP mrt_dump_args END  */
#line 55 "proto/mrt/config.Y"
{ mrt_dump_cmd((yyvsp[-1].md)); }
#line 15459 "obj/conf/cf-parse.tab.c"
    break;

  case 1533: /* mrt_dump_args: %empty  */
#line 63 "proto/mrt/config.Y"
               { (yyval.md) = cfg_allocz(sizeof(struct mrt_dump_data)); }
#line 15465 "obj/conf/cf-parse.tab.c"
    break;

  case 1534: /* mrt_dump_args: mrt_dump_args TABLE rtable  */
#line 64 "proto/mrt/config.Y"
                                { (yyval.md) = (yyvsp[-2].md); (yyval.md)->table_ptr = (yyvsp[0].r)->table; }
#line 15471 "obj/conf/cf-parse.tab.c"
    break;

  case 1535: /* mrt_dump_args: mrt_dump_args TABLE TEXT  */
#line 65 "proto/mrt/config.Y"
                                { (yyval.md) = (yyvsp[-2].md); (yyval.md)->table_expr = (yyvsp[0].t); }
#line 15477 "obj/conf/cf-parse.tab.c"
    break;

  case 1536: /* mrt_dump_args: mrt_dump_args FILTER filter  */
#line 66 "proto/mrt/config.Y"
                                { (yyval.md) = (yyvsp[-2].md); (yyval.md)->filter = (yyvsp[0].f); }
#line 15483 "obj/conf/cf-parse.tab.c"
    break;

  case 1537: /* mrt_dump_args: mrt_dump_args where_filter  */
#line 67 "proto/mrt/config.Y"
                                { (yyval.md) = (yyvsp[-1].md); (yyval.md)->filter = (yyvsp[0].f); }
#line 15489 "obj/conf/cf-parse.tab.c"
    break;

  case 1538: /* mrt_dump_args: mrt_dump_args TO text  */
#line 68 "proto/mrt/config.Y"
                                { (yyval.md) = (yyvsp[-2].md); (yyval.md)->filename = (yyvsp[0].t); }
#line 15495 "obj/conf/cf-parse.tab.c"
    break;

  case 1540: /* bmp_proto_start: proto_start BMP  */
#line 26 "proto/bmp/config.Y"
                                 {
     this_proto = proto_config_new(&proto_bmp, (yyvsp[-1].i));
     this_proto->loop_order = DOMAIN_ORDER(proto);
     BMP_CFG->sys_descr = "Not defined";
     BMP_CFG->sys_name = "Not defined";
     BMP_CFG->tx_pending_limit = (1 << 30) / page_size;
   }
#line 15507 "obj/conf/cf-parse.tab.c"
    break;

  case 1542: /* bmp_station_address: bmp_station_address IP ipa  */
#line 37 "proto/bmp/config.Y"
                              {
     if (ipa_zero((yyvsp[0].a)))
       cf_error("Invalid BMP monitoring station IP address");
     BMP_CFG->station_ip = (yyvsp[0].a);
   }
#line 15517 "obj/conf/cf-parse.tab.c"
    break;

  case 1543: /* bmp_station_address: bmp_station_address PORT expr  */
#line 42 "proto/bmp/config.Y"
                                 {
     if (((yyvsp[0].i) < 1) || ((yyvsp[0].i) > 65535))
       cf_error("Invalid BMP monitoring station port number");
     BMP_CFG->station_port = (yyvsp[0].i);
   }
#line 15527 "obj/conf/cf-parse.tab.c"
    break;

  case 1546: /* bmp_proto: bmp_proto LOCAL ADDRESS ipa ';'  */
#line 52 "proto/bmp/config.Y"
                                   {
     BMP_CFG->local_addr = (yyvsp[-1].a);
   }
#line 15535 "obj/conf/cf-parse.tab.c"
    break;

  case 1548: /* bmp_proto: bmp_proto SYSTEM DESCRIPTION text ';'  */
#line 56 "proto/bmp/config.Y"
                                         {
     if (!(yyvsp[-1].t) || (strlen((yyvsp[-1].t)) == 0))
       cf_error("String is empty");
     else if (strlen((yyvsp[-1].t)) > 255)
       cf_error("Invalid string length");
     BMP_CFG->sys_descr = (yyvsp[-1].t);
   }
#line 15547 "obj/conf/cf-parse.tab.c"
    break;

  case 1549: /* bmp_proto: bmp_proto SYSTEM NAME text ';'  */
#line 63 "proto/bmp/config.Y"
                                  {
     if (!(yyvsp[-1].t) || (strlen((yyvsp[-1].t)) == 0))
       cf_error("String is empty");
     else if (strlen((yyvsp[-1].t)) > 255)
       cf_error("Invalid string length");
     BMP_CFG->sys_name = (yyvsp[-1].t);
   }
#line 15559 "obj/conf/cf-parse.tab.c"
    break;

  case 1550: /* bmp_proto: bmp_proto MONITORING RIB IN PRE_POLICY bool ';'  */
#line 70 "proto/bmp/config.Y"
                                                   {
     BMP_CFG->monitoring_rib_in_pre_policy = (yyvsp[-1].i);
   }
#line 15567 "obj/conf/cf-parse.tab.c"
    break;

  case 1551: /* bmp_proto: bmp_proto MONITORING RIB IN POST_POLICY bool ';'  */
#line 73 "proto/bmp/config.Y"
                                                    {
     BMP_CFG->monitoring_rib_in_post_policy = (yyvsp[-1].i);
   }
#line 15575 "obj/conf/cf-parse.tab.c"
    break;

  case 1552: /* bmp_proto: bmp_proto TX BUFFER LIMIT expr ';'  */
#line 76 "proto/bmp/config.Y"
                                      {
     BMP_CFG->tx_pending_limit = (yyvsp[-1].i) * (u64) (1 << 20) / page_size;
     if ((yyvsp[-1].i) < 1) cf_error("BMP TX buffer limit must be at least 1 megabyte");
   }
#line 15584 "obj/conf/cf-parse.tab.c"
    break;

  case 1554: /* kern_sys_item: KERNEL TABLE expr  */
#line 29 "sysdep/linux/netlink.Y"
                     { THIS_KRT->sys.table_id = (yyvsp[0].i); }
#line 15590 "obj/conf/cf-parse.tab.c"
    break;

  case 1555: /* kern_sys_item: METRIC expr  */
#line 30 "sysdep/linux/netlink.Y"
               { THIS_KRT->sys.metric = (yyvsp[0].i); }
#line 15596 "obj/conf/cf-parse.tab.c"
    break;

  case 1556: /* kern_sys_item: NETLINK RX BUFFER expr  */
#line 31 "sysdep/linux/netlink.Y"
                          { THIS_KRT->sys.netlink_rx_buffer = (yyvsp[0].i); }
#line 15602 "obj/conf/cf-parse.tab.c"
    break;

  case 1557: /* attr_bit: KRT_LOCK_MTU  */
#line 35 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(2, "krt_lock"); }
#line 15608 "obj/conf/cf-parse.tab.c"
    break;

  case 1558: /* attr_bit: KRT_LOCK_WINDOW  */
#line 36 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(3, "krt_lock"); }
#line 15614 "obj/conf/cf-parse.tab.c"
    break;

  case 1559: /* attr_bit: KRT_LOCK_RTT  */
#line 37 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(4, "krt_lock"); }
#line 15620 "obj/conf/cf-parse.tab.c"
    break;

  case 1560: /* attr_bit: KRT_LOCK_RTTVAR  */
#line 38 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(5, "krt_lock"); }
#line 15626 "obj/conf/cf-parse.tab.c"
    break;

  case 1561: /* attr_bit: KRT_LOCK_SSTHRESH  */
#line 39 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(6, "krt_lock"); }
#line 15632 "obj/conf/cf-parse.tab.c"
    break;

  case 1562: /* attr_bit: KRT_LOCK_CWND  */
#line 40 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(7, "krt_lock"); }
#line 15638 "obj/conf/cf-parse.tab.c"
    break;

  case 1563: /* attr_bit: KRT_LOCK_ADVMSS  */
#line 41 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(8, "krt_lock"); }
#line 15644 "obj/conf/cf-parse.tab.c"
    break;

  case 1564: /* attr_bit: KRT_LOCK_REORDERING  */
#line 42 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(9, "krt_lock"); }
#line 15650 "obj/conf/cf-parse.tab.c"
    break;

  case 1565: /* attr_bit: KRT_LOCK_HOPLIMIT  */
#line 43 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(10, "krt_lock"); }
#line 15656 "obj/conf/cf-parse.tab.c"
    break;

  case 1566: /* attr_bit: KRT_LOCK_INITCWND  */
#line 44 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(11, "krt_lock"); }
#line 15662 "obj/conf/cf-parse.tab.c"
    break;

  case 1567: /* attr_bit: KRT_LOCK_RTO_MIN  */
#line 46 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(13, "krt_lock"); }
#line 15668 "obj/conf/cf-parse.tab.c"
    break;

  case 1568: /* attr_bit: KRT_LOCK_INITRWND  */
#line 47 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(14, "krt_lock"); }
#line 15674 "obj/conf/cf-parse.tab.c"
    break;

  case 1569: /* attr_bit: KRT_LOCK_QUICKACK  */
#line 48 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(15, "krt_lock"); }
#line 15680 "obj/conf/cf-parse.tab.c"
    break;

  case 1570: /* attr_bit: KRT_LOCK_CONGCTL  */
#line 49 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(16, "krt_lock"); }
#line 15686 "obj/conf/cf-parse.tab.c"
    break;

  case 1571: /* attr_bit: KRT_LOCK_FASTOPEN_NO_COOKIE  */
#line 50 "sysdep/linux/netlink.Y"
                                        { (yyval.fab) = f_new_dynamic_attr_bit(17, "krt_lock"); }
#line 15692 "obj/conf/cf-parse.tab.c"
    break;

  case 1572: /* attr_bit: KRT_FEATURE_ECN  */
#line 53 "sysdep/linux/netlink.Y"
                                { (yyval.fab) = f_new_dynamic_attr_bit(0, "krt_features"); }
#line 15698 "obj/conf/cf-parse.tab.c"
    break;

  case 1573: /* attr_bit: KRT_FEATURE_ALLFRAG  */
#line 54 "sysdep/linux/netlink.Y"
                              { (yyval.fab) = f_new_dynamic_attr_bit(3, "krt_features"); }
#line 15704 "obj/conf/cf-parse.tab.c"
    break;

  case 1574: /* lvalue: attr_bit  */
#line 57 "sysdep/linux/netlink.Y"
                 { (yyval.flv) = (struct f_lval) { .type = F_LVAL_ATTR_BIT, .fab = (yyvsp[0].fab), .rte = f_new_inst(FI_CURRENT_ROUTE), }; }
#line 15710 "obj/conf/cf-parse.tab.c"
    break;

  case 1576: /* log_begin: %empty  */
#line 36 "sysdep/unix/config.Y"
           { this_log = cfg_allocz(sizeof(struct log_config)); }
#line 15716 "obj/conf/cf-parse.tab.c"
    break;

  case 1577: /* log_config: LOG log_begin log_file log_mask ';'  */
#line 38 "sysdep/unix/config.Y"
                                                {
    this_log->mask = (yyvsp[-1].i);
    add_tail(&new_config->logfiles, &this_log->n);
  }
#line 15725 "obj/conf/cf-parse.tab.c"
    break;

  case 1578: /* syslog_name: NAME text  */
#line 45 "sysdep/unix/config.Y"
             { (yyval.t) = (yyvsp[0].t); }
#line 15731 "obj/conf/cf-parse.tab.c"
    break;

  case 1579: /* syslog_name: %empty  */
#line 46 "sysdep/unix/config.Y"
   { (yyval.t) = bird_name; }
#line 15737 "obj/conf/cf-parse.tab.c"
    break;

  case 1581: /* log_limit: expr text  */
#line 51 "sysdep/unix/config.Y"
             { this_log->limit = (yyvsp[-1].i); this_log->backup = (yyvsp[0].t); }
#line 15743 "obj/conf/cf-parse.tab.c"
    break;

  case 1582: /* log_file: text log_limit  */
#line 55 "sysdep/unix/config.Y"
                  {
     if (!parse_and_exit)
     {
       this_log->rf = rf_open(new_config->pool, (yyvsp[-1].t), RF_APPEND, this_log->limit);
       if (!this_log->rf) cf_error("Unable to open log file '%s': %m", (yyvsp[-1].t));
     }
     this_log->filename = (yyvsp[-1].t);
   }
#line 15756 "obj/conf/cf-parse.tab.c"
    break;

  case 1583: /* log_file: FIXED text expr  */
#line 63 "sysdep/unix/config.Y"
                   {
     if (!parse_and_exit)
     {
       this_log->rf = rf_open(new_config->pool, (yyvsp[-1].t), RF_FIXED, this_log->limit = (yyvsp[0].i));
       if (!this_log->rf) cf_error("Unable to open log file '%s': %m", (yyvsp[-1].t));
     }
     this_log->filename = (yyvsp[-1].t);
   }
#line 15769 "obj/conf/cf-parse.tab.c"
    break;

  case 1584: /* log_file: SYSLOG syslog_name  */
#line 71 "sysdep/unix/config.Y"
                      { this_log->rf = NULL; new_config->syslog_name = (yyvsp[0].t); }
#line 15775 "obj/conf/cf-parse.tab.c"
    break;

  case 1585: /* log_file: STDERR  */
#line 72 "sysdep/unix/config.Y"
          { this_log->rf = &rf_stderr; this_log->terminal_flag = 1; }
#line 15781 "obj/conf/cf-parse.tab.c"
    break;

  case 1586: /* log_file: UDP log_udp_host log_udp_port  */
#line 73 "sysdep/unix/config.Y"
                                 { this_log->rf = NULL; }
#line 15787 "obj/conf/cf-parse.tab.c"
    break;

  case 1587: /* log_udp_host: text_or_ipa  */
#line 77 "sysdep/unix/config.Y"
{
  if ((yyvsp[0].v).type == T_STRING)
    this_log->udp_host = (yyvsp[0].v).val.s;
  else if ((yyvsp[0].v).type == T_IP)
    this_log->udp_ip = (yyvsp[0].v).val.ip;
  else bug("Bad text_or_ipa");
}
#line 15799 "obj/conf/cf-parse.tab.c"
    break;

  case 1588: /* log_udp_port: %empty  */
#line 86 "sysdep/unix/config.Y"
                { this_log->udp_port = 514; }
#line 15805 "obj/conf/cf-parse.tab.c"
    break;

  case 1589: /* log_udp_port: PORT NUM  */
#line 87 "sysdep/unix/config.Y"
             { check_u16((yyvsp[0].i)); this_log->udp_port = (yyvsp[0].i); }
#line 15811 "obj/conf/cf-parse.tab.c"
    break;

  case 1590: /* log_mask: ALL  */
#line 91 "sysdep/unix/config.Y"
       { (yyval.i) = ~0; }
#line 15817 "obj/conf/cf-parse.tab.c"
    break;

  case 1591: /* log_mask: '{' log_mask_list '}'  */
#line 92 "sysdep/unix/config.Y"
                         { (yyval.i) = (yyvsp[-1].i); }
#line 15823 "obj/conf/cf-parse.tab.c"
    break;

  case 1592: /* log_mask_list: log_cat  */
#line 96 "sysdep/unix/config.Y"
           { (yyval.i) = 1 << (yyvsp[0].i); }
#line 15829 "obj/conf/cf-parse.tab.c"
    break;

  case 1593: /* log_mask_list: log_mask_list ',' log_cat  */
#line 97 "sysdep/unix/config.Y"
                             { (yyval.i) = (yyvsp[-2].i) | (1 << (yyvsp[0].i)); }
#line 15835 "obj/conf/cf-parse.tab.c"
    break;

  case 1594: /* log_cat: DEBUG  */
#line 101 "sysdep/unix/config.Y"
         { (yyval.i) = L_DEBUG[0]; }
#line 15841 "obj/conf/cf-parse.tab.c"
    break;

  case 1595: /* log_cat: TRACE  */
#line 102 "sysdep/unix/config.Y"
         { (yyval.i) = L_TRACE[0]; }
#line 15847 "obj/conf/cf-parse.tab.c"
    break;

  case 1596: /* log_cat: INFO  */
#line 103 "sysdep/unix/config.Y"
        { (yyval.i) = L_INFO[0]; }
#line 15853 "obj/conf/cf-parse.tab.c"
    break;

  case 1597: /* log_cat: REMOTE  */
#line 104 "sysdep/unix/config.Y"
          { (yyval.i) = L_REMOTE[0]; }
#line 15859 "obj/conf/cf-parse.tab.c"
    break;

  case 1598: /* log_cat: WARNING  */
#line 105 "sysdep/unix/config.Y"
           { (yyval.i) = L_WARN[0]; }
#line 15865 "obj/conf/cf-parse.tab.c"
    break;

  case 1599: /* log_cat: ERROR  */
#line 106 "sysdep/unix/config.Y"
         { (yyval.i) = L_ERR[0]; }
#line 15871 "obj/conf/cf-parse.tab.c"
    break;

  case 1600: /* log_cat: AUTH  */
#line 107 "sysdep/unix/config.Y"
        { (yyval.i) = L_AUTH[0]; }
#line 15877 "obj/conf/cf-parse.tab.c"
    break;

  case 1601: /* log_cat: FATAL  */
#line 108 "sysdep/unix/config.Y"
         { (yyval.i) = L_FATAL[0]; }
#line 15883 "obj/conf/cf-parse.tab.c"
    break;

  case 1602: /* log_cat: BUG  */
#line 109 "sysdep/unix/config.Y"
       { (yyval.i) = L_BUG[0]; }
#line 15889 "obj/conf/cf-parse.tab.c"
    break;

  case 1604: /* mrtdump_base: MRTDUMP PROTOCOLS mrtdump_mask ';'  */
#line 116 "sysdep/unix/config.Y"
                                      { new_config->proto_default_mrtdump = (yyvsp[-1].i); }
#line 15895 "obj/conf/cf-parse.tab.c"
    break;

  case 1605: /* mrtdump_base: MRTDUMP text ';'  */
#line 117 "sysdep/unix/config.Y"
                    {
     if (!parse_and_exit)
     {
       struct rfile *f = rf_open(new_config->pool, (yyvsp[-1].t), RF_APPEND, 0);
       if (!f) cf_error("Unable to open MRTDump file '%s': %m", (yyvsp[-1].t));
       new_config->mrtdump_file = f;
     }
   }
#line 15908 "obj/conf/cf-parse.tab.c"
    break;

  case 1607: /* cli: CLI text cli_opts  */
#line 129 "sysdep/unix/config.Y"
                       {
  this_cli_config->name = (yyvsp[-1].t);
  cli_config_add_tail(&new_config->cli, this_cli_config);
  this_cli_config = NULL;
}
#line 15918 "obj/conf/cf-parse.tab.c"
    break;

  case 1610: /* cli_opts_begin: %empty  */
#line 137 "sysdep/unix/config.Y"
                {
  this_cli_config = cfg_alloc(sizeof *this_cli_config);
  *this_cli_config = (typeof (*this_cli_config)) {
    .config = new_config,
    .mode = 0660,
  };
}
#line 15930 "obj/conf/cf-parse.tab.c"
    break;

  case 1612: /* cli_opts_block: cli_opts_block RESTRICT ';'  */
#line 147 "sysdep/unix/config.Y"
                                { this_cli_config->restricted = 1; }
#line 15936 "obj/conf/cf-parse.tab.c"
    break;

  case 1613: /* cli_opts_block: cli_opts_block V2 ATTRIBUTES ';'  */
#line 148 "sysdep/unix/config.Y"
                                     { this_cli_config->v2attributes = 1; }
#line 15942 "obj/conf/cf-parse.tab.c"
    break;

  case 1614: /* conf: THREADS NUM  */
#line 151 "sysdep/unix/config.Y"
                  {
  if ((yyvsp[0].i) < 1) cf_error("Number of threads must be at least one.");
  if (!new_config->thread_group_simple &&
      !EMPTY_TLIST(thread_group_config, &new_config->thread_group))
    cf_error("Mixing of `threads NUM` and `threads worker {}` is not allowed.");

  if (new_config->thread_group_simple == -1)
    THEAD(thread_group_config, &new_config->thread_group)->thread_count = (yyvsp[0].i);

  new_config->thread_group_simple = (yyvsp[0].i);
}
#line 15958 "obj/conf/cf-parse.tab.c"
    break;

  case 1615: /* $@32: %empty  */
#line 163 "sysdep/unix/config.Y"
                          {
  switch (new_config->thread_group_simple) {
    case -1: cf_error("Put `threads` block before any protocol or table definition.");
    case 0: break;
    default: cf_error("Mixing of `threads NUM` and `threads worker {}` is not allowed.");
  }

  this_thread_group = cfg_alloc(sizeof *this_thread_group);
  *this_thread_group = strcmp((yyvsp[0].s)->name, "express") ?
    thread_group_config_default_worker :
    thread_group_config_default_express;
}
#line 15975 "obj/conf/cf-parse.tab.c"
    break;

  case 1616: /* conf: THREAD GROUP symbol $@32 '{' thread_group_opts '}'  */
#line 174 "sysdep/unix/config.Y"
                            {
  if (this_thread_group->params.max_time > 60 S_)
    cf_error("Loop time maximum is 60 seconds, got %t", this_thread_group->params.max_time);
  if (this_thread_group->params.max_latency < this_thread_group->params.max_time)
    cf_error("Loop time maximum can't be higher than its latency limit");
  if (this_thread_group->params.min_time > this_thread_group->params.max_time)
    cf_error("Loop time minimm can't be higher than maximum");
  if (this_thread_group->params.wakeup_time < 1 S_)
    cf_error("Too low idle wakeup time, expected at least 1 second");

  this_thread_group->symbol = cf_define_symbol(new_config, (yyvsp[-4].s), SYM_THREAD_GROUP, thread_group, this_thread_group);
  thread_group_config_add_tail(&new_config->thread_group, this_thread_group);
  this_thread_group = NULL;
}
#line 15994 "obj/conf/cf-parse.tab.c"
    break;

  case 1617: /* thread_group_opts: MAX TIME expr_us ';'  */
#line 189 "sysdep/unix/config.Y"
                                        { this_thread_group->params.max_time = (yyvsp[-1].time); }
#line 16000 "obj/conf/cf-parse.tab.c"
    break;

  case 1618: /* thread_group_opts: MIN TIME expr_us ';'  */
#line 190 "sysdep/unix/config.Y"
                                        { this_thread_group->params.min_time = (yyvsp[-1].time); }
#line 16006 "obj/conf/cf-parse.tab.c"
    break;

  case 1619: /* thread_group_opts: MAX LATENCY expr_us ';'  */
#line 191 "sysdep/unix/config.Y"
                                           { this_thread_group->params.max_latency = (yyvsp[-1].time); }
#line 16012 "obj/conf/cf-parse.tab.c"
    break;

  case 1620: /* thread_group_opts: THREADS expr ';'  */
#line 192 "sysdep/unix/config.Y"
                                    { this_thread_group->thread_count = (yyvsp[-1].i); }
#line 16018 "obj/conf/cf-parse.tab.c"
    break;

  case 1621: /* thread_group_opts: WAKEUP TIME expr_us ';'  */
#line 193 "sysdep/unix/config.Y"
                                           { this_thread_group->params.wakeup_time = (yyvsp[-1].time); }
#line 16024 "obj/conf/cf-parse.tab.c"
    break;

  case 1622: /* thread_group_opts: DEFAULT bool ';'  */
#line 194 "sysdep/unix/config.Y"
                                    {
  if ((yyvsp[-1].i)) {
    if (new_config->default_thread_group &&
	new_config->default_thread_group != this_thread_group)
      cf_error("Too many default thread groups, already have %s",
	  new_config->default_thread_group->symbol->name);
    new_config->default_thread_group = this_thread_group;
  }
}
#line 16038 "obj/conf/cf-parse.tab.c"
    break;

  case 1624: /* debug_unix: DEBUG LATENCY latency_debug_mask  */
#line 208 "sysdep/unix/config.Y"
                                    { new_config->latency_debug = (yyvsp[0].i); }
#line 16044 "obj/conf/cf-parse.tab.c"
    break;

  case 1625: /* debug_unix: DEBUG LATENCY LIMIT expr_us  */
#line 209 "sysdep/unix/config.Y"
                               { new_config->latency_limit = (yyvsp[0].time); }
#line 16050 "obj/conf/cf-parse.tab.c"
    break;

  case 1626: /* debug_unix: WATCHDOG WARNING expr_us  */
#line 210 "sysdep/unix/config.Y"
                            { new_config->watchdog_warning = (yyvsp[0].time); }
#line 16056 "obj/conf/cf-parse.tab.c"
    break;

  case 1627: /* debug_unix: WATCHDOG TIMEOUT expr_us  */
#line 211 "sysdep/unix/config.Y"
                            { new_config->watchdog_timeout = ((yyvsp[0].time) + 999999) TO_S; }
#line 16062 "obj/conf/cf-parse.tab.c"
    break;

  case 1628: /* latency_debug_mask: ALL  */
#line 215 "sysdep/unix/config.Y"
       { (yyval.i) = ~0; }
#line 16068 "obj/conf/cf-parse.tab.c"
    break;

  case 1629: /* latency_debug_mask: OFF  */
#line 216 "sysdep/unix/config.Y"
       { (yyval.i) = 0; }
#line 16074 "obj/conf/cf-parse.tab.c"
    break;

  case 1630: /* latency_debug_mask: '{' latency_debug_list '}'  */
#line 217 "sysdep/unix/config.Y"
                              { (yyval.i) = (yyvsp[-1].i); }
#line 16080 "obj/conf/cf-parse.tab.c"
    break;

  case 1632: /* latency_debug_list: latency_debug_list ',' latency_debug_flag  */
#line 220 "sysdep/unix/config.Y"
                                                                                   { (yyval.i) = (yyvsp[-2].i) | (yyvsp[0].i); }
#line 16086 "obj/conf/cf-parse.tab.c"
    break;

  case 1633: /* latency_debug_flag: PING  */
#line 223 "sysdep/unix/config.Y"
                { (yyval.i) = DL_PING; }
#line 16092 "obj/conf/cf-parse.tab.c"
    break;

  case 1634: /* latency_debug_flag: WAKEUP  */
#line 224 "sysdep/unix/config.Y"
                { (yyval.i) = DL_WAKEUP; }
#line 16098 "obj/conf/cf-parse.tab.c"
    break;

  case 1635: /* latency_debug_flag: SOCKETS  */
#line 225 "sysdep/unix/config.Y"
                { (yyval.i) = DL_SOCKETS; }
#line 16104 "obj/conf/cf-parse.tab.c"
    break;

  case 1636: /* latency_debug_flag: SCHEDULING  */
#line 226 "sysdep/unix/config.Y"
                { (yyval.i) = DL_SCHEDULING; }
#line 16110 "obj/conf/cf-parse.tab.c"
    break;

  case 1637: /* latency_debug_flag: ALLOCATOR  */
#line 227 "sysdep/unix/config.Y"
                { (yyval.i) = DL_ALLOCATOR; }
#line 16116 "obj/conf/cf-parse.tab.c"
    break;

  case 1638: /* latency_debug_flag: EVENTS  */
#line 228 "sysdep/unix/config.Y"
                { (yyval.i) = DL_EVENTS; }
#line 16122 "obj/conf/cf-parse.tab.c"
    break;

  case 1639: /* latency_debug_flag: TIMERS  */
#line 229 "sysdep/unix/config.Y"
                { (yyval.i) = DL_TIMERS; }
#line 16128 "obj/conf/cf-parse.tab.c"
    break;

  case 1641: /* cmd_CONFIGURE: CONFIGURE cfg_name cfg_timeout END  */
#line 238 "sysdep/unix/config.Y"
{ cmd_reconfig((yyvsp[-2].t), RECONFIG_HARD, (yyvsp[-1].i)); }
#line 16134 "obj/conf/cf-parse.tab.c"
    break;

  case 1643: /* cmd_CONFIGURE_SOFT: CONFIGURE SOFT cfg_name cfg_timeout END  */
#line 241 "sysdep/unix/config.Y"
{ cmd_reconfig((yyvsp[-2].t), RECONFIG_SOFT, (yyvsp[-1].i)); }
#line 16140 "obj/conf/cf-parse.tab.c"
    break;

  case 1645: /* cmd_CONFIGURE_CONFIRM: CONFIGURE CONFIRM END  */
#line 248 "sysdep/unix/config.Y"
{ cmd_reconfig_confirm(); }
#line 16146 "obj/conf/cf-parse.tab.c"
    break;

  case 1647: /* cmd_CONFIGURE_UNDO: CONFIGURE UNDO END  */
#line 251 "sysdep/unix/config.Y"
{ cmd_reconfig_undo(); }
#line 16152 "obj/conf/cf-parse.tab.c"
    break;

  case 1649: /* cmd_CONFIGURE_STATUS: CONFIGURE STATUS END  */
#line 254 "sysdep/unix/config.Y"
{ cmd_reconfig_status(); }
#line 16158 "obj/conf/cf-parse.tab.c"
    break;

  case 1651: /* cmd_CONFIGURE_CHECK: CONFIGURE CHECK cfg_name END  */
#line 257 "sysdep/unix/config.Y"
{ cmd_check_config((yyvsp[-1].t)); }
#line 16164 "obj/conf/cf-parse.tab.c"
    break;

  case 1653: /* cmd_DOWN: DOWN END  */
#line 260 "sysdep/unix/config.Y"
{ cmd_shutdown(); }
#line 16170 "obj/conf/cf-parse.tab.c"
    break;

  case 1655: /* cmd_GRACEFUL_RESTART: GRACEFUL RESTART END  */
#line 265 "sysdep/unix/config.Y"
{ cmd_graceful_restart(); }
#line 16176 "obj/conf/cf-parse.tab.c"
    break;

  case 1657: /* cmd_SHOW_THREADS: SHOW THREADS END  */
#line 268 "sysdep/unix/config.Y"
{ cmd_show_threads(0); }
#line 16182 "obj/conf/cf-parse.tab.c"
    break;

  case 1659: /* cmd_SHOW_THREADS_ALL: SHOW THREADS ALL END  */
#line 271 "sysdep/unix/config.Y"
{ cmd_show_threads(1); }
#line 16188 "obj/conf/cf-parse.tab.c"
    break;

  case 1660: /* cfg_name: %empty  */
#line 274 "sysdep/unix/config.Y"
               { (yyval.t) = NULL; }
#line 16194 "obj/conf/cf-parse.tab.c"
    break;

  case 1662: /* cfg_timeout: %empty  */
#line 279 "sysdep/unix/config.Y"
               { (yyval.i) = 0; }
#line 16200 "obj/conf/cf-parse.tab.c"
    break;

  case 1663: /* cfg_timeout: TIMEOUT  */
#line 280 "sysdep/unix/config.Y"
           { (yyval.i) = UNIX_DEFAULT_CONFIGURE_TIMEOUT; }
#line 16206 "obj/conf/cf-parse.tab.c"
    break;

  case 1664: /* cfg_timeout: TIMEOUT expr  */
#line 281 "sysdep/unix/config.Y"
                { (yyval.i) = (yyvsp[0].i); }
#line 16212 "obj/conf/cf-parse.tab.c"
    break;

  case 1666: /* kern_proto_start: proto_start KERNEL  */
#line 45 "sysdep/unix/krt.Y"
                                     {
     this_proto = krt_init_config((yyvsp[-1].i));
}
#line 16220 "obj/conf/cf-parse.tab.c"
    break;

  case 1669: /* kern_learn: bool  */
#line 54 "sysdep/unix/krt.Y"
        { (yyval.i) = (yyvsp[0].i) ? KRT_LEARN_ALIEN : KRT_LEARN_NONE; }
#line 16226 "obj/conf/cf-parse.tab.c"
    break;

  case 1670: /* kern_learn: ALL  */
#line 55 "sysdep/unix/krt.Y"
        { (yyval.i) = KRT_LEARN_ALL; }
#line 16232 "obj/conf/cf-parse.tab.c"
    break;

  case 1671: /* kern_mp_limit: %empty  */
#line 59 "sysdep/unix/krt.Y"
               { (yyval.i) = KRT_DEFAULT_ECMP_LIMIT; }
#line 16238 "obj/conf/cf-parse.tab.c"
    break;

  case 1672: /* kern_mp_limit: LIMIT expr  */
#line 60 "sysdep/unix/krt.Y"
               { (yyval.i) = (yyvsp[0].i); if (((yyvsp[0].i) <= 0) || ((yyvsp[0].i) > 255)) cf_error("Merge paths limit must be in range 1-255"); }
#line 16244 "obj/conf/cf-parse.tab.c"
    break;

  case 1676: /* kern_item: kern_channel  */
#line 71 "sysdep/unix/krt.Y"
                { this_proto->net_type = (yyvsp[0].cc)->net_type; }
#line 16250 "obj/conf/cf-parse.tab.c"
    break;

  case 1677: /* kern_item: PERSIST bool  */
#line 72 "sysdep/unix/krt.Y"
                { THIS_KRT->persist = (yyvsp[0].i); }
#line 16256 "obj/conf/cf-parse.tab.c"
    break;

  case 1678: /* kern_item: SCAN TIME expr  */
#line 73 "sysdep/unix/krt.Y"
                  {
      /* Scan time of 0 means scan on startup only */
      THIS_KRT->scan_time = (yyvsp[0].i) S_;
   }
#line 16265 "obj/conf/cf-parse.tab.c"
    break;

  case 1679: /* kern_item: LEARN kern_learn  */
#line 77 "sysdep/unix/krt.Y"
                    {
      THIS_KRT->learn = (yyvsp[0].i);
#ifndef KRT_ALLOW_LEARN
      if ((yyvsp[0].i))
	cf_error("Learning of kernel routes not supported on this platform");
#endif
   }
#line 16277 "obj/conf/cf-parse.tab.c"
    break;

  case 1680: /* kern_item: GRACEFUL RESTART bool  */
#line 84 "sysdep/unix/krt.Y"
                         { THIS_KRT->graceful_restart = (yyvsp[0].i); }
#line 16283 "obj/conf/cf-parse.tab.c"
    break;

  case 1681: /* kern_item: MERGE PATHS bool kern_mp_limit  */
#line 85 "sysdep/unix/krt.Y"
                                  {
      THIS_KRT->merge_paths = (yyvsp[-1].i) ? (yyvsp[0].i) : 0;
#ifndef KRT_ALLOW_MERGE_PATHS
      if ((yyvsp[-1].i))
	cf_error("Path merging not supported on this platform");
#endif
   }
#line 16295 "obj/conf/cf-parse.tab.c"
    break;

  case 1683: /* kif_proto_start: proto_start DEVICE  */
#line 98 "sysdep/unix/krt.Y"
                                    { this_proto = kif_init_config((yyvsp[-1].i)); }
#line 16301 "obj/conf/cf-parse.tab.c"
    break;

  case 1688: /* kif_item: SCAN TIME expr  */
#line 107 "sysdep/unix/krt.Y"
                  {
      /* Scan time of 0 means scan on startup only */
      THIS_KIF->scan_time = (yyvsp[0].i) S_;
   }
#line 16310 "obj/conf/cf-parse.tab.c"
    break;

  case 1689: /* kif_iface_start: %empty  */
#line 114 "sysdep/unix/krt.Y"
{
  this_ipatt = cfg_allocz(sizeof(struct kif_iface_config));
  add_tail(&THIS_KIF->iface_list, NODE this_ipatt);
  init_list(&this_ipatt->ipn_list);
}
#line 16320 "obj/conf/cf-parse.tab.c"
    break;

  case 1690: /* kif_iface_item: PREFERRED ipa  */
#line 121 "sysdep/unix/krt.Y"
                 { kif_set_preferred((yyvsp[0].a)); }
#line 16326 "obj/conf/cf-parse.tab.c"
    break;


#line 16330 "obj/conf/cf-parse.tab.c"

        default: break;
      }
    if (yychar_backup != yychar)
      YY_LAC_DISCARD ("yychar change");
  }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yyesa, &yyes, &yyes_capacity, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        if (yychar != YYEMPTY)
          YY_LAC_ESTABLISH;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  /* If the stack popping above didn't lose the initial context for the
     current lookahead token, the shift below will for sure.  */
  YY_LAC_DISCARD ("error recovery");

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yyes != yyesa)
    YYSTACK_FREE (yyes);
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 57 "conf/gen_parser.m4"

#line 491 "conf/confbase.Y"
/* C Code from conf/confbase.Y */

#line 206 "conf/flowspec.Y"
/* C Code from conf/flowspec.Y */

#line 1043 "nest/config.Y"
/* C Code from nest/config.Y */

#line 200 "nest/mpls.Y"
/* C Code from nest/mpls.Y */

#line 149 "proto/aggregator/config.Y"
/* C Code from proto/aggregator/config.Y */

#line 271 "proto/bfd/config.Y"
/* C Code from proto/bfd/config.Y */

#line 204 "proto/babel/config.Y"
/* C Code from proto/babel/config.Y */

#line 558 "proto/bgp/config.Y"
/* C Code from proto/bgp/config.Y */

#line 99 "proto/l3vpn/config.Y"
/* C Code from proto/l3vpn/config.Y */

#line 565 "proto/ospf/config.Y"
/* C Code from proto/ospf/config.Y */

#line 58 "proto/pipe/config.Y"
/* C Code from proto/pipe/config.Y */

#line 353 "proto/radv/config.Y"
/* C Code from proto/radv/config.Y */

#line 202 "proto/rip/config.Y"
/* C Code from proto/rip/config.Y */

#line 185 "proto/rpki/config.Y"
/* C Code from proto/rpki/config.Y */

#line 206 "proto/static/config.Y"
/* C Code from proto/static/config.Y */

#line 72 "proto/mrt/config.Y"
/* C Code from proto/mrt/config.Y */

#line 82 "proto/bmp/config.Y"
/* C Code from proto/bmp/config.Y */

#line 59 "sysdep/linux/netlink.Y"
/* C Code from sysdep/linux/netlink.Y */

#line 284 "sysdep/unix/config.Y"
/* C Code from sysdep/unix/config.Y */

#line 138 "sysdep/unix/krt.Y"
/* C Code from sysdep/unix/krt.Y */

