/* FallbackFont.c generated by valac 0.56.17, the Vala compiler
 * generated from FallbackFont.vala, do not modify */

/*
Copyright (C) 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <loadfont.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BIRD_FONT_FALLBACK_FONT_TYPE_CACHE_PAIR (bird_font_fallback_font_cache_pair_get_type ())
#define BIRD_FONT_FALLBACK_FONT_CACHE_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_FALLBACK_FONT_TYPE_CACHE_PAIR, BirdFontFallbackFontCachePair))
#define BIRD_FONT_FALLBACK_FONT_CACHE_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_FALLBACK_FONT_TYPE_CACHE_PAIR, BirdFontFallbackFontCachePairClass))
#define BIRD_FONT_FALLBACK_FONT_IS_CACHE_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_FALLBACK_FONT_TYPE_CACHE_PAIR))
#define BIRD_FONT_FALLBACK_FONT_IS_CACHE_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_FALLBACK_FONT_TYPE_CACHE_PAIR))
#define BIRD_FONT_FALLBACK_FONT_CACHE_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_FALLBACK_FONT_TYPE_CACHE_PAIR, BirdFontFallbackFontCachePairClass))

typedef struct _BirdFontFallbackFontCachePair BirdFontFallbackFontCachePair;
typedef struct _BirdFontFallbackFontCachePairClass BirdFontFallbackFontCachePairClass;
enum  {
	BIRD_FONT_FALLBACK_FONT_0_PROPERTY,
	BIRD_FONT_FALLBACK_FONT_NUM_PROPERTIES
};
static GParamSpec* bird_font_fallback_font_properties[BIRD_FONT_FALLBACK_FONT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
typedef struct _Block83Data Block83Data;
typedef struct _BirdFontFallbackFontCachePairPrivate BirdFontFallbackFontCachePairPrivate;

#define BIRD_FONT_TYPE_BIRD_FONT_FILE (bird_font_bird_font_file_get_type ())
#define BIRD_FONT_BIRD_FONT_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_BIRD_FONT_FILE, BirdFontBirdFontFile))
#define BIRD_FONT_BIRD_FONT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_BIRD_FONT_FILE, BirdFontBirdFontFileClass))
#define BIRD_FONT_IS_BIRD_FONT_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_BIRD_FONT_FILE))
#define BIRD_FONT_IS_BIRD_FONT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_BIRD_FONT_FILE))
#define BIRD_FONT_BIRD_FONT_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_BIRD_FONT_FILE, BirdFontBirdFontFileClass))

typedef struct _BirdFontBirdFontFile BirdFontBirdFontFile;
typedef struct _BirdFontBirdFontFileClass BirdFontBirdFontFileClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	BIRD_FONT_FALLBACK_FONT_CACHE_PAIR_0_PROPERTY,
	BIRD_FONT_FALLBACK_FONT_CACHE_PAIR_NUM_PROPERTIES
};
static GParamSpec* bird_font_fallback_font_cache_pair_properties[BIRD_FONT_FALLBACK_FONT_CACHE_PAIR_NUM_PROPERTIES];

struct _BirdFontFallbackFontPrivate {
	GeeArrayList* font_directories;
	FreeTypeFontFace* default_font;
	gchar* default_font_file_name;
	gchar* default_font_family_name;
	GeeHashMap* glyphs;
	GeeArrayList* cached;
	gchar* default_font_file;
};

struct _Block83Data {
	int _ref_count_;
	BirdFontFallbackFont* self;
	FcConfig* config;
};

struct _BirdFontFallbackFontCachePair {
	GObject parent_instance;
	BirdFontFallbackFontCachePairPrivate * priv;
	BirdFontFont* font;
	gunichar character;
	gint referenced;
};

struct _BirdFontFallbackFontCachePairClass {
	GObjectClass parent_class;
};

static gint BirdFontFallbackFont_private_offset;
static gpointer bird_font_fallback_font_parent_class = NULL;
FcConfig* bird_font_fallback_font_font_config = NULL;
static gboolean bird_font_fallback_font_font_config_started;
static gboolean bird_font_fallback_font_font_config_started = FALSE;
static gpointer bird_font_fallback_font_cache_pair_parent_class = NULL;

static GType bird_font_fallback_font_cache_pair_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gboolean ___lambda599_ (BirdFontFallbackFont* self);
static void _bird_font_fallback_font_init_font_config_bird_font_task_runnable (gpointer self);
static gboolean ____lambda599__gsource_func (gpointer self);
static void bird_font_fallback_font_add_font_folder (BirdFontFallbackFont* self,
                                              const gchar* f);
static void bird_font_fallback_font_open_default_font (BirdFontFallbackFont* self);
static Block83Data* block83_data_ref (Block83Data* _data83_);
static void block83_data_unref (void * _userdata_);
static gboolean __lambda600_ (Block83Data* _data83_);
static gboolean ___lambda600__gsource_func (gpointer self);
static gint ___lambda7_ (BirdFontFallbackFont* self,
                  BirdFontFallbackFontCachePair* a,
                  BirdFontFallbackFontCachePair* b);
static gint ____lambda7__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static BirdFontFont* bird_font_fallback_font_get_single_fallback_glyph_font (BirdFontFallbackFont* self,
                                                                      gunichar c);
static BirdFontFallbackFontCachePair* bird_font_fallback_font_cache_pair_new (BirdFontFont* f,
                                                                       gunichar c);
static BirdFontFallbackFontCachePair* bird_font_fallback_font_cache_pair_construct (GType object_type,
                                                                             BirdFontFont* f,
                                                                             gunichar c);
VALA_EXTERN GType bird_font_bird_font_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GString* bird_font_fallback_font_get_glyph_in_font (BirdFontFallbackFont* self,
                                                    FreeTypeFontFace* font,
                                                    gunichar c);
VALA_EXTERN BirdFontBirdFontFile* bird_font_bird_font_file_new (BirdFontFont* f);
VALA_EXTERN BirdFontBirdFontFile* bird_font_bird_font_file_construct (GType object_type,
                                                          BirdFontFont* f);
VALA_EXTERN gboolean bird_font_bird_font_file_load_data (BirdFontBirdFontFile* self,
                                             const gchar* xml_data);
static GFile* bird_font_fallback_font_search_font_file (BirdFontFallbackFont* self,
                                                 const gchar* font_file);
static void bird_font_fallback_font_cache_pair_finalize (GObject * obj);
static GType bird_font_fallback_font_cache_pair_get_type_once (void);
static void bird_font_fallback_font_finalize (GObject * obj);
static GType bird_font_fallback_font_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_fallback_font_get_instance_private (BirdFontFallbackFont* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontFallbackFont_private_offset);
}

static void
_bird_font_fallback_font_init_font_config_bird_font_task_runnable (gpointer self)
{
	bird_font_fallback_font_init_font_config ((BirdFontFallbackFont*) self);
}

static gboolean
___lambda599_ (BirdFontFallbackFont* self)
{
	BirdFontTask* t = NULL;
	BirdFontTask* _tmp0_;
	BirdFontNativeWindow* _tmp1_;
	gboolean result;
	_tmp0_ = bird_font_task_new (_bird_font_fallback_font_init_font_config_bird_font_task_runnable, g_object_ref (self), g_object_unref, FALSE);
	t = _tmp0_;
	_tmp1_ = bird_font_main_window_native_window;
	bird_font_native_window_run_non_blocking_background_thread (_tmp1_, t);
	result = FALSE;
	_g_object_unref0 (t);
	return result;
}

static gboolean
____lambda599__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda599_ ((BirdFontFallbackFont*) self);
	return result;
}

BirdFontFallbackFont*
bird_font_fallback_font_construct (GType object_type)
{
	BirdFontFallbackFont * self = NULL;
	gchar* home = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GeeArrayList* _tmp2_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GeeHashMap* _tmp15_;
	GeeArrayList* _tmp16_;
	self = (BirdFontFallbackFont*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	home = _tmp1_;
	_tmp2_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->font_directories);
	self->priv->font_directories = _tmp2_;
	if (!bird_font_fallback_font_font_config_started) {
		GSource* idle = NULL;
		GSource* _tmp3_;
		GSource* _tmp4_;
		GSource* _tmp5_;
		bird_font_fallback_font_font_config_started = TRUE;
		_tmp3_ = g_idle_source_new ();
		idle = _tmp3_;
		_tmp4_ = idle;
		g_source_set_callback (_tmp4_, ____lambda599__gsource_func, g_object_ref (self), g_object_unref);
		_tmp5_ = idle;
		g_source_attach (_tmp5_, NULL);
		_g_source_unref0 (idle);
	}
	bird_font_fallback_font_add_font_folder (self, "/usr/share/fonts/");
	bird_font_fallback_font_add_font_folder (self, "/usr/local/share/fonts/");
	_tmp6_ = home;
	_tmp7_ = g_strconcat (_tmp6_, "/.local/share/fonts", NULL);
	_tmp8_ = _tmp7_;
	bird_font_fallback_font_add_font_folder (self, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = home;
	_tmp10_ = g_strconcat (_tmp9_, "/.fonts", NULL);
	_tmp11_ = _tmp10_;
	bird_font_fallback_font_add_font_folder (self, _tmp11_);
	_g_free0 (_tmp11_);
	bird_font_fallback_font_add_font_folder (self, "C:\\Windows\\Fonts");
	_tmp12_ = home;
	_tmp13_ = g_strconcat (_tmp12_, "/Library/Fonts", NULL);
	_tmp14_ = _tmp13_;
	bird_font_fallback_font_add_font_folder (self, _tmp14_);
	_g_free0 (_tmp14_);
	bird_font_fallback_font_add_font_folder (self, "/Library/Fonts");
	bird_font_fallback_font_add_font_folder (self, "/Network/Library/Fonts");
	bird_font_fallback_font_add_font_folder (self, "/System/Library/Fonts");
	bird_font_fallback_font_add_font_folder (self, "/System Folder/Fonts");
	_tmp15_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, BIRD_FONT_FALLBACK_FONT_TYPE_CACHE_PAIR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->glyphs);
	self->priv->glyphs = _tmp15_;
	_tmp16_ = gee_array_list_new (BIRD_FONT_FALLBACK_FONT_TYPE_CACHE_PAIR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->cached);
	self->priv->cached = _tmp16_;
	bird_font_fallback_font_open_default_font (self);
	_g_free0 (home);
	return self;
}

BirdFontFallbackFont*
bird_font_fallback_font_new (void)
{
	return bird_font_fallback_font_construct (BIRD_FONT_TYPE_FALLBACK_FONT);
}

static Block83Data*
block83_data_ref (Block83Data* _data83_)
{
	g_atomic_int_inc (&_data83_->_ref_count_);
	return _data83_;
}

static void
block83_data_unref (void * _userdata_)
{
	Block83Data* _data83_;
	_data83_ = (Block83Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data83_->_ref_count_)) {
		BirdFontFallbackFont* self;
		self = _data83_->self;
		_g_object_unref0 (self);
		g_slice_free (Block83Data, _data83_);
	}
}

static gboolean
__lambda600_ (Block83Data* _data83_)
{
	BirdFontFallbackFont* self;
	gboolean result;
	self = _data83_->self;
	bird_font_fallback_font_font_config = _data83_->config;
	result = FALSE;
	return result;
}

static gboolean
___lambda600__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda600_ (self);
	return result;
}

void
bird_font_fallback_font_init_font_config (BirdFontFallbackFont* self)
{
	Block83Data* _data83_;
	FcConfig* _tmp0_;
	GSource* idle = NULL;
	GSource* _tmp1_;
	g_return_if_fail (self != NULL);
	_data83_ = g_slice_new0 (Block83Data);
	_data83_->_ref_count_ = 1;
	_data83_->self = g_object_ref (self);
	_tmp0_ = FcInitLoadConfigAndFonts ();
	_data83_->config = _tmp0_;
	_tmp1_ = g_idle_source_new ();
	idle = _tmp1_;
	g_source_set_callback (idle, ___lambda600__gsource_func, block83_data_ref (_data83_), block83_data_unref);
	g_source_attach (idle, NULL);
	_g_source_unref0 (idle);
	block83_data_unref (_data83_);
	_data83_ = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
___lambda7_ (BirdFontFallbackFont* self,
             BirdFontFallbackFontCachePair* a,
             BirdFontFallbackFontCachePair* b)
{
	BirdFontFallbackFontCachePair* pa = NULL;
	BirdFontFallbackFontCachePair* _tmp0_;
	BirdFontFallbackFontCachePair* pb = NULL;
	BirdFontFallbackFontCachePair* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_FALLBACK_FONT_TYPE_CACHE_PAIR, BirdFontFallbackFontCachePair));
	pa = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_FALLBACK_FONT_TYPE_CACHE_PAIR, BirdFontFallbackFontCachePair));
	pb = _tmp1_;
	result = pb->referenced - pa->referenced;
	_g_object_unref0 (pb);
	_g_object_unref0 (pa);
	return result;
}

static gint
____lambda7__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = ___lambda7_ ((BirdFontFallbackFont*) self, (BirdFontFallbackFontCachePair*) a, (BirdFontFallbackFontCachePair*) b);
	return result;
}

BirdFontFont*
bird_font_fallback_font_get_single_glyph_font (BirdFontFallbackFont* self,
                                               gunichar c)
{
	BirdFontFont* f = NULL;
	gunichar last = 0U;
	BirdFontFallbackFontCachePair* p = NULL;
	GeeHashMap* _tmp0_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	BirdFontFont* _tmp26_;
	BirdFontFont* _tmp27_;
	BirdFontFallbackFontCachePair* _tmp28_;
	GeeHashMap* _tmp29_;
	BirdFontFallbackFontCachePair* _tmp30_;
	GeeArrayList* _tmp31_;
	BirdFontFallbackFontCachePair* _tmp32_;
	BirdFontFont* _tmp33_;
	BirdFontFont* _tmp34_;
	BirdFontFont* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->glyphs;
	if (G_LIKELY (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) c)))) {
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		BirdFontFallbackFontCachePair* _tmp3_;
		BirdFontFallbackFontCachePair* _tmp6_;
		BirdFontFont* _tmp7_;
		BirdFontFont* _tmp8_;
		_tmp1_ = self->priv->glyphs;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) c));
		_g_object_unref0 (p);
		p = (BirdFontFallbackFontCachePair*) _tmp2_;
		_tmp3_ = p;
		if (_tmp3_->referenced < G_MAXINT) {
			BirdFontFallbackFontCachePair* _tmp4_;
			gint _tmp5_;
			_tmp4_ = p;
			_tmp5_ = _tmp4_->referenced;
			_tmp4_->referenced = _tmp5_ + 1;
		}
		_tmp6_ = p;
		_tmp7_ = _tmp6_->font;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		result = _tmp8_;
		_g_object_unref0 (p);
		_g_object_unref0 (f);
		return result;
	}
	_tmp9_ = self->priv->cached;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ > (self->max_cached_fonts - 100)) {
		GeeArrayList* _tmp12_;
		gint j = 0;
		_tmp12_ = self->priv->cached;
		gee_list_sort ((GeeList*) _tmp12_, ____lambda7__gcompare_data_func, g_object_ref (self), g_object_unref);
		j = 0;
		{
			gint i = 0;
			GeeArrayList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp13_ = self->priv->cached;
			_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			i = _tmp15_ - 1;
			{
				gboolean _tmp16_ = FALSE;
				_tmp16_ = TRUE;
				while (TRUE) {
					gint _tmp18_;
					GeeArrayList* _tmp19_;
					gpointer _tmp20_;
					BirdFontFallbackFontCachePair* _tmp21_;
					GeeHashMap* _tmp22_;
					GeeArrayList* _tmp23_;
					gpointer _tmp24_;
					BirdFontFallbackFontCachePair* _tmp25_;
					if (!_tmp16_) {
						gint _tmp17_;
						_tmp17_ = i;
						i = _tmp17_ - 1;
					}
					_tmp16_ = FALSE;
					if (!(i > 0)) {
						break;
					}
					if (j > 100) {
						break;
					}
					_tmp18_ = j;
					j = _tmp18_ + 1;
					_tmp19_ = self->priv->cached;
					_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, i);
					_tmp21_ = (BirdFontFallbackFontCachePair*) _tmp20_;
					last = _tmp21_->character;
					_g_object_unref0 (_tmp21_);
					_tmp22_ = self->priv->glyphs;
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp22_, (gpointer) ((gintptr) last), NULL);
					_tmp23_ = self->priv->cached;
					_tmp24_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp23_, i);
					_tmp25_ = (BirdFontFallbackFontCachePair*) _tmp24_;
					_g_object_unref0 (_tmp25_);
				}
			}
		}
	}
	_tmp26_ = bird_font_fallback_font_get_single_fallback_glyph_font (self, c);
	_g_object_unref0 (f);
	f = _tmp26_;
	_tmp27_ = f;
	_tmp28_ = bird_font_fallback_font_cache_pair_new (_tmp27_, c);
	_g_object_unref0 (p);
	p = _tmp28_;
	_tmp29_ = self->priv->glyphs;
	_tmp30_ = p;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, (gpointer) ((gintptr) c), _tmp30_);
	_tmp31_ = self->priv->cached;
	_tmp32_ = p;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, _tmp32_);
	_tmp33_ = f;
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, BIRD_FONT_TYPE_FONT, BirdFontFont));
	result = _tmp34_;
	_g_object_unref0 (p);
	_g_object_unref0 (f);
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static BirdFontFont*
bird_font_fallback_font_get_single_fallback_glyph_font (BirdFontFallbackFont* self,
                                                        gunichar c)
{
	gchar* font_file = NULL;
	BirdFontBirdFontFile* bf_parser = NULL;
	BirdFontFont* bf_font = NULL;
	GString* glyph_data = NULL;
	FreeTypeFontFace* font = NULL;
	BirdFontFont* _tmp0_;
	gunichar _tmp1_;
	gboolean _tmp2_ = FALSE;
	FreeTypeFontFace* _tmp4_;
	GString* _tmp7_;
	GString* _tmp18_;
	BirdFontFont* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_font_new ();
	_g_object_unref0 (bf_font);
	bf_font = _tmp0_;
	_g_free0 (font_file);
	font_file = NULL;
	_g_string_free0 (glyph_data);
	glyph_data = NULL;
	_tmp1_ = c;
	if ((((gunichar) 0xe000) <= _tmp1_) && (_tmp1_ <= ((gunichar) 0xf8ff))) {
		result = bf_font;
		_g_string_free0 (glyph_data);
		_g_object_unref0 (bf_parser);
		_g_free0 (font_file);
		return result;
	}
	if (c <= ((gunichar) 0x001f)) {
		_tmp2_ = TRUE;
	} else {
		gunichar _tmp3_;
		_tmp3_ = c;
		_tmp2_ = (((gunichar) 0x007f) <= _tmp3_) && (_tmp3_ <= ((gunichar) 0x008d));
	}
	if (_tmp2_) {
		result = bf_font;
		_g_string_free0 (glyph_data);
		_g_object_unref0 (bf_parser);
		_g_free0 (font_file);
		return result;
	}
	_tmp4_ = self->priv->default_font;
	if (_tmp4_ != NULL) {
		FreeTypeFontFace* _tmp5_;
		GString* _tmp6_;
		_tmp5_ = self->priv->default_font;
		_tmp6_ = bird_font_fallback_font_get_glyph_in_font (self, (FreeTypeFontFace*) _tmp5_, c);
		_g_string_free0 (glyph_data);
		glyph_data = _tmp6_;
	}
	_tmp7_ = glyph_data;
	if (_tmp7_ == NULL) {
		FcConfig* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = bird_font_fallback_font_font_config;
		_tmp9_ = g_unichar_to_string (c);
		_tmp10_ = (gchar*) _tmp9_;
		_tmp11_ = find_font (_tmp8_, _tmp10_);
		_g_free0 (font_file);
		font_file = _tmp11_;
		_g_free0 (_tmp10_);
		_tmp12_ = font_file;
		if (_tmp12_ != NULL) {
			const gchar* _tmp13_;
			FreeTypeFontFace* _tmp14_;
			FreeTypeFontFace* _tmp15_;
			GString* _tmp16_;
			FreeTypeFontFace* _tmp17_;
			_tmp13_ = font_file;
			_tmp14_ = open_font ((const gchar*) _tmp13_);
			font = _tmp14_;
			_tmp15_ = font;
			_tmp16_ = bird_font_fallback_font_get_glyph_in_font (self, _tmp15_, c);
			_g_string_free0 (glyph_data);
			glyph_data = _tmp16_;
			_tmp17_ = font;
			close_ft_font (_tmp17_);
		}
	}
	_tmp18_ = glyph_data;
	if (_tmp18_ != NULL) {
		BirdFontFont* _tmp19_;
		BirdFontBirdFontFile* _tmp20_;
		BirdFontBirdFontFile* _tmp21_;
		GString* _tmp22_;
		const gchar* _tmp23_;
		_tmp19_ = bf_font;
		_tmp20_ = bird_font_bird_font_file_new (_tmp19_);
		_g_object_unref0 (bf_parser);
		bf_parser = _tmp20_;
		_tmp21_ = bf_parser;
		_tmp22_ = glyph_data;
		_tmp23_ = ((GString*) _tmp22_)->str;
		bird_font_bird_font_file_load_data (_tmp21_, _tmp23_);
	}
	result = bf_font;
	_g_string_free0 (glyph_data);
	_g_object_unref0 (bf_parser);
	_g_free0 (font_file);
	return result;
}

GString*
bird_font_fallback_font_get_glyph_in_font (BirdFontFallbackFont* self,
                                           FreeTypeFontFace* font,
                                           gunichar c)
{
	GString* glyph_data = NULL;
	BirdFontGlyphCollection* gc = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	BirdFontGlyphCollection* _tmp2_;
	GString* _tmp3_;
	GString* result;
	g_return_val_if_fail (self != NULL, NULL);
	glyph_data = NULL;
	_tmp0_ = g_unichar_to_string (c);
	_tmp1_ = (gchar*) _tmp0_;
	_tmp2_ = bird_font_glyph_collection_new (c, _tmp1_);
	_g_object_unref0 (gc);
	gc = _tmp2_;
	_g_free0 (_tmp1_);
	_tmp3_ = load_glyph (font, (guint) c);
	_g_string_free0 (glyph_data);
	glyph_data = _tmp3_;
	result = glyph_data;
	_g_object_unref0 (gc);
	return result;
}

static void
bird_font_fallback_font_add_font_folder (BirdFontFallbackFont* self,
                                         const gchar* f)
{
	GFile* folder = NULL;
	GFile* _tmp0_;
	GFileInfo* file_info = NULL;
	gchar* fn = NULL;
	gchar* file_attributes = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	_tmp0_ = g_file_new_for_path (f);
	folder = _tmp0_;
	{
		GFile* _tmp1_;
		_tmp1_ = folder;
		if (g_file_query_exists (_tmp1_, NULL)) {
			GeeArrayList* _tmp2_;
			GFile* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			GFileEnumerator* enumerator = NULL;
			GFile* _tmp9_;
			const gchar* _tmp10_;
			GFileEnumerator* _tmp11_;
			_tmp2_ = self->priv->font_directories;
			_tmp3_ = folder;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _tmp3_);
			_tmp4_ = g_strdup (G_FILE_ATTRIBUTE_STANDARD_NAME);
			_g_free0 (file_attributes);
			file_attributes = _tmp4_;
			_tmp5_ = file_attributes;
			_tmp6_ = g_strconcat (_tmp5_, ",", NULL);
			_g_free0 (file_attributes);
			file_attributes = _tmp6_;
			_tmp7_ = file_attributes;
			_tmp8_ = g_strconcat (_tmp7_, G_FILE_ATTRIBUTE_STANDARD_TYPE, NULL);
			_g_free0 (file_attributes);
			file_attributes = _tmp8_;
			_tmp9_ = folder;
			_tmp10_ = file_attributes;
			_tmp11_ = g_file_enumerate_children (_tmp9_, _tmp10_, 0, NULL, &_inner_error0_);
			enumerator = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			while (TRUE) {
				GFileInfo* _tmp12_ = NULL;
				GFileEnumerator* _tmp13_;
				GFileInfo* _tmp14_;
				GFileInfo* _tmp15_;
				GFileInfo* _tmp16_;
				GFileInfo* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				GFileInfo* _tmp20_;
				_tmp13_ = enumerator;
				_tmp14_ = g_file_enumerator_next_file (_tmp13_, NULL, &_inner_error0_);
				_tmp12_ = _tmp14_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (enumerator);
					goto __catch0_g_error;
				}
				_tmp15_ = _tmp12_;
				_tmp12_ = NULL;
				_g_object_unref0 (file_info);
				file_info = _tmp15_;
				_tmp16_ = file_info;
				if (!(_tmp16_ != NULL)) {
					_g_object_unref0 (_tmp12_);
					break;
				}
				_tmp17_ = file_info;
				_tmp18_ = g_file_info_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, g_file_info_get_type (), GFileInfo));
				_tmp19_ = g_strdup (_tmp18_);
				_g_free0 (fn);
				fn = _tmp19_;
				_tmp20_ = file_info;
				if (g_file_info_get_file_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, g_file_info_get_type (), GFileInfo)) == G_FILE_TYPE_DIRECTORY) {
					GFile* _tmp21_;
					const gchar* _tmp22_;
					GFile* _tmp23_;
					GFile* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp21_ = folder;
					_tmp22_ = fn;
					_tmp23_ = bird_font_get_child (_tmp21_, _tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_file_get_path (_tmp24_);
					_tmp26_ = (gchar*) _tmp25_;
					bird_font_fallback_font_add_font_folder (self, _tmp26_);
					_g_free0 (_tmp26_);
					_g_object_unref0 (_tmp24_);
				}
				_g_object_unref0 (_tmp12_);
			}
			_g_object_unref0 (enumerator);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		g_warning ("FallbackFont.vala:265: %s", _tmp28_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (file_attributes);
		_g_free0 (fn);
		_g_object_unref0 (file_info);
		_g_object_unref0 (folder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (file_attributes);
	_g_free0 (fn);
	_g_object_unref0 (file_info);
	_g_object_unref0 (folder);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static GFile*
bird_font_fallback_font_search_font_file (BirdFontFallbackFont* self,
                                          const gchar* font_file)
{
	GFile* d = NULL;
	GFile* f = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (font_file != NULL, NULL);
	{
		gint i = 0;
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = self->priv->font_directories;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		i = _tmp2_ - 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp5_;
				gpointer _tmp6_;
				GFile* _tmp7_;
				GFile* _tmp8_;
				GFile* _tmp9_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ - 1;
				}
				_tmp3_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp5_ = self->priv->font_directories;
				_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, i);
				_g_object_unref0 (d);
				d = (GFile*) _tmp6_;
				_tmp7_ = d;
				_tmp8_ = bird_font_get_child (_tmp7_, font_file);
				_g_object_unref0 (f);
				f = _tmp8_;
				_tmp9_ = f;
				if (g_file_query_exists (_tmp9_, NULL)) {
					result = f;
					_g_object_unref0 (d);
					return result;
				}
			}
		}
	}
	_tmp10_ = string_to_string (font_file);
	_tmp11_ = g_strconcat ("The font ", _tmp10_, " not found", NULL);
	_tmp12_ = _tmp11_;
	g_warning ("FallbackFont.vala:281: %s", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = g_file_new_for_path (font_file);
	result = _tmp13_;
	_g_object_unref0 (f);
	_g_object_unref0 (d);
	return result;
}

gchar*
bird_font_fallback_font_get_default_font_file (BirdFontFallbackFont* self)
{
	GFile* font_file = NULL;
	gchar* fn = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	const gchar* _tmp16_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	fn = NULL;
	_tmp0_ = self->priv->default_font_file;
	if (G_LIKELY (_tmp0_ != NULL)) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->default_font_file;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		_g_free0 (fn);
		_g_object_unref0 (font_file);
		return result;
	}
	_tmp3_ = self->priv->default_font_file_name;
	_tmp4_ = bird_font_search_paths_search_file (NULL, _tmp3_);
	_g_object_unref0 (font_file);
	font_file = _tmp4_;
	_tmp5_ = font_file;
	if (g_file_query_exists (_tmp5_, NULL)) {
		GFile* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = font_file;
		_tmp7_ = g_file_get_path (_tmp6_);
		_g_free0 (fn);
		fn = (gchar*) _tmp7_;
	} else {
		const gchar* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		_tmp8_ = self->priv->default_font_file_name;
		_tmp9_ = bird_font_fallback_font_search_font_file (self, _tmp8_);
		_g_object_unref0 (font_file);
		font_file = _tmp9_;
		_tmp10_ = font_file;
		if (g_file_query_exists (_tmp10_, NULL)) {
			GFile* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = font_file;
			_tmp12_ = g_file_get_path (_tmp11_);
			_g_free0 (fn);
			fn = (gchar*) _tmp12_;
		} else {
			FcConfig* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp13_ = bird_font_fallback_font_font_config;
			_tmp14_ = self->priv->default_font_family_name;
			_tmp15_ = find_font_file (_tmp13_, _tmp14_);
			_g_free0 (fn);
			fn = _tmp15_;
		}
	}
	_tmp16_ = fn;
	if (G_LIKELY (_tmp16_ != NULL)) {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp17_ = fn;
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (self->priv->default_font_file);
		self->priv->default_font_file = _tmp18_;
		result = fn;
		_g_object_unref0 (font_file);
		return result;
	}
	_tmp19_ = self->priv->default_font_family_name;
	_tmp20_ = g_strconcat (_tmp19_, " not found", NULL);
	_tmp21_ = _tmp20_;
	g_warning ("FallbackFont.vala:312: %s", _tmp21_);
	_g_free0 (_tmp21_);
	result = NULL;
	_g_free0 (fn);
	_g_object_unref0 (font_file);
	return result;
}

static void
bird_font_fallback_font_open_default_font (BirdFontFallbackFont* self)
{
	gchar* fn = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_fallback_font_get_default_font_file (self);
	fn = _tmp0_;
	_tmp1_ = fn;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		FreeTypeFontFace* _tmp3_;
		_tmp2_ = fn;
		_tmp3_ = open_font ((const gchar*) _tmp2_);
		self->priv->default_font = _tmp3_;
	}
	_g_free0 (fn);
}

static BirdFontFallbackFontCachePair*
bird_font_fallback_font_cache_pair_construct (GType object_type,
                                              BirdFontFont* f,
                                              gunichar c)
{
	BirdFontFallbackFontCachePair * self = NULL;
	BirdFontFont* _tmp0_;
	g_return_val_if_fail (f != NULL, NULL);
	self = (BirdFontFallbackFontCachePair*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (f);
	_g_object_unref0 (self->font);
	self->font = _tmp0_;
	self->character = c;
	return self;
}

static BirdFontFallbackFontCachePair*
bird_font_fallback_font_cache_pair_new (BirdFontFont* f,
                                        gunichar c)
{
	return bird_font_fallback_font_cache_pair_construct (BIRD_FONT_FALLBACK_FONT_TYPE_CACHE_PAIR, f, c);
}

static void
bird_font_fallback_font_cache_pair_class_init (BirdFontFallbackFontCachePairClass * klass,
                                               gpointer klass_data)
{
	bird_font_fallback_font_cache_pair_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = bird_font_fallback_font_cache_pair_finalize;
}

static void
bird_font_fallback_font_cache_pair_instance_init (BirdFontFallbackFontCachePair * self,
                                                  gpointer klass)
{
	self->referenced = 1;
}

static void
bird_font_fallback_font_cache_pair_finalize (GObject * obj)
{
	BirdFontFallbackFontCachePair * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_FALLBACK_FONT_TYPE_CACHE_PAIR, BirdFontFallbackFontCachePair);
	_g_object_unref0 (self->font);
	G_OBJECT_CLASS (bird_font_fallback_font_cache_pair_parent_class)->finalize (obj);
}

static GType
bird_font_fallback_font_cache_pair_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontFallbackFontCachePairClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_fallback_font_cache_pair_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontFallbackFontCachePair), 0, (GInstanceInitFunc) bird_font_fallback_font_cache_pair_instance_init, NULL };
	GType bird_font_fallback_font_cache_pair_type_id;
	bird_font_fallback_font_cache_pair_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontFallbackFontCachePair", &g_define_type_info, 0);
	return bird_font_fallback_font_cache_pair_type_id;
}

static GType
bird_font_fallback_font_cache_pair_get_type (void)
{
	static volatile gsize bird_font_fallback_font_cache_pair_type_id__once = 0;
	if (g_once_init_enter (&bird_font_fallback_font_cache_pair_type_id__once)) {
		GType bird_font_fallback_font_cache_pair_type_id;
		bird_font_fallback_font_cache_pair_type_id = bird_font_fallback_font_cache_pair_get_type_once ();
		g_once_init_leave (&bird_font_fallback_font_cache_pair_type_id__once, bird_font_fallback_font_cache_pair_type_id);
	}
	return bird_font_fallback_font_cache_pair_type_id__once;
}

static void
bird_font_fallback_font_class_init (BirdFontFallbackFontClass * klass,
                                    gpointer klass_data)
{
	bird_font_fallback_font_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontFallbackFont_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_fallback_font_finalize;
}

static void
bird_font_fallback_font_instance_init (BirdFontFallbackFont * self,
                                       gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = bird_font_fallback_font_get_instance_private (self);
	self->priv->default_font = NULL;
	_tmp0_ = g_strdup ("Roboto-Regular.ttf");
	self->priv->default_font_file_name = _tmp0_;
	_tmp1_ = g_strdup ("Roboto");
	self->priv->default_font_family_name = _tmp1_;
	self->max_cached_fonts = 300;
	self->priv->default_font_file = NULL;
}

static void
bird_font_fallback_font_finalize (GObject * obj)
{
	BirdFontFallbackFont * self;
	FreeTypeFontFace* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_FALLBACK_FONT, BirdFontFallbackFont);
	_tmp0_ = self->priv->default_font;
	if (_tmp0_ != NULL) {
		FreeTypeFontFace* _tmp1_;
		_tmp1_ = self->priv->default_font;
		close_ft_font (_tmp1_);
	}
	_g_object_unref0 (self->priv->font_directories);
	_g_free0 (self->priv->default_font_file_name);
	_g_free0 (self->priv->default_font_family_name);
	_g_object_unref0 (self->priv->glyphs);
	_g_object_unref0 (self->priv->cached);
	_g_free0 (self->priv->default_font_file);
	G_OBJECT_CLASS (bird_font_fallback_font_parent_class)->finalize (obj);
}

static GType
bird_font_fallback_font_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontFallbackFontClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_fallback_font_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontFallbackFont), 0, (GInstanceInitFunc) bird_font_fallback_font_instance_init, NULL };
	GType bird_font_fallback_font_type_id;
	bird_font_fallback_font_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontFallbackFont", &g_define_type_info, 0);
	BirdFontFallbackFont_private_offset = g_type_add_instance_private (bird_font_fallback_font_type_id, sizeof (BirdFontFallbackFontPrivate));
	return bird_font_fallback_font_type_id;
}

GType
bird_font_fallback_font_get_type (void)
{
	static volatile gsize bird_font_fallback_font_type_id__once = 0;
	if (g_once_init_enter (&bird_font_fallback_font_type_id__once)) {
		GType bird_font_fallback_font_type_id;
		bird_font_fallback_font_type_id = bird_font_fallback_font_get_type_once ();
		g_once_init_leave (&bird_font_fallback_font_type_id__once, bird_font_fallback_font_type_id);
	}
	return bird_font_fallback_font_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

