/* dialog.c generated by valac 0.56.18, the Vala compiler
 * generated from dialog.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and creates the dialog
* menus like the Preference Dialog
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <math.h>

#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOK_CONTEXTMENU_HEADER _ ("Edit Info for")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOK_CONTEXTMENU_UPDATE_COVER _ ("Update Cover Image")
#define BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "/com/github/babluboy/bookworm/"
#define BOOKWORM_APP_CONSTANTS_UPDATE_IMAGE_ICON_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-insert-image.svg"
#define BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_UPDATING_COVER_IMAGE _ ("Update cover image")
#define BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS 12
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOK_CONTEXTMENU_UPDATE_TITLE _ ("Update Title")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE _ ("Unknown Book")
#define BOOKWORM_APP_CONSTANTS_MAX_NUMBER_OF_CHARS_FOR_BOOK_TITLE 18
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOK_CONTEXTMENU_UPDATE_AUTHOR _ ("Update Author")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOK_CONTEXTMENU_UPDATE_TAGS _ ("Update Tags")
#define BOOKWORM_APP_CONSTANTS_RATING_NONE_IMAGE_ICON_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-help-about-symbolic.svg"
#define BOOKWORM_APP_CONSTANTS_RATING_SELECTED_IMAGE_ICON_LOCATION BOOKWORM_APP_CONSTANTS_RESOURCE_PREFIX "16-bookworm-help-about.svg"
#define BOOKWORM_APP_CONSTANTS_SPACING_BUTTONS 6
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_DIALOG_TITLE _ ("Preferences")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_LOCAL_STORAGE _ ("Enable cache (opens books faster)")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_COLOUR_SCHEME _ ("Turn on Dark Mode")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_TWO_PAGE _ ("Enable two page reading")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_SKIP_LIBRARY _ ("Always show library on startup")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_FONT _ ("Select Font")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PROFILE_CUSTOMIZATION _ ("Customize reading profile")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PROFILE_CUSTOMIZATION_BACKGROUND_COLOR _ ("Background")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PROFILE_CUSTOMIZATION_FONT_COLOR _ ("Text")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PROFILE_CUSTOMIZATION_HIGHLIGHT_COLOR _ ("Highlight")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_VALUES_RESET _ ("Reset to default values")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_BOOKS_DISCOVERY _ ("Add folders to scan for books")
#define BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_ADD_DIRECTORY _ ("Add folder to scan for books")
#define BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_REMOVE_DIRECTORY _ ("Remove displayed folder from book scan")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_LIBRARY_PAGE_ITEMS _ ("Number of books per page on library")
#define BOOKWORM_APP_CONSTANTS_TEXT_BOOK_DISCOVERY_TOAST _ ("Discovery of books will be started when Bookworm is closed")
#define BOOKWORM_APP_CONSTANTS_bookworm_id "com.github.babluboy.bookworm"
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_ANNOTATION _ ("Edit annotation for:")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_ANNOTATION_TAG _ ("Annotation Tags")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_ANNOTATION_TAG_ENTRY _ ("Comma-separated tags for this annotation")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_APP_DIALOG (bookworm_app_app_dialog_get_type ())
#define BOOKWORM_APP_APP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_APP_DIALOG, BookwormAppAppDialog))
#define BOOKWORM_APP_APP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_APP_DIALOG, BookwormAppAppDialogClass))
#define BOOKWORM_APP_IS_APP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_APP_DIALOG))
#define BOOKWORM_APP_IS_APP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_APP_DIALOG))
#define BOOKWORM_APP_APP_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_APP_DIALOG, BookwormAppAppDialogClass))

typedef struct _BookwormAppAppDialog BookwormAppAppDialog;
typedef struct _BookwormAppAppDialogClass BookwormAppAppDialogClass;
typedef struct _BookwormAppAppDialogPrivate BookwormAppAppDialogPrivate;
enum  {
	BOOKWORM_APP_APP_DIALOG_0_PROPERTY,
	BOOKWORM_APP_APP_DIALOG_NUM_PROPERTIES
};
static GParamSpec* bookworm_app_app_dialog_properties[BOOKWORM_APP_APP_DIALOG_NUM_PROPERTIES];

#define BOOKWORM_APP_TYPE_SETTINGS (bookworm_app_settings_get_type ())
#define BOOKWORM_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings))
#define BOOKWORM_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))
#define BOOKWORM_APP_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))

typedef struct _BookwormAppSettings BookwormAppSettings;
typedef struct _BookwormAppSettingsClass BookwormAppSettingsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))
typedef struct _Block16Data Block16Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block17Data Block17Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block18Data Block18Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block19Data Block19Data;

struct _BookwormAppAppDialog {
	GtkDialog parent_instance;
	BookwormAppAppDialogPrivate * priv;
};

struct _BookwormAppAppDialogClass {
	GtkDialogClass parent_class;
};

struct _Block16Data {
	int _ref_count_;
	GtkEntry* updateTitleEntry;
	GtkEntry* updateAuthorEntry;
	GtkEntry* updateTagsEntry;
	GeeArrayList* bookRatingList;
	BookwormAppBook* aBook;
};

struct _Block17Data {
	int _ref_count_;
	Block16Data * _data16_;
	GtkButton* rating_star_button;
};

struct _Block18Data {
	int _ref_count_;
	GtkSwitch* localStorageSwitch;
	GtkSwitch* nightModeSwitch;
	GtkSwitch* twoPageViewSwitch;
	GtkSwitch* showLibraryAtStartSwitch;
	GtkFontButton* fontButton;
	GtkColorButton* backgroundColourButton;
	GtkColorButton* textColourButton;
	GtkColorButton* highlightColourButton;
	GdkRGBA aRGBATextColor;
	GdkRGBA aRGBABackgroundColor;
	GdkRGBA aRGBAHighlightColor;
	GtkEntry* libraryPageItemsEntry;
	GraniteWidgetsToast* dialog_toast;
};

struct _Block19Data {
	int _ref_count_;
	BookwormAppBook* aBook;
	GtkTextView* annotationsInputTextView;
	GtkEntry* annotationTagEntry;
	gchar* textForAnnotation;
};

static gpointer bookworm_app_app_dialog_parent_class = NULL;
VALA_EXTERN GtkComboBoxText* bookworm_app_app_dialog_profileCombobox;
GtkComboBoxText* bookworm_app_app_dialog_profileCombobox = NULL;
VALA_EXTERN GtkComboBoxText* bookworm_app_app_dialog_directoryComboBox;
GtkComboBoxText* bookworm_app_app_dialog_directoryComboBox = NULL;
VALA_EXTERN GString* bookworm_app_app_dialog_scanDirList;
GString* bookworm_app_app_dialog_scanDirList = NULL;
VALA_EXTERN BookwormAppSettings* bookworm_app_app_dialog_settings;
BookwormAppSettings* bookworm_app_app_dialog_settings = NULL;
VALA_EXTERN BookwormAppSettings* bookworm_app_bookworm_settings;
VALA_EXTERN GtkApplicationWindow* bookworm_app_bookworm_window;
VALA_EXTERN GtkFlowBox* bookworm_app_app_window_library_grid;
VALA_EXTERN GeeHashMap* bookworm_app_bookworm_libraryViewMap;
VALA_EXTERN gchar** bookworm_app_bookworm_profileColorList;
VALA_EXTERN gint bookworm_app_bookworm_profileColorList_length1;
VALA_EXTERN GtkImage* bookworm_app_bookworm_add_scan_directory_image;
VALA_EXTERN GtkImage* bookworm_app_bookworm_remove_scan_directory_image;
VALA_EXTERN GtkCssProvider* bookworm_app_bookworm_cssProvider;
VALA_EXTERN gchar* bookworm_app_bookworm_locationOfEBookCurrentlyRead;

VALA_EXTERN GType bookworm_app_app_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppAppDialog, g_object_unref)
VALA_EXTERN GType bookworm_app_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppSettings, g_object_unref)
VALA_EXTERN BookwormAppAppDialog* bookworm_app_app_dialog_new (void);
VALA_EXTERN BookwormAppAppDialog* bookworm_app_app_dialog_construct (GType object_type);
VALA_EXTERN BookwormAppSettings* bookworm_app_settings_get_instance (void);
VALA_EXTERN const gchar* bookworm_app_settings_get_list_of_scan_dirs (BookwormAppSettings* self);
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN GtkPopover* bookworm_app_app_dialog_createBookContextMenu (BookwormAppBook* aBook);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
VALA_EXTERN gchar* bookworm_app_book_getBookLocation (BookwormAppBook* self);
VALA_EXTERN GtkWidget* bookworm_app_book_getBookWidget (BookwormAppBook* self,
                                            const gchar* name);
VALA_EXTERN gchar* bookworm_app_book_getBookTitle (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_utils_minimizeStringLength (const gchar* originalString,
                                                gint maxLength);
static void __lambda8_ (Block16Data* _data16_);
VALA_EXTERN GeeArrayList* bookworm_app_utils_selectFileChooser (GtkFileChooserAction action,
                                                    const gchar* title,
                                                    GtkWindow* parent,
                                                    gboolean select_multiple,
                                                    const gchar* filterType);
VALA_EXTERN BookwormAppBook* bookworm_app_utils_setBookCoverImage (BookwormAppBook* aBook,
                                                       const gchar* bookCoverImageLocation);
VALA_EXTERN void bookworm_app_book_setWasBookOpened (BookwormAppBook* self,
                                         gboolean aWasBookOpened);
VALA_EXTERN gchar* bookworm_app_book_getBookCoverLocation (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookWidget (BookwormAppBook* self,
                                      const gchar* name,
                                      GtkWidget* aWidget);
VALA_EXTERN void bookworm_app_library_replaceCoverImageOnBook (BookwormAppBook* book);
VALA_EXTERN void bookworm_app_bookworm_toggleUIState (void);
static void ___lambda8__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
VALA_EXTERN gchar* bookworm_app_utils_parseMarkUp (const gchar* inputString);
static gboolean __lambda10_ (Block16Data* _data16_);
VALA_EXTERN void bookworm_app_book_setBookTitle (BookwormAppBook* self,
                                     const gchar* aBookTitle);
VALA_EXTERN gboolean bookworm_app_book_getIsBookCoverImagePresent (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_utils_breakString (const gchar* originalString,
                                       gint breakLength,
                                       const gchar* breakString);
static gboolean ___lambda10__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                  GdkEventFocus* event,
                                                  gpointer self);
VALA_EXTERN gchar* bookworm_app_book_getBookAuthor (BookwormAppBook* self);
static gboolean __lambda11_ (Block16Data* _data16_);
VALA_EXTERN void bookworm_app_book_setBookAuthor (BookwormAppBook* self,
                                      const gchar* aBookAuthor);
static gboolean ___lambda11__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                  GdkEventFocus* event,
                                                  gpointer self);
VALA_EXTERN gchar* bookworm_app_book_getBookTags (BookwormAppBook* self);
static gboolean __lambda12_ (Block16Data* _data16_);
VALA_EXTERN void bookworm_app_book_setBookTags (BookwormAppBook* self,
                                    const gchar* aBookTags);
static gboolean ___lambda12__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                  GdkEventFocus* event,
                                                  gpointer self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void _____lambda13_ (Block17Data* _data17_);
VALA_EXTERN void bookworm_app_book_setBookRating (BookwormAppBook* self,
                                      gint aBookRating);
static void ______lambda13__gtk_button_clicked (GtkButton* _sender,
                                         gpointer self);
VALA_EXTERN gint bookworm_app_book_getBookRating (BookwormAppBook* self);
static void __lambda14_ (Block16Data* _data16_);
static void ___lambda14__gtk_popover_closed (GtkPopover* _sender,
                                      gpointer self);
VALA_EXTERN void bookworm_app_app_dialog_createPreferencesDialog (void);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
VALA_EXTERN gboolean bookworm_app_settings_get_is_local_storage_enabled (BookwormAppSettings* self);
VALA_EXTERN gboolean bookworm_app_settings_get_is_dark_theme_enabled (BookwormAppSettings* self);
VALA_EXTERN gboolean bookworm_app_settings_get_is_two_page_enabled (BookwormAppSettings* self);
VALA_EXTERN gboolean bookworm_app_settings_get_is_show_library_on_start (BookwormAppSettings* self);
VALA_EXTERN gboolean bookworm_app_app_dialog_filterFont (PangoFontFamily* family,
                                             PangoFontFace* face);
static gboolean _bookworm_app_app_dialog_filterFont_gtk_font_filter_func (PangoFontFamily* family,
                                                                   PangoFontFace* face,
                                                                   gpointer self);
VALA_EXTERN const gchar* bookworm_app_settings_get_reading_font_name (BookwormAppSettings* self);
VALA_EXTERN gint bookworm_app_settings_get_library_page_items (BookwormAppSettings* self);
static void __lambda15_ (Block18Data* _data18_);
VALA_EXTERN void bookworm_app_settings_set_reading_font_name (BookwormAppSettings* self,
                                                  const gchar* value);
VALA_EXTERN void bookworm_app_settings_set_reading_font_name_family (BookwormAppSettings* self,
                                                         const gchar* value);
VALA_EXTERN void bookworm_app_settings_set_reading_font_size (BookwormAppSettings* self,
                                                  gint value);
VALA_EXTERN void bookworm_app_content_handler_refreshCurrentPage (void);
static void ___lambda15__gtk_font_button_font_set (GtkFontButton* _sender,
                                            gpointer self);
static void __lambda16_ (Block18Data* _data18_);
VALA_EXTERN void bookworm_app_settings_set_is_local_storage_enabled (BookwormAppSettings* self,
                                                         gboolean value);
static void ___lambda16__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda17_ (Block18Data* _data18_);
VALA_EXTERN void bookworm_app_settings_set_is_show_library_on_start (BookwormAppSettings* self,
                                                         gboolean value);
static void ___lambda17__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda18_ (Block18Data* _data18_);
VALA_EXTERN void bookworm_app_settings_set_is_two_page_enabled (BookwormAppSettings* self,
                                                    gboolean value);
static void ___lambda18__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda19_ (Block18Data* _data18_);
VALA_EXTERN void bookworm_app_settings_set_is_dark_theme_enabled (BookwormAppSettings* self,
                                                      gboolean value);
VALA_EXTERN void bookworm_app_settings_set_reading_profile (BookwormAppSettings* self,
                                                const gchar* value);
static void ___lambda19__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda20_ (Block18Data* _data18_);
static void ___lambda20__gtk_combo_box_changed (GtkComboBox* _sender,
                                         gpointer self);
static void __lambda21_ (Block18Data* _data18_);
VALA_EXTERN gchar* bookworm_app_app_dialog_rgba_to_hex (GdkRGBA* color,
                                            gboolean alpha,
                                            gboolean prefix_hash);
VALA_EXTERN void bookworm_app_app_dialog_updateProfileColorToSettings (void);
static void ___lambda21__gtk_color_button_color_set (GtkColorButton* _sender,
                                              gpointer self);
static void __lambda22_ (Block18Data* _data18_);
static void ___lambda22__gtk_color_button_color_set (GtkColorButton* _sender,
                                              gpointer self);
static void __lambda23_ (Block18Data* _data18_);
static void ___lambda23__gtk_color_button_color_set (GtkColorButton* _sender,
                                              gpointer self);
static void __lambda24_ (Block18Data* _data18_);
VALA_EXTERN GeeArrayList* bookworm_app_utils_selectDirChooser (const gchar* title,
                                                   GtkWindow* parent,
                                                   gboolean select_multiple);
VALA_EXTERN void bookworm_app_settings_set_list_of_scan_dirs (BookwormAppSettings* self,
                                                  const gchar* value);
static void ___lambda24__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda26_ (void);
static void ___lambda26__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda27_ (Block18Data* _data18_);
VALA_EXTERN void bookworm_app_settings_set_library_page_items (BookwormAppSettings* self,
                                                   gint value);
static void ___lambda27__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static gboolean __lambda28_ (Block18Data* _data18_);
static gchar* _variant_get1 (GVariant* value);
VALA_EXTERN void bookworm_app_settings_set_list_of_profile_colors (BookwormAppSettings* self,
                                                       const gchar* value);
static gboolean _variant_get2 (GVariant* value);
static gboolean _variant_get3 (GVariant* value);
static gboolean _variant_get4 (GVariant* value);
static gboolean _variant_get5 (GVariant* value);
static gchar* _variant_get6 (GVariant* value);
static gchar* _variant_get7 (GVariant* value);
static gint _variant_get8 (GVariant* value);
static gint _variant_get9 (GVariant* value);
static gint _variant_get10 (GVariant* value);
static gboolean ___lambda28__gtk_link_button_activate_link (GtkLinkButton* _sender,
                                                     gpointer self);
static void __lambda29_ (void);
static void ___lambda29__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
VALA_EXTERN void bookworm_app_bookworm_loadCSSProvider (GtkCssProvider* cssProvider);
VALA_EXTERN void bookworm_app_app_dialog_createAnnotationDialog (const gchar* textForAnnotation);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
VALA_EXTERN gchar* bookworm_app_book_getAnnotations (BookwormAppBook* self,
                                         const gchar* index);
VALA_EXTERN gint bookworm_app_book_getBookPageNumber (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_book_getAnnotationTags (BookwormAppBook* self);
static void __lambda30_ (Block19Data* _data19_);
VALA_EXTERN void bookworm_app_book_setAnnotations (BookwormAppBook* self,
                                       const gchar* index,
                                       const gchar* annotationText);
VALA_EXTERN void bookworm_app_book_setAnnotationTags (BookwormAppBook* self,
                                          const gchar* anAnnotationTags);
VALA_EXTERN gchar* bookworm_app_utils_setWebViewTitle (const gchar* javascript);
VALA_EXTERN BookwormAppBook* bookworm_app_content_handler_renderPage (BookwormAppBook* aBook,
                                                          gchar* direction);
static void ___lambda30__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
static void bookworm_app_app_dialog_finalize (GObject * obj);
static GType bookworm_app_app_dialog_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_BOOKWORM_READING_MODE[5];

BookwormAppAppDialog*
bookworm_app_app_dialog_construct (GType object_type)
{
	BookwormAppAppDialog * self = NULL;
	BookwormAppSettings* _tmp0_;
	GString* _tmp1_;
	BookwormAppSettings* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 27 "../src/dialog.vala"
	self = (BookwormAppAppDialog*) g_object_new (object_type, NULL);
#line 28 "../src/dialog.vala"
	_tmp0_ = bookworm_app_settings_get_instance ();
#line 28 "../src/dialog.vala"
	_g_object_unref0 (bookworm_app_app_dialog_settings);
#line 28 "../src/dialog.vala"
	bookworm_app_app_dialog_settings = _tmp0_;
#line 29 "../src/dialog.vala"
	_tmp1_ = bookworm_app_app_dialog_scanDirList;
#line 29 "../src/dialog.vala"
	_tmp2_ = bookworm_app_bookworm_settings;
#line 29 "../src/dialog.vala"
	_tmp3_ = bookworm_app_settings_get_list_of_scan_dirs (_tmp2_);
#line 29 "../src/dialog.vala"
	_tmp4_ = _tmp3_;
#line 29 "../src/dialog.vala"
	g_string_assign (_tmp1_, _tmp4_);
#line 27 "../src/dialog.vala"
	return self;
#line 452 "dialog.c"
}

BookwormAppAppDialog*
bookworm_app_app_dialog_new (void)
{
#line 27 "../src/dialog.vala"
	return bookworm_app_app_dialog_construct (BOOKWORM_APP_TYPE_APP_DIALOG);
#line 460 "dialog.c"
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
#line 32 "../src/dialog.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 32 "../src/dialog.vala"
	return _data16_;
#line 470 "dialog.c"
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 32 "../src/dialog.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 32 "../src/dialog.vala"
		_g_object_unref0 (_data16_->bookRatingList);
#line 32 "../src/dialog.vala"
		_g_object_unref0 (_data16_->updateTagsEntry);
#line 32 "../src/dialog.vala"
		_g_object_unref0 (_data16_->updateAuthorEntry);
#line 32 "../src/dialog.vala"
		_g_object_unref0 (_data16_->updateTitleEntry);
#line 32 "../src/dialog.vala"
		_bookworm_app_book_unref0 (_data16_->aBook);
#line 32 "../src/dialog.vala"
		g_slice_free (Block16Data, _data16_);
#line 492 "dialog.c"
	}
}

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 70 "../src/dialog.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 501 "dialog.c"
}

static void
__lambda8_ (Block16Data* _data16_)
{
	GeeArrayList* selectedFiles = NULL;
	GtkApplicationWindow* _tmp0_;
	GeeArrayList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeArrayList* _tmp3_;
	GError* _inner_error0_ = NULL;
#line 60 "../src/dialog.vala"
	_tmp0_ = bookworm_app_bookworm_window;
#line 60 "../src/dialog.vala"
	_tmp1_ = bookworm_app_utils_selectFileChooser (GTK_FILE_CHOOSER_ACTION_OPEN, _ ("Select Image"), (GtkWindow*) _tmp0_, FALSE, "IMAGES");
#line 60 "../src/dialog.vala"
	selectedFiles = _tmp1_;
#line 67 "../src/dialog.vala"
	_tmp3_ = selectedFiles;
#line 67 "../src/dialog.vala"
	if (_tmp3_ != NULL) {
#line 523 "dialog.c"
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
#line 67 "../src/dialog.vala"
		_tmp4_ = selectedFiles;
#line 67 "../src/dialog.vala"
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
#line 67 "../src/dialog.vala"
		_tmp6_ = _tmp5_;
#line 67 "../src/dialog.vala"
		_tmp2_ = _tmp6_ > 0;
#line 535 "dialog.c"
	} else {
#line 67 "../src/dialog.vala"
		_tmp2_ = FALSE;
#line 539 "dialog.c"
	}
#line 67 "../src/dialog.vala"
	if (_tmp2_) {
#line 543 "dialog.c"
		gchar* selectedCoverImagePath = NULL;
		GeeArrayList* _tmp7_;
		gpointer _tmp8_;
		BookwormAppBook* _tmp9_;
		const gchar* _tmp10_;
		BookwormAppBook* _tmp11_;
#line 68 "../src/dialog.vala"
		_tmp7_ = selectedFiles;
#line 68 "../src/dialog.vala"
		_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, 0);
#line 68 "../src/dialog.vala"
		selectedCoverImagePath = (gchar*) _tmp8_;
#line 70 "../src/dialog.vala"
		_tmp9_ = _bookworm_app_book_ref0 (_data16_->aBook);
#line 70 "../src/dialog.vala"
		_tmp10_ = selectedCoverImagePath;
#line 70 "../src/dialog.vala"
		_tmp11_ = bookworm_app_utils_setBookCoverImage (_tmp9_, _tmp10_);
#line 70 "../src/dialog.vala"
		_bookworm_app_book_unref0 (_data16_->aBook);
#line 70 "../src/dialog.vala"
		_data16_->aBook = _tmp11_;
#line 71 "../src/dialog.vala"
		bookworm_app_book_setWasBookOpened (_data16_->aBook, TRUE);
#line 568 "dialog.c"
		{
			GdkPixbuf* aBookCover = NULL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GdkPixbuf* _tmp14_;
			GdkPixbuf* _tmp15_;
			GtkImage* aCoverImage = NULL;
			GdkPixbuf* _tmp16_;
			GtkImage* _tmp17_;
			GtkImage* _tmp18_;
			GtkImage* _tmp19_;
			GtkImage* _tmp20_;
			BookwormAppBook* _tmp21_;
			GtkLabel* titleTextLabel = NULL;
			GtkWidget* _tmp22_;
			GtkLabel* _tmp23_;
			GtkLabel* _tmp24_;
			GtkFlowBox* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
#line 74 "../src/dialog.vala"
			_tmp12_ = bookworm_app_book_getBookCoverLocation (_data16_->aBook);
#line 74 "../src/dialog.vala"
			_tmp13_ = _tmp12_;
#line 74 "../src/dialog.vala"
			_tmp14_ = gdk_pixbuf_new_from_resource_at_scale (_tmp13_, 150, 200, FALSE, &_inner_error0_);
#line 74 "../src/dialog.vala"
			_tmp15_ = _tmp14_;
#line 74 "../src/dialog.vala"
			_g_free0 (_tmp13_);
#line 74 "../src/dialog.vala"
			aBookCover = _tmp15_;
#line 74 "../src/dialog.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 604 "dialog.c"
				goto __catch0_g_error;
			}
#line 80 "../src/dialog.vala"
			_tmp16_ = aBookCover;
#line 80 "../src/dialog.vala"
			_tmp17_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp16_);
#line 80 "../src/dialog.vala"
			g_object_ref_sink (_tmp17_);
#line 80 "../src/dialog.vala"
			aCoverImage = _tmp17_;
#line 81 "../src/dialog.vala"
			_tmp18_ = aCoverImage;
#line 81 "../src/dialog.vala"
			gtk_widget_set_halign ((GtkWidget*) _tmp18_, GTK_ALIGN_START);
#line 82 "../src/dialog.vala"
			_tmp19_ = aCoverImage;
#line 82 "../src/dialog.vala"
			gtk_widget_set_valign ((GtkWidget*) _tmp19_, GTK_ALIGN_START);
#line 83 "../src/dialog.vala"
			_tmp20_ = aCoverImage;
#line 83 "../src/dialog.vala"
			bookworm_app_book_setBookWidget (_data16_->aBook, "COVER_IMAGE", (GtkWidget*) _tmp20_);
#line 84 "../src/dialog.vala"
			_tmp21_ = _bookworm_app_book_ref0 (_data16_->aBook);
#line 84 "../src/dialog.vala"
			bookworm_app_library_replaceCoverImageOnBook (_tmp21_);
#line 86 "../src/dialog.vala"
			_tmp22_ = bookworm_app_book_getBookWidget (_data16_->aBook, "TITLE_TEXT_LABEL");
#line 86 "../src/dialog.vala"
			titleTextLabel = G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_label_get_type (), GtkLabel);
#line 87 "../src/dialog.vala"
			_tmp23_ = titleTextLabel;
#line 87 "../src/dialog.vala"
			gtk_label_set_text (_tmp23_, "");
#line 88 "../src/dialog.vala"
			_tmp24_ = titleTextLabel;
#line 88 "../src/dialog.vala"
			bookworm_app_book_setBookWidget (_data16_->aBook, "TITLE_TEXT_LABEL", (GtkWidget*) _tmp24_);
#line 90 "../src/dialog.vala"
			_tmp25_ = bookworm_app_app_window_library_grid;
#line 90 "../src/dialog.vala"
			gtk_widget_show_all ((GtkWidget*) _tmp25_);
#line 91 "../src/dialog.vala"
			bookworm_app_bookworm_toggleUIState ();
#line 92 "../src/dialog.vala"
			_tmp26_ = selectedCoverImagePath;
#line 92 "../src/dialog.vala"
			_tmp27_ = g_strconcat ("Updated cover to image located at path:", _tmp26_, NULL);
#line 92 "../src/dialog.vala"
			_tmp28_ = _tmp27_;
#line 92 "../src/dialog.vala"
			g_debug ("dialog.vala:92: %s", _tmp28_);
#line 92 "../src/dialog.vala"
			_g_free0 (_tmp28_);
#line 73 "../src/dialog.vala"
			_g_object_unref0 (titleTextLabel);
#line 73 "../src/dialog.vala"
			_g_object_unref0 (aCoverImage);
#line 73 "../src/dialog.vala"
			_g_object_unref0 (aBookCover);
#line 665 "dialog.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			GError* _tmp35_;
			const gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
#line 73 "../src/dialog.vala"
			e = _inner_error0_;
#line 73 "../src/dialog.vala"
			_inner_error0_ = NULL;
#line 94 "../src/dialog.vala"
			_tmp29_ = bookworm_app_book_getBookCoverLocation (_data16_->aBook);
#line 94 "../src/dialog.vala"
			_tmp30_ = _tmp29_;
#line 94 "../src/dialog.vala"
			_tmp31_ = g_strconcat ("Error in getting the book cover image from location [", _tmp30_, NULL);
#line 94 "../src/dialog.vala"
			_tmp32_ = _tmp31_;
#line 94 "../src/dialog.vala"
			_tmp33_ = g_strconcat (_tmp32_, "] :", NULL);
#line 94 "../src/dialog.vala"
			_tmp34_ = _tmp33_;
#line 94 "../src/dialog.vala"
			_tmp35_ = e;
#line 94 "../src/dialog.vala"
			_tmp36_ = _tmp35_->message;
#line 94 "../src/dialog.vala"
			_tmp37_ = g_strconcat (_tmp34_, _tmp36_, NULL);
#line 94 "../src/dialog.vala"
			_tmp38_ = _tmp37_;
#line 94 "../src/dialog.vala"
			g_warning ("dialog.vala:94: %s", _tmp38_);
#line 94 "../src/dialog.vala"
			_g_free0 (_tmp38_);
#line 94 "../src/dialog.vala"
			_g_free0 (_tmp34_);
#line 94 "../src/dialog.vala"
			_g_free0 (_tmp32_);
#line 94 "../src/dialog.vala"
			_g_free0 (_tmp30_);
#line 73 "../src/dialog.vala"
			_g_error_free0 (e);
#line 717 "dialog.c"
		}
		__finally0:
#line 73 "../src/dialog.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 73 "../src/dialog.vala"
			_g_free0 (selectedCoverImagePath);
#line 73 "../src/dialog.vala"
			_g_object_unref0 (selectedFiles);
#line 73 "../src/dialog.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 73 "../src/dialog.vala"
			g_clear_error (&_inner_error0_);
#line 73 "../src/dialog.vala"
			return;
#line 732 "dialog.c"
		}
#line 67 "../src/dialog.vala"
		_g_free0 (selectedCoverImagePath);
#line 736 "dialog.c"
	}
#line 59 "../src/dialog.vala"
	_g_object_unref0 (selectedFiles);
#line 740 "dialog.c"
}

static void
___lambda8__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
#line 59 "../src/dialog.vala"
	__lambda8_ (self);
#line 749 "dialog.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 771 "dialog.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 775 "dialog.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 781 "dialog.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 785 "dialog.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 789 "dialog.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 797 "dialog.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 825 "dialog.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 834 "dialog.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 848 "dialog.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 857 "dialog.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 871 "dialog.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 880 "dialog.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 889 "dialog.c"
}

static gboolean
__lambda10_ (Block16Data* _data16_)
{
	gboolean _tmp0_ = FALSE;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
#line 108 "../src/dialog.vala"
	_tmp1_ = _data16_->updateTitleEntry;
#line 108 "../src/dialog.vala"
	_tmp2_ = gtk_entry_get_text (_tmp1_);
#line 108 "../src/dialog.vala"
	if (_tmp2_ != NULL) {
#line 905 "dialog.c"
		GtkEntry* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
#line 108 "../src/dialog.vala"
		_tmp3_ = _data16_->updateTitleEntry;
#line 108 "../src/dialog.vala"
		_tmp4_ = gtk_entry_get_text (_tmp3_);
#line 108 "../src/dialog.vala"
		_tmp5_ = strlen (_tmp4_);
#line 108 "../src/dialog.vala"
		_tmp6_ = _tmp5_;
#line 108 "../src/dialog.vala"
		_tmp0_ = _tmp6_ > 0;
#line 920 "dialog.c"
	} else {
#line 108 "../src/dialog.vala"
		_tmp0_ = FALSE;
#line 924 "dialog.c"
	}
#line 108 "../src/dialog.vala"
	if (_tmp0_) {
#line 928 "dialog.c"
		gchar* title = NULL;
		GtkEntry* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
#line 109 "../src/dialog.vala"
		_tmp7_ = _data16_->updateTitleEntry;
#line 109 "../src/dialog.vala"
		_tmp8_ = gtk_entry_get_text (_tmp7_);
#line 109 "../src/dialog.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 109 "../src/dialog.vala"
		title = _tmp9_;
#line 110 "../src/dialog.vala"
		_tmp11_ = title;
#line 110 "../src/dialog.vala"
		if (_tmp11_ == NULL) {
#line 110 "../src/dialog.vala"
			_tmp10_ = TRUE;
#line 954 "dialog.c"
		} else {
			const gchar* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
#line 110 "../src/dialog.vala"
			_tmp12_ = title;
#line 110 "../src/dialog.vala"
			_tmp13_ = strlen (_tmp12_);
#line 110 "../src/dialog.vala"
			_tmp14_ = _tmp13_;
#line 110 "../src/dialog.vala"
			_tmp10_ = _tmp14_ < 1;
#line 967 "dialog.c"
		}
#line 110 "../src/dialog.vala"
		if (_tmp10_) {
#line 971 "dialog.c"
			gchar* _tmp15_;
#line 111 "../src/dialog.vala"
			_tmp15_ = g_strdup (BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE);
#line 111 "../src/dialog.vala"
			_g_free0 (title);
#line 111 "../src/dialog.vala"
			title = _tmp15_;
#line 979 "dialog.c"
		}
#line 114 "../src/dialog.vala"
		_tmp16_ = title;
#line 114 "../src/dialog.vala"
		_tmp17_ = string_replace (_tmp16_, "&", "and");
#line 114 "../src/dialog.vala"
		_g_free0 (title);
#line 114 "../src/dialog.vala"
		title = _tmp17_;
#line 115 "../src/dialog.vala"
		_tmp18_ = title;
#line 115 "../src/dialog.vala"
		_tmp19_ = bookworm_app_utils_minimizeStringLength (_tmp18_, 4 * BOOKWORM_APP_CONSTANTS_MAX_NUMBER_OF_CHARS_FOR_BOOK_TITLE);
#line 115 "../src/dialog.vala"
		_g_free0 (title);
#line 115 "../src/dialog.vala"
		title = _tmp19_;
#line 116 "../src/dialog.vala"
		_tmp20_ = title;
#line 116 "../src/dialog.vala"
		bookworm_app_book_setBookTitle (_data16_->aBook, _tmp20_);
#line 117 "../src/dialog.vala"
		bookworm_app_book_setWasBookOpened (_data16_->aBook, TRUE);
#line 118 "../src/dialog.vala"
		if (!bookworm_app_book_getIsBookCoverImagePresent (_data16_->aBook)) {
#line 1005 "dialog.c"
			GtkLabel* titleTextLabel = NULL;
			GtkWidget* _tmp21_;
			GtkLabel* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			GtkLabel* _tmp30_;
			GtkLabel* _tmp31_;
			GtkLabel* _tmp32_;
			GtkLabel* _tmp33_;
			GtkLabel* _tmp34_;
			GtkLabel* _tmp35_;
			GtkLabel* _tmp36_;
			GtkFlowBox* _tmp37_;
#line 120 "../src/dialog.vala"
			_tmp21_ = bookworm_app_book_getBookWidget (_data16_->aBook, "TITLE_TEXT_LABEL");
#line 120 "../src/dialog.vala"
			titleTextLabel = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_label_get_type (), GtkLabel);
#line 121 "../src/dialog.vala"
			_tmp22_ = titleTextLabel;
#line 121 "../src/dialog.vala"
			_tmp23_ = title;
#line 121 "../src/dialog.vala"
			_tmp24_ = bookworm_app_utils_breakString (_tmp23_, BOOKWORM_APP_CONSTANTS_MAX_NUMBER_OF_CHARS_FOR_BOOK_TITLE, "\n");
#line 121 "../src/dialog.vala"
			_tmp25_ = _tmp24_;
#line 121 "../src/dialog.vala"
			_tmp26_ = g_strconcat ("<b>", _tmp25_, NULL);
#line 121 "../src/dialog.vala"
			_tmp27_ = _tmp26_;
#line 121 "../src/dialog.vala"
			_tmp28_ = g_strconcat (_tmp27_, "</b>", NULL);
#line 121 "../src/dialog.vala"
			_tmp29_ = _tmp28_;
#line 121 "../src/dialog.vala"
			gtk_label_set_text (_tmp22_, _tmp29_);
#line 121 "../src/dialog.vala"
			_g_free0 (_tmp29_);
#line 121 "../src/dialog.vala"
			_g_free0 (_tmp27_);
#line 121 "../src/dialog.vala"
			_g_free0 (_tmp25_);
#line 129 "../src/dialog.vala"
			_tmp30_ = titleTextLabel;
#line 129 "../src/dialog.vala"
			gtk_label_set_use_markup (_tmp30_, TRUE);
#line 130 "../src/dialog.vala"
			_tmp31_ = titleTextLabel;
#line 130 "../src/dialog.vala"
			gtk_label_set_line_wrap (_tmp31_, TRUE);
#line 131 "../src/dialog.vala"
			_tmp32_ = titleTextLabel;
#line 131 "../src/dialog.vala"
			gtk_widget_set_halign ((GtkWidget*) _tmp32_, GTK_ALIGN_CENTER);
#line 132 "../src/dialog.vala"
			_tmp33_ = titleTextLabel;
#line 132 "../src/dialog.vala"
			gtk_widget_set_margin_start ((GtkWidget*) _tmp33_, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 133 "../src/dialog.vala"
			_tmp34_ = titleTextLabel;
#line 133 "../src/dialog.vala"
			gtk_widget_set_margin_end ((GtkWidget*) _tmp34_, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 134 "../src/dialog.vala"
			_tmp35_ = titleTextLabel;
#line 134 "../src/dialog.vala"
			gtk_label_set_max_width_chars (_tmp35_, -1);
#line 135 "../src/dialog.vala"
			_tmp36_ = titleTextLabel;
#line 135 "../src/dialog.vala"
			bookworm_app_book_setBookWidget (_data16_->aBook, "TITLE_TEXT_LABEL", (GtkWidget*) _tmp36_);
#line 136 "../src/dialog.vala"
			_tmp37_ = bookworm_app_app_window_library_grid;
#line 136 "../src/dialog.vala"
			gtk_widget_show_all ((GtkWidget*) _tmp37_);
#line 137 "../src/dialog.vala"
			bookworm_app_bookworm_toggleUIState ();
#line 118 "../src/dialog.vala"
			_g_object_unref0 (titleTextLabel);
#line 1088 "dialog.c"
		}
#line 108 "../src/dialog.vala"
		_g_free0 (title);
#line 1092 "dialog.c"
	}
#line 140 "../src/dialog.vala"
	result = FALSE;
#line 140 "../src/dialog.vala"
	return result;
#line 1098 "dialog.c"
}

static gboolean
___lambda10__gtk_widget_focus_out_event (GtkWidget* _sender,
                                         GdkEventFocus* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda10_ (self);
#line 107 "../src/dialog.vala"
	return result;
#line 1110 "dialog.c"
}

static gboolean
__lambda11_ (Block16Data* _data16_)
{
	gboolean _tmp0_ = FALSE;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
#line 152 "../src/dialog.vala"
	_tmp1_ = _data16_->updateAuthorEntry;
#line 152 "../src/dialog.vala"
	_tmp2_ = gtk_entry_get_text (_tmp1_);
#line 152 "../src/dialog.vala"
	if (_tmp2_ != NULL) {
#line 1126 "dialog.c"
		GtkEntry* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
#line 152 "../src/dialog.vala"
		_tmp3_ = _data16_->updateAuthorEntry;
#line 152 "../src/dialog.vala"
		_tmp4_ = gtk_entry_get_text (_tmp3_);
#line 152 "../src/dialog.vala"
		_tmp5_ = strlen (_tmp4_);
#line 152 "../src/dialog.vala"
		_tmp6_ = _tmp5_;
#line 152 "../src/dialog.vala"
		_tmp0_ = _tmp6_ > 0;
#line 1141 "dialog.c"
	} else {
#line 152 "../src/dialog.vala"
		_tmp0_ = FALSE;
#line 1145 "dialog.c"
	}
#line 152 "../src/dialog.vala"
	if (_tmp0_) {
#line 1149 "dialog.c"
		GtkEntry* _tmp7_;
		const gchar* _tmp8_;
#line 153 "../src/dialog.vala"
		_tmp7_ = _data16_->updateAuthorEntry;
#line 153 "../src/dialog.vala"
		_tmp8_ = gtk_entry_get_text (_tmp7_);
#line 153 "../src/dialog.vala"
		bookworm_app_book_setBookAuthor (_data16_->aBook, _tmp8_);
#line 154 "../src/dialog.vala"
		bookworm_app_book_setWasBookOpened (_data16_->aBook, TRUE);
#line 1160 "dialog.c"
	}
#line 156 "../src/dialog.vala"
	result = FALSE;
#line 156 "../src/dialog.vala"
	return result;
#line 1166 "dialog.c"
}

static gboolean
___lambda11__gtk_widget_focus_out_event (GtkWidget* _sender,
                                         GdkEventFocus* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda11_ (self);
#line 151 "../src/dialog.vala"
	return result;
#line 1178 "dialog.c"
}

static gboolean
__lambda12_ (Block16Data* _data16_)
{
	gboolean _tmp0_ = FALSE;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
#line 168 "../src/dialog.vala"
	_tmp1_ = _data16_->updateTagsEntry;
#line 168 "../src/dialog.vala"
	_tmp2_ = gtk_entry_get_text (_tmp1_);
#line 168 "../src/dialog.vala"
	if (_tmp2_ != NULL) {
#line 1194 "dialog.c"
		GtkEntry* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
#line 168 "../src/dialog.vala"
		_tmp3_ = _data16_->updateTagsEntry;
#line 168 "../src/dialog.vala"
		_tmp4_ = gtk_entry_get_text (_tmp3_);
#line 168 "../src/dialog.vala"
		_tmp5_ = strlen (_tmp4_);
#line 168 "../src/dialog.vala"
		_tmp6_ = _tmp5_;
#line 168 "../src/dialog.vala"
		_tmp0_ = _tmp6_ > 0;
#line 1209 "dialog.c"
	} else {
#line 168 "../src/dialog.vala"
		_tmp0_ = FALSE;
#line 1213 "dialog.c"
	}
#line 168 "../src/dialog.vala"
	if (_tmp0_) {
#line 1217 "dialog.c"
		GtkEntry* _tmp7_;
		const gchar* _tmp8_;
#line 169 "../src/dialog.vala"
		_tmp7_ = _data16_->updateTagsEntry;
#line 169 "../src/dialog.vala"
		_tmp8_ = gtk_entry_get_text (_tmp7_);
#line 169 "../src/dialog.vala"
		bookworm_app_book_setBookTags (_data16_->aBook, _tmp8_);
#line 170 "../src/dialog.vala"
		bookworm_app_book_setWasBookOpened (_data16_->aBook, TRUE);
#line 1228 "dialog.c"
	}
#line 172 "../src/dialog.vala"
	result = FALSE;
#line 172 "../src/dialog.vala"
	return result;
#line 1234 "dialog.c"
}

static gboolean
___lambda12__gtk_widget_focus_out_event (GtkWidget* _sender,
                                         GdkEventFocus* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda12_ (self);
#line 167 "../src/dialog.vala"
	return result;
#line 1246 "dialog.c"
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
#line 180 "../src/dialog.vala"
	g_atomic_int_inc (&_data17_->_ref_count_);
#line 180 "../src/dialog.vala"
	return _data17_;
#line 1256 "dialog.c"
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
#line 180 "../src/dialog.vala"
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
#line 180 "../src/dialog.vala"
		_g_object_unref0 (_data17_->rating_star_button);
#line 180 "../src/dialog.vala"
		block16_data_unref (_data17_->_data16_);
#line 180 "../src/dialog.vala"
		_data17_->_data16_ = NULL;
#line 180 "../src/dialog.vala"
		g_slice_free (Block17Data, _data17_);
#line 1274 "dialog.c"
	}
}

static void
_____lambda13_ (Block17Data* _data17_)
{
	Block16Data* _data16_;
	GtkIconTheme* _tmp0_;
	gint ratingClicked = 0;
	GeeArrayList* _tmp7_;
	GtkButton* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
#line 193 "../src/dialog.vala"
	_data16_ = _data17_->_data16_;
#line 195 "../src/dialog.vala"
	_tmp0_ = gtk_icon_theme_get_default ();
#line 195 "../src/dialog.vala"
	if (gtk_icon_theme_has_icon (_tmp0_, "starred")) {
#line 1296 "dialog.c"
		GtkButton* _tmp1_;
		GtkImage* _tmp2_;
		GtkImage* _tmp3_;
#line 196 "../src/dialog.vala"
		_tmp1_ = _data17_->rating_star_button;
#line 196 "../src/dialog.vala"
		_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name ("starred", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 196 "../src/dialog.vala"
		g_object_ref_sink (_tmp2_);
#line 196 "../src/dialog.vala"
		_tmp3_ = _tmp2_;
#line 196 "../src/dialog.vala"
		gtk_button_set_image (_tmp1_, (GtkWidget*) _tmp3_);
#line 196 "../src/dialog.vala"
		_g_object_unref0 (_tmp3_);
#line 1312 "dialog.c"
	} else {
		GtkButton* _tmp4_;
		GtkImage* _tmp5_;
		GtkImage* _tmp6_;
#line 198 "../src/dialog.vala"
		_tmp4_ = _data17_->rating_star_button;
#line 198 "../src/dialog.vala"
		_tmp5_ = (GtkImage*) gtk_image_new_from_file (BOOKWORM_APP_CONSTANTS_RATING_SELECTED_IMAGE_ICON_LOCATION);
#line 198 "../src/dialog.vala"
		g_object_ref_sink (_tmp5_);
#line 198 "../src/dialog.vala"
		_tmp6_ = _tmp5_;
#line 198 "../src/dialog.vala"
		gtk_button_set_image (_tmp4_, (GtkWidget*) _tmp6_);
#line 198 "../src/dialog.vala"
		_g_object_unref0 (_tmp6_);
#line 1329 "dialog.c"
	}
#line 200 "../src/dialog.vala"
	_tmp7_ = _data16_->bookRatingList;
#line 200 "../src/dialog.vala"
	_tmp8_ = _data17_->rating_star_button;
#line 200 "../src/dialog.vala"
	ratingClicked = gee_abstract_list_index_of ((GeeAbstractList*) _tmp7_, _tmp8_);
#line 201 "../src/dialog.vala"
	bookworm_app_book_setBookRating (_data16_->aBook, ratingClicked + 1);
#line 202 "../src/dialog.vala"
	bookworm_app_book_setWasBookOpened (_data16_->aBook, TRUE);
#line 203 "../src/dialog.vala"
	_tmp9_ = g_strdup_printf ("%i", ratingClicked + 1);
#line 203 "../src/dialog.vala"
	_tmp10_ = _tmp9_;
#line 203 "../src/dialog.vala"
	_tmp11_ = g_strconcat ("Book Rating Set to:", _tmp10_, NULL);
#line 203 "../src/dialog.vala"
	_tmp12_ = _tmp11_;
#line 203 "../src/dialog.vala"
	g_debug ("dialog.vala:203: %s", _tmp12_);
#line 203 "../src/dialog.vala"
	_g_free0 (_tmp12_);
#line 203 "../src/dialog.vala"
	_g_free0 (_tmp10_);
#line 1355 "dialog.c"
	{
		gint j = 0;
#line 205 "../src/dialog.vala"
		j = 0;
#line 1360 "dialog.c"
		{
			gboolean _tmp13_ = FALSE;
#line 205 "../src/dialog.vala"
			_tmp13_ = TRUE;
#line 205 "../src/dialog.vala"
			while (TRUE) {
#line 1367 "dialog.c"
				GtkIconTheme* _tmp15_;
#line 205 "../src/dialog.vala"
				if (!_tmp13_) {
#line 1371 "dialog.c"
					gint _tmp14_;
#line 205 "../src/dialog.vala"
					_tmp14_ = j;
#line 205 "../src/dialog.vala"
					j = _tmp14_ + 1;
#line 1377 "dialog.c"
				}
#line 205 "../src/dialog.vala"
				_tmp13_ = FALSE;
#line 205 "../src/dialog.vala"
				if (!(j < ratingClicked)) {
#line 205 "../src/dialog.vala"
					break;
#line 1385 "dialog.c"
				}
#line 206 "../src/dialog.vala"
				_tmp15_ = gtk_icon_theme_get_default ();
#line 206 "../src/dialog.vala"
				if (gtk_icon_theme_has_icon (_tmp15_, "starred")) {
#line 1391 "dialog.c"
					GeeArrayList* _tmp16_;
					gpointer _tmp17_;
					GtkButton* _tmp18_;
					GtkImage* _tmp19_;
					GtkImage* _tmp20_;
#line 207 "../src/dialog.vala"
					_tmp16_ = _data16_->bookRatingList;
#line 207 "../src/dialog.vala"
					_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, j);
#line 207 "../src/dialog.vala"
					_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST ((GtkButton*) _tmp17_, gtk_button_get_type (), GtkButton);
#line 207 "../src/dialog.vala"
					_tmp19_ = (GtkImage*) gtk_image_new_from_icon_name ("starred", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 207 "../src/dialog.vala"
					g_object_ref_sink (_tmp19_);
#line 207 "../src/dialog.vala"
					_tmp20_ = _tmp19_;
#line 207 "../src/dialog.vala"
					gtk_button_set_image (_tmp18_, (GtkWidget*) _tmp20_);
#line 207 "../src/dialog.vala"
					_g_object_unref0 (_tmp20_);
#line 207 "../src/dialog.vala"
					_g_object_unref0 (_tmp18_);
#line 1415 "dialog.c"
				} else {
					GeeArrayList* _tmp21_;
					gpointer _tmp22_;
					GtkButton* _tmp23_;
					GtkImage* _tmp24_;
					GtkImage* _tmp25_;
#line 209 "../src/dialog.vala"
					_tmp21_ = _data16_->bookRatingList;
#line 209 "../src/dialog.vala"
					_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, j);
#line 209 "../src/dialog.vala"
					_tmp23_ = G_TYPE_CHECK_INSTANCE_CAST ((GtkButton*) _tmp22_, gtk_button_get_type (), GtkButton);
#line 209 "../src/dialog.vala"
					_tmp24_ = (GtkImage*) gtk_image_new_from_file (BOOKWORM_APP_CONSTANTS_RATING_SELECTED_IMAGE_ICON_LOCATION);
#line 209 "../src/dialog.vala"
					g_object_ref_sink (_tmp24_);
#line 209 "../src/dialog.vala"
					_tmp25_ = _tmp24_;
#line 209 "../src/dialog.vala"
					gtk_button_set_image (_tmp23_, (GtkWidget*) _tmp25_);
#line 209 "../src/dialog.vala"
					_g_object_unref0 (_tmp25_);
#line 209 "../src/dialog.vala"
					_g_object_unref0 (_tmp23_);
#line 1440 "dialog.c"
				}
			}
		}
	}
	{
		gint k = 0;
#line 216 "../src/dialog.vala"
		k = ratingClicked + 1;
#line 1449 "dialog.c"
		{
			gboolean _tmp26_ = FALSE;
#line 216 "../src/dialog.vala"
			_tmp26_ = TRUE;
#line 216 "../src/dialog.vala"
			while (TRUE) {
#line 1456 "dialog.c"
				GtkIconTheme* _tmp28_;
#line 216 "../src/dialog.vala"
				if (!_tmp26_) {
#line 1460 "dialog.c"
					gint _tmp27_;
#line 216 "../src/dialog.vala"
					_tmp27_ = k;
#line 216 "../src/dialog.vala"
					k = _tmp27_ + 1;
#line 1466 "dialog.c"
				}
#line 216 "../src/dialog.vala"
				_tmp26_ = FALSE;
#line 216 "../src/dialog.vala"
				if (!(k < 5)) {
#line 216 "../src/dialog.vala"
					break;
#line 1474 "dialog.c"
				}
#line 217 "../src/dialog.vala"
				_tmp28_ = gtk_icon_theme_get_default ();
#line 217 "../src/dialog.vala"
				if (gtk_icon_theme_has_icon (_tmp28_, "non-starred")) {
#line 1480 "dialog.c"
					GeeArrayList* _tmp29_;
					gpointer _tmp30_;
					GtkButton* _tmp31_;
					GtkImage* _tmp32_;
					GtkImage* _tmp33_;
#line 218 "../src/dialog.vala"
					_tmp29_ = _data16_->bookRatingList;
#line 218 "../src/dialog.vala"
					_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, k);
#line 218 "../src/dialog.vala"
					_tmp31_ = G_TYPE_CHECK_INSTANCE_CAST ((GtkButton*) _tmp30_, gtk_button_get_type (), GtkButton);
#line 218 "../src/dialog.vala"
					_tmp32_ = (GtkImage*) gtk_image_new_from_icon_name ("non-starred", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 218 "../src/dialog.vala"
					g_object_ref_sink (_tmp32_);
#line 218 "../src/dialog.vala"
					_tmp33_ = _tmp32_;
#line 218 "../src/dialog.vala"
					gtk_button_set_image (_tmp31_, (GtkWidget*) _tmp33_);
#line 218 "../src/dialog.vala"
					_g_object_unref0 (_tmp33_);
#line 218 "../src/dialog.vala"
					_g_object_unref0 (_tmp31_);
#line 1504 "dialog.c"
				} else {
					GeeArrayList* _tmp34_;
					gpointer _tmp35_;
					GtkButton* _tmp36_;
					GtkImage* _tmp37_;
					GtkImage* _tmp38_;
#line 220 "../src/dialog.vala"
					_tmp34_ = _data16_->bookRatingList;
#line 220 "../src/dialog.vala"
					_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, k);
#line 220 "../src/dialog.vala"
					_tmp36_ = G_TYPE_CHECK_INSTANCE_CAST ((GtkButton*) _tmp35_, gtk_button_get_type (), GtkButton);
#line 220 "../src/dialog.vala"
					_tmp37_ = (GtkImage*) gtk_image_new_from_file (BOOKWORM_APP_CONSTANTS_RATING_NONE_IMAGE_ICON_LOCATION);
#line 220 "../src/dialog.vala"
					g_object_ref_sink (_tmp37_);
#line 220 "../src/dialog.vala"
					_tmp38_ = _tmp37_;
#line 220 "../src/dialog.vala"
					gtk_button_set_image (_tmp36_, (GtkWidget*) _tmp38_);
#line 220 "../src/dialog.vala"
					_g_object_unref0 (_tmp38_);
#line 220 "../src/dialog.vala"
					_g_object_unref0 (_tmp36_);
#line 1529 "dialog.c"
				}
			}
		}
	}
}

static void
______lambda13__gtk_button_clicked (GtkButton* _sender,
                                    gpointer self)
{
#line 193 "../src/dialog.vala"
	_____lambda13_ (self);
#line 1542 "dialog.c"
}

static void
__lambda14_ (Block16Data* _data16_)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 258 "../src/dialog.vala"
	_tmp0_ = bookworm_app_bookworm_libraryViewMap;
#line 258 "../src/dialog.vala"
	_tmp1_ = bookworm_app_book_getBookLocation (_data16_->aBook);
#line 258 "../src/dialog.vala"
	_tmp2_ = _tmp1_;
#line 258 "../src/dialog.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp2_, _data16_->aBook);
#line 258 "../src/dialog.vala"
	_g_free0 (_tmp2_);
#line 259 "../src/dialog.vala"
	g_debug ("dialog.vala:259: Popover closed and Book details updated...");
#line 1563 "dialog.c"
}

static void
___lambda14__gtk_popover_closed (GtkPopover* _sender,
                                 gpointer self)
{
#line 257 "../src/dialog.vala"
	__lambda14_ (self);
#line 1572 "dialog.c"
}

GtkPopover*
bookworm_app_app_dialog_createBookContextMenu (BookwormAppBook* aBook)
{
	Block16Data* _data16_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkPopover* bookContextPopover = NULL;
	GtkWidget* _tmp4_;
	GtkEventBox* _tmp5_;
	GtkPopover* _tmp6_;
	GtkPopover* _tmp7_;
	GString* contextTitle = NULL;
	GString* _tmp8_;
	GString* _tmp9_;
	GString* _tmp10_;
	GString* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GString* _tmp14_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GtkLabel* contextTitleLabel = NULL;
	GString* _tmp19_;
	const gchar* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* updateCoverLabel = NULL;
	GtkLabel* _tmp22_;
	GtkImage* updateImageIcon = NULL;
	GtkIconTheme* _tmp23_;
	GtkButton* updateCoverImageButton = NULL;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkImage* _tmp28_;
	GtkButton* _tmp29_;
	GtkButton* _tmp30_;
	GtkBox* updateCoverImageBox = NULL;
	GtkBox* _tmp31_;
	GtkBox* _tmp32_;
	GtkLabel* _tmp33_;
	GtkBox* _tmp34_;
	GtkButton* _tmp35_;
	GtkButton* _tmp36_;
	GtkLabel* updateTitleLabel = NULL;
	GtkLabel* _tmp37_;
	GtkEntry* _tmp38_;
	GtkEntry* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GtkBox* updateTitleBox = NULL;
	GtkBox* _tmp44_;
	GtkBox* _tmp45_;
	GtkLabel* _tmp46_;
	GtkBox* _tmp47_;
	GtkEntry* _tmp48_;
	GtkEntry* _tmp49_;
	GtkLabel* updateAuthorLabel = NULL;
	GtkLabel* _tmp50_;
	GtkEntry* _tmp51_;
	GtkEntry* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	GtkBox* updateAuthorBox = NULL;
	GtkBox* _tmp55_;
	GtkBox* _tmp56_;
	GtkLabel* _tmp57_;
	GtkBox* _tmp58_;
	GtkEntry* _tmp59_;
	GtkEntry* _tmp60_;
	GtkLabel* updateTagsLabel = NULL;
	GtkLabel* _tmp61_;
	GtkEntry* _tmp62_;
	GtkEntry* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	GtkBox* updateTagsBox = NULL;
	GtkBox* _tmp66_;
	GtkBox* _tmp67_;
	GtkLabel* _tmp68_;
	GtkBox* _tmp69_;
	GtkEntry* _tmp70_;
	GtkEntry* _tmp71_;
	GeeArrayList* _tmp72_;
	GtkBox* ratingBox = NULL;
	GtkBox* _tmp73_;
	GtkBox* _tmp74_;
	GtkBox* bookContextMenuBox = NULL;
	GtkBox* _tmp102_;
	GtkLabel* _tmp103_;
	GtkSeparator* _tmp104_;
	GtkSeparator* _tmp105_;
	GtkBox* _tmp106_;
	GtkBox* _tmp107_;
	GtkBox* _tmp108_;
	GtkBox* _tmp109_;
	GtkSeparator* _tmp110_;
	GtkSeparator* _tmp111_;
	GtkBox* _tmp112_;
	GtkPopover* _tmp113_;
	GtkPopover* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	gchar* _tmp118_;
	GtkPopover* result;
#line 32 "../src/dialog.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 32 "../src/dialog.vala"
	_data16_ = g_slice_new0 (Block16Data);
#line 32 "../src/dialog.vala"
	_data16_->_ref_count_ = 1;
#line 32 "../src/dialog.vala"
	_bookworm_app_book_unref0 (_data16_->aBook);
#line 32 "../src/dialog.vala"
	_data16_->aBook = aBook;
#line 33 "../src/dialog.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (_data16_->aBook);
#line 33 "../src/dialog.vala"
	_tmp1_ = _tmp0_;
#line 33 "../src/dialog.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:createBookContextMenu] aBook.location=", _tmp1_, NULL);
#line 33 "../src/dialog.vala"
	_tmp3_ = _tmp2_;
#line 33 "../src/dialog.vala"
	g_debug ("dialog.vala:33: %s", _tmp3_);
#line 33 "../src/dialog.vala"
	_g_free0 (_tmp3_);
#line 33 "../src/dialog.vala"
	_g_free0 (_tmp1_);
#line 34 "../src/dialog.vala"
	_tmp4_ = bookworm_app_book_getBookWidget (_data16_->aBook, "BOOK_EVENTBOX");
#line 34 "../src/dialog.vala"
	_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_event_box_get_type (), GtkEventBox);
#line 34 "../src/dialog.vala"
	_tmp6_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) _tmp5_);
#line 34 "../src/dialog.vala"
	g_object_ref_sink (_tmp6_);
#line 34 "../src/dialog.vala"
	_tmp7_ = _tmp6_;
#line 34 "../src/dialog.vala"
	_g_object_unref0 (_tmp5_);
#line 34 "../src/dialog.vala"
	bookContextPopover = _tmp7_;
#line 36 "../src/dialog.vala"
	_tmp8_ = g_string_new ("");
#line 36 "../src/dialog.vala"
	contextTitle = _tmp8_;
#line 37 "../src/dialog.vala"
	_tmp9_ = contextTitle;
#line 37 "../src/dialog.vala"
	_tmp10_ = g_string_append (_tmp9_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOK_CONTEXTMENU_HEADER);
#line 37 "../src/dialog.vala"
	_tmp11_ = g_string_append (_tmp10_, " ");
#line 37 "../src/dialog.vala"
	_tmp12_ = bookworm_app_book_getBookTitle (_data16_->aBook);
#line 37 "../src/dialog.vala"
	_tmp13_ = _tmp12_;
#line 37 "../src/dialog.vala"
	g_string_append (_tmp11_, _tmp13_);
#line 37 "../src/dialog.vala"
	_g_free0 (_tmp13_);
#line 41 "../src/dialog.vala"
	_tmp14_ = contextTitle;
#line 41 "../src/dialog.vala"
	_tmp15_ = contextTitle;
#line 41 "../src/dialog.vala"
	_tmp16_ = _tmp15_->str;
#line 41 "../src/dialog.vala"
	_tmp17_ = bookworm_app_utils_minimizeStringLength (_tmp16_, 35);
#line 41 "../src/dialog.vala"
	_tmp18_ = _tmp17_;
#line 41 "../src/dialog.vala"
	g_string_assign (_tmp14_, _tmp18_);
#line 41 "../src/dialog.vala"
	_g_free0 (_tmp18_);
#line 42 "../src/dialog.vala"
	_tmp19_ = contextTitle;
#line 42 "../src/dialog.vala"
	_tmp20_ = _tmp19_->str;
#line 42 "../src/dialog.vala"
	_tmp21_ = (GtkLabel*) gtk_label_new (_tmp20_);
#line 42 "../src/dialog.vala"
	g_object_ref_sink (_tmp21_);
#line 42 "../src/dialog.vala"
	contextTitleLabel = _tmp21_;
#line 44 "../src/dialog.vala"
	_tmp22_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOK_CONTEXTMENU_UPDATE_COVER);
#line 44 "../src/dialog.vala"
	g_object_ref_sink (_tmp22_);
#line 44 "../src/dialog.vala"
	updateCoverLabel = _tmp22_;
#line 45 "../src/dialog.vala"
	updateImageIcon = NULL;
#line 46 "../src/dialog.vala"
	_tmp23_ = gtk_icon_theme_get_default ();
#line 46 "../src/dialog.vala"
	if (gtk_icon_theme_has_icon (_tmp23_, "insert-image")) {
#line 1777 "dialog.c"
		GtkImage* _tmp24_;
#line 47 "../src/dialog.vala"
		_tmp24_ = (GtkImage*) gtk_image_new_from_icon_name ("insert-image", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 47 "../src/dialog.vala"
		g_object_ref_sink (_tmp24_);
#line 47 "../src/dialog.vala"
		_g_object_unref0 (updateImageIcon);
#line 47 "../src/dialog.vala"
		updateImageIcon = _tmp24_;
#line 1787 "dialog.c"
	} else {
		GtkImage* _tmp25_;
#line 49 "../src/dialog.vala"
		_tmp25_ = (GtkImage*) gtk_image_new_from_file (BOOKWORM_APP_CONSTANTS_UPDATE_IMAGE_ICON_LOCATION);
#line 49 "../src/dialog.vala"
		g_object_ref_sink (_tmp25_);
#line 49 "../src/dialog.vala"
		_g_object_unref0 (updateImageIcon);
#line 49 "../src/dialog.vala"
		updateImageIcon = _tmp25_;
#line 1798 "dialog.c"
	}
#line 51 "../src/dialog.vala"
	_tmp26_ = (GtkButton*) gtk_button_new ();
#line 51 "../src/dialog.vala"
	g_object_ref_sink (_tmp26_);
#line 51 "../src/dialog.vala"
	updateCoverImageButton = _tmp26_;
#line 52 "../src/dialog.vala"
	_tmp27_ = updateCoverImageButton;
#line 52 "../src/dialog.vala"
	_tmp28_ = updateImageIcon;
#line 52 "../src/dialog.vala"
	gtk_button_set_image (_tmp27_, (GtkWidget*) _tmp28_);
#line 53 "../src/dialog.vala"
	_tmp29_ = updateCoverImageButton;
#line 53 "../src/dialog.vala"
	gtk_button_set_relief (_tmp29_, GTK_RELIEF_NONE);
#line 54 "../src/dialog.vala"
	_tmp30_ = updateCoverImageButton;
#line 54 "../src/dialog.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp30_, BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_UPDATING_COVER_IMAGE);
#line 55 "../src/dialog.vala"
	_tmp31_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 55 "../src/dialog.vala"
	g_object_ref_sink (_tmp31_);
#line 55 "../src/dialog.vala"
	updateCoverImageBox = _tmp31_;
#line 56 "../src/dialog.vala"
	_tmp32_ = updateCoverImageBox;
#line 56 "../src/dialog.vala"
	_tmp33_ = updateCoverLabel;
#line 56 "../src/dialog.vala"
	gtk_box_pack_start (_tmp32_, (GtkWidget*) _tmp33_, FALSE, TRUE, (guint) 0);
#line 57 "../src/dialog.vala"
	_tmp34_ = updateCoverImageBox;
#line 57 "../src/dialog.vala"
	_tmp35_ = updateCoverImageButton;
#line 57 "../src/dialog.vala"
	gtk_box_pack_start (_tmp34_, (GtkWidget*) _tmp35_, FALSE, TRUE, (guint) 0);
#line 59 "../src/dialog.vala"
	_tmp36_ = updateCoverImageButton;
#line 59 "../src/dialog.vala"
	g_signal_connect_data (_tmp36_, "clicked", (GCallback) ___lambda8__gtk_button_clicked, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 100 "../src/dialog.vala"
	_tmp37_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOK_CONTEXTMENU_UPDATE_TITLE);
#line 100 "../src/dialog.vala"
	g_object_ref_sink (_tmp37_);
#line 100 "../src/dialog.vala"
	updateTitleLabel = _tmp37_;
#line 101 "../src/dialog.vala"
	_tmp38_ = (GtkEntry*) gtk_entry_new ();
#line 101 "../src/dialog.vala"
	g_object_ref_sink (_tmp38_);
#line 101 "../src/dialog.vala"
	_data16_->updateTitleEntry = _tmp38_;
#line 102 "../src/dialog.vala"
	_tmp39_ = _data16_->updateTitleEntry;
#line 102 "../src/dialog.vala"
	_tmp40_ = bookworm_app_book_getBookTitle (_data16_->aBook);
#line 102 "../src/dialog.vala"
	_tmp41_ = _tmp40_;
#line 102 "../src/dialog.vala"
	_tmp42_ = bookworm_app_utils_parseMarkUp (_tmp41_);
#line 102 "../src/dialog.vala"
	_tmp43_ = _tmp42_;
#line 102 "../src/dialog.vala"
	gtk_entry_set_text (_tmp39_, _tmp43_);
#line 102 "../src/dialog.vala"
	_g_free0 (_tmp43_);
#line 102 "../src/dialog.vala"
	_g_free0 (_tmp41_);
#line 103 "../src/dialog.vala"
	_tmp44_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 103 "../src/dialog.vala"
	g_object_ref_sink (_tmp44_);
#line 103 "../src/dialog.vala"
	updateTitleBox = _tmp44_;
#line 104 "../src/dialog.vala"
	_tmp45_ = updateTitleBox;
#line 104 "../src/dialog.vala"
	_tmp46_ = updateTitleLabel;
#line 104 "../src/dialog.vala"
	gtk_box_pack_start (_tmp45_, (GtkWidget*) _tmp46_, FALSE, TRUE, (guint) 0);
#line 105 "../src/dialog.vala"
	_tmp47_ = updateTitleBox;
#line 105 "../src/dialog.vala"
	_tmp48_ = _data16_->updateTitleEntry;
#line 105 "../src/dialog.vala"
	gtk_box_pack_end (_tmp47_, (GtkWidget*) _tmp48_, FALSE, TRUE, (guint) 0);
#line 107 "../src/dialog.vala"
	_tmp49_ = _data16_->updateTitleEntry;
#line 107 "../src/dialog.vala"
	g_signal_connect_data ((GtkWidget*) _tmp49_, "focus-out-event", (GCallback) ___lambda10__gtk_widget_focus_out_event, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 144 "../src/dialog.vala"
	_tmp50_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOK_CONTEXTMENU_UPDATE_AUTHOR);
#line 144 "../src/dialog.vala"
	g_object_ref_sink (_tmp50_);
#line 144 "../src/dialog.vala"
	updateAuthorLabel = _tmp50_;
#line 145 "../src/dialog.vala"
	_tmp51_ = (GtkEntry*) gtk_entry_new ();
#line 145 "../src/dialog.vala"
	g_object_ref_sink (_tmp51_);
#line 145 "../src/dialog.vala"
	_data16_->updateAuthorEntry = _tmp51_;
#line 146 "../src/dialog.vala"
	_tmp52_ = _data16_->updateAuthorEntry;
#line 146 "../src/dialog.vala"
	_tmp53_ = bookworm_app_book_getBookAuthor (_data16_->aBook);
#line 146 "../src/dialog.vala"
	_tmp54_ = _tmp53_;
#line 146 "../src/dialog.vala"
	gtk_entry_set_text (_tmp52_, _tmp54_);
#line 146 "../src/dialog.vala"
	_g_free0 (_tmp54_);
#line 147 "../src/dialog.vala"
	_tmp55_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 147 "../src/dialog.vala"
	g_object_ref_sink (_tmp55_);
#line 147 "../src/dialog.vala"
	updateAuthorBox = _tmp55_;
#line 148 "../src/dialog.vala"
	_tmp56_ = updateAuthorBox;
#line 148 "../src/dialog.vala"
	_tmp57_ = updateAuthorLabel;
#line 148 "../src/dialog.vala"
	gtk_box_pack_start (_tmp56_, (GtkWidget*) _tmp57_, FALSE, TRUE, (guint) 0);
#line 149 "../src/dialog.vala"
	_tmp58_ = updateAuthorBox;
#line 149 "../src/dialog.vala"
	_tmp59_ = _data16_->updateAuthorEntry;
#line 149 "../src/dialog.vala"
	gtk_box_pack_end (_tmp58_, (GtkWidget*) _tmp59_, FALSE, TRUE, (guint) 0);
#line 151 "../src/dialog.vala"
	_tmp60_ = _data16_->updateAuthorEntry;
#line 151 "../src/dialog.vala"
	g_signal_connect_data ((GtkWidget*) _tmp60_, "focus-out-event", (GCallback) ___lambda11__gtk_widget_focus_out_event, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 160 "../src/dialog.vala"
	_tmp61_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_BOOK_CONTEXTMENU_UPDATE_TAGS);
#line 160 "../src/dialog.vala"
	g_object_ref_sink (_tmp61_);
#line 160 "../src/dialog.vala"
	updateTagsLabel = _tmp61_;
#line 161 "../src/dialog.vala"
	_tmp62_ = (GtkEntry*) gtk_entry_new ();
#line 161 "../src/dialog.vala"
	g_object_ref_sink (_tmp62_);
#line 161 "../src/dialog.vala"
	_data16_->updateTagsEntry = _tmp62_;
#line 162 "../src/dialog.vala"
	_tmp63_ = _data16_->updateTagsEntry;
#line 162 "../src/dialog.vala"
	_tmp64_ = bookworm_app_book_getBookTags (_data16_->aBook);
#line 162 "../src/dialog.vala"
	_tmp65_ = _tmp64_;
#line 162 "../src/dialog.vala"
	gtk_entry_set_text (_tmp63_, _tmp65_);
#line 162 "../src/dialog.vala"
	_g_free0 (_tmp65_);
#line 163 "../src/dialog.vala"
	_tmp66_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 163 "../src/dialog.vala"
	g_object_ref_sink (_tmp66_);
#line 163 "../src/dialog.vala"
	updateTagsBox = _tmp66_;
#line 164 "../src/dialog.vala"
	_tmp67_ = updateTagsBox;
#line 164 "../src/dialog.vala"
	_tmp68_ = updateTagsLabel;
#line 164 "../src/dialog.vala"
	gtk_box_pack_start (_tmp67_, (GtkWidget*) _tmp68_, FALSE, TRUE, (guint) 0);
#line 165 "../src/dialog.vala"
	_tmp69_ = updateTagsBox;
#line 165 "../src/dialog.vala"
	_tmp70_ = _data16_->updateTagsEntry;
#line 165 "../src/dialog.vala"
	gtk_box_pack_end (_tmp69_, (GtkWidget*) _tmp70_, FALSE, TRUE, (guint) 0);
#line 167 "../src/dialog.vala"
	_tmp71_ = _data16_->updateTagsEntry;
#line 167 "../src/dialog.vala"
	g_signal_connect_data ((GtkWidget*) _tmp71_, "focus-out-event", (GCallback) ___lambda12__gtk_widget_focus_out_event, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 176 "../src/dialog.vala"
	_tmp72_ = gee_array_list_new (gtk_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 176 "../src/dialog.vala"
	_data16_->bookRatingList = _tmp72_;
#line 177 "../src/dialog.vala"
	_tmp73_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 177 "../src/dialog.vala"
	g_object_ref_sink (_tmp73_);
#line 177 "../src/dialog.vala"
	ratingBox = _tmp73_;
#line 178 "../src/dialog.vala"
	_tmp74_ = ratingBox;
#line 178 "../src/dialog.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp74_, GTK_ALIGN_CENTER);
#line 1994 "dialog.c"
	{
		gint i = 0;
#line 180 "../src/dialog.vala"
		i = 0;
#line 1999 "dialog.c"
		{
			gboolean _tmp75_ = FALSE;
#line 180 "../src/dialog.vala"
			_tmp75_ = TRUE;
#line 180 "../src/dialog.vala"
			while (TRUE) {
#line 2006 "dialog.c"
				Block17Data* _data17_;
				GtkImage* rating_star_image = NULL;
				GtkIconTheme* _tmp77_;
				GtkButton* _tmp80_;
				GtkButton* _tmp81_;
				GtkImage* _tmp82_;
				GtkButton* _tmp83_;
				GeeArrayList* _tmp84_;
				GtkButton* _tmp85_;
				GtkBox* _tmp86_;
				GtkButton* _tmp87_;
				GtkButton* _tmp88_;
#line 180 "../src/dialog.vala"
				_data17_ = g_slice_new0 (Block17Data);
#line 180 "../src/dialog.vala"
				_data17_->_ref_count_ = 1;
#line 180 "../src/dialog.vala"
				_data17_->_data16_ = block16_data_ref (_data16_);
#line 180 "../src/dialog.vala"
				if (!_tmp75_) {
#line 2027 "dialog.c"
					gint _tmp76_;
#line 180 "../src/dialog.vala"
					_tmp76_ = i;
#line 180 "../src/dialog.vala"
					i = _tmp76_ + 1;
#line 2033 "dialog.c"
				}
#line 180 "../src/dialog.vala"
				_tmp75_ = FALSE;
#line 180 "../src/dialog.vala"
				if (!(i < 5)) {
#line 180 "../src/dialog.vala"
					block17_data_unref (_data17_);
#line 180 "../src/dialog.vala"
					_data17_ = NULL;
#line 180 "../src/dialog.vala"
					break;
#line 2045 "dialog.c"
				}
#line 181 "../src/dialog.vala"
				rating_star_image = NULL;
#line 182 "../src/dialog.vala"
				_tmp77_ = gtk_icon_theme_get_default ();
#line 182 "../src/dialog.vala"
				if (gtk_icon_theme_has_icon (_tmp77_, "non-starred")) {
#line 2053 "dialog.c"
					GtkImage* _tmp78_;
#line 183 "../src/dialog.vala"
					_tmp78_ = (GtkImage*) gtk_image_new_from_icon_name ("non-starred", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 183 "../src/dialog.vala"
					g_object_ref_sink (_tmp78_);
#line 183 "../src/dialog.vala"
					_g_object_unref0 (rating_star_image);
#line 183 "../src/dialog.vala"
					rating_star_image = _tmp78_;
#line 2063 "dialog.c"
				} else {
					GtkImage* _tmp79_;
#line 185 "../src/dialog.vala"
					_tmp79_ = (GtkImage*) gtk_image_new_from_file (BOOKWORM_APP_CONSTANTS_RATING_NONE_IMAGE_ICON_LOCATION);
#line 185 "../src/dialog.vala"
					g_object_ref_sink (_tmp79_);
#line 185 "../src/dialog.vala"
					_g_object_unref0 (rating_star_image);
#line 185 "../src/dialog.vala"
					rating_star_image = _tmp79_;
#line 2074 "dialog.c"
				}
#line 187 "../src/dialog.vala"
				_tmp80_ = (GtkButton*) gtk_button_new ();
#line 187 "../src/dialog.vala"
				g_object_ref_sink (_tmp80_);
#line 187 "../src/dialog.vala"
				_data17_->rating_star_button = _tmp80_;
#line 188 "../src/dialog.vala"
				_tmp81_ = _data17_->rating_star_button;
#line 188 "../src/dialog.vala"
				_tmp82_ = rating_star_image;
#line 188 "../src/dialog.vala"
				gtk_button_set_image (_tmp81_, (GtkWidget*) _tmp82_);
#line 189 "../src/dialog.vala"
				_tmp83_ = _data17_->rating_star_button;
#line 189 "../src/dialog.vala"
				gtk_button_set_relief (_tmp83_, GTK_RELIEF_NONE);
#line 190 "../src/dialog.vala"
				_tmp84_ = _data16_->bookRatingList;
#line 190 "../src/dialog.vala"
				_tmp85_ = _data17_->rating_star_button;
#line 190 "../src/dialog.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp84_, _tmp85_);
#line 191 "../src/dialog.vala"
				_tmp86_ = ratingBox;
#line 191 "../src/dialog.vala"
				_tmp87_ = _data17_->rating_star_button;
#line 191 "../src/dialog.vala"
				gtk_box_pack_start (_tmp86_, (GtkWidget*) _tmp87_, FALSE, TRUE, (guint) 0);
#line 193 "../src/dialog.vala"
				_tmp88_ = _data17_->rating_star_button;
#line 193 "../src/dialog.vala"
				g_signal_connect_data (_tmp88_, "clicked", (GCallback) ______lambda13__gtk_button_clicked, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
#line 180 "../src/dialog.vala"
				_g_object_unref0 (rating_star_image);
#line 180 "../src/dialog.vala"
				block17_data_unref (_data17_);
#line 180 "../src/dialog.vala"
				_data17_ = NULL;
#line 2114 "dialog.c"
			}
		}
	}
#line 229 "../src/dialog.vala"
	if (bookworm_app_book_getBookRating (_data16_->aBook) > 0) {
#line 2120 "dialog.c"
		{
			gint l = 0;
#line 230 "../src/dialog.vala"
			l = 0;
#line 2125 "dialog.c"
			{
				gboolean _tmp89_ = FALSE;
#line 230 "../src/dialog.vala"
				_tmp89_ = TRUE;
#line 230 "../src/dialog.vala"
				while (TRUE) {
#line 2132 "dialog.c"
					GtkIconTheme* _tmp91_;
#line 230 "../src/dialog.vala"
					if (!_tmp89_) {
#line 2136 "dialog.c"
						gint _tmp90_;
#line 230 "../src/dialog.vala"
						_tmp90_ = l;
#line 230 "../src/dialog.vala"
						l = _tmp90_ + 1;
#line 2142 "dialog.c"
					}
#line 230 "../src/dialog.vala"
					_tmp89_ = FALSE;
#line 230 "../src/dialog.vala"
					if (!(l < bookworm_app_book_getBookRating (_data16_->aBook))) {
#line 230 "../src/dialog.vala"
						break;
#line 2150 "dialog.c"
					}
#line 231 "../src/dialog.vala"
					_tmp91_ = gtk_icon_theme_get_default ();
#line 231 "../src/dialog.vala"
					if (gtk_icon_theme_has_icon (_tmp91_, "starred")) {
#line 2156 "dialog.c"
						GeeArrayList* _tmp92_;
						gpointer _tmp93_;
						GtkButton* _tmp94_;
						GtkImage* _tmp95_;
						GtkImage* _tmp96_;
#line 232 "../src/dialog.vala"
						_tmp92_ = _data16_->bookRatingList;
#line 232 "../src/dialog.vala"
						_tmp93_ = gee_abstract_list_get ((GeeAbstractList*) _tmp92_, l);
#line 232 "../src/dialog.vala"
						_tmp94_ = G_TYPE_CHECK_INSTANCE_CAST ((GtkButton*) _tmp93_, gtk_button_get_type (), GtkButton);
#line 232 "../src/dialog.vala"
						_tmp95_ = (GtkImage*) gtk_image_new_from_icon_name ("starred", (GtkIconSize) GTK_ICON_SIZE_MENU);
#line 232 "../src/dialog.vala"
						g_object_ref_sink (_tmp95_);
#line 232 "../src/dialog.vala"
						_tmp96_ = _tmp95_;
#line 232 "../src/dialog.vala"
						gtk_button_set_image (_tmp94_, (GtkWidget*) _tmp96_);
#line 232 "../src/dialog.vala"
						_g_object_unref0 (_tmp96_);
#line 232 "../src/dialog.vala"
						_g_object_unref0 (_tmp94_);
#line 2180 "dialog.c"
					} else {
						GeeArrayList* _tmp97_;
						gpointer _tmp98_;
						GtkButton* _tmp99_;
						GtkImage* _tmp100_;
						GtkImage* _tmp101_;
#line 234 "../src/dialog.vala"
						_tmp97_ = _data16_->bookRatingList;
#line 234 "../src/dialog.vala"
						_tmp98_ = gee_abstract_list_get ((GeeAbstractList*) _tmp97_, l);
#line 234 "../src/dialog.vala"
						_tmp99_ = G_TYPE_CHECK_INSTANCE_CAST ((GtkButton*) _tmp98_, gtk_button_get_type (), GtkButton);
#line 234 "../src/dialog.vala"
						_tmp100_ = (GtkImage*) gtk_image_new_from_file (BOOKWORM_APP_CONSTANTS_RATING_SELECTED_IMAGE_ICON_LOCATION);
#line 234 "../src/dialog.vala"
						g_object_ref_sink (_tmp100_);
#line 234 "../src/dialog.vala"
						_tmp101_ = _tmp100_;
#line 234 "../src/dialog.vala"
						gtk_button_set_image (_tmp99_, (GtkWidget*) _tmp101_);
#line 234 "../src/dialog.vala"
						_g_object_unref0 (_tmp101_);
#line 234 "../src/dialog.vala"
						_g_object_unref0 (_tmp99_);
#line 2205 "dialog.c"
					}
				}
			}
		}
	}
#line 243 "../src/dialog.vala"
	_tmp102_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, BOOKWORM_APP_CONSTANTS_SPACING_BUTTONS);
#line 243 "../src/dialog.vala"
	g_object_ref_sink (_tmp102_);
#line 243 "../src/dialog.vala"
	bookContextMenuBox = _tmp102_;
#line 244 "../src/dialog.vala"
	gtk_container_set_border_width ((GtkContainer*) bookContextMenuBox, (guint) BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 245 "../src/dialog.vala"
	_tmp103_ = contextTitleLabel;
#line 245 "../src/dialog.vala"
	gtk_box_pack_start (bookContextMenuBox, (GtkWidget*) _tmp103_, FALSE, FALSE, (guint) 0);
#line 246 "../src/dialog.vala"
	_tmp104_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 246 "../src/dialog.vala"
	g_object_ref_sink (_tmp104_);
#line 246 "../src/dialog.vala"
	_tmp105_ = _tmp104_;
#line 246 "../src/dialog.vala"
	gtk_box_pack_start (bookContextMenuBox, (GtkWidget*) _tmp105_, TRUE, TRUE, (guint) 0);
#line 246 "../src/dialog.vala"
	_g_object_unref0 (_tmp105_);
#line 247 "../src/dialog.vala"
	_tmp106_ = updateCoverImageBox;
#line 247 "../src/dialog.vala"
	gtk_box_pack_start (bookContextMenuBox, (GtkWidget*) _tmp106_, FALSE, FALSE, (guint) 0);
#line 248 "../src/dialog.vala"
	_tmp107_ = updateTitleBox;
#line 248 "../src/dialog.vala"
	gtk_box_pack_start (bookContextMenuBox, (GtkWidget*) _tmp107_, FALSE, FALSE, (guint) 0);
#line 249 "../src/dialog.vala"
	_tmp108_ = updateAuthorBox;
#line 249 "../src/dialog.vala"
	gtk_box_pack_start (bookContextMenuBox, (GtkWidget*) _tmp108_, FALSE, FALSE, (guint) 0);
#line 250 "../src/dialog.vala"
	_tmp109_ = updateTagsBox;
#line 250 "../src/dialog.vala"
	gtk_box_pack_start (bookContextMenuBox, (GtkWidget*) _tmp109_, FALSE, FALSE, (guint) 0);
#line 251 "../src/dialog.vala"
	_tmp110_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 251 "../src/dialog.vala"
	g_object_ref_sink (_tmp110_);
#line 251 "../src/dialog.vala"
	_tmp111_ = _tmp110_;
#line 251 "../src/dialog.vala"
	gtk_box_pack_start (bookContextMenuBox, (GtkWidget*) _tmp111_, TRUE, TRUE, (guint) 0);
#line 251 "../src/dialog.vala"
	_g_object_unref0 (_tmp111_);
#line 252 "../src/dialog.vala"
	_tmp112_ = ratingBox;
#line 252 "../src/dialog.vala"
	gtk_box_pack_end (bookContextMenuBox, (GtkWidget*) _tmp112_, FALSE, FALSE, (guint) 0);
#line 254 "../src/dialog.vala"
	_tmp113_ = bookContextPopover;
#line 254 "../src/dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp113_, (GtkWidget*) bookContextMenuBox);
#line 257 "../src/dialog.vala"
	_tmp114_ = bookContextPopover;
#line 257 "../src/dialog.vala"
	g_signal_connect_data (_tmp114_, "closed", (GCallback) ___lambda14__gtk_popover_closed, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 261 "../src/dialog.vala"
	_tmp115_ = bookworm_app_book_getBookLocation (_data16_->aBook);
#line 261 "../src/dialog.vala"
	_tmp116_ = _tmp115_;
#line 261 "../src/dialog.vala"
	_tmp117_ = g_strconcat ("[END] [FUNCTION:createBookContextMenu] aBook.location=", _tmp116_, NULL);
#line 261 "../src/dialog.vala"
	_tmp118_ = _tmp117_;
#line 261 "../src/dialog.vala"
	g_debug ("dialog.vala:261: %s", _tmp118_);
#line 261 "../src/dialog.vala"
	_g_free0 (_tmp118_);
#line 261 "../src/dialog.vala"
	_g_free0 (_tmp116_);
#line 262 "../src/dialog.vala"
	result = bookContextPopover;
#line 262 "../src/dialog.vala"
	_g_object_unref0 (bookContextMenuBox);
#line 262 "../src/dialog.vala"
	_g_object_unref0 (ratingBox);
#line 262 "../src/dialog.vala"
	_g_object_unref0 (updateTagsBox);
#line 262 "../src/dialog.vala"
	_g_object_unref0 (updateTagsLabel);
#line 262 "../src/dialog.vala"
	_g_object_unref0 (updateAuthorBox);
#line 262 "../src/dialog.vala"
	_g_object_unref0 (updateAuthorLabel);
#line 262 "../src/dialog.vala"
	_g_object_unref0 (updateTitleBox);
#line 262 "../src/dialog.vala"
	_g_object_unref0 (updateTitleLabel);
#line 262 "../src/dialog.vala"
	_g_object_unref0 (updateCoverImageBox);
#line 262 "../src/dialog.vala"
	_g_object_unref0 (updateCoverImageButton);
#line 262 "../src/dialog.vala"
	_g_object_unref0 (updateImageIcon);
#line 262 "../src/dialog.vala"
	_g_object_unref0 (updateCoverLabel);
#line 262 "../src/dialog.vala"
	_g_object_unref0 (contextTitleLabel);
#line 262 "../src/dialog.vala"
	_g_string_free0 (contextTitle);
#line 262 "../src/dialog.vala"
	block16_data_unref (_data16_);
#line 262 "../src/dialog.vala"
	_data16_ = NULL;
#line 262 "../src/dialog.vala"
	return result;
#line 2321 "dialog.c"
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
#line 265 "../src/dialog.vala"
	g_atomic_int_inc (&_data18_->_ref_count_);
#line 265 "../src/dialog.vala"
	return _data18_;
#line 2331 "dialog.c"
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
#line 265 "../src/dialog.vala"
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
#line 265 "../src/dialog.vala"
		_g_object_unref0 (_data18_->dialog_toast);
#line 265 "../src/dialog.vala"
		_g_object_unref0 (_data18_->libraryPageItemsEntry);
#line 265 "../src/dialog.vala"
		_g_object_unref0 (_data18_->highlightColourButton);
#line 265 "../src/dialog.vala"
		_g_object_unref0 (_data18_->textColourButton);
#line 265 "../src/dialog.vala"
		_g_object_unref0 (_data18_->backgroundColourButton);
#line 265 "../src/dialog.vala"
		_g_object_unref0 (_data18_->fontButton);
#line 265 "../src/dialog.vala"
		_g_object_unref0 (_data18_->showLibraryAtStartSwitch);
#line 265 "../src/dialog.vala"
		_g_object_unref0 (_data18_->twoPageViewSwitch);
#line 265 "../src/dialog.vala"
		_g_object_unref0 (_data18_->nightModeSwitch);
#line 265 "../src/dialog.vala"
		_g_object_unref0 (_data18_->localStorageSwitch);
#line 265 "../src/dialog.vala"
		g_slice_free (Block18Data, _data18_);
#line 2363 "dialog.c"
	}
}

static gboolean
_bookworm_app_app_dialog_filterFont_gtk_font_filter_func (PangoFontFamily* family,
                                                          PangoFontFace* face,
                                                          gpointer self)
{
	gboolean result;
	result = bookworm_app_app_dialog_filterFont (family, face);
#line 316 "../src/dialog.vala"
	return result;
#line 2376 "dialog.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 417 "../src/dialog.vala"
	return self ? g_object_ref (self) : NULL;
#line 2384 "dialog.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 2408 "dialog.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 2416 "dialog.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 2422 "dialog.c"
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 2450 "dialog.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 2456 "dialog.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 2462 "dialog.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 2466 "dialog.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 2474 "dialog.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 2478 "dialog.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 2490 "dialog.c"
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1195 "glib-2.0.vapi"
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1195 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1197 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1197 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 2514 "dialog.c"
		gchar* _tmp2_;
#line 1198 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1198 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1198 "glib-2.0.vapi"
		return result;
#line 2522 "dialog.c"
	} else {
#line 1200 "glib-2.0.vapi"
		result = -1;
#line 1200 "glib-2.0.vapi"
		return result;
#line 2528 "dialog.c"
	}
}

static void
__lambda15_ (Block18Data* _data18_)
{
	gchar* selectedFontandSize = NULL;
	GtkFontButton* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* selectedFontFamily = NULL;
	GtkFontButton* _tmp3_;
	PangoFontFamily* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gint selectedFontSize = 0;
	const gchar* _tmp7_;
	BookwormAppSettings* _tmp15_;
	const gchar* _tmp16_;
	BookwormAppSettings* _tmp17_;
	const gchar* _tmp18_;
	BookwormAppSettings* _tmp19_;
#line 435 "../src/dialog.vala"
	_tmp0_ = _data18_->fontButton;
#line 435 "../src/dialog.vala"
	_tmp1_ = gtk_font_button_get_font_name (_tmp0_);
#line 435 "../src/dialog.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 435 "../src/dialog.vala"
	selectedFontandSize = _tmp2_;
#line 436 "../src/dialog.vala"
	_tmp3_ = _data18_->fontButton;
#line 436 "../src/dialog.vala"
	_tmp4_ = gtk_font_chooser_get_font_family ((GtkFontChooser*) _tmp3_);
#line 436 "../src/dialog.vala"
	_tmp5_ = pango_font_family_get_name (_tmp4_);
#line 436 "../src/dialog.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 436 "../src/dialog.vala"
	selectedFontFamily = _tmp6_;
#line 437 "../src/dialog.vala"
	selectedFontSize = 12;
#line 438 "../src/dialog.vala"
	_tmp7_ = selectedFontandSize;
#line 438 "../src/dialog.vala"
	if (string_index_of (_tmp7_, " ", 0) != -1) {
#line 2575 "dialog.c"
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
#line 439 "../src/dialog.vala"
		_tmp8_ = selectedFontandSize;
#line 439 "../src/dialog.vala"
		_tmp9_ = selectedFontandSize;
#line 439 "../src/dialog.vala"
		_tmp10_ = selectedFontandSize;
#line 439 "../src/dialog.vala"
		_tmp11_ = strlen (_tmp10_);
#line 439 "../src/dialog.vala"
		_tmp12_ = _tmp11_;
#line 439 "../src/dialog.vala"
		_tmp13_ = string_slice (_tmp8_, (glong) string_last_index_of (_tmp9_, " ", 0), (glong) _tmp12_);
#line 439 "../src/dialog.vala"
		_tmp14_ = _tmp13_;
#line 439 "../src/dialog.vala"
		selectedFontSize = atoi (_tmp14_);
#line 439 "../src/dialog.vala"
		_g_free0 (_tmp14_);
#line 2601 "dialog.c"
	}
#line 444 "../src/dialog.vala"
	_tmp15_ = bookworm_app_bookworm_settings;
#line 444 "../src/dialog.vala"
	_tmp16_ = selectedFontandSize;
#line 444 "../src/dialog.vala"
	bookworm_app_settings_set_reading_font_name (_tmp15_, _tmp16_);
#line 445 "../src/dialog.vala"
	_tmp17_ = bookworm_app_bookworm_settings;
#line 445 "../src/dialog.vala"
	_tmp18_ = selectedFontFamily;
#line 445 "../src/dialog.vala"
	bookworm_app_settings_set_reading_font_name_family (_tmp17_, _tmp18_);
#line 446 "../src/dialog.vala"
	_tmp19_ = bookworm_app_bookworm_settings;
#line 446 "../src/dialog.vala"
	bookworm_app_settings_set_reading_font_size (_tmp19_, selectedFontSize);
#line 448 "../src/dialog.vala"
	bookworm_app_content_handler_refreshCurrentPage ();
#line 433 "../src/dialog.vala"
	_g_free0 (selectedFontFamily);
#line 433 "../src/dialog.vala"
	_g_free0 (selectedFontandSize);
#line 2625 "dialog.c"
}

static void
___lambda15__gtk_font_button_font_set (GtkFontButton* _sender,
                                       gpointer self)
{
#line 433 "../src/dialog.vala"
	__lambda15_ (self);
#line 2634 "dialog.c"
}

static void
__lambda16_ (Block18Data* _data18_)
{
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 452 "../src/dialog.vala"
	_tmp0_ = _data18_->localStorageSwitch;
#line 452 "../src/dialog.vala"
	_tmp1_ = gtk_switch_get_active (_tmp0_);
#line 452 "../src/dialog.vala"
	_tmp2_ = _tmp1_;
#line 452 "../src/dialog.vala"
	if (_tmp2_) {
#line 2651 "dialog.c"
		BookwormAppSettings* _tmp3_;
#line 453 "../src/dialog.vala"
		_tmp3_ = bookworm_app_bookworm_settings;
#line 453 "../src/dialog.vala"
		bookworm_app_settings_set_is_local_storage_enabled (_tmp3_, TRUE);
#line 2657 "dialog.c"
	} else {
		BookwormAppSettings* _tmp4_;
#line 455 "../src/dialog.vala"
		_tmp4_ = bookworm_app_bookworm_settings;
#line 455 "../src/dialog.vala"
		bookworm_app_settings_set_is_local_storage_enabled (_tmp4_, FALSE);
#line 2664 "dialog.c"
	}
}

static void
___lambda16__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 451 "../src/dialog.vala"
	__lambda16_ (self);
#line 2675 "dialog.c"
}

static void
__lambda17_ (Block18Data* _data18_)
{
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 460 "../src/dialog.vala"
	_tmp0_ = _data18_->showLibraryAtStartSwitch;
#line 460 "../src/dialog.vala"
	_tmp1_ = gtk_switch_get_active (_tmp0_);
#line 460 "../src/dialog.vala"
	_tmp2_ = _tmp1_;
#line 460 "../src/dialog.vala"
	if (_tmp2_) {
#line 2692 "dialog.c"
		BookwormAppSettings* _tmp3_;
#line 461 "../src/dialog.vala"
		_tmp3_ = bookworm_app_bookworm_settings;
#line 461 "../src/dialog.vala"
		bookworm_app_settings_set_is_show_library_on_start (_tmp3_, TRUE);
#line 2698 "dialog.c"
	} else {
		BookwormAppSettings* _tmp4_;
#line 463 "../src/dialog.vala"
		_tmp4_ = bookworm_app_bookworm_settings;
#line 463 "../src/dialog.vala"
		bookworm_app_settings_set_is_show_library_on_start (_tmp4_, FALSE);
#line 2705 "dialog.c"
	}
}

static void
___lambda17__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 459 "../src/dialog.vala"
	__lambda17_ (self);
#line 2716 "dialog.c"
}

static void
__lambda18_ (Block18Data* _data18_)
{
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 468 "../src/dialog.vala"
	_tmp0_ = _data18_->twoPageViewSwitch;
#line 468 "../src/dialog.vala"
	_tmp1_ = gtk_switch_get_active (_tmp0_);
#line 468 "../src/dialog.vala"
	_tmp2_ = _tmp1_;
#line 468 "../src/dialog.vala"
	if (_tmp2_) {
#line 2733 "dialog.c"
		BookwormAppSettings* _tmp3_;
#line 469 "../src/dialog.vala"
		_tmp3_ = bookworm_app_bookworm_settings;
#line 469 "../src/dialog.vala"
		bookworm_app_settings_set_is_two_page_enabled (_tmp3_, TRUE);
#line 2739 "dialog.c"
	} else {
		BookwormAppSettings* _tmp4_;
#line 471 "../src/dialog.vala"
		_tmp4_ = bookworm_app_bookworm_settings;
#line 471 "../src/dialog.vala"
		bookworm_app_settings_set_is_two_page_enabled (_tmp4_, FALSE);
#line 2746 "dialog.c"
	}
#line 474 "../src/dialog.vala"
	bookworm_app_content_handler_refreshCurrentPage ();
#line 2750 "dialog.c"
}

static void
___lambda18__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 467 "../src/dialog.vala"
	__lambda18_ (self);
#line 2760 "dialog.c"
}

static void
__lambda19_ (Block18Data* _data18_)
{
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 478 "../src/dialog.vala"
	_tmp0_ = _data18_->nightModeSwitch;
#line 478 "../src/dialog.vala"
	_tmp1_ = gtk_switch_get_active (_tmp0_);
#line 478 "../src/dialog.vala"
	_tmp2_ = _tmp1_;
#line 478 "../src/dialog.vala"
	if (_tmp2_) {
#line 2777 "dialog.c"
		BookwormAppSettings* _tmp3_;
		GtkSettings* _tmp4_;
		BookwormAppSettings* _tmp5_;
		const gchar* _tmp6_;
#line 480 "../src/dialog.vala"
		_tmp3_ = bookworm_app_bookworm_settings;
#line 480 "../src/dialog.vala"
		bookworm_app_settings_set_is_dark_theme_enabled (_tmp3_, TRUE);
#line 481 "../src/dialog.vala"
		_tmp4_ = gtk_settings_get_default ();
#line 481 "../src/dialog.vala"
		g_object_set (_tmp4_, "gtk-application-prefer-dark-theme", TRUE, NULL);
#line 483 "../src/dialog.vala"
		_tmp5_ = bookworm_app_bookworm_settings;
#line 483 "../src/dialog.vala"
		_tmp6_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_READING_MODE[4];
#line 483 "../src/dialog.vala"
		bookworm_app_settings_set_reading_profile (_tmp5_, _tmp6_);
#line 485 "../src/dialog.vala"
		bookworm_app_content_handler_refreshCurrentPage ();
#line 2798 "dialog.c"
	} else {
		BookwormAppSettings* _tmp7_;
		GtkSettings* _tmp8_;
		BookwormAppSettings* _tmp9_;
		const gchar* _tmp10_;
#line 488 "../src/dialog.vala"
		_tmp7_ = bookworm_app_bookworm_settings;
#line 488 "../src/dialog.vala"
		bookworm_app_settings_set_is_dark_theme_enabled (_tmp7_, FALSE);
#line 489 "../src/dialog.vala"
		_tmp8_ = gtk_settings_get_default ();
#line 489 "../src/dialog.vala"
		g_object_set (_tmp8_, "gtk-application-prefer-dark-theme", FALSE, NULL);
#line 491 "../src/dialog.vala"
		_tmp9_ = bookworm_app_bookworm_settings;
#line 491 "../src/dialog.vala"
		_tmp10_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_READING_MODE[3];
#line 491 "../src/dialog.vala"
		bookworm_app_settings_set_reading_profile (_tmp9_, _tmp10_);
#line 493 "../src/dialog.vala"
		bookworm_app_content_handler_refreshCurrentPage ();
#line 2820 "dialog.c"
	}
}

static void
___lambda19__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 477 "../src/dialog.vala"
	__lambda19_ (self);
#line 2831 "dialog.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 2850 "dialog.c"
}

static void
__lambda20_ (Block18Data* _data18_)
{
	GtkComboBoxText* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	GtkComboBoxText* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_;
	GtkComboBoxText* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gboolean _tmp35_;
#line 498 "../src/dialog.vala"
	_tmp0_ = bookworm_app_app_dialog_profileCombobox;
#line 498 "../src/dialog.vala"
	_tmp1_ = gtk_combo_box_text_get_active_text (_tmp0_);
#line 498 "../src/dialog.vala"
	_tmp2_ = _tmp1_;
#line 498 "../src/dialog.vala"
	_tmp3_ = string_contains (_tmp2_, " 1");
#line 498 "../src/dialog.vala"
	_g_free0 (_tmp2_);
#line 498 "../src/dialog.vala"
	if (_tmp3_) {
#line 2880 "dialog.c"
		gchar** _tmp4_;
		gint _tmp4__length1;
		const gchar* _tmp5_;
		GtkColorButton* _tmp6_;
		GdkRGBA _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		GtkColorButton* _tmp10_;
		GdkRGBA _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		const gchar* _tmp13_;
		GtkColorButton* _tmp14_;
		GdkRGBA _tmp15_;
#line 499 "../src/dialog.vala"
		_tmp4_ = bookworm_app_bookworm_profileColorList;
#line 499 "../src/dialog.vala"
		_tmp4__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 499 "../src/dialog.vala"
		_tmp5_ = _tmp4_[0];
#line 499 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBATextColor, _tmp5_);
#line 500 "../src/dialog.vala"
		_tmp6_ = _data18_->textColourButton;
#line 500 "../src/dialog.vala"
		_tmp7_ = _data18_->aRGBATextColor;
#line 500 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp6_, &_tmp7_);
#line 502 "../src/dialog.vala"
		_tmp8_ = bookworm_app_bookworm_profileColorList;
#line 502 "../src/dialog.vala"
		_tmp8__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 502 "../src/dialog.vala"
		_tmp9_ = _tmp8_[1];
#line 502 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBABackgroundColor, _tmp9_);
#line 503 "../src/dialog.vala"
		_tmp10_ = _data18_->backgroundColourButton;
#line 503 "../src/dialog.vala"
		_tmp11_ = _data18_->aRGBABackgroundColor;
#line 503 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp10_, &_tmp11_);
#line 505 "../src/dialog.vala"
		_tmp12_ = bookworm_app_bookworm_profileColorList;
#line 505 "../src/dialog.vala"
		_tmp12__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 505 "../src/dialog.vala"
		_tmp13_ = _tmp12_[2];
#line 505 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBAHighlightColor, _tmp13_);
#line 506 "../src/dialog.vala"
		_tmp14_ = _data18_->highlightColourButton;
#line 506 "../src/dialog.vala"
		_tmp15_ = _data18_->aRGBAHighlightColor;
#line 506 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp14_, &_tmp15_);
#line 2938 "dialog.c"
	}
#line 508 "../src/dialog.vala"
	_tmp16_ = bookworm_app_app_dialog_profileCombobox;
#line 508 "../src/dialog.vala"
	_tmp17_ = gtk_combo_box_text_get_active_text (_tmp16_);
#line 508 "../src/dialog.vala"
	_tmp18_ = _tmp17_;
#line 508 "../src/dialog.vala"
	_tmp19_ = string_contains (_tmp18_, " 2");
#line 508 "../src/dialog.vala"
	_g_free0 (_tmp18_);
#line 508 "../src/dialog.vala"
	if (_tmp19_) {
#line 2952 "dialog.c"
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		GtkColorButton* _tmp22_;
		GdkRGBA _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		const gchar* _tmp25_;
		GtkColorButton* _tmp26_;
		GdkRGBA _tmp27_;
		gchar** _tmp28_;
		gint _tmp28__length1;
		const gchar* _tmp29_;
		GtkColorButton* _tmp30_;
		GdkRGBA _tmp31_;
#line 509 "../src/dialog.vala"
		_tmp20_ = bookworm_app_bookworm_profileColorList;
#line 509 "../src/dialog.vala"
		_tmp20__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 509 "../src/dialog.vala"
		_tmp21_ = _tmp20_[3];
#line 509 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBATextColor, _tmp21_);
#line 510 "../src/dialog.vala"
		_tmp22_ = _data18_->textColourButton;
#line 510 "../src/dialog.vala"
		_tmp23_ = _data18_->aRGBATextColor;
#line 510 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp22_, &_tmp23_);
#line 512 "../src/dialog.vala"
		_tmp24_ = bookworm_app_bookworm_profileColorList;
#line 512 "../src/dialog.vala"
		_tmp24__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 512 "../src/dialog.vala"
		_tmp25_ = _tmp24_[4];
#line 512 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBABackgroundColor, _tmp25_);
#line 513 "../src/dialog.vala"
		_tmp26_ = _data18_->backgroundColourButton;
#line 513 "../src/dialog.vala"
		_tmp27_ = _data18_->aRGBABackgroundColor;
#line 513 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp26_, &_tmp27_);
#line 515 "../src/dialog.vala"
		_tmp28_ = bookworm_app_bookworm_profileColorList;
#line 515 "../src/dialog.vala"
		_tmp28__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 515 "../src/dialog.vala"
		_tmp29_ = _tmp28_[5];
#line 515 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBAHighlightColor, _tmp29_);
#line 516 "../src/dialog.vala"
		_tmp30_ = _data18_->highlightColourButton;
#line 516 "../src/dialog.vala"
		_tmp31_ = _data18_->aRGBAHighlightColor;
#line 516 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp30_, &_tmp31_);
#line 3010 "dialog.c"
	}
#line 518 "../src/dialog.vala"
	_tmp32_ = bookworm_app_app_dialog_profileCombobox;
#line 518 "../src/dialog.vala"
	_tmp33_ = gtk_combo_box_text_get_active_text (_tmp32_);
#line 518 "../src/dialog.vala"
	_tmp34_ = _tmp33_;
#line 518 "../src/dialog.vala"
	_tmp35_ = string_contains (_tmp34_, " 3");
#line 518 "../src/dialog.vala"
	_g_free0 (_tmp34_);
#line 518 "../src/dialog.vala"
	if (_tmp35_) {
#line 3024 "dialog.c"
		gchar** _tmp36_;
		gint _tmp36__length1;
		const gchar* _tmp37_;
		GtkColorButton* _tmp38_;
		GdkRGBA _tmp39_;
		gchar** _tmp40_;
		gint _tmp40__length1;
		const gchar* _tmp41_;
		GtkColorButton* _tmp42_;
		GdkRGBA _tmp43_;
		gchar** _tmp44_;
		gint _tmp44__length1;
		const gchar* _tmp45_;
		GtkColorButton* _tmp46_;
		GdkRGBA _tmp47_;
#line 519 "../src/dialog.vala"
		_tmp36_ = bookworm_app_bookworm_profileColorList;
#line 519 "../src/dialog.vala"
		_tmp36__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 519 "../src/dialog.vala"
		_tmp37_ = _tmp36_[6];
#line 519 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBATextColor, _tmp37_);
#line 520 "../src/dialog.vala"
		_tmp38_ = _data18_->textColourButton;
#line 520 "../src/dialog.vala"
		_tmp39_ = _data18_->aRGBATextColor;
#line 520 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp38_, &_tmp39_);
#line 522 "../src/dialog.vala"
		_tmp40_ = bookworm_app_bookworm_profileColorList;
#line 522 "../src/dialog.vala"
		_tmp40__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 522 "../src/dialog.vala"
		_tmp41_ = _tmp40_[7];
#line 522 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBABackgroundColor, _tmp41_);
#line 523 "../src/dialog.vala"
		_tmp42_ = _data18_->backgroundColourButton;
#line 523 "../src/dialog.vala"
		_tmp43_ = _data18_->aRGBABackgroundColor;
#line 523 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp42_, &_tmp43_);
#line 525 "../src/dialog.vala"
		_tmp44_ = bookworm_app_bookworm_profileColorList;
#line 525 "../src/dialog.vala"
		_tmp44__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 525 "../src/dialog.vala"
		_tmp45_ = _tmp44_[8];
#line 525 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBAHighlightColor, _tmp45_);
#line 526 "../src/dialog.vala"
		_tmp46_ = _data18_->highlightColourButton;
#line 526 "../src/dialog.vala"
		_tmp47_ = _data18_->aRGBAHighlightColor;
#line 526 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp46_, &_tmp47_);
#line 3082 "dialog.c"
	}
}

static void
___lambda20__gtk_combo_box_changed (GtkComboBox* _sender,
                                    gpointer self)
{
#line 497 "../src/dialog.vala"
	__lambda20_ (self);
#line 3092 "dialog.c"
}

static void
__lambda21_ (Block18Data* _data18_)
{
	GtkComboBoxText* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	GtkComboBoxText* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	GtkComboBoxText* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
#line 531 "../src/dialog.vala"
	_tmp0_ = bookworm_app_app_dialog_profileCombobox;
#line 531 "../src/dialog.vala"
	_tmp1_ = gtk_combo_box_text_get_active_text (_tmp0_);
#line 531 "../src/dialog.vala"
	_tmp2_ = _tmp1_;
#line 531 "../src/dialog.vala"
	_tmp3_ = string_contains (_tmp2_, " 1");
#line 531 "../src/dialog.vala"
	_g_free0 (_tmp2_);
#line 531 "../src/dialog.vala"
	if (_tmp3_) {
#line 3122 "dialog.c"
		gchar** _tmp4_;
		gint _tmp4__length1;
		GtkColorButton* _tmp5_;
		GdkRGBA _tmp6_ = {0};
		GdkRGBA _tmp7_;
		gchar* _tmp8_;
#line 532 "../src/dialog.vala"
		_tmp4_ = bookworm_app_bookworm_profileColorList;
#line 532 "../src/dialog.vala"
		_tmp4__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 532 "../src/dialog.vala"
		_tmp5_ = _data18_->textColourButton;
#line 532 "../src/dialog.vala"
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp5_, &_tmp6_);
#line 532 "../src/dialog.vala"
		_tmp7_ = _tmp6_;
#line 532 "../src/dialog.vala"
		_tmp8_ = bookworm_app_app_dialog_rgba_to_hex (&_tmp7_, FALSE, TRUE);
#line 532 "../src/dialog.vala"
		_g_free0 (_tmp4_[0]);
#line 532 "../src/dialog.vala"
		_tmp4_[0] = _tmp8_;
#line 3145 "dialog.c"
	}
#line 534 "../src/dialog.vala"
	_tmp9_ = bookworm_app_app_dialog_profileCombobox;
#line 534 "../src/dialog.vala"
	_tmp10_ = gtk_combo_box_text_get_active_text (_tmp9_);
#line 534 "../src/dialog.vala"
	_tmp11_ = _tmp10_;
#line 534 "../src/dialog.vala"
	_tmp12_ = string_contains (_tmp11_, " 2");
#line 534 "../src/dialog.vala"
	_g_free0 (_tmp11_);
#line 534 "../src/dialog.vala"
	if (_tmp12_) {
#line 3159 "dialog.c"
		gchar** _tmp13_;
		gint _tmp13__length1;
		GtkColorButton* _tmp14_;
		GdkRGBA _tmp15_ = {0};
		GdkRGBA _tmp16_;
		gchar* _tmp17_;
#line 535 "../src/dialog.vala"
		_tmp13_ = bookworm_app_bookworm_profileColorList;
#line 535 "../src/dialog.vala"
		_tmp13__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 535 "../src/dialog.vala"
		_tmp14_ = _data18_->textColourButton;
#line 535 "../src/dialog.vala"
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp14_, &_tmp15_);
#line 535 "../src/dialog.vala"
		_tmp16_ = _tmp15_;
#line 535 "../src/dialog.vala"
		_tmp17_ = bookworm_app_app_dialog_rgba_to_hex (&_tmp16_, FALSE, TRUE);
#line 535 "../src/dialog.vala"
		_g_free0 (_tmp13_[3]);
#line 535 "../src/dialog.vala"
		_tmp13_[3] = _tmp17_;
#line 3182 "dialog.c"
	}
#line 537 "../src/dialog.vala"
	_tmp18_ = bookworm_app_app_dialog_profileCombobox;
#line 537 "../src/dialog.vala"
	_tmp19_ = gtk_combo_box_text_get_active_text (_tmp18_);
#line 537 "../src/dialog.vala"
	_tmp20_ = _tmp19_;
#line 537 "../src/dialog.vala"
	_tmp21_ = string_contains (_tmp20_, " 3");
#line 537 "../src/dialog.vala"
	_g_free0 (_tmp20_);
#line 537 "../src/dialog.vala"
	if (_tmp21_) {
#line 3196 "dialog.c"
		gchar** _tmp22_;
		gint _tmp22__length1;
		GtkColorButton* _tmp23_;
		GdkRGBA _tmp24_ = {0};
		GdkRGBA _tmp25_;
		gchar* _tmp26_;
#line 538 "../src/dialog.vala"
		_tmp22_ = bookworm_app_bookworm_profileColorList;
#line 538 "../src/dialog.vala"
		_tmp22__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 538 "../src/dialog.vala"
		_tmp23_ = _data18_->textColourButton;
#line 538 "../src/dialog.vala"
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp23_, &_tmp24_);
#line 538 "../src/dialog.vala"
		_tmp25_ = _tmp24_;
#line 538 "../src/dialog.vala"
		_tmp26_ = bookworm_app_app_dialog_rgba_to_hex (&_tmp25_, FALSE, TRUE);
#line 538 "../src/dialog.vala"
		_g_free0 (_tmp22_[6]);
#line 538 "../src/dialog.vala"
		_tmp22_[6] = _tmp26_;
#line 3219 "dialog.c"
	}
#line 540 "../src/dialog.vala"
	bookworm_app_app_dialog_updateProfileColorToSettings ();
#line 542 "../src/dialog.vala"
	bookworm_app_content_handler_refreshCurrentPage ();
#line 3225 "dialog.c"
}

static void
___lambda21__gtk_color_button_color_set (GtkColorButton* _sender,
                                         gpointer self)
{
#line 530 "../src/dialog.vala"
	__lambda21_ (self);
#line 3234 "dialog.c"
}

static void
__lambda22_ (Block18Data* _data18_)
{
	GtkComboBoxText* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	GtkComboBoxText* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	GtkComboBoxText* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
#line 546 "../src/dialog.vala"
	_tmp0_ = bookworm_app_app_dialog_profileCombobox;
#line 546 "../src/dialog.vala"
	_tmp1_ = gtk_combo_box_text_get_active_text (_tmp0_);
#line 546 "../src/dialog.vala"
	_tmp2_ = _tmp1_;
#line 546 "../src/dialog.vala"
	_tmp3_ = string_contains (_tmp2_, " 1");
#line 546 "../src/dialog.vala"
	_g_free0 (_tmp2_);
#line 546 "../src/dialog.vala"
	if (_tmp3_) {
#line 3264 "dialog.c"
		gchar** _tmp4_;
		gint _tmp4__length1;
		GtkColorButton* _tmp5_;
		GdkRGBA _tmp6_ = {0};
		GdkRGBA _tmp7_;
		gchar* _tmp8_;
#line 547 "../src/dialog.vala"
		_tmp4_ = bookworm_app_bookworm_profileColorList;
#line 547 "../src/dialog.vala"
		_tmp4__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 547 "../src/dialog.vala"
		_tmp5_ = _data18_->backgroundColourButton;
#line 547 "../src/dialog.vala"
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp5_, &_tmp6_);
#line 547 "../src/dialog.vala"
		_tmp7_ = _tmp6_;
#line 547 "../src/dialog.vala"
		_tmp8_ = bookworm_app_app_dialog_rgba_to_hex (&_tmp7_, FALSE, TRUE);
#line 547 "../src/dialog.vala"
		_g_free0 (_tmp4_[1]);
#line 547 "../src/dialog.vala"
		_tmp4_[1] = _tmp8_;
#line 3287 "dialog.c"
	}
#line 549 "../src/dialog.vala"
	_tmp9_ = bookworm_app_app_dialog_profileCombobox;
#line 549 "../src/dialog.vala"
	_tmp10_ = gtk_combo_box_text_get_active_text (_tmp9_);
#line 549 "../src/dialog.vala"
	_tmp11_ = _tmp10_;
#line 549 "../src/dialog.vala"
	_tmp12_ = string_contains (_tmp11_, " 2");
#line 549 "../src/dialog.vala"
	_g_free0 (_tmp11_);
#line 549 "../src/dialog.vala"
	if (_tmp12_) {
#line 3301 "dialog.c"
		gchar** _tmp13_;
		gint _tmp13__length1;
		GtkColorButton* _tmp14_;
		GdkRGBA _tmp15_ = {0};
		GdkRGBA _tmp16_;
		gchar* _tmp17_;
#line 550 "../src/dialog.vala"
		_tmp13_ = bookworm_app_bookworm_profileColorList;
#line 550 "../src/dialog.vala"
		_tmp13__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 550 "../src/dialog.vala"
		_tmp14_ = _data18_->backgroundColourButton;
#line 550 "../src/dialog.vala"
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp14_, &_tmp15_);
#line 550 "../src/dialog.vala"
		_tmp16_ = _tmp15_;
#line 550 "../src/dialog.vala"
		_tmp17_ = bookworm_app_app_dialog_rgba_to_hex (&_tmp16_, FALSE, TRUE);
#line 550 "../src/dialog.vala"
		_g_free0 (_tmp13_[4]);
#line 550 "../src/dialog.vala"
		_tmp13_[4] = _tmp17_;
#line 3324 "dialog.c"
	}
#line 552 "../src/dialog.vala"
	_tmp18_ = bookworm_app_app_dialog_profileCombobox;
#line 552 "../src/dialog.vala"
	_tmp19_ = gtk_combo_box_text_get_active_text (_tmp18_);
#line 552 "../src/dialog.vala"
	_tmp20_ = _tmp19_;
#line 552 "../src/dialog.vala"
	_tmp21_ = string_contains (_tmp20_, " 3");
#line 552 "../src/dialog.vala"
	_g_free0 (_tmp20_);
#line 552 "../src/dialog.vala"
	if (_tmp21_) {
#line 3338 "dialog.c"
		gchar** _tmp22_;
		gint _tmp22__length1;
		GtkColorButton* _tmp23_;
		GdkRGBA _tmp24_ = {0};
		GdkRGBA _tmp25_;
		gchar* _tmp26_;
#line 553 "../src/dialog.vala"
		_tmp22_ = bookworm_app_bookworm_profileColorList;
#line 553 "../src/dialog.vala"
		_tmp22__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 553 "../src/dialog.vala"
		_tmp23_ = _data18_->backgroundColourButton;
#line 553 "../src/dialog.vala"
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp23_, &_tmp24_);
#line 553 "../src/dialog.vala"
		_tmp25_ = _tmp24_;
#line 553 "../src/dialog.vala"
		_tmp26_ = bookworm_app_app_dialog_rgba_to_hex (&_tmp25_, FALSE, TRUE);
#line 553 "../src/dialog.vala"
		_g_free0 (_tmp22_[7]);
#line 553 "../src/dialog.vala"
		_tmp22_[7] = _tmp26_;
#line 3361 "dialog.c"
	}
#line 555 "../src/dialog.vala"
	bookworm_app_app_dialog_updateProfileColorToSettings ();
#line 557 "../src/dialog.vala"
	bookworm_app_content_handler_refreshCurrentPage ();
#line 3367 "dialog.c"
}

static void
___lambda22__gtk_color_button_color_set (GtkColorButton* _sender,
                                         gpointer self)
{
#line 545 "../src/dialog.vala"
	__lambda22_ (self);
#line 3376 "dialog.c"
}

static void
__lambda23_ (Block18Data* _data18_)
{
	GtkComboBoxText* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	GtkComboBoxText* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	GtkComboBoxText* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
#line 561 "../src/dialog.vala"
	_tmp0_ = bookworm_app_app_dialog_profileCombobox;
#line 561 "../src/dialog.vala"
	_tmp1_ = gtk_combo_box_text_get_active_text (_tmp0_);
#line 561 "../src/dialog.vala"
	_tmp2_ = _tmp1_;
#line 561 "../src/dialog.vala"
	_tmp3_ = string_contains (_tmp2_, " 1");
#line 561 "../src/dialog.vala"
	_g_free0 (_tmp2_);
#line 561 "../src/dialog.vala"
	if (_tmp3_) {
#line 3406 "dialog.c"
		gchar** _tmp4_;
		gint _tmp4__length1;
		GtkColorButton* _tmp5_;
		GdkRGBA _tmp6_ = {0};
		GdkRGBA _tmp7_;
		gchar* _tmp8_;
#line 562 "../src/dialog.vala"
		_tmp4_ = bookworm_app_bookworm_profileColorList;
#line 562 "../src/dialog.vala"
		_tmp4__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 562 "../src/dialog.vala"
		_tmp5_ = _data18_->highlightColourButton;
#line 562 "../src/dialog.vala"
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp5_, &_tmp6_);
#line 562 "../src/dialog.vala"
		_tmp7_ = _tmp6_;
#line 562 "../src/dialog.vala"
		_tmp8_ = bookworm_app_app_dialog_rgba_to_hex (&_tmp7_, FALSE, TRUE);
#line 562 "../src/dialog.vala"
		_g_free0 (_tmp4_[2]);
#line 562 "../src/dialog.vala"
		_tmp4_[2] = _tmp8_;
#line 3429 "dialog.c"
	}
#line 564 "../src/dialog.vala"
	_tmp9_ = bookworm_app_app_dialog_profileCombobox;
#line 564 "../src/dialog.vala"
	_tmp10_ = gtk_combo_box_text_get_active_text (_tmp9_);
#line 564 "../src/dialog.vala"
	_tmp11_ = _tmp10_;
#line 564 "../src/dialog.vala"
	_tmp12_ = string_contains (_tmp11_, " 2");
#line 564 "../src/dialog.vala"
	_g_free0 (_tmp11_);
#line 564 "../src/dialog.vala"
	if (_tmp12_) {
#line 3443 "dialog.c"
		gchar** _tmp13_;
		gint _tmp13__length1;
		GtkColorButton* _tmp14_;
		GdkRGBA _tmp15_ = {0};
		GdkRGBA _tmp16_;
		gchar* _tmp17_;
#line 565 "../src/dialog.vala"
		_tmp13_ = bookworm_app_bookworm_profileColorList;
#line 565 "../src/dialog.vala"
		_tmp13__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 565 "../src/dialog.vala"
		_tmp14_ = _data18_->highlightColourButton;
#line 565 "../src/dialog.vala"
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp14_, &_tmp15_);
#line 565 "../src/dialog.vala"
		_tmp16_ = _tmp15_;
#line 565 "../src/dialog.vala"
		_tmp17_ = bookworm_app_app_dialog_rgba_to_hex (&_tmp16_, FALSE, TRUE);
#line 565 "../src/dialog.vala"
		_g_free0 (_tmp13_[5]);
#line 565 "../src/dialog.vala"
		_tmp13_[5] = _tmp17_;
#line 3466 "dialog.c"
	}
#line 567 "../src/dialog.vala"
	_tmp18_ = bookworm_app_app_dialog_profileCombobox;
#line 567 "../src/dialog.vala"
	_tmp19_ = gtk_combo_box_text_get_active_text (_tmp18_);
#line 567 "../src/dialog.vala"
	_tmp20_ = _tmp19_;
#line 567 "../src/dialog.vala"
	_tmp21_ = string_contains (_tmp20_, " 3");
#line 567 "../src/dialog.vala"
	_g_free0 (_tmp20_);
#line 567 "../src/dialog.vala"
	if (_tmp21_) {
#line 3480 "dialog.c"
		gchar** _tmp22_;
		gint _tmp22__length1;
		GtkColorButton* _tmp23_;
		GdkRGBA _tmp24_ = {0};
		GdkRGBA _tmp25_;
		gchar* _tmp26_;
#line 568 "../src/dialog.vala"
		_tmp22_ = bookworm_app_bookworm_profileColorList;
#line 568 "../src/dialog.vala"
		_tmp22__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 568 "../src/dialog.vala"
		_tmp23_ = _data18_->highlightColourButton;
#line 568 "../src/dialog.vala"
		gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp23_, &_tmp24_);
#line 568 "../src/dialog.vala"
		_tmp25_ = _tmp24_;
#line 568 "../src/dialog.vala"
		_tmp26_ = bookworm_app_app_dialog_rgba_to_hex (&_tmp25_, FALSE, TRUE);
#line 568 "../src/dialog.vala"
		_g_free0 (_tmp22_[8]);
#line 568 "../src/dialog.vala"
		_tmp22_[8] = _tmp26_;
#line 3503 "dialog.c"
	}
#line 570 "../src/dialog.vala"
	bookworm_app_app_dialog_updateProfileColorToSettings ();
#line 572 "../src/dialog.vala"
	bookworm_app_content_handler_refreshCurrentPage ();
#line 3509 "dialog.c"
}

static void
___lambda23__gtk_color_button_color_set (GtkColorButton* _sender,
                                         gpointer self)
{
#line 560 "../src/dialog.vala"
	__lambda23_ (self);
#line 3518 "dialog.c"
}

static void
__lambda24_ (Block18Data* _data18_)
{
	GeeArrayList* selectedDir = NULL;
	GtkApplicationWindow* _tmp0_;
	GeeArrayList* _tmp1_;
	GtkTreeModel* aTreeModel = NULL;
	GtkComboBoxText* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	gint numberOfDirs = 0;
	GtkTreeModel* _tmp7_;
	GtkTreeIter _tmp8_;
#line 577 "../src/dialog.vala"
	_tmp0_ = bookworm_app_bookworm_window;
#line 577 "../src/dialog.vala"
	_tmp1_ = bookworm_app_utils_selectDirChooser (_ ("Select folder"), (GtkWindow*) _tmp0_, FALSE);
#line 577 "../src/dialog.vala"
	selectedDir = _tmp1_;
#line 582 "../src/dialog.vala"
	_tmp2_ = bookworm_app_app_dialog_directoryComboBox;
#line 582 "../src/dialog.vala"
	_tmp3_ = gtk_combo_box_get_model ((GtkComboBox*) _tmp2_);
#line 582 "../src/dialog.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 582 "../src/dialog.vala"
	aTreeModel = _tmp4_;
#line 584 "../src/dialog.vala"
	_tmp5_ = aTreeModel;
#line 584 "../src/dialog.vala"
	gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
#line 584 "../src/dialog.vala"
	iter = _tmp6_;
#line 585 "../src/dialog.vala"
	_tmp7_ = aTreeModel;
#line 585 "../src/dialog.vala"
	_tmp8_ = iter;
#line 585 "../src/dialog.vala"
	numberOfDirs = gtk_tree_model_iter_n_children (_tmp7_, &_tmp8_);
#line 3563 "dialog.c"
	{
		GeeArrayList* _dir_list = NULL;
		GeeArrayList* _tmp9_;
		gint _dir_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _dir_index = 0;
#line 586 "../src/dialog.vala"
		_tmp9_ = selectedDir;
#line 586 "../src/dialog.vala"
		_dir_list = _tmp9_;
#line 586 "../src/dialog.vala"
		_tmp10_ = _dir_list;
#line 586 "../src/dialog.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
#line 586 "../src/dialog.vala"
		_tmp12_ = _tmp11_;
#line 586 "../src/dialog.vala"
		_dir_size = _tmp12_;
#line 586 "../src/dialog.vala"
		_dir_index = -1;
#line 586 "../src/dialog.vala"
		while (TRUE) {
#line 3588 "dialog.c"
			gint _tmp13_;
			gint _tmp14_;
			gchar* dir = NULL;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			GtkComboBoxText* _tmp17_;
			const gchar* _tmp18_;
			GString* _tmp19_;
			const gchar* _tmp20_;
			GString* _tmp21_;
			BookwormAppSettings* _tmp22_;
			GString* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			GtkComboBoxText* _tmp26_;
			GString* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
#line 586 "../src/dialog.vala"
			_dir_index = _dir_index + 1;
#line 586 "../src/dialog.vala"
			_tmp13_ = _dir_index;
#line 586 "../src/dialog.vala"
			_tmp14_ = _dir_size;
#line 586 "../src/dialog.vala"
			if (!(_tmp13_ < _tmp14_)) {
#line 586 "../src/dialog.vala"
				break;
#line 3618 "dialog.c"
			}
#line 586 "../src/dialog.vala"
			_tmp15_ = _dir_list;
#line 586 "../src/dialog.vala"
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _dir_index);
#line 586 "../src/dialog.vala"
			dir = (gchar*) _tmp16_;
#line 587 "../src/dialog.vala"
			_tmp17_ = bookworm_app_app_dialog_directoryComboBox;
#line 587 "../src/dialog.vala"
			_tmp18_ = dir;
#line 587 "../src/dialog.vala"
			gtk_combo_box_text_append_text (_tmp17_, _tmp18_);
#line 588 "../src/dialog.vala"
			_tmp19_ = bookworm_app_app_dialog_scanDirList;
#line 588 "../src/dialog.vala"
			_tmp20_ = dir;
#line 588 "../src/dialog.vala"
			_tmp21_ = g_string_append (_tmp19_, _tmp20_);
#line 588 "../src/dialog.vala"
			g_string_append (_tmp21_, "~~");
#line 589 "../src/dialog.vala"
			_tmp22_ = bookworm_app_bookworm_settings;
#line 589 "../src/dialog.vala"
			_tmp23_ = bookworm_app_app_dialog_scanDirList;
#line 589 "../src/dialog.vala"
			_tmp24_ = _tmp23_->str;
#line 589 "../src/dialog.vala"
			bookworm_app_settings_set_list_of_scan_dirs (_tmp22_, _tmp24_);
#line 590 "../src/dialog.vala"
			_tmp25_ = numberOfDirs;
#line 590 "../src/dialog.vala"
			numberOfDirs = _tmp25_ + 1;
#line 591 "../src/dialog.vala"
			_tmp26_ = bookworm_app_app_dialog_directoryComboBox;
#line 591 "../src/dialog.vala"
			gtk_combo_box_set_active ((GtkComboBox*) _tmp26_, numberOfDirs);
#line 592 "../src/dialog.vala"
			_tmp27_ = bookworm_app_app_dialog_scanDirList;
#line 592 "../src/dialog.vala"
			_tmp28_ = _tmp27_->str;
#line 592 "../src/dialog.vala"
			_tmp29_ = g_strconcat ("value of scanDirList after adding dir:", _tmp28_, NULL);
#line 592 "../src/dialog.vala"
			_tmp30_ = _tmp29_;
#line 592 "../src/dialog.vala"
			g_debug ("dialog.vala:592: %s", _tmp30_);
#line 592 "../src/dialog.vala"
			_g_free0 (_tmp30_);
#line 586 "../src/dialog.vala"
			_g_free0 (dir);
#line 3670 "dialog.c"
		}
	}
#line 595 "../src/dialog.vala"
	granite_widgets_toast_send_notification (_data18_->dialog_toast);
#line 576 "../src/dialog.vala"
	_g_object_unref0 (aTreeModel);
#line 576 "../src/dialog.vala"
	_g_object_unref0 (selectedDir);
#line 3679 "dialog.c"
}

static void
___lambda24__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 576 "../src/dialog.vala"
	__lambda24_ (self);
#line 3688 "dialog.c"
}

static void
__lambda26_ (void)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkComboBoxText* _tmp2_;
#line 599 "../src/dialog.vala"
	_tmp2_ = bookworm_app_app_dialog_directoryComboBox;
#line 599 "../src/dialog.vala"
	if (_tmp2_ != NULL) {
#line 3701 "dialog.c"
		GtkComboBoxText* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 600 "../src/dialog.vala"
		_tmp3_ = bookworm_app_app_dialog_directoryComboBox;
#line 600 "../src/dialog.vala"
		_tmp4_ = gtk_combo_box_text_get_active_text (_tmp3_);
#line 600 "../src/dialog.vala"
		_tmp5_ = _tmp4_;
#line 600 "../src/dialog.vala"
		_tmp1_ = _tmp5_ != NULL;
#line 600 "../src/dialog.vala"
		_g_free0 (_tmp5_);
#line 3715 "dialog.c"
	} else {
#line 599 "../src/dialog.vala"
		_tmp1_ = FALSE;
#line 3719 "dialog.c"
	}
#line 599 "../src/dialog.vala"
	if (_tmp1_) {
#line 3723 "dialog.c"
		GtkComboBoxText* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 601 "../src/dialog.vala"
		_tmp6_ = bookworm_app_app_dialog_directoryComboBox;
#line 601 "../src/dialog.vala"
		_tmp7_ = gtk_combo_box_text_get_active_text (_tmp6_);
#line 601 "../src/dialog.vala"
		_tmp8_ = _tmp7_;
#line 601 "../src/dialog.vala"
		_tmp9_ = strlen (_tmp8_);
#line 601 "../src/dialog.vala"
		_tmp10_ = _tmp9_;
#line 601 "../src/dialog.vala"
		_tmp0_ = _tmp10_ > 1;
#line 601 "../src/dialog.vala"
		_g_free0 (_tmp8_);
#line 3743 "dialog.c"
	} else {
#line 599 "../src/dialog.vala"
		_tmp0_ = FALSE;
#line 3747 "dialog.c"
	}
#line 599 "../src/dialog.vala"
	if (_tmp0_) {
#line 3751 "dialog.c"
		GString* _tmp11_;
		GString* _tmp12_;
		const gchar* _tmp13_;
		GtkComboBoxText* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GtkComboBoxText* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GString* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		BookwormAppSettings* _tmp32_;
		GString* _tmp33_;
		const gchar* _tmp34_;
		gint currentActiveID = 0;
		GtkComboBoxText* _tmp35_;
		GtkComboBoxText* _tmp36_;
#line 603 "../src/dialog.vala"
		_tmp11_ = bookworm_app_app_dialog_scanDirList;
#line 603 "../src/dialog.vala"
		_tmp12_ = bookworm_app_app_dialog_scanDirList;
#line 603 "../src/dialog.vala"
		_tmp13_ = _tmp12_->str;
#line 603 "../src/dialog.vala"
		_tmp14_ = bookworm_app_app_dialog_directoryComboBox;
#line 603 "../src/dialog.vala"
		_tmp15_ = gtk_combo_box_text_get_active_text (_tmp14_);
#line 603 "../src/dialog.vala"
		_tmp16_ = _tmp15_;
#line 603 "../src/dialog.vala"
		_tmp17_ = g_strconcat (_tmp16_, "~~", NULL);
#line 603 "../src/dialog.vala"
		_tmp18_ = _tmp17_;
#line 603 "../src/dialog.vala"
		_tmp19_ = string_replace (_tmp13_, _tmp18_, "");
#line 603 "../src/dialog.vala"
		_tmp20_ = _tmp19_;
#line 603 "../src/dialog.vala"
		g_string_assign (_tmp11_, _tmp20_);
#line 603 "../src/dialog.vala"
		_g_free0 (_tmp20_);
#line 603 "../src/dialog.vala"
		_g_free0 (_tmp18_);
#line 603 "../src/dialog.vala"
		_g_free0 (_tmp16_);
#line 604 "../src/dialog.vala"
		_tmp21_ = bookworm_app_app_dialog_directoryComboBox;
#line 604 "../src/dialog.vala"
		_tmp22_ = gtk_combo_box_text_get_active_text (_tmp21_);
#line 604 "../src/dialog.vala"
		_tmp23_ = _tmp22_;
#line 604 "../src/dialog.vala"
		_tmp24_ = g_strconcat ("value of scanDirList after removal of [", _tmp23_, NULL);
#line 604 "../src/dialog.vala"
		_tmp25_ = _tmp24_;
#line 604 "../src/dialog.vala"
		_tmp26_ = g_strconcat (_tmp25_, "]:", NULL);
#line 604 "../src/dialog.vala"
		_tmp27_ = _tmp26_;
#line 604 "../src/dialog.vala"
		_tmp28_ = bookworm_app_app_dialog_scanDirList;
#line 604 "../src/dialog.vala"
		_tmp29_ = _tmp28_->str;
#line 604 "../src/dialog.vala"
		_tmp30_ = g_strconcat (_tmp27_, _tmp29_, NULL);
#line 604 "../src/dialog.vala"
		_tmp31_ = _tmp30_;
#line 604 "../src/dialog.vala"
		g_debug ("dialog.vala:604: %s", _tmp31_);
#line 604 "../src/dialog.vala"
		_g_free0 (_tmp31_);
#line 604 "../src/dialog.vala"
		_g_free0 (_tmp27_);
#line 604 "../src/dialog.vala"
		_g_free0 (_tmp25_);
#line 604 "../src/dialog.vala"
		_g_free0 (_tmp23_);
#line 605 "../src/dialog.vala"
		_tmp32_ = bookworm_app_bookworm_settings;
#line 605 "../src/dialog.vala"
		_tmp33_ = bookworm_app_app_dialog_scanDirList;
#line 605 "../src/dialog.vala"
		_tmp34_ = _tmp33_->str;
#line 605 "../src/dialog.vala"
		bookworm_app_settings_set_list_of_scan_dirs (_tmp32_, _tmp34_);
#line 606 "../src/dialog.vala"
		_tmp35_ = bookworm_app_app_dialog_directoryComboBox;
#line 606 "../src/dialog.vala"
		currentActiveID = gtk_combo_box_get_active ((GtkComboBox*) _tmp35_);
#line 607 "../src/dialog.vala"
		_tmp36_ = bookworm_app_app_dialog_directoryComboBox;
#line 607 "../src/dialog.vala"
		gtk_combo_box_text_remove (_tmp36_, currentActiveID);
#line 3855 "dialog.c"
	}
}

static void
___lambda26__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 598 "../src/dialog.vala"
	__lambda26_ ();
#line 3865 "dialog.c"
}

static void
__lambda27_ (Block18Data* _data18_)
{
	BookwormAppSettings* _tmp0_;
	const gchar* _tmp1_;
#line 612 "../src/dialog.vala"
	_tmp0_ = bookworm_app_bookworm_settings;
#line 612 "../src/dialog.vala"
	_tmp1_ = gtk_entry_get_text (_data18_->libraryPageItemsEntry);
#line 612 "../src/dialog.vala"
	bookworm_app_settings_set_library_page_items (_tmp0_, atoi (_tmp1_));
#line 3879 "dialog.c"
}

static void
___lambda27__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
#line 611 "../src/dialog.vala"
	__lambda27_ (self);
#line 3888 "dialog.c"
}

static gchar*
_variant_get1 (GVariant* value)
{
#line 617 "../src/dialog.vala"
	return g_variant_dup_string (value, NULL);
#line 3896 "dialog.c"
}

static gboolean
_variant_get2 (GVariant* value)
{
#line 649 "../src/dialog.vala"
	return g_variant_get_boolean (value);
#line 3904 "dialog.c"
}

static gboolean
_variant_get3 (GVariant* value)
{
#line 653 "../src/dialog.vala"
	return g_variant_get_boolean (value);
#line 3912 "dialog.c"
}

static gboolean
_variant_get4 (GVariant* value)
{
#line 657 "../src/dialog.vala"
	return g_variant_get_boolean (value);
#line 3920 "dialog.c"
}

static gboolean
_variant_get5 (GVariant* value)
{
#line 661 "../src/dialog.vala"
	return g_variant_get_boolean (value);
#line 3928 "dialog.c"
}

static gchar*
_variant_get6 (GVariant* value)
{
#line 664 "../src/dialog.vala"
	return g_variant_dup_string (value, NULL);
#line 3936 "dialog.c"
}

static gchar*
_variant_get7 (GVariant* value)
{
#line 665 "../src/dialog.vala"
	return g_variant_dup_string (value, NULL);
#line 3944 "dialog.c"
}

static gint
_variant_get8 (GVariant* value)
{
#line 666 "../src/dialog.vala"
	return g_variant_get_int32 (value);
#line 3952 "dialog.c"
}

static gint
_variant_get9 (GVariant* value)
{
#line 670 "../src/dialog.vala"
	return g_variant_get_int32 (value);
#line 3960 "dialog.c"
}

static gint
_variant_get10 (GVariant* value)
{
#line 671 "../src/dialog.vala"
	return g_variant_get_int32 (value);
#line 3968 "dialog.c"
}

static gboolean
__lambda28_ (Block18Data* _data18_)
{
	GSettings* bookwormSettings = NULL;
	GSettings* _tmp0_;
	gchar* defaultProfileColors = NULL;
	GSettings* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	GtkComboBoxText* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	GtkComboBoxText* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gboolean _tmp28_;
	GtkComboBoxText* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gboolean _tmp44_;
	BookwormAppSettings* _tmp57_;
	const gchar* _tmp58_;
	GtkSwitch* _tmp59_;
	BookwormAppSettings* _tmp60_;
	GSettings* _tmp61_;
	GVariant* _tmp62_;
	GVariant* _tmp63_;
	gboolean _tmp64_;
	GtkSwitch* _tmp65_;
	BookwormAppSettings* _tmp66_;
	GSettings* _tmp67_;
	GVariant* _tmp68_;
	GVariant* _tmp69_;
	gboolean _tmp70_;
	GtkSwitch* _tmp71_;
	BookwormAppSettings* _tmp72_;
	GSettings* _tmp73_;
	GVariant* _tmp74_;
	GVariant* _tmp75_;
	gboolean _tmp76_;
	GtkSwitch* _tmp77_;
	BookwormAppSettings* _tmp78_;
	GSettings* _tmp79_;
	GVariant* _tmp80_;
	GVariant* _tmp81_;
	gboolean _tmp82_;
	BookwormAppSettings* _tmp83_;
	GSettings* _tmp84_;
	GVariant* _tmp85_;
	GVariant* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	BookwormAppSettings* _tmp89_;
	GSettings* _tmp90_;
	GVariant* _tmp91_;
	GVariant* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	BookwormAppSettings* _tmp95_;
	GSettings* _tmp96_;
	GVariant* _tmp97_;
	GVariant* _tmp98_;
	gint _tmp99_;
	GtkFontButton* _tmp100_;
	BookwormAppSettings* _tmp101_;
	const gchar* _tmp102_;
	const gchar* _tmp103_;
	GSettings* _tmp104_;
	GVariant* _tmp105_;
	GVariant* _tmp106_;
	gint _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	BookwormAppSettings* _tmp110_;
	GSettings* _tmp111_;
	GVariant* _tmp112_;
	GVariant* _tmp113_;
	gint _tmp114_;
	gboolean result;
#line 616 "../src/dialog.vala"
	_tmp0_ = g_settings_new (BOOKWORM_APP_CONSTANTS_bookworm_id);
#line 616 "../src/dialog.vala"
	bookwormSettings = _tmp0_;
#line 617 "../src/dialog.vala"
	_tmp1_ = bookwormSettings;
#line 617 "../src/dialog.vala"
	_tmp2_ = g_settings_get_default_value (_tmp1_, "list-of-profile-colors");
#line 617 "../src/dialog.vala"
	_tmp3_ = _tmp2_;
#line 617 "../src/dialog.vala"
	_tmp4_ = _variant_get1 (_tmp3_);
#line 617 "../src/dialog.vala"
	_tmp5_ = _tmp4_;
#line 617 "../src/dialog.vala"
	_g_variant_unref0 (_tmp3_);
#line 617 "../src/dialog.vala"
	defaultProfileColors = _tmp5_;
#line 618 "../src/dialog.vala"
	_tmp6_ = defaultProfileColors;
#line 618 "../src/dialog.vala"
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, ",", 0);
#line 618 "../src/dialog.vala"
	bookworm_app_bookworm_profileColorList = (_vala_array_free (bookworm_app_bookworm_profileColorList, bookworm_app_bookworm_profileColorList_length1, (GDestroyNotify) g_free), NULL);
#line 618 "../src/dialog.vala"
	bookworm_app_bookworm_profileColorList = _tmp8_;
#line 618 "../src/dialog.vala"
	bookworm_app_bookworm_profileColorList_length1 = _vala_array_length (_tmp7_);
#line 620 "../src/dialog.vala"
	_tmp9_ = bookworm_app_app_dialog_profileCombobox;
#line 620 "../src/dialog.vala"
	_tmp10_ = gtk_combo_box_text_get_active_text (_tmp9_);
#line 620 "../src/dialog.vala"
	_tmp11_ = _tmp10_;
#line 620 "../src/dialog.vala"
	_tmp12_ = string_contains (_tmp11_, " 1");
#line 620 "../src/dialog.vala"
	_g_free0 (_tmp11_);
#line 620 "../src/dialog.vala"
	if (_tmp12_) {
#line 4096 "dialog.c"
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		GtkColorButton* _tmp15_;
		GdkRGBA _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		GtkColorButton* _tmp19_;
		GdkRGBA _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		GtkColorButton* _tmp23_;
		GdkRGBA _tmp24_;
#line 621 "../src/dialog.vala"
		_tmp13_ = bookworm_app_bookworm_profileColorList;
#line 621 "../src/dialog.vala"
		_tmp13__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 621 "../src/dialog.vala"
		_tmp14_ = _tmp13_[0];
#line 621 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBATextColor, _tmp14_);
#line 622 "../src/dialog.vala"
		_tmp15_ = _data18_->textColourButton;
#line 622 "../src/dialog.vala"
		_tmp16_ = _data18_->aRGBATextColor;
#line 622 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp15_, &_tmp16_);
#line 623 "../src/dialog.vala"
		_tmp17_ = bookworm_app_bookworm_profileColorList;
#line 623 "../src/dialog.vala"
		_tmp17__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 623 "../src/dialog.vala"
		_tmp18_ = _tmp17_[1];
#line 623 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBABackgroundColor, _tmp18_);
#line 624 "../src/dialog.vala"
		_tmp19_ = _data18_->backgroundColourButton;
#line 624 "../src/dialog.vala"
		_tmp20_ = _data18_->aRGBABackgroundColor;
#line 624 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp19_, &_tmp20_);
#line 625 "../src/dialog.vala"
		_tmp21_ = bookworm_app_bookworm_profileColorList;
#line 625 "../src/dialog.vala"
		_tmp21__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 625 "../src/dialog.vala"
		_tmp22_ = _tmp21_[2];
#line 625 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBAHighlightColor, _tmp22_);
#line 626 "../src/dialog.vala"
		_tmp23_ = _data18_->highlightColourButton;
#line 626 "../src/dialog.vala"
		_tmp24_ = _data18_->aRGBAHighlightColor;
#line 626 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp23_, &_tmp24_);
#line 4154 "dialog.c"
	}
#line 628 "../src/dialog.vala"
	_tmp25_ = bookworm_app_app_dialog_profileCombobox;
#line 628 "../src/dialog.vala"
	_tmp26_ = gtk_combo_box_text_get_active_text (_tmp25_);
#line 628 "../src/dialog.vala"
	_tmp27_ = _tmp26_;
#line 628 "../src/dialog.vala"
	_tmp28_ = string_contains (_tmp27_, " 2");
#line 628 "../src/dialog.vala"
	_g_free0 (_tmp27_);
#line 628 "../src/dialog.vala"
	if (_tmp28_) {
#line 4168 "dialog.c"
		gchar** _tmp29_;
		gint _tmp29__length1;
		const gchar* _tmp30_;
		GtkColorButton* _tmp31_;
		GdkRGBA _tmp32_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		const gchar* _tmp34_;
		GtkColorButton* _tmp35_;
		GdkRGBA _tmp36_;
		gchar** _tmp37_;
		gint _tmp37__length1;
		const gchar* _tmp38_;
		GtkColorButton* _tmp39_;
		GdkRGBA _tmp40_;
#line 629 "../src/dialog.vala"
		_tmp29_ = bookworm_app_bookworm_profileColorList;
#line 629 "../src/dialog.vala"
		_tmp29__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 629 "../src/dialog.vala"
		_tmp30_ = _tmp29_[3];
#line 629 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBATextColor, _tmp30_);
#line 630 "../src/dialog.vala"
		_tmp31_ = _data18_->textColourButton;
#line 630 "../src/dialog.vala"
		_tmp32_ = _data18_->aRGBATextColor;
#line 630 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp31_, &_tmp32_);
#line 631 "../src/dialog.vala"
		_tmp33_ = bookworm_app_bookworm_profileColorList;
#line 631 "../src/dialog.vala"
		_tmp33__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 631 "../src/dialog.vala"
		_tmp34_ = _tmp33_[4];
#line 631 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBABackgroundColor, _tmp34_);
#line 632 "../src/dialog.vala"
		_tmp35_ = _data18_->backgroundColourButton;
#line 632 "../src/dialog.vala"
		_tmp36_ = _data18_->aRGBABackgroundColor;
#line 632 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp35_, &_tmp36_);
#line 633 "../src/dialog.vala"
		_tmp37_ = bookworm_app_bookworm_profileColorList;
#line 633 "../src/dialog.vala"
		_tmp37__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 633 "../src/dialog.vala"
		_tmp38_ = _tmp37_[5];
#line 633 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBAHighlightColor, _tmp38_);
#line 634 "../src/dialog.vala"
		_tmp39_ = _data18_->highlightColourButton;
#line 634 "../src/dialog.vala"
		_tmp40_ = _data18_->aRGBAHighlightColor;
#line 634 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp39_, &_tmp40_);
#line 4226 "dialog.c"
	}
#line 636 "../src/dialog.vala"
	_tmp41_ = bookworm_app_app_dialog_profileCombobox;
#line 636 "../src/dialog.vala"
	_tmp42_ = gtk_combo_box_text_get_active_text (_tmp41_);
#line 636 "../src/dialog.vala"
	_tmp43_ = _tmp42_;
#line 636 "../src/dialog.vala"
	_tmp44_ = string_contains (_tmp43_, " 3");
#line 636 "../src/dialog.vala"
	_g_free0 (_tmp43_);
#line 636 "../src/dialog.vala"
	if (_tmp44_) {
#line 4240 "dialog.c"
		gchar** _tmp45_;
		gint _tmp45__length1;
		const gchar* _tmp46_;
		GtkColorButton* _tmp47_;
		GdkRGBA _tmp48_;
		gchar** _tmp49_;
		gint _tmp49__length1;
		const gchar* _tmp50_;
		GtkColorButton* _tmp51_;
		GdkRGBA _tmp52_;
		gchar** _tmp53_;
		gint _tmp53__length1;
		const gchar* _tmp54_;
		GtkColorButton* _tmp55_;
		GdkRGBA _tmp56_;
#line 637 "../src/dialog.vala"
		_tmp45_ = bookworm_app_bookworm_profileColorList;
#line 637 "../src/dialog.vala"
		_tmp45__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 637 "../src/dialog.vala"
		_tmp46_ = _tmp45_[6];
#line 637 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBATextColor, _tmp46_);
#line 638 "../src/dialog.vala"
		_tmp47_ = _data18_->textColourButton;
#line 638 "../src/dialog.vala"
		_tmp48_ = _data18_->aRGBATextColor;
#line 638 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp47_, &_tmp48_);
#line 639 "../src/dialog.vala"
		_tmp49_ = bookworm_app_bookworm_profileColorList;
#line 639 "../src/dialog.vala"
		_tmp49__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 639 "../src/dialog.vala"
		_tmp50_ = _tmp49_[7];
#line 639 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBABackgroundColor, _tmp50_);
#line 640 "../src/dialog.vala"
		_tmp51_ = _data18_->backgroundColourButton;
#line 640 "../src/dialog.vala"
		_tmp52_ = _data18_->aRGBABackgroundColor;
#line 640 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp51_, &_tmp52_);
#line 641 "../src/dialog.vala"
		_tmp53_ = bookworm_app_bookworm_profileColorList;
#line 641 "../src/dialog.vala"
		_tmp53__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 641 "../src/dialog.vala"
		_tmp54_ = _tmp53_[8];
#line 641 "../src/dialog.vala"
		gdk_rgba_parse (&_data18_->aRGBAHighlightColor, _tmp54_);
#line 642 "../src/dialog.vala"
		_tmp55_ = _data18_->highlightColourButton;
#line 642 "../src/dialog.vala"
		_tmp56_ = _data18_->aRGBAHighlightColor;
#line 642 "../src/dialog.vala"
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp55_, &_tmp56_);
#line 4298 "dialog.c"
	}
#line 645 "../src/dialog.vala"
	_tmp57_ = bookworm_app_app_dialog_settings;
#line 645 "../src/dialog.vala"
	_tmp58_ = defaultProfileColors;
#line 645 "../src/dialog.vala"
	bookworm_app_settings_set_list_of_profile_colors (_tmp57_, _tmp58_);
#line 648 "../src/dialog.vala"
	_tmp59_ = _data18_->twoPageViewSwitch;
#line 648 "../src/dialog.vala"
	gtk_switch_set_active (_tmp59_, FALSE);
#line 649 "../src/dialog.vala"
	_tmp60_ = bookworm_app_bookworm_settings;
#line 649 "../src/dialog.vala"
	_tmp61_ = bookwormSettings;
#line 649 "../src/dialog.vala"
	_tmp62_ = g_settings_get_default_value (_tmp61_, "is-two-page-enabled");
#line 649 "../src/dialog.vala"
	_tmp63_ = _tmp62_;
#line 649 "../src/dialog.vala"
	_tmp64_ = _variant_get2 (_tmp63_);
#line 649 "../src/dialog.vala"
	bookworm_app_settings_set_is_two_page_enabled (_tmp60_, _tmp64_);
#line 649 "../src/dialog.vala"
	_g_variant_unref0 (_tmp63_);
#line 652 "../src/dialog.vala"
	_tmp65_ = _data18_->localStorageSwitch;
#line 652 "../src/dialog.vala"
	gtk_switch_set_active (_tmp65_, TRUE);
#line 653 "../src/dialog.vala"
	_tmp66_ = bookworm_app_bookworm_settings;
#line 653 "../src/dialog.vala"
	_tmp67_ = bookwormSettings;
#line 653 "../src/dialog.vala"
	_tmp68_ = g_settings_get_default_value (_tmp67_, "is-local-storage-enabled");
#line 653 "../src/dialog.vala"
	_tmp69_ = _tmp68_;
#line 653 "../src/dialog.vala"
	_tmp70_ = _variant_get3 (_tmp69_);
#line 653 "../src/dialog.vala"
	bookworm_app_settings_set_is_local_storage_enabled (_tmp66_, _tmp70_);
#line 653 "../src/dialog.vala"
	_g_variant_unref0 (_tmp69_);
#line 656 "../src/dialog.vala"
	_tmp71_ = _data18_->showLibraryAtStartSwitch;
#line 656 "../src/dialog.vala"
	gtk_switch_set_active (_tmp71_, FALSE);
#line 657 "../src/dialog.vala"
	_tmp72_ = bookworm_app_bookworm_settings;
#line 657 "../src/dialog.vala"
	_tmp73_ = bookwormSettings;
#line 657 "../src/dialog.vala"
	_tmp74_ = g_settings_get_default_value (_tmp73_, "is-show-library-on-start");
#line 657 "../src/dialog.vala"
	_tmp75_ = _tmp74_;
#line 657 "../src/dialog.vala"
	_tmp76_ = _variant_get4 (_tmp75_);
#line 657 "../src/dialog.vala"
	bookworm_app_settings_set_is_show_library_on_start (_tmp72_, _tmp76_);
#line 657 "../src/dialog.vala"
	_g_variant_unref0 (_tmp75_);
#line 660 "../src/dialog.vala"
	_tmp77_ = _data18_->nightModeSwitch;
#line 660 "../src/dialog.vala"
	gtk_switch_set_active (_tmp77_, FALSE);
#line 661 "../src/dialog.vala"
	_tmp78_ = bookworm_app_bookworm_settings;
#line 661 "../src/dialog.vala"
	_tmp79_ = bookwormSettings;
#line 661 "../src/dialog.vala"
	_tmp80_ = g_settings_get_default_value (_tmp79_, "is-dark-theme-enabled");
#line 661 "../src/dialog.vala"
	_tmp81_ = _tmp80_;
#line 661 "../src/dialog.vala"
	_tmp82_ = _variant_get5 (_tmp81_);
#line 661 "../src/dialog.vala"
	bookworm_app_settings_set_is_dark_theme_enabled (_tmp78_, _tmp82_);
#line 661 "../src/dialog.vala"
	_g_variant_unref0 (_tmp81_);
#line 664 "../src/dialog.vala"
	_tmp83_ = bookworm_app_bookworm_settings;
#line 664 "../src/dialog.vala"
	_tmp84_ = bookwormSettings;
#line 664 "../src/dialog.vala"
	_tmp85_ = g_settings_get_default_value (_tmp84_, "reading-font-name");
#line 664 "../src/dialog.vala"
	_tmp86_ = _tmp85_;
#line 664 "../src/dialog.vala"
	_tmp87_ = _variant_get6 (_tmp86_);
#line 664 "../src/dialog.vala"
	_tmp88_ = _tmp87_;
#line 664 "../src/dialog.vala"
	bookworm_app_settings_set_reading_font_name (_tmp83_, _tmp88_);
#line 664 "../src/dialog.vala"
	_g_free0 (_tmp88_);
#line 664 "../src/dialog.vala"
	_g_variant_unref0 (_tmp86_);
#line 665 "../src/dialog.vala"
	_tmp89_ = bookworm_app_bookworm_settings;
#line 665 "../src/dialog.vala"
	_tmp90_ = bookwormSettings;
#line 665 "../src/dialog.vala"
	_tmp91_ = g_settings_get_default_value (_tmp90_, "reading-font-name-family");
#line 665 "../src/dialog.vala"
	_tmp92_ = _tmp91_;
#line 665 "../src/dialog.vala"
	_tmp93_ = _variant_get7 (_tmp92_);
#line 665 "../src/dialog.vala"
	_tmp94_ = _tmp93_;
#line 665 "../src/dialog.vala"
	bookworm_app_settings_set_reading_font_name_family (_tmp89_, _tmp94_);
#line 665 "../src/dialog.vala"
	_g_free0 (_tmp94_);
#line 665 "../src/dialog.vala"
	_g_variant_unref0 (_tmp92_);
#line 666 "../src/dialog.vala"
	_tmp95_ = bookworm_app_bookworm_settings;
#line 666 "../src/dialog.vala"
	_tmp96_ = bookwormSettings;
#line 666 "../src/dialog.vala"
	_tmp97_ = g_settings_get_default_value (_tmp96_, "reading-font-size");
#line 666 "../src/dialog.vala"
	_tmp98_ = _tmp97_;
#line 666 "../src/dialog.vala"
	_tmp99_ = _variant_get8 (_tmp98_);
#line 666 "../src/dialog.vala"
	bookworm_app_settings_set_reading_font_size (_tmp95_, _tmp99_);
#line 666 "../src/dialog.vala"
	_g_variant_unref0 (_tmp98_);
#line 667 "../src/dialog.vala"
	_tmp100_ = _data18_->fontButton;
#line 667 "../src/dialog.vala"
	_tmp101_ = bookworm_app_bookworm_settings;
#line 667 "../src/dialog.vala"
	_tmp102_ = bookworm_app_settings_get_reading_font_name (_tmp101_);
#line 667 "../src/dialog.vala"
	_tmp103_ = _tmp102_;
#line 667 "../src/dialog.vala"
	gtk_font_button_set_font_name (_tmp100_, _tmp103_);
#line 670 "../src/dialog.vala"
	_tmp104_ = bookwormSettings;
#line 670 "../src/dialog.vala"
	_tmp105_ = g_settings_get_default_value (_tmp104_, "library-page-items");
#line 670 "../src/dialog.vala"
	_tmp106_ = _tmp105_;
#line 670 "../src/dialog.vala"
	_tmp107_ = _variant_get9 (_tmp106_);
#line 670 "../src/dialog.vala"
	_tmp108_ = g_strdup_printf ("%i", _tmp107_);
#line 670 "../src/dialog.vala"
	_tmp109_ = _tmp108_;
#line 670 "../src/dialog.vala"
	gtk_entry_set_text (_data18_->libraryPageItemsEntry, _tmp109_);
#line 670 "../src/dialog.vala"
	_g_free0 (_tmp109_);
#line 670 "../src/dialog.vala"
	_g_variant_unref0 (_tmp106_);
#line 671 "../src/dialog.vala"
	_tmp110_ = bookworm_app_bookworm_settings;
#line 671 "../src/dialog.vala"
	_tmp111_ = bookwormSettings;
#line 671 "../src/dialog.vala"
	_tmp112_ = g_settings_get_default_value (_tmp111_, "library-page-items");
#line 671 "../src/dialog.vala"
	_tmp113_ = _tmp112_;
#line 671 "../src/dialog.vala"
	_tmp114_ = _variant_get10 (_tmp113_);
#line 671 "../src/dialog.vala"
	bookworm_app_settings_set_library_page_items (_tmp110_, _tmp114_);
#line 671 "../src/dialog.vala"
	_g_variant_unref0 (_tmp113_);
#line 674 "../src/dialog.vala"
	bookworm_app_content_handler_refreshCurrentPage ();
#line 676 "../src/dialog.vala"
	result = TRUE;
#line 676 "../src/dialog.vala"
	_g_free0 (defaultProfileColors);
#line 676 "../src/dialog.vala"
	_g_object_unref0 (bookwormSettings);
#line 676 "../src/dialog.vala"
	return result;
#line 4480 "dialog.c"
}

static gboolean
___lambda28__gtk_link_button_activate_link (GtkLinkButton* _sender,
                                            gpointer self)
{
	gboolean result;
	result = __lambda28_ (self);
#line 614 "../src/dialog.vala"
	return result;
#line 4491 "dialog.c"
}

static void
__lambda29_ (void)
{
#line 680 "../src/dialog.vala"
	bookworm_app_app_dialog_updateProfileColorToSettings ();
#line 4499 "dialog.c"
}

static void
___lambda29__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
#line 679 "../src/dialog.vala"
	__lambda29_ ();
#line 4509 "dialog.c"
}

void
bookworm_app_app_dialog_createPreferencesDialog (void)
{
	Block18Data* _data18_;
	BookwormAppAppDialog* dialog = NULL;
	BookwormAppAppDialog* _tmp0_;
	BookwormAppAppDialog* _tmp1_;
	GtkApplicationWindow* _tmp2_;
	BookwormAppAppDialog* _tmp3_;
	BookwormAppAppDialog* _tmp4_;
	BookwormAppAppDialog* _tmp5_;
	GtkLabel* localStorageLabel = NULL;
	GtkLabel* _tmp6_;
	GtkSwitch* _tmp7_;
	BookwormAppSettings* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GtkBox* localStorageBox = NULL;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkLabel* _tmp14_;
	GtkBox* _tmp15_;
	GtkSwitch* _tmp16_;
	GtkLabel* colourScheme = NULL;
	GtkLabel* _tmp17_;
	GtkSwitch* _tmp18_;
	BookwormAppSettings* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	GtkBox* prefBox = NULL;
	GtkBox* _tmp23_;
	GtkBox* _tmp24_;
	GtkLabel* _tmp25_;
	GtkBox* _tmp26_;
	GtkSwitch* _tmp27_;
	GtkLabel* twoPageViewLabel = NULL;
	GtkLabel* _tmp28_;
	GtkSwitch* _tmp29_;
	BookwormAppSettings* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	GtkBox* twoPageViewBox = NULL;
	GtkBox* _tmp34_;
	GtkBox* _tmp35_;
	GtkLabel* _tmp36_;
	GtkBox* _tmp37_;
	GtkSwitch* _tmp38_;
	GtkLabel* showLibraryAtStartLabel = NULL;
	GtkLabel* _tmp39_;
	GtkSwitch* _tmp40_;
	BookwormAppSettings* _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	GtkBox* showLibraryAtStartBox = NULL;
	GtkBox* _tmp45_;
	GtkBox* _tmp46_;
	GtkLabel* _tmp47_;
	GtkBox* _tmp48_;
	GtkSwitch* _tmp49_;
	GtkLabel* fontChooserLabel = NULL;
	GtkLabel* _tmp50_;
	GtkFontButton* _tmp51_;
	GtkFontButton* _tmp52_;
	GtkFontButton* _tmp53_;
	BookwormAppSettings* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	GtkFontButton* _tmp57_;
	GtkBox* fontBox = NULL;
	GtkBox* _tmp58_;
	GtkBox* _tmp59_;
	GtkLabel* _tmp60_;
	GtkBox* _tmp61_;
	GtkFontButton* _tmp62_;
	GtkComboBoxText* _tmp63_;
	GString* profileNameText = NULL;
	GString* _tmp64_;
	GString* _tmp65_;
	GString* _tmp66_;
	GtkComboBoxText* _tmp67_;
	GString* _tmp68_;
	const gchar* _tmp69_;
	GString* _tmp70_;
	GString* _tmp71_;
	GtkComboBoxText* _tmp72_;
	GString* _tmp73_;
	const gchar* _tmp74_;
	GString* _tmp75_;
	GString* _tmp76_;
	GtkComboBoxText* _tmp77_;
	GString* _tmp78_;
	const gchar* _tmp79_;
	GtkLabel* backgroundColourLabel = NULL;
	GtkLabel* _tmp80_;
	GtkColorButton* _tmp81_;
	GtkColorButton* _tmp82_;
	GtkBox* backgroundColourBox = NULL;
	GtkBox* _tmp83_;
	GtkBox* _tmp84_;
	GtkLabel* _tmp85_;
	GtkBox* _tmp86_;
	GtkColorButton* _tmp87_;
	GtkLabel* textColourLabel = NULL;
	GtkLabel* _tmp88_;
	GtkColorButton* _tmp89_;
	GtkColorButton* _tmp90_;
	GtkBox* textColourBox = NULL;
	GtkBox* _tmp91_;
	GtkBox* _tmp92_;
	GtkLabel* _tmp93_;
	GtkBox* _tmp94_;
	GtkColorButton* _tmp95_;
	GtkLabel* highlightColourLabel = NULL;
	GtkLabel* _tmp96_;
	GtkColorButton* _tmp97_;
	GtkColorButton* _tmp98_;
	GtkBox* highlightColourBox = NULL;
	GtkBox* _tmp99_;
	GtkBox* _tmp100_;
	GtkLabel* _tmp101_;
	GtkBox* _tmp102_;
	GtkColorButton* _tmp103_;
	GtkLinkButton* preferencesReset = NULL;
	GtkLinkButton* _tmp104_;
	GtkBox* resetBox = NULL;
	GtkBox* _tmp105_;
	GtkBox* _tmp106_;
	GtkLinkButton* _tmp107_;
	GtkComboBoxText* _tmp108_;
	gchar** _tmp109_;
	gint _tmp109__length1;
	const gchar* _tmp110_;
	GtkColorButton* _tmp111_;
	GdkRGBA _tmp112_;
	gchar** _tmp113_;
	gint _tmp113__length1;
	const gchar* _tmp114_;
	GtkColorButton* _tmp115_;
	GdkRGBA _tmp116_;
	gchar** _tmp117_;
	gint _tmp117__length1;
	const gchar* _tmp118_;
	GtkColorButton* _tmp119_;
	GdkRGBA _tmp120_;
	GtkLabel* discoverBooksLabel = NULL;
	GtkLabel* _tmp121_;
	GtkComboBoxText* _tmp122_;
	BookwormAppSettings* _tmp123_;
	const gchar* _tmp124_;
	const gchar* _tmp125_;
	gint _tmp126_;
	gint _tmp127_;
	GtkComboBoxText* _tmp142_;
	GtkButton* add_scan_directory_button = NULL;
	GtkButton* _tmp143_;
	GtkImage* _tmp144_;
	GtkButton* remove_scan_directory_button = NULL;
	GtkButton* _tmp145_;
	GtkImage* _tmp146_;
	GtkBox* discoverBooksBox = NULL;
	GtkBox* _tmp147_;
	GtkLabel* _tmp148_;
	GtkComboBoxText* _tmp149_;
	GtkBox* libraryPageItemsBox = NULL;
	GtkBox* _tmp150_;
	GtkLabel* libraryPageItemsLabel = NULL;
	GtkLabel* _tmp151_;
	GtkEntry* _tmp152_;
	BookwormAppSettings* _tmp153_;
	gint _tmp154_;
	gint _tmp155_;
	gchar* _tmp156_;
	gchar* _tmp157_;
	GtkBox* customProfileBox = NULL;
	GtkBox* _tmp158_;
	GtkComboBoxText* _tmp159_;
	GtkBox* _tmp160_;
	GtkBox* _tmp161_;
	GtkBox* _tmp162_;
	GraniteWidgetsToast* _tmp163_;
	GtkBox* content = NULL;
	BookwormAppAppDialog* _tmp164_;
	GtkBox* _tmp165_;
	GtkBox* _tmp166_;
	GtkBox* _tmp167_;
	GtkBox* _tmp168_;
	GtkBox* _tmp169_;
	GtkBox* _tmp170_;
	GtkBox* _tmp171_;
	GtkBox* _tmp172_;
	BookwormAppAppDialog* _tmp173_;
	GtkFontButton* _tmp174_;
	GtkSwitch* _tmp175_;
	GtkSwitch* _tmp176_;
	GtkSwitch* _tmp177_;
	GtkSwitch* _tmp178_;
	GtkComboBoxText* _tmp179_;
	GtkColorButton* _tmp180_;
	GtkColorButton* _tmp181_;
	GtkColorButton* _tmp182_;
	GtkLinkButton* _tmp183_;
	BookwormAppAppDialog* _tmp184_;
#line 265 "../src/dialog.vala"
	_data18_ = g_slice_new0 (Block18Data);
#line 265 "../src/dialog.vala"
	_data18_->_ref_count_ = 1;
#line 266 "../src/dialog.vala"
	g_debug ("dialog.vala:266: [START] [FUNCTION:createPreferencesDialog]");
#line 267 "../src/dialog.vala"
	_tmp0_ = bookworm_app_app_dialog_new ();
#line 267 "../src/dialog.vala"
	g_object_ref_sink (_tmp0_);
#line 267 "../src/dialog.vala"
	dialog = _tmp0_;
#line 268 "../src/dialog.vala"
	_tmp1_ = dialog;
#line 268 "../src/dialog.vala"
	_tmp2_ = bookworm_app_bookworm_window;
#line 268 "../src/dialog.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp1_, (GtkWindow*) _tmp2_);
#line 270 "../src/dialog.vala"
	_tmp3_ = dialog;
#line 270 "../src/dialog.vala"
	gtk_window_set_title ((GtkWindow*) _tmp3_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_DIALOG_TITLE);
#line 271 "../src/dialog.vala"
	_tmp4_ = dialog;
#line 271 "../src/dialog.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp4_, (guint) 5);
#line 272 "../src/dialog.vala"
	_tmp5_ = dialog;
#line 272 "../src/dialog.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp5_, 600, 200);
#line 274 "../src/dialog.vala"
	_tmp6_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_LOCAL_STORAGE);
#line 274 "../src/dialog.vala"
	g_object_ref_sink (_tmp6_);
#line 274 "../src/dialog.vala"
	localStorageLabel = _tmp6_;
#line 275 "../src/dialog.vala"
	_tmp7_ = (GtkSwitch*) gtk_switch_new ();
#line 275 "../src/dialog.vala"
	g_object_ref_sink (_tmp7_);
#line 275 "../src/dialog.vala"
	_data18_->localStorageSwitch = _tmp7_;
#line 277 "../src/dialog.vala"
	_tmp8_ = bookworm_app_bookworm_settings;
#line 277 "../src/dialog.vala"
	_tmp9_ = bookworm_app_settings_get_is_local_storage_enabled (_tmp8_);
#line 277 "../src/dialog.vala"
	_tmp10_ = _tmp9_;
#line 277 "../src/dialog.vala"
	if (_tmp10_) {
#line 4764 "dialog.c"
		GtkSwitch* _tmp11_;
#line 278 "../src/dialog.vala"
		_tmp11_ = _data18_->localStorageSwitch;
#line 278 "../src/dialog.vala"
		gtk_switch_set_active (_tmp11_, TRUE);
#line 4770 "dialog.c"
	}
#line 280 "../src/dialog.vala"
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 280 "../src/dialog.vala"
	g_object_ref_sink (_tmp12_);
#line 280 "../src/dialog.vala"
	localStorageBox = _tmp12_;
#line 281 "../src/dialog.vala"
	_tmp13_ = localStorageBox;
#line 281 "../src/dialog.vala"
	_tmp14_ = localStorageLabel;
#line 281 "../src/dialog.vala"
	gtk_box_pack_start (_tmp13_, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
#line 282 "../src/dialog.vala"
	_tmp15_ = localStorageBox;
#line 282 "../src/dialog.vala"
	_tmp16_ = _data18_->localStorageSwitch;
#line 282 "../src/dialog.vala"
	gtk_box_pack_end (_tmp15_, (GtkWidget*) _tmp16_, FALSE, FALSE, (guint) 0);
#line 284 "../src/dialog.vala"
	_tmp17_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_COLOUR_SCHEME);
#line 284 "../src/dialog.vala"
	g_object_ref_sink (_tmp17_);
#line 284 "../src/dialog.vala"
	colourScheme = _tmp17_;
#line 285 "../src/dialog.vala"
	_tmp18_ = (GtkSwitch*) gtk_switch_new ();
#line 285 "../src/dialog.vala"
	g_object_ref_sink (_tmp18_);
#line 285 "../src/dialog.vala"
	_data18_->nightModeSwitch = _tmp18_;
#line 287 "../src/dialog.vala"
	_tmp19_ = bookworm_app_bookworm_settings;
#line 287 "../src/dialog.vala"
	_tmp20_ = bookworm_app_settings_get_is_dark_theme_enabled (_tmp19_);
#line 287 "../src/dialog.vala"
	_tmp21_ = _tmp20_;
#line 287 "../src/dialog.vala"
	if (_tmp21_) {
#line 4810 "dialog.c"
		GtkSwitch* _tmp22_;
#line 288 "../src/dialog.vala"
		_tmp22_ = _data18_->nightModeSwitch;
#line 288 "../src/dialog.vala"
		gtk_switch_set_active (_tmp22_, TRUE);
#line 4816 "dialog.c"
	}
#line 290 "../src/dialog.vala"
	_tmp23_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 290 "../src/dialog.vala"
	g_object_ref_sink (_tmp23_);
#line 290 "../src/dialog.vala"
	prefBox = _tmp23_;
#line 291 "../src/dialog.vala"
	_tmp24_ = prefBox;
#line 291 "../src/dialog.vala"
	_tmp25_ = colourScheme;
#line 291 "../src/dialog.vala"
	gtk_box_pack_start (_tmp24_, (GtkWidget*) _tmp25_, FALSE, FALSE, (guint) 0);
#line 292 "../src/dialog.vala"
	_tmp26_ = prefBox;
#line 292 "../src/dialog.vala"
	_tmp27_ = _data18_->nightModeSwitch;
#line 292 "../src/dialog.vala"
	gtk_box_pack_end (_tmp26_, (GtkWidget*) _tmp27_, FALSE, FALSE, (guint) 0);
#line 294 "../src/dialog.vala"
	_tmp28_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_TWO_PAGE);
#line 294 "../src/dialog.vala"
	g_object_ref_sink (_tmp28_);
#line 294 "../src/dialog.vala"
	twoPageViewLabel = _tmp28_;
#line 295 "../src/dialog.vala"
	_tmp29_ = (GtkSwitch*) gtk_switch_new ();
#line 295 "../src/dialog.vala"
	g_object_ref_sink (_tmp29_);
#line 295 "../src/dialog.vala"
	_data18_->twoPageViewSwitch = _tmp29_;
#line 297 "../src/dialog.vala"
	_tmp30_ = bookworm_app_bookworm_settings;
#line 297 "../src/dialog.vala"
	_tmp31_ = bookworm_app_settings_get_is_two_page_enabled (_tmp30_);
#line 297 "../src/dialog.vala"
	_tmp32_ = _tmp31_;
#line 297 "../src/dialog.vala"
	if (_tmp32_) {
#line 4856 "dialog.c"
		GtkSwitch* _tmp33_;
#line 298 "../src/dialog.vala"
		_tmp33_ = _data18_->twoPageViewSwitch;
#line 298 "../src/dialog.vala"
		gtk_switch_set_active (_tmp33_, TRUE);
#line 4862 "dialog.c"
	}
#line 300 "../src/dialog.vala"
	_tmp34_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 300 "../src/dialog.vala"
	g_object_ref_sink (_tmp34_);
#line 300 "../src/dialog.vala"
	twoPageViewBox = _tmp34_;
#line 301 "../src/dialog.vala"
	_tmp35_ = twoPageViewBox;
#line 301 "../src/dialog.vala"
	_tmp36_ = twoPageViewLabel;
#line 301 "../src/dialog.vala"
	gtk_box_pack_start (_tmp35_, (GtkWidget*) _tmp36_, FALSE, FALSE, (guint) 0);
#line 302 "../src/dialog.vala"
	_tmp37_ = twoPageViewBox;
#line 302 "../src/dialog.vala"
	_tmp38_ = _data18_->twoPageViewSwitch;
#line 302 "../src/dialog.vala"
	gtk_box_pack_end (_tmp37_, (GtkWidget*) _tmp38_, FALSE, FALSE, (guint) 0);
#line 304 "../src/dialog.vala"
	_tmp39_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_SKIP_LIBRARY);
#line 304 "../src/dialog.vala"
	g_object_ref_sink (_tmp39_);
#line 304 "../src/dialog.vala"
	showLibraryAtStartLabel = _tmp39_;
#line 305 "../src/dialog.vala"
	_tmp40_ = (GtkSwitch*) gtk_switch_new ();
#line 305 "../src/dialog.vala"
	g_object_ref_sink (_tmp40_);
#line 305 "../src/dialog.vala"
	_data18_->showLibraryAtStartSwitch = _tmp40_;
#line 307 "../src/dialog.vala"
	_tmp41_ = bookworm_app_bookworm_settings;
#line 307 "../src/dialog.vala"
	_tmp42_ = bookworm_app_settings_get_is_show_library_on_start (_tmp41_);
#line 307 "../src/dialog.vala"
	_tmp43_ = _tmp42_;
#line 307 "../src/dialog.vala"
	if (_tmp43_) {
#line 4902 "dialog.c"
		GtkSwitch* _tmp44_;
#line 308 "../src/dialog.vala"
		_tmp44_ = _data18_->showLibraryAtStartSwitch;
#line 308 "../src/dialog.vala"
		gtk_switch_set_active (_tmp44_, TRUE);
#line 4908 "dialog.c"
	}
#line 310 "../src/dialog.vala"
	_tmp45_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 310 "../src/dialog.vala"
	g_object_ref_sink (_tmp45_);
#line 310 "../src/dialog.vala"
	showLibraryAtStartBox = _tmp45_;
#line 311 "../src/dialog.vala"
	_tmp46_ = showLibraryAtStartBox;
#line 311 "../src/dialog.vala"
	_tmp47_ = showLibraryAtStartLabel;
#line 311 "../src/dialog.vala"
	gtk_box_pack_start (_tmp46_, (GtkWidget*) _tmp47_, FALSE, FALSE, (guint) 0);
#line 312 "../src/dialog.vala"
	_tmp48_ = showLibraryAtStartBox;
#line 312 "../src/dialog.vala"
	_tmp49_ = _data18_->showLibraryAtStartSwitch;
#line 312 "../src/dialog.vala"
	gtk_box_pack_end (_tmp48_, (GtkWidget*) _tmp49_, FALSE, FALSE, (guint) 0);
#line 314 "../src/dialog.vala"
	_tmp50_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_FONT);
#line 314 "../src/dialog.vala"
	g_object_ref_sink (_tmp50_);
#line 314 "../src/dialog.vala"
	fontChooserLabel = _tmp50_;
#line 315 "../src/dialog.vala"
	_tmp51_ = (GtkFontButton*) gtk_font_button_new ();
#line 315 "../src/dialog.vala"
	g_object_ref_sink (_tmp51_);
#line 315 "../src/dialog.vala"
	_data18_->fontButton = _tmp51_;
#line 316 "../src/dialog.vala"
	_tmp52_ = _data18_->fontButton;
#line 316 "../src/dialog.vala"
	gtk_font_chooser_set_filter_func ((GtkFontChooser*) _tmp52_, _bookworm_app_app_dialog_filterFont_gtk_font_filter_func, NULL, NULL);
#line 317 "../src/dialog.vala"
	_tmp53_ = _data18_->fontButton;
#line 317 "../src/dialog.vala"
	_tmp54_ = bookworm_app_bookworm_settings;
#line 317 "../src/dialog.vala"
	_tmp55_ = bookworm_app_settings_get_reading_font_name (_tmp54_);
#line 317 "../src/dialog.vala"
	_tmp56_ = _tmp55_;
#line 317 "../src/dialog.vala"
	gtk_font_button_set_font_name (_tmp53_, _tmp56_);
#line 318 "../src/dialog.vala"
	_tmp57_ = _data18_->fontButton;
#line 318 "../src/dialog.vala"
	gtk_font_button_set_show_style (_tmp57_, FALSE);
#line 319 "../src/dialog.vala"
	_tmp58_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 319 "../src/dialog.vala"
	g_object_ref_sink (_tmp58_);
#line 319 "../src/dialog.vala"
	fontBox = _tmp58_;
#line 320 "../src/dialog.vala"
	_tmp59_ = fontBox;
#line 320 "../src/dialog.vala"
	_tmp60_ = fontChooserLabel;
#line 320 "../src/dialog.vala"
	gtk_box_pack_start (_tmp59_, (GtkWidget*) _tmp60_, FALSE, FALSE, (guint) 0);
#line 321 "../src/dialog.vala"
	_tmp61_ = fontBox;
#line 321 "../src/dialog.vala"
	_tmp62_ = _data18_->fontButton;
#line 321 "../src/dialog.vala"
	gtk_box_pack_end (_tmp61_, (GtkWidget*) _tmp62_, FALSE, FALSE, (guint) 0);
#line 323 "../src/dialog.vala"
	_tmp63_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
#line 323 "../src/dialog.vala"
	g_object_ref_sink (_tmp63_);
#line 323 "../src/dialog.vala"
	_g_object_unref0 (bookworm_app_app_dialog_profileCombobox);
#line 323 "../src/dialog.vala"
	bookworm_app_app_dialog_profileCombobox = _tmp63_;
#line 324 "../src/dialog.vala"
	_tmp64_ = g_string_new ("");
#line 324 "../src/dialog.vala"
	profileNameText = _tmp64_;
#line 325 "../src/dialog.vala"
	_tmp65_ = profileNameText;
#line 325 "../src/dialog.vala"
	_tmp66_ = g_string_assign (_tmp65_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_PROFILE_CUSTOMIZATION);
#line 325 "../src/dialog.vala"
	g_string_append (_tmp66_, " 1");
#line 326 "../src/dialog.vala"
	_tmp67_ = bookworm_app_app_dialog_profileCombobox;
#line 326 "../src/dialog.vala"
	_tmp68_ = profileNameText;
#line 326 "../src/dialog.vala"
	_tmp69_ = _tmp68_->str;
#line 326 "../src/dialog.vala"
	gtk_combo_box_text_append_text (_tmp67_, _tmp69_);
#line 327 "../src/dialog.vala"
	_tmp70_ = profileNameText;
#line 327 "../src/dialog.vala"
	_tmp71_ = g_string_assign (_tmp70_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_PROFILE_CUSTOMIZATION);
#line 327 "../src/dialog.vala"
	g_string_append (_tmp71_, " 2");
#line 328 "../src/dialog.vala"
	_tmp72_ = bookworm_app_app_dialog_profileCombobox;
#line 328 "../src/dialog.vala"
	_tmp73_ = profileNameText;
#line 328 "../src/dialog.vala"
	_tmp74_ = _tmp73_->str;
#line 328 "../src/dialog.vala"
	gtk_combo_box_text_append_text (_tmp72_, _tmp74_);
#line 329 "../src/dialog.vala"
	_tmp75_ = profileNameText;
#line 329 "../src/dialog.vala"
	_tmp76_ = g_string_assign (_tmp75_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_PROFILE_CUSTOMIZATION);
#line 329 "../src/dialog.vala"
	g_string_append (_tmp76_, " 3");
#line 330 "../src/dialog.vala"
	_tmp77_ = bookworm_app_app_dialog_profileCombobox;
#line 330 "../src/dialog.vala"
	_tmp78_ = profileNameText;
#line 330 "../src/dialog.vala"
	_tmp79_ = _tmp78_->str;
#line 330 "../src/dialog.vala"
	gtk_combo_box_text_append_text (_tmp77_, _tmp79_);
#line 332 "../src/dialog.vala"
	_tmp80_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_PROFILE_CUSTOMIZATION_BACKGROUND_COLOR);
#line 332 "../src/dialog.vala"
	g_object_ref_sink (_tmp80_);
#line 332 "../src/dialog.vala"
	backgroundColourLabel = _tmp80_;
#line 333 "../src/dialog.vala"
	_tmp81_ = (GtkColorButton*) gtk_color_button_new ();
#line 333 "../src/dialog.vala"
	g_object_ref_sink (_tmp81_);
#line 333 "../src/dialog.vala"
	_data18_->backgroundColourButton = _tmp81_;
#line 334 "../src/dialog.vala"
	_tmp82_ = _data18_->backgroundColourButton;
#line 334 "../src/dialog.vala"
	gtk_button_set_relief ((GtkButton*) _tmp82_, GTK_RELIEF_HALF);
#line 335 "../src/dialog.vala"
	_tmp83_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
#line 335 "../src/dialog.vala"
	g_object_ref_sink (_tmp83_);
#line 335 "../src/dialog.vala"
	backgroundColourBox = _tmp83_;
#line 336 "../src/dialog.vala"
	_tmp84_ = backgroundColourBox;
#line 336 "../src/dialog.vala"
	_tmp85_ = backgroundColourLabel;
#line 336 "../src/dialog.vala"
	gtk_box_pack_start (_tmp84_, (GtkWidget*) _tmp85_, FALSE, FALSE, (guint) 0);
#line 337 "../src/dialog.vala"
	_tmp86_ = backgroundColourBox;
#line 337 "../src/dialog.vala"
	_tmp87_ = _data18_->backgroundColourButton;
#line 337 "../src/dialog.vala"
	gtk_box_pack_start (_tmp86_, (GtkWidget*) _tmp87_, FALSE, FALSE, (guint) 0);
#line 339 "../src/dialog.vala"
	_tmp88_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_PROFILE_CUSTOMIZATION_FONT_COLOR);
#line 339 "../src/dialog.vala"
	g_object_ref_sink (_tmp88_);
#line 339 "../src/dialog.vala"
	textColourLabel = _tmp88_;
#line 340 "../src/dialog.vala"
	_tmp89_ = (GtkColorButton*) gtk_color_button_new ();
#line 340 "../src/dialog.vala"
	g_object_ref_sink (_tmp89_);
#line 340 "../src/dialog.vala"
	_data18_->textColourButton = _tmp89_;
#line 341 "../src/dialog.vala"
	_tmp90_ = _data18_->textColourButton;
#line 341 "../src/dialog.vala"
	gtk_button_set_relief ((GtkButton*) _tmp90_, GTK_RELIEF_HALF);
#line 342 "../src/dialog.vala"
	_tmp91_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
#line 342 "../src/dialog.vala"
	g_object_ref_sink (_tmp91_);
#line 342 "../src/dialog.vala"
	textColourBox = _tmp91_;
#line 343 "../src/dialog.vala"
	_tmp92_ = textColourBox;
#line 343 "../src/dialog.vala"
	_tmp93_ = textColourLabel;
#line 343 "../src/dialog.vala"
	gtk_box_pack_start (_tmp92_, (GtkWidget*) _tmp93_, FALSE, FALSE, (guint) 0);
#line 344 "../src/dialog.vala"
	_tmp94_ = textColourBox;
#line 344 "../src/dialog.vala"
	_tmp95_ = _data18_->textColourButton;
#line 344 "../src/dialog.vala"
	gtk_box_pack_start (_tmp94_, (GtkWidget*) _tmp95_, FALSE, FALSE, (guint) 0);
#line 346 "../src/dialog.vala"
	_tmp96_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_PROFILE_CUSTOMIZATION_HIGHLIGHT_COLOR);
#line 346 "../src/dialog.vala"
	g_object_ref_sink (_tmp96_);
#line 346 "../src/dialog.vala"
	highlightColourLabel = _tmp96_;
#line 347 "../src/dialog.vala"
	_tmp97_ = (GtkColorButton*) gtk_color_button_new ();
#line 347 "../src/dialog.vala"
	g_object_ref_sink (_tmp97_);
#line 347 "../src/dialog.vala"
	_data18_->highlightColourButton = _tmp97_;
#line 348 "../src/dialog.vala"
	_tmp98_ = _data18_->highlightColourButton;
#line 348 "../src/dialog.vala"
	gtk_button_set_relief ((GtkButton*) _tmp98_, GTK_RELIEF_HALF);
#line 349 "../src/dialog.vala"
	_tmp99_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
#line 349 "../src/dialog.vala"
	g_object_ref_sink (_tmp99_);
#line 349 "../src/dialog.vala"
	highlightColourBox = _tmp99_;
#line 350 "../src/dialog.vala"
	_tmp100_ = highlightColourBox;
#line 350 "../src/dialog.vala"
	_tmp101_ = highlightColourLabel;
#line 350 "../src/dialog.vala"
	gtk_box_pack_start (_tmp100_, (GtkWidget*) _tmp101_, FALSE, FALSE, (guint) 0);
#line 351 "../src/dialog.vala"
	_tmp102_ = highlightColourBox;
#line 351 "../src/dialog.vala"
	_tmp103_ = _data18_->highlightColourButton;
#line 351 "../src/dialog.vala"
	gtk_box_pack_start (_tmp102_, (GtkWidget*) _tmp103_, FALSE, FALSE, (guint) 0);
#line 353 "../src/dialog.vala"
	_tmp104_ = (GtkLinkButton*) gtk_link_button_new_with_label ("reset", BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_VALUES_RESET);
#line 353 "../src/dialog.vala"
	g_object_ref_sink (_tmp104_);
#line 353 "../src/dialog.vala"
	preferencesReset = _tmp104_;
#line 354 "../src/dialog.vala"
	_tmp105_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 354 "../src/dialog.vala"
	g_object_ref_sink (_tmp105_);
#line 354 "../src/dialog.vala"
	resetBox = _tmp105_;
#line 355 "../src/dialog.vala"
	_tmp106_ = resetBox;
#line 355 "../src/dialog.vala"
	_tmp107_ = preferencesReset;
#line 355 "../src/dialog.vala"
	gtk_box_pack_end (_tmp106_, (GtkWidget*) _tmp107_, FALSE, FALSE, (guint) 0);
#line 358 "../src/dialog.vala"
	_tmp108_ = bookworm_app_app_dialog_profileCombobox;
#line 358 "../src/dialog.vala"
	gtk_combo_box_set_active ((GtkComboBox*) _tmp108_, 0);
#line 359 "../src/dialog.vala"
	memset (&_data18_->aRGBATextColor, 0, sizeof (GdkRGBA));
#line 360 "../src/dialog.vala"
	_tmp109_ = bookworm_app_bookworm_profileColorList;
#line 360 "../src/dialog.vala"
	_tmp109__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 360 "../src/dialog.vala"
	_tmp110_ = _tmp109_[0];
#line 360 "../src/dialog.vala"
	gdk_rgba_parse (&_data18_->aRGBATextColor, _tmp110_);
#line 361 "../src/dialog.vala"
	_tmp111_ = _data18_->textColourButton;
#line 361 "../src/dialog.vala"
	_tmp112_ = _data18_->aRGBATextColor;
#line 361 "../src/dialog.vala"
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp111_, &_tmp112_);
#line 363 "../src/dialog.vala"
	memset (&_data18_->aRGBABackgroundColor, 0, sizeof (GdkRGBA));
#line 364 "../src/dialog.vala"
	_tmp113_ = bookworm_app_bookworm_profileColorList;
#line 364 "../src/dialog.vala"
	_tmp113__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 364 "../src/dialog.vala"
	_tmp114_ = _tmp113_[1];
#line 364 "../src/dialog.vala"
	gdk_rgba_parse (&_data18_->aRGBABackgroundColor, _tmp114_);
#line 365 "../src/dialog.vala"
	_tmp115_ = _data18_->backgroundColourButton;
#line 365 "../src/dialog.vala"
	_tmp116_ = _data18_->aRGBABackgroundColor;
#line 365 "../src/dialog.vala"
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp115_, &_tmp116_);
#line 367 "../src/dialog.vala"
	memset (&_data18_->aRGBAHighlightColor, 0, sizeof (GdkRGBA));
#line 368 "../src/dialog.vala"
	_tmp117_ = bookworm_app_bookworm_profileColorList;
#line 368 "../src/dialog.vala"
	_tmp117__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 368 "../src/dialog.vala"
	_tmp118_ = _tmp117_[2];
#line 368 "../src/dialog.vala"
	gdk_rgba_parse (&_data18_->aRGBAHighlightColor, _tmp118_);
#line 369 "../src/dialog.vala"
	_tmp119_ = _data18_->highlightColourButton;
#line 369 "../src/dialog.vala"
	_tmp120_ = _data18_->aRGBAHighlightColor;
#line 369 "../src/dialog.vala"
	gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp119_, &_tmp120_);
#line 371 "../src/dialog.vala"
	_tmp121_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_BOOKS_DISCOVERY);
#line 371 "../src/dialog.vala"
	g_object_ref_sink (_tmp121_);
#line 371 "../src/dialog.vala"
	discoverBooksLabel = _tmp121_;
#line 372 "../src/dialog.vala"
	_tmp122_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
#line 372 "../src/dialog.vala"
	g_object_ref_sink (_tmp122_);
#line 372 "../src/dialog.vala"
	_g_object_unref0 (bookworm_app_app_dialog_directoryComboBox);
#line 372 "../src/dialog.vala"
	bookworm_app_app_dialog_directoryComboBox = _tmp122_;
#line 373 "../src/dialog.vala"
	_tmp123_ = bookworm_app_bookworm_settings;
#line 373 "../src/dialog.vala"
	_tmp124_ = bookworm_app_settings_get_list_of_scan_dirs (_tmp123_);
#line 373 "../src/dialog.vala"
	_tmp125_ = _tmp124_;
#line 373 "../src/dialog.vala"
	_tmp126_ = strlen (_tmp125_);
#line 373 "../src/dialog.vala"
	_tmp127_ = _tmp126_;
#line 373 "../src/dialog.vala"
	if (_tmp127_ > 1) {
#line 5228 "dialog.c"
		gchar** scanDirList = NULL;
		BookwormAppSettings* _tmp128_;
		const gchar* _tmp129_;
		const gchar* _tmp130_;
		gchar** _tmp131_;
		gchar** _tmp132_;
		gint scanDirList_length1;
		gint _scanDirList_size_;
		gchar** _tmp133_;
		gint _tmp133__length1;
#line 374 "../src/dialog.vala"
		_tmp128_ = bookworm_app_app_dialog_settings;
#line 374 "../src/dialog.vala"
		_tmp129_ = bookworm_app_settings_get_list_of_scan_dirs (_tmp128_);
#line 374 "../src/dialog.vala"
		_tmp130_ = _tmp129_;
#line 374 "../src/dialog.vala"
		_tmp132_ = _tmp131_ = g_strsplit (_tmp130_, "~~", 0);
#line 374 "../src/dialog.vala"
		scanDirList = _tmp132_;
#line 374 "../src/dialog.vala"
		scanDirList_length1 = _vala_array_length (_tmp131_);
#line 374 "../src/dialog.vala"
		_scanDirList_size_ = scanDirList_length1;
#line 375 "../src/dialog.vala"
		_tmp133_ = scanDirList;
#line 375 "../src/dialog.vala"
		_tmp133__length1 = scanDirList_length1;
#line 5257 "dialog.c"
		{
			gchar** dir_collection = NULL;
			gint dir_collection_length1 = 0;
			gint _dir_collection_size_ = 0;
			gint dir_it = 0;
#line 375 "../src/dialog.vala"
			dir_collection = _tmp133_;
#line 375 "../src/dialog.vala"
			dir_collection_length1 = _tmp133__length1;
#line 375 "../src/dialog.vala"
			for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
#line 5269 "dialog.c"
				gchar* _tmp134_;
				gchar* dir = NULL;
#line 375 "../src/dialog.vala"
				_tmp134_ = g_strdup (dir_collection[dir_it]);
#line 375 "../src/dialog.vala"
				dir = _tmp134_;
#line 5276 "dialog.c"
				{
					gboolean _tmp135_ = FALSE;
					const gchar* _tmp136_;
#line 376 "../src/dialog.vala"
					_tmp136_ = dir;
#line 376 "../src/dialog.vala"
					if (_tmp136_ != NULL) {
#line 5284 "dialog.c"
						const gchar* _tmp137_;
						gint _tmp138_;
						gint _tmp139_;
#line 376 "../src/dialog.vala"
						_tmp137_ = dir;
#line 376 "../src/dialog.vala"
						_tmp138_ = strlen (_tmp137_);
#line 376 "../src/dialog.vala"
						_tmp139_ = _tmp138_;
#line 376 "../src/dialog.vala"
						_tmp135_ = _tmp139_ > 1;
#line 5296 "dialog.c"
					} else {
#line 376 "../src/dialog.vala"
						_tmp135_ = FALSE;
#line 5300 "dialog.c"
					}
#line 376 "../src/dialog.vala"
					if (_tmp135_) {
#line 5304 "dialog.c"
						GtkComboBoxText* _tmp140_;
						const gchar* _tmp141_;
#line 377 "../src/dialog.vala"
						_tmp140_ = bookworm_app_app_dialog_directoryComboBox;
#line 377 "../src/dialog.vala"
						_tmp141_ = dir;
#line 377 "../src/dialog.vala"
						gtk_combo_box_text_append_text (_tmp140_, _tmp141_);
#line 5313 "dialog.c"
					}
#line 375 "../src/dialog.vala"
					_g_free0 (dir);
#line 5317 "dialog.c"
				}
			}
		}
#line 373 "../src/dialog.vala"
		scanDirList = (_vala_array_free (scanDirList, scanDirList_length1, (GDestroyNotify) g_free), NULL);
#line 5323 "dialog.c"
	}
#line 381 "../src/dialog.vala"
	_tmp142_ = bookworm_app_app_dialog_directoryComboBox;
#line 381 "../src/dialog.vala"
	gtk_combo_box_set_active ((GtkComboBox*) _tmp142_, 0);
#line 384 "../src/dialog.vala"
	_tmp143_ = (GtkButton*) gtk_button_new ();
#line 384 "../src/dialog.vala"
	g_object_ref_sink (_tmp143_);
#line 384 "../src/dialog.vala"
	add_scan_directory_button = _tmp143_;
#line 385 "../src/dialog.vala"
	_tmp144_ = bookworm_app_bookworm_add_scan_directory_image;
#line 385 "../src/dialog.vala"
	gtk_button_set_image (add_scan_directory_button, (GtkWidget*) _tmp144_);
#line 386 "../src/dialog.vala"
	gtk_button_set_relief (add_scan_directory_button, GTK_RELIEF_NONE);
#line 387 "../src/dialog.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) add_scan_directory_button, BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_ADD_DIRECTORY);
#line 390 "../src/dialog.vala"
	_tmp145_ = (GtkButton*) gtk_button_new ();
#line 390 "../src/dialog.vala"
	g_object_ref_sink (_tmp145_);
#line 390 "../src/dialog.vala"
	remove_scan_directory_button = _tmp145_;
#line 391 "../src/dialog.vala"
	_tmp146_ = bookworm_app_bookworm_remove_scan_directory_image;
#line 391 "../src/dialog.vala"
	gtk_button_set_image (remove_scan_directory_button, (GtkWidget*) _tmp146_);
#line 392 "../src/dialog.vala"
	gtk_button_set_relief (remove_scan_directory_button, GTK_RELIEF_NONE);
#line 393 "../src/dialog.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) remove_scan_directory_button, BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_REMOVE_DIRECTORY);
#line 396 "../src/dialog.vala"
	_tmp147_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 1);
#line 396 "../src/dialog.vala"
	g_object_ref_sink (_tmp147_);
#line 396 "../src/dialog.vala"
	discoverBooksBox = _tmp147_;
#line 397 "../src/dialog.vala"
	_tmp148_ = discoverBooksLabel;
#line 397 "../src/dialog.vala"
	gtk_box_pack_start (discoverBooksBox, (GtkWidget*) _tmp148_, FALSE, FALSE, (guint) 0);
#line 398 "../src/dialog.vala"
	gtk_box_pack_start (discoverBooksBox, (GtkWidget*) add_scan_directory_button, FALSE, FALSE, (guint) 0);
#line 399 "../src/dialog.vala"
	gtk_box_pack_start (discoverBooksBox, (GtkWidget*) remove_scan_directory_button, FALSE, FALSE, (guint) 0);
#line 400 "../src/dialog.vala"
	_tmp149_ = bookworm_app_app_dialog_directoryComboBox;
#line 400 "../src/dialog.vala"
	gtk_box_pack_end (discoverBooksBox, (GtkWidget*) _tmp149_, FALSE, FALSE, (guint) 0);
#line 402 "../src/dialog.vala"
	_tmp150_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 1);
#line 402 "../src/dialog.vala"
	g_object_ref_sink (_tmp150_);
#line 402 "../src/dialog.vala"
	libraryPageItemsBox = _tmp150_;
#line 403 "../src/dialog.vala"
	_tmp151_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_PREFERENCES_LIBRARY_PAGE_ITEMS);
#line 403 "../src/dialog.vala"
	g_object_ref_sink (_tmp151_);
#line 403 "../src/dialog.vala"
	libraryPageItemsLabel = _tmp151_;
#line 404 "../src/dialog.vala"
	_tmp152_ = (GtkEntry*) gtk_entry_new ();
#line 404 "../src/dialog.vala"
	g_object_ref_sink (_tmp152_);
#line 404 "../src/dialog.vala"
	_data18_->libraryPageItemsEntry = _tmp152_;
#line 405 "../src/dialog.vala"
	_tmp153_ = bookworm_app_app_dialog_settings;
#line 405 "../src/dialog.vala"
	_tmp154_ = bookworm_app_settings_get_library_page_items (_tmp153_);
#line 405 "../src/dialog.vala"
	_tmp155_ = _tmp154_;
#line 405 "../src/dialog.vala"
	_tmp156_ = g_strdup_printf ("%i", _tmp155_);
#line 405 "../src/dialog.vala"
	_tmp157_ = _tmp156_;
#line 405 "../src/dialog.vala"
	gtk_entry_set_text (_data18_->libraryPageItemsEntry, _tmp157_);
#line 405 "../src/dialog.vala"
	_g_free0 (_tmp157_);
#line 406 "../src/dialog.vala"
	gtk_box_pack_start (libraryPageItemsBox, (GtkWidget*) libraryPageItemsLabel, FALSE, FALSE, (guint) 0);
#line 407 "../src/dialog.vala"
	gtk_box_pack_end (libraryPageItemsBox, (GtkWidget*) _data18_->libraryPageItemsEntry, FALSE, FALSE, (guint) 0);
#line 409 "../src/dialog.vala"
	_tmp158_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 409 "../src/dialog.vala"
	g_object_ref_sink (_tmp158_);
#line 409 "../src/dialog.vala"
	customProfileBox = _tmp158_;
#line 410 "../src/dialog.vala"
	_tmp159_ = bookworm_app_app_dialog_profileCombobox;
#line 410 "../src/dialog.vala"
	gtk_box_pack_start (customProfileBox, (GtkWidget*) _tmp159_, FALSE, FALSE, (guint) 0);
#line 411 "../src/dialog.vala"
	_tmp160_ = highlightColourBox;
#line 411 "../src/dialog.vala"
	gtk_box_pack_end (customProfileBox, (GtkWidget*) _tmp160_, FALSE, FALSE, (guint) 0);
#line 412 "../src/dialog.vala"
	_tmp161_ = textColourBox;
#line 412 "../src/dialog.vala"
	gtk_box_pack_end (customProfileBox, (GtkWidget*) _tmp161_, FALSE, FALSE, (guint) 0);
#line 413 "../src/dialog.vala"
	_tmp162_ = backgroundColourBox;
#line 413 "../src/dialog.vala"
	gtk_box_pack_end (customProfileBox, (GtkWidget*) _tmp162_, FALSE, FALSE, (guint) 0);
#line 415 "../src/dialog.vala"
	_tmp163_ = granite_widgets_toast_new (BOOKWORM_APP_CONSTANTS_TEXT_BOOK_DISCOVERY_TOAST);
#line 415 "../src/dialog.vala"
	g_object_ref_sink (_tmp163_);
#line 415 "../src/dialog.vala"
	_data18_->dialog_toast = _tmp163_;
#line 417 "../src/dialog.vala"
	_tmp164_ = dialog;
#line 417 "../src/dialog.vala"
	_tmp165_ = gtk_dialog_get_content_area ((GtkDialog*) _tmp164_);
#line 417 "../src/dialog.vala"
	_tmp166_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp165_, gtk_box_get_type ()) ? ((GtkBox*) _tmp165_) : NULL);
#line 417 "../src/dialog.vala"
	content = _tmp166_;
#line 418 "../src/dialog.vala"
	gtk_box_set_spacing (content, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 419 "../src/dialog.vala"
	_tmp167_ = prefBox;
#line 419 "../src/dialog.vala"
	gtk_box_pack_start (content, (GtkWidget*) _tmp167_, FALSE, FALSE, (guint) 0);
#line 420 "../src/dialog.vala"
	_tmp168_ = localStorageBox;
#line 420 "../src/dialog.vala"
	gtk_box_pack_start (content, (GtkWidget*) _tmp168_, FALSE, FALSE, (guint) 0);
#line 421 "../src/dialog.vala"
	_tmp169_ = showLibraryAtStartBox;
#line 421 "../src/dialog.vala"
	gtk_box_pack_start (content, (GtkWidget*) _tmp169_, FALSE, FALSE, (guint) 0);
#line 422 "../src/dialog.vala"
	_tmp170_ = twoPageViewBox;
#line 422 "../src/dialog.vala"
	gtk_box_pack_start (content, (GtkWidget*) _tmp170_, FALSE, FALSE, (guint) 0);
#line 423 "../src/dialog.vala"
	_tmp171_ = fontBox;
#line 423 "../src/dialog.vala"
	gtk_box_pack_start (content, (GtkWidget*) _tmp171_, FALSE, FALSE, (guint) 0);
#line 424 "../src/dialog.vala"
	gtk_box_pack_start (content, (GtkWidget*) customProfileBox, FALSE, FALSE, (guint) 0);
#line 425 "../src/dialog.vala"
	gtk_box_pack_start (content, (GtkWidget*) discoverBooksBox, FALSE, FALSE, (guint) 0);
#line 426 "../src/dialog.vala"
	gtk_box_pack_start (content, (GtkWidget*) libraryPageItemsBox, FALSE, FALSE, (guint) 0);
#line 427 "../src/dialog.vala"
	_tmp172_ = resetBox;
#line 427 "../src/dialog.vala"
	gtk_box_pack_end (content, (GtkWidget*) _tmp172_, TRUE, TRUE, (guint) 5);
#line 428 "../src/dialog.vala"
	gtk_box_pack_end (content, (GtkWidget*) _data18_->dialog_toast, TRUE, TRUE, (guint) 0);
#line 430 "../src/dialog.vala"
	_tmp173_ = dialog;
#line 430 "../src/dialog.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp173_);
#line 433 "../src/dialog.vala"
	_tmp174_ = _data18_->fontButton;
#line 433 "../src/dialog.vala"
	g_signal_connect_data (_tmp174_, "font-set", (GCallback) ___lambda15__gtk_font_button_font_set, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 451 "../src/dialog.vala"
	_tmp175_ = _data18_->localStorageSwitch;
#line 451 "../src/dialog.vala"
	g_signal_connect_data ((GObject*) _tmp175_, "notify::active", (GCallback) ___lambda16__g_object_notify, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 459 "../src/dialog.vala"
	_tmp176_ = _data18_->showLibraryAtStartSwitch;
#line 459 "../src/dialog.vala"
	g_signal_connect_data ((GObject*) _tmp176_, "notify::active", (GCallback) ___lambda17__g_object_notify, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 467 "../src/dialog.vala"
	_tmp177_ = _data18_->twoPageViewSwitch;
#line 467 "../src/dialog.vala"
	g_signal_connect_data ((GObject*) _tmp177_, "notify::active", (GCallback) ___lambda18__g_object_notify, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 477 "../src/dialog.vala"
	_tmp178_ = _data18_->nightModeSwitch;
#line 477 "../src/dialog.vala"
	g_signal_connect_data ((GObject*) _tmp178_, "notify::active", (GCallback) ___lambda19__g_object_notify, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 497 "../src/dialog.vala"
	_tmp179_ = bookworm_app_app_dialog_profileCombobox;
#line 497 "../src/dialog.vala"
	g_signal_connect_data ((GtkComboBox*) _tmp179_, "changed", (GCallback) ___lambda20__gtk_combo_box_changed, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 530 "../src/dialog.vala"
	_tmp180_ = _data18_->textColourButton;
#line 530 "../src/dialog.vala"
	g_signal_connect_data (_tmp180_, "color-set", (GCallback) ___lambda21__gtk_color_button_color_set, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 545 "../src/dialog.vala"
	_tmp181_ = _data18_->backgroundColourButton;
#line 545 "../src/dialog.vala"
	g_signal_connect_data (_tmp181_, "color-set", (GCallback) ___lambda22__gtk_color_button_color_set, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 560 "../src/dialog.vala"
	_tmp182_ = _data18_->highlightColourButton;
#line 560 "../src/dialog.vala"
	g_signal_connect_data (_tmp182_, "color-set", (GCallback) ___lambda23__gtk_color_button_color_set, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 576 "../src/dialog.vala"
	g_signal_connect_data (add_scan_directory_button, "clicked", (GCallback) ___lambda24__gtk_button_clicked, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 598 "../src/dialog.vala"
	g_signal_connect (remove_scan_directory_button, "clicked", (GCallback) ___lambda26__gtk_button_clicked, NULL);
#line 611 "../src/dialog.vala"
	g_signal_connect_data ((GtkEditable*) _data18_->libraryPageItemsEntry, "changed", (GCallback) ___lambda27__gtk_editable_changed, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 614 "../src/dialog.vala"
	_tmp183_ = preferencesReset;
#line 614 "../src/dialog.vala"
	g_signal_connect_data (_tmp183_, "activate-link", (GCallback) ___lambda28__gtk_link_button_activate_link, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 679 "../src/dialog.vala"
	_tmp184_ = dialog;
#line 679 "../src/dialog.vala"
	g_signal_connect ((GtkDialog*) _tmp184_, "response", (GCallback) ___lambda29__gtk_dialog_response, NULL);
#line 682 "../src/dialog.vala"
	g_debug ("dialog.vala:682: [END] [FUNCTION:createPreferencesDialog]");
#line 265 "../src/dialog.vala"
	_g_object_unref0 (content);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (customProfileBox);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (libraryPageItemsLabel);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (libraryPageItemsBox);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (discoverBooksBox);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (remove_scan_directory_button);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (add_scan_directory_button);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (discoverBooksLabel);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (resetBox);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (preferencesReset);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (highlightColourBox);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (highlightColourLabel);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (textColourBox);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (textColourLabel);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (backgroundColourBox);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (backgroundColourLabel);
#line 265 "../src/dialog.vala"
	_g_string_free0 (profileNameText);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (fontBox);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (fontChooserLabel);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (showLibraryAtStartBox);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (showLibraryAtStartLabel);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (twoPageViewBox);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (twoPageViewLabel);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (prefBox);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (colourScheme);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (localStorageBox);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (localStorageLabel);
#line 265 "../src/dialog.vala"
	_g_object_unref0 (dialog);
#line 265 "../src/dialog.vala"
	block18_data_unref (_data18_);
#line 265 "../src/dialog.vala"
	_data18_ = NULL;
#line 5597 "dialog.c"
}

void
bookworm_app_app_dialog_updateProfileColorToSettings (void)
{
	GString* listOfProfileColors = NULL;
	GString* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	BookwormAppSettings* _tmp6_;
	GString* _tmp7_;
	const gchar* _tmp8_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GtkCssProvider* _tmp15_;
#line 686 "../src/dialog.vala"
	g_debug ("dialog.vala:686: [START] [FUNCTION:updateProfileColorToSettings]");
#line 688 "../src/dialog.vala"
	_tmp0_ = g_string_new ("");
#line 688 "../src/dialog.vala"
	listOfProfileColors = _tmp0_;
#line 689 "../src/dialog.vala"
	_tmp1_ = bookworm_app_bookworm_profileColorList;
#line 689 "../src/dialog.vala"
	_tmp1__length1 = bookworm_app_bookworm_profileColorList_length1;
#line 5627 "dialog.c"
	{
		gchar** aProfileColor_collection = NULL;
		gint aProfileColor_collection_length1 = 0;
		gint _aProfileColor_collection_size_ = 0;
		gint aProfileColor_it = 0;
#line 689 "../src/dialog.vala"
		aProfileColor_collection = _tmp1_;
#line 689 "../src/dialog.vala"
		aProfileColor_collection_length1 = _tmp1__length1;
#line 689 "../src/dialog.vala"
		for (aProfileColor_it = 0; aProfileColor_it < aProfileColor_collection_length1; aProfileColor_it = aProfileColor_it + 1) {
#line 5639 "dialog.c"
			gchar* _tmp2_;
			gchar* aProfileColor = NULL;
#line 689 "../src/dialog.vala"
			_tmp2_ = g_strdup (aProfileColor_collection[aProfileColor_it]);
#line 689 "../src/dialog.vala"
			aProfileColor = _tmp2_;
#line 5646 "dialog.c"
			{
				GString* _tmp3_;
				const gchar* _tmp4_;
				GString* _tmp5_;
#line 690 "../src/dialog.vala"
				_tmp3_ = listOfProfileColors;
#line 690 "../src/dialog.vala"
				_tmp4_ = aProfileColor;
#line 690 "../src/dialog.vala"
				_tmp5_ = g_string_append (_tmp3_, _tmp4_);
#line 690 "../src/dialog.vala"
				g_string_append (_tmp5_, ",");
#line 689 "../src/dialog.vala"
				_g_free0 (aProfileColor);
#line 5661 "dialog.c"
			}
		}
	}
#line 692 "../src/dialog.vala"
	_tmp6_ = bookworm_app_app_dialog_settings;
#line 692 "../src/dialog.vala"
	_tmp7_ = listOfProfileColors;
#line 692 "../src/dialog.vala"
	_tmp8_ = _tmp7_->str;
#line 692 "../src/dialog.vala"
	_tmp9_ = listOfProfileColors;
#line 692 "../src/dialog.vala"
	_tmp10_ = _tmp9_->str;
#line 692 "../src/dialog.vala"
	_tmp11_ = strlen (_tmp10_);
#line 692 "../src/dialog.vala"
	_tmp12_ = _tmp11_;
#line 692 "../src/dialog.vala"
	_tmp13_ = string_slice (_tmp8_, (glong) 0, (glong) (_tmp12_ - 1));
#line 692 "../src/dialog.vala"
	_tmp14_ = _tmp13_;
#line 692 "../src/dialog.vala"
	bookworm_app_settings_set_list_of_profile_colors (_tmp6_, _tmp14_);
#line 692 "../src/dialog.vala"
	_g_free0 (_tmp14_);
#line 694 "../src/dialog.vala"
	_tmp15_ = bookworm_app_bookworm_cssProvider;
#line 694 "../src/dialog.vala"
	bookworm_app_bookworm_loadCSSProvider (_tmp15_);
#line 695 "../src/dialog.vala"
	g_debug ("dialog.vala:695: [END] [FUNCTION:updateProfileColorToSettings]");
#line 685 "../src/dialog.vala"
	_g_string_free0 (listOfProfileColors);
#line 5695 "dialog.c"
}

gboolean
bookworm_app_app_dialog_filterFont (PangoFontFamily* family,
                                    PangoFontFace* face)
{
	const gchar* _tmp0_;
	gboolean result;
#line 698 "../src/dialog.vala"
	g_return_val_if_fail (family != NULL, FALSE);
#line 698 "../src/dialog.vala"
	g_return_val_if_fail (face != NULL, FALSE);
#line 699 "../src/dialog.vala"
	_tmp0_ = pango_font_face_get_face_name (face);
#line 699 "../src/dialog.vala"
	if (g_strcmp0 (_tmp0_, "Regular") != 0) {
#line 700 "../src/dialog.vala"
		result = FALSE;
#line 700 "../src/dialog.vala"
		return result;
#line 5716 "dialog.c"
	}
#line 702 "../src/dialog.vala"
	result = TRUE;
#line 702 "../src/dialog.vala"
	return result;
#line 5722 "dialog.c"
}

gchar*
bookworm_app_app_dialog_rgba_to_hex (GdkRGBA* color,
                                     gboolean alpha,
                                     gboolean prefix_hash)
{
	gchar* hex = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 705 "../src/dialog.vala"
	g_return_val_if_fail (color != NULL, NULL);
#line 707 "../src/dialog.vala"
	_tmp0_ = g_strdup ("");
#line 707 "../src/dialog.vala"
	hex = _tmp0_;
#line 708 "../src/dialog.vala"
	if (alpha) {
#line 5741 "dialog.c"
		GdkRGBA _tmp1_;
		GdkRGBA _tmp2_;
		GdkRGBA _tmp3_;
		GdkRGBA _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 709 "../src/dialog.vala"
		_tmp1_ = *color;
#line 709 "../src/dialog.vala"
		_tmp2_ = *color;
#line 709 "../src/dialog.vala"
		_tmp3_ = *color;
#line 709 "../src/dialog.vala"
		_tmp4_ = *color;
#line 709 "../src/dialog.vala"
		_tmp5_ = g_strdup_printf ("%02x%02x%02x%02x", (guint) round (_tmp1_.red * 255), (guint) round (_tmp2_.green * 255), (guint) round (_tmp3_.blue * 255), (guint) round (_tmp4_.alpha * 255));
#line 709 "../src/dialog.vala"
		_tmp6_ = _tmp5_;
#line 709 "../src/dialog.vala"
		_tmp7_ = g_utf8_strup (_tmp6_, (gssize) -1);
#line 709 "../src/dialog.vala"
		_g_free0 (hex);
#line 709 "../src/dialog.vala"
		hex = _tmp7_;
#line 709 "../src/dialog.vala"
		_g_free0 (_tmp6_);
#line 5769 "dialog.c"
	} else {
		GdkRGBA _tmp8_;
		GdkRGBA _tmp9_;
		GdkRGBA _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
#line 714 "../src/dialog.vala"
		_tmp8_ = *color;
#line 714 "../src/dialog.vala"
		_tmp9_ = *color;
#line 714 "../src/dialog.vala"
		_tmp10_ = *color;
#line 714 "../src/dialog.vala"
		_tmp11_ = g_strdup_printf ("%02x%02x%02x", (guint) round (_tmp8_.red * 255), (guint) round (_tmp9_.green * 255), (guint) round (_tmp10_.blue * 255));
#line 714 "../src/dialog.vala"
		_tmp12_ = _tmp11_;
#line 714 "../src/dialog.vala"
		_tmp13_ = g_utf8_strup (_tmp12_, (gssize) -1);
#line 714 "../src/dialog.vala"
		_g_free0 (hex);
#line 714 "../src/dialog.vala"
		hex = _tmp13_;
#line 714 "../src/dialog.vala"
		_g_free0 (_tmp12_);
#line 5795 "dialog.c"
	}
#line 716 "../src/dialog.vala"
	if (prefix_hash) {
#line 5799 "dialog.c"
		const gchar* _tmp14_;
		gchar* _tmp15_;
#line 717 "../src/dialog.vala"
		_tmp14_ = hex;
#line 717 "../src/dialog.vala"
		_tmp15_ = g_strconcat ("#", _tmp14_, NULL);
#line 717 "../src/dialog.vala"
		_g_free0 (hex);
#line 717 "../src/dialog.vala"
		hex = _tmp15_;
#line 5810 "dialog.c"
	}
#line 719 "../src/dialog.vala"
	result = hex;
#line 719 "../src/dialog.vala"
	return result;
#line 5816 "dialog.c"
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
#line 722 "../src/dialog.vala"
	g_atomic_int_inc (&_data19_->_ref_count_);
#line 722 "../src/dialog.vala"
	return _data19_;
#line 5826 "dialog.c"
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
#line 722 "../src/dialog.vala"
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
#line 722 "../src/dialog.vala"
		_g_object_unref0 (_data19_->annotationTagEntry);
#line 722 "../src/dialog.vala"
		_g_object_unref0 (_data19_->annotationsInputTextView);
#line 722 "../src/dialog.vala"
		_bookworm_app_book_unref0 (_data19_->aBook);
#line 722 "../src/dialog.vala"
		_g_free0 (_data19_->textForAnnotation);
#line 722 "../src/dialog.vala"
		g_slice_free (Block19Data, _data19_);
#line 5846 "dialog.c"
	}
}

static void
__lambda30_ (Block19Data* _data19_)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	BookwormAppBook* _tmp14_;
	gchar* _tmp15_;
	BookwormAppBook* _tmp16_;
#line 757 "../src/dialog.vala"
	_tmp0_ = g_strdup_printf ("%i", bookworm_app_book_getBookPageNumber (_data19_->aBook));
#line 757 "../src/dialog.vala"
	_tmp1_ = _tmp0_;
#line 757 "../src/dialog.vala"
	_tmp2_ = g_strconcat (_tmp1_, "#~~#", NULL);
#line 757 "../src/dialog.vala"
	_tmp3_ = _tmp2_;
#line 757 "../src/dialog.vala"
	_tmp4_ = g_strconcat (_tmp3_, _data19_->textForAnnotation, NULL);
#line 757 "../src/dialog.vala"
	_tmp5_ = _tmp4_;
#line 757 "../src/dialog.vala"
	_tmp6_ = gtk_text_view_get_buffer (_data19_->annotationsInputTextView);
#line 757 "../src/dialog.vala"
	_tmp7_ = _tmp6_;
#line 757 "../src/dialog.vala"
	g_object_get (_tmp7_, "text", &_tmp8_, NULL);
#line 757 "../src/dialog.vala"
	_tmp9_ = _tmp8_;
#line 757 "../src/dialog.vala"
	_tmp10_ = _tmp9_;
#line 757 "../src/dialog.vala"
	bookworm_app_book_setAnnotations (_data19_->aBook, _tmp5_, _tmp10_);
#line 757 "../src/dialog.vala"
	_g_free0 (_tmp10_);
#line 757 "../src/dialog.vala"
	_g_free0 (_tmp5_);
#line 757 "../src/dialog.vala"
	_g_free0 (_tmp3_);
#line 757 "../src/dialog.vala"
	_g_free0 (_tmp1_);
#line 758 "../src/dialog.vala"
	_tmp11_ = gtk_entry_get_text (_data19_->annotationTagEntry);
#line 758 "../src/dialog.vala"
	bookworm_app_book_setAnnotationTags (_data19_->aBook, _tmp11_);
#line 759 "../src/dialog.vala"
	_tmp12_ = bookworm_app_utils_setWebViewTitle ("document.title = ' '");
#line 759 "../src/dialog.vala"
	_tmp13_ = _tmp12_;
#line 759 "../src/dialog.vala"
	_g_free0 (_tmp13_);
#line 760 "../src/dialog.vala"
	_tmp14_ = _bookworm_app_book_ref0 (_data19_->aBook);
#line 760 "../src/dialog.vala"
	_tmp15_ = g_strdup ("");
#line 760 "../src/dialog.vala"
	_tmp16_ = bookworm_app_content_handler_renderPage (_tmp14_, _tmp15_);
#line 760 "../src/dialog.vala"
	_bookworm_app_book_unref0 (_data19_->aBook);
#line 760 "../src/dialog.vala"
	_data19_->aBook = _tmp16_;
#line 5922 "dialog.c"
}

static void
___lambda30__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
#line 756 "../src/dialog.vala"
	__lambda30_ (self);
#line 5931 "dialog.c"
}

void
bookworm_app_app_dialog_createAnnotationDialog (const gchar* textForAnnotation)
{
	Block19Data* _data19_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkDialog* annotationDialog = NULL;
	GtkDialog* _tmp3_;
	GtkApplicationWindow* _tmp4_;
	GeeHashMap* _tmp5_;
	const gchar* _tmp6_;
	gpointer _tmp7_;
	GtkLabel* annotationsLabel = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkTextView* _tmp16_;
	GtkTextBuffer* _tmp17_;
	GtkTextBuffer* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GtkScrolledWindow* scrolledAnnotations = NULL;
	GtkScrolledWindow* _tmp27_;
	GtkLabel* annotationsTagLabel = NULL;
	GtkLabel* _tmp28_;
	GtkEntry* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GtkBox* annotationTagBox = NULL;
	GtkBox* _tmp32_;
	GtkBox* content = NULL;
	GtkBox* _tmp33_;
	GtkBox* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
#line 722 "../src/dialog.vala"
	g_return_if_fail (textForAnnotation != NULL);
#line 722 "../src/dialog.vala"
	_data19_ = g_slice_new0 (Block19Data);
#line 722 "../src/dialog.vala"
	_data19_->_ref_count_ = 1;
#line 722 "../src/dialog.vala"
	_tmp0_ = g_strdup (textForAnnotation);
#line 722 "../src/dialog.vala"
	_g_free0 (_data19_->textForAnnotation);
#line 722 "../src/dialog.vala"
	_data19_->textForAnnotation = _tmp0_;
#line 723 "../src/dialog.vala"
	_tmp1_ = g_strconcat ("[START] [FUNCTION:createAnnotationDialog] textForAnnotation=", _data19_->textForAnnotation, NULL);
#line 723 "../src/dialog.vala"
	_tmp2_ = _tmp1_;
#line 723 "../src/dialog.vala"
	g_debug ("dialog.vala:723: %s", _tmp2_);
#line 723 "../src/dialog.vala"
	_g_free0 (_tmp2_);
#line 724 "../src/dialog.vala"
	_tmp3_ = (GtkDialog*) gtk_dialog_new ();
#line 724 "../src/dialog.vala"
	g_object_ref_sink (_tmp3_);
#line 724 "../src/dialog.vala"
	annotationDialog = _tmp3_;
#line 725 "../src/dialog.vala"
	_tmp4_ = bookworm_app_bookworm_window;
#line 725 "../src/dialog.vala"
	gtk_window_set_transient_for ((GtkWindow*) annotationDialog, (GtkWindow*) _tmp4_);
#line 726 "../src/dialog.vala"
	gtk_container_set_border_width ((GtkContainer*) annotationDialog, (guint) BOOKWORM_APP_CONSTANTS_SPACING_BUTTONS);
#line 727 "../src/dialog.vala"
	gtk_window_set_default_size ((GtkWindow*) annotationDialog, 600, 400);
#line 728 "../src/dialog.vala"
	_tmp5_ = bookworm_app_bookworm_libraryViewMap;
#line 728 "../src/dialog.vala"
	_tmp6_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 728 "../src/dialog.vala"
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp6_);
#line 728 "../src/dialog.vala"
	_data19_->aBook = (BookwormAppBook*) _tmp7_;
#line 730 "../src/dialog.vala"
	_tmp8_ = g_strconcat (" ", _data19_->textForAnnotation, NULL);
#line 730 "../src/dialog.vala"
	_tmp9_ = _tmp8_;
#line 730 "../src/dialog.vala"
	_tmp10_ = bookworm_app_utils_minimizeStringLength (_tmp9_, 35);
#line 730 "../src/dialog.vala"
	_tmp11_ = _tmp10_;
#line 730 "../src/dialog.vala"
	_tmp12_ = g_strconcat (BOOKWORM_APP_CONSTANTS_TEXT_FOR_ANNOTATION, _tmp11_, NULL);
#line 730 "../src/dialog.vala"
	_tmp13_ = _tmp12_;
#line 730 "../src/dialog.vala"
	_tmp14_ = (GtkLabel*) gtk_label_new (_tmp13_);
#line 730 "../src/dialog.vala"
	g_object_ref_sink (_tmp14_);
#line 730 "../src/dialog.vala"
	_tmp15_ = _tmp14_;
#line 730 "../src/dialog.vala"
	_g_free0 (_tmp13_);
#line 730 "../src/dialog.vala"
	_g_free0 (_tmp11_);
#line 730 "../src/dialog.vala"
	_g_free0 (_tmp9_);
#line 730 "../src/dialog.vala"
	annotationsLabel = _tmp15_;
#line 734 "../src/dialog.vala"
	gtk_label_set_line_wrap (annotationsLabel, TRUE);
#line 735 "../src/dialog.vala"
	_tmp16_ = (GtkTextView*) gtk_text_view_new ();
#line 735 "../src/dialog.vala"
	g_object_ref_sink (_tmp16_);
#line 735 "../src/dialog.vala"
	_data19_->annotationsInputTextView = _tmp16_;
#line 736 "../src/dialog.vala"
	gtk_text_view_set_wrap_mode (_data19_->annotationsInputTextView, GTK_WRAP_WORD);
#line 737 "../src/dialog.vala"
	_tmp17_ = gtk_text_view_get_buffer (_data19_->annotationsInputTextView);
#line 737 "../src/dialog.vala"
	_tmp18_ = _tmp17_;
#line 737 "../src/dialog.vala"
	_tmp19_ = g_strdup_printf ("%i", bookworm_app_book_getBookPageNumber (_data19_->aBook));
#line 737 "../src/dialog.vala"
	_tmp20_ = _tmp19_;
#line 737 "../src/dialog.vala"
	_tmp21_ = g_strconcat (_tmp20_, "#~~#", NULL);
#line 737 "../src/dialog.vala"
	_tmp22_ = _tmp21_;
#line 737 "../src/dialog.vala"
	_tmp23_ = g_strconcat (_tmp22_, _data19_->textForAnnotation, NULL);
#line 737 "../src/dialog.vala"
	_tmp24_ = _tmp23_;
#line 737 "../src/dialog.vala"
	_tmp25_ = bookworm_app_book_getAnnotations (_data19_->aBook, _tmp24_);
#line 737 "../src/dialog.vala"
	_tmp26_ = _tmp25_;
#line 737 "../src/dialog.vala"
	g_object_set (_tmp18_, "text", _tmp26_, NULL);
#line 737 "../src/dialog.vala"
	_g_free0 (_tmp26_);
#line 737 "../src/dialog.vala"
	_g_free0 (_tmp24_);
#line 737 "../src/dialog.vala"
	_g_free0 (_tmp22_);
#line 737 "../src/dialog.vala"
	_g_free0 (_tmp20_);
#line 738 "../src/dialog.vala"
	_tmp27_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 738 "../src/dialog.vala"
	g_object_ref_sink (_tmp27_);
#line 738 "../src/dialog.vala"
	scrolledAnnotations = _tmp27_;
#line 739 "../src/dialog.vala"
	gtk_container_add ((GtkContainer*) scrolledAnnotations, (GtkWidget*) _data19_->annotationsInputTextView);
#line 741 "../src/dialog.vala"
	_tmp28_ = (GtkLabel*) gtk_label_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_ANNOTATION_TAG);
#line 741 "../src/dialog.vala"
	g_object_ref_sink (_tmp28_);
#line 741 "../src/dialog.vala"
	annotationsTagLabel = _tmp28_;
#line 742 "../src/dialog.vala"
	_tmp29_ = (GtkEntry*) gtk_entry_new ();
#line 742 "../src/dialog.vala"
	g_object_ref_sink (_tmp29_);
#line 742 "../src/dialog.vala"
	_data19_->annotationTagEntry = _tmp29_;
#line 743 "../src/dialog.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) _data19_->annotationTagEntry, BOOKWORM_APP_CONSTANTS_TEXT_FOR_ANNOTATION_TAG_ENTRY);
#line 744 "../src/dialog.vala"
	_tmp30_ = bookworm_app_book_getAnnotationTags (_data19_->aBook);
#line 744 "../src/dialog.vala"
	_tmp31_ = _tmp30_;
#line 744 "../src/dialog.vala"
	gtk_entry_set_text (_data19_->annotationTagEntry, _tmp31_);
#line 744 "../src/dialog.vala"
	_g_free0 (_tmp31_);
#line 745 "../src/dialog.vala"
	_tmp32_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 745 "../src/dialog.vala"
	g_object_ref_sink (_tmp32_);
#line 745 "../src/dialog.vala"
	annotationTagBox = _tmp32_;
#line 746 "../src/dialog.vala"
	gtk_box_pack_start (annotationTagBox, (GtkWidget*) annotationsTagLabel, FALSE, FALSE, (guint) 0);
#line 747 "../src/dialog.vala"
	gtk_box_pack_start (annotationTagBox, (GtkWidget*) _data19_->annotationTagEntry, FALSE, TRUE, (guint) 0);
#line 749 "../src/dialog.vala"
	_tmp33_ = gtk_dialog_get_content_area (annotationDialog);
#line 749 "../src/dialog.vala"
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, gtk_box_get_type ()) ? ((GtkBox*) _tmp33_) : NULL);
#line 749 "../src/dialog.vala"
	content = _tmp34_;
#line 750 "../src/dialog.vala"
	gtk_box_set_spacing (content, BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 751 "../src/dialog.vala"
	gtk_box_pack_start (content, (GtkWidget*) annotationsLabel, FALSE, FALSE, (guint) 0);
#line 752 "../src/dialog.vala"
	gtk_box_pack_start (content, (GtkWidget*) scrolledAnnotations, TRUE, TRUE, (guint) 0);
#line 753 "../src/dialog.vala"
	gtk_box_pack_start (content, (GtkWidget*) annotationTagBox, FALSE, TRUE, (guint) 0);
#line 754 "../src/dialog.vala"
	gtk_widget_show_all ((GtkWidget*) annotationDialog);
#line 756 "../src/dialog.vala"
	g_signal_connect_data ((GtkWidget*) annotationDialog, "destroy", (GCallback) ___lambda30__gtk_widget_destroy, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
#line 762 "../src/dialog.vala"
	_tmp35_ = g_strconcat ("[END] [FUNCTION:createAnnotationDialog] textForAnnotation=", _data19_->textForAnnotation, NULL);
#line 762 "../src/dialog.vala"
	_tmp36_ = _tmp35_;
#line 762 "../src/dialog.vala"
	g_debug ("dialog.vala:762: %s", _tmp36_);
#line 762 "../src/dialog.vala"
	_g_free0 (_tmp36_);
#line 722 "../src/dialog.vala"
	_g_object_unref0 (content);
#line 722 "../src/dialog.vala"
	_g_object_unref0 (annotationTagBox);
#line 722 "../src/dialog.vala"
	_g_object_unref0 (annotationsTagLabel);
#line 722 "../src/dialog.vala"
	_g_object_unref0 (scrolledAnnotations);
#line 722 "../src/dialog.vala"
	_g_object_unref0 (annotationsLabel);
#line 722 "../src/dialog.vala"
	_g_object_unref0 (annotationDialog);
#line 722 "../src/dialog.vala"
	block19_data_unref (_data19_);
#line 722 "../src/dialog.vala"
	_data19_ = NULL;
#line 6171 "dialog.c"
}

static void
bookworm_app_app_dialog_class_init (BookwormAppAppDialogClass * klass,
                                    gpointer klass_data)
{
	GString* _tmp0_;
#line 21 "../src/dialog.vala"
	bookworm_app_app_dialog_parent_class = g_type_class_peek_parent (klass);
#line 21 "../src/dialog.vala"
	G_OBJECT_CLASS (klass)->finalize = bookworm_app_app_dialog_finalize;
#line 24 "../src/dialog.vala"
	_tmp0_ = g_string_new ("");
#line 24 "../src/dialog.vala"
	bookworm_app_app_dialog_scanDirList = _tmp0_;
#line 6187 "dialog.c"
}

static void
bookworm_app_app_dialog_instance_init (BookwormAppAppDialog * self,
                                       gpointer klass)
{
}

static void
bookworm_app_app_dialog_finalize (GObject * obj)
{
	BookwormAppAppDialog * self;
#line 21 "../src/dialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_APP_DIALOG, BookwormAppAppDialog);
#line 21 "../src/dialog.vala"
	G_OBJECT_CLASS (bookworm_app_app_dialog_parent_class)->finalize (obj);
#line 6204 "dialog.c"
}

static GType
bookworm_app_app_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppAppDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_app_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppAppDialog), 0, (GInstanceInitFunc) bookworm_app_app_dialog_instance_init, NULL };
	GType bookworm_app_app_dialog_type_id;
	bookworm_app_app_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "BookwormAppAppDialog", &g_define_type_info, 0);
	return bookworm_app_app_dialog_type_id;
}

GType
bookworm_app_app_dialog_get_type (void)
{
	static volatile gsize bookworm_app_app_dialog_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_app_dialog_type_id__once)) {
		GType bookworm_app_app_dialog_type_id;
		bookworm_app_app_dialog_type_id = bookworm_app_app_dialog_get_type_once ();
		g_once_init_leave (&bookworm_app_app_dialog_type_id__once, bookworm_app_app_dialog_type_id);
	}
	return bookworm_app_app_dialog_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

