//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by conversion-gen. DO NOT EDIT.

package v1

import (
	unsafe "unsafe"

	apisacmev1 "github.com/cert-manager/cert-manager/pkg/apis/acme/v1"
	certmanagerv1 "github.com/cert-manager/cert-manager/pkg/apis/certmanager/v1"
	apismetav1 "github.com/cert-manager/cert-manager/pkg/apis/meta/v1"
	acme "github.com/cert-manager/cmctl/v2/pkg/convert/internal/apis/acme"
	acmev1 "github.com/cert-manager/cmctl/v2/pkg/convert/internal/apis/acme/v1"
	certmanager "github.com/cert-manager/cmctl/v2/pkg/convert/internal/apis/certmanager"
	meta "github.com/cert-manager/cmctl/v2/pkg/convert/internal/apis/meta"
	internalapismetav1 "github.com/cert-manager/cmctl/v2/pkg/convert/internal/apis/meta/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.CAIssuer)(nil), (*certmanager.CAIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CAIssuer_To_certmanager_CAIssuer(a.(*certmanagerv1.CAIssuer), b.(*certmanager.CAIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CAIssuer)(nil), (*certmanagerv1.CAIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CAIssuer_To_v1_CAIssuer(a.(*certmanager.CAIssuer), b.(*certmanagerv1.CAIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.Certificate)(nil), (*certmanager.Certificate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_Certificate_To_certmanager_Certificate(a.(*certmanagerv1.Certificate), b.(*certmanager.Certificate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.Certificate)(nil), (*certmanagerv1.Certificate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_Certificate_To_v1_Certificate(a.(*certmanager.Certificate), b.(*certmanagerv1.Certificate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.CertificateAdditionalOutputFormat)(nil), (*certmanager.CertificateAdditionalOutputFormat)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CertificateAdditionalOutputFormat_To_certmanager_CertificateAdditionalOutputFormat(a.(*certmanagerv1.CertificateAdditionalOutputFormat), b.(*certmanager.CertificateAdditionalOutputFormat), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateAdditionalOutputFormat)(nil), (*certmanagerv1.CertificateAdditionalOutputFormat)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateAdditionalOutputFormat_To_v1_CertificateAdditionalOutputFormat(a.(*certmanager.CertificateAdditionalOutputFormat), b.(*certmanagerv1.CertificateAdditionalOutputFormat), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.CertificateCondition)(nil), (*certmanager.CertificateCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CertificateCondition_To_certmanager_CertificateCondition(a.(*certmanagerv1.CertificateCondition), b.(*certmanager.CertificateCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateCondition)(nil), (*certmanagerv1.CertificateCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateCondition_To_v1_CertificateCondition(a.(*certmanager.CertificateCondition), b.(*certmanagerv1.CertificateCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.CertificateKeystores)(nil), (*certmanager.CertificateKeystores)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CertificateKeystores_To_certmanager_CertificateKeystores(a.(*certmanagerv1.CertificateKeystores), b.(*certmanager.CertificateKeystores), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateKeystores)(nil), (*certmanagerv1.CertificateKeystores)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateKeystores_To_v1_CertificateKeystores(a.(*certmanager.CertificateKeystores), b.(*certmanagerv1.CertificateKeystores), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.CertificateList)(nil), (*certmanager.CertificateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CertificateList_To_certmanager_CertificateList(a.(*certmanagerv1.CertificateList), b.(*certmanager.CertificateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateList)(nil), (*certmanagerv1.CertificateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateList_To_v1_CertificateList(a.(*certmanager.CertificateList), b.(*certmanagerv1.CertificateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.CertificatePrivateKey)(nil), (*certmanager.CertificatePrivateKey)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CertificatePrivateKey_To_certmanager_CertificatePrivateKey(a.(*certmanagerv1.CertificatePrivateKey), b.(*certmanager.CertificatePrivateKey), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificatePrivateKey)(nil), (*certmanagerv1.CertificatePrivateKey)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificatePrivateKey_To_v1_CertificatePrivateKey(a.(*certmanager.CertificatePrivateKey), b.(*certmanagerv1.CertificatePrivateKey), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.CertificateRequest)(nil), (*certmanager.CertificateRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CertificateRequest_To_certmanager_CertificateRequest(a.(*certmanagerv1.CertificateRequest), b.(*certmanager.CertificateRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateRequest)(nil), (*certmanagerv1.CertificateRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequest_To_v1_CertificateRequest(a.(*certmanager.CertificateRequest), b.(*certmanagerv1.CertificateRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.CertificateRequestCondition)(nil), (*certmanager.CertificateRequestCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CertificateRequestCondition_To_certmanager_CertificateRequestCondition(a.(*certmanagerv1.CertificateRequestCondition), b.(*certmanager.CertificateRequestCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateRequestCondition)(nil), (*certmanagerv1.CertificateRequestCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequestCondition_To_v1_CertificateRequestCondition(a.(*certmanager.CertificateRequestCondition), b.(*certmanagerv1.CertificateRequestCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.CertificateRequestList)(nil), (*certmanager.CertificateRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CertificateRequestList_To_certmanager_CertificateRequestList(a.(*certmanagerv1.CertificateRequestList), b.(*certmanager.CertificateRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateRequestList)(nil), (*certmanagerv1.CertificateRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequestList_To_v1_CertificateRequestList(a.(*certmanager.CertificateRequestList), b.(*certmanagerv1.CertificateRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.CertificateRequestSpec)(nil), (*certmanager.CertificateRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CertificateRequestSpec_To_certmanager_CertificateRequestSpec(a.(*certmanagerv1.CertificateRequestSpec), b.(*certmanager.CertificateRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateRequestSpec)(nil), (*certmanagerv1.CertificateRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequestSpec_To_v1_CertificateRequestSpec(a.(*certmanager.CertificateRequestSpec), b.(*certmanagerv1.CertificateRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.CertificateRequestStatus)(nil), (*certmanager.CertificateRequestStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(a.(*certmanagerv1.CertificateRequestStatus), b.(*certmanager.CertificateRequestStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateRequestStatus)(nil), (*certmanagerv1.CertificateRequestStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequestStatus_To_v1_CertificateRequestStatus(a.(*certmanager.CertificateRequestStatus), b.(*certmanagerv1.CertificateRequestStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.CertificateSecretTemplate)(nil), (*certmanager.CertificateSecretTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CertificateSecretTemplate_To_certmanager_CertificateSecretTemplate(a.(*certmanagerv1.CertificateSecretTemplate), b.(*certmanager.CertificateSecretTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateSecretTemplate)(nil), (*certmanagerv1.CertificateSecretTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateSecretTemplate_To_v1_CertificateSecretTemplate(a.(*certmanager.CertificateSecretTemplate), b.(*certmanagerv1.CertificateSecretTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.CertificateSpec)(nil), (*certmanager.CertificateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CertificateSpec_To_certmanager_CertificateSpec(a.(*certmanagerv1.CertificateSpec), b.(*certmanager.CertificateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateSpec)(nil), (*certmanagerv1.CertificateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateSpec_To_v1_CertificateSpec(a.(*certmanager.CertificateSpec), b.(*certmanagerv1.CertificateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.CertificateStatus)(nil), (*certmanager.CertificateStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_CertificateStatus_To_certmanager_CertificateStatus(a.(*certmanagerv1.CertificateStatus), b.(*certmanager.CertificateStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateStatus)(nil), (*certmanagerv1.CertificateStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateStatus_To_v1_CertificateStatus(a.(*certmanager.CertificateStatus), b.(*certmanagerv1.CertificateStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.ClusterIssuer)(nil), (*certmanager.ClusterIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ClusterIssuer_To_certmanager_ClusterIssuer(a.(*certmanagerv1.ClusterIssuer), b.(*certmanager.ClusterIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.ClusterIssuer)(nil), (*certmanagerv1.ClusterIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_ClusterIssuer_To_v1_ClusterIssuer(a.(*certmanager.ClusterIssuer), b.(*certmanagerv1.ClusterIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.ClusterIssuerList)(nil), (*certmanager.ClusterIssuerList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ClusterIssuerList_To_certmanager_ClusterIssuerList(a.(*certmanagerv1.ClusterIssuerList), b.(*certmanager.ClusterIssuerList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.ClusterIssuerList)(nil), (*certmanagerv1.ClusterIssuerList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_ClusterIssuerList_To_v1_ClusterIssuerList(a.(*certmanager.ClusterIssuerList), b.(*certmanagerv1.ClusterIssuerList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.Issuer)(nil), (*certmanager.Issuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_Issuer_To_certmanager_Issuer(a.(*certmanagerv1.Issuer), b.(*certmanager.Issuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.Issuer)(nil), (*certmanagerv1.Issuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_Issuer_To_v1_Issuer(a.(*certmanager.Issuer), b.(*certmanagerv1.Issuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.IssuerCondition)(nil), (*certmanager.IssuerCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_IssuerCondition_To_certmanager_IssuerCondition(a.(*certmanagerv1.IssuerCondition), b.(*certmanager.IssuerCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerCondition)(nil), (*certmanagerv1.IssuerCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerCondition_To_v1_IssuerCondition(a.(*certmanager.IssuerCondition), b.(*certmanagerv1.IssuerCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.IssuerConfig)(nil), (*certmanager.IssuerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_IssuerConfig_To_certmanager_IssuerConfig(a.(*certmanagerv1.IssuerConfig), b.(*certmanager.IssuerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerConfig)(nil), (*certmanagerv1.IssuerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerConfig_To_v1_IssuerConfig(a.(*certmanager.IssuerConfig), b.(*certmanagerv1.IssuerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.IssuerList)(nil), (*certmanager.IssuerList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_IssuerList_To_certmanager_IssuerList(a.(*certmanagerv1.IssuerList), b.(*certmanager.IssuerList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerList)(nil), (*certmanagerv1.IssuerList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerList_To_v1_IssuerList(a.(*certmanager.IssuerList), b.(*certmanagerv1.IssuerList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.IssuerSpec)(nil), (*certmanager.IssuerSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_IssuerSpec_To_certmanager_IssuerSpec(a.(*certmanagerv1.IssuerSpec), b.(*certmanager.IssuerSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerSpec)(nil), (*certmanagerv1.IssuerSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerSpec_To_v1_IssuerSpec(a.(*certmanager.IssuerSpec), b.(*certmanagerv1.IssuerSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.IssuerStatus)(nil), (*certmanager.IssuerStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_IssuerStatus_To_certmanager_IssuerStatus(a.(*certmanagerv1.IssuerStatus), b.(*certmanager.IssuerStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerStatus)(nil), (*certmanagerv1.IssuerStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerStatus_To_v1_IssuerStatus(a.(*certmanager.IssuerStatus), b.(*certmanagerv1.IssuerStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.JKSKeystore)(nil), (*certmanager.JKSKeystore)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_JKSKeystore_To_certmanager_JKSKeystore(a.(*certmanagerv1.JKSKeystore), b.(*certmanager.JKSKeystore), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.JKSKeystore)(nil), (*certmanagerv1.JKSKeystore)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_JKSKeystore_To_v1_JKSKeystore(a.(*certmanager.JKSKeystore), b.(*certmanagerv1.JKSKeystore), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.NameConstraintItem)(nil), (*certmanager.NameConstraintItem)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_NameConstraintItem_To_certmanager_NameConstraintItem(a.(*certmanagerv1.NameConstraintItem), b.(*certmanager.NameConstraintItem), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.NameConstraintItem)(nil), (*certmanagerv1.NameConstraintItem)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_NameConstraintItem_To_v1_NameConstraintItem(a.(*certmanager.NameConstraintItem), b.(*certmanagerv1.NameConstraintItem), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.NameConstraints)(nil), (*certmanager.NameConstraints)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_NameConstraints_To_certmanager_NameConstraints(a.(*certmanagerv1.NameConstraints), b.(*certmanager.NameConstraints), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.NameConstraints)(nil), (*certmanagerv1.NameConstraints)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_NameConstraints_To_v1_NameConstraints(a.(*certmanager.NameConstraints), b.(*certmanagerv1.NameConstraints), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.OtherName)(nil), (*certmanager.OtherName)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_OtherName_To_certmanager_OtherName(a.(*certmanagerv1.OtherName), b.(*certmanager.OtherName), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.OtherName)(nil), (*certmanagerv1.OtherName)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_OtherName_To_v1_OtherName(a.(*certmanager.OtherName), b.(*certmanagerv1.OtherName), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.PKCS12Keystore)(nil), (*certmanager.PKCS12Keystore)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_PKCS12Keystore_To_certmanager_PKCS12Keystore(a.(*certmanagerv1.PKCS12Keystore), b.(*certmanager.PKCS12Keystore), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.PKCS12Keystore)(nil), (*certmanagerv1.PKCS12Keystore)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_PKCS12Keystore_To_v1_PKCS12Keystore(a.(*certmanager.PKCS12Keystore), b.(*certmanagerv1.PKCS12Keystore), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.SelfSignedIssuer)(nil), (*certmanager.SelfSignedIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_SelfSignedIssuer_To_certmanager_SelfSignedIssuer(a.(*certmanagerv1.SelfSignedIssuer), b.(*certmanager.SelfSignedIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.SelfSignedIssuer)(nil), (*certmanagerv1.SelfSignedIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_SelfSignedIssuer_To_v1_SelfSignedIssuer(a.(*certmanager.SelfSignedIssuer), b.(*certmanagerv1.SelfSignedIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.ServiceAccountRef)(nil), (*certmanager.ServiceAccountRef)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ServiceAccountRef_To_certmanager_ServiceAccountRef(a.(*certmanagerv1.ServiceAccountRef), b.(*certmanager.ServiceAccountRef), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.ServiceAccountRef)(nil), (*certmanagerv1.ServiceAccountRef)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_ServiceAccountRef_To_v1_ServiceAccountRef(a.(*certmanager.ServiceAccountRef), b.(*certmanagerv1.ServiceAccountRef), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.VaultAppRole)(nil), (*certmanager.VaultAppRole)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_VaultAppRole_To_certmanager_VaultAppRole(a.(*certmanagerv1.VaultAppRole), b.(*certmanager.VaultAppRole), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VaultAppRole)(nil), (*certmanagerv1.VaultAppRole)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VaultAppRole_To_v1_VaultAppRole(a.(*certmanager.VaultAppRole), b.(*certmanagerv1.VaultAppRole), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.VaultAuth)(nil), (*certmanager.VaultAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_VaultAuth_To_certmanager_VaultAuth(a.(*certmanagerv1.VaultAuth), b.(*certmanager.VaultAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VaultAuth)(nil), (*certmanagerv1.VaultAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VaultAuth_To_v1_VaultAuth(a.(*certmanager.VaultAuth), b.(*certmanagerv1.VaultAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.VaultClientCertificateAuth)(nil), (*certmanager.VaultClientCertificateAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_VaultClientCertificateAuth_To_certmanager_VaultClientCertificateAuth(a.(*certmanagerv1.VaultClientCertificateAuth), b.(*certmanager.VaultClientCertificateAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VaultClientCertificateAuth)(nil), (*certmanagerv1.VaultClientCertificateAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VaultClientCertificateAuth_To_v1_VaultClientCertificateAuth(a.(*certmanager.VaultClientCertificateAuth), b.(*certmanagerv1.VaultClientCertificateAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.VaultIssuer)(nil), (*certmanager.VaultIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_VaultIssuer_To_certmanager_VaultIssuer(a.(*certmanagerv1.VaultIssuer), b.(*certmanager.VaultIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VaultIssuer)(nil), (*certmanagerv1.VaultIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VaultIssuer_To_v1_VaultIssuer(a.(*certmanager.VaultIssuer), b.(*certmanagerv1.VaultIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.VaultKubernetesAuth)(nil), (*certmanager.VaultKubernetesAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth(a.(*certmanagerv1.VaultKubernetesAuth), b.(*certmanager.VaultKubernetesAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VaultKubernetesAuth)(nil), (*certmanagerv1.VaultKubernetesAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VaultKubernetesAuth_To_v1_VaultKubernetesAuth(a.(*certmanager.VaultKubernetesAuth), b.(*certmanagerv1.VaultKubernetesAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.VenafiCloud)(nil), (*certmanager.VenafiCloud)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_VenafiCloud_To_certmanager_VenafiCloud(a.(*certmanagerv1.VenafiCloud), b.(*certmanager.VenafiCloud), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VenafiCloud)(nil), (*certmanagerv1.VenafiCloud)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VenafiCloud_To_v1_VenafiCloud(a.(*certmanager.VenafiCloud), b.(*certmanagerv1.VenafiCloud), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.VenafiIssuer)(nil), (*certmanager.VenafiIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_VenafiIssuer_To_certmanager_VenafiIssuer(a.(*certmanagerv1.VenafiIssuer), b.(*certmanager.VenafiIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VenafiIssuer)(nil), (*certmanagerv1.VenafiIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VenafiIssuer_To_v1_VenafiIssuer(a.(*certmanager.VenafiIssuer), b.(*certmanagerv1.VenafiIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.VenafiTPP)(nil), (*certmanager.VenafiTPP)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_VenafiTPP_To_certmanager_VenafiTPP(a.(*certmanagerv1.VenafiTPP), b.(*certmanager.VenafiTPP), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VenafiTPP)(nil), (*certmanagerv1.VenafiTPP)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VenafiTPP_To_v1_VenafiTPP(a.(*certmanager.VenafiTPP), b.(*certmanagerv1.VenafiTPP), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanagerv1.X509Subject)(nil), (*certmanager.X509Subject)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_X509Subject_To_certmanager_X509Subject(a.(*certmanagerv1.X509Subject), b.(*certmanager.X509Subject), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.X509Subject)(nil), (*certmanagerv1.X509Subject)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_X509Subject_To_v1_X509Subject(a.(*certmanager.X509Subject), b.(*certmanagerv1.X509Subject), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_CAIssuer_To_certmanager_CAIssuer(in *certmanagerv1.CAIssuer, out *certmanager.CAIssuer, s conversion.Scope) error {
	out.SecretName = in.SecretName
	out.CRLDistributionPoints = *(*[]string)(unsafe.Pointer(&in.CRLDistributionPoints))
	out.OCSPServers = *(*[]string)(unsafe.Pointer(&in.OCSPServers))
	out.IssuingCertificateURLs = *(*[]string)(unsafe.Pointer(&in.IssuingCertificateURLs))
	return nil
}

// Convert_v1_CAIssuer_To_certmanager_CAIssuer is an autogenerated conversion function.
func Convert_v1_CAIssuer_To_certmanager_CAIssuer(in *certmanagerv1.CAIssuer, out *certmanager.CAIssuer, s conversion.Scope) error {
	return autoConvert_v1_CAIssuer_To_certmanager_CAIssuer(in, out, s)
}

func autoConvert_certmanager_CAIssuer_To_v1_CAIssuer(in *certmanager.CAIssuer, out *certmanagerv1.CAIssuer, s conversion.Scope) error {
	out.SecretName = in.SecretName
	out.CRLDistributionPoints = *(*[]string)(unsafe.Pointer(&in.CRLDistributionPoints))
	out.OCSPServers = *(*[]string)(unsafe.Pointer(&in.OCSPServers))
	out.IssuingCertificateURLs = *(*[]string)(unsafe.Pointer(&in.IssuingCertificateURLs))
	return nil
}

// Convert_certmanager_CAIssuer_To_v1_CAIssuer is an autogenerated conversion function.
func Convert_certmanager_CAIssuer_To_v1_CAIssuer(in *certmanager.CAIssuer, out *certmanagerv1.CAIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_CAIssuer_To_v1_CAIssuer(in, out, s)
}

func autoConvert_v1_Certificate_To_certmanager_Certificate(in *certmanagerv1.Certificate, out *certmanager.Certificate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_CertificateSpec_To_certmanager_CertificateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_CertificateStatus_To_certmanager_CertificateStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Certificate_To_certmanager_Certificate is an autogenerated conversion function.
func Convert_v1_Certificate_To_certmanager_Certificate(in *certmanagerv1.Certificate, out *certmanager.Certificate, s conversion.Scope) error {
	return autoConvert_v1_Certificate_To_certmanager_Certificate(in, out, s)
}

func autoConvert_certmanager_Certificate_To_v1_Certificate(in *certmanager.Certificate, out *certmanagerv1.Certificate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certmanager_CertificateSpec_To_v1_CertificateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certmanager_CertificateStatus_To_v1_CertificateStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_Certificate_To_v1_Certificate is an autogenerated conversion function.
func Convert_certmanager_Certificate_To_v1_Certificate(in *certmanager.Certificate, out *certmanagerv1.Certificate, s conversion.Scope) error {
	return autoConvert_certmanager_Certificate_To_v1_Certificate(in, out, s)
}

func autoConvert_v1_CertificateAdditionalOutputFormat_To_certmanager_CertificateAdditionalOutputFormat(in *certmanagerv1.CertificateAdditionalOutputFormat, out *certmanager.CertificateAdditionalOutputFormat, s conversion.Scope) error {
	out.Type = certmanager.CertificateOutputFormatType(in.Type)
	return nil
}

// Convert_v1_CertificateAdditionalOutputFormat_To_certmanager_CertificateAdditionalOutputFormat is an autogenerated conversion function.
func Convert_v1_CertificateAdditionalOutputFormat_To_certmanager_CertificateAdditionalOutputFormat(in *certmanagerv1.CertificateAdditionalOutputFormat, out *certmanager.CertificateAdditionalOutputFormat, s conversion.Scope) error {
	return autoConvert_v1_CertificateAdditionalOutputFormat_To_certmanager_CertificateAdditionalOutputFormat(in, out, s)
}

func autoConvert_certmanager_CertificateAdditionalOutputFormat_To_v1_CertificateAdditionalOutputFormat(in *certmanager.CertificateAdditionalOutputFormat, out *certmanagerv1.CertificateAdditionalOutputFormat, s conversion.Scope) error {
	out.Type = certmanagerv1.CertificateOutputFormatType(in.Type)
	return nil
}

// Convert_certmanager_CertificateAdditionalOutputFormat_To_v1_CertificateAdditionalOutputFormat is an autogenerated conversion function.
func Convert_certmanager_CertificateAdditionalOutputFormat_To_v1_CertificateAdditionalOutputFormat(in *certmanager.CertificateAdditionalOutputFormat, out *certmanagerv1.CertificateAdditionalOutputFormat, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateAdditionalOutputFormat_To_v1_CertificateAdditionalOutputFormat(in, out, s)
}

func autoConvert_v1_CertificateCondition_To_certmanager_CertificateCondition(in *certmanagerv1.CertificateCondition, out *certmanager.CertificateCondition, s conversion.Scope) error {
	out.Type = certmanager.CertificateConditionType(in.Type)
	out.Status = meta.ConditionStatus(in.Status)
	out.LastTransitionTime = (*metav1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_v1_CertificateCondition_To_certmanager_CertificateCondition is an autogenerated conversion function.
func Convert_v1_CertificateCondition_To_certmanager_CertificateCondition(in *certmanagerv1.CertificateCondition, out *certmanager.CertificateCondition, s conversion.Scope) error {
	return autoConvert_v1_CertificateCondition_To_certmanager_CertificateCondition(in, out, s)
}

func autoConvert_certmanager_CertificateCondition_To_v1_CertificateCondition(in *certmanager.CertificateCondition, out *certmanagerv1.CertificateCondition, s conversion.Scope) error {
	out.Type = certmanagerv1.CertificateConditionType(in.Type)
	out.Status = apismetav1.ConditionStatus(in.Status)
	out.LastTransitionTime = (*metav1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_certmanager_CertificateCondition_To_v1_CertificateCondition is an autogenerated conversion function.
func Convert_certmanager_CertificateCondition_To_v1_CertificateCondition(in *certmanager.CertificateCondition, out *certmanagerv1.CertificateCondition, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateCondition_To_v1_CertificateCondition(in, out, s)
}

func autoConvert_v1_CertificateKeystores_To_certmanager_CertificateKeystores(in *certmanagerv1.CertificateKeystores, out *certmanager.CertificateKeystores, s conversion.Scope) error {
	if in.JKS != nil {
		in, out := &in.JKS, &out.JKS
		*out = new(certmanager.JKSKeystore)
		if err := Convert_v1_JKSKeystore_To_certmanager_JKSKeystore(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.JKS = nil
	}
	if in.PKCS12 != nil {
		in, out := &in.PKCS12, &out.PKCS12
		*out = new(certmanager.PKCS12Keystore)
		if err := Convert_v1_PKCS12Keystore_To_certmanager_PKCS12Keystore(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PKCS12 = nil
	}
	return nil
}

// Convert_v1_CertificateKeystores_To_certmanager_CertificateKeystores is an autogenerated conversion function.
func Convert_v1_CertificateKeystores_To_certmanager_CertificateKeystores(in *certmanagerv1.CertificateKeystores, out *certmanager.CertificateKeystores, s conversion.Scope) error {
	return autoConvert_v1_CertificateKeystores_To_certmanager_CertificateKeystores(in, out, s)
}

func autoConvert_certmanager_CertificateKeystores_To_v1_CertificateKeystores(in *certmanager.CertificateKeystores, out *certmanagerv1.CertificateKeystores, s conversion.Scope) error {
	if in.JKS != nil {
		in, out := &in.JKS, &out.JKS
		*out = new(certmanagerv1.JKSKeystore)
		if err := Convert_certmanager_JKSKeystore_To_v1_JKSKeystore(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.JKS = nil
	}
	if in.PKCS12 != nil {
		in, out := &in.PKCS12, &out.PKCS12
		*out = new(certmanagerv1.PKCS12Keystore)
		if err := Convert_certmanager_PKCS12Keystore_To_v1_PKCS12Keystore(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PKCS12 = nil
	}
	return nil
}

// Convert_certmanager_CertificateKeystores_To_v1_CertificateKeystores is an autogenerated conversion function.
func Convert_certmanager_CertificateKeystores_To_v1_CertificateKeystores(in *certmanager.CertificateKeystores, out *certmanagerv1.CertificateKeystores, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateKeystores_To_v1_CertificateKeystores(in, out, s)
}

func autoConvert_v1_CertificateList_To_certmanager_CertificateList(in *certmanagerv1.CertificateList, out *certmanager.CertificateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certmanager.Certificate, len(*in))
		for i := range *in {
			if err := Convert_v1_Certificate_To_certmanager_Certificate(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_CertificateList_To_certmanager_CertificateList is an autogenerated conversion function.
func Convert_v1_CertificateList_To_certmanager_CertificateList(in *certmanagerv1.CertificateList, out *certmanager.CertificateList, s conversion.Scope) error {
	return autoConvert_v1_CertificateList_To_certmanager_CertificateList(in, out, s)
}

func autoConvert_certmanager_CertificateList_To_v1_CertificateList(in *certmanager.CertificateList, out *certmanagerv1.CertificateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certmanagerv1.Certificate, len(*in))
		for i := range *in {
			if err := Convert_certmanager_Certificate_To_v1_Certificate(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_certmanager_CertificateList_To_v1_CertificateList is an autogenerated conversion function.
func Convert_certmanager_CertificateList_To_v1_CertificateList(in *certmanager.CertificateList, out *certmanagerv1.CertificateList, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateList_To_v1_CertificateList(in, out, s)
}

func autoConvert_v1_CertificatePrivateKey_To_certmanager_CertificatePrivateKey(in *certmanagerv1.CertificatePrivateKey, out *certmanager.CertificatePrivateKey, s conversion.Scope) error {
	out.RotationPolicy = certmanager.PrivateKeyRotationPolicy(in.RotationPolicy)
	out.Encoding = certmanager.PrivateKeyEncoding(in.Encoding)
	out.Algorithm = certmanager.PrivateKeyAlgorithm(in.Algorithm)
	out.Size = in.Size
	return nil
}

// Convert_v1_CertificatePrivateKey_To_certmanager_CertificatePrivateKey is an autogenerated conversion function.
func Convert_v1_CertificatePrivateKey_To_certmanager_CertificatePrivateKey(in *certmanagerv1.CertificatePrivateKey, out *certmanager.CertificatePrivateKey, s conversion.Scope) error {
	return autoConvert_v1_CertificatePrivateKey_To_certmanager_CertificatePrivateKey(in, out, s)
}

func autoConvert_certmanager_CertificatePrivateKey_To_v1_CertificatePrivateKey(in *certmanager.CertificatePrivateKey, out *certmanagerv1.CertificatePrivateKey, s conversion.Scope) error {
	out.RotationPolicy = certmanagerv1.PrivateKeyRotationPolicy(in.RotationPolicy)
	out.Encoding = certmanagerv1.PrivateKeyEncoding(in.Encoding)
	out.Algorithm = certmanagerv1.PrivateKeyAlgorithm(in.Algorithm)
	out.Size = in.Size
	return nil
}

// Convert_certmanager_CertificatePrivateKey_To_v1_CertificatePrivateKey is an autogenerated conversion function.
func Convert_certmanager_CertificatePrivateKey_To_v1_CertificatePrivateKey(in *certmanager.CertificatePrivateKey, out *certmanagerv1.CertificatePrivateKey, s conversion.Scope) error {
	return autoConvert_certmanager_CertificatePrivateKey_To_v1_CertificatePrivateKey(in, out, s)
}

func autoConvert_v1_CertificateRequest_To_certmanager_CertificateRequest(in *certmanagerv1.CertificateRequest, out *certmanager.CertificateRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_CertificateRequestSpec_To_certmanager_CertificateRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_CertificateRequest_To_certmanager_CertificateRequest is an autogenerated conversion function.
func Convert_v1_CertificateRequest_To_certmanager_CertificateRequest(in *certmanagerv1.CertificateRequest, out *certmanager.CertificateRequest, s conversion.Scope) error {
	return autoConvert_v1_CertificateRequest_To_certmanager_CertificateRequest(in, out, s)
}

func autoConvert_certmanager_CertificateRequest_To_v1_CertificateRequest(in *certmanager.CertificateRequest, out *certmanagerv1.CertificateRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certmanager_CertificateRequestSpec_To_v1_CertificateRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certmanager_CertificateRequestStatus_To_v1_CertificateRequestStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_CertificateRequest_To_v1_CertificateRequest is an autogenerated conversion function.
func Convert_certmanager_CertificateRequest_To_v1_CertificateRequest(in *certmanager.CertificateRequest, out *certmanagerv1.CertificateRequest, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateRequest_To_v1_CertificateRequest(in, out, s)
}

func autoConvert_v1_CertificateRequestCondition_To_certmanager_CertificateRequestCondition(in *certmanagerv1.CertificateRequestCondition, out *certmanager.CertificateRequestCondition, s conversion.Scope) error {
	out.Type = certmanager.CertificateRequestConditionType(in.Type)
	out.Status = meta.ConditionStatus(in.Status)
	out.LastTransitionTime = (*metav1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_CertificateRequestCondition_To_certmanager_CertificateRequestCondition is an autogenerated conversion function.
func Convert_v1_CertificateRequestCondition_To_certmanager_CertificateRequestCondition(in *certmanagerv1.CertificateRequestCondition, out *certmanager.CertificateRequestCondition, s conversion.Scope) error {
	return autoConvert_v1_CertificateRequestCondition_To_certmanager_CertificateRequestCondition(in, out, s)
}

func autoConvert_certmanager_CertificateRequestCondition_To_v1_CertificateRequestCondition(in *certmanager.CertificateRequestCondition, out *certmanagerv1.CertificateRequestCondition, s conversion.Scope) error {
	out.Type = certmanagerv1.CertificateRequestConditionType(in.Type)
	out.Status = apismetav1.ConditionStatus(in.Status)
	out.LastTransitionTime = (*metav1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_certmanager_CertificateRequestCondition_To_v1_CertificateRequestCondition is an autogenerated conversion function.
func Convert_certmanager_CertificateRequestCondition_To_v1_CertificateRequestCondition(in *certmanager.CertificateRequestCondition, out *certmanagerv1.CertificateRequestCondition, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateRequestCondition_To_v1_CertificateRequestCondition(in, out, s)
}

func autoConvert_v1_CertificateRequestList_To_certmanager_CertificateRequestList(in *certmanagerv1.CertificateRequestList, out *certmanager.CertificateRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certmanager.CertificateRequest, len(*in))
		for i := range *in {
			if err := Convert_v1_CertificateRequest_To_certmanager_CertificateRequest(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_CertificateRequestList_To_certmanager_CertificateRequestList is an autogenerated conversion function.
func Convert_v1_CertificateRequestList_To_certmanager_CertificateRequestList(in *certmanagerv1.CertificateRequestList, out *certmanager.CertificateRequestList, s conversion.Scope) error {
	return autoConvert_v1_CertificateRequestList_To_certmanager_CertificateRequestList(in, out, s)
}

func autoConvert_certmanager_CertificateRequestList_To_v1_CertificateRequestList(in *certmanager.CertificateRequestList, out *certmanagerv1.CertificateRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certmanagerv1.CertificateRequest, len(*in))
		for i := range *in {
			if err := Convert_certmanager_CertificateRequest_To_v1_CertificateRequest(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_certmanager_CertificateRequestList_To_v1_CertificateRequestList is an autogenerated conversion function.
func Convert_certmanager_CertificateRequestList_To_v1_CertificateRequestList(in *certmanager.CertificateRequestList, out *certmanagerv1.CertificateRequestList, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateRequestList_To_v1_CertificateRequestList(in, out, s)
}

func autoConvert_v1_CertificateRequestSpec_To_certmanager_CertificateRequestSpec(in *certmanagerv1.CertificateRequestSpec, out *certmanager.CertificateRequestSpec, s conversion.Scope) error {
	out.Duration = (*metav1.Duration)(unsafe.Pointer(in.Duration))
	if err := internalapismetav1.Convert_v1_ObjectReference_To_meta_ObjectReference(&in.IssuerRef, &out.IssuerRef, s); err != nil {
		return err
	}
	out.Request = *(*[]byte)(unsafe.Pointer(&in.Request))
	out.IsCA = in.IsCA
	out.Usages = *(*[]certmanager.KeyUsage)(unsafe.Pointer(&in.Usages))
	out.Username = in.Username
	out.UID = in.UID
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Extra = *(*map[string][]string)(unsafe.Pointer(&in.Extra))
	return nil
}

// Convert_v1_CertificateRequestSpec_To_certmanager_CertificateRequestSpec is an autogenerated conversion function.
func Convert_v1_CertificateRequestSpec_To_certmanager_CertificateRequestSpec(in *certmanagerv1.CertificateRequestSpec, out *certmanager.CertificateRequestSpec, s conversion.Scope) error {
	return autoConvert_v1_CertificateRequestSpec_To_certmanager_CertificateRequestSpec(in, out, s)
}

func autoConvert_certmanager_CertificateRequestSpec_To_v1_CertificateRequestSpec(in *certmanager.CertificateRequestSpec, out *certmanagerv1.CertificateRequestSpec, s conversion.Scope) error {
	out.Duration = (*metav1.Duration)(unsafe.Pointer(in.Duration))
	if err := internalapismetav1.Convert_meta_ObjectReference_To_v1_ObjectReference(&in.IssuerRef, &out.IssuerRef, s); err != nil {
		return err
	}
	out.Request = *(*[]byte)(unsafe.Pointer(&in.Request))
	out.IsCA = in.IsCA
	out.Usages = *(*[]certmanagerv1.KeyUsage)(unsafe.Pointer(&in.Usages))
	out.Username = in.Username
	out.UID = in.UID
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Extra = *(*map[string][]string)(unsafe.Pointer(&in.Extra))
	return nil
}

// Convert_certmanager_CertificateRequestSpec_To_v1_CertificateRequestSpec is an autogenerated conversion function.
func Convert_certmanager_CertificateRequestSpec_To_v1_CertificateRequestSpec(in *certmanager.CertificateRequestSpec, out *certmanagerv1.CertificateRequestSpec, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateRequestSpec_To_v1_CertificateRequestSpec(in, out, s)
}

func autoConvert_v1_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(in *certmanagerv1.CertificateRequestStatus, out *certmanager.CertificateRequestStatus, s conversion.Scope) error {
	out.Conditions = *(*[]certmanager.CertificateRequestCondition)(unsafe.Pointer(&in.Conditions))
	out.Certificate = *(*[]byte)(unsafe.Pointer(&in.Certificate))
	out.CA = *(*[]byte)(unsafe.Pointer(&in.CA))
	out.FailureTime = (*metav1.Time)(unsafe.Pointer(in.FailureTime))
	return nil
}

// Convert_v1_CertificateRequestStatus_To_certmanager_CertificateRequestStatus is an autogenerated conversion function.
func Convert_v1_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(in *certmanagerv1.CertificateRequestStatus, out *certmanager.CertificateRequestStatus, s conversion.Scope) error {
	return autoConvert_v1_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(in, out, s)
}

func autoConvert_certmanager_CertificateRequestStatus_To_v1_CertificateRequestStatus(in *certmanager.CertificateRequestStatus, out *certmanagerv1.CertificateRequestStatus, s conversion.Scope) error {
	out.Conditions = *(*[]certmanagerv1.CertificateRequestCondition)(unsafe.Pointer(&in.Conditions))
	out.Certificate = *(*[]byte)(unsafe.Pointer(&in.Certificate))
	out.CA = *(*[]byte)(unsafe.Pointer(&in.CA))
	out.FailureTime = (*metav1.Time)(unsafe.Pointer(in.FailureTime))
	return nil
}

// Convert_certmanager_CertificateRequestStatus_To_v1_CertificateRequestStatus is an autogenerated conversion function.
func Convert_certmanager_CertificateRequestStatus_To_v1_CertificateRequestStatus(in *certmanager.CertificateRequestStatus, out *certmanagerv1.CertificateRequestStatus, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateRequestStatus_To_v1_CertificateRequestStatus(in, out, s)
}

func autoConvert_v1_CertificateSecretTemplate_To_certmanager_CertificateSecretTemplate(in *certmanagerv1.CertificateSecretTemplate, out *certmanager.CertificateSecretTemplate, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_v1_CertificateSecretTemplate_To_certmanager_CertificateSecretTemplate is an autogenerated conversion function.
func Convert_v1_CertificateSecretTemplate_To_certmanager_CertificateSecretTemplate(in *certmanagerv1.CertificateSecretTemplate, out *certmanager.CertificateSecretTemplate, s conversion.Scope) error {
	return autoConvert_v1_CertificateSecretTemplate_To_certmanager_CertificateSecretTemplate(in, out, s)
}

func autoConvert_certmanager_CertificateSecretTemplate_To_v1_CertificateSecretTemplate(in *certmanager.CertificateSecretTemplate, out *certmanagerv1.CertificateSecretTemplate, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_certmanager_CertificateSecretTemplate_To_v1_CertificateSecretTemplate is an autogenerated conversion function.
func Convert_certmanager_CertificateSecretTemplate_To_v1_CertificateSecretTemplate(in *certmanager.CertificateSecretTemplate, out *certmanagerv1.CertificateSecretTemplate, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateSecretTemplate_To_v1_CertificateSecretTemplate(in, out, s)
}

func autoConvert_v1_CertificateSpec_To_certmanager_CertificateSpec(in *certmanagerv1.CertificateSpec, out *certmanager.CertificateSpec, s conversion.Scope) error {
	out.Subject = (*certmanager.X509Subject)(unsafe.Pointer(in.Subject))
	out.LiteralSubject = in.LiteralSubject
	out.CommonName = in.CommonName
	out.Duration = (*metav1.Duration)(unsafe.Pointer(in.Duration))
	out.RenewBefore = (*metav1.Duration)(unsafe.Pointer(in.RenewBefore))
	out.RenewBeforePercentage = (*int32)(unsafe.Pointer(in.RenewBeforePercentage))
	out.DNSNames = *(*[]string)(unsafe.Pointer(&in.DNSNames))
	out.IPAddresses = *(*[]string)(unsafe.Pointer(&in.IPAddresses))
	out.URIs = *(*[]string)(unsafe.Pointer(&in.URIs))
	out.OtherNames = *(*[]certmanager.OtherName)(unsafe.Pointer(&in.OtherNames))
	out.EmailAddresses = *(*[]string)(unsafe.Pointer(&in.EmailAddresses))
	out.SecretName = in.SecretName
	out.SecretTemplate = (*certmanager.CertificateSecretTemplate)(unsafe.Pointer(in.SecretTemplate))
	if in.Keystores != nil {
		in, out := &in.Keystores, &out.Keystores
		*out = new(certmanager.CertificateKeystores)
		if err := Convert_v1_CertificateKeystores_To_certmanager_CertificateKeystores(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Keystores = nil
	}
	if err := internalapismetav1.Convert_v1_ObjectReference_To_meta_ObjectReference(&in.IssuerRef, &out.IssuerRef, s); err != nil {
		return err
	}
	out.IsCA = in.IsCA
	out.Usages = *(*[]certmanager.KeyUsage)(unsafe.Pointer(&in.Usages))
	out.PrivateKey = (*certmanager.CertificatePrivateKey)(unsafe.Pointer(in.PrivateKey))
	out.SignatureAlgorithm = certmanager.SignatureAlgorithm(in.SignatureAlgorithm)
	out.EncodeUsagesInRequest = (*bool)(unsafe.Pointer(in.EncodeUsagesInRequest))
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.AdditionalOutputFormats = *(*[]certmanager.CertificateAdditionalOutputFormat)(unsafe.Pointer(&in.AdditionalOutputFormats))
	out.NameConstraints = (*certmanager.NameConstraints)(unsafe.Pointer(in.NameConstraints))
	return nil
}

// Convert_v1_CertificateSpec_To_certmanager_CertificateSpec is an autogenerated conversion function.
func Convert_v1_CertificateSpec_To_certmanager_CertificateSpec(in *certmanagerv1.CertificateSpec, out *certmanager.CertificateSpec, s conversion.Scope) error {
	return autoConvert_v1_CertificateSpec_To_certmanager_CertificateSpec(in, out, s)
}

func autoConvert_certmanager_CertificateSpec_To_v1_CertificateSpec(in *certmanager.CertificateSpec, out *certmanagerv1.CertificateSpec, s conversion.Scope) error {
	out.Subject = (*certmanagerv1.X509Subject)(unsafe.Pointer(in.Subject))
	out.LiteralSubject = in.LiteralSubject
	out.CommonName = in.CommonName
	out.Duration = (*metav1.Duration)(unsafe.Pointer(in.Duration))
	out.RenewBefore = (*metav1.Duration)(unsafe.Pointer(in.RenewBefore))
	out.RenewBeforePercentage = (*int32)(unsafe.Pointer(in.RenewBeforePercentage))
	out.DNSNames = *(*[]string)(unsafe.Pointer(&in.DNSNames))
	out.IPAddresses = *(*[]string)(unsafe.Pointer(&in.IPAddresses))
	out.URIs = *(*[]string)(unsafe.Pointer(&in.URIs))
	out.EmailAddresses = *(*[]string)(unsafe.Pointer(&in.EmailAddresses))
	out.OtherNames = *(*[]certmanagerv1.OtherName)(unsafe.Pointer(&in.OtherNames))
	out.SecretName = in.SecretName
	out.SecretTemplate = (*certmanagerv1.CertificateSecretTemplate)(unsafe.Pointer(in.SecretTemplate))
	if in.Keystores != nil {
		in, out := &in.Keystores, &out.Keystores
		*out = new(certmanagerv1.CertificateKeystores)
		if err := Convert_certmanager_CertificateKeystores_To_v1_CertificateKeystores(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Keystores = nil
	}
	if err := internalapismetav1.Convert_meta_ObjectReference_To_v1_ObjectReference(&in.IssuerRef, &out.IssuerRef, s); err != nil {
		return err
	}
	out.IsCA = in.IsCA
	out.Usages = *(*[]certmanagerv1.KeyUsage)(unsafe.Pointer(&in.Usages))
	out.PrivateKey = (*certmanagerv1.CertificatePrivateKey)(unsafe.Pointer(in.PrivateKey))
	out.SignatureAlgorithm = certmanagerv1.SignatureAlgorithm(in.SignatureAlgorithm)
	out.EncodeUsagesInRequest = (*bool)(unsafe.Pointer(in.EncodeUsagesInRequest))
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.AdditionalOutputFormats = *(*[]certmanagerv1.CertificateAdditionalOutputFormat)(unsafe.Pointer(&in.AdditionalOutputFormats))
	out.NameConstraints = (*certmanagerv1.NameConstraints)(unsafe.Pointer(in.NameConstraints))
	return nil
}

// Convert_certmanager_CertificateSpec_To_v1_CertificateSpec is an autogenerated conversion function.
func Convert_certmanager_CertificateSpec_To_v1_CertificateSpec(in *certmanager.CertificateSpec, out *certmanagerv1.CertificateSpec, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateSpec_To_v1_CertificateSpec(in, out, s)
}

func autoConvert_v1_CertificateStatus_To_certmanager_CertificateStatus(in *certmanagerv1.CertificateStatus, out *certmanager.CertificateStatus, s conversion.Scope) error {
	out.Conditions = *(*[]certmanager.CertificateCondition)(unsafe.Pointer(&in.Conditions))
	out.LastFailureTime = (*metav1.Time)(unsafe.Pointer(in.LastFailureTime))
	out.NotBefore = (*metav1.Time)(unsafe.Pointer(in.NotBefore))
	out.NotAfter = (*metav1.Time)(unsafe.Pointer(in.NotAfter))
	out.RenewalTime = (*metav1.Time)(unsafe.Pointer(in.RenewalTime))
	out.Revision = (*int)(unsafe.Pointer(in.Revision))
	out.NextPrivateKeySecretName = (*string)(unsafe.Pointer(in.NextPrivateKeySecretName))
	out.FailedIssuanceAttempts = (*int)(unsafe.Pointer(in.FailedIssuanceAttempts))
	return nil
}

// Convert_v1_CertificateStatus_To_certmanager_CertificateStatus is an autogenerated conversion function.
func Convert_v1_CertificateStatus_To_certmanager_CertificateStatus(in *certmanagerv1.CertificateStatus, out *certmanager.CertificateStatus, s conversion.Scope) error {
	return autoConvert_v1_CertificateStatus_To_certmanager_CertificateStatus(in, out, s)
}

func autoConvert_certmanager_CertificateStatus_To_v1_CertificateStatus(in *certmanager.CertificateStatus, out *certmanagerv1.CertificateStatus, s conversion.Scope) error {
	out.Conditions = *(*[]certmanagerv1.CertificateCondition)(unsafe.Pointer(&in.Conditions))
	out.LastFailureTime = (*metav1.Time)(unsafe.Pointer(in.LastFailureTime))
	out.NotBefore = (*metav1.Time)(unsafe.Pointer(in.NotBefore))
	out.NotAfter = (*metav1.Time)(unsafe.Pointer(in.NotAfter))
	out.RenewalTime = (*metav1.Time)(unsafe.Pointer(in.RenewalTime))
	out.Revision = (*int)(unsafe.Pointer(in.Revision))
	out.NextPrivateKeySecretName = (*string)(unsafe.Pointer(in.NextPrivateKeySecretName))
	out.FailedIssuanceAttempts = (*int)(unsafe.Pointer(in.FailedIssuanceAttempts))
	return nil
}

// Convert_certmanager_CertificateStatus_To_v1_CertificateStatus is an autogenerated conversion function.
func Convert_certmanager_CertificateStatus_To_v1_CertificateStatus(in *certmanager.CertificateStatus, out *certmanagerv1.CertificateStatus, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateStatus_To_v1_CertificateStatus(in, out, s)
}

func autoConvert_v1_ClusterIssuer_To_certmanager_ClusterIssuer(in *certmanagerv1.ClusterIssuer, out *certmanager.ClusterIssuer, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_IssuerSpec_To_certmanager_IssuerSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_IssuerStatus_To_certmanager_IssuerStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ClusterIssuer_To_certmanager_ClusterIssuer is an autogenerated conversion function.
func Convert_v1_ClusterIssuer_To_certmanager_ClusterIssuer(in *certmanagerv1.ClusterIssuer, out *certmanager.ClusterIssuer, s conversion.Scope) error {
	return autoConvert_v1_ClusterIssuer_To_certmanager_ClusterIssuer(in, out, s)
}

func autoConvert_certmanager_ClusterIssuer_To_v1_ClusterIssuer(in *certmanager.ClusterIssuer, out *certmanagerv1.ClusterIssuer, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certmanager_IssuerSpec_To_v1_IssuerSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certmanager_IssuerStatus_To_v1_IssuerStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_ClusterIssuer_To_v1_ClusterIssuer is an autogenerated conversion function.
func Convert_certmanager_ClusterIssuer_To_v1_ClusterIssuer(in *certmanager.ClusterIssuer, out *certmanagerv1.ClusterIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_ClusterIssuer_To_v1_ClusterIssuer(in, out, s)
}

func autoConvert_v1_ClusterIssuerList_To_certmanager_ClusterIssuerList(in *certmanagerv1.ClusterIssuerList, out *certmanager.ClusterIssuerList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certmanager.ClusterIssuer, len(*in))
		for i := range *in {
			if err := Convert_v1_ClusterIssuer_To_certmanager_ClusterIssuer(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ClusterIssuerList_To_certmanager_ClusterIssuerList is an autogenerated conversion function.
func Convert_v1_ClusterIssuerList_To_certmanager_ClusterIssuerList(in *certmanagerv1.ClusterIssuerList, out *certmanager.ClusterIssuerList, s conversion.Scope) error {
	return autoConvert_v1_ClusterIssuerList_To_certmanager_ClusterIssuerList(in, out, s)
}

func autoConvert_certmanager_ClusterIssuerList_To_v1_ClusterIssuerList(in *certmanager.ClusterIssuerList, out *certmanagerv1.ClusterIssuerList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certmanagerv1.ClusterIssuer, len(*in))
		for i := range *in {
			if err := Convert_certmanager_ClusterIssuer_To_v1_ClusterIssuer(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_certmanager_ClusterIssuerList_To_v1_ClusterIssuerList is an autogenerated conversion function.
func Convert_certmanager_ClusterIssuerList_To_v1_ClusterIssuerList(in *certmanager.ClusterIssuerList, out *certmanagerv1.ClusterIssuerList, s conversion.Scope) error {
	return autoConvert_certmanager_ClusterIssuerList_To_v1_ClusterIssuerList(in, out, s)
}

func autoConvert_v1_Issuer_To_certmanager_Issuer(in *certmanagerv1.Issuer, out *certmanager.Issuer, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_IssuerSpec_To_certmanager_IssuerSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_IssuerStatus_To_certmanager_IssuerStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Issuer_To_certmanager_Issuer is an autogenerated conversion function.
func Convert_v1_Issuer_To_certmanager_Issuer(in *certmanagerv1.Issuer, out *certmanager.Issuer, s conversion.Scope) error {
	return autoConvert_v1_Issuer_To_certmanager_Issuer(in, out, s)
}

func autoConvert_certmanager_Issuer_To_v1_Issuer(in *certmanager.Issuer, out *certmanagerv1.Issuer, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certmanager_IssuerSpec_To_v1_IssuerSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certmanager_IssuerStatus_To_v1_IssuerStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_Issuer_To_v1_Issuer is an autogenerated conversion function.
func Convert_certmanager_Issuer_To_v1_Issuer(in *certmanager.Issuer, out *certmanagerv1.Issuer, s conversion.Scope) error {
	return autoConvert_certmanager_Issuer_To_v1_Issuer(in, out, s)
}

func autoConvert_v1_IssuerCondition_To_certmanager_IssuerCondition(in *certmanagerv1.IssuerCondition, out *certmanager.IssuerCondition, s conversion.Scope) error {
	out.Type = certmanager.IssuerConditionType(in.Type)
	out.Status = meta.ConditionStatus(in.Status)
	out.LastTransitionTime = (*metav1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_v1_IssuerCondition_To_certmanager_IssuerCondition is an autogenerated conversion function.
func Convert_v1_IssuerCondition_To_certmanager_IssuerCondition(in *certmanagerv1.IssuerCondition, out *certmanager.IssuerCondition, s conversion.Scope) error {
	return autoConvert_v1_IssuerCondition_To_certmanager_IssuerCondition(in, out, s)
}

func autoConvert_certmanager_IssuerCondition_To_v1_IssuerCondition(in *certmanager.IssuerCondition, out *certmanagerv1.IssuerCondition, s conversion.Scope) error {
	out.Type = certmanagerv1.IssuerConditionType(in.Type)
	out.Status = apismetav1.ConditionStatus(in.Status)
	out.LastTransitionTime = (*metav1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_certmanager_IssuerCondition_To_v1_IssuerCondition is an autogenerated conversion function.
func Convert_certmanager_IssuerCondition_To_v1_IssuerCondition(in *certmanager.IssuerCondition, out *certmanagerv1.IssuerCondition, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerCondition_To_v1_IssuerCondition(in, out, s)
}

func autoConvert_v1_IssuerConfig_To_certmanager_IssuerConfig(in *certmanagerv1.IssuerConfig, out *certmanager.IssuerConfig, s conversion.Scope) error {
	if in.ACME != nil {
		in, out := &in.ACME, &out.ACME
		*out = new(acme.ACMEIssuer)
		if err := acmev1.Convert_v1_ACMEIssuer_To_acme_ACMEIssuer(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ACME = nil
	}
	out.CA = (*certmanager.CAIssuer)(unsafe.Pointer(in.CA))
	if in.Vault != nil {
		in, out := &in.Vault, &out.Vault
		*out = new(certmanager.VaultIssuer)
		if err := Convert_v1_VaultIssuer_To_certmanager_VaultIssuer(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Vault = nil
	}
	out.SelfSigned = (*certmanager.SelfSignedIssuer)(unsafe.Pointer(in.SelfSigned))
	if in.Venafi != nil {
		in, out := &in.Venafi, &out.Venafi
		*out = new(certmanager.VenafiIssuer)
		if err := Convert_v1_VenafiIssuer_To_certmanager_VenafiIssuer(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Venafi = nil
	}
	return nil
}

// Convert_v1_IssuerConfig_To_certmanager_IssuerConfig is an autogenerated conversion function.
func Convert_v1_IssuerConfig_To_certmanager_IssuerConfig(in *certmanagerv1.IssuerConfig, out *certmanager.IssuerConfig, s conversion.Scope) error {
	return autoConvert_v1_IssuerConfig_To_certmanager_IssuerConfig(in, out, s)
}

func autoConvert_certmanager_IssuerConfig_To_v1_IssuerConfig(in *certmanager.IssuerConfig, out *certmanagerv1.IssuerConfig, s conversion.Scope) error {
	if in.ACME != nil {
		in, out := &in.ACME, &out.ACME
		*out = new(apisacmev1.ACMEIssuer)
		if err := acmev1.Convert_acme_ACMEIssuer_To_v1_ACMEIssuer(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ACME = nil
	}
	out.CA = (*certmanagerv1.CAIssuer)(unsafe.Pointer(in.CA))
	if in.Vault != nil {
		in, out := &in.Vault, &out.Vault
		*out = new(certmanagerv1.VaultIssuer)
		if err := Convert_certmanager_VaultIssuer_To_v1_VaultIssuer(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Vault = nil
	}
	out.SelfSigned = (*certmanagerv1.SelfSignedIssuer)(unsafe.Pointer(in.SelfSigned))
	if in.Venafi != nil {
		in, out := &in.Venafi, &out.Venafi
		*out = new(certmanagerv1.VenafiIssuer)
		if err := Convert_certmanager_VenafiIssuer_To_v1_VenafiIssuer(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Venafi = nil
	}
	return nil
}

// Convert_certmanager_IssuerConfig_To_v1_IssuerConfig is an autogenerated conversion function.
func Convert_certmanager_IssuerConfig_To_v1_IssuerConfig(in *certmanager.IssuerConfig, out *certmanagerv1.IssuerConfig, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerConfig_To_v1_IssuerConfig(in, out, s)
}

func autoConvert_v1_IssuerList_To_certmanager_IssuerList(in *certmanagerv1.IssuerList, out *certmanager.IssuerList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certmanager.Issuer, len(*in))
		for i := range *in {
			if err := Convert_v1_Issuer_To_certmanager_Issuer(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_IssuerList_To_certmanager_IssuerList is an autogenerated conversion function.
func Convert_v1_IssuerList_To_certmanager_IssuerList(in *certmanagerv1.IssuerList, out *certmanager.IssuerList, s conversion.Scope) error {
	return autoConvert_v1_IssuerList_To_certmanager_IssuerList(in, out, s)
}

func autoConvert_certmanager_IssuerList_To_v1_IssuerList(in *certmanager.IssuerList, out *certmanagerv1.IssuerList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certmanagerv1.Issuer, len(*in))
		for i := range *in {
			if err := Convert_certmanager_Issuer_To_v1_Issuer(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_certmanager_IssuerList_To_v1_IssuerList is an autogenerated conversion function.
func Convert_certmanager_IssuerList_To_v1_IssuerList(in *certmanager.IssuerList, out *certmanagerv1.IssuerList, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerList_To_v1_IssuerList(in, out, s)
}

func autoConvert_v1_IssuerSpec_To_certmanager_IssuerSpec(in *certmanagerv1.IssuerSpec, out *certmanager.IssuerSpec, s conversion.Scope) error {
	if err := Convert_v1_IssuerConfig_To_certmanager_IssuerConfig(&in.IssuerConfig, &out.IssuerConfig, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_IssuerSpec_To_certmanager_IssuerSpec is an autogenerated conversion function.
func Convert_v1_IssuerSpec_To_certmanager_IssuerSpec(in *certmanagerv1.IssuerSpec, out *certmanager.IssuerSpec, s conversion.Scope) error {
	return autoConvert_v1_IssuerSpec_To_certmanager_IssuerSpec(in, out, s)
}

func autoConvert_certmanager_IssuerSpec_To_v1_IssuerSpec(in *certmanager.IssuerSpec, out *certmanagerv1.IssuerSpec, s conversion.Scope) error {
	if err := Convert_certmanager_IssuerConfig_To_v1_IssuerConfig(&in.IssuerConfig, &out.IssuerConfig, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_IssuerSpec_To_v1_IssuerSpec is an autogenerated conversion function.
func Convert_certmanager_IssuerSpec_To_v1_IssuerSpec(in *certmanager.IssuerSpec, out *certmanagerv1.IssuerSpec, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerSpec_To_v1_IssuerSpec(in, out, s)
}

func autoConvert_v1_IssuerStatus_To_certmanager_IssuerStatus(in *certmanagerv1.IssuerStatus, out *certmanager.IssuerStatus, s conversion.Scope) error {
	out.Conditions = *(*[]certmanager.IssuerCondition)(unsafe.Pointer(&in.Conditions))
	out.ACME = (*acme.ACMEIssuerStatus)(unsafe.Pointer(in.ACME))
	return nil
}

// Convert_v1_IssuerStatus_To_certmanager_IssuerStatus is an autogenerated conversion function.
func Convert_v1_IssuerStatus_To_certmanager_IssuerStatus(in *certmanagerv1.IssuerStatus, out *certmanager.IssuerStatus, s conversion.Scope) error {
	return autoConvert_v1_IssuerStatus_To_certmanager_IssuerStatus(in, out, s)
}

func autoConvert_certmanager_IssuerStatus_To_v1_IssuerStatus(in *certmanager.IssuerStatus, out *certmanagerv1.IssuerStatus, s conversion.Scope) error {
	out.Conditions = *(*[]certmanagerv1.IssuerCondition)(unsafe.Pointer(&in.Conditions))
	out.ACME = (*apisacmev1.ACMEIssuerStatus)(unsafe.Pointer(in.ACME))
	return nil
}

// Convert_certmanager_IssuerStatus_To_v1_IssuerStatus is an autogenerated conversion function.
func Convert_certmanager_IssuerStatus_To_v1_IssuerStatus(in *certmanager.IssuerStatus, out *certmanagerv1.IssuerStatus, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerStatus_To_v1_IssuerStatus(in, out, s)
}

func autoConvert_v1_JKSKeystore_To_certmanager_JKSKeystore(in *certmanagerv1.JKSKeystore, out *certmanager.JKSKeystore, s conversion.Scope) error {
	out.Create = in.Create
	out.Alias = (*string)(unsafe.Pointer(in.Alias))
	if err := internalapismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.PasswordSecretRef, &out.PasswordSecretRef, s); err != nil {
		return err
	}
	out.Password = (*string)(unsafe.Pointer(in.Password))
	return nil
}

// Convert_v1_JKSKeystore_To_certmanager_JKSKeystore is an autogenerated conversion function.
func Convert_v1_JKSKeystore_To_certmanager_JKSKeystore(in *certmanagerv1.JKSKeystore, out *certmanager.JKSKeystore, s conversion.Scope) error {
	return autoConvert_v1_JKSKeystore_To_certmanager_JKSKeystore(in, out, s)
}

func autoConvert_certmanager_JKSKeystore_To_v1_JKSKeystore(in *certmanager.JKSKeystore, out *certmanagerv1.JKSKeystore, s conversion.Scope) error {
	out.Create = in.Create
	if err := internalapismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.PasswordSecretRef, &out.PasswordSecretRef, s); err != nil {
		return err
	}
	out.Password = (*string)(unsafe.Pointer(in.Password))
	out.Alias = (*string)(unsafe.Pointer(in.Alias))
	return nil
}

// Convert_certmanager_JKSKeystore_To_v1_JKSKeystore is an autogenerated conversion function.
func Convert_certmanager_JKSKeystore_To_v1_JKSKeystore(in *certmanager.JKSKeystore, out *certmanagerv1.JKSKeystore, s conversion.Scope) error {
	return autoConvert_certmanager_JKSKeystore_To_v1_JKSKeystore(in, out, s)
}

func autoConvert_v1_NameConstraintItem_To_certmanager_NameConstraintItem(in *certmanagerv1.NameConstraintItem, out *certmanager.NameConstraintItem, s conversion.Scope) error {
	out.DNSDomains = *(*[]string)(unsafe.Pointer(&in.DNSDomains))
	out.IPRanges = *(*[]string)(unsafe.Pointer(&in.IPRanges))
	out.EmailAddresses = *(*[]string)(unsafe.Pointer(&in.EmailAddresses))
	out.URIDomains = *(*[]string)(unsafe.Pointer(&in.URIDomains))
	return nil
}

// Convert_v1_NameConstraintItem_To_certmanager_NameConstraintItem is an autogenerated conversion function.
func Convert_v1_NameConstraintItem_To_certmanager_NameConstraintItem(in *certmanagerv1.NameConstraintItem, out *certmanager.NameConstraintItem, s conversion.Scope) error {
	return autoConvert_v1_NameConstraintItem_To_certmanager_NameConstraintItem(in, out, s)
}

func autoConvert_certmanager_NameConstraintItem_To_v1_NameConstraintItem(in *certmanager.NameConstraintItem, out *certmanagerv1.NameConstraintItem, s conversion.Scope) error {
	out.DNSDomains = *(*[]string)(unsafe.Pointer(&in.DNSDomains))
	out.IPRanges = *(*[]string)(unsafe.Pointer(&in.IPRanges))
	out.EmailAddresses = *(*[]string)(unsafe.Pointer(&in.EmailAddresses))
	out.URIDomains = *(*[]string)(unsafe.Pointer(&in.URIDomains))
	return nil
}

// Convert_certmanager_NameConstraintItem_To_v1_NameConstraintItem is an autogenerated conversion function.
func Convert_certmanager_NameConstraintItem_To_v1_NameConstraintItem(in *certmanager.NameConstraintItem, out *certmanagerv1.NameConstraintItem, s conversion.Scope) error {
	return autoConvert_certmanager_NameConstraintItem_To_v1_NameConstraintItem(in, out, s)
}

func autoConvert_v1_NameConstraints_To_certmanager_NameConstraints(in *certmanagerv1.NameConstraints, out *certmanager.NameConstraints, s conversion.Scope) error {
	out.Critical = in.Critical
	out.Permitted = (*certmanager.NameConstraintItem)(unsafe.Pointer(in.Permitted))
	out.Excluded = (*certmanager.NameConstraintItem)(unsafe.Pointer(in.Excluded))
	return nil
}

// Convert_v1_NameConstraints_To_certmanager_NameConstraints is an autogenerated conversion function.
func Convert_v1_NameConstraints_To_certmanager_NameConstraints(in *certmanagerv1.NameConstraints, out *certmanager.NameConstraints, s conversion.Scope) error {
	return autoConvert_v1_NameConstraints_To_certmanager_NameConstraints(in, out, s)
}

func autoConvert_certmanager_NameConstraints_To_v1_NameConstraints(in *certmanager.NameConstraints, out *certmanagerv1.NameConstraints, s conversion.Scope) error {
	out.Critical = in.Critical
	out.Permitted = (*certmanagerv1.NameConstraintItem)(unsafe.Pointer(in.Permitted))
	out.Excluded = (*certmanagerv1.NameConstraintItem)(unsafe.Pointer(in.Excluded))
	return nil
}

// Convert_certmanager_NameConstraints_To_v1_NameConstraints is an autogenerated conversion function.
func Convert_certmanager_NameConstraints_To_v1_NameConstraints(in *certmanager.NameConstraints, out *certmanagerv1.NameConstraints, s conversion.Scope) error {
	return autoConvert_certmanager_NameConstraints_To_v1_NameConstraints(in, out, s)
}

func autoConvert_v1_OtherName_To_certmanager_OtherName(in *certmanagerv1.OtherName, out *certmanager.OtherName, s conversion.Scope) error {
	out.OID = in.OID
	out.UTF8Value = in.UTF8Value
	return nil
}

// Convert_v1_OtherName_To_certmanager_OtherName is an autogenerated conversion function.
func Convert_v1_OtherName_To_certmanager_OtherName(in *certmanagerv1.OtherName, out *certmanager.OtherName, s conversion.Scope) error {
	return autoConvert_v1_OtherName_To_certmanager_OtherName(in, out, s)
}

func autoConvert_certmanager_OtherName_To_v1_OtherName(in *certmanager.OtherName, out *certmanagerv1.OtherName, s conversion.Scope) error {
	out.OID = in.OID
	out.UTF8Value = in.UTF8Value
	return nil
}

// Convert_certmanager_OtherName_To_v1_OtherName is an autogenerated conversion function.
func Convert_certmanager_OtherName_To_v1_OtherName(in *certmanager.OtherName, out *certmanagerv1.OtherName, s conversion.Scope) error {
	return autoConvert_certmanager_OtherName_To_v1_OtherName(in, out, s)
}

func autoConvert_v1_PKCS12Keystore_To_certmanager_PKCS12Keystore(in *certmanagerv1.PKCS12Keystore, out *certmanager.PKCS12Keystore, s conversion.Scope) error {
	out.Create = in.Create
	out.Profile = certmanager.PKCS12Profile(in.Profile)
	if err := internalapismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.PasswordSecretRef, &out.PasswordSecretRef, s); err != nil {
		return err
	}
	out.Password = (*string)(unsafe.Pointer(in.Password))
	return nil
}

// Convert_v1_PKCS12Keystore_To_certmanager_PKCS12Keystore is an autogenerated conversion function.
func Convert_v1_PKCS12Keystore_To_certmanager_PKCS12Keystore(in *certmanagerv1.PKCS12Keystore, out *certmanager.PKCS12Keystore, s conversion.Scope) error {
	return autoConvert_v1_PKCS12Keystore_To_certmanager_PKCS12Keystore(in, out, s)
}

func autoConvert_certmanager_PKCS12Keystore_To_v1_PKCS12Keystore(in *certmanager.PKCS12Keystore, out *certmanagerv1.PKCS12Keystore, s conversion.Scope) error {
	out.Create = in.Create
	if err := internalapismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.PasswordSecretRef, &out.PasswordSecretRef, s); err != nil {
		return err
	}
	out.Password = (*string)(unsafe.Pointer(in.Password))
	out.Profile = certmanagerv1.PKCS12Profile(in.Profile)
	return nil
}

// Convert_certmanager_PKCS12Keystore_To_v1_PKCS12Keystore is an autogenerated conversion function.
func Convert_certmanager_PKCS12Keystore_To_v1_PKCS12Keystore(in *certmanager.PKCS12Keystore, out *certmanagerv1.PKCS12Keystore, s conversion.Scope) error {
	return autoConvert_certmanager_PKCS12Keystore_To_v1_PKCS12Keystore(in, out, s)
}

func autoConvert_v1_SelfSignedIssuer_To_certmanager_SelfSignedIssuer(in *certmanagerv1.SelfSignedIssuer, out *certmanager.SelfSignedIssuer, s conversion.Scope) error {
	out.CRLDistributionPoints = *(*[]string)(unsafe.Pointer(&in.CRLDistributionPoints))
	return nil
}

// Convert_v1_SelfSignedIssuer_To_certmanager_SelfSignedIssuer is an autogenerated conversion function.
func Convert_v1_SelfSignedIssuer_To_certmanager_SelfSignedIssuer(in *certmanagerv1.SelfSignedIssuer, out *certmanager.SelfSignedIssuer, s conversion.Scope) error {
	return autoConvert_v1_SelfSignedIssuer_To_certmanager_SelfSignedIssuer(in, out, s)
}

func autoConvert_certmanager_SelfSignedIssuer_To_v1_SelfSignedIssuer(in *certmanager.SelfSignedIssuer, out *certmanagerv1.SelfSignedIssuer, s conversion.Scope) error {
	out.CRLDistributionPoints = *(*[]string)(unsafe.Pointer(&in.CRLDistributionPoints))
	return nil
}

// Convert_certmanager_SelfSignedIssuer_To_v1_SelfSignedIssuer is an autogenerated conversion function.
func Convert_certmanager_SelfSignedIssuer_To_v1_SelfSignedIssuer(in *certmanager.SelfSignedIssuer, out *certmanagerv1.SelfSignedIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_SelfSignedIssuer_To_v1_SelfSignedIssuer(in, out, s)
}

func autoConvert_v1_ServiceAccountRef_To_certmanager_ServiceAccountRef(in *certmanagerv1.ServiceAccountRef, out *certmanager.ServiceAccountRef, s conversion.Scope) error {
	out.Name = in.Name
	out.TokenAudiences = *(*[]string)(unsafe.Pointer(&in.TokenAudiences))
	return nil
}

// Convert_v1_ServiceAccountRef_To_certmanager_ServiceAccountRef is an autogenerated conversion function.
func Convert_v1_ServiceAccountRef_To_certmanager_ServiceAccountRef(in *certmanagerv1.ServiceAccountRef, out *certmanager.ServiceAccountRef, s conversion.Scope) error {
	return autoConvert_v1_ServiceAccountRef_To_certmanager_ServiceAccountRef(in, out, s)
}

func autoConvert_certmanager_ServiceAccountRef_To_v1_ServiceAccountRef(in *certmanager.ServiceAccountRef, out *certmanagerv1.ServiceAccountRef, s conversion.Scope) error {
	out.Name = in.Name
	out.TokenAudiences = *(*[]string)(unsafe.Pointer(&in.TokenAudiences))
	return nil
}

// Convert_certmanager_ServiceAccountRef_To_v1_ServiceAccountRef is an autogenerated conversion function.
func Convert_certmanager_ServiceAccountRef_To_v1_ServiceAccountRef(in *certmanager.ServiceAccountRef, out *certmanagerv1.ServiceAccountRef, s conversion.Scope) error {
	return autoConvert_certmanager_ServiceAccountRef_To_v1_ServiceAccountRef(in, out, s)
}

func autoConvert_v1_VaultAppRole_To_certmanager_VaultAppRole(in *certmanagerv1.VaultAppRole, out *certmanager.VaultAppRole, s conversion.Scope) error {
	out.Path = in.Path
	out.RoleId = in.RoleId
	if err := internalapismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.SecretRef, &out.SecretRef, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_VaultAppRole_To_certmanager_VaultAppRole is an autogenerated conversion function.
func Convert_v1_VaultAppRole_To_certmanager_VaultAppRole(in *certmanagerv1.VaultAppRole, out *certmanager.VaultAppRole, s conversion.Scope) error {
	return autoConvert_v1_VaultAppRole_To_certmanager_VaultAppRole(in, out, s)
}

func autoConvert_certmanager_VaultAppRole_To_v1_VaultAppRole(in *certmanager.VaultAppRole, out *certmanagerv1.VaultAppRole, s conversion.Scope) error {
	out.Path = in.Path
	out.RoleId = in.RoleId
	if err := internalapismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.SecretRef, &out.SecretRef, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_VaultAppRole_To_v1_VaultAppRole is an autogenerated conversion function.
func Convert_certmanager_VaultAppRole_To_v1_VaultAppRole(in *certmanager.VaultAppRole, out *certmanagerv1.VaultAppRole, s conversion.Scope) error {
	return autoConvert_certmanager_VaultAppRole_To_v1_VaultAppRole(in, out, s)
}

func autoConvert_v1_VaultAuth_To_certmanager_VaultAuth(in *certmanagerv1.VaultAuth, out *certmanager.VaultAuth, s conversion.Scope) error {
	if in.TokenSecretRef != nil {
		in, out := &in.TokenSecretRef, &out.TokenSecretRef
		*out = new(meta.SecretKeySelector)
		if err := internalapismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TokenSecretRef = nil
	}
	if in.AppRole != nil {
		in, out := &in.AppRole, &out.AppRole
		*out = new(certmanager.VaultAppRole)
		if err := Convert_v1_VaultAppRole_To_certmanager_VaultAppRole(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.AppRole = nil
	}
	out.ClientCertificate = (*certmanager.VaultClientCertificateAuth)(unsafe.Pointer(in.ClientCertificate))
	if in.Kubernetes != nil {
		in, out := &in.Kubernetes, &out.Kubernetes
		*out = new(certmanager.VaultKubernetesAuth)
		if err := Convert_v1_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kubernetes = nil
	}
	return nil
}

// Convert_v1_VaultAuth_To_certmanager_VaultAuth is an autogenerated conversion function.
func Convert_v1_VaultAuth_To_certmanager_VaultAuth(in *certmanagerv1.VaultAuth, out *certmanager.VaultAuth, s conversion.Scope) error {
	return autoConvert_v1_VaultAuth_To_certmanager_VaultAuth(in, out, s)
}

func autoConvert_certmanager_VaultAuth_To_v1_VaultAuth(in *certmanager.VaultAuth, out *certmanagerv1.VaultAuth, s conversion.Scope) error {
	if in.TokenSecretRef != nil {
		in, out := &in.TokenSecretRef, &out.TokenSecretRef
		*out = new(apismetav1.SecretKeySelector)
		if err := internalapismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TokenSecretRef = nil
	}
	if in.AppRole != nil {
		in, out := &in.AppRole, &out.AppRole
		*out = new(certmanagerv1.VaultAppRole)
		if err := Convert_certmanager_VaultAppRole_To_v1_VaultAppRole(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.AppRole = nil
	}
	out.ClientCertificate = (*certmanagerv1.VaultClientCertificateAuth)(unsafe.Pointer(in.ClientCertificate))
	if in.Kubernetes != nil {
		in, out := &in.Kubernetes, &out.Kubernetes
		*out = new(certmanagerv1.VaultKubernetesAuth)
		if err := Convert_certmanager_VaultKubernetesAuth_To_v1_VaultKubernetesAuth(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Kubernetes = nil
	}
	return nil
}

// Convert_certmanager_VaultAuth_To_v1_VaultAuth is an autogenerated conversion function.
func Convert_certmanager_VaultAuth_To_v1_VaultAuth(in *certmanager.VaultAuth, out *certmanagerv1.VaultAuth, s conversion.Scope) error {
	return autoConvert_certmanager_VaultAuth_To_v1_VaultAuth(in, out, s)
}

func autoConvert_v1_VaultClientCertificateAuth_To_certmanager_VaultClientCertificateAuth(in *certmanagerv1.VaultClientCertificateAuth, out *certmanager.VaultClientCertificateAuth, s conversion.Scope) error {
	out.Path = in.Path
	out.SecretName = in.SecretName
	out.Name = in.Name
	return nil
}

// Convert_v1_VaultClientCertificateAuth_To_certmanager_VaultClientCertificateAuth is an autogenerated conversion function.
func Convert_v1_VaultClientCertificateAuth_To_certmanager_VaultClientCertificateAuth(in *certmanagerv1.VaultClientCertificateAuth, out *certmanager.VaultClientCertificateAuth, s conversion.Scope) error {
	return autoConvert_v1_VaultClientCertificateAuth_To_certmanager_VaultClientCertificateAuth(in, out, s)
}

func autoConvert_certmanager_VaultClientCertificateAuth_To_v1_VaultClientCertificateAuth(in *certmanager.VaultClientCertificateAuth, out *certmanagerv1.VaultClientCertificateAuth, s conversion.Scope) error {
	out.Path = in.Path
	out.SecretName = in.SecretName
	out.Name = in.Name
	return nil
}

// Convert_certmanager_VaultClientCertificateAuth_To_v1_VaultClientCertificateAuth is an autogenerated conversion function.
func Convert_certmanager_VaultClientCertificateAuth_To_v1_VaultClientCertificateAuth(in *certmanager.VaultClientCertificateAuth, out *certmanagerv1.VaultClientCertificateAuth, s conversion.Scope) error {
	return autoConvert_certmanager_VaultClientCertificateAuth_To_v1_VaultClientCertificateAuth(in, out, s)
}

func autoConvert_v1_VaultIssuer_To_certmanager_VaultIssuer(in *certmanagerv1.VaultIssuer, out *certmanager.VaultIssuer, s conversion.Scope) error {
	if err := Convert_v1_VaultAuth_To_certmanager_VaultAuth(&in.Auth, &out.Auth, s); err != nil {
		return err
	}
	out.Server = in.Server
	out.ServerName = in.ServerName
	out.Path = in.Path
	out.Namespace = in.Namespace
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	if in.CABundleSecretRef != nil {
		in, out := &in.CABundleSecretRef, &out.CABundleSecretRef
		*out = new(meta.SecretKeySelector)
		if err := internalapismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CABundleSecretRef = nil
	}
	if in.ClientCertSecretRef != nil {
		in, out := &in.ClientCertSecretRef, &out.ClientCertSecretRef
		*out = new(meta.SecretKeySelector)
		if err := internalapismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ClientCertSecretRef = nil
	}
	if in.ClientKeySecretRef != nil {
		in, out := &in.ClientKeySecretRef, &out.ClientKeySecretRef
		*out = new(meta.SecretKeySelector)
		if err := internalapismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ClientKeySecretRef = nil
	}
	return nil
}

// Convert_v1_VaultIssuer_To_certmanager_VaultIssuer is an autogenerated conversion function.
func Convert_v1_VaultIssuer_To_certmanager_VaultIssuer(in *certmanagerv1.VaultIssuer, out *certmanager.VaultIssuer, s conversion.Scope) error {
	return autoConvert_v1_VaultIssuer_To_certmanager_VaultIssuer(in, out, s)
}

func autoConvert_certmanager_VaultIssuer_To_v1_VaultIssuer(in *certmanager.VaultIssuer, out *certmanagerv1.VaultIssuer, s conversion.Scope) error {
	if err := Convert_certmanager_VaultAuth_To_v1_VaultAuth(&in.Auth, &out.Auth, s); err != nil {
		return err
	}
	out.Server = in.Server
	out.ServerName = in.ServerName
	out.Path = in.Path
	out.Namespace = in.Namespace
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	if in.CABundleSecretRef != nil {
		in, out := &in.CABundleSecretRef, &out.CABundleSecretRef
		*out = new(apismetav1.SecretKeySelector)
		if err := internalapismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CABundleSecretRef = nil
	}
	if in.ClientCertSecretRef != nil {
		in, out := &in.ClientCertSecretRef, &out.ClientCertSecretRef
		*out = new(apismetav1.SecretKeySelector)
		if err := internalapismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ClientCertSecretRef = nil
	}
	if in.ClientKeySecretRef != nil {
		in, out := &in.ClientKeySecretRef, &out.ClientKeySecretRef
		*out = new(apismetav1.SecretKeySelector)
		if err := internalapismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ClientKeySecretRef = nil
	}
	return nil
}

// Convert_certmanager_VaultIssuer_To_v1_VaultIssuer is an autogenerated conversion function.
func Convert_certmanager_VaultIssuer_To_v1_VaultIssuer(in *certmanager.VaultIssuer, out *certmanagerv1.VaultIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_VaultIssuer_To_v1_VaultIssuer(in, out, s)
}

func autoConvert_v1_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth(in *certmanagerv1.VaultKubernetesAuth, out *certmanager.VaultKubernetesAuth, s conversion.Scope) error {
	out.Path = in.Path
	if err := internalapismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.SecretRef, &out.SecretRef, s); err != nil {
		return err
	}
	out.ServiceAccountRef = (*certmanager.ServiceAccountRef)(unsafe.Pointer(in.ServiceAccountRef))
	out.Role = in.Role
	return nil
}

// Convert_v1_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth is an autogenerated conversion function.
func Convert_v1_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth(in *certmanagerv1.VaultKubernetesAuth, out *certmanager.VaultKubernetesAuth, s conversion.Scope) error {
	return autoConvert_v1_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth(in, out, s)
}

func autoConvert_certmanager_VaultKubernetesAuth_To_v1_VaultKubernetesAuth(in *certmanager.VaultKubernetesAuth, out *certmanagerv1.VaultKubernetesAuth, s conversion.Scope) error {
	out.Path = in.Path
	if err := internalapismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.SecretRef, &out.SecretRef, s); err != nil {
		return err
	}
	out.ServiceAccountRef = (*certmanagerv1.ServiceAccountRef)(unsafe.Pointer(in.ServiceAccountRef))
	out.Role = in.Role
	return nil
}

// Convert_certmanager_VaultKubernetesAuth_To_v1_VaultKubernetesAuth is an autogenerated conversion function.
func Convert_certmanager_VaultKubernetesAuth_To_v1_VaultKubernetesAuth(in *certmanager.VaultKubernetesAuth, out *certmanagerv1.VaultKubernetesAuth, s conversion.Scope) error {
	return autoConvert_certmanager_VaultKubernetesAuth_To_v1_VaultKubernetesAuth(in, out, s)
}

func autoConvert_v1_VenafiCloud_To_certmanager_VenafiCloud(in *certmanagerv1.VenafiCloud, out *certmanager.VenafiCloud, s conversion.Scope) error {
	out.URL = in.URL
	if err := internalapismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(&in.APITokenSecretRef, &out.APITokenSecretRef, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_VenafiCloud_To_certmanager_VenafiCloud is an autogenerated conversion function.
func Convert_v1_VenafiCloud_To_certmanager_VenafiCloud(in *certmanagerv1.VenafiCloud, out *certmanager.VenafiCloud, s conversion.Scope) error {
	return autoConvert_v1_VenafiCloud_To_certmanager_VenafiCloud(in, out, s)
}

func autoConvert_certmanager_VenafiCloud_To_v1_VenafiCloud(in *certmanager.VenafiCloud, out *certmanagerv1.VenafiCloud, s conversion.Scope) error {
	out.URL = in.URL
	if err := internalapismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(&in.APITokenSecretRef, &out.APITokenSecretRef, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_VenafiCloud_To_v1_VenafiCloud is an autogenerated conversion function.
func Convert_certmanager_VenafiCloud_To_v1_VenafiCloud(in *certmanager.VenafiCloud, out *certmanagerv1.VenafiCloud, s conversion.Scope) error {
	return autoConvert_certmanager_VenafiCloud_To_v1_VenafiCloud(in, out, s)
}

func autoConvert_v1_VenafiIssuer_To_certmanager_VenafiIssuer(in *certmanagerv1.VenafiIssuer, out *certmanager.VenafiIssuer, s conversion.Scope) error {
	out.Zone = in.Zone
	if in.TPP != nil {
		in, out := &in.TPP, &out.TPP
		*out = new(certmanager.VenafiTPP)
		if err := Convert_v1_VenafiTPP_To_certmanager_VenafiTPP(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TPP = nil
	}
	if in.Cloud != nil {
		in, out := &in.Cloud, &out.Cloud
		*out = new(certmanager.VenafiCloud)
		if err := Convert_v1_VenafiCloud_To_certmanager_VenafiCloud(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Cloud = nil
	}
	return nil
}

// Convert_v1_VenafiIssuer_To_certmanager_VenafiIssuer is an autogenerated conversion function.
func Convert_v1_VenafiIssuer_To_certmanager_VenafiIssuer(in *certmanagerv1.VenafiIssuer, out *certmanager.VenafiIssuer, s conversion.Scope) error {
	return autoConvert_v1_VenafiIssuer_To_certmanager_VenafiIssuer(in, out, s)
}

func autoConvert_certmanager_VenafiIssuer_To_v1_VenafiIssuer(in *certmanager.VenafiIssuer, out *certmanagerv1.VenafiIssuer, s conversion.Scope) error {
	out.Zone = in.Zone
	if in.TPP != nil {
		in, out := &in.TPP, &out.TPP
		*out = new(certmanagerv1.VenafiTPP)
		if err := Convert_certmanager_VenafiTPP_To_v1_VenafiTPP(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TPP = nil
	}
	if in.Cloud != nil {
		in, out := &in.Cloud, &out.Cloud
		*out = new(certmanagerv1.VenafiCloud)
		if err := Convert_certmanager_VenafiCloud_To_v1_VenafiCloud(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Cloud = nil
	}
	return nil
}

// Convert_certmanager_VenafiIssuer_To_v1_VenafiIssuer is an autogenerated conversion function.
func Convert_certmanager_VenafiIssuer_To_v1_VenafiIssuer(in *certmanager.VenafiIssuer, out *certmanagerv1.VenafiIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_VenafiIssuer_To_v1_VenafiIssuer(in, out, s)
}

func autoConvert_v1_VenafiTPP_To_certmanager_VenafiTPP(in *certmanagerv1.VenafiTPP, out *certmanager.VenafiTPP, s conversion.Scope) error {
	out.URL = in.URL
	if err := internalapismetav1.Convert_v1_LocalObjectReference_To_meta_LocalObjectReference(&in.CredentialsRef, &out.CredentialsRef, s); err != nil {
		return err
	}
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	if in.CABundleSecretRef != nil {
		in, out := &in.CABundleSecretRef, &out.CABundleSecretRef
		*out = new(meta.SecretKeySelector)
		if err := internalapismetav1.Convert_v1_SecretKeySelector_To_meta_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CABundleSecretRef = nil
	}
	return nil
}

// Convert_v1_VenafiTPP_To_certmanager_VenafiTPP is an autogenerated conversion function.
func Convert_v1_VenafiTPP_To_certmanager_VenafiTPP(in *certmanagerv1.VenafiTPP, out *certmanager.VenafiTPP, s conversion.Scope) error {
	return autoConvert_v1_VenafiTPP_To_certmanager_VenafiTPP(in, out, s)
}

func autoConvert_certmanager_VenafiTPP_To_v1_VenafiTPP(in *certmanager.VenafiTPP, out *certmanagerv1.VenafiTPP, s conversion.Scope) error {
	out.URL = in.URL
	if err := internalapismetav1.Convert_meta_LocalObjectReference_To_v1_LocalObjectReference(&in.CredentialsRef, &out.CredentialsRef, s); err != nil {
		return err
	}
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	if in.CABundleSecretRef != nil {
		in, out := &in.CABundleSecretRef, &out.CABundleSecretRef
		*out = new(apismetav1.SecretKeySelector)
		if err := internalapismetav1.Convert_meta_SecretKeySelector_To_v1_SecretKeySelector(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CABundleSecretRef = nil
	}
	return nil
}

// Convert_certmanager_VenafiTPP_To_v1_VenafiTPP is an autogenerated conversion function.
func Convert_certmanager_VenafiTPP_To_v1_VenafiTPP(in *certmanager.VenafiTPP, out *certmanagerv1.VenafiTPP, s conversion.Scope) error {
	return autoConvert_certmanager_VenafiTPP_To_v1_VenafiTPP(in, out, s)
}

func autoConvert_v1_X509Subject_To_certmanager_X509Subject(in *certmanagerv1.X509Subject, out *certmanager.X509Subject, s conversion.Scope) error {
	out.Organizations = *(*[]string)(unsafe.Pointer(&in.Organizations))
	out.Countries = *(*[]string)(unsafe.Pointer(&in.Countries))
	out.OrganizationalUnits = *(*[]string)(unsafe.Pointer(&in.OrganizationalUnits))
	out.Localities = *(*[]string)(unsafe.Pointer(&in.Localities))
	out.Provinces = *(*[]string)(unsafe.Pointer(&in.Provinces))
	out.StreetAddresses = *(*[]string)(unsafe.Pointer(&in.StreetAddresses))
	out.PostalCodes = *(*[]string)(unsafe.Pointer(&in.PostalCodes))
	out.SerialNumber = in.SerialNumber
	return nil
}

// Convert_v1_X509Subject_To_certmanager_X509Subject is an autogenerated conversion function.
func Convert_v1_X509Subject_To_certmanager_X509Subject(in *certmanagerv1.X509Subject, out *certmanager.X509Subject, s conversion.Scope) error {
	return autoConvert_v1_X509Subject_To_certmanager_X509Subject(in, out, s)
}

func autoConvert_certmanager_X509Subject_To_v1_X509Subject(in *certmanager.X509Subject, out *certmanagerv1.X509Subject, s conversion.Scope) error {
	out.Organizations = *(*[]string)(unsafe.Pointer(&in.Organizations))
	out.Countries = *(*[]string)(unsafe.Pointer(&in.Countries))
	out.OrganizationalUnits = *(*[]string)(unsafe.Pointer(&in.OrganizationalUnits))
	out.Localities = *(*[]string)(unsafe.Pointer(&in.Localities))
	out.Provinces = *(*[]string)(unsafe.Pointer(&in.Provinces))
	out.StreetAddresses = *(*[]string)(unsafe.Pointer(&in.StreetAddresses))
	out.PostalCodes = *(*[]string)(unsafe.Pointer(&in.PostalCodes))
	out.SerialNumber = in.SerialNumber
	return nil
}

// Convert_certmanager_X509Subject_To_v1_X509Subject is an autogenerated conversion function.
func Convert_certmanager_X509Subject_To_v1_X509Subject(in *certmanager.X509Subject, out *certmanagerv1.X509Subject, s conversion.Scope) error {
	return autoConvert_certmanager_X509Subject_To_v1_X509Subject(in, out, s)
}
